#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 1.17.2
id: pandoc-1.17.2-CPhvoyFoQN5JDjebjWyHwJ
key: pandoc-1.17.2-CPhvoyFoQN5JDjebjWyHwJ
license: GPL
copyright: (c) 2006-2016 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: http://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook,
    MediaWiki markup, TWiki markup, Haddock markup, OPML,
    Emacs Org-Mode, txt2tags, Word Docx, ODT, and Textile, and
    it can write Markdown, reStructuredText, XHTML, HTML 5,
    LaTeX, ConTeXt, DocBook, OPML, TEI, OpenDocument, ODT,
    Word docx, RTF, MediaWiki, DokuWiki, ZimWiki, Textile,
    groff man pages, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign ICML,
    and several kinds of HTML/javascript slide shows (S5, Slidy,
    Slideous, DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
author: John MacFarlane <jgm@berkeley.edu>
exposed: True
exposed-modules:
    Text.Pandoc Text.Pandoc.Options Text.Pandoc.Pretty
    Text.Pandoc.Shared Text.Pandoc.MediaBag Text.Pandoc.Error
    Text.Pandoc.Readers.HTML Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.RST
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.TeXMath
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.Odt Text.Pandoc.Readers.EPUB
    Text.Pandoc.Writers.Native Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.HTML
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.LaTeX
    Text.Pandoc.Writers.ConTeXt Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.CommonMark
    Text.Pandoc.Writers.Haddock Text.Pandoc.Writers.RST
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.Docx
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.TEI Text.Pandoc.PDF Text.Pandoc.UTF8
    Text.Pandoc.Templates Text.Pandoc.XML Text.Pandoc.SelfContained
    Text.Pandoc.Process Text.Pandoc.CSS
hidden-modules: Text.Pandoc.Readers.Docx.Lists
                Text.Pandoc.Readers.Docx.Combine Text.Pandoc.Readers.Docx.Parse
                Text.Pandoc.Readers.Docx.Fonts Text.Pandoc.Readers.Docx.Util
                Text.Pandoc.Readers.Docx.StyleMap Text.Pandoc.Readers.Odt.Base
                Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.ParserState
                Text.Pandoc.Readers.Org.Parsing Text.Pandoc.Readers.Org.Shared
                Text.Pandoc.Writers.Shared Text.Pandoc.Asciify Text.Pandoc.MIME
                Text.Pandoc.Emoji Text.Pandoc.Parsing Text.Pandoc.UUID
                Text.Pandoc.ImageSize Text.Pandoc.Slides Text.Pandoc.Highlighting
                Text.Pandoc.Compat.Time Text.Pandoc.Compat.Except
                Text.Pandoc.Compat.TagSoupEntity Text.Pandoc.Compat.Directory
                Text.Pandoc.Compat.Monoid Paths_pandoc
abi: 501a8a687eabb09602df8fe09ade7540
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/pandoc-1.17.2
library-dirs: /usr/lib/ghc-8.0.1/site-local/pandoc-1.17.2
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-1.17.2-CPhvoyFoQN5JDjebjWyHwJ
depends:
    HTTP-4000.3.3-Fl4VtSZsPE4A3kSlCM2M0U
    JuicyPixels-3.2.8-1iUXz9JObS4BnPlpDlg3cu
    SHA-1.6.4.2-GSP9nhHyWNEAImBrL9QfXp
    aeson-0.11.2.0-31ZI7bFuFz27ynqHifCKlM array-0.5.1.1 base-4.9.0.0
    base64-bytestring-1.0.0.1-In9M41tLtcS9QYt3QpGpNY binary-0.8.3.0
    blaze-html-0.8.1.2-2ceCZ3Fm7x67ZwaaR7uQ3C
    blaze-markup-0.7.1.0-BKRb0wHFpEyDJWTsyjQqnp bytestring-0.10.8.1
    cmark-0.5.3.1-CxZR9nAoIRJKORA05rPFjL containers-0.5.7.1
    data-default-0.7.1.1-ZpKfkXGfJa8c8Q6OFbvrr deepseq-1.4.2.0
    directory-1.2.6.2
    extensible-exceptions-0.1.1.4-3h0ykvvAO915cRhUyj3rRV
    filemanip-0.3.6.3-DFENeGbODv96RwGywUxkEu filepath-1.4.1.0
    ghc-prim-0.5.0.0 haddock-library-1.4.2-F7UTHpERtmTC4fYnmJsN6z
    highlighting-kate-0.6.3-Cpl2xT9YMNbJaTBA4Xordr
    hslua-0.4.1-D8QXBMM9Kwg4NVuXtEl8dM
    http-client-0.5.3.2-5IEB0uVBZrIaNQDsTOptj
    http-client-tls-0.3.3-9RKT1DIvFWkIEfYsJgi6pZ
    http-types-0.9.1-58mzFhAgNAb9DH0XYXjd5P
    mtl-2.2.1-6qsR1PHUy5lL47Hpoa4jCM
    network-2.6.3.1-G4Up1CPKbp7DeFsnywOnGG
    network-uri-2.6.1.0-8yR4gjnzE4eDGhJR7PHfVJ
    old-time-1.1.0.3-IcvdkJUsE9M8t3io8peAEp
    pandoc-types-1.16.1.1-DxO5HnQkuvb5R4LlZL94h3
    parsec-3.1.11-IYEP8Lv1S9x5FeUQxGPDBY process-1.4.2.0
    random-1.1-54KmMHXjttlERYcr1mvsAe
    scientific-0.3.4.9-Ghl8M4Ey2fMI7e1yk2TuuH
    syb-0.6-C65vWCsht6A8uLstpQIXyj tagsoup-0.14-Cyor6HaGaUK6jsf16bXCqB
    temporary-1.2.0.4-2ZGJgvUMoC3CqxertnjRxn
    texmath-0.8.6.5-KIygm3aGNHd5xPILRNHGeE
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ time-1.6.0.1
    unordered-containers-0.2.7.1-6Q3w38ZivLTB9nLFgf8RUI
    vector-0.11.0.0-BEDZb5o2QOhGbIm6ky7rl6
    xml-1.3.14-rYbwgRBahsKh5Xn1LyTeP
    yaml-0.8.18.7-ELVjObuxCXv4YVdKYubPJb
    zip-archive-0.3.0.5-BR4HyKApj4VC2AJ039ZjGN
    zlib-0.6.1.1-IKN2DpYEe8r3bYFvs7BDUW
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
