#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc-citeproc
version: 0.10.1.1
id: pandoc-citeproc-0.10.1.1-7oufBPFNTMR9bFPhDsrtzN
key: pandoc-citeproc-0.10.1.1-7oufBPFNTMR9bFPhDsrtzN
license: BSD3
maintainer: jgm@berkeley.edu
homepage: https://github.com/jgm/pandoc-citeproc
synopsis: Supports using pandoc with citeproc
description:
    The pandoc-citeproc library exports functions for
    using the citeproc system with pandoc.  It relies on
    citeproc-hs, a library for rendering
    bibliographic reference citations into a variety
    of styles using a macro language called Citation
    Style Language (CSL). More details on CSL can be
    found here: <http://citationstyles.org/>.
    .
    Currently this package includes a heavily revised
    copy of the citeproc-hs code. When citeproc-hs is
    updated to be compatible, this package will simply
    depend on citeproc-hs.
    .
    This package also contains an executable: pandoc-citeproc,
    which works as a pandoc filter, and
    also has a mode for converting bibliographic databases
    a YAML format suitable for inclusion in pandoc YAML
    metadata.
category: Text
author: John MacFarlane, Andrea Rossato
exposed: True
exposed-modules:
    Text.CSL.Pandoc Text.CSL Text.CSL.Reference Text.CSL.Style
    Text.CSL.Eval Text.CSL.Eval.Common Text.CSL.Eval.Date
    Text.CSL.Eval.Names Text.CSL.Eval.Output Text.CSL.Parser
    Text.CSL.Proc Text.CSL.Proc.Collapse Text.CSL.Proc.Disamb
    Text.CSL.Input.Bibutils Text.CSL.Input.Bibtex
    Text.CSL.Output.Pandoc Text.CSL.Output.Plain Text.CSL.Data
hidden-modules: Text.CSL.Util Prelude Paths_pandoc_citeproc
abi: d166179d7972ebb042abe6bd49e75961
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/pandoc-citeproc-0.10.1.1
library-dirs: /usr/lib/ghc-8.0.1/site-local/pandoc-citeproc-0.10.1.1
data-dir: /usr/share/pandoc-citeproc
hs-libraries: HSpandoc-citeproc-0.10.1.1-7oufBPFNTMR9bFPhDsrtzN
depends:
    aeson-0.11.2.0-31ZI7bFuFz27ynqHifCKlM base-4.9.0.0
    bytestring-0.10.8.1 containers-0.5.7.1
    data-default-0.7.1.1-ZpKfkXGfJa8c8Q6OFbvrr directory-1.2.6.2
    filepath-1.4.1.0 hs-bibutils-5.5-Bujn9fwi74P5NCilKdJf4S
    mtl-2.2.1-6qsR1PHUy5lL47Hpoa4jCM
    old-locale-1.0.0.7-6glXNhHF891B41ZfuI8hU8
    pandoc-1.17.2-CPhvoyFoQN5JDjebjWyHwJ
    pandoc-types-1.16.1.1-DxO5HnQkuvb5R4LlZL94h3
    parsec-3.1.11-IYEP8Lv1S9x5FeUQxGPDBY
    setenv-0.1.1.3-5zeeXxY3qb3AsPnIgczcsm
    split-0.2.3.1-IJKK4pOCYGKud0jZImZke syb-0.6-C65vWCsht6A8uLstpQIXyj
    tagsoup-0.14-Cyor6HaGaUK6jsf16bXCqB
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ
    text-icu-0.7.0.1-6fsOEPVbikhJ6ijUdaDY71 time-1.6.0.1
    unordered-containers-0.2.7.1-6Q3w38ZivLTB9nLFgf8RUI
    vector-0.11.0.0-BEDZb5o2QOhGbIm6ky7rl6
    xml-conduit-1.4.0.1-wM05AeQAgG5KzbPe3KVLR
    yaml-0.8.18.7-ELVjObuxCXv4YVdKYubPJb
haddock-interfaces: /usr/share/doc/pandoc-citeproc/html/pandoc-citeproc.haddock
haddock-html: /usr/share/doc/pandoc-citeproc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
