/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.patterns.MatchState;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public final class Match {
    private final String posTag;
    private final boolean suppressMisspelled;
    private final String regexReplace;
    private final String posTagReplace;
    private final CaseConversion caseConversionType;
    private final IncludeRange includeSkipped;
    private final Pattern pRegexMatch;
    private final boolean setPos;
    private boolean postagRegexp;
    private boolean staticLemma;
    private String lemma;
    private int tokenRef;
    private Pattern pPosRegexMatch;
    private boolean inMessageOnly;

    public Match(String posTag, String posTagReplace, boolean postagRegexp, String regexMatch, String regexReplace, CaseConversion caseConversionType, boolean setPOS, boolean suppressMisspelled, IncludeRange includeSkipped) {
        this.posTag = posTag;
        this.postagRegexp = postagRegexp;
        this.caseConversionType = caseConversionType;
        Pattern pattern = this.pRegexMatch = regexMatch != null ? Pattern.compile(regexMatch) : null;
        if (postagRegexp && posTag != null) {
            this.pPosRegexMatch = Pattern.compile(posTag);
        }
        this.regexReplace = regexReplace;
        this.posTagReplace = posTagReplace;
        this.setPos = setPOS;
        this.includeSkipped = includeSkipped;
        this.suppressMisspelled = suppressMisspelled;
    }

    public MatchState createState(Synthesizer synthesizer, AnalyzedTokenReadings token) {
        MatchState state = new MatchState(this, synthesizer);
        state.setToken(token);
        return state;
    }

    public MatchState createState(Synthesizer synthesizer, AnalyzedTokenReadings[] tokens, int index, int next) {
        MatchState state = new MatchState(this, synthesizer);
        state.setToken(tokens, index, next);
        return state;
    }

    public boolean setsPos() {
        return this.setPos;
    }

    public boolean posRegExp() {
        return this.postagRegexp;
    }

    public void setLemmaString(String lemmaString) {
        if (!StringTools.isEmpty(lemmaString)) {
            this.lemma = lemmaString;
            this.staticLemma = true;
            this.postagRegexp = true;
            if (this.posTag != null) {
                this.pPosRegexMatch = Pattern.compile(this.posTag);
            }
        }
    }

    public String getLemma() {
        return this.lemma;
    }

    public boolean isStaticLemma() {
        return this.staticLemma;
    }

    public boolean checksSpelling() {
        return this.suppressMisspelled;
    }

    public void setTokenRef(int i) {
        this.tokenRef = i;
    }

    public int getTokenRef() {
        return this.tokenRef;
    }

    public boolean convertsCase() {
        return this.caseConversionType != CaseConversion.NONE;
    }

    public CaseConversion getCaseConversionType() {
        return this.caseConversionType;
    }

    public void setInMessageOnly(boolean inMessageOnly) {
        this.inMessageOnly = inMessageOnly;
    }

    public boolean isInMessageOnly() {
        return this.inMessageOnly;
    }

    public String getPosTag() {
        return this.posTag;
    }

    public Pattern getRegexMatch() {
        return this.pRegexMatch;
    }

    public String getRegexReplace() {
        return this.regexReplace;
    }

    public Pattern getPosRegexMatch() {
        return this.pPosRegexMatch;
    }

    public boolean isPostagRegexp() {
        return this.postagRegexp;
    }

    public String getPosTagReplace() {
        return this.posTagReplace;
    }

    public IncludeRange getIncludeSkipped() {
        return this.includeSkipped;
    }

    public static enum IncludeRange {
        NONE,
        FOLLOWING,
        ALL;

    }

    public static enum CaseConversion {
        NONE,
        STARTLOWER,
        STARTUPPER,
        ALLLOWER,
        ALLUPPER,
        PRESERVE;

    }
}

