/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.users;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.authentication.ExtensionAuthentication;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.sessions.ExtensionSessionManagement;
import org.zaproxy.zap.extension.users.ContextUserAuthManager;
import org.zaproxy.zap.extension.users.ContextUsersPanel;
import org.zaproxy.zap.extension.users.UsersAPI;
import org.zaproxy.zap.extension.users.UsersTableModel;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextPanelFactory;

public class ExtensionUserManagement
extends ExtensionAdaptor
implements ContextPanelFactory,
ContextDataFactory {
    public static final String CONTEXT_CONFIG_USERS = "context.users";
    public static final String CONTEXT_CONFIG_USERS_USER = "context.users.user";
    public static final int EXTENSION_ORDER = 57;
    public static final String NAME = "ExtensionUserManagement";
    private static final Logger log = Logger.getLogger(ExtensionUserManagement.class);
    private Map<Integer, ContextUsersPanel> userPanelsMap = new HashMap<Integer, ContextUsersPanel>();
    private Map<Integer, ContextUserAuthManager> contextManagers = new HashMap<Integer, ContextUserAuthManager>();
    private UsersAPI api;
    private static final List<Class<?>> EXTENSION_DEPENDENCIES;
    private ExtensionHttpSessions extensionHttpSessions;

    public ExtensionUserManagement() {
        this.initialize();
    }

    protected ExtensionHttpSessions getExtensionHttpSessions() {
        if (this.extensionHttpSessions == null) {
            this.extensionHttpSessions = (ExtensionHttpSessions)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHttpSessions");
            if (this.extensionHttpSessions == null) {
                log.error((Object)("Http Sessions Extension should be enabled for the " + ExtensionUserManagement.class.getSimpleName() + " to work."));
            }
        }
        return this.extensionHttpSessions;
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(57);
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        Model.getSingleton().addContextDataFactory(this);
        if (this.getView() != null) {
            this.getView().addContextPanelFactory(this);
        }
        this.api = new UsersAPI(this);
        API.getInstance().registerApiImplementor(this.api);
    }

    @Override
    public List<Class<?>> getDependencies() {
        return EXTENSION_DEPENDENCIES;
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public AbstractContextPropertiesPanel getContextPanel(Context context) {
        return this.getContextPanel(context.getIndex());
    }

    private ContextUsersPanel getContextPanel(int n) {
        ContextUsersPanel contextUsersPanel = this.userPanelsMap.get(n);
        if (contextUsersPanel == null) {
            contextUsersPanel = new ContextUsersPanel(this, n);
            this.userPanelsMap.put(n, contextUsersPanel);
        }
        return contextUsersPanel;
    }

    public ContextUserAuthManager getContextUserAuthManager(int n) {
        ContextUserAuthManager contextUserAuthManager = this.contextManagers.get(n);
        if (contextUserAuthManager == null) {
            contextUserAuthManager = new ContextUserAuthManager(n);
            this.contextManagers.put(n, contextUserAuthManager);
        }
        return contextUserAuthManager;
    }

    public List<User> getUIConfiguredUsers(int n) {
        ContextUsersPanel contextUsersPanel = this.userPanelsMap.get(n);
        if (contextUsersPanel != null) {
            return Collections.unmodifiableList(contextUsersPanel.getUsersTableModel().getUsers());
        }
        return null;
    }

    public UsersTableModel getUIConfiguredUsersModel(int n) {
        ContextUsersPanel contextUsersPanel = this.userPanelsMap.get(n);
        if (contextUsersPanel != null) {
            return contextUsersPanel.getUsersTableModel();
        }
        return null;
    }

    @Override
    public void discardContexts() {
        this.contextManagers.clear();
        this.userPanelsMap.clear();
    }

    @Override
    public void discardContext(Context context) {
        this.contextManagers.remove(context.getIndex());
        this.userPanelsMap.remove(context.getIndex());
    }

    @Override
    public void loadContextData(Session session, Context context) {
        try {
            List<String> list = session.getContextDataStrings(context.getIndex(), 300);
            ContextUserAuthManager contextUserAuthManager = this.getContextUserAuthManager(context.getIndex());
            for (String string : list) {
                User user = User.decode(context.getIndex(), string);
                contextUserAuthManager.addUser(user);
            }
        }
        catch (Exception exception) {
            log.error((Object)"Unable to load Users.", (Throwable)exception);
        }
    }

    @Override
    public void persistContextData(Session session, Context context) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            ContextUserAuthManager contextUserAuthManager = this.contextManagers.get(context.getIndex());
            if (contextUserAuthManager != null) {
                for (User user : contextUserAuthManager.getUsers()) {
                    arrayList.add(User.encode(user));
                }
                session.setContextData(context.getIndex(), 300, arrayList);
            }
        }
        catch (Exception exception) {
            log.error((Object)"Unable to persist Users.", (Throwable)exception);
        }
    }

    public void removeSharedContextUsers(Context context) {
        this.getContextPanel(context.getIndex()).getUsersTableModel().removeAllUsers();
    }

    public void addSharedContextUser(Context context, User user) {
        this.getContextPanel(context.getIndex()).getUsersTableModel().addUser(user);
    }

    public List<User> getSharedContextUsers(Context context) {
        return this.getContextPanel(context.getIndex()).getUsersTableModel().getUsers();
    }

    public void removeContextUsers(int n) {
        this.getContextUserAuthManager(n).removeAllUsers();
    }

    @Override
    public void exportContextData(Context context, Configuration configuration) {
        ContextUserAuthManager contextUserAuthManager = this.contextManagers.get(context.getIndex());
        if (contextUserAuthManager != null) {
            for (User user : contextUserAuthManager.getUsers()) {
                configuration.addProperty(CONTEXT_CONFIG_USERS_USER, (Object)User.encode(user));
            }
        }
    }

    @Override
    public void importContextData(Context context, Configuration configuration) {
        List list = configuration.getList(CONTEXT_CONFIG_USERS_USER);
        ContextUserAuthManager contextUserAuthManager = this.getContextUserAuthManager(context.getIndex());
        for (Object e : list) {
            User user = User.decode(context.getIndex(), e.toString());
            contextUserAuthManager.addUser(user);
        }
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    static {
        ArrayList<Class<ExtensionSessionManagement>> arrayList = new ArrayList<Class<ExtensionSessionManagement>>(3);
        arrayList.add(ExtensionHttpSessions.class);
        arrayList.add(ExtensionAuthentication.class);
        arrayList.add(ExtensionSessionManagement.class);
        EXTENSION_DEPENDENCIES = Collections.unmodifiableList(arrayList);
    }
}

