/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AbstractPollArrayWrapper;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelChImpl;

class PollArrayWrapper
extends AbstractPollArrayWrapper {
    static final short POLLCONN = 4;
    int interruptFD;

    PollArrayWrapper(int newSize) {
        newSize = (newSize + 1) * 8;
        this.pollArray = new AllocatedNativeObject(newSize, false);
        this.pollArrayAddress = this.pollArray.address();
        this.totalChannels = 1;
    }

    void initInterrupt(int fd0, int fd1) {
        this.interruptFD = fd1;
        this.putDescriptor(0, fd0);
        this.putEventOps(0, 1);
        this.putReventOps(0, 0);
    }

    void release(int i) {
    }

    void free() {
        this.pollArray.free();
    }

    void addEntry(SelChImpl sc) {
        this.putDescriptor(this.totalChannels, IOUtil.fdVal(sc.getFD()));
        this.putEventOps(this.totalChannels, 0);
        this.putReventOps(this.totalChannels, 0);
        ++this.totalChannels;
    }

    static void replaceEntry(PollArrayWrapper source, int sindex, PollArrayWrapper target, int tindex) {
        target.putDescriptor(tindex, source.getDescriptor(sindex));
        target.putEventOps(tindex, source.getEventOps(sindex));
        target.putReventOps(tindex, source.getReventOps(sindex));
    }

    void grow(int newSize) {
        PollArrayWrapper temp = new PollArrayWrapper(newSize);
        for (int i = 0; i < this.totalChannels; ++i) {
            PollArrayWrapper.replaceEntry(this, i, temp, i);
        }
        this.pollArray.free();
        this.pollArray = temp.pollArray;
        this.pollArrayAddress = this.pollArray.address();
    }

    int poll(int numfds, int offset, long timeout) {
        return this.poll0(this.pollArrayAddress + (long)(offset * 8), numfds, timeout);
    }

    public void interrupt() {
        PollArrayWrapper.interrupt(this.interruptFD);
    }

    private native int poll0(long var1, int var3, long var4);

    private static native void interrupt(int var0);
}

