/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ClassElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public abstract class AnonymousClassElementBase
extends ClassElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.AnonymousClassElement");

    public AnonymousClassElementBase(IElementType type2) {
        super(type2);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 78: {
                return this.getFirstChildNode().getElementType() == JavaElementType.JAVA_CODE_REFERENCE ? this.getFirstChildNode() : null;
            }
            case 73: {
                return this.findChildByType(JavaElementType.EXPRESSION_LIST);
            }
            case 18: {
                return this.findChildByType(JavaTokenType.LBRACE);
            }
            case 19: 
        }
        return TreeUtil.findChildBackward(this, JavaTokenType.RBRACE);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return this.getChildRole(child, 78);
        }
        if (i == JavaElementType.EXPRESSION_LIST) {
            return 73;
        }
        if (i == JavaElementType.FIELD) {
            return 4;
        }
        if (i == JavaElementType.METHOD) {
            return 5;
        }
        if (i == JavaElementType.CLASS_INITIALIZER) {
            return 6;
        }
        if (i == JavaElementType.CLASS) {
            return 3;
        }
        if (i == JavaTokenType.LBRACE) {
            return this.getChildRole(child, 18);
        }
        if (i == JavaTokenType.RBRACE) {
            return this.getChildRole(child, 19);
        }
        if (i == JavaTokenType.COMMA) {
            return 23;
        }
        return 0;
    }
}

