/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.types.KotlinType;

public class DeclarationBodyVisitor
extends TranslatorVisitor<Void> {
    protected final List<JsPropertyInitializer> result;
    private final List<JsPropertyInitializer> staticResult;
    private final List<JsPropertyInitializer> enumEntryList;
    @NotNull
    private final JsScope scope;
    @Nullable
    private List<JsStatement> initializerStatements;

    public DeclarationBodyVisitor(@NotNull List<JsPropertyInitializer> result2, @NotNull List<JsPropertyInitializer> staticResult, @NotNull JsScope scope) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "<init>"));
        }
        if (staticResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticResult", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "<init>"));
        }
        this.enumEntryList = new SmartList<JsPropertyInitializer>();
        this.result = result2;
        this.staticResult = staticResult;
        this.scope = scope;
    }

    @NotNull
    public List<JsPropertyInitializer> getResult() {
        List<JsPropertyInitializer> list2 = this.result;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "getResult"));
        }
        return list2;
    }

    public List<JsPropertyInitializer> getEnumEntryList() {
        return this.enumEntryList;
    }

    @Override
    protected Void emptyResult(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "emptyResult"));
        }
        return null;
    }

    @Override
    public Void visitClassOrObject(@NotNull KtClassOrObject declaration, TranslationContext context) {
        KtObjectDeclaration objectDeclaration;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitClassOrObject"));
        }
        this.staticResult.addAll(ClassTranslator.translate(declaration, context).getProperties());
        if (declaration instanceof KtObjectDeclaration && (objectDeclaration = (KtObjectDeclaration)declaration).isCompanion()) {
            DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForElement(context.bindingContext(), declaration);
            this.addInitializerStatement(context.getQualifiedReference(descriptor2).makeStmt());
        }
        return null;
    }

    @Override
    public Void visitEnumEntry(@NotNull KtEnumEntry enumEntry, TranslationContext data) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitEnumEntry"));
        }
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(data.bindingContext(), enumEntry);
        List<KotlinType> supertypes2 = JsDescriptorUtils.getSupertypesWithoutFakes(descriptor2);
        if (enumEntry.getBody() != null || supertypes2.size() > 1) {
            this.enumEntryList.addAll(ClassTranslator.translate(enumEntry, data).getProperties());
        } else {
            assert (supertypes2.size() == 1) : "Simple Enum entry must have one supertype";
            JsExpression jsEnumEntryCreation = new ClassInitializerTranslator(enumEntry, data).generateEnumEntryInstanceCreation(supertypes2.get(0));
            jsEnumEntryCreation = TranslationUtils.simpleReturnFunction(data.scope(), jsEnumEntryCreation);
            this.enumEntryList.add(new JsPropertyInitializer(data.getNameForDescriptor(descriptor2).makeRef(), jsEnumEntryCreation));
        }
        return null;
    }

    @Override
    public Void visitNamedFunction(@NotNull KtNamedFunction expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitNamedFunction"));
        }
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor(context.bindingContext(), expression);
        if (descriptor2.getModality() == Modality.ABSTRACT) {
            return null;
        }
        context = context.newDeclaration(descriptor2, context.getDefinitionPlace());
        JsPropertyInitializer methodAsPropertyInitializer = Translation.functionTranslator(expression, context).translateAsMethod();
        this.result.add(methodAsPropertyInitializer);
        return null;
    }

    @Override
    public Void visitProperty(@NotNull KtProperty expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitProperty"));
        }
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptor(context.bindingContext(), expression);
        context = context.newDeclaration(propertyDescriptor, context.getDefinitionPlace());
        PropertyTranslatorKt.translateAccessors(propertyDescriptor, expression, this.result, context);
        return null;
    }

    @Override
    public Void visitAnonymousInitializer(@NotNull KtAnonymousInitializer expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitAnonymousInitializer"));
        }
        return null;
    }

    @Override
    public Void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, TranslationContext data) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitSecondaryConstructor"));
        }
        return null;
    }

    private void addInitializerStatement(@NotNull JsStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "addInitializerStatement"));
        }
        if (this.initializerStatements == null) {
            this.initializerStatements = new ArrayList<JsStatement>();
            JsFunction initializerFunction = new JsFunction(this.scope, new JsBlock(this.initializerStatements), "class initializer");
            this.staticResult.add(new JsPropertyInitializer(new JsNameRef("object_initializer$"), initializerFunction));
        }
        this.initializerStatements.add(statement);
    }
}

