/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.DomainObjectSet;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.NativeLibraryRequirement;
import org.gradle.nativeplatform.internal.resolve.LibraryBinaryLocator;

public class ChainedLibraryBinaryLocator
implements LibraryBinaryLocator {
    private final List<LibraryBinaryLocator> locators = new ArrayList<LibraryBinaryLocator>();

    public ChainedLibraryBinaryLocator(List<? extends LibraryBinaryLocator> locators) {
        this.locators.addAll(locators);
    }

    @Override
    public DomainObjectSet<NativeLibraryBinary> getBinaries(NativeLibraryRequirement requirement) {
        for (LibraryBinaryLocator locator : this.locators) {
            DomainObjectSet<NativeLibraryBinary> binaries = locator.getBinaries(requirement);
            if (binaries == null) continue;
            return binaries;
        }
        return null;
    }
}

