/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilationInitializer;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationNotNecessary;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotProvider;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.Clock;

class SelectiveCompiler
implements Compiler<JavaCompileSpec> {
    private static final Logger LOG = Logging.getLogger(SelectiveCompiler.class);
    private final IncrementalTaskInputs inputs;
    private final PreviousCompilation previousCompilation;
    private final CleaningJavaCompiler cleaningCompiler;
    private final RecompilationSpecProvider recompilationSpecProvider;
    private final IncrementalCompilationInitializer incrementalCompilationInitilizer;
    private final JarClasspathSnapshotProvider jarClasspathSnapshotProvider;

    public SelectiveCompiler(IncrementalTaskInputs inputs, PreviousCompilation previousCompilation, CleaningJavaCompiler cleaningCompiler, RecompilationSpecProvider recompilationSpecProvider, IncrementalCompilationInitializer compilationInitializer, JarClasspathSnapshotProvider jarClasspathSnapshotProvider) {
        this.inputs = inputs;
        this.previousCompilation = previousCompilation;
        this.cleaningCompiler = cleaningCompiler;
        this.recompilationSpecProvider = recompilationSpecProvider;
        this.incrementalCompilationInitilizer = compilationInitializer;
        this.jarClasspathSnapshotProvider = jarClasspathSnapshotProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkResult execute(JavaCompileSpec spec) {
        WorkResult workResult;
        Clock clock = new Clock();
        JarClasspathSnapshot jarClasspathSnapshot = this.jarClasspathSnapshotProvider.getJarClasspathSnapshot(spec.getClasspath());
        RecompilationSpec recompilationSpec = this.recompilationSpecProvider.provideRecompilationSpec(this.inputs, this.previousCompilation, jarClasspathSnapshot);
        if (recompilationSpec.isFullRebuildNeeded()) {
            LOG.lifecycle("Full recompilation is required because {}. Analysis took {}.", new Object[]{recompilationSpec.getFullRebuildCause(), clock.getTime()});
            return this.cleaningCompiler.execute(spec);
        }
        this.incrementalCompilationInitilizer.initializeCompilation(spec, recompilationSpec.getClassNames());
        if (spec.getSource().isEmpty()) {
            LOG.lifecycle("None of the classes needs to be compiled! Analysis took {}. ", new Object[]{clock.getTime()});
            return new RecompilationNotNecessary();
        }
        try {
            workResult = this.cleaningCompiler.getCompiler().execute((CompileSpec)spec);
        }
        catch (Throwable throwable) {
            LOG.lifecycle("Incremental compilation of {} classes completed in {}.", new Object[]{recompilationSpec.getClassNames().size(), clock.getTime()});
            throw throwable;
        }
        LOG.lifecycle("Incremental compilation of {} classes completed in {}.", new Object[]{recompilationSpec.getClassNames().size(), clock.getTime()});
        return workResult;
    }
}

