/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.LicenseString;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class ImageToolBar
extends JToolBar
implements Serializable,
LicenseString {
    private int numButtons = 0;
    private ImageIcon[] IconArray = null;
    private ImageIcon[] IconDisabledArray;
    private JButton[] JButtonArray = null;

    public String getLicenseString() {
        return "This file is covered by the GNU GENERAL PUBLIC LICENSE, Version 2, June 1991";
    }

    public boolean setImages(Image[] images) {
        boolean success = false;
        if (images != null && images.length == this.numButtons) {
            if (this.IconArray == null) {
                this.IconArray = new ImageIcon[images.length];
            }
            int i = 0;
            while (i < images.length) {
                if (images[i] != null) {
                    this.IconArray[i] = new ImageIcon(images[i]);
                    this.JButtonArray[i].setIcon(this.IconArray[i]);
                }
                ++i;
            }
            success = true;
        }
        return success;
    }

    public boolean setImageIcons(ImageIcon[] imageIcons) {
        boolean success = false;
        if (imageIcons != null && imageIcons.length == this.numButtons) {
            this.IconArray = imageIcons;
            int i = 0;
            while (i < imageIcons.length) {
                if (imageIcons[i] != null) {
                    this.JButtonArray[i].setIcon(this.IconArray[i]);
                }
                ++i;
            }
            success = true;
        }
        return success;
    }

    public boolean setImageIconsDisabled(ImageIcon[] imageIcons) {
        boolean success = false;
        if (imageIcons != null && imageIcons.length == this.numButtons) {
            this.IconDisabledArray = imageIcons;
            int i = 0;
            while (i < imageIcons.length) {
                if (imageIcons[i] != null) {
                    this.JButtonArray[i].setDisabledIcon(this.IconDisabledArray[i]);
                }
                ++i;
            }
            success = true;
        }
        return success;
    }

    public int getNumButtons() {
        return this.numButtons;
    }

    public void setNumButtons(int n) {
        if (n > 0) {
            this.numButtons = n;
            this.JButtonArray = new JButton[this.numButtons];
            int i = 0;
            while (i < this.numButtons) {
                this.JButtonArray[i] = new JButton();
                this.JButtonArray[i].setDefaultCapable(false);
                this.JButtonArray[i].setActionCommand("" + i);
                this.add(this.JButtonArray[i]);
                ++i;
            }
        }
    }

    public void addActionListener(ActionListener listener) {
        if (listener != null) {
            int i = 0;
            while (i < this.numButtons) {
                this.JButtonArray[i].addActionListener(listener);
                ++i;
            }
        }
    }

    private boolean validIndex(int i) {
        return i >= 0 && i < this.getNumButtons();
    }

    public void setButtonEnabled(int i, boolean flag) {
        if (this.validIndex(i)) {
            this.JButtonArray[i].setEnabled(flag);
        }
    }

    public JButton getButtonAtIndex(int i) {
        JButton resp = null;
        if (this.validIndex(i)) {
            resp = this.JButtonArray[i];
        }
        return resp;
    }
}

