/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Source;

public class NumericCharacterReference
extends CharacterReference {
    private boolean hex;

    private NumericCharacterReference(Source source, int n, int n2, int n3, boolean bl) {
        super(source, n, n2, n3);
        this.hex = bl;
    }

    public boolean isDecimal() {
        return !this.hex;
    }

    public boolean isHexadecimal() {
        return this.hex;
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (NumericCharacterReference.requiresEncoding(c)) {
                NumericCharacterReference.appendDecimalCharacterReferenceString(stringBuffer, c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String encodeDecimal(String string) {
        return NumericCharacterReference.encode(string);
    }

    public static String encodeHexadecimal(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (NumericCharacterReference.requiresEncoding(c)) {
                NumericCharacterReference.appendHexadecimalCharacterReferenceString(stringBuffer, c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String getCharacterReferenceString() {
        return this.hex ? NumericCharacterReference.getHexadecimalCharacterReferenceString(this.codePoint) : NumericCharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getCharacterReferenceString(int n) {
        return NumericCharacterReference.getDecimalCharacterReferenceString(n);
    }

    static CharacterReference construct(Source source, int n) {
        String string;
        int n2;
        int n3;
        int n4;
        String string2 = source.getParseTextLowerCase();
        boolean bl = string2.charAt(n4 = n + 2) == 'x';
        if (bl) {
            ++n4;
        }
        int n5 = string2.length() - 1;
        int n6 = n4;
        boolean bl2 = false;
        while (true) {
            if ((n3 = string2.charAt(n6)) == 59) {
                n2 = n6 + 1;
                string = string2.substring(n4, n6);
                break;
            }
            if (!(n3 >= 48 && n3 <= 57 || bl && n3 >= 97 && n3 <= 102)) {
                bl2 = true;
            } else if (n6 == n5) {
                bl2 = true;
                ++n6;
            }
            if (bl2) {
                if (bl) {
                    return null;
                }
                n2 = n6;
                string = string2.substring(n4, n6);
                break;
            }
            ++n6;
        }
        if (string.length() == 0) {
            return null;
        }
        n3 = -1;
        try {
            n3 = Integer.parseInt(string, bl ? 16 : 10);
            if (n3 > 0x10FFFF) {
                n3 = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new NumericCharacterReference(source, n, n2, n3, bl);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        if (this.hex) {
            NumericCharacterReference.appendHexadecimalCharacterReferenceString(stringBuffer, this.codePoint);
        } else {
            NumericCharacterReference.appendDecimalCharacterReferenceString(stringBuffer, this.codePoint);
        }
        stringBuffer.append("\" ");
        NumericCharacterReference.appendUnicodeText(stringBuffer, this.codePoint);
        stringBuffer.append(' ').append(super.toString());
        return stringBuffer.toString();
    }
}

