/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntegerKeyStore<T> {
    private static final int RANGE_BIT_SIZE = 8;
    private static final int RANGE_SIZE = 256;
    private final Map<Integer, ArrayList<T>> arrays = new HashMap<Integer, ArrayList<T>>();

    IntegerKeyStore() {
    }

    public void put(Integer index, T value) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int rangeKey = index >> 8;
        int rangeIndex = index % 256;
        ArrayList<Object> range = this.arrays.get(rangeKey);
        if (range == null) {
            range = new ArrayList<Object>(Collections.nCopies(256, null));
            this.arrays.put(rangeKey, range);
        }
        range.set(rangeIndex, value);
    }

    public T get(Integer index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int rangeKey = index >> 8;
        int rangeIndex = index % 256;
        ArrayList<T> range = this.arrays.get(rangeKey);
        return range == null ? null : (T)range.get(rangeIndex);
    }
}

