/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphClassTable;
import org.apache.fop.complexscripts.fonts.GlyphCoverageTable;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionState;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionSubtable;
import org.apache.fop.complexscripts.fonts.GlyphSubtable;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.scripts.ScriptProcessor;
import org.apache.fop.complexscripts.util.CharAssociation;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.GlyphTester;

public class GlyphSubstitutionTable
extends GlyphTable {
    private static final Log log = LogFactory.getLog(GlyphSubstitutionTable.class);
    public static final int GSUB_LOOKUP_TYPE_SINGLE = 1;
    public static final int GSUB_LOOKUP_TYPE_MULTIPLE = 2;
    public static final int GSUB_LOOKUP_TYPE_ALTERNATE = 3;
    public static final int GSUB_LOOKUP_TYPE_LIGATURE = 4;
    public static final int GSUB_LOOKUP_TYPE_CONTEXTUAL = 5;
    public static final int GSUB_LOOKUP_TYPE_CHAINED_CONTEXTUAL = 6;
    public static final int GSUB_LOOKUP_TYPE_EXTENSION_SUBSTITUTION = 7;
    public static final int GSUB_LOOKUP_TYPE_REVERSE_CHAINED_SINGLE = 8;

    public GlyphSubstitutionTable(GlyphDefinitionTable gdef, Map lookups, List subtables) {
        super(gdef, lookups);
        if (subtables == null || subtables.size() == 0) {
            throw new AdvancedTypographicTableFormatException("subtables must be non-empty");
        }
        for (Object o : subtables) {
            if (o instanceof GlyphSubstitutionSubtable) {
                this.addSubtable((GlyphSubtable)o);
                continue;
            }
            throw new AdvancedTypographicTableFormatException("subtable must be a glyph substitution subtable");
        }
        this.freezeSubtables();
    }

    public GlyphSequence substitute(GlyphSequence gs, String script, String language) {
        GlyphSequence ogs;
        Map lookups = this.matchLookups(script, language, "*");
        if (lookups != null && lookups.size() > 0) {
            ScriptProcessor sp = ScriptProcessor.getInstance(script);
            ogs = sp.substitute(this, gs, script, language, lookups);
        } else {
            ogs = gs;
        }
        return ogs;
    }

    public static int getLookupTypeFromName(String name) {
        String s = name.toLowerCase();
        int t = "single".equals(s) ? 1 : ("multiple".equals(s) ? 2 : ("alternate".equals(s) ? 3 : ("ligature".equals(s) ? 4 : ("contextual".equals(s) ? 5 : ("chainedcontextual".equals(s) ? 6 : ("extensionsubstitution".equals(s) ? 7 : ("reversechainiingcontextualsingle".equals(s) ? 8 : -1)))))));
        return t;
    }

    public static String getLookupTypeName(int type) {
        String tn = null;
        switch (type) {
            case 1: {
                tn = "single";
                break;
            }
            case 2: {
                tn = "multiple";
                break;
            }
            case 3: {
                tn = "alternate";
                break;
            }
            case 4: {
                tn = "ligature";
                break;
            }
            case 5: {
                tn = "contextual";
                break;
            }
            case 6: {
                tn = "chainedcontextual";
                break;
            }
            case 7: {
                tn = "extensionsubstitution";
                break;
            }
            case 8: {
                tn = "reversechainiingcontextualsingle";
                break;
            }
            default: {
                tn = "unknown";
            }
        }
        return tn;
    }

    public static GlyphSubtable createSubtable(int type, String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
        GlyphSubstitutionSubtable st = null;
        switch (type) {
            case 1: {
                st = SingleSubtable.create(id, sequence, flags, format, coverage, entries);
                break;
            }
            case 2: {
                st = MultipleSubtable.create(id, sequence, flags, format, coverage, entries);
                break;
            }
            case 3: {
                st = AlternateSubtable.create(id, sequence, flags, format, coverage, entries);
                break;
            }
            case 4: {
                st = LigatureSubtable.create(id, sequence, flags, format, coverage, entries);
                break;
            }
            case 5: {
                st = ContextualSubtable.create(id, sequence, flags, format, coverage, entries);
                break;
            }
            case 6: {
                st = ChainedContextualSubtable.create(id, sequence, flags, format, coverage, entries);
                break;
            }
            case 8: {
                st = ReverseChainedSingleSubtable.create(id, sequence, flags, format, coverage, entries);
                break;
            }
        }
        return st;
    }

    public static GlyphSubtable createSubtable(int type, String id, int sequence, int flags, int format, List coverage, List entries) {
        return GlyphSubstitutionTable.createSubtable(type, id, sequence, flags, format, GlyphCoverageTable.createCoverageTable(coverage), entries);
    }

    public static class LigatureSet {
        private final Ligature[] ligatures;
        private final int maxComponents;

        public LigatureSet(List ligatures) {
            this(ligatures.toArray(new Ligature[ligatures.size()]));
        }

        public LigatureSet(Ligature[] ligatures) {
            if (ligatures == null) {
                throw new AdvancedTypographicTableFormatException("invalid ligatures, must be non-null array");
            }
            this.ligatures = ligatures;
            int ncMax = -1;
            for (Ligature l : ligatures) {
                int nc = l.getNumComponents() + 1;
                if (nc <= ncMax) continue;
                ncMax = nc;
            }
            this.maxComponents = ncMax;
        }

        public Ligature[] getLigatures() {
            return this.ligatures;
        }

        public int getNumLigatures() {
            return this.ligatures.length;
        }

        public int getMaxComponents() {
            return this.maxComponents;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{ligs={");
            int n = this.ligatures.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.ligatures[i]);
            }
            sb.append("}}");
            return sb.toString();
        }
    }

    public static class Ligature {
        private final int ligature;
        private final int[] components;

        public Ligature(int ligature, int[] components) {
            if (ligature < 0 || ligature > 65535) {
                throw new AdvancedTypographicTableFormatException("invalid ligature glyph index: " + ligature);
            }
            if (components == null) {
                throw new AdvancedTypographicTableFormatException("invalid ligature components, must be non-null array");
            }
            int n = components.length;
            for (int i = 0; i < n; ++i) {
                int gc = components[i];
                if (gc >= 0 && gc <= 65535) continue;
                throw new AdvancedTypographicTableFormatException("invalid component glyph index: " + gc);
            }
            this.ligature = ligature;
            this.components = components;
        }

        public int getLigature() {
            return this.ligature;
        }

        public int[] getComponents() {
            return this.components;
        }

        public int getNumComponents() {
            return this.components.length;
        }

        public boolean matchesComponents(int[] glyphs) {
            if (glyphs.length < this.components.length + 1) {
                return false;
            }
            int n = this.components.length;
            for (int i = 0; i < n; ++i) {
                if (glyphs[i + 1] == this.components[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{components={");
            int n = this.components.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(Integer.toString(this.components[i]));
            }
            sb.append("},ligature=");
            sb.append(Integer.toString(this.ligature));
            sb.append("}");
            return sb.toString();
        }
    }

    private static class ReverseChainedSingleSubtableFormat1
    extends ReverseChainedSingleSubtable {
        ReverseChainedSingleSubtableFormat1(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage, entries);
            this.populate(entries);
        }

        public List getEntries() {
            return null;
        }

        private void populate(List entries) {
        }
    }

    private static abstract class ReverseChainedSingleSubtable
    extends GlyphSubstitutionSubtable {
        public ReverseChainedSingleSubtable(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage);
        }

        public int getType() {
            return 8;
        }

        public boolean isCompatible(GlyphSubtable subtable) {
            return subtable instanceof ReverseChainedSingleSubtable;
        }

        public boolean usesReverseScan() {
            return true;
        }

        static GlyphSubstitutionSubtable create(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            if (format == 1) {
                return new ReverseChainedSingleSubtableFormat1(id, sequence, flags, format, coverage, entries);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class ChainedContextualSubtableFormat3
    extends ChainedContextualSubtable {
        private GlyphTable.RuleSet[] rsa;

        ChainedContextualSubtableFormat3(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage, entries);
            this.populate(entries);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<GlyphTable.RuleSet[]> entries = new ArrayList<GlyphTable.RuleSet[]>(1);
                entries.add(this.rsa);
                return entries;
            }
            return null;
        }

        public void resolveLookupReferences(Map lookupTables) {
            GlyphTable.resolveLookupReferences(this.rsa, lookupTables);
        }

        public GlyphTable.RuleLookup[] getLookups(int ci, int gi, GlyphSubstitutionState ss, int[] rv) {
            GlyphTable.RuleSet rs;
            assert (ss != null);
            assert (rv != null && rv.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (rs = this.rsa[0]) != null) {
                for (GlyphTable.Rule r : rs.getRules()) {
                    GlyphCoverageTable[] lgca;
                    GlyphCoverageTable[] bgca;
                    GlyphTable.ChainedCoverageSequenceRule cr;
                    GlyphCoverageTable[] igca;
                    if (r == null || !(r instanceof GlyphTable.ChainedCoverageSequenceRule) || !this.matches(ss, igca = (cr = (GlyphTable.ChainedCoverageSequenceRule)r).getCoverages(), 0, rv) || !this.matches(ss, bgca = cr.getBacktrackCoverages(), -1, null) || !this.matches(ss, lgca = cr.getLookaheadCoverages(), rv[0], null)) continue;
                    return r.getLookups();
                }
            }
            return null;
        }

        private boolean matches(GlyphSubstitutionState ss, GlyphCoverageTable[] gca, int offset, int[] rv) {
            return ContextualSubtableFormat3.matches(ss, gca, offset, rv);
        }

        private void populate(List entries) {
            if (entries == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (entries.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + entries.size() + " entries present, but requires 1 entry");
            }
            Object o = entries.get(0);
            if (o == null || !(o instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an RuleSet[], but is: " + (o != null ? o.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])o;
        }
    }

    private static class ChainedContextualSubtableFormat2
    extends ChainedContextualSubtable {
        private GlyphClassTable icdt;
        private GlyphClassTable bcdt;
        private GlyphClassTable lcdt;
        private int ngc;
        private GlyphTable.RuleSet[] rsa;

        ChainedContextualSubtableFormat2(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage, entries);
            this.populate(entries);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<Object> entries = new ArrayList<Object>(5);
                entries.add(this.icdt);
                entries.add(this.bcdt);
                entries.add(this.lcdt);
                entries.add(this.ngc);
                entries.add(this.rsa);
                return entries;
            }
            return null;
        }

        public GlyphTable.RuleLookup[] getLookups(int ci, int gi, GlyphSubstitutionState ss, int[] rv) {
            GlyphTable.RuleSet rs;
            assert (ss != null);
            assert (rv != null && rv.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (rs = this.rsa[0]) != null) {
                for (GlyphTable.Rule r : rs.getRules()) {
                    int[] lca;
                    int[] bca;
                    GlyphTable.ChainedClassSequenceRule cr;
                    int[] ica;
                    if (r == null || !(r instanceof GlyphTable.ChainedClassSequenceRule) || !this.matches(ss, this.icdt, ica = (cr = (GlyphTable.ChainedClassSequenceRule)r).getClasses(this.icdt.getClassIndex(gi, ss.getClassMatchSet(gi))), 0, rv) || !this.matches(ss, this.bcdt, bca = cr.getBacktrackClasses(), -1, null) || !this.matches(ss, this.lcdt, lca = cr.getLookaheadClasses(), rv[0], null)) continue;
                    return r.getLookups();
                }
            }
            return null;
        }

        private boolean matches(GlyphSubstitutionState ss, GlyphClassTable cdt, int[] classes, int offset, int[] rv) {
            return ContextualSubtableFormat2.matches(ss, cdt, classes, offset, rv);
        }

        public void resolveLookupReferences(Map lookupTables) {
            GlyphTable.resolveLookupReferences(this.rsa, lookupTables);
        }

        private void populate(List entries) {
            if (entries == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (entries.size() != 5) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + entries.size() + " entries present, but requires 5 entries");
            }
            Object o = entries.get(0);
            if (o == null || !(o instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an GlyphClassTable, but is: " + (o != null ? o.getClass() : null));
            }
            this.icdt = (GlyphClassTable)o;
            o = entries.get(1);
            if (o != null && !(o instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, second entry must be an GlyphClassTable, but is: " + o.getClass());
            }
            this.bcdt = (GlyphClassTable)o;
            o = entries.get(2);
            if (o != null && !(o instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, third entry must be an GlyphClassTable, but is: " + o.getClass());
            }
            this.lcdt = (GlyphClassTable)o;
            o = entries.get(3);
            if (o == null || !(o instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, fourth entry must be an Integer, but is: " + (o != null ? o.getClass() : null));
            }
            this.ngc = (Integer)o;
            o = entries.get(4);
            if (o == null || !(o instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, fifth entry must be an RuleSet[], but is: " + (o != null ? o.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])o;
            if (this.rsa.length != this.ngc) {
                throw new AdvancedTypographicTableFormatException("illegal entries, RuleSet[] length is " + this.rsa.length + ", but expected " + this.ngc + " glyph classes");
            }
        }
    }

    private static class ChainedContextualSubtableFormat1
    extends ChainedContextualSubtable {
        private GlyphTable.RuleSet[] rsa;

        ChainedContextualSubtableFormat1(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage, entries);
            this.populate(entries);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<GlyphTable.RuleSet[]> entries = new ArrayList<GlyphTable.RuleSet[]>(1);
                entries.add(this.rsa);
                return entries;
            }
            return null;
        }

        public void resolveLookupReferences(Map lookupTables) {
            GlyphTable.resolveLookupReferences(this.rsa, lookupTables);
        }

        public GlyphTable.RuleLookup[] getLookups(int ci, int gi, GlyphSubstitutionState ss, int[] rv) {
            GlyphTable.RuleSet rs;
            assert (ss != null);
            assert (rv != null && rv.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (rs = this.rsa[0]) != null) {
                for (GlyphTable.Rule r : rs.getRules()) {
                    int[] lga;
                    int[] bga;
                    GlyphTable.ChainedGlyphSequenceRule cr;
                    int[] iga;
                    if (r == null || !(r instanceof GlyphTable.ChainedGlyphSequenceRule) || !this.matches(ss, iga = (cr = (GlyphTable.ChainedGlyphSequenceRule)r).getGlyphs(gi), 0, rv) || !this.matches(ss, bga = cr.getBacktrackGlyphs(), -1, null) || !this.matches(ss, lga = cr.getLookaheadGlyphs(), rv[0], null)) continue;
                    return r.getLookups();
                }
            }
            return null;
        }

        private boolean matches(GlyphSubstitutionState ss, int[] glyphs, int offset, int[] rv) {
            return ContextualSubtableFormat1.matches(ss, glyphs, offset, rv);
        }

        private void populate(List entries) {
            if (entries == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (entries.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + entries.size() + " entries present, but requires 1 entry");
            }
            Object o = entries.get(0);
            if (o == null || !(o instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an RuleSet[], but is: " + (o != null ? o.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])o;
        }
    }

    private static abstract class ChainedContextualSubtable
    extends GlyphSubstitutionSubtable {
        public ChainedContextualSubtable(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage);
        }

        public int getType() {
            return 6;
        }

        public boolean isCompatible(GlyphSubtable subtable) {
            return subtable instanceof ChainedContextualSubtable;
        }

        public boolean substitute(GlyphSubstitutionState ss) {
            int gi = ss.getGlyph();
            int ci = this.getCoverageIndex(gi);
            if (ci < 0) {
                return false;
            }
            int[] rv = new int[1];
            GlyphTable.RuleLookup[] la = this.getLookups(ci, gi, ss, rv);
            if (la != null) {
                ss.apply(la, rv[0]);
                return true;
            }
            return false;
        }

        public abstract GlyphTable.RuleLookup[] getLookups(int var1, int var2, GlyphSubstitutionState var3, int[] var4);

        static GlyphSubstitutionSubtable create(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            if (format == 1) {
                return new ChainedContextualSubtableFormat1(id, sequence, flags, format, coverage, entries);
            }
            if (format == 2) {
                return new ChainedContextualSubtableFormat2(id, sequence, flags, format, coverage, entries);
            }
            if (format == 3) {
                return new ChainedContextualSubtableFormat3(id, sequence, flags, format, coverage, entries);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class ContextualSubtableFormat3
    extends ContextualSubtable {
        private GlyphTable.RuleSet[] rsa;

        ContextualSubtableFormat3(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage, entries);
            this.populate(entries);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<GlyphTable.RuleSet[]> entries = new ArrayList<GlyphTable.RuleSet[]>(1);
                entries.add(this.rsa);
                return entries;
            }
            return null;
        }

        public void resolveLookupReferences(Map lookupTables) {
            GlyphTable.resolveLookupReferences(this.rsa, lookupTables);
        }

        public GlyphTable.RuleLookup[] getLookups(int ci, int gi, GlyphSubstitutionState ss, int[] rv) {
            GlyphTable.RuleSet rs;
            assert (ss != null);
            assert (rv != null && rv.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (rs = this.rsa[0]) != null) {
                for (GlyphTable.Rule r : rs.getRules()) {
                    GlyphTable.ChainedCoverageSequenceRule cr;
                    GlyphCoverageTable[] gca;
                    if (r == null || !(r instanceof GlyphTable.ChainedCoverageSequenceRule) || !ContextualSubtableFormat3.matches(ss, gca = (cr = (GlyphTable.ChainedCoverageSequenceRule)r).getCoverages(), 0, rv)) continue;
                    return r.getLookups();
                }
            }
            return null;
        }

        static boolean matches(GlyphSubstitutionState ss, GlyphCoverageTable[] gca, int offset, int[] rv) {
            int ngm;
            GlyphTester ignores;
            if (gca == null || gca.length == 0) {
                return true;
            }
            boolean reverse = offset < 0;
            int[] counts = ss.getGlyphsAvailable(offset, reverse, ignores = ss.getIgnoreDefault());
            int nga = counts[0];
            if (nga < (ngm = gca.length)) {
                return false;
            }
            int[] ga = ss.getGlyphs(offset, ngm, reverse, ignores, null, counts);
            for (int k = 0; k < ngm; ++k) {
                GlyphCoverageTable ct = gca[k];
                if (ct == null || ct.getCoverageIndex(ga[k]) >= 0) continue;
                return false;
            }
            if (rv != null) {
                rv[0] = counts[0] + counts[1];
            }
            return true;
        }

        private void populate(List entries) {
            if (entries == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (entries.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + entries.size() + " entries present, but requires 1 entry");
            }
            Object o = entries.get(0);
            if (o == null || !(o instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an RuleSet[], but is: " + (o != null ? o.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])o;
        }
    }

    private static class ContextualSubtableFormat2
    extends ContextualSubtable {
        private GlyphClassTable cdt;
        private int ngc;
        private GlyphTable.RuleSet[] rsa;

        ContextualSubtableFormat2(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage, entries);
            this.populate(entries);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<Object> entries = new ArrayList<Object>(3);
                entries.add(this.cdt);
                entries.add(this.ngc);
                entries.add(this.rsa);
                return entries;
            }
            return null;
        }

        public void resolveLookupReferences(Map lookupTables) {
            GlyphTable.resolveLookupReferences(this.rsa, lookupTables);
        }

        public GlyphTable.RuleLookup[] getLookups(int ci, int gi, GlyphSubstitutionState ss, int[] rv) {
            GlyphTable.RuleSet rs;
            assert (ss != null);
            assert (rv != null && rv.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (rs = this.rsa[0]) != null) {
                for (GlyphTable.Rule r : rs.getRules()) {
                    GlyphTable.ChainedClassSequenceRule cr;
                    int[] ca;
                    if (r == null || !(r instanceof GlyphTable.ChainedClassSequenceRule) || !ContextualSubtableFormat2.matches(ss, this.cdt, ca = (cr = (GlyphTable.ChainedClassSequenceRule)r).getClasses(this.cdt.getClassIndex(gi, ss.getClassMatchSet(gi))), 0, rv)) continue;
                    return r.getLookups();
                }
            }
            return null;
        }

        static boolean matches(GlyphSubstitutionState ss, GlyphClassTable cdt, int[] classes, int offset, int[] rv) {
            int ngm;
            GlyphTester ignores;
            if (cdt == null || classes == null || classes.length == 0) {
                return true;
            }
            boolean reverse = offset < 0;
            int[] counts = ss.getGlyphsAvailable(offset, reverse, ignores = ss.getIgnoreDefault());
            int nga = counts[0];
            if (nga < (ngm = classes.length)) {
                return false;
            }
            int[] ga = ss.getGlyphs(offset, ngm, reverse, ignores, null, counts);
            for (int k = 0; k < ngm; ++k) {
                int gi = ga[k];
                int ms = ss.getClassMatchSet(gi);
                int gc = cdt.getClassIndex(gi, ms);
                if (gc < 0 || gc >= cdt.getClassSize(ms)) {
                    return false;
                }
                if (gc == classes[k]) continue;
                return false;
            }
            if (rv != null) {
                rv[0] = counts[0] + counts[1];
            }
            return true;
        }

        private void populate(List entries) {
            if (entries == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (entries.size() != 3) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + entries.size() + " entries present, but requires 3 entries");
            }
            Object o = entries.get(0);
            if (o == null || !(o instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an GlyphClassTable, but is: " + (o != null ? o.getClass() : null));
            }
            this.cdt = (GlyphClassTable)o;
            o = entries.get(1);
            if (o == null || !(o instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, second entry must be an Integer, but is: " + (o != null ? o.getClass() : null));
            }
            this.ngc = (Integer)o;
            o = entries.get(2);
            if (o == null || !(o instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, third entry must be an RuleSet[], but is: " + (o != null ? o.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])o;
            if (this.rsa.length != this.ngc) {
                throw new AdvancedTypographicTableFormatException("illegal entries, RuleSet[] length is " + this.rsa.length + ", but expected " + this.ngc + " glyph classes");
            }
        }
    }

    private static class ContextualSubtableFormat1
    extends ContextualSubtable {
        private GlyphTable.RuleSet[] rsa;

        ContextualSubtableFormat1(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage, entries);
            this.populate(entries);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<GlyphTable.RuleSet[]> entries = new ArrayList<GlyphTable.RuleSet[]>(1);
                entries.add(this.rsa);
                return entries;
            }
            return null;
        }

        public void resolveLookupReferences(Map lookupTables) {
            GlyphTable.resolveLookupReferences(this.rsa, lookupTables);
        }

        public GlyphTable.RuleLookup[] getLookups(int ci, int gi, GlyphSubstitutionState ss, int[] rv) {
            GlyphTable.RuleSet rs;
            assert (ss != null);
            assert (rv != null && rv.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (rs = this.rsa[0]) != null) {
                for (GlyphTable.Rule r : rs.getRules()) {
                    GlyphTable.ChainedGlyphSequenceRule cr;
                    int[] iga;
                    if (r == null || !(r instanceof GlyphTable.ChainedGlyphSequenceRule) || !ContextualSubtableFormat1.matches(ss, iga = (cr = (GlyphTable.ChainedGlyphSequenceRule)r).getGlyphs(gi), 0, rv)) continue;
                    return r.getLookups();
                }
            }
            return null;
        }

        static boolean matches(GlyphSubstitutionState ss, int[] glyphs, int offset, int[] rv) {
            int ngm;
            GlyphTester ignores;
            if (glyphs == null || glyphs.length == 0) {
                return true;
            }
            boolean reverse = offset < 0;
            int[] counts = ss.getGlyphsAvailable(offset, reverse, ignores = ss.getIgnoreDefault());
            int nga = counts[0];
            if (nga < (ngm = glyphs.length)) {
                return false;
            }
            int[] ga = ss.getGlyphs(offset, ngm, reverse, ignores, null, counts);
            for (int k = 0; k < ngm; ++k) {
                if (ga[k] == glyphs[k]) continue;
                return false;
            }
            if (rv != null) {
                rv[0] = counts[0] + counts[1];
            }
            return true;
        }

        private void populate(List entries) {
            if (entries == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (entries.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + entries.size() + " entries present, but requires 1 entry");
            }
            Object o = entries.get(0);
            if (o == null || !(o instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an RuleSet[], but is: " + (o != null ? o.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])o;
        }
    }

    private static abstract class ContextualSubtable
    extends GlyphSubstitutionSubtable {
        public ContextualSubtable(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage);
        }

        public int getType() {
            return 5;
        }

        public boolean isCompatible(GlyphSubtable subtable) {
            return subtable instanceof ContextualSubtable;
        }

        public boolean substitute(GlyphSubstitutionState ss) {
            int gi = ss.getGlyph();
            int ci = this.getCoverageIndex(gi);
            if (ci < 0) {
                return false;
            }
            int[] rv = new int[1];
            GlyphTable.RuleLookup[] la = this.getLookups(ci, gi, ss, rv);
            if (la != null) {
                ss.apply(la, rv[0]);
            }
            return true;
        }

        public abstract GlyphTable.RuleLookup[] getLookups(int var1, int var2, GlyphSubstitutionState var3, int[] var4);

        static GlyphSubstitutionSubtable create(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            if (format == 1) {
                return new ContextualSubtableFormat1(id, sequence, flags, format, coverage, entries);
            }
            if (format == 2) {
                return new ContextualSubtableFormat2(id, sequence, flags, format, coverage, entries);
            }
            if (format == 3) {
                return new ContextualSubtableFormat3(id, sequence, flags, format, coverage, entries);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class LigatureSubtableFormat1
    extends LigatureSubtable {
        private LigatureSet[] ligatureSets;

        public LigatureSubtableFormat1(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage, entries);
            this.populate(entries);
        }

        public List getEntries() {
            ArrayList<LigatureSet> entries = new ArrayList<LigatureSet>(this.ligatureSets.length);
            int n = this.ligatureSets.length;
            for (int i = 0; i < n; ++i) {
                entries.add(this.ligatureSets[i]);
            }
            return entries;
        }

        public LigatureSet getLigatureSetForCoverageIndex(int ci, int gi) throws IllegalArgumentException {
            if (this.ligatureSets == null) {
                return null;
            }
            if (ci >= this.ligatureSets.length) {
                throw new IllegalArgumentException("coverage index " + ci + " out of range, maximum coverage index is " + this.ligatureSets.length);
            }
            return this.ligatureSets[ci];
        }

        private void populate(List entries) {
            int i = 0;
            int n = entries.size();
            LigatureSet[] ligatureSets = new LigatureSet[n];
            for (Object o : entries) {
                if (o instanceof LigatureSet) {
                    ligatureSets[i++] = (LigatureSet)o;
                    continue;
                }
                throw new AdvancedTypographicTableFormatException("illegal ligatures entry, must be LigatureSet: " + o);
            }
            assert (i == n);
            assert (this.ligatureSets == null);
            this.ligatureSets = ligatureSets;
        }
    }

    private static abstract class LigatureSubtable
    extends GlyphSubstitutionSubtable {
        public LigatureSubtable(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage);
        }

        public int getType() {
            return 4;
        }

        public boolean isCompatible(GlyphSubtable subtable) {
            return subtable instanceof LigatureSubtable;
        }

        public boolean substitute(GlyphSubstitutionState ss) {
            int[] iga;
            Ligature l;
            GlyphTester ignores;
            boolean reverse;
            int[] counts;
            int nga;
            int gi = ss.getGlyph();
            int ci = this.getCoverageIndex(gi);
            if (ci < 0) {
                return false;
            }
            LigatureSet ls = this.getLigatureSetForCoverageIndex(ci, gi);
            if (ls != null && (nga = (counts = ss.getGlyphsAvailable(0, reverse = false, ignores = ss.getIgnoreDefault()))[0]) > 1 && (l = this.findLigature(ls, iga = ss.getGlyphs(0, nga, reverse, ignores, null, counts))) != null) {
                int go = l.getLigature();
                if (go < 0 || go > 65535) {
                    go = 65535;
                }
                int nmg = 1 + l.getNumComponents();
                ss.getGlyphs(0, nmg, reverse, ignores, null, counts);
                nga = counts[0];
                int ngi = counts[1];
                CharAssociation[] laa = ss.getAssociations(0, nga);
                ss.putGlyph(go, CharAssociation.join(laa), Boolean.TRUE);
                if (ngi > 0) {
                    ss.putGlyphs(ss.getIgnoredGlyphs(0, ngi), ss.getIgnoredAssociations(0, ngi), null);
                }
                ss.consume(nga + ngi);
            }
            return true;
        }

        private Ligature findLigature(LigatureSet ls, int[] glyphs) {
            Ligature[] la = ls.getLigatures();
            int k = -1;
            int maxComponents = -1;
            int n = la.length;
            for (int i = 0; i < n; ++i) {
                int nc;
                Ligature l = la[i];
                if (!l.matchesComponents(glyphs) || (nc = l.getNumComponents()) <= maxComponents) continue;
                maxComponents = nc;
                k = i;
            }
            if (k >= 0) {
                return la[k];
            }
            return null;
        }

        public abstract LigatureSet getLigatureSetForCoverageIndex(int var1, int var2) throws IllegalArgumentException;

        static GlyphSubstitutionSubtable create(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            if (format == 1) {
                return new LigatureSubtableFormat1(id, sequence, flags, format, coverage, entries);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class AlternateSubtableFormat1
    extends AlternateSubtable {
        private int[][] gaa;

        AlternateSubtableFormat1(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage, entries);
            this.populate(entries);
        }

        public List getEntries() {
            ArrayList<int[]> entries = new ArrayList<int[]>(this.gaa.length);
            int n = this.gaa.length;
            for (int i = 0; i < n; ++i) {
                entries.add(this.gaa[i]);
            }
            return entries;
        }

        public int[] getAlternatesForCoverageIndex(int ci, int gi) throws IllegalArgumentException {
            if (this.gaa == null) {
                return null;
            }
            if (ci >= this.gaa.length) {
                throw new IllegalArgumentException("coverage index " + ci + " out of range, maximum coverage index is " + this.gaa.length);
            }
            return this.gaa[ci];
        }

        private void populate(List entries) {
            int i = 0;
            int n = entries.size();
            int[][] gaa = new int[n][];
            for (Object o : entries) {
                if (o instanceof int[]) {
                    gaa[i++] = (int[])o;
                    continue;
                }
                throw new AdvancedTypographicTableFormatException("illegal entries entry, must be int[]: " + o);
            }
            assert (i == n);
            assert (this.gaa == null);
            this.gaa = gaa;
        }
    }

    private static abstract class AlternateSubtable
    extends GlyphSubstitutionSubtable {
        public AlternateSubtable(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage);
        }

        public int getType() {
            return 3;
        }

        public boolean isCompatible(GlyphSubtable subtable) {
            return subtable instanceof AlternateSubtable;
        }

        public boolean substitute(GlyphSubstitutionState ss) {
            int gi = ss.getGlyph();
            int ci = this.getCoverageIndex(gi);
            if (ci < 0) {
                return false;
            }
            int[] ga = this.getAlternatesForCoverageIndex(ci, gi);
            int ai = ss.getAlternatesIndex(ci);
            int go = ai < 0 || ai >= ga.length ? gi : ga[ai];
            if (go < 0 || go > 65535) {
                go = 65535;
            }
            ss.putGlyph(go, ss.getAssociation(), Boolean.TRUE);
            ss.consume(1);
            return true;
        }

        public abstract int[] getAlternatesForCoverageIndex(int var1, int var2) throws IllegalArgumentException;

        static GlyphSubstitutionSubtable create(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            if (format == 1) {
                return new AlternateSubtableFormat1(id, sequence, flags, format, coverage, entries);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class MultipleSubtableFormat1
    extends MultipleSubtable {
        private int[][] gsa;

        MultipleSubtableFormat1(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage, entries);
            this.populate(entries);
        }

        public List getEntries() {
            if (this.gsa != null) {
                ArrayList<int[][]> entries = new ArrayList<int[][]>(1);
                entries.add(this.gsa);
                return entries;
            }
            return null;
        }

        public int[] getGlyphsForCoverageIndex(int ci, int gi) throws IllegalArgumentException {
            if (this.gsa == null) {
                return null;
            }
            if (ci >= this.gsa.length) {
                throw new IllegalArgumentException("coverage index " + ci + " out of range, maximum coverage index is " + this.gsa.length);
            }
            return this.gsa[ci];
        }

        private void populate(List entries) {
            if (entries == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (entries.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + entries.size() + " entries present, but requires 1 entry");
            }
            Object o = entries.get(0);
            if (o == null || !(o instanceof int[][])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an int[][], but is: " + (o != null ? o.getClass() : null));
            }
            this.gsa = (int[][])o;
        }
    }

    private static abstract class MultipleSubtable
    extends GlyphSubstitutionSubtable {
        public MultipleSubtable(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage);
        }

        public int getType() {
            return 2;
        }

        public boolean isCompatible(GlyphSubtable subtable) {
            return subtable instanceof MultipleSubtable;
        }

        public boolean substitute(GlyphSubstitutionState ss) {
            int gi = ss.getGlyph();
            int ci = this.getCoverageIndex(gi);
            if (ci < 0) {
                return false;
            }
            int[] ga = this.getGlyphsForCoverageIndex(ci, gi);
            if (ga != null) {
                ss.putGlyphs(ga, CharAssociation.replicate(ss.getAssociation(), ga.length), Boolean.TRUE);
                ss.consume(1);
            }
            return true;
        }

        public abstract int[] getGlyphsForCoverageIndex(int var1, int var2) throws IllegalArgumentException;

        static GlyphSubstitutionSubtable create(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            if (format == 1) {
                return new MultipleSubtableFormat1(id, sequence, flags, format, coverage, entries);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class SingleSubtableFormat2
    extends SingleSubtable {
        private int[] glyphs;

        SingleSubtableFormat2(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage, entries);
            this.populate(entries);
        }

        public List getEntries() {
            ArrayList<Integer> entries = new ArrayList<Integer>(this.glyphs.length);
            int n = this.glyphs.length;
            for (int i = 0; i < n; ++i) {
                entries.add(this.glyphs[i]);
            }
            return entries;
        }

        public int getGlyphForCoverageIndex(int ci, int gi) throws IllegalArgumentException {
            if (this.glyphs == null) {
                return -1;
            }
            if (ci >= this.glyphs.length) {
                throw new IllegalArgumentException("coverage index " + ci + " out of range, maximum coverage index is " + this.glyphs.length);
            }
            return this.glyphs[ci];
        }

        private void populate(List entries) {
            int i = 0;
            int n = entries.size();
            int[] glyphs = new int[n];
            for (Object o : entries) {
                if (o instanceof Integer) {
                    int gid = (Integer)o;
                    if (gid >= 0 && gid < 65536) {
                        glyphs[i++] = gid;
                        continue;
                    }
                    throw new AdvancedTypographicTableFormatException("illegal glyph index: " + gid);
                }
                throw new AdvancedTypographicTableFormatException("illegal entries entry, must be Integer: " + o);
            }
            assert (i == n);
            assert (this.glyphs == null);
            this.glyphs = glyphs;
        }
    }

    private static class SingleSubtableFormat1
    extends SingleSubtable {
        private int delta;
        private int ciMax;

        SingleSubtableFormat1(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage, entries);
            this.populate(entries);
        }

        public List getEntries() {
            ArrayList<Integer> entries = new ArrayList<Integer>(1);
            entries.add(this.delta);
            return entries;
        }

        public int getGlyphForCoverageIndex(int ci, int gi) throws IllegalArgumentException {
            if (ci <= this.ciMax) {
                return gi + this.delta;
            }
            throw new IllegalArgumentException("coverage index " + ci + " out of range, maximum coverage index is " + this.ciMax);
        }

        private void populate(List entries) {
            if (entries == null || entries.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null and contain exactly one entry");
            }
            Object o = entries.get(0);
            int delta = 0;
            if (!(o instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries entry, must be Integer, but is: " + o);
            }
            delta = (Integer)o;
            this.delta = delta;
            this.ciMax = this.getCoverageSize() - 1;
        }
    }

    private static abstract class SingleSubtable
    extends GlyphSubstitutionSubtable {
        SingleSubtable(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            super(id, sequence, flags, format, coverage);
        }

        public int getType() {
            return 1;
        }

        public boolean isCompatible(GlyphSubtable subtable) {
            return subtable instanceof SingleSubtable;
        }

        public boolean substitute(GlyphSubstitutionState ss) {
            int gi = ss.getGlyph();
            int ci = this.getCoverageIndex(gi);
            if (ci < 0) {
                return false;
            }
            int go = this.getGlyphForCoverageIndex(ci, gi);
            if (go < 0 || go > 65535) {
                go = 65535;
            }
            ss.putGlyph(go, ss.getAssociation(), Boolean.TRUE);
            ss.consume(1);
            return true;
        }

        public abstract int getGlyphForCoverageIndex(int var1, int var2) throws IllegalArgumentException;

        static GlyphSubstitutionSubtable create(String id, int sequence, int flags, int format, GlyphCoverageTable coverage, List entries) {
            if (format == 1) {
                return new SingleSubtableFormat1(id, sequence, flags, format, coverage, entries);
            }
            if (format == 2) {
                return new SingleSubtableFormat2(id, sequence, flags, format, coverage, entries);
            }
            throw new UnsupportedOperationException();
        }
    }
}

