/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.DispatcherBuilder;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.IncrementalTypeDescriptor;
import org.springsource.loaded.MethodDelta;
import org.springsource.loaded.MethodInvokerRewriter;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeDelta;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.Utils;
import sl.org.objectweb.asm.Type;
import sl.org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentLiveVersion {
    private static Logger log = Logger.getLogger(CurrentLiveVersion.class.getName());
    final ReloadableType reloadableType;
    final TypeDescriptor typeDescriptor;
    final String versionstamp;
    public final IncrementalTypeDescriptor incrementalTypeDescriptor;
    String dispatcherName;
    byte[] dispatcher;
    Class<?> dispatcherClass;
    Object dispatcherInstance;
    String executorName;
    byte[] executor;
    Class<?> executorClass;
    TypeDelta typeDelta;
    private Method staticInitializer;
    private boolean haveLookedForStaticInitializer;
    public boolean staticInitializedNeedsRerunningOnDefine = false;

    public CurrentLiveVersion(ReloadableType reloadableType, String versionstamp, byte[] newbytedata) {
        if (GlobalConfiguration.logging && log.isLoggable(Level.FINER)) {
            log.entering("CurrentLiveVersion", "<init>", " new version of " + reloadableType.getName() + " loaded, version stamp '" + versionstamp + "'");
        }
        this.reloadableType = reloadableType;
        this.typeDescriptor = reloadableType.getTypeRegistry().getExtractor().extract(newbytedata, true);
        this.versionstamp = versionstamp;
        if (GlobalConfiguration.assertsMode && !this.typeDescriptor.getName().equals(reloadableType.typedescriptor.getName())) {
            throw new IllegalStateException("New version has wrong name.  Expected " + reloadableType.typedescriptor.getName() + " but was " + this.typeDescriptor.getName());
        }
        newbytedata = GlobalConfiguration.callsideRewritingOn ? MethodInvokerRewriter.rewrite(reloadableType.typeRegistry, newbytedata) : newbytedata;
        this.incrementalTypeDescriptor = new IncrementalTypeDescriptor(reloadableType.typedescriptor);
        this.incrementalTypeDescriptor.setLatestTypeDescriptor(this.typeDescriptor);
        this.executor = reloadableType.getTypeRegistry().executorBuilder.createFor(reloadableType, versionstamp, this.typeDescriptor, newbytedata);
        if (GlobalConfiguration.classesToDump != null && GlobalConfiguration.classesToDump.contains(reloadableType.getSlashedName())) {
            Utils.dump(Utils.getExecutorName(reloadableType.getName(), versionstamp).replace('.', '/'), this.executor);
        }
        if (!this.typeDescriptor.isInterface()) {
            this.dispatcherName = Utils.getDispatcherName(reloadableType.getName(), versionstamp);
            this.executorName = Utils.getExecutorName(reloadableType.getName(), versionstamp);
            this.dispatcher = DispatcherBuilder.createFor(reloadableType, this.incrementalTypeDescriptor, versionstamp);
        }
        reloadableType.typeRegistry.checkChildClassLoader(reloadableType);
        this.define();
    }

    public void define() {
        this.staticInitializer = null;
        this.haveLookedForStaticInitializer = false;
        if (!this.typeDescriptor.isInterface()) {
            try {
                this.dispatcherClass = this.reloadableType.typeRegistry.defineClass(this.dispatcherName, this.dispatcher, false);
            }
            catch (RuntimeException t) {
                if (t.getMessage().indexOf("duplicate class definition") == -1) {
                    throw t;
                }
                t.printStackTrace();
            }
        }
        try {
            this.executorClass = this.reloadableType.typeRegistry.defineClass(this.executorName, this.executor, false);
        }
        catch (RuntimeException t) {
            if (t.getMessage().indexOf("duplicate class definition") == -1) {
                throw t;
            }
            t.printStackTrace();
        }
        if (!this.typeDescriptor.isInterface()) {
            try {
                this.dispatcherInstance = this.dispatcherClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to build dispatcher class instance", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to build dispatcher class instance", e);
            }
        }
    }

    public MethodMember getReloadableMethod(String name, String descriptor) {
        MethodMember[] methods;
        for (MethodMember rmethod : methods = this.incrementalTypeDescriptor.getLatestTypeDescriptor().getMethods()) {
            if (!rmethod.getName().equals(name) || !descriptor.equals(rmethod.getDescriptor())) continue;
            return rmethod;
        }
        return null;
    }

    public Method getExecutorMethod(MethodMember methodMember) {
        String name = methodMember.isConstructor() ? "___init___" : methodMember.getName();
        String executorDescriptor = this.getExecutorDescriptor(methodMember);
        if (this.executorClass != null) {
            Method[] executorMethods;
            for (Method executor : executorMethods = this.executorClass.getDeclaredMethods()) {
                if (!executor.getName().equals(name) || !Type.getMethodDescriptor(executor).equals(executorDescriptor)) continue;
                return executor;
            }
        }
        return null;
    }

    private String getExecutorDescriptor(MethodMember methodMember) {
        Type[] params;
        Type[] newParametersArray = params = Type.getArgumentTypes(methodMember.getDescriptor());
        if (!methodMember.isStatic()) {
            newParametersArray = new Type[params.length + 1];
            System.arraycopy(params, 0, newParametersArray, 1, params.length);
            newParametersArray[0] = Type.getType(this.reloadableType.getClazz());
        }
        String executorDescriptor = Type.getMethodDescriptor(Type.getReturnType(methodMember.getDescriptor()), newParametersArray);
        return executorDescriptor;
    }

    public String toString() {
        return "CurrentLiveVersion [reloadableType=" + this.reloadableType + ", typeDescriptor=" + this.typeDescriptor + ", versionstamp=" + this.versionstamp + ", dispatcherName=" + this.dispatcherName + ", executorName=" + this.executorName + "]";
    }

    public Class<?> getExecutorClass() {
        return this.executorClass;
    }

    public String getVersionStamp() {
        return this.versionstamp;
    }

    public Field getExecutorField(String name) throws SecurityException, NoSuchFieldException {
        return this.executorClass.getDeclaredField(name);
    }

    public TypeDelta getTypeDelta() {
        return this.typeDelta;
    }

    public void setTypeDelta(TypeDelta td) {
        this.typeDelta = td;
    }

    public boolean hasClinit() {
        return this.typeDescriptor.hasClinit();
    }

    public boolean hasConstructorChanged(String descriptor) {
        MethodMember mm = this.typeDescriptor.getConstructor(descriptor);
        return this.hasConstructorChanged(mm);
    }

    public boolean hasConstructorChanged(MethodMember mm) {
        if (mm == null) {
            return true;
        }
        if (this.typeDelta.haveMethodsChangedOrBeenAddedOrRemoved()) {
            MethodNode mn;
            MethodDelta md;
            if (this.typeDelta.haveMethodsChanged() && (md = this.typeDelta.changedMethods.get(mm.name + mm.descriptor)) != null) {
                return true;
            }
            if (this.typeDelta.haveMethodsBeenAdded() && (mn = this.typeDelta.brandNewMethods.get(mm.name + mm.descriptor)) != null) {
                return true;
            }
            if (this.typeDelta.haveMethodsBeenDeleted() && (mn = this.typeDelta.lostMethods.get(mm.name + mm.descriptor)) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean hasConstructorChanged(int ctorId) {
        MethodMember mm = this.typeDescriptor.getConstructor(ctorId);
        return this.hasConstructorChanged(mm);
    }

    public void clearClassloaderLinks() {
        this.executorClass = null;
        this.dispatcherClass = null;
    }

    public void reloadMostRecentDispatcherAndExecutor() {
        this.define();
    }

    public Object getDispatcherInstance() {
        return null;
    }

    public void runStaticInitializer() {
        if (!this.haveLookedForStaticInitializer) {
            try {
                this.staticInitializer = this.getExecutorClass().getDeclaredMethod("___clinit___", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.haveLookedForStaticInitializer = true;
        }
        if (this.staticInitializer != null) {
            try {
                this.staticInitializer.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                log.severe("Unexpected exception whilst trying to call the static initializer on " + this.reloadableType.getName());
                e.printStackTrace();
            }
        }
    }
}

