/*
 * Copyright 2010-2012 VMware and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springsource.loaded;

// TODO many more to add here - would drastically reduce amount of generated bytecode but the cost would be debugging confusion
// TODO can these methods be made synthetic (at load time) so they don't interfere with the debugger?
// TODO can we check on whether debugging is going to happen and then choose whether to use these helper methods at startup?
/**
 * Runtime Helper Class. Provides utility methods called by generated code to perform common functions. Using these does
 * reduce the amount of generated bytecode but it introduces extra paths into the code (calls) that a debugger might
 * step into.
 * 
 * 
 * @author Andy Clement
 * @since 1.0.4
 */
public class RTH {

	/**
	 * Collapse a String and int into an array
	 * 
	 * @param aString some string
	 * @param anInt some int
	 * @return the collapsed array
	 */
	public static Object[] collapse(String aString, int anInt) {
		return new Object[] { aString, Integer.valueOf(anInt) };
	}

}
