/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.cf.attrib.AttCode;
import com.android.dx.cf.attrib.AttLineNumberTable;
import com.android.dx.cf.attrib.AttLocalVariableTable;
import com.android.dx.cf.attrib.AttLocalVariableTypeTable;
import com.android.dx.cf.code.ByteCatchList;
import com.android.dx.cf.code.BytecodeArray;
import com.android.dx.cf.code.LineNumberList;
import com.android.dx.cf.code.LocalVariableList;
import com.android.dx.cf.iface.AttributeList;
import com.android.dx.cf.iface.ClassFile;
import com.android.dx.cf.iface.Method;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Prototype;

public final class ConcreteMethod
implements Method {
    private final Method method;
    private final CstString sourceFile;
    private final boolean accSuper;
    private final AttCode attCode;
    private final LineNumberList lineNumbers;
    private final LocalVariableList localVariables;

    public ConcreteMethod(Method method, ClassFile cf, boolean keepLines, boolean keepLocals) {
        this(method, cf.getAccessFlags(), cf.getSourceFile(), keepLines, keepLocals);
    }

    public ConcreteMethod(Method method, int accessFlags, CstString sourceFile, boolean keepLines, boolean keepLocals) {
        this.method = method;
        this.accSuper = (accessFlags & 0x20) != 0;
        this.sourceFile = sourceFile;
        AttributeList attribs = method.getAttributes();
        this.attCode = (AttCode)attribs.findFirst("Code");
        AttributeList codeAttribs = this.attCode.getAttributes();
        LineNumberList lineNumbers = LineNumberList.EMPTY;
        if (keepLines) {
            AttLineNumberTable lnt = (AttLineNumberTable)codeAttribs.findFirst("LineNumberTable");
            while (lnt != null) {
                lineNumbers = LineNumberList.concat(lineNumbers, lnt.getLineNumbers());
                lnt = (AttLineNumberTable)codeAttribs.findNext(lnt);
            }
        }
        this.lineNumbers = lineNumbers;
        LocalVariableList localVariables = LocalVariableList.EMPTY;
        if (keepLocals) {
            AttLocalVariableTable lvt = (AttLocalVariableTable)codeAttribs.findFirst("LocalVariableTable");
            while (lvt != null) {
                localVariables = LocalVariableList.concat(localVariables, lvt.getLocalVariables());
                lvt = (AttLocalVariableTable)codeAttribs.findNext(lvt);
            }
            LocalVariableList typeList = LocalVariableList.EMPTY;
            AttLocalVariableTypeTable lvtt = (AttLocalVariableTypeTable)codeAttribs.findFirst("LocalVariableTypeTable");
            while (lvtt != null) {
                typeList = LocalVariableList.concat(typeList, lvtt.getLocalVariables());
                lvtt = (AttLocalVariableTypeTable)codeAttribs.findNext(lvtt);
            }
            if (typeList.size() != 0) {
                localVariables = LocalVariableList.mergeDescriptorsAndSignatures(localVariables, typeList);
            }
        }
        this.localVariables = localVariables;
    }

    @Override
    public CstNat getNat() {
        return this.method.getNat();
    }

    @Override
    public CstString getName() {
        return this.method.getName();
    }

    @Override
    public CstString getDescriptor() {
        return this.method.getDescriptor();
    }

    @Override
    public int getAccessFlags() {
        return this.method.getAccessFlags();
    }

    @Override
    public AttributeList getAttributes() {
        return this.method.getAttributes();
    }

    @Override
    public CstType getDefiningClass() {
        return this.method.getDefiningClass();
    }

    @Override
    public Prototype getEffectiveDescriptor() {
        return this.method.getEffectiveDescriptor();
    }

    public boolean getAccSuper() {
        return this.accSuper;
    }

    public int getMaxStack() {
        return this.attCode.getMaxStack();
    }

    public int getMaxLocals() {
        return this.attCode.getMaxLocals();
    }

    public BytecodeArray getCode() {
        return this.attCode.getCode();
    }

    public ByteCatchList getCatches() {
        return this.attCode.getCatches();
    }

    public LineNumberList getLineNumbers() {
        return this.lineNumbers;
    }

    public LocalVariableList getLocalVariables() {
        return this.localVariables;
    }

    public SourcePosition makeSourcePosistion(int offset) {
        return new SourcePosition(this.sourceFile, offset, this.lineNumbers.pcToLine(offset));
    }
}

