/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.io.IOException;
import java.util.Map;
import javajs.img.DCT;
import javajs.img.Huffman;
import javajs.img.ImageEncoder;
import javajs.img.JpegObj;

public class JpgEncoder
extends ImageEncoder {
    private static final int CONTINUE_MAX = 65500;
    private static final int CONTINUE_MAX_BUFFER = 65510;
    private JpegObj jpegObj;
    private Huffman huf;
    private DCT dct;
    protected int defaultQuality = 100;
    private String applicationTag;
    private static byte[] eoi = new byte[]{-1, -39};
    private static byte[] jfif = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
    private static byte[] soi = new byte[]{-1, -40};

    @Override
    protected void setParams(Map<String, Object> map) {
        if (this.quality <= 0) {
            this.quality = map.containsKey("qualityJPG") ? (Integer)map.get("qualityJPG") : this.defaultQuality;
        }
        this.jpegObj = new JpegObj();
        this.jpegObj.comment = (String)map.get("comment");
        this.applicationTag = (String)map.get("jpgAppTag");
    }

    @Override
    protected void generate() throws IOException {
        this.jpegObj.imageWidth = this.width;
        this.jpegObj.imageHeight = this.height;
        this.dct = new DCT(this.quality);
        this.huf = new Huffman(this.width, this.height);
        if (this.jpegObj == null) {
            return;
        }
        this.jpegObj.getYCCArray(this.pixels);
        String string = this.writeHeaders(this.jpegObj, this.dct);
        this.writeCompressedData(this.jpegObj, this.dct, this.huf);
        this.writeMarker(eoi);
        if (string != null) {
            byte[] byArray = string.getBytes();
            this.out.write(byArray, 0, byArray.length);
        }
    }

    private void writeCompressedData(JpegObj jpegObj, DCT dCT, Huffman huffman) {
        int n;
        float[][] fArray = new float[8][8];
        double[][] dArray = new double[8][8];
        int[] nArray = new int[64];
        int[] nArray2 = new int[jpegObj.numberOfComponents];
        int n2 = huffman.imageWidth % 8 != 0 ? (int)(Math.floor((double)huffman.imageWidth / 8.0) + 1.0) * 8 : huffman.imageWidth;
        int n3 = huffman.imageHeight % 8 != 0 ? (int)(Math.floor((double)huffman.imageHeight / 8.0) + 1.0) * 8 : huffman.imageHeight;
        for (n = 0; n < jpegObj.numberOfComponents; ++n) {
            n2 = Math.min(n2, jpegObj.blockWidth[n]);
            n3 = Math.min(n3, jpegObj.blockHeight[n]);
        }
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                n4 = j * 8;
                int n5 = i * 8;
                for (n = 0; n < jpegObj.numberOfComponents; ++n) {
                    float[][] fArray2 = jpegObj.components[n];
                    int n6 = jpegObj.vsampFactor[n];
                    int n7 = jpegObj.hsampFactor[n];
                    int n8 = jpegObj.qtableNumber[n];
                    int n9 = jpegObj.dctableNumber[n];
                    int n10 = jpegObj.actableNumber[n];
                    for (int k = 0; k < n6; ++k) {
                        for (int i2 = 0; i2 < n7; ++i2) {
                            int n11 = i2 * 8;
                            int n12 = k * 8;
                            for (int i3 = 0; i3 < 8; ++i3) {
                                for (int i4 = 0; i4 < 8; ++i4) {
                                    fArray[i3][i4] = fArray2[n5 + n12 + i3][n4 + n11 + i4];
                                }
                            }
                            dArray = DCT.forwardDCT(fArray);
                            nArray = DCT.quantizeBlock(dArray, dCT.divisors[n8]);
                            huffman.HuffmanBlockEncoder(this.out, nArray, nArray2[n], n9, n10);
                            nArray2[n] = nArray[0];
                        }
                    }
                }
            }
        }
        huffman.flushBuffer(this.out);
    }

    private String writeHeaders(JpegObj jpegObj, DCT dCT) {
        int n;
        this.writeMarker(soi);
        this.writeArray(jfif);
        String string = null;
        if (jpegObj.comment.length() > 0) {
            this.writeString(jpegObj.comment, (byte)-31);
        }
        this.writeString("JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.\n\n", (byte)-2);
        byte[] byArray = new byte[134];
        byArray[0] = -1;
        byArray[1] = -37;
        byArray[2] = 0;
        byArray[3] = -124;
        int n2 = 4;
        for (n = 0; n < 2; ++n) {
            byArray[n2++] = (byte)(0 + n);
            int[] nArray = dCT.quantum[n];
            for (int i = 0; i < 64; ++i) {
                byArray[n2++] = (byte)nArray[Huffman.jpegNaturalOrder[i]];
            }
        }
        this.writeArray(byArray);
        byte[] byArray2 = new byte[19];
        byArray2[0] = -1;
        byArray2[1] = -64;
        byArray2[2] = 0;
        byArray2[3] = 17;
        byArray2[4] = (byte)jpegObj.precision;
        byArray2[5] = (byte)(jpegObj.imageHeight >> 8 & 0xFF);
        byArray2[6] = (byte)(jpegObj.imageHeight & 0xFF);
        byArray2[7] = (byte)(jpegObj.imageWidth >> 8 & 0xFF);
        byArray2[8] = (byte)(jpegObj.imageWidth & 0xFF);
        byArray2[9] = (byte)jpegObj.numberOfComponents;
        int n3 = 10;
        for (n = 0; n < byArray2[9]; ++n) {
            byArray2[n3++] = (byte)jpegObj.compID[n];
            byArray2[n3++] = (byte)((jpegObj.hsampFactor[n] << 4) + jpegObj.vsampFactor[n]);
            byArray2[n3++] = (byte)jpegObj.qtableNumber[n];
        }
        this.writeArray(byArray2);
        this.WriteDHTHeader(Huffman.bitsDCluminance, Huffman.valDCluminance);
        this.WriteDHTHeader(Huffman.bitsACluminance, Huffman.valACluminance);
        this.WriteDHTHeader(Huffman.bitsDCchrominance, Huffman.valDCchrominance);
        this.WriteDHTHeader(Huffman.bitsACchrominance, Huffman.valACchrominance);
        byte[] byArray3 = new byte[14];
        byArray3[0] = -1;
        byArray3[1] = -38;
        byArray3[2] = 0;
        byArray3[3] = 12;
        byArray3[4] = (byte)jpegObj.numberOfComponents;
        n3 = 5;
        for (n = 0; n < byArray3[4]; ++n) {
            byArray3[n3++] = (byte)jpegObj.compID[n];
            byArray3[n3++] = (byte)((jpegObj.dctableNumber[n] << 4) + jpegObj.actableNumber[n]);
        }
        byArray3[n3++] = (byte)jpegObj.ss;
        byArray3[n3++] = (byte)jpegObj.se;
        byArray3[n3++] = (byte)((jpegObj.ah << 4) + jpegObj.al);
        this.writeArray(byArray3);
        return string;
    }

    private void writeString(String string, byte by) {
        int n;
        int n2 = string.length();
        String string2 = this.applicationTag;
        for (int i = 0; i < n2; i += n) {
            int n3;
            n = n2 - i;
            if (n > 65510 && (n3 = string.lastIndexOf(10, i + (n = 65500))) > i + 1) {
                n = n3 - i;
            }
            if (i + n == n2) {
                string2 = "";
            }
            this.writeTag(n + string2.length(), by);
            this.writeArray(string.substring(i, i + n).getBytes());
            if (string2.length() <= 0) continue;
            this.writeArray(string2.getBytes());
        }
    }

    private void writeTag(int n, byte by) {
        byte[] byArray = new byte[]{-1, by, (byte)((n += 2) >> 8 & 0xFF), (byte)(n & 0xFF)};
        this.writeArray(byArray);
    }

    void WriteDHTHeader(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 1; n2 < 17; ++n2) {
            n3 += nArray[n2];
        }
        byte[] byArray = new byte[21 + n3];
        byArray[0] = -1;
        byArray[1] = -60;
        n2 = 4;
        for (n = 0; n < 17; ++n) {
            byArray[n2++] = (byte)nArray[n];
        }
        for (n = 0; n < n3; ++n) {
            byArray[n2++] = (byte)nArray2[n];
        }
        byArray[2] = (byte)(n2 - 2 >> 8 & 0xFF);
        byArray[3] = (byte)(n2 - 2 & 0xFF);
        this.writeArray(byArray);
    }

    void writeMarker(byte[] byArray) {
        this.out.write(byArray, 0, 2);
    }

    void writeArray(byte[] byArray) {
        this.out.write(byArray, 0, byArray.length);
    }
}

