/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.securerandom;

import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ConvertBytes;

public class SecureRandomLibrary {
    @JRubyMethod(meta=true)
    public static IRubyObject random_bytes(ThreadContext context, IRubyObject self2) {
        return RubyString.newStringNoCopy(context.runtime, SecureRandomLibrary.nextBytes(context, 16));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject random_bytes(ThreadContext context, IRubyObject self2, IRubyObject n) {
        return RubyString.newStringNoCopy(context.runtime, SecureRandomLibrary.nextBytes(context, n));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject hex(ThreadContext context, IRubyObject self2) {
        return RubyString.newStringNoCopy(context.runtime, ConvertBytes.twosComplementToHexBytes(SecureRandomLibrary.nextBytes(context, 16), false));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject hex(ThreadContext context, IRubyObject self2, IRubyObject n) {
        return RubyString.newStringNoCopy(context.runtime, ConvertBytes.twosComplementToHexBytes(SecureRandomLibrary.nextBytes(context, n), false));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject uuid(ThreadContext context, IRubyObject self2) {
        return RubyString.newStringNoCopy(context.runtime, ConvertBytes.bytesToUUIDBytes(SecureRandomLibrary.nextBytes(context, 16), false));
    }

    private static byte[] nextBytes(ThreadContext context, IRubyObject n) {
        int size2 = n.isNil() ? 16 : (int)n.convertToInteger().getLongValue();
        return SecureRandomLibrary.nextBytes(context, size2);
    }

    private static byte[] nextBytes(ThreadContext context, int size2) {
        if (size2 < 0) {
            throw context.runtime.newArgumentError("negative argument: " + size2);
        }
        byte[] bytes2 = new byte[size2];
        context.getSecureRandom().nextBytes(bytes2);
        return bytes2;
    }
}

