/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import morfologik.stemming.BufferUtils;
import morfologik.stemming.ISequenceEncoder;

public class TrimPrefixAndSuffixEncoder
implements ISequenceEncoder {
    private static final int REMOVE_EVERYTHING = 255;

    @Override
    public ByteBuffer encode(ByteBuffer reuse, ByteBuffer source, ByteBuffer target) {
        int maxSubsequenceLength = 0;
        int maxSubsequenceIndex = 0;
        for (int i = 0; i < source.remaining(); ++i) {
            int sharedPrefix = BufferUtils.sharedPrefixLength(source, i, target, 0);
            if (sharedPrefix <= maxSubsequenceLength || i >= 255 || source.remaining() - (i + sharedPrefix) >= 255) continue;
            maxSubsequenceLength = sharedPrefix;
            maxSubsequenceIndex = i;
        }
        int truncatePrefixBytes = maxSubsequenceIndex;
        int truncateSuffixBytes = source.remaining() - (maxSubsequenceIndex + maxSubsequenceLength);
        if (truncatePrefixBytes >= 255 || truncateSuffixBytes >= 255) {
            maxSubsequenceLength = 0;
            maxSubsequenceIndex = 0;
            truncateSuffixBytes = 255;
            truncatePrefixBytes = 255;
        }
        int len1 = target.remaining() - maxSubsequenceLength;
        reuse = BufferUtils.clearAndEnsureCapacity(reuse, 2 + len1);
        assert (target.hasArray() && target.position() == 0 && target.arrayOffset() == 0);
        reuse.put((byte)(truncatePrefixBytes + 65 & 0xFF));
        reuse.put((byte)(truncateSuffixBytes + 65 & 0xFF));
        reuse.put(target.array(), maxSubsequenceLength, len1);
        reuse.flip();
        return reuse;
    }

    @Override
    public ByteBuffer decode(ByteBuffer reuse, ByteBuffer source, ByteBuffer encoded) {
        assert (encoded.remaining() >= 2);
        int p = encoded.position();
        int truncatePrefixBytes = encoded.get(p) - 65 & 0xFF;
        int truncateSuffixBytes = encoded.get(p + 1) - 65 & 0xFF;
        if (truncatePrefixBytes == 255 || truncateSuffixBytes == 255) {
            truncatePrefixBytes = source.remaining();
            truncateSuffixBytes = 0;
        }
        assert (source.hasArray() && source.position() == 0 && source.arrayOffset() == 0);
        assert (encoded.hasArray() && encoded.position() == 0 && encoded.arrayOffset() == 0);
        int len1 = source.remaining() - (truncateSuffixBytes + truncatePrefixBytes);
        int len2 = encoded.remaining() - 2;
        reuse = BufferUtils.clearAndEnsureCapacity(reuse, len1 + len2);
        reuse.put(source.array(), truncatePrefixBytes, len1);
        reuse.put(encoded.array(), 2, len2);
        reuse.flip();
        return reuse;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

