/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.map;

import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.collections.Iterators;
import edu.berkeley.nlp.lm.map.NgramMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NgramsForOrderIterableWrapper<W, V>
implements Iterable<Map.Entry<List<W>, V>> {
    private final NgramMap<V> map;
    private final int ngramOrder;
    private final WordIndexer<W> wordIndexer;

    public NgramsForOrderIterableWrapper(NgramMap<V> map, WordIndexer<W> wordIndexer, int ngramOrder) {
        this.map = map;
        this.ngramOrder = ngramOrder;
        this.wordIndexer = wordIndexer;
    }

    @Override
    public Iterator<Map.Entry<List<W>, V>> iterator() {
        return new Iterators.Transform<NgramMap.Entry<V>, Map.Entry<List<W>, V>>(this.map.getNgramsForOrder(this.ngramOrder).iterator()){

            @Override
            protected Map.Entry<List<W>, V> transform(final NgramMap.Entry<V> next) {
                return new Map.Entry<List<W>, V>(){

                    @Override
                    public List<W> getKey() {
                        List ngram = WordIndexer.StaticMethods.toList(NgramsForOrderIterableWrapper.this.wordIndexer, next.key);
                        return ngram;
                    }

                    @Override
                    public V getValue() {
                        return next.value;
                    }

                    @Override
                    public V setValue(V arg0) {
                        throw new UnsupportedOperationException("Method not yet implemented");
                    }
                };
            }
        };
    }

    public long size() {
        return this.map.getNumNgrams(this.ngramOrder);
    }
}

