/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.lucene40.BitVector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.MutableBits;

@Deprecated
public final class Lucene40LiveDocsFormat
extends LiveDocsFormat {
    static final String DELETES_EXTENSION = "del";

    public MutableBits newLiveDocs(int size) throws IOException {
        BitVector bitVector = new BitVector(size);
        bitVector.invertAll();
        return bitVector;
    }

    public MutableBits newLiveDocs(Bits existing) throws IOException {
        BitVector liveDocs = (BitVector)existing;
        return liveDocs.clone();
    }

    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info, IOContext context) throws IOException {
        String filename = IndexFileNames.fileNameFromGeneration((String)info.info.name, (String)DELETES_EXTENSION, (long)info.getDelGen());
        BitVector liveDocs = new BitVector(dir, filename, context);
        if (liveDocs.length() != info.info.maxDoc()) {
            throw new CorruptIndexException("liveDocs.length()=" + liveDocs.length() + "info.docCount=" + info.info.maxDoc(), filename);
        }
        if (liveDocs.count() != info.info.maxDoc() - info.getDelCount()) {
            throw new CorruptIndexException("liveDocs.count()=" + liveDocs.count() + " info.docCount=" + info.info.maxDoc() + " info.getDelCount()=" + info.getDelCount(), filename);
        }
        return liveDocs;
    }

    public void writeLiveDocs(MutableBits bits, Directory dir, SegmentCommitInfo info, int newDelCount, IOContext context) throws IOException {
        String filename = IndexFileNames.fileNameFromGeneration((String)info.info.name, (String)DELETES_EXTENSION, (long)info.getNextDelGen());
        BitVector liveDocs = (BitVector)bits;
        if (liveDocs.length() != info.info.maxDoc()) {
            throw new CorruptIndexException("liveDocs.length()=" + liveDocs.length() + "info.docCount=" + info.info.maxDoc(), filename);
        }
        if (liveDocs.count() != info.info.maxDoc() - info.getDelCount() - newDelCount) {
            throw new CorruptIndexException("liveDocs.count()=" + liveDocs.count() + " info.docCount=" + info.info.maxDoc() + " info.getDelCount()=" + info.getDelCount() + " newDelCount=" + newDelCount, filename);
        }
        liveDocs.write(dir, filename, context);
    }

    public void files(SegmentCommitInfo info, Collection<String> files) throws IOException {
        if (info.hasDeletions()) {
            files.add(IndexFileNames.fileNameFromGeneration((String)info.info.name, (String)DELETES_EXTENSION, (long)info.getDelGen()));
        }
    }
}

