/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.JapaneseBasicFormFilter;
import org.apache.lucene.analysis.ja.JapaneseKatakanaStemFilter;
import org.apache.lucene.analysis.ja.JapanesePartOfSpeechStopFilter;
import org.apache.lucene.analysis.ja.JapanesePunctuationFilter;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.JapaneseWidthFilter;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapaneseAnalyzer
extends StopwordAnalyzerBase {
    private final Set<String> stoptags;
    private final Set<?> stemExclusionSet;
    private final String dictionaryDir;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public static Set<String> getDefaultStopTags() {
        return DefaultSetHolder.DEFAULT_STOP_TAGS;
    }

    public JapaneseAnalyzer(Version version) {
        this(version, DefaultSetHolder.DEFAULT_STOP_SET, DefaultSetHolder.DEFAULT_STOP_TAGS, (Set<?>)CharArraySet.EMPTY_SET, null);
    }

    public JapaneseAnalyzer(Version version, String dictionaryDir) {
        this(version, DefaultSetHolder.DEFAULT_STOP_SET, DefaultSetHolder.DEFAULT_STOP_TAGS, (Set<?>)CharArraySet.EMPTY_SET, dictionaryDir);
    }

    public JapaneseAnalyzer(Version version, Set<?> stopwords, Set<String> stoptags, Set<?> stemExclusionSet, String dictionaryDir) {
        super(version, stopwords);
        this.stoptags = stoptags;
        this.stemExclusionSet = stemExclusionSet;
        this.dictionaryDir = dictionaryDir;
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String field, Reader reader) {
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(reader, null, this.dictionaryDir);
        Object stream = new JapaneseWidthFilter((TokenStream)tokenizer);
        stream = new JapanesePunctuationFilter(true, (TokenStream)stream);
        stream = new JapanesePartOfSpeechStopFilter(true, (TokenStream)stream, this.stoptags);
        stream = new StopFilter(this.matchVersion, (TokenStream)stream, (Set)this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            stream = new KeywordMarkerFilter((TokenStream)stream, this.stemExclusionSet);
        }
        stream = new JapaneseBasicFormFilter((TokenStream)stream);
        stream = new JapaneseKatakanaStemFilter((TokenStream)stream);
        stream = new LowerCaseFilter(this.matchVersion, (TokenStream)stream);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET;
        static final Set<String> DEFAULT_STOP_TAGS;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = JapaneseAnalyzer.loadStopwordSet((boolean)false, (Class)JapaneseAnalyzer.class, (String)"stopwords_ja.txt", (String)"#");
                CharArraySet tagset = JapaneseAnalyzer.loadStopwordSet((boolean)false, (Class)JapaneseAnalyzer.class, (String)"stoptags_ja.txt", (String)"#");
                DEFAULT_STOP_TAGS = new HashSet<String>();
                for (Object element : tagset) {
                    char[] chars = (char[])element;
                    DEFAULT_STOP_TAGS.add(new String(chars));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

