/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedToken;
import org.languagetool.rules.patterns.PatternToken;

public class PatternTokenTest {
    @Test
    public void testSentenceStart() {
        PatternToken patternToken = new PatternToken("", false, false, false);
        patternToken.setPosToken(new PatternToken.PosToken("SENT_START", false, false));
        Assert.assertTrue((boolean)patternToken.isSentenceStart());
        patternToken.setPosToken(new PatternToken.PosToken("SENT_START", false, true));
        Assert.assertFalse((boolean)patternToken.isSentenceStart());
        patternToken.setPosToken(new PatternToken.PosToken("SENT_START", true, false));
        Assert.assertTrue((boolean)patternToken.isSentenceStart());
        patternToken.setPosToken(new PatternToken.PosToken("SENT_START", true, true));
        Assert.assertFalse((boolean)patternToken.isSentenceStart());
        PatternToken patternToken2 = new PatternToken("bla|blah", false, true, false);
        patternToken2.setPosToken(new PatternToken.PosToken("foo", true, true));
        Assert.assertFalse((boolean)patternToken2.isSentenceStart());
    }

    @Test
    public void testUnknownTag() {
        PatternToken patternToken = new PatternToken("", false, false, false);
        patternToken.setPosToken(new PatternToken.PosToken("UNKNOWN", false, false));
        PatternToken patternToken2 = new PatternToken("", false, false, false);
        patternToken2.setPosToken(new PatternToken.PosToken("UNKNOWN", false, true));
        PatternToken patternToken3 = new PatternToken("", false, false, false);
        patternToken3.setPosToken(new PatternToken.PosToken("UNKNOWN|VBG", true, false));
        PatternToken patternToken4 = new PatternToken("", false, false, false);
        patternToken4.setPosToken(new PatternToken.PosToken("UNKNOWN|VBG", true, true));
        PatternToken patternToken5 = new PatternToken("\\p{Ll}+", false, true, false);
        patternToken5.setPosToken(new PatternToken.PosToken("UNKNOWN", false, false));
        AnalyzedToken an = new AnalyzedToken("schword", null, null);
        Assert.assertTrue((boolean)patternToken.isMatched(an));
        Assert.assertFalse((boolean)patternToken2.isMatched(an));
        Assert.assertTrue((boolean)patternToken3.isMatched(an));
        Assert.assertFalse((boolean)patternToken4.isMatched(an));
        Assert.assertTrue((boolean)patternToken5.isMatched(an));
        an.setNoPOSTag(false);
        Assert.assertFalse((boolean)patternToken.isMatched(an));
        Assert.assertTrue((boolean)patternToken2.isMatched(an));
        Assert.assertFalse((boolean)patternToken3.isMatched(an));
        Assert.assertTrue((boolean)patternToken4.isMatched(an));
        Assert.assertFalse((boolean)patternToken5.isMatched(an));
        AnalyzedToken anSentEnd = new AnalyzedToken("schword", "SENT_END", null);
        Assert.assertTrue((boolean)patternToken.isMatched(anSentEnd));
        Assert.assertFalse((boolean)patternToken2.isMatched(anSentEnd));
        Assert.assertTrue((boolean)patternToken3.isMatched(anSentEnd));
        Assert.assertFalse((boolean)patternToken4.isMatched(anSentEnd));
        Assert.assertTrue((boolean)patternToken5.isMatched(anSentEnd));
        PatternToken patternToken6 = new PatternToken("\\p{Ll}+", false, true, false);
        patternToken6.setPosToken(new PatternToken.PosToken("SENT_END", false, false));
        Assert.assertTrue((boolean)patternToken6.isMatched(anSentEnd));
        PatternToken patternToken7 = new PatternToken("\\p{Ll}+", false, true, false);
        patternToken7.setPosToken(new PatternToken.PosToken("SENT_END|BLABLA", true, false));
        Assert.assertTrue((boolean)patternToken7.isMatched(anSentEnd));
        anSentEnd.setNoPOSTag(false);
        Assert.assertFalse((boolean)patternToken.isMatched(anSentEnd));
        Assert.assertTrue((boolean)patternToken2.isMatched(anSentEnd));
        Assert.assertFalse((boolean)patternToken3.isMatched(anSentEnd));
        Assert.assertTrue((boolean)patternToken4.isMatched(anSentEnd));
        Assert.assertFalse((boolean)patternToken5.isMatched(anSentEnd));
        AnalyzedToken anParaEnd = new AnalyzedToken("schword", "PARA_END", null);
        Assert.assertTrue((boolean)patternToken.isMatched(anParaEnd));
        Assert.assertFalse((boolean)patternToken2.isMatched(anParaEnd));
        Assert.assertTrue((boolean)patternToken3.isMatched(anParaEnd));
        Assert.assertFalse((boolean)patternToken4.isMatched(anParaEnd));
        Assert.assertTrue((boolean)patternToken5.isMatched(anParaEnd));
        anParaEnd.setNoPOSTag(false);
        Assert.assertFalse((boolean)patternToken.isMatched(anParaEnd));
        Assert.assertTrue((boolean)patternToken2.isMatched(anParaEnd));
        Assert.assertFalse((boolean)patternToken3.isMatched(anParaEnd));
        Assert.assertTrue((boolean)patternToken4.isMatched(anParaEnd));
        Assert.assertFalse((boolean)patternToken5.isMatched(anParaEnd));
        AnalyzedToken anWithPOS = new AnalyzedToken("schword", "POS", null);
        Assert.assertFalse((boolean)patternToken.isMatched(anWithPOS));
        Assert.assertTrue((boolean)patternToken2.isMatched(anWithPOS));
        Assert.assertFalse((boolean)patternToken3.isMatched(anWithPOS));
        Assert.assertTrue((boolean)patternToken4.isMatched(anWithPOS));
        Assert.assertFalse((boolean)patternToken5.isMatched(anWithPOS));
    }
}

