# -*- coding: binary -*-
require 'rex/post/meterpreter/extensions/stdapi/railgun/win_const_manager'
require 'thread'

module Rex
module Post
module Meterpreter
module Extensions
module Stdapi
module Railgun

#
# A container holding useful Windows API Constants.
#
class ApiConstants

  # This will be lazily loaded in self.manager
  @@manager = nil

  # Mutex to ensure we don't add constants more than once via thread races.
  @@manager_semaphore = Mutex.new

  #
  # Provides a frozen constant manager for the constants defined in
  # self.add_constants
  #
  def self.manager

    # The first check for nil is to potentially skip the need to synchronize
    if @@manager.nil?
      # Looks like we MAY need to load manager
      @@manager_semaphore.synchronize do
        # We check once more. Now our options are synchronized
        if @@manager.nil?
          @@manager = WinConstManager.new

          self.add_constants(@@manager)

          @@manager.freeze
        end
      end
    end

    return @@manager
  end

  #
  # Slurp in a giant list of known constants.
  #
  def self.add_constants(win_const_mgr)
    win_const_mgr.add_const('HWND_BROADCAST',0x00000FFFF)
    win_const_mgr.add_const('MCI_DGV_SETVIDEO_TINT',0x00004003)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_PROCESS',0x00000001)
    win_const_mgr.add_const('TF_LBI_TOOLTIP',0x00000004)
    win_const_mgr.add_const('CM_DRP_CLASSGUID',0x00000009)
    win_const_mgr.add_const('SYMMETRICWRAPKEYBLOB',0x0000000B)
    win_const_mgr.add_const('FKF_AVAILABLE',0x00000002)
    win_const_mgr.add_const('LINE_AGENTSTATUSEX',0x0000001D)
    win_const_mgr.add_const('REGDF_GENFORCEDCONFIG',0x00000020)
    win_const_mgr.add_const('ERROR_INSTALL_PACKAGE_REJECTED',0x00000659)
    win_const_mgr.add_const('AM_DVD_SECTOR_PROTECTED',0x00000020)
    win_const_mgr.add_const('BTH_ERROR_PAIRING_NOT_ALLOWED',0x00000018)
    win_const_mgr.add_const('CMSG_HASH_DATA_PARAM',0x00000015)
    win_const_mgr.add_const('DNS_ERROR_INCONSISTENT_ROOT_HINTS',0x0000255D)
    win_const_mgr.add_const('HSE_VECTOR_ELEMENT_TYPE_MEMORY_BUFFER',0x00000000)
    win_const_mgr.add_const('TASK_LAST_WEEK',0x00000005)
    win_const_mgr.add_const('DISPID_COLLECTION_RESERVED_MAX',0x000007FF)
    win_const_mgr.add_const('MSIM_DISPID_ONSESSIONMEMBERLEAVE',0x00000E0D)
    win_const_mgr.add_const('WPWIZ_ERROR_PROV_QI',0xC0042002)
    win_const_mgr.add_const('FLICK_WM_HANDLED_MASK',0x00000001)
    win_const_mgr.add_const('NS_NISPLUS',0x0000002A)
    win_const_mgr.add_const('WM_SYSCHAR',0x00000106)
    win_const_mgr.add_const('NDR_MAJOR_VERSION',0x00000005)
    win_const_mgr.add_const('SPPSR_ENUM_ADV_DEVICE_PROPERTIES',0x00000003)
    win_const_mgr.add_const('ICC_PAGESCROLLER_CLASS',0x00001000)
    win_const_mgr.add_const('SUBLANG_CORSICAN_FRANCE',0x00000001)
    win_const_mgr.add_const('IMAGE_REL_IA64_PCREL60X',0x00000015)
    win_const_mgr.add_const('MD_WARNING_SAVE_FAILED',0x000CC809)
    win_const_mgr.add_const('GIL_CHECKSHIELD',0x00000200)
    win_const_mgr.add_const('DDE_FDEFERUPD',0x00004000)
    win_const_mgr.add_const('OS_NT4ORGREATER',0x00000003)
    win_const_mgr.add_const('DISK_LOGGING_DUMP',0x00000002)
    win_const_mgr.add_const('IMAGE_SIZEOF_SYMBOL',0x00000012)
    win_const_mgr.add_const('LVS_EX_HIDELABELS',0x00020000)
    win_const_mgr.add_const('DBT_VOLLOCKUNLOCKFAILED',0x00008046)
    win_const_mgr.add_const('WM_GETICON',0x0000007F)
    win_const_mgr.add_const('SEC_WINNT_AUTH_IDENTITY_VERSION',0x00000200)
    win_const_mgr.add_const('USER_MARSHAL_FC_USMALL',0x00000004)
    win_const_mgr.add_const('INTERNET_OPTION_HANDLE_TYPE',0x00000009)
    win_const_mgr.add_const('MCGIP_CALENDARBODY',0x00000006)
    win_const_mgr.add_const('EVENT_SYSTEM_DIALOGEND',0x00000011)
    win_const_mgr.add_const('MFOUTPUTATTRIBUTE_SOFTWARE',0x00000010)
    win_const_mgr.add_const('IMAGEHLP_GET_TYPE_INFO_CHILDREN',0x00000002)
    win_const_mgr.add_const('MCI_CD_OFFSET',0x00000440)
    win_const_mgr.add_const('CRED_MAX_DOMAIN_TARGET_NAME_LENGTH',0x00000100)
    win_const_mgr.add_const('ERROR_DS_SIZELIMIT_EXCEEDED',0x00002023)
    win_const_mgr.add_const('ACPI_PPM_SOFTWARE_ANY',0x000000FD)
    win_const_mgr.add_const('DM_PELSHEIGHT',0x00100000)
    win_const_mgr.add_const('EVENT_TRACE_CONTROL_STOP',0x00000001)
    win_const_mgr.add_const('BTH_ERROR_QOS_IS_NOT_SUPPORTED',0x00000027)
    win_const_mgr.add_const('DISPID_IWBSCRIPTCONTROL_VERSION',0x00000008)
    win_const_mgr.add_const('CLONE_FLAG_ENTITY',0x00000004)
    win_const_mgr.add_const('IP_UNICAST_IF',0x0000001F)
    win_const_mgr.add_const('LDAP_OPT_VERSION',0x00000011)
    win_const_mgr.add_const('CLUSAPI_CHANGE_ACCESS',0x00000002)
    win_const_mgr.add_const('SND_NOSTOP',0x00000010)
    win_const_mgr.add_const('L2_NOTIFICATION_SOURCE_ALL',0x00000000)
    win_const_mgr.add_const('IDM_SIZETOCONTROLHEIGHT',0x00000024)
    win_const_mgr.add_const('CTRY_CANADA',0x00000002)
    win_const_mgr.add_const('FWPM_ACTRL_CLASSIFY',0x00000010)
    win_const_mgr.add_const('SERVICE_STOP_REASON_FLAG_CUSTOM',0x20000000)
    win_const_mgr.add_const('DN_MOVED',0x00001000)
    win_const_mgr.add_const('RPC_S_ENTRY_TYPE_MISMATCH',0x00000782)
    win_const_mgr.add_const('DMBIN_LARGECAPACITY',0x0000000B)
    win_const_mgr.add_const('SOUND_SYSTEM_BEEP',0x00000003)
    win_const_mgr.add_const('SQL_FD_FETCH_ABSOLUTE',0x00000010)
    win_const_mgr.add_const('COLOR_HIGHLIGHTTEXT',0x0000000E)
    win_const_mgr.add_const('CTRY_SAUDI_ARABIA',0x000003C6)
    win_const_mgr.add_const('DEBUG_FILTER_GO_HANDLED',0x00000000)
    win_const_mgr.add_const('CR_FLG_RENEWAL',0x00000002)
    win_const_mgr.add_const('DDOVERZ_INSERTINBACKOF',0x00000005)
    win_const_mgr.add_const('PARITY_MARK',0x00000800)
    win_const_mgr.add_const('SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_CYRILLIC',0x00000008)
    win_const_mgr.add_const('MSSIP_FLAGS_USE_CATALOG',0x00020000)
    win_const_mgr.add_const('PSINJECT_SHOWPAGE',0x00000069)
    win_const_mgr.add_const('TMT_GLYPHINDEX',0x00000972)
    win_const_mgr.add_const('OID_FDDI_MAC_FRAME_ERROR_FLAG',0x0303024C)
    win_const_mgr.add_const('PAN_SERIF_OBTUSE_SQUARE_COVE',0x00000005)
    win_const_mgr.add_const('JOYCAPS_HASPOV',0x00000010)
    win_const_mgr.add_const('WAVE_FORMAT_96S16',0x00080000)
    win_const_mgr.add_const('LVS_ALIGNTOP',0x00000000)
    win_const_mgr.add_const('SUBLANG_ALSATIAN_FRANCE',0x00000001)
    win_const_mgr.add_const('SQL_DL_SQL92_TIME',0x00000002)
    win_const_mgr.add_const('LANG_FAEROESE',0x00000038)
    win_const_mgr.add_const('SQL_QUALIFIER_NAME_SEPARATOR',0x00000029)
    win_const_mgr.add_const('DNS_TYPE_SINK',0x00000028)
    win_const_mgr.add_const('FD_QOS',0x00000001)
    win_const_mgr.add_const('EXCEPTION_MAXIMUM_PARAMETERS',0x0000000F)
    win_const_mgr.add_const('ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE',0x000036C2)
    win_const_mgr.add_const('SUBLANG_PORTUGUESE',0x00000002)
    win_const_mgr.add_const('POST_CHECK_CACHE_ENTRY',0x20000000)
    win_const_mgr.add_const('IMAGE_DEBUG_TYPE_EXCEPTION',0x00000005)
    win_const_mgr.add_const('AUDIT_ENUMERATE_USERS',0x00000010)
    win_const_mgr.add_const('ALT4KB_BASE',0x6FC00000000)
    win_const_mgr.add_const('DIRID_COMMON_TEMPLATES',0x0000402D)
    win_const_mgr.add_const('MCI_DGV_INFO_TEXT',0x00010000)
    win_const_mgr.add_const('OPTION_REBIND_TIME',0x0000003B)
    win_const_mgr.add_const('WM_COMPAREITEM',0x00000039)
    win_const_mgr.add_const('TAPE_DRIVE_SET_REPORT_SMKS',0x80000800)
    win_const_mgr.add_const('RPC_X_SS_HANDLES_MISMATCH',0x000006F2)
    win_const_mgr.add_const('CRYPT_OCSP_ONLY_RETRIEVAL',0x01000000)
    win_const_mgr.add_const('PRINT_PROP_FORCE_NAME',0x00000001)
    win_const_mgr.add_const('DISPID_LISTITEM',0x00000000)
    win_const_mgr.add_const('DEVICE_STATE_DISABLED',0x00000002)
    win_const_mgr.add_const('NAP_BIT_OFFSET',0x00000008)
    win_const_mgr.add_const('SERVICE_CTRL_PAUSE',0x00000001)
    win_const_mgr.add_const('SECURITY_WORLD_RID',0x00000000)
    win_const_mgr.add_const('PPP_LCP_ACFC',0x00000004)
    win_const_mgr.add_const('DRMHSESSION_INVALID',0x00000000)
    win_const_mgr.add_const('FEI_MODEM_POWERED_OFF',0x00000012)
    win_const_mgr.add_const('VK_TAB',0x00000009)
    win_const_mgr.add_const('DNS_RTYPE_AXFR',0x00000000)
    win_const_mgr.add_const('IDD_UPDATELINKS',0x000003EF)
    win_const_mgr.add_const('SNMP_ERROR_READONLY',0x00000004)
    win_const_mgr.add_const('CMSG_KEY_TRANS_RECIPIENT',0x00000001)
    win_const_mgr.add_const('UISF_HIDEACCEL',0x00000002)
    win_const_mgr.add_const('WTPF_OFFLINEOK_COM',0x00000800)
    win_const_mgr.add_const('WPF_NO_VERIFY_POST',0x00000080)
    win_const_mgr.add_const('CERT_STORE_PROV_CONTROL_FUNC',0x0000000D)
    win_const_mgr.add_const('INTERNET_HANDLE_TYPE_CONNECT_GOPHER',0x00000003)
    win_const_mgr.add_const('CB_GETEDITSEL',0x00000140)
    win_const_mgr.add_const('SFGAO_NONENUMERATED',0x00100000)
    win_const_mgr.add_const('XP1_SUPPORT_BROADCAST',0x00000200)
    win_const_mgr.add_const('STI_HW_CONFIG_SCSI',0x00000002)
    win_const_mgr.add_const('CSS_ENABLETEMPLATE',0x00000020)
    win_const_mgr.add_const('SEMAPHORE_MODIFY_STATE',0x00000002)
    win_const_mgr.add_const('OLEUI_CANCEL',0x00000002)
    win_const_mgr.add_const('RIM_TYPEHID',0x00000002)
    win_const_mgr.add_const('MCI_VCR_GETDEVCAPS_HAS_CLOCK',0x00004003)
    win_const_mgr.add_const('D3DPTFILTERCAPS_MAGFGAUSSIANQUAD',0x10000000)
    win_const_mgr.add_const('SORT_JAPANESE_RADICALSTROKE',0x00000004)
    win_const_mgr.add_const('RSC_FLAG_QUIET',0x00000004)
    win_const_mgr.add_const('ERROR_CLIPPING_NOT_SUPPORTED',0x000007D5)
    win_const_mgr.add_const('XINPUT_GAMEPAD_BACK',0x00000020)
    win_const_mgr.add_const('CERT_DECIPHER_ONLY_KEY_USAGE',0x00000080)
    win_const_mgr.add_const('ERROR_TRANSACTION_REQUEST_NOT_VALID',0x00001A2E)
    win_const_mgr.add_const('CRYPTNET_URL_CACHE_DEFAULT_FLUSH',0x00000000)
    win_const_mgr.add_const('CRYPTDLG_REVOCATION_ONLINE',0x80000000)
    win_const_mgr.add_const('APPCOMMAND_BROWSER_STOP',0x00000004)
    win_const_mgr.add_const('DIF_ADDPROPERTYPAGE_ADVANCED',0x00000023)
    win_const_mgr.add_const('SV_ENFORCEKERBEROSREAUTHENTICATION_PARMNUM',0x00000257)
    win_const_mgr.add_const('TLMENUF_FORE',0x00000020)
    win_const_mgr.add_const('UIS_SET',0x00000001)
    win_const_mgr.add_const('FEI_BUSY',0x00000005)
    win_const_mgr.add_const('DMI_MASK',0x00000001)
    win_const_mgr.add_const('WINHTTP_QUERY_CONTENT_TYPE',0x00000001)
    win_const_mgr.add_const('DISPID_IWEBBRIDGE_SCROLLBAR',0x00000002)
    win_const_mgr.add_const('DN_HAS_MARK',0x00000200)
    win_const_mgr.add_const('IN_CLASSD_NET',0x00000000)
    win_const_mgr.add_const('ERROR_REDIRECTOR_HAS_OPEN_HANDLES',0x00000702)
    win_const_mgr.add_const('FP_MD_ID_BEGIN_RESERVED',0x00008000)
    win_const_mgr.add_const('IDD_DYNAWIZ_INSTALLDETECTEDDEVS_PAGE',0x0000271B)
    win_const_mgr.add_const('DISPID_IMULTISESSION_STARTSECTOROFPREVIOUSSESSION',0x00000201)
    win_const_mgr.add_const('TRUSTEE_ACCESS_READ',0x00000002)
    win_const_mgr.add_const('LNH_16_CPU',0x00000031)
    win_const_mgr.add_const('DISPID_IDISCRECORDER2_EJECTMEDIA',0x00000100)
    win_const_mgr.add_const('NS_DNS',0x0000000C)
    win_const_mgr.add_const('SE_ADT_PARAMETERS_SEND_TO_LSA',0x00000002)
    win_const_mgr.add_const('CFM_SMALLCAPS',0x00000040)
    win_const_mgr.add_const('DISPID_COMMANDSTATECHANGE',0x00000069)
    win_const_mgr.add_const('TBS_BOTH',0x00000008)
    win_const_mgr.add_const('IF_TYPE_IPFORWARD',0x0000008E)
    win_const_mgr.add_const('PIPE_CLIENT_END',0x00000000)
    win_const_mgr.add_const('ERROR_SXS_UNTRANSLATABLE_HRESULT',0x000036FD)
    win_const_mgr.add_const('DS_REPADD_SELECT_SECRETS',0x00001000)
    win_const_mgr.add_const('DICS_FLAG_CONFIGSPECIFIC',0x00000002)
    win_const_mgr.add_const('DSOP_SCOPE_FLAG_WANT_PROVIDER_LDAP',0x00000004)
    win_const_mgr.add_const('ISOLATIONAWARE_MANIFEST_RESOURCE_ID',0x00000002)
    win_const_mgr.add_const('WINHTTP_OPTION_RESOLVE_TIMEOUT',0x00000002)
    win_const_mgr.add_const('NS_DHCP',0x00000006)
    win_const_mgr.add_const('CMSG_VERSION_PARAM',0x0000001E)
    win_const_mgr.add_const('ERROR_INVALID_AT_INTERRUPT_TIME',0x00000068)
    win_const_mgr.add_const('ICDRAW_UPDATE',0x40000000)
    win_const_mgr.add_const('X3_TMPLT_INST_WORD_X',0x00000000)
    win_const_mgr.add_const('PST_KEY_CURRENT_USER',0x00000000)
    win_const_mgr.add_const('FLAG_ASSUME_COMP_WQLFILTER_TRUE',0x02000000)
    win_const_mgr.add_const('CMSG_MAIL_LIST_ENCRYPT_FREE_OBJID_FLAG',0x00000002)
    win_const_mgr.add_const('CM_PROB_MOVED',0x00000019)
    win_const_mgr.add_const('APD_STRICT_UPGRADE',0x00000001)
    win_const_mgr.add_const('KAGPROPVAL_CONCUR_LOCK',0x00000004)
    win_const_mgr.add_const('TRBN_LAST',0x00000000)
    win_const_mgr.add_const('DXVA_BITSTREAM_CONCEALMENT_NEED_LIKELY',0x00000002)
    win_const_mgr.add_const('MDM_MASK_PROTOCOLDATA',0x00000000)
    win_const_mgr.add_const('VPDF_FORCEAPM10MODE',0x00000002)
    win_const_mgr.add_const('DDCKEYCAPS_DESTOVERLAYONEACTIVE',0x00000080)
    win_const_mgr.add_const('IDM_ALIGNBOTTOM',0x00000001)
    win_const_mgr.add_const('PDCAP_WAKE_FROM_S1_SUPPORTED',0x00200000)
    win_const_mgr.add_const('RESOURCEDISPLAYTYPE_NDSCONTAINER',0x0000000B)
    win_const_mgr.add_const('MAX_NOTIFICATION_DATA',0x00000040)
    win_const_mgr.add_const('MDM_SHIFT_HDLCPPP_SPEED',0x00000000)
    win_const_mgr.add_const('SQL_COLUMN_LENGTH',0x00000003)
    win_const_mgr.add_const('IMAGE_REL_SH3_TOKEN',0x00000012)
    win_const_mgr.add_const('LINECALLSTATE_UNKNOWN',0x00008000)
    win_const_mgr.add_const('SKF_LCTLLOCKED',0x00040000)
    win_const_mgr.add_const('DOT11_STATUS_ENCRYPTION_FAILED',0x00000200)
    win_const_mgr.add_const('IDC_GP_OBJECTSIZE',0x000003F3)
    win_const_mgr.add_const('COMMON_LVB_LEADING_BYTE',0x00000100)
    win_const_mgr.add_const('GAA_FLAG_SKIP_DNS_SERVER',0x00000008)
    win_const_mgr.add_const('DNF_UNUSED_28',0x10000000)
    win_const_mgr.add_const('DNF_UNUSED_27',0x08000000)
    win_const_mgr.add_const('DNF_UNUSED_26',0x04000000)
    win_const_mgr.add_const('SCARD_E_NO_SUCH_CERTIFICATE',0x8010002C)
    win_const_mgr.add_const('DNF_UNUSED_24',0x01000000)
    win_const_mgr.add_const('DNF_UNUSED_23',0x00800000)
    win_const_mgr.add_const('DNF_UNUSED_22',0x00400000)
    win_const_mgr.add_const('DNF_UNUSED_21',0x00200000)
    win_const_mgr.add_const('URLACTION_FEATURE_ZONE_ELEVATION',0x00002101)
    win_const_mgr.add_const('ISDB_ITT_TID',0x000000D2)
    win_const_mgr.add_const('GESTURE_BRACE_LEFT',0x00000000)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_COLLATIONS',0x00000003)
    win_const_mgr.add_const('CR_NO_SUCH_DEVICE_INTERFACE',0x00000037)
    win_const_mgr.add_const('MCI_DGV_STATUS_VOLUME',0x00004019)
    win_const_mgr.add_const('JIFMK_RST0',0x0000FFD0)
    win_const_mgr.add_const('DDCKEYCAPS_SRCBLTCLRSPACE',0x00000400)
    win_const_mgr.add_const('JIFMK_RST2',0x0000FFD2)
    win_const_mgr.add_const('JIFMK_RST5',0x0000FFD5)
    win_const_mgr.add_const('JIFMK_RST4',0x0000FFD4)
    win_const_mgr.add_const('JIFMK_RST7',0x0000FFD7)
    win_const_mgr.add_const('JIFMK_RST6',0x0000FFD6)
    win_const_mgr.add_const('LVCDRF_NOGROUPFRAME',0x00020000)
    win_const_mgr.add_const('LOCALE_SNATIVELANGNAME',0x00000004)
    win_const_mgr.add_const('LINEERR_INVALCONSULTCALLHANDLE',0x80000021)
    win_const_mgr.add_const('DDBLT_ZBUFFERDESTCONSTOVERRIDE',0x00100000)
    win_const_mgr.add_const('RF_SHOW_EVENTS',0x00800000)
    win_const_mgr.add_const('WM_MDIMAXIMIZE',0x00000225)
    win_const_mgr.add_const('RAS_EAP_FLAG_FIRST_LINK',0x00000010)
    win_const_mgr.add_const('NCBNAMSZ',0x00000010)
    win_const_mgr.add_const('CRR_ACTIVATION_LIMIT',0xFFFFFFFE)
    win_const_mgr.add_const('DB_PROT_LEVEL_CONNECT',0x00000001)
    win_const_mgr.add_const('INTERNET_CACHE_FLAG_ALLOW_COLLISIONS',0x00000100)
    win_const_mgr.add_const('DSA_NEWOBJ_CTX_PRECOMMIT',0x00000001)
    win_const_mgr.add_const('VER_SUITE_BACKOFFICE',0x00000004)
    win_const_mgr.add_const('WHITEBALANCE_ONEPUSH_AUTO',0x00000003)
    win_const_mgr.add_const('IMAGE_SYM_TYPE_STRUCT',0x00000008)
    win_const_mgr.add_const('LINEMEDIAMODE_AUTOMATEDVOICE',0x00000008)
    win_const_mgr.add_const('SFC_DISABLE_ONCE',0x00000002)
    win_const_mgr.add_const('IMAGE_REL_SH3_PCREL12_WORD',0x0000000B)
    win_const_mgr.add_const('PTE_ACCESS',0x00000005)
    win_const_mgr.add_const('SQL_SQL92_NUMERIC_VALUE_FUNCTIONS',0x0000009F)
    win_const_mgr.add_const('WIA_IPC_THUMBNAIL',0x00001402)
    win_const_mgr.add_const('D3D10_EFFECT_VARIABLE_ANNOTATION',0x00000001)
    win_const_mgr.add_const('OBM_OLD_CLOSE',0x00007FFF)
    win_const_mgr.add_const('IPP_E_FILENOTDIRTY',0xC0048004)
    win_const_mgr.add_const('IF_TYPE_HSSI',0x0000002E)
    win_const_mgr.add_const('SQL_MAX_PROCEDURE_NAME_LEN',0x00000021)
    win_const_mgr.add_const('ERROR_SXS_SETTING_NOT_REGISTERED',0x0000371A)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_ERROR',0x000035F8)
    win_const_mgr.add_const('ACM_FORMATENUMF_NCHANNELS',0x00020000)
    win_const_mgr.add_const('CCS_ADJUSTABLE',0x00000020)
    win_const_mgr.add_const('ZERO_PADDING',0x00000003)
    win_const_mgr.add_const('ASC_REQ_IDENTIFY',0x00080000)
    win_const_mgr.add_const('D3DDEVCAPS_TEXTURENONLOCALVIDMEM',0x00001000)
    win_const_mgr.add_const('MAXD3DDECLLENGTH',0x00000040)
    win_const_mgr.add_const('MAXD3DDECLUSAGEINDEX',0x0000000F)
    win_const_mgr.add_const('META_SETPOLYFILLMODE',0x00000106)
    win_const_mgr.add_const('SKF_CONFIRMHOTKEY',0x00000008)
    win_const_mgr.add_const('DTR_KIPCR2_INDEX',0x00000004)
    win_const_mgr.add_const('DIF_MOVEDEVICE',0x0000000E)
    win_const_mgr.add_const('RESERVED',0x80000000)
    win_const_mgr.add_const('ERROR_INVALID_OPERATION_ON_QUORUM',0x000013CC)
    win_const_mgr.add_const('RI_MOUSE_WHEEL',0x00000400)
    win_const_mgr.add_const('TMT_EDGESHADOWCOLOR',0x00000EDE)
    win_const_mgr.add_const('SYMFLAG_THUNK',0x00002000)
    win_const_mgr.add_const('BITS_MC_STATE_FILE_CORRUPT',0x80194007)
    win_const_mgr.add_const('PSR_MBZ1_V',0x00000001)
    win_const_mgr.add_const('PAN_PROP_MODERN',0x00000003)
    win_const_mgr.add_const('SMC_AUTOEXPANDCHANGE',0x00000042)
    win_const_mgr.add_const('WSB_PROP_CXHSCROLL',0x00000002)
    win_const_mgr.add_const('JRO_VERSION',0x00000002)
    win_const_mgr.add_const('SPSVCINST_TAGTOFRONT',0x00000001)
    win_const_mgr.add_const('IDTB_TOC_PREV',0x000000E0)
    win_const_mgr.add_const('IDC_VP_ASICON',0x000003EB)
    win_const_mgr.add_const('CM_DISABLE_BITS',0x00000007)
    win_const_mgr.add_const('SORTED_CTL_EXT_FLAGS_OFFSET',0x00000000)
    win_const_mgr.add_const('IPP_E_FIRST',0x40048000)
    win_const_mgr.add_const('SQL_MORE_INFO_YES',0x00000001)
    win_const_mgr.add_const('IASSEMBLYCACHE_UNINSTALL_DISPOSITION_REFERENCE_NOT_FOUND',0x00000006)
    win_const_mgr.add_const('WLX_OPTION_IGNORE_AUTO_LOGON',0x00000008)
    win_const_mgr.add_const('SCRIPTPROP_HOSTSTACKREQUIRED',0x00001003)
    win_const_mgr.add_const('HC_SKIP',0x00000002)
    win_const_mgr.add_const('INTERNET_OPTION_KEEP_CONNECTION',0x00000016)
    win_const_mgr.add_const('HHWIN_BUTTON_FORWARD',0x00000001)
    win_const_mgr.add_const('DFM_INVOKECOMMAND',0x00000002)
    win_const_mgr.add_const('CB_SETHORIZONTALEXTENT',0x00000015)
    win_const_mgr.add_const('ERROR_MEDIA_NOT_AVAILABLE',0x000010DE)
    win_const_mgr.add_const('ERROR_IPSEC_MM_FILTER_PENDING_DELETION',0x000032DA)
    win_const_mgr.add_const('UF_PARTIAL_SECRETS_ACCOUNT',0x04000000)
    win_const_mgr.add_const('EXPOSUREMETERING_CENTERSPOT',0x00000004)
    win_const_mgr.add_const('DISPID_SETVIEWTYPE',0x00000017)
    win_const_mgr.add_const('POLICY_ERRV_GLOBAL_DEF_FLOW_DURATION',0x00000009)
    win_const_mgr.add_const('SV_SRVHEURISTICS_PARMNUM',0x000001AF)
    win_const_mgr.add_const('INCLUDED_TYPES_FCI_FDI',0x00000001)
    win_const_mgr.add_const('WM_NEXTDLGCTL',0x00000028)
    win_const_mgr.add_const('OID_TCP_OFFLOAD_PARAMETERS',0xFC01020C)
    win_const_mgr.add_const('L2CAP_DEFAULT_MTU',0x000002A0)
    win_const_mgr.add_const('SM_CXICON',0x0000000B)
    win_const_mgr.add_const('WMS_STREAM_AVG_BITRATE',0x00000003)
    win_const_mgr.add_const('ALLOCATE_RESPONSE',0x00000002)
    win_const_mgr.add_const('MD_ACCESS_EXECUTE',0x00000004)
    win_const_mgr.add_const('TMT_HEIGHT',0x00000971)
    win_const_mgr.add_const('CERT_IE30_RESERVED_PROP_ID',0x00000007)
    win_const_mgr.add_const('DNS_QUERY_STANDARD',0x00000000)
    win_const_mgr.add_const('SERVICE_QUALITATIVE',0x80200000)
    win_const_mgr.add_const('OID_802_3_MULTICAST_LIST',0x01010103)
    win_const_mgr.add_const('TRUSTEE_ACCESS_ALL',0xFFFFFFFF)
    win_const_mgr.add_const('IMAGE_SCN_NO_DEFER_SPEC_EXC',0x00004000)
    win_const_mgr.add_const('BG_E_TOO_LARGE',0x80200020)
    win_const_mgr.add_const('DISPID_FOCUSCHANGED',0x000000D0)
    win_const_mgr.add_const('DBCOMPUTEMODE_DYNAMIC',0x00000002)
    win_const_mgr.add_const('DNS_TYPE_ADDRS',0x00000000)
    win_const_mgr.add_const('STM_SETICON',0x00000170)
    win_const_mgr.add_const('POLICY_ERRV_SUBNET_GRP_FLOW_DURATION',0x0000000E)
    win_const_mgr.add_const('PRINTER_CHANGE_WRITE_JOB',0x00000800)
    win_const_mgr.add_const('INTERNET_OPTION_DATA_RECEIVE_TIMEOUT',0x00000008)
    win_const_mgr.add_const('KSALLOCATOR_REQUIREMENTF_FRAME_INTEGRITY',0x00000004)
    win_const_mgr.add_const('CSIDL_CDBURN_AREA',0x00000003)
    win_const_mgr.add_const('CMSG_CMS_RECIPIENT_INFO_PARAM',0x00000024)
    win_const_mgr.add_const('NDW_INSTALLFLAG_NODETECTEDDEVS',0x00001000)
    win_const_mgr.add_const('MDM_PROTOCOLID_AUTO',0x00000006)
    win_const_mgr.add_const('SQL_CVT_LONGVARBINARY',0x00040000)
    win_const_mgr.add_const('WM_RESTORE_INDIVIDUALIZE',0x00000002)
    win_const_mgr.add_const('ARRAY_SEP_CHAR',0x00000009)
    win_const_mgr.add_const('ERROR_NO_SAVEPOINT_WITH_OPEN_FILES',0x00001ABA)
    win_const_mgr.add_const('OID_FDDI_SMT_STATION_ACTION',0x03030277)
    win_const_mgr.add_const('OID_PNP_ADD_WAKE_UP_PATTERN',0xFD010103)
    win_const_mgr.add_const('ERROR_NO_USER_KEYS',0x00001776)
    win_const_mgr.add_const('ERROR_ILLEGAL_FLOAT_CONTEXT',0x00000243)
    win_const_mgr.add_const('ISR_TPA',0x00000000)
    win_const_mgr.add_const('DEVPROP_TYPE_INT32',0x00000006)
    win_const_mgr.add_const('SIO_ASSOCIATE_PVC',0x90160003)
    win_const_mgr.add_const('LANG_KAZAK',0x00000003)
    win_const_mgr.add_const('FS_THAI',0x00010000)
    win_const_mgr.add_const('DDOSD_GUID',0x00000001)
    win_const_mgr.add_const('ARW_BOTTOMRIGHT',0x00000001)
    win_const_mgr.add_const('IPSEC_POLICY_FLAG_CLEAR_DF_ON_TUNNEL',0x00000008)
    win_const_mgr.add_const('AE_UAS_MODALS',0x00000002)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_GETSPIFAIL',0x00003621)
    win_const_mgr.add_const('ERROR_DS_DRA_SCHEMA_INFO_SHIP',0x0000215E)
    win_const_mgr.add_const('SE_ADT_PARAMETER_GENERIC_AUDIT',0x00000008)
    win_const_mgr.add_const('MD_EXTLOG_CLIENT_IP',0x00000004)
    win_const_mgr.add_const('MIB_IF_ADMIN_STATUS_DOWN',0x00000002)
    win_const_mgr.add_const('DBPROPVAL_NP_ABOUTTODO',0x00000002)
    win_const_mgr.add_const('OPTION_NON_LOCAL_SOURCE_ROUTING',0x00000014)
    win_const_mgr.add_const('PROP_UPDATE',0x00000002)
    win_const_mgr.add_const('SQL_DATABASE_NAME',0x00000010)
    win_const_mgr.add_const('LINEDIGITMODE_DTMFEND',0x00000004)
    win_const_mgr.add_const('DNS_TYPE_NAPTR',0x00000023)
    win_const_mgr.add_const('LINE_LEN',0x00000100)
    win_const_mgr.add_const('TF_CONVERSIONMODE_FIXED',0x00000800)
    win_const_mgr.add_const('EDITF_ATTRIBUTESUBJECTALTNAME2',0x00040000)
    win_const_mgr.add_const('SES_USEAIMM',0x00000040)
    win_const_mgr.add_const('ERROR_INSTALL_PACKAGE_INVALID',0x00000654)
    win_const_mgr.add_const('SQL_TXN_SERIALIZABLE',0x00000008)
    win_const_mgr.add_const('CRYPT_OID_INFO_SIGN_KEY',0x00000004)
    win_const_mgr.add_const('CAPATHLENGTH_INFINITE',0x00000000)
    win_const_mgr.add_const('SUBLANG_ENGLISH_NZ',0x00000005)
    win_const_mgr.add_const('SHGFI_SMALLICON',0x00000001)
    win_const_mgr.add_const('BTH_ERROR_UNSPECIFIED_ERROR',0x00000001)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_PROCESS_ERR_NONCE',0x0000360F)
    win_const_mgr.add_const('ISFB_MASK_BKCOLOR',0x00000002)
    win_const_mgr.add_const('EVENT_TRACE_FILE_MODE_NEWFILE',0x00000008)
    win_const_mgr.add_const('MCI_DGV_PUT_SOURCE',0x00020000)
    win_const_mgr.add_const('SEE_MASK_CLASSNAME',0x00000001)
    win_const_mgr.add_const('SQL_CONCURRENCY',0x00000007)
    win_const_mgr.add_const('CCHCCTEXT',0x00000100)
    win_const_mgr.add_const('XINPUT_GAMEPAD_DPAD_DOWN',0x00000002)
    win_const_mgr.add_const('DS_REPL_NBR_RETURN_OBJECT_PARENTS',0x00000800)
    win_const_mgr.add_const('DBPROPVAL_PT_PGUID_NAME',0x00000020)
    win_const_mgr.add_const('OBM_CHECK',0x00007FF8)
    win_const_mgr.add_const('ICW_FULL_SMARTSTART',0x00000800)
    win_const_mgr.add_const('SPDSL_DISALLOW_NEGATIVE_ADJUST',0x00000002)
    win_const_mgr.add_const('LINEERR_NODEVICE',0x80000042)
    win_const_mgr.add_const('ERRCLASS_ALREADY',0x0000000C)
    win_const_mgr.add_const('META_OFFSETWINDOWORG',0x0000020F)
    win_const_mgr.add_const('PICTYPE_BITMAP',0x00000001)
    win_const_mgr.add_const('MCI_VCR_STATUS_COUNTER_RESOLUTION',0x00004011)
    win_const_mgr.add_const('FS_BAD_ADDRESS',0x20000100)
    win_const_mgr.add_const('DXVA_DEBLOCKING_CONTROL_BUFFER',0x00000004)
    win_const_mgr.add_const('WINHTTP_FLAG_NULL_CODEPAGE',0x00000008)
    win_const_mgr.add_const('ACMFORMATCHOOSE_STYLEF_SHOWHELP',0x00000004)
    win_const_mgr.add_const('CHANGER_PREDISMOUNT_ALIGN_TO_SLOT',0x80000001)
    win_const_mgr.add_const('DDOSD_COMPRESSION_RATIO',0x00000002)
    win_const_mgr.add_const('MD_CPU_ENABLE_KERNEL_TIME',0x00000008)
    win_const_mgr.add_const('CERT_KEY_SPEC_PROP_ID',0x00000006)
    win_const_mgr.add_const('NETE_TOOMANYCONN',0x00000005)
    win_const_mgr.add_const('OBM_ZOOMD',0x00007FE9)
    win_const_mgr.add_const('OLEUI_QUERY_LINKBROKEN',0x0000FF01)
    win_const_mgr.add_const('OID_802_11_PMKID',0x0D010123)
    win_const_mgr.add_const('DEVPROP_TYPE_SBYTE',0x00000002)
    win_const_mgr.add_const('PORT_FINGER',0x0000004F)
    win_const_mgr.add_const('SB_ENDSCROLL',0x00000008)
    win_const_mgr.add_const('FILE_DEVICE_8042_PORT',0x00000027)
    win_const_mgr.add_const('MPEG2_PROGRAM_ELEMENTARY_STREAM',0x00000001)
    win_const_mgr.add_const('ERROR_NO_VOLUME_ID',0x00000495)
    win_const_mgr.add_const('SECURITY_FLAG_IGNORE_REVOCATION',0x00000080)
    win_const_mgr.add_const('RECOFLAG_COERCE',0x00000002)
    win_const_mgr.add_const('PIDSI_GENRE',0x0000000B)
    win_const_mgr.add_const('MDPROPVAL_NME_MEASURESONLY',0x00000001)
    win_const_mgr.add_const('DDCKEYCAPS_DESTBLTCLRSPACEYUV',0x00000004)
    win_const_mgr.add_const('AE_NETLOGOFF',0x0000000F)
    win_const_mgr.add_const('ATSC_PIT_TID',0x000000D0)
    win_const_mgr.add_const('EXTENSION_CRITICAL_FLAG',0x00000001)
    win_const_mgr.add_const('ERROR_INVALID_ACCOUNT_NAME',0x00000523)
    win_const_mgr.add_const('INITIAL_MXCSR',0x00000001)
    win_const_mgr.add_const('SECURITY_PROXY_RID',0x00000008)
    win_const_mgr.add_const('CRYPT_LDAP_SIGN_RETRIEVAL',0x00010000)
    win_const_mgr.add_const('GBF_DIRECT',0x00000001)
    win_const_mgr.add_const('DISPID_EVENTHOOK_INSENSITIVE_BASE',0x0044AA20)
    win_const_mgr.add_const('DBPROPVAL_NC_START',0x00000008)
    win_const_mgr.add_const('FILE_ENCRYPTABLE',0x00000000)
    win_const_mgr.add_const('NTMS_PRODUCTNAME_LENGTH',0x00000080)
    win_const_mgr.add_const('SQL_FD_FETCH_BOOKMARK',0x00000080)
    win_const_mgr.add_const('PDH_UNABLE_READ_LOG_HEADER',0xC0000BD0)
    win_const_mgr.add_const('META_SETVIEWPORTEXT',0x0000020E)
    win_const_mgr.add_const('CPL_INQUIRE',0x00000003)
    win_const_mgr.add_const('MAX_CLASS_NAME_LEN',0x00000020)
    win_const_mgr.add_const('WIN32',0x00000064)
    win_const_mgr.add_const('TABLET_DISABLE_FLICKFALLBACKKEYS',0x00100000)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_CRYPTO_OPERATORS',0x00000239)
    win_const_mgr.add_const('D3DDEVCAPS_HWRASTERIZATION',0x00080000)
    win_const_mgr.add_const('SQL_FN_TSI_SECOND',0x00000002)
    win_const_mgr.add_const('URLPOLICY_CREDENTIALS_MUST_PROMPT_USER',0x00010000)
    win_const_mgr.add_const('D3DPCMPCAPS_NEVER',0x00000001)
    win_const_mgr.add_const('DTBG_CLIPRECT',0x00000001)
    win_const_mgr.add_const('DNS_ERROR_RCODE_NXRRSET',0x00002330)
    win_const_mgr.add_const('ERROR_DS_RIDMGR_INIT_ERROR',0x00002013)
    win_const_mgr.add_const('WIA_DPC_COMPRESSION_SETTING',0x00000817)
    win_const_mgr.add_const('EXPOSUREMODE_APERTURE_PRIORITY',0x00000003)
    win_const_mgr.add_const('COD_AUDIO_MINOR_VIDEO_MONITOR',0x0000000E)
    win_const_mgr.add_const('WM_MDIACTIVATE',0x00000222)
    win_const_mgr.add_const('DMPAPER_PENV_2_ROTATED',0x0000006E)
    win_const_mgr.add_const('MCI_VCR_CUE_INPUT',0x00010000)
    win_const_mgr.add_const('DDCKEY_SRCBLT',0x00000008)
    win_const_mgr.add_const('SWP_NOCOPYBITS',0x00000100)
    win_const_mgr.add_const('HTTP_STATUS_MOVED',0x0000012D)
    win_const_mgr.add_const('FPF_SEND',0x00000002)
    win_const_mgr.add_const('ERROR_FAIL_RESTART',0x00000160)
    win_const_mgr.add_const('CRYPT_OID_INFO_NAME_KEY',0x00000002)
    win_const_mgr.add_const('SM_CXMENUSIZE',0x00000036)
    win_const_mgr.add_const('DTN_LAST2',0x00000000)
    win_const_mgr.add_const('CRED_ENUMERATE_ALL_CREDENTIALS',0x00000001)
    win_const_mgr.add_const('MCI_DGV_INFO_VIDEO_ALG',0x00004006)
    win_const_mgr.add_const('DEBUG_REGSRC_DEBUGGEE',0x00000000)
    win_const_mgr.add_const('EMR_STROKEPATH',0x00000040)
    win_const_mgr.add_const('SW_SHOWMINIMIZED',0x00000002)
    win_const_mgr.add_const('GQOS_ERRORCODE_UNKNOWN',0xFFFFFFFF)
    win_const_mgr.add_const('AUDIT_QUERY_SYSTEM_POLICY',0x00000002)
    win_const_mgr.add_const('LINEERR_INVALFEATURE',0x80000055)
    win_const_mgr.add_const('RPC_S_UNKNOWN_MGR_TYPE',0x000006B4)
    win_const_mgr.add_const('TCI_SRCCODEPAGE',0x00000002)
    win_const_mgr.add_const('TB_USER_MASK',0x00000180)
    win_const_mgr.add_const('SQL_ATTR_APP_PARAM_DESC',0x0000271B)
    win_const_mgr.add_const('NDIS_STATISTICS_FLAGS_VALID_BROADCAST_FRAMES_XMIT',0x00000100)
    win_const_mgr.add_const('TRUST_ATTRIBUTE_NON_TRANSITIVE',0x00000001)
    win_const_mgr.add_const('OID_FDDI_MAC_FRAME_ERROR_RATIO',0x03030246)
    win_const_mgr.add_const('WLX_DLG_SAS',0x00000065)
    win_const_mgr.add_const('MCI_DGV_STATUS_VIDEO_STREAM',0x00000402)
    win_const_mgr.add_const('DSGIF_ISDISABLED',0x00000002)
    win_const_mgr.add_const('WMDM_SP_REVOKED',0x00000004)
    win_const_mgr.add_const('HSE_EXEC_URL_SSI_CMD',0x00000040)
    win_const_mgr.add_const('DSBI_ENTIREDIRECTORY',0x00090000)
    win_const_mgr.add_const('IME_CAND_STROKE',0x00000005)
    win_const_mgr.add_const('TVIF_INTEGRAL',0x00000080)
    win_const_mgr.add_const('SCARD_CLASS_PERF',0x00000007)
    win_const_mgr.add_const('INDEX_GUID_DESCENDER',0x00000008)
    win_const_mgr.add_const('LINEDEVCAPFLAGS_CALLHUB',0x00000400)
    win_const_mgr.add_const('D3DMIN30SHADERINSTRUCTIONS',0x00000200)
    win_const_mgr.add_const('PORT_NFS',0x00000801)
    win_const_mgr.add_const('RECO_CUT',0x00000003)
    win_const_mgr.add_const('FR_PROP_NONE',0x00000000)
    win_const_mgr.add_const('MCI_VCR_STATUS_AUDIO_MONITOR',0x0000400A)
    win_const_mgr.add_const('NETSH_VERSION_50',0x00005000)
    win_const_mgr.add_const('AGP_FLAG_SPECIAL_RESERVE',0x000F8000)
    win_const_mgr.add_const('FAX_CONFIG_SET',0x00000008)
    win_const_mgr.add_const('FILE_DEVICE_DISK',0x00000007)
    win_const_mgr.add_const('CERT_ISSUER_PUBLIC_KEY_MD5_HASH_PROP_ID',0x00000018)
    win_const_mgr.add_const('LIF_URL',0x00000008)
    win_const_mgr.add_const('WLAN_CONNECTION_ADHOC_JOIN_ONLY',0x00000002)
    win_const_mgr.add_const('ERROR_INVALID_ACCESS',0x0000000C)
    win_const_mgr.add_const('LINEPROXYREQUEST_SETAGENTMEASUREMENTPERIOD',0x0000000A)
    win_const_mgr.add_const('DWFAF_HIDDEN',0x00000001)
    win_const_mgr.add_const('EMR_CREATEPEN',0x00000026)
    win_const_mgr.add_const('TCP_CONGESTION_ALGORITHM',0x0000000C)
    win_const_mgr.add_const('LINEERR_DIALDIALTONE',0x80000009)
    win_const_mgr.add_const('COMPRESSION_FORMAT_DEFAULT',0x00000001)
    win_const_mgr.add_const('SVAUD_BADNETLOGON',0x00000180)
    win_const_mgr.add_const('ETW_REVERSED_COUNTED_STRING_TYPE_VALUE',0x0000006E)
    win_const_mgr.add_const('HSHELL_APPCOMMAND',0x0000000C)
    win_const_mgr.add_const('DLGC_WANTCHARS',0x00000080)
    win_const_mgr.add_const('DIF_NEWDEVICEWIZARD_FINISHINSTALL',0x0000001E)
    win_const_mgr.add_const('DNS_ERROR_ZONE_ALREADY_EXISTS',0x00002589)
    win_const_mgr.add_const('IDM_PASTEINSERT',0x00000848)
    win_const_mgr.add_const('IMGCHG_SIZE',0x00000001)
    win_const_mgr.add_const('TF_NAVIGATE',0x7FAEABAC)
    win_const_mgr.add_const('ASYNCH',0x00000080)
    win_const_mgr.add_const('CBR_19200',0x00004B00)
    win_const_mgr.add_const('X3_I_INST_WORD_X',0x00000003)
    win_const_mgr.add_const('ERROR_INVALID_LDT_SIZE',0x00000231)
    win_const_mgr.add_const('EXCHIVERB_REPLYTOSENDER',0x00000066)
    win_const_mgr.add_const('LC_POLYMARKER',0x00000008)
    win_const_mgr.add_const('RI_MOUSE_MIDDLE_BUTTON_DOWN',0x00000010)
    win_const_mgr.add_const('VK_LBUTTON',0x00000001)
    win_const_mgr.add_const('INT32_MAX',0x7FFFFFFF)
    win_const_mgr.add_const('POLICY_ERRV_GLOBAL_UNAUTH_USER_SUM_FLOW_RATE',0x00000024)
    win_const_mgr.add_const('CREATE_WAITABLE_TIMER_MANUAL_RESET',0x00000001)
    win_const_mgr.add_const('SQL_TXN_READ_COMMITTED',0x00000002)
    win_const_mgr.add_const('MCI_VD_PLAY_SLOW',0x00100000)
    win_const_mgr.add_const('PFM_DONOTHYPHEN',0x00400000)
    win_const_mgr.add_const('AIF_REPLACEONLY',0x00000400)
    win_const_mgr.add_const('FD_WRITE_BIT',0x00000001)
    win_const_mgr.add_const('ULONG_MAX',0x00000000)
    win_const_mgr.add_const('ERROR_USER_PROFILE_LOAD',0x000001F4)
    win_const_mgr.add_const('FILE_IS_ENCRYPTED',0x00000001)
    win_const_mgr.add_const('MOD_WAVETABLE',0x00000006)
    win_const_mgr.add_const('WINHTTP_CALLBACK_STATUS_FLAG_SECURITY_CHANNEL_ERROR',0x80000000)
    win_const_mgr.add_const('WEBPOST_ERROR_POST_FILES',0xC004210F)
    win_const_mgr.add_const('EMR_POLYLINETO',0x00000006)
    win_const_mgr.add_const('CM_DRP_EXCLUSIVE',0x0000001B)
    win_const_mgr.add_const('EAP_FLAG_CONFG_READONLY',0x00080000)
    win_const_mgr.add_const('IP_DEFAULT_MULTICAST_LOOP',0x00000001)
    win_const_mgr.add_const('MCI_DGV_SETVIDEO_BRIGHTNESS',0x00004000)
    win_const_mgr.add_const('X3_TMPLT_SIGN_VAL_POS_X',0x00000000)
    win_const_mgr.add_const('RPC_S_INVALID_STRING_BINDING',0x000006A4)
    win_const_mgr.add_const('QUOTA_LIMITS_HARDWS_MAX_ENABLE',0x00000004)
    win_const_mgr.add_const('DXVA_SCAN_METHOD_ZIG_ZAG',0x00000000)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_MEMORY_HARD_FAULTS',0x00002000)
    win_const_mgr.add_const('MILCORE_TS_QUERYVER_RESULT_FALSE',0x00000000)
    win_const_mgr.add_const('USER_SCRIPT_PATH_PARMNUM',0x00000009)
    win_const_mgr.add_const('LR_VGACOLOR',0x00000080)
    win_const_mgr.add_const('RSC_LOADRS_LEN',0x0000000E)
    win_const_mgr.add_const('BITS_MC_JOB_TAKE_OWNERSHIP',0x80194004)
    win_const_mgr.add_const('BYTE_ERROR',0x00000000)
    win_const_mgr.add_const('WSA_QOS_EFLOWCOUNT',0x00002B0F)
    win_const_mgr.add_const('GPT_BASIC_DATA_ATTRIBUTE_HIDDEN',0x4000000000000000)
    win_const_mgr.add_const('WIA_PAGE_USLEGAL',0x00000003)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_DISABLEDVDCOMPATIBILITYMODE',0x0000010E)
    win_const_mgr.add_const('NET_SITEID_MAXSYSTEM',0x00000000)
    win_const_mgr.add_const('DLG_FLAGS_SEC_CERT_CN_INVALID',0x02000000)
    win_const_mgr.add_const('MCI_AVI_SETVIDEO_PALETTE_COLOR',0x00008100)
    win_const_mgr.add_const('ERROR_DS_UNWILLING_TO_PERFORM',0x00002035)
    win_const_mgr.add_const('PRF_NONCLIENT',0x00000002)
    win_const_mgr.add_const('DEX_IDS_ILLEGAL_PROPERTY_VAL',0x00000588)
    win_const_mgr.add_const('DEBUG_GETMOD_DEFAULT',0x00000000)
    win_const_mgr.add_const('CRED_PERSIST_LOCAL_MACHINE',0x00000002)
    win_const_mgr.add_const('PIPE_READMODE_MESSAGE',0x00000002)
    win_const_mgr.add_const('DNS_QUERY_NO_HOSTS_FILE',0x00000040)
    win_const_mgr.add_const('ODA_DRAWENTIRE',0x00000001)
    win_const_mgr.add_const('CLUSTER_VERSION_UNKNOWN',0xFFFFFFFF)
    win_const_mgr.add_const('BL_36M',0x02400000)
    win_const_mgr.add_const('DOMAIN_NO_LM_OWF_CHANGE',0x00000040)
    win_const_mgr.add_const('ERROR_MAPPED_ALIGNMENT',0x0000046C)
    win_const_mgr.add_const('HTTP_LOGGING_FLAG_LOCAL_TIME_ROLLOVER',0x00000001)
    win_const_mgr.add_const('CRLF_IGNORE_UNKNOWN_CMC_ATTRIBUTES',0x00000080)
    win_const_mgr.add_const('BTH_MAJORVERSION',0x00000002)
    win_const_mgr.add_const('ELEMENT_STATUS_PRODUCT_DATA',0x00000040)
    win_const_mgr.add_const('APPCOMMAND_BROWSER_REFRESH',0x00000003)
    win_const_mgr.add_const('CI_STATE_DELETION_MERGE',0x00008000)
    win_const_mgr.add_const('IR_CLOSECONVERT',0x00000122)
    win_const_mgr.add_const('SQL_API_SQLBINDCOL',0x00000004)
    win_const_mgr.add_const('SES_MAPCPS',0x00000008)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_FREESECTORS',0x00000109)
    win_const_mgr.add_const('RESTART_NO_PATCH',0x00000004)
    win_const_mgr.add_const('CS_HREDRAW',0x00000002)
    win_const_mgr.add_const('RSA1024BIT_KEY',0x04000000)
    win_const_mgr.add_const('RPC_C_OPT_BINDING_NONCAUSAL',0x00000009)
    win_const_mgr.add_const('PSP_USEHICON',0x00000002)
    win_const_mgr.add_const('SWP_NOZORDER',0x00000004)
    win_const_mgr.add_const('PHONESTATE_RESUME',0x00080000)
    win_const_mgr.add_const('MD_LOGON_INTERACTIVE',0x00000000)
    win_const_mgr.add_const('MQ_LOOKUP_PEEK_CURRENT',0x40000010)
    win_const_mgr.add_const('MDPROPVAL_MSF_LASTPERIODS',0x00000020)
    win_const_mgr.add_const('D3DSI_COMMENTSIZE_MASK',0x7FFF0000)
    win_const_mgr.add_const('HTTP_RESPONSE_INFO_FLAGS_PRESERVE_ORDER',0x00000001)
    win_const_mgr.add_const('WNODE_FLAG_SINGLE_ITEM',0x00000004)
    win_const_mgr.add_const('MSV1_0_SUBAUTH_WORKSTATIONS',0x00000004)
    win_const_mgr.add_const('SCOPE_FLAG_INCLUDE',0x00000001)
    win_const_mgr.add_const('ERROR_TM_VOLATILE',0x00001AAC)
    win_const_mgr.add_const('STATE_SYSTEM_PROTECTED',0x20000000)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_PROVIDER_CHIMNEY_OFFLOAD_GENERIC_CHARACTERISTICS',0x0000008F)
    win_const_mgr.add_const('ERROR_DEBUGGER_INACTIVE',0x00000504)
    win_const_mgr.add_const('DEBUG_VALUE_FLOAT128',0x00000009)
    win_const_mgr.add_const('TKF_HOTKEYSOUND',0x00000010)
    win_const_mgr.add_const('WAVECAPS_PLAYBACKRATE',0x00000002)
    win_const_mgr.add_const('CLIP_CHARACTER_PRECIS',0x00000001)
    win_const_mgr.add_const('SPI_SETHANDHELD',0x0000004E)
    win_const_mgr.add_const('IDM_VERTSPACEINCREASE',0x00000030)
    win_const_mgr.add_const('MB_YESNO',0x00000004)
    win_const_mgr.add_const('ALINF_ROLLBACK',0x00000040)
    win_const_mgr.add_const('SI_NO_ADDITIONAL_PERMISSION',0x00200000)
    win_const_mgr.add_const('MCI_DGV_SETVIDEO_ALG',0x00020000)
    win_const_mgr.add_const('STM_GETICON',0x00000171)
    win_const_mgr.add_const('INTERNET_FLAG_SECURE',0x00800000)
    win_const_mgr.add_const('JOB_OBJECT_LIMIT_RESERVED4',0x00010000)
    win_const_mgr.add_const('CRESTRICTIONS_MDSCHEMA_SETS',0x00000005)
    win_const_mgr.add_const('CERT_CHAIN_POLICY_TRUST_TESTROOT_FLAG',0x00004000)
    win_const_mgr.add_const('AF_BTH',0x00000020)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2RAWCD_SUPPORTEDWRITESPEEDS',0x0000010F)
    win_const_mgr.add_const('CR_WRONG_TYPE',0x00000026)
    win_const_mgr.add_const('DS_SCHEMA_GUID_NOT_FOUND',0x00000000)
    win_const_mgr.add_const('ERROR_DS_PARAM_ERROR',0x0000203F)
    win_const_mgr.add_const('TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_PERCENT',0x00000020)
    win_const_mgr.add_const('DBPROPVAL_IN_ALLOWNULL',0x00000000)
    win_const_mgr.add_const('RF_LINED_INPUT',0x00000008)
    win_const_mgr.add_const('ADN_DONT_DEL_DIR',0x00000004)
    win_const_mgr.add_const('CBR_115200',0x0001C200)
    win_const_mgr.add_const('DEBUG_FORMAT_USER_SMALL_CODE_SEGMENTS',0x00001000)
    win_const_mgr.add_const('D3DUSAGE_QUERY_WRAPANDMIP',0x00200000)
    win_const_mgr.add_const('CONFIGMG_VERSION',0x00000400)
    win_const_mgr.add_const('TPM_HORPOSANIMATION',0x00000400)
    win_const_mgr.add_const('MQ_LOOKUP_RECEIVE_NEXT',0x40000021)
    win_const_mgr.add_const('IFS_IFM_LEN',0x00000026)
    win_const_mgr.add_const('WIA_IPA_FORMAT',0x0000100A)
    win_const_mgr.add_const('BS_OWNERDRAW',0x0000000B)
    win_const_mgr.add_const('DSBI_NOROOT',0x00010000)
    win_const_mgr.add_const('IMAGE_SUBSYSTEM_POSIX_CUI',0x00000007)
    win_const_mgr.add_const('MAX_CREATINGDC_LENGTH',0x00000100)
    win_const_mgr.add_const('PSH_WIZARDHASFINISH',0x00000010)
    win_const_mgr.add_const('OID_802_5_CURRENT_GROUP',0x02010104)
    win_const_mgr.add_const('SECURITY_FLAG_PCT',0x00000008)
    win_const_mgr.add_const('SQL_CODE_MINUTE_TO_SECOND',0x0000000D)
    win_const_mgr.add_const('CM_DRP_BUSNUMBER',0x00000016)
    win_const_mgr.add_const('NORMAL_PRIORITY_CLASS',0x00000020)
    win_const_mgr.add_const('ERROR_FAIL_SHUTDOWN',0x0000015F)
    win_const_mgr.add_const('TIMED_SEND_CAPABLE',0x00000010)
    win_const_mgr.add_const('CDDS_POSTPAINT',0x00000002)
    win_const_mgr.add_const('PSWIZB_RESTORE',0x00000001)
    win_const_mgr.add_const('ERROR_INVALID_TRANSFORM',0x000007E4)
    win_const_mgr.add_const('WINHTTP_OPTION_MAX_HTTP_STATUS_CONTINUE',0x0000005A)
    win_const_mgr.add_const('LINEGATHERTERM_TERMDIGIT',0x00000002)
    win_const_mgr.add_const('TRACE_LEVEL_ERROR',0x00000002)
    win_const_mgr.add_const('WINHTTP_CALLBACK_STATUS_READ_COMPLETE',0x00080000)
    win_const_mgr.add_const('TXFS_ROLLFORWARD_REDO_FLAG_USE_LAST_REDO_LSN',0x00000001)
    win_const_mgr.add_const('HTOBJECT',0x00000013)
    win_const_mgr.add_const('MDSP_READ',0x00000001)
    win_const_mgr.add_const('OPATH_TOK_BACKSLASH',0x0000006E)
    win_const_mgr.add_const('MK_LBUTTON',0x00000001)
    win_const_mgr.add_const('FACILITY_UMI',0x00000016)
    win_const_mgr.add_const('CR_PROP_NONE',0x00000000)
    win_const_mgr.add_const('DEBUG_DATA_SPACE_VIRTUAL',0x00000000)
    win_const_mgr.add_const('ACM_FILTERTAGDETAILSF_FILTERTAG',0x00000001)
    win_const_mgr.add_const('ERROR_NO_LOGON_SERVERS',0x0000051F)
    win_const_mgr.add_const('CMSG_RECIPIENT_COUNT_PARAM',0x00000011)
    win_const_mgr.add_const('READABLE_LOCAL_CLOCK',0x00000001)
    win_const_mgr.add_const('PROGDLG_MODAL',0x00000001)
    win_const_mgr.add_const('HHWIN_PROP_AUTO_SYNC',0x00000001)
    win_const_mgr.add_const('EMR_OFFSETCLIPRGN',0x0000001A)
    win_const_mgr.add_const('PC_WINDPOLYGON',0x00000004)
    win_const_mgr.add_const('MDMEASURE_AGGR_STD',0x00000007)
    win_const_mgr.add_const('ODBC_ERROR_LOAD_LIB_FAILED',0x0000000D)
    win_const_mgr.add_const('IME_ESC_SET_EUDC_DICTIONARY',0x00001004)
    win_const_mgr.add_const('TASK_MARCH',0x00000004)
    win_const_mgr.add_const('NCBRECVANY',0x00000016)
    win_const_mgr.add_const('ERROR_DS_CANT_CREATE_UNDER_SCHEMA',0x0000213E)
    win_const_mgr.add_const('LINEERR_UNINITIALIZED',0x80000050)
    win_const_mgr.add_const('MND_ENDMENU',0x00000001)
    win_const_mgr.add_const('DRV_FREE',0x00000006)
    win_const_mgr.add_const('ADS_JOB_PRINTED',0x00000080)
    win_const_mgr.add_const('HSHELL_ENDTASK',0x0000000A)
    win_const_mgr.add_const('NORM_IGNOREWIDTH',0x00020000)
    win_const_mgr.add_const('USER_DCR_INITIAL',0x00000007)
    win_const_mgr.add_const('LVM_FIRST',0x00001000)
    win_const_mgr.add_const('DS_REPSYNC_FORCE',0x00000100)
    win_const_mgr.add_const('CSC_CACHE_NONE',0x00000030)
    win_const_mgr.add_const('ILD_ROP',0x00000040)
    win_const_mgr.add_const('OID_FDDI_PORT_LER_ESTIMATE',0x0303026D)
    win_const_mgr.add_const('KF_REPEAT',0x00004000)
    win_const_mgr.add_const('MD_ERROR_SUB403_CERT_BAD',0x00000010)
    win_const_mgr.add_const('DS_DNS_CONTROLLER_FLAG',0x20000000)
    win_const_mgr.add_const('ERROR_INCOMPATIBLE_SERVICE_SID_TYPE',0x0000050A)
    win_const_mgr.add_const('PRINTER_ATTRIBUTE_ENABLE_DEVQ',0x00000080)
    win_const_mgr.add_const('RBS_TOOLTIPS',0x00000100)
    win_const_mgr.add_const('OID_TAPI_GET_ADDRESS_STATUS',0x0703010C)
    win_const_mgr.add_const('PRJOB_DESTPAUSED',0x00000040)
    win_const_mgr.add_const('PXE_TRACE_INFO',0x00020000)
    win_const_mgr.add_const('VIEW_NETDISCONNECT',0x0000000A)
    win_const_mgr.add_const('ERROR_DS_NOT_INSTALLED',0x00002008)
    win_const_mgr.add_const('FACILITY_INTERNET',0x0000000C)
    win_const_mgr.add_const('SMART_SHORT_SELFTEST_OFFLINE',0x00000001)
    win_const_mgr.add_const('DCBA_FACEUPLEFT',0x00000002)
    win_const_mgr.add_const('SECPKG_OPTIONS_TYPE_LSA',0x00000001)
    win_const_mgr.add_const('DBPROPVAL_TR_COMMIT',0x00000002)
    win_const_mgr.add_const('SECPKG_ATTR_LOCAL_CERT_INFO',0x00000063)
    win_const_mgr.add_const('SW_NORMAL',0x00000001)
    win_const_mgr.add_const('BI_RGB',0x00000000)
    win_const_mgr.add_const('SSRVOPT_FAVOR_COMPRESSED',0x00200000)
    win_const_mgr.add_const('SQL_ATTR_ENLIST_IN_XA',0x000004B8)
    win_const_mgr.add_const('CMSG_CONTENTS_OCTETS_FLAG',0x00000010)
    win_const_mgr.add_const('ERROR_INVALID_SPI_VALUE',0x0000059F)
    win_const_mgr.add_const('WINHTTP_OPTION_USE_GLOBAL_SERVER_CREDENTIALS',0x00000065)
    win_const_mgr.add_const('CRL_V1',0x00000000)
    win_const_mgr.add_const('COD_SERVICE_RENDERING',0x00000020)
    win_const_mgr.add_const('ALG_SID_ANY',0x00000000)
    win_const_mgr.add_const('SUOI_FORCEDELETE',0x00000001)
    win_const_mgr.add_const('AVIF_MUSTUSEINDEX',0x00000020)
    win_const_mgr.add_const('IDM_TABLEPROPERTIES',0x000008A2)
    win_const_mgr.add_const('DTR_KTBASE_INDEX',0x00000002)
    win_const_mgr.add_const('CTFMODEBIAS_HANGUL',0x00000009)
    win_const_mgr.add_const('MAPI_RECEIPT_REQUESTED',0x00000002)
    win_const_mgr.add_const('ES_CENTER',0x00000001)
    win_const_mgr.add_const('CERT_INFO_NOT_AFTER_FLAG',0x00000006)
    win_const_mgr.add_const('WSP_PROTOCOL_UUID16',0x0000000E)
    win_const_mgr.add_const('IMAGE_REL_IA64_ADDEND',0x0000001F)
    win_const_mgr.add_const('DCX_NORESETATTRS',0x00000004)
    win_const_mgr.add_const('LOGON32_LOGON_SERVICE',0x00000005)
    win_const_mgr.add_const('DS_DNS_FOREST_FLAG',0x80000000)
    win_const_mgr.add_const('WIA_IPS_PHOTOMETRIC_INTERP',0x00001809)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_SPEAKERON',0x00000015)
    win_const_mgr.add_const('LANG_YORUBA',0x00000006)
    win_const_mgr.add_const('FWPM_FILTER_FLAG_HAS_PROVIDER_CONTEXT',0x00000004)
    win_const_mgr.add_const('DISPID_PICT_HANDLE',0x00000000)
    win_const_mgr.add_const('IPSEC_AUTH_CONFIG_HMAC_MD5_96',0x00000000)
    win_const_mgr.add_const('PRIMARY_CACHE_INVALID',0x00000000)
    win_const_mgr.add_const('VK_DBE_ENTERDLGCONVERSIONMODE',0x00000000)
    win_const_mgr.add_const('MAX_CACHE_ENTRY_INFO_SIZE',0x00001000)
    win_const_mgr.add_const('PFS_EC_SHIFT',0x00000034)
    win_const_mgr.add_const('SUBLANG_POLISH_POLAND',0x00000001)
    win_const_mgr.add_const('DDFLIP_STEREO',0x00000010)
    win_const_mgr.add_const('METADATA_MASTER_ROOT_HANDLE',0x00000000)
    win_const_mgr.add_const('WS_EX_NOINHERITLAYOUT',0x00100000)
    win_const_mgr.add_const('LVA_ALIGNTOP',0x00000002)
    win_const_mgr.add_const('CTFMODEBIAS_HALFWIDTHALPHANUMERIC',0x0000000C)
    win_const_mgr.add_const('SECURITY_SERVICE_ID_RID_COUNT',0x00000006)
    win_const_mgr.add_const('IMAGE_FILE_BYTES_REVERSED_HI',0x00008000)
    win_const_mgr.add_const('SDP_ATTRIB_CORDLESS_EXTERNAL_NETWORK',0x00000301)
    win_const_mgr.add_const('MD_APPPOOL_COMMAND_STOP',0x00000002)
    win_const_mgr.add_const('APPCOMMAND_BASS_BOOST',0x00000014)
    win_const_mgr.add_const('SFVM_GETHELPTOPIC',0x0000003F)
    win_const_mgr.add_const('NIIF_FILTER_INTERFACE',0x00000002)
    win_const_mgr.add_const('CI_PROVIDER_INDEXING_SERVICE',0x00000002)
    win_const_mgr.add_const('SI_ACCESS_CONTAINER',0x00040000)
    win_const_mgr.add_const('MM_TEXT',0x00000001)
    win_const_mgr.add_const('CSTR_LESS_THAN',0x00000001)
    win_const_mgr.add_const('DXGI_MWA_NO_WINDOW_CHANGES',0x00000001)
    win_const_mgr.add_const('DFCS_SCROLLSIZEGRIP',0x00000008)
    win_const_mgr.add_const('SM_CXEDGE',0x0000002D)
    win_const_mgr.add_const('CRYPT_ACQUIRE_SILENT_FLAG',0x00000040)
    win_const_mgr.add_const('CERT_COMPARE_ISSUER_OF',0x0000000C)
    win_const_mgr.add_const('DDPF_ALPHA',0x00000002)
    win_const_mgr.add_const('SQL_ADD',0x00000004)
    win_const_mgr.add_const('WINHTTP_OPTION_PASSPORT_COBRANDING_TEXT',0x00000051)
    win_const_mgr.add_const('EMARCH_ENC_I17_IMM9D_SIZE_X',0x00000009)
    win_const_mgr.add_const('DS_REPMOD_ASYNCHRONOUS_OPERATION',0x00000001)
    win_const_mgr.add_const('THAI_CHARSET',0x000000DE)
    win_const_mgr.add_const('MB_MODEMASK',0x00003000)
    win_const_mgr.add_const('ALG_SID_TLS1PRF',0x0000000A)
    win_const_mgr.add_const('AA_AUDIT_ALL',0x00000001)
    win_const_mgr.add_const('IMAGE_DEBUG_TYPE_FIXUP',0x00000006)
    win_const_mgr.add_const('PHONEFEATURE_SETGAINSPEAKER',0x00040000)
    win_const_mgr.add_const('OIC_WINLOGO',0x00007F05)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_CONFIG_SERVICES',0x0000000F)
    win_const_mgr.add_const('IDS_CAP_ERRORDIBSAVE',0x00000196)
    win_const_mgr.add_const('EMR_ALPHABLEND',0x00000072)
    win_const_mgr.add_const('GL_ID_UNKNOWN',0x00000000)
    win_const_mgr.add_const('CFU_UNDERLINETHICKDASH',0x0000000E)
    win_const_mgr.add_const('SNMPAPI_TL_PDU_TOO_BIG',0x0000006D)
    win_const_mgr.add_const('TXTLOG_SETUP',0x08000000)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_QUEUECALL',0x0000002D)
    win_const_mgr.add_const('DEFAULT_CONTEXT_PRIORITY',0x00000064)
    win_const_mgr.add_const('NT32_PTR_SIZE',0x00000004)
    win_const_mgr.add_const('SCESTATUS_SUCCESS',0x00000000)
    win_const_mgr.add_const('PHONEFEATURE_SETHOOKSWITCHHANDSET',0x00100000)
    win_const_mgr.add_const('CACHE_HEADER_DATA_CACHE_RESERVED_31',0x0000001F)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_MSGINDICATOR',0x00000026)
    win_const_mgr.add_const('OID_FDDI_PATH_T_MAX_LOWER_BOUND',0x0303025A)
    win_const_mgr.add_const('USER_PARMS_PARMNUM',0x0000000D)
    win_const_mgr.add_const('DISPID_SUBMIT',0x00000003)
    win_const_mgr.add_const('LINEMEDIACONTROL_RESET',0x00000004)
    win_const_mgr.add_const('PP_SMARTCARD_GUID',0x0000002D)
    win_const_mgr.add_const('DDOVER_ARGBSCALEFACTORS',0x02000000)
    win_const_mgr.add_const('IMAGE_COMPRESSION_UNCOMPRESSED',0x00000001)
    win_const_mgr.add_const('MB_TASKMODAL',0x00002000)
    win_const_mgr.add_const('OID_GEN_MULTICAST_FRAMES_XMIT',0x00020204)
    win_const_mgr.add_const('SUBLANG_QUECHUA_ECUADOR',0x00000002)
    win_const_mgr.add_const('CRYPT_MM',0x00000003)
    win_const_mgr.add_const('CFU_UNDERLINETHICK',0x00000009)
    win_const_mgr.add_const('ERROR_SXS_MANIFEST_FORMAT_ERROR',0x000036B4)
    win_const_mgr.add_const('SFVM_SIZE',0x00000039)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_ANONYMOUS',0x80000040)
    win_const_mgr.add_const('SV_THREADCOUNTADD_PARMNUM',0x0000020E)
    win_const_mgr.add_const('PORT_SEND',0x000000A9)
    win_const_mgr.add_const('SQL_FN_NUM_ATAN',0x00000008)
    win_const_mgr.add_const('CTL_FIND_SAME_USAGE_FLAG',0x00000001)
    win_const_mgr.add_const('VER_ERR_METHOD_SIG',0x01000000)
    win_const_mgr.add_const('DBPROPVAL_TI_BROWSE',0x00000100)
    win_const_mgr.add_const('DXGI_CPU_ACCESS_NONE',0x00000000)
    win_const_mgr.add_const('VR_INSTANT_BAD',0x00000002)
    win_const_mgr.add_const('ES_SUNKEN',0x00004000)
    win_const_mgr.add_const('SPREG_GETPROCADDR',0x00000002)
    win_const_mgr.add_const('MQ_MOVE_ACCESS',0x00000004)
    win_const_mgr.add_const('MDM_MASK_BEARERMODE',0x00000000)
    win_const_mgr.add_const('DISPID_MODE',0x00000012)
    win_const_mgr.add_const('RAS_FLAGS_PPP_CONNECTION',0x00000001)
    win_const_mgr.add_const('ERROR_MEMBER_IN_ALIAS',0x00000562)
    win_const_mgr.add_const('NETLOGON_CONTROL_BACKUP_CHANGE_LOG',0x0000FFFC)
    win_const_mgr.add_const('LVBKIF_TYPE_WATERMARK',0x10000000)
    win_const_mgr.add_const('IDM_TRIED_ITALIC',0x0000002B)
    win_const_mgr.add_const('NCRYPT_ALLOW_PLAINTEXT_ARCHIVING_FLAG',0x00000008)
    win_const_mgr.add_const('NETLOGON_REDO_NEEDED',0x00000008)
    win_const_mgr.add_const('CE_PTO',0x00000200)
    win_const_mgr.add_const('JOB_OBJECT_EXTENDED_LIMIT_VALID_FLAGS',0x00000003)
    win_const_mgr.add_const('MIXERLINE_LINEF_SOURCE',0x80000000)
    win_const_mgr.add_const('MD_ACCESS_NO_PHYSICAL_DIR',0x00008000)
    win_const_mgr.add_const('ERROR_UNKNOWN_PRINT_MONITOR',0x00000BB8)
    win_const_mgr.add_const('ROLLBACK_BITS',0x00000001)
    win_const_mgr.add_const('MQMSG_ACKNOWLEDGMENT_POS_ARRIVAL',0x00000001)
    win_const_mgr.add_const('PF_NX_ENABLED',0x0000000C)
    win_const_mgr.add_const('POLICY_GET_PRIVATE_INFORMATION',0x00000004)
    win_const_mgr.add_const('DEBUG_REGISTER_SUB_REGISTER',0x00000001)
    win_const_mgr.add_const('FD_ADDRESS_LIST_CHANGE_BIT',0x00000009)
    win_const_mgr.add_const('IDM_VERTSPACEDECREASE',0x0000002F)
    win_const_mgr.add_const('UM_SELTYPE_LOCALGROUP',0x00000004)
    win_const_mgr.add_const('SQL_SRJO_CROSS_JOIN',0x00000002)
    win_const_mgr.add_const('FWPM_FILTER_FLAG_PERSISTENT',0x00000001)
    win_const_mgr.add_const('ERROR_TRANSACTION_NOT_ROOT',0x00001A41)
    win_const_mgr.add_const('OID_GEN_NDIS_RESERVED_5',0x0001020C)
    win_const_mgr.add_const('D3DVTXPCAPS_NO_TEXGEN_NONLOCALVIEWER',0x00000200)
    win_const_mgr.add_const('OID_GEN_NDIS_RESERVED_6',0x00010212)
    win_const_mgr.add_const('OID_GEN_NDIS_RESERVED_1',0x00020217)
    win_const_mgr.add_const('MARK_HANDLE_NOT_TXF_SYSTEM_LOG',0x00000008)
    win_const_mgr.add_const('OID_GEN_NDIS_RESERVED_3',0x0001020A)
    win_const_mgr.add_const('OID_GEN_NDIS_RESERVED_2',0x00020218)
    win_const_mgr.add_const('ERROR_INVALID_MENU_HANDLE',0x00000579)
    win_const_mgr.add_const('TXFS_RM_FLAG_LOGGING_MODE',0x00000001)
    win_const_mgr.add_const('ERROR_UNKNOWN_PRINTPROCESSOR',0x00000706)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_NEG_STATUS_BEGIN',0x000035E8)
    win_const_mgr.add_const('CS_OWNDC',0x00000020)
    win_const_mgr.add_const('DIRID_ABSOLUTE_16BIT',0x00000000)
    win_const_mgr.add_const('LINECALLFEATURE_REDIRECT',0x00020000)
    win_const_mgr.add_const('ERROR_BUFFER_ALL_ZEROS',0x000002F2)
    win_const_mgr.add_const('RESOURCE_MANAGER_VOLATILE',0x00000001)
    win_const_mgr.add_const('SO_PAUSE_ACCEPT',0x00003003)
    win_const_mgr.add_const('MDPROPVAL_MNF_DRILLUPLEVEL',0x00020000)
    win_const_mgr.add_const('DBPROP_IGNORENOISEONLYCLAUSES',0x00000005)
    win_const_mgr.add_const('GPO_INFO_FLAG_LOGRSOP_TRANSITION',0x00000200)
    win_const_mgr.add_const('LANG_IRISH',0x00000003)
    win_const_mgr.add_const('ERROR_DS_GENERIC_ERROR',0x00002095)
    win_const_mgr.add_const('CTRY_UKRAINE',0x0000017C)
    win_const_mgr.add_const('WMIREG_FLAG_INSTANCE_LIST',0x00000004)
    win_const_mgr.add_const('POLICY_AUDIT_EVENT_SUCCESS',0x00000001)
    win_const_mgr.add_const('PAGEMASK_64KB',0x00000000)
    win_const_mgr.add_const('FWPM_ACTRL_READ',0x00000080)
    win_const_mgr.add_const('RQ_UPDATE_REQUEST_CACHE',0x00000200)
    win_const_mgr.add_const('LINEADDRFEATURE_PICKUPWAITING',0x00000800)
    win_const_mgr.add_const('RF_DOWN_AND_LEFT',0x00000100)
    win_const_mgr.add_const('MCI_VCR_SETAUDIO_NUMBER',0x00400000)
    win_const_mgr.add_const('ERROR_LOG_PINNED_RESERVATION',0x000019F8)
    win_const_mgr.add_const('RPC_S_INVALID_NAF_ID',0x000006E3)
    win_const_mgr.add_const('LANG_BENGALI',0x00000045)
    win_const_mgr.add_const('JOB_OBJECT_LIMIT_RESERVED3',0x00008000)
    win_const_mgr.add_const('TLMENUF_BACK',0x00000010)
    win_const_mgr.add_const('NDIS_LINK_STATE_REVISION_1',0x00000001)
    win_const_mgr.add_const('TXFS_RM_FLAG_GROW_LOG',0x00000400)
    win_const_mgr.add_const('LINETERMDEV_PHONE',0x00000001)
    win_const_mgr.add_const('MPEG_TSDT_TID',0x00000003)
    win_const_mgr.add_const('RASLCPAD_CHAP_MD5',0x00000005)
    win_const_mgr.add_const('D3DSTENCILCAPS_INVERT',0x00000020)
    win_const_mgr.add_const('INT_MAX',0x7FFFFFFF)
    win_const_mgr.add_const('NI_FINALIZECONVERSIONRESULT',0x00000014)
    win_const_mgr.add_const('CREATE_MUTEX_INITIAL_OWNER',0x00000001)
    win_const_mgr.add_const('VOLUME_NAME_DOS',0x00000000)
    win_const_mgr.add_const('MCI_DGV_GETDEVCAPS_HAS_STILL',0x00004005)
    win_const_mgr.add_const('PRIVACY_TEMPLATE_MEDIUM_LOW',0x00000004)
    win_const_mgr.add_const('DATE_YEARMONTH',0x00000008)
    win_const_mgr.add_const('CPIOD_FORCE_PROMPT',0x80000000)
    win_const_mgr.add_const('SERVICETYPE_CONTROLLEDLOAD',0x00000002)
    win_const_mgr.add_const('LINE_REPLY',0x0000000C)
    win_const_mgr.add_const('BG_COPY_FILE_GROUP',0x00000002)
    win_const_mgr.add_const('DNOBJECT_EVR',0x0000001A)
    win_const_mgr.add_const('MD_LOGCUSTOM_DATATYPE_UINT',0x00000001)
    win_const_mgr.add_const('COD_LAN_ACCESS_0_USED',0x00000000)
    win_const_mgr.add_const('PRINTER_ENUM_ICONMASK',0x00000000)
    win_const_mgr.add_const('SECBUFFER_VERSION',0x00000000)
    win_const_mgr.add_const('ENM_CHANGE',0x00000001)
    win_const_mgr.add_const('URL_WININET_COMPATIBILITY',0x80000000)
    win_const_mgr.add_const('RPC_X_SS_CHAR_TRANS_SHORT_FILE',0x000006EE)
    win_const_mgr.add_const('MMIO_WRITE',0x00000001)
    win_const_mgr.add_const('PROPID_M_BASE',0x00000000)
    win_const_mgr.add_const('RTCTR_TCP',0x00000002)
    win_const_mgr.add_const('WSAHOST_NOT_FOUND',0x00002AF9)
    win_const_mgr.add_const('MDM_ANALOG_RLP_OFF',0x00000001)
    win_const_mgr.add_const('ACCESS_SUCCESS_MASK',0x000000F0)
    win_const_mgr.add_const('WINEVENT_OPCODE_SEND',0x00000009)
    win_const_mgr.add_const('MDM_BLIND_DIAL',0x00000200)
    win_const_mgr.add_const('VARIANT_USE_NLS',0x00000080)
    win_const_mgr.add_const('D3DVS_W_W',0x00000003)
    win_const_mgr.add_const('ERROR_SXS_FILE_HASH_MISMATCH',0x000036CC)
    win_const_mgr.add_const('REG_LATEST_FORMAT',0x00000002)
    win_const_mgr.add_const('DOMAIN_GROUP_RID_SCHEMA_ADMINS',0x00000206)
    win_const_mgr.add_const('REG_WHOLE_HIVE_VOLATILE',0x00000001)
    win_const_mgr.add_const('VK_PROCESSKEY',0x000000E5)
    win_const_mgr.add_const('ERROR_INVALID_EXE_SIGNATURE',0x000000BF)
    win_const_mgr.add_const('WINHTTP_QUERY_WARNING',0x00000043)
    win_const_mgr.add_const('SORT_GEORGIAN_TRADITIONAL',0x00000000)
    win_const_mgr.add_const('D3DVS_W_Z',0x00000002)
    win_const_mgr.add_const('D3DVS_W_X',0x00000000)
    win_const_mgr.add_const('D3DVS_W_Y',0x00000001)
    win_const_mgr.add_const('JIFMK_JPG13',0x0000FFFD)
    win_const_mgr.add_const('JIFMK_JPG12',0x0000FFFC)
    win_const_mgr.add_const('HTTP_LOGGING_FLAG_LOG_ERRORS_ONLY',0x00000004)
    win_const_mgr.add_const('JIFMK_JPG10',0x0000FFFA)
    win_const_mgr.add_const('EVENTLOG_AUDIT_SUCCESS',0x00000008)
    win_const_mgr.add_const('LINECALLCOMPLCOND_NOANSWER',0x00000002)
    win_const_mgr.add_const('TBS_ENABLESELRANGE',0x00000020)
    win_const_mgr.add_const('DOMAIN_GROUP_RID_CERT_ADMINS',0x00000205)
    win_const_mgr.add_const('HTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON',0x01000000)
    win_const_mgr.add_const('DISPID_SETCONTEXTMENU',0x00000005)
    win_const_mgr.add_const('DDFLIP_WAIT',0x00000001)
    win_const_mgr.add_const('PCF_RLSD',0x00000004)
    win_const_mgr.add_const('IMAGE_SYM_TYPE_BYTE',0x0000000C)
    win_const_mgr.add_const('ERROR_PRINTER_HAS_JOBS_QUEUED',0x00000BC1)
    win_const_mgr.add_const('SPREG_UNKNOWN',0xFFFFFFFF)
    win_const_mgr.add_const('DDSCAPS2_CUBEMAP_NEGATIVEZ',0x00008000)
    win_const_mgr.add_const('ERROR_NOT_QUORUM_CAPABLE',0x0000139D)
    win_const_mgr.add_const('WM_MDIRESTORE',0x00000223)
    win_const_mgr.add_const('WHEEL_DELTA',0x00000078)
    win_const_mgr.add_const('CRSWPP_BIND_FAILED',0xC004220A)
    win_const_mgr.add_const('FAX_ERR_MESSAGE_NOT_FOUND',0x00001B61)
    win_const_mgr.add_const('SUBLANG_CHINESE_SIMPLIFIED',0x00000002)
    win_const_mgr.add_const('IF_TYPE_AAL5',0x00000031)
    win_const_mgr.add_const('DB_DISP_REVOKED',0x00000015)
    win_const_mgr.add_const('DEBUG_SYMINFO_GET_MODULE_SYMBOL_NAMES_AND_OFFSETS',0x00000003)
    win_const_mgr.add_const('CF_WYSIWYG',0x00008000)
    win_const_mgr.add_const('MDMVOLFLAG_LOW',0x00000001)
    win_const_mgr.add_const('BAUD_075',0x00000001)
    win_const_mgr.add_const('ED_BASE',0x00001000)
    win_const_mgr.add_const('CAUSE_PROTOCOL_ERROR',0x0000006F)
    win_const_mgr.add_const('CHANNEL_OPTION_SHOW_PROTOCOL',0x00200000)
    win_const_mgr.add_const('CDB2GVF_NOINCLUDEITEM',0x00000010)
    win_const_mgr.add_const('BIF_RETURNFSANCESTORS',0x00000008)
    win_const_mgr.add_const('CM_VIEWFLAGS_MASK',0x00000000)
    win_const_mgr.add_const('FMEVENT_TOOLBARLOAD',0x00000069)
    win_const_mgr.add_const('DSBI_NOBUTTONS',0x00000001)
    win_const_mgr.add_const('ERROR_TRANSACTION_PROPAGATION_FAILED',0x00001A37)
    win_const_mgr.add_const('DIIRFLAG_INF_ALREADY_COPIED',0x00000001)
    win_const_mgr.add_const('RASIPO_VJ',0x00000001)
    win_const_mgr.add_const('SUBLANG_SAMI_NORTHERN_NORWAY',0x00000001)
    win_const_mgr.add_const('EMR_SETCOLORSPACE',0x00000064)
    win_const_mgr.add_const('FLG_PROFITEM_DELETE',0x00000002)
    win_const_mgr.add_const('ERROR_CONNECTION_ACTIVE',0x000004CE)
    win_const_mgr.add_const('VPF_DISABLESCALE',0x00000004)
    win_const_mgr.add_const('MD_DIRBROW_SHOW_TIME',0x00000004)
    win_const_mgr.add_const('OID_GEN_RCV_NO_BUFFER',0x00020105)
    win_const_mgr.add_const('FWPM_PROVIDER_CONTEXT_FLAG_PERSISTENT',0x00000001)
    win_const_mgr.add_const('MCHT_TODAYLINK',0x00030000)
    win_const_mgr.add_const('DS_REPDEL_LOCAL_ONLY',0x00000010)
    win_const_mgr.add_const('TCS_FLATBUTTONS',0x00000008)
    win_const_mgr.add_const('DE_E_FILTER_SCRIPTLABEL',0x80100010)
    win_const_mgr.add_const('OID_CO_TAPI_CM_CAPS',0xFE001001)
    win_const_mgr.add_const('CSTORAGEPROPERTY',0x00000017)
    win_const_mgr.add_const('MCI_DGV_GETDEVCAPS_PALETTES',0x00004006)
    win_const_mgr.add_const('IMAGE_SYM_CLASS_STRUCT_TAG',0x0000000A)
    win_const_mgr.add_const('SFC_SCAN_ONCE',0x00000002)
    win_const_mgr.add_const('PGF_SCROLLLEFT',0x00000004)
    win_const_mgr.add_const('ERROR_COULD_NOT_RESIZE_LOG',0x000019E5)
    win_const_mgr.add_const('IDM_TRIED_INSERTCOL',0x0000000F)
    win_const_mgr.add_const('SEE_MASK_ASYNCOK',0x00100000)
    win_const_mgr.add_const('WINHTTP_OPTION_REJECT_USERPWD_IN_URL',0x00000064)
    win_const_mgr.add_const('DBT_DEVICEQUERYREMOVE',0x00008001)
    win_const_mgr.add_const('KSEVENT_TYPE_ONESHOT',0x00000002)
    win_const_mgr.add_const('DTR_KIPCR_INDEX',0x00000000)
    win_const_mgr.add_const('SQL_CVT_LONGVARCHAR',0x00000200)
    win_const_mgr.add_const('KSSTREAM_SYNCHRONOUS',0x00001000)
    win_const_mgr.add_const('CI_STATE_ANNEALING_MERGE',0x00000008)
    win_const_mgr.add_const('SSRVOPT_OVERWRITE',0x00004000)
    win_const_mgr.add_const('DB_BINDFLAGS_DELAYFETCHCOLUMNS',0x00000001)
    win_const_mgr.add_const('SPI_GETSCREENSAVETIMEOUT',0x0000000E)
    win_const_mgr.add_const('SEE_MASK_NOASYNC',0x00000100)
    win_const_mgr.add_const('LDAP_OPT_SERVER_ERROR',0x00000033)
    win_const_mgr.add_const('PHONEFEATURE_SETGAINHANDSET',0x00020000)
    win_const_mgr.add_const('PWLEN',0x00000100)
    win_const_mgr.add_const('MDM_PIAFS_INCOMING',0x00000000)
    win_const_mgr.add_const('LINEPROXYREQUEST_SETAGENTSTATE',0x00000002)
    win_const_mgr.add_const('AD_APPLY_BUFFERED_REFRESH',0x00000010)
    win_const_mgr.add_const('EAP_E_USER_FIRST',0x80420100)
    win_const_mgr.add_const('SPI_GETACCESSTIMEOUT',0x0000003C)
    win_const_mgr.add_const('IPPROTO_GGP',0x00000003)
    win_const_mgr.add_const('SYMFLAG_METADATA',0x00020000)
    win_const_mgr.add_const('SNMP_ERROR_NOSUCHNAME',0x00000002)
    win_const_mgr.add_const('ACMSTREAMHEADER_STATUSF_PREPARED',0x00020000)
    win_const_mgr.add_const('MDLEVEL_TYPE_TIME_QUARTERS',0x00000044)
    win_const_mgr.add_const('SBSP_ALLOW_AUTONAVIGATE',0x00010000)
    win_const_mgr.add_const('SQL_NB_OFF',0x00000000)
    win_const_mgr.add_const('IO_REPARSE_TAG_RESERVED_ZERO',0x00000000)
    win_const_mgr.add_const('DRIVE_UNKNOWN',0x00000000)
    win_const_mgr.add_const('CC_MAX_HW_DECODE_LINES',0x0000000C)
    win_const_mgr.add_const('POLICY_ERRV_GLOBAL_UNAUTH_USER_PEAK_RATE',0x0000001C)
    win_const_mgr.add_const('FR_HIDEUPDOWN',0x00004000)
    win_const_mgr.add_const('JIFMK_SOF11',0x0000FFCB)
    win_const_mgr.add_const('WPCPROV_KEYWORD_WPC',0x00000010)
    win_const_mgr.add_const('PID_INTSITE_DESCRIPTION',0x00000007)
    win_const_mgr.add_const('IMAGE_REL_ARM_SECTION',0x0000000E)
    win_const_mgr.add_const('SMC_OPEN',0x00000045)
    win_const_mgr.add_const('IMAGE_SUBSYSTEM_NATIVE',0x00000001)
    win_const_mgr.add_const('EVT_VARIANT_TYPE_ARRAY',0x00000080)
    win_const_mgr.add_const('SPDRP_CLASSGUID',0x00000008)
    win_const_mgr.add_const('HHT_ONOVERFLOW',0x00004000)
    win_const_mgr.add_const('URLACTION_JAVA_CURR_MAX',0x00001C00)
    win_const_mgr.add_const('MFBYTESTREAM_HAS_SLOW_SEEK',0x00000100)
    win_const_mgr.add_const('CERT_CLOSE_STORE_FORCE_FLAG',0x00000001)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_FORCEOVERWRITE',0x00000117)
    win_const_mgr.add_const('DBC_SHOWOBSCURE',0x00000002)
    win_const_mgr.add_const('EMBDHLP_INPROC_SERVER',0x00000001)
    win_const_mgr.add_const('HTMAXBUTTON',0x00000009)
    win_const_mgr.add_const('SIMPLEREGION',0x00000002)
    win_const_mgr.add_const('KSPROPERTY_VIDEOPROCAMP_FLAGS_MANUAL',0x00000000)
    win_const_mgr.add_const('DEBUG_DATA_SPACE_IO',0x00000003)
    win_const_mgr.add_const('LVS_OWNERDATA',0x00001000)
    win_const_mgr.add_const('SHCNE_INTERRUPT',0x80000000)
    win_const_mgr.add_const('JOB_NOTIFY_FIELD_STATUS',0x0000000A)
    win_const_mgr.add_const('POLICY_ERRV_NO_MORE_INFO',0x00000001)
    win_const_mgr.add_const('SF_NOTIFY_SEND_RAW_DATA',0x00000400)
    win_const_mgr.add_const('ERROR_DS_SRC_GUID_MISMATCH',0x00002128)
    win_const_mgr.add_const('TMT_HBITMAP',0x000000D4)
    win_const_mgr.add_const('NEWFILEOPENV3ORD',0x00000611)
    win_const_mgr.add_const('IMAGE_SIZEOF_FILE_HEADER',0x00000014)
    win_const_mgr.add_const('RBHT_GRABBER',0x00000004)
    win_const_mgr.add_const('WM_QUERYUISTATE',0x00000129)
    win_const_mgr.add_const('ERROR_DS_CANT_CACHE_ATT',0x000020D1)
    win_const_mgr.add_const('ERROR_LOG_FILE_FULL',0x000005DE)
    win_const_mgr.add_const('SQL_FN_NUM_ACOS',0x00000002)
    win_const_mgr.add_const('DI_NOMIRROR',0x00000010)
    win_const_mgr.add_const('LB_SELITEMRANGEEX',0x00000183)
    win_const_mgr.add_const('STI_ONLINESTATE_ERROR',0x00000004)
    win_const_mgr.add_const('SCARD_READER_TYPE_IDE',0x00000010)
    win_const_mgr.add_const('SHCNE_NETSHARE',0x00000200)
    win_const_mgr.add_const('CRYPTDLG_POLICY_MASK',0x0000FFFF)
    win_const_mgr.add_const('SV_MAXNONPAGEDMEMORYUSAGE_PARMNUM',0x00000200)
    win_const_mgr.add_const('DNS_ERROR_RCODE_NOTAUTH',0x00002331)
    win_const_mgr.add_const('FWPM_SESSION_FLAG_DYNAMIC',0x00000001)
    win_const_mgr.add_const('DBPROP_MSREMOTE_HANDLER',0x00000004)
    win_const_mgr.add_const('ERROR_CTX_INVALID_WD',0x00001B89)
    win_const_mgr.add_const('PXE_CALLBACK_SHUTDOWN',0x00000001)
    win_const_mgr.add_const('SQL_NNC_NULL',0x00000000)
    win_const_mgr.add_const('SECURITY_FLAG_STRENGTH_STRONG',0x20000000)
    win_const_mgr.add_const('JOB_OBJECT_UILIMIT_READCLIPBOARD',0x00000002)
    win_const_mgr.add_const('WINHTTP_CALLBACK_STATUS_HEADERS_AVAILABLE',0x00020000)
    win_const_mgr.add_const('OID_802_11_RTS_THRESHOLD',0x0D01020A)
    win_const_mgr.add_const('RUNDLGORD',0x00000609)
    win_const_mgr.add_const('SQL_CVT_DECIMAL',0x00000004)
    win_const_mgr.add_const('PARTITION_FAT_12',0x00000001)
    win_const_mgr.add_const('FLAG_NO_CSE_INVOKE',0x40000000)
    win_const_mgr.add_const('PARTITION_FAT_16',0x00000004)
    win_const_mgr.add_const('OLEMISC_ACTSLIKELABEL',0x00002000)
    win_const_mgr.add_const('MCI_VCR_SEEK_MARK',0x00020000)
    win_const_mgr.add_const('WSAESOCKTNOSUPPORT',0x0000273C)
    win_const_mgr.add_const('LM20_SERVICE_PAUSE_PENDING',0x00000008)
    win_const_mgr.add_const('MDM_MASK_AUTO_SPEED',0x00000007)
    win_const_mgr.add_const('CRYPT_MODE_CBCOFMI',0x0000000A)
    win_const_mgr.add_const('CE_TXFULL',0x00000100)
    win_const_mgr.add_const('IDS_IMPORTANCE',0x00011009)
    win_const_mgr.add_const('PROCESSOR_HITACHI_SH3E',0x00002714)
    win_const_mgr.add_const('PORT_AT3',0x000000CB)
    win_const_mgr.add_const('LUP_DUAL_ADDR',0x00200000)
    win_const_mgr.add_const('PORT_AT5',0x000000CD)
    win_const_mgr.add_const('EV_RING',0x00000100)
    win_const_mgr.add_const('PORT_AT7',0x000000CF)
    win_const_mgr.add_const('DI_MASK',0x00000001)
    win_const_mgr.add_const('DPNHADDRESSTYPE_SHAREDPORTS',0x00000004)
    win_const_mgr.add_const('DDBLT_ALPHADEST',0x00000001)
    win_const_mgr.add_const('MCI_DGV_STATUS_CONTRAST',0x00004007)
    win_const_mgr.add_const('DISPID_IHTMLOPSPROFILE_COMMITCHANGES',0x00000006)
    win_const_mgr.add_const('IMAGE_REL_CEE_ADDR32NB',0x00000003)
    win_const_mgr.add_const('_WIN32_IE_IE20',0x00000200)
    win_const_mgr.add_const('TBS_LEFT',0x00000004)
    win_const_mgr.add_const('NS_NIS',0x00000029)
    win_const_mgr.add_const('HTTP_LOG_FIELD_SERVER_IP',0x00000040)
    win_const_mgr.add_const('ITIR_KEY',0x00000008)
    win_const_mgr.add_const('NDR64_FC_BIND_PRIMITIVE',0x00000002)
    win_const_mgr.add_const('DCI_1632_ACCESS',0x00000040)
    win_const_mgr.add_const('STGM_CREATE',0x00001000)
    win_const_mgr.add_const('DBT_CUSTOMEVENT',0x00008006)
    win_const_mgr.add_const('PHONEERR_INVALPHONESTATE',0x90000014)
    win_const_mgr.add_const('LOCALE_SABBREVMONTHNAME11',0x0000004E)
    win_const_mgr.add_const('DDPF_PALETTEINDEXEDTO8',0x00000010)
    win_const_mgr.add_const('OPTION_MTU',0x0000001A)
    win_const_mgr.add_const('SFF_KEEPDOCINFO',0x00001000)
    win_const_mgr.add_const('ACL_REVISION1',0x00000001)
    win_const_mgr.add_const('SDP_ATTRIB_HID_REMOTE_WAKE',0x0000020A)
    win_const_mgr.add_const('PHONESTATE_DEVSPECIFIC',0x00100000)
    win_const_mgr.add_const('LINEAGENTSTATE_LOGGEDOFF',0x00000001)
    win_const_mgr.add_const('SM_CYSCREEN',0x00000001)
    win_const_mgr.add_const('ERROR_POSSIBLE_DEADLOCK',0x0000046B)
    win_const_mgr.add_const('CBR_128000',0x0001F400)
    win_const_mgr.add_const('UNDNAME_NO_MEMBER_TYPE',0x00000200)
    win_const_mgr.add_const('INVALID_FRAGMENT_ID',0x00000000)
    win_const_mgr.add_const('TVHT_ONITEMBUTTON',0x00000010)
    win_const_mgr.add_const('ISCSI_SECURITY_FLAG_AGGRESSIVE_MODE_ENABLED',0x00000008)
    win_const_mgr.add_const('SCARD_E_WRITE_TOO_MANY',0x80100028)
    win_const_mgr.add_const('INTERNET_CUSTOMDIAL_SAFE_FOR_UNATTENDED',0x00000001)
    win_const_mgr.add_const('LINEMEDIACONTROL_VOLUMEDOWN',0x00000200)
    win_const_mgr.add_const('TXTBIT_DISABLEDRAG',0x00001000)
    win_const_mgr.add_const('CP_RECTANGLE',0x00000001)
    win_const_mgr.add_const('BS_DIBPATTERNPT',0x00000006)
    win_const_mgr.add_const('SCTE_EAS_OOB_PID',0x00001FFC)
    win_const_mgr.add_const('ERROR_DS_EPOCH_MISMATCH',0x00002123)
    win_const_mgr.add_const('VK_DBE_ENTERWORDREGISTERMODE',0x00000000)
    win_const_mgr.add_const('WINHTTP_QUERY_IF_MATCH',0x00000038)
    win_const_mgr.add_const('OID_FDDI_MAC_NOT_COPIED_RATIO',0x03030248)
    win_const_mgr.add_const('DOT11_ASSOC_STATUS_SUCCESS',0x00000000)
    win_const_mgr.add_const('HTTP_LOG_FIELD_URI_QUERY',0x00000200)
    win_const_mgr.add_const('LINEDEVCAPFLAGS_MULTIPLEADDR',0x00000010)
    win_const_mgr.add_const('ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE',0x00001B66)
    win_const_mgr.add_const('SQL_DATETIME_LITERALS',0x00000077)
    win_const_mgr.add_const('DBPROPVAL_UP_DELETE',0x00000002)
    win_const_mgr.add_const('KAGPROP_SYSTEMFUNCTIONS',0x00000015)
    win_const_mgr.add_const('IMAGE_REL_IA64_SREL32',0x00000013)
    win_const_mgr.add_const('SERVICE_DEREGISTER',0x00000002)
    win_const_mgr.add_const('CERT_CHAIN_REVOCATION_CHECK_END_CERT',0x10000000)
    win_const_mgr.add_const('LINECALLSTATE_CONFERENCED',0x00000800)
    win_const_mgr.add_const('SQL_SR_GRANT_OPTION_FOR',0x00000010)
    win_const_mgr.add_const('VDMDBG_BREAK_DOSTASK',0x00000001)
    win_const_mgr.add_const('SYSTEM_MANDATORY_LABEL_NO_EXECUTE_UP',0x00000004)
    win_const_mgr.add_const('MF_256_BYTE_ALIGNMENT',0x00000000)
    win_const_mgr.add_const('IP6_ADDRESS_STRING_LENGTH',0x00000041)
    win_const_mgr.add_const('VK_VOLUME_DOWN',0x000000AE)
    win_const_mgr.add_const('ISCSI_LOGIN_OPTIONS_MAXIMUM_CONNECTIONS',0x00000004)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_DC_PROMOTION',0x00000021)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_REQUEST_EX',0x00000096)
    win_const_mgr.add_const('SQL_BP_SCROLL',0x00000040)
    win_const_mgr.add_const('EC_EXTDEVICE_MODE_CHANGE',0x00000031)
    win_const_mgr.add_const('ACL_REVISION',0x00000002)
    win_const_mgr.add_const('CMSG_KEY_AGREE_RECIPIENT',0x00000002)
    win_const_mgr.add_const('VK_DIVIDE',0x0000006F)
    win_const_mgr.add_const('DNS_RTYPE_ATMA',0x00002200)
    win_const_mgr.add_const('HTTP_QUERY_RETRY_AFTER',0x00000024)
    win_const_mgr.add_const('WM_NOTIFY',0x0000004E)
    win_const_mgr.add_const('ERROR_DS_NAME_ERROR_NO_MAPPING',0x00002118)
    win_const_mgr.add_const('IPPORT_RJE',0x0000004D)
    win_const_mgr.add_const('SHFMT_CANCEL',0xFFFFFFFE)
    win_const_mgr.add_const('ERROR_DS_ATT_NOT_DEF_IN_SCHEMA',0x0000206F)
    win_const_mgr.add_const('IPSEC_POLICY_FLAG_DONT_NEGOTIATE_SECOND_LIFETIME',0x00000040)
    win_const_mgr.add_const('HTCLIENT',0x00000001)
    win_const_mgr.add_const('CHANNEL_EVENT_INITIALIZED',0x00000000)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_EXCLUDE_BUILTIN_GROUPS',0x80008000)
    win_const_mgr.add_const('PSH_WIZARD97',0x01000000)
    win_const_mgr.add_const('WIA_IPS_DESKEW_Y',0x00001813)
    win_const_mgr.add_const('WIA_IPS_DESKEW_X',0x00001812)
    win_const_mgr.add_const('SFF_SELECTION',0x00008000)
    win_const_mgr.add_const('SFGAO_NEWCONTENT',0x00200000)
    win_const_mgr.add_const('LINEGENERATETERM_DONE',0x00000001)
    win_const_mgr.add_const('DCTT_DOWNLOAD',0x00000002)
    win_const_mgr.add_const('IDC_LP_AUTOMATIC',0x000003F8)
    win_const_mgr.add_const('IPXADDRESSLEN',0x00000016)
    win_const_mgr.add_const('OID_ATM_CALL_PROCEEDING',0x0801020B)
    win_const_mgr.add_const('TRANSACTIONMANAGER_SET_INFORMATION',0x00000002)
    win_const_mgr.add_const('RATING_THREE_STARS_MAX',0x0000003E)
    win_const_mgr.add_const('CSIDL_INTERNET_CACHE',0x00000020)
    win_const_mgr.add_const('WIA_DIP_DRIVER_VERSION',0x0000000F)
    win_const_mgr.add_const('SCERR_NOCARDNAME',0x00004000)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_PREPARE_COMPLETE',0x00000020)
    win_const_mgr.add_const('SQL_INTERVAL_DAY_TO_SECOND',0x00000064)
    win_const_mgr.add_const('SMC_EXITMENU',0x00000003)
    win_const_mgr.add_const('ACM_FORMATDETAILSF_QUERYMASK',0x0000000F)
    win_const_mgr.add_const('INTERNET_OPTION_ASYNC_ID',0x0000000F)
    win_const_mgr.add_const('PROP_LG_CYDLG',0x000000DA)
    win_const_mgr.add_const('POLICY_ERRV_GLOBAL_DEF_FLOW_RATE',0x00000011)
    win_const_mgr.add_const('DISPID_IWRITEENGINE2_ENDINGSECTORSPERSECOND',0x00000103)
    win_const_mgr.add_const('CBN_DROPDOWN',0x00000007)
    win_const_mgr.add_const('DVASPECT_SHORTNAME',0x00000002)
    win_const_mgr.add_const('WSAEISCONN',0x00002748)
    win_const_mgr.add_const('RDW_ERASENOW',0x00000200)
    win_const_mgr.add_const('MCI_VCR_GETDEVCAPS_CAN_MONITOR_SOURCES',0x00004009)
    win_const_mgr.add_const('CM_PROB_REGISTRY',0x00000013)
    win_const_mgr.add_const('ERROR_CLUSTER_NETWORK_NOT_INTERNAL',0x000013C4)
    win_const_mgr.add_const('META_FLOODFILL',0x00000419)
    win_const_mgr.add_const('PE_ATTRIB_TYPE_CREDENTIAL',0x00000002)
    win_const_mgr.add_const('TXFS_RM_FLAG_LOG_CONTAINER_COUNT_MIN',0x00000008)
    win_const_mgr.add_const('IOF_CHECKLINK',0x00000008)
    win_const_mgr.add_const('TVIS_USERMASK',0x0000F000)
    win_const_mgr.add_const('SPI_SETMOUSECLICKLOCKTIME',0x00002009)
    win_const_mgr.add_const('CR_APM_VETOED',0x00000018)
    win_const_mgr.add_const('LVGA_FOOTER_LEFT',0x00000008)
    win_const_mgr.add_const('TTI_INFO_LARGE',0x00000004)
    win_const_mgr.add_const('RTCEF_BUDDY',0x00000100)
    win_const_mgr.add_const('LPM_RESULT_READY',0x00000000)
    win_const_mgr.add_const('TR_PL',0x00000007)
    win_const_mgr.add_const('DS_GOOD_TIMESERV_FLAG',0x00000200)
    win_const_mgr.add_const('IPP_E_STATUS_CANNOTCOMPLETE',0xC0048101)
    win_const_mgr.add_const('RP_DSN_NOTIFY_MASK',0x0F000000)
    win_const_mgr.add_const('PHOTOACQ_DISABLE_AUTO_ROTATE',0x00000002)
    win_const_mgr.add_const('JOB_STATUS_SPOOLING',0x00000008)
    win_const_mgr.add_const('EDS_RAWMODE',0x00000002)
    win_const_mgr.add_const('KDF_SECRET_HANDLE',0x00000006)
    win_const_mgr.add_const('FS_HANDLED',0x20000010)
    win_const_mgr.add_const('TVNRET_SKIPNEW',0x00000002)
    win_const_mgr.add_const('WINHTTP_CALLBACK_STATUS_DATA_AVAILABLE',0x00040000)
    win_const_mgr.add_const('ACCESS_MAX_MS_V4_ACE_TYPE',0x00000008)
    win_const_mgr.add_const('ERROR_MAX_THRDS_REACHED',0x000000A4)
    win_const_mgr.add_const('ELEMENT_STATUS_AVOLTAG',0x20000000)
    win_const_mgr.add_const('CM_PROB_VXDLDR',0x00000014)
    win_const_mgr.add_const('WIA_DIP_VEND_DESC',0x00000003)
    win_const_mgr.add_const('DNF_UNUSED_29',0x20000000)
    win_const_mgr.add_const('SHTDN_REASON_MAJOR_APPLICATION',0x00040000)
    win_const_mgr.add_const('SQL_IDENTIFIER_CASE',0x0000001C)
    win_const_mgr.add_const('LANG_AFRIKAANS',0x00000036)
    win_const_mgr.add_const('MCI_DGV_SETVIDEO_SRC_NUMBER',0x00080000)
    win_const_mgr.add_const('KAGPROP_MARSHALLABLE',0x00000003)
    win_const_mgr.add_const('SMINV_REFRESH',0x00000001)
    win_const_mgr.add_const('TC_NORMAL',0x00000000)
    win_const_mgr.add_const('MK_E_LAST',0x800401EF)
    win_const_mgr.add_const('LANG_ROMANIAN',0x00000018)
    win_const_mgr.add_const('HTMLDLG_VERIFY',0x00000100)
    win_const_mgr.add_const('DNF_AUTHENTICODE_SIGNED',0x00020000)
    win_const_mgr.add_const('ABN_POSCHANGED',0x00000001)
    win_const_mgr.add_const('DNF_UNUSED_25',0x02000000)
    win_const_mgr.add_const('CACHE_HEADER_DATA_NOTIFICATION_FILTER',0x00000015)
    win_const_mgr.add_const('AE_LIM_UNKNOWN',0x00000000)
    win_const_mgr.add_const('SPI_SETKEYBOARDDELAY',0x00000017)
    win_const_mgr.add_const('SQL_NUM_FUNCTIONS',0x00000017)
    win_const_mgr.add_const('IRLMP_PARAMETERS',0x00000018)
    win_const_mgr.add_const('STD_DELETE',0x00000005)
    win_const_mgr.add_const('ICU_ENCODE_PERCENT',0x00001000)
    win_const_mgr.add_const('EXITEVENT_INVALID',0x00000000)
    win_const_mgr.add_const('MAXWORD',0x00000000)
    win_const_mgr.add_const('MAX_SUBSTREAMS',0x0000000F)
    win_const_mgr.add_const('ARCONTENT_PHASE_MASK',0x70000000)
    win_const_mgr.add_const('MCI_VCR_SET_CLOCK',0x04000000)
    win_const_mgr.add_const('TMT_SCROLLBAR',0x00000641)
    win_const_mgr.add_const('TYPE_ENUMFONTS',0x00000001)
    win_const_mgr.add_const('BOM_NEUTRALOVERRIDE',0x00000004)
    win_const_mgr.add_const('MP_STATUS_ABANDON_DELIVERY',0x00000006)
    win_const_mgr.add_const('ERROR_EVENT_PENDING',0x000002C7)
    win_const_mgr.add_const('BNEP_PROTOCOL_UUID16',0x0000000F)
    win_const_mgr.add_const('KS_VIDEO_FLAG_FIELD2',0x00000002)
    win_const_mgr.add_const('MM_MIM_LONGERROR',0x000003C6)
    win_const_mgr.add_const('REO_SELECTED',0x08000000)
    win_const_mgr.add_const('KS_VIDEO_FLAG_FIELD1',0x00000001)
    win_const_mgr.add_const('PHONEBUTTONMODE_CALL',0x00000002)
    win_const_mgr.add_const('DNSSEC_KEY_FLAG_USER',0x00000000)
    win_const_mgr.add_const('ERROR_CTX_CLIENT_QUERY_TIMEOUT',0x00001B80)
    win_const_mgr.add_const('SQL_NO_ACTION',0x00000003)
    win_const_mgr.add_const('SC_ARRANGE',0x0000F110)
    win_const_mgr.add_const('RDW_VALIDATE',0x00000008)
    win_const_mgr.add_const('BS_HATCHED',0x00000002)
    win_const_mgr.add_const('CERT_TRUST_IS_OFFLINE_REVOCATION',0x01000000)
    win_const_mgr.add_const('INDEX_GUID_LINE',0x00000008)
    win_const_mgr.add_const('MQMSG_PRIV_LEVEL_NONE',0x00000000)
    win_const_mgr.add_const('OPAQUEKEYBLOB',0x00000009)
    win_const_mgr.add_const('LINECALLFEATURE2_TRANSFERNORM',0x00000040)
    win_const_mgr.add_const('PROP_SD',0x00000200)
    win_const_mgr.add_const('ETO_RTLREADING',0x00000080)
    win_const_mgr.add_const('POLICY_ERRV_SUBNET_DEF_FLOW_DURATION',0x0000000D)
    win_const_mgr.add_const('WINHTTP_OPTION_CALLBACK',0x00000001)
    win_const_mgr.add_const('N_BTSHFT',0x00000004)
    win_const_mgr.add_const('DI_AUTOASSIGNRES',0x00000040)
    win_const_mgr.add_const('IAS_MAX_CLASSNAME',0x00000040)
    win_const_mgr.add_const('ERROR_DS_CODE_INCONSISTENCY',0x000020D8)
    win_const_mgr.add_const('CF_FORCEFONTEXIST',0x00010000)
    win_const_mgr.add_const('MCI_DGV_SETAUDIO_ALG',0x00040000)
    win_const_mgr.add_const('CLUS_NO_MODIFY',0x00000000)
    win_const_mgr.add_const('CLIENTSITE_E_FIRST',0x80040190)
    win_const_mgr.add_const('EN_UPDATE',0x00000400)
    win_const_mgr.add_const('PRINTTICKET_ISTREAM_APIS',0x00000001)
    win_const_mgr.add_const('CHANNEL_RC_NOT_CONNECTED',0x00000004)
    win_const_mgr.add_const('JIFMK_RST1',0x0000FFD1)
    win_const_mgr.add_const('SECURITY_LOCAL_SYSTEM_RID',0x00000012)
    win_const_mgr.add_const('DOT11_STATUS_RETRY_LIMIT_EXCEEDED',0x00000002)
    win_const_mgr.add_const('HCBT_DESTROYWND',0x00000004)
    win_const_mgr.add_const('ERROR_NOT_SUBSTED',0x00000089)
    win_const_mgr.add_const('SQL_CD_FALSE',0x00000000)
    win_const_mgr.add_const('JIFMK_RST3',0x0000FFD3)
    win_const_mgr.add_const('SFGAO_REMOVABLE',0x02000000)
    win_const_mgr.add_const('NETE_NOMEMORY',0x00000001)
    win_const_mgr.add_const('EC_COMPLETE',0x00000001)
    win_const_mgr.add_const('DISPID_IWRITEENGINE2_CANCELWRITE',0x00000201)
    win_const_mgr.add_const('SERVICE_FLAG_HARD',0x00000002)
    win_const_mgr.add_const('WMDM_DEVICECAP_CANSTREAMRECORD',0x00000008)
    win_const_mgr.add_const('WPF_ENABLE_LOCAL_BASE_DIR',0x00100000)
    win_const_mgr.add_const('ALG_SID_SHA1',0x00000004)
    win_const_mgr.add_const('WS_TABSTOP',0x00010000)
    win_const_mgr.add_const('WSA_E_CANCELLED',0x0000277F)
    win_const_mgr.add_const('SUBLANG_ENGLISH_JAMAICA',0x00000008)
    win_const_mgr.add_const('OPTION_BOOTFILE_NAME',0x00000043)
    win_const_mgr.add_const('ERROR_TOO_MANY_SECRETS',0x00000565)
    win_const_mgr.add_const('X3_OPCODE_INST_WORD_X',0x00000003)
    win_const_mgr.add_const('DISPID_BEFORENAVIGATE2',0x000000FA)
    win_const_mgr.add_const('TMT_INFOTEXT',0x00000658)
    win_const_mgr.add_const('LINEQOSSERVICELEVEL_IFAVAILABLE',0x00000002)
    win_const_mgr.add_const('MQ_MIN_PRIORITY',0x00000000)
    win_const_mgr.add_const('SDP_ATTRIB_CLASS_ID_LIST',0x00000001)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_SECLOADFAIL',0x0000361C)
    win_const_mgr.add_const('AVIFILECAPS_ALLKEYFRAMES',0x00000010)
    win_const_mgr.add_const('WIA_IPA_DATATYPE',0x00001007)
    win_const_mgr.add_const('LB_GETTOPINDEX',0x0000018E)
    win_const_mgr.add_const('DISPID_MOUSEOUT',0x0000000C)
    win_const_mgr.add_const('LDAP_MSG_ALL',0x00000001)
    win_const_mgr.add_const('RTS_CONTROL_TOGGLE',0x00000003)
    win_const_mgr.add_const('EVENT_TRACE_FILE_MODE_APPEND',0x00000004)
    win_const_mgr.add_const('CERT_FILTER_VALID_TIME_RANGE',0x00000002)
    win_const_mgr.add_const('DMSTATEFLAG_APPLYTOALL',0x00000001)
    win_const_mgr.add_const('BCRYPT_DH_PUBLIC_MAGIC',0x42504844)
    win_const_mgr.add_const('EAP_FLAG_NON_INTERACTIVE',0x00000002)
    win_const_mgr.add_const('LISTEN_OUTSTANDING',0x00000001)
    win_const_mgr.add_const('COMP_ELEM_POS_LEFT',0x00000010)
    win_const_mgr.add_const('ATSC_MGT_PID',0x00001FFB)
    win_const_mgr.add_const('URLACTION_SCRIPT_RUN',0x00001400)
    win_const_mgr.add_const('TMT_CUSTOMSPLITRECT',0x0000138C)
    win_const_mgr.add_const('GPC_BLOCK_POLICY',0x00000001)
    win_const_mgr.add_const('CS_VREDRAW',0x00000001)
    win_const_mgr.add_const('PDH_LOG_SAMPLE_TOO_SMALL',0xC0000BF8)
    win_const_mgr.add_const('D3DTEXOPCAPS_BLENDFACTORALPHA',0x00002000)
    win_const_mgr.add_const('IDS_CAP_STAT_CAP_FINI',0x000001F7)
    win_const_mgr.add_const('SUBLANG_SPANISH',0x00000001)
    win_const_mgr.add_const('VER_SUITE_STORAGE_SERVER',0x00002000)
    win_const_mgr.add_const('DOMAIN_USER_RID_KRBTGT',0x000001F6)
    win_const_mgr.add_const('RESTART_MAX_CMD_LINE',0x00000800)
    win_const_mgr.add_const('DC_DUPLEX',0x00000007)
    win_const_mgr.add_const('FAX_ERR_RULE_NOT_FOUND',0x00001B5D)
    win_const_mgr.add_const('VARCMP_GT',0x00000002)
    win_const_mgr.add_const('TXTBIT_SAVESELECTION',0x00000040)
    win_const_mgr.add_const('NOTE_COLOR_GREEN',0x00000001)
    win_const_mgr.add_const('ICDRAW_QUERY',0x00000001)
    win_const_mgr.add_const('IP_ADAPTER_DDNS_ENABLED',0x00000001)
    win_const_mgr.add_const('ERROR_DS_SERVER_DOWN',0x0000203A)
    win_const_mgr.add_const('DDFXCAPS_BLTROTATION',0x00000100)
    win_const_mgr.add_const('PAN_ANY',0x00000000)
    win_const_mgr.add_const('CMSG_VERIFY_SIGNER_CERT',0x00000002)
    win_const_mgr.add_const('CS_E_LAST',0x8004016F)
    win_const_mgr.add_const('BG_E_TOO_MANY_RANGES_IN_FILE',0x80200052)
    win_const_mgr.add_const('TASK_FLAG_START_ONLY_IF_IDLE',0x00000010)
    win_const_mgr.add_const('WLAN_PROFILE_GROUP_POLICY',0x00000001)
    win_const_mgr.add_const('USER_USR_COMMENT_PARMNUM',0x0000000C)
    win_const_mgr.add_const('SM_CYMENU',0x0000000F)
    win_const_mgr.add_const('JOB_NOTIFY_FIELD_BYTES_PRINTED',0x00000017)
    win_const_mgr.add_const('IMAGE_REL_BASED_IA64_PCREL21',0x0000000B)
    win_const_mgr.add_const('PFM_KEEP',0x00020000)
    win_const_mgr.add_const('LINEDIGITMODE_DTMF',0x00000002)
    win_const_mgr.add_const('PSR_DI',0x00000016)
    win_const_mgr.add_const('ERROR_DS_DRS_EXTENSIONS_CHANGED',0x00002192)
    win_const_mgr.add_const('CF_NOSIZESEL',0x00200000)
    win_const_mgr.add_const('LVS_SORTASCENDING',0x00000010)
    win_const_mgr.add_const('CERT_TRUST_IS_COMPLEX_CHAIN',0x00010000)
    win_const_mgr.add_const('PSR_DA',0x00000026)
    win_const_mgr.add_const('PSR_DB',0x00000018)
    win_const_mgr.add_const('ERROR_SXS_XML_E_MULTIPLE_COLONS',0x000036DE)
    win_const_mgr.add_const('ERROR_INVALID_SUB_AUTHORITY',0x00000537)
    win_const_mgr.add_const('IDM_ARRANGEBOTTOM',0x00000008)
    win_const_mgr.add_const('META_ARC',0x00000817)
    win_const_mgr.add_const('LOAD_WITH_ALTERED_SEARCH_PATH',0x00000008)
    win_const_mgr.add_const('PSR_DT',0x00000011)
    win_const_mgr.add_const('MD_ERROR_SUB404_QUERY_STRING_TOO_LONG',0x0000000F)
    win_const_mgr.add_const('WMDM_E_INVALIDTYPE',0x80045002)
    win_const_mgr.add_const('FACILITY_NDIS_ERROR_CODE',0x00000023)
    win_const_mgr.add_const('DEBUG_DUMP_FILE_PAGE_FILE_DUMP',0x00000000)
    win_const_mgr.add_const('TYPE_VALUE',0x00000000)
    win_const_mgr.add_const('CDEF_DEVMON_FILTER',0x00000080)
    win_const_mgr.add_const('DISPID_HTMLDLG',0x000061A8)
    win_const_mgr.add_const('TVC_BYMOUSE',0x00000001)
    win_const_mgr.add_const('PIDDSI_LINKSDIRTY',0x00000010)
    win_const_mgr.add_const('PROTO_IP_DIFFSERV',0x00002718)
    win_const_mgr.add_const('D3DTA_SELECTMASK',0x00000000)
    win_const_mgr.add_const('FWPM_ACTRL_ENUM',0x00000020)
    win_const_mgr.add_const('ERROR_DRIVER_FAILED_PRIOR_UNLOAD',0x0000028E)
    win_const_mgr.add_const('IPV6_IFLIST',0x0000001C)
    win_const_mgr.add_const('FILE_DEVICE_VMBUS',0x0000003E)
    win_const_mgr.add_const('SQL_COPT_SS_BASE',0x000004B0)
    win_const_mgr.add_const('ERROR_WX86_WARNING',0x0000021B)
    win_const_mgr.add_const('MAX_MCAST_TTL',0x000000FF)
    win_const_mgr.add_const('ERROR_IPSEC_MM_FILTER_NOT_FOUND',0x000032CF)
    win_const_mgr.add_const('RTL_CRITICAL_SECTION_FLAG_STATIC_INIT',0x04000000)
    win_const_mgr.add_const('RI_MOUSE_BUTTON_4_UP',0x00000080)
    win_const_mgr.add_const('SQL_AT_CONSTRAINT_NAME_DEFINITION',0x00008000)
    win_const_mgr.add_const('CERT_STORE_CREATE_NEW_FLAG',0x00002000)
    win_const_mgr.add_const('STATURL_QUERYFLAG_ISCACHED',0x00010000)
    win_const_mgr.add_const('WAVE_FORMAT_2M16',0x00000040)
    win_const_mgr.add_const('RECIPIENTPOLICYV1',0x00000001)
    win_const_mgr.add_const('WMDRM_KEYTYPE_COCKTAIL',0x00000001)
    win_const_mgr.add_const('GIL_PERCLASS',0x00000004)
    win_const_mgr.add_const('WINEVENT_CHANNEL_GLOBAL_SECURITY',0x00000000)
    win_const_mgr.add_const('DDFXCAPS_BLTALPHA',0x00000001)
    win_const_mgr.add_const('CM_GAMMA_RAMP',0x00000002)
    win_const_mgr.add_const('DEBUG_FILTER_GO_NOT_HANDLED',0x00000001)
    win_const_mgr.add_const('GCP_REORDER',0x00000002)
    win_const_mgr.add_const('WIA_DPS_PAGE_HEIGHT',0x00000C1B)
    win_const_mgr.add_const('_WIN32_WINNT_LONGHORN',0x00000600)
    win_const_mgr.add_const('IMAGE_REL_BASED_HIGHADJ',0x00000004)
    win_const_mgr.add_const('IDM_TRIED_DELETECELLS',0x00000015)
    win_const_mgr.add_const('CRYPT_OID_INFO_ALGID_KEY',0x00000003)
    win_const_mgr.add_const('LVGS_SELECTED',0x00000020)
    win_const_mgr.add_const('DNS_ERROR_NO_PACKET',0x0000251F)
    win_const_mgr.add_const('JOY_POVRIGHT',0x00002328)
    win_const_mgr.add_const('UIS_INITIALIZE',0x00000003)
    win_const_mgr.add_const('LANG_ARABIC',0x00000001)
    win_const_mgr.add_const('D3DSP_SWIZZLE_SHIFT',0x00000010)
    win_const_mgr.add_const('KSALLOCATOR_REQUIREMENTF_PREFERENCES_ONLY',0x80000000)
    win_const_mgr.add_const('LINEBUSYMODE_TRUNK',0x00000002)
    win_const_mgr.add_const('DBPROPVAL_NP_OKTODO',0x00000001)
    win_const_mgr.add_const('ERROR_CLUSTER_RESOURCE_TYPE_BUSY',0x00001715)
    win_const_mgr.add_const('CHECKSUM_OPEN_FAILURE',0x00000001)
    win_const_mgr.add_const('DE_E_NO_VALID_MEDIA',0x800C000A)
    win_const_mgr.add_const('PORT_SNMP',0x000000A1)
    win_const_mgr.add_const('DNS_TYPE_NS',0x00000002)
    win_const_mgr.add_const('DOT11_ASSOC_STATUS_PHY_DISABLED',0x00000004)
    win_const_mgr.add_const('PORT_DCP',0x0000005D)
    win_const_mgr.add_const('INTERNET_COOKIE_PROMPT_REQUIRED',0x00000020)
    win_const_mgr.add_const('TM_JOIN',0x00000002)
    win_const_mgr.add_const('WPP_POST_POSTING_URL_ERROR',0xC0042381)
    win_const_mgr.add_const('STATUS_SEVERITY_ERROR',0x00000003)
    win_const_mgr.add_const('WH_SYSMSGFILTER',0x00000006)
    win_const_mgr.add_const('IF_TYPE_ISO88025_TOKENRING',0x00000009)
    win_const_mgr.add_const('FILE_FLAG_SEQUENTIAL_SCAN',0x08000000)
    win_const_mgr.add_const('RPC_C_HTTP_AUTHN_SCHEME_BASIC',0x00000001)
    win_const_mgr.add_const('VPDF_SKIPINTELSLCHECK',0x00000004)
    win_const_mgr.add_const('PTE_WRITE_MASK',0x00000400)
    win_const_mgr.add_const('PAN_PROP_VERY_CONDENSED',0x00000008)
    win_const_mgr.add_const('MQMSG_AUTHENTICATED_SIGXML',0x00000009)
    win_const_mgr.add_const('INTERNET_STATUS_P3P_POLICYREF',0x00000146)
    win_const_mgr.add_const('SHARE_NETNAME_PARMNUM',0x00000001)
    win_const_mgr.add_const('NDR64_FC_BIND_GENERIC',0x00000001)
    win_const_mgr.add_const('CERT_TRUST_HAS_NOT_SUPPORTED_CRITICAL_EXT',0x08000000)
    win_const_mgr.add_const('ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT',0x0000170F)
    win_const_mgr.add_const('EVENT_SYSTEM_CONTEXTHELPSTART',0x0000000C)
    win_const_mgr.add_const('SV_TIMESOURCE_PARMNUM',0x00000204)
    win_const_mgr.add_const('EAP_E_SERVER_CERT_INVALID',0x80420201)
    win_const_mgr.add_const('MSIM_LIST_CONTACT',0x00000001)
    win_const_mgr.add_const('CMC_FAIL_BAD_IDENTITY',0x00000007)
    win_const_mgr.add_const('FIND_ENDSWITH',0x00200000)
    win_const_mgr.add_const('ODBC_ERROR_REMOVE_DSN_FAILED',0x00000014)
    win_const_mgr.add_const('DISPID_CANADVANCEERROR',0x0000000C)
    win_const_mgr.add_const('IP_RECEIVE_BROADCAST',0x00000016)
    win_const_mgr.add_const('WINHTTP_AUTH_SCHEME_BASIC',0x00000001)
    win_const_mgr.add_const('SIMULATED_FONTTYPE',0x00008000)
    win_const_mgr.add_const('VER_ERR_OPERAND',0x00000004)
    win_const_mgr.add_const('WIA_DPC_POWER_MODE',0x00000810)
    win_const_mgr.add_const('PDH_PLA_COLLECTION_NOT_FOUND',0xC0000BEB)
    win_const_mgr.add_const('COMP_ELEM_RESTORED_CSI',0x00002000)
    win_const_mgr.add_const('FIND_ACTCTX_SECTION_KEY_RETURN_FLAGS',0x00000002)
    win_const_mgr.add_const('HTTP_STATUS_CONFLICT',0x00000199)
    win_const_mgr.add_const('ETDT_USEAEROWIZARDTABTEXTURE',0x00000008)
    win_const_mgr.add_const('MCI_DGV_SETAUDIO_BLOCKALIGN',0x00004007)
    win_const_mgr.add_const('GPO_INFO_FLAG_SAFEMODE_BOOT',0x00000800)
    win_const_mgr.add_const('DBPROPVAL_TR_DONTCARE',0x00000040)
    win_const_mgr.add_const('CERT_STORE_SAVE_AS_PKCS12',0x00000003)
    win_const_mgr.add_const('NETLOGON_REPLICATION_IN_PROGRESS',0x00000002)
    win_const_mgr.add_const('SQL_BIND_TYPE',0x00000005)
    win_const_mgr.add_const('DCI_CAN_STRETCHXN',0x00004000)
    win_const_mgr.add_const('ENM_CORRECTTEXT',0x00400000)
    win_const_mgr.add_const('PHONEFEATURE_GETVOLUMEHANDSET',0x00000800)
    win_const_mgr.add_const('D3DFVF_TEXTUREFORMAT4',0x00000002)
    win_const_mgr.add_const('DEBUG_OUTSYM_DEFAULT',0x00000000)
    win_const_mgr.add_const('SPI_SETCLEARTYPE',0x00001049)
    win_const_mgr.add_const('EVENT_HEADER_EXT_TYPE_SID',0x00000002)
    win_const_mgr.add_const('SF_MAX_USERNAME',0x00000100)
    win_const_mgr.add_const('BL_4M',0x00400000)
    win_const_mgr.add_const('SM_FOCUS_TYPE_WFW_SERVER',0x00000006)
    win_const_mgr.add_const('PFM_NUMBERINGTAB',0x00004000)
    win_const_mgr.add_const('SFC_SCAN_IMMEDIATE',0x00000003)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_LOCAL_GROUPS',0x80000002)
    win_const_mgr.add_const('ERROR_CLUSTER_NODE_NOT_MEMBER',0x000013BC)
    win_const_mgr.add_const('META_DIBCREATEPATTERNBRUSH',0x00000142)
    win_const_mgr.add_const('CRYPT_HTTP_POST_RETRIEVAL',0x00100000)
    win_const_mgr.add_const('C2_RIGHTTOLEFT',0x00000002)
    win_const_mgr.add_const('BTH_MFG_TTPCOM',0x0000001A)
    win_const_mgr.add_const('MNGO_NOERROR',0x00000001)
    win_const_mgr.add_const('DS_REPSYNC_REQUEUE',0x00040000)
    win_const_mgr.add_const('WMDM_DEVICECAP_CANSEEK',0x00000080)
    win_const_mgr.add_const('NCRYPTBUFFER_DATA',0x00000001)
    win_const_mgr.add_const('UF_PASSWORD_EXPIRED',0x00800000)
    win_const_mgr.add_const('ERROR_BAD_CLUSTERS',0x00001AC1)
    win_const_mgr.add_const('SF_TEXTIZED',0x00000004)
    win_const_mgr.add_const('ETO_OPAQUE',0x00000002)
    win_const_mgr.add_const('LINEPROXYSTATUS_CLOSE',0x00000002)
    win_const_mgr.add_const('NTMS_BARCODE_LENGTH',0x00000040)
    win_const_mgr.add_const('HTTP_STATUS_SWITCH_PROTOCOLS',0x00000065)
    win_const_mgr.add_const('ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME',0x0000370B)
    win_const_mgr.add_const('CERT_SYSTEM_STORE_CURRENT_USER_ID',0x00000001)
    win_const_mgr.add_const('KSDATARANGE_ATTRIBUTES',0x00000001)
    win_const_mgr.add_const('PAN_PROP_EXPANDED',0x00000005)
    win_const_mgr.add_const('WIA_PROP_NONE',0x00000008)
    win_const_mgr.add_const('ENABLE_EXTENDED_FLAGS',0x00000080)
    win_const_mgr.add_const('HELP_INDEX',0x00000003)
    win_const_mgr.add_const('WSAELOOP',0x0000274E)
    win_const_mgr.add_const('SV_BALANCECOUNT_PARMNUM',0x00000241)
    win_const_mgr.add_const('ERROR_PRINTER_DRIVER_ALREADY_INSTALLED',0x00000703)
    win_const_mgr.add_const('BS_ICON',0x00000040)
    win_const_mgr.add_const('EWX_REBOOT',0x00000002)
    win_const_mgr.add_const('HHWIN_BUTTON_STOP',0x00000001)
    win_const_mgr.add_const('DI_FLAGSEX_DRIVERLIST_FROM_URL',0x00200000)
    win_const_mgr.add_const('CTL_FIND_MD5_HASH',0x00000002)
    win_const_mgr.add_const('VK_DBE_KATAKANA',0x00000000)
    win_const_mgr.add_const('DCR_PP',0x00000000)
    win_const_mgr.add_const('WIA_PAGE_ISO_A8',0x0000000E)
    win_const_mgr.add_const('WIA_PAGE_ISO_A9',0x0000000F)
    win_const_mgr.add_const('WIA_PAGE_ISO_A6',0x0000000C)
    win_const_mgr.add_const('WIA_PAGE_ISO_A7',0x0000000D)
    win_const_mgr.add_const('MCI_WAVE_SET_ANYINPUT',0x04000000)
    win_const_mgr.add_const('DISPLAYDIB_NOFLIP',0x00000800)
    win_const_mgr.add_const('WIA_PAGE_ISO_A2',0x00000009)
    win_const_mgr.add_const('DN_HAS_PROBLEM',0x00000400)
    win_const_mgr.add_const('WIA_PAGE_ISO_A0',0x00000007)
    win_const_mgr.add_const('IMAGE_COMPRESSION_JPEG',0x00000006)
    win_const_mgr.add_const('LINEDIGITMODE_PULSE',0x00000001)
    win_const_mgr.add_const('ERROR_CLUSTER_NODE_ALREADY_UP',0x000013C5)
    win_const_mgr.add_const('SM_CXPADDEDBORDER',0x0000005C)
    win_const_mgr.add_const('TV_FIRST',0x00001100)
    win_const_mgr.add_const('CM_REMOVAL_POLICY_EXPECT_SURPRISE_REMOVAL',0x00000003)
    win_const_mgr.add_const('AMCONTROL_USED',0x00000001)
    win_const_mgr.add_const('STATE_SYSTEM_SELFVOICING',0x00080000)
    win_const_mgr.add_const('DEBUG_PROC_DESC_NO_MTS_PACKAGES',0x00000004)
    win_const_mgr.add_const('FAX_ERR_GROUP_NOT_FOUND',0x00001B5A)
    win_const_mgr.add_const('SQL_CVT_FLOAT',0x00000020)
    win_const_mgr.add_const('SQL_FN_NUM_TAN',0x00008000)
    win_const_mgr.add_const('MAPI_PW_FIRST_PROFILE',0x00000001)
    win_const_mgr.add_const('WS_GROUP',0x00020000)
    win_const_mgr.add_const('COLOR_SAMPLES',0x000002CD)
    win_const_mgr.add_const('ERROR_SCREEN_ALREADY_LOCKED',0x000005A0)
    win_const_mgr.add_const('CSRESTORE_TYPE_ONLINE',0x00000002)
    win_const_mgr.add_const('BG_E_TOO_MANY_JOBS_PER_MACHINE',0x80200050)
    win_const_mgr.add_const('TRUSTERROR_STEP_MSG_SIGNERCERT',0x0000000E)
    win_const_mgr.add_const('SI_ADVANCED',0x00000010)
    win_const_mgr.add_const('MCI_VCR_STATUS_VIDEO_SOURCE_NUMBER',0x00004009)
    win_const_mgr.add_const('WIA_DPS_SHOW_PREVIEW_CONTROL',0x00000C1F)
    win_const_mgr.add_const('DDFXCAPS_BLTSHRINKY',0x00001000)
    win_const_mgr.add_const('SPFILENOTIFY_STARTCOPY',0x00000000)
    win_const_mgr.add_const('HDF_JUSTIFYMASK',0x00000003)
    win_const_mgr.add_const('OID_GEN_VENDOR_ID',0x0001010C)
    win_const_mgr.add_const('DIF_NEWDEVICEWIZARD_PRESELECT',0x0000001A)
    win_const_mgr.add_const('PORT_UUCPD',0x0000021C)
    win_const_mgr.add_const('ILGOS_ALWAYS',0x00000000)
    win_const_mgr.add_const('C2_COMMONSEPARATOR',0x00000007)
    win_const_mgr.add_const('IDM_SIZETOCONTROL',0x00000023)
    win_const_mgr.add_const('SPQ_FLAG_BACKUP_AWARE',0x00000001)
    win_const_mgr.add_const('DEBUG_PHYSICAL_WRITE_COMBINED',0x00000003)
    win_const_mgr.add_const('ALG_TYPE_STREAM',0x00000004)
    win_const_mgr.add_const('ISSCERT_FILEURL_OLD',0x00000008)
    win_const_mgr.add_const('CMS_BACKWARD',0x00000001)
    win_const_mgr.add_const('EXCHIVERB_RESERVED_DELIVERY',0x0000006B)
    win_const_mgr.add_const('BTH_ERROR_UKNOWN_LMP_PDU',0x00000019)
    win_const_mgr.add_const('CFS_FORCE_POSITION',0x00000020)
    win_const_mgr.add_const('DEX_IDS_INSTALL_PROBLEM',0x0000057C)
    win_const_mgr.add_const('TCHT_ONITEMICON',0x00000002)
    win_const_mgr.add_const('WSAEDQUOT',0x00002755)
    win_const_mgr.add_const('IDM_DYNSRCSTOP',0x000008E0)
    win_const_mgr.add_const('CERT_PROT_ROOT_DISABLE_NT_AUTH_REQUIRED_FLAG',0x00000010)
    win_const_mgr.add_const('IDS_CC',0x00011005)
    win_const_mgr.add_const('DEBUG_SYMENT_IS_DATA',0x00000002)
    win_const_mgr.add_const('DS_REPSYNC_CRITICAL',0x00200000)
    win_const_mgr.add_const('DIF_INSTALLWIZARD',0x00000010)
    win_const_mgr.add_const('DOT11_STATUS_PACKET_REASSEMBLED',0x00001000)
    win_const_mgr.add_const('DMPAPER_A4_EXTRA',0x00000035)
    win_const_mgr.add_const('IMAGE_REL_IA64_SECREL32',0x0000000E)
    win_const_mgr.add_const('CERT_TRUST_DO_FULL_TRUST',0x00000005)
    win_const_mgr.add_const('IME_ESC_RESERVED_FIRST',0x00000004)
    win_const_mgr.add_const('SECPKG_FLAG_PRIVACY',0x00000002)
    win_const_mgr.add_const('MCI_INFO_NAME',0x00001000)
    win_const_mgr.add_const('CPF_CASTORE_ERROR',0x00000010)
    win_const_mgr.add_const('PAN_FAMILY_DECORATIVE',0x00000004)
    win_const_mgr.add_const('SQL_AD_CONSTRAINT_NAME_DEFINITION',0x00000001)
    win_const_mgr.add_const('FS_CALL_DELAYED',0x20002000)
    win_const_mgr.add_const('DB_IMP_LEVEL_ANONYMOUS',0x00000000)
    win_const_mgr.add_const('WNODE_FLAG_TOO_SMALL',0x00000020)
    win_const_mgr.add_const('SI_RESET_SACL',0x00080000)
    win_const_mgr.add_const('ICW_LAUNCHEDMANUAL',0x00000200)
    win_const_mgr.add_const('PICTYPE_METAFILE',0x00000002)
    win_const_mgr.add_const('IMAGE_FILE_MACHINE_TRICORE',0x00000520)
    win_const_mgr.add_const('DNS_RCLASS_HESIOD',0x00000400)
    win_const_mgr.add_const('DEBUG_CLASS_UNINITIALIZED',0x00000000)
    win_const_mgr.add_const('CALENDAR_SHOWTIMEAS_FREE',0x00000000)
    win_const_mgr.add_const('VER_SUITENAME',0x00000040)
    win_const_mgr.add_const('OID_FDDI_PORT_NEIGHBOR_TYPE',0x0303025D)
    win_const_mgr.add_const('MCI_DGV_FILE_MODE_LOADING',0x00000002)
    win_const_mgr.add_const('IMPORTANCE_HIGH_MIN',0x00000005)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_CO_PROTOCOL_CHARACTERISTICS',0x00000090)
    win_const_mgr.add_const('EAP_E_EAPHOST_METHOD_INVALID_PACKET',0x80420017)
    win_const_mgr.add_const('HIGH_SURROGATE_END',0x00000000)
    win_const_mgr.add_const('SP_PROT_NONE',0x00000000)
    win_const_mgr.add_const('ERROR_ACCOUNT_DISABLED',0x00000533)
    win_const_mgr.add_const('DOT11_ASSOC_STATUS_REASON_CODE_MASK',0x00000000)
    win_const_mgr.add_const('LB_SETANCHORINDEX',0x0000019C)
    win_const_mgr.add_const('KRAF_DISABLEUSEDEFAULTPROVIDER',0x00000008)
    win_const_mgr.add_const('BCRYPT_SECRET_AGREEMENT_OPERATION',0x00000008)
    win_const_mgr.add_const('METHOD_TYPE_ALL_METHODS',0xFFFFFFFF)
    win_const_mgr.add_const('DPNHCAPSFLAG_PUBLICADDRESSAVAILABLE',0x00000008)
    win_const_mgr.add_const('CM_DRP_REMOVAL_POLICY_HW_DEFAULT',0x00000021)
    win_const_mgr.add_const('ISR_ED',0x0000002B)
    win_const_mgr.add_const('FR_HIDEMATCHCASE',0x00008000)
    win_const_mgr.add_const('PERF_AGGREGATE_MAX',0x00000004)
    win_const_mgr.add_const('SQL_SCCO_READ_ONLY',0x00000001)
    win_const_mgr.add_const('RATING_FOUR_STARS_MAX',0x00000057)
    win_const_mgr.add_const('CTRY_AZERBAIJAN',0x000003E2)
    win_const_mgr.add_const('ISR_EI',0x00000029)
    win_const_mgr.add_const('WINEVENT_OPCODE_RECEIVE',0x00000000)
    win_const_mgr.add_const('ERROR_GROUP_NOT_FOUND',0x00001395)
    win_const_mgr.add_const('DC_COLLATE',0x00000016)
    win_const_mgr.add_const('D3DFVF_XYZ',0x00000002)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_OTHER',0x00000001)
    win_const_mgr.add_const('NETBIOS_TYPE_QUICK_UNIQUE',0x00000002)
    win_const_mgr.add_const('WINEVENT_OPCODE_DC_STOP',0x00000004)
    win_const_mgr.add_const('ERROR_CTX_CLOSE_PENDING',0x00001B5F)
    win_const_mgr.add_const('OT_STATIC',0x00000003)
    win_const_mgr.add_const('TAPE_FIXED_PARTITIONS',0x00000000)
    win_const_mgr.add_const('KSALLOCATOR_OPTIONF_VALID',0x00000003)
    win_const_mgr.add_const('USER_MARSHAL_FC_SHORT',0x00000006)
    win_const_mgr.add_const('CRLF_PRESERVE_EXPIRED_CA_CERTS',0x00040000)
    win_const_mgr.add_const('SHUTDOWN_TYPE_LEN',0x00000020)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_FILE_IO_INIT',0x04000000)
    win_const_mgr.add_const('LBS_MULTICOLUMN',0x00000200)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_SERVICEPACK_UNINSTALL',0x00000013)
    win_const_mgr.add_const('DDOVERFX_ARITHSTRETCHY',0x00000001)
    win_const_mgr.add_const('CAL_SABBREVDAYNAME2',0x00000000)
    win_const_mgr.add_const('CAL_SABBREVDAYNAME3',0x00000010)
    win_const_mgr.add_const('CAL_SABBREVDAYNAME4',0x00000011)
    win_const_mgr.add_const('TRANSPARENT',0x00000001)
    win_const_mgr.add_const('CAL_SABBREVDAYNAME6',0x00000013)
    win_const_mgr.add_const('SQL_DATE',0x00000009)
    win_const_mgr.add_const('CF_TIFF',0x00000006)
    win_const_mgr.add_const('SO_DONTROUTE',0x00000010)
    win_const_mgr.add_const('MEM_4MB_PAGES',0x80000000)
    win_const_mgr.add_const('STI_DEVSTATUS_EVENTS_STATE',0x00000002)
    win_const_mgr.add_const('D3DPMISCCAPS_POSTBLENDSRGBCONVERT',0x00200000)
    win_const_mgr.add_const('ILGT_NORMAL',0x00000000)
    win_const_mgr.add_const('ISDB_ERT_PID',0x00000021)
    win_const_mgr.add_const('SM_YVIRTUALSCREEN',0x0000004D)
    win_const_mgr.add_const('CERT_NAME_STR_NO_QUOTING_FLAG',0x10000000)
    win_const_mgr.add_const('CRESTRICTIONS_MDSCHEMA_MEMBERS',0x0000000C)
    win_const_mgr.add_const('DNS_ERROR_INVALID_NAME_CHAR',0x00002558)
    win_const_mgr.add_const('MAX_IDD_DYNAWIZ_RESOURCE_ID',0x00002AF8)
    win_const_mgr.add_const('LINECALLINFOSTATE_MEDIAMODE',0x00000010)
    win_const_mgr.add_const('MD_EXTLOG_SITE_NAME',0x00000010)
    win_const_mgr.add_const('SQL_DIAG_DROP_COLLATION',0x0000001A)
    win_const_mgr.add_const('SM_FOCUS_TYPE_LM_DOMAIN',0x00000002)
    win_const_mgr.add_const('CRYPT_DELETE_KEYSET',0x00000001)
    win_const_mgr.add_const('AA_A_WRITE',0x00002000)
    win_const_mgr.add_const('MAX_THEMESIZE',0x00000040)
    win_const_mgr.add_const('DEBUG_FORMAT_DEFAULT',0x00000000)
    win_const_mgr.add_const('STATUS_SEVERITY_RTC_ERROR',0x00000002)
    win_const_mgr.add_const('SCARD_W_SECURITY_VIOLATION',0x8010006A)
    win_const_mgr.add_const('MSIMWND_DISPID_ONSHOW',0x000000E3)
    win_const_mgr.add_const('BSSF_UNDELETEABLE',0x00001000)
    win_const_mgr.add_const('__SPECSTRINGS_STRICT_LEVEL',0x00000001)
    win_const_mgr.add_const('OID_GEN_LAST_CHANGE',0x00010281)
    win_const_mgr.add_const('IDS_CAP_STAT_CAP_INIT',0x000001F6)
    win_const_mgr.add_const('ERROR_DS_CANT_ON_NON_LEAF',0x00002015)
    win_const_mgr.add_const('SB_THUMBPOSITION',0x00000004)
    win_const_mgr.add_const('CERT_REQUEST_ORIGINATOR_PROP_ID',0x00000047)
    win_const_mgr.add_const('USER_HOME_DIR_PARMNUM',0x00000006)
    win_const_mgr.add_const('SCESTATUS_NO_MAPPING',0x00000012)
    win_const_mgr.add_const('FWPM_SUBSCRIPTION_FLAG_NOTIFY_ON_DELETE',0x00000002)
    win_const_mgr.add_const('DDPCAPS_8BIT',0x00000004)
    win_const_mgr.add_const('LC_INTERIORS',0x00000080)
    win_const_mgr.add_const('ERROR_INVALID_LB_MESSAGE',0x00000598)
    win_const_mgr.add_const('ERROR_BAD_ACCESSOR_FLAGS',0x00000305)
    win_const_mgr.add_const('WKSTA_UTILIZENTCACHING_PARMNUM',0x00000035)
    win_const_mgr.add_const('DNS_RCODE_SERVFAIL',0x00000002)
    win_const_mgr.add_const('D3DCAPS2_CANSHARERESOURCE',0x80000000)
    win_const_mgr.add_const('KSPROPERTY_TYPE_SERIALIZESIZE',0x00008000)
    win_const_mgr.add_const('LM20_UNLEN',0x00000014)
    win_const_mgr.add_const('BASE_PROTOCOL',0x00000001)
    win_const_mgr.add_const('KTM_MARSHAL_BLOB_VERSION_MINOR',0x00000001)
    win_const_mgr.add_const('MUTZ_REQUIRESAVEDFILECHECK',0x00000400)
    win_const_mgr.add_const('MS_PROFILE_GROUP_POLICY',0x00000001)
    win_const_mgr.add_const('PAN_FAMILYTYPE_INDEX',0x00000000)
    win_const_mgr.add_const('WM_HANDHELDFIRST',0x00000358)
    win_const_mgr.add_const('MCI_DEVTYPE_VCR',0x00000201)
    win_const_mgr.add_const('SCARD_NEGOTIABLE',0x00000005)
    win_const_mgr.add_const('CM_OPEN_CLASS_KEY_INTERFACE',0x00000001)
    win_const_mgr.add_const('HDI_FORMAT',0x00000004)
    win_const_mgr.add_const('ERROR_LOG_POLICY_INVALID',0x000019DD)
    win_const_mgr.add_const('IDM_HTMLAREA',0x00000882)
    win_const_mgr.add_const('MUI_MACHINE_LANGUAGE_SETTINGS',0x00000400)
    win_const_mgr.add_const('CBS_AUTOHSCROLL',0x00000040)
    win_const_mgr.add_const('FILEOP_DELETE',0x00000002)
    win_const_mgr.add_const('DISPID_ONFULLSCREEN',0x00000102)
    win_const_mgr.add_const('RASLCPAP_SPAP',0x0000C027)
    win_const_mgr.add_const('SCARD_COLD_RESET',0x00000001)
    win_const_mgr.add_const('TF_CLUIE_SELECTION',0x00000004)
    win_const_mgr.add_const('OID_802_11_NON_BCAST_SSID_LIST',0x0D010124)
    win_const_mgr.add_const('DI_FLAGSEX_PROPCHANGE_PENDING',0x00000400)
    win_const_mgr.add_const('SQL_API_SQLGETDESCFIELD',0x000003F0)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_IO_FLUSH',0x0000000E)
    win_const_mgr.add_const('ERROR_NO_RECOVERY_POLICY',0x00001773)
    win_const_mgr.add_const('WARNING_IPSEC_QM_POLICY_PRUNED',0x000032E1)
    win_const_mgr.add_const('D3DPBLENDCAPS_INVSRCALPHA',0x00000020)
    win_const_mgr.add_const('NI_DGRAM',0x00000010)
    win_const_mgr.add_const('LINE_QUEUESTATUS',0x0000001C)
    win_const_mgr.add_const('OPTION_NETWORK_INFO_SERVICE_DOM',0x00000028)
    win_const_mgr.add_const('PST_RS422',0x00000003)
    win_const_mgr.add_const('RPC_IF_ALLOW_LOCAL_ONLY',0x00000020)
    win_const_mgr.add_const('ERROR_INVALID_PRIMARY_GROUP',0x0000051C)
    win_const_mgr.add_const('PP_ENUMALGS',0x00000001)
    win_const_mgr.add_const('DSF_ALL_DEVICES',0x0000FFFF)
    win_const_mgr.add_const('IMAGE_SYM_TYPE_FLOAT',0x00000006)
    win_const_mgr.add_const('CM_DRP_DEVICEDESC',0x00000001)
    win_const_mgr.add_const('WM_MDISETMENU',0x00000230)
    win_const_mgr.add_const('BTH_MFG_SYMBOL_TECHNOLOGIES',0x0000002A)
    win_const_mgr.add_const('IP_SUCCESS',0x00000000)
    win_const_mgr.add_const('CRYPTUI_CERT_MGR_PUBLISHER_TAB',0x00000004)
    win_const_mgr.add_const('GLEX_RETURN',0x00000020)
    win_const_mgr.add_const('DEBUG_ATTACH_EXDI_DRIVER',0x00000002)
    win_const_mgr.add_const('CDERR_NOTEMPLATE',0x00000003)
    win_const_mgr.add_const('RC_OP_DX_OUTPUT',0x00004000)
    win_const_mgr.add_const('FW_SEMIBOLD',0x00000258)
    win_const_mgr.add_const('MAX_DATE_TIME_LENGTH',0x00000038)
    win_const_mgr.add_const('MSIM_LIST_BLOCK',0x00000004)
    win_const_mgr.add_const('PRIVACY_TYPE_FIRST_PARTY',0x00000000)
    win_const_mgr.add_const('WEBPOST_ERROR_FIRST',0x40042100)
    win_const_mgr.add_const('PAN_LETT_NORMAL_FLATTENED',0x00000005)
    win_const_mgr.add_const('AMDDS_YUVOVR',0x00000008)
    win_const_mgr.add_const('NCRYPT_SCHANNEL_INTERFACE',0x00010002)
    win_const_mgr.add_const('GDICOMMENT_UNICODE_END',0x00000080)
    win_const_mgr.add_const('DOT11_FLAGS_80211G_USE_PROTECTION',0x00000020)
    win_const_mgr.add_const('SPI_SETKEYBOARDCUES',0x0000100B)
    win_const_mgr.add_const('LINEDEVSTATE_BATTERY',0x00008000)
    win_const_mgr.add_const('SQL_ATTR_ENLIST_IN_DTC',0x000004B7)
    win_const_mgr.add_const('KS_VIDEO_FLAG_B_FRAME',0x00000020)
    win_const_mgr.add_const('FTP_TRANSFER_TYPE_UNKNOWN',0x00000000)
    win_const_mgr.add_const('UF_MNS_LOGON_ACCOUNT',0x00020000)
    win_const_mgr.add_const('WINSTA_ENUMERATE',0x00000100)
    win_const_mgr.add_const('MDSP_WRITE',0x00000002)
    win_const_mgr.add_const('SV_QUEUESAMPLESECS_PARMNUM',0x00000240)
    win_const_mgr.add_const('CRYPT_ACQUIRE_COMPARE_KEY_FLAG',0x00000004)
    win_const_mgr.add_const('RR_INDEX_LEN',0x00000003)
    win_const_mgr.add_const('CRYPT_DONT_VERIFY_SIGNATURE',0x00000100)
    win_const_mgr.add_const('WMS_NUM_STREAMHEADER_ATTRIBUTES',0x0000000B)
    win_const_mgr.add_const('DNS_RTYPE_WINS',0x00000001)
    win_const_mgr.add_const('COLOR_HUEACCEL',0x000002D3)
    win_const_mgr.add_const('DEBUG_EXECUTE_NO_REPEAT',0x00000004)
    win_const_mgr.add_const('DNS_ERROR_INVALID_DATAFILE_NAME',0x000025B4)
    win_const_mgr.add_const('DMPAPER_ENV_B5',0x00000022)
    win_const_mgr.add_const('DMPAPER_ENV_B6',0x00000023)
    win_const_mgr.add_const('_FACDXGI',0x00000087)
    win_const_mgr.add_const('CM_REMOVE_BITS',0x00000003)
    win_const_mgr.add_const('SCARD_CLASS_ICC_STATE',0x00000009)
    win_const_mgr.add_const('MODALS_MIN_PASSWD_LEN_PARMNUM',0x00000001)
    win_const_mgr.add_const('WHITEBALANCE_DAYLIGHT',0x00000004)
    win_const_mgr.add_const('FRS_ERR_PARENT_INSUFFICIENT_PRIV',0x00001F49)
    win_const_mgr.add_const('OID_FDDI_PORT_CONNNECT_STATE',0x03030272)
    win_const_mgr.add_const('RPC_X_SS_CONTEXT_DAMAGED',0x000006F1)
    win_const_mgr.add_const('IIS_MD_ADSI_METAID_BEGIN',0x0001FBD0)
    win_const_mgr.add_const('WSB_PROP_HSTYLE',0x00000200)
    win_const_mgr.add_const('PTE_PFN_SHIFT',0x00000008)
    win_const_mgr.add_const('LPD_SWAP_COPY',0x00000400)
    win_const_mgr.add_const('SPDRP_SECURITY',0x00000017)
    win_const_mgr.add_const('IDM_RAISED',0x0000003D)
    win_const_mgr.add_const('MCI_VCR_STATUS_TUNER_CHANNEL',0x00004014)
    win_const_mgr.add_const('MAPI_DIALOG',0x00000008)
    win_const_mgr.add_const('OID_ATM_RCV_INVALID_VPI_VCI',0x08020201)
    win_const_mgr.add_const('EVENT_HEADER_FLAG_TRACE_MESSAGE',0x00000008)
    win_const_mgr.add_const('BEST_MODE',0x00000003)
    win_const_mgr.add_const('CRL_FIND_ISSUED_BY_AKI_FLAG',0x00000001)
    win_const_mgr.add_const('PROCESSOR_ARM_7TDMI',0x00011171)
    win_const_mgr.add_const('WLAN_AVAILABLE_NETWORK_INCLUDE_ALL_ADHOC_PROFILES',0x00000001)
    win_const_mgr.add_const('CB_GETLBTEXT',0x00000148)
    win_const_mgr.add_const('MILCORE_TS_QUERYVER_RESULT_TRUE',0x7FFFFFFF)
    win_const_mgr.add_const('WKSTA_COMPUTERNAME_PARMNUM',0x00000001)
    win_const_mgr.add_const('SV_NETIOALERT_PARMNUM',0x0000002A)
    win_const_mgr.add_const('PORT_NICNAME',0x0000002B)
    win_const_mgr.add_const('NDW_INSTALLFLAG_NEEDSHUTDOWN',0x00000200)
    win_const_mgr.add_const('DT_LEFT',0x00000000)
    win_const_mgr.add_const('PID_MISC_ACCESSCOUNT',0x00000003)
    win_const_mgr.add_const('MINIDUMP_MISC1_PROCESS_ID',0x00000001)
    win_const_mgr.add_const('PRINTER_NOTIFY_FIELD_STATUS',0x00000012)
    win_const_mgr.add_const('D3DWRAPCOORD_3',0x00000008)
    win_const_mgr.add_const('D3DWRAPCOORD_2',0x00000004)
    win_const_mgr.add_const('D3DWRAPCOORD_1',0x00000002)
    win_const_mgr.add_const('D3DWRAPCOORD_0',0x00000001)
    win_const_mgr.add_const('IF_TYPE_DS0_BUNDLE',0x00000052)
    win_const_mgr.add_const('MXDCOP_SET_S0PAGE',0x0000001C)
    win_const_mgr.add_const('JOY_POVBACKWARD',0x00004650)
    win_const_mgr.add_const('DDOVER_ALPHASRCNEG',0x00000080)
    win_const_mgr.add_const('ED_CENTER',0x00000200)
    win_const_mgr.add_const('PRODUCT_STORAGE_STANDARD_SERVER',0x00000015)
    win_const_mgr.add_const('MD_SERVER_SIZE_MEDIUM',0x00000001)
    win_const_mgr.add_const('OID_802_3_XMIT_TIMES_CRS_LOST',0x01020206)
    win_const_mgr.add_const('SUBLANG_KINYARWANDA_RWANDA',0x00000001)
    win_const_mgr.add_const('LINEDEVSTATE_LOCK',0x00080000)
    win_const_mgr.add_const('SHGVSPB_INHERIT',0x00000010)
    win_const_mgr.add_const('COLOR_INACTIVECAPTIONTEXT',0x00000013)
    win_const_mgr.add_const('X3_D_WH_SIGN_VAL_POS_X',0x00000000)
    win_const_mgr.add_const('LINEAGENTSTATUSEX_STATE',0x00000002)
    win_const_mgr.add_const('MM_MIM_ERROR',0x000003C5)
    win_const_mgr.add_const('ERROR_LOG_INCONSISTENT_SECURITY',0x000019F6)
    win_const_mgr.add_const('SNMP_GENERICTRAP_EGPNEIGHLOSS',0x00000005)
    win_const_mgr.add_const('INTERNET_OPTION_SECURITY_CERTIFICATE',0x00000023)
    win_const_mgr.add_const('ERROR_LOG_START_OF_LOG',0x000019DA)
    win_const_mgr.add_const('OID_IRDA_MAX_UNICAST_LIST_SIZE',0x0A010203)
    win_const_mgr.add_const('SQL_CONVERT_BIT',0x00000037)
    win_const_mgr.add_const('ES_AWAYMODE_REQUIRED',0x00000040)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_REGKCBRUNDOWNEND',0x00000019)
    win_const_mgr.add_const('OPATH_TOK_INT',0x00000066)
    win_const_mgr.add_const('RP_SYNC',0x00000002)
    win_const_mgr.add_const('URLACTION_HTML_MIN',0x00001600)
    win_const_mgr.add_const('POLICY_ERRV_SUBNET_UNAUTH_USER_FLOW_COUNT',0x00000008)
    win_const_mgr.add_const('ERROR_EVT_VERSION_TOO_NEW',0x00003ABB)
    win_const_mgr.add_const('CERT_KEY_ENCIPHERMENT_KEY_USAGE',0x00000020)
    win_const_mgr.add_const('TF_MOD_LCONTROL',0x00000080)
    win_const_mgr.add_const('ENCODE_IS_USED',0x00000010)
    win_const_mgr.add_const('WINHTTP_QUERY_ALLOW',0x00000007)
    win_const_mgr.add_const('SCH_CRED_RESTRICTED_ROOTS',0x00002000)
    win_const_mgr.add_const('META_SELECTPALETTE',0x00000234)
    win_const_mgr.add_const('PIDDSI_CATEGORY',0x00000002)
    win_const_mgr.add_const('EC_DEVICE_LOST',0x00000001)
    win_const_mgr.add_const('CACHE_CONFIG_DISK_CACHE_PATHS_FC',0x00000040)
    win_const_mgr.add_const('ERROR_CONNECTION_UNAVAIL',0x000004B1)
    win_const_mgr.add_const('GPO_BROWSE_OPENBUTTON',0x00000008)
    win_const_mgr.add_const('ERROR_WRONG_EFS',0x00001775)
    win_const_mgr.add_const('SPINST_COPYINF',0x00000200)
    win_const_mgr.add_const('KSDSOUND_BUFFER_CTRL_PAN',0x00000004)
    win_const_mgr.add_const('IDS_CAP_STAT_VIDEOAUDIO',0x000001FF)
    win_const_mgr.add_const('ERROR_INDIGENOUS_TYPE',0x000010F2)
    win_const_mgr.add_const('GT_INTERNAL',0x00000008)
    win_const_mgr.add_const('AA_S_DELETE',0x00000040)
    win_const_mgr.add_const('E_SURFACE_NOTMYPOINTER',0x8000C002)
    win_const_mgr.add_const('PRNSETUPDLGORD',0x00000603)
    win_const_mgr.add_const('RPC_C_AUTHN_LEVEL_CALL',0x00000003)
    win_const_mgr.add_const('PHONEFEATURE_SETHOOKSWITCHHEADSET',0x00400000)
    win_const_mgr.add_const('POLICY_SHOWREASONUI_ALWAYS',0x00000001)
    win_const_mgr.add_const('ERROR_GEN_FAILURE',0x0000001F)
    win_const_mgr.add_const('SYNCH_DATA_STORE_NOTES',0x00000005)
    win_const_mgr.add_const('DEBUG_REGISTERS_INT32',0x00000001)
    win_const_mgr.add_const('SES_DRAFTMODE',0x00008000)
    win_const_mgr.add_const('DPNHGETCAPS_UPDATESERVERSTATUS',0x00000001)
    win_const_mgr.add_const('IME_ESC_SYNC_HOTKEY',0x00001007)
    win_const_mgr.add_const('CRYPT_VERIFY_CERT_SIGN_ISSUER_NULL',0x00000004)
    win_const_mgr.add_const('ERROR_UNSUPPORTED_COMPRESSION',0x0000026A)
    win_const_mgr.add_const('TTI_WARNING',0x00000002)
    win_const_mgr.add_const('DOT11_STATUS_AUTH_NOT_VERIFIED',0x00008000)
    win_const_mgr.add_const('BLLI_L2_HDLC_NRM',0x0000000A)
    win_const_mgr.add_const('IMAGE_REL_MIPS_SECRELLO',0x0000000C)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_QM_EXPIRED',0x00003647)
    win_const_mgr.add_const('MM_DONTREMOVESEPS',0x00000004)
    win_const_mgr.add_const('CERT_TRUST_HAS_VALID_NAME_CONSTRAINTS',0x00000400)
    win_const_mgr.add_const('ERROR_DS_CLASS_MUST_BE_CONCRETE',0x000020A7)
    win_const_mgr.add_const('IF_TYPE_FASTETHER',0x0000003E)
    win_const_mgr.add_const('WM_TCARD',0x00000052)
    win_const_mgr.add_const('PFM_OFFSET',0x00000004)
    win_const_mgr.add_const('IMGBITS_NONE',0x02000000)
    win_const_mgr.add_const('IDRETRY',0x00000004)
    win_const_mgr.add_const('CRL_DIST_POINT_ISSUER_RDN_NAME',0x00000002)
    win_const_mgr.add_const('STOPBITS_15',0x00000002)
    win_const_mgr.add_const('LMEM_VALID_FLAGS',0x00000F72)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_SINGLE_PHASE_COMMIT',0x00000200)
    win_const_mgr.add_const('WIA_DPC_TILT_POSITION',0x0000080D)
    win_const_mgr.add_const('HTTP_QUERY_MAX_FORWARDS',0x0000003C)
    win_const_mgr.add_const('MSV1_0_NTLM3_OWF_LENGTH',0x00000010)
    win_const_mgr.add_const('SV_CONNECTIONLESSAUTODISC_PARMNUM',0x00000232)
    win_const_mgr.add_const('ERROR_DS_DST_DOMAIN_NOT_NATIVE',0x00002130)
    win_const_mgr.add_const('MD_ERROR_SUB403_ADDR_REJECT',0x00000006)
    win_const_mgr.add_const('WMDM_FILE_ATTR_MUSIC',0x00080000)
    win_const_mgr.add_const('CDB2N_CONTEXTMENU_START',0x00000002)
    win_const_mgr.add_const('ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER',0x00002145)
    win_const_mgr.add_const('WINEVENT_KEYWORD_RESERVED_62',0x4000000000000000)
    win_const_mgr.add_const('WINEVENT_KEYWORD_RESERVED_63',0x8000000000000000)
    win_const_mgr.add_const('TTFMFP_SUBSET',0x00000000)
    win_const_mgr.add_const('SPI_GETTOOLTIPFADE',0x00001018)
    win_const_mgr.add_const('COD_AUDIO_MINOR_GAMING_TOY',0x00000012)
    win_const_mgr.add_const('CM_DEVCAP_NONDYNAMIC',0x00000200)
    win_const_mgr.add_const('LOCALE_IMEASURE',0x0000000D)
    win_const_mgr.add_const('NRC_CMDTMO',0x00000005)
    win_const_mgr.add_const('FILTER_TEMP_DUPLICATE_ACCOUNT',0x00000001)
    win_const_mgr.add_const('TLS1_ALERT_EXPORT_RESTRICTION',0x0000003C)
    win_const_mgr.add_const('HTTP_QUERY_ECHO_REPLY',0x00000048)
    win_const_mgr.add_const('DEBUG_SYMINFO_IMAGEHLP_MODULEW64',0x00000001)
    win_const_mgr.add_const('MSIM_LIST_SYSTEM',0x00000080)
    win_const_mgr.add_const('IDD_OUTOFMEMORY',0x00000400)
    win_const_mgr.add_const('SP_COPY_FORCE_NEWER',0x00002000)
    win_const_mgr.add_const('PROV_REPLACE_OWF',0x00000017)
    win_const_mgr.add_const('METADATA_DONT_EXPAND',0x00000200)
    win_const_mgr.add_const('CB_OKAY',0x00000000)
    win_const_mgr.add_const('MCIWNDF_NOTIFYSIZE',0x00000400)
    win_const_mgr.add_const('BTH_MFG_NOKIA',0x00000001)
    win_const_mgr.add_const('LDAP_VENDOR_VERSION',0x000001FE)
    win_const_mgr.add_const('IF_TYPE_REGULAR_1822',0x00000002)
    win_const_mgr.add_const('DBFLAGS_CREATEIFNEEDED',0x00000002)
    win_const_mgr.add_const('SCARD_W_CHV_BLOCKED',0x8010006C)
    win_const_mgr.add_const('CACHE_CONFIG_USER_MODE_FC',0x00001000)
    win_const_mgr.add_const('DSOP_SCOPE_FLAG_WANT_PROVIDER_GC',0x00000008)
    win_const_mgr.add_const('NETE_CONNBROKEN',0x00000004)
    win_const_mgr.add_const('RBBIM_CHEVRONLOCATION',0x00001000)
    win_const_mgr.add_const('TIMEANIMATIONELEMENT_OFFSET',0x00000300)
    win_const_mgr.add_const('SM_CYSIZE',0x0000001F)
    win_const_mgr.add_const('XIDDATASIZE',0x00000080)
    win_const_mgr.add_const('SNMP_TRAP_LINKUP',0x00000003)
    win_const_mgr.add_const('AUTH_REQ_TRANSITIVE_TRUST',0x00000400)
    win_const_mgr.add_const('D3DISSUE_BEGIN',0x00000001)
    win_const_mgr.add_const('ERROR_FLOPPY_UNKNOWN_ERROR',0x00000464)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_VOLUMEUP',0x00000013)
    win_const_mgr.add_const('HTTP_QUERY_LINK',0x00000010)
    win_const_mgr.add_const('IDC_EL_CANCELLINK',0x000000D1)
    win_const_mgr.add_const('LUP_RETURN_BLOB',0x00000200)
    win_const_mgr.add_const('CP_SUPPORTED',0x00000002)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_NEG_STATUS_END',0x00003649)
    win_const_mgr.add_const('CTRY_CARIBBEAN',0x00000001)
    win_const_mgr.add_const('DISPID_IWBSCRIPTCONTROL_SETCONTEXTMENU',0x00000003)
    win_const_mgr.add_const('MAPIFORM_SELECT_ALL_REGISTRIES',0x00000000)
    win_const_mgr.add_const('OFASI_EDIT',0x00000001)
    win_const_mgr.add_const('WINHTTP_QUERY_CONTENT_LANGUAGE',0x00000006)
    win_const_mgr.add_const('SHACF_AUTOAPPEND_FORCE_OFF',0x80000000)
    win_const_mgr.add_const('FEI_LINE_UNAVAILABLE',0x00000019)
    win_const_mgr.add_const('DRM_PLAYLIST_DATA_V2_VALID',0x00000001)
    win_const_mgr.add_const('D3D10_DEFAULT_BLEND_FACTOR_ALPHA',0x00000001)
    win_const_mgr.add_const('ACTRL_AUDIT_FAILURE',0x00000008)
    win_const_mgr.add_const('RP_ERROR_CONTEXT_CAT',0x00200000)
    win_const_mgr.add_const('ERROR_DRIVER_DATABASE_ERROR',0x0000028C)
    win_const_mgr.add_const('DEBUG_CES_EFFECTIVE_PROCESSOR',0x00000002)
    win_const_mgr.add_const('MDM_SHIFT_BEARERMODE',0x0000000C)
    win_const_mgr.add_const('RPC_C_HTTP_AUTHN_SCHEME_NEGOTIATE',0x00000010)
    win_const_mgr.add_const('CTL_FIND_EXISTING',0x00000005)
    win_const_mgr.add_const('SQL_API_SQLGETSTMTATTR',0x000003F6)
    win_const_mgr.add_const('PIDVSI_FRAME_COUNT',0x00000005)
    win_const_mgr.add_const('DCOMSCM_PING_DISALLOW_UNSECURE_CALL',0x00000020)
    win_const_mgr.add_const('DDPCAPS_8BITENTRIES',0x00000002)
    win_const_mgr.add_const('D3DPRESENT_BACK_BUFFERS_MAX',0x00000003)
    win_const_mgr.add_const('DEBUG_ENGOPT_FAIL_INCOMPLETE_INFORMATION',0x00000200)
    win_const_mgr.add_const('FCT_ADDTOEND',0x00000004)
    win_const_mgr.add_const('CAL_TAIWAN',0x00000004)
    win_const_mgr.add_const('FACILITY_USERMODE_FILTER_MANAGER',0x0000001F)
    win_const_mgr.add_const('DEX_IDS_STREAM_NUMBER',0x0000057F)
    win_const_mgr.add_const('DBPROP_DEFERNONINDEXEDTRIMMING',0x00000003)
    win_const_mgr.add_const('NTDDI_WIN2KSP4',0x05000400)
    win_const_mgr.add_const('AM_AC3_ALTERNATE_AUDIO_1',0x00000001)
    win_const_mgr.add_const('NTDDI_WIN2KSP3',0x05000300)
    win_const_mgr.add_const('INTERNET_HANDLE_TYPE_GOPHER_FILE',0x0000000B)
    win_const_mgr.add_const('AM_AC3_ALTERNATE_AUDIO_2',0x00000002)
    win_const_mgr.add_const('ERROR_SXS_XML_E_EXPECTINGTAGEND',0x000036D6)
    win_const_mgr.add_const('SMART_OFFLINE_ROUTINE_OFFLINE',0x00000000)
    win_const_mgr.add_const('IPX_IN_TRAFFIC_FILTER_INFO_TYPE',0x00000006)
    win_const_mgr.add_const('WAVE_FORMAT_48M16',0x00004000)
    win_const_mgr.add_const('RESOURCEDISPLAYTYPE_NETWORK',0x00000006)
    win_const_mgr.add_const('GT_RESOURCE',0x00000005)
    win_const_mgr.add_const('TTFCFP_SUBSET1',0x00000001)
    win_const_mgr.add_const('CRYPT_STRING_BINARY',0x00000002)
    win_const_mgr.add_const('IMAGE_REL_CEE_ADDR64',0x00000002)
    win_const_mgr.add_const('LOGFLAGS_FORWARD',0x00000000)
    win_const_mgr.add_const('SQL_CO_OFF',0x00000000)
    win_const_mgr.add_const('DN_STARTED',0x00000008)
    win_const_mgr.add_const('OID_GEN_PCI_DEVICE_CUSTOM_PROPERTIES',0x00010211)
    win_const_mgr.add_const('DNS_CLASS_CSNET',0x00000002)
    win_const_mgr.add_const('IMAGE_SUBSYSTEM_WINDOWS_CE_GUI',0x00000009)
    win_const_mgr.add_const('AUTH_FLAG_DISABLE_BASIC_CLEARCHANNEL',0x00000004)
    win_const_mgr.add_const('DSBF_ICONLOCATION',0x00000002)
    win_const_mgr.add_const('ERROR_SOURCE_ELEMENT_EMPTY',0x00000488)
    win_const_mgr.add_const('EAP_E_EAPHOST_THIRDPARTY_METHOD_HOST_RESET',0x80420012)
    win_const_mgr.add_const('MDLEVEL_TYPE_CALCULATED',0x00000002)
    win_const_mgr.add_const('PBTF_APMRESUMEFROMFAILURE',0x00000001)
    win_const_mgr.add_const('LINEADDRESSTYPE_DOMAINNAME',0x00000008)
    win_const_mgr.add_const('SUBLANG_SINDHI_AFGHANISTAN',0x00000002)
    win_const_mgr.add_const('IDF_NOREMOVABLEMEDIAPROMPT',0x00001000)
    win_const_mgr.add_const('DMCOLOR_COLOR',0x00000002)
    win_const_mgr.add_const('LDAP_RES_COMPARE',0x00000006)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_PREW2KCOMPACCESS',0x0000022A)
    win_const_mgr.add_const('CDO_E_INVALID_POST_OPTION',0x80040221)
    win_const_mgr.add_const('CAUSE_REASON_IE_MISSING',0x00000004)
    win_const_mgr.add_const('IDM_OPTIONS',0x00000857)
    win_const_mgr.add_const('DNF_DUPDRIVERVER',0x00008000)
    win_const_mgr.add_const('ERROR_TRANSPORT_FULL',0x000010E8)
    win_const_mgr.add_const('KERBEROS_VERSION',0x00000005)
    win_const_mgr.add_const('SUBLANG_ENGLISH_PHILIPPINES',0x00000000)
    win_const_mgr.add_const('SDP_PROTOCOL_UUID16',0x00000001)
    win_const_mgr.add_const('IDM_TRIED_FIND',0x00000022)
    win_const_mgr.add_const('SPI_SETSOUNDSENTRY',0x00000041)
    win_const_mgr.add_const('DI_VENDOR_ID_SOURCE_USB_IF',0x00000002)
    win_const_mgr.add_const('RIDI_PREPARSEDDATA',0x20000005)
    win_const_mgr.add_const('STDPROP_INDEX_TERM_RAW_LENGTH',0x000000D3)
    win_const_mgr.add_const('MHDR_DONE',0x00000001)
    win_const_mgr.add_const('ERROR_TRANSFORM_NOT_SUPPORTED',0x000007D4)
    win_const_mgr.add_const('ERROR_MULTIPLE_FAULT_VIOLATION',0x00000280)
    win_const_mgr.add_const('CMC_TAGGED_CERT_REQUEST_CHOICE',0x00000001)
    win_const_mgr.add_const('PRJOB_QS_SPOOLING',0x00000002)
    win_const_mgr.add_const('EM_GETPASSWORDCHAR',0x000000D2)
    win_const_mgr.add_const('MDPROPVAL_MNF_DRILLDOWNLEVELBOTTOM',0x00008000)
    win_const_mgr.add_const('WAVE_FILTER_DEVELOPMENT',0x0000FFFF)
    win_const_mgr.add_const('NDIS_WMI_ENUM_ADAPTER_REVISION_1',0x00000001)
    win_const_mgr.add_const('CACHEGROUP_ATTRIBUTE_BASIC',0x00000001)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2TAO_RECORDER',0x00000100)
    win_const_mgr.add_const('SQL_ATTR_WRITE',0x00000001)
    win_const_mgr.add_const('CPLPAGE_MOUSE_WHEEL',0x00000003)
    win_const_mgr.add_const('EC_END_OF_SEGMENT',0x0000001C)
    win_const_mgr.add_const('DISPID_DDISCFORMAT2RAWCDEVENTS_UPDATE',0x00000200)
    win_const_mgr.add_const('PDH_LOG_OPT_USER_STRING',0x01000000)
    win_const_mgr.add_const('RP_ERROR_CONTEXT_STORE',0x00100000)
    win_const_mgr.add_const('MD_SERVER_CONFIG_ALLOW_ENCRYPT',0x00000004)
    win_const_mgr.add_const('PER_USER_AUDIT_FAILURE_EXCLUDE',0x00000008)
    win_const_mgr.add_const('OID_TAPI_PROVIDER_SHUTDOWN',0x07030119)
    win_const_mgr.add_const('LINECALLPARAMFLAGS_PREDICTIVEDIAL',0x00000040)
    win_const_mgr.add_const('IDI_DISABLED_OVL',0x000001F5)
    win_const_mgr.add_const('LOCALE_IDEFAULTEBCDICCODEPAGE',0x00001012)
    win_const_mgr.add_const('WINHTTP_OPTION_MAX_CONNS_PER_SERVER',0x00000049)
    win_const_mgr.add_const('MCI_DGV_LIST_NUMBER',0x00040000)
    win_const_mgr.add_const('BG_E_VALIDATION_FAILED',0x80200053)
    win_const_mgr.add_const('CRYPTPROTECT_PROMPT_REQUIRE_STRONG',0x00000010)
    win_const_mgr.add_const('OID_TAPI_CONDITIONAL_MEDIA_DETECTION',0x07030105)
    win_const_mgr.add_const('UIA_E_ELEMENTNOTENABLED',0x80040200)
    win_const_mgr.add_const('PID_IS_SHOWCMD',0x00000007)
    win_const_mgr.add_const('FAX_CONFIG_QUERY',0x00000004)
    win_const_mgr.add_const('MD_LOG_TYPE_ENABLED',0x00000001)
    win_const_mgr.add_const('DNS_RTYPE_WKS',0x00000000)
    win_const_mgr.add_const('SQL_DESC_LITERAL_PREFIX',0x0000001B)
    win_const_mgr.add_const('ARCONTENT_UNKNOWNCONTENT',0x00000040)
    win_const_mgr.add_const('MDLEVEL_TYPE_REGULAR',0x00000000)
    win_const_mgr.add_const('CPL_EXIT',0x00000007)
    win_const_mgr.add_const('DDOVER_REFRESHDIRTYRECTS',0x00010000)
    win_const_mgr.add_const('IAS_ATTRIB_INT',0x00000001)
    win_const_mgr.add_const('SECPKG_FLAG_STREAM',0x00000400)
    win_const_mgr.add_const('WIA_COMPRESSION_BI_RLE4',0x00000001)
    win_const_mgr.add_const('DEBUG_STATUS_INSIDE_WAIT',0x100000000)
    win_const_mgr.add_const('CHANNEL_OPTION_ENCRYPT_RDP',0x40000000)
    win_const_mgr.add_const('TMT_EDGEHIGHLIGHTCOLOR',0x00000EDD)
    win_const_mgr.add_const('TBS_COMMAND_LOCALITY_ONE',0x00000001)
    win_const_mgr.add_const('ISCSI_LOGIN_OPTIONS_DEFAULT_TIME_2_WAIT',0x00000008)
    win_const_mgr.add_const('ERROR_DS_ROOT_MUST_BE_NC',0x0000206D)
    win_const_mgr.add_const('PID_INTSITE_WHATSNEW',0x00000002)
    win_const_mgr.add_const('ACM_FORMATSUGGESTF_TYPEMASK',0x00FF0000)
    win_const_mgr.add_const('MCI_DGV_OPEN_WS',0x00010000)
    win_const_mgr.add_const('WAVE_FORMAT_44M16',0x00000400)
    win_const_mgr.add_const('CERT_STORE_UPDATE_KEYID_FLAG',0x00000400)
    win_const_mgr.add_const('COD_PERIPHERAL_MINOR_REMOTE_CONTROL',0x00000003)
    win_const_mgr.add_const('SV_MINKEEPSEARCH_PARMNUM',0x0000020A)
    win_const_mgr.add_const('ISCSI_LOGIN_FLAG_REQUIRE_IPSEC',0x00000001)
    win_const_mgr.add_const('D3D9_RESOURCE_PRIORITY_LOW',0x50000000)
    win_const_mgr.add_const('LINECALLFEATURE_SETCALLDATA',0x80000000)
    win_const_mgr.add_const('D3DPRASTERCAPS_DITHER',0x00000001)
    win_const_mgr.add_const('IMAGE_REL_I386_DIR16',0x00000001)
    win_const_mgr.add_const('AUDIOCLOCK_CHARACTERISTIC_FIXED_FREQ',0x00000001)
    win_const_mgr.add_const('PID_AUTHOR',0x00000004)
    win_const_mgr.add_const('IDB_HIST_LARGE_COLOR',0x00000009)
    win_const_mgr.add_const('ERROR_HANDLE_EOF',0x00000026)
    win_const_mgr.add_const('XINPUT_GAMEPAD_START',0x00000010)
    win_const_mgr.add_const('RPC_C_AUTHN_NONE',0x00000000)
    win_const_mgr.add_const('RATING_FIVE_STARS_SET',0x00000063)
    win_const_mgr.add_const('ERROR_CANT_TERMINATE_SELF',0x0000022B)
    win_const_mgr.add_const('PTE_OFFSET_LEN',0x0000000A)
    win_const_mgr.add_const('PFM_TABSTOPS',0x00000010)
    win_const_mgr.add_const('EM_LINELENGTH',0x000000C1)
    win_const_mgr.add_const('STARTF_USEPOSITION',0x00000004)
    win_const_mgr.add_const('UNDNAME_NO_ALLOCATION_LANGUAGE',0x00000010)
    win_const_mgr.add_const('CWF_CREATE_ONLY',0x00000001)
    win_const_mgr.add_const('PROCESSOR_MIPS_R4000',0x00000FA0)
    win_const_mgr.add_const('SNMP_ERRORSTATUS_INCONSISTENTVALUE',0x0000000C)
    win_const_mgr.add_const('CERT_CHAIN_MAX_AIA_URL_COUNT_IN_CERT_DEFAULT',0x00000005)
    win_const_mgr.add_const('CERT_KEYGEN_REQUEST_V1',0x00000000)
    win_const_mgr.add_const('IMAGE_REL_PPC_ADDR16',0x00000004)
    win_const_mgr.add_const('CAP_SMART_CMD',0x00000004)
    win_const_mgr.add_const('GUI_16BITTASK',0x00000020)
    win_const_mgr.add_const('IF_TYPE_DCN',0x0000008D)
    win_const_mgr.add_const('CSRESTORE_TYPE_CATCHUP',0x00000004)
    win_const_mgr.add_const('DDCAPS_ALIGNBOUNDARYDEST',0x00000002)
    win_const_mgr.add_const('CTRY_ITALY',0x00000027)
    win_const_mgr.add_const('IMAGE_REL_PPC_ADDR14',0x00000005)
    win_const_mgr.add_const('DEBUG_GSEL_NEAREST_ONLY',0x00000008)
    win_const_mgr.add_const('MRINFO_LEAF_FLAG',0x00000080)
    win_const_mgr.add_const('INTERNET_FLAG_RESYNCHRONIZE',0x00000800)
    win_const_mgr.add_const('SSA_PIDX',0x10000000)
    win_const_mgr.add_const('FACILITY_P2P',0x00000063)
    win_const_mgr.add_const('PRIORITY_PROP_NORMAL',0x00000001)
    win_const_mgr.add_const('IDC_IO_OBJECTTYPETEXT',0x0000083F)
    win_const_mgr.add_const('KP_PERMISSIONS',0x00000006)
    win_const_mgr.add_const('CMSG_DETACHED_FLAG',0x00000004)
    win_const_mgr.add_const('C1_DEFINED',0x00000200)
    win_const_mgr.add_const('AM_VIDEO_FLAG_FIELD_MASK',0x00000003)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_UPGRADE',0x00000004)
    win_const_mgr.add_const('DMPAPER_ENV_ITALY',0x00000024)
    win_const_mgr.add_const('HTTP_STATUS_USE_PROXY',0x00000131)
    win_const_mgr.add_const('DRM_EL_GROUPIDENTITY',0x00000002)
    win_const_mgr.add_const('BG_E_CONNECTION_CLOSED',0x8020002E)
    win_const_mgr.add_const('ACMFILTERCHOOSE_STYLEF_ENABLETEMPLATEHANDLE',0x00000020)
    win_const_mgr.add_const('WMDM_STORAGECONTROL_INSERTAFTER',0x00000400)
    win_const_mgr.add_const('VK_OEM_PA1',0x000000EB)
    win_const_mgr.add_const('SV_OTHERQUEUEAFFINITY_PARMNUM',0x0000023F)
    win_const_mgr.add_const('DEBUG_REQUEST_READ_USER_MINIDUMP_STREAM',0x00000007)
    win_const_mgr.add_const('METADATA_PERMISSION_READ',0x00000001)
    win_const_mgr.add_const('FILE_SKIP_SET_EVENT_ON_HANDLE',0x00000002)
    win_const_mgr.add_const('OID_ATM_MAX_AAL34_PACKET_SIZE',0x0801010A)
    win_const_mgr.add_const('HHWIN_BUTTON_SYNC',0x00000001)
    win_const_mgr.add_const('VK_OEM_PA3',0x000000ED)
    win_const_mgr.add_const('TVIF_EXPANDEDIMAGE',0x00000200)
    win_const_mgr.add_const('CM_PROB_UNKNOWN_RESOURCE',0x00000011)
    win_const_mgr.add_const('VK_OEM_PA2',0x000000EC)
    win_const_mgr.add_const('LINECALLSTATE_DIALTONE',0x00000008)
    win_const_mgr.add_const('INTERNET_OPTION_IGNORE_CERT_ERROR_FLAGS',0x00000063)
    win_const_mgr.add_const('PRINTER_STATUS_POWER_SAVE',0x01000000)
    win_const_mgr.add_const('USER_CALL_IS_ASYNC',0x00000100)
    win_const_mgr.add_const('RPC_QUERY_SERVER_PRINCIPAL_NAME',0x00000002)
    win_const_mgr.add_const('TF_LBI_BITMAP',0x00000008)
    win_const_mgr.add_const('FLASHMODE_REDEYE_AUTO',0x00000004)
    win_const_mgr.add_const('IDM_PROTECTMETATAGS',0x00001BBD)
    win_const_mgr.add_const('PIDMSI_SEQUENCE_NO',0x00000005)
    win_const_mgr.add_const('WEBPOST_ERROR_NO_POSTINFO',0x40042119)
    win_const_mgr.add_const('IDC_CI_BROWSE',0x00000082)
    win_const_mgr.add_const('MAPIFORM_CPU_MIP',0x00000002)
    win_const_mgr.add_const('VK_MEDIA_STOP',0x000000B2)
    win_const_mgr.add_const('WCT_OBJNAME_LENGTH',0x00000080)
    win_const_mgr.add_const('PDH_LOG_TYPE_CSV',0x00000001)
    win_const_mgr.add_const('DEF_MAX_PWHIST',0x00000008)
    win_const_mgr.add_const('RTM_ROUTE_FLAGS_MARTIAN',0x00000001)
    win_const_mgr.add_const('ERROR_USER_MAPPED_FILE',0x000004C8)
    win_const_mgr.add_const('CDIS_FOCUS',0x00000010)
    win_const_mgr.add_const('SERVICE_UI_ALWAYS',0x00000002)
    win_const_mgr.add_const('INTERNET_OPTION_PARENT_HANDLE',0x00000015)
    win_const_mgr.add_const('PARTITION_UNIX',0x00000063)
    win_const_mgr.add_const('CB_MAX_CABINET_NAME',0x00000100)
    win_const_mgr.add_const('PAGEMASK_1MB',0x00000000)
    win_const_mgr.add_const('DNS_ERROR_ZONE_DOES_NOT_EXIST',0x00002581)
    win_const_mgr.add_const('WINEVENT_OPCODE_INFO',0x00000000)
    win_const_mgr.add_const('CF_SELECTSCRIPT',0x00400000)
    win_const_mgr.add_const('PRODUCT_ENTERPRISE_SERVER',0x0000000A)
    win_const_mgr.add_const('WAVEIN_MAPPER_STATUS_DEVICE',0x00000000)
    win_const_mgr.add_const('CERT_NAME_STR_NO_PLUS_FLAG',0x20000000)
    win_const_mgr.add_const('DDCKEYCAPS_SRCOVERLAY',0x00002000)
    win_const_mgr.add_const('PORT_OCBINDER',0x000000B7)
    win_const_mgr.add_const('URLACTION_ACTIVEX_NO_WEBOC_SCRIPT',0x00001206)
    win_const_mgr.add_const('WINHTTP_CALLBACK_STATUS_SENDREQUEST_COMPLETE',0x00400000)
    win_const_mgr.add_const('BACKUP_TYPE_INCREMENTAL',0x00000004)
    win_const_mgr.add_const('RTCEF_SESSION_STATE_CHANGE',0x00000004)
    win_const_mgr.add_const('ERROR_DS_DRA_INCONSISTENT_DIT',0x000020FB)
    win_const_mgr.add_const('DNS_UPDATE_SECURITY_ONLY',0x00000100)
    win_const_mgr.add_const('AM_GBF_NODDSURFACELOCK',0x00000008)
    win_const_mgr.add_const('COOKIEACTION_REJECT',0x00000002)
    win_const_mgr.add_const('MQCERT_REGISTER_ALWAYS',0x00000001)
    win_const_mgr.add_const('DNS_TKEY_MODE_DIFFIE_HELLMAN',0x00000002)
    win_const_mgr.add_const('LINECALLFEATURE_DROP',0x00000080)
    win_const_mgr.add_const('IMAGE_REL_PPC_ADDR64',0x00000001)
    win_const_mgr.add_const('WVR_ALIGNTOP',0x00000010)
    win_const_mgr.add_const('IDM_JUSTIFYGENERAL',0x0000003A)
    win_const_mgr.add_const('WIA_PRIVATE_ITEMPROP',0x00011802)
    win_const_mgr.add_const('NETLOGON_CONTROL_QUERY_DNS_REG',0x0000000C)
    win_const_mgr.add_const('CR_NOT_SYSTEM_VM',0x00000016)
    win_const_mgr.add_const('WKSTA_BUFFILESWITHDENYWRITE_PARMNUM',0x0000003A)
    win_const_mgr.add_const('DEBUG_FIND_SOURCE_DEFAULT',0x00000000)
    win_const_mgr.add_const('IMAGE_REL_PPC_REL24',0x00000006)
    win_const_mgr.add_const('SES_UPPERCASE',0x00000200)
    win_const_mgr.add_const('DDFXCAPS_OVERLAYMIRRORLEFTRIGHT',0x08000000)
    win_const_mgr.add_const('OID_802_11_AUTHENTICATION_MODE',0x0D010118)
    win_const_mgr.add_const('TF_SPEECHUI_SHOWN',0x00000010)
    win_const_mgr.add_const('CAL_SMONTHNAME6',0x00000001)
    win_const_mgr.add_const('BG_E_SESSION_NOT_FOUND',0x8020001F)
    win_const_mgr.add_const('MQSEC_GET_QUEUE_PROPERTIES',0x00000020)
    win_const_mgr.add_const('EAP_E_USER_ROOT_CERT_NOT_FOUND',0x80420300)
    win_const_mgr.add_const('D3DCREATE_HARDWARE_VERTEXPROCESSING',0x00000040)
    win_const_mgr.add_const('CERT_OID_NAME_STR',0x00000002)
    win_const_mgr.add_const('MONITORINFOF_PRIMARY',0x00000001)
    win_const_mgr.add_const('ERROR_EVT_INVALID_CHANNEL_PATH',0x00003A98)
    win_const_mgr.add_const('SYNCMGRHANDLERFLAG_MASK',0x00000000)
    win_const_mgr.add_const('SCARD_E_UNSUPPORTED_FEATURE',0x80100022)
    win_const_mgr.add_const('HH_GET_WIN_TYPE',0x00000005)
    win_const_mgr.add_const('SPI_SETSCREENSAVETIMEOUT',0x0000000F)
    win_const_mgr.add_const('EVENT_OBJECT_FOCUS',0x00008005)
    win_const_mgr.add_const('_A_EXEC',0x00000040)
    win_const_mgr.add_const('DISPID_SEARCHGUIDEURL',0x0000001D)
    win_const_mgr.add_const('MCI_DGV_STATUS_AUDIO',0x00004014)
    win_const_mgr.add_const('ERROR_BAD_ARGUMENTS',0x000000A0)
    win_const_mgr.add_const('CAL_SMONTHNAME7',0x00000001)
    win_const_mgr.add_const('SP_BACKUP_BACKUPPASS',0x00000001)
    win_const_mgr.add_const('CSF_ONLYGETSOURCE',0x00000004)
    win_const_mgr.add_const('CERT_CHAIN_POLICY_IGNORE_ROOT_REV_UNKNOWN_FLAG',0x00000800)
    win_const_mgr.add_const('VIEW_PRIORITY_SHELLEXT',0x00000040)
    win_const_mgr.add_const('CACHE_S_FIRST',0x00040170)
    win_const_mgr.add_const('SMINV_ID',0x00000008)
    win_const_mgr.add_const('NDIS_PACKET_TYPE_SOURCE_ROUTING',0x00000010)
    win_const_mgr.add_const('LINEADDRFEATURE_FORWARDFWD',0x00001000)
    win_const_mgr.add_const('CR_PROP_DNSNAME',0x00000016)
    win_const_mgr.add_const('MDM_V120_ML_2',0x00000002)
    win_const_mgr.add_const('IMR_CANDIDATEWINDOW',0x00000002)
    win_const_mgr.add_const('ERROR_DS_SHUTTING_DOWN',0x000020AC)
    win_const_mgr.add_const('DB_ALL_EXCEPT_LIKE',0x00000003)
    win_const_mgr.add_const('IMAGE_SYM_CLASS_AUTOMATIC',0x00000001)
    win_const_mgr.add_const('ERRCLASS_APPERR',0x00000007)
    win_const_mgr.add_const('LINEADDRFEATURE_PICKUPDIRECT',0x00000400)
    win_const_mgr.add_const('HHWIN_PROP_TAB_CUSTOM8',0x00000001)
    win_const_mgr.add_const('HHWIN_PROP_TAB_CUSTOM9',0x00000001)
    win_const_mgr.add_const('PST_X25',0x00000103)
    win_const_mgr.add_const('COD_LAN_ACCESS_83_USED',0x00000005)
    win_const_mgr.add_const('CMSG_KEY_AGREE_ENCRYPT_FREE_PARA_FLAG',0x00000001)
    win_const_mgr.add_const('HHWIN_PROP_TAB_CUSTOM2',0x00000001)
    win_const_mgr.add_const('HHWIN_PROP_TAB_CUSTOM3',0x00000001)
    win_const_mgr.add_const('HHWIN_PROP_TAB_CUSTOM1',0x00000001)
    win_const_mgr.add_const('HHWIN_PROP_TAB_CUSTOM6',0x00000001)
    win_const_mgr.add_const('HHWIN_PROP_TAB_CUSTOM7',0x00000001)
    win_const_mgr.add_const('HHWIN_PROP_TAB_CUSTOM4',0x00000001)
    win_const_mgr.add_const('HHWIN_PROP_TAB_CUSTOM5',0x00000001)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_TRANSITION_DIAGONAL',0x0000000E)
    win_const_mgr.add_const('RES_FIND_MULTIPLE',0x00000002)
    win_const_mgr.add_const('GESTURE_DOUBLE_TAP',0x00000000)
    win_const_mgr.add_const('SQL_SO_KEYSET_DRIVEN',0x00000002)
    win_const_mgr.add_const('FILE_FLAG_DELETE_ON_CLOSE',0x04000000)
    win_const_mgr.add_const('PHONEFEATURE_GETVOLUMEHEADSET',0x00002000)
    win_const_mgr.add_const('STARTF_USEHOTKEY',0x00000200)
    win_const_mgr.add_const('KAGPROP_POSITIONONNEWROW',0x00000004)
    win_const_mgr.add_const('METHOD_BGP4_PA_ORIGIN',0x00000004)
    win_const_mgr.add_const('HHT_ONFILTER',0x00000010)
    win_const_mgr.add_const('USE_USERNAME_PARMNUM',0x00000005)
    win_const_mgr.add_const('ETDT_USETABTEXTURE',0x00000004)
    win_const_mgr.add_const('DOT11_STATUS_ICV_VERIFIED',0x00000800)
    win_const_mgr.add_const('LINECALLFEATURE_HOLD',0x00000800)
    win_const_mgr.add_const('LANG_SINHALESE',0x00000005)
    win_const_mgr.add_const('PORT_MDQS',0x0000029A)
    win_const_mgr.add_const('HTTP_STATUS_VERSION_NOT_SUP',0x000001F9)
    win_const_mgr.add_const('INPUT_KEYBOARD',0x00000001)
    win_const_mgr.add_const('DWORD_PTR_ERROR',0x00000000)
    win_const_mgr.add_const('EMR_SCALEWINDOWEXTEX',0x00000020)
    win_const_mgr.add_const('PERF_ATTRIB_BY_REFERENCE',0x00000001)
    win_const_mgr.add_const('IPX_STATIC_SERVICE_INFO_TYPE',0x00000003)
    win_const_mgr.add_const('OID_LTALK_OUT_NO_HANDLERS',0x05020201)
    win_const_mgr.add_const('BG_E_DESTINATION_LOCKED',0x8020000D)
    win_const_mgr.add_const('OBJ_ENHMETAFILE',0x0000000D)
    win_const_mgr.add_const('AA_S_CREATE',0x00000020)
    win_const_mgr.add_const('CM_CDFLAGS_DRIVER',0x00000001)
    win_const_mgr.add_const('SQL_UNSEARCHABLE',0x00000000)
    win_const_mgr.add_const('OUT_CHARACTER_PRECIS',0x00000002)
    win_const_mgr.add_const('PHONEERR_NOMEM',0x9000001A)
    win_const_mgr.add_const('CAL_SMONTHNAME2',0x00000016)
    win_const_mgr.add_const('IPX_IN_TRAFFIC_FILTER_GLOBAL_INFO_TYPE',0x0000000B)
    win_const_mgr.add_const('REPL_UNLOCK_FORCE',0x00000001)
    win_const_mgr.add_const('NTDSCONN_OPT_RODC_TOPOLOGY',0x00000001)
    win_const_mgr.add_const('IDS_CAP_STAT_L_FRAMES',0x000001FB)
    win_const_mgr.add_const('ISC_REQ_MUTUAL_AUTH',0x00000002)
    win_const_mgr.add_const('IMF_UIFONTS',0x00000020)
    win_const_mgr.add_const('DBIMF_TOPALIGN',0x00000400)
    win_const_mgr.add_const('MCI_DGV_COPY_VIDEO_STREAM',0x00040000)
    win_const_mgr.add_const('CREATE_NEW_CONSOLE',0x00000010)
    win_const_mgr.add_const('LOCALE_ITIME',0x00000023)
    win_const_mgr.add_const('CB_FINDSTRINGEXACT',0x00000158)
    win_const_mgr.add_const('SUBLANG_SPANISH_PERU',0x00000000)
    win_const_mgr.add_const('RP_DSN_SENT_DELAYED',0x00004000)
    win_const_mgr.add_const('DISPLAY_DEVICE_MULTI_DRIVER',0x00000002)
    win_const_mgr.add_const('PCMCIA_DEF_MEMLEN',0x00001000)
    win_const_mgr.add_const('CM_PROB_IRQ_TRANSLATION_FAILED',0x00000024)
    win_const_mgr.add_const('LINEFORWARDMODE_BUSYNAINTERNAL',0x00002000)
    win_const_mgr.add_const('MDPROPVAL_NL_NUMBEREDLEVELS',0x00000002)
    win_const_mgr.add_const('HELP_SETCONTENTS',0x00000005)
    win_const_mgr.add_const('TRUSTERROR_STEP_FINAL_OBJPROV',0x00000020)
    win_const_mgr.add_const('BS_CHECKBOX',0x00000002)
    win_const_mgr.add_const('VNSPROTO_RELIABLE_IPC',0x00000002)
    win_const_mgr.add_const('DISPID_SELECT',0x00000007)
    win_const_mgr.add_const('HHWIN_PARAM_CUR_TAB',0x00000001)
    win_const_mgr.add_const('DS_REPUPD_DELETE_REFERENCE',0x00000008)
    win_const_mgr.add_const('STAT_BUSY',0x00000000)
    win_const_mgr.add_const('LDAP_SCOPE_BASE',0x00000000)
    win_const_mgr.add_const('RUNCMDS_NOWAIT',0x00000002)
    win_const_mgr.add_const('CAL_JAPAN',0x00000003)
    win_const_mgr.add_const('IMAGE_REL_CEF_TOKEN',0x00000006)
    win_const_mgr.add_const('ADAPTER_FLOW_MODE_STANDARD',0x00000002)
    win_const_mgr.add_const('SQL_CT_CONSTRAINT_NON_DEFERRABLE',0x00000100)
    win_const_mgr.add_const('CRYPTUI_WIZ_DIGITAL_SIGN_PVK_PROV',0x00000002)
    win_const_mgr.add_const('PERF_SIZE_VARIABLE_LEN',0x00000300)
    win_const_mgr.add_const('DS_REPMOD_UPDATE_RESULT',0x00000008)
    win_const_mgr.add_const('SV_TYPE_LOCAL_LIST_ONLY',0x40000000)
    win_const_mgr.add_const('LINEERR_DIALBILLING',0x80000008)
    win_const_mgr.add_const('CF_DIF',0x00000005)
    win_const_mgr.add_const('CCHILDREN_TITLEBAR',0x00000005)
    win_const_mgr.add_const('TAPIMEDIATYPE_DATAMODEM',0x00000010)
    win_const_mgr.add_const('MD_NOTIFY_READ_RAW_DATA',0x00008000)
    win_const_mgr.add_const('RBAB_AUTOSIZE',0x00000001)
    win_const_mgr.add_const('BTH_ERROR_LMP_TRANSACTION_COLLISION',0x00000023)
    win_const_mgr.add_const('DDFXCAPS_BLTARITHSTRETCHYN',0x00000010)
    win_const_mgr.add_const('WT_EXECUTEINLONGTHREAD',0x00000010)
    win_const_mgr.add_const('SERVICE_CONTROL_PAUSE',0x00000002)
    win_const_mgr.add_const('IMFT_RADIOCHECK',0x00000001)
    win_const_mgr.add_const('SETRTS',0x00000003)
    win_const_mgr.add_const('LUP_RETURN_ADDR',0x00000100)
    win_const_mgr.add_const('TF_MOD_ALT',0x00000001)
    win_const_mgr.add_const('HHWIN_PARAM_EXPANSION',0x00000001)
    win_const_mgr.add_const('SM_CYEDGE',0x0000002E)
    win_const_mgr.add_const('SIZEPALETTE',0x00000068)
    win_const_mgr.add_const('ERROR_EVT_NON_VALIDATING_MSXML',0x00003AA5)
    win_const_mgr.add_const('VCSTATUS_READONLY',0x00000010)
    win_const_mgr.add_const('FLG_PROFITEM_GROUP',0x00000004)
    win_const_mgr.add_const('D3DCURSORCAPS_COLOR',0x00000001)
    win_const_mgr.add_const('WTPF_IGNOREREVOCATIONONTS',0x00020000)
    win_const_mgr.add_const('MK_MBUTTON',0x00000010)
    win_const_mgr.add_const('GCP_LIGATE',0x00000020)
    win_const_mgr.add_const('DISABLE_DET_STALL_FIX',0x00000003)
    win_const_mgr.add_const('DISPID_RUNONCEREQUIREDSETTINGSCOMPLETE',0x0000001B)
    win_const_mgr.add_const('WMDM_E_LICENSE_NOTEXIST',0x8004500F)
    win_const_mgr.add_const('V86FLAGS_IOPL',0x00003000)
    win_const_mgr.add_const('ERR_DISK_OPEN_ERROR',0xE0000003)
    win_const_mgr.add_const('IMC_GETCOMPOSITIONFONT',0x00000009)
    win_const_mgr.add_const('EMR_SETMITERLIMIT',0x0000003A)
    win_const_mgr.add_const('SYSPAL_STATIC',0x00000001)
    win_const_mgr.add_const('CERT_STORE_UNSAFE_PHYSICAL_FLAG',0x00000020)
    win_const_mgr.add_const('VDMDBG_BREAK_EXCEPTIONS',0x00000008)
    win_const_mgr.add_const('CREATE_NEW_PROCESS_GROUP',0x00000200)
    win_const_mgr.add_const('OID_GEN_FRIENDLY_NAME',0x00020216)
    win_const_mgr.add_const('MCIERR_BASE',0x00000100)
    win_const_mgr.add_const('HHN_FIRST',0x00000000)
    win_const_mgr.add_const('TRUSTERROR_STEP_VERIFY_MSGINDIRECTDATA',0x00000013)
    win_const_mgr.add_const('SQL_API_SQLCOLATTRIBUTE',0x00000006)
    win_const_mgr.add_const('LUP_DEEP',0x00000001)
    win_const_mgr.add_const('GAA_FLAG_SKIP_UNICAST',0x00000001)
    win_const_mgr.add_const('SQL_API_SQLFREEENV',0x0000000F)
    win_const_mgr.add_const('CPS_REVERT',0x00000003)
    win_const_mgr.add_const('RBBIM_ID',0x00000100)
    win_const_mgr.add_const('RP_UNRESOLVED',0x00001030)
    win_const_mgr.add_const('UF_DONT_REQUIRE_PREAUTH',0x00400000)
    win_const_mgr.add_const('SECURITY_LOGON_IDS_RID',0x00000005)
    win_const_mgr.add_const('AM_DVD_SECTOR_NOT_PROTECTED',0x00000000)
    win_const_mgr.add_const('NUM_BASIC_COLORS',0x00000030)
    win_const_mgr.add_const('INTERNET_CONNECTION_CONFIGURED',0x00000040)
    win_const_mgr.add_const('DMPAPER_LETTER_TRANSVERSE',0x00000036)
    win_const_mgr.add_const('PRINTER_ATTRIBUTE_DIRECT',0x00000002)
    win_const_mgr.add_const('LINEADDRESSSHARING_PRIVATE',0x00000001)
    win_const_mgr.add_const('SQL_COMMIT',0x00000000)
    win_const_mgr.add_const('IDC_GP_OBJECTTYPE',0x000003F2)
    win_const_mgr.add_const('DISPID_AUTOCOMPLETESAVEFORM',0x0000000A)
    win_const_mgr.add_const('PRINTER_ENUM_ICON4',0x00080000)
    win_const_mgr.add_const('TMT_HEADING1FONT',0x00000327)
    win_const_mgr.add_const('SYNC_HANDLERTYPE_OTHER',0x00000000)
    win_const_mgr.add_const('COOKIE_STATE_LB',0x00000000)
    win_const_mgr.add_const('IDM_TELETYPE',0x000008B8)
    win_const_mgr.add_const('IDM_TRIED_HYPERLINK',0x00000028)
    win_const_mgr.add_const('DISPID_ONKEYDOWN',0x0000000C)
    win_const_mgr.add_const('BCRYPT_CIPHER_INTERFACE',0x00000001)
    win_const_mgr.add_const('TCPIP_OWNING_MODULE_SIZE',0x00000010)
    win_const_mgr.add_const('DFCS_PUSHED',0x00000200)
    win_const_mgr.add_const('BCRYPT_ECDH_PRIVATE_P521_MAGIC',0x364B4345)
    win_const_mgr.add_const('RTM_VIEW_MASK_UCAST',0x00000001)
    win_const_mgr.add_const('CERT_ALT_NAME_VALUE_ERR_INDEX_MASK',0x0000FFFF)
    win_const_mgr.add_const('ERROR_NO_SUCH_GROUP',0x00000527)
    
    # Generic Access Rights
    win_const_mgr.add_const('GENERIC_ALL',0x10000000)
    win_const_mgr.add_const('GENERIC_EXECUTE',0x20000000)
    win_const_mgr.add_const('GENERIC_WRITE',0x40000000)
    win_const_mgr.add_const('GENERIC_READ',0x80000000)
    
        
    # Standard Access Rights
    win_const_mgr.add_const('DELETE',0x00010000)
    win_const_mgr.add_const('READ_CONTROL',0x00020000)
    win_const_mgr.add_const('WRITE_DAC',0x00040000)
    win_const_mgr.add_const('WRITE_OWNER',0x00080000)
    win_const_mgr.add_const('ACCESS_SYSTEM_SECURITY',0x01000000)
    
    # Services
    win_const_mgr.add_const('SERVICE_NO_CHANGE',0xFFFFFFFF)
    
    # Service Start Types
    win_const_mgr.add_const('START_TYPE_BOOT',0x00000000)
    win_const_mgr.add_const('START_TYPE_SYSTEM',0x00000001)
    win_const_mgr.add_const('START_TYPE_AUTO',0x00000002)
    win_const_mgr.add_const('START_TYPE_MANUAL',0x00000003)
    win_const_mgr.add_const('START_TYPE_DISABLED',0x00000004)
    
    # Service States
    win_const_mgr.add_const('SERVICE_STOPPED',0x00000001)
    win_const_mgr.add_const('SERVICE_START_PENDING',0x00000002)
    win_const_mgr.add_const('SERVICE_STOP_PENDING',0x00000003)
    win_const_mgr.add_const('SERVICE_RUNNING',0x00000004)
    win_const_mgr.add_const('SERVICE_CONTINUE_PENDING',0x00000005)
    win_const_mgr.add_const('SERVICE_PAUSE_PENDING',0x00000006)
    win_const_mgr.add_const('SERVICE_PAUSED',0x00000007)
    
    # Service Types
    win_const_mgr.add_const('SERVICE_KERNEL_DRIVER',0x00000001)
    win_const_mgr.add_const('SERVICE_FILE_SYSTEM_DRIVER',0x00000002)
    win_const_mgr.add_const('SERVICE_ADAPTER',0x00000004)
    win_const_mgr.add_const('SERVICE_RECOGNIZER_DRIVER',0x00000008)
    win_const_mgr.add_const('SERVICE_WIN32_OWN_PROCESS',0x00000010)
    win_const_mgr.add_const('SERVICE_WIN32_SHARE_PROCESS',0x00000020)
    
    # Service Manager Permissions
    win_const_mgr.add_const('SC_MANAGER_CONNECT',0x00000001)
    win_const_mgr.add_const('SC_MANAGER_CREATE_SERVICE',0x00000002)
    win_const_mgr.add_const('SC_MANAGER_ENUMERATE_SERVICE',0x00000004)
    win_const_mgr.add_const('SC_MANAGER_LOCK',0x00000008)
    win_const_mgr.add_const('SC_MANAGER_QUERY_LOCK_STATUS',0x00000010)
    win_const_mgr.add_const('SC_MANAGER_MODIFY_BOOT_CONFIG',0x00000020)
    win_const_mgr.add_const('SC_MANAGER_USER_DEFINED_CONTROL',0x00000100)
    win_const_mgr.add_const('SC_MANAGER_ALL_ACCESS',0x000F003F)
    
    # Service Permissions
    win_const_mgr.add_const('SERVICE_QUERY_CONFIG',0x00000001)
    win_const_mgr.add_const('SERVICE_CHANGE_CONFIG',0x00000002)
    win_const_mgr.add_const('SERVICE_QUERY_STATUS',0x00000004)
    win_const_mgr.add_const('SERVICE_ENUMERATE_DEPENDENTS',0x00000008)
    win_const_mgr.add_const('SERVICE_START',0x00000010)
    win_const_mgr.add_const('SERVICE_STOP',0x00000020)
    win_const_mgr.add_const('SERVICE_PAUSE_CONTINUE',0x00000040)
    win_const_mgr.add_const('SERVICE_INTERROGATE',0x00000080)
    win_const_mgr.add_const('SERVICE_USER_DEFINED_CONTROL',0x00000100)
    win_const_mgr.add_const('SERVICE_ALL_ACCESS',0x000F01FF)
    
    win_const_mgr.add_const('LINEINITIALIZEEXOPTION_USECOMPLETIONPORT',0x00000003)
    win_const_mgr.add_const('AVIIF_TWOCC',0x00000002)
    win_const_mgr.add_const('TBTS_LEFT',0x00000001)
    win_const_mgr.add_const('PDH_LOGSVC_QUERY_NOT_FOUND',0xC0000BD8)
    win_const_mgr.add_const('PRINTER_CONTROL_PAUSE',0x00000001)
    win_const_mgr.add_const('RPC_C_IMP_LEVEL_ANONYMOUS',0x00000001)
    win_const_mgr.add_const('DIF_DETECTVERIFY',0x00000014)
    win_const_mgr.add_const('HCF_AVAILABLE',0x00000002)
    win_const_mgr.add_const('PT_BEZIERTO',0x00000004)
    win_const_mgr.add_const('BG_E_PROXY_LIST_TOO_LARGE',0x80200018)
    win_const_mgr.add_const('SW_HIDE',0x00000000)
    win_const_mgr.add_const('ACM_FORMATENUMF_CONVERT',0x00100000)
    win_const_mgr.add_const('CERT_VALIDITY_AFTER_END',0x00000002)
    win_const_mgr.add_const('RPC_C_STATS_PKTS_IN',0x00000002)
    win_const_mgr.add_const('DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_FALSE_PLUS',0x00FFFFFB)
    win_const_mgr.add_const('WM_CUT',0x00000300)
    win_const_mgr.add_const('SP_PROT_SSL3_CLIENT',0x00000020)
    win_const_mgr.add_const('SS_WHITEFRAME',0x00000009)
    win_const_mgr.add_const('IMAGE_REL_AMD64_SECREL',0x0000000B)
    win_const_mgr.add_const('OPATH_TOK_DOT',0x00000069)
    win_const_mgr.add_const('INTERNET_STATUS_USER_INPUT_REQUIRED',0x0000008C)
    win_const_mgr.add_const('PSD_NOWARNING',0x00000080)
    win_const_mgr.add_const('WINHTTP_QUERY_WWW_AUTHENTICATE',0x00000028)
    win_const_mgr.add_const('PATCH_OPTION_NO_TIMESTAMP',0x00800000)
    win_const_mgr.add_const('ERROR_WMI_SERVER_UNAVAILABLE',0x00001070)
    win_const_mgr.add_const('SQL_API_SQLEXECDIRECT',0x0000000B)
    win_const_mgr.add_const('TMT_SIZES',0x00000192)
    win_const_mgr.add_const('SQL_DESC_UNNAMED',0x000003F4)
    win_const_mgr.add_const('SMART_ERROR_NO_MEM',0x00000007)
    win_const_mgr.add_const('APPCOMMAND_DWM_FLIP3D',0x00000036)
    win_const_mgr.add_const('FILE_SUPPORTS_REPARSE_POINTS',0x00000080)
    win_const_mgr.add_const('IN_CLASSD_HOST',0x00000000)
    win_const_mgr.add_const('WINHTTP_OPTION_REQUEST_PRIORITY',0x0000003A)
    win_const_mgr.add_const('TRBN_FIRST',0x00000000)
    win_const_mgr.add_const('PORT_HOSTS2NS',0x00000051)
    win_const_mgr.add_const('DNSSEC_PROTOCOL_TLS',0x00000001)
    win_const_mgr.add_const('HH_PRETRANSLATEMESSAGE',0x00000000)
    win_const_mgr.add_const('OPTION_ARP_CACHE_TIMEOUT',0x00000023)
    win_const_mgr.add_const('SV_SCAVTIMEOUT_PARMNUM',0x00000210)
    win_const_mgr.add_const('DBPROP_MSDAORA_DETERMINEKEYCOLUMNS',0x00000001)
    win_const_mgr.add_const('LINEDIALTONEMODE_NORMAL',0x00000001)
    win_const_mgr.add_const('DOT11_ASSOC_STATUS_ASSOCIATION_RESPONSE',0x00030000)
    win_const_mgr.add_const('DI_COMPAT_FROM_CLASS',0x00080000)
    win_const_mgr.add_const('MPEG2_PROGRAM_DIRECTORY_PES_PACKET',0x00000002)
    win_const_mgr.add_const('MF_UNHILITE',0x00000000)
    win_const_mgr.add_const('CAUSE_COND_TRANSIENT',0x00000002)
    win_const_mgr.add_const('CMSG_CRL_COUNT_PARAM',0x0000000D)
    win_const_mgr.add_const('DNS_RTYPE_X25',0x00001300)
    win_const_mgr.add_const('MEDIA_WRITE_PROTECTED',0x00000100)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_DATAON',0x00000018)
    win_const_mgr.add_const('SQL_FN_STR_ASCII',0x00002000)
    win_const_mgr.add_const('ACTRL_PERM_6',0x00000020)
    win_const_mgr.add_const('ACTRL_PERM_7',0x00000040)
    win_const_mgr.add_const('ACTRL_PERM_4',0x00000008)
    win_const_mgr.add_const('ACTRL_PERM_5',0x00000010)
    win_const_mgr.add_const('ACTRL_PERM_2',0x00000002)
    win_const_mgr.add_const('ACTRL_PERM_3',0x00000004)
    win_const_mgr.add_const('ACTRL_PERM_1',0x00000001)
    win_const_mgr.add_const('PHONEFEATURE_SETHOOKSWITCHSPEAKER',0x00200000)
    win_const_mgr.add_const('PERF_TIMER_100NS',0x00100000)
    win_const_mgr.add_const('IDTB_EXPAND',0x000000C8)
    win_const_mgr.add_const('ACTRL_PERM_8',0x00000080)
    win_const_mgr.add_const('IKEEXT_CERT_CREDENTIAL_FLAG_NAP_CERT',0x00000001)
    win_const_mgr.add_const('PFNS_PAREN',0x00000000)
    win_const_mgr.add_const('EMR_SETARCDIRECTION',0x00000039)
    win_const_mgr.add_const('SV_LOCKVIOLATIONRETRIES_PARMNUM',0x00000237)
    win_const_mgr.add_const('MAXBQUALSIZE',0x00000040)
    win_const_mgr.add_const('SPI_SETFOREGROUNDFLASHCOUNT',0x00002005)
    win_const_mgr.add_const('MF_USER_MODE_COMPONENT_LOAD',0x00000001)
    win_const_mgr.add_const('D3DTA_DIFFUSE',0x00000000)
    win_const_mgr.add_const('CM_DEVCAP_LOCKSUPPORTED',0x00000001)
    win_const_mgr.add_const('PRINTER_CHANGE_TIMEOUT',0x80000000)
    win_const_mgr.add_const('CREDP_FLAGS_IN_PROCESS',0x00000001)
    win_const_mgr.add_const('LDAP_OPT_ERROR_STRING',0x00000032)
    win_const_mgr.add_const('IMR_COMPOSITIONWINDOW',0x00000001)
    win_const_mgr.add_const('C3_SYMBOL',0x00000008)
    win_const_mgr.add_const('KERB_RETRIEVE_TICKET_WITH_SEC_CRED',0x00000010)
    win_const_mgr.add_const('DDCAPS2_CANMANAGETEXTURE',0x00800000)
    win_const_mgr.add_const('FAILED_ACCESS_ACE_FLAG',0x00000080)
    win_const_mgr.add_const('CTRY_HUNGARY',0x00000024)
    win_const_mgr.add_const('TBMF_BUTTONSPACING',0x00000004)
    win_const_mgr.add_const('CERT_VALIDITY_OTHER_EXTENSION_FAILURE',0x00000200)
    win_const_mgr.add_const('SUBLANG_ITALIAN_SWISS',0x00000002)
    win_const_mgr.add_const('CM_DETECT_BITS',0x80000007)
    win_const_mgr.add_const('WS_THICKFRAME',0x00040000)
    win_const_mgr.add_const('LANG_OCCITAN',0x00000082)
    win_const_mgr.add_const('SQL_OPT_TRACE_OFF',0x00000000)
    win_const_mgr.add_const('PHONESTATE_REINIT',0x00200000)
    win_const_mgr.add_const('IIS_MD_SSL_BASE',0x0000157C)
    win_const_mgr.add_const('ES_LEFT',0x00000000)
    win_const_mgr.add_const('CREDSSP_SERVER_AUTH_NEGOTIATE',0x00000001)
    win_const_mgr.add_const('JOB_OBJECT_MSG_END_OF_PROCESS_TIME',0x00000002)
    win_const_mgr.add_const('CRYPT_EXPORT',0x00000004)
    win_const_mgr.add_const('WIA_IPS_MAX_HORIZONTAL_SIZE',0x00001815)
    win_const_mgr.add_const('DISPID_GETERRORCODE',0x00000010)
    win_const_mgr.add_const('CERT_FILTER_ISSUER_CERTS_ONLY',0x00000010)
    win_const_mgr.add_const('MF_8_BYTE_ALIGNMENT',0x00000007)
    win_const_mgr.add_const('OID_GEN_VLAN_ID',0x0001021C)
    win_const_mgr.add_const('_WIN32_IE_IE60',0x00000600)
    win_const_mgr.add_const('SV_TYPE_CLUSTER_VS_NT',0x04000000)
    win_const_mgr.add_const('SN_INFLAG_INSTALL',0x00000002)
    win_const_mgr.add_const('ACCESS_ALLOWED_CALLBACK_ACE_TYPE',0x00000009)
    win_const_mgr.add_const('IOCTL_WMP_DEVICE_CAN_SYNC',0x00032504)
    win_const_mgr.add_const('NDIS_RING_COUNTER_OVERFLOW',0x00000100)
    win_const_mgr.add_const('ETW_ASCIICHAR_TYPE_VALUE',0x00000066)
    win_const_mgr.add_const('DTBG_OMITBORDER',0x00000004)
    win_const_mgr.add_const('CLUSCTL_OBJECT_SHIFT',0x00000018)
    win_const_mgr.add_const('ADOMD_MINOR',0x00000000)
    win_const_mgr.add_const('ERROR_DS_NO_REQUESTED_ATTS_FOUND',0x00002074)
    win_const_mgr.add_const('RTM_ENUM_NEXT',0x00000001)
    win_const_mgr.add_const('DBPROPVAL_SQL_ANSI92_FULL',0x00000080)
    win_const_mgr.add_const('SQL_AT_CONSTRAINT_INITIALLY_DEFERRED',0x00010000)
    win_const_mgr.add_const('KSPIN_FLAG_PROCESS_IN_RUN_STATE_ONLY',0x00010000)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_SUPPORTEDWRITESPEEDS',0x00000115)
    win_const_mgr.add_const('IDM_ORDERLIST',0x00000888)
    win_const_mgr.add_const('FACILITY_AUDCLNT',0x00000889)
    win_const_mgr.add_const('ERROR_DS_POLICY_NOT_KNOWN',0x000021AA)
    win_const_mgr.add_const('LINEPROXYREQUEST_GETAGENTGROUPLIST',0x00000008)
    win_const_mgr.add_const('PHONE_CREATE',0x00000014)
    win_const_mgr.add_const('SQL_DD_DROP_DOMAIN',0x00000001)
    win_const_mgr.add_const('FOF_ALLOWUNDO',0x00000040)
    win_const_mgr.add_const('CRYPTUI_WIZ_DIGITAL_SIGN_EXCLUDE_PAGE_HASHES',0x00000002)
    win_const_mgr.add_const('KSALLOCATOR_FLAG_CYCLE',0x00000400)
    win_const_mgr.add_const('DNS_ATMA_FORMAT_AESA',0x00000002)
    win_const_mgr.add_const('PRINTER_STATUS_WARMING_UP',0x00010000)
    win_const_mgr.add_const('SNMPAPI_TL_TIMEOUT',0x0000006C)
    win_const_mgr.add_const('GPO_INFO_FLAG_ASYNC_FOREGROUND',0x00001000)
    win_const_mgr.add_const('ENM_DRAGDROPDONE',0x00000010)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_MUTLISESSIONINTERFACES',0x00000118)
    win_const_mgr.add_const('IN_CLASSB_NET',0x00000000)
    win_const_mgr.add_const('MD_AUTH_BASIC',0x00000002)
    win_const_mgr.add_const('PDH_NOEXPANDINSTANCES',0x00000002)
    win_const_mgr.add_const('PHOTO_SHARPNESS_NORMAL',0x00000000)
    win_const_mgr.add_const('SPDRP_PHYSICAL_DEVICE_OBJECT_NAME',0x0000000E)
    win_const_mgr.add_const('VECTOR_RANK_MAX',0x00000001)
    win_const_mgr.add_const('MAX_INTLIST_COUNT',0x0000000A)
    win_const_mgr.add_const('RPC_S_NOT_RPC_ERROR',0x0000071F)
    win_const_mgr.add_const('WIN_CERT_REVISION_1_0',0x00000100)
    win_const_mgr.add_const('IP_RTHDR',0x00000020)
    win_const_mgr.add_const('ERROR_DEPENDENCY_ALREADY_EXISTS',0x0000138B)
    win_const_mgr.add_const('ESLFLAG_FULLPATH',0x00000001)
    win_const_mgr.add_const('LINECALLFEATURE_SETQOS',0x40000000)
    win_const_mgr.add_const('NRC_ILLCMD',0x00000003)
    win_const_mgr.add_const('INTERNET_SERVICE_FTP',0x00000001)
    win_const_mgr.add_const('PERF_MULTI_COUNTER',0x02000000)
    win_const_mgr.add_const('KP_PUB_PARAMS',0x00000027)
    win_const_mgr.add_const('MAX_PST_ERROR',0x800C0F00)
    win_const_mgr.add_const('OPTION_NETWORK_TIME_SERVERS',0x0000002A)
    win_const_mgr.add_const('PSF_HIDECHANGEICON',0x00000020)
    win_const_mgr.add_const('SPI_SETFONTSMOOTHINGCONTRAST',0x0000200D)
    win_const_mgr.add_const('IGIMII_HELP',0x00000010)
    win_const_mgr.add_const('UIS_CLEAR',0x00000002)
    win_const_mgr.add_const('ICMODE_FASTCOMPRESS',0x00000005)
    win_const_mgr.add_const('WM_SYSDEADCHAR',0x00000107)
    win_const_mgr.add_const('PIFMAXFILEPATH',0x00000104)
    win_const_mgr.add_const('WM_QUIT',0x00000012)
    win_const_mgr.add_const('ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER',0x00002146)
    win_const_mgr.add_const('WINHTTP_ACCESS_TYPE_NAMED_PROXY',0x00000003)
    win_const_mgr.add_const('RPC_PROTSEQ_HTTP',0x00000004)
    win_const_mgr.add_const('MCSC_TITLEBK',0x00000002)
    win_const_mgr.add_const('CHARS_IN_GUID',0x00000027)
    win_const_mgr.add_const('PFD_SUPPORT_GDI',0x00000010)
    win_const_mgr.add_const('GMEM_SHARE',0x00002000)
    win_const_mgr.add_const('KSPROPERTY_TYPE_DEFAULTVALUES',0x00010000)
    win_const_mgr.add_const('MDFF_ITALIC',0x00000002)
    win_const_mgr.add_const('DI_FORCECOPY',0x02000000)
    win_const_mgr.add_const('MDM_V110_SPEED_DEFAULT',0x00000000)
    win_const_mgr.add_const('COD_IMAGING_MINOR_DISPLAY_MASK',0x00000004)
    win_const_mgr.add_const('FILE_READ_DATA',0x00000001)
    win_const_mgr.add_const('DB_BINDFLAGS_ISSTRUCTUREDDOCUMENT',0x00000080)
    win_const_mgr.add_const('IMAGE_REL_IA64_SECREL64I',0x0000000D)
    win_const_mgr.add_const('DDF_HALFTONE',0x00001000)
    win_const_mgr.add_const('USER_PASSWORD_EXPIRED',0x00020000)
    win_const_mgr.add_const('PID_INTSITE_RECURSE',0x0000000C)
    win_const_mgr.add_const('AUDCLNT_STREAMFLAGS_LOOPBACK',0x00020000)
    win_const_mgr.add_const('DBIMF_NORMAL',0x00000000)
    win_const_mgr.add_const('JOY_BUTTON2CHG',0x00000200)
    win_const_mgr.add_const('F_LOCATION',0x0000000D)
    win_const_mgr.add_const('IDM_TRIED_IS_2D_ELEMENT',0x00000001)
    win_const_mgr.add_const('MDM_X75_DATA_DEFAULT',0x00000000)
    win_const_mgr.add_const('NOM_BS1',0x00000002)
    win_const_mgr.add_const('VK_BROWSER_HOME',0x000000AC)
    win_const_mgr.add_const('NET_VALIDATE_BAD_PASSWORD_TIME',0x00000002)
    win_const_mgr.add_const('MD_SERVER_COMMAND_START',0x00000001)
    win_const_mgr.add_const('NOM_BT2',0x00000200)
    win_const_mgr.add_const('EVENT_SYSTEM_CAPTUREEND',0x00000009)
    win_const_mgr.add_const('ERROR_NO_TRACKING_SERVICE',0x00000494)
    win_const_mgr.add_const('SQL_ROW_SUCCESS_WITH_INFO',0x00000006)
    win_const_mgr.add_const('ERROR_INVALID_MESSAGE',0x000003EA)
    win_const_mgr.add_const('KSFILTER_FLAG_DENY_USERMODE_ACCESS',0x80000000)
    win_const_mgr.add_const('HIGHLY_DELAY_SENSITIVE',0xFFFFFFFE)
    win_const_mgr.add_const('PORT_TEMPO',0x0000020E)
    win_const_mgr.add_const('CBA_EVENT',0x00000010)
    win_const_mgr.add_const('SHIL_EXTRALARGE',0x00000002)
    win_const_mgr.add_const('MCI_ANIM_PLAY_REVERSE',0x00020000)
    win_const_mgr.add_const('SOCKET_INFO_CONNECTION_SECURED',0x00000001)
    win_const_mgr.add_const('META_SETMAPMODE',0x00000103)
    win_const_mgr.add_const('IF_TYPE_V35',0x0000002D)
    win_const_mgr.add_const('PFM_NOLINENUMBER',0x00100000)
    win_const_mgr.add_const('DSPRINT_PENDING',0x80000000)
    win_const_mgr.add_const('SQL_SQL92_FOREIGN_KEY_UPDATE_RULE',0x0000009D)
    win_const_mgr.add_const('DCX_LOCKWINDOWUPDATE',0x00000400)
    win_const_mgr.add_const('CWCSTORAGENAME',0x00000020)
    win_const_mgr.add_const('EFS_USE_RECOVERY_KEYS',0x00000001)
    win_const_mgr.add_const('TXTBIT_CHARFORMATCHANGE',0x00020000)
    win_const_mgr.add_const('OPERATION_IDEMPOTENT',0x00000004)
    win_const_mgr.add_const('DMICM_ABS_COLORIMETRIC',0x00000004)
    win_const_mgr.add_const('PXE_ADDR_BROADCAST',0x00000001)
    win_const_mgr.add_const('ADS_SERVICE_FILE_SYSTEM_DRIVER',0x00000002)
    win_const_mgr.add_const('PF_MMX_INSTRUCTIONS_AVAILABLE',0x00000003)
    win_const_mgr.add_const('LUP_NOCONTAINERS',0x00000004)
    win_const_mgr.add_const('LINEDIALTONEMODE_EXTERNAL',0x00000008)
    win_const_mgr.add_const('SPDRP_ADDRESS',0x0000001C)
    win_const_mgr.add_const('NDIS_MAC_OPTION_NO_LOOPBACK',0x00000008)
    win_const_mgr.add_const('DBIF_VIEWMODE_VERTICAL',0x00000001)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED',0x00003624)
    win_const_mgr.add_const('MB_USERICON',0x00000080)
    win_const_mgr.add_const('ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED',0x00000BBD)
    win_const_mgr.add_const('MAPI_BODY_AS_FILE',0x00000200)
    win_const_mgr.add_const('OS_APPLIANCE',0x00000024)
    win_const_mgr.add_const('KSMETHOD_WAVE_QUEUED_BREAKLOOP',0x00000001)
    win_const_mgr.add_const('WINHTTP_CALLBACK_STATUS_INTERMEDIATE_RESPONSE',0x00008000)
    win_const_mgr.add_const('INHERITED_ACE',0x00000010)
    win_const_mgr.add_const('USER_MARSHAL_IID',0x00000020)
    win_const_mgr.add_const('SSF_SHOWCOMPCOLOR',0x00000008)
    win_const_mgr.add_const('PID_IS_NAME',0x00000004)
    win_const_mgr.add_const('CRED_PRESERVE_CREDENTIAL_BLOB',0x00000001)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_SHOWMODALDIALOG',0x00000482)
    win_const_mgr.add_const('INTERNET_REQFLAG_CACHE_WRITE_DISABLED',0x00000040)
    win_const_mgr.add_const('KSDATARANGE_BIT_REQUIRED_ATTRIBUTES',0x00000002)
    win_const_mgr.add_const('MNS_MODELESS',0x40000000)
    win_const_mgr.add_const('SQL_PC_NON_PSEUDO',0x00000001)
    win_const_mgr.add_const('LANG_CROATIAN',0x00000001)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_PROCEDURE_COLUMNS',0x00000004)
    win_const_mgr.add_const('LVIF_IMAGE',0x00000002)
    win_const_mgr.add_const('TBSTATE_PRESSED',0x00000002)
    win_const_mgr.add_const('SQL_INSERT_STATEMENT',0x000000AC)
    win_const_mgr.add_const('VK_OEM_FJ_JISHO',0x00000092)
    win_const_mgr.add_const('KSSTREAM_HEADER_OPTIONSF_ENDOFSTREAM',0x00000200)
    win_const_mgr.add_const('CDO_E_HTTP_FORBIDDEN',0x80040219)
    win_const_mgr.add_const('EVENT_HEADER_FLAG_32_BIT_HEADER',0x00000020)
    win_const_mgr.add_const('ERROR_SMARTCARD_SUBSYSTEM_FAILURE',0x000004F0)
    win_const_mgr.add_const('COD_MAJOR_UNCLASSIFIED',0x0000001F)
    win_const_mgr.add_const('SERIAL_IOC_MCR_LOOP',0x00000010)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_NETWORK_CONFIGURATION_OPS',0x0000022C)
    win_const_mgr.add_const('EN_REQUESTRESIZE',0x00000701)
    win_const_mgr.add_const('LINECALLINFOSTATE_RATE',0x00000008)
    win_const_mgr.add_const('DISPID_INVOKECONTEXTMENU',0x00000008)
    win_const_mgr.add_const('PAGE_EXECUTE_READ',0x00000020)
    win_const_mgr.add_const('NETE_CONNBUSY',0x00000003)
    win_const_mgr.add_const('SERVICE_INACTIVE',0x00000002)
    win_const_mgr.add_const('C3_NOTAPPLICABLE',0x00000000)
    win_const_mgr.add_const('WSA_QOS_EPROVSPECBUF',0x00002B0A)
    win_const_mgr.add_const('SQL_IS_SELECT_INTO',0x00000004)
    win_const_mgr.add_const('IEIFLAG_GLEAM',0x00000010)
    win_const_mgr.add_const('PLA_CAPABILITY_V1_SVC',0x00000001)
    win_const_mgr.add_const('ERROR_SERVICE_REQUEST_TIMEOUT',0x0000041D)
    win_const_mgr.add_const('ALG_SID_RSA_MSATWORK',0x00000002)
    win_const_mgr.add_const('CP_UTF8',0x0000FDE9)
    win_const_mgr.add_const('IMC_SETSTATUSWINDOWPOS',0x00000010)
    win_const_mgr.add_const('DSA_NOTIFY_PROP',0x00000008)
    win_const_mgr.add_const('CERT_CHAIN_REVOCATION_ACCUMULATIVE_TIMEOUT',0x08000000)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_BRADDR',0x00000007)
    win_const_mgr.add_const('PANE_PRIVACY',0x00000007)
    win_const_mgr.add_const('WINSTA_CREATEDESKTOP',0x00000008)
    win_const_mgr.add_const('ACCESS_DENIED_ACE_TYPE',0x00000001)
    win_const_mgr.add_const('WM_CONTEXTMENU',0x0000007B)
    win_const_mgr.add_const('WTNCA_NODRAWICON',0x00000002)
    win_const_mgr.add_const('SUBVERSION_MASK',0x000000FF)
    win_const_mgr.add_const('LGRPID_JAPANESE',0x00000007)
    win_const_mgr.add_const('CSIDL_WINDOWS',0x00000024)
    win_const_mgr.add_const('SCARD_SPECIFIC',0x00000006)
    win_const_mgr.add_const('IMAGE_RESOURCE_NAME_IS_STRING',0x80000000)
    win_const_mgr.add_const('SUBSTREAM_FILTER_VAL_NONE',0x10000000)
    win_const_mgr.add_const('PRINTER_STATUS_ERROR',0x00000002)
    win_const_mgr.add_const('MSV1_0_CRED_LM_PRESENT',0x00000001)
    win_const_mgr.add_const('CERT_CREATE_SELFSIGN_NO_KEY_INFO',0x00000002)
    win_const_mgr.add_const('DEBUG_MANRESET_DEFAULT',0x00000000)
    win_const_mgr.add_const('AM_GETDECODERCAP_QUERY_VMR_SUPPORT',0x00000001)
    win_const_mgr.add_const('MCI_OVLY_WINDOW_ENABLE_STRETCH',0x00100000)
    win_const_mgr.add_const('TMT_MSGBOXFONT',0x00000325)
    win_const_mgr.add_const('SERVICE_NT_MAXTIME',0x0000FFFF)
    win_const_mgr.add_const('IDB_STD_SMALL_COLOR',0x00000000)
    win_const_mgr.add_const('GROUP_ALL_PARMNUM',0x00000000)
    win_const_mgr.add_const('PID_SHARE_CSC_STATUS',0x00000002)
    win_const_mgr.add_const('MCI_STATUS_NUMBER_OF_TRACKS',0x00000003)
    win_const_mgr.add_const('PSR_DFL',0x00000012)
    win_const_mgr.add_const('TRUSTERROR_STEP_CATALOGFILE',0x00000006)
    win_const_mgr.add_const('SBSP_OPENMODE',0x00000010)
    win_const_mgr.add_const('DELTA_MAX_HASH_SIZE',0x00000020)
    win_const_mgr.add_const('NS_MS',0x0000001E)
    win_const_mgr.add_const('KP_RA',0x00000010)
    win_const_mgr.add_const('URLACTION_ALLOW_XDOMAIN_SUBFRAME_RESIZE',0x00001408)
    win_const_mgr.add_const('BLLI_L2_MODE_EXT',0x00000080)
    win_const_mgr.add_const('MAPI_ALLOW_OTHERS',0x00000008)
    win_const_mgr.add_const('DFS_VOLUME_STATE_OK',0x00000001)
    win_const_mgr.add_const('OCR_SIZENS',0x00007F85)
    win_const_mgr.add_const('MEDIA_WRITE_ONCE',0x00000002)
    win_const_mgr.add_const('CB_ADDSTRING',0x00000143)
    win_const_mgr.add_const('SERVICE_CCP_QUERY_HINT',0x00010000)
    win_const_mgr.add_const('SBSP_NAVIGATEBACK',0x00004000)
    win_const_mgr.add_const('KP_RP',0x00000017)
    win_const_mgr.add_const('PID_SYNC_COPY_IN',0x00000002)
    win_const_mgr.add_const('RPC_X_WRONG_ES_VERSION',0x00000724)
    win_const_mgr.add_const('DMPAPER_B6_JIS_ROTATED',0x00000059)
    win_const_mgr.add_const('MCI_SEQ_STATUS_COPYRIGHT',0x0000400C)
    win_const_mgr.add_const('BSIS_NOCONTEXTMENU',0x00000010)
    win_const_mgr.add_const('PROPFLAGS_INDEXED',0x00010000)
    win_const_mgr.add_const('WMPCOREEVENT_BASE',0x00001388)
    win_const_mgr.add_const('DECIMAL_BASE',0x0000000A)
    win_const_mgr.add_const('SPI_SETDISABLEOVERLAPPEDCONTENT',0x00001041)
    win_const_mgr.add_const('CR_CANT_SHARE_IRQ',0x0000002B)
    win_const_mgr.add_const('LOCALE_S2359',0x00000029)
    win_const_mgr.add_const('COMCTL32_VERSION',0x00000005)
    win_const_mgr.add_const('ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT',0x00000710)
    win_const_mgr.add_const('PORT_RLP',0x00000027)
    win_const_mgr.add_const('ERROR_SXS_DUPLICATE_CLSID',0x000036C7)
    win_const_mgr.add_const('TAPE_QUERY_MEDIA_CAPACITY',0x00000001)
    win_const_mgr.add_const('MIB_IPADDR_TRANSIENT',0x00000080)
    win_const_mgr.add_const('SQL_DB_DISCONNECT',0x00000001)
    win_const_mgr.add_const('ACTRL_DS_OPEN',0x00000000)
    win_const_mgr.add_const('COD_AUDIO_MINOR_CAR_AUDIO',0x00000008)
    win_const_mgr.add_const('IF_TYPE_WAN_ROUTER',0x00000003)
    win_const_mgr.add_const('CHANNEL_OPTION_PRI_LOW',0x02000000)
    win_const_mgr.add_const('MNID_ID',0x00000000)
    win_const_mgr.add_const('POLICY_ERRV_GLOBAL_UNAUTH_USER_FLOW_COUNT',0x00000004)
    win_const_mgr.add_const('IMAGE_REL_SH3_DIRECT32_NB',0x00000010)
    win_const_mgr.add_const('MCI_DGV_SETVIDEO_ITEM',0x00100000)
    win_const_mgr.add_const('SECURITY_LOCAL_RID',0x00000000)
    win_const_mgr.add_const('VM_NORMAL',0x00000004)
    win_const_mgr.add_const('DBPROPVAL_TS_CARDINALITY',0x00000001)
    win_const_mgr.add_const('CBEMAXSTRLEN',0x00000104)
    win_const_mgr.add_const('FACILITY_WINCODEC_ERR',0x00000898)
    win_const_mgr.add_const('MDMEASURE_AGGR_AVG',0x00000005)
    win_const_mgr.add_const('PSIDENT_GDICENTRIC',0x00000000)
    win_const_mgr.add_const('KSMETHOD_TYPE_TOPOLOGY',0x10000000)
    win_const_mgr.add_const('XEPR_V2TEMPLATEOID',0x00000010)
    win_const_mgr.add_const('DDENUM_DETACHEDSECONDARYDEVICES',0x00000002)
    win_const_mgr.add_const('WSAEACCES',0x0000271D)
    win_const_mgr.add_const('STAT_CONTENT_QUERY_INCOMPLETE',0x00000080)
    win_const_mgr.add_const('CDO_E_BAD_DATA',0x80040229)
    win_const_mgr.add_const('PFD_GENERIC_ACCELERATED',0x00001000)
    win_const_mgr.add_const('SM_CXHSCROLL',0x00000015)
    win_const_mgr.add_const('DRIVERVERSION',0x00000000)
    win_const_mgr.add_const('TBS_COMMAND_PRIORITY_NORMAL',0x000000C8)
    win_const_mgr.add_const('SI_AUDITS_ELEVATION_REQUIRED',0x02000000)
    win_const_mgr.add_const('CRYPT_IMPL_UNKNOWN',0x00000004)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_RSS_PARAMETERS',0x00000089)
    win_const_mgr.add_const('FWP_OPTION_VALUE_ENABLE_LOOSE_SOURCE',0x00000001)
    win_const_mgr.add_const('ACTIVATION_CONTEXT_BASIC_INFORMATION_DEFINED',0x00000001)
    win_const_mgr.add_const('OID_GEN_MAXIMUM_SEND_PACKETS',0x00010115)
    win_const_mgr.add_const('ERROR_SXS_XML_E_BADPEREFINSUBSET',0x000036EB)
    win_const_mgr.add_const('LCPRI_POWEROFF',0x0000A000)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_INDOUBT',0x00004000)
    win_const_mgr.add_const('PORT_EMFISCNTL',0x0000008D)
    win_const_mgr.add_const('ACM_FORMATENUMF_HARDWARE',0x00400000)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_USERS',0x80000001)
    win_const_mgr.add_const('DISPID_PRINT',0x0000001C)
    win_const_mgr.add_const('ACCESS_MIN_MS_OBJECT_ACE_TYPE',0x00000005)
    win_const_mgr.add_const('PORT_ECHO',0x00000007)
    win_const_mgr.add_const('CRYPTUI_WIZ_DIGITAL_SIGN_ADD_CHAIN',0x00000001)
    win_const_mgr.add_const('REG_MULTI_SZ',0x00000007)
    win_const_mgr.add_const('UF_TRUSTED_FOR_DELEGATION',0x00080000)
    win_const_mgr.add_const('RTCEF_BUDDY2',0x00040000)
    win_const_mgr.add_const('ERROR_AMBIGUOUS_SYSTEM_DEVICE',0x00003B92)
    win_const_mgr.add_const('VK_VOLUME_MUTE',0x000000AD)
    win_const_mgr.add_const('TRACK_ONLINE_CACHE_ENTRY',0x00000020)
    win_const_mgr.add_const('DBPROPVAL_GB_EQUALS_SELECT',0x00000002)
    win_const_mgr.add_const('IPSEC_CIPHER_CONFIG_CBC_3DES',0x00000002)
    win_const_mgr.add_const('PRJOB_DESTNOPAPER',0x00000100)
    win_const_mgr.add_const('PMSF_MULTIPLE',0x00000001)
    win_const_mgr.add_const('CERT_SYSTEM_STORE_MASK',0xFFFF0000)
    win_const_mgr.add_const('SKF_RWINLOCKED',0x00800000)
    win_const_mgr.add_const('NRC_BUFLEN',0x00000001)
    win_const_mgr.add_const('IDM_TRIED_DELETEROWS',0x00000010)
    win_const_mgr.add_const('DIRID_WINDOWS',0x0000000A)
    win_const_mgr.add_const('STATE_SYSTEM_ALERT_HIGH',0x10000000)
    win_const_mgr.add_const('LCRED_STATUS_UNKNOWN_ISSUER',0x00000002)
    win_const_mgr.add_const('AVI_INDEX_OF_SUB_2FIELD',0x00000003)
    win_const_mgr.add_const('DPNHCAPSFLAG_LOCALFIREWALLPRESENT',0x00000001)
    win_const_mgr.add_const('ENUM_S_LAST',0x000401BF)
    win_const_mgr.add_const('ERROR_NO_PDB_POINTER',0x00008802)
    win_const_mgr.add_const('DISPID_PICT_HPAL',0x00000002)
    win_const_mgr.add_const('IF_TYPE_FRAMERELAY_INTERCONNECT',0x0000003A)
    win_const_mgr.add_const('SQL_QUERY_TIMEOUT',0x00000000)
    win_const_mgr.add_const('VK_DBE_CODEINPUT',0x00000000)
    win_const_mgr.add_const('FACILITY_WINDOWS_CE',0x00000018)
    win_const_mgr.add_const('ERROR_ALREADY_ASSIGNED',0x00000055)
    win_const_mgr.add_const('CLONE_FLAG_NO_PRECONDITION',0x00000008)
    win_const_mgr.add_const('FWP_FILTER_ENUM_FLAG_BEST_TERMINATING_MATCH',0x00000001)
    win_const_mgr.add_const('PAN_SERIF_SQUARE',0x00000006)
    win_const_mgr.add_const('CRYPT_DELETE_DEFAULT',0x00000004)
    win_const_mgr.add_const('SCARD_W_CACHE_ITEM_NOT_FOUND',0x80100070)
    win_const_mgr.add_const('PORT_XDMCP',0x000000B1)
    win_const_mgr.add_const('AF_VOICEVIEW',0x00000012)
    win_const_mgr.add_const('ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG',0x00002185)
    win_const_mgr.add_const('LOCALE_SMONTHOUSANDSEP',0x00000017)
    win_const_mgr.add_const('SQL_API_SQLNATIVESQL',0x0000003E)
    win_const_mgr.add_const('HCF_LOGONDESKTOP',0x00000100)
    win_const_mgr.add_const('WVR_VALIDRECTS',0x00000400)
    win_const_mgr.add_const('DEX_IDS_BAD_MEDIATYPE',0x0000057E)
    win_const_mgr.add_const('TVIS_DROPHILITED',0x00000008)
    win_const_mgr.add_const('KSNODEPIN_SUM_MUX_IN',0x00000001)
    win_const_mgr.add_const('TO_ADVANCEDLAYOUT',0x00000008)
    win_const_mgr.add_const('MDLEVEL_TYPE_ALL',0x00000001)
    win_const_mgr.add_const('SGCM_RTL',0x00000001)
    win_const_mgr.add_const('IMAGE_SYM_CLASS_ARGUMENT',0x00000009)
    win_const_mgr.add_const('DEBUG_OUTPUT_EXTENSION_WARNING',0x00000040)
    win_const_mgr.add_const('STDPROP_KEY',0x00000004)
    win_const_mgr.add_const('DBG_BREAK',0x00000006)
    win_const_mgr.add_const('MEM_RESET',0x00080000)
    win_const_mgr.add_const('MD_CPU_ENABLE_EVENT',0x00000001)
    win_const_mgr.add_const('CRYPT_VERIFY_CERT_SIGN_ISSUER_CERT',0x00000002)
    win_const_mgr.add_const('SPI_SETMOUSEHOVERWIDTH',0x00000063)
    win_const_mgr.add_const('RTM_MATCH_PREF',0x00000004)
    win_const_mgr.add_const('FILE_ATTRIBUTE_ENCRYPTED',0x00004000)
    win_const_mgr.add_const('PORT_MDBSDAEMON',0x00000320)
    win_const_mgr.add_const('COLOR_WINDOW',0x00000005)
    win_const_mgr.add_const('WIA_DPS_VERTICAL_SHEET_FEED_SIZE',0x00000C05)
    win_const_mgr.add_const('IP_UNBLOCK_SOURCE',0x00000012)
    win_const_mgr.add_const('SBSP_TRUSTEDFORACTIVEX',0x10000000)
    win_const_mgr.add_const('CMC_OTHER_INFO_FAIL_CHOICE',0x00000001)
    win_const_mgr.add_const('FWPM_NET_EVENT_FLAG_LOCAL_ADDR_SET',0x00000002)
    win_const_mgr.add_const('EMR_MASKBLT',0x0000004E)
    win_const_mgr.add_const('CMSG_HASH_ALGORITHM_PARAM',0x00000014)
    win_const_mgr.add_const('SCOPE_TYPE_MASK',0x00000000)
    win_const_mgr.add_const('D3DPS20CAPS_NOTEXINSTRUCTIONLIMIT',0x00000001)
    win_const_mgr.add_const('OBJ_DC',0x00000003)
    win_const_mgr.add_const('DDSCAPS2_VOLUME',0x00200000)
    win_const_mgr.add_const('MCI_VD_SEEK_REVERSE',0x00010000)
    win_const_mgr.add_const('CBA_SET_OPTIONS',0x00000008)
    win_const_mgr.add_const('CSIDL_SENDTO',0x00000009)
    win_const_mgr.add_const('ERROR_INVALID_FORM_SIZE',0x0000076F)
    win_const_mgr.add_const('IDM_SETDIRTY',0x00000926)
    win_const_mgr.add_const('SCRIPTPROP_DELAYEDEVENTSINKING',0x00001000)
    win_const_mgr.add_const('MD_LFHINT_NTA',0x00000003)
    win_const_mgr.add_const('SYSFXUI_DONOTSHOW_BASSMANAGEMENT',0x00000004)
    win_const_mgr.add_const('WINEVENT_KEYWORD_AUDIT_SUCCESS',0x20000000000000)
    win_const_mgr.add_const('ERROR_UNRECOGNIZED_MEDIA',0x000006F9)
    win_const_mgr.add_const('OCR_WAIT',0x00007F02)
    win_const_mgr.add_const('MPEGLAYER3_FLAG_PADDING_OFF',0x00000002)
    win_const_mgr.add_const('BTH_MAX_SERVICE_NAME_SIZE',0x00000100)
    win_const_mgr.add_const('INTERNET_FLAG_IDN_DIRECT',0x00000001)
    win_const_mgr.add_const('ERROR_PAGEFILE_QUOTA',0x000005AE)
    win_const_mgr.add_const('SFC_DISABLE_NORMAL',0x00000000)
    win_const_mgr.add_const('SCTE_EAS_IB_PID',0x00001FFB)
    win_const_mgr.add_const('DRM_AL_NOPERSIST',0x00000002)
    win_const_mgr.add_const('DDE_FRELEASE',0x00002000)
    win_const_mgr.add_const('MP_MSGCLASS_NONDELIVERY_REPORT',0x00000004)
    win_const_mgr.add_const('ERROR_LOG_SECTOR_PARITY_INVALID',0x000019C9)
    win_const_mgr.add_const('ACCESS_ALLOWED_OBJECT_ACE_TYPE',0x00000005)
    win_const_mgr.add_const('SPI_GETHIGHCONTRAST',0x00000042)
    win_const_mgr.add_const('PP_KEYSPEC',0x00000027)
    win_const_mgr.add_const('ERROR_INSTALL_SERVICE_SAFEBOOT',0x00000674)
    win_const_mgr.add_const('DRM_ACTIVATE_CANCEL',0x00000008)
    win_const_mgr.add_const('BCRYPT_ALG_HANDLE_HMAC_FLAG',0x00000008)
    win_const_mgr.add_const('SV_ERRORALERT_PARMNUM',0x00000026)
    win_const_mgr.add_const('GUARANTEED_SERV',0x00000002)
    win_const_mgr.add_const('XP1_PARTIAL_MESSAGE',0x00040000)
    win_const_mgr.add_const('NON_VALIDATED_LOGON',0x00000003)
    win_const_mgr.add_const('PAN_LETT_OBLIQUE_ROUNDED',0x0000000D)
    win_const_mgr.add_const('IMAGE_SYM_CLASS_UNDEFINED_STATIC',0x0000000E)
    win_const_mgr.add_const('TPR_MIC_LEN',0x00000004)
    win_const_mgr.add_const('SERVICE_CONTROL_STOP',0x00000001)
    win_const_mgr.add_const('WM_CTLCOLORMSGBOX',0x00000132)
    win_const_mgr.add_const('EN_SAVECLIPBOARD',0x00000708)
    win_const_mgr.add_const('DB_DISP_LOG_MIN',0x00000014)
    win_const_mgr.add_const('SQLDATETIM4',0x00000003)
    win_const_mgr.add_const('WTNCA_NODRAWCAPTION',0x00000001)
    win_const_mgr.add_const('POLICY_ERRV_SUBNET_DEF_PEAK_RATE',0x0000001D)
    win_const_mgr.add_const('NI_NAMEREQD',0x00000004)
    win_const_mgr.add_const('CDO_E_RECIPIENTS_REJECTED',0x8004020F)
    win_const_mgr.add_const('CRYPT_LDAP_SCOPE_BASE_ONLY_RETRIEVAL',0x00002000)
    win_const_mgr.add_const('DEBUG_CES_TEXT_REPLACEMENTS',0x00004000)
    win_const_mgr.add_const('KSALLOCATOR_FLAG_PARTIAL_READ_SUPPORT',0x00000010)
    win_const_mgr.add_const('CPLPAGE_MOUSE_PTRMOTION',0x00000002)
    win_const_mgr.add_const('NDIS_STATISTICS_FLAGS_VALID_DIRECTED_BYTES_RCV',0x00010000)
    win_const_mgr.add_const('MCI_MCIAVI_PLAY_WINDOW',0x01000000)
    win_const_mgr.add_const('DISPLAY_DEVICE_VGA_COMPATIBLE',0x00000010)
    win_const_mgr.add_const('SV_MAXLINKDELAY_PARMNUM',0x00000228)
    win_const_mgr.add_const('OID_GEN_MAXIMUM_LOOKAHEAD',0x00010105)
    win_const_mgr.add_const('ACTRL_READ_CONTROL',0x10000000)
    win_const_mgr.add_const('MF_COMPONENT_REVOKED',0x00002000)
    win_const_mgr.add_const('CB_GETDROPPEDSTATE',0x00000157)
    win_const_mgr.add_const('ERROR_IRQ_BUSY',0x0000045F)
    win_const_mgr.add_const('TMT_LASTUPDATED',0x0000057B)
    win_const_mgr.add_const('SECURITY_PACKAGE_SCHANNEL_RID',0x0000000E)
    win_const_mgr.add_const('OID_GEN_TIMEOUT_DPC_REQUEST_CAPABILITIES',0x00010210)
    win_const_mgr.add_const('FPSR_DD',0x00000001)
    win_const_mgr.add_const('IMAGE_FILE_UP_SYSTEM_ONLY',0x00004000)
    win_const_mgr.add_const('SQL_CDO_DEFAULT',0x00000002)
    win_const_mgr.add_const('BTH_ADDR_STRING_SIZE',0x0000000C)
    win_const_mgr.add_const('PID_CODEPAGE',0x00000001)
    win_const_mgr.add_const('FACILITY_TRANSACTION',0x00000019)
    win_const_mgr.add_const('JOB_NOTIFY_FIELD_PRINT_PROCESSOR',0x00000006)
    win_const_mgr.add_const('UF_LOCKOUT',0x00000010)
    win_const_mgr.add_const('MB_SETFOREGROUND',0x00010000)
    win_const_mgr.add_const('MD_LFHINT_NT1',0x00000001)
    win_const_mgr.add_const('DNS_TYPE_GID',0x00000066)
    win_const_mgr.add_const('IIS_MD_ID_BEGIN_RESERVED',0x00000001)
    win_const_mgr.add_const('HH_DISPLAY_TOC',0x00000001)
    win_const_mgr.add_const('SFVM_WINDOWCREATED',0x0000000F)
    win_const_mgr.add_const('MMC_VER',0x00000200)
    win_const_mgr.add_const('ERROR_I24_GEN_FAILURE',0x0000000C)
    win_const_mgr.add_const('WSA_FLAG_MULTIPOINT_D_ROOT',0x00000008)
    win_const_mgr.add_const('CRYPT_VERIFY_DATA_HASH',0x00000040)
    win_const_mgr.add_const('CR_FLG_CAXCHGCERT',0x00000008)
    win_const_mgr.add_const('SORT_DEFAULT',0x00000000)
    win_const_mgr.add_const('PID_INTSITE_VISITCOUNT',0x00000006)
    win_const_mgr.add_const('FACILITY_WPC',0x00000999)
    win_const_mgr.add_const('CRYPTUI_CERT_MGR_SINGLE_TAB_FLAG',0x00008000)
    win_const_mgr.add_const('MCI_AVI_SETVIDEO_PALETTE_HALFTONE',0x0000FFFF)
    win_const_mgr.add_const('WMS_CONTAINER_LIVE',0x00000008)
    win_const_mgr.add_const('IME_PROP_CANDLIST_START_FROM_1',0x00040000)
    win_const_mgr.add_const('CSURL_ADDTOCERTCDP',0x00000002)
    win_const_mgr.add_const('PF_COMPARE_EXCHANGE128',0x0000000E)
    win_const_mgr.add_const('FPSR_D3',0x00000035)
    win_const_mgr.add_const('FPSR_D2',0x00000028)
    win_const_mgr.add_const('FPSR_D1',0x0000001B)
    win_const_mgr.add_const('FPSR_D0',0x0000000E)
    win_const_mgr.add_const('LV_VIEW_LIST',0x00000003)
    win_const_mgr.add_const('PIFSHPROGSIZE',0x00000040)
    win_const_mgr.add_const('IDCANCEL',0x00000002)
    win_const_mgr.add_const('SQL_OJ_NOT_ORDERED',0x00000010)
    win_const_mgr.add_const('SERVER_ACCESS_ADMINISTER',0x00000001)
    win_const_mgr.add_const('GW_HWNDPREV',0x00000003)
    win_const_mgr.add_const('ALG_SID_SEAL',0x00000002)
    win_const_mgr.add_const('DATE_RTLREADING',0x00000020)
    win_const_mgr.add_const('OBM_UPARROW',0x00007FF1)
    win_const_mgr.add_const('KSPRIORITY_LOW',0x00000001)
    win_const_mgr.add_const('HDF_BITMAP_ON_RIGHT',0x00001000)
    win_const_mgr.add_const('FPS_INITIALIZING',0x20008000)
    win_const_mgr.add_const('PERF_COLLECT_END',0x00000006)
    win_const_mgr.add_const('ERRCLASS_NOTFND',0x00000008)
    win_const_mgr.add_const('MCI_DGV_FILE_MODE_LOADING_S',0x00008005)
    win_const_mgr.add_const('WM_UNINITMENUPOPUP',0x00000125)
    win_const_mgr.add_const('AEC_STATUS_FD_CURRENTLY_CONVERGED',0x00000008)
    win_const_mgr.add_const('LVBKIF_SOURCE_URL',0x00000002)
    win_const_mgr.add_const('SQLDATETIME',0x00000003)
    win_const_mgr.add_const('D3DSP_TEXTURETYPE_MASK',0x78000000)
    win_const_mgr.add_const('OID_FDDI_PORT_PMD_CLASS',0x03030265)
    win_const_mgr.add_const('COOKIE_LEASHED_CACHE_ENTRY',0x00002000)
    win_const_mgr.add_const('PCS_TRUNCATED',0x00000004)
    win_const_mgr.add_const('SQL_SFKD_NO_ACTION',0x00000002)
    win_const_mgr.add_const('SPEAKER_SIDE_RIGHT',0x00000400)
    win_const_mgr.add_const('SQLDATETIMN',0x00000006)
    win_const_mgr.add_const('APPCOMMAND_CLOSE',0x0000001F)
    win_const_mgr.add_const('CC_PIE',0x00000002)
    win_const_mgr.add_const('ERROR_DUP_FCB',0x00000051)
    win_const_mgr.add_const('DSF_DV_DEVICES',0x00000040)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_ACKPART',0x00000015)
    win_const_mgr.add_const('WMDRM_ACQUIRE_LICENSE_SILENT',0x00000001)
    win_const_mgr.add_const('WIA_IPA_CHANNELS_PER_PIXEL',0x0000100D)
    win_const_mgr.add_const('PHOTOACQ_DELETE_AFTER_ACQUIRE',0x00000020)
    win_const_mgr.add_const('SM_CYSMSIZE',0x00000035)
    win_const_mgr.add_const('DEBUG_SYMTYPE_EXPORT',0x00000004)
    win_const_mgr.add_const('DDFLIP_DONOTWAIT',0x00000020)
    win_const_mgr.add_const('CTRY_SLOVAK',0x000001A5)
    win_const_mgr.add_const('SI_RESET_DACL_TREE',0x00004000)
    win_const_mgr.add_const('ILC_COLOR24',0x00000018)
    win_const_mgr.add_const('JL_RECEIVER_ONLY',0x00000002)
    win_const_mgr.add_const('ERROR_NO_MORE_INFO',0x00000001)
    win_const_mgr.add_const('LINECALLCOMPLCOND_BUSY',0x00000001)
    win_const_mgr.add_const('DPNH_MAX_SIMULTANEOUS_PORTS',0x00000010)
    win_const_mgr.add_const('ERROR_KEY_HAS_CHILDREN',0x000003FC)
    win_const_mgr.add_const('DIF_ENABLECLASS',0x00000013)
    win_const_mgr.add_const('VCAPS_DST_CAN_CLIP',0x00000004)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_MINIPORT_ADAPTER_REGISTRATION_ATTRIBUTES',0x0000009E)
    win_const_mgr.add_const('SC_DLG_MINIMAL_UI',0x00000001)
    win_const_mgr.add_const('GCP_NEUTRALOVERRIDE',0x02000000)
    win_const_mgr.add_const('WMPCOREEVENT_CDROM_BASE',0x00001644)
    win_const_mgr.add_const('WMDRM_DEVICE_NEEDCLOCK',0x00000002)
    win_const_mgr.add_const('D3DFVFCAPS_TEXCOORDCOUNTMASK',0x00000000)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_STATISTICS',0x00000003)
    win_const_mgr.add_const('COPYFLG_NOSKIP',0x00000002)
    win_const_mgr.add_const('UM_SELTYPE_REMOTEUSER',0x00000002)
    win_const_mgr.add_const('DBPROPVAL_ASYNCH_POPULATEONDEMAND',0x00000020)
    win_const_mgr.add_const('ISR_IA_VECTOR_LEN',0x00000008)
    win_const_mgr.add_const('ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE',0x0000370C)
    win_const_mgr.add_const('CAP_ATA_ID_CMD',0x00000001)
    win_const_mgr.add_const('LOCALE_ICURRDIGITS',0x00000019)
    win_const_mgr.add_const('RIP_INTERFACE_TABLE',0x00000001)
    win_const_mgr.add_const('WM_BACKUP_OVERWRITE',0x00000001)
    win_const_mgr.add_const('ERROR_UNEXPECTED_MM_EXTEND_ERR',0x0000022E)
    win_const_mgr.add_const('HHWIN_BUTTON_REFRESH',0x00000001)
    win_const_mgr.add_const('SQL_INTERVAL_HOUR',0x00000064)
    win_const_mgr.add_const('LINEADDRCAPFLAGS_PICKUPGROUPID',0x00000002)
    win_const_mgr.add_const('PORT_ATRMTP',0x000000C9)
    win_const_mgr.add_const('RPCFLG_ACCESS_LOCAL',0x00400000)
    win_const_mgr.add_const('ERROR_NOT_TINY_STREAM',0x00000256)
    win_const_mgr.add_const('OID_802_3_RCV_OVERRUN',0x01020203)
    win_const_mgr.add_const('SNMP_AUTHAPI_TRIV_AUTH_FAILED',0x00000020)
    win_const_mgr.add_const('APPCOMMAND_OPEN',0x0000001E)
    win_const_mgr.add_const('OID_FDDI_SMT_STATION_ID',0x03030201)
    win_const_mgr.add_const('VS_VERSION_INFO',0x00000001)
    win_const_mgr.add_const('DB_DISP_DENIED',0x0000001F)
    win_const_mgr.add_const('FACILITY_MF_WIN32',0x00000007)
    win_const_mgr.add_const('AGP_FLAG_NO_SBA_ENABLE',0x00000100)
    win_const_mgr.add_const('ALG_SID_CAST',0x00000006)
    win_const_mgr.add_const('DBPROPVAL_CB_PRESERVE',0x00000002)
    win_const_mgr.add_const('LINEPROXYSTATUS_OPEN',0x00000001)
    win_const_mgr.add_const('SMC_GETAUTOEXPANDSTATE',0x00000041)
    win_const_mgr.add_const('SPIF_SENDWININICHANGE',0x00000002)
    win_const_mgr.add_const('CRYPTUI_WARN_UNTRUSTED_ROOT',0x00000400)
    win_const_mgr.add_const('CRYPT_LOCALIZED_NAME_ENCODING_TYPE',0x00000000)
    win_const_mgr.add_const('LSP_SYSTEM',0x80000000)
    win_const_mgr.add_const('IF_TYPE_MPLS_TUNNEL',0x00000096)
    win_const_mgr.add_const('ERROR_CURRENT_DOMAIN_NOT_ALLOWED',0x00000577)
    win_const_mgr.add_const('ERR_DISK_CREATE_ERROR',0xE0000002)
    win_const_mgr.add_const('TMT_BTNFACE',0x00000650)
    win_const_mgr.add_const('DEBUG_IOUTPUT_KD_PROTOCOL',0x80000000)
    win_const_mgr.add_const('TAPE_RETURN_STATISTICS',0x00000000)
    win_const_mgr.add_const('WMDM_STORAGE_ATTR_FOLDERS',0x00000100)
    win_const_mgr.add_const('IDM_SHOWSTYLETAGS',0x00000913)
    win_const_mgr.add_const('IMAGE_REL_MIPS_ABSOLUTE',0x00000000)
    win_const_mgr.add_const('MCI_SAVE_FILE',0x00000100)
    win_const_mgr.add_const('IDM_GOTO',0x000008BF)
    win_const_mgr.add_const('DS_REPADD_NEVER_NOTIFY',0x00000200)
    win_const_mgr.add_const('GESTURE_DOWN_RIGHT',0x00000000)
    win_const_mgr.add_const('DDCREATE_EMULATIONONLY',0x00000002)
    win_const_mgr.add_const('IMAGE_DEBUG_TYPE_FPO',0x00000003)
    win_const_mgr.add_const('D3DUSAGE_QUERY_SRGBWRITE',0x00040000)
    win_const_mgr.add_const('PERF_COUNTER_VALUE',0x00000000)
    win_const_mgr.add_const('USN_REASON_ENCRYPTION_CHANGE',0x00040000)
    win_const_mgr.add_const('SQL_CV_CREATE_VIEW',0x00000001)
    win_const_mgr.add_const('MDAXIS_SECTIONS',0x00000003)
    win_const_mgr.add_const('IP_FLAG_DF',0x00000002)
    win_const_mgr.add_const('TTFCFP_STD_MAC_CHAR_SET',0x00000000)
    win_const_mgr.add_const('PAN_SERIF_COVE',0x00000002)
    win_const_mgr.add_const('ISR_IR',0x00000026)
    win_const_mgr.add_const('CI_STATE_CONTENT_SCAN_REQUIRED',0x00000004)
    win_const_mgr.add_const('LINEPROXYREQUEST_GETAGENTACTIVITYLIST',0x00000007)
    win_const_mgr.add_const('GOPHER_TYPE_HTML',0x00020000)
    win_const_mgr.add_const('OID_TAPI_DROP',0x07030109)
    win_const_mgr.add_const('MD_CHANGE_TYPE_SET_DATA',0x00000004)
    win_const_mgr.add_const('NETE_NOT_CONNECTED',0x000000E9)
    win_const_mgr.add_const('ALLOWED_FAIL',0x00000001)
    win_const_mgr.add_const('ADS_PRINTER_MANUAL_FEED',0x00000006)
    win_const_mgr.add_const('MAX_INTERPRETER_PARAM_OUT_SIZE',0x00000007)
    win_const_mgr.add_const('SCSI_IOCTL_DATA_OUT',0x00000000)
    win_const_mgr.add_const('BL_20M',0x01400000)
    win_const_mgr.add_const('EPR_0',0x00000000)
    win_const_mgr.add_const('AF_APPLETALK',0x00000010)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_INVALID_HEADER',0x00003600)
    win_const_mgr.add_const('FR_PROP_ENCRYPTEDKEYHASH',0x0000000E)
    win_const_mgr.add_const('SERVICE_SINGLE_COPY',0x00000002)
    win_const_mgr.add_const('DXGI_MAX_SWAP_CHAIN_BUFFERS',0x00000010)
    win_const_mgr.add_const('IKEEXT_CERT_AUTH_DISABLE_SSL_CERT_VALIDATION',0x00000008)
    win_const_mgr.add_const('DISPID_HISTORY',0x00000001)
    win_const_mgr.add_const('IMPORTANCE_HIGH_MAX',0x00000005)
    win_const_mgr.add_const('HTTP_QUERY_CONTENT_BASE',0x00000032)
    win_const_mgr.add_const('D3DPS20_MIN_NUMINSTRUCTIONSLOTS',0x00000060)
    win_const_mgr.add_const('ERROR_DS_COULDNT_CONTACT_FSMO',0x000020AF)
    win_const_mgr.add_const('PIR_STATUS_TABLE_MSSPEC',0x00000001)
    win_const_mgr.add_const('LDAP_OPT_TIMELIMIT',0x00000004)
    win_const_mgr.add_const('VIEW_PARENTFOLDER',0x00000008)
    win_const_mgr.add_const('MM_DRVM_OPEN',0x000003D0)
    win_const_mgr.add_const('CSS_SHOW_HELP',0x00000010)
    win_const_mgr.add_const('ECO_SELECTIONBAR',0x01000000)
    win_const_mgr.add_const('ERROR_GRACEFUL_DISCONNECT',0x000004CA)
    win_const_mgr.add_const('HDI_LPARAM',0x00000008)
    win_const_mgr.add_const('CT_CTYPE1',0x00000001)
    win_const_mgr.add_const('FPSR_WRE1',0x00000014)
    win_const_mgr.add_const('SIGNERSCORE_AUTHENTICODE',0x0F000000)
    win_const_mgr.add_const('VARIABLE_DIM',0x00000001)
    win_const_mgr.add_const('LOCALE_NOUSEROVERRIDE',0x80000000)
    win_const_mgr.add_const('IDB_HIST_DISABLED',0x0000000E)
    win_const_mgr.add_const('AEC_STATUS_FD_HISTORY_UNINITIALIZED',0x00000000)
    win_const_mgr.add_const('META_POLYLINE',0x00000325)
    win_const_mgr.add_const('INV_LPM_HANDLE',0x00000001)
    win_const_mgr.add_const('TASK_JULY',0x00000040)
    win_const_mgr.add_const('HLNF_EXTERNALNAVIGATE',0x10000000)
    win_const_mgr.add_const('MSIM_DISPID_ONLISTREMOVERESULT',0x00000E03)
    win_const_mgr.add_const('SDP_DEFAULT_INQUIRY_SECONDS',0x00000006)
    win_const_mgr.add_const('DNS_ERROR_RECORD_FORMAT',0x000025E6)
    win_const_mgr.add_const('MEDIASINK_CAN_PREROLL',0x00000010)
    win_const_mgr.add_const('IDC_EL_CHANGESOURCE',0x000000C9)
    win_const_mgr.add_const('ERROR_SHARED_POLICY',0x0000201A)
    win_const_mgr.add_const('SUBLANG_ENGLISH_EIRE',0x00000006)
    win_const_mgr.add_const('WAVECAPS_VOLUME',0x00000004)
    win_const_mgr.add_const('MCI_DGV_GETDEVCAPS_CAN_FREEZE',0x00004002)
    win_const_mgr.add_const('IDM_ABSOLUTE_POSITION',0x0000095D)
    win_const_mgr.add_const('ERROR_INSTALL_TRANSFORM_REJECTED',0x0000066C)
    win_const_mgr.add_const('EIMES_GETCOMPSTRATONCE',0x00000001)
    win_const_mgr.add_const('TR_NOIND',0x00000000)
    win_const_mgr.add_const('SHARE_SERVER_PARMNUM',0x000001F7)
    win_const_mgr.add_const('IPSEC_SA_BUNDLE_FLAG_CLEAR_DF_ON_TUNNEL',0x00000400)
    win_const_mgr.add_const('TMT_LOCALIZEDMIRRORIMAGE',0x000008AC)
    win_const_mgr.add_const('QUERY_ACTCTX_FLAG_ACTCTX_IS_HMODULE',0x00000008)
    win_const_mgr.add_const('ADS_PRINTER_PAUSED',0x00000001)
    win_const_mgr.add_const('WINEVENT_OPCODE_REPLY',0x00000006)
    win_const_mgr.add_const('GCP_DISPLAYZWG',0x00400000)
    win_const_mgr.add_const('DAOROWFETCH_BINDABSOLUTE',0x00000008)
    win_const_mgr.add_const('CERT_CHAIN_POLICY_IGNORE_PEER_TRUST_FLAG',0x00001000)
    win_const_mgr.add_const('CSURL_SERVERPUBLISHDELTA',0x00000040)
    win_const_mgr.add_const('ERROR_SPL_NO_ADDJOB',0x00000BBC)
    win_const_mgr.add_const('NDIS_RING_SIGNAL_LOSS',0x00008000)
    win_const_mgr.add_const('DNS_PORT_NET_ORDER',0x00003500)
    win_const_mgr.add_const('WNPERM_DLG_OWNER',0x00000002)
    win_const_mgr.add_const('ISCSI_LOGIN_FLAG_ALLOW_PORTAL_HOPPING',0x00000008)
    win_const_mgr.add_const('MM_WIM_OPEN',0x000003BE)
    win_const_mgr.add_const('UD_MAXVAL',0x00000007)
    win_const_mgr.add_const('MCI_VCR_SETAUDIO_RECORD',0x00010000)
    win_const_mgr.add_const('EXITPUB_ACTIVEDIRECTORY',0x00000002)
    win_const_mgr.add_const('SHARE_FILE_SD_PARMNUM',0x000001F5)
    win_const_mgr.add_const('WIA_INCOMPAT_XP',0x00000001)
    win_const_mgr.add_const('GMMP_USE_DISPLAY_POINTS',0x00000001)
    win_const_mgr.add_const('PIR_STATUS_MINIPORT_MAX',0x00000008)
    win_const_mgr.add_const('SEC_WRITECOMBINE',0x40000000)
    win_const_mgr.add_const('NMPWAIT_USE_DEFAULT_WAIT',0x00000000)
    win_const_mgr.add_const('VCSTATUS_NEXT',0x00000001)
    win_const_mgr.add_const('MIB_IPADDR_DELETED',0x00000040)
    win_const_mgr.add_const('MUI_FULL_LANGUAGE',0x00000001)
    win_const_mgr.add_const('BCRYPT_NO_KEY_VALIDATION',0x00000008)
    win_const_mgr.add_const('MDM_X75_DATA_T_70',0x00000003)
    win_const_mgr.add_const('CDERR_GENERALCODES',0x00000000)
    win_const_mgr.add_const('IMAGE_SUBSYSTEM_NATIVE_WINDOWS',0x00000008)
    win_const_mgr.add_const('OID_GEN_MULTICAST_BYTES_XMIT',0x00020203)
    win_const_mgr.add_const('COLOR_APPWORKSPACE',0x0000000C)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_PROTOCOL_DRIVER_CHARACTERISTICS',0x00000095)
    win_const_mgr.add_const('XINPUT_GAMEPAD_DPAD_UP',0x00000001)
    win_const_mgr.add_const('LB_SETCOUNT',0x000001A7)
    win_const_mgr.add_const('SAFER_POLICY_SANDBOX_INERT',0x00020000)
    win_const_mgr.add_const('POLICY_KERBEROS_VALIDATE_CLIENT',0x00000080)
    win_const_mgr.add_const('MCI_DGV_LIST_AUDIO_QUALITY',0x00004001)
    win_const_mgr.add_const('IF_TYPE_IP',0x0000007E)
    win_const_mgr.add_const('TBSTYLE_TOOLTIPS',0x00000100)
    win_const_mgr.add_const('CLIPBRD_E_LAST',0x800401DF)
    win_const_mgr.add_const('IDM_2D_POSITION',0x0000095A)
    win_const_mgr.add_const('HTTP_LOG_FIELD_BYTES_SENT',0x00001000)
    win_const_mgr.add_const('SQL_SR_UPDATE_COLUMN',0x00004000)
    win_const_mgr.add_const('LVS_EX_JUSTIFYCOLUMNS',0x00200000)
    win_const_mgr.add_const('VP_TV_STANDARD_PAL_B',0x00000004)
    win_const_mgr.add_const('GET_FEATURE_FROM_THREAD_TRUSTED',0x00000020)
    win_const_mgr.add_const('VP_TV_STANDARD_PAL_N',0x00000080)
    win_const_mgr.add_const('ERROR_NO_SUCH_LOGON_SESSION',0x00000520)
    win_const_mgr.add_const('IDTB_CUSTOMIZE',0x000000DD)
    win_const_mgr.add_const('SPFILELOG_FORCENEW',0x00000002)
    win_const_mgr.add_const('VP_TV_STANDARD_PAL_H',0x00000010)
    win_const_mgr.add_const('VP_TV_STANDARD_PAL_I',0x00000020)
    win_const_mgr.add_const('MF_SYSMENU',0x00002000)
    win_const_mgr.add_const('ERROR_DS_SEC_DESC_INVALID',0x000020A2)
    win_const_mgr.add_const('ERROR_DS_NO_MORE_RIDS',0x00002011)
    win_const_mgr.add_const('AF_CHAOS',0x00000005)
    win_const_mgr.add_const('SW_SHOWNOACTIVATE',0x00000004)
    win_const_mgr.add_const('AMDDS_DCIPS',0x00000001)
    win_const_mgr.add_const('PFD_SUPPORT_COMPOSITION',0x00008000)
    win_const_mgr.add_const('NCRYPT_UNREGISTER_NOTIFY_FLAG',0x00000002)
    win_const_mgr.add_const('SV_TYPE_TIME_SOURCE',0x00000020)
    win_const_mgr.add_const('IP_BLOCK_SOURCE',0x00000011)
    win_const_mgr.add_const('TMT_MENUHILIGHT',0x0000065E)
    win_const_mgr.add_const('CAUSE_QOS_UNAVAILABLE',0x00000031)
    win_const_mgr.add_const('CTRY_IRAN',0x000003D5)
    win_const_mgr.add_const('CD_LBSELSUB',0x00000001)
    win_const_mgr.add_const('SENSITIVITY_PROP_PRIVATE',0x00000002)
    win_const_mgr.add_const('ERROR_NOT_LOGGED_ON',0x000004DD)
    win_const_mgr.add_const('FILE_FLAG_OVERLAPPED',0x40000000)
    win_const_mgr.add_const('PRINTER_NOTIFY_FIELD_UNTIL_TIME',0x00000011)
    win_const_mgr.add_const('OID_WAN_CO_GET_STATS_INFO',0x04010282)
    win_const_mgr.add_const('HSHELL_WINDOWCREATED',0x00000001)
    win_const_mgr.add_const('ERROR_DS_NCNAME_MISSING_CR_REF',0x000020DC)
    win_const_mgr.add_const('TAPE_DRIVE_LOGICAL_BLK',0x80004000)
    win_const_mgr.add_const('LINECALLFEATURE_MONITORDIGITS',0x00001000)
    win_const_mgr.add_const('VFT2_DRV_INPUTMETHOD',0x0000000B)
    win_const_mgr.add_const('ERROR_LOG_BLOCK_INVALID',0x000019D1)
    win_const_mgr.add_const('DMDISPLAYFLAGS_TEXTMODE',0x00000004)
    win_const_mgr.add_const('LINEERR_NOMULTIPLEINSTANCE',0x80000056)
    win_const_mgr.add_const('MF_SEPARATOR',0x00000800)
    win_const_mgr.add_const('KRB_NT_SRV_INST',0x00000002)
    win_const_mgr.add_const('NLS_VALID_LOCALE_MASK',0x00000000)
    win_const_mgr.add_const('WLX_SAS_TYPE_TIMEOUT',0x00000000)
    win_const_mgr.add_const('IDM_TRIED_BOLD',0x0000001C)
    win_const_mgr.add_const('STI_UNICODE',0x00000001)
    win_const_mgr.add_const('MAX_WST_VBI_LINES_PER_FIELD',0x00000011)
    win_const_mgr.add_const('DEBUG_OUTPUT_SYMBOLS_DEFAULT',0x00000000)
    win_const_mgr.add_const('DEBUG_FILTER_BREAK',0x00000000)
    win_const_mgr.add_const('RPC_C_PARM_MAX_PACKET_LENGTH',0x00000001)
    win_const_mgr.add_const('SPI_SETSCREENREADER',0x00000047)
    win_const_mgr.add_const('NCBDELNAME',0x00000031)
    win_const_mgr.add_const('CRYPT_SORTED_CTL_ENCODE_HASHED_SUBJECT_IDENTIFIER_FLAG',0x00010000)
    win_const_mgr.add_const('MD_EXTLOG_URI_QUERY',0x00000200)
    win_const_mgr.add_const('AA_A_DELETE',0x00004000)
    win_const_mgr.add_const('FOFX_PREFERHARDLINK',0x00020000)
    win_const_mgr.add_const('AI_NUMERICSERV',0x00000008)
    win_const_mgr.add_const('DR_RW',0x0000003E)
    win_const_mgr.add_const('IMAGE_REL_M32R_TOKEN',0x0000000E)
    win_const_mgr.add_const('DISPLAYDIB_BEGIN',0x00008000)
    win_const_mgr.add_const('ERROR_RESOURCE_NOT_ONLINE',0x0000138C)
    win_const_mgr.add_const('DPNHADDRESSTYPE_TCP',0x00000001)
    win_const_mgr.add_const('MD_LOGON_NETWORK_CLEARTEXT',0x00000003)
    win_const_mgr.add_const('DEBUG_STACK_PARAMETERS_NEWLINE',0x00000400)
    win_const_mgr.add_const('SQL_SCOPE_SESSION',0x00000002)
    win_const_mgr.add_const('ERROR_NO_SCROLLBARS',0x000005A7)
    win_const_mgr.add_const('MD_LOCATION',0x00002705)
    win_const_mgr.add_const('MCI_OPEN_TYPE',0x00002000)
    win_const_mgr.add_const('PDH_CALC_NEGATIVE_VALUE',0x800007D8)
    win_const_mgr.add_const('PAN_FAMILY_SCRIPT',0x00000003)
    win_const_mgr.add_const('CRL_REASON_CERTIFICATE_HOLD_FLAG',0x00000002)
    win_const_mgr.add_const('GMEM_FIXED',0x00000000)
    win_const_mgr.add_const('CERT_STORE_PROV_FREE_FIND_CRL_FUNC',0x00000012)
    win_const_mgr.add_const('PORT_ATNBP',0x000000CA)
    win_const_mgr.add_const('TF_MOD_LALT',0x00000040)
    win_const_mgr.add_const('MMIOM_CLOSE',0x00000004)
    win_const_mgr.add_const('SSA_LAYOUTRTL',0x20000000)
    win_const_mgr.add_const('ERROR_TOO_MANY_MODULES',0x000000D6)
    win_const_mgr.add_const('IMAGE_FILE_MACHINE_AM33',0x00000001)
    win_const_mgr.add_const('SV_HIDDEN_PARMNUM',0x00000010)
    win_const_mgr.add_const('IDC_IO_FILE',0x0000083A)
    win_const_mgr.add_const('ERROR_INSTALL_TEMP_UNWRITABLE',0x00000660)
    win_const_mgr.add_const('HHWIN_PROP_MENU',0x00000001)
    win_const_mgr.add_const('WIA_DPV_LAST_PICTURE_TAKEN',0x00000E02)
    win_const_mgr.add_const('EMR_SETSTRETCHBLTMODE',0x00000015)
    win_const_mgr.add_const('COOKIE_STATE_UB',0x00000005)
    win_const_mgr.add_const('WINHTTP_QUERY_CONTENT_TRANSFER_ENCODING',0x00000002)
    win_const_mgr.add_const('TVS_SINGLEEXPAND',0x00000400)
    win_const_mgr.add_const('SCHEDULE_INTERVAL',0x00000000)
    win_const_mgr.add_const('IF_TYPE_NSIP',0x0000001B)
    win_const_mgr.add_const('GCS_HELPTEXTA',0x00000001)
    win_const_mgr.add_const('TF_MOD_ON_KEYUP',0x00000200)
    win_const_mgr.add_const('RTCIF_DISABLE_MEDIA',0x00000001)
    win_const_mgr.add_const('PSWIZBF_ELEVATIONREQUIRED',0x00000001)
    win_const_mgr.add_const('SNMP_MGMTAPI_INVALID_CTL',0x0000002E)
    win_const_mgr.add_const('KLF_SHIFTLOCK',0x00010000)
    win_const_mgr.add_const('ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND',0x000032D1)
    win_const_mgr.add_const('GCS_HELPTEXTW',0x00000005)
    win_const_mgr.add_const('IF_TYPE_PERSONAL_WAN_ROUTER',0x00000006)
    win_const_mgr.add_const('MCI_DGV_FREEZE_OUTSIDE',0x00020000)
    win_const_mgr.add_const('NOPARITY',0x00000000)
    win_const_mgr.add_const('VK_LSHIFT',0x000000A0)
    win_const_mgr.add_const('CM_PROB_DRIVER_FAILED_PRIOR_UNLOAD',0x00000026)
    win_const_mgr.add_const('SAFER_POLICY_JOBID_UNTRUSTED',0x03000000)
    win_const_mgr.add_const('CRYPT_ASYNC_RETRIEVAL',0x00000010)
    win_const_mgr.add_const('ERROR_COMPRESSION_DISABLED',0x00000301)
    win_const_mgr.add_const('COLOR_LUM',0x000002C1)
    win_const_mgr.add_const('DBPROPVAL_PT_GUID_NAME',0x00000001)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_CALLID',0x00000022)
    win_const_mgr.add_const('HTTP_LOG_FIELD_QUEUE_NAME',0x04000000)
    win_const_mgr.add_const('KEY_CREATE_LINK',0x00000020)
    win_const_mgr.add_const('OR_INVALID_OID',0x00000777)
    win_const_mgr.add_const('MINCHAR',0x00000080)
    win_const_mgr.add_const('ERROR_NO_SUCH_MEMBER',0x0000056B)
    win_const_mgr.add_const('RT_MANIFEST',0x00000018)
    win_const_mgr.add_const('RC_FLOODFILL',0x00001000)
    win_const_mgr.add_const('BUTTON_IMAGELIST_ALIGN_BOTTOM',0x00000003)
    win_const_mgr.add_const('TVSIL_STATE',0x00000002)
    win_const_mgr.add_const('D3DSTENCILCAPS_DECRSAT',0x00000010)
    win_const_mgr.add_const('GESTURE_CHEVRON_LEFT',0x00000000)
    win_const_mgr.add_const('RPC_C_RPCHTTP_USE_LOAD_BALANCE',0x00000008)
    win_const_mgr.add_const('MCI_VCR_SET_COUNTER_VALUE',0x02000000)
    win_const_mgr.add_const('HELPINFO_WINDOW',0x00000001)
    win_const_mgr.add_const('EVENT_OBJECT_CREATE',0x00008000)
    win_const_mgr.add_const('LINEFORWARDMODE_UNCONDSPECIFIC',0x00000008)
    win_const_mgr.add_const('TAPE_ABSOLUTE_BLOCK',0x00000001)
    win_const_mgr.add_const('ISC_RET_USED_DCE_STYLE',0x00000200)
    win_const_mgr.add_const('OBM_RESTORED',0x00007FE8)
    win_const_mgr.add_const('VP_MODE_TV_PLAYBACK',0x00000002)
    win_const_mgr.add_const('ROTREGFLAGS_ALLOWANYCLIENT',0x00000001)
    win_const_mgr.add_const('SECTION_MAP_EXECUTE',0x00000008)
    win_const_mgr.add_const('PORT_NIMAIL',0x0000003D)
    win_const_mgr.add_const('ILGOS_FROMSTANDBY',0x00000001)
    win_const_mgr.add_const('WMIREG_FLAG_INSTANCE_BASENAME',0x00000008)
    win_const_mgr.add_const('D3DSP_WRITEMASK_3',0x00080000)
    win_const_mgr.add_const('DNS_ERROR_DATAFILE_BASE',0x000025B2)
    win_const_mgr.add_const('LONGLONG_MAX',0x7FFFFFFFFFFFFFFF)
    win_const_mgr.add_const('VER_ERR_NO_ARG',0xFFFFFFFF)
    win_const_mgr.add_const('ERROR_DS_CHILDREN_EXIST',0x0000208C)
    win_const_mgr.add_const('SFVM_GETNOTIFY',0x00000031)
    win_const_mgr.add_const('DXVA_CHROMA_FORMAT_444',0x00000003)
    win_const_mgr.add_const('MIXER_GETLINECONTROLSF_ONEBYTYPE',0x00000002)
    win_const_mgr.add_const('CDO_E_ROLE_NOMORE_AVAILABLE',0x80040236)
    win_const_mgr.add_const('ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING',0x000036FE)
    win_const_mgr.add_const('ERROR_NOT_SAFE_MODE_DRIVER',0x00000286)
    win_const_mgr.add_const('NCRYPT_ALLOW_ARCHIVING_FLAG',0x00000004)
    win_const_mgr.add_const('IME_ESC_AUTOMATA',0x00001009)
    win_const_mgr.add_const('SQL_API_SQLGETDATA',0x0000002B)
    win_const_mgr.add_const('IMAGE_DIRECTORY_ENTRY_IMPORT',0x00000001)
    win_const_mgr.add_const('SQL_ALTER_TABLE',0x00000056)
    win_const_mgr.add_const('THREAD_PRIORITY_NORMAL',0x00000000)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_RECONNECT',0x00000010)
    win_const_mgr.add_const('NCBDGRECVBC',0x00000023)
    win_const_mgr.add_const('USAGE_MATCH_TYPE_OR',0x00000001)
    win_const_mgr.add_const('MIIM_DATA',0x00000020)
    win_const_mgr.add_const('IDM_HORIZSPACEMAKEEQUAL',0x00000018)
    win_const_mgr.add_const('MD_NETLOGON_WKS_NONE',0x00000000)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_POSTGAPALREADYINIMAGE',0x00000104)
    win_const_mgr.add_const('CM_PROB_TRANSLATION_FAILED',0x00000021)
    win_const_mgr.add_const('WMSZ_LEFT',0x00000001)
    win_const_mgr.add_const('ERROR_DS_SEMANTIC_ATT_TEST',0x000020BF)
    win_const_mgr.add_const('RESOURCEDISPLAYTYPE_GROUP',0x00000005)
    win_const_mgr.add_const('SAM_MINUTES_PER_WEEK',0x0000003C)
    win_const_mgr.add_const('INDEX_INK_ANALYSIS_GUID_MAX',0x00000080)
    win_const_mgr.add_const('LDAP_OPT_PING_LIMIT',0x00000038)
    win_const_mgr.add_const('CM_PROB_PHANTOM',0x0000002D)
    win_const_mgr.add_const('CCHDEVICENAME',0x00000020)
    win_const_mgr.add_const('WMDM_GET_FORMAT_SUPPORT_AUDIO',0x00000001)
    win_const_mgr.add_const('MD_CPU_ENABLE_CGI_LOGGING',0x00000002)
    win_const_mgr.add_const('NDIS_802_11_AUTH_REQUEST_GROUP_ERROR',0x0000000E)
    win_const_mgr.add_const('URLOSTRM_GETNEWESTVERSION',0x00000003)
    win_const_mgr.add_const('SPDRP_UI_NUMBER_DESC_FORMAT',0x00000000)
    win_const_mgr.add_const('INDEX_GUID_CENTROID',0x0000000E)
    win_const_mgr.add_const('ERROR_RESOURCE_DATA_NOT_FOUND',0x00000714)
    win_const_mgr.add_const('BASE_ID',0x00006600)
    win_const_mgr.add_const('STATE_SYSTEM_FOCUSED',0x00000004)
    win_const_mgr.add_const('SUBLANG_SPANISH_EL_SALVADOR',0x00000011)
    win_const_mgr.add_const('WGL_FONT_LINES',0x00000000)
    win_const_mgr.add_const('MCI_QUALITY_DIALOG',0x00080000)
    win_const_mgr.add_const('SP_BAUD',0x00000002)
    win_const_mgr.add_const('EVCF_HASSETTINGS',0x00000001)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_EXTENSION',0x00000005)
    win_const_mgr.add_const('DI_FLAGSEX_ALWAYSWRITEIDS',0x00000200)
    win_const_mgr.add_const('OID_802_11_ADD_WEP',0x0D010113)
    win_const_mgr.add_const('MIB_IPROUTE_TYPE_DIRECT',0x00000003)
    win_const_mgr.add_const('VIF_CANNOTREADDST',0x00020000)
    win_const_mgr.add_const('TMT_MENU',0x00000645)
    win_const_mgr.add_const('HHWIN_PROP_TAB_FAVORITES',0x00000001)
    win_const_mgr.add_const('SP_COPY_WINDOWS_SIGNED',0x01000000)
    win_const_mgr.add_const('METADATA_ISINHERITED',0x00000020)
    win_const_mgr.add_const('MCI_DGV_SETVIDEO_SRC_PAL_S',0x00008013)
    win_const_mgr.add_const('FILE_DEVICE_DFS_FILE_SYSTEM',0x00000035)
    win_const_mgr.add_const('MD_EXTLOG_USERNAME',0x00000008)
    win_const_mgr.add_const('ASC_REQ_MUTUAL_AUTH',0x00000002)
    win_const_mgr.add_const('CRYPT_DATA_KEY',0x00000800)
    win_const_mgr.add_const('IPX_DEDICATED_LINK',0x00000001)
    win_const_mgr.add_const('MANAGED_APPS_INFOLEVEL_DEFAULT',0x00010000)
    win_const_mgr.add_const('PRINTER_ENUM_ICON8',0x00800000)
    win_const_mgr.add_const('NETERR_RING_STATUS_AUTO_REMOVAL_ERROR',0x00000400)
    win_const_mgr.add_const('ERROR_INVALID_NETNAME',0x000004BE)
    win_const_mgr.add_const('DDFXALPHACAPS_OVERLAYALPHAPIXELS',0x00000040)
    win_const_mgr.add_const('DEBUG_CES_CURRENT_THREAD',0x00000001)
    win_const_mgr.add_const('SEEK_SET',0x00000000)
    win_const_mgr.add_const('ERROR_CRM_PROTOCOL_ALREADY_EXISTS',0x00001A36)
    win_const_mgr.add_const('WINHTTP_QUERY_ACCEPT_RANGES',0x0000002A)
    win_const_mgr.add_const('DOT11_ASSOC_STATUS_PEER_DEAUTHENTICATED',0x00010000)
    win_const_mgr.add_const('DEBUG_ENGOPT_ALL',0x0003FFFF)
    win_const_mgr.add_const('LANG_SANSKRIT',0x00000004)
    win_const_mgr.add_const('TF_SFT_NOLABELS',0x00000100)
    win_const_mgr.add_const('CAT_E_FIRST',0x80040160)
    win_const_mgr.add_const('CFE_BOLD',0x00000001)
    win_const_mgr.add_const('TF_CONVERSIONMODE_ROMAN',0x00000010)
    win_const_mgr.add_const('SECPKG_NEGOTIATION_TRY_MULTICRED',0x00000004)
    win_const_mgr.add_const('STATUS_SEVERITY_WARNING',0x00000002)
    win_const_mgr.add_const('MD_EXTLOG_TIME',0x00000002)
    win_const_mgr.add_const('I24_OPERATION',0x00000001)
    win_const_mgr.add_const('E_XML_NOTWF',0xC00CE223)
    win_const_mgr.add_const('DNPROTO_NSP',0x00000001)
    win_const_mgr.add_const('ERROR_NOTIFY_ENUM_DIR',0x000003FE)
    win_const_mgr.add_const('FSHIFT',0x00000004)
    win_const_mgr.add_const('CM_GETIDLIST_FILTER_ENUMERATOR',0x00000001)
    win_const_mgr.add_const('ERROR_DS_SAM_INIT_FAILURE_CONSOLE',0x00002172)
    win_const_mgr.add_const('GESTURE_CIRCLE_TAP',0x00000000)
    win_const_mgr.add_const('TIMEPLAYITEM_OFFSET',0x00000C00)
    win_const_mgr.add_const('SPMODE_MSVM',0x00000040)
    win_const_mgr.add_const('FOFX_KEEPNEWERFILE',0x00400000)
    win_const_mgr.add_const('IS_EM',0x00000000)
    win_const_mgr.add_const('CHANNEL_EVENT_WRITE_CANCELLED',0x0000000C)
    win_const_mgr.add_const('DEBUG_ENGOPT_ALLOW_NETWORK_PATHS',0x00000004)
    win_const_mgr.add_const('REG_RESOURCE_LIST',0x00000008)
    win_const_mgr.add_const('VMRBITMAP_SRCCOLORKEY',0x00000008)
    win_const_mgr.add_const('LSA_NB_DISABLED_ADMIN',0x00000004)
    win_const_mgr.add_const('ERROR_EC_NO_ACTIVE_CHANNEL',0x00003AED)
    win_const_mgr.add_const('UOI_USER_SID',0x00000004)
    win_const_mgr.add_const('CERT_STORE_PROV_WRITE_CERT_FUNC',0x00000002)
    win_const_mgr.add_const('LBER_DEFAULT',0x00000000)
    win_const_mgr.add_const('SCARD_CLASS_IFD_PROTOCOL',0x00000008)
    win_const_mgr.add_const('IPX_STATIC_SERV_TABLE',0x00000005)
    win_const_mgr.add_const('WMDM_DEVICECAP_CANRECORD',0x00000004)
    win_const_mgr.add_const('EXPOSUREMETERING_MULTISPOT',0x00000003)
    win_const_mgr.add_const('CAUSE_INCORRECT_MESSAGE_LENGTH',0x00000068)
    win_const_mgr.add_const('SQL_DROP_CHARACTER_SET',0x00000089)
    win_const_mgr.add_const('MAXLEN_IFDESCR',0x00000100)
    win_const_mgr.add_const('R2_MASKPEN',0x00000009)
    win_const_mgr.add_const('CMC_STATUS_NO_SUPPORT',0x00000004)
    win_const_mgr.add_const('TT_NOIND',0x00000000)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_SELF',0x00000014)
    win_const_mgr.add_const('SERVICE_CTRL_INTERROGATE',0x00000000)
    win_const_mgr.add_const('DEBUG_SESSION_END_SESSION_ACTIVE_DETACH',0x00000002)
    win_const_mgr.add_const('TASK_FLAG_RUN_ONLY_IF_DOCKED',0x00000100)
    win_const_mgr.add_const('WKSTA_SIZERROR_PARMNUM',0x00000013)
    win_const_mgr.add_const('LINECALLPARAMFLAGS_DESTOFFHOOK',0x00000010)
    win_const_mgr.add_const('WS_DISABLED',0x08000000)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2TAO_CLIENTNAME',0x0000010E)
    win_const_mgr.add_const('DEBUG_ENGOPT_DISABLE_MANAGED_SUPPORT',0x00004000)
    win_const_mgr.add_const('RAS_EAP_FLAG_ALTERNATIVE_USER_DB',0x00000800)
    win_const_mgr.add_const('BSF_RESIZABLE',0x00000200)
    win_const_mgr.add_const('SQL_DRIVER_PROMPT',0x00000002)
    win_const_mgr.add_const('IDF_NOCOMPRESSED',0x00000008)
    win_const_mgr.add_const('PBS_SMOOTHREVERSE',0x00000010)
    win_const_mgr.add_const('DDCAPS_ALIGNSIZESRC',0x00000010)
    win_const_mgr.add_const('MDPROPVAL_MOQ_OUTERREFERENCE',0x00000001)
    win_const_mgr.add_const('ARW_UP',0x00000004)
    win_const_mgr.add_const('IDS_CAP_STAT_I_FRAMES',0x000001FA)
    win_const_mgr.add_const('FILE_NOTIFY_CHANGE_SECURITY',0x00000100)
    win_const_mgr.add_const('TRANSACTION_MANAGER_COMMIT_SYSTEM_HIVES',0x00000004)
    win_const_mgr.add_const('LINEBEARERMODE_DATA',0x00000008)
    win_const_mgr.add_const('WIA_DPS_MIN_HORIZONTAL_SHEET_FEED_SIZE',0x00000C20)
    win_const_mgr.add_const('CACHE_HEADER_DATA_CACHE_RESERVED_8',0x00000008)
    win_const_mgr.add_const('CACHE_HEADER_DATA_CACHE_RESERVED_9',0x00000009)
    win_const_mgr.add_const('CERT_ALT_NAME_DIRECTORY_NAME',0x00000005)
    win_const_mgr.add_const('SBM_SETRANGEREDRAW',0x000000E6)
    win_const_mgr.add_const('CTRL_LOGOFF_EVENT',0x00000005)
    win_const_mgr.add_const('BCRYPT_RSAPRIVATE_MAGIC',0x32415352)
    win_const_mgr.add_const('AE_LOCKOUT',0x00000014)
    win_const_mgr.add_const('IRDA_PROTO_SOCK_STREAM',0x00000001)
    win_const_mgr.add_const('LINECALLSTATE_IDLE',0x00000001)
    win_const_mgr.add_const('VP_FLAGS_TV_STANDARD',0x00000002)
    win_const_mgr.add_const('OID_TAPI_SET_CALL_PARAMS',0x0703011E)
    win_const_mgr.add_const('DFM_VALIDATECMD',0x00000009)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATAEVENTARGS_ESTIMATEDREMAININGTIME',0x00000301)
    win_const_mgr.add_const('STN_CLICKED',0x00000000)
    win_const_mgr.add_const('STDPROP_USERPROP_BASE',0x00010000)
    win_const_mgr.add_const('JOB_OBJECT_UILIMIT_SYSTEMPARAMETERS',0x00000008)
    win_const_mgr.add_const('CHANNEL_FLAG_LAST',0x00000002)
    win_const_mgr.add_const('GETVECTORBRUSHSIZE',0x0000001B)
    win_const_mgr.add_const('TF_MOD_RALT',0x00000008)
    win_const_mgr.add_const('CTF_INSIST',0x00000001)
    win_const_mgr.add_const('LM20_CNLEN',0x0000000F)
    win_const_mgr.add_const('SQL_COPT_SS_BASE_EX',0x000004D8)
    win_const_mgr.add_const('SI_USER_NOT_SCREENED',0x00000000)
    win_const_mgr.add_const('DEBUG_FILTER_EXIT_PROCESS',0x00000003)
    win_const_mgr.add_const('IMAGE_DLLCHARACTERISTICS_DYNAMIC_BASE',0x00000040)
    win_const_mgr.add_const('BTH_MINORVERSION',0x00000000)
    win_const_mgr.add_const('GOPHER_ATTRIBUTE_ID_BASE',0x00000000)
    win_const_mgr.add_const('ERROR_INDEX_ABSENT',0x0000064B)
    win_const_mgr.add_const('MDMSPKR_ON',0x00000002)
    win_const_mgr.add_const('ADS_PRINTER_POWER_SAVE',0x01000000)
    win_const_mgr.add_const('EVT_CLEAR_ACCESS',0x00000004)
    win_const_mgr.add_const('CORDLESS_EXTERNAL_NETWORK_ISDN',0x00000002)
    win_const_mgr.add_const('KSPROPERTY_CAMERACONTROL_FLAGS_AUTO',0x00000000)
    win_const_mgr.add_const('OQWF_OKCANCEL',0x00000001)
    win_const_mgr.add_const('MM_MIXM_LINE_CHANGE',0x000003D0)
    win_const_mgr.add_const('SNMP_ERRORSTATUS_READONLY',0x00000004)
    win_const_mgr.add_const('OID_ATM_MAX_AAL5_PACKET_SIZE',0x0801010B)
    win_const_mgr.add_const('SPFILENOTIFY_LANGMISMATCH',0x00010000)
    win_const_mgr.add_const('WINHTTP_QUERY_VERSION',0x00000012)
    win_const_mgr.add_const('PROCESSOR_ARCHITECTURE_ALPHA64',0x00000007)
    win_const_mgr.add_const('FRS_ERR_INTERNAL_API',0x00001F44)
    win_const_mgr.add_const('URLACTION_SHELL_MAX',0x00000019)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2ERASE_MEDIATYPE',0x00000102)
    win_const_mgr.add_const('LVTVIM_COLUMNS',0x00000002)
    win_const_mgr.add_const('MCI_DGV_OPEN_32BIT',0x00100000)
    win_const_mgr.add_const('MAX_COLOR_CHANNELS',0x00000008)
    win_const_mgr.add_const('OEM_FIXED_FONT',0x0000000A)
    win_const_mgr.add_const('HS_DIAGCROSS',0x00000005)
    win_const_mgr.add_const('ECOOP_OR',0x00000002)
    win_const_mgr.add_const('D3DSHADER_ADDRESSMODE_MASK',0x00000001)
    win_const_mgr.add_const('DXVA_DCCMD_SURFACE_BUFFER',0x0000000C)
    win_const_mgr.add_const('DXVA_ENCRYPTPROTOCOLFUNCFLAG_ACCEL',0x00FFFF08)
    win_const_mgr.add_const('SQL_DS_RESTRICT',0x00000002)
    win_const_mgr.add_const('SQL_FD_FETCH_NEXT',0x00000001)
    win_const_mgr.add_const('HTTP_QUERY_ACCEPT_LANGUAGE',0x0000001B)
    win_const_mgr.add_const('CM_CDMASK_VALID',0x0000000F)
    win_const_mgr.add_const('DI_NEEDRESTART',0x00000080)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_NETWORK',0x80001000)
    win_const_mgr.add_const('ACTIVATION_CONTEXT_SECTION_COM_INTERFACE_REDIRECTION',0x00000005)
    win_const_mgr.add_const('ERROR_RESMON_ONLINE_FAILED',0x0000139A)
    win_const_mgr.add_const('SUBLANG_SPANISH_DOMINICAN_REPUBLIC',0x00000007)
    win_const_mgr.add_const('IR_STRINGSTART',0x00000100)
    win_const_mgr.add_const('PGS_DRAGNDROP',0x00000004)
    win_const_mgr.add_const('NRC_SABORT',0x00000018)
    win_const_mgr.add_const('CSIDL_NETHOOD',0x00000013)
    win_const_mgr.add_const('LINEOFFERINGMODE_ACTIVE',0x00000001)
    win_const_mgr.add_const('OBEX_PROTOCOL_UUID16',0x00000008)
    win_const_mgr.add_const('CHANNEL_OPTION_ENCRYPT_SC',0x20000000)
    win_const_mgr.add_const('DDBLTFX_ZBUFFERRANGE',0x00000080)
    win_const_mgr.add_const('BG_S_ERROR_CONTEXT_NONE',0x00200006)
    win_const_mgr.add_const('CONNECTION_LAN',0x00000001)
    win_const_mgr.add_const('SET_FEATURE_ON_THREAD_RESTRICTED',0x00000080)
    win_const_mgr.add_const('BACKGROUND_RED',0x00000040)
    win_const_mgr.add_const('SSF_SORTCOLUMNS',0x00000010)
    win_const_mgr.add_const('NUMPRS_INEXACT',0x00020000)
    win_const_mgr.add_const('WMDM_GET_FORMAT_SUPPORT_FILE',0x00000004)
    win_const_mgr.add_const('WAVECAPS_SAMPLEACCURATE',0x00000020)
    win_const_mgr.add_const('IF_TYPE_DDN_X25',0x00000004)
    win_const_mgr.add_const('SIC_ASCIIDIGIT',0x00000002)
    win_const_mgr.add_const('MCI_DGV_STATUS_GAMMA',0x00000400)
    win_const_mgr.add_const('DMPAPER_DBL_JAPANESE_POSTCARD',0x00000045)
    win_const_mgr.add_const('MQ_MAX_MSG_LABEL_LEN',0x000000FA)
    win_const_mgr.add_const('OID_FDDI_IF_SPECIFIC',0x0303028D)
    win_const_mgr.add_const('HTTP_QUERY_MIME_VERSION',0x00000000)
    win_const_mgr.add_const('D3DTEXOPCAPS_BUMPENVMAP',0x00200000)
    win_const_mgr.add_const('TAPE_QUERY_DRIVE_PARAMETERS',0x00000000)
    win_const_mgr.add_const('ERROR_ALREADY_RUNNING_LKG',0x00000432)
    win_const_mgr.add_const('TF_WRITE_BEHIND',0x00000004)
    win_const_mgr.add_const('WM_CANCELMODE',0x0000001F)
    win_const_mgr.add_const('PAN_CONTRAST_INDEX',0x00000004)
    win_const_mgr.add_const('TMPF_TRUETYPE',0x00000004)
    win_const_mgr.add_const('DBPROPVAL_STGM_DIRECT',0x00010000)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_BIND_PARAMETERS',0x00000086)
    win_const_mgr.add_const('AIF_NO_VERSION_DIALOG',0x00000020)
    win_const_mgr.add_const('ERROR_SUBST_TO_SUBST',0x0000008B)
    win_const_mgr.add_const('OF_EXIST',0x00004000)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_REFLONG',0x00000001)
    win_const_mgr.add_const('UM_FOCUS_TYPE_DOMAIN',0x00000001)
    win_const_mgr.add_const('FAX_PORT_SET',0x00000020)
    win_const_mgr.add_const('DBT_DEVICEREMOVECOMPLETE',0x00008004)
    win_const_mgr.add_const('STGM_SHARE_DENY_WRITE',0x00000020)
    win_const_mgr.add_const('DMDO_90',0x00000001)
    win_const_mgr.add_const('_WIN32_MSM',0x00000064)
    win_const_mgr.add_const('CPLPAGE_MOUSE_BUTTONS',0x00000001)
    win_const_mgr.add_const('IMAGE_REL_ARM_ADDR32',0x00000001)
    win_const_mgr.add_const('SQL_DIAG_REVOKE',0x0000003B)
    win_const_mgr.add_const('PFL_MULTIPLE_PROTO_ENTRIES',0x00000001)
    win_const_mgr.add_const('MCI_DGV_INFO_USAGE',0x00004000)
    win_const_mgr.add_const('VK_OEM_JUMP',0x000000EA)
    win_const_mgr.add_const('ERROR_SLOT_NOT_PRESENT',0x00000004)
    win_const_mgr.add_const('ICMF_CHOOSE_DATARATE',0x00000002)
    win_const_mgr.add_const('COLOR_SATACCEL',0x000002D4)
    win_const_mgr.add_const('PSD_INWININIINTLMEASURE',0x00000000)
    win_const_mgr.add_const('LOCALE_SNATIVECTRYNAME',0x00000008)
    win_const_mgr.add_const('LANG_VIETNAMESE',0x00000002)
    win_const_mgr.add_const('NOTE_COLOR_WHITE',0x00000004)
    win_const_mgr.add_const('ERROR_CLUSTER_NOT_INSTALLED',0x0000172C)
    win_const_mgr.add_const('NETLOGON_REPLICATION_NEEDED',0x00000001)
    win_const_mgr.add_const('GGO_METRICS',0x00000000)
    win_const_mgr.add_const('STI_GENCAP_WIA',0x00000010)
    win_const_mgr.add_const('DDSETSURFACEDESC_PRESERVEDC',0x00000001)
    win_const_mgr.add_const('ISC_SHOWUICOMPOSITIONWINDOW',0x80000000)
    win_const_mgr.add_const('CTF_COINIT_STA',0x00000008)
    win_const_mgr.add_const('SHTDN_REASON_MAJOR_HARDWARE',0x00010000)
    win_const_mgr.add_const('ERROR_DS_BUSY',0x0000200E)
    win_const_mgr.add_const('MD_SERVER_STATE_PAUSED',0x00000006)
    win_const_mgr.add_const('SCARD_STATE_PRESENT',0x00000020)
    win_const_mgr.add_const('RTM_VIEW_MASK_NONE',0x00000000)
    win_const_mgr.add_const('MCI_ANIM_STATUS_HWND',0x00004003)
    win_const_mgr.add_const('ERROR_EVT_CHANNEL_NOT_FOUND',0x00003A9F)
    win_const_mgr.add_const('TMT_ALPHATHRESHOLD',0x0000096F)
    win_const_mgr.add_const('DS_DOMAIN_DIRECT_OUTBOUND',0x00000002)
    win_const_mgr.add_const('ICERR_NEWPALETTE',0x00000002)
    win_const_mgr.add_const('SCARD_E_INVALID_VALUE',0x80100011)
    win_const_mgr.add_const('TTFCFP_ISO_PLATFORMID',0x00000002)
    win_const_mgr.add_const('MCI_DGV_INPUT_S',0x00008003)
    win_const_mgr.add_const('DI_NOWRITE_IDS',0x80000000)
    win_const_mgr.add_const('CM_CDMASK_DESCRIPTION',0x00000008)
    win_const_mgr.add_const('IDM_TRIED_PRINT',0x00000033)
    win_const_mgr.add_const('LINETONEMODE_BILLING',0x00000010)
    win_const_mgr.add_const('COD_MAJOR_MISCELLANEOUS',0x00000000)
    win_const_mgr.add_const('OFFLINE_STATUS_INCOMPLETE',0x00000004)
    win_const_mgr.add_const('EAP_METHOD_AUTHENTICATOR_CONFIG_IS_IDENTITY_PRIVACY',0x00000001)
    win_const_mgr.add_const('EAP_FLAG_RESUME_FROM_HIBERNATE',0x00000200)
    win_const_mgr.add_const('SV_TYPE_MASTER_BROWSER',0x00040000)
    win_const_mgr.add_const('MCI_DGV_SETVIDEO_SHARPNESS',0x00004004)
    win_const_mgr.add_const('NETSETUP_JOIN_UNSECURE',0x00000040)
    win_const_mgr.add_const('LINECALLSTATE_SPECIALINFO',0x00000080)
    win_const_mgr.add_const('ERROR_BAD_USER_PROFILE',0x000004E5)
    win_const_mgr.add_const('IPPORT_TIMESERVER',0x00000025)
    win_const_mgr.add_const('SQL_HANDLE_DBC',0x00000002)
    win_const_mgr.add_const('IMAGE_SCN_SCALE_INDEX',0x00000001)
    win_const_mgr.add_const('WMDM_STATUS_DEVICECONTROL_REMOTE',0x00000040)
    win_const_mgr.add_const('IDC_IO_RESULTIMAGE',0x0000083C)
    win_const_mgr.add_const('IMAGE_SIZEOF_SECTION_HEADER',0x00000028)
    win_const_mgr.add_const('DOT11_ASSOC_STATUS_RADIO_OFF',0x00000003)
    win_const_mgr.add_const('IDTB_BROWSE_FWD',0x000000D3)
    win_const_mgr.add_const('PROPTYPE_STRING',0x00000004)
    win_const_mgr.add_const('VK_LEFT',0x00000025)
    win_const_mgr.add_const('FIXED_PITCH',0x00000001)
    win_const_mgr.add_const('NDIS_PACKET_TYPE_MULTICAST',0x00000002)
    win_const_mgr.add_const('BATTERY_PERCENTAGE_UNKNOWN',0x000000FF)
    win_const_mgr.add_const('SV_ACTIVELOCKS_PARMNUM',0x000001A3)
    win_const_mgr.add_const('FLG_REGSVR_DLLINSTALL',0x00000002)
    win_const_mgr.add_const('PDH_UNKNOWN_LOG_FORMAT',0xC0000BD6)
    win_const_mgr.add_const('SNMPAPI_ON',0x00000001)
    win_const_mgr.add_const('PHONEFEATURE_GETBUTTONINFO',0x00000001)
    win_const_mgr.add_const('MCI_STATUS_START',0x00000200)
    win_const_mgr.add_const('BCSIF_IMAGE',0x00000002)
    win_const_mgr.add_const('CSIDL_NETWORK',0x00000012)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_TABLES',0x00000004)
    win_const_mgr.add_const('SHTDN_REASON_FLAG_COMMENT_REQUIRED',0x01000000)
    win_const_mgr.add_const('EVENT_CONSOLE_END_APPLICATION',0x00004007)
    win_const_mgr.add_const('FAX_ERR_FILE_ACCESS_DENIED',0x00001B60)
    win_const_mgr.add_const('SQL_COLLATION_SEQ',0x00002714)
    win_const_mgr.add_const('DBG_WOWINIT',0x00000011)
    win_const_mgr.add_const('MD_AUTH_MD5',0x00000010)
    win_const_mgr.add_const('SEARCH_ALL_NO_SEQ',0x00000004)
    win_const_mgr.add_const('DISPID_HTMLPOPUP',0x00006978)
    win_const_mgr.add_const('IDM_TRIED_JUSTIFYRIGHT',0x0000002E)
    win_const_mgr.add_const('SEE_MASK_CONNECTNETDRV',0x00000080)
    win_const_mgr.add_const('WIA_DPS_DITHER_PATTERN_DATA',0x00000C0D)
    win_const_mgr.add_const('WM_SIZE',0x00000005)
    win_const_mgr.add_const('CONSOLE_SELECTION_IN_PROGRESS',0x00000001)
    win_const_mgr.add_const('PROGRESS_CONTINUE',0x00000000)
    win_const_mgr.add_const('IMAGE_SYM_DTYPE_ARRAY',0x00000003)
    win_const_mgr.add_const('PE_HDR_LEN',0x00000002)
    win_const_mgr.add_const('MM_WIM_DATA',0x000003C0)
    win_const_mgr.add_const('DSA_NOTIFY_FLAG_FORCE_ADDITIONAL_DATA',0x00000001)
    win_const_mgr.add_const('BCSS_ALIGNLEFT',0x00000004)
    win_const_mgr.add_const('DC_DRIVER',0x0000000B)
    win_const_mgr.add_const('ITR_KERNEL_INDEX',0x00000001)
    win_const_mgr.add_const('MQ_LOOKUP_RECEIVE_CURRENT',0x40000020)
    win_const_mgr.add_const('GESTURE_SECTION',0x00000000)
    win_const_mgr.add_const('LINEBEARERMODE_RESTRICTEDDATA',0x00000080)
    win_const_mgr.add_const('INDEX_GUID_ROOT',0x00000000)
    win_const_mgr.add_const('DRM_LOCKBOXTYPE_BLACKBOX',0x00000002)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_PROPAGATE_PUSH',0x00010000)
    win_const_mgr.add_const('MM_MICROSOFT',0x00000001)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_OPEN_PARAMETERS',0x00000087)
    win_const_mgr.add_const('SNMP_LOG_TRACE',0x00000004)
    win_const_mgr.add_const('IMAGE_REL_I386_DIR32NB',0x00000007)
    win_const_mgr.add_const('BG_S_OVERRIDDEN_BY_POLICY',0x00200055)
    win_const_mgr.add_const('DISPID_ORDERCHANGED',0x000000D2)
    win_const_mgr.add_const('LOCALE_INEGSIGNPOSN',0x00000053)
    win_const_mgr.add_const('SID_HASH_SIZE',0x00000020)
    win_const_mgr.add_const('SCH_CRED_FORMAT_CERT_HASH_STORE',0x00000002)
    win_const_mgr.add_const('NDIS_ENCAPSULATION_IEEE_802_3_P_AND_Q',0x00000004)
    win_const_mgr.add_const('SPC_UUID_LENGTH',0x00000010)
    win_const_mgr.add_const('SAFER_MAX_DESCRIPTION_SIZE',0x00000100)
    win_const_mgr.add_const('SERVICETYPE_GENERAL_INFORMATION',0x00000005)
    win_const_mgr.add_const('SO_BTH_MTU_MAX',0x80000008)
    win_const_mgr.add_const('WMDM_STORAGECAP_FILESINROOT',0x00000002)
    win_const_mgr.add_const('DBPROPVAL_TR_BOTH',0x00000080)
    win_const_mgr.add_const('NRC_NOSAPS',0x00000037)
    win_const_mgr.add_const('IGP_PROPERTY',0x00000004)
    win_const_mgr.add_const('SQL_CA2_CRC_EXACT',0x00001000)
    win_const_mgr.add_const('FAULT_INVALID_VARIABLE',0x00000194)
    win_const_mgr.add_const('DICLASSPROP_INTERFACE',0x00000002)
    win_const_mgr.add_const('NTDDI_VERSION',0x06000000)
    win_const_mgr.add_const('JRO_MAJOR',0x00000002)
    win_const_mgr.add_const('PAN_LETT_NORMAL_OFF_CENTER',0x00000007)
    win_const_mgr.add_const('GLOBAL_INTERFACE_INDEX',0xFFFFFFFF)
    win_const_mgr.add_const('LVHT_TORIGHT',0x00000020)
    win_const_mgr.add_const('INDEX_DONT_CARE',0x00000000)
    win_const_mgr.add_const('CLRBREAK',0x00000009)
    win_const_mgr.add_const('MPEG_PAT_TID',0x00000000)
    win_const_mgr.add_const('IDM_ETCHED',0x00000041)
    win_const_mgr.add_const('SNMPAPI_TL_NOT_INITIALIZED',0x00000064)
    win_const_mgr.add_const('TME_NONCLIENT',0x00000010)
    win_const_mgr.add_const('ILD_OVERLAYMASK',0x00000F00)
    win_const_mgr.add_const('ERROR_WMI_DP_NOT_FOUND',0x0000106C)
    win_const_mgr.add_const('LINECALLFEATURE_ACCEPT',0x00000001)
    win_const_mgr.add_const('SUBSMGRUPDATE_MASK',0x00000001)
    win_const_mgr.add_const('ERROR_PIPE_BUSY',0x000000E7)
    win_const_mgr.add_const('DBPROPVAL_IC_UPPER',0x00000001)
    win_const_mgr.add_const('VK_SLEEP',0x0000005F)
    win_const_mgr.add_const('SQL_TYPE_NULL',0x00000000)
    win_const_mgr.add_const('LOCALE_STHOUSAND',0x0000000F)
    win_const_mgr.add_const('SHIL_LARGE',0x00000000)
    win_const_mgr.add_const('PPCF_ADDARGUMENTS',0x00000003)
    win_const_mgr.add_const('CAL_SABBREVMONTHNAME1',0x00000022)
    win_const_mgr.add_const('LINEADDRESSSTATE_DEVSPECIFIC',0x00000002)
    win_const_mgr.add_const('BSIS_AUTOGRIPPER',0x00000000)
    win_const_mgr.add_const('MCI_FORMAT_SAMPLES',0x00000009)
    win_const_mgr.add_const('MAPIFORM_CPU_M68',0x00000005)
    win_const_mgr.add_const('KSAUDIO_QUALITY_BASIC',0x00000002)
    win_const_mgr.add_const('ADS_PRINTER_PROCESSING',0x00004000)
    win_const_mgr.add_const('KAGPROP_AUTH_SERVERINTEGRATED',0x00000003)
    win_const_mgr.add_const('FLAGCOLOR_PURPLE',0x00000001)
    win_const_mgr.add_const('CERT_LDAP_STORE_OPENED_FLAG',0x00040000)
    win_const_mgr.add_const('MDPROPVAL_MNF_DRILLDOWNLEVEL',0x00000800)
    win_const_mgr.add_const('TRACE_PROVIDER_FLAG_PRE_ENABLE',0x00000002)
    win_const_mgr.add_const('ERROR_SXS_XML_E_UNCLOSEDENDTAG',0x000036ED)
    win_const_mgr.add_const('ALLOW_OUTOFBAND_NOTIFICATION',0x00000002)
    win_const_mgr.add_const('SSF_DONTPRETTYPATH',0x00000800)
    win_const_mgr.add_const('IDM_TRIED_SEND_BELOW_TEXT',0x0000000A)
    win_const_mgr.add_const('AF_PUP',0x00000004)
    win_const_mgr.add_const('CERT_STORE_BACKUP_RESTORE_FLAG',0x00000800)
    win_const_mgr.add_const('SLMFLAG_NO_SYMBOLS',0x00000004)
    win_const_mgr.add_const('CSIDL_PROGRAM_FILESX86',0x00000002)
    win_const_mgr.add_const('LVS_EX_UNDERLINEHOT',0x00000800)
    win_const_mgr.add_const('FACILITY_SL_ITF',0x00000004)
    win_const_mgr.add_const('MDLEVEL_TYPE_UNKNOWN',0x00000000)
    win_const_mgr.add_const('SETUP_ATTEMPT_VROOT_CREATE',0x00000080)
    win_const_mgr.add_const('LINEDISCONNECTMODE_UNREACHABLE',0x00000100)
    win_const_mgr.add_const('SNMP_ERRORSTATUS_BADVALUE',0x00000003)
    win_const_mgr.add_const('BHLI_ISO',0x00000000)
    win_const_mgr.add_const('RSVP_RESV_ERR',0x00000004)
    win_const_mgr.add_const('MAXLOGICALLOGNAMESIZE',0x00000100)
    win_const_mgr.add_const('PERF_NUMBER_DEC_1000',0x00020000)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_FOREIGN_KEYS',0x00000006)
    win_const_mgr.add_const('ERROR_MOUNT_POINT_NOT_RESOLVED',0x00000289)
    win_const_mgr.add_const('ERROR_LOG_BLOCK_VERSION',0x000019D0)
    win_const_mgr.add_const('ERROR_DS_INVALID_DN_SYNTAX',0x00002032)
    win_const_mgr.add_const('CSF_SHOWHELP',0x00000001)
    win_const_mgr.add_const('CFE_AUTOCOLOR',0x40000000)
    win_const_mgr.add_const('USER_TIMER_MAXIMUM',0x7FFFFFFF)
    win_const_mgr.add_const('CDO_E_CONTENTPROPXML_CONVERT_FAILED',0x80040230)
    win_const_mgr.add_const('PID_FILENAME',0x00000064)
    win_const_mgr.add_const('POLICY_ERRV_GLOBAL_GRP_FLOW_DURATION',0x0000000A)
    win_const_mgr.add_const('SSM_SET',0x00000001)
    win_const_mgr.add_const('SV_TYPE_DCE',0x10000000)
    win_const_mgr.add_const('MM_WIM_CLOSE',0x000003BF)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_LOAD_SOFT_SA',0x00003614)
    win_const_mgr.add_const('TRUSTERROR_STEP_MSG_COUNTERSIGINFO',0x00000010)
    win_const_mgr.add_const('WM_ENTERMENULOOP',0x00000211)
    win_const_mgr.add_const('NDIS_RING_RING_RECOVERY',0x00000040)
    win_const_mgr.add_const('WINEVENT_LEVEL_WARNING',0x00000003)
    win_const_mgr.add_const('CERT_ARCHIVED_PROP_ID',0x00000013)
    win_const_mgr.add_const('IDM_BREAKATNEXT',0x00000907)
    win_const_mgr.add_const('SCHANNEL_RENEGOTIATE',0x00000000)
    win_const_mgr.add_const('RGN_COPY',0x00000005)
    win_const_mgr.add_const('CLUSTER_RUNNING',0x00000010)
    win_const_mgr.add_const('IDC_EL_UPDATENOW',0x000000D2)
    win_const_mgr.add_const('IF_TYPE_SRP',0x00000097)
    win_const_mgr.add_const('DDSPD_IUNKNOWNPOINTER',0x00000001)
    win_const_mgr.add_const('USER_DONT_REQUIRE_PREAUTH',0x00010000)
    win_const_mgr.add_const('PSR_MBZ0_V',0x00000007)
    win_const_mgr.add_const('SQL_UPDATE',0x00000002)
    win_const_mgr.add_const('DCIENUMSURFACE',0x00000004)
    win_const_mgr.add_const('NDIS_WMI_SET_HEADER_REVISION_1',0x00000001)
    win_const_mgr.add_const('MD_ROOT_ENABLE_EDIT_WHILE_RUNNING',0x0000270E)
    win_const_mgr.add_const('GROUP_SECURITY_INFORMATION',0x00000002)
    win_const_mgr.add_const('EASTEUROPE_CHARSET',0x000000EE)
    win_const_mgr.add_const('SHI1_NUM_ELEMENTS',0x00000004)
    win_const_mgr.add_const('IMAGE_FILE_BYTES_REVERSED_LO',0x00000080)
    win_const_mgr.add_const('ERROR_DS_INSUFF_ACCESS_RIGHTS',0x00002098)
    win_const_mgr.add_const('LINE_PROXYREQUEST',0x00000018)
    win_const_mgr.add_const('NTMSMLI_MAXIDSIZE',0x00000100)
    win_const_mgr.add_const('MCI_VCR_STATUS_TIME_TYPE',0x00004019)
    win_const_mgr.add_const('TAPE_DRIVE_SET_ECC',0x80000100)
    win_const_mgr.add_const('CRYPT_GET_URL_FROM_AUTH_ATTRIBUTE',0x00000008)
    win_const_mgr.add_const('CTRY_IRAQ',0x000003C4)
    win_const_mgr.add_const('DEBUG_STATUS_REVERSE_STEP_OVER',0x0000000D)
    win_const_mgr.add_const('MSV1_0_VALIDATION_USER_FLAGS',0x00000020)
    win_const_mgr.add_const('TXFS_START_RM_FLAG_LOG_NO_CONTAINER_COUNT_MIN',0x00000080)
    win_const_mgr.add_const('I24_AREA',0x00000006)
    win_const_mgr.add_const('DDCAPS_ALIGNSIZEDEST',0x00000004)
    win_const_mgr.add_const('CM_QUERY_ARBITRATOR_TRANSLATED',0x00000001)
    win_const_mgr.add_const('KSPROPERTY_TYPE_UNSERIALIZESET',0x00001000)
    win_const_mgr.add_const('WMI_GUIDTYPE_TRACECONTROL',0x00000000)
    win_const_mgr.add_const('DDCKEYCAPS_SRCOVERLAYYUV',0x00020000)
    win_const_mgr.add_const('SQL_API_SQLSETCONNECTATTR',0x000003F8)
    win_const_mgr.add_const('ERROR_TRANSACTION_NOT_JOINED',0x00001A34)
    win_const_mgr.add_const('ERROR_NO_DBG_POINTER',0x00008801)
    win_const_mgr.add_const('ERROR_SXS_XML_E_MISSINGSEMICOLON',0x000036D7)
    win_const_mgr.add_const('FILE_DEVICE_TRANSPORT',0x00000021)
    win_const_mgr.add_const('PPP_LCP_EAP',0x0000C227)
    win_const_mgr.add_const('CTRY_YEMEN',0x000003C7)
    win_const_mgr.add_const('SETUP_W2K_SECURITY_NOT_UPGRADED_FLAG',0x00000800)
    win_const_mgr.add_const('ERROR_DS_SOURCE_AUDITING_NOT_ENABLED',0x00002168)
    win_const_mgr.add_const('APPCOMMAND_TREBLE_DOWN',0x00000016)
    win_const_mgr.add_const('CAL_ITWODIGITYEARMAX',0x00000030)
    win_const_mgr.add_const('TASK_FLAG_KILL_ON_IDLE_END',0x00000020)
    win_const_mgr.add_const('DOMAIN_USER_RID_ADMIN',0x000001F4)
    win_const_mgr.add_const('ERROR_SXS_INVALID_XML_NAMESPACE_URI',0x000036BE)
    win_const_mgr.add_const('IMAGE_REL_AMD64_TOKEN',0x0000000D)
    win_const_mgr.add_const('ERROR_REMOTE_SESSION_LIMIT_EXCEEDED',0x000004C4)
    win_const_mgr.add_const('HEAP_CREATE_ENABLE_EXECUTE',0x00040000)
    win_const_mgr.add_const('DSOP_SCOPE_FLAG_STARTING_SCOPE',0x00000001)
    win_const_mgr.add_const('SPDRP_UNUSED2',0x00000006)
    win_const_mgr.add_const('SPDRP_UNUSED1',0x00000005)
    win_const_mgr.add_const('SPDRP_UNUSED0',0x00000003)
    win_const_mgr.add_const('MAX_GOPHER_ATTRIBUTE_NAME',0x00000080)
    win_const_mgr.add_const('LVS_EX_BORDERSELECT',0x00008000)
    win_const_mgr.add_const('INTERNET_STATUS_COOKIE_HISTORY',0x00000147)
    win_const_mgr.add_const('FILE_SYSTEM_NOT_SUPPORT',0x00000006)
    win_const_mgr.add_const('SM_CYBORDER',0x00000006)
    win_const_mgr.add_const('SQL_CDO_CONSTRAINT_INITIALLY_IMMEDIATE',0x00000040)
    win_const_mgr.add_const('INTERNET_PREFETCH_PROGRESS',0x00000000)
    win_const_mgr.add_const('CM_DRP_UPPERFILTERS',0x00000012)
    win_const_mgr.add_const('HANDLE_PARAM_IS_OUT',0x00000020)
    win_const_mgr.add_const('PDH_NO_DIALOG_DATA',0xC0000BC7)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_CHARACTER_SETS',0x00000003)
    win_const_mgr.add_const('DDF_FULLSCREEN',0x00000100)
    win_const_mgr.add_const('SBS_TOPALIGN',0x00000002)
    win_const_mgr.add_const('DCI_OVERLAY',0x00000002)
    win_const_mgr.add_const('METAFILE_DRIVER',0x00000801)
    win_const_mgr.add_const('SQL_ATTR_ROW_ARRAY_SIZE',0x0000001B)
    win_const_mgr.add_const('LVBKIF_STYLE_NORMAL',0x00000000)
    win_const_mgr.add_const('NRC_IFBUSY',0x00000021)
    win_const_mgr.add_const('LOCALE_INEGCURR',0x0000001C)
    win_const_mgr.add_const('WM_MOUSEMOVE',0x00000200)
    win_const_mgr.add_const('LINECALLREASON_DIRECT',0x00000001)
    win_const_mgr.add_const('WMDM_STORAGE_ATTR_FILESYSTEM',0x00000001)
    win_const_mgr.add_const('FWPM_WEIGHT_RANGE_IKE_EXEMPTIONS',0x00000000)
    win_const_mgr.add_const('DISPID_FONT_BOLD',0x00000003)
    win_const_mgr.add_const('FKF_FILTERKEYSON',0x00000001)
    win_const_mgr.add_const('URLACTION_SHELL_FILE_DOWNLOAD',0x00001803)
    win_const_mgr.add_const('PHOTO_FLASH_NONE',0x00000000)
    win_const_mgr.add_const('CERT_PE_IMAGE_DIGEST_DEBUG_INFO',0x00000001)
    win_const_mgr.add_const('CTRY_ISRAEL',0x000003CC)
    win_const_mgr.add_const('ERROR_INVALID_MODULETYPE',0x000000BE)
    win_const_mgr.add_const('ERROR_CANNOT_ABORT_TRANSACTIONS',0x00001AC0)
    win_const_mgr.add_const('LINEADDRCAPFLAGS_FWDCONSULT',0x00000100)
    win_const_mgr.add_const('WEBPOST_ERROR_PROV_DLL',0xC0042105)
    win_const_mgr.add_const('BSF_DELEGATEDNAVIGATION',0x00010000)
    win_const_mgr.add_const('D3DPMISCCAPS_TSSARGTEMP',0x00000400)
    win_const_mgr.add_const('DDSCL_SETFOCUSWINDOW',0x00000080)
    win_const_mgr.add_const('IDM_BOLD',0x00000034)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_BRIDGEDAPP',0x0000001C)
    win_const_mgr.add_const('CDO_E_CONNECTION_DROPPED',0x80040212)
    win_const_mgr.add_const('ERROR_FILE_ENCRYPTED',0x00001772)
    win_const_mgr.add_const('TMT_BORDERSIZE',0x00000963)
    win_const_mgr.add_const('DNSSEC_ALGORITHM_RSAMD5',0x00000001)
    win_const_mgr.add_const('TMT_TEXTAPPLYOVERLAY',0x000008A8)
    win_const_mgr.add_const('ERROR_INVALID_EVENTNAME',0x000004BB)
    win_const_mgr.add_const('BACKUP_SECURITY_DATA',0x00000003)
    win_const_mgr.add_const('NCBCHAINSENDNA',0x00000072)
    win_const_mgr.add_const('ACTRL_DS_SELF',0x00000008)
    win_const_mgr.add_const('SRRF_RT_REG_QWORD',0x00000040)
    win_const_mgr.add_const('SQL_API_SQLNUMPARAMS',0x0000003F)
    win_const_mgr.add_const('FAX_ERR_SRV_OUTOFMEMORY',0x00001B59)
    win_const_mgr.add_const('LINECALLCOMPLMODE_MESSAGE',0x00000008)
    win_const_mgr.add_const('WKSTA_NUMALERTS_PARMNUM',0x00000014)
    win_const_mgr.add_const('GOPHER_TYPE_GOPHER_PLUS',0x80000000)
    win_const_mgr.add_const('PD_CAN_STRETCHDIB',0x00000002)
    win_const_mgr.add_const('ALLOWED_IGNORE',0x00000008)
    win_const_mgr.add_const('MAPI_DIM',0x00000001)
    win_const_mgr.add_const('IMAGE_FILE_MACHINE_I386',0x00000014)
    win_const_mgr.add_const('DB_PROT_LEVEL_PKT_PRIVACY',0x00000005)
    win_const_mgr.add_const('WSASYS_STATUS_LEN',0x00000080)
    win_const_mgr.add_const('DN_WO',0x00000002)
    win_const_mgr.add_const('RF_CAC_INPUT',0x00000020)
    win_const_mgr.add_const('EMR_SETMAPPERFLAGS',0x00000010)
    win_const_mgr.add_const('SPI_SETTOGGLEKEYS',0x00000035)
    win_const_mgr.add_const('PORT_NETRJS3',0x00000049)
    win_const_mgr.add_const('TF_CONVERSIONMODE_SOFTKEYBOARD',0x00000080)
    win_const_mgr.add_const('COLOR_GREENACCEL',0x000002D7)
    win_const_mgr.add_const('WMS_STREAM_MIN_BITRATE',0x00000001)
    win_const_mgr.add_const('MFE_WRONG_IF',0x00000003)
    win_const_mgr.add_const('INTERNET_CONNECTION_MODEM_BUSY',0x00000008)
    win_const_mgr.add_const('MAJOR_VERSION_MASK',0x0000000F)
    win_const_mgr.add_const('MFOUTPUTATTRIBUTE_NONSTANDARDIMPLEMENTATION',0x00000002)
    win_const_mgr.add_const('ASC_RET_ALLOW_CONTEXT_REPLAY',0x00400000)
    win_const_mgr.add_const('IDC_CV_DISPLAYASICON',0x00000098)
    win_const_mgr.add_const('TABLE_ROW_MODIFIED',0x00000005)
    win_const_mgr.add_const('WINEVENT_OPCODE_EXTENSION',0x00000005)
    win_const_mgr.add_const('ATA_FLAGS_48BIT_COMMAND',0x00000001)
    win_const_mgr.add_const('DMPAPER_P16K_ROTATED',0x0000006A)
    win_const_mgr.add_const('CERT_STORE_PROV_WRITE_CRL_FUNC',0x00000006)
    win_const_mgr.add_const('SQL_FN_SYS_DBNAME',0x00000002)
    win_const_mgr.add_const('MDPROPVAL_NME_ALLDIMENSIONS',0x00000000)
    win_const_mgr.add_const('ITSSFLAG_KILL_ON_DESTROY',0x00000001)
    win_const_mgr.add_const('WIA_IPS_PREVIEW_TYPE',0x00000C27)
    win_const_mgr.add_const('IS_TEXT_UNICODE_REVERSE_ASCII16',0x00000010)
    win_const_mgr.add_const('ERROR_INSTALL_SERVICE_FAILURE',0x00000641)
    win_const_mgr.add_const('IOCTL_IP_ADDCHANGE_NOTIFY_REQUEST',0x00000066)
    win_const_mgr.add_const('AF_UNKNOWN1',0x00000014)
    win_const_mgr.add_const('SAFER_LEVELID_FULLYTRUSTED',0x00040000)
    win_const_mgr.add_const('HTTP_LOG_FIELD_URI_STEM',0x00000100)
    win_const_mgr.add_const('BTH_MFG_QUALCOMM',0x0000001D)
    win_const_mgr.add_const('UP_P2MP',0x00000001)
    win_const_mgr.add_const('IDASYNC',0x00007D01)
    win_const_mgr.add_const('IDS_CAP_MCI_CONTROL_ERROR',0x000001B4)
    win_const_mgr.add_const('ERROR_INVALID_TABLE',0x0000065C)
    win_const_mgr.add_const('VMRBITMAP_SRCRECT',0x00000010)
    win_const_mgr.add_const('URL_DONT_UNESCAPE',0x00020000)
    win_const_mgr.add_const('DCX_VALIDATE',0x00200000)
    win_const_mgr.add_const('NOTIFIER_TYPE_IMMEDIATE',0x00000010)
    win_const_mgr.add_const('ACM_FORMATENUMF_NSAMPLESPERSEC',0x00040000)
    win_const_mgr.add_const('IRLMP_SEND_PDU_LEN',0x00000013)
    win_const_mgr.add_const('FILE_LIST_DIRECTORY',0x00000001)
    win_const_mgr.add_const('MF_512_BYTE_ALIGNMENT',0x00000001)
    win_const_mgr.add_const('IDM_PLUGIN',0x00000880)
    win_const_mgr.add_const('IMAGE_REL_PPC_TOKEN',0x00000016)
    win_const_mgr.add_const('D3DVS20_MAX_NUMTEMPS',0x00000020)
    win_const_mgr.add_const('PSF_NOREFRESHDATAOBJECT',0x00000080)
    win_const_mgr.add_const('MD_ACCESS_NO_REMOTE_EXECUTE',0x00002000)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_REGISTRY',0x00020000)
    win_const_mgr.add_const('SYMOPT_FLAT_DIRECTORY',0x00400000)
    win_const_mgr.add_const('IDTIMEOUT',0x00007D00)
    win_const_mgr.add_const('PIFDEFFILESIZE',0x00000050)
    win_const_mgr.add_const('TABLET_DISABLE_PENTAPFEEDBACK',0x00000008)
    win_const_mgr.add_const('PP_ENUMCONTAINERS',0x00000002)
    win_const_mgr.add_const('DNS_ERROR_NAME_DOES_NOT_EXIST',0x000025F2)
    win_const_mgr.add_const('SET_FEATURE_ON_THREAD',0x00000001)
    win_const_mgr.add_const('IDM_PASTEFORMAT',0x000008BE)
    win_const_mgr.add_const('SQL_INTERVAL_HOUR_TO_MINUTE',0x00000064)
    win_const_mgr.add_const('TF_CONVERSIONMODE_EUDC',0x00000200)
    win_const_mgr.add_const('PID_LASTAUTHOR',0x00000008)
    win_const_mgr.add_const('PSD_DISABLEPAPER',0x00000200)
    win_const_mgr.add_const('COPY_FILE_FAIL_IF_EXISTS',0x00000001)
    win_const_mgr.add_const('SC_SEPARATOR',0x0000F00F)
    win_const_mgr.add_const('INTERNET_OPTION_PER_CONNECTION_OPTION',0x0000004B)
    win_const_mgr.add_const('DRV_CONFIGURE',0x00000007)
    win_const_mgr.add_const('RSC_FLAG_INF',0x00000001)
    win_const_mgr.add_const('GET_MODULE_HANDLE_EX_FLAG_FROM_ADDRESS',0x00000004)
    win_const_mgr.add_const('CF_GDIOBJLAST',0x000003FF)
    win_const_mgr.add_const('CMS_DISABLEINTENT',0x00000400)
    win_const_mgr.add_const('JOB_CONTROL_SENT_TO_PRINTER',0x00000006)
    win_const_mgr.add_const('LINECALLCOMPLMODE_CALLBACK',0x00000002)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_MM_AV',0x0000000F)
    win_const_mgr.add_const('APPCOMMAND_REPLY_TO_MAIL',0x00000027)
    win_const_mgr.add_const('ERROR_DEV_NOT_EXIST',0x00000037)
    win_const_mgr.add_const('CRED_MAX_TARGETNAME_ATTRIBUTE_LENGTH',0x00000100)
    win_const_mgr.add_const('REG_HIVE_EXACT_FILE_GROWTH',0x00000080)
    win_const_mgr.add_const('TF_MOD_LSHIFT',0x00000100)
    win_const_mgr.add_const('FACILITY_NTDSB',0x00000800)
    win_const_mgr.add_const('STRINGFORMAT_BINARY',0x00000004)
    win_const_mgr.add_const('LINEDEVSTATE_OPEN',0x00000200)
    win_const_mgr.add_const('CONNECT_DEFERRED',0x00000400)
    win_const_mgr.add_const('GD_ICONCOMPONENT',0x00000003)
    win_const_mgr.add_const('DRIVE_REMOVABLE',0x00000002)
    win_const_mgr.add_const('DDSCL_ALLOWMODEX',0x00000040)
    win_const_mgr.add_const('BTH_MFG_SIGNIA',0x0000001B)
    win_const_mgr.add_const('IPSEC_CIPHER_CONFIG_CBC_AES_128',0x00000003)
    win_const_mgr.add_const('OPTION_COOKIE_SERVERS',0x00000008)
    win_const_mgr.add_const('LINEPROXYREQUEST_SETAGENTSESSIONSTATE',0x0000000E)
    win_const_mgr.add_const('MCI_DEVTYPE_ANIMATION',0x00000207)
    win_const_mgr.add_const('LVN_LAST',0x00000000)
    win_const_mgr.add_const('CM_DRP_CONFIGFLAGS',0x0000000B)
    win_const_mgr.add_const('MCHT_CALENDARCONTROL',0x00100000)
    win_const_mgr.add_const('BIND_ALL_IMAGES',0x00000004)
    win_const_mgr.add_const('FPSR_TD0',0x0000000C)
    win_const_mgr.add_const('FPSR_TD1',0x00000019)
    win_const_mgr.add_const('USER_AUTH_FLAGS_PARMNUM',0x0000000A)
    win_const_mgr.add_const('FPSR_TD3',0x00000033)
    win_const_mgr.add_const('ERROR_DS_AFFECTS_MULTIPLE_DSAS',0x00002039)
    win_const_mgr.add_const('USER_PASSWORD_NOT_REQUIRED',0x00000004)
    win_const_mgr.add_const('ENHANCED_KEY',0x00000100)
    win_const_mgr.add_const('STOPBITS_10',0x00000001)
    win_const_mgr.add_const('DDCAPS_OVERLAYSTRETCH',0x00004000)
    win_const_mgr.add_const('USE_IPC',0x00000003)
    win_const_mgr.add_const('CTRY_PANAMA',0x000001FB)
    win_const_mgr.add_const('DEBUG_REQUEST_TARGET_CAN_DETACH',0x00000008)
    win_const_mgr.add_const('CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_BYTE_COUNT_DEFAULT',0x000186A0)
    win_const_mgr.add_const('SSF_SHOWSUPERHIDDEN',0x00040000)
    win_const_mgr.add_const('INFINITE',0xFFFFFFFF)
    win_const_mgr.add_const('MDM_SHIFT_X75_DATA',0x00000000)
    win_const_mgr.add_const('TYMED_CALLBACK',0x00000080)
    win_const_mgr.add_const('IMAGE_REL_MIPS_JMPADDR16',0x00000010)
    win_const_mgr.add_const('NDIS_PACKET_TYPE_802_11_BROADCAST_MGMT',0x00040000)
    win_const_mgr.add_const('LOGON32_PROVIDER_WINNT35',0x00000001)
    win_const_mgr.add_const('MD_APPPOOL_IDENTITY_TYPE_NETWORKSERVICE',0x00000002)
    win_const_mgr.add_const('SQL_SR_SELECT_TABLE',0x00001000)
    win_const_mgr.add_const('HHWIN_PARAM_PROPERTIES',0x00000001)
    win_const_mgr.add_const('TMT_MINSIZE4',0x00000D4F)
    win_const_mgr.add_const('DBTF_NET',0x00000002)
    win_const_mgr.add_const('SSPROPVAL_USEPROCFORPREP_ON',0x00000001)
    win_const_mgr.add_const('LDAP_DIRSYNC_PUBLIC_DATA_ONLY',0x00002000)
    win_const_mgr.add_const('CSVER_MINOR_WHISTLER_BETA3',0x00000002)
    win_const_mgr.add_const('CSVER_MINOR_WHISTLER_BETA2',0x00000001)
    win_const_mgr.add_const('PFM_PAGEBREAKBEFORE',0x00080000)
    win_const_mgr.add_const('ERROR_MOD_NOT_FOUND',0x0000007E)
    win_const_mgr.add_const('DBT_LOW_DISK_SPACE',0x00000048)
    win_const_mgr.add_const('KEYEVENTF_KEYUP',0x00000002)
    win_const_mgr.add_const('D3D10_SRGB_TO_FLOAT_THRESHOLD',0x00000000)
    win_const_mgr.add_const('EVENT_SRCSPEW',0x00000064)
    win_const_mgr.add_const('ERROR_NETLOGON_NOT_STARTED',0x00000700)
    win_const_mgr.add_const('FRS_ERR_SYSVOL_DEMOTE',0x00001F50)
    win_const_mgr.add_const('ERROR_OPLOCK_BREAK_IN_PROGRESS',0x000002E6)
    win_const_mgr.add_const('USE_SPECIFIC_TRANSPORT',0x80000000)
    win_const_mgr.add_const('ERROR_I24_DISK_CHANGE',0x0000000D)
    win_const_mgr.add_const('RATING_THREE_STARS_MIN',0x00000026)
    win_const_mgr.add_const('EN_ALIGNLTR',0x00000710)
    win_const_mgr.add_const('SDP_ATTRIB_RECORD_HANDLE',0x00000000)
    win_const_mgr.add_const('SO_GROUP_PRIORITY',0x00002002)
    win_const_mgr.add_const('IF_TYPE_PLC',0x000000AE)
    win_const_mgr.add_const('IPX_INTERFACE_ANSI_NAME_LEN',0x00000030)
    win_const_mgr.add_const('IDM_OBJECT',0x00000879)
    win_const_mgr.add_const('RPC_S_CANT_CREATE_ENDPOINT',0x000006B8)
    win_const_mgr.add_const('SPI_GETMENUSHOWDELAY',0x0000006A)
    win_const_mgr.add_const('IPX_TRAFFIC_FILTER_ON_SRCSOCKET',0x00000004)
    win_const_mgr.add_const('IDD_CONVERTONLY4',0x00000450)
    win_const_mgr.add_const('DBT_DEVICEQUERYREMOVEFAILED',0x00008002)
    win_const_mgr.add_const('MD_APP_POOL_RECYCLE_PRIVATE_MEMORY',0x00000080)
    win_const_mgr.add_const('ERROR_SEEK',0x00000019)
    win_const_mgr.add_const('IMAGE_REL_SHM_REFHALF',0x00000015)
    win_const_mgr.add_const('TBS_COMMAND_PRIORITY_SYSTEM',0x00000190)
    win_const_mgr.add_const('CF_NULL',0x00000000)
    win_const_mgr.add_const('GESTURE_BRACKET_RIGHT',0x00000000)
    win_const_mgr.add_const('OID_FDDI_PORT_REQUESTED_PATHS',0x03030261)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH',0x0000363F)
    win_const_mgr.add_const('PRINTER_NOTIFY_FIELD_SECURITY_DESCRIPTOR',0x0000000C)
    win_const_mgr.add_const('ERROR_INVALID_PRINTER_NAME',0x00000709)
    win_const_mgr.add_const('TABLE_ROW_ADDED',0x00000003)
    win_const_mgr.add_const('IPX_SERV_TABLE',0x00000004)
    win_const_mgr.add_const('SQL_ROW_NUMBER',0x0000000E)
    win_const_mgr.add_const('WPF_ASYNCWINDOWPLACEMENT',0x00000004)
    win_const_mgr.add_const('ICW_ALREADYRUN',0x00000004)
    win_const_mgr.add_const('TCS_RIGHT',0x00000002)
    win_const_mgr.add_const('SUBLANG_LOWER_SORBIAN_GERMANY',0x00000002)
    win_const_mgr.add_const('DEBUG_SERVERS_PROCESS',0x00000002)
    win_const_mgr.add_const('MDM_V23_OVERRIDE',0x00000400)
    win_const_mgr.add_const('CR_PROP_POLICYDESCRIPTION',0x00000005)
    win_const_mgr.add_const('DWORD64_MAX',0x00000000)
    win_const_mgr.add_const('FACILITY_FILTER_MANAGER',0x0000001C)
    win_const_mgr.add_const('WMS_STREAM_MAX_PACKET_SIZE',0x00000004)
    win_const_mgr.add_const('SUBLANG_PORTUGUESE_BRAZILIAN',0x00000001)
    win_const_mgr.add_const('CERT_VALIDITY_CRL_OUT_OF_DATE',0x40000000)
    win_const_mgr.add_const('CLFS_MGMT_CLIENT_REGISTRATION_VERSION',0x00000001)
    win_const_mgr.add_const('HDF_SORTUP',0x00000400)
    win_const_mgr.add_const('TIMERR_NOERROR',0x00000000)
    win_const_mgr.add_const('TP_ELEMENT_MEMORY',0x00000001)
    win_const_mgr.add_const('LANG_ALSATIAN',0x00000084)
    win_const_mgr.add_const('TMT_HIGHLIGHT',0x0000064E)
    win_const_mgr.add_const('LINEEQOSINFO_GENERICERROR',0x00000004)
    win_const_mgr.add_const('ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN',0x00002143)
    win_const_mgr.add_const('VALIDATEUNC_PERSIST',0x00000008)
    win_const_mgr.add_const('WLX_DIRECTORY_LENGTH',0x00000100)
    win_const_mgr.add_const('FACILITY_PLA',0x00000030)
    win_const_mgr.add_const('MCS_MULTISELECT',0x00000002)
    win_const_mgr.add_const('UNDNAME_NO_LEADING_UNDERSCORES',0x00000001)
    win_const_mgr.add_const('WAVE_FORMAT_96M16',0x00040000)
    win_const_mgr.add_const('CRL_REASON_SUPERSEDED_FLAG',0x00000008)
    win_const_mgr.add_const('D3DCS_BOTTOM',0x00000008)
    win_const_mgr.add_const('BOE_RTLDIR',0x00000001)
    win_const_mgr.add_const('DEBUG_EINDEX_FROM_CURRENT',0x00000002)
    win_const_mgr.add_const('WSAEPROTONOSUPPORT',0x0000273B)
    win_const_mgr.add_const('SO_CONNOPTLEN',0x00007005)
    win_const_mgr.add_const('TBS_AUTOTICKS',0x00000001)
    win_const_mgr.add_const('DNS_ERROR_NO_ZONE_INFO',0x00002582)
    win_const_mgr.add_const('CERT_TRUST_IS_REVOKED',0x00000004)
    win_const_mgr.add_const('ERROR_MCA_EXCEPTION',0x00000310)
    win_const_mgr.add_const('PFM_NUMBERINGSTYLE',0x00002000)
    win_const_mgr.add_const('CMSG_MAX_LENGTH_FLAG',0x00000020)
    win_const_mgr.add_const('REG_NONE',0x00000000)
    win_const_mgr.add_const('DE_E_REDIRECT_FAILED',0x800C0014)
    win_const_mgr.add_const('ASC_RET_CONFIDENTIALITY',0x00000010)
    win_const_mgr.add_const('SCRIPTITEM_NOCODE',0x00000400)
    win_const_mgr.add_const('PAN_WEIGHT_THIN',0x00000004)
    win_const_mgr.add_const('LINEDISCONNECTMODE_BUSY',0x00000020)
    win_const_mgr.add_const('MFASYNC_CALLBACK_QUEUE_IO',0x00000003)
    win_const_mgr.add_const('IDM_IMGARTREWIND',0x000008E4)
    win_const_mgr.add_const('MDMEMBER_TYPE_REGULAR',0x00000001)
    win_const_mgr.add_const('NCBENUM',0x00000037)
    win_const_mgr.add_const('BTHNS_RESULT_DEVICE_REMEMBERED',0x00020000)
    win_const_mgr.add_const('MD_NOTIFY_ACCESS_DENIED',0x00000800)
    win_const_mgr.add_const('DUMP_POINTERS_VERSION_1',0x00000001)
    win_const_mgr.add_const('CM_ADD_ID_COMPATIBLE',0x00000001)
    win_const_mgr.add_const('PROGRESS_STOP',0x00000002)
    win_const_mgr.add_const('SQL_CA1_LOCK_UNLOCK',0x00000100)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_PROPAGATE_PULL',0x00008000)
    win_const_mgr.add_const('SUF_EXPRESS',0x00000002)
    win_const_mgr.add_const('MAPI_OLE_STATIC',0x00000002)
    win_const_mgr.add_const('LINEPROXYREQUEST_AGENTSPECIFIC',0x00000006)
    win_const_mgr.add_const('LOCALE_SMONTHNAME3',0x0000003A)
    win_const_mgr.add_const('LOCALE_SMONTHNAME2',0x00000039)
    win_const_mgr.add_const('LOCALE_SMONTHNAME1',0x00000038)
    win_const_mgr.add_const('CM_CDMASK_RESDES',0x00000002)
    win_const_mgr.add_const('LOCALE_SMONTHNAME7',0x0000003E)
    win_const_mgr.add_const('LOCALE_SMONTHNAME6',0x0000003D)
    win_const_mgr.add_const('LOCALE_SMONTHNAME5',0x0000003C)
    win_const_mgr.add_const('LOCALE_SMONTHNAME4',0x0000003B)
    win_const_mgr.add_const('SF_NOTIFY_END_OF_NET_SESSION',0x00000100)
    win_const_mgr.add_const('LOCALE_SMONTHNAME9',0x00000040)
    win_const_mgr.add_const('BG_E_BLOCKED_BY_POLICY',0x8020003E)
    win_const_mgr.add_const('HHWIN_PARAM_TB_FLAGS',0x00000001)
    win_const_mgr.add_const('CFU_UNDERLINEHAIRLINE',0x0000000A)
    win_const_mgr.add_const('TXTBIT_HIDESELECTION',0x00000020)
    win_const_mgr.add_const('WINHTTP_OPTION_MAX_HTTP_AUTOMATIC_REDIRECTS',0x00000059)
    win_const_mgr.add_const('ERROR_SXS_DUPLICATE_TLBID',0x000036C9)
    win_const_mgr.add_const('KRB_NT_ENTERPRISE_PRINCIPAL',0x0000000A)
    win_const_mgr.add_const('DEBUG_TBINFO_PRIORITY_CLASS',0x00000002)
    win_const_mgr.add_const('ERROR_UNABLE_TO_INVENTORY_TRANSPORT',0x000010E7)
    win_const_mgr.add_const('IMAGE_REL_ARM_TOKEN',0x00000005)
    win_const_mgr.add_const('DXGI_PRESENT_DO_NOT_SEQUENCE',0x00000002)
    win_const_mgr.add_const('IF_TYPE_H323_GATEKEEPER',0x000000A4)
    win_const_mgr.add_const('FCW_INTERNETBAR',0x00000006)
    win_const_mgr.add_const('LINEFEATURE_SETMEDIACONTROL',0x00000010)
    win_const_mgr.add_const('RPC_C_QOS_CAPABILITIES_MUTUAL_AUTH',0x00000001)
    win_const_mgr.add_const('ERROR_SXS_XML_E_MULTIPLEROOTS',0x000036E6)
    win_const_mgr.add_const('IMAGE_FILE_LARGE_ADDRESS_AWARE',0x00000020)
    win_const_mgr.add_const('LANG_LUXEMBOURGISH',0x00000006)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_PROTOCOL_RESTART_PARAMETERS',0x000000A3)
    win_const_mgr.add_const('ATTRIB_TRANSPARENCY',0x00000001)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_RECONFIG',0x00000005)
    win_const_mgr.add_const('MCI_DGV_LIST_VIDEO_STREAM',0x00004007)
    win_const_mgr.add_const('SHRINK_VOLUME_FLAG_FAIL_ON_BAD_CLUSTERS',0x00000001)
    win_const_mgr.add_const('ERROR_TOO_MANY_CONTEXT_IDS',0x00000568)
    win_const_mgr.add_const('OID_802_3_XMIT_HEARTBEAT_FAILURE',0x01020205)
    win_const_mgr.add_const('PAN_SERIF_PERP_SANS',0x0000000D)
    win_const_mgr.add_const('FIND_FORMAT',0x00000040)
    win_const_mgr.add_const('IME_PROP_COMPLETE_ON_UNSELECT',0x00100000)
    win_const_mgr.add_const('DBPROPVAL_IC_LOWER',0x00000002)
    win_const_mgr.add_const('DMPAPER_A5_ROTATED',0x0000004E)
    win_const_mgr.add_const('CI_STATE_MASTER_MERGE',0x00000002)
    win_const_mgr.add_const('ENABLE_POWER_MANAGEMENT',0x00000007)
    win_const_mgr.add_const('CBS_SORT',0x00000100)
    win_const_mgr.add_const('CFS_EXCLUDE',0x00000080)
    win_const_mgr.add_const('MF_MEDIATYPE_EQUAL_MAJOR_TYPES',0x00000001)
    win_const_mgr.add_const('UIA_E_INVALIDOPERATION',0x80131509)
    win_const_mgr.add_const('OID_FDDI_RING_MGT_STATE',0x03020106)
    win_const_mgr.add_const('BN_UNHILITE',0x00000003)
    win_const_mgr.add_const('SPOOL_FILE_TEMPORARY',0x00000002)
    win_const_mgr.add_const('SNMPAPI_OTHER_ERROR',0x00000063)
    win_const_mgr.add_const('BCRYPT_RSAPUBLIC_MAGIC',0x31415352)
    win_const_mgr.add_const('TIME_MIDI',0x00000010)
    win_const_mgr.add_const('INTERNET_OPTION_ORIGINAL_CONNECT_FLAGS',0x00000061)
    win_const_mgr.add_const('SHI2_NUM_ELEMENTS',0x0000000A)
    win_const_mgr.add_const('MDTREEOP_DESCENDANTS',0x00000010)
    win_const_mgr.add_const('AUDIO_MAX_FRAMERATE',0x0005DC00)
    win_const_mgr.add_const('JOY_RETURNZ',0x00000004)
    win_const_mgr.add_const('OLEMISC_NOUIACTIVATE',0x00004000)
    win_const_mgr.add_const('JOY_RETURNX',0x00000001)
    win_const_mgr.add_const('POLICY_ERRV_SUBNET_USER_SUM_FLOW_RATE',0x00000027)
    win_const_mgr.add_const('ISR_MBZ2_V',0x00000000)
    win_const_mgr.add_const('COLOR_BTNFACE',0x0000000F)
    win_const_mgr.add_const('CONTEXT_AMD64',0x00100000)
    win_const_mgr.add_const('JOY_RETURNR',0x00000008)
    win_const_mgr.add_const('DDCAPS_CANCLIPSTRETCHED',0x40000000)
    win_const_mgr.add_const('SQL_NOSCAN_ON',0x00000001)
    win_const_mgr.add_const('JOY_RETURNV',0x00000020)
    win_const_mgr.add_const('CSIDL_FLAG_CREATE',0x00008000)
    win_const_mgr.add_const('JOY_RETURNU',0x00000010)
    win_const_mgr.add_const('GESTURE_STAR',0x00000000)
    win_const_mgr.add_const('WINHTTP_DISABLE_REDIRECTS',0x00000002)
    win_const_mgr.add_const('IDD_WIZEXTN_FIRST',0x00005000)
    win_const_mgr.add_const('OCSP_BASIC_RESPONSE_V1',0x00000000)
    win_const_mgr.add_const('LOCALE_SNATIVECURRNAME',0x00001008)
    win_const_mgr.add_const('MPEG2_PROGRAM_PACK_HEADER',0x00000003)
    win_const_mgr.add_const('LDAP_PORT',0x00000185)
    win_const_mgr.add_const('MFOUTPUTATTRIBUTE_VIDEO',0x00000004)
    win_const_mgr.add_const('MCI_DEVTYPE_VIDEODISC',0x00000202)
    win_const_mgr.add_const('MAPI_GUARANTEE_FIFO',0x00000100)
    win_const_mgr.add_const('ERROR_MESSAGE_EXCEEDS_MAX_SIZE',0x000010F0)
    win_const_mgr.add_const('LINEERR_INVALLINESTATE',0x8000002C)
    win_const_mgr.add_const('CRYPTUI_DISABLE_EXPORT',0x00002000)
    win_const_mgr.add_const('DBPROPVAL_GU_NOTSUPPORTED',0x00000001)
    win_const_mgr.add_const('IPX_GETNETINFO',0x00004008)
    win_const_mgr.add_const('ERROR_DIFFERENT_SERVICE_ACCOUNT',0x00000437)
    win_const_mgr.add_const('SVSI_EDIT',0x00000003)
    win_const_mgr.add_const('MSIM_LIST_REVERSE',0x00000008)
    win_const_mgr.add_const('TXTLOG_CMI',0x10000000)
    win_const_mgr.add_const('RESOURCES_ALLOCATED',0x00000001)
    win_const_mgr.add_const('IDM_EXECPRINT',0x0000005D)
    win_const_mgr.add_const('CERT_KEY_AGREEMENT_KEY_USAGE',0x00000008)
    win_const_mgr.add_const('ASYNC_RECO_RESETCONTEXT_FAILED',0x00000010)
    win_const_mgr.add_const('ISR_X',0x00000020)
    win_const_mgr.add_const('FD_WRITE',0x00000001)
    win_const_mgr.add_const('MD_ERROR_SUB401_FILTER',0x00000004)
    win_const_mgr.add_const('SIO_GET_ATM_ADDRESS',0x00000000)
    win_const_mgr.add_const('DBPROPVAL_CU_PRIVILEGE_DEFINITION',0x00000008)
    win_const_mgr.add_const('DDOVER_OVERRIDEBOBWEAVE',0x00400000)
    win_const_mgr.add_const('EDITF_BASICCONSTRAINTSCA',0x00000080)
    win_const_mgr.add_const('ERROR_POINT_NOT_FOUND',0x00000493)
    win_const_mgr.add_const('ERROR_REGISTRY_IO_FAILED',0x000003F8)
    win_const_mgr.add_const('POLLRDNORM',0x00000100)
    win_const_mgr.add_const('IT_MSG_TERMINATION',0x00000004)
    win_const_mgr.add_const('EAP_I_USER_ACCOUNT_OTHER_ERROR',0x40420110)
    win_const_mgr.add_const('WLX_SAS_ACTION_RECONNECTED',0x0000000F)
    win_const_mgr.add_const('LOCALE_SSHORTESTDAYNAME7',0x00000066)
    win_const_mgr.add_const('META_FRAMEREGION',0x00000429)
    win_const_mgr.add_const('PTE_OWNER',0x00000007)
    win_const_mgr.add_const('IDD_CONVERT4',0x0000044F)
    win_const_mgr.add_const('IS_TEXT_UNICODE_REVERSE_MASK',0x000000F0)
    win_const_mgr.add_const('DSOBJECT_ISCONTAINER',0x00000001)
    win_const_mgr.add_const('DDCKEYCAPS_SRCOVERLAYCLRSPACEYUV',0x00008000)
    win_const_mgr.add_const('WSANOTINITIALISED',0x0000276D)
    win_const_mgr.add_const('ISR_MBZ2',0x0000002C)
    win_const_mgr.add_const('ERROR_HOST_DOWN',0x000004E8)
    win_const_mgr.add_const('STI_VERSION_REAL',0x00000002)
    win_const_mgr.add_const('ISR_MBZ1',0x00000028)
    win_const_mgr.add_const('ISC_RET_ALLOCATED_MEMORY',0x00000100)
    win_const_mgr.add_const('URLACTION_AUTOMATIC_DOWNLOAD_UI',0x00002200)
    win_const_mgr.add_const('SEE_MASK_UNICODE',0x00004000)
    win_const_mgr.add_const('MUTZ_IGNORE_ZONE_MAPPINGS',0x00004000)
    win_const_mgr.add_const('SYSTEM_AUDIT_OBJECT_ACE_TYPE',0x00000007)
    win_const_mgr.add_const('DBPROPVAL_RT_FREETHREAD',0x00000001)
    win_const_mgr.add_const('SV_OPLOCKBREAKRESPONSEWAIT_PARMNUM',0x00000217)
    win_const_mgr.add_const('ITIR_PS',0x00000002)
    win_const_mgr.add_const('WINHTTP_QUERY_CONNECTION',0x00000017)
    win_const_mgr.add_const('DEBUG_STATUS_WAIT_TIMEOUT',0x200000000)
    win_const_mgr.add_const('DEBUG_INTERRUPT_ACTIVE',0x00000000)
    win_const_mgr.add_const('SQL_CVT_WCHAR',0x00200000)
    win_const_mgr.add_const('LINEDISCONNECTMODE_CONGESTION',0x00000200)
    win_const_mgr.add_const('DEBUG_EXPR_MASM',0x00000000)
    win_const_mgr.add_const('META_CHORD',0x00000830)
    win_const_mgr.add_const('MDDISPINFO_PARENT_SAME_AS_PREV',0x00020000)
    win_const_mgr.add_const('OID_FDDI_SMT_MASTER_CT',0x0303020A)
    win_const_mgr.add_const('IDC_PS_ICONDISPLAY',0x000001FB)
    win_const_mgr.add_const('MFASYNC_FAST_IO_PROCESSING_CALLBACK',0x00000001)
    win_const_mgr.add_const('PORT_SNET',0x000000A6)
    win_const_mgr.add_const('TMT_BODYFONT',0x00000329)
    win_const_mgr.add_const('ERROR_LOG_FULL',0x000019E4)
    win_const_mgr.add_const('PRINTER_NOTIFY_FIELD_PORT_NAME',0x00000003)
    win_const_mgr.add_const('COD_MAJOR_LAN_ACCESS',0x00000003)
    win_const_mgr.add_const('SYMFLAG_TLSREL',0x00004000)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_TRANSITION_BOW_TIE',0x0000000B)
    win_const_mgr.add_const('IN_CLASSA_NSHIFT',0x00000018)
    win_const_mgr.add_const('CPL_SETUP',0x000000C8)
    win_const_mgr.add_const('DC_FIELDS',0x00000001)
    win_const_mgr.add_const('AD_COUNTERCLOCKWISE',0x00000001)
    win_const_mgr.add_const('CF_HIDECHANGEICON',0x00000080)
    win_const_mgr.add_const('JOB_CONTROL_RESTART',0x00000004)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_NSI_NETWORK_RW_STRUCT',0x000000AC)
    win_const_mgr.add_const('IF_TYPE_PARA',0x00000022)
    win_const_mgr.add_const('CM_LOCATE_DEVNODE_CANCELREMOVE',0x00000002)
    win_const_mgr.add_const('CMSG_HASHED_DATA_V0',0x00000000)
    win_const_mgr.add_const('PS1',0x00000002)
    win_const_mgr.add_const('NS_BTH',0x00000010)
    win_const_mgr.add_const('ERROR_SXS_CORRUPT_ACTIVATION_STACK',0x00003702)
    win_const_mgr.add_const('CHANNEL_RC_NO_BUFFER',0x00000008)
    win_const_mgr.add_const('LINEPROXYREQUEST_GETAGENTCAPS',0x00000004)
    win_const_mgr.add_const('DEBUG_SCOPE_GROUP_LOCALS',0x00000002)
    win_const_mgr.add_const('D3DCLEAR_STENCIL',0x00000004)
    win_const_mgr.add_const('MKF_MODIFIERS',0x00000040)
    win_const_mgr.add_const('TAPE_DRIVE_EJECT_MEDIA',0x01000000)
    win_const_mgr.add_const('GESTURE_SWAP',0x00000000)
    win_const_mgr.add_const('RASLCPAD_CHAP_MSV2',0x00000081)
    win_const_mgr.add_const('HCI_CONNNECTION_TYPE_ACL',0x00000001)
    win_const_mgr.add_const('GDT_NONE',0x00000001)
    win_const_mgr.add_const('OID_WAN_LINE_COUNT',0x0401010A)
    win_const_mgr.add_const('CF_SETCONVERTDEFAULT',0x00000002)
    win_const_mgr.add_const('DISKQUOTA_STATE_ENFORCE',0x00000002)
    win_const_mgr.add_const('DI_FLAGSEX_RECURSIVESEARCH',0x40000000)
    win_const_mgr.add_const('PS5',0x00000020)
    win_const_mgr.add_const('WSAENOTSOCK',0x00002736)
    win_const_mgr.add_const('IPX_SERVICE_FILTER_DENY',0x00000002)
    win_const_mgr.add_const('WIA_DPC_CAPTURE_DELAY',0x00000822)
    win_const_mgr.add_const('XACT_S_LAST',0x0004D010)
    win_const_mgr.add_const('INTERNET_OPTION_SEND_UTF8_SERVERNAME_TO_PROXY',0x00000058)
    win_const_mgr.add_const('META_SELECTOBJECT',0x0000012D)
    win_const_mgr.add_const('SQL_CONVERT_GUID',0x000000AD)
    win_const_mgr.add_const('PFD_OVERLAY_PLANE',0x00000001)
    win_const_mgr.add_const('TC_RA_ABLE',0x00002000)
    win_const_mgr.add_const('HH_DISPLAY_TOPIC',0x00000000)
    win_const_mgr.add_const('MSV1_0_SUBAUTHENTICATION_DLL_IIS',0x00000084)
    win_const_mgr.add_const('SPFILEQ_FILE_IN_USE',0x00000001)
    win_const_mgr.add_const('DBIMF_VARIABLEHEIGHT',0x00000008)
    win_const_mgr.add_const('FR_RAW',0x00020000)
    win_const_mgr.add_const('MDM_AUTO_ML_DEFAULT',0x00000000)
    win_const_mgr.add_const('TC_NOTIFY_PARAM_CHANGED',0x00000004)
    win_const_mgr.add_const('DISPID_TABLEPARAMS_TABLEATTRS',0x00000003)
    win_const_mgr.add_const('SCH_CRED_MAX_SUPPORTED_ALGS',0x00000100)
    win_const_mgr.add_const('INTERNET_OPTION_CONNECT_TIME',0x00000037)
    win_const_mgr.add_const('WPF_SHOWPAGE_DESTSITE',0x00040000)
    win_const_mgr.add_const('ACM_DRIVERENUMF_NOLOCAL',0x40000000)
    win_const_mgr.add_const('MDM_FORCED_EC',0x00000004)
    win_const_mgr.add_const('FLASHMODE_REDEYE_FILL',0x00000005)
    win_const_mgr.add_const('SUBLANG_CROATIAN_CROATIA',0x00000001)
    win_const_mgr.add_const('VK_LMENU',0x000000A4)
    win_const_mgr.add_const('CERT_STORE_ADD_NEWER',0x00000006)
    win_const_mgr.add_const('MXDC_ESCAPE',0x0000101A)
    win_const_mgr.add_const('LANG_TAMAZIGHT',0x00000005)
    win_const_mgr.add_const('FILE_ATTRIBUTE_COMPRESSED',0x00000800)
    win_const_mgr.add_const('DNS_ERROR_DNAME_COLLISION',0x000025F9)
    win_const_mgr.add_const('PORT_HOSTNAME',0x00000065)
    win_const_mgr.add_const('SV_SCAVQOSINFOUPDATETIME_PARMNUM',0x0000022B)
    win_const_mgr.add_const('DISPID_IDISCRECORDER2_INITIALIZEDISCRECORDER',0x00000106)
    win_const_mgr.add_const('APPNAMEBUFFERLEN',0x00000028)
    win_const_mgr.add_const('BG_E_INSUFFICIENT_RANGE_SUPPORT',0x80200013)
    win_const_mgr.add_const('LOCALE_SLANGUAGE',0x00000002)
    win_const_mgr.add_const('RPC_IF_ALLOW_CALLBACKS_WITH_NO_AUTH',0x00000010)
    win_const_mgr.add_const('WIA_IPC_THUMB_WIDTH',0x00001403)
    win_const_mgr.add_const('TMSUCCESS',0x04000000)
    win_const_mgr.add_const('MCI_INFO_COPYRIGHT',0x00002000)
    win_const_mgr.add_const('AM_AC3_SERVICE_NO_DIALOG',0x00000001)
    win_const_mgr.add_const('LIS_VISITED',0x00000004)
    win_const_mgr.add_const('SERVICE_PAUSABLE',0x00000020)
    win_const_mgr.add_const('TMT_GLYPHIMAGEFILE',0x00000BC0)
    win_const_mgr.add_const('ERROR_INSTALL_USEREXIT',0x00000642)
    win_const_mgr.add_const('SUBLANG_NEPALI_NEPAL',0x00000001)
    win_const_mgr.add_const('DDFXCAPS_BLTMIRRORLEFTRIGHT',0x00000040)
    win_const_mgr.add_const('WMDM_RIGHTS_COPY_TO_NON_SDMI_DEVICE',0x00000002)
    win_const_mgr.add_const('SQL_DTC_ENLIST_EXPENSIVE',0x00000001)
    win_const_mgr.add_const('SET_FEATURE_IN_REGISTRY',0x00000004)
    win_const_mgr.add_const('BATTERY_CLASS_MINOR_VERSION',0x00000000)
    win_const_mgr.add_const('MCI_DGV_SETAUDIO_RECORD',0x00100000)
    win_const_mgr.add_const('CRYPT_GET_URL_FROM_EXTENSION',0x00000002)
    win_const_mgr.add_const('APPLY_OPTION_FAIL_IF_EXACT',0x00000001)
    win_const_mgr.add_const('INTERNET_FLAG_CACHE_ASYNC',0x00000080)
    win_const_mgr.add_const('DDCKEYCAPS_DESTOVERLAYCLRSPACE',0x00000020)
    win_const_mgr.add_const('TRUST_ATTRIBUTE_TRUST_USES_RC4_ENCRYPTION',0x00000080)
    win_const_mgr.add_const('DTM_FIRST',0x00001000)
    win_const_mgr.add_const('EAP_E_EAPHOST_XML_MALFORMED',0x80420019)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_SOFTWARE_UPDATE_UNINSTALL',0x00000014)
    win_const_mgr.add_const('SMSET_DONTOWN',0x00000001)
    win_const_mgr.add_const('KAGPROP_TIMEDATEFUNCTIONS',0x00000016)
    win_const_mgr.add_const('MCI_DGV_LIST_VIDEO_QUALITY',0x00004006)
    win_const_mgr.add_const('PP_SGC_INFO',0x00000025)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_SECURITY',0x00000010)
    win_const_mgr.add_const('ERR_INVALID_SOURCE_NAME',0xE0000009)
    win_const_mgr.add_const('ERROR_VOLUME_MOUNTED',0x000002E7)
    win_const_mgr.add_const('LINEERR_INVALTONE',0x8000003C)
    win_const_mgr.add_const('WM_MDICASCADE',0x00000227)
    win_const_mgr.add_const('PSINJECT_ENDSTREAM',0x00000014)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW3_CLIPBOARDDATA',0x00000497)
    win_const_mgr.add_const('SI_RESET_DACL',0x00040000)
    win_const_mgr.add_const('MM_HIMETRIC',0x00000003)
    win_const_mgr.add_const('FD_ACCEPT',0x00000001)
    win_const_mgr.add_const('SORT_JAPANESE_XJIS',0x00000000)
    win_const_mgr.add_const('SQL_DIAG_NATIVE',0x00000005)
    win_const_mgr.add_const('MCI_FORMAT_SMPTE_30DROP',0x00000007)
    win_const_mgr.add_const('ERROR_MORE_DATA',0x000000EA)
    win_const_mgr.add_const('PSR_MBZ4',0x00000000)
    win_const_mgr.add_const('CSC_MASK',0x00000030)
    win_const_mgr.add_const('D3DUSAGE_AUTOGENMIPMAP',0x00000400)
    win_const_mgr.add_const('IDM_TRIED_SET_ALIGNMENT',0x00000003)
    win_const_mgr.add_const('RELATIVE',0x00000002)
    win_const_mgr.add_const('D3DPMISCCAPS_NULLREFERENCE',0x00001000)
    win_const_mgr.add_const('DDOVERZ_INSERTINFRONTOF',0x00000004)
    win_const_mgr.add_const('PRINTER_DRIVER_PACKAGE_AWARE',0x00000001)
    win_const_mgr.add_const('DSDSOF_DONTSIGNSEAL',0x00000004)
    win_const_mgr.add_const('PAN_STROKE_GRADUAL_VERT',0x00000004)
    win_const_mgr.add_const('PHOTOACQ_DISABLE_SETTINGS_LINK',0x00000400)
    win_const_mgr.add_const('TVHT_ONITEMINDENT',0x00000008)
    win_const_mgr.add_const('MK_S_LAST',0x000401EF)
    win_const_mgr.add_const('GESTURE_DIGIT_6',0x00000000)
    win_const_mgr.add_const('IDC_PU_CONVERT',0x00000386)
    win_const_mgr.add_const('CDO_E_CONTENTPROPXML_WRONG_CHARSET',0x8004022E)
    win_const_mgr.add_const('CTRY_ARGENTINA',0x00000036)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_IO_WRITE_INIT',0x0000000D)
    win_const_mgr.add_const('GENERATE_METHOD_PREFIX',0x00000001)
    win_const_mgr.add_const('DISPID_WINDOWRESIZE',0x0000006E)
    win_const_mgr.add_const('DNS_TYPE_AXFR',0x00000000)
    win_const_mgr.add_const('DEBUG_OUTCTL_IGNORE',0x00000003)
    win_const_mgr.add_const('HELPINFO_MENUITEM',0x00000002)
    win_const_mgr.add_const('ASC_RET_DATAGRAM',0x00000400)
    win_const_mgr.add_const('VIDEO_CONFIGURE_MAX',0x00000080)
    win_const_mgr.add_const('IDC_LP_TIME',0x000003FB)
    win_const_mgr.add_const('MDPROPVAL_MNF_COVARIANCE',0x00000020)
    win_const_mgr.add_const('MDM_HDLCPPP_AUTH_MSCHAP',0x00000004)
    win_const_mgr.add_const('MD_GLOBAL_SESSIONKEY',0x0000270F)
    win_const_mgr.add_const('OS_ADVSERVER',0x00000016)
    win_const_mgr.add_const('SFGAO_ENCRYPTED',0x00002000)
    win_const_mgr.add_const('WINHTTP_QUERY_CONTENT_LENGTH',0x00000005)
    win_const_mgr.add_const('SERVICE_CONTROL_POWEREVENT',0x0000000D)
    win_const_mgr.add_const('SND_PURGE',0x00000040)
    win_const_mgr.add_const('SPI_GETCOMBOBOXANIMATION',0x00001004)
    win_const_mgr.add_const('IDM_PAGEBREAK',0x00000881)
    win_const_mgr.add_const('IO_COMPLETION_MODIFY_STATE',0x00000002)
    win_const_mgr.add_const('BASIC_CONSTRAINTS_CERT_CHAIN_POLICY_CA_FLAG',0x80000000)
    win_const_mgr.add_const('ADS_PRINTER_ERROR',0x00000003)
    win_const_mgr.add_const('CACHE_ENTRY_TYPE_FC',0x00001000)
    win_const_mgr.add_const('ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS',0x000013CB)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_MM_GPF',0x0000000D)
    win_const_mgr.add_const('PID_IS_HOTKEY',0x00000006)
    win_const_mgr.add_const('EMR_RESERVED_119',0x00000077)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_NON_CACHEABLE_PRINCIPALS_GROUP',0x0000023C)
    win_const_mgr.add_const('ERROR_DS_BACKLINK_WITHOUT_LINK',0x00002122)
    win_const_mgr.add_const('E_FILTER_MULTIPLETAGS',0x80100004)
    win_const_mgr.add_const('EMR_RESERVED_110',0x0000006E)
    win_const_mgr.add_const('CDO_E_FROM_MISSING',0x8004020D)
    win_const_mgr.add_const('WININET_API_FLAG_USE_CONTEXT',0x00000008)
    win_const_mgr.add_const('CSVER_MINOR_LONGHORN_BETA1',0x00000001)
    win_const_mgr.add_const('AUTH_FLAG_DISABLE_NEGOTIATE',0x00000001)
    win_const_mgr.add_const('MCI_VCR_UNFREEZE_INPUT',0x00010000)
    win_const_mgr.add_const('SNMP_OUTPUT_TO_CONSOLE',0x00000001)
    win_const_mgr.add_const('KSSTREAM_HEADER_OPTIONSF_BUFFEREDTRANSFER',0x00000400)
    win_const_mgr.add_const('SPI_SETPENWINDOWS',0x00000031)
    win_const_mgr.add_const('ERROR_SESSION_CREDENTIAL_CONFLICT',0x000004C3)
    win_const_mgr.add_const('NCBASTAT',0x00000033)
    win_const_mgr.add_const('SNMPAPI_OID_INVALID',0x00000009)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_OFFLOAD_ENCAPSULATION',0x000000A8)
    win_const_mgr.add_const('SQL_FN_NUM_SIN',0x00002000)
    win_const_mgr.add_const('SHPWHF_NORECOMPRESS',0x00000001)
    win_const_mgr.add_const('BL_24M',0x01800000)
    win_const_mgr.add_const('SAC_CERT_V1',0x00000002)
    win_const_mgr.add_const('SPDRP_DEVICE_POWER_DATA',0x0000001E)
    win_const_mgr.add_const('PSD_RETURNDEFAULT',0x00000400)
    win_const_mgr.add_const('IME_HOTKEY_DSWITCH_LAST',0x0000011F)
    win_const_mgr.add_const('CC_ENABLEHOOK',0x00000010)
    win_const_mgr.add_const('MAXNUMERICLEN',0x00000010)
    win_const_mgr.add_const('DT_BOTTOM',0x00000008)
    win_const_mgr.add_const('CERT_STORE_CRL_CONTEXT',0x00000002)
    win_const_mgr.add_const('NDR64_FC_AUTO_HANDLE',0x00000003)
    win_const_mgr.add_const('DB_INVALID_HACCESSOR',0x00000000)
    win_const_mgr.add_const('BLLI_L2_HDLC_ARM',0x00000009)
    win_const_mgr.add_const('UNSUPPORTED_CREDENTIAL_TYPE',0x00000002)
    win_const_mgr.add_const('PROV_STT_BRND',0x00000009)
    win_const_mgr.add_const('PKR_MBZ1',0x00000020)
    win_const_mgr.add_const('PKR_MBZ0',0x00000004)
    win_const_mgr.add_const('OFN_ENABLEHOOK',0x00000020)
    win_const_mgr.add_const('REQDISP_ISSUE',0x00000001)
    win_const_mgr.add_const('ISFBVIEWMODE_SMALLICONS',0x00000001)
    win_const_mgr.add_const('FILE_WRITE_DATA',0x00000002)
    win_const_mgr.add_const('D3DUSAGE_RTPATCHES',0x00000080)
    win_const_mgr.add_const('HTTP_LOG_FIELD_USER_NAME',0x00000008)
    win_const_mgr.add_const('ADMINDATA_MAX_NAME_LEN',0x00000100)
    win_const_mgr.add_const('MCI_STATUS_POSITION',0x00000002)
    win_const_mgr.add_const('EVCF_OUTOFDISKSPACE',0x00000040)
    win_const_mgr.add_const('DNS_UPDATE_RESERVED',0x00000000)
    win_const_mgr.add_const('USER_MD_ID_BASE_RESERVED',0x00000000)
    win_const_mgr.add_const('BT_PORT_DYN_FIRST',0x00001001)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_INVALID_SITUATION',0x00003627)
    win_const_mgr.add_const('EMR_SETLAYOUT',0x00000073)
    win_const_mgr.add_const('HTTP_QUERY_IF_UNMODIFIED_SINCE',0x0000003B)
    win_const_mgr.add_const('CREDUIWIN_AUTHPACKAGE_ONLY',0x00000010)
    win_const_mgr.add_const('WINHTTP_QUERY_UPGRADE',0x00000040)
    win_const_mgr.add_const('SQL_INFO_DRIVER_START',0x000003E8)
    win_const_mgr.add_const('ILMM_IE4',0x00000000)
    win_const_mgr.add_const('DEBUG_EVENT_CREATE_THREAD',0x00000004)
    win_const_mgr.add_const('FWPS_CLASSIFY_OUT_FLAG_ABSORB',0x00000001)
    win_const_mgr.add_const('ERROR_BAD_NET_RESP',0x0000003A)
    win_const_mgr.add_const('IP_STATUS_BASE',0x00002AF8)
    win_const_mgr.add_const('OID_FDDI_IF_SPEED',0x0303027C)
    win_const_mgr.add_const('BATTERY_FLAG_NO_BATTERY',0x00000080)
    win_const_mgr.add_const('MCI_DGV_STATUS_FILE_MODE',0x00000401)
    win_const_mgr.add_const('TMT_RESERVEDHIGH',0x00001F3F)
    win_const_mgr.add_const('CERT_LOGOTYPE_DIRECT_INFO_CHOICE',0x00000001)
    win_const_mgr.add_const('OR_INVALID_OXID',0x00000776)
    win_const_mgr.add_const('EC_WINDOW_DESTROYED',0x00000015)
    win_const_mgr.add_const('ERROR_DS_LINK_ID_NOT_AVAILABLE',0x00002181)
    win_const_mgr.add_const('ERROR_INVALID_MESSAGEDEST',0x000004C2)
    win_const_mgr.add_const('ERROR_NOT_A_REPARSE_POINT',0x00001126)
    win_const_mgr.add_const('OFN_LONGNAMES',0x00200000)
    win_const_mgr.add_const('PF_FLOATING_POINT_PRECISION_ERRATA',0x00000000)
    win_const_mgr.add_const('CM_OUT_OF_GAMUT',0x000000FF)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_PROCESS_ERR_DELETE',0x00003611)
    win_const_mgr.add_const('EMR_PIE',0x0000002F)
    win_const_mgr.add_const('IGIMII_CONFIGURE',0x00000004)
    win_const_mgr.add_const('SUBLANG_MALAY_BRUNEI_DARUSSALAM',0x00000002)
    win_const_mgr.add_const('ERROR_NOT_CONTAINER',0x000004B7)
    win_const_mgr.add_const('LINETERMMODE_LAMPS',0x00000002)
    win_const_mgr.add_const('D3DPTADDRESSCAPS_WRAP',0x00000001)
    win_const_mgr.add_const('TRUST_ATTRIBUTES_VALID',0xFF03FFFF)
    win_const_mgr.add_const('GCP_KASHIDA',0x00000400)
    win_const_mgr.add_const('BIND_CACHE_IMPORT_DLLS',0x00000008)
    win_const_mgr.add_const('SECPKG_INTERFACE_VERSION_3',0x00040000)
    win_const_mgr.add_const('EAP_I_USER_FIRST',0x40420100)
    win_const_mgr.add_const('DNS_RCODE_NOTIMPL',0x00000004)
    win_const_mgr.add_const('SECPKG_INTERFACE_VERSION_4',0x00080000)
    win_const_mgr.add_const('PORT_PWDGEN',0x00000081)
    win_const_mgr.add_const('TVS_SHOWSELALWAYS',0x00000020)
    win_const_mgr.add_const('MCI_VCR_STATUS_AUDIO_SOURCE',0x00004006)
    win_const_mgr.add_const('WMDM_STATUS_STORAGE_NOTSUPPORTED',0x00000800)
    win_const_mgr.add_const('ILD_ASYNC',0x00008000)
    win_const_mgr.add_const('IF_TYPE_E1',0x00000013)
    win_const_mgr.add_const('DEBUG_HANDLE_DATA_TYPE_MINI_MUTANT_1',0x00000007)
    win_const_mgr.add_const('GPO_OPTION_DISABLE_MACHINE',0x00000002)
    win_const_mgr.add_const('DEBUG_HANDLE_DATA_TYPE_MINI_MUTANT_2',0x00000008)
    win_const_mgr.add_const('MOUSEEVENTF_RIGHTUP',0x00000010)
    win_const_mgr.add_const('PP_USE_HARDWARE_RNG',0x00000026)
    win_const_mgr.add_const('ETW_SBYTE_TYPE_VALUE',0x00000003)
    win_const_mgr.add_const('GESTURE_DOUBLE_RIGHT',0x00000000)
    win_const_mgr.add_const('HCI_CONNNECTION_TYPE_SCO',0x00000002)
    win_const_mgr.add_const('JOY_RETURNPOV',0x00000040)
    win_const_mgr.add_const('PSR_IA',0x0000002D)
    win_const_mgr.add_const('LINEERR_INVALGROUPID',0x8000002A)
    win_const_mgr.add_const('TBMF_BARPAD',0x00000002)
    win_const_mgr.add_const('VK_ICO_00',0x000000E4)
    win_const_mgr.add_const('DCI_OK',0x00000000)
    win_const_mgr.add_const('LCPRI_HARDWIRED',0x0000E000)
    win_const_mgr.add_const('TF_IPP_CAPS_WOW16SUPPORT',0x00000010)
    win_const_mgr.add_const('BLLI_L2_X25M',0x00000007)
    win_const_mgr.add_const('TBIF_DEFAULT',0x00000000)
    win_const_mgr.add_const('D3D10_DEFAULT_MAX_ANISOTROPY',0x00000010)
    win_const_mgr.add_const('HCCC_PROTOCOL_UUID16',0x00000012)
    win_const_mgr.add_const('PROFILE_USER',0x10000000)
    win_const_mgr.add_const('IMAGE_DEBUG_TYPE_MISC',0x00000004)
    win_const_mgr.add_const('CDO_E_NOT_ASSIGNEDTO_USER',0x80040238)
    win_const_mgr.add_const('UNRECOVERED_WRITES_VALID',0x00000002)
    win_const_mgr.add_const('DDLOCK_DONOTWAIT',0x00004000)
    win_const_mgr.add_const('D3DPTEXTURECAPS_ALPHA',0x00000004)
    win_const_mgr.add_const('REG_DWORD',0x00000004)
    win_const_mgr.add_const('MD_PASSPORT_TRY_MAPPING',0x00000001)
    win_const_mgr.add_const('ERROR_LAST_ADMIN',0x0000052A)
    win_const_mgr.add_const('ERROR_NO_TXF_METADATA',0x00001AA0)
    win_const_mgr.add_const('IDLE_PRIORITY_CLASS',0x00000040)
    win_const_mgr.add_const('TAPE_DRIVE_ERASE_BOP_ONLY',0x00000040)
    win_const_mgr.add_const('WSAEDISCON',0x00002775)
    win_const_mgr.add_const('SNMP_TRAP_COLDSTART',0x00000000)
    win_const_mgr.add_const('ERROR_SERVICE_SPECIFIC_ERROR',0x0000042A)
    win_const_mgr.add_const('IKEEXT_CERT_FLAG_INTERMEDIATE_CA',0x00000008)
    win_const_mgr.add_const('LINETERMDEV_SPEAKER',0x00000004)
    win_const_mgr.add_const('WM_LBUTTONDOWN',0x00000201)
    win_const_mgr.add_const('ERROR_DS_DUP_MSDS_INTID',0x00002195)
    win_const_mgr.add_const('SHERB_NOSOUND',0x00000004)
    win_const_mgr.add_const('FACILITY_SYSTEM',0x00000000)
    win_const_mgr.add_const('GROUP_COMMENT_PARMNUM',0x00000002)
    win_const_mgr.add_const('HH_SET_INFO_TYPE',0x00000008)
    win_const_mgr.add_const('DTN_FIRST',0x00000000)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_OBJECT_ACTIONS',0x00000001)
    win_const_mgr.add_const('PDH_CSTATUS_BAD_COUNTERNAME',0xC0000BC0)
    win_const_mgr.add_const('SPSVCINST_NOCLOBBER_LOADORDERGROUP',0x00000040)
    win_const_mgr.add_const('SDP_ATTRIB_PROTOCOL_DESCRIPTOR_LIST',0x00000004)
    win_const_mgr.add_const('VFT_VXD',0x00000005)
    win_const_mgr.add_const('IPSEC_SA_BUNDLE_FLAG_GUARANTEE_ENCRYPTION',0x00000008)
    win_const_mgr.add_const('SQL_DP_ON',0x00000001)
    win_const_mgr.add_const('IDD_CHANGEICON',0x000003E9)
    win_const_mgr.add_const('TAPE_DRIVE_ABS_BLK_IMMED',0x80002000)
    win_const_mgr.add_const('MDAXIS_COLUMNS',0x00000000)
    win_const_mgr.add_const('TVSI_NOSINGLEEXPAND',0x00008000)
    win_const_mgr.add_const('DPD_DELETE_SPECIFIC_VERSION',0x00000002)
    win_const_mgr.add_const('PDERR_LOADDRVFAILURE',0x00001004)
    win_const_mgr.add_const('RC_BIGFONT',0x00000400)
    win_const_mgr.add_const('LINEERR_INVALCOMPLETIONID',0x8000001F)
    win_const_mgr.add_const('SPCRP_CHARACTERISTICS',0x0000001B)
    win_const_mgr.add_const('BS_INDEXED',0x00000004)
    win_const_mgr.add_const('LVGGR_LABEL',0x00000002)
    win_const_mgr.add_const('D3DSP_REGTYPE_MASK2',0x00001800)
    win_const_mgr.add_const('SN_CMP_SIGONLY',0x00000002)
    win_const_mgr.add_const('LP_MONOCHROME',0x00000001)
    win_const_mgr.add_const('WMDM_E_MAC_CHECK_FAILED',0x8004500A)
    win_const_mgr.add_const('LOCALE_SCURRENCY',0x00000014)
    win_const_mgr.add_const('LDAP_DEREF_SEARCHING',0x00000001)
    win_const_mgr.add_const('SFGAO_DROPTARGET',0x00000100)
    win_const_mgr.add_const('MAPI_MULTITHREAD_NOTIFICATIONS',0x00000001)
    win_const_mgr.add_const('STRING_DESCRIPTION_OFFSET',0x00000001)
    win_const_mgr.add_const('ERROR_NOT_SNAPSHOT_VOLUME',0x00001AB9)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_NO_POLICY',0x00003601)
    win_const_mgr.add_const('HDI_ORDER',0x00000080)
    win_const_mgr.add_const('OS_EMBEDDED',0x0000000D)
    win_const_mgr.add_const('SERVICE_INSTALL_STATE',0x00000003)
    win_const_mgr.add_const('ERROR_REQUEST_ABORTED',0x000004D3)
    win_const_mgr.add_const('CERT_STORE_READONLY_FLAG',0x00008000)
    win_const_mgr.add_const('PAN_WEIGHT_NORD',0x0000000B)
    win_const_mgr.add_const('EC_ERROR_STILLPLAYING',0x00000008)
    win_const_mgr.add_const('IO_REPARSE_TAG_DFSR',0x80000012)
    win_const_mgr.add_const('MIXER_SHORT_NAME_CHARS',0x00000010)
    win_const_mgr.add_const('WPF_RESTORETOMAXIMIZED',0x00000002)
    win_const_mgr.add_const('SECPKG_ATTR_CREDS',0x80000080)
    win_const_mgr.add_const('LMEM_FIXED',0x00000000)
    win_const_mgr.add_const('SECURITY_VALID_SQOS_FLAGS',0x001F0000)
    win_const_mgr.add_const('XA_RBBASE',0x00000064)
    win_const_mgr.add_const('MSG_TRUNC',0x00000100)
    win_const_mgr.add_const('SE_ADT_OBJECT_ONLY',0x00000001)
    win_const_mgr.add_const('DFM_MERGECONTEXTMENU',0x00000001)
    win_const_mgr.add_const('IDM_TOOLBOX',0x0000002A)
    win_const_mgr.add_const('BCRYPT_KEY_DATA_BLOB_VERSION1',0x00000001)
    win_const_mgr.add_const('WGL_SWAP_UNDERLAY1',0x00010000)
    win_const_mgr.add_const('CRYPTDLG_ACTION_MASK',0xFFFF0000)
    win_const_mgr.add_const('MCI_ANIM_WINDOW_HWND',0x00010000)
    win_const_mgr.add_const('MF_MEDIATYPE_EQUAL_FORMAT_DATA',0x00000004)
    win_const_mgr.add_const('USE_REMOTE_PARMNUM',0x00000002)
    win_const_mgr.add_const('CF_PALETTE',0x00000009)
    win_const_mgr.add_const('PBT_APMRESUMESTANDBY',0x00000008)
    win_const_mgr.add_const('DDOVER_AUTOFLIP',0x00100000)
    win_const_mgr.add_const('PIDVSI_DATA_RATE',0x00000008)
    win_const_mgr.add_const('OID_GEN_MACHINE_NAME',0x0001021A)
    win_const_mgr.add_const('SUCCESSFUL_ACCESS_ACE_FLAG',0x00000040)
    win_const_mgr.add_const('CERT_STORE_ADD_NEWER_INHERIT_PROPERTIES',0x00000007)
    win_const_mgr.add_const('WLX_DESKTOP_HANDLE',0x00000002)
    win_const_mgr.add_const('RP_DSN_SENT_RELAYED',0x00010040)
    win_const_mgr.add_const('CHANGER_LOCK_UNLOCK',0x00000080)
    win_const_mgr.add_const('LINEAGENTSTATE_BUSYOTHER',0x00000040)
    win_const_mgr.add_const('ERROR_PARTITION_FAILURE',0x00000451)
    win_const_mgr.add_const('EMR_WIDENPATH',0x00000042)
    win_const_mgr.add_const('V86FLAGS_ALIGNMENT',0x00040000)
    win_const_mgr.add_const('SMDM_HMENU',0x00000002)
    win_const_mgr.add_const('SORT_CHINESE_PRC',0x00000002)
    win_const_mgr.add_const('CERT_PROT_ROOT_INHIBIT_ADD_AT_INIT_FLAG',0x00000002)
    win_const_mgr.add_const('SSRVOPT_PROXYW',0x00040000)
    win_const_mgr.add_const('OCSP_BASIC_BY_KEY_RESPONDER_ID',0x00000002)
    win_const_mgr.add_const('WIA_PAGE_A4',0x00000000)
    win_const_mgr.add_const('IDS_CAP_STAT_PALETTE_BUILD',0x000001F8)
    win_const_mgr.add_const('XINPUT_GAMEPAD_A',0x00001000)
    win_const_mgr.add_const('LINEAGENTSESSIONSTATE_ENDED',0x00000010)
    win_const_mgr.add_const('WGL_SWAP_UNDERLAY8',0x00800000)
    win_const_mgr.add_const('TAPE_LOGICAL_BLOCK',0x00000002)
    win_const_mgr.add_const('SCARD_PROTOCOL_UNDEFINED',0x00000000)
    win_const_mgr.add_const('REPL_STATE_NO_MASTER',0x00000001)
    win_const_mgr.add_const('FACILITY_BACKUP',0x000007FF)
    win_const_mgr.add_const('RSC_MBZ0',0x00000005)
    win_const_mgr.add_const('SQL_C_DEFAULT',0x00000063)
    win_const_mgr.add_const('REG_START_JOURNAL',0x00000040)
    win_const_mgr.add_const('PTE_LARGE_PAGE',0x00000036)
    win_const_mgr.add_const('CAUSE_TEMPORARY_FAILURE',0x00000029)
    win_const_mgr.add_const('PHONEERR_STRUCTURETOOSMALL',0x90000021)
    win_const_mgr.add_const('IMAGE_REL_AM_ADDR32NB',0x00000002)
    win_const_mgr.add_const('LVKF_SHIFT',0x00000004)
    win_const_mgr.add_const('ETW_SINGLE_TYPE_VALUE',0x0000000C)
    win_const_mgr.add_const('WMDM_E_BUFFERTOOSMALL',0x80045008)
    win_const_mgr.add_const('IPRTRMGR_PID',0x00002710)
    win_const_mgr.add_const('DNS_RCODE_NOTAUTH',0x00000009)
    win_const_mgr.add_const('OID_FDDI_MAC_UNDA_FLAG',0x0303024B)
    win_const_mgr.add_const('SYMFLAG_SLOT',0x00008000)
    win_const_mgr.add_const('SPI_SETKEYBOARDSPEED',0x0000000B)
    win_const_mgr.add_const('BTH_MFG_OPEN_INTERFACE',0x00000027)
    win_const_mgr.add_const('REO_LINK',0x80000000)
    win_const_mgr.add_const('ERROR_PAGE_FAULT_GUARD_PAGE',0x000002EE)
    win_const_mgr.add_const('SQL_GD_ANY_ORDER',0x00000002)
    win_const_mgr.add_const('THREAD_BASE_PRIORITY_MAX',0x00000002)
    win_const_mgr.add_const('ERROR_INIT_STATUS_NEEDED',0x00000011)
    win_const_mgr.add_const('DISPLAYDIB_STOP',0x00000005)
    win_const_mgr.add_const('WIA_PAGE_ISO_B8',0x00000019)
    win_const_mgr.add_const('METADATA_LOCAL_MACHINE_ONLY',0x00000080)
    win_const_mgr.add_const('CRYPT_OID_INFO_OID_KEY_FLAGS_MASK',0xFFFF0000)
    win_const_mgr.add_const('GESTURE_TRIPLE_LEFT',0x00000000)
    win_const_mgr.add_const('SFVS_SELECT_NONE',0x00000000)
    win_const_mgr.add_const('DDCKEY_COLORSPACE',0x00000001)
    win_const_mgr.add_const('LDAP_MODRDN_CMD',0x00000006)
    win_const_mgr.add_const('ML_CROSSCODEPAGE_MASK',0x00000007)
    win_const_mgr.add_const('SYMFLAG_ILREL',0x00010000)
    win_const_mgr.add_const('IMAGE_REL_IA64_GPREL22',0x00000009)
    win_const_mgr.add_const('CM_GLOBAL_STATE_DETECTION_PENDING',0x00000010)
    win_const_mgr.add_const('GETSETPRINTORIENT',0x0000001E)
    win_const_mgr.add_const('RTCEF_MEDIA',0x00000020)
    win_const_mgr.add_const('DMPAPER_11X17',0x00000011)
    win_const_mgr.add_const('RQ_MAP_REQUEST_HANDLER',0x00000010)
    win_const_mgr.add_const('IDM_CELLPROPERTIES',0x000008A3)
    win_const_mgr.add_const('OPER_STATE_UP',0x00000002)
    win_const_mgr.add_const('VK_F6',0x00000075)
    win_const_mgr.add_const('SQL_ATTR_AUTO_IPD',0x00002711)
    win_const_mgr.add_const('ERROR_IPSEC_QM_POLICY_IN_USE',0x000032CA)
    win_const_mgr.add_const('DEBUG_GSEL_ALLOW_HIGHER',0x00000004)
    win_const_mgr.add_const('GESTURE_SEMICIRCLE_RIGHT',0x00000000)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_PROCESS_ERR_CERT',0x0000360B)
    win_const_mgr.add_const('CERT_CHAIN_POLICY_ALLOW_UNKNOWN_CA_FLAG',0x00000010)
    win_const_mgr.add_const('DDSCAPS_VIDEOMEMORY',0x00004000)
    win_const_mgr.add_const('BCRYPT_SIGNATURE_OPERATION',0x00000010)
    win_const_mgr.add_const('MD_EXTLOG_SERVER_IP',0x00000040)
    win_const_mgr.add_const('SHACF_FILESYS_ONLY',0x00000010)
    win_const_mgr.add_const('MAX_STR_BLOCKREASON',0x00000100)
    win_const_mgr.add_const('DISPID_IBLOCKFORMATS_COUNT',0x00000001)
    win_const_mgr.add_const('DEBUG_STATUS_REVERSE_STEP_BRANCH',0x0000000C)
    win_const_mgr.add_const('DRAFTMODE',0x00000007)
    win_const_mgr.add_const('ERROR_MUI_FILE_NOT_LOADED',0x00003B01)
    win_const_mgr.add_const('FACILITY_IPSEC',0x00000036)
    win_const_mgr.add_const('ERROR_DRIVER_FAILED_SLEEP',0x00000279)
    win_const_mgr.add_const('HHWIN_BUTTON_TOC_NEXT',0x00000001)
    win_const_mgr.add_const('CRED_TYPE_GENERIC_CERTIFICATE',0x00000005)
    win_const_mgr.add_const('ERROR_DS_CANT_START',0x00002153)
    win_const_mgr.add_const('ERROR_CLUSCFG_ROLLBACK_FAILED',0x0000170E)
    win_const_mgr.add_const('IN6ADDR_TEREDOPREFIX_LENGTH',0x00000020)
    win_const_mgr.add_const('CREDUI_FLAGS_PERSIST',0x00001000)
    win_const_mgr.add_const('OID_GEN_LINK_SPEED',0x00010107)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_AUTHORIZATIONACCESS',0x00000230)
    win_const_mgr.add_const('DSOP_SCOPE_TYPE_WORKGROUP',0x00000080)
    win_const_mgr.add_const('OQWF_HIDEMENUS',0x00000400)
    win_const_mgr.add_const('DMBIN_FORMSOURCE',0x0000000F)
    win_const_mgr.add_const('NTM_TYPE1',0x00100000)
    win_const_mgr.add_const('IDC_EL_OPENSOURCE',0x000000D3)
    win_const_mgr.add_const('KLF_SETFORPROCESS',0x00000100)
    win_const_mgr.add_const('DI_FLAGSEX_INET_DRIVER',0x00020000)
    win_const_mgr.add_const('CSIDL_COMMON_VIDEO',0x00000037)
    win_const_mgr.add_const('VIEW_PRIORITY_SHELLEXT_ASBACKUP',0x00000015)
    win_const_mgr.add_const('MDPROPVAL_NL_SCHEMAONLY',0x00000004)
    win_const_mgr.add_const('NETLOGON_CONTROL_SYNCHRONIZE',0x00000003)
    win_const_mgr.add_const('X3_EMPTY_INST_WORD_X',0x00000001)
    win_const_mgr.add_const('SYMSEARCH_MASKOBJS',0x00000001)
    win_const_mgr.add_const('CDIS_OTHERSIDEHOT',0x00000800)
    win_const_mgr.add_const('MUI_USER_PREFERRED_UI_LANGUAGES',0x00000010)
    win_const_mgr.add_const('DIF_DESTROYPRIVATEDATA',0x0000000C)
    win_const_mgr.add_const('DTN_FIRST2',0x00000000)
    win_const_mgr.add_const('CRYPTUI_WIZ_DIGITAL_SIGN_INDIVIDUAL',0x00000002)
    win_const_mgr.add_const('IDM_RESPECTVISIBILITY_INDESIGN',0x00000965)
    win_const_mgr.add_const('LINEMAPPER',0xFFFFFFFF)
    win_const_mgr.add_const('SPDRP_LOCATION_PATHS',0x00000023)
    win_const_mgr.add_const('AVIERR_OK',0x00000000)
    win_const_mgr.add_const('EMR_STRETCHDIBITS',0x00000051)
    win_const_mgr.add_const('MF_UNCHECKED',0x00000000)
    win_const_mgr.add_const('HTTP_QUERY_ORIG_URI',0x00000022)
    win_const_mgr.add_const('LINEERR_INVALLINEHANDLE',0x8000002B)
    win_const_mgr.add_const('POLICY_SHOWREASONUI_WORKSTATIONONLY',0x00000002)
    win_const_mgr.add_const('ERROR_PARAMETER_QUOTA_EXCEEDED',0x00000503)
    win_const_mgr.add_const('MAXIMUM_WAIT_OBJECTS',0x00000040)
    win_const_mgr.add_const('BCRYPT_DSA_PARAMETERS_MAGIC',0x00000004)
    win_const_mgr.add_const('MD_APPPOOL_COMMAND_START',0x00000001)
    win_const_mgr.add_const('PD_ENABLEPRINTTEMPLATE',0x00004000)
    win_const_mgr.add_const('SHPPFW_MEDIACHECKONLY',0x00000010)
    win_const_mgr.add_const('PLA_CAPABILITY_V1_SYSTEM',0x00000004)
    win_const_mgr.add_const('WS_EX_TOOLWINDOW',0x00000080)
    win_const_mgr.add_const('TC_SA_CONTIN',0x00000100)
    win_const_mgr.add_const('SSF_AVAILABLE',0x00000002)
    win_const_mgr.add_const('DEBUG_SESSION_END_SESSION_ACTIVE_TERMINATE',0x00000001)
    win_const_mgr.add_const('DNS_QUERY_TREAT_AS_FQDN',0x00001000)
    win_const_mgr.add_const('IDD_LINKPROPS4',0x00000453)
    win_const_mgr.add_const('PF_XMMI64_INSTRUCTIONS_AVAILABLE',0x0000000A)
    win_const_mgr.add_const('NDW_INSTALLFLAG_INSTALLSPECIFIC',0x00002000)
    win_const_mgr.add_const('IDM_MP_EMAILPICTURE',0x000008F0)
    win_const_mgr.add_const('DDCAPS2_DYNAMICTEXTURES',0x20000000)
    win_const_mgr.add_const('FLI_GLYPHS',0x00040000)
    win_const_mgr.add_const('SPDRP_ENUMERATOR_NAME',0x00000016)
    win_const_mgr.add_const('IF_NUMBER',0x00000000)
    win_const_mgr.add_const('PSF_SELECTPASTELINK',0x00000004)
    win_const_mgr.add_const('INTERNET_OPTION_CONNECT_RETRIES',0x00000003)
    win_const_mgr.add_const('SELCERT_PROPERTIES',0x00000064)
    win_const_mgr.add_const('CSIDL_COMMON_PROGRAMS',0x00000000)
    win_const_mgr.add_const('PAN_STRAIGHT_ARMS_DOUBLE_SERIF',0x00000006)
    win_const_mgr.add_const('DSOP_SCOPE_TYPE_USER_ENTERED_DOWNLEVEL_SCOPE',0x00000200)
    win_const_mgr.add_const('SQL_MAX_BINARY_LITERAL_LEN',0x00000070)
    win_const_mgr.add_const('URLACTION_ACTIVEX_MAX',0x00000013)
    win_const_mgr.add_const('ERROR_IMPLICIT_TRANSACTION_NOT_SUPPORTED',0x00001A45)
    win_const_mgr.add_const('IDM_FORM',0x00000885)
    win_const_mgr.add_const('PROTO_IP_NT_STATIC',0x00002716)
    win_const_mgr.add_const('GMEM_VALID_FLAGS',0x00007F72)
    win_const_mgr.add_const('JOB_NOTIFY_FIELD_SUBMITTED',0x00000010)
    win_const_mgr.add_const('RPC_BUFFER_COMPLETE',0x00001000)
    win_const_mgr.add_const('ERROR_DS_CANT_ADD_TO_GC',0x00002166)
    win_const_mgr.add_const('ERROR_NOT_DOS_DISK',0x0000001A)
    win_const_mgr.add_const('TXTBIT_PARAFORMATCHANGE',0x00040000)
    win_const_mgr.add_const('MCI_DGV_STEP_FRAMES',0x00020000)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_SAMPLE_ROTATION',0x00000002)
    win_const_mgr.add_const('WLAN_PROFILE_CONNECTION_MODE_SET_BY_CLIENT',0x00010000)
    win_const_mgr.add_const('MFCLOCK_TOLERANCE_UNKNOWN',0x0000C350)
    win_const_mgr.add_const('STYPE_IPC',0x00000003)
    win_const_mgr.add_const('SNMP_BERAPI_SHORT_BUFFER',0x0000000D)
    win_const_mgr.add_const('WOW64_SIZE_OF_80387_REGISTERS',0x00000050)
    win_const_mgr.add_const('LOCALE_USE_CP_ACP',0x40000000)
    win_const_mgr.add_const('FR_PROP_PENDINFOTOKEN',0x00000008)
    win_const_mgr.add_const('CERT_RDN_ISO646_STRING',0x00000009)
    win_const_mgr.add_const('ULW_ALPHA',0x00000002)
    win_const_mgr.add_const('JOB_OBJECT_LIMIT_AFFINITY',0x00000010)
    win_const_mgr.add_const('DBG_GPFAULT',0x00000007)
    win_const_mgr.add_const('CMC_STATUS_CONFIRM_REQUIRED',0x00000005)
    win_const_mgr.add_const('MS_MAX_PROFILE_NAME_LENGTH',0x00000100)
    win_const_mgr.add_const('NCRYPT_PERSIST_FLAG',0x80000000)
    win_const_mgr.add_const('DBPROPVAL_OS_RESOURCEPOOLING',0x00000001)
    win_const_mgr.add_const('ERROR_TRANSACTION_REQUIRED_PROMOTION',0x00001AB5)
    win_const_mgr.add_const('PSH_DEFAULT',0x00000000)
    win_const_mgr.add_const('PDH_INVALID_DATASOURCE',0xC0000BDD)
    win_const_mgr.add_const('HDS_FLAT',0x00000200)
    win_const_mgr.add_const('CF_ENHMETAFILE',0x0000000E)
    win_const_mgr.add_const('NDIS_RING_AUTO_REMOVAL_ERROR',0x00000400)
    win_const_mgr.add_const('PDH_MAX_COUNTER_NAME',0x00000400)
    win_const_mgr.add_const('RES_UNUSED_1',0x00000001)
    win_const_mgr.add_const('THREAD_SET_INFORMATION',0x00000020)
    win_const_mgr.add_const('OI_ASYNC',0xFFFFEEEE)
    win_const_mgr.add_const('DF_ALLOWOTHERACCOUNTHOOK',0x00000001)
    win_const_mgr.add_const('SOUND_SYSTEM_STARTUP',0x00000001)
    win_const_mgr.add_const('DISPID_WINDOWSETRESIZABLE',0x00000106)
    win_const_mgr.add_const('SQLNVARCHAR',0x00000000)
    win_const_mgr.add_const('SW_PARENTOPENING',0x00000003)
    win_const_mgr.add_const('RSC_FLAG_DELAYREGISTEROCX',0x00000200)
    win_const_mgr.add_const('MPEG2_PROGRAM_PES_STREAM',0x00000004)
    win_const_mgr.add_const('DS_WRITABLE_FLAG',0x00000100)
    win_const_mgr.add_const('LANG_UKRAINIAN',0x00000022)
    win_const_mgr.add_const('MFSTARTUP_FULL',0x00000000)
    win_const_mgr.add_const('DNS_PORT_HOST_ORDER',0x00000035)
    win_const_mgr.add_const('ICDRAW_HDC',0x00000004)
    win_const_mgr.add_const('DISP_CHANGE_SUCCESSFUL',0x00000000)
    win_const_mgr.add_const('CERT_PROT_ROOT_DISABLE_NOT_DEFINED_NAME_CONSTRAINT_FLAG',0x00000020)
    win_const_mgr.add_const('WM_USER',0x00000400)
    win_const_mgr.add_const('ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH',0x0000215C)
    win_const_mgr.add_const('MDM_BEARERMODE_GSM',0x00000002)
    win_const_mgr.add_const('CERT_STORE_SAVE_AS_PKCS7',0x00000002)
    win_const_mgr.add_const('ERROR_POLICY_ONLY_IN_DS',0x0000201C)
    win_const_mgr.add_const('IPV6_V6ONLY',0x0000001B)
    win_const_mgr.add_const('LB_GETHORIZONTALEXTENT',0x00000193)
    win_const_mgr.add_const('SPMODE_FORMATTEXT',0x00000080)
    win_const_mgr.add_const('IDI_RESOURCE',0x0000009F)
    win_const_mgr.add_const('MDPROPVAL_MC_SINGLECASE',0x00000001)
    win_const_mgr.add_const('KERB_RETRIEVE_TICKET_AS_KERB_CRED',0x00000008)
    win_const_mgr.add_const('MINIDUMP_THREAD_INFO_WRITING_THREAD',0x00000002)
    win_const_mgr.add_const('DNS_RTYPE_NXT',0x00000001)
    win_const_mgr.add_const('SHGNLI_PIDL',0x00000001)
    win_const_mgr.add_const('DISPID_RUNONCEHASSHOWN',0x0000001C)
    win_const_mgr.add_const('ICU_DECODE',0x10000000)
    win_const_mgr.add_const('CB_INSERTSTRING',0x0000014A)
    win_const_mgr.add_const('WIA_IPA_ITEMS_STORED',0x0000101F)
    win_const_mgr.add_const('IF_TYPE_TDLC',0x00000074)
    win_const_mgr.add_const('CONSOLE_FULLSCREEN_MODE',0x00000001)
    win_const_mgr.add_const('STD_HELP',0x0000000B)
    win_const_mgr.add_const('ACCESS_DELETE',0x00000010)
    win_const_mgr.add_const('BLLI_L2_Q922',0x0000000E)
    win_const_mgr.add_const('TXFS_RM_FLAG_SHRINK_LOG',0x00000800)
    win_const_mgr.add_const('ACMFILTERCHOOSE_STYLEF_SHOWHELP',0x00000004)
    win_const_mgr.add_const('ADS_SERVICE_OWN_PROCESS',0x00000010)
    win_const_mgr.add_const('IDC_PS_RESULTIMAGE',0x000001FD)
    win_const_mgr.add_const('CB_SETCURSEL',0x0000014E)
    win_const_mgr.add_const('SQL_ENSURE',0x00000001)
    win_const_mgr.add_const('OPTION_MERIT_DUMP_FILE',0x0000000E)
    win_const_mgr.add_const('LUP_RETURN_COMMENT',0x00000080)
    win_const_mgr.add_const('SUBLANG_UKRAINIAN_UKRAINE',0x00000001)
    win_const_mgr.add_const('TMT_BACKGROUND',0x00000642)
    win_const_mgr.add_const('WM_IME_COMPOSITION',0x0000010F)
    win_const_mgr.add_const('PBS_SMOOTH',0x00000001)
    win_const_mgr.add_const('SQL_FETCH_RELATIVE',0x00000006)
    win_const_mgr.add_const('MOUSEEVENTF_MOVE_NOCOALESCE',0x00002000)
    win_const_mgr.add_const('IPPROTO_PUP',0x0000000C)
    win_const_mgr.add_const('ASP_MD_ID_END_RESERVED',0x00000074)
    win_const_mgr.add_const('ERROR_SUCCESS_RESTART_REQUIRED',0x00000BC3)
    win_const_mgr.add_const('PO_RENAME',0x00000014)
    win_const_mgr.add_const('INV_REQ_HANDLE',0x00000003)
    win_const_mgr.add_const('ERROR_DLL_MIGHT_BE_INCOMPATIBLE',0x000002AF)
    win_const_mgr.add_const('VER_BUILDNUMBER',0x00000004)
    win_const_mgr.add_const('EV_RLSD',0x00000020)
    win_const_mgr.add_const('LANG_SWEDISH',0x00000001)
    win_const_mgr.add_const('ERROR_ALREADY_FIBER',0x00000500)
    win_const_mgr.add_const('SQL_FN_TD_HOUR',0x00000400)
    win_const_mgr.add_const('FD_SETSIZE',0x00000040)
    win_const_mgr.add_const('GCP_DBCS',0x00000001)
    win_const_mgr.add_const('IDM_PRINT',0x0000001B)
    win_const_mgr.add_const('IDC_UL_STOP',0x00000406)
    win_const_mgr.add_const('SHARE_CURRENT_USES_PARMNUM',0x00000007)
    win_const_mgr.add_const('DEBUG_ATTACH_INVASIVE_RESUME_PROCESS',0x00000010)
    win_const_mgr.add_const('PVD_CONFIG',0x00003001)
    win_const_mgr.add_const('RBS_REGISTERDROP',0x00001000)
    win_const_mgr.add_const('CQFF_NOGLOBALPAGES',0x00000001)
    win_const_mgr.add_const('IMPLINK_IP',0x0000009B)
    win_const_mgr.add_const('TRUSTERROR_STEP_MSG_COUNTERSIGCERT',0x00000011)
    win_const_mgr.add_const('CTRY_KUWAIT',0x000003C5)
    win_const_mgr.add_const('PAN_STRAIGHT_ARMS_WEDGE',0x00000003)
    win_const_mgr.add_const('ISMEX_NOSEND',0x00000000)
    win_const_mgr.add_const('DMBIN_MANUAL',0x00000004)
    win_const_mgr.add_const('SECPKG_ATTR_AUTHENTICATION_ID',0x00000014)
    win_const_mgr.add_const('BG_E_HTTP_ERROR_203',0x801900CB)
    win_const_mgr.add_const('CRSWPP_SECURITY_PACKAGE_NOT_FOUND',0xC0042204)
    win_const_mgr.add_const('WMS_STREAM_PREROLL',0x00000006)
    win_const_mgr.add_const('SQL_MAX_CHAR_LITERAL_LEN',0x0000006C)
    win_const_mgr.add_const('FACILITY_RPC_RUNTIME',0x00000002)
    win_const_mgr.add_const('SW_SHOWMINNOACTIVE',0x00000007)
    win_const_mgr.add_const('PLAL_ALERT_CMD_LINE_C_NAME',0x00000400)
    win_const_mgr.add_const('RIDEV_CAPTUREMOUSE',0x00000200)
    win_const_mgr.add_const('LINECALLSTATE_DIALING',0x00000010)
    win_const_mgr.add_const('EAP_E_SERVER_LAST',0x804202FF)
    win_const_mgr.add_const('ERROR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE',0x00001AB2)
    win_const_mgr.add_const('CAUSE_VPI_VCI_UNAVAILABLE',0x00000023)
    win_const_mgr.add_const('DDCKEY_DESTOVERLAY',0x00000004)
    win_const_mgr.add_const('IMAGE_REL_PPC_REL14',0x00000007)
    win_const_mgr.add_const('SYNCH_DATA_STORE_MESSAGES',0x00000006)
    win_const_mgr.add_const('INTERNET_MAX_SCHEME_LENGTH',0x00000020)
    win_const_mgr.add_const('WHDR_PREPARED',0x00000002)
    win_const_mgr.add_const('BSF_TRUSTEDFORACTIVEX',0x00020000)
    win_const_mgr.add_const('WINEVENT_LEVEL_RESERVED_10',0x00000000)
    win_const_mgr.add_const('WINEVENT_LEVEL_RESERVED_11',0x00000000)
    win_const_mgr.add_const('DXGI_USAGE_READ_ONLY',0x00000001)
    win_const_mgr.add_const('NDIS_STATISTICS_FLAGS_VALID_BYTES_XMIT',0x00000200)
    win_const_mgr.add_const('PHONEERR_INVALRINGMODE',0x90000017)
    win_const_mgr.add_const('SLE_ERROR',0x00000001)
    win_const_mgr.add_const('AUTH_REQ_OK_AS_DELEGATE',0x00000100)
    win_const_mgr.add_const('DOT11_MIN_PDU_SIZE',0x00000100)
    win_const_mgr.add_const('LCMAP_TRADITIONAL_CHINESE',0x04000000)
    win_const_mgr.add_const('INTERNET_KEEP_ALIVE_DISABLED',0x00000000)
    win_const_mgr.add_const('LINEDEVSTATE_SIGNAL',0x00010000)
    win_const_mgr.add_const('DISPID_BEFORENAVIGATE',0x00000064)
    win_const_mgr.add_const('SP_COPY_NEWER_ONLY',0x00010000)
    win_const_mgr.add_const('D3DPRESENT_LINEAR_CONTENT',0x00000002)
    win_const_mgr.add_const('SFVM_ADDOBJECT',0x00000003)
    win_const_mgr.add_const('CDO_E_ARGUMENT3',0x80044002)
    win_const_mgr.add_const('TC_OP_CHARACTER',0x00000001)
    win_const_mgr.add_const('NDIS_MAC_OPTION_COPY_LOOKAHEAD_DATA',0x00000001)
    win_const_mgr.add_const('DDSCAPS_ZBUFFER',0x00020000)
    win_const_mgr.add_const('REG_NO_COMPRESSION',0x00000004)
    win_const_mgr.add_const('DE_E_RESOURCE_NOT_FOUND',0x800C0005)
    win_const_mgr.add_const('LUP_NEAREST',0x00000008)
    win_const_mgr.add_const('IDM_CHANGEFONTSIZE',0x000008C1)
    win_const_mgr.add_const('TAPE_TENSION',0x00000002)
    win_const_mgr.add_const('SQL_ASYNC_ENABLE_ON',0x00000001)
    win_const_mgr.add_const('MF_BOOT_DRIVER_VERIFICATION_FAILED',0x00100000)
    win_const_mgr.add_const('USN_REASON_RENAME_OLD_NAME',0x00001000)
    win_const_mgr.add_const('INTERNET_CACHE_GROUP_ADD',0x00000000)
    win_const_mgr.add_const('IME_CMODE_NATIVE',0x00000001)
    win_const_mgr.add_const('WINHTTP_OPTION_ENABLE_FEATURE',0x0000004F)
    win_const_mgr.add_const('PRINTER_NOTIFY_FIELD_DATATYPE',0x0000000B)
    win_const_mgr.add_const('DE_E_INVALID_URL',0x800C0002)
    win_const_mgr.add_const('ADDURL_SILENT',0x00000000)
    win_const_mgr.add_const('IF_TYPE_SHDSL',0x000000A9)
    win_const_mgr.add_const('END_NESTED_SYSTEM_CHANGE',0x00000067)
    win_const_mgr.add_const('IDS_CAP_INFO',0x00000191)
    win_const_mgr.add_const('PDH_DATA_SOURCE_IS_REAL_TIME',0xC0000BCF)
    win_const_mgr.add_const('ERROR_LOG_PINNED',0x000019F4)
    win_const_mgr.add_const('SYMOPT_NO_IMAGE_SEARCH',0x00020000)
    win_const_mgr.add_const('VFT2_DRV_LANGUAGE',0x00000003)
    win_const_mgr.add_const('IMAGE_REL_M32R_SECTION',0x0000000C)
    win_const_mgr.add_const('DEBUG_ECREATE_PROCESS_DEFAULT',0x00000000)
    win_const_mgr.add_const('FWPM_TXN_READ_ONLY',0x00000001)
    win_const_mgr.add_const('TRUETYPE_FONTTYPE',0x00000004)
    win_const_mgr.add_const('NIIF_NDIS_RESERVED1',0x00000004)
    win_const_mgr.add_const('LINECALLSTATE_ACCEPTED',0x00000004)
    win_const_mgr.add_const('NIIF_NDIS_RESERVED3',0x00000010)
    win_const_mgr.add_const('NIIF_NDIS_RESERVED2',0x00000008)
    win_const_mgr.add_const('LINEFORWARDMODE_UNKNOWN',0x00010000)
    win_const_mgr.add_const('DBT_DEVICETYPESPECIFIC',0x00008005)
    win_const_mgr.add_const('ADS_PRINTER_OUTPUT_BIN_FULL',0x00000800)
    win_const_mgr.add_const('WLX_PROFILE_TYPE_V1_0',0x00000001)
    win_const_mgr.add_const('USER_HOME_DIR_DRIVE_PARMNUM',0x00000035)
    win_const_mgr.add_const('ERROR_DS_ROOT_CANT_BE_SUBREF',0x00002086)
    win_const_mgr.add_const('SQL_CVT_TIMESTAMP',0x00020000)
    win_const_mgr.add_const('LVSICF_NOSCROLL',0x00000002)
    win_const_mgr.add_const('DESKTOP_ENUMERATE',0x00000040)
    win_const_mgr.add_const('OPTION_ALL_SUBNETS_MTU',0x0000001B)
    win_const_mgr.add_const('IMAGE_REL_BASED_DIR64',0x0000000A)
    win_const_mgr.add_const('SERVICE_CONFIG_REQUIRED_PRIVILEGES_INFO',0x00000006)
    win_const_mgr.add_const('ENABLEDUPLEX',0x0000001C)
    win_const_mgr.add_const('RPC_C_MQ_PERMANENT',0x00000001)
    win_const_mgr.add_const('VK_ACCEPT',0x0000001E)
    win_const_mgr.add_const('SV_CACHEDDIRECTORYLIMIT_PARMNUM',0x0000024B)
    win_const_mgr.add_const('OS_DOMAINMEMBER',0x0000001C)
    win_const_mgr.add_const('WMS_STREAM_CONCEALED_FLAG',0x00000004)
    win_const_mgr.add_const('SEE_MASK_INVOKEIDLIST',0x00000000)
    win_const_mgr.add_const('STATE_SYSTEM_DEFAULT',0x00000100)
    win_const_mgr.add_const('DOT11_SERVICE_CLASS_STRICTLY_ORDERED',0x00000001)
    win_const_mgr.add_const('X3_I_SIZE_X',0x00000001)
    win_const_mgr.add_const('DISPID_ONREADYSTATECHANGE',0x00000010)
    win_const_mgr.add_const('FIND_RET',0x0000F000)
    win_const_mgr.add_const('CLRDTR',0x00000006)
    win_const_mgr.add_const('RSVP_SHARED_EXPLICIT_STYLE',0x00000003)
    win_const_mgr.add_const('WNODE_FLAG_LOG_WNODE',0x00040000)
    win_const_mgr.add_const('DSBI_NOLINES',0x00000002)
    win_const_mgr.add_const('MCW_VERTICAL',0x00000008)
    win_const_mgr.add_const('OS_XPORGREATER',0x00000012)
    win_const_mgr.add_const('LINEERR_INVALDEVICECLASS',0x80000023)
    win_const_mgr.add_const('TRUSTERROR_STEP_MSG_INNERCNTTYPE',0x0000000A)
    win_const_mgr.add_const('PIDASI_STREAM_NUMBER',0x00000008)
    win_const_mgr.add_const('CONNDLG_PERSIST',0x00000010)
    win_const_mgr.add_const('DDCAPS_ALIGNBOUNDARYSRC',0x00000008)
    win_const_mgr.add_const('CIF_SELECTFROMFILE',0x00000008)
    win_const_mgr.add_const('ERROR_DS_NO_PARENT_OBJECT',0x00002089)
    win_const_mgr.add_const('WM_MDIDESTROY',0x00000221)
    win_const_mgr.add_const('CPL_SELECT',0x00000004)
    win_const_mgr.add_const('CERT_INFO_EXTENSION_FLAG',0x0000000B)
    win_const_mgr.add_const('SQLAOPVAR',0x00000032)
    win_const_mgr.add_const('SHPPFW_IGNOREFILENAME',0x00000004)
    win_const_mgr.add_const('SE_GROUP_INTEGRITY_ENABLED',0x00000040)
    win_const_mgr.add_const('LDAP_FILTER_SUBSTRINGS',0x00000000)
    win_const_mgr.add_const('ERROR_PAGE_FAULT_TRANSITION',0x000002EB)
    win_const_mgr.add_const('CRYPTNET_URL_CACHE_DISABLE_FLUSH',0xFFFFFFFF)
    win_const_mgr.add_const('HEAP_DISABLE_COALESCE_ON_FREE',0x00000080)
    win_const_mgr.add_const('CTRY_AUSTRIA',0x0000002B)
    win_const_mgr.add_const('BIND_NO_UPDATE',0x00000002)
    win_const_mgr.add_const('CMSG_ENCRYPT_PARAM',0x0000001A)
    win_const_mgr.add_const('D3D10_SHADER_ENABLE_STRICTNESS',0x00000001)
    win_const_mgr.add_const('PP_SIGNATURE_PIN',0x00000021)
    win_const_mgr.add_const('CERT_LAST_RESERVED_PROP_ID',0x00007FFF)
    win_const_mgr.add_const('SKF_RCTLLATCHED',0x08000000)
    win_const_mgr.add_const('IME_SETCONVERSIONFONTEX',0x00000019)
    win_const_mgr.add_const('SO_OPENTYPE',0x00007008)
    win_const_mgr.add_const('DVASPECT_COPY',0x00000003)
    win_const_mgr.add_const('MCI_NOTIFY_SUCCESSFUL',0x00000001)
    win_const_mgr.add_const('IDS_CAP_SETFILESIZE',0x000001A0)
    win_const_mgr.add_const('COLOR_BTNHIGHLIGHT',0x00000014)
    win_const_mgr.add_const('ERROR_CLEANER_CARTRIDGE_SPENT',0x000010ED)
    win_const_mgr.add_const('BLLI_L3_MODE_NORMAL',0x00000040)
    win_const_mgr.add_const('GESTURE_SQUARE',0x00000000)
    win_const_mgr.add_const('HEAP_CREATE_ENABLE_TRACING',0x00020000)
    win_const_mgr.add_const('LANG_YAKUT',0x00000085)
    win_const_mgr.add_const('DNOBJECT_DTERM',0x00000017)
    win_const_mgr.add_const('OID_ENCODING',0x0000000B)
    win_const_mgr.add_const('IDM_TRIED_OUTDENT',0x00000030)
    win_const_mgr.add_const('CR_NO_CM_SERVICES',0x00000032)
    win_const_mgr.add_const('OS_TERMINALSERVER',0x00000018)
    win_const_mgr.add_const('MCI_STATUS_READY',0x00000007)
    win_const_mgr.add_const('MM_MSFT_ACM_WMAUDIO',0x00000027)
    win_const_mgr.add_const('ISSP_MODE',0x00000001)
    win_const_mgr.add_const('SB_LINEUP',0x00000000)
    win_const_mgr.add_const('LVCF_IDEALWIDTH',0x00000100)
    win_const_mgr.add_const('STI_VERSION_FLAG_UNICODE',0x01000000)
    win_const_mgr.add_const('MD_ERROR_SUB401_LOGON',0x00000001)
    win_const_mgr.add_const('OID_IRDA_RESERVED2',0x0A01020F)
    win_const_mgr.add_const('ILDRF_OVERLAYLOWQUALITY',0x00000010)
    win_const_mgr.add_const('RPC_S_PROTSEQ_NOT_SUPPORTED',0x000006A7)
    win_const_mgr.add_const('PORT_NETSCDEV',0x0000009B)
    win_const_mgr.add_const('PD_HIDEPRINTTOFILE',0x00100000)
    win_const_mgr.add_const('ERROR_INVALID_EDIT_HEIGHT',0x00000590)
    win_const_mgr.add_const('KSPROBE_STREAMWRITE',0x00000001)
    win_const_mgr.add_const('FR_DOWN',0x00000001)
    win_const_mgr.add_const('IMF_FORCEACTIVE',0x00000040)
    win_const_mgr.add_const('RTM_CHANGE_TYPE_BEST',0x00000002)
    win_const_mgr.add_const('SQL_FN_NUM_RADIANS',0x00200000)
    win_const_mgr.add_const('WIA_DPS_PAD_COLOR',0x00000C0A)
    win_const_mgr.add_const('LINEROAMMODE_HOME',0x00000004)
    win_const_mgr.add_const('FAX_ERR_GROUP_IN_USE',0x00001B5C)
    win_const_mgr.add_const('NUM_SSRVOPTS',0x0000001E)
    win_const_mgr.add_const('SW_OTHERUNZOOM',0x00000004)
    win_const_mgr.add_const('SPI_GETCARETWIDTH',0x00002006)
    win_const_mgr.add_const('MD_BACKUP_MAX_LEN',0x00000064)
    win_const_mgr.add_const('RGN_OR',0x00000002)
    win_const_mgr.add_const('ISC_SHOWUIGUIDELINE',0x40000000)
    win_const_mgr.add_const('CORDLESS_EXTERNAL_NETWORK_ANALOG_CELLULAR',0x00000005)
    win_const_mgr.add_const('ATADDRESSLEN',0x00000020)
    win_const_mgr.add_const('DBPROPVAL_TR_COMMIT_NO',0x00000004)
    win_const_mgr.add_const('ERROR_INVALID_REPARSE_DATA',0x00001128)
    win_const_mgr.add_const('NCBUNLINK',0x00000070)
    win_const_mgr.add_const('ERROR_GENERIC_NOT_MAPPED',0x00000550)
    win_const_mgr.add_const('ERROR_RESOURCE_REQUIREMENTS_CHANGED',0x000002F4)
    win_const_mgr.add_const('CERT_VALIDITY_KEY_USAGE_EXT_FAILURE',0x00000010)
    win_const_mgr.add_const('DBPROPVAL_DF_INITIALLY_DEFERRED',0x00000001)
    win_const_mgr.add_const('HTTP_QUERY_HOST',0x00000037)
    win_const_mgr.add_const('PAGE_WRITECOPY',0x00000008)
    win_const_mgr.add_const('SNMPAPI_TL_SRC_INVALID',0x00000069)
    win_const_mgr.add_const('MCI_DEVTYPE_SEQUENCER',0x0000020B)
    win_const_mgr.add_const('TAPIMEDIATYPE_VIDEO',0x00008000)
    win_const_mgr.add_const('SVSI_SELECTIONMARK',0x00000040)
    win_const_mgr.add_const('IPX_INTERFACE_TABLE',0x00000001)
    win_const_mgr.add_const('DNS_TYPE_UNSPEC',0x00000067)
    win_const_mgr.add_const('SO_DISCDATA',0x00007002)
    win_const_mgr.add_const('DISPID_COUNTVIEWTYPES',0x00000016)
    win_const_mgr.add_const('UNITS_PER_DAY',0x00000018)
    win_const_mgr.add_const('ERROR_CANT_ACCESS_DOMAIN_INFO',0x00000547)
    win_const_mgr.add_const('CERT_STORE_CTL_CONTEXT',0x00000003)
    win_const_mgr.add_const('CERT_TRUST_CTL_IS_NOT_VALID_FOR_USAGE',0x00080000)
    win_const_mgr.add_const('WM_LBUTTONDBLCLK',0x00000203)
    win_const_mgr.add_const('HTTP_QUERY_ACCEPT_CHARSET',0x00000019)
    win_const_mgr.add_const('TMT_DISKSTREAM',0x000000D5)
    win_const_mgr.add_const('WSAEINPROGRESS',0x00002734)
    win_const_mgr.add_const('ERROR_PROFILE_NOT_FOUND',0x000007E0)
    win_const_mgr.add_const('RTL_CRITSECT_TYPE',0x00000000)
    win_const_mgr.add_const('SHADOW_IRQL_IMPLEMENTATION',0x00000001)
    win_const_mgr.add_const('CCS_NORESIZE',0x00000004)
    win_const_mgr.add_const('ERROR_DS_INAPPROPRIATE_MATCHING',0x0000202E)
    win_const_mgr.add_const('MFASYNC_CALLBACK_QUEUE_ALL',0xFFFFFFFF)
    win_const_mgr.add_const('RESOURCEUSAGE_RESERVED',0x80000000)
    win_const_mgr.add_const('OPTION_BOOT_FILE_SIZE',0x0000000D)
    win_const_mgr.add_const('SEE_MASK_FLAG_NO_UI',0x00000400)
    win_const_mgr.add_const('PS_COMPONENT_DRRSEQ',0x00000005)
    win_const_mgr.add_const('LB_GETITEMRECT',0x00000198)
    win_const_mgr.add_const('MCI_AVI_STATUS_LAST_PLAY_SPEED',0x00008002)
    win_const_mgr.add_const('WSB_PROP_CYVTHUMB',0x00000020)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_INLINE_REFLONG',0x00000009)
    win_const_mgr.add_const('AD_CLOCKWISE',0x00000002)
    win_const_mgr.add_const('DMPAPER_STATEMENT',0x00000006)
    win_const_mgr.add_const('ERROR_INVALID_HANDLE_STATE',0x00000649)
    win_const_mgr.add_const('WIA_INTENT_IMAGE_TYPE_MASK',0x0000000F)
    win_const_mgr.add_const('C3_LOWSURROGATE',0x00001000)
    win_const_mgr.add_const('SV_TYPE_BACKUP_BROWSER',0x00020000)
    win_const_mgr.add_const('OID_GEN_NDIS_RESERVED_4',0x0001020B)
    win_const_mgr.add_const('TTF_RTLREADING',0x00000004)
    win_const_mgr.add_const('DS_BEHAVIOR_LONGHORN',0x00000003)
    win_const_mgr.add_const('WIA_DPS_ENDORSER_STRING',0x00000C15)
    win_const_mgr.add_const('WIZ_BODYCX',0x000000B8)
    win_const_mgr.add_const('PFN_BULLET',0x00000001)
    win_const_mgr.add_const('PFM_SPACEAFTER',0x00000080)
    win_const_mgr.add_const('SO_CONDITIONAL_ACCEPT',0x00003002)
    win_const_mgr.add_const('ADO_VERSION',0x00000006)
    win_const_mgr.add_const('INTERNET_PER_CONN_PROXY_BYPASS',0x00000003)
    win_const_mgr.add_const('DEBUG_TYPEOPTS_UNICODE_DISPLAY',0x00000001)
    win_const_mgr.add_const('MAXINTATOM',0x0000C000)
    win_const_mgr.add_const('ERROR_EVT_PUBLISHER_DISABLED',0x00003ABD)
    win_const_mgr.add_const('DEBUG_HANDLE_DATA_TYPE_PER_HANDLE_OPERATIONS',0x00000009)
    win_const_mgr.add_const('DI_NOBROWSE',0x00000200)
    win_const_mgr.add_const('DI_NORMAL',0x00000003)
    win_const_mgr.add_const('SQL_MAX_NUMERIC_LEN',0x00000010)
    win_const_mgr.add_const('SQL_ALL_EXCEPT_LIKE',0x00000002)
    win_const_mgr.add_const('MSV1_0_MAX_NTLM3_LIFE',0x0001FA40)
    win_const_mgr.add_const('SQL_FC_OFF',0x00000000)
    win_const_mgr.add_const('VIF_FILEINUSE',0x00000080)
    win_const_mgr.add_const('TAPE_DRIVE_ECC',0x00010000)
    win_const_mgr.add_const('ERROR_DS_DRA_REF_NOT_FOUND',0x00002101)
    win_const_mgr.add_const('TMT_HEADING1TEXTCOLOR',0x00000EF1)
    win_const_mgr.add_const('CONNECT_REDIRECT',0x00000080)
    win_const_mgr.add_const('SCH_CRED_IGNORE_REVOCATION_OFFLINE',0x00001000)
    win_const_mgr.add_const('DNS_RCLASS_NONE',0x00000000)
    win_const_mgr.add_const('UF_INTERDOMAIN_TRUST_ACCOUNT',0x00000800)
    win_const_mgr.add_const('EXECUTE_FLAG_SAME_URL',0x00000010)
    win_const_mgr.add_const('EAP_E_USER_CERT_OTHER_ERROR',0x80420104)
    win_const_mgr.add_const('ERROR_CLUSTER_MEMBERSHIP_HALT',0x00001704)
    win_const_mgr.add_const('MAX_ISCSI_PORTAL_NAME_LEN',0x00000100)
    win_const_mgr.add_const('LINEMEDIAMODE_TELEX',0x00000800)
    win_const_mgr.add_const('RP_RECIP_FLAGS_RESERVED',0x0000000F)
    win_const_mgr.add_const('PERFSTATE_POLICY_CHANGE_ROCKET',0x00000002)
    win_const_mgr.add_const('MD_LOGCUSTOM_DATATYPE_LPWSTR',0x00000007)
    win_const_mgr.add_const('KSPRIORITY_HIGH',0x80000000)
    win_const_mgr.add_const('EC_VIDEO_SIZE_CHANGED',0x0000000A)
    win_const_mgr.add_const('ISR_NI',0x00000027)
    win_const_mgr.add_const('VP_TV_STANDARD_PAL_M',0x00000040)
    win_const_mgr.add_const('CRYPT_INSTALL_OID_FUNC_BEFORE_FLAG',0x00000001)
    win_const_mgr.add_const('IPPORT_WHOIS',0x0000002B)
    win_const_mgr.add_const('ERROR_INVALID_MONITOR_HANDLE',0x000005B5)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_NEXTWRITABLEADDRESS',0x0000010A)
    win_const_mgr.add_const('ABM_SETAUTOHIDEBAR',0x00000008)
    win_const_mgr.add_const('STN_DBLCLK',0x00000001)
    win_const_mgr.add_const('IDM_MIMECSET__FIRST__',0x00000E19)
    win_const_mgr.add_const('PATCH_OPTION_USE_LZX_LARGE',0x00000004)
    win_const_mgr.add_const('MS_RING_ON',0x00000040)
    win_const_mgr.add_const('MAPI_LOGON_UI',0x00000001)
    win_const_mgr.add_const('DLG_FLAGS_SEC_CERT_DATE_INVALID',0x04000000)
    win_const_mgr.add_const('DMPAPER_TABLOID_EXTRA',0x00000034)
    win_const_mgr.add_const('RBBIM_CHEVRONSTATE',0x00002000)
    win_const_mgr.add_const('ISOPROTO_X25',0x00000020)
    win_const_mgr.add_const('SPI_SETHIGHCONTRAST',0x00000043)
    win_const_mgr.add_const('CRL_REASON_CESSATION_OF_OPERATION_FLAG',0x00000004)
    win_const_mgr.add_const('CM_PROB_NEED_RESTART',0x0000000E)
    win_const_mgr.add_const('HTTP_QUERY_CONTENT_DESCRIPTION',0x00000004)
    win_const_mgr.add_const('GETSETPAPERMETRICS',0x00000023)
    win_const_mgr.add_const('ALERT_SYSTEM_QUERY',0x00000004)
    win_const_mgr.add_const('MD_APPPOOL_IDENTITY_TYPE_LOCALSERVICE',0x00000001)
    win_const_mgr.add_const('HHWIN_BUTTON_CONTENTS',0x00000001)
    win_const_mgr.add_const('KERN_CONTEXT_CERT_INFO_V1',0x00000000)
    win_const_mgr.add_const('DI_FLAGSEX_ALTPLATFORM_DRVSEARCH',0x10000000)
    win_const_mgr.add_const('STATE_SYSTEM_EXTSELECTABLE',0x02000000)
    win_const_mgr.add_const('LINEDEVSTATE_TRANSLATECHANGE',0x00400000)
    win_const_mgr.add_const('MCI_DGV_STATUS_SIZE',0x00004010)
    win_const_mgr.add_const('DDSCL_SETDEVICEWINDOW',0x00000100)
    win_const_mgr.add_const('SQL_UP_ON',0x00000001)
    win_const_mgr.add_const('CONFIGFLAG_NET_BOOT',0x00000010)
    win_const_mgr.add_const('LVS_NOCOLUMNHEADER',0x00004000)
    win_const_mgr.add_const('SCRIPT_DIGITSUBSTITUTE_NONE',0x00000001)
    win_const_mgr.add_const('DEBUG_KNOWN_STRUCT_SUPPRESS_TYPE_NAME',0x00000003)
    win_const_mgr.add_const('ERROR_TRANSLATION_COMPLETE',0x000002F5)
    win_const_mgr.add_const('OID_802_5_CURRENT_FUNCTIONAL',0x02010103)
    win_const_mgr.add_const('DEBUG_TBINFO_AFFINITY',0x00000020)
    win_const_mgr.add_const('CS_BYTEALIGNCLIENT',0x00001000)
    win_const_mgr.add_const('WIA_DIP_HW_CONFIG',0x0000000B)
    win_const_mgr.add_const('STM_SETIMAGE',0x00000172)
    win_const_mgr.add_const('ERROR_REPARSE_TAG_INVALID',0x00001129)
    win_const_mgr.add_const('MFT_STREAMS_UNLIMITED',0xFFFFFFFF)
    win_const_mgr.add_const('CGD_STRING_PROPERTY',0x00000001)
    win_const_mgr.add_const('PST_PC_ROAMABLE',0x00000020)
    win_const_mgr.add_const('DEBUG_SRCFILE_SYMBOL_TOKEN_SOURCE_COMMAND_WIDE',0x00000001)
    win_const_mgr.add_const('HHT_NOWHERE',0x00000001)
    win_const_mgr.add_const('IF_ENABLEEXITKEYRETRIEVAL',0x00000800)
    win_const_mgr.add_const('PANE_NAVIGATION',0x00000005)
    win_const_mgr.add_const('MUI_FILETYPE_LANGUAGE_NEUTRAL_MAIN',0x00000002)
    win_const_mgr.add_const('ALPHA_SHIFT',0x00000018)
    win_const_mgr.add_const('IDM_CELLSPLIT',0x0000089D)
    win_const_mgr.add_const('SQL_AD_ADD_CONSTRAINT_INITIALLY_IMMEDIATE',0x00000040)
    win_const_mgr.add_const('BTH_MFG_ZEEVO',0x00000012)
    win_const_mgr.add_const('CERT_RDN_UNICODE_STRING',0x0000000C)
    win_const_mgr.add_const('TBMF_PAD',0x00000001)
    win_const_mgr.add_const('WINHTTP_OPTION_HANDLE_TYPE',0x00000009)
    win_const_mgr.add_const('WINHTTP_OPTION_REDIRECT_POLICY',0x00000058)
    win_const_mgr.add_const('STARTF_USESTDHANDLES',0x00000100)
    win_const_mgr.add_const('SQL_CONVERT_LONGVARCHAR',0x0000003E)
    win_const_mgr.add_const('CTRY_UNITED_KINGDOM',0x0000002C)
    win_const_mgr.add_const('WM_CONVERTREQUEST',0x0000010A)
    win_const_mgr.add_const('WH_MAX',0x0000000B)
    win_const_mgr.add_const('LINEERR_INVALTRANSFERMODE',0x8000003F)
    win_const_mgr.add_const('DEF_PWUNIQUENESS',0x00000005)
    win_const_mgr.add_const('IRLMP_ENUMDEVICES',0x00000010)
    win_const_mgr.add_const('SPI_SETDOUBLECLICKTIME',0x00000020)
    win_const_mgr.add_const('AF_TCNMESSAGE',0x0000001E)
    win_const_mgr.add_const('DISPID_RETREATERROR',0x0000000B)
    win_const_mgr.add_const('FLG_DELREG_OPERATION_MASK',0x000000FE)
    win_const_mgr.add_const('PHONEBUTTONSTATE_DOWN',0x00000002)
    win_const_mgr.add_const('PAN_XHEIGHT_DUCKING_LARGE',0x00000007)
    win_const_mgr.add_const('GESTURE_DOUBLE_CURLICUE',0x00000000)
    win_const_mgr.add_const('LANG_GUJARATI',0x00000047)
    win_const_mgr.add_const('OBM_RGARROWI',0x00007FDF)
    win_const_mgr.add_const('IDM_ZOOMPERCENT',0x00000032)
    win_const_mgr.add_const('META_SETRELABS',0x00000105)
    win_const_mgr.add_const('LANG_MARATHI',0x00000004)
    win_const_mgr.add_const('STREAM_FORMAT_WIN32_MODULE',0x00000002)
    win_const_mgr.add_const('SECURITY_RESTRICTED_CODE_RID',0x0000000C)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_CSWITCH',0x00000010)
    win_const_mgr.add_const('DEBUG_BREAKPOINT_ADDER_ONLY',0x00000008)
    win_const_mgr.add_const('NDR_CONTEXT_HANDLE_NOSERIALIZE',0x00000004)
    win_const_mgr.add_const('RF_STROKEREORDER',0x00002000)
    win_const_mgr.add_const('ICM_SET_MODE',0x00000001)
    win_const_mgr.add_const('DTS_LONGDATEFORMAT',0x00000004)
    win_const_mgr.add_const('IDM_1D',0x0000087A)
    win_const_mgr.add_const('FTP_TRANSFER_TYPE_ASCII',0x00000001)
    win_const_mgr.add_const('DEBUG_VALUE_INT16',0x00000002)
    win_const_mgr.add_const('SSA_NOKASHIDA',0x80000000)
    win_const_mgr.add_const('OFN_NODEREFERENCELINKS',0x00100000)
    win_const_mgr.add_const('IDD_ACMFILTERCHOOSE_BTN_DELNAME',0x00000068)
    win_const_mgr.add_const('L2CAP_MIN_MTU',0x00000030)
    win_const_mgr.add_const('IME_MODE_NOCODEINPUT',0x00000100)
    win_const_mgr.add_const('SOCK_RDM',0x00000004)
    win_const_mgr.add_const('FILE_DEVICE_TAPE',0x00000001)
    win_const_mgr.add_const('IPSEC_POLICY_FLAG_ND_BOUNDARY',0x00000004)
    win_const_mgr.add_const('OID_WAN_PROTOCOL_TYPE',0x04010104)
    win_const_mgr.add_const('JOB_OBJECT_UILIMIT_HANDLES',0x00000001)
    win_const_mgr.add_const('MOUSEEVENTF_MOVE',0x00000001)
    win_const_mgr.add_const('SFC_DISABLE_SETUP',0x00000003)
    win_const_mgr.add_const('SPFILENOTIFY_QUEUESCAN_SIGNERINFO',0x00000040)
    win_const_mgr.add_const('WAVE_FORMAT_44S08',0x00000200)
    win_const_mgr.add_const('INTERNET_OPTION_DETECT_POST_SEND',0x00000047)
    win_const_mgr.add_const('DOT11_ASSOC_STATUS_IHV_START',0x80000000)
    win_const_mgr.add_const('FILE_TYPE_PIPE',0x00000003)
    win_const_mgr.add_const('OPTION_NETWORK_INFO_SERVERS',0x00000029)
    win_const_mgr.add_const('EAP_E_SERVER_ROOT_CERT_NAME_REQUIRED',0x80420406)
    win_const_mgr.add_const('DBT_DEVTYP_OEM',0x00000000)
    win_const_mgr.add_const('D3DPRESENTFLAG_LOCKABLE_BACKBUFFER',0x00000001)
    win_const_mgr.add_const('WSA_QOS_EUNKOWNPSOBJ',0x00002B10)
    win_const_mgr.add_const('FILE_DEVICE_MOUSE',0x00000000)
    win_const_mgr.add_const('TH32CS_INHERIT',0x80000000)
    win_const_mgr.add_const('OBM_OLD_UPARROW',0x00007FFD)
    win_const_mgr.add_const('IMAGE_SCN_LNK_NRELOC_OVFL',0x01000000)
    win_const_mgr.add_const('SQL_RESET_YES',0x00000001)
    win_const_mgr.add_const('DS_GFTI_UPDATE_TDO',0x00000001)
    win_const_mgr.add_const('IMN_SETOPENSTATUS',0x00000008)
    win_const_mgr.add_const('DA_LAST',0x7FFFFFFF)
    win_const_mgr.add_const('ACM_METRIC_COUNT_LOCAL_CONVERTERS',0x00000016)
    win_const_mgr.add_const('MCI_SET',0x0000080D)
    win_const_mgr.add_const('SPI_SETDESKPATTERN',0x00000015)
    win_const_mgr.add_const('WINTRUST_MAX_HASH_BYTES_TO_MAP_DEFAULT',0x00100000)
    win_const_mgr.add_const('ISO_GLOBAL',0x00000001)
    win_const_mgr.add_const('WHDR_ENDLOOP',0x00000008)
    win_const_mgr.add_const('DSF_WIA_CAMERAS',0x00000002)
    win_const_mgr.add_const('COD_PERIPHERAL_MINOR_POINTER_MASK',0x00000020)
    win_const_mgr.add_const('LM20_DEVLEN',0x00000008)
    win_const_mgr.add_const('VK_OEM_FJ_LOYA',0x00000095)
    win_const_mgr.add_const('POLICY_VIEW_AUDIT_INFORMATION',0x00000002)
    win_const_mgr.add_const('R2_MERGEPENNOT',0x0000000E)
    win_const_mgr.add_const('ERROR_USER_EXISTS',0x00000524)
    win_const_mgr.add_const('WLX_PROFILE_TYPE_V2_0',0x00000002)
    win_const_mgr.add_const('SFVM_QUERYFSNOTIFY',0x00000019)
    win_const_mgr.add_const('SPFILELOG_QUERYONLY',0x00000004)
    win_const_mgr.add_const('OID_GEN_MAXIMUM_FRAME_SIZE',0x00010106)
    win_const_mgr.add_const('VIEW_LIST',0x00000002)
    win_const_mgr.add_const('DEBUG_CDS_REGISTERS',0x00000001)
    win_const_mgr.add_const('SFVM_COLUMNCLICK',0x00000018)
    win_const_mgr.add_const('SQLINT2',0x00000034)
    win_const_mgr.add_const('IMAGE_COMDAT_SELECT_ASSOCIATIVE',0x00000005)
    win_const_mgr.add_const('SERVICE_UNINSTALLABLE',0x00000010)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2TAOEVENTARGS_CURRENTTRACKNUMBER',0x00000300)
    win_const_mgr.add_const('KAGPROP_OUTERJOINS',0x00000013)
    win_const_mgr.add_const('SQLINT4',0x00000038)
    win_const_mgr.add_const('KS_NABTS_GROUPID_ORIGINAL_CONTENT_ADVERTISER_BASE',0x00000810)
    win_const_mgr.add_const('SQLINT8',0x00000007)
    win_const_mgr.add_const('TF_CLUIE_DOCUMENTMGR',0x00000001)
    win_const_mgr.add_const('DB_DISP_CA_CERT_CHAIN',0x00000010)
    win_const_mgr.add_const('JOY_CAL_READVONLY',0x08000000)
    win_const_mgr.add_const('SO_CONNOPT',0x00007001)
    win_const_mgr.add_const('DISPID_ONKEYUP',0x0000000E)
    win_const_mgr.add_const('IPPROTO_IP',0x00000000)
    win_const_mgr.add_const('PORT_NETNEWS',0x00000214)
    win_const_mgr.add_const('SCH_CRED_REVOCATION_CHECK_END_CERT',0x00000100)
    win_const_mgr.add_const('HEAP_ZERO_MEMORY',0x00000008)
    win_const_mgr.add_const('TF_MENUREADY',0x00000001)
    win_const_mgr.add_const('TAPE_DRIVE_WRITE_LONG_FMKS',0x88000000)
    win_const_mgr.add_const('DDSCAPS_WRITEONLY',0x00010000)
    win_const_mgr.add_const('DDSGR_CALIBRATE',0x00000001)
    win_const_mgr.add_const('SHIMSTCAPFLAG_PURGEABLE',0x00000002)
    win_const_mgr.add_const('CERT_KEY_CONTEXT_PROP_ID',0x00000005)
    win_const_mgr.add_const('ANY_SIZE',0x00000001)
    win_const_mgr.add_const('ERROR_WRITE_PROTECT',0x00000013)
    win_const_mgr.add_const('URLACTION_CLIENT_CERT_PROMPT',0x00001A04)
    win_const_mgr.add_const('WIA_DPS_ENDORSER_CHARACTERS',0x00000C14)
    win_const_mgr.add_const('RPC_PROTSEQ_LRPC',0x00000003)
    win_const_mgr.add_const('LAYOUT_BTT',0x00000002)
    win_const_mgr.add_const('ERROR_LOST_WRITEBEHIND_DATA',0x00000254)
    win_const_mgr.add_const('SM_CYKANJIWINDOW',0x00000012)
    win_const_mgr.add_const('DISPID_SELECTEDITEMCHANGED',0x000000DC)
    win_const_mgr.add_const('WM_XBUTTONDBLCLK',0x0000020D)
    win_const_mgr.add_const('MDDISPINFO_DRILLED_DOWN',0x00010000)
    win_const_mgr.add_const('MMIO_READWRITE',0x00000002)
    win_const_mgr.add_const('DBPROPVAL_TI_READCOMMITTED',0x00001000)
    win_const_mgr.add_const('OID_FDDI_MAC_UPSTREAM_NBR',0x03030225)
    win_const_mgr.add_const('COD_MAJOR_PERIPHERAL',0x00000005)
    win_const_mgr.add_const('TASK_APRIL',0x00000008)
    win_const_mgr.add_const('TWOSTOPBITS',0x00000002)
    win_const_mgr.add_const('D3DTEXOPCAPS_MODULATECOLOR_ADDALPHA',0x00040000)
    win_const_mgr.add_const('PORT_NETBIOSSSN',0x0000008B)
    win_const_mgr.add_const('SPI_SETLOWPOWERTIMEOUT',0x00000051)
    win_const_mgr.add_const('CM_REMOVE_UI_OK',0x00000000)
    win_const_mgr.add_const('RIS_INTERFACE_MEDIA_PRESENT',0x00000003)
    win_const_mgr.add_const('DDBLT_COLORFILL',0x00000400)
    win_const_mgr.add_const('DDCAPS2_WIDESURFACES',0x00001000)
    win_const_mgr.add_const('BTH_MFG_CSR',0x0000000A)
    win_const_mgr.add_const('RRF_RT_REG_SZ',0x00000002)
    win_const_mgr.add_const('DMPAPER_ENV_MONARCH',0x00000025)
    win_const_mgr.add_const('WIA_DIP_UI_CLSID',0x0000000A)
    win_const_mgr.add_const('BM_GETIMAGE',0x000000F6)
    win_const_mgr.add_const('D3DCREATE_FPU_PRESERVE',0x00000002)
    win_const_mgr.add_const('MDM_V110_SPEED_4DOT8K',0x00000003)
    win_const_mgr.add_const('KRB_NT_SRV_XHST',0x00000004)
    win_const_mgr.add_const('VK_CANCEL',0x00000003)
    win_const_mgr.add_const('MOD_SWSYNTH',0x00000007)
    win_const_mgr.add_const('ERROR_UNSUPPORTED_TYPE',0x0000065E)
    win_const_mgr.add_const('LINEEQOSINFO_NOQOS',0x00000001)
    win_const_mgr.add_const('VFF_FILEINUSE',0x00000002)
    win_const_mgr.add_const('CM_GETIDLIST_FILTER_NONE',0x00000000)
    win_const_mgr.add_const('RPC_S_CALL_FAILED',0x000006BE)
    win_const_mgr.add_const('CRYPT_LDAP_INSERT_ENTRY_ATTRIBUTE',0x00008000)
    win_const_mgr.add_const('ISC_REQ_CONFIDENTIALITY',0x00000010)
    win_const_mgr.add_const('IDS_CAP_STAT_VIDEOCURRENT',0x000001FE)
    win_const_mgr.add_const('URLACTION_NETWORK_MAX',0x0000001B)
    win_const_mgr.add_const('BS_NOTIFY',0x00004000)
    win_const_mgr.add_const('USER_ACCT_EXPIRES_PARMNUM',0x00000011)
    win_const_mgr.add_const('POLICY_ERRV_SUBNET_USER_FLOW_RATE',0x00000017)
    win_const_mgr.add_const('DDPCAPS_PRIMARYSURFACE',0x00000010)
    win_const_mgr.add_const('PS_LEN',0x00000006)
    win_const_mgr.add_const('D3DDTCAPS_UDEC3',0x00000040)
    win_const_mgr.add_const('IDM_SHOWCOMMENTTAGS',0x00000914)
    win_const_mgr.add_const('ASPECTXY',0x0000002C)
    win_const_mgr.add_const('SECPKG_ATTR_ROOT_STORE',0x00000055)
    win_const_mgr.add_const('OPTION_PAD',0x00000000)
    win_const_mgr.add_const('MCI_UNDO',0x00000879)
    win_const_mgr.add_const('DS_CENTER',0x00000800)
    win_const_mgr.add_const('IF_TYPE_PROP_DOCS_WIRELESS_UPSTREAM',0x000000B6)
    win_const_mgr.add_const('ALG_SID_RSA_PKCS',0x00000001)
    win_const_mgr.add_const('ERROR_I24_READ_FAULT',0x0000000B)
    win_const_mgr.add_const('PST_PC_SMARTCARD',0x00000004)
    win_const_mgr.add_const('DMPAPER_JENV_CHOU3',0x00000049)
    win_const_mgr.add_const('DDBLTFX_ZBUFFERBASEDEST',0x00000100)
    win_const_mgr.add_const('MCI_OVLY_PUT_SOURCE',0x00020000)
    win_const_mgr.add_const('AM_MPEG_AUDIO_DUAL_LEFT',0x00000001)
    win_const_mgr.add_const('TB_ENDTRACK',0x00000008)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_SCROLL',0x00000488)
    win_const_mgr.add_const('IP_GENERAL_INFO_BASE',0x00000000)
    win_const_mgr.add_const('PRIVACY_TEMPLATE_MEDIUM',0x00000003)
    win_const_mgr.add_const('SCARD_F_INTERNAL_ERROR',0x80100001)
    win_const_mgr.add_const('DEF_PRIORITY',0x00000001)
    win_const_mgr.add_const('VFT2_DRV_SYSTEM',0x00000007)
    win_const_mgr.add_const('NTDDI_WINXPSP1',0x05010100)
    win_const_mgr.add_const('NTDDI_WINXPSP2',0x05010200)
    win_const_mgr.add_const('CFM_BOLD',0x00000001)
    win_const_mgr.add_const('HHWIN_PROP_NO_TOOLBAR',0x00000001)
    win_const_mgr.add_const('OID_FDDI_IF_OUT_NUCAST_PKTS',0x03030289)
    win_const_mgr.add_const('NDIS_PACKET_TYPE_NO_LOCAL',0x00010000)
    win_const_mgr.add_const('HHT_ONDIVOPEN',0x00000008)
    win_const_mgr.add_const('EVENT_MIN_LEVEL',0x00000000)
    win_const_mgr.add_const('ASN_CONSTRUCTOR',0x00000020)
    win_const_mgr.add_const('NET_VALIDATE_LOCKOUT_TIME',0x00000004)
    win_const_mgr.add_const('ERROR_DS_OUT_OF_VERSION_STORE',0x0000217D)
    win_const_mgr.add_const('ERROR_IPSEC_INVALID_PACKET',0x0000365A)
    win_const_mgr.add_const('INTERNET_STATUS_HANDLE_CLOSING',0x00000046)
    win_const_mgr.add_const('POLICY_ERRV_SUBNET_GRP_SUM_FLOW_RATE',0x00000026)
    win_const_mgr.add_const('DATABITS_16X',0x00000020)
    win_const_mgr.add_const('RPC_S_INVALID_TAG',0x000006C5)
    win_const_mgr.add_const('LSA_FTRECORD_DISABLED_REASONS',0x0000FFFF)
    win_const_mgr.add_const('SPI_SETTOOLTIPANIMATION',0x00001017)
    win_const_mgr.add_const('CRYPT_X942_KEY_LENGTH_BYTE_LENGTH',0x00000004)
    win_const_mgr.add_const('CRYPT_ACQUIRE_NO_HEALING',0x00000008)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_INTERACTIVE',0x80000800)
    win_const_mgr.add_const('SQL_USER_NAME',0x0000002F)
    win_const_mgr.add_const('NMPWAIT_WAIT_FOREVER',0x00000000)
    win_const_mgr.add_const('BTH_MFG_ALCATEL',0x00000024)
    win_const_mgr.add_const('DEV_PORT_SIM',0x00000001)
    win_const_mgr.add_const('WMDM_STATUS_READY',0x00000001)
    win_const_mgr.add_const('TVS_RTLREADING',0x00000040)
    win_const_mgr.add_const('DDCAPS_CANCLIP',0x20000000)
    win_const_mgr.add_const('X3_BTYPE_QP_SIZE_X',0x00000009)
    win_const_mgr.add_const('ALG_SID_KEA',0x00000004)
    win_const_mgr.add_const('MCI_ANIM_WINDOW_DISABLE_STRETCH',0x00200000)
    win_const_mgr.add_const('COD_AUDIO_MINOR_UNCLASSIFIED',0x00000000)
    win_const_mgr.add_const('SQL_API_LOADBYORDINAL',0x000000C7)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_GPDISP',0x00000006)
    win_const_mgr.add_const('VK_HANGEUL',0x00000015)
    win_const_mgr.add_const('HTBOTTOMLEFT',0x00000010)
    win_const_mgr.add_const('CR_INVALID_PRIORITY',0x00000027)
    win_const_mgr.add_const('RUNCMDS_DELAYPOSTCMD',0x00000004)
    win_const_mgr.add_const('DCI_VISIBLE',0x00000010)
    win_const_mgr.add_const('OS_WEBSERVER',0x0000001F)
    win_const_mgr.add_const('STIF_SUPPORT_HEX',0x00000001)
    win_const_mgr.add_const('SECPKG_FLAG_MUTUAL_AUTH',0x00010000)
    win_const_mgr.add_const('INDEX_GUID_SEMANTICTYPE',0x00000005)
    win_const_mgr.add_const('ERROR_NO_DATA_DETECTED',0x00000450)
    win_const_mgr.add_const('SYMSTOREOPT_PASS_IF_EXISTS',0x00000040)
    win_const_mgr.add_const('IPSEC_POLICY_FLAG_NAT_ENCAP_ALLOW_GENERAL_NAT_TRAVERSAL',0x00000020)
    win_const_mgr.add_const('LDAP_RES_MODRDN',0x00000006)
    win_const_mgr.add_const('MCI_MONITOR',0x00000871)
    win_const_mgr.add_const('VALID_NTFT',0x000000C0)
    win_const_mgr.add_const('API_RECEIVE_RESPONSE',0x00000001)
    win_const_mgr.add_const('D3DFVF_XYZB2',0x00000008)
    win_const_mgr.add_const('ERROR_DS_ALIAS_DEREF_PROBLEM',0x00002034)
    win_const_mgr.add_const('CAUSE_CHANNEL_NONEXISTENT',0x00000052)
    win_const_mgr.add_const('PSNRET_INVALID',0x00000001)
    win_const_mgr.add_const('WM_PENWINLAST',0x0000038F)
    win_const_mgr.add_const('LB_ADDSTRING',0x00000180)
    win_const_mgr.add_const('LVGF_TASK',0x00000200)
    win_const_mgr.add_const('MFASYNC_CALLBACK_QUEUE_LONG_FUNCTION',0x00000007)
    win_const_mgr.add_const('IDM_SPECIALCHAR',0x0000086C)
    win_const_mgr.add_const('TMT_NOETCHEDEFFECT',0x000008A7)
    win_const_mgr.add_const('LANG_LITHUANIAN',0x00000027)
    win_const_mgr.add_const('KS_VIDEOSTREAM_CC',0x00000100)
    win_const_mgr.add_const('DNS_RTYPE_KEY',0x00001900)
    win_const_mgr.add_const('INTERNET_OPTION_CONNECTED_STATE',0x00000032)
    win_const_mgr.add_const('ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED',0x00003B66)
    win_const_mgr.add_const('MAX_INTERPRETER_OUT_SIZE',0x00000080)
    win_const_mgr.add_const('DBPROP_INIT_TREATASOFFLINE',0x00000004)
    win_const_mgr.add_const('PSR_PK',0x0000000F)
    win_const_mgr.add_const('SQL_FN_NUM_TRUNCATE',0x00800000)
    win_const_mgr.add_const('DXVA_MV_PRECISION_AND_CHROMA_RELATION_MPEG2',0x00000000)
    win_const_mgr.add_const('SQL_CB_PRESERVE',0x00000002)
    win_const_mgr.add_const('SQL_PC_ON',0x00000001)
    win_const_mgr.add_const('WN_VALID_LOGON_ACCOUNT',0x00000001)
    win_const_mgr.add_const('ERROR_SXS_ASSEMBLY_MISSING',0x00003701)
    win_const_mgr.add_const('MCI_VCR_STATUS_VIDEO_RECORD',0x00004017)
    win_const_mgr.add_const('ISOPROTO_TP2',0x0000001B)
    win_const_mgr.add_const('DBPROP_CI_EXCLUDE_SCOPES',0x00000005)
    win_const_mgr.add_const('DEBUG_OUTTYPE_COMPACT_OUTPUT',0x00000008)
    win_const_mgr.add_const('D3DRENDERSTATE_WRAPBIAS',0x00000080)
    win_const_mgr.add_const('DOMAIN_PASSWORD_NO_CLEAR_CHANGE',0x00000004)
    win_const_mgr.add_const('ISOPROTO_TP4',0x0000001D)
    win_const_mgr.add_const('SORT_CHINESE_PRCP',0x00000000)
    win_const_mgr.add_const('NLS_CP_CPINFO',0x10000000)
    win_const_mgr.add_const('DSDSOF_DSAVAILABLE',0x40000000)
    win_const_mgr.add_const('OID_FDDI_IF_IN_DISCARDS',0x03030284)
    win_const_mgr.add_const('GESTURE_RIGHT_ARROW_UP',0x00000000)
    win_const_mgr.add_const('ERROR_DISK_CHANGE',0x0000006B)
    win_const_mgr.add_const('DDGBS_ISBLTDONE',0x00000002)
    win_const_mgr.add_const('LINETRANSLATERESULT_NOTINTOLLLIST',0x00000020)
    win_const_mgr.add_const('DBT_USERDEFINED',0x0000FFFF)
    win_const_mgr.add_const('DCI_STATUS_STRIDECHANGED',0x00000002)
    win_const_mgr.add_const('CERT_ALT_NAME_IP_ADDRESS',0x00000008)
    win_const_mgr.add_const('CRLF_PRESERVE_REVOKED_CA_CERTS',0x00080000)
    win_const_mgr.add_const('SCRIPTPROP_BUILDNUMBER',0x00000003)
    win_const_mgr.add_const('BL_16M',0x01000000)
    win_const_mgr.add_const('SW_SHOWMAXIMIZED',0x00000003)
    win_const_mgr.add_const('SFVM_GETHELPTEXT',0x00000003)
    win_const_mgr.add_const('KS_CC_SUBSTREAM_EVEN',0x00000002)
    win_const_mgr.add_const('MCI_FORMAT_MSF',0x00000002)
    win_const_mgr.add_const('EM_LINEINDEX',0x000000BB)
    win_const_mgr.add_const('MS_CTS_ON',0x00000010)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_MAGIC_NUMBER_2',0x00000001)
    win_const_mgr.add_const('SECPKG_ATTR_CIPHER_STRENGTHS',0x00000057)
    win_const_mgr.add_const('MP_STATUS_CATEGORIZED',0x00000005)
    win_const_mgr.add_const('WMDM_S_NOT_ALL_PROPERTIES_RETRIEVED',0x00045002)
    win_const_mgr.add_const('MD_USER_ISOLATION_AD',0x00000002)
    win_const_mgr.add_const('MD_ERROR_SUB403_SSL128_REQUIRED',0x00000005)
    win_const_mgr.add_const('INF_STYLE_CACHE_ENABLE',0x00000010)
    win_const_mgr.add_const('CDO_E_PROP_NONHEADER',0x8004022A)
    win_const_mgr.add_const('ACTRL_DELETE',0x08000000)
    win_const_mgr.add_const('DOSOPTF_USESPMODE',0x00000008)
    win_const_mgr.add_const('SQL_SP_MATCH_UNIQUE_FULL',0x00000020)
    win_const_mgr.add_const('CDS_FULLSCREEN',0x00000004)
    win_const_mgr.add_const('USE_QWORD_JUMP',0x00000040)
    win_const_mgr.add_const('CR_REMOTE_COMM_FAILURE',0x00000030)
    win_const_mgr.add_const('ERROR_DHCP_ADDRESS_CONFLICT',0x00001004)
    win_const_mgr.add_const('SQL_DESC_OCTET_LENGTH',0x000003F5)
    win_const_mgr.add_const('IDI_QUESTION',0x00007F02)
    win_const_mgr.add_const('ERROR_WAIT_3',0x000002DD)
    win_const_mgr.add_const('ERROR_WAIT_2',0x000002DC)
    win_const_mgr.add_const('ERROR_WAIT_1',0x000002DB)
    win_const_mgr.add_const('MCI_DGV_RECORD_AUDIO_STREAM',0x00040000)
    win_const_mgr.add_const('CMSG_CTRL_MAIL_LIST_DECRYPT',0x00000012)
    win_const_mgr.add_const('MUI_NON_LANG_NEUTRAL_FILE',0x00000200)
    win_const_mgr.add_const('IME_CMODE_KATAKANA',0x00000002)
    win_const_mgr.add_const('META_CREATEPALETTE',0x00000000)
    win_const_mgr.add_const('JOB_OBJECT_LIMIT_BREAKAWAY_OK',0x00000800)
    win_const_mgr.add_const('INTERNET_OPTION_DIGEST_AUTH_UNLOAD',0x0000004C)
    win_const_mgr.add_const('APPCOMMAND_MEDIA_RECORD',0x00000030)
    win_const_mgr.add_const('PSM_HID_INTERRUPT',0x00000013)
    win_const_mgr.add_const('MD_CPU_THROTTLE',0x00000003)
    win_const_mgr.add_const('DBPROPVAL_TC_DDL_LOCK',0x00000010)
    win_const_mgr.add_const('COLOR_GRADIENTACTIVECAPTION',0x0000001B)
    win_const_mgr.add_const('PS_1M',0x00000014)
    win_const_mgr.add_const('DEBUG_OUTPUT_DEBUGGEE_PROMPT',0x00000100)
    win_const_mgr.add_const('DLL_PROCESS_DETACH',0x00000000)
    win_const_mgr.add_const('RP_DSN_NOTIFY_INVALID',0x00000000)
    win_const_mgr.add_const('STDPROP_INDEX_LENGTH',0x000000CB)
    win_const_mgr.add_const('NIIF_NDIS_ENDPOINT_INTERFACE',0x00000040)
    win_const_mgr.add_const('DISPID_SHOWBROWSERUI',0x0000000D)
    win_const_mgr.add_const('DMA_ENTRY',0x00000004)
    win_const_mgr.add_const('RF_ADVISEINKCHANGE',0x00001000)
    win_const_mgr.add_const('DEBUG_VALUE_FLOAT80',0x00000007)
    win_const_mgr.add_const('UPDP_SILENT_UPLOAD',0x00000001)
    win_const_mgr.add_const('AVI_INDEX_OF_CHUNKS',0x00000001)
    win_const_mgr.add_const('CR_FLG_PUBLISHERROR',0x80000000)
    win_const_mgr.add_const('TMREGISTER',0x00000001)
    win_const_mgr.add_const('OFN_EXPLORER',0x00080000)
    win_const_mgr.add_const('PROPID_MGMT_QUEUE_BASE',0x00000000)
    win_const_mgr.add_const('DCI_STATUS_WASSTILLDRAWING',0x00000020)
    win_const_mgr.add_const('D3DDEVCAPS_EXECUTESYSTEMMEMORY',0x00000010)
    win_const_mgr.add_const('TR_MA',0x00000002)
    win_const_mgr.add_const('ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2',0x0000218A)
    win_const_mgr.add_const('MDPROPVAL_MJC_MULTICUBES',0x00000002)
    win_const_mgr.add_const('IPSEC_SA_BUNDLE_FLAG_ND_PEER_NAT_BOUNDARY',0x00000004)
    win_const_mgr.add_const('MAXIMUM_ALLOWED',0x02000000)
    win_const_mgr.add_const('IDM_MARQUEE',0x00000886)
    win_const_mgr.add_const('TC_NOTIFY_FLOW_CLOSE',0x00000005)
    win_const_mgr.add_const('RP_HANDLED',0x00000010)
    win_const_mgr.add_const('ISOPROTO_TP3',0x0000001C)
    win_const_mgr.add_const('FWPM_NET_EVENT_FLAG_APP_ID_SET',0x00000020)
    win_const_mgr.add_const('CM_DRP_UI_NUMBER_DESC_FORMAT',0x0000001E)
    win_const_mgr.add_const('DMBIN_USER',0x00000100)
    win_const_mgr.add_const('STRINGFORMAT_DBCS',0x00000002)
    win_const_mgr.add_const('SQL_FN_TD_DAYNAME',0x00008000)
    win_const_mgr.add_const('GPO_INFO_FLAG_BACKGROUND',0x00000010)
    win_const_mgr.add_const('SQL_FETCH_FIRST',0x00000002)
    win_const_mgr.add_const('SQL_CP_OFF',0x00000000)
    win_const_mgr.add_const('SQL_NULLABLE_UNKNOWN',0x00000002)
    win_const_mgr.add_const('CRLF_REBUILD_MODIFIED_SUBJECT_ONLY',0x00000020)
    win_const_mgr.add_const('ISR_PROBE',0x00000002)
    win_const_mgr.add_const('ST_SELECTION',0x00000002)
    win_const_mgr.add_const('ERROR_NOT_ENOUGH_QUOTA',0x00000718)
    win_const_mgr.add_const('SV_ACCESSALERT_PARMNUM',0x00000028)
    win_const_mgr.add_const('PDH_PLA_SERVICE_ERROR',0xC0000BF1)
    win_const_mgr.add_const('ACM_STREAMSIZEF_SOURCE',0x00000000)
    win_const_mgr.add_const('ES_OEMCONVERT',0x00000400)
    win_const_mgr.add_const('SQL_CODE_MONTH',0x00000002)
    win_const_mgr.add_const('ENM_PAGECHANGE',0x00000040)
    win_const_mgr.add_const('EVT_WRITE_ACCESS',0x00000002)
    win_const_mgr.add_const('ERROR_INVALID_SERVICE_CONTROL',0x0000041C)
    win_const_mgr.add_const('PSH_PROPTITLE',0x00000001)
    win_const_mgr.add_const('N_TSHIFT',0x00000002)
    win_const_mgr.add_const('DC_BINADJUST',0x00000013)
    win_const_mgr.add_const('DNSSEC_KEY_FLAG_ZONE',0x00000040)
    win_const_mgr.add_const('MUTZ_FORCE_INTRANET_FLAGS',0x00002000)
    win_const_mgr.add_const('D3DDEVCAPS2_DMAPNPATCH',0x00000002)
    win_const_mgr.add_const('STORAGE_PRIORITY_HINT_SUPPORTED',0x00000001)
    win_const_mgr.add_const('DNS_ERROR_NODE_IS_CNAME',0x000025EC)
    win_const_mgr.add_const('STATURL_QUERYFLAG_TOPLEVEL',0x00080000)
    win_const_mgr.add_const('MCI_FORMAT_SMPTE_30',0x00000006)
    win_const_mgr.add_const('EVENT_SYSTEM_MENUPOPUPSTART',0x00000006)
    win_const_mgr.add_const('SPI_SETSHOWIMEUI',0x0000006F)
    win_const_mgr.add_const('BTH_ERROR_ACL_CONNECTION_ALREADY_EXISTS',0x00000000)
    win_const_mgr.add_const('INTERNET_PER_CONN_AUTOCONFIG_SECONDARY_URL',0x00000006)
    win_const_mgr.add_const('DXVA_CONFIG_DATA_TYPE_AYUV',0x00000003)
    win_const_mgr.add_const('SUBLANG_VIETNAMESE_VIETNAM',0x00000001)
    win_const_mgr.add_const('WM_LBUTTONUP',0x00000202)
    win_const_mgr.add_const('ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED',0x000013D7)
    win_const_mgr.add_const('TCIF_STATE',0x00000010)
    win_const_mgr.add_const('RENDBIND_DEFAULTUSERNAME',0x00000004)
    win_const_mgr.add_const('MC_CAPS_MONITOR_TECHNOLOGY_TYPE',0x00000001)
    win_const_mgr.add_const('SQL_CONVERT_DATE',0x00000039)
    win_const_mgr.add_const('HSHELL_WINDOWACTIVATED',0x00000004)
    win_const_mgr.add_const('CONSOLE_TEXTMODE_BUFFER',0x00000001)
    win_const_mgr.add_const('INCLUDED_FDI',0x00000001)
    win_const_mgr.add_const('PRAGMA_DEPRECATED_DDK',0x00000000)
    win_const_mgr.add_const('DFCS_CAPTIONRESTORE',0x00000003)
    win_const_mgr.add_const('JIFMK_JPG11',0x0000FFFB)
    win_const_mgr.add_const('EAP_FLAG_MACHINE_AUTH',0x00000020)
    win_const_mgr.add_const('TBCDRF_HILITEHOTTRACK',0x00020000)
    win_const_mgr.add_const('DSOP_FILTER_GLOBAL_GROUPS_SE',0x00000080)
    win_const_mgr.add_const('DEFAULT_GUI_FONT',0x00000011)
    win_const_mgr.add_const('SQL_ATTR_DISCONNECT_BEHAVIOR',0x00000072)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_HINT',0x00000008)
    win_const_mgr.add_const('DEBUG_EVENT_CREATE_PROCESS',0x00000010)
    win_const_mgr.add_const('ISQLANG_V1',0x00000001)
    win_const_mgr.add_const('ISQLANG_V2',0x00000002)
    win_const_mgr.add_const('FAULT_DEVICE_INTERNAL_ERROR',0x000001F5)
    win_const_mgr.add_const('D3DTEXOPCAPS_SELECTARG2',0x00000004)
    win_const_mgr.add_const('ACCESS_FAIL_SHIFT',0x00000004)
    win_const_mgr.add_const('OID_GEN_ALIAS',0x00010289)
    win_const_mgr.add_const('SUBLANG_ENGLISH_SOUTH_AFRICA',0x00000007)
    win_const_mgr.add_const('IMAGE_SCN_ALIGN_1024BYTES',0x00B00000)
    win_const_mgr.add_const('VK_BACK',0x00000008)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_SETWRITESPEED',0x00000202)
    win_const_mgr.add_const('D3DPTADDRESSCAPS_MIRRORONCE',0x00000020)
    win_const_mgr.add_const('CALL_PENDING',0x00000002)
    win_const_mgr.add_const('WTS_PROTOCOL_TYPE_RDP',0x00000002)
    win_const_mgr.add_const('SQL_CA1_BULK_FETCH_BY_BOOKMARK',0x00080000)
    win_const_mgr.add_const('TF_SENTENCEMODE_NONE',0x00000000)
    win_const_mgr.add_const('ISMEX_CALLBACK',0x00000004)
    win_const_mgr.add_const('WMS_CONTAINER_PART_OF_PLAYLIST',0x00000020)
    win_const_mgr.add_const('DNS_ERROR_RCODE_REFUSED',0x0000232D)
    win_const_mgr.add_const('WIA_DATA_DITHER',0x00000001)
    win_const_mgr.add_const('DEVLEN',0x00000050)
    win_const_mgr.add_const('OID_FDDI_IF_LAST_CHANGE',0x03030280)
    win_const_mgr.add_const('WVR_VREDRAW',0x00000200)
    win_const_mgr.add_const('ERROR_CLUSTER_NODE_NOT_PAUSED',0x000013C2)
    win_const_mgr.add_const('ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT',0x00003715)
    win_const_mgr.add_const('SE_ERR_ACCESSDENIED',0x00000005)
    win_const_mgr.add_const('OID_LTALK_NO_DATA_ERRORS',0x05020204)
    win_const_mgr.add_const('INDEX_GUID_ASCENDER',0x00000007)
    win_const_mgr.add_const('PI_APPLYPOLICY',0x00000002)
    win_const_mgr.add_const('IDD_DYNAWIZ_SELECTDEV_PAGE',0x00002719)
    win_const_mgr.add_const('IMAGE_REL_M32R_REFLO',0x0000000A)
    win_const_mgr.add_const('MANAGED_APPTYPE_UNSUPPORTED',0x00000003)
    win_const_mgr.add_const('SERVICE_REDIR_COMM_PAUSED',0x00000400)
    win_const_mgr.add_const('ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND',0x00003A9A)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_FORWARD',0x0000000C)
    win_const_mgr.add_const('LIF_ITEMINDEX',0x00000001)
    win_const_mgr.add_const('MD_GLOBAL_XMLSCHEMATIMESTAMP',0x00002708)
    win_const_mgr.add_const('MD_CPU_ENABLE_TOTAL_PROCS',0x00000020)
    win_const_mgr.add_const('SQL_RETURN_VALUE',0x00000005)
    win_const_mgr.add_const('WINHTTP_QUERY_STATUS_TEXT',0x00000014)
    win_const_mgr.add_const('CRYPTPROTECT_CRED_SYNC',0x00000008)
    win_const_mgr.add_const('SPEAKER_TOP_BACK_LEFT',0x00008000)
    win_const_mgr.add_const('IPPROTO_IGMP',0x00000002)
    win_const_mgr.add_const('SQL_DROP_TRANSLATION',0x0000008E)
    win_const_mgr.add_const('CREATE_FOR_IMPORT',0x00000001)
    win_const_mgr.add_const('BTH_ERROR_PAGE_TIMEOUT',0x00000004)
    win_const_mgr.add_const('SSRVOPT_PROXY',0x00001000)
    win_const_mgr.add_const('SDP_SERVICE_SEARCH_REQUEST',0x00000001)
    win_const_mgr.add_const('CONNECT_CMD_SAVECRED',0x00001000)
    win_const_mgr.add_const('INTERNET_STATUS_FILTER_SENDING',0x00000010)
    win_const_mgr.add_const('LVFI_WRAP',0x00000020)
    win_const_mgr.add_const('KSATTRIBUTE_REQUIRED',0x00000001)
    win_const_mgr.add_const('GESTURE_BRACE_OVER',0x00000000)
    win_const_mgr.add_const('SDP_ATTRIB_HID_DESCRIPTOR_LIST',0x00000206)
    win_const_mgr.add_const('SS_REALSIZEIMAGE',0x00000800)
    win_const_mgr.add_const('BG_E_REMOTE_NOT_SUPPORTED',0x80200014)
    win_const_mgr.add_const('WMDRM_CERTIFICATE_TYPE_XML',0x00000001)
    win_const_mgr.add_const('WM_CHARTOITEM',0x0000002F)
    win_const_mgr.add_const('EPSPRINTING',0x00000021)
    win_const_mgr.add_const('TBSTYLE_CUSTOMERASE',0x00002000)
    win_const_mgr.add_const('RPC_S_SERVER_TOO_BUSY',0x000006BB)
    win_const_mgr.add_const('RPCFLG_HAS_CALLBACK',0x04000000)
    win_const_mgr.add_const('LVS_EX_MULTIWORKAREAS',0x00002000)
    win_const_mgr.add_const('OVERWRITE_HIDDEN',0x00000004)
    win_const_mgr.add_const('RESOURCE_GLOBALNET',0x00000002)
    win_const_mgr.add_const('ERROR_CTX_WINSTATION_NOT_FOUND',0x00001B6E)
    win_const_mgr.add_const('NIIF_ICON_MASK',0x0000000F)
    win_const_mgr.add_const('IMC_SETCANDIDATEPOS',0x00000008)
    win_const_mgr.add_const('MOUSE_VIRTUAL_DESKTOP',0x00000002)
    win_const_mgr.add_const('ERROR_MUTANT_LIMIT_EXCEEDED',0x0000024B)
    win_const_mgr.add_const('DWFAF_GROUP2',0x00000004)
    win_const_mgr.add_const('PARITY_EVEN',0x00000400)
    win_const_mgr.add_const('DWFAF_GROUP1',0x00000002)
    win_const_mgr.add_const('CM_PROB_DEVLOADER_FAILED',0x00000002)
    win_const_mgr.add_const('EVENT_TRACE_CONTROL_FLUSH',0x00000003)
    win_const_mgr.add_const('ERROR_ADDRESS_ALREADY_ASSOCIATED',0x000004CB)
    win_const_mgr.add_const('IF_TYPE_ARCNET',0x00000023)
    win_const_mgr.add_const('CERT_FIND_OPTIONAL_ENHKEY_USAGE_FLAG',0x00000001)
    win_const_mgr.add_const('MSV1_0_TRY_GUEST_ACCOUNT_ONLY',0x00000100)
    win_const_mgr.add_const('ERROR_LOG_INVALID_RANGE',0x000019CC)
    win_const_mgr.add_const('PRIMARY_CRED_LOGON_PACKAGE_SHIFT',0x00000018)
    win_const_mgr.add_const('AE_AUTODIS',0x00000002)
    win_const_mgr.add_const('SPI_SETDRAGWIDTH',0x0000004C)
    win_const_mgr.add_const('CDERR_NOHINSTANCE',0x00000004)
    win_const_mgr.add_const('CONNECTION_WAN',0x00000002)
    win_const_mgr.add_const('RPC_S_CALL_CANCELLED',0x0000071A)
    win_const_mgr.add_const('SQL_LOGIN_TIMEOUT_DEFAULT',0x0000000F)
    win_const_mgr.add_const('DVASPECT_LINK',0x00000004)
    win_const_mgr.add_const('DISPLAY_DEVICE_MIRRORING_DRIVER',0x00000008)
    win_const_mgr.add_const('LINEERR_INVALMEDIALIST',0x8000002E)
    win_const_mgr.add_const('IDM_INDENT',0x0000088A)
    win_const_mgr.add_const('PD_USELARGETEMPLATE',0x10000000)
    win_const_mgr.add_const('SQL_CTR_CREATE_TRANSLATION',0x00000001)
    win_const_mgr.add_const('ERROR_IEPORT_FULL',0x000010F5)
    win_const_mgr.add_const('UME_VERSION',0x00000000)
    win_const_mgr.add_const('DBPROPVAL_ORS_INDEX',0x00000001)
    win_const_mgr.add_const('BSF_NOLOCALFILEWARNING',0x00000010)
    win_const_mgr.add_const('SQL_SG_DELETE_TABLE',0x00000020)
    win_const_mgr.add_const('ACM_METRIC_HARDWARE_WAVE_OUTPUT',0x0000001F)
    win_const_mgr.add_const('LDAP_DEREF_FINDING',0x00000002)
    win_const_mgr.add_const('ACM_FILTERDETAILSF_INDEX',0x00000000)
    win_const_mgr.add_const('DS_REPL_NBR_PREEMPTED',0x01000000)
    win_const_mgr.add_const('TF_RP_LOCALPROCESS',0x00000004)
    win_const_mgr.add_const('ACM_MPEG_JOINTSTEREO',0x00000002)
    win_const_mgr.add_const('EDITF_ADDOLDKEYUSAGE',0x00000008)
    win_const_mgr.add_const('ALG_SID_RC5',0x0000000D)
    win_const_mgr.add_const('DIRID_PROGRAM_FILES_X86',0x0000402A)
    win_const_mgr.add_const('IF_TYPE_ISO88024_TOKENBUS',0x00000008)
    win_const_mgr.add_const('DV_NTSC',0x00000000)
    win_const_mgr.add_const('CR_INVALID_CONFLICT_LIST',0x00000039)
    win_const_mgr.add_const('CERT_COMPARE_KEY_SPEC',0x00000009)
    win_const_mgr.add_const('SQL_FD_FETCH_RELATIVE',0x00000020)
    win_const_mgr.add_const('RSC_FLAG_SETUPAPI',0x00000400)
    win_const_mgr.add_const('SQL_ISV_USAGE_PRIVILEGES',0x00080000)
    win_const_mgr.add_const('PHONEBUTTONMODE_FEATURE',0x00000004)
    win_const_mgr.add_const('DN_RO',0x00000001)
    win_const_mgr.add_const('WBF_LEVEL1',0x00000080)
    win_const_mgr.add_const('MF_4_BYTE_ALIGNMENT',0x00000003)
    win_const_mgr.add_const('D3DTEXOPCAPS_PREMODULATE',0x00010000)
    win_const_mgr.add_const('AGP_FLAG_REVERSE_INITIALIZATION',0x00000080)
    win_const_mgr.add_const('FROM_LEFT_4TH_BUTTON_PRESSED',0x00000010)
    win_const_mgr.add_const('MD_ERROR_SUB404_VERB_DENIED',0x00000006)
    win_const_mgr.add_const('DESKTOP_CREATEWINDOW',0x00000002)
    win_const_mgr.add_const('ULONG64_ERROR',0x00000000)
    win_const_mgr.add_const('INTERENT_GOONLINE_MASK',0x00000001)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_MAGIC_NUMBER',0x00000001)
    win_const_mgr.add_const('IDM_LINEBREAKNORMAL',0x00000867)
    win_const_mgr.add_const('IF_TYPE_AAL2',0x000000BB)
    win_const_mgr.add_const('KP_MODE_BITS',0x00000005)
    win_const_mgr.add_const('CRED_MAX_CREDENTIAL_BLOB_SIZE',0x00000200)
    win_const_mgr.add_const('HTTP_QUERY_MESSAGE_ID',0x0000000C)
    win_const_mgr.add_const('SV_DISC_PARMNUM',0x0000000A)
    win_const_mgr.add_const('CM_CDMASK_FLAGS',0x00000004)
    win_const_mgr.add_const('ERROR_LOG_SPACE_RESERVED_INVALID',0x000019E2)
    win_const_mgr.add_const('WSAEDESTADDRREQ',0x00002737)
    win_const_mgr.add_const('TBIF_SIZE',0x00000040)
    win_const_mgr.add_const('INTERNET_OPTION_CODEPAGE_EXTRA',0x00000065)
    win_const_mgr.add_const('KSEG4_VRN',0x00000005)
    win_const_mgr.add_const('DSROLE_PRIMARY_DS_MIXED_MODE',0x00000002)
    win_const_mgr.add_const('GL_ID_NOMODULE',0x00000001)
    win_const_mgr.add_const('VMR_RENDER_DEVICE_SYSMEM',0x00000004)
    win_const_mgr.add_const('CA_LOG_FILTER',0x00000002)
    win_const_mgr.add_const('DISPID_UPDATEIMAGE',0x000000DE)
    win_const_mgr.add_const('QUOTA_LIMITS_HARDWS_MIN_DISABLE',0x00000002)
    win_const_mgr.add_const('STREAM_FLAGS_DONTCACHEXSL',0x00000020)
    win_const_mgr.add_const('VREFRESH',0x00000074)
    win_const_mgr.add_const('MPV_WRITE_CONTENT',0x00000002)
    win_const_mgr.add_const('MCI_DGV_WHERE_WINDOW',0x00200000)
    win_const_mgr.add_const('START_PROCESS_RID',0x00000004)
    win_const_mgr.add_const('TF_TMAE_CONSOLE',0x00000040)
    win_const_mgr.add_const('IPP_E_MDAC_VERSION',0xC004800D)
    win_const_mgr.add_const('CACHE_ENTRY_MODTIME_FC',0x00000040)
    win_const_mgr.add_const('CMSG_ENVELOPED',0x00000003)
    win_const_mgr.add_const('PIR_STATUS_MINIPORT_COMPATIBLE',0x00000001)
    win_const_mgr.add_const('TPM_RIGHTBUTTON',0x00000002)
    win_const_mgr.add_const('ICEE_CREATE_MACHINE_ILLEGAL',0x00000000)
    win_const_mgr.add_const('DISPID_AUTOCOMPLETEATTACH',0x0000000C)
    win_const_mgr.add_const('SPI_GETMOUSEVANISH',0x00001020)
    win_const_mgr.add_const('CM_ENABLEHOOK',0x00000001)
    win_const_mgr.add_const('LINEERR_STRUCTURETOOSMALL',0x8000004D)
    win_const_mgr.add_const('AF_UNSPEC',0x00000000)
    win_const_mgr.add_const('STI_TRACE_INFORMATION',0x00000001)
    win_const_mgr.add_const('GGL_PRIVATE',0x00000004)
    win_const_mgr.add_const('IMAGE_SYM_CLASS_LABEL',0x00000006)
    win_const_mgr.add_const('WTS_WSD_SHUTDOWN',0x00000002)
    win_const_mgr.add_const('ERROR_NOT_SAME_DEVICE',0x00000011)
    win_const_mgr.add_const('UPNP_ADDRESSFAMILY_BOTH',0x00000003)
    win_const_mgr.add_const('MM_DRVM_DATA',0x000003D2)
    win_const_mgr.add_const('TAPE_DRIVE_REPORT_SMKS',0x00080000)
    win_const_mgr.add_const('LINEDEVSTATE_INSERVICE',0x00000040)
    win_const_mgr.add_const('RTM_MATCH_NONE',0x00000000)
    win_const_mgr.add_const('SPFILENOTIFY_RENAMEERROR',0x00000000)
    win_const_mgr.add_const('DEBUG_HANDLE_DATA_TYPE_BASIC',0x00000000)
    win_const_mgr.add_const('LVGMF_TEXTCOLOR',0x00000004)
    win_const_mgr.add_const('UNDEFINE_PRIMARY',0x0000000C)
    win_const_mgr.add_const('DBPROP_USECONTENTINDEX',0x00000002)
    win_const_mgr.add_const('CREDUI_MAX_CAPTION_LENGTH',0x00000080)
    win_const_mgr.add_const('SUBLANG_ENGLISH_TRINIDAD',0x00000000)
    win_const_mgr.add_const('MCI_VD_GETDEVCAPS_CLV',0x00010000)
    win_const_mgr.add_const('IDS_POSTED_AT',0x00011003)
    win_const_mgr.add_const('LANG_BASQUE',0x00000002)
    win_const_mgr.add_const('IF_ENABLEADMINASAUDITOR',0x00001000)
    win_const_mgr.add_const('SQL_UB_OFF',0x00000000)
    win_const_mgr.add_const('SUBLANG_TIBETAN_PRC',0x00000001)
    win_const_mgr.add_const('USER_NO_AUTH_DATA_REQUIRED',0x00080000)
    win_const_mgr.add_const('TVGN_PREVIOUS',0x00000002)
    win_const_mgr.add_const('WPP_POST_POSTING_SERVER_ERROR',0xC0042382)
    win_const_mgr.add_const('SPREG_DLLINSTALL',0x00000004)
    win_const_mgr.add_const('LOCALE_SMONDECIMALSEP',0x00000016)
    win_const_mgr.add_const('WSAEINVALIDPROVIDER',0x00002779)
    win_const_mgr.add_const('D3DPS20_MAX_NUMINSTRUCTIONSLOTS',0x00000200)
    win_const_mgr.add_const('CERT_PROT_ROOT_DISABLE_LM_AUTH_FLAG',0x00000008)
    win_const_mgr.add_const('SQL_BP_CLOSE',0x00000001)
    win_const_mgr.add_const('CERT_STORE_PROV_GET_CRL_PROPERTY_FUNC',0x00000013)
    win_const_mgr.add_const('TRUST_AUTH_TYPE_NONE',0x00000000)
    win_const_mgr.add_const('PHYSICALWIDTH',0x0000006E)
    win_const_mgr.add_const('WM_UNDO',0x00000304)
    win_const_mgr.add_const('DDCAPS_READSCANLINE',0x00020000)
    win_const_mgr.add_const('SMART_IDE_ERROR',0x00000001)
    win_const_mgr.add_const('INTERNET_DIAL_UNATTENDED',0x00008000)
    win_const_mgr.add_const('MAX_SCOPE_NAME_LEN',0x000000FF)
    win_const_mgr.add_const('HTTP_QUERY_TRANSFER_ENCODING',0x0000003F)
    win_const_mgr.add_const('DS_NETBIOS_ADDRESS',0x00000002)
    win_const_mgr.add_const('MOUSEEVENTF_WHEEL',0x00000800)
    win_const_mgr.add_const('LOCALE_SDAYNAME5',0x0000002E)
    win_const_mgr.add_const('LOCALE_SDAYNAME4',0x0000002D)
    win_const_mgr.add_const('IDS_CAP_DEFPALEXT',0x00000198)
    win_const_mgr.add_const('ERROR_DS_CANT_DEL_MASTER_CROSSREF',0x000020B7)
    win_const_mgr.add_const('LOCALE_SDAYNAME1',0x0000002A)
    win_const_mgr.add_const('SCESTATUS_RECORD_NOT_FOUND',0x00000002)
    win_const_mgr.add_const('SQL_DROP_VIEW',0x0000008F)
    win_const_mgr.add_const('FEI_MODEM_POWERED_ON',0x00000011)
    win_const_mgr.add_const('WNODE_FLAG_INTERNAL',0x00000100)
    win_const_mgr.add_const('ERROR_SXS_INVALID_ACTCTXDATA_FORMAT',0x000036B2)
    win_const_mgr.add_const('ACMFILTERTAGDETAILS_FILTERTAG_CHARS',0x00000030)
    win_const_mgr.add_const('MAPI_E_ATTACHMENT_WRITE_FAILURE',0x0000000D)
    win_const_mgr.add_const('SECPKG_CRED_DEFAULT',0x00000004)
    win_const_mgr.add_const('D3DSTREAMSOURCE_INSTANCEDATA',0x00000002)
    win_const_mgr.add_const('DDSD_ALPHABITDEPTH',0x00000080)
    win_const_mgr.add_const('SERVICE_IP_WAITTIME_SHIFT',0x00000008)
    win_const_mgr.add_const('SHTDN_REASON_FLAG_DIRTY_UI',0x08000000)
    win_const_mgr.add_const('PHOTO_LIGHTSOURCE_D55',0x00000014)
    win_const_mgr.add_const('ERROR_PATH_BUSY',0x00000094)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_NO_PRIVATE_KEY',0x000035FC)
    win_const_mgr.add_const('SPI_SETICONTITLEWRAP',0x0000001A)
    win_const_mgr.add_const('DIALOPTION_DIALTONE',0x00000100)
    win_const_mgr.add_const('WM_DESTROYCLIPBOARD',0x00000307)
    win_const_mgr.add_const('SQL_XL_ON',0x00000001)
    win_const_mgr.add_const('MIXERCONTROL_CT_CLASS_LIST',0x70000000)
    win_const_mgr.add_const('WS_EX_APPWINDOW',0x00040000)
    win_const_mgr.add_const('LPD_SHARE_ACCUM',0x00000100)
    win_const_mgr.add_const('DNSSEC_KEY_FLAG_NOAUTH',0x00000001)
    win_const_mgr.add_const('SQL_DIAG_SERVER_NAME',0x0000000B)
    win_const_mgr.add_const('ARCONTENT_SVCD',0x00000800)
    win_const_mgr.add_const('SQL_ATTR_PARAM_BIND_OFFSET_PTR',0x00000011)
    win_const_mgr.add_const('SEVERITY_SUCCESS',0x00000000)
    win_const_mgr.add_const('POLICY_ERRV_GLOBAL_USER_PEAK_RATE',0x0000001B)
    win_const_mgr.add_const('IMAPI_SECTORS_PER_SECOND_AT_1X_DVD',0x000002A8)
    win_const_mgr.add_const('D3DUSAGE_QUERY_LEGACYBUMPMAP',0x00008000)
    win_const_mgr.add_const('APPLY_OPTION_FAIL_IF_CLOSE',0x00000002)
    win_const_mgr.add_const('NTDDI_LONGHORN',0x06000000)
    win_const_mgr.add_const('SSF_WIN95CLASSIC',0x00000400)
    win_const_mgr.add_const('HTTP_SERVICE_CONFIG_SSL_FLAG_NEGOTIATE_CLIENT_CERT',0x00000002)
    win_const_mgr.add_const('MCI_OVLY_WINDOW_TEXT',0x00080000)
    win_const_mgr.add_const('AA_S_OPEN',0x00000010)
    win_const_mgr.add_const('TAPE_DRIVE_TENSION_IMMED',0x80000040)
    win_const_mgr.add_const('TBCDRF_USECDCOLORS',0x00800000)
    win_const_mgr.add_const('ADAM_REPL_AUTHENTICATION_MODE_NEGOTIATE_PASS_THROUGH',0x00000000)
    win_const_mgr.add_const('OID_GEN_GET_TIME_CAPS',0x0002020F)
    win_const_mgr.add_const('DSA_NOTIFY_REN',0x00000002)
    win_const_mgr.add_const('SMC_GETBKCONTEXTMENU',0x00000044)
    win_const_mgr.add_const('DBPROPVAL_TC_DML',0x00000001)
    win_const_mgr.add_const('DDSD_WIDTH',0x00000004)
    win_const_mgr.add_const('DE_E_CANNOT_LOCK_REQUEST',0x800C0016)
    win_const_mgr.add_const('MD_EXTLOG_SERVER_PORT',0x00008000)
    win_const_mgr.add_const('GROUP_ATTRIBUTES_PARMNUM',0x00000003)
    win_const_mgr.add_const('CM_DRP_INSTALL_STATE',0x00000023)
    win_const_mgr.add_const('SQL_SR_REFERENCES_COLUMN',0x00000800)
    win_const_mgr.add_const('ERROR_SEM_USER_LIMIT',0x0000006A)
    win_const_mgr.add_const('TVGN_ROOT',0x00000000)
    win_const_mgr.add_const('MSG_SERVICE_CONFIGURE',0x00000003)
    win_const_mgr.add_const('TBSTYLE_EX_DOUBLEBUFFER',0x00000080)
    win_const_mgr.add_const('ERROR_TXF_DIR_NOT_EMPTY',0x00001AAA)
    win_const_mgr.add_const('PATCH_TRANSFORM_PE_RESOURCE_2',0x00000100)
    win_const_mgr.add_const('SYMOPT_NO_PROMPTS',0x00080000)
    win_const_mgr.add_const('SECPKG_ATTR_REMOTE_CRED',0x00000051)
    win_const_mgr.add_const('DOT11_PSD_IE_MAX_ENTRY_NUMBER',0x00000005)
    win_const_mgr.add_const('ACE_INHERITED_OBJECT_TYPE_PRESENT',0x00000002)
    win_const_mgr.add_const('SQL_SCC_XOPEN_CLI_VERSION1',0x00000001)
    win_const_mgr.add_const('DI_MEMORYMAP_WRITE',0x00000001)
    win_const_mgr.add_const('VK_OEM_CLEAR',0x000000FE)
    win_const_mgr.add_const('NDIS_TCP_CONNECTION_OFFLOAD_REVISION_1',0x00000001)
    win_const_mgr.add_const('VER_ERR_TYPE_E',0x00004000)
    win_const_mgr.add_const('ILLUMINANT_D65',0x00000006)
    win_const_mgr.add_const('SQL_API_SQLCOLATTRIBUTES',0x00000006)
    win_const_mgr.add_const('RI_KEY_TERMSRV_SET_LED',0x00000008)
    win_const_mgr.add_const('S_PERIODVOICE',0x00000003)
    win_const_mgr.add_const('PDERR_DNDMMISMATCH',0x00001009)
    win_const_mgr.add_const('POLICY_ERRV_GLOBAL_DEF_SUM_FLOW_RATE',0x00000021)
    win_const_mgr.add_const('DDSD_LPSURFACE',0x00000800)
    win_const_mgr.add_const('LINEERR_INVALAGENTGROUP',0x80000058)
    win_const_mgr.add_const('BS_BOTTOM',0x00000800)
    win_const_mgr.add_const('BL_28M',0x01C00000)
    win_const_mgr.add_const('PSM_BNEP',0x0000000F)
    win_const_mgr.add_const('CRYPT_OID_PUBKEY_ENCRYPT_ONLY_FLAG',0x40000000)
    win_const_mgr.add_const('WM_IME_KEYUP',0x00000291)
    win_const_mgr.add_const('IMAGE_REL_SH3_SIZEOF_SECTION',0x0000000D)
    win_const_mgr.add_const('DISPID_WINDOWSETWIDTH',0x0000010A)
    win_const_mgr.add_const('DISPID_WINDOWREGISTERED',0x000000C8)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_COMPUTERS',0x80000008)
    win_const_mgr.add_const('KF_FLAG_DEFAULT_PATH',0x00000400)
    win_const_mgr.add_const('TPM_RECURSE',0x00000001)
    win_const_mgr.add_const('VER_SUITE_PERSONAL',0x00000200)
    win_const_mgr.add_const('IDM_LEFTALIGNPARA',0x000008CB)
    win_const_mgr.add_const('MCI_OVLY_GETDEVCAPS_CAN_STRETCH',0x00004001)
    win_const_mgr.add_const('DISKQUOTA_USERNAME_RESOLVE_ASYNC',0x00000002)
    win_const_mgr.add_const('D3DDEVCAPS2_STREAMOFFSET',0x00000001)
    win_const_mgr.add_const('WIA_IPS_THRESHOLD',0x0000180F)
    win_const_mgr.add_const('AM_VIDEO_FLAG_B_SAMPLE',0x00000020)
    win_const_mgr.add_const('TVGN_LASTVISIBLE',0x0000000A)
    win_const_mgr.add_const('OID_ARCNET_CURRENT_ADDRESS',0x06010102)
    win_const_mgr.add_const('PRINTER_CONTROL_SET_STATUS',0x00000004)
    win_const_mgr.add_const('HTTP_STATUS_REQUEST_TOO_LARGE',0x0000019D)
    win_const_mgr.add_const('PDH_LOG_FILE_OPEN_ERROR',0xC0000BCA)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_CONNFAIL',0x00000011)
    win_const_mgr.add_const('VER_ERR_TYPE_1',0x00000800)
    win_const_mgr.add_const('SV_USERSECURITY',0x00000001)
    win_const_mgr.add_const('IMAGE_SYM_TYPE_DOUBLE',0x00000007)
    win_const_mgr.add_const('PS_COSMETIC',0x00000000)
    win_const_mgr.add_const('PBT_APMQUERYSUSPENDFAILED',0x00000002)
    win_const_mgr.add_const('ICW_MAX_EMAILNAME',0x00000040)
    win_const_mgr.add_const('LVGS_HIDDEN',0x00000002)
    win_const_mgr.add_const('MDPROPVAL_MNF_AGGREGATE',0x00000010)
    win_const_mgr.add_const('VER_ERR_TYPE_2',0x00001000)
    win_const_mgr.add_const('TF_CLUIE_CURRENTPAGE',0x00000020)
    win_const_mgr.add_const('DIRID_USER',0x00008000)
    win_const_mgr.add_const('LINEMEDIACONTROL_RESUME',0x00000010)
    win_const_mgr.add_const('INTERNET_SUPPRESS_COOKIE_POLICY_RESET',0x00000002)
    win_const_mgr.add_const('GENERATE_METHOD_INFLECT',0x00000002)
    win_const_mgr.add_const('OID_GEN_XMIT_OK',0x00020101)
    win_const_mgr.add_const('TRUST_DIRECTION_DISABLED',0x00000000)
    win_const_mgr.add_const('SF_TEXT',0x00000001)
    win_const_mgr.add_const('CRYPTUI_DONT_OPEN_STORES',0x00000100)
    win_const_mgr.add_const('LOCALE_SCONSOLEFALLBACKNAME',0x00000006)
    win_const_mgr.add_const('CERT_KEY_PROV_HANDLE_PROP_ID',0x00000001)
    win_const_mgr.add_const('MSV1_0_CLEARTEXT_PASSWORD_ALLOWED',0x00000002)
    win_const_mgr.add_const('SDP_ATTRIB_HID_PARSER_VERSION',0x00000201)
    win_const_mgr.add_const('KAGPROP_ODBCSQLCONFORMANCE',0x00000012)
    win_const_mgr.add_const('REG_QWORD',0x0000000B)
    win_const_mgr.add_const('DDCAPS2_CERTIFIED',0x00000001)
    win_const_mgr.add_const('IF_NOLOCALICERTADMINBACKUP',0x00000080)
    win_const_mgr.add_const('OID_802_11_ADD_KEY',0x0D01011D)
    win_const_mgr.add_const('NIIF_INFO',0x00000001)
    win_const_mgr.add_const('ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE',0x000036FF)
    win_const_mgr.add_const('SECURITY_FLAG_STRENGTH_WEAK',0x10000000)
    win_const_mgr.add_const('KSPROPERTY_SUPPORT_GET',0x00000001)
    win_const_mgr.add_const('NDIS_802_11_PMKID_CANDIDATE_PREAUTH_ENABLED',0x00000001)
    win_const_mgr.add_const('IMAGE_REL_AM_REL32_2',0x00000006)
    win_const_mgr.add_const('ISC_REQ_SEQUENCE_DETECT',0x00000008)
    win_const_mgr.add_const('IMAGE_COMDAT_SELECT_NEWEST',0x00000007)
    win_const_mgr.add_const('MFBYTESTREAM_SEEK_FLAG_CANCEL_PENDING_IO',0x00000001)
    win_const_mgr.add_const('ICC_PROGRESS_CLASS',0x00000020)
    win_const_mgr.add_const('NT5_MAJOR_VERSION',0x00000003)
    win_const_mgr.add_const('NO_ERROR',0x00000000)
    win_const_mgr.add_const('DISPID_SEARCHCOMMAND_ERROR',0x00000006)
    win_const_mgr.add_const('DEBUG_FORMAT_USER_SMALL_FILTER_MEMORY',0x00000020)
    win_const_mgr.add_const('SS_ENDELLIPSIS',0x00004000)
    win_const_mgr.add_const('EMARCH_ENC_I17_SIGN_SIZE_X',0x00000001)
    win_const_mgr.add_const('GPO_BROWSE_INITTOALL',0x00000010)
    win_const_mgr.add_const('DS_LIST_ACCOUNT_OBJECT_FOR_SERVER',0x00000002)
    win_const_mgr.add_const('IF_TYPE_TR008',0x000000B0)
    win_const_mgr.add_const('D3DSTENCILCAPS_INCRSAT',0x00000008)
    win_const_mgr.add_const('URLACTION_FEATURE_SCRIPT_STATUS_BAR',0x00002103)
    win_const_mgr.add_const('PGS_HORZ',0x00000001)
    win_const_mgr.add_const('KS_VIDEO_FLAG_I_FRAME',0x00000000)
    win_const_mgr.add_const('CSURL_ADDTOCERTOCSP',0x00000020)
    win_const_mgr.add_const('IMAGE_ROM_OPTIONAL_HDR_MAGIC',0x00000107)
    win_const_mgr.add_const('SCERR_NOGUIDS',0x00008000)
    win_const_mgr.add_const('ARCONTENT_AUDIOCD',0x00000004)
    win_const_mgr.add_const('X3_IMM39_1_SIZE_X',0x00000017)
    win_const_mgr.add_const('MCS_WEEKNUMBERS',0x00000004)
    win_const_mgr.add_const('MOUSE_ATTRIBUTES_CHANGED',0x00000004)
    win_const_mgr.add_const('PORT_INGRESNET',0x00000086)
    win_const_mgr.add_const('TMT_WINDOWFRAME',0x00000647)
    win_const_mgr.add_const('MIXER_OBJECTF_MIXER',0x00000000)
    win_const_mgr.add_const('DFS_PROPERTY_FLAG_INSITE_REFERRALS',0x00000001)
    win_const_mgr.add_const('ERROR_NON_MDICHILD_WINDOW',0x000005A5)
    win_const_mgr.add_const('RSVP_PATH',0x00000001)
    win_const_mgr.add_const('CONTEXT_SERVICE_ACTIVE',0x10000000)
    win_const_mgr.add_const('ELEMENT_STATUS_INENAB',0x00000020)
    win_const_mgr.add_const('MDPROPVAL_NL_NAMEDLEVELS',0x00000001)
    win_const_mgr.add_const('CM_CDFLAGS_ROOT_OWNED',0x00000002)
    win_const_mgr.add_const('URL_CONVERT_IF_DOSPATH',0x00200000)
    win_const_mgr.add_const('LOCALE_SABBREVMONTHNAME5',0x00000048)
    win_const_mgr.add_const('PDH_MAX_INSTANCE_NAME',0x00000400)
    win_const_mgr.add_const('RPC_S_INVALID_ASYNC_HANDLE',0x0000077A)
    win_const_mgr.add_const('RESOURCE_MANAGER_MAXIMUM_OPTION',0x00000003)
    win_const_mgr.add_const('SDP_ATTRIB_PAN_SECURITY_DESCRIPTION',0x0000030A)
    win_const_mgr.add_const('KSAC3_SERVICE_HEARING_IMPAIRED',0x00000003)
    win_const_mgr.add_const('SQL_FN_STR_RIGHT',0x00000200)
    win_const_mgr.add_const('GETTRACKKERNTABLE',0x00000103)
    win_const_mgr.add_const('ERROR_DS_INVALID_GROUP_TYPE',0x00002141)
    win_const_mgr.add_const('SYMSTOREOPT_RETURNINDEX',0x00000004)
    win_const_mgr.add_const('TMT_COPYRIGHT',0x0000025D)
    win_const_mgr.add_const('DDLOCK_WRITEONLY',0x00000020)
    win_const_mgr.add_const('PRINTER_CHANGE_SET_JOB',0x00000200)
    win_const_mgr.add_const('MD_NOTIFY_LOG',0x00000200)
    win_const_mgr.add_const('WIA_FILM_BW_NEGATIVE',0x00000002)
    win_const_mgr.add_const('MB_TOPMOST',0x00040000)
    win_const_mgr.add_const('ERROR_QUORUM_RESOURCE_ONLINE_FAILED',0x000013A3)
    win_const_mgr.add_const('HKCOMB_NONE',0x00000001)
    win_const_mgr.add_const('OID_TAPI_DEV_SPECIFIC',0x07030107)
    win_const_mgr.add_const('DIF_NEWDEVICEWIZARD_POSTANALYZE',0x0000001D)
    win_const_mgr.add_const('SDP_ATTRIB_FAX_AUDIO_FEEDBACK_SUPPORT',0x00000305)
    win_const_mgr.add_const('DNS_RTYPE_MAILA',0x00000000)
    win_const_mgr.add_const('GL_APPLICATION_START',0x00000200)
    win_const_mgr.add_const('ADS_SERVICE_ERROR_SEVERE',0x00000002)
    win_const_mgr.add_const('SPEAKER_FRONT_LEFT',0x00000001)
    win_const_mgr.add_const('CRYPT_USER_KEYSET',0x00001000)
    win_const_mgr.add_const('WM_WINDOWPOSCHANGING',0x00000046)
    win_const_mgr.add_const('SQL_SP_BETWEEN',0x00000800)
    win_const_mgr.add_const('FNOINVERT',0x00000002)
    win_const_mgr.add_const('CR_DEFAULT',0x00000001)
    win_const_mgr.add_const('CB_GETITEMDATA',0x00000150)
    win_const_mgr.add_const('ERROR_RESTART_APPLICATION',0x000005BB)
    win_const_mgr.add_const('IDD_INSERTOBJECT',0x000003E8)
    win_const_mgr.add_const('DECODE_IS_USED',0x00000020)
    win_const_mgr.add_const('DWL_USER',0x00000008)
    win_const_mgr.add_const('PHOTO_ORIENTATION_TRANSPOSE',0x00000005)
    win_const_mgr.add_const('GD_ACCELERATORS',0x00000009)
    win_const_mgr.add_const('DISPID_IHTMLOPSPROFILE_DOWRITEREQUEST',0x00000009)
    win_const_mgr.add_const('ERROR_LOGIN_TIME_RESTRICTION',0x000004D7)
    win_const_mgr.add_const('ICU_NO_META',0x08000000)
    win_const_mgr.add_const('D3DCREATE_MULTITHREADED',0x00000004)
    win_const_mgr.add_const('GOPHER_TYPE_INLINE',0x00100000)
    win_const_mgr.add_const('SQL_SRJO_LEFT_OUTER_JOIN',0x00000040)
    win_const_mgr.add_const('CR_PROP_CANAME',0x00000006)
    win_const_mgr.add_const('OID_FDDI_MAC_OLD_DOWNSTREAM_NBR',0x03030228)
    win_const_mgr.add_const('DE_E_NO_SESSION',0x800C0003)
    win_const_mgr.add_const('MDM_V110_SPEED_28DOT8K',0x00000008)
    win_const_mgr.add_const('ARCONTENT_BLANKDVD',0x00000020)
    win_const_mgr.add_const('PSINJECT_PAGENUMBER',0x00000064)
    win_const_mgr.add_const('SV_TYPE_WORKSTATION',0x00000001)
    win_const_mgr.add_const('DDCAPS_NOHARDWARE',0x02000000)
    win_const_mgr.add_const('TBCD_TICS',0x00000001)
    win_const_mgr.add_const('LWS_IGNORERETURN',0x00000002)
    win_const_mgr.add_const('RTM_VIEW_ID_MCAST',0x00000001)
    win_const_mgr.add_const('TMT_NAME',0x00000258)
    win_const_mgr.add_const('EVT_VARIANT_TYPE_MASK',0x00000007)
    win_const_mgr.add_const('ELEMENT_STATUS_LUN_VALID',0x00001000)
    win_const_mgr.add_const('SYMF_OMAP_MODIFIED',0x00000002)
    win_const_mgr.add_const('FLG_BITREG_SETBITS',0x00000001)
    win_const_mgr.add_const('KSPIN_FLAG_SOME_FRAMES_REQUIRED_FOR_PROCESSING',0x00800000)
    win_const_mgr.add_const('TCS_VERTICAL',0x00000080)
    win_const_mgr.add_const('IPX_BASE_ENTRY',0x00000000)
    win_const_mgr.add_const('USER_CODE_DESCRIPTOR',0xCFBFFFFF00000000)
    win_const_mgr.add_const('FILE_ADD_FILE',0x00000002)
    win_const_mgr.add_const('SUBLANG_ARABIC_LIBYA',0x00000004)
    win_const_mgr.add_const('ERROR_PRINTER_DRIVER_IN_USE',0x00000BB9)
    win_const_mgr.add_const('ETW_BOOLEAN_TYPE_VALUE',0x0000000E)
    win_const_mgr.add_const('LOCALE_ICOUNTRY',0x00000005)
    win_const_mgr.add_const('BOE_NEUTRALOVERRIDE',0x00000004)
    win_const_mgr.add_const('CM_DEVCAP_UNIQUEID',0x00000010)
    win_const_mgr.add_const('SECPKG_ATTR_LOGOFF_TIME',0x00000015)
    win_const_mgr.add_const('MCAST_JOIN_GROUP',0x00000029)
    win_const_mgr.add_const('PLAL_ALERT_CMD_LINE_MASK',0x00007F00)
    win_const_mgr.add_const('PRINTER_CONTROL_PURGE',0x00000003)
    win_const_mgr.add_const('SQLAOPMIN',0x00000051)
    win_const_mgr.add_const('DEBUG_ADDSYNTHMOD_DEFAULT',0x00000000)
    win_const_mgr.add_const('MF_64_BYTE_ALIGNMENT',0x00000003)
    win_const_mgr.add_const('DBIM_ACTUAL',0x00000008)
    win_const_mgr.add_const('CERT_ENCODING_TYPE_MASK',0x0000FFFF)
    win_const_mgr.add_const('IF_TYPE_SLIP',0x0000001C)
    win_const_mgr.add_const('RAS_EAP_FLAG_SAVE_CREDMAN',0x00200000)
    win_const_mgr.add_const('AD_GETWP_IMAGE',0x00000001)
    win_const_mgr.add_const('CHANNEL_RC_NO_MEMORY',0x0000000C)
    win_const_mgr.add_const('TASK_FLAG_KILL_IF_GOING_ON_BATTERIES',0x00000080)
    win_const_mgr.add_const('PAN_LETT_NORMAL_ROUNDED',0x00000006)
    win_const_mgr.add_const('SIOM_RESERVED_SLOWFILE',0x00000002)
    win_const_mgr.add_const('SCARD_READER_TYPE_USB',0x00000020)
    win_const_mgr.add_const('DRM_EL_MACHINE',0x00000001)
    win_const_mgr.add_const('WINHTTP_QUERY_SET_COOKIE',0x0000002B)
    win_const_mgr.add_const('EDITF_ENABLEAKIISSUERNAME',0x00000800)
    win_const_mgr.add_const('URLPOLICY_CHANNEL_SOFTDIST_PROHIBIT',0x00010000)
    win_const_mgr.add_const('LSA_TLN_DISABLED_NEW',0x00000001)
    win_const_mgr.add_const('SM_CYICONSPACING',0x00000027)
    win_const_mgr.add_const('MDM_V110_SPEED_2DOT4K',0x00000002)
    win_const_mgr.add_const('ERROR_LOGON_SESSION_EXISTS',0x00000553)
    win_const_mgr.add_const('DSS_PREFIXONLY',0x00000400)
    win_const_mgr.add_const('INCL_WINSOCK_API_PROTOTYPES',0x00000001)
    win_const_mgr.add_const('HTTP_SEND_RESPONSE_FLAG_DISCONNECT',0x00000001)
    win_const_mgr.add_const('EC_REPAINT',0x00000005)
    win_const_mgr.add_const('LINECALLFEATURE2_COMPLMESSAGE',0x00000020)
    win_const_mgr.add_const('FRAME_TSS',0x00000002)
    win_const_mgr.add_const('HCDC_PROTOCOL_UUID16',0x00000014)
    win_const_mgr.add_const('ITWW_OPEN_NOCONNECT',0x00000001)
    win_const_mgr.add_const('WINHTTP_QUERY_CONTENT_ENCODING',0x0000001D)
    win_const_mgr.add_const('ERROR_INVALID_SERVICENAME',0x000004BD)
    win_const_mgr.add_const('AUXCAPS_CDAUDIO',0x00000001)
    win_const_mgr.add_const('IF_TYPE_X25_PLE',0x00000028)
    win_const_mgr.add_const('LVS_EX_FLATSB',0x00000100)
    win_const_mgr.add_const('ALG_SID_SHA_512',0x0000000E)
    win_const_mgr.add_const('FWPS_INCOMING_FLAG_ABSORB',0x00000004)
    win_const_mgr.add_const('INTERNET_REQFLAG_VIA_PROXY',0x00000004)
    win_const_mgr.add_const('TRUSTERROR_STEP_FINAL_CERTPROV',0x00000022)
    win_const_mgr.add_const('DBPROPVAL_CB_NULL',0x00000001)
    win_const_mgr.add_const('RAS_FLAGS_MESSENGER_PRESENT',0x00000002)
    win_const_mgr.add_const('D3D10_SHADER_PACK_MATRIX_ROW_MAJOR',0x00000001)
    win_const_mgr.add_const('WNODE_FLAG_USE_TIMESTAMP',0x00000200)
    win_const_mgr.add_const('LINETRANSLATERESULT_VOICEDETECT',0x00000400)
    win_const_mgr.add_const('IDM_OBJECTVERBLIST5',0x0000004D)
    win_const_mgr.add_const('STGFMT_DOCUMENT',0x00000000)
    win_const_mgr.add_const('PHOTO_PROGRAMMODE_MANUAL',0x00000001)
    win_const_mgr.add_const('FILE_DEVICE_TAPE_FILE_SYSTEM',0x00000020)
    win_const_mgr.add_const('SERVICE_NO_TRAFFIC_CONTROL',0x81000000)
    win_const_mgr.add_const('OLEMISC_ALIGNABLE',0x00008000)
    win_const_mgr.add_const('CR_CALL_NOT_IMPLEMENTED',0x00000034)
    win_const_mgr.add_const('TMT_COLORIZATIONCOLOR',0x0000097F)
    win_const_mgr.add_const('DEBUG_REQUEST_READ_CAPTURED_EVENT_CODE_STREAM',0x0000000B)
    win_const_mgr.add_const('PTE_ACCESS_MASK',0x00000020)
    win_const_mgr.add_const('TMT_BTNSHADOW',0x00000651)
    win_const_mgr.add_const('RBHT_CHEVRON',0x00000008)
    win_const_mgr.add_const('DXVA_AYUV_BUFFER',0x00000008)
    win_const_mgr.add_const('PHONEERR_SERVICE_NOT_RUNNING',0x90000025)
    win_const_mgr.add_const('TVS_INFOTIP',0x00000800)
    win_const_mgr.add_const('LUP_RETURN_QUERY_STRING',0x00000800)
    win_const_mgr.add_const('OID_TCP6_OFFLOAD_STATS',0xFC010208)
    win_const_mgr.add_const('BTHNS_RESULT_DEVICE_CONNECTED',0x00010000)
    win_const_mgr.add_const('CF_METAFILEPICT',0x00000003)
    win_const_mgr.add_const('PHOTO_PHOTOMETRIC_YCBCR',0x00000006)
    win_const_mgr.add_const('MCI_DGV_FF_RJPEG',0x00004005)
    win_const_mgr.add_const('CRYPT_STRING_HEXADDR',0x00000000)
    win_const_mgr.add_const('CM_PROB_DISABLED',0x00000016)
    win_const_mgr.add_const('EAP_E_EAPHOST_LAST',0x804200FF)
    win_const_mgr.add_const('IKEEXT_POLICY_FLAG_ENABLE_OPTIONAL_DH',0x00000008)
    win_const_mgr.add_const('DNS_RCODE_MAX',0x0000000F)
    win_const_mgr.add_const('ERROR_DS_ILLEGAL_MOD_OPERATION',0x00002077)
    win_const_mgr.add_const('PERF_OBJECT_TIMER',0x00200000)
    win_const_mgr.add_const('OID_TAPI_ACCEPT',0x07030101)
    win_const_mgr.add_const('TXTLOG_UMPNPMGR',0x02000000)
    win_const_mgr.add_const('DN_RW',0x00000003)
    win_const_mgr.add_const('ERROR_WMI_INSTANCE_NOT_FOUND',0x00001069)
    win_const_mgr.add_const('DBPROPVAL_LM_NONE',0x00000001)
    win_const_mgr.add_const('NCRYPT_SILENT_FLAG',0x00000040)
    win_const_mgr.add_const('METADATA_NON_SECURE_ONLY',0x00000100)
    win_const_mgr.add_const('PC_FOLLOWING',0x00000001)
    win_const_mgr.add_const('X3_IMM39_2_SIZE_X',0x00000010)
    win_const_mgr.add_const('IMEA_INIT',0x00000001)
    win_const_mgr.add_const('IMAGE_REL_AM_SECTION',0x00000008)
    win_const_mgr.add_const('DEBUG_REQUEST_GET_CAPTURED_EVENT_CODE_OFFSET',0x0000000A)
    win_const_mgr.add_const('ERROR_DS_CANT_MOD_SYSTEM_ONLY',0x000020B1)
    win_const_mgr.add_const('D3DCAPS2_CANMANAGERESOURCE',0x10000000)
    win_const_mgr.add_const('KSDATAFORMAT_TEMPORAL_COMPRESSION',0x00000001)
    win_const_mgr.add_const('PROOF_MODE',0x00000001)
    win_const_mgr.add_const('DFS_PROPERTY_FLAG_SITE_COSTING',0x00000004)
    win_const_mgr.add_const('ERROR_DOMAIN_TRUST_INCONSISTENT',0x00000712)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2TAO_SETWRITESPEED',0x00000204)
    win_const_mgr.add_const('PRINTER_NOTIFY_INFO_DISCARDED',0x00000001)
    win_const_mgr.add_const('SB_PIXEL_ALPHA',0x00000002)
    win_const_mgr.add_const('WKSTA_NUMCHARBUF_PARMNUM',0x00000016)
    win_const_mgr.add_const('ERROR_DELAY_LOAD_FAILED',0x00000505)
    win_const_mgr.add_const('FS_VIETNAMESE',0x00000100)
    win_const_mgr.add_const('NETERR_RING_STATUS_SOFT_ERROR',0x00002000)
    win_const_mgr.add_const('CAUSE_LOC_PUBLIC_REMOTE',0x00000004)
    win_const_mgr.add_const('CLRES_VERSION_V1_00',0x00000100)
    win_const_mgr.add_const('WSA_QOS_EFILTERCOUNT',0x00002B0D)
    win_const_mgr.add_const('WINEVENT_LEVEL_RESERVED_13',0x00000000)
    win_const_mgr.add_const('TBSTATE_INDETERMINATE',0x00000010)
    win_const_mgr.add_const('WGL_SWAPMULTIPLE_MAX',0x00000010)
    win_const_mgr.add_const('DI_FLAGSEX_FINISHINSTALL_ACTION',0x00000008)
    win_const_mgr.add_const('PHONEERR_INCOMPATIBLEAPIVERSION',0x90000003)
    win_const_mgr.add_const('DS_DS_FLAG',0x00000010)
    win_const_mgr.add_const('IDIGNORE',0x00000005)
    win_const_mgr.add_const('ACMFILTERCHOOSE_STYLEF_ENABLEHOOK',0x00000008)
    win_const_mgr.add_const('ERROR_I24_BAD_UNIT',0x00000001)
    win_const_mgr.add_const('WLX_SAS_TYPE_CTRL_ALT_DEL',0x00000001)
    win_const_mgr.add_const('IKEEXT_POLICY_FLAG_NO_MACHINE_LUID_VERIFY',0x00000002)
    win_const_mgr.add_const('CERT_STORE_BASE_CRL_FLAG',0x00000100)
    win_const_mgr.add_const('FEI_FATAL_ERROR',0x00000000)
    win_const_mgr.add_const('IOCTL_MTP_CUSTOM_COMMAND',0x03150544)
    win_const_mgr.add_const('DEBUG_MODULE_USER_MODE',0x00000002)
    win_const_mgr.add_const('MCI_GETDEVCAPS_COMPOUND_DEVICE',0x00000006)
    win_const_mgr.add_const('OID_FDDI_IF_OUT_UCAST_PKTS',0x03030288)
    win_const_mgr.add_const('PXE_TRACE_ERROR',0x00080000)
    win_const_mgr.add_const('WMIREG_FLAG_RESERVED2',0x00040000)
    win_const_mgr.add_const('INDEX_GUID_TOPINKBREAKSONLY',0x00000009)
    win_const_mgr.add_const('BSM_ALLDESKTOPS',0x00000010)
    win_const_mgr.add_const('WMIREG_FLAG_RESERVED1',0x00020000)
    win_const_mgr.add_const('FWPM_NET_EVENT_FLAG_SCOPE_ID_SET',0x00000080)
    win_const_mgr.add_const('RBNM_LPARAM',0x00000004)
    win_const_mgr.add_const('DEBUG_OUTTYPE_VERBOSE',0x00000004)
    win_const_mgr.add_const('ICDRAW_FULLSCREEN',0x00000002)
    win_const_mgr.add_const('MCIWNDOPENF_NEW',0x00000001)
    win_const_mgr.add_const('MAX_ERROR_TEXT_LEN',0x000000A0)
    win_const_mgr.add_const('ERROR_FILE_NOT_FOUND',0x00000002)
    win_const_mgr.add_const('OID_FDDI_PORT_CONNECTION_POLICIES',0x0303025E)
    win_const_mgr.add_const('XEKL_KEYSIZE_DEFAULT',0x00000004)
    win_const_mgr.add_const('DPNHADDRESSTYPE_GATEWAY',0x00000010)
    win_const_mgr.add_const('D3DSTREAMSOURCE_INDEXEDDATA',0x00000001)
    win_const_mgr.add_const('OID_GEN_OPERATIONAL_STATUS',0x00010283)
    win_const_mgr.add_const('DB_BINDFLAGS_RECURSIVE',0x00000004)
    win_const_mgr.add_const('MCN_LAST',0x00000000)
    win_const_mgr.add_const('RPC_C_MQ_TEMPORARY',0x00000000)
    win_const_mgr.add_const('RPC_IF_SEC_CACHE_PER_PROC',0x00000080)
    win_const_mgr.add_const('CACHE_HEADER_DATA_CACHE_RESERVED_15',0x0000000F)
    win_const_mgr.add_const('RTCMT_T120_SENDRECV',0x00000010)
    win_const_mgr.add_const('SSA_GLYPHS',0x00000080)
    win_const_mgr.add_const('IDM_HORIZSPACEINCREASE',0x00000017)
    win_const_mgr.add_const('LINEDEVSTATE_MSGWAITON',0x00000010)
    win_const_mgr.add_const('LINECALLFEATURE_SETCALLPARAMS',0x00200000)
    win_const_mgr.add_const('CMSG_RC4_NO_SALT_FLAG',0x40000000)
    win_const_mgr.add_const('SECPKG_ATTR_MAPPED_CRED_ATTR',0x00000005)
    win_const_mgr.add_const('SV_PLATFORM_ID_PARMNUM',0x00000065)
    win_const_mgr.add_const('WEBPOST_ERROR_INVALID_POSTINFO',0x40042118)
    win_const_mgr.add_const('SECURITY_WRITE_RESTRICTED_CODE_RID',0x00000021)
    win_const_mgr.add_const('STREAM_FORMAT_WIN32_MANIFEST',0x00000004)
    win_const_mgr.add_const('RESOURCEDISPLAYTYPE_SHAREADMIN',0x00000008)
    win_const_mgr.add_const('WLX_OPTION_SMART_CARD_PRESENT',0x00010001)
    win_const_mgr.add_const('DMPAPER_A3',0x00000008)
    win_const_mgr.add_const('LVIF_STATE',0x00000008)
    win_const_mgr.add_const('D3D10_EFFECT_COMPILE_CHILD_EFFECT',0x00000001)
    win_const_mgr.add_const('DMPAPER_A4',0x00000009)
    win_const_mgr.add_const('CRYPT_MODE_CFBP',0x00000007)
    win_const_mgr.add_const('IMAGE_REL_AMD64_SREL32',0x0000000E)
    win_const_mgr.add_const('MAPI_E_NO_MESSAGES',0x00000010)
    win_const_mgr.add_const('EXPOSUREMETERING_AVERAGE',0x00000001)
    win_const_mgr.add_const('PIR_STATUS_MINIPORT_ERROR',0x00000004)
    win_const_mgr.add_const('CERT_STORE_PROV_READ_CTL_FUNC',0x00000009)
    win_const_mgr.add_const('GESTURE_DIGIT_4',0x00000000)
    win_const_mgr.add_const('MP_STATUS_SUCCESS',0x00000000)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_SAMPLE_BLENDING',0x00000004)
    win_const_mgr.add_const('DBPROPVAL_DST_MDP',0x00000002)
    win_const_mgr.add_const('D3DVS20_MIN_DYNAMICFLOWCONTROLDEPTH',0x00000000)
    win_const_mgr.add_const('SCSI_IOCTL_DATA_IN',0x00000001)
    win_const_mgr.add_const('WH_FOREGROUNDIDLE',0x0000000B)
    win_const_mgr.add_const('IDC_VP_RELATIVE',0x000003ED)
    win_const_mgr.add_const('RESOURCEMANAGER_GET_NOTIFICATION',0x00000010)
    win_const_mgr.add_const('CIF_SHOWHELP',0x00000001)
    win_const_mgr.add_const('DNS_ERROR_SETUP_BASE',0x0000267A)
    win_const_mgr.add_const('SV_USERS_PER_LICENSE',0x00000005)
    win_const_mgr.add_const('INTERNET_CACHE_FLAG_GET_STRUCT_ONLY',0x00001000)
    win_const_mgr.add_const('PCS_FATAL',0x80000000)
    win_const_mgr.add_const('SQL_DIAG_CREATE_TRANSLATION',0x0000004F)
    win_const_mgr.add_const('WNFMT_MULTILINE',0x00000001)
    win_const_mgr.add_const('URLACTION_SHELL_MIN',0x00001800)
    win_const_mgr.add_const('OPTION_MESSAGE_TYPE',0x00000035)
    win_const_mgr.add_const('SM_CXFULLSCREEN',0x00000010)
    win_const_mgr.add_const('X3_I_SIGN_VAL_POS_X',0x0000003B)
    win_const_mgr.add_const('OID_ATM_MAX_AAL0_PACKET_SIZE',0x08010108)
    win_const_mgr.add_const('SW_AUTOPROF_LOAD_MASK',0x00000001)
    win_const_mgr.add_const('EMR_ENDPATH',0x0000003C)
    win_const_mgr.add_const('VMR_RENDER_DEVICE_OVERLAY',0x00000001)
    win_const_mgr.add_const('FW_DONTCARE',0x00000000)
    win_const_mgr.add_const('IF_TYPE_BASIC_ISDN',0x00000014)
    win_const_mgr.add_const('DBIM_TITLE',0x00000010)
    win_const_mgr.add_const('ERROR_I24_WRONG_DISK',0x0000000F)
    win_const_mgr.add_const('TABLE_SORT_DONE',0x00000006)
    win_const_mgr.add_const('SQL_NULL_HDESC',0x00000000)
    win_const_mgr.add_const('INDEX_GUID_PREFIXTEXT',0x00000005)
    win_const_mgr.add_const('ERROR_INVALID_SERVER_STATE',0x00000548)
    win_const_mgr.add_const('MCI_DGV_STATUS_MONITOR',0x00000400)
    win_const_mgr.add_const('RTM_ROUTE_FLAGS_INACTIVE',0x00000008)
    win_const_mgr.add_const('WINEVENT_LEVEL_RESERVED_15',0x00000000)
    win_const_mgr.add_const('UNDNAME_COMPLETE',0x00000000)
    win_const_mgr.add_const('CERT_INFO_VERSION_FLAG',0x00000001)
    win_const_mgr.add_const('GL_THREAD_CLEANUP',0x00008000)
    win_const_mgr.add_const('IDF_NOBROWSE',0x00000001)
    win_const_mgr.add_const('VTBIT_UI4',0x00000001)
    win_const_mgr.add_const('TRANSACTION_MANAGER_COMMIT_LOWEST',0x00000008)
    win_const_mgr.add_const('WM_HOTKEY',0x00000312)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_SECURITY',0x0000000D)
    win_const_mgr.add_const('CRYPT_RETRIEVE_MULTIPLE_OBJECTS',0x00000001)
    win_const_mgr.add_const('DXVA_QUERYORREPLYFUNCFLAG_DECODER_LOCK_QUERY',0x00FFFFF5)
    win_const_mgr.add_const('DOT11_ENCAP_RFC_1042',0x00000001)
    win_const_mgr.add_const('STGM_PRIORITY',0x00040000)
    win_const_mgr.add_const('HTTP_QUERY_COOKIE',0x0000002C)
    win_const_mgr.add_const('CONTEXT_EXCEPTION_ACTIVE',0x08000000)
    win_const_mgr.add_const('OID_GEN_RECEIVE_SCALE_PARAMETERS',0x00010204)
    win_const_mgr.add_const('WMS_VER_MAJOR',0x00000009)
    win_const_mgr.add_const('IO_REPARSE_TAG_MOUNT_POINT',0xA0000003)
    win_const_mgr.add_const('INTERNET_FLAG_NEED_FILE',0x00000010)
    win_const_mgr.add_const('TVHT_TORIGHT',0x00000400)
    win_const_mgr.add_const('WIA_DPS_TRANSPARENCY_STATUS',0x00000C23)
    win_const_mgr.add_const('PRIVACY_URLISTOPLEVEL',0x00010000)
    win_const_mgr.add_const('LOCALE_IDATE',0x00000021)
    win_const_mgr.add_const('PROCESS_QUERY_LIMITED_INFORMATION',0x00001000)
    win_const_mgr.add_const('XP_GRACEFUL_CLOSE',0x00000020)
    win_const_mgr.add_const('SERVICE_IP_NO_HINT',0x00000000)
    win_const_mgr.add_const('LONGHORN_MAJOR_VERSION',0x00000005)
    win_const_mgr.add_const('ERROR_OPERATION_NOT_SUPPORTED_IN_TRANSACTION',0x00001AC5)
    win_const_mgr.add_const('HSE_URL_FLAGS_WRITE',0x00000002)
    win_const_mgr.add_const('JIFMK_EOI',0x0000FFD9)
    win_const_mgr.add_const('LINEMEDIAMODE_DATAMODEM',0x00000010)
    win_const_mgr.add_const('JOY_RETURNY',0x00000002)
    win_const_mgr.add_const('CERT_INFO_ISSUER_UNIQUE_ID_FLAG',0x00000009)
    win_const_mgr.add_const('KSEVENT_ENTRY_BUFFERED',0x00000004)
    win_const_mgr.add_const('VARIANT_CALENDAR_GREGORIAN',0x00000040)
    win_const_mgr.add_const('CR_PROP_CASIGCERT',0x0000000C)
    win_const_mgr.add_const('DS_REPDEL_WRITEABLE',0x00000002)
    win_const_mgr.add_const('CM_PROB_DEVLOADER_NOT_READY',0x00000017)
    win_const_mgr.add_const('LVIF_COLUMNS',0x00000200)
    win_const_mgr.add_const('DRIVE_NO_ROOT_DIR',0x00000001)
    win_const_mgr.add_const('SB_TOP',0x00000006)
    win_const_mgr.add_const('SVAUD_SERVICE',0x00000001)
    win_const_mgr.add_const('LF32_FREE',0x00000002)
    win_const_mgr.add_const('EC_STREAM_CONTROL_STOPPED',0x0000001A)
    win_const_mgr.add_const('ERROR_SEVERITY_WARNING',0x80000000)
    win_const_mgr.add_const('PHOTO_METERINGMODE_PARTIAL',0x00000006)
    win_const_mgr.add_const('SQL_CVT_TIME',0x00010000)
    win_const_mgr.add_const('MOD_MAPPER',0x00000005)
    win_const_mgr.add_const('OID_FDDI_PATH_RING_LATENCY',0x03030252)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_CONFIGURATION_OBJECT',0x000000A9)
    win_const_mgr.add_const('PF_XMMI_INSTRUCTIONS_AVAILABLE',0x00000006)
    win_const_mgr.add_const('ACM_METRIC_HARDWARE_WAVE_INPUT',0x0000001E)
    win_const_mgr.add_const('FILE_DEVICE_NETWORK',0x00000012)
    win_const_mgr.add_const('INTERNET_COOKIE_IS_SECURE',0x00000001)
    win_const_mgr.add_const('PDE_OFFSET_LEN',0x0000000A)
    win_const_mgr.add_const('IP_ADD_IFLIST',0x0000001D)
    win_const_mgr.add_const('PDH_LOG_TYPE_NOT_FOUND',0xC0000BCB)
    win_const_mgr.add_const('LINEADDRCAPFLAGS_CONFERENCEHELD',0x00004000)
    win_const_mgr.add_const('SECPKG_STATE_WORKSTATION',0x00000008)
    win_const_mgr.add_const('SV_PRODUCTTYPE_PARMNUM',0x00000230)
    win_const_mgr.add_const('SS_BLACKRECT',0x00000004)
    win_const_mgr.add_const('IDM_TRIED_GETBLOCKFMTS',0x00000027)
    win_const_mgr.add_const('COMP_ELEM_CURITEMSTATE',0x00004000)
    win_const_mgr.add_const('IDM_SHOWGRID',0x00000045)
    win_const_mgr.add_const('EVENT_CONSOLE_UPDATE_REGION',0x00004002)
    win_const_mgr.add_const('DLGC_DEFPUSHBUTTON',0x00000010)
    win_const_mgr.add_const('ERROR_SPL_NO_STARTDOC',0x00000BBB)
    win_const_mgr.add_const('NUMPRS_DECIMAL',0x00000100)
    win_const_mgr.add_const('RPC_C_AUTHZ_NAME',0x00000001)
    win_const_mgr.add_const('AE_LIM_EXPIRED',0x00000002)
    win_const_mgr.add_const('PLATFORM_ID_NT',0x000001F4)
    win_const_mgr.add_const('OID_TAPI_GET_DEV_CONFIG',0x07030111)
    win_const_mgr.add_const('MF_BYPOSITION',0x00000400)
    win_const_mgr.add_const('DDBLT_ALPHASRCCONSTOVERRIDE',0x00000040)
    win_const_mgr.add_const('LVIS_CUT',0x00000004)
    win_const_mgr.add_const('DTBG_OMITCONTENT',0x00000008)
    win_const_mgr.add_const('FWPS_INCOMING_FLAG_CONNECTION_FAILING_INDICATION',0x00000008)
    win_const_mgr.add_const('PIDDSI_COMPANY',0x0000000F)
    win_const_mgr.add_const('IME_SMODE_PHRASEPREDICT',0x00000008)
    win_const_mgr.add_const('SPQ_FLAG_ABORT_IF_UNSIGNED',0x00000002)
    win_const_mgr.add_const('OID_GEN_MAC_OPTIONS',0x00010113)
    win_const_mgr.add_const('DS_CENTERMOUSE',0x00001000)
    win_const_mgr.add_const('UNICODE_STRING_MAX_CHARS',0x00007FFF)
    win_const_mgr.add_const('CM_SETUP_WRITE_LOG_CONFS',0x00000002)
    win_const_mgr.add_const('CMSG_SIGNED_FLAG',0x00000001)
    win_const_mgr.add_const('ERROR_NO_CHILD_PROCESS',0x000000B8)
    win_const_mgr.add_const('ERROR_MEMBER_NOT_IN_GROUP',0x00000529)
    win_const_mgr.add_const('CFE_SUBSCRIPT',0x00010000)
    win_const_mgr.add_const('OFN_ENABLETEMPLATE',0x00000040)
    win_const_mgr.add_const('IMAGE_DLLCHARACTERISTICS_NO_ISOLATION',0x00000200)
    win_const_mgr.add_const('CM_DELETE_CLASS_BITS',0x00000003)
    win_const_mgr.add_const('BACKUP_TXFS_DATA',0x00000000)
    win_const_mgr.add_const('AVRF_ENUM_RESOURCES_FLAGS_DONT_RESOLVE_TRACES',0x00000002)
    win_const_mgr.add_const('SPEAKER_TOP_BACK_RIGHT',0x00020000)
    win_const_mgr.add_const('SQL_IK_NONE',0x00000000)
    win_const_mgr.add_const('UP_P2P',0x00000000)
    win_const_mgr.add_const('UI_CURRENT_PROVIDER_FIRST',0x00000004)
    win_const_mgr.add_const('VK_ESCAPE',0x0000001B)
    win_const_mgr.add_const('COMMON_LVB_GRID_RVERTICAL',0x00001000)
    win_const_mgr.add_const('ALG_SID_ECDSA',0x00000003)
    win_const_mgr.add_const('TMT_DISPLAYNAME',0x00000259)
    win_const_mgr.add_const('WMDM_SEEK_REMOTECONTROL',0x00000001)
    win_const_mgr.add_const('ADS_SERVICE_PAUSE_PENDING',0x00000006)
    win_const_mgr.add_const('KSMETHOD_TYPE_MODIFY',0x00000003)
    win_const_mgr.add_const('CTFMODEBIAS_FULLWIDTHALPHANUMERIC',0x0000000B)
    win_const_mgr.add_const('IMAGE_REL_SH3_DIRECT16',0x00000001)
    win_const_mgr.add_const('IITWBC_BREAK_ACCEPT_WILDCARDS',0x00000001)
    win_const_mgr.add_const('WM_MENUCOMMAND',0x00000126)
    win_const_mgr.add_const('CI_STATE_BATTERY_POWER',0x00000800)
    win_const_mgr.add_const('SRCLIST_SYSTEM',0x00000010)
    win_const_mgr.add_const('MIB_IPADDR_DISCONNECTED',0x00000008)
    win_const_mgr.add_const('READ_THRESHOLD_BUFFER_SIZE',0x00000200)
    win_const_mgr.add_const('SW_INVALIDATE',0x00000002)
    win_const_mgr.add_const('MAX_L2CAP_INFO_DATA_LENGTH',0x0000002C)
    win_const_mgr.add_const('BG_E_SERVER_EXECUTE_ENABLE',0x80200023)
    win_const_mgr.add_const('WM_PAINTICON',0x00000026)
    win_const_mgr.add_const('WSAENETUNREACH',0x00002743)
    win_const_mgr.add_const('MDPROPVAL_MNF_LINREG2',0x00000200)
    win_const_mgr.add_const('PARTTYPE_MASK',0x00030000)
    win_const_mgr.add_const('RF_DEMAND_UPDATE_ROUTES',0x00000004)
    win_const_mgr.add_const('DISPID_REFRESHDOC',0x00000020)
    win_const_mgr.add_const('ENM_PARAGRAPHEXPANDED',0x00000020)
    win_const_mgr.add_const('SQL_DIAG_DYNAMIC_DELETE_CURSOR',0x00000026)
    win_const_mgr.add_const('IMAGE_DIRECTORY_ENTRY_GLOBALPTR',0x00000008)
    win_const_mgr.add_const('SO_BTH_MTU_MIN',0x08000000)
    win_const_mgr.add_const('LINETERMSHARING_SHAREDEXCL',0x00000002)
    win_const_mgr.add_const('CMSG_CTRL_DEL_CRL',0x0000000D)
    win_const_mgr.add_const('PSBTN_MAX',0x00000006)
    win_const_mgr.add_const('DNS_RTYPE_A',0x00000100)
    win_const_mgr.add_const('MD_LOGFILE_PERIOD_MAXSIZE',0x00000000)
    win_const_mgr.add_const('DDLOCK_READONLY',0x00000010)
    win_const_mgr.add_const('CBN_SELENDCANCEL',0x0000000A)
    win_const_mgr.add_const('PDH_LOG_FILE_CREATE_ERROR',0xC0000BC9)
    win_const_mgr.add_const('ICM_ADDPROFILE',0x00000001)
    win_const_mgr.add_const('NS_NTDS',0x00000020)
    win_const_mgr.add_const('NOTE_COLOR_PINK',0x00000002)
    win_const_mgr.add_const('SESSION_QUERY_ACCESS',0x00000001)
    win_const_mgr.add_const('LMEM_LOCKCOUNT',0x000000FF)
    win_const_mgr.add_const('DOT11_MAX_NUM_DEFAULT_KEY',0x00000004)
    win_const_mgr.add_const('FWPM_TUNNEL_FLAG_POINT_TO_POINT',0x00000001)
    win_const_mgr.add_const('LINECALLINFOSTATE_REDIRECTINGID',0x00080000)
    win_const_mgr.add_const('DN_NEEDS_LOCKING',0x02000000)
    win_const_mgr.add_const('WIA_PHOTO_WHITE_1',0x00000000)
    win_const_mgr.add_const('ERROR_CTX_MODEM_INF_NOT_FOUND',0x00001B61)
    win_const_mgr.add_const('COD_LAN_ACCESS_67_USED',0x00000004)
    win_const_mgr.add_const('LAYOUT_VBH',0x00000004)
    win_const_mgr.add_const('ERROR_LOCK_VIOLATION',0x00000021)
    win_const_mgr.add_const('LINEADDRCAPFLAGS_CONFERENCEMAKE',0x00008000)
    win_const_mgr.add_const('SYMFLAG_REGREL',0x00000010)
    win_const_mgr.add_const('MCI_VCR_SETTUNER_CHANNEL',0x00010000)
    win_const_mgr.add_const('HDF_OWNERDRAW',0x00008000)
    win_const_mgr.add_const('TTFCFP_FLAGS_TTC',0x00000004)
    win_const_mgr.add_const('EC_READ_ACCESS',0x00000001)
    win_const_mgr.add_const('NCRYPT_IMPL_SOFTWARE_FLAG',0x00000002)
    win_const_mgr.add_const('DIRID_HELP',0x00000012)
    win_const_mgr.add_const('RF_OBJECT',0x00000002)
    win_const_mgr.add_const('NDW_INSTALLFLAG_SKIPISDEVINSTALLED',0x00000800)
    win_const_mgr.add_const('DTT_BORDERCOLOR',0x00000001)
    win_const_mgr.add_const('D3DCREATE_DISABLE_PRINTSCREEN',0x00008000)
    win_const_mgr.add_const('WC_ERR_INVALID_CHARS',0x00000080)
    win_const_mgr.add_const('HTTP_MINOR_VERSION',0x00000000)
    win_const_mgr.add_const('GCS_UNICODE',0x00000004)
    win_const_mgr.add_const('JS_RETRYING',0x00000020)
    win_const_mgr.add_const('RSOP_INFO_FLAG_DIAGNOSTIC_MODE',0x00000001)
    win_const_mgr.add_const('NDIS_PACKET_TYPE_802_11_MULTICAST_MGMT',0x00080000)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_DBGPRINT',0x00040000)
    win_const_mgr.add_const('NS_SLP',0x00000005)
    win_const_mgr.add_const('EC_FULLSCREEN_LOST',0x00000012)
    win_const_mgr.add_const('IP_ADAPTER_ADDRESS_DNS_ELIGIBLE',0x00000001)
    win_const_mgr.add_const('NT_FE_CONSOLE_PROPS_SIG',0xA0000004)
    win_const_mgr.add_const('IOF_SELECTCREATECONTROL',0x00002000)
    win_const_mgr.add_const('PIPE_ACCESS_INBOUND',0x00000001)
    win_const_mgr.add_const('PIDDSI_LINECOUNT',0x00000005)
    win_const_mgr.add_const('LR_CREATEDIBSECTION',0x00002000)
    win_const_mgr.add_const('IF_TYPE_ISDN_U',0x0000004C)
    win_const_mgr.add_const('SECPKG_CALL_URGENT',0x00000004)
    win_const_mgr.add_const('IF_TYPE_ISDN_S',0x0000004B)
    win_const_mgr.add_const('FILE_NOTIFY_CHANGE_DIR_NAME',0x00000002)
    win_const_mgr.add_const('PC_STYLED',0x00000020)
    win_const_mgr.add_const('USER_MNS_LOGON_ACCOUNT',0x00000020)
    win_const_mgr.add_const('PROCESSOR_ARM820',0x00000820)
    win_const_mgr.add_const('CERT_TRUST_IS_PEER_TRUSTED',0x00000800)
    win_const_mgr.add_const('ERROR_DS_OBJ_NOT_FOUND',0x0000208D)
    win_const_mgr.add_const('ERROR_INVALID_DLL',0x00000482)
    win_const_mgr.add_const('DISPID_ONMENUBAR',0x00000100)
    win_const_mgr.add_const('DDBLT_KEYSRC',0x00008000)
    win_const_mgr.add_const('ERROR_SXS_XML_E_MISSINGWHITESPACE',0x000036D5)
    win_const_mgr.add_const('SPI_GETFLATMENU',0x00001022)
    win_const_mgr.add_const('SSPROP_MAXBLOBLENGTH',0x00000008)
    win_const_mgr.add_const('AM_LOADSTATUS_CLOSED',0x00000000)
    win_const_mgr.add_const('SERVICE_AUTO_START',0x00000002)
    win_const_mgr.add_const('OID_802_11_TX_POWER_LEVEL',0x0D010205)
    win_const_mgr.add_const('MDM_MASK_HDLCPPP_AUTH',0x00000007)
    win_const_mgr.add_const('CI_STATE_LOW_MEMORY',0x00000080)
    win_const_mgr.add_const('EXCHIVERB_REPLYTOALL',0x00000067)
    win_const_mgr.add_const('ERROR_UNABLE_TO_LOAD_MEDIUM',0x000010E4)
    win_const_mgr.add_const('ISFB_STATE_QLINKSMODE',0x00000020)
    win_const_mgr.add_const('ERROR_CLUSTERLOG_CORRUPT',0x000013A5)
    win_const_mgr.add_const('IP_DONTFRAGMENT',0x0000000E)
    win_const_mgr.add_const('WSA_QOS_ADMISSION_FAILURE',0x00002B02)
    win_const_mgr.add_const('BG_E_MAXDOWNLOAD_TIMEOUT',0x80200054)
    win_const_mgr.add_const('USER_PRIMARY_GROUP_PARMNUM',0x00000033)
    win_const_mgr.add_const('DNS_RCODE_NOTZONE',0x0000000A)
    win_const_mgr.add_const('PRIMARY_CRED_CLEAR_PASSWORD',0x00000001)
    win_const_mgr.add_const('LINECALLPARTYID_UNAVAIL',0x00000040)
    win_const_mgr.add_const('GETFACENAME',0x00000201)
    win_const_mgr.add_const('PRIMARY_CRED_LOGON_NO_TCB',0x00000010)
    win_const_mgr.add_const('ERROR_DLL_MIGHT_BE_INSECURE',0x000002AE)
    win_const_mgr.add_const('CERT_STORE_SAVE_TO_FILE',0x00000001)
    win_const_mgr.add_const('SSF_DESKTOPHTML',0x00000200)
    win_const_mgr.add_const('IFS_V_LEN',0x00000001)
    win_const_mgr.add_const('TBS_BOTTOM',0x00000000)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_SAMPLE_ADV_BLENDING',0x00000008)
    win_const_mgr.add_const('PHONEFEATURE_GETHOOKSWITCHSPEAKER',0x00000080)
    win_const_mgr.add_const('KSMETHOD_TYPE_WRITE',0x00000002)
    win_const_mgr.add_const('PROPTYPE_BINARY',0x00000003)
    win_const_mgr.add_const('DVB_RST_PID',0x00000013)
    win_const_mgr.add_const('MOUSEEVENTF_LEFTDOWN',0x00000002)
    win_const_mgr.add_const('INSTALLED_CACHE_ENTRY',0x10000000)
    win_const_mgr.add_const('DNS_MAX_LABEL_LENGTH',0x0000003F)
    win_const_mgr.add_const('ICC_HOTKEY_CLASS',0x00000040)
    win_const_mgr.add_const('DPAM_UNION',0x00000004)
    win_const_mgr.add_const('DRIVER_KERNELMODE',0x00000001)
    win_const_mgr.add_const('WTS_WSD_REBOOT',0x00000004)
    win_const_mgr.add_const('ADS_PRINTER_PAPER_OUT',0x00000005)
    win_const_mgr.add_const('WIA_IPA_PROP_STREAM_COMPAT_ID',0x0000101A)
    win_const_mgr.add_const('LINEQOSSERVICELEVEL_NEEDED',0x00000001)
    win_const_mgr.add_const('KS_VBI_FLAG_TVTUNER_CHANGE',0x00000010)
    win_const_mgr.add_const('EMR_POLYGON',0x00000003)
    win_const_mgr.add_const('NRC_NOCALL',0x00000014)
    win_const_mgr.add_const('LVS_NOSCROLL',0x00002000)
    win_const_mgr.add_const('OPENCHANNEL',0x0000100E)
    win_const_mgr.add_const('PAGE_NOCACHE',0x00000200)
    win_const_mgr.add_const('ERROR_DS_ATT_VAL_ALREADY_EXISTS',0x00002083)
    win_const_mgr.add_const('XP1_MULTIPOINT_CONTROL_PLANE',0x00000800)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_PROCESS_ERR_ID',0x0000360A)
    win_const_mgr.add_const('IME_ESC_MAX_KEY',0x00001005)
    win_const_mgr.add_const('IF_TYPE_IPOVER_CLAW',0x0000006E)
    win_const_mgr.add_const('DB_MODE_SHARE_DENY_WRITE',0x00000008)
    win_const_mgr.add_const('ILR_VERTICAL_BOTTOM',0x00000020)
    win_const_mgr.add_const('CSIDL_ADMINTOOLS',0x00000030)
    win_const_mgr.add_const('WIA_DPF_MOUNT_POINT',0x00000D02)
    win_const_mgr.add_const('ERROR_IPSEC_MM_POLICY_PENDING_DELETION',0x000032DD)
    win_const_mgr.add_const('WIA_DPC_FOCUS_MODE',0x00000809)
    win_const_mgr.add_const('DISPID_SELECTEDITEMS',0x00000018)
    win_const_mgr.add_const('DATE_LONGDATE',0x00000002)
    win_const_mgr.add_const('IDM_SHOWALIGNEDSITETAGS',0x00000911)
    win_const_mgr.add_const('FLAG_LOOPBACK_REPLACE',0x08000000)
    win_const_mgr.add_const('SERVICE_CCP_CHKPT_NUM',0x000000FF)
    win_const_mgr.add_const('PTE_EXC_DEFER',0x10000000000000)
    win_const_mgr.add_const('UNLOCK_ELEMENT',0x00000001)
    win_const_mgr.add_const('SQL_INDEX_UNIQUE',0x00000000)
    win_const_mgr.add_const('SQL_API_SQLBROWSECONNECT',0x00000037)
    win_const_mgr.add_const('MD_ERROR_SUB404_CONTENT_LENGTH_TOO_LARGE',0x0000000D)
    win_const_mgr.add_const('MAX_MODULE_NAME32',0x000000FF)
    win_const_mgr.add_const('HSE_URL_FLAGS_READ',0x00000001)
    win_const_mgr.add_const('TUISPIDLL_OBJECT_PHONEID',0x00000002)
    win_const_mgr.add_const('SM_RESERVED1',0x00000018)
    win_const_mgr.add_const('TLS1_ALERT_INSUFFIENT_SECURITY',0x00000047)
    win_const_mgr.add_const('SQL_RETRIEVE_DATA',0x0000000B)
    win_const_mgr.add_const('FOFX_SHOWELEVATIONPROMPT',0x00040000)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_UNSTABLE',0x00000006)
    win_const_mgr.add_const('DN_NONE',0x00000000)
    win_const_mgr.add_const('SND_ASYNC',0x00000001)
    win_const_mgr.add_const('CTRY_LIECHTENSTEIN',0x00000029)
    win_const_mgr.add_const('MCI_DGV_RECORD_VIDEO_STREAM',0x00080000)
    win_const_mgr.add_const('SP_COPY_OEM_F6_INF',0x00200000)
    win_const_mgr.add_const('VK_CLEAR',0x0000000C)
    win_const_mgr.add_const('RC_SAVEBITMAP',0x00000040)
    win_const_mgr.add_const('SM_RESERVED2',0x00000019)
    win_const_mgr.add_const('MFT_RIGHTORDER',0x00002000)
    win_const_mgr.add_const('LOCALE_SPOSITIVESIGN',0x00000050)
    win_const_mgr.add_const('CAUSE_UNIMPLEMENTED_MESSAGE_TYPE',0x00000061)
    win_const_mgr.add_const('EMR_EXTFLOODFILL',0x00000035)
    win_const_mgr.add_const('ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER',0x00002188)
    win_const_mgr.add_const('PGB_TOPORLEFT',0x00000000)
    win_const_mgr.add_const('IMAPI_SECTORS_PER_SECOND_AT_1X_CD',0x0000004B)
    win_const_mgr.add_const('PST_EXTERN_PROPID_BASE',0x00006700)
    win_const_mgr.add_const('REFERENCE_WHITE_MIN',0x00001770)
    win_const_mgr.add_const('DEBUG_DATA_KPRCB_OFFSET',0x00000001)
    win_const_mgr.add_const('SUBLANG_MAORI_NEW_ZEALAND',0x00000001)
    win_const_mgr.add_const('EMR_RESERVED_109',0x0000006D)
    win_const_mgr.add_const('NTMS_DEVICENAME_LENGTH',0x00000040)
    win_const_mgr.add_const('IOC_OUT',0x40000000)
    win_const_mgr.add_const('HTTP_ADDREQ_FLAG_REPLACE',0x80000000)
    win_const_mgr.add_const('CRLF_PUBLISH_EXPIRED_CERT_CRLS',0x00000200)
    win_const_mgr.add_const('ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN',0x00002179)
    win_const_mgr.add_const('IF_TYPE_ETHERNET_3MBIT',0x0000001A)
    win_const_mgr.add_const('DEBUG_STACK_FRAME_MEMORY_USAGE',0x00000200)
    win_const_mgr.add_const('CR_CREATE_BLOCKED',0x00000015)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_CLEAR_SAVEPOINT',0x00200000)
    win_const_mgr.add_const('DNS_OPCODE_QUERY',0x00000000)
    win_const_mgr.add_const('EFFECTMODE_BW',0x00000002)
    win_const_mgr.add_const('LOGON32_LOGON_NETWORK_CLEARTEXT',0x00000008)
    win_const_mgr.add_const('SQL_API_SQLFREEHANDLE',0x000003EE)
    win_const_mgr.add_const('SQL_ISV_SQL_LANGUAGES',0x00004000)
    win_const_mgr.add_const('DRM_EL_GROUPIDENTITY_LID',0x00000008)
    win_const_mgr.add_const('ATADDR_BROADCAST',0x000000FF)
    win_const_mgr.add_const('DEBUG_OUTTYPE_NO_INDENT',0x00000001)
    win_const_mgr.add_const('MCI_SAVE',0x00000813)
    win_const_mgr.add_const('SCARD_READER_SWALLOWS',0x00000001)
    win_const_mgr.add_const('NETERR_RING_STATUS_HARD_ERROR',0x00004000)
    win_const_mgr.add_const('KAGPROP_FILEUSAGE',0x00000017)
    win_const_mgr.add_const('INDEX_GUID_ALLOWPARTIALDICTIONARYTERMS',0x00000004)
    win_const_mgr.add_const('SS_BLACKFRAME',0x00000007)
    win_const_mgr.add_const('FACILITY_DRIVER_FRAMEWORK',0x00000020)
    win_const_mgr.add_const('CMC_FAIL_INTERNAL_CA_ERROR',0x0000000B)
    win_const_mgr.add_const('MAX_PATH16',0x000000FF)
    win_const_mgr.add_const('CONFIGFLAG_CANTSTOPACHILD',0x00000080)
    win_const_mgr.add_const('TASK_FLAG_RUN_ONLY_IF_LOGGED_ON',0x00002000)
    win_const_mgr.add_const('RPC_S_INVALID_ENDPOINT_FORMAT',0x000006AA)
    win_const_mgr.add_const('SQL_API_SQLSETSTMTATTR',0x000003FC)
    win_const_mgr.add_const('IDD_WIZEXTN_LAST',0x00005100)
    win_const_mgr.add_const('ERROR_WMI_DP_FAILED',0x00001071)
    win_const_mgr.add_const('SP_PROT_PCT1_SERVER',0x00000001)
    win_const_mgr.add_const('ERROR_LOG_CONTAINER_OPEN_FAILED',0x000019F1)
    win_const_mgr.add_const('MAPI_USER_ABORT',0x00000001)
    win_const_mgr.add_const('ACCESS_MAX_MS_V3_ACE_TYPE',0x00000004)
    win_const_mgr.add_const('CCERR_CHOOSECOLORCODES',0x00005000)
    win_const_mgr.add_const('ACM_FORMATENUMF_SUGGEST',0x00200000)
    win_const_mgr.add_const('ERROR_DS_SRC_SID_EXISTS_IN_FOREST',0x0000215B)
    win_const_mgr.add_const('PATCH_SYMBOL_RESERVED1',0x80000000)
    win_const_mgr.add_const('TCS_MULTILINE',0x00000200)
    win_const_mgr.add_const('PROPID_Q_BASE',0x00000064)
    win_const_mgr.add_const('EVENT_S_LAST',0x0004021F)
    win_const_mgr.add_const('SUBLANG_BENGALI_BANGLADESH',0x00000002)
    win_const_mgr.add_const('DFCS_INACTIVE',0x00000100)
    win_const_mgr.add_const('CERT_PUBKEY_HASH_RESERVED_PROP_ID',0x00000008)
    win_const_mgr.add_const('SERVICETYPE_QUALITATIVE',0x0000000D)
    win_const_mgr.add_const('FR_MATCHALEFHAMZA',0x80000000)
    win_const_mgr.add_const('LCID_INSTALLED',0x00000001)
    win_const_mgr.add_const('CMF_NOVERBS',0x00000008)
    win_const_mgr.add_const('D3DPRESENT_RATE_DEFAULT',0x00000000)
    win_const_mgr.add_const('LGRPID_ARABIC',0x00000000)
    win_const_mgr.add_const('SKF_RWINLATCHED',0x80000000)
    win_const_mgr.add_const('KSALLOCATOR_REQUIREMENTF_INPLACE_MODIFIER',0x00000001)
    win_const_mgr.add_const('ERROR_DIR_NOT_ROOT',0x00000090)
    win_const_mgr.add_const('HSHELL_TASKMAN',0x00000007)
    win_const_mgr.add_const('MCI_DGV_STATUS_FILE_COMPLETION',0x00004020)
    win_const_mgr.add_const('REGSTR_MAX_VALUE_LENGTH',0x00000100)
    win_const_mgr.add_const('DBPROPVAL_OO_SINGLETON',0x00000020)
    win_const_mgr.add_const('SCRIPTPROP_CATCHEXCEPTION',0x00001001)
    win_const_mgr.add_const('PFM_TABLE',0x40000000)
    win_const_mgr.add_const('PORT_ANYTERMACC',0x00000039)
    win_const_mgr.add_const('DBC_GS_SIZEDOWN',0x00000001)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_SECURITYFIX',0x00000000)
    win_const_mgr.add_const('CS_CLASSDC',0x00000040)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_SETREPDIAL',0x00000028)
    win_const_mgr.add_const('VK_F18',0x00000081)
    win_const_mgr.add_const('ERROR_DS_NAME_TYPE_UNKNOWN',0x0000209F)
    win_const_mgr.add_const('APPCOMMAND_MEDIA_STOP',0x0000000D)
    win_const_mgr.add_const('MCI_DGV_STATUS_VIDEO_RECORD',0x00000401)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_PROMOTE_NEW',0x10000000)
    win_const_mgr.add_const('BTH_MFG_C_TECHNOLOGIES',0x00000026)
    win_const_mgr.add_const('DDCAPS_PALETTEVSYNC',0x00010000)
    win_const_mgr.add_const('DBPROPVAL_MR_CONCURRENT',0x00000002)
    win_const_mgr.add_const('NTDSDSA_OPT_DISABLE_SPN_REGISTRATION',0x00000001)
    win_const_mgr.add_const('IDTB_FAVORITES',0x000000D9)
    win_const_mgr.add_const('TVS_EX_NOINDENTSTATE',0x00000008)
    win_const_mgr.add_const('LDAP_OPT_IO_FN_PTRS',0x00000000)
    win_const_mgr.add_const('ERROR_DS_CLASS_NOT_DSA',0x00002097)
    win_const_mgr.add_const('DBPROPVAL_STGM_TRANSACTED',0x00020000)
    win_const_mgr.add_const('DI_QUIETINSTALL',0x00800000)
    win_const_mgr.add_const('VER_NT_WORKSTATION',0x00000001)
    win_const_mgr.add_const('SKF_LSHIFTLATCHED',0x01000000)
    win_const_mgr.add_const('WLX_DLG_USER_LOGOFF',0x00000068)
    win_const_mgr.add_const('ERROR_NO_IMPERSONATION_TOKEN',0x0000051D)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_FILTER_RESTART_PARAMETERS',0x0000009B)
    win_const_mgr.add_const('SCESTATUS_NOT_ENOUGH_RESOURCE',0x00000008)
    win_const_mgr.add_const('CAUSE_ACCESS_INFORMAION_DISCARDED',0x0000002B)
    win_const_mgr.add_const('MSG_SERVICE_UI_READ_ONLY',0x00000008)
    win_const_mgr.add_const('CLCTL_GLOBAL_SHIFT',0x00000017)
    win_const_mgr.add_const('IDC_BZ_MESSAGE1',0x0000025A)
    win_const_mgr.add_const('PDH_LOG_WRITE_ACCESS',0x00020000)
    win_const_mgr.add_const('VK_CRSEL',0x000000F7)
    win_const_mgr.add_const('MCIWNDF_NOAUTOSIZEMOVIE',0x00000004)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_ACKFULL',0x00000014)
    win_const_mgr.add_const('ERRCLASS_OUTRES',0x00000001)
    win_const_mgr.add_const('TAPE_REWIND',0x00000000)
    win_const_mgr.add_const('TASK_MONDAY',0x00000002)
    win_const_mgr.add_const('D3DCREATE_DISABLE_DRIVER_MANAGEMENT_EX',0x00000400)
    win_const_mgr.add_const('WAVEOUT_MAPPER_STATUS_FORMAT',0x00000002)
    win_const_mgr.add_const('IF_TYPE_PROTEON_80MBIT',0x0000000D)
    win_const_mgr.add_const('LINECALLHUBTRACKING_ALLCALLS',0x00000002)
    win_const_mgr.add_const('IMN_SETCOMPOSITIONWINDOW',0x0000000B)
    win_const_mgr.add_const('MCSC_BACKGROUND',0x00000000)
    win_const_mgr.add_const('SRRF_RT_REG_BINARY',0x00000008)
    win_const_mgr.add_const('ERROR_PNP_BAD_MPS_TABLE',0x0000029F)
    win_const_mgr.add_const('FNERR_SUBCLASSFAILURE',0x00003001)
    win_const_mgr.add_const('KSFILTER_FLAG_RECEIVE_ZERO_LENGTH_SAMPLES',0x00000008)
    win_const_mgr.add_const('ERROR_DS_MISSING_FSMO_SETTINGS',0x000020F2)
    win_const_mgr.add_const('UIA_E_PROXYASSEMBLYNOTLOADED',0x80040203)
    win_const_mgr.add_const('HTTP_AUTH_ENABLE_DIGEST',0x00000002)
    win_const_mgr.add_const('WM_CT_INTERLACED',0x00000080)
    win_const_mgr.add_const('ERROR_ALREADY_INITIALIZED',0x000004DF)
    win_const_mgr.add_const('DNS_STATUS_FQDN',0x00002555)
    win_const_mgr.add_const('TMNOMIGRATE',0x00000002)
    win_const_mgr.add_const('NTDDI_WS03SP1',0x05020100)
    win_const_mgr.add_const('LVS_EX_AUTOAUTOARRANGE',0x01000000)
    win_const_mgr.add_const('MCI_RECORD_OVERWRITE',0x00000200)
    win_const_mgr.add_const('PORT_TIME',0x00000025)
    win_const_mgr.add_const('DCI_SURFACE_TYPE',0x0000000F)
    win_const_mgr.add_const('LB_GETSEL',0x00000187)
    win_const_mgr.add_const('INVALID_RUNDOWN_ROUTINE_INDEX',0x000000FF)
    win_const_mgr.add_const('KERB_CHECKSUM_MD5_DES',0x00000008)
    win_const_mgr.add_const('ERROR_SERVICE_DEPENDENCY_DELETED',0x00000433)
    win_const_mgr.add_const('LINEDISCONNECTMODE_CANCELLED',0x00080000)
    win_const_mgr.add_const('DC_BINNAMES',0x0000000C)
    win_const_mgr.add_const('SUBLANG_BASHKIR_RUSSIA',0x00000001)
    win_const_mgr.add_const('SQL_COLUMN_DISPLAY_SIZE',0x00000006)
    win_const_mgr.add_const('TRUSTEE_ACCESS_EXPLICIT',0x00000001)
    win_const_mgr.add_const('REO_INVERTEDSELECT',0x00000004)
    win_const_mgr.add_const('RATING_TWO_STARS_MAX',0x00000025)
    win_const_mgr.add_const('NCBDGSENDBC',0x00000022)
    win_const_mgr.add_const('STDPROP_USERPROP_MAX',0x7FFFFFFF)
    win_const_mgr.add_const('R2_NOT',0x00000006)
    win_const_mgr.add_const('TBCDRF_NOEDGES',0x00010000)
    win_const_mgr.add_const('BLLI_L3_ISO_8208',0x00000007)
    win_const_mgr.add_const('IDM_NOACTIVATENORMALOLECONTROLS',0x0000091C)
    win_const_mgr.add_const('SNMP_MGMTAPI_SELECT_FDERRORS',0x00000029)
    win_const_mgr.add_const('CERT_NAME_STR_DISABLE_UTF8_DIR_STR_FLAG',0x00100000)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_NETWORK_SERVICE',0x80080000)
    win_const_mgr.add_const('SQL_SQL92_ROW_VALUE_CONSTRUCTOR',0x000000A3)
    win_const_mgr.add_const('PATCH_OPTION_SIGNATURE_MD5',0x01000000)
    win_const_mgr.add_const('GLEX_PUSHBACK',0x00000004)
    win_const_mgr.add_const('TT_ENABLED',0x00000002)
    win_const_mgr.add_const('PIDDSI_SLIDECOUNT',0x00000007)
    win_const_mgr.add_const('BSIM_STATE',0x00000001)
    win_const_mgr.add_const('SPI_SETSELECTIONFADE',0x00001015)
    win_const_mgr.add_const('SERVICE_UI_ALLOWED',0x00000010)
    win_const_mgr.add_const('DRIVER_UNTRUSTED_HARDWAREID_RANK',0x00008FFF)
    win_const_mgr.add_const('PFD_SWAP_EXCHANGE',0x00000200)
    win_const_mgr.add_const('QOS_CLASS3',0x00000003)
    win_const_mgr.add_const('OID_802_3_XMIT_MORE_COLLISIONS',0x01020103)
    win_const_mgr.add_const('SPI_SETSHOWSOUNDS',0x00000039)
    win_const_mgr.add_const('OID_GEN_STATISTICS',0x00020106)
    win_const_mgr.add_const('DPAM_INTERSECT',0x00000008)
    win_const_mgr.add_const('OID_FDDI_PORT_LER_FLAG',0x03030275)
    win_const_mgr.add_const('FS_CHINESESIMP',0x00040000)
    win_const_mgr.add_const('SQL_NAMED',0x00000000)
    win_const_mgr.add_const('DBPROPVAL_BD_XTRANSACTION',0x00000002)
    win_const_mgr.add_const('DEVPROP_TYPE_UINT32',0x00000007)
    win_const_mgr.add_const('D3DCAPS2_RESERVED',0x02000000)
    win_const_mgr.add_const('PAGESETUPDLGORD',0x0000060A)
    win_const_mgr.add_const('CDO_E_FAILED_TO_CONNECT',0x80040213)
    win_const_mgr.add_const('CRED_FLAGS_VALID_FLAGS',0x0000F01F)
    win_const_mgr.add_const('DPAM_NORMAL',0x00000002)
    win_const_mgr.add_const('VP_FLAGS_FLICKER',0x00000004)
    win_const_mgr.add_const('FD_LONGHORN',0x00000001)
    win_const_mgr.add_const('SUCCEED_ABORT',0x00000002)
    win_const_mgr.add_const('SIZE_T_MAX',0x00000000)
    win_const_mgr.add_const('ERROR_MENU_ITEM_NOT_FOUND',0x000005B0)
    win_const_mgr.add_const('DPNHADDRESSTYPE_FIXEDPORTS',0x00000002)
    win_const_mgr.add_const('DDBLTFX_ARITHSTRETCHY',0x00000001)
    win_const_mgr.add_const('SNMPAPI_TL_RESOURCE_ERROR',0x00000067)
    win_const_mgr.add_const('MAX_SERVICE_NAME_LEN',0x00000100)
    win_const_mgr.add_const('LC_STYLED',0x00000020)
    win_const_mgr.add_const('RPCFLG_INPUT_SYNCHRONOUS',0x20000000)
    win_const_mgr.add_const('PS_NULL',0x00000005)
    win_const_mgr.add_const('DB_PROT_LEVEL_PKT',0x00000003)
    win_const_mgr.add_const('ERROR_I24_WRITE_FAULT',0x0000000A)
    win_const_mgr.add_const('LINEDISCONNECTMODE_PICKUP',0x00000008)
    win_const_mgr.add_const('SCH_CRED_REVOCATION_CHECK_CACHE_ONLY',0x00004000)
    win_const_mgr.add_const('DELTA_FILE_SIZE_LIMIT',0x00000020)
    win_const_mgr.add_const('SQL_COLUMN_SEARCHABLE',0x0000000D)
    win_const_mgr.add_const('IPX_PACE_DEFVAL',0x00000012)
    win_const_mgr.add_const('SL_INTERNAL_ZONE',0x0000E000)
    win_const_mgr.add_const('SHOP_VOLUMEGUID',0x00000004)
    win_const_mgr.add_const('NUMPRS_NEG',0x00010000)
    win_const_mgr.add_const('JOB_OBJECT_LIMIT_SILENT_BREAKAWAY_OK',0x00001000)
    win_const_mgr.add_const('JIFMK_SOS',0x0000FFDA)
    win_const_mgr.add_const('ERROR_PIPE_LISTENING',0x00000218)
    win_const_mgr.add_const('PAN_NO_FIT',0x00000001)
    win_const_mgr.add_const('PBT_APMQUERYSUSPEND',0x00000000)
    win_const_mgr.add_const('SECURITY_NT_NON_UNIQUE_SUB_AUTH_COUNT',0x00000003)
    win_const_mgr.add_const('NSTYPE_ENUMERABLE',0x00000004)
    win_const_mgr.add_const('IMGCHG_COMPLETE',0x00000004)
    win_const_mgr.add_const('VER_GREATER_EQUAL',0x00000003)
    win_const_mgr.add_const('DISPID_SHOWDETAILS',0x0000000B)
    win_const_mgr.add_const('PS_16K',0x0000000E)
    win_const_mgr.add_const('WMDM_STORAGECAP_FILESINFOLDERS',0x00000008)
    win_const_mgr.add_const('DEBUG_VALUE_FLOAT64',0x00000006)
    win_const_mgr.add_const('PS_16M',0x00000018)
    win_const_mgr.add_const('SCH_CRED_REVOCATION_CHECK_CHAIN_EXCLUDE_ROOT',0x00000400)
    win_const_mgr.add_const('IPPORT_TELNET',0x00000017)
    win_const_mgr.add_const('DNS_TYPE_SOA',0x00000006)
    win_const_mgr.add_const('IDM_CUT',0x00000010)
    win_const_mgr.add_const('CM_DEVCAP_DOCKDEVICE',0x00000008)
    win_const_mgr.add_const('CMSG_CTRL_DEL_SIGNER',0x00000007)
    win_const_mgr.add_const('PST_KEY_LOCAL_MACHINE',0x00000001)
    win_const_mgr.add_const('ERROR_WRONG_TARGET_NAME',0x00000574)
    win_const_mgr.add_const('MMIO_FHOPEN',0x00000010)
    win_const_mgr.add_const('FIND_DIR',0x0000000F)
    win_const_mgr.add_const('ALG_SID_ECDH',0x00000005)
    win_const_mgr.add_const('CM_NONE',0x00000000)
    win_const_mgr.add_const('ICEE_CREATE_MACHINE_I386',0x00000100)
    win_const_mgr.add_const('MD_AUTH_SINGLEREQUEST',0x00000040)
    win_const_mgr.add_const('SUBLANG_DARI_AFGHANISTAN',0x00000001)
    win_const_mgr.add_const('IDM_TRIED_INSERTCELL',0x00000014)
    win_const_mgr.add_const('LAYERED_PROTOCOL',0x00000000)
    win_const_mgr.add_const('TLS1_ALERT_ACCESS_DENIED',0x00000031)
    win_const_mgr.add_const('IF_TYPE_MEDIAMAILOVERIP',0x0000008B)
    win_const_mgr.add_const('ERROR_SXS_XML_E_MISSING_PAREN',0x000036DC)
    win_const_mgr.add_const('VK_F17',0x00000080)
    win_const_mgr.add_const('IMAGE_FILE_MACHINE_R3000',0x00000162)
    win_const_mgr.add_const('DS_PDC_FLAG',0x00000001)
    win_const_mgr.add_const('ERROR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK',0x00001727)
    win_const_mgr.add_const('EM_GETSEL',0x000000B0)
    win_const_mgr.add_const('TRANSPORT_TYPE_LPC',0x00000004)
    win_const_mgr.add_const('OUT_RASTER_PRECIS',0x00000006)
    win_const_mgr.add_const('ALG_SID_AES',0x00000011)
    win_const_mgr.add_const('THREAD_TERMINATE',0x00000001)
    win_const_mgr.add_const('PD_NONETWORKBUTTON',0x00200000)
    win_const_mgr.add_const('FILE_COMPRESSION_NTCAB',0x00000003)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_SECURITYFIX_UNINSTALL',0x00000018)
    win_const_mgr.add_const('NORM_IGNORECASE',0x00000001)
    win_const_mgr.add_const('PFM_RIGHTINDENT',0x00000002)
    win_const_mgr.add_const('WINVER',0x00000500)
    win_const_mgr.add_const('SWP_FRAMECHANGED',0x00000020)
    win_const_mgr.add_const('ERROR_DEPENDENCY_NOT_ALLOWED',0x000013CD)
    win_const_mgr.add_const('FILE_DEVICE_UNKNOWN',0x00000022)
    win_const_mgr.add_const('FWP_V6_ADDR_SIZE',0x00000010)
    win_const_mgr.add_const('MKF_INDICATOR',0x00000020)
    win_const_mgr.add_const('STRSAFE_FILL_ON_FAILURE',0x00000400)
    win_const_mgr.add_const('DS_BEHAVIOR_WIN2003_WITH_MIXED_DOMAINS',0x00000001)
    win_const_mgr.add_const('SPFEI_ALL_SR_EVENTS',0x1FFFFC00000000)
    win_const_mgr.add_const('TIMERMODE_NORMAL',0x00000000)
    win_const_mgr.add_const('TMT_TEXTGLOWSIZE',0x00000979)
    win_const_mgr.add_const('DB_REMOTE',0x00000001)
    win_const_mgr.add_const('DIRECT3D_VERSION',0x00000900)
    win_const_mgr.add_const('__REQUIRED_RPCSAL_H_VERSION__',0x00000064)
    win_const_mgr.add_const('CFM_PROTECTED',0x00000010)
    win_const_mgr.add_const('CERT_STORE_TIME_VALIDITY_FLAG',0x00000002)
    win_const_mgr.add_const('NMPWAIT_NOWAIT',0x00000001)
    win_const_mgr.add_const('FEI_RINGING',0x00000000)
    win_const_mgr.add_const('SCARD_CLASS_VENDOR_INFO',0x00000001)
    win_const_mgr.add_const('UF_NO_AUTH_DATA_REQUIRED',0x02000000)
    win_const_mgr.add_const('DBG_DIVOVERFLOW',0x00000008)
    win_const_mgr.add_const('CRYPTUI_HIDE_DETAILPAGE',0x00000002)
    win_const_mgr.add_const('WGL_SWAP_OVERLAY4',0x00000010)
    win_const_mgr.add_const('SMS_EXTERN_PROPID_BASE',0x00006700)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_COMMIT_COMPLETE',0x00000040)
    win_const_mgr.add_const('RTM_VIEW_MASK_MCAST',0x00000002)
    win_const_mgr.add_const('CHANNEL_FLAG_SUSPEND',0x00000020)
    win_const_mgr.add_const('PXE_BA_CUSTOM',0x00000002)
    win_const_mgr.add_const('OID_GEN_ENUMERATE_PORTS',0x0001020D)
    win_const_mgr.add_const('SUBLANG_PASHTO_AFGHANISTAN',0x00000001)
    win_const_mgr.add_const('SERVICE_CONTROL_STATUS_REASON_INFO',0x00000001)
    win_const_mgr.add_const('BOM_PLAINTEXT',0x00000002)
    win_const_mgr.add_const('D3DCREATE_DISABLE_PSGP_THREADING',0x00002000)
    win_const_mgr.add_const('WINHTTP_FLAG_ESCAPE_DISABLE',0x00000040)
    win_const_mgr.add_const('PSR_TB',0x0000001A)
    win_const_mgr.add_const('IMAGE_SCN_LNK_COMDAT',0x00001000)
    win_const_mgr.add_const('TPM_TOPALIGN',0x00000000)
    win_const_mgr.add_const('SQL_DIAG_MESSAGE_TEXT',0x00000006)
    win_const_mgr.add_const('DS_REPSYNC_SELECT_SECRETS',0x00008000)
    win_const_mgr.add_const('FWP_CONDITION_FLAG_IS_IPSEC_NATT_RECLASSIFY',0x00000080)
    win_const_mgr.add_const('BG_E_INVALID_HASH_ALGORITHM',0x80200041)
    win_const_mgr.add_const('E_FILTER_SCRIPTLISTING',0x80100008)
    win_const_mgr.add_const('RTL_RUN_ONCE_ASYNC',0x00000002)
    win_const_mgr.add_const('MCI_VCR_STATUS_AUDIO_SOURCE_NUMBER',0x00004007)
    win_const_mgr.add_const('BAUD_600',0x00000020)
    win_const_mgr.add_const('RBBS_HIDETITLE',0x00000400)
    win_const_mgr.add_const('IDTB_INDEX',0x000000D6)
    win_const_mgr.add_const('SECPKG_CALL_PROCESS_TERM',0x00000100)
    win_const_mgr.add_const('IDM_GETDOCDLGFLAGS',0x00003A9D)
    win_const_mgr.add_const('SQL_OJ_ALL_COMPARISON_OPS',0x00000040)
    win_const_mgr.add_const('SPINST_FILES',0x00000010)
    win_const_mgr.add_const('PORT_RXE',0x000002F9)
    win_const_mgr.add_const('MCI_GETDEVCAPS_DEVICE_TYPE',0x00000004)
    win_const_mgr.add_const('PRINTER_CHANGE_ADD_PRINTER',0x00000001)
    win_const_mgr.add_const('ERROR_DS_DST_NC_MISMATCH',0x00002126)
    win_const_mgr.add_const('HTMLDLG_MODAL',0x00000020)
    win_const_mgr.add_const('HTTP_LOG_FIELD_URI',0x00800000)
    win_const_mgr.add_const('MD_CHANGE_TYPE_ADD_OBJECT',0x00000002)
    win_const_mgr.add_const('SHACF_URLHISTORY',0x00000002)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_SRVACQFAIL',0x0000361F)
    win_const_mgr.add_const('COLOR_SCHEMES',0x000002CB)
    win_const_mgr.add_const('ETW_DECIMAL_TYPE_VALUE',0x0000000F)
    win_const_mgr.add_const('SDP_ATTRIB_HID_LANG_ID_BASE_LIST',0x00000207)
    win_const_mgr.add_const('LINETERMSHARING_PRIVATE',0x00000001)
    win_const_mgr.add_const('XINPUT_GAMEPAD_RIGHT_SHOULDER',0x00000200)
    win_const_mgr.add_const('DISABLE_VHPT_WALKER',0x0000000A)
    win_const_mgr.add_const('TAPIMEDIATYPE_AUDIO',0x00000008)
    win_const_mgr.add_const('IDTB_PRINT',0x000000CF)
    win_const_mgr.add_const('ILDI_QUERYACCESS',0x00000008)
    win_const_mgr.add_const('ERROR_INSTALL_TRANSFORM_FAILURE',0x00000658)
    win_const_mgr.add_const('NRB_FUNCTION_REMOVE_LBAS_PINNED_SET',0x00000011)
    win_const_mgr.add_const('KSPIN_FLAG_PROCESS_IF_ANY_IN_RUN_STATE',0x01000000)
    win_const_mgr.add_const('SPI_SETLANGTOGGLE',0x0000005B)
    win_const_mgr.add_const('TABLET_DISABLE_TOUCHUIFORCEON',0x00000100)
    win_const_mgr.add_const('DI_FLAGSEX_INSTALLEDDRIVER',0x04000000)
    win_const_mgr.add_const('IMN_PRIVATE',0x0000000E)
    win_const_mgr.add_const('NET_STRING_IPV4_ADDRESS',0x00000001)
    win_const_mgr.add_const('DN_ARM_WAKEUP',0x04000000)
    win_const_mgr.add_const('WIA_PAGE_BUSINESSCARD',0x00000006)
    win_const_mgr.add_const('DISPID_WINDOWACTIVATE',0x0000006F)
    win_const_mgr.add_const('ERROR_CANTFETCHBACKWARDS',0x00000302)
    win_const_mgr.add_const('DDBLT_KEYDEST',0x00002000)
    win_const_mgr.add_const('OID_FDDI_SMT_LAST_SET_STATION_ID',0x0303021E)
    win_const_mgr.add_const('CERT_COMPARE_SUBJECT_CERT',0x0000000B)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW3_PRINT',0x00000496)
    win_const_mgr.add_const('FE_FONTSMOOTHINGDOCKING',0x00008000)
    win_const_mgr.add_const('REG_LINK',0x00000006)
    win_const_mgr.add_const('IIS_MD_UT_WAM',0x00000064)
    win_const_mgr.add_const('FWPM_ACTRL_ADD',0x00000001)
    win_const_mgr.add_const('SQL_ROW_NOROW',0x00000003)
    win_const_mgr.add_const('MCI_LOAD',0x00000850)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_RESUME',0x00000007)
    win_const_mgr.add_const('VALID_INHERIT_FLAGS',0x0000001F)
    win_const_mgr.add_const('IOF_SHOWHELP',0x00000001)
    win_const_mgr.add_const('OID_WAN_CO_GET_COMP_INFO',0x04010280)
    win_const_mgr.add_const('IDM_ADDRESS',0x0000088D)
    win_const_mgr.add_const('INTENT_SATURATION',0x00000002)
    win_const_mgr.add_const('IDM_TRIED_FONT',0x00000023)
    win_const_mgr.add_const('GESTURE_DOUBLE_UP',0x00000000)
    win_const_mgr.add_const('SQL_API_ODBC3_ALL_FUNCTIONS',0x000003E7)
    win_const_mgr.add_const('DPROMPT_OUTOFMEMORY',0x00000004)
    win_const_mgr.add_const('SECQOP_WRAP_OOB_DATA',0x40000000)
    win_const_mgr.add_const('DOMAIN_USER_RID_MAX',0x000003E7)
    win_const_mgr.add_const('STN_ENABLE',0x00000002)
    win_const_mgr.add_const('ERROR_DS_CANT_DELETE',0x000020CE)
    win_const_mgr.add_const('ERROR_SXS_XML_E_MISSINGEQUALS',0x000036F9)
    win_const_mgr.add_const('MDLEVEL_TYPE_TIME_UNDEFINED',0x00001004)
    win_const_mgr.add_const('LOCALE_SGROUPING',0x00000010)
    win_const_mgr.add_const('SYMSTOREOPT_UNICODE',0x00000020)
    win_const_mgr.add_const('PIDDRSI_PROTECTED',0x00000002)
    win_const_mgr.add_const('DRV_USER',0x00004000)
    win_const_mgr.add_const('CLUSCTL_RESOURCE_STATE_CHANGE_REASON_VERSION_1',0x00000001)
    win_const_mgr.add_const('URL_MK_NO_CANONICALIZE',0x00000002)
    win_const_mgr.add_const('PRINTER_ENUM_ICON6',0x00200000)
    win_const_mgr.add_const('PRINTER_ENUM_ICON7',0x00400000)
    win_const_mgr.add_const('SCARD_READER_TYPE_PARALELL',0x00000002)
    win_const_mgr.add_const('PRINTER_ENUM_ICON5',0x00100000)
    win_const_mgr.add_const('PRINTER_ENUM_ICON2',0x00020000)
    win_const_mgr.add_const('MD_ERROR_NOT_INITIALIZED',0x800CC800)
    win_const_mgr.add_const('SUBLANG_KONKANI_INDIA',0x00000001)
    win_const_mgr.add_const('PRINTER_ENUM_ICON1',0x00010000)
    win_const_mgr.add_const('DEBUG_ENGOPT_DISABLE_EXECUTION_COMMANDS',0x00010000)
    win_const_mgr.add_const('ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE',0x00002137)
    win_const_mgr.add_const('PAGEMASK_16KB',0x00000003)
    win_const_mgr.add_const('RTM_ENUM_RANGE',0x00000002)
    win_const_mgr.add_const('AGP_FLAG_NO_4X_RATE',0x00000004)
    win_const_mgr.add_const('ERROR_BAD_EXE_FORMAT',0x000000C1)
    win_const_mgr.add_const('USER_PARTIAL_SECRETS_ACCOUNT',0x00100000)
    win_const_mgr.add_const('TASK_TUESDAY',0x00000004)
    win_const_mgr.add_const('BAUD_128K',0x00010000)
    win_const_mgr.add_const('IPV6_RECVRTHDR',0x00000026)
    win_const_mgr.add_const('EVENT_TRACE_BUFFERING_MODE',0x00000400)
    win_const_mgr.add_const('TBBF_LARGE',0x00000001)
    win_const_mgr.add_const('DRM_EL_EUL_LID',0x00000040)
    win_const_mgr.add_const('APPCOMMAND_BROWSER_FORWARD',0x00000002)
    win_const_mgr.add_const('ERROR_SERVICE_CANNOT_ACCEPT_CTRL',0x00000425)
    win_const_mgr.add_const('URLACTION_XPS_DOCUMENTS',0x00002401)
    win_const_mgr.add_const('TF_CONVERSIONMODE_FULLSHAPE',0x00000008)
    win_const_mgr.add_const('CB_SHOWDROPDOWN',0x0000014F)
    win_const_mgr.add_const('PLAL_ALERT_CMD_LINE_L_VAL',0x00001000)
    win_const_mgr.add_const('MC_SUPPORTED_COLOR_TEMPERATURE_5000K',0x00000002)
    win_const_mgr.add_const('CLFS_MGMT_POLICY_VERSION',0x00000001)
    win_const_mgr.add_const('DTS_SHORTDATECENTURYFORMAT',0x0000000C)
    win_const_mgr.add_const('SDP_ATTRIB_PAN_MAX_NET_ACCESS_RATE',0x0000030C)
    win_const_mgr.add_const('PORT_DSP',0x00000021)
    win_const_mgr.add_const('NDIS_MAC_OPTION_RECEIVE_SERIALIZED',0x00000002)
    win_const_mgr.add_const('NTDSSETTINGS_OPT_FORCE_KCC_WHISTLER_BEHAVIOR',0x00000001)
    win_const_mgr.add_const('IF_TYPE_FRAMERELAY_MPI',0x0000005C)
    win_const_mgr.add_const('ERROR_EVENT_DONE',0x000002C6)
    win_const_mgr.add_const('LINEERR_INVALAGENTID',0x80000057)
    win_const_mgr.add_const('SIZE_MAXHIDE',0x00000004)
    win_const_mgr.add_const('LVHT_EX_GROUP_HEADER',0x10000000)
    win_const_mgr.add_const('CRLF_DELTA_USE_OLDEST_UNEXPIRED_BASE',0x00000001)
    win_const_mgr.add_const('MFASFINDEXER_NO_FIXED_INTERVAL',0x00000000)
    win_const_mgr.add_const('PO_PORTCHANGE',0x00000020)
    win_const_mgr.add_const('TABLE_CHANGED',0x00000001)
    win_const_mgr.add_const('IF_TYPE_V37',0x00000078)
    win_const_mgr.add_const('IF_TYPE_V36',0x00000041)
    win_const_mgr.add_const('SHA_HASH_LEN',0x00000014)
    win_const_mgr.add_const('PORT_DSF',0x0000022B)
    win_const_mgr.add_const('SQL_DIAG_CALL',0x00000007)
    win_const_mgr.add_const('LINEERR_REQUESTOVERRUN',0x8000004C)
    win_const_mgr.add_const('AUTHZ_GENERATE_FAILURE_AUDIT',0x00000002)
    win_const_mgr.add_const('CSIDL_ALTSTARTUP',0x00000001)
    win_const_mgr.add_const('PSR_DFH',0x00000013)
    win_const_mgr.add_const('CTRY_SOUTH_AFRICA',0x0000001B)
    win_const_mgr.add_const('COMP_ELEM_POS_TOP',0x00000020)
    win_const_mgr.add_const('ERROR_DS_DATABASE_ERROR',0x000020D9)
    win_const_mgr.add_const('CF_MAX',0x0000000F)
    win_const_mgr.add_const('IF_TYPE_PROP_WIRELESS_P2P',0x0000009D)
    win_const_mgr.add_const('CTRY_MALDIVES',0x000003C0)
    win_const_mgr.add_const('WMDRM_QUERY_DEVICE_CLOCKSTATUS',0x00000002)
    win_const_mgr.add_const('DBPROPVAL_TI_READUNCOMMITTED',0x00000100)
    win_const_mgr.add_const('WINSTA_READSCREEN',0x00000200)
    win_const_mgr.add_const('SERVICE_REDIR_PAUSED',0x00000700)
    win_const_mgr.add_const('ERROR_POLICY_OBJECT_NOT_FOUND',0x0000201B)
    win_const_mgr.add_const('TMT_GRADIENTINACTIVECAPTION',0x0000065D)
    win_const_mgr.add_const('PID_COMPUTERNAME',0x00000005)
    win_const_mgr.add_const('RPC_S_INVALID_AUTH_IDENTITY',0x000006D5)
    win_const_mgr.add_const('RTCEF_PRESENCE_PROPERTY',0x00020000)
    win_const_mgr.add_const('D3DDEVCAPS_TEXTURESYSTEMMEMORY',0x00000100)
    win_const_mgr.add_const('STATE_SYSTEM_FOCUSABLE',0x00100000)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_COVER',0x00000021)
    win_const_mgr.add_const('INTERNET_HANDLE_TYPE_CONNECT_HTTP',0x00000004)
    win_const_mgr.add_const('ACTRL_DS_DELETE_TREE',0x00000040)
    win_const_mgr.add_const('COD_MINOR_BIT_OFFSET',0x00000002)
    win_const_mgr.add_const('NDW_INSTALLFLAG_HARDWAREALLREADYIN',0x00000002)
    win_const_mgr.add_const('MD_ERROR_INVALID_VERSION',0x800CC802)
    win_const_mgr.add_const('IMPLINK_HIGHEXPER',0x0000009E)
    win_const_mgr.add_const('SHOP_FILEPATH',0x00000002)
    win_const_mgr.add_const('PGK_MENU',0x00000004)
    win_const_mgr.add_const('DBPROPVAL_IC_SENSITIVE',0x00000004)
    win_const_mgr.add_const('PERF_COUNTER_ELAPSED',0x00040000)
    win_const_mgr.add_const('ELF_DISABLEUPDATENOW',0x00000002)
    win_const_mgr.add_const('TTFCFP_DELTA',0x00000002)
    win_const_mgr.add_const('CBS_OEMCONVERT',0x00000080)
    win_const_mgr.add_const('ERROR_WAKE_SYSTEM',0x000002DA)
    win_const_mgr.add_const('COD_LAN_ACCESS_17_USED',0x00000001)
    win_const_mgr.add_const('RIDEV_NOLEGACY',0x00000030)
    win_const_mgr.add_const('MD_LFHINT_NT2',0x00000002)
    win_const_mgr.add_const('GMEM_ZEROINIT',0x00000040)
    win_const_mgr.add_const('ERR_TSTDUP',0x0000005C)
    win_const_mgr.add_const('LINEERR_INVALMESSAGEID',0x80000030)
    win_const_mgr.add_const('ENM_UPDATE',0x00000002)
    win_const_mgr.add_const('CSIDL_COMMON_TEMPLATES',0x00000002)
    win_const_mgr.add_const('PPP_LCP_SSHF',0x00000008)
    win_const_mgr.add_const('VK_NONAME',0x000000FC)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_SYSTEMCALL',0x00000080)
    win_const_mgr.add_const('NRC_DUPNAME',0x00000000)
    win_const_mgr.add_const('NDW_INSTALLFLAG_EXPRESSINTRO',0x00000400)
    win_const_mgr.add_const('DM_PROMPT',0x00000004)
    win_const_mgr.add_const('VOS_OS216_PM16',0x00020002)
    win_const_mgr.add_const('IF_TYPE_IBM370PARCHAN',0x00000048)
    win_const_mgr.add_const('CACHE_ENTRY_EXPTIME_FC',0x00000080)
    win_const_mgr.add_const('ERROR_UNABLE_TO_REMOVE_REPLACED',0x00000497)
    win_const_mgr.add_const('MSGF_MENU',0x00000002)
    win_const_mgr.add_const('CMM_WIN_VERSION',0x00000000)
    win_const_mgr.add_const('PHONE_STATE',0x00000012)
    win_const_mgr.add_const('MIDI_CACHE_QUERY',0x00000003)
    win_const_mgr.add_const('ERROR_ILLEGAL_CHARACTER',0x00000246)
    win_const_mgr.add_const('ACTRL_ACCESS_PROTECTED',0x00000001)
    win_const_mgr.add_const('VK_OEM_FJ_ROYA',0x00000096)
    win_const_mgr.add_const('ACCESS_MAX_MS_ACE_TYPE',0x00000008)
    win_const_mgr.add_const('SUBLANG_ESTONIAN_ESTONIA',0x00000001)
    win_const_mgr.add_const('LANG_SERBIAN_NEUTRAL',0x00000007)
    win_const_mgr.add_const('DIF_REGISTERDEVICE',0x00000019)
    win_const_mgr.add_const('ML_SHELL_LANGUAGE',0x00000004)
    win_const_mgr.add_const('SCHEME_UPDATE',0x00000020)
    win_const_mgr.add_const('HTTP_LOG_FIELD_SERVER_PORT',0x00008000)
    win_const_mgr.add_const('DBPARAMTYPE_INPUT',0x00000001)
    win_const_mgr.add_const('DBFLAGS_CHECKPOINTDEPTH60MB',0x00000020)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_MINIPORT_ADD_DEVICE_REGISTRATION_ATTRIBUTES',0x000000A4)
    win_const_mgr.add_const('EN_HSCROLL',0x00000601)
    win_const_mgr.add_const('FILE_DEVICE_INPORT_PORT',0x00000000)
    win_const_mgr.add_const('TCIF_TEXT',0x00000001)
    win_const_mgr.add_const('INTERNET_OPEN_TYPE_DIRECT',0x00000001)
    win_const_mgr.add_const('MCI_VCR_PLAY_SCAN',0x00040000)
    win_const_mgr.add_const('DS_SCHEMA_GUID_CLASS',0x00000003)
    win_const_mgr.add_const('BITS_MC_FATAL_IGD_ERROR',0x80194009)
    win_const_mgr.add_const('DV_NTSCPAL',0x00200000)
    win_const_mgr.add_const('OS_PROFESSIONAL',0x00000014)
    win_const_mgr.add_const('DEBUG_BREAK_WRITE',0x00000002)
    win_const_mgr.add_const('OID_IP6_OFFLOAD_STATS',0xFC01020A)
    win_const_mgr.add_const('SFGAO_LINK',0x00010000)
    win_const_mgr.add_const('WINHTTP_QUERY_CONTENT_RANGE',0x00000035)
    win_const_mgr.add_const('DDSCAPS2_RTPATCHES',0x01000000)
    win_const_mgr.add_const('MD_ERROR_SUB404_DENIED_BY_POLICY',0x00000002)
    win_const_mgr.add_const('CLTYPE_LEN',0x0000000C)
    win_const_mgr.add_const('GCS_VERBICONW',0x00000014)
    win_const_mgr.add_const('VIDEO_CONFIGURE_MIN',0x00000040)
    win_const_mgr.add_const('URL_ESCAPE_PERCENT',0x00001000)
    win_const_mgr.add_const('SM_CXMINTRACK',0x00000022)
    win_const_mgr.add_const('SUBLANG_SERBIAN_CYRILLIC',0x00000003)
    win_const_mgr.add_const('PFA_LEFT',0x00000001)
    win_const_mgr.add_const('PORT_POP2',0x0000006D)
    win_const_mgr.add_const('PORT_POP3',0x0000006E)
    win_const_mgr.add_const('BLACK_PEN',0x00000007)
    win_const_mgr.add_const('ERROR_DS_NAME_VALUE_TOO_LONG',0x0000209D)
    win_const_mgr.add_const('WM_COMMNOTIFY',0x00000044)
    win_const_mgr.add_const('WEBPOST_ERROR_LAST',0x400421FF)
    win_const_mgr.add_const('SQL_NOSCAN',0x00000002)
    win_const_mgr.add_const('MD_SERVER_CONFIG_SSL_128',0x00000002)
    win_const_mgr.add_const('MCI_DGV_STATUS_VIDEO_SRC_NUM',0x00000401)
    win_const_mgr.add_const('IMGBITS_MASK',0x0E000000)
    win_const_mgr.add_const('PORT_CISCOSYS',0x00000084)
    win_const_mgr.add_const('SENSITIVITY_PROP_PERSONAL',0x00000001)
    win_const_mgr.add_const('D3DPRASTERCAPS_WFOG',0x00100000)
    win_const_mgr.add_const('PCMCIA_DEF_MIN_REGION',0x00010000)
    win_const_mgr.add_const('DSLFLAG_MISMATCHED_DBG',0x00000002)
    win_const_mgr.add_const('RTM_NEXTHOP_CHANGE_NEW',0x00000001)
    win_const_mgr.add_const('SQL_SR_INSERT_TABLE',0x00000100)
    win_const_mgr.add_const('IDS_CAP_STAT_LIVE_MODE',0x000001F4)
    win_const_mgr.add_const('NETE_ENCRYPT_REQ',0x00000013)
    win_const_mgr.add_const('EMR_POLYPOLYGON',0x00000008)
    win_const_mgr.add_const('DIB_PAL_COLORS',0x00000001)
    win_const_mgr.add_const('DB_IN',0x00000001)
    win_const_mgr.add_const('DEBUG_STATUS_NO_CHANGE',0x00000000)
    win_const_mgr.add_const('DNS_TKEY_MODE_GSS',0x00000003)
    win_const_mgr.add_const('OID_FDDI_LONG_CURRENT_ADDR',0x03010102)
    win_const_mgr.add_const('HORZSIZE',0x00000004)
    win_const_mgr.add_const('CB_GETCOMBOBOXINFO',0x00000164)
    win_const_mgr.add_const('DFCS_BUTTONRADIO',0x00000004)
    win_const_mgr.add_const('ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED',0x000020EA)
    win_const_mgr.add_const('DRM_ACTIVATE_DELAYED',0x00000040)
    win_const_mgr.add_const('CHANGER_CLEANER_AUTODISMOUNT',0x80000004)
    win_const_mgr.add_const('LWA_ALPHA',0x00000002)
    win_const_mgr.add_const('ERROR_DS_DRA_BAD_NC',0x000020F8)
    win_const_mgr.add_const('WMDM_E_CANTOPEN_PMSN_SERVICE_PIPE',0x80045013)
    win_const_mgr.add_const('MF_GRAYED',0x00000001)
    win_const_mgr.add_const('MCI_DGV_REALIZE_NORM',0x00010000)
    win_const_mgr.add_const('KSPIN_FLAG_DISTINCT_TRAILING_EDGE',0x00000200)
    win_const_mgr.add_const('GESTURE_SQUIGGLE',0x00000000)
    win_const_mgr.add_const('TA_BASELINE',0x00000018)
    win_const_mgr.add_const('DM_LOGPIXELS',0x00020000)
    win_const_mgr.add_const('SDP_ATTRIB_PAN_NET_ACCESS_TYPE',0x0000030B)
    win_const_mgr.add_const('DEVPROP_TYPE_EMPTY',0x00000000)
    win_const_mgr.add_const('EDITF_ATTRIBUTEEKU',0x00008000)
    win_const_mgr.add_const('E_FILTER_SCRIPTLABEL',0x80100010)
    win_const_mgr.add_const('WIA_IPC_AUDIO_AVAILABLE',0x00001405)
    win_const_mgr.add_const('WINHTTP_QUERY_IF_MODIFIED_SINCE',0x00000020)
    win_const_mgr.add_const('NRB_ILLEGAL_REQUEST',0x00000001)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_SECURITYFIX_UNINSTALL',0x00000015)
    win_const_mgr.add_const('EXCEPTION_DEBUG_EVENT',0x00000001)
    win_const_mgr.add_const('RPC_S_INVALID_TIMEOUT',0x000006AD)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_SA_DELETED',0x000035EF)
    win_const_mgr.add_const('CR_PROP_PRODUCTVERSION',0x00000002)
    win_const_mgr.add_const('LINE_GENERATE',0x00000007)
    win_const_mgr.add_const('SPDIT_CLASSDRIVER',0x00000001)
    win_const_mgr.add_const('RPC_S_NOT_LISTENING',0x000006B3)
    win_const_mgr.add_const('KSAC3_SERVICE_VISUALLY_IMPAIRED',0x00000002)
    win_const_mgr.add_const('INTERNET_HANDLE_TYPE_CONNECT_FTP',0x00000002)
    win_const_mgr.add_const('OBM_OLD_DNARROW',0x00007FFC)
    win_const_mgr.add_const('CRYPTUI_WIZ_DIGITAL_SIGN_ADD_CHAIN_NO_ROOT',0x00000002)
    win_const_mgr.add_const('SHI1005_FLAGS_RESTRICT_EXCLUSIVE_OPENS',0x00000100)
    win_const_mgr.add_const('IDM_TRIED_MERGECELLS',0x00000012)
    win_const_mgr.add_const('DE_E_FILTER_SCRIPTTEXTAREA',0x80100020)
    win_const_mgr.add_const('TPR_MIC',0x00000004)
    win_const_mgr.add_const('SMART_SHORT_SELFTEST_CAPTIVE',0x00000081)
    win_const_mgr.add_const('RAS_EAP_FLAG_HOSTED_IN_PEAP',0x00000100)
    win_const_mgr.add_const('TMT_SCROLLBARWIDTH',0x000004B2)
    win_const_mgr.add_const('NETERR_RING_STATUS_REMOTE_RECEIVED',0x00000200)
    win_const_mgr.add_const('PID_TITLE',0x00000002)
    win_const_mgr.add_const('SCARD_READER_TYPE_PCMCIA',0x00000040)
    win_const_mgr.add_const('OID_FDDI_LONG_PERMANENT_ADDR',0x03010101)
    win_const_mgr.add_const('PDH_PLA_VALIDATION_WARNING',0x80000BF3)
    win_const_mgr.add_const('VK_XBUTTON2',0x00000006)
    win_const_mgr.add_const('SES_NOIME',0x00000080)
    win_const_mgr.add_const('WIA_IPA_DEPTH',0x00001008)
    win_const_mgr.add_const('SPSVCINST_CLOBBER_SECURITY',0x00000400)
    win_const_mgr.add_const('SHI1005_FLAGS_ACCESS_BASED_DIRECTORY_ENUM',0x00000800)
    win_const_mgr.add_const('DMPAPER_B4',0x0000000C)
    win_const_mgr.add_const('WRITE_WATCH_FLAG_RESET',0x00000001)
    win_const_mgr.add_const('BCRYPT_SUPPORTED_PAD_PKCS1_SIG',0x00000004)
    win_const_mgr.add_const('SYMF_THUNK',0x00002000)
    win_const_mgr.add_const('PLATFORM_UNKNOWN',0x00000000)
    win_const_mgr.add_const('MD_APP_POOL_RECYCLE_CONFIG_CHANGE',0x00000040)
    win_const_mgr.add_const('FILE_ACTION_RENAMED_OLD_NAME',0x00000004)
    win_const_mgr.add_const('HFRMREG_LOCAL',0x00000001)
    win_const_mgr.add_const('ARCONTENT_PHASE_UNKNOWN',0x00000000)
    win_const_mgr.add_const('DDSCAPS3_CREATESHAREDRESOURCE',0x00002000)
    win_const_mgr.add_const('ERROR_DS_INIT_FAILURE',0x00002154)
    win_const_mgr.add_const('RPC_X_BAD_STUB_DATA',0x000006F7)
    win_const_mgr.add_const('CBENF_KILLFOCUS',0x00000001)
    win_const_mgr.add_const('ADS_SERVICE_ERROR_IGNORE',0x00000000)
    win_const_mgr.add_const('MOD_SHIFT',0x00000004)
    win_const_mgr.add_const('SHCNE_MEDIAINSERTED',0x00000020)
    win_const_mgr.add_const('SV_USERPATH_PARMNUM',0x00000070)
    win_const_mgr.add_const('VFT2_DRV_COMM',0x0000000A)
    win_const_mgr.add_const('HELP_SETINDEX',0x00000005)
    win_const_mgr.add_const('ERROR_SUCCESS_REBOOT_REQUIRED',0x00000BC2)
    win_const_mgr.add_const('NS_NBP',0x00000014)
    win_const_mgr.add_const('ERROR_LM_CROSS_ENCRYPTION_REQUIRED',0x0000056E)
    win_const_mgr.add_const('LVSIL_GROUPHEADER',0x00000003)
    win_const_mgr.add_const('NS_WRQ',0x00000032)
    win_const_mgr.add_const('SRRF_RT_REG_MULTI_SZ',0x00000020)
    win_const_mgr.add_const('ERROR_INVALID_PRINT_MONITOR',0x00000BBF)
    win_const_mgr.add_const('DSOP_SCOPE_FLAG_WANT_SID_PATH',0x00000010)
    win_const_mgr.add_const('ICEE_CREATE_MACHINE_IA64',0x00000200)
    win_const_mgr.add_const('SETUP_SUSPEND_FLAG',0x00000004)
    win_const_mgr.add_const('PORT_NETRJS1',0x00000047)
    win_const_mgr.add_const('PORT_NETRJS2',0x00000048)
    win_const_mgr.add_const('SQL_API_SQLDRIVERS',0x00000047)
    win_const_mgr.add_const('PORT_NETRJS4',0x0000004A)
    win_const_mgr.add_const('SQL_ISV_TABLE_CONSTRAINTS',0x00008000)
    win_const_mgr.add_const('RP_DSN_SENT_EXPANDED',0x00008040)
    win_const_mgr.add_const('MCI_DGV_SET_FILEFORMAT',0x00080000)
    win_const_mgr.add_const('WABOBJECT_ME_NEW',0x00000001)
    win_const_mgr.add_const('VFFF_ISSHAREDFILE',0x00000001)
    win_const_mgr.add_const('DDOVER_SHOW',0x00004000)
    win_const_mgr.add_const('TMT_TEXTSHADOWOFFSET',0x00000D4A)
    win_const_mgr.add_const('FEI_NOT_FAX_CALL',0x00000000)
    win_const_mgr.add_const('SRCINFO_PATH',0x00000001)
    win_const_mgr.add_const('SUBLANG_SPANISH_COLOMBIA',0x00000009)
    win_const_mgr.add_const('DNS_QUERY_WIRE_ONLY',0x00000100)
    win_const_mgr.add_const('WMDM_LOG_NOTIMESTAMP',0x00000010)
    win_const_mgr.add_const('DSOP_SCOPE_TYPE_USER_ENTERED_UPLEVEL_SCOPE',0x00000100)
    win_const_mgr.add_const('PAN_XHEIGHT_DUCKING_SMALL',0x00000005)
    win_const_mgr.add_const('PXE_TRACE_FATAL',0x00100000)
    win_const_mgr.add_const('ERROR_REMOTE_STORAGE_MEDIA_ERROR',0x00001100)
    win_const_mgr.add_const('ERROR_INVALID_SERVICE_ACCOUNT',0x00000421)
    win_const_mgr.add_const('TMT_MINSIZE5',0x00000D50)
    win_const_mgr.add_const('RENDBIND_DEFAULTCREDENTIALS',0x00000000)
    win_const_mgr.add_const('TMT_MINSIZE3',0x00000D4E)
    win_const_mgr.add_const('TMT_MINSIZE2',0x00000D4D)
    win_const_mgr.add_const('TMT_MINSIZE1',0x00000D4C)
    win_const_mgr.add_const('CDN_FIRST',0x00000000)
    win_const_mgr.add_const('DDF_UPDATE',0x00000002)
    win_const_mgr.add_const('SUBLANG_MONGOLIAN_CYRILLIC_MONGOLIA',0x00000001)
    win_const_mgr.add_const('WSA_QOS_ESERVICETYPE',0x00002B08)
    win_const_mgr.add_const('CERT_KEY_CERT_SIGN_KEY_USAGE',0x00000004)
    win_const_mgr.add_const('AUTHZ_SKIP_TOKEN_GROUPS',0x00000002)
    win_const_mgr.add_const('ERROR_CLUSTER_RHS_FAILED_INITIALIZATION',0x0000172B)
    win_const_mgr.add_const('APPCOMMAND_UNDO',0x00000022)
    win_const_mgr.add_const('DDSCAPS_OFFSCREENPLAIN',0x00000040)
    win_const_mgr.add_const('ERROR_DIR_EFS_DISALLOWED',0x0000177A)
    win_const_mgr.add_const('ERROR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE',0x0000030D)
    win_const_mgr.add_const('IF_MAX_STRING_SIZE',0x00000100)
    win_const_mgr.add_const('PF_COMPARE64_EXCHANGE128',0x0000000F)
    win_const_mgr.add_const('PDH_CSTATUS_NO_COUNTER',0xC0000BB9)
    win_const_mgr.add_const('MQMSG_AUTHENTICATED_SIG20',0x00000003)
    win_const_mgr.add_const('ELEMENT_STATUS_FULL',0x00000001)
    win_const_mgr.add_const('SQL_CURSOR_SENSITIVITY',0x00002711)
    win_const_mgr.add_const('LVS_TYPEMASK',0x00000003)
    win_const_mgr.add_const('SID_RECOMMENDED_SUB_AUTHORITIES',0x00000001)
    win_const_mgr.add_const('DN_BAD_PARTIAL',0x00400000)
    win_const_mgr.add_const('DISPID_IDISCRECORDER2_RELEASEEXCLUSIVEACCESS',0x00000103)
    win_const_mgr.add_const('GROUPIDMASK',0x00008000)
    win_const_mgr.add_const('TMT_TOCOLOR4',0x000007D9)
    win_const_mgr.add_const('NDIS_ETH_TYPE_IPV6',0x00000086)
    win_const_mgr.add_const('NDIS_ETH_TYPE_IPV4',0x00000800)
    win_const_mgr.add_const('SUBLANG_TSWANA_SOUTH_AFRICA',0x00000001)
    win_const_mgr.add_const('CRYPT_PUBKEY_ALG_OID_GROUP_ID',0x00000003)
    win_const_mgr.add_const('DS_REPSYNC_WRITEABLE',0x00000002)
    win_const_mgr.add_const('MPEGLAYER3_WFX_EXTRA_BYTES',0x0000000C)
    win_const_mgr.add_const('WIA_IPS_PAGE_SIZE',0x00000C19)
    win_const_mgr.add_const('SSRVACTION_TRACE',0x00000001)
    win_const_mgr.add_const('TME_LEAVE',0x00000002)
    win_const_mgr.add_const('CM_PROB_OUT_OF_MEMORY',0x00000003)
    win_const_mgr.add_const('SHGDFIL_FINDDATA',0x00000001)
    win_const_mgr.add_const('ILC_HIGHQUALITYSCALE',0x00020000)
    win_const_mgr.add_const('PHONEPRIVILEGE_MONITOR',0x00000001)
    win_const_mgr.add_const('SERIAL_IOC_FCR_RCVR_TRIGGER_MSB',0x00000080)
    win_const_mgr.add_const('SCARD_RESET_CARD',0x00000001)
    win_const_mgr.add_const('MDMVOLFLAG_MEDIUM',0x00000002)
    win_const_mgr.add_const('LINEERR_INVALDIALPARAMS',0x80000025)
    win_const_mgr.add_const('TVHT_NOWHERE',0x00000001)
    win_const_mgr.add_const('CERT_FIRST_USER_PROP_ID',0x00008000)
    win_const_mgr.add_const('DF_IMPERSONATION',0x80000000)
    win_const_mgr.add_const('GMEM_DISCARDED',0x00004000)
    win_const_mgr.add_const('DS_TRY_NEXTCLOSEST_SITE',0x00040000)
    win_const_mgr.add_const('MAXIMUM_SEQUENCE',0xFFFFFFFFFFFFFFFF)
    win_const_mgr.add_const('FACILITY_EAP_MESSAGE',0x00000842)
    win_const_mgr.add_const('STGM_OUTPUT',0x00008000)
    win_const_mgr.add_const('ERROR_AUTHIP_FAILURE',0x000005BD)
    win_const_mgr.add_const('MD_NOTIFY_URL_MAP',0x00001000)
    win_const_mgr.add_const('CHANNEL_RC_OK',0x00000000)
    win_const_mgr.add_const('KS_TVAUDIO_MODE_LANG_A',0x00000010)
    win_const_mgr.add_const('KS_TVAUDIO_MODE_LANG_C',0x00000040)
    win_const_mgr.add_const('KS_TVAUDIO_MODE_LANG_B',0x00000020)
    win_const_mgr.add_const('CC_INTERIORS',0x00000080)
    win_const_mgr.add_const('HKL_NEXT',0x00000001)
    win_const_mgr.add_const('CC_STYLED',0x00000020)
    win_const_mgr.add_const('GESTURE_LEFT_DOWN',0x00000000)
    win_const_mgr.add_const('DDOVER_ALPHADESTCONSTOVERRIDE',0x00000002)
    win_const_mgr.add_const('SQL_STILL_EXECUTING',0x00000002)
    win_const_mgr.add_const('WIA_IPA_PIXELS_PER_LINE',0x00001010)
    win_const_mgr.add_const('DEBUG_MANSTR_NONE',0x00000000)
    win_const_mgr.add_const('PSR_MBZ1',0x00000010)
    win_const_mgr.add_const('PSR_MBZ0',0x00000006)
    win_const_mgr.add_const('PSR_MBZ3',0x0000002E)
    win_const_mgr.add_const('MF_COMPONENT_LS_CERT_REVOKED',0x00040000)
    win_const_mgr.add_const('ERROR_CLUSTER_NO_QUORUM',0x00001725)
    win_const_mgr.add_const('KSEVENTF_EVENT_HANDLE',0x00000001)
    win_const_mgr.add_const('UPDP_CHECK_DRIVERSTORE',0x00000004)
    win_const_mgr.add_const('WINHTTP_OPTION_AUTOLOGON_POLICY',0x0000004D)
    win_const_mgr.add_const('PHOTO_GAINCONTROL_NONE',0x00000000)
    win_const_mgr.add_const('OID_GEN_RECEIVE_BUFFER_SPACE',0x00010109)
    win_const_mgr.add_const('V86FLAGS_AUXCARRY',0x00000010)
    win_const_mgr.add_const('AMDDS_YUVOFF',0x00000020)
    win_const_mgr.add_const('FWP_OPTION_VALUE_DENY_MULTICAST_STATE',0x00000001)
    win_const_mgr.add_const('WM_STYLECHANGING',0x0000007C)
    win_const_mgr.add_const('PTE_EXECUTE_MASK',0x00000200)
    win_const_mgr.add_const('DNS_ERROR_NAME_NOT_IN_ZONE',0x000025EA)
    win_const_mgr.add_const('TMT_TOCOLOR3',0x000007D8)
    win_const_mgr.add_const('KRB_NT_SRV_HST',0x00000003)
    win_const_mgr.add_const('LPV_REJECT',0x0000FFFF)
    win_const_mgr.add_const('MM_SUBMENUSHAVEIDS',0x00000002)
    win_const_mgr.add_const('LDAP_API_FEATURE_VIRTUAL_LIST_VIEW',0x000003E9)
    win_const_mgr.add_const('SQL_DOUBLE',0x00000008)
    win_const_mgr.add_const('SQL_ASYNC_ENABLE_OFF',0x00000000)
    win_const_mgr.add_const('ISDB_DCT_PID',0x00000017)
    win_const_mgr.add_const('IMAGE_REL_PPC_BRTAKEN',0x00000200)
    win_const_mgr.add_const('ILR_DEFAULT',0x00000000)
    win_const_mgr.add_const('PSR_ID',0x00000025)
    win_const_mgr.add_const('PSR_IC',0x0000000D)
    win_const_mgr.add_const('MCI_DGV_FF_RDIB',0x00004003)
    win_const_mgr.add_const('MD_ACCESS_SSL',0x00000008)
    win_const_mgr.add_const('DBPROPVAL_BO_NOINDEXUPDATE',0x00000001)
    win_const_mgr.add_const('IF_TYPE_HDSL2',0x000000A8)
    win_const_mgr.add_const('ERROR_INSTALL_SUSPEND',0x00000644)
    win_const_mgr.add_const('DEBUG_ENGOPT_DISALLOW_SHELL_COMMANDS',0x00001000)
    win_const_mgr.add_const('FR_HIDEWHOLEWORD',0x00010000)
    win_const_mgr.add_const('CONFIGFLAG_FINISHINSTALL_UI',0x00010000)
    win_const_mgr.add_const('D3DPTEXTURECAPS_CUBEMAP_POW2',0x00020000)
    win_const_mgr.add_const('FKF_INDICATOR',0x00000020)
    win_const_mgr.add_const('PSR_IT',0x00000024)
    win_const_mgr.add_const('PSR_IS',0x00000022)
    win_const_mgr.add_const('OBM_LFARROWD',0x00007FE4)
    win_const_mgr.add_const('D3DPSHADECAPS_ALPHAGOURAUDBLEND',0x00004000)
    win_const_mgr.add_const('ERROR_NOINTERFACE',0x00000278)
    win_const_mgr.add_const('DRM_SERVICE_TYPE_ACTIVATION',0x00000001)
    win_const_mgr.add_const('DDL_POSTMSGS',0x00002000)
    win_const_mgr.add_const('MAPI_EXTENDED',0x00000020)
    win_const_mgr.add_const('CRYPT_OAEP',0x00000040)
    win_const_mgr.add_const('ACM_FORMATENUMF_OUTPUT',0x01000000)
    win_const_mgr.add_const('ERROR_INVALID_SHOWWIN_COMMAND',0x000005A9)
    win_const_mgr.add_const('XINPUT_GAMEPAD_Y',0x00008000)
    win_const_mgr.add_const('XINPUT_GAMEPAD_X',0x00004000)
    win_const_mgr.add_const('SCHEMADEF_VERSION',0x00000001)
    win_const_mgr.add_const('DM_NUP',0x00000040)
    win_const_mgr.add_const('MSIMHOSTEVENTS_DISPID_ONCLICKUSERNOTIFY',0x0000000F)
    win_const_mgr.add_const('PP_DELETEKEY',0x00000018)
    win_const_mgr.add_const('WINHTTP_CALLBACK_STATUS_REQUEST_SENT',0x00000020)
    win_const_mgr.add_const('AE_BADPW',0x00000001)
    win_const_mgr.add_const('IME_CMODE_HANJACONVERT',0x00000040)
    win_const_mgr.add_const('XINPUT_GAMEPAD_B',0x00002000)
    win_const_mgr.add_const('TRUSTERROR_STEP_FINAL_UIPROV',0x00000025)
    win_const_mgr.add_const('DBCOMPUTEMODE_COMPUTED',0x00000001)
    win_const_mgr.add_const('PSP_HASHELP',0x00000020)
    win_const_mgr.add_const('AM_QUERY_DECODER_DXVA_1_SUPPORT',0x00000002)
    win_const_mgr.add_const('WSAECONNABORTED',0x00002745)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_CONFIG_PHYSICALDISK',0x0000000B)
    win_const_mgr.add_const('CLFS_FLAG_MINIFILTER_LEVEL',0x00000100)
    win_const_mgr.add_const('HTTP_FLUSH_RESPONSE_FLAG_RECURSIVE',0x00000001)
    win_const_mgr.add_const('LVS_EX_LABELTIP',0x00004000)
    win_const_mgr.add_const('MAPI_PREFIX',0x0000002A)
    win_const_mgr.add_const('ERROR_CTX_PD_NOT_FOUND',0x00001B5B)
    win_const_mgr.add_const('SSPROP_SQLXMLXPROGID',0x00000004)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_MAX',0x00000018)
    win_const_mgr.add_const('TSF_COPY_LOCALIZED_NAME',0x00000200)
    win_const_mgr.add_const('SQL_CA1_SELECT_FOR_UPDATE',0x00008000)
    win_const_mgr.add_const('DDSD_CKDESTBLT',0x00004000)
    win_const_mgr.add_const('IT_MSG_DATA_HEADER',0x00000001)
    win_const_mgr.add_const('CR_INVALID_MACHINENAME',0x0000002F)
    win_const_mgr.add_const('SUBLANG_KANNADA_INDIA',0x00000001)
    win_const_mgr.add_const('RPC_FW_IF_FLAG_DCOM',0x00000001)
    win_const_mgr.add_const('ED_TOP',0x00000001)
    win_const_mgr.add_const('LOCALE_SMONTHNAME8',0x0000003F)
    win_const_mgr.add_const('MIN_GOPHER_ATTRIBUTE_LENGTH',0x00000100)
    win_const_mgr.add_const('SNMP_AUTHAPI_INVALID_VERSION',0x0000001E)
    win_const_mgr.add_const('CTRY_FAEROE_ISLANDS',0x0000012A)
    win_const_mgr.add_const('WM_SETFONT',0x00000030)
    win_const_mgr.add_const('CDO_E_NOT_ALL_DELETED',0x80040223)
    win_const_mgr.add_const('SQL_COLUMN_UPDATABLE',0x0000000A)
    win_const_mgr.add_const('NFS_ALL',0x00000010)
    win_const_mgr.add_const('DMTT_DOWNLOAD',0x00000002)
    win_const_mgr.add_const('SUPPORTS_REMOTE_ADMIN_PROTOCOL',0x00000002)
    win_const_mgr.add_const('LINEERR_CALLUNAVAIL',0x80000005)
    win_const_mgr.add_const('MD_SERVER_COMMAND_STOP',0x00000002)
    win_const_mgr.add_const('ERROR_NOT_ALL_ASSIGNED',0x00000514)
    win_const_mgr.add_const('VER_SUITE_SMALLBUSINESS',0x00000001)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_OUT_OF_MEMORY',0x00003623)
    win_const_mgr.add_const('BKMODE_LAST',0x00000002)
    win_const_mgr.add_const('SQL_SP_MATCH_PARTIAL',0x00000010)
    win_const_mgr.add_const('SQL_DIAG_CREATE_SCHEMA',0x00000040)
    win_const_mgr.add_const('MIDI_IO_STATUS',0x00000020)
    win_const_mgr.add_const('DBT_VOLLOCKLOCKRELEASED',0x00008045)
    win_const_mgr.add_const('CDO_E_ARGUMENT1',0x80044000)
    win_const_mgr.add_const('D3DPRESENT_INTERVAL_IMMEDIATE',0x80000000)
    win_const_mgr.add_const('TASK_SATURDAY',0x00000040)
    win_const_mgr.add_const('CDO_E_ARGUMENT2',0x80044001)
    win_const_mgr.add_const('CDO_E_ARGUMENT5',0x80044004)
    win_const_mgr.add_const('ADO_MINOR',0x00000000)
    win_const_mgr.add_const('D3DLOCK_NOOVERWRITE',0x00001000)
    win_const_mgr.add_const('TRUSTERROR_STEP_SIP',0x00000003)
    win_const_mgr.add_const('ERROR_FULLSCREEN_MODE',0x000003EF)
    win_const_mgr.add_const('OID_TAPI_MONITOR_DIGITS',0x07030124)
    win_const_mgr.add_const('FILEOP_NEWPATH',0x00000004)
    win_const_mgr.add_const('BSF_QUERY',0x00000001)
    win_const_mgr.add_const('DISPLAY_DEVICE_TS_COMPATIBLE',0x00200000)
    win_const_mgr.add_const('INDEX_GUID_INKWORD',0x0000000A)
    win_const_mgr.add_const('RCRED_STATUS_UNKNOWN_ISSUER',0x00000002)
    win_const_mgr.add_const('SV_SESSREQS_PARMNUM',0x000001A1)
    win_const_mgr.add_const('LINE_PROXYSTATUS',0x0000001F)
    win_const_mgr.add_const('DOT11_PSD_IE_MAX_DATA_SIZE',0x000000F0)
    win_const_mgr.add_const('ATA_FLAGS_USE_DMA',0x00000001)
    win_const_mgr.add_const('PTE_PFN_LEN',0x00000018)
    win_const_mgr.add_const('MCI_RESERVE',0x00000872)
    win_const_mgr.add_const('ERROR_TRAY_MALFUNCTION',0x00000010)
    win_const_mgr.add_const('LINETERMMODE_BUTTONS',0x00000001)
    win_const_mgr.add_const('RTM_ENUM_OWN_ROUTES',0x00010000)
    win_const_mgr.add_const('OLEUI_ERR_FINDTEMPLATEFAILURE',0x0000006E)
    win_const_mgr.add_const('ERROR_EAS_NOT_SUPPORTED',0x0000011A)
    win_const_mgr.add_const('MAXIMUM_SMARTCARD_READERS',0x0000000A)
    win_const_mgr.add_const('PRINTER_ATTRIBUTE_DO_COMPLETE_FIRST',0x00000200)
    win_const_mgr.add_const('ADS_PRINTER_NO_TONER',0x00040000)
    win_const_mgr.add_const('PID_SUBJECT',0x00000003)
    win_const_mgr.add_const('CDO_E_LOGON_FAILURE',0x80040217)
    win_const_mgr.add_const('LBS_WANTKEYBOARDINPUT',0x00000400)
    win_const_mgr.add_const('WINHTTP_OPTION_PASSWORD',0x00001001)
    win_const_mgr.add_const('DEBUG_END_ACTIVE_TERMINATE',0x00000001)
    win_const_mgr.add_const('MMIO_GLOBALPROC',0x10000000)
    win_const_mgr.add_const('CERT_CHAIN_ENABLE_SHARE_STORE',0x00000020)
    win_const_mgr.add_const('IP_FRAGOFF_SHIFT',0x00000003)
    win_const_mgr.add_const('LINEDISCONNECTMODE_NODIALTONE',0x00001000)
    win_const_mgr.add_const('OPTION_SERVER_IDENTIFIER',0x00000036)
    win_const_mgr.add_const('FL_UFI_MEMORYFONT',0x00000004)
    win_const_mgr.add_const('OID_FDDI_PORT_INDEX',0x03030267)
    win_const_mgr.add_const('CLFS_MAX_CONTAINER_INFO',0x00000100)
    win_const_mgr.add_const('OID_GEN_MEDIA_CONNECT_STATUS',0x00010114)
    win_const_mgr.add_const('MIXERLINE_LINEF_ACTIVE',0x00000001)
    win_const_mgr.add_const('SQLBIGBINARY',0x00000000)
    win_const_mgr.add_const('BIF_SHAREABLE',0x00008000)
    win_const_mgr.add_const('WM_HELP',0x00000053)
    win_const_mgr.add_const('SPQ_SCAN_FILE_PRESENCE',0x00000001)
    win_const_mgr.add_const('SV_GUESTACC_PARMNUM',0x00000198)
    win_const_mgr.add_const('RDW_UPDATENOW',0x00000100)
    win_const_mgr.add_const('NRC_INVADDRESS',0x00000039)
    win_const_mgr.add_const('USHORT_ERROR',0x00000000)
    win_const_mgr.add_const('DMPAPER_ENV_INVITE',0x0000002F)
    win_const_mgr.add_const('ERROR_SYMLINK_NOT_SUPPORTED',0x000005B8)
    win_const_mgr.add_const('INTERNET_STATUS_FILTER_STATE_CHANGE',0x00004000)
    win_const_mgr.add_const('OPTION_BROADCAST_ADDRESS',0x0000001C)
    win_const_mgr.add_const('SP_SERIALCOMM',0x00000001)
    win_const_mgr.add_const('IMAGE_SCN_MEM_LOCKED',0x00040000)
    win_const_mgr.add_const('DNS_RCLASS_INTERNET',0x00000100)
    win_const_mgr.add_const('PROCESSOR_INTEL_386',0x00000182)
    win_const_mgr.add_const('CRED_MAX_VALUE_SIZE',0x00000100)
    win_const_mgr.add_const('WIA_PAGE_DIN_4B',0x00000035)
    win_const_mgr.add_const('S_STACCATO',0x00000002)
    win_const_mgr.add_const('MC_CAPS_DISPLAY_AREA_POSITION',0x00000080)
    win_const_mgr.add_const('PHOTO_EXPOSUREPROGRAM_MANUAL',0x00000001)
    win_const_mgr.add_const('PIR_STATUS_TABLE_REGISTRY',0x00000000)
    win_const_mgr.add_const('TRUSTERROR_STEP_FINAL_CERTCHKPROV',0x00000023)
    win_const_mgr.add_const('IPX_MAX_ADAPTER_NUM',0x0000400D)
    win_const_mgr.add_const('RTL_RUN_ONCE_CTX_RESERVED_BITS',0x00000002)
    win_const_mgr.add_const('OID_802_5_TOKEN_ERRORS',0x02020206)
    win_const_mgr.add_const('PRIVACY_URLHASCOMPACTPOLICY',0x00020000)
    win_const_mgr.add_const('BS_PUSHLIKE',0x00001000)
    win_const_mgr.add_const('IDM_REMOVEFORMAT',0x000008B6)
    win_const_mgr.add_const('HH_RESET_IT_FILTER',0x00000017)
    win_const_mgr.add_const('SORT_GEORGIAN_MODERN',0x00000001)
    win_const_mgr.add_const('PORT_EMFISDATA',0x0000008C)
    win_const_mgr.add_const('ADS_JOB_DELETED',0x00000100)
    win_const_mgr.add_const('DI_GENERALPAGE_ADDED',0x00001000)
    win_const_mgr.add_const('WINHTTP_CALLBACK_STATUS_NAME_RESOLVED',0x00000002)
    win_const_mgr.add_const('IS_IA',0x00000001)
    win_const_mgr.add_const('MD_ERROR_SUB404_DENIED_BY_MIMEMAP',0x00000003)
    win_const_mgr.add_const('SPI_SETWHEELSCROLLCHARS',0x0000006D)
    win_const_mgr.add_const('SQL_AD_DROP_DOMAIN_DEFAULT',0x00000010)
    win_const_mgr.add_const('CRYPT_ALL_FUNCTIONS',0x00000001)
    win_const_mgr.add_const('SQL_CODE_DAY_TO_MINUTE',0x00000009)
    win_const_mgr.add_const('JPEG_Y',0x00000001)
    win_const_mgr.add_const('DCE_C_ERROR_STRING_LEN',0x00000100)
    win_const_mgr.add_const('DEBUG_END_REENTRANT',0x00000003)
    win_const_mgr.add_const('MDPROPVAL_MNF_LINREGVARIANCE',0x00000100)
    win_const_mgr.add_const('DC_PAPERS',0x00000002)
    win_const_mgr.add_const('STI_VERSION_3',0x00000003)
    win_const_mgr.add_const('PAN_PROP_OLD_STYLE',0x00000002)
    win_const_mgr.add_const('FS_JOHAB',0x00200000)
    win_const_mgr.add_const('ERROR_CLUSTER_NODE_ALREADY_MEMBER',0x000013C9)
    win_const_mgr.add_const('SM_CYFRAME',0x00000021)
    win_const_mgr.add_const('DB_IMP_LEVEL_DELEGATE',0x00000003)
    win_const_mgr.add_const('SET_POLY_MODE',0x00001008)
    win_const_mgr.add_const('COMMON_LVB_REVERSE_VIDEO',0x00004000)
    win_const_mgr.add_const('DIREG_DEV',0x00000001)
    win_const_mgr.add_const('CACHE_CONFIG_COOKIES_PATHS_FC',0x00000200)
    win_const_mgr.add_const('STATE_SYSTEM_FLOATING',0x00001000)
    win_const_mgr.add_const('CERT_STORE_PROV_SYSTEM_STORE_FLAG',0x00000008)
    win_const_mgr.add_const('PROCESSOR_ALPHA_21064',0x00005248)
    win_const_mgr.add_const('GC_WCH_SIBLING',0x00000001)
    win_const_mgr.add_const('URLACTION_SHELL_VERB',0x00001804)
    win_const_mgr.add_const('ACTCTX_FLAG_PROCESSOR_ARCHITECTURE_VALID',0x00000001)
    win_const_mgr.add_const('WLX_SAS_ACTION_LOGOFF',0x00000004)
    win_const_mgr.add_const('DDCAPS2_CANBOBINTERLEAVED',0x00000010)
    win_const_mgr.add_const('IPX_STATIC_ROUTE_INFO_TYPE',0x00000002)
    win_const_mgr.add_const('DISABLE_STORE_UPDATE',0x0000000F)
    win_const_mgr.add_const('GGO_BITMAP',0x00000001)
    win_const_mgr.add_const('DB_PROT_LEVEL_NONE',0x00000000)
    win_const_mgr.add_const('CRYPTUI_WIZ_DIGITAL_SIGN_PVK_FILE',0x00000001)
    win_const_mgr.add_const('CERT_COMPARE_ATTR',0x00000003)
    win_const_mgr.add_const('SPEAKER_LOW_FREQUENCY',0x00000008)
    win_const_mgr.add_const('NCRYPTBUFFER_SSL_HIGHEST_VERSION',0x00000016)
    win_const_mgr.add_const('DEBUG_SYMTYPE_CODEVIEW',0x00000002)
    win_const_mgr.add_const('ERR_INVALID_FILE_TYPE',0xE000000B)
    win_const_mgr.add_const('PRINTER_FONTTYPE',0x00004000)
    win_const_mgr.add_const('OID_TAPI_OPEN',0x07030117)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_SCROLLTO',0x00000490)
    win_const_mgr.add_const('SQL_FN_STR_LTRIM',0x00000008)
    win_const_mgr.add_const('LDAP_OPT_CHASE_REFERRALS',0x00000002)
    win_const_mgr.add_const('MDITILE_ZORDER',0x00000004)
    win_const_mgr.add_const('NTDSCONN_KCC_NO_REASON',0x00000000)
    win_const_mgr.add_const('DBPROPVAL_SQ_QUANTIFIED',0x00000010)
    win_const_mgr.add_const('LCSEX_ANSICREATED',0x00000001)
    win_const_mgr.add_const('CMSG_KEY_AGREE_STATIC_KEY_CHOICE',0x00000002)
    win_const_mgr.add_const('PAN_CONTRAST_MEDIUM_LOW',0x00000005)
    win_const_mgr.add_const('SAFER_LEVELID_NORMALUSER',0x00020000)
    win_const_mgr.add_const('ACMFORMATCHOOSE_STYLEF_INITTOWFXSTRUCT',0x00000040)
    win_const_mgr.add_const('FE_FONTSMOOTHINGORIENTATIONRGB',0x00000001)
    win_const_mgr.add_const('WINWATCHNOTIFY_START',0x00000000)
    win_const_mgr.add_const('KERB_LOGON_FLAG_ALLOW_EXPIRED_TICKET',0x00000001)
    win_const_mgr.add_const('STREAM_FLAGS_DISALLOW_ABSOLUTE_PATH',0x00000002)
    win_const_mgr.add_const('SQL_OSC_MINIMUM',0x00000000)
    win_const_mgr.add_const('MCI_DGV_PUT_CLIENT',0x00400000)
    win_const_mgr.add_const('FACILITY_ACPI_ERROR_CODE',0x00000014)
    win_const_mgr.add_const('ACMFORMATTAGDETAILS_FORMATTAG_CHARS',0x00000030)
    win_const_mgr.add_const('SQL_STRING_FUNCTIONS',0x00000032)
    win_const_mgr.add_const('CERT_STORE_SAVE_TO_FILENAME_W',0x00000004)
    win_const_mgr.add_const('MAX_ADAPTER_NAME',0x00000080)
    win_const_mgr.add_const('URLACTION_ACTIVEX_MIN',0x00001200)
    win_const_mgr.add_const('DEBUG_DATA_SPACE_CONTROL',0x00000002)
    win_const_mgr.add_const('CAUSE_PU_PROVIDER',0x00000000)
    win_const_mgr.add_const('I24_CLASS',0x00000080)
    win_const_mgr.add_const('META_POLYGON',0x00000324)
    win_const_mgr.add_const('DNS_ERROR_DS_ZONE_ALREADY_EXISTS',0x000025F6)
    win_const_mgr.add_const('WMDM_DEVICECAP_CANPLAY',0x00000001)
    win_const_mgr.add_const('ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS',0x0000212D)
    win_const_mgr.add_const('SO_CONFIRM_NAME',0x0000A003)
    win_const_mgr.add_const('TRUST_TYPE_DCE',0x00000004)
    win_const_mgr.add_const('CF_BITMAP',0x00000002)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_INCOMING_FOREST_TRUST_BUILDERS',0x0000022D)
    win_const_mgr.add_const('WMDM_STORAGECAP_FOLDERLIMITEXISTS',0x00000010)
    win_const_mgr.add_const('NDIS_OFFLOAD_PARAMETERS_TX_ENABLED_RX_DISABLED',0x00000002)
    win_const_mgr.add_const('REG_SECURE_CONNECTION',0x00000001)
    win_const_mgr.add_const('MC_CAPS_RESTORE_FACTORY_DEFAULTS',0x00000400)
    win_const_mgr.add_const('KAGPROP_MAXCOLUMNSININDEX',0x0000000D)
    win_const_mgr.add_const('CHANGER_STATUS_NON_VOLATILE',0x00000010)
    win_const_mgr.add_const('ERROR_NET_OPEN_FAILED',0x0000023A)
    win_const_mgr.add_const('INTERNET_RFC1123_FORMAT',0x00000000)
    win_const_mgr.add_const('CACHE_NOTIFY_URL_SET_STICKY',0x00000010)
    win_const_mgr.add_const('CRED_FLAGS_PASSWORD_FOR_CERT',0x00000001)
    win_const_mgr.add_const('DEBUG_TBINFO_START_OFFSET',0x00000010)
    win_const_mgr.add_const('LDAP_OPT_RETURN_REFS',0x00000004)
    win_const_mgr.add_const('CRYPT_RC2_128BIT_VERSION',0x0000003A)
    win_const_mgr.add_const('SKF_AVAILABLE',0x00000002)
    win_const_mgr.add_const('DEBUG_SYMENT_IS_PARAMETER',0x00000004)
    win_const_mgr.add_const('TMTVS_RESERVEDLOW',0x000186A0)
    win_const_mgr.add_const('ERROR_DS_ALIASED_OBJ_MISSING',0x0000208E)
    win_const_mgr.add_const('C3_FULLWIDTH',0x00000080)
    win_const_mgr.add_const('CERT_SHA1_HASH_PROP_ID',0x00000003)
    win_const_mgr.add_const('ERROR_UNKNOWN_PRODUCT',0x00000645)
    win_const_mgr.add_const('ERROR_EVT_FILTER_ALREADYSCOPED',0x00003AA6)
    win_const_mgr.add_const('CLFS_FLAG_IGNORE_SHARE_ACCESS',0x00000040)
    win_const_mgr.add_const('IDM_FOLLOWLINKN',0x00000859)
    win_const_mgr.add_const('SYNC_HANDLERTYPE_DEVICES',0x00000002)
    win_const_mgr.add_const('ERROR_HIBERNATED',0x000002D6)
    win_const_mgr.add_const('CFE_LINK',0x00000020)
    win_const_mgr.add_const('ERROR_FCB_UNAVAILABLE',0x00000023)
    win_const_mgr.add_const('MD_LOG_TYPE_DISABLED',0x00000000)
    win_const_mgr.add_const('ERROR_NO_MORE_MATCHES',0x00000272)
    win_const_mgr.add_const('GPO_OPEN_READ_ONLY',0x00000002)
    win_const_mgr.add_const('MCI_ANIM_PLAY_SLOW',0x00080000)
    win_const_mgr.add_const('PROCESS_TRACE_MODE_REAL_TIME',0x00000100)
    win_const_mgr.add_const('MAXINCOMINGALLOCSIZEDEFAULT',0x00000040)
    win_const_mgr.add_const('SQL_SNVF_OCTET_LENGTH',0x00000010)
    win_const_mgr.add_const('AVIF_TRUSTCKTYPE',0x00000800)
    win_const_mgr.add_const('DFM_GETDEFSTATICID',0x0000000E)
    win_const_mgr.add_const('D3DTSS_TCI_CAMERASPACENORMAL',0x00010000)
    win_const_mgr.add_const('OFFLOAD_MAX_SAS',0x00000003)
    win_const_mgr.add_const('D3DUSAGE_NPATCHES',0x00000100)
    win_const_mgr.add_const('MD_EXTLOG_HTTP_STATUS',0x00000400)
    win_const_mgr.add_const('FS_LATIN2',0x00000002)
    win_const_mgr.add_const('FS_LATIN1',0x00000001)
    win_const_mgr.add_const('MSG_WAITALL',0x00000008)
    win_const_mgr.add_const('CTRY_NORWAY',0x0000002F)
    win_const_mgr.add_const('DDSCL_FPUPRESERVE',0x00001000)
    win_const_mgr.add_const('SMINIT_DEFAULT',0x00000000)
    win_const_mgr.add_const('INTERNET_OPTION_AUTH_FLAGS',0x00000055)
    win_const_mgr.add_const('LINECALLTREATMENT_RINGBACK',0x00000002)
    win_const_mgr.add_const('CACHE_HEADER_DATA_CACHE_RESERVED_19',0x00000013)
    win_const_mgr.add_const('FILE_COMPRESSION_WINLZA',0x00000001)
    win_const_mgr.add_const('VIDEO_CONFIGURE_QUERYSIZE',0x00000001)
    win_const_mgr.add_const('WINHTTP_AUTH_SCHEME_NEGOTIATE',0x00000010)
    win_const_mgr.add_const('IDM_MOVE',0x00000058)
    win_const_mgr.add_const('CACHE_HEADER_DATA_CACHE_RESERVED_16',0x00000010)
    win_const_mgr.add_const('CACHE_HEADER_DATA_CACHE_RESERVED_17',0x00000011)
    win_const_mgr.add_const('CACHE_HEADER_DATA_CACHE_RESERVED_10',0x0000000A)
    win_const_mgr.add_const('CACHE_HEADER_DATA_CACHE_RESERVED_11',0x0000000B)
    win_const_mgr.add_const('CACHE_HEADER_DATA_CACHE_RESERVED_12',0x0000000C)
    win_const_mgr.add_const('METHOD_BGP4_AS_PATH',0x00000001)
    win_const_mgr.add_const('SC_SCREENSAVE',0x0000F140)
    win_const_mgr.add_const('MFASYNC_CALLBACK_QUEUE_TIMER',0x00000004)
    win_const_mgr.add_const('CF_CONVERTONLY',0x00000100)
    win_const_mgr.add_const('PID_COMMENTS',0x00000006)
    win_const_mgr.add_const('CF_NOVERTFONTS',0x01000000)
    win_const_mgr.add_const('IME_THOTKEY_IME_NONIME_TOGGLE',0x00000070)
    win_const_mgr.add_const('LANG_CZECH',0x00000005)
    win_const_mgr.add_const('SERVICE_STOP_REASON_FLAG_PLANNED',0x40000000)
    win_const_mgr.add_const('DNS_TYPE_AAAA',0x00000001)
    win_const_mgr.add_const('TF_SENTENCEMODE_CONVERSATION',0x00000010)
    win_const_mgr.add_const('IPPORT_TFTP',0x00000045)
    win_const_mgr.add_const('CR_NO_SUCH_DEVNODE',0x0000000D)
    win_const_mgr.add_const('AVISTREAMINFO_DISABLED',0x00000001)
    win_const_mgr.add_const('LINEADDRFEATURE_PICKUPHELD',0x00000100)
    win_const_mgr.add_const('LANG_CATALAN',0x00000003)
    win_const_mgr.add_const('SERVICE_NOTIFY_STOP_PENDING',0x00000004)
    win_const_mgr.add_const('PORT_LPD',0x00000203)
    win_const_mgr.add_const('PSINJECT_BOUNDINGBOX',0x00000009)
    win_const_mgr.add_const('PP_CRYPT_COUNT_KEY_USE',0x00000029)
    win_const_mgr.add_const('DLLVER_BUILD_MASK',0xFFFF0000)
    win_const_mgr.add_const('LINEADDRESSTYPE_SDP',0x00000002)
    win_const_mgr.add_const('ERROR_TOO_MANY_MUXWAITERS',0x00000098)
    win_const_mgr.add_const('GET_FEATURE_FROM_THREAD_INTERNET',0x00000040)
    win_const_mgr.add_const('ETO_PDY',0x00002000)
    win_const_mgr.add_const('JOHAB_CHARSET',0x00000082)
    win_const_mgr.add_const('OFN_NONETWORKBUTTON',0x00020000)
    win_const_mgr.add_const('EVENT_SYSTEM_SWITCHEND',0x00000015)
    win_const_mgr.add_const('DBPROPVAL_BD_INTRANSACTION',0x00000001)
    win_const_mgr.add_const('CSIDL_FLAG_MASK',0x0000FF00)
    win_const_mgr.add_const('ODS_GRAYED',0x00000002)
    win_const_mgr.add_const('PPCF_FORCEQUALIFY',0x00000040)
    win_const_mgr.add_const('SAFER_SCOPEID_USER',0x00000002)
    win_const_mgr.add_const('ELF_SHOWHELP',0x00000001)
    win_const_mgr.add_const('PE_TYPE_APPID',0x00000003)
    win_const_mgr.add_const('CP_SYMBOL',0x0000002A)
    win_const_mgr.add_const('LVS_EX_INFOTIP',0x00000400)
    win_const_mgr.add_const('EVCF_SETTINGSMODE',0x00000020)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_CONNECT',0x0000000C)
    win_const_mgr.add_const('PS_ALTERNATE',0x00000008)
    win_const_mgr.add_const('CSURL_ADDTOFRESHESTCRL',0x00000004)
    win_const_mgr.add_const('META_ANIMATEPALETTE',0x00000436)
    win_const_mgr.add_const('GESTURE_EXCLAMATION',0x00000000)
    win_const_mgr.add_const('STATE_SYSTEM_HOTTRACKED',0x00000080)
    win_const_mgr.add_const('SCRIPTPROP_DEBUGGER',0x00001100)
    win_const_mgr.add_const('ERROR_DS_CANT_REPLACE_HIDDEN_REC',0x000020E8)
    win_const_mgr.add_const('LINESPECIALINFO_UNAVAIL',0x00000010)
    win_const_mgr.add_const('TAPE_DRIVE_FIXED',0x00000001)
    win_const_mgr.add_const('ERROR_SXS_PROCESS_TERMINATION_REQUESTED',0x00003707)
    win_const_mgr.add_const('SM_RESERVED4',0x0000001B)
    win_const_mgr.add_const('SECBUFFER_KERNEL_MAP',0x20000000)
    win_const_mgr.add_const('THREAD_SUSPEND_RESUME',0x00000002)
    win_const_mgr.add_const('CFE_ITALIC',0x00000002)
    win_const_mgr.add_const('SM_RESERVED3',0x0000001A)
    win_const_mgr.add_const('IMAGE_REL_SH3_SECREL',0x0000000F)
    win_const_mgr.add_const('BG_E_VOLUME_CHANGED',0x8020000E)
    win_const_mgr.add_const('IPPORT_EPMAP',0x00000087)
    win_const_mgr.add_const('SQL_BP_DROP',0x00000004)
    win_const_mgr.add_const('REPL_EXTENT_FILE',0x00000001)
    win_const_mgr.add_const('DN_ROOT_ENUMERATED',0x00000001)
    win_const_mgr.add_const('MD_CERT_NO_USAGE_CHECK',0x00010000)
    win_const_mgr.add_const('ERROR_DS_NTDSCRIPT_SYNTAX_ERROR',0x0000218F)
    win_const_mgr.add_const('BSIS_PRESERVEORDERDURINGLAYOUT',0x00000200)
    win_const_mgr.add_const('IRLMP_SHARP_MODE',0x00000020)
    win_const_mgr.add_const('SQL_SP_ISNOTNULL',0x00000002)
    win_const_mgr.add_const('LINEANSWERMODE_HOLD',0x00000004)
    win_const_mgr.add_const('CONTROLCALLBACK_PREROLL',0x00000001)
    win_const_mgr.add_const('SSTF_NONE',0x00000000)
    win_const_mgr.add_const('SO_KEEPALIVE',0x00000008)
    win_const_mgr.add_const('INTERNET_ERROR_BASE',0x00002EE0)
    win_const_mgr.add_const('SHCNE_UPDATEDIR',0x00001000)
    win_const_mgr.add_const('LVNI_DROPHILITED',0x00000008)
    win_const_mgr.add_const('CBA_SYMBOLS_UNLOADED',0x00000004)
    win_const_mgr.add_const('PGF_SCROLLRIGHT',0x00000008)
    win_const_mgr.add_const('MCI_WAVE_STATUS_SAMPLESPERSEC',0x00004003)
    win_const_mgr.add_const('USN_REASON_NAMED_DATA_OVERWRITE',0x00000010)
    win_const_mgr.add_const('IDC_IO_DISPLAYASICON',0x00000838)
    win_const_mgr.add_const('INTERNET_OPTION_DISABLE_PASSPORT_AUTH',0x00000057)
    win_const_mgr.add_const('D3DDEVCAPS_QUINTICRTPATCHES',0x00200000)
    win_const_mgr.add_const('SUBLANG_ORIYA_INDIA',0x00000001)
    win_const_mgr.add_const('GL_LEVEL_FATAL',0x00000001)
    win_const_mgr.add_const('CPF_COMPLETE',0x00000004)
    win_const_mgr.add_const('IFF_LOOPBACK',0x00000004)
    win_const_mgr.add_const('IDM_SCROLL_TOP',0x0000094D)
    win_const_mgr.add_const('BIF_DONTGOBELOWDOMAIN',0x00000002)
    win_const_mgr.add_const('HDS_FILTERBAR',0x00000100)
    win_const_mgr.add_const('ERROR_CTX_CLIENT_LICENSE_NOT_SET',0x00001B8D)
    win_const_mgr.add_const('WMDM_FILE_ATTR_CANREAD',0x00040000)
    win_const_mgr.add_const('GESTURE_ARROW_LEFT',0x00000000)
    win_const_mgr.add_const('SRCINFO_FLAGS',0x00000004)
    win_const_mgr.add_const('IF_TYPE_MSDSL',0x0000008F)
    win_const_mgr.add_const('LVGMF_BORDERCOLOR',0x00000002)
    win_const_mgr.add_const('NDW_INSTALLFLAG_SKIPCLASSLIST',0x00004000)
    win_const_mgr.add_const('MMIO_FINDCHUNK',0x00000010)
    win_const_mgr.add_const('D3DSP_DCL_USAGEINDEX_MASK',0x00000000)
    win_const_mgr.add_const('DFCS_BUTTON3STATE',0x00000008)
    win_const_mgr.add_const('SRRF_RM_SAFE',0x00020000)
    win_const_mgr.add_const('PFD_DRAW_TO_WINDOW',0x00000004)
    win_const_mgr.add_const('ERROR_CTX_SHADOW_DISABLED',0x00001B8B)
    win_const_mgr.add_const('CERT_ARCHIVED_KEY_HASH_PROP_ID',0x00000041)
    win_const_mgr.add_const('INTERNET_OPTION_CODEPAGE_PATH',0x00000064)
    win_const_mgr.add_const('LANG_BELARUSIAN',0x00000023)
    win_const_mgr.add_const('LINEAGENTSTATEEX_BUSYINCOMING',0x00000008)
    win_const_mgr.add_const('MAPI_PW_ADD_SERVICE_ONLY',0x00000004)
    win_const_mgr.add_const('NDIS_OFFLOAD_SUPPORTED',0x00000001)
    win_const_mgr.add_const('RECOCONF_MEDIUMCONFIDENCE',0x00000000)
    win_const_mgr.add_const('RP_DELIVERED',0x00000110)
    win_const_mgr.add_const('DIRID_PROGRAM_FILES',0x00004026)
    win_const_mgr.add_const('ST_DEFAULT',0x00000000)
    win_const_mgr.add_const('LDAP_OPT_REF_DEREF_CONN_PER_MSG',0x00000094)
    win_const_mgr.add_const('FCT_MERGE',0x00000001)
    win_const_mgr.add_const('LINEDEVSTATE_ROAMMODE',0x00004000)
    win_const_mgr.add_const('SSA_GCP',0x00000200)
    win_const_mgr.add_const('CLUSAPI_NO_ACCESS',0x00000004)
    win_const_mgr.add_const('SCRIPTTEXT_DELAYEXECUTION',0x00000001)
    win_const_mgr.add_const('PRINTER_NOTIFY_FIELD_TOTAL_BYTES',0x00000018)
    win_const_mgr.add_const('SQL_ROLLBACK',0x00000001)
    win_const_mgr.add_const('CF_TEXT',0x00000001)
    win_const_mgr.add_const('MDMSPKRFLAG_ON',0x00000004)
    win_const_mgr.add_const('SNMP_BERAPI_INVALID_LENGTH',0x0000000A)
    win_const_mgr.add_const('ILMCM_CHECKLAYOUTANDTIPENABLED',0x00000001)
    win_const_mgr.add_const('PSH_USECALLBACK',0x00000100)
    win_const_mgr.add_const('BTH_ERROR_UNSUPPORTED_FEATURE_OR_PARAMETER',0x00000011)
    win_const_mgr.add_const('LINEDIALTONEMODE_UNAVAIL',0x00000020)
    win_const_mgr.add_const('CB_SETTOPINDEX',0x00000015)
    win_const_mgr.add_const('TASK_THURSDAY',0x00000010)
    win_const_mgr.add_const('SERVICETYPE_NETWORK_UNAVAILABLE',0x00000004)
    win_const_mgr.add_const('FILE_ATTRIBUTE_HIDDEN',0x00000002)
    win_const_mgr.add_const('SQL_ISV_COLLATIONS',0x00000008)
    win_const_mgr.add_const('WS_EX_RIGHTSCROLLBAR',0x00000000)
    win_const_mgr.add_const('SQL_DDL_INDEX',0x000000AA)
    win_const_mgr.add_const('ERROR_DS_NO_CHAINED_EVAL',0x00002088)
    win_const_mgr.add_const('OI_DEFAULT',0x00000000)
    win_const_mgr.add_const('PSINJECT_DOCSUPPLIEDRES',0x00000006)
    win_const_mgr.add_const('WM_DWMCOLORIZATIONCOLORCHANGED',0x00000320)
    win_const_mgr.add_const('ERROR_UNWIND_CONSOLIDATE',0x000002AC)
    win_const_mgr.add_const('OID_FDDI_IF_IN_UCAST_PKTS',0x03030282)
    win_const_mgr.add_const('INET6_ADDRSTRLEN',0x00000041)
    win_const_mgr.add_const('_SETUPAPI_VER',0x00000410)
    win_const_mgr.add_const('DICS_START',0x00000004)
    win_const_mgr.add_const('DNS_RTYPE_ANY',0x00000000)
    win_const_mgr.add_const('DS_DIRECTORY_SERVICE_6_REQUIRED',0x00080000)
    win_const_mgr.add_const('MDM_X75_DATA_64K',0x00000001)
    win_const_mgr.add_const('LANG_BOSNIAN',0x00000001)
    win_const_mgr.add_const('D3DCAPS2_FULLSCREENGAMMA',0x00020000)
    win_const_mgr.add_const('EVENT_SRCSPEW_END',0x000000C7)
    win_const_mgr.add_const('LVIS_SELECTED',0x00000002)
    win_const_mgr.add_const('SQL_FD_FETCH_FIRST',0x00000002)
    win_const_mgr.add_const('SCS_CAP_SETRECONVERTSTRING',0x00000004)
    win_const_mgr.add_const('CERT_TRUST_PUB_ALLOW_ENTERPRISE_ADMIN_TRUST',0x00000002)
    win_const_mgr.add_const('CSCONTROL_SHUTDOWN',0x00000001)
    win_const_mgr.add_const('ERROR_INSTALL_SOURCE_ABSENT',0x0000064C)
    win_const_mgr.add_const('NTMS_MAXATTR_NAMELEN',0x00000020)
    win_const_mgr.add_const('OBM_BTNCORNERS',0x00007FF6)
    win_const_mgr.add_const('HHT_ONDROPDOWN',0x00002000)
    win_const_mgr.add_const('SECPKG_STATE_DOMAIN_CONTROLLER',0x00000004)
    win_const_mgr.add_const('BEGIN_NESTED_SYSTEM_CHANGE_NORP',0x00000068)
    win_const_mgr.add_const('BUTTON_IMAGELIST_ALIGN_CENTER',0x00000004)
    win_const_mgr.add_const('MCI_FORMAT_HMS',0x00000001)
    win_const_mgr.add_const('LOAD_IGNORE_CODE_AUTHZ_LEVEL',0x00000010)
    win_const_mgr.add_const('EMR_MOVETOEX',0x0000001B)
    win_const_mgr.add_const('PCS_REMOVEDCHAR',0x00000002)
    win_const_mgr.add_const('FWPM_ACTRL_SUBSCRIBE',0x00000200)
    win_const_mgr.add_const('MCI_ESCAPE',0x00000805)
    win_const_mgr.add_const('IDM_PRINTPREVIEW',0x000007D3)
    win_const_mgr.add_const('DEBUG_OUTPUT_SYMBOLS_NO_NAMES',0x00000001)
    win_const_mgr.add_const('KRAF_SAVEBADREQUESTKEY',0x00000002)
    win_const_mgr.add_const('OID_FDDI_MAC_T_PRI2',0x03030236)
    win_const_mgr.add_const('OID_FDDI_MAC_T_PRI3',0x03030237)
    win_const_mgr.add_const('OID_FDDI_MAC_T_PRI0',0x03030234)
    win_const_mgr.add_const('OID_FDDI_MAC_T_PRI1',0x03030235)
    win_const_mgr.add_const('OID_FDDI_MAC_T_PRI6',0x0303023A)
    win_const_mgr.add_const('OID_FDDI_MAC_T_PRI4',0x03030238)
    win_const_mgr.add_const('OID_FDDI_MAC_T_PRI5',0x03030239)
    win_const_mgr.add_const('NTMS_OMIDLABELID_LENGTH',0x000000FF)
    win_const_mgr.add_const('HTTB_RESIZINGBORDER_BOTTOM',0x00000080)
    win_const_mgr.add_const('CBR_2400',0x00000960)
    win_const_mgr.add_const('CRSWPP_INVALID_POSTINFO_FILE',0xC0042201)
    win_const_mgr.add_const('WKSTA_OTH_DOMAINS_PARMNUM',0x00000065)
    win_const_mgr.add_const('MFE_NO_ERROR',0x00000000)
    win_const_mgr.add_const('ULW_OPAQUE',0x00000004)
    win_const_mgr.add_const('MIIM_SUBMENU',0x00000004)
    win_const_mgr.add_const('PIDMSI_PRODUCTION',0x0000000A)
    win_const_mgr.add_const('MD_USER_ISOLATION_BASIC',0x00000001)
    win_const_mgr.add_const('SECBUFFER_ATTRMASK',0xF0000000)
    win_const_mgr.add_const('WKSTA_ERRLOGSZ_PARMNUM',0x0000001B)
    win_const_mgr.add_const('CC_PREVENTFULLOPEN',0x00000004)
    win_const_mgr.add_const('MCI_ANIM_STATUS_FORWARD',0x00004002)
    win_const_mgr.add_const('SO_ACCEPTCONN',0x00000002)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_MOVEBY',0x00000007)
    win_const_mgr.add_const('PHOTO_CONTRAST_NORMAL',0x00000000)
    win_const_mgr.add_const('RIS_INTERFACE_MEDIA_ABSENT',0x00000004)
    win_const_mgr.add_const('CFE_SUPERSCRIPT',0x00020000)
    win_const_mgr.add_const('REG_PROCESS_APPKEY',0x00000001)
    win_const_mgr.add_const('CRYPT_STRING_NOCRLF',0x40000000)
    win_const_mgr.add_const('LMEM_DISCARDABLE',0x00000F00)
    win_const_mgr.add_const('ERROR_SERVER_HAS_OPEN_HANDLES',0x00000713)
    win_const_mgr.add_const('SE_DACL_PRESENT',0x00000004)
    win_const_mgr.add_const('MCI_DGV_GETDEVCAPS_CAN_TEST',0x00004009)
    win_const_mgr.add_const('ESB_DISABLE_RIGHT',0x00000002)
    win_const_mgr.add_const('PHONEERR_NODEVICE',0x90000018)
    win_const_mgr.add_const('CTFMODEBIAS_NAME',0x00000002)
    win_const_mgr.add_const('OLEUI_ERR_HRESOURCEINVALID',0x0000006D)
    win_const_mgr.add_const('MC_SUPPORTED_COLOR_TEMPERATURE_10000K',0x00000040)
    win_const_mgr.add_const('WINEVENT_KEYWORD_RESERVED_57',0x200000000000000)
    win_const_mgr.add_const('ERROR_WRONG_PASSWORD',0x0000052B)
    win_const_mgr.add_const('CAUSE_USER_BUSY',0x00000011)
    win_const_mgr.add_const('CHANNEL_EVENT_TERMINATED',0x00000004)
    win_const_mgr.add_const('IGP_SETCOMPSTR',0x00000014)
    win_const_mgr.add_const('ERROR_FAIL_REBOOT_REQUIRED',0x00000BC9)
    win_const_mgr.add_const('PHOTO_LIGHTSOURCE_DAYLIGHT',0x00000001)
    win_const_mgr.add_const('FMFOCUS_TREE',0x00000002)
    win_const_mgr.add_const('INTERNET_OPTION_DISCONNECTED_TIMEOUT',0x00000031)
    win_const_mgr.add_const('IMAGE_REL_MIPS_SECTION',0x0000000A)
    win_const_mgr.add_const('DSDSOF_HASUSERANDSERVERINFO',0x00000001)
    win_const_mgr.add_const('TCS_EX_FLATSEPARATORS',0x00000001)
    win_const_mgr.add_const('CRYPT_DEFAULT_CONTEXT_AUTO_RELEASE_FLAG',0x00000001)
    win_const_mgr.add_const('GL_STOP_LISTENING',0x00000002)
    win_const_mgr.add_const('WINEVENT_KEYWORD_RESERVED_56',0x100000000000000)
    win_const_mgr.add_const('OID_GEN_RCV_OK',0x00020102)
    win_const_mgr.add_const('ASPECTY',0x0000002A)
    win_const_mgr.add_const('ASPECTX',0x00000028)
    win_const_mgr.add_const('ICQUALITY_HIGH',0x00002710)
    win_const_mgr.add_const('THREAD_MODE_BACKGROUND_BEGIN',0x00010000)
    win_const_mgr.add_const('SQL_NC_HIGH',0x00000000)
    win_const_mgr.add_const('CBA_DEFERRED_SYMBOL_LOAD_COMPLETE',0x00000002)
    win_const_mgr.add_const('DBIM_MODEFLAGS',0x00000020)
    win_const_mgr.add_const('ERROR_PATCH_PACKAGE_OPEN_FAILED',0x00000663)
    win_const_mgr.add_const('CRYPT_VERIFY_CERT_SIGN_ISSUER_PUBKEY',0x00000001)
    win_const_mgr.add_const('ERROR_HOOK_NOT_INSTALLED',0x00000597)
    win_const_mgr.add_const('PSD_ENABLEPAGESETUPTEMPLATEHANDLE',0x00020000)
    win_const_mgr.add_const('IDM_EMPTYGLYPHTABLE',0x00000920)
    win_const_mgr.add_const('ERROR_INCORRECT_SIZE',0x000005B6)
    win_const_mgr.add_const('PRINTER_NOTIFY_FIELD_START_TIME',0x00000010)
    win_const_mgr.add_const('IME_CMODE_FULLSHAPE',0x00000008)
    win_const_mgr.add_const('TAPE_DRIVE_TAPE_REMAINING',0x00000200)
    win_const_mgr.add_const('SQL_DIAG_CREATE_DOMAIN',0x00000017)
    win_const_mgr.add_const('STATE_SYSTEM_READONLY',0x00000040)
    win_const_mgr.add_const('IMAGE_SEPARATE_DEBUG_SIGNATURE',0x00004449)
    win_const_mgr.add_const('FACILITY_NAP',0x00000027)
    win_const_mgr.add_const('SP_PARITY',0x00000001)
    win_const_mgr.add_const('IDC_CV_CHANGEICON',0x00000099)
    win_const_mgr.add_const('IMAGE_SUBSYSTEM_WINDOWS_BOOT_APPLICATION',0x00000010)
    win_const_mgr.add_const('LINECALLFEATURE_SECURECALL',0x00080000)
    win_const_mgr.add_const('SQL_FN_TD_QUARTER',0x00000040)
    win_const_mgr.add_const('ERROR_DEBUG_ATTACH_FAILED',0x0000024E)
    win_const_mgr.add_const('KSMEDIUM_TYPE_ANYINSTANCE',0x00000000)
    win_const_mgr.add_const('PS_64M',0x00000001)
    win_const_mgr.add_const('IDM_TABLEINSERT',0x00000898)
    win_const_mgr.add_const('ICMODE_INTERNALF_FUNCTION32',0x00008000)
    win_const_mgr.add_const('IMAGE_SCN_MEM_16BIT',0x00020000)
    win_const_mgr.add_const('CRYPT_RC2_40BIT_VERSION',0x000000A0)
    win_const_mgr.add_const('PTE_CACHE_SHIFT',0x00000002)
    win_const_mgr.add_const('VER_EQUAL',0x00000001)
    win_const_mgr.add_const('ISOPROTO_CLTP',0x0000001E)
    win_const_mgr.add_const('CHANNEL_RC_BAD_CHANNEL',0x00000006)
    win_const_mgr.add_const('JOB_NOTIFY_FIELD_SECURITY_DESCRIPTOR',0x0000000C)
    win_const_mgr.add_const('CRYPT_IMPORT_KEY',0x00000080)
    win_const_mgr.add_const('POLICY_ERRV_SUBNET_GRP_FLOW_RATE',0x00000016)
    win_const_mgr.add_const('WAVE_FORMAT_4S08',0x00000200)
    win_const_mgr.add_const('DNS_RTYPE_IXFR',0x00000000)
    win_const_mgr.add_const('STRM_PAUSED',0x00000008)
    win_const_mgr.add_const('TMT_FRAMESPERSECOND',0x0000097A)
    win_const_mgr.add_const('DC_ICON',0x00000004)
    win_const_mgr.add_const('RESOURCEUSAGE_NOLOCALDEVICE',0x00000004)
    win_const_mgr.add_const('SUBLANG_SANSKRIT_INDIA',0x00000001)
    win_const_mgr.add_const('SCE_LOG_LEVEL_ALWAYS',0x00000000)
    win_const_mgr.add_const('PROCESSOR_PPC_601',0x00000259)
    win_const_mgr.add_const('VIF_CANNOTRENAME',0x00002000)
    win_const_mgr.add_const('CACHE_CONFIG_SYNC_MODE_FC',0x00000080)
    win_const_mgr.add_const('MCI_DGV_FF_AVI',0x00004001)
    win_const_mgr.add_const('CTRY_TATARSTAN',0x00000007)
    win_const_mgr.add_const('ERROR_PROCESS_IN_JOB',0x000002F8)
    win_const_mgr.add_const('SERVICE_REDIR_PRINT_PAUSED',0x00000200)
    win_const_mgr.add_const('MEM_ROTATE',0x00800000)
    win_const_mgr.add_const('ERROR_FILE_CHECKED_OUT',0x000000DC)
    win_const_mgr.add_const('USN_REASON_OBJECT_ID_CHANGE',0x00080000)
    win_const_mgr.add_const('SQL_CODE_HOUR_TO_MINUTE',0x0000000B)
    win_const_mgr.add_const('LINK_STORE_TO_ENGINE_INSTANCE',0x00000001)
    win_const_mgr.add_const('ERROR_DEVICE_IN_USE',0x00000964)
    win_const_mgr.add_const('LVHT_ONITEMSTATEICON',0x00000008)
    win_const_mgr.add_const('PERF_DETAIL_COSTLY',0x00010000)
    win_const_mgr.add_const('LDAP_RES_EXTENDED',0x00000078)
    win_const_mgr.add_const('LCMAP_LINGUISTIC_CASING',0x01000000)
    win_const_mgr.add_const('INTERNET_ERROR_MASK_INSERT_CDROM',0x00000001)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_PORT_CHARACTERISTICS',0x0000009C)
    win_const_mgr.add_const('WAVE_FORMAT_1M08',0x00000001)
    win_const_mgr.add_const('LDAP_INVALID_CMD',0x00000000)
    win_const_mgr.add_const('MCI_WAVE_STATUS_BITSPERSAMPLE',0x00004006)
    win_const_mgr.add_const('SQL_ASYNC_ENABLE',0x00000004)
    win_const_mgr.add_const('SMTO_NOTIMEOUTIFNOTHUNG',0x00000008)
    win_const_mgr.add_const('CERT_CHAIN_POLICY_IGNORE_END_REV_UNKNOWN_FLAG',0x00000100)
    win_const_mgr.add_const('DBSESSIONCOUNTDEFAULT',0x00000014)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_MM_TF',0x0000000A)
    win_const_mgr.add_const('MB_MISCMASK',0x0000C000)
    win_const_mgr.add_const('DDSD_DEPTH',0x00800000)
    win_const_mgr.add_const('ASC_REQ_FRAGMENT_SUPPLIED',0x00002000)
    win_const_mgr.add_const('IF_TYPE_G703_2MB',0x00000043)
    win_const_mgr.add_const('PP_CHANGE_PASSWORD',0x00000007)
    win_const_mgr.add_const('WT_EXECUTEINPERSISTENTTHREAD',0x00000080)
    win_const_mgr.add_const('CERT_ALT_NAME_RFC822_NAME',0x00000002)
    win_const_mgr.add_const('SUBLANG_FRENCH',0x00000001)
    win_const_mgr.add_const('PAN_PROP_EVEN_WIDTH',0x00000004)
    win_const_mgr.add_const('PIPE_TYPE_MESSAGE',0x00000004)
    win_const_mgr.add_const('GL_ID_PRIVATE_FIRST',0x00008000)
    win_const_mgr.add_const('PPP_CCP_ENCRYPTION40BIT',0x00000020)
    win_const_mgr.add_const('PXE_BA_IGNORE',0x00000003)
    win_const_mgr.add_const('HTTP_STATUS_CONTINUE',0x00000064)
    win_const_mgr.add_const('ERROR_BAD_PROVIDER',0x000004B4)
    win_const_mgr.add_const('VP_FLAGS_BRIGHTNESS',0x00000040)
    win_const_mgr.add_const('OID_WAN_PERMANENT_ADDRESS',0x04010101)
    win_const_mgr.add_const('DNS_ERROR_RCODE_BADKEY',0x00002339)
    win_const_mgr.add_const('RPC_S_NOT_ALL_OBJS_EXPORTED',0x00000783)
    win_const_mgr.add_const('CDN_LAST',0x00000000)
    win_const_mgr.add_const('PD_RETURNDC',0x00000100)
    win_const_mgr.add_const('LINEPROXYREQUEST_CREATEAGENT',0x00000009)
    win_const_mgr.add_const('ISC_RET_CONNECTION',0x00000800)
    win_const_mgr.add_const('HDF_CHECKBOX',0x00000040)
    win_const_mgr.add_const('IF_TYPE_PPP',0x00000017)
    win_const_mgr.add_const('TCP_NOSYNRETRIES',0x00000009)
    win_const_mgr.add_const('TH32CS_SNAPTHREAD',0x00000004)
    win_const_mgr.add_const('UCSCHAR_INVALID_CHARACTER',0x00000000)
    win_const_mgr.add_const('FOF_NORECURSION',0x00001000)
    win_const_mgr.add_const('ERROR_INVALID_KEYBOARD_HANDLE',0x000005B1)
    win_const_mgr.add_const('INTERNET_OPTION_ACTIVATE_WORKER_THREADS',0x0000005C)
    win_const_mgr.add_const('DXVA_STATUS_REPORTING_FUNCTION',0x00000007)
    win_const_mgr.add_const('BCP_FMT_COLLATION_ID',0x00000007)
    win_const_mgr.add_const('X3_D_WH_SIZE_X',0x00000003)
    win_const_mgr.add_const('PROPTYPE_MASK',0x00000000)
    win_const_mgr.add_const('KSEVENTF_EVENT_OBJECT',0x00000004)
    win_const_mgr.add_const('RECOFLAG_PREFIXOK',0x00000008)
    win_const_mgr.add_const('WPWIZ_ERROR_INIT_FAILED',0xC0042003)
    win_const_mgr.add_const('CSIDL_HISTORY',0x00000022)
    win_const_mgr.add_const('MAPI_NOW',0x00000010)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_TOTALSECTORS',0x00000108)
    win_const_mgr.add_const('MCI_STATUS_CURRENT_TRACK',0x00000008)
    win_const_mgr.add_const('ERROR_SXS_ASSEMBLY_NOT_FOUND',0x000036B3)
    win_const_mgr.add_const('PRIMARY_CRED_INTERACTIVE_SMARTCARD_LOGON',0x00000040)
    win_const_mgr.add_const('JOB_OBJECT_UILIMIT_ALL',0x000000FF)
    win_const_mgr.add_const('SFVS_SELECT_INVERT',0x00000002)
    win_const_mgr.add_const('RBBIM_BACKGROUND',0x00000080)
    win_const_mgr.add_const('ERROR_AUDIT_FAILED',0x0000025E)
    win_const_mgr.add_const('STATUS_SEVERITY_COFAIL',0x00000003)
    win_const_mgr.add_const('SNMPAPI_ENTITY_UNKNOWN',0x00000006)
    win_const_mgr.add_const('NDR_DEFAULT_CORR_CACHE_SIZE',0x00000190)
    win_const_mgr.add_const('WINCODEC_SDK_VERSION',0x00000236)
    win_const_mgr.add_const('FACILITY_MSMQ',0x0000000E)
    win_const_mgr.add_const('FRS_ERR_CHILD_TO_PARENT_COMM',0x00001F4B)
    win_const_mgr.add_const('SF_NOTIFY_URL_MAP',0x00001000)
    win_const_mgr.add_const('DPNHREGISTERPORTS_TCP',0x00000001)
    win_const_mgr.add_const('INTERNET_FLAG_HYPERLINK',0x00000400)
    win_const_mgr.add_const('COMP_TYPE_MAX',0x00000004)
    win_const_mgr.add_const('FLG_PROFITEM_CURRENTUSER',0x00000001)
    win_const_mgr.add_const('TAPE_RETURN_ENV_INFO',0x00000001)
    win_const_mgr.add_const('DI_NODI_DEFAULTACTION',0x00200000)
    win_const_mgr.add_const('MSIM_DISPID_ON_NM_INVITERECEIVED',0x00000E13)
    win_const_mgr.add_const('DBC_HIDE',0x00000000)
    win_const_mgr.add_const('SUBLANG_UIGHUR_PRC',0x00000001)
    win_const_mgr.add_const('SBM_GETRANGE',0x000000E3)
    win_const_mgr.add_const('CM_INSTALL_STATE_FAILED_INSTALL',0x00000002)
    win_const_mgr.add_const('CERT_REGISTRY_STORE_ROAMING_FLAG',0x00040000)
    win_const_mgr.add_const('ERROR_INVALID_SEGMENT_NUMBER',0x000000B4)
    win_const_mgr.add_const('SV_AUTOSHAREWKS_PARMNUM',0x0000024F)
    win_const_mgr.add_const('SPMODE_FLUSH',0x00000010)
    win_const_mgr.add_const('ICMF_CHOOSE_PREVIEW',0x00000004)
    win_const_mgr.add_const('URLACTION_INFODELIVERY_NO_ADDING_CHANNELS',0x00001D00)
    win_const_mgr.add_const('PERF_DETAIL_ADVANCED',0x000000C8)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2RAWCD_CURRENTMEDIATYPE',0x00000105)
    win_const_mgr.add_const('CERT_TRUST_PUB_ALLOW_MACHINE_ADMIN_TRUST',0x00000001)
    win_const_mgr.add_const('MK_CONTROL',0x00000008)
    win_const_mgr.add_const('D3DPBLENDCAPS_BOTHINVSRCALPHA',0x00001000)
    win_const_mgr.add_const('USN_PAGE_SIZE',0x00001000)
    win_const_mgr.add_const('NET_DFS_SETDC_FLAGS',0x00000000)
    win_const_mgr.add_const('WINHTTP_FLAG_SECURE',0x00800000)
    win_const_mgr.add_const('WHDR_DONE',0x00000001)
    win_const_mgr.add_const('DBPROPVAL_MR_SUPPORTED',0x00000001)
    win_const_mgr.add_const('MAPIFORM_OS_WINNT_40',0x00000005)
    win_const_mgr.add_const('SP_BACKUP_SPECIAL',0x00000004)
    win_const_mgr.add_const('IF_TYPE_CES',0x00000085)
    win_const_mgr.add_const('OID_TCP_TASK_IPSEC_DELETE_SA',0xFC010203)
    win_const_mgr.add_const('MF_MEDIATYPE_EQUAL_FORMAT_TYPES',0x00000002)
    win_const_mgr.add_const('NOM_BT3',0x00000400)
    win_const_mgr.add_const('NOM_BT0',0x00000040)
    win_const_mgr.add_const('NOM_BT1',0x00000100)
    win_const_mgr.add_const('NOM_BT6',0x00002000)
    win_const_mgr.add_const('NOM_BT7',0x00004000)
    win_const_mgr.add_const('NOM_BT4',0x00000800)
    win_const_mgr.add_const('NOM_BT5',0x00001000)
    win_const_mgr.add_const('MOUSEEVENTF_LEFTUP',0x00000004)
    win_const_mgr.add_const('SAFER_POLICY_UIFLAGS_HIDDEN',0x00000004)
    win_const_mgr.add_const('WIA_DPS_SCAN_AHEAD_PAGES',0x00000C16)
    win_const_mgr.add_const('SECBUFFER_TARGET',0x0000000D)
    win_const_mgr.add_const('TCP_PROTOCOL_UUID16',0x00000004)
    win_const_mgr.add_const('WIA_INTENT_BEST_PREVIEW',0x00040000)
    win_const_mgr.add_const('PSWIZB_DISABLEDFINISH',0x00000008)
    win_const_mgr.add_const('PIDSI_AUTHOR',0x00000004)
    win_const_mgr.add_const('EC_OPEN_ALWAYS',0x00000000)
    win_const_mgr.add_const('WAVE_FORMAT_DRM',0x00000009)
    win_const_mgr.add_const('POWER_LEVEL_USER_NOTIFY_TEXT',0x00000001)
    win_const_mgr.add_const('CERT_VALIDITY_MASK_TRUST',0x00000000)
    win_const_mgr.add_const('TRUST_ATTRIBUTE_TREE_PARENT',0x00400000)
    win_const_mgr.add_const('NUMPENS',0x00000012)
    win_const_mgr.add_const('MAX_INF_SECTION_NAME_LENGTH',0x000000FF)
    win_const_mgr.add_const('IMGANIM_MASK',0x10000000)
    win_const_mgr.add_const('ABS_ALWAYSONTOP',0x00000002)
    win_const_mgr.add_const('MD_APP_POOL_RECYCLE_MEMORY',0x00000008)
    win_const_mgr.add_const('ICM_UNREGISTERICMATCHER',0x00000006)
    win_const_mgr.add_const('NFS_BUTTON',0x00000008)
    win_const_mgr.add_const('SECPKG_ATTR_PASSWORD_EXPIRY',0x00000008)
    win_const_mgr.add_const('HHWIN_BUTTON_TOC_PREV',0x00000001)
    win_const_mgr.add_const('AGP_FLAG_SPECIAL_TARGET',0x000FFFFF)
    win_const_mgr.add_const('CFM_LCID',0x02000000)
    win_const_mgr.add_const('SNMP_ERROR_GENERR',0x00000005)
    win_const_mgr.add_const('IDTB_OPTIONS',0x000000D0)
    win_const_mgr.add_const('LBS_USETABSTOPS',0x00000080)
    win_const_mgr.add_const('AUXCAPS_LRVOLUME',0x00000002)
    win_const_mgr.add_const('SYSTEM_CACHE_ALIGNMENT_SIZE',0x00000080)
    win_const_mgr.add_const('OPTION_OK_TO_OVERLAY',0x00000034)
    win_const_mgr.add_const('CERT_TRUST_CTL_IS_NOT_TIME_VALID',0x00020000)
    win_const_mgr.add_const('D3DCAPS2_CANAUTOGENMIPMAP',0x40000000)
    win_const_mgr.add_const('EXTENSION_ORIGIN_ADMIN',0x00030000)
    win_const_mgr.add_const('EMARCH_ENC_I17_IC_VAL_POS_X',0x00000015)
    win_const_mgr.add_const('D3DPMISCCAPS_FOGVERTEXCLAMPED',0x00100000)
    win_const_mgr.add_const('IPX_GETNETINFO_NORIP',0x00004009)
    win_const_mgr.add_const('WMDM_STORAGE_IS_DEFAULT',0x08000000)
    win_const_mgr.add_const('PROCESS_HEAP_ENTRY_BUSY',0x00000004)
    win_const_mgr.add_const('DFM_INVOKECOMMANDEX',0x0000000C)
    win_const_mgr.add_const('DM_PANNINGHEIGHT',0x10000000)
    win_const_mgr.add_const('MQ_ACTION_PEEK_CURRENT',0x80000000)
    win_const_mgr.add_const('PROCESS_SET_SESSIONID',0x00000004)
    win_const_mgr.add_const('LINECALLREASON_REDIRECT',0x00000040)
    win_const_mgr.add_const('QUERY_DEEP',0x00000001)
    win_const_mgr.add_const('F_NOFILE',0x00000001)
    win_const_mgr.add_const('OLEVERB_PRIMARY',0x00000000)
    win_const_mgr.add_const('ERROR_ACCESS_DENIED',0x00000005)
    win_const_mgr.add_const('SQL_FETCH_RESUME',0x00000007)
    win_const_mgr.add_const('CMC_OTHER_INFO_PEND_CHOICE',0x00000002)
    win_const_mgr.add_const('PRIMARY_CRED_CACHED_LOGON',0x00000008)
    win_const_mgr.add_const('META_PIE',0x0000081A)
    win_const_mgr.add_const('BCPODBC',0x00000007)
    win_const_mgr.add_const('SUBLANG_SPANISH_NICARAGUA',0x00000013)
    win_const_mgr.add_const('FILTER_NORMAL_ACCOUNT',0x00000002)
    win_const_mgr.add_const('D3DSTENCILCAPS_REPLACE',0x00000004)
    win_const_mgr.add_const('WS_EX_COMPOSITED',0x02000000)
    win_const_mgr.add_const('IMPORTANCE_LOW_SET',0x00000001)
    win_const_mgr.add_const('MUI_COMPLEX_SCRIPT_FILTER',0x00000200)
    win_const_mgr.add_const('MIM_APPLYTOSUBMENUS',0x80000000)
    win_const_mgr.add_const('QS_RAWINPUT',0x00000400)
    win_const_mgr.add_const('SPCRP_DEVTYPE',0x00000019)
    win_const_mgr.add_const('SYNCHRONIZE',0x00100000)
    win_const_mgr.add_const('RDW_ALLCHILDREN',0x00000080)
    win_const_mgr.add_const('AF_CLUSTER',0x00000018)
    win_const_mgr.add_const('DCBA_FACEUPCENTER',0x00000001)
    win_const_mgr.add_const('SQL_FN_TD_MONTH',0x00000020)
    win_const_mgr.add_const('FILE_SHARE_DELETE',0x00000004)
    win_const_mgr.add_const('MQSEC_WRITE_MESSAGE',0x00000004)
    win_const_mgr.add_const('PT_ROAMING',0x00000002)
    win_const_mgr.add_const('RPC_CONTEXT_HANDLE_SERIALIZE',0x10000000)
    win_const_mgr.add_const('TVHT_ONITEMSTATEICON',0x00000040)
    win_const_mgr.add_const('CAL_SSHORTDATE',0x00000005)
    win_const_mgr.add_const('ICDRAW_PREROLL',0x20000000)
    win_const_mgr.add_const('CFM_STRIKEOUT',0x00000008)
    win_const_mgr.add_const('TOKEN_ADJUST_DEFAULT',0x00000080)
    win_const_mgr.add_const('SQL_SVE_COALESCE',0x00000004)
    win_const_mgr.add_const('MCI_DGV_PLAY_REPEAT',0x00010000)
    win_const_mgr.add_const('FILESYSTEM_STATISTICS_TYPE_NTFS',0x00000001)
    win_const_mgr.add_const('IMAGE_SYM_CLASS_STATIC',0x00000003)
    win_const_mgr.add_const('TTI_INFO',0x00000001)
    win_const_mgr.add_const('SECBUFFER_READONLY_WITH_CHECKSUM',0x10000000)
    win_const_mgr.add_const('KS_VIDEOSTREAM_NABTS',0x00000020)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_SEND',0x0000002F)
    win_const_mgr.add_const('SCRIPTPROP_JITDEBUG',0x00001101)
    win_const_mgr.add_const('INTERNET_COOKIE_IS_SESSION',0x00000002)
    win_const_mgr.add_const('ERROR_MALFORMED_SUBSTITUTION_STRING',0x0000370E)
    win_const_mgr.add_const('MM_PC_JOYSTICK',0x0000000C)
    win_const_mgr.add_const('DISPID_EXECCOMMAND',0x00000002)
    win_const_mgr.add_const('PERF_INVERSE_COUNTER',0x01000000)
    win_const_mgr.add_const('SQL_API_SQLGETDIAGFIELD',0x000003F2)
    win_const_mgr.add_const('HTTP_MAJOR_VERSION',0x00000001)
    win_const_mgr.add_const('ERROR_NO_TRUST_LSA_SECRET',0x000006FA)
    win_const_mgr.add_const('PRINTER_ENUM_LOCAL',0x00000002)
    win_const_mgr.add_const('EMR_CREATECOLORSPACEW',0x0000007A)
    win_const_mgr.add_const('CLUSAPI_VERSION',0x00000600)
    win_const_mgr.add_const('PAN_PROP_MONOSPACED',0x00000009)
    win_const_mgr.add_const('MAXSTRETCHBLTMODE',0x00000004)
    win_const_mgr.add_const('D3DPBLENDCAPS_BOTHSRCALPHA',0x00000800)
    win_const_mgr.add_const('AE_NETLOGON',0x0000000E)
    win_const_mgr.add_const('EXCEPTION_NONCONTINUABLE',0x00000001)
    win_const_mgr.add_const('SHGFI_DISPLAYNAME',0x00000200)
    win_const_mgr.add_const('ISO_FORCE_DISCONNECTED',0x00000001)
    win_const_mgr.add_const('GL_ID_INPUTRADICAL',0x00000025)
    win_const_mgr.add_const('DDSCAPS2_HINTANTIALIASING',0x00000100)
    win_const_mgr.add_const('LB_INITSTORAGE',0x000001A8)
    win_const_mgr.add_const('FRS_ERR_PARENT_TO_CHILD_COMM',0x00001F4C)
    win_const_mgr.add_const('RESTORE_TYPE_ONLINE',0x00000002)
    win_const_mgr.add_const('PID_TEMPLATE',0x00000007)
    win_const_mgr.add_const('WINHTTP_QUERY_PROXY_AUTHENTICATE',0x00000029)
    win_const_mgr.add_const('FPS_UNAVAILABLE',0x20000020)
    win_const_mgr.add_const('OBM_RESTORE',0x00007FEB)
    win_const_mgr.add_const('INTERNET_COOKIE_IS_LEGACY',0x00000800)
    win_const_mgr.add_const('DM_ICMINTENT',0x01000000)
    win_const_mgr.add_const('GPT_BASIC_DATA_ATTRIBUTE_SHADOW_COPY',0x2000000000000000)
    win_const_mgr.add_const('KERB_ETYPE_RSA_MD5_CMS',0x0000000A)
    win_const_mgr.add_const('LM20_SNLEN',0x0000000F)
    win_const_mgr.add_const('EXCHIVERB_REPLYTOFOLDER',0x0000006C)
    win_const_mgr.add_const('TIMEMEDIAPLAYER_OFFSET',0x00000800)
    win_const_mgr.add_const('X3_OPCODE_INST_WORD_POS_X',0x0000001C)
    win_const_mgr.add_const('ERROR_NO_SUCH_USER',0x00000525)
    win_const_mgr.add_const('MD_ERROR_SUB401_URLAUTH_POLICY',0x00000007)
    win_const_mgr.add_const('ERROR_CHILD_WINDOW_MENU',0x0000059C)
    win_const_mgr.add_const('MCI_SEQ_OFFSET',0x000004C0)
    win_const_mgr.add_const('IDM_PEERHITTESTSAMEINEDIT',0x00000977)
    win_const_mgr.add_const('DTT_BORDERSIZE',0x00000001)
    win_const_mgr.add_const('MD_DIMTYPE_OTHER',0x00000003)
    win_const_mgr.add_const('SQL_ISV_TABLES',0x00020000)
    win_const_mgr.add_const('IMAGE_BITMAP',0x00000000)
    win_const_mgr.add_const('FR_ENABLETEMPLATEHANDLE',0x00002000)
    win_const_mgr.add_const('AVIF_ISINTERLEAVED',0x00000100)
    win_const_mgr.add_const('DIGCDP_FLAG_REMOTE_ADVANCED',0x00000004)
    win_const_mgr.add_const('LVGS_FOCUSED',0x00000010)
    win_const_mgr.add_const('JOB_OBJECT_UILIMIT_NONE',0x00000000)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_DCOM_USERS',0x00000232)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_MM_EXPIRED',0x0000363D)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_ENVIRONMENT',0x00000000)
    win_const_mgr.add_const('SHTDN_REASON_MAJOR_LEGACY_API',0x00070000)
    win_const_mgr.add_const('DDFXCAPS_OVERLAYARITHSTRETCHYN',0x00000008)
    win_const_mgr.add_const('PDERR_NODEFAULTPRN',0x00001008)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_DC_DEMOTION',0x00000022)
    win_const_mgr.add_const('PDH_LOGSVC_NOT_OPENED',0xC0000BD9)
    win_const_mgr.add_const('HHWIN_BUTTON_NOTES',0x00000001)
    win_const_mgr.add_const('MAPI_E_INVALID_SESSION',0x00000013)
    win_const_mgr.add_const('DMPAPER_P32K',0x0000005E)
    win_const_mgr.add_const('DBPARAMTYPE_RETURNVALUE',0x00000004)
    win_const_mgr.add_const('RPC_S_NO_MORE_BINDINGS',0x0000070E)
    win_const_mgr.add_const('CR_PROP_TEMPLATES',0x0000001D)
    win_const_mgr.add_const('DS_REPSYNC_NO_DISCARD',0x00000080)
    win_const_mgr.add_const('FACILITY_NS',0x0000000D)
    win_const_mgr.add_const('OS_WIN2000ORGREATER',0x00000007)
    win_const_mgr.add_const('SSRVOPT_GETPATH',0x00000040)
    win_const_mgr.add_const('DNS_RCLASS_ANY',0x00000000)
    win_const_mgr.add_const('OID_IRDA_EXTRA_RCV_BOFS',0x0A010200)
    win_const_mgr.add_const('WM_TABLET_MAXOFFSET',0x00000020)
    win_const_mgr.add_const('CERT_SUBJECT_INFO_ACCESS_PROP_ID',0x00000050)
    win_const_mgr.add_const('LINEADDRCAPFLAGS_NOEXTERNALCALLS',0x10000000)
    win_const_mgr.add_const('BTH_MFG_ROHDE_SCHWARZ',0x00000019)
    win_const_mgr.add_const('MD_GLOBAL_BINSCHEMATIMESTAMP',0x00002707)
    win_const_mgr.add_const('SCH_CRED_MAX_STORE_NAME_SIZE',0x00000080)
    win_const_mgr.add_const('ERROR_BAD_PATHNAME',0x000000A1)
    win_const_mgr.add_const('SOCKET_INFO_CONNECTION_ENCRYPTED',0x00000002)
    win_const_mgr.add_const('TBS_NOTICKS',0x00000010)
    win_const_mgr.add_const('DNS_ERROR_INVALID_TYPE',0x0000254F)
    win_const_mgr.add_const('PORT_ENTOMB',0x00000307)
    win_const_mgr.add_const('LOCALE_SENGCURRNAME',0x00001007)
    win_const_mgr.add_const('AUDIT_QUERY_MISC_POLICY',0x00000040)
    win_const_mgr.add_const('CRED_TI_USERNAME_TARGET',0x00000008)
    win_const_mgr.add_const('DPNHADDRESSTYPE_LOCALFIREWALL',0x00000008)
    win_const_mgr.add_const('DMPAPER_DBL_JAPANESE_POSTCARD_ROTATED',0x00000052)
    win_const_mgr.add_const('ERROR_CANT_RESOLVE_FILENAME',0x00000781)
    win_const_mgr.add_const('IIS_MD_UT_END_RESERVED',0x000007D0)
    win_const_mgr.add_const('WKSTA_CHARTIME_PARMNUM',0x0000000B)
    win_const_mgr.add_const('CRLF_IGNORE_INVALID_POLICIES',0x00000010)
    win_const_mgr.add_const('LINEAGENTFEATURE_GETAGENTGROUP',0x00000020)
    win_const_mgr.add_const('DDLOCK_HASVOLUMETEXTUREBOXRECT',0x00008000)
    win_const_mgr.add_const('TLS1_ALERT_BAD_RECORD_MAC',0x00000014)
    win_const_mgr.add_const('ERROR_CTX_SHADOW_INVALID',0x00001B8A)
    win_const_mgr.add_const('INTERNET_STATUS_INTERMEDIATE_RESPONSE',0x00000078)
    win_const_mgr.add_const('DT_NOPREFIX',0x00000800)
    win_const_mgr.add_const('PRF_CHILDREN',0x00000010)
    win_const_mgr.add_const('DBPROP_CI_CATALOG_NAME',0x00000002)
    win_const_mgr.add_const('DISPLAYDIB_MODE',0x0000000F)
    win_const_mgr.add_const('TIME_NOMINUTESORSECONDS',0x00000001)
    win_const_mgr.add_const('MAX_GOPHER_SELECTOR_TEXT',0x00000100)
    win_const_mgr.add_const('SPQ_FLAG_VALID',0x0000000F)
    win_const_mgr.add_const('IMAGE_REL_I386_REL32',0x00000014)
    win_const_mgr.add_const('ANY_DEST_ADDR',0xFFFFFFFF)
    win_const_mgr.add_const('PORT_PRTSERVER',0x00000023)
    win_const_mgr.add_const('FILE_DEVICE_FILE_SYSTEM',0x00000009)
    win_const_mgr.add_const('CLFS_SCAN_BUFFERED',0x00000020)
    win_const_mgr.add_const('PHONEFEATURE_SETDISPLAY',0x00010000)
    win_const_mgr.add_const('HHWIN_PROP_NOTB_TEXT',0x00000001)
    win_const_mgr.add_const('ERROR_INVALID_QUOTA_LOWER',0x00000223)
    win_const_mgr.add_const('SERIAL_IOC_FCR_RCVR_RESET',0x00000002)
    win_const_mgr.add_const('ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND',0x00003A9B)
    win_const_mgr.add_const('MD_AUTH_CHANGE_DISABLE',0x00000002)
    win_const_mgr.add_const('JOB_STATUS_PRINTED',0x00000080)
    win_const_mgr.add_const('VER_SERVER_NT',0x80000000)
    win_const_mgr.add_const('JOB_OBJECT_QUERY',0x00000004)
    win_const_mgr.add_const('PSR_DD',0x00000027)
    win_const_mgr.add_const('SE_ERR_DDEFAIL',0x0000001D)
    win_const_mgr.add_const('BDIF_PERSONAL',0x00000010)
    win_const_mgr.add_const('MAXINCOMINGMESSAGESIZEDEFAULT',0x00000040)
    win_const_mgr.add_const('IDM_NEW_TOPLEVELWINDOW',0x00001B8A)
    win_const_mgr.add_const('KSPIN_FLAG_DO_NOT_INITIATE_PROCESSING',0x00000010)
    win_const_mgr.add_const('MKF_RIGHTBUTTONDOWN',0x02000000)
    win_const_mgr.add_const('PIDISM_WATCH',0x00000001)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_SERVICEPACK',0x00000000)
    win_const_mgr.add_const('ERROR_DS_CANT_DELETE_DSA_OBJ',0x00002094)
    win_const_mgr.add_const('SND_SYNC',0x00000000)
    win_const_mgr.add_const('DNS_ERROR_TRY_AGAIN_LATER',0x00002552)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_WMI',0x00000012)
    win_const_mgr.add_const('WIA_PROPPAGE_DEVICE_GENERAL',0x00000004)
    win_const_mgr.add_const('PDH_INVALID_SQL_LOG_FORMAT',0xC0000BF5)
    win_const_mgr.add_const('PSINJECT_BEGINSTREAM',0x00000001)
    win_const_mgr.add_const('IFS_IFM',0x00000000)
    win_const_mgr.add_const('MCI_SEQ_STATUS_TEMPO',0x00004002)
    win_const_mgr.add_const('CF_ACCEPT',0x00000000)
    win_const_mgr.add_const('SQL_API_SQLSTATISTICS',0x00000035)
    win_const_mgr.add_const('MD_CPU_ENABLE_TERMINATED_PROCS',0x00000080)
    win_const_mgr.add_const('SMC_SHCHANGENOTIFY',0x0000002E)
    win_const_mgr.add_const('MFOUTPUTATTRIBUTE_BUS',0x00000020)
    win_const_mgr.add_const('DS_REPSYNCALL_DO_NOT_SYNC',0x00000008)
    win_const_mgr.add_const('MCI_SEQ_SET_PORT',0x00020000)
    win_const_mgr.add_const('FEI_ROUTING',0x00000010)
    win_const_mgr.add_const('CB_GETDROPPEDCONTROLRECT',0x00000152)
    win_const_mgr.add_const('OID_GEN_PORT_STATE',0x0001020E)
    win_const_mgr.add_const('DBPARAMTYPE_OUTPUT',0x00000003)
    win_const_mgr.add_const('ERROR_INVALID_PASSWORD',0x00000056)
    win_const_mgr.add_const('DEVICE_STATEMASK_ALL',0x00000000)
    win_const_mgr.add_const('CRYPT_VERIFY_CERT_SIGN_ISSUER_CHAIN',0x00000003)
    win_const_mgr.add_const('DI_SHOWCLASS',0x00000004)
    win_const_mgr.add_const('REG_HIVE_SINGLE_LOG',0x00000200)
    win_const_mgr.add_const('WMS_CONTAINER_LAST_ENTRY_IN_PLAYLIST',0x00000800)
    win_const_mgr.add_const('UDS_ARROWKEYS',0x00000020)
    win_const_mgr.add_const('LINE_REMOVE',0x00000019)
    win_const_mgr.add_const('D3DPTEXTURECAPS_ALPHAPALETTE',0x00000080)
    win_const_mgr.add_const('ERROR_INVALID_ACCEL_HANDLE',0x0000057B)
    win_const_mgr.add_const('LUP_RETURN_NAME',0x00000010)
    win_const_mgr.add_const('NUM_CUSTOM_COLORS',0x00000010)
    win_const_mgr.add_const('MDAXIS_PAGES',0x00000002)
    win_const_mgr.add_const('BG_E_HTTP_ERROR_205',0x801900CD)
    win_const_mgr.add_const('SECPKG_FLAG_DELEGATION',0x00020000)
    win_const_mgr.add_const('LANG_LATVIAN',0x00000026)
    win_const_mgr.add_const('GM_LAST',0x00000002)
    win_const_mgr.add_const('TVHT_BELOW',0x00000200)
    win_const_mgr.add_const('SCARD_E_NO_KEY_CONTAINER',0x80100030)
    win_const_mgr.add_const('IDD_LINKPROPS',0x0000044E)
    win_const_mgr.add_const('PID_FIRST_USABLE',0x00000002)
    win_const_mgr.add_const('WNODE_FLAG_EVENT_ITEM',0x00000008)
    win_const_mgr.add_const('FILEOP_ABORT',0x00000000)
    win_const_mgr.add_const('ASC_RET_CALL_LEVEL',0x00002000)
    win_const_mgr.add_const('ISCSI_SECURITY_FLAG_TRANSPORT_MODE_PREFERRED',0x00000020)
    win_const_mgr.add_const('ISCSI_LOGIN_OPTIONS_HEADER_DIGEST',0x00000001)
    win_const_mgr.add_const('WINHTTP_ENABLE_PASSPORT_KEYRING',0x40000000)
    win_const_mgr.add_const('BG_E_HTTP_ERROR_200',0x801900C8)
    win_const_mgr.add_const('TF_IPP_CAPS_COMLESSSUPPORT',0x00000008)
    win_const_mgr.add_const('DLCTL_SILENT',0x40000000)
    win_const_mgr.add_const('MCI_SYSINFO',0x00000810)
    win_const_mgr.add_const('PST_PC_MULTIPLE_REPOSITORIES',0x00000010)
    win_const_mgr.add_const('DTR_IO_PORT_INDEX',0x00000005)
    win_const_mgr.add_const('SKF_AUDIBLEFEEDBACK',0x00000040)
    win_const_mgr.add_const('MSV1_0_ALLOW_SERVER_TRUST_ACCOUNT',0x00000020)
    win_const_mgr.add_const('MEM_16K',0x00004000)
    win_const_mgr.add_const('ACL_REVISION3',0x00000003)
    win_const_mgr.add_const('OWNER_SECURITY_INFORMATION',0x00000001)
    win_const_mgr.add_const('MDPROPVAL_FS_GENERATED_COLUMN',0x00000002)
    win_const_mgr.add_const('OID_GEN_PHYSICAL_MEDIUM',0x00010202)
    win_const_mgr.add_const('MEM_16M',0x01000000)
    win_const_mgr.add_const('D3DCREATE_MIXED_VERTEXPROCESSING',0x00000080)
    win_const_mgr.add_const('ERROR_INVALID_PRINTER_COMMAND',0x0000070B)
    win_const_mgr.add_const('WMS_STREAM_SHARING_BANDWIDTH',0x0000000A)
    win_const_mgr.add_const('BDR_SUNKENOUTER',0x00000002)
    win_const_mgr.add_const('DISPID_COLLECTION_MAX',0x002DC6BF)
    win_const_mgr.add_const('DISKQUOTA_LOGFLAG_USER_LIMIT',0x00000002)
    win_const_mgr.add_const('FACILITY_COMMONLOG',0x0000001A)
    win_const_mgr.add_const('SVSI_CHECK',0x00000100)
    win_const_mgr.add_const('DDSCAPS2_EXTENDEDFORMATPRIMARY',0x40000000)
    win_const_mgr.add_const('MHDR_PREPARED',0x00000002)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2TAO_CURRENTMEDIATYPE',0x0000010B)
    win_const_mgr.add_const('INTERNET_OPTION_SEND_TIMEOUT',0x00000005)
    win_const_mgr.add_const('D3DFVF_XYZRHW',0x00000004)
    win_const_mgr.add_const('DDFXCAPS_OVERLAYSHRINKX',0x00080000)
    win_const_mgr.add_const('DDFXCAPS_OVERLAYSHRINKY',0x00200000)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_HOLD',0x00000004)
    win_const_mgr.add_const('SPDRP_REMOVAL_POLICY',0x0000001F)
    win_const_mgr.add_const('WIA_IPA_UPLOAD_ITEM_SIZE',0x0000101E)
    win_const_mgr.add_const('ERROR_CLUSTER_INVALID_STRING_TERMINATION',0x0000171C)
    win_const_mgr.add_const('LINEDIALTONEMODE_INTERNAL',0x00000004)
    win_const_mgr.add_const('ERROR_SPECIAL_USER',0x0000055D)
    win_const_mgr.add_const('CRYPT_STRING_BASE64X509CRLHEADER',0x00000009)
    win_const_mgr.add_const('ERROR_DS_DRA_REPL_PENDING',0x0000211D)
    win_const_mgr.add_const('ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN',0x0000219B)
    win_const_mgr.add_const('DISPID_DDISCMASTER2EVENTS_DEVICEREMOVED',0x00000101)
    win_const_mgr.add_const('SCARD_STATE_UNAWARE',0x00000000)
    win_const_mgr.add_const('ERROR_WMI_TRY_AGAIN',0x0000106B)
    win_const_mgr.add_const('CAL_IYEAROFFSETRANGE',0x00000003)
    win_const_mgr.add_const('COD_MINOR_MASK',0x000000FC)
    win_const_mgr.add_const('WS_CHILD',0x40000000)
    win_const_mgr.add_const('BYTE_MAX',0x00000000)
    win_const_mgr.add_const('LINECALLFEATURE_SENDUSERUSER',0x00100000)
    win_const_mgr.add_const('D3DPS20CAPS_ARBITRARYSWIZZLE',0x00000001)
    win_const_mgr.add_const('ERROR_BAD_TOKEN_TYPE',0x00000545)
    win_const_mgr.add_const('SQL_FN_TD_CURDATE',0x00000002)
    win_const_mgr.add_const('SEC_LARGE_PAGES',0x80000000)
    win_const_mgr.add_const('VER_PRODUCTVERSION_DW',0x06000000)
    win_const_mgr.add_const('OID_WAN_GET_LINK_INFO',0x04010109)
    win_const_mgr.add_const('IPV6_HDRINCL',0x00000002)
    win_const_mgr.add_const('SQL_INITIALLY_IMMEDIATE',0x00000006)
    win_const_mgr.add_const('GDICOMMENT_MULTIFORMATS',0x40000004)
    win_const_mgr.add_const('BATTERY_LIFE_UNKNOWN',0xFFFFFFFF)
    win_const_mgr.add_const('ACMDRIVERDETAILS_SUPPORTF_CONVERTER',0x00000002)
    win_const_mgr.add_const('DT_RASCAMERA',0x00000003)
    win_const_mgr.add_const('TR_ED',0x00000034)
    win_const_mgr.add_const('OBJECT_PUSH_FORMAT_VCARD_3_0',0x00000002)
    win_const_mgr.add_const('ACTION_REVOCATION_DEFAULT_CACHE',0x00020000)
    win_const_mgr.add_const('RTM_NEXTHOP_STATE_DELETED',0x00000001)
    win_const_mgr.add_const('IPX_TRAFFIC_FILTER_ON_DSTSOCKET',0x00000040)
    win_const_mgr.add_const('CRYPT_NOHASHOID',0x00000001)
    win_const_mgr.add_const('RPC_S_UNSUPPORTED_NAME_SYNTAX',0x000006C9)
    win_const_mgr.add_const('DBPROPVAL_RT_SINGLETHREAD',0x00000004)
    win_const_mgr.add_const('MDPROPVAL_MOQ_MEMBER_MEMBER',0x00000080)
    win_const_mgr.add_const('DSGIF_ISMASK',0x00000000)
    win_const_mgr.add_const('PERF_AGGREGATE_MIN',0x00000003)
    win_const_mgr.add_const('ERROR_NO_TOKEN',0x000003F0)
    win_const_mgr.add_const('SP_COPY_IN_USE_TRY_RENAME',0x04000000)
    win_const_mgr.add_const('DV_DVSD_PAL_FRAMESIZE',0x00023280)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_TRANSITION_SLIDE',0x0000001B)
    win_const_mgr.add_const('CTRY_JAPAN',0x00000051)
    win_const_mgr.add_const('WINHTTP_CONNS_PER_SERVER_UNLIMITED',0xFFFFFFFF)
    win_const_mgr.add_const('KSAUDIO_SPEAKER_DIRECTOUT',0x00000000)
    win_const_mgr.add_const('LINEAGENTSTATE_UNAVAIL',0x00000200)
    win_const_mgr.add_const('MD_CPU_NO_ACTION',0x00000000)
    win_const_mgr.add_const('MM_MSFT_ACM_WMAUDIO2',0x00000065)
    win_const_mgr.add_const('MCI_DGV_DELETE_AT',0x00010000)
    win_const_mgr.add_const('WLAN_MAX_PHY_TYPE_NUMBER',0x00000008)
    win_const_mgr.add_const('DIF_FINISHINSTALL_ACTION',0x0000002A)
    win_const_mgr.add_const('SPDIT_NODRIVER',0x00000000)
    win_const_mgr.add_const('FWPM_FILTER_FLAG_DISABLED',0x00000020)
    win_const_mgr.add_const('WINHTTP_QUERY_SERVER',0x00000025)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MAJOR_OPERATINGSYSTEM',0x00030000)
    win_const_mgr.add_const('POLICY_QOS_ALLOW_LOCAL_ROOT_CERT_STORE',0x00000020)
    win_const_mgr.add_const('CAUSE_VPI_VCI_UNACCEPTABLE',0x0000000A)
    win_const_mgr.add_const('DWM_EC_DISABLECOMPOSITION',0x00000000)
    win_const_mgr.add_const('IP_MULTICAST_IF',0x00000009)
    win_const_mgr.add_const('TRUST_TYPE_UPLEVEL',0x00000002)
    win_const_mgr.add_const('SUBLANG_FRENCH_MONACO',0x00000006)
    win_const_mgr.add_const('WSAENAMETOOLONG',0x0000274F)
    win_const_mgr.add_const('FILE_PERSISTENT_ACLS',0x00000008)
    win_const_mgr.add_const('DISPLAYDIB_DONTLOCKTASK',0x00000200)
    win_const_mgr.add_const('PORT_DAYTIME',0x0000000D)
    win_const_mgr.add_const('WIA_DPC_DIMENSION',0x00000816)
    win_const_mgr.add_const('CMSG_SIGNER_CERT_ID_PARAM',0x00000026)
    win_const_mgr.add_const('DTS_SHORTDATEFORMAT',0x00000000)
    win_const_mgr.add_const('SFGAO_STREAM',0x00400000)
    win_const_mgr.add_const('DFS_VOLUME_STATE_INCONSISTENT',0x00000002)
    win_const_mgr.add_const('OID_802_3_ADD_MULTICAST_ADDRESS',0x01010208)
    win_const_mgr.add_const('DSOP_FILTER_WELL_KNOWN_PRINCIPALS',0x00000008)
    win_const_mgr.add_const('PSBTN_OK',0x00000003)
    win_const_mgr.add_const('SQL_AO_OFF',0x00000000)
    win_const_mgr.add_const('NDIS_PROTOCOL_ID_MAX',0x0000000F)
    win_const_mgr.add_const('RTCEF_SESSION_REFER_STATUS',0x00100000)
    win_const_mgr.add_const('OF_PROMPT',0x00002000)
    win_const_mgr.add_const('WINEVENT_OUTOFCONTEXT',0x00000000)
    win_const_mgr.add_const('SS_GRAYRECT',0x00000005)
    win_const_mgr.add_const('DDSCAPS_MODEX',0x00200000)
    win_const_mgr.add_const('SQL_SDF_CURRENT_TIME',0x00000002)
    win_const_mgr.add_const('SPC_INC_PE_PAGE_HASHES_FLAG',0x00000100)
    win_const_mgr.add_const('HALFTONE',0x00000004)
    win_const_mgr.add_const('LOCALE_NAME_MAX_LENGTH',0x00000055)
    win_const_mgr.add_const('MAPI_FULL_IPM_TREE',0x00000002)
    win_const_mgr.add_const('MODALS_PASSWD_HIST_LEN_PARMNUM',0x00000005)
    win_const_mgr.add_const('SCARD_E_CANT_DISPOSE',0x8010000E)
    win_const_mgr.add_const('KS_AMCONTROL_USED',0x00000001)
    win_const_mgr.add_const('TIMESTATE_OFFSET',0x00001000)
    win_const_mgr.add_const('ICEE_CREATE_FILE_STRIP_RELOCS',0x00000008)
    win_const_mgr.add_const('AF_ATM',0x00000016)
    win_const_mgr.add_const('CRYPTUI_ENABLE_EDITPROPERTIES',0x00000008)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_REGVIRTUALIZE',0x0000001A)
    win_const_mgr.add_const('RPC_TYPE_STRICT_CONTEXT_HANDLE',0x40000000)
    win_const_mgr.add_const('SE_GROUP_RESOURCE',0x20000000)
    win_const_mgr.add_const('TASK_FLAG_DONT_START_IF_ON_BATTERIES',0x00000040)
    win_const_mgr.add_const('WPWIZ_ERROR_FIRST',0x40042000)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_SECURITYFIX',0x00000012)
    win_const_mgr.add_const('WINEVENT_TASK_NONE',0x00000000)
    win_const_mgr.add_const('HTTP_QUERY_AUTHENTICATION_INFO',0x0000004C)
    win_const_mgr.add_const('PIDASI_STREAM_NAME',0x00000009)
    win_const_mgr.add_const('FWPS_METADATA_FIELD_FRAGMENT_DATA',0x00001000)
    win_const_mgr.add_const('KSDSOUND_BUFFER_CTRL_3D',0x00000001)
    win_const_mgr.add_const('PATCH_OPTION_USE_LZX_BEST',0x00000003)
    win_const_mgr.add_const('TVIF_IMAGE',0x00000002)
    win_const_mgr.add_const('INTERNET_REQFLAG_PASSIVE',0x00000010)
    win_const_mgr.add_const('EXIT_PROCESS_DEBUG_EVENT',0x00000005)
    win_const_mgr.add_const('DMPAPER_PENV_10',0x00000069)
    win_const_mgr.add_const('DFCS_SCROLLCOMBOBOX',0x00000005)
    win_const_mgr.add_const('PNRP_MAX_ENDPOINT_ADDRESSES',0x0000000A)
    win_const_mgr.add_const('CF_NOVECTORFONTS',0x00000800)
    win_const_mgr.add_const('SDP_ATTRIB_IMAGING_SUPPORTED_CAPABILITIES',0x00000310)
    win_const_mgr.add_const('EV_RX80FULL',0x00000400)
    win_const_mgr.add_const('D3DDTCAPS_DEC3N',0x00000080)
    win_const_mgr.add_const('IS_TEXT_UNICODE_SIGNATURE',0x00000008)
    win_const_mgr.add_const('IDM_TRIED_NUDGE_ELEMENT',0x00000002)
    win_const_mgr.add_const('ERROR_INSTALL_REMOTE_DISALLOWED',0x00000668)
    win_const_mgr.add_const('DISPID_IFONTNAMES_COUNT',0x00000001)
    win_const_mgr.add_const('CB_RESETCONTENT',0x0000014B)
    win_const_mgr.add_const('IMAGE_DIRECTORY_ENTRY_ARCHITECTURE',0x00000007)
    win_const_mgr.add_const('D3DVTXPCAPS_DIRECTIONALLIGHTS',0x00000008)
    win_const_mgr.add_const('LOCALE_IDEFAULTANSICODEPAGE',0x00001004)
    win_const_mgr.add_const('IDC_PS_PASTELINKLIST',0x000001F8)
    win_const_mgr.add_const('D3D10_FLOAT_TO_SRGB_THRESHOLD',0x00000000)
    win_const_mgr.add_const('ARW_STARTMASK',0x00000003)
    win_const_mgr.add_const('GESTURE_DOWN',0x00000000)
    win_const_mgr.add_const('SHGFI_OVERLAYINDEX',0x00000040)
    win_const_mgr.add_const('MCI_DGV_INFO_ITEM',0x00000000)
    win_const_mgr.add_const('STATURLFLAG_ISCACHED',0x00000001)
    win_const_mgr.add_const('PDH_CSTATUS_NEW_DATA',0x00000001)
    win_const_mgr.add_const('OPATH_TOK_QSTRING',0x00000065)
    win_const_mgr.add_const('MAX_IF_TYPE',0x000000C4)
    win_const_mgr.add_const('DNS_FILTERON',0x00000004)
    win_const_mgr.add_const('OID_TAG',0x0000000A)
    win_const_mgr.add_const('VIF_DIFFCODEPG',0x00000010)
    win_const_mgr.add_const('INFINFO_REVERSE_DEFAULT_SEARCH',0x00000004)
    win_const_mgr.add_const('DEVPROP_MASK_TYPEMOD',0x0000F000)
    win_const_mgr.add_const('HH_DISPLAY_TEXT_POPUP',0x0000000E)
    win_const_mgr.add_const('CACHE_E_FIRST',0x80040170)
    win_const_mgr.add_const('OID_802_11_WEP_STATUS',0x0D01011B)
    win_const_mgr.add_const('LPV_DROP_MSG',0x0000FFFD)
    win_const_mgr.add_const('PFD_DOUBLEBUFFER_DONTCARE',0x40000000)
    win_const_mgr.add_const('DRM_EL_REVOCATIONLIST',0x00000400)
    win_const_mgr.add_const('CACHE_HEADER_DATA_CURRENT_SETTINGS_VERSION',0x00000000)
    win_const_mgr.add_const('SCARD_CLASS_POWER_MGMT',0x00000004)
    win_const_mgr.add_const('CDO_E_SMTP_SEND_FAILED',0x80040211)
    win_const_mgr.add_const('DB_LOCAL_EXCLUSIVE',0x00000003)
    win_const_mgr.add_const('IF_TYPE_CHANNEL',0x00000046)
    win_const_mgr.add_const('SPC_EXC_PE_PAGE_HASHES_FLAG',0x00000010)
    win_const_mgr.add_const('DCICOMMAND',0x00000C03)
    win_const_mgr.add_const('ERROR_DS_CANT_FIND_NC_IN_CACHE',0x000020E5)
    win_const_mgr.add_const('SQL_DL_SQL92_INTERVAL_YEAR_TO_MONTH',0x00000200)
    win_const_mgr.add_const('CERT_NAME_FRIENDLY_DISPLAY_TYPE',0x00000005)
    win_const_mgr.add_const('PER_USER_AUDIT_SUCCESS_EXCLUDE',0x00000002)
    win_const_mgr.add_const('D3DPMISCCAPS_PERSTAGECONSTANT',0x00008000)
    win_const_mgr.add_const('TAPE_FORMAT',0x00000005)
    win_const_mgr.add_const('LOCALE_SNAME',0x00000005)
    win_const_mgr.add_const('X3_IMM39_1_INST_WORD_X',0x00000002)
    win_const_mgr.add_const('CR_PROP_CRLSTATE',0x00000014)
    win_const_mgr.add_const('WIA_DPS_DOCUMENT_HANDLING_SELECT',0x00000C10)
    win_const_mgr.add_const('KSCREATE_ITEM_NOPARAMETERS',0x00000004)
    win_const_mgr.add_const('IMAGE_SCN_ALIGN_32BYTES',0x00600000)
    win_const_mgr.add_const('TXFS_START_RM_FLAG_LOG_GROWTH_INCREMENT_NUM_CONTAINERS',0x00000008)
    win_const_mgr.add_const('STARTF_USEFILLATTRIBUTE',0x00000010)
    win_const_mgr.add_const('KS_CC_SUBSTREAM_SERVICE_T4',0x00000800)
    win_const_mgr.add_const('WMDM_DEVICE_TYPE_FILELISTRESYNC',0x00000200)
    win_const_mgr.add_const('KS_CC_SUBSTREAM_SERVICE_T1',0x00000040)
    win_const_mgr.add_const('BG_E_HTTP_ERROR_101',0x80190065)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_WRITEPROTECTSTATUS',0x00000107)
    win_const_mgr.add_const('KS_CC_SUBSTREAM_SERVICE_T2',0x00000080)
    win_const_mgr.add_const('HTTP_ADDREQ_FLAG_ADD',0x20000000)
    win_const_mgr.add_const('PROTOCOLFLAG_NO_PICS_CHECK',0x00000001)
    win_const_mgr.add_const('GCT_SEPARATOR',0x00000008)
    win_const_mgr.add_const('PF_CHANNELS_ENABLED',0x00000010)
    win_const_mgr.add_const('CM_PROB_REINSTALL',0x00000012)
    win_const_mgr.add_const('S_WHITE512',0x00000004)
    win_const_mgr.add_const('ERROR_RESOURCEMANAGER_READ_ONLY',0x00001A33)
    win_const_mgr.add_const('CB_GETLOCALE',0x0000015A)
    win_const_mgr.add_const('AE_NOACCESSPERM',0x00000003)
    win_const_mgr.add_const('SSPROPVAL_USEPROCFORPREP_OFF',0x00000000)
    win_const_mgr.add_const('MSV1_0_SUBAUTH_ACCOUNT_DISABLED',0x00000001)
    win_const_mgr.add_const('STI_DEVICE_CREATE_DATA',0x00000002)
    win_const_mgr.add_const('ACTCTX_FLAG_SOURCE_IS_ASSEMBLYREF',0x00000040)
    win_const_mgr.add_const('DISPID_SETPERERRSTATE',0x00000016)
    win_const_mgr.add_const('ATMPROTO_AALUSER',0x00000000)
    win_const_mgr.add_const('SQL_SP_QUANTIFIED_COMPARISON',0x00002000)
    win_const_mgr.add_const('CACHE_S_LAST',0x0004017F)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2RAWCD_RECORDER',0x00000100)
    win_const_mgr.add_const('WSAEOPNOTSUPP',0x0000273D)
    win_const_mgr.add_const('TAPIMAXCALLEDPARTYSIZE',0x00000028)
    win_const_mgr.add_const('PRINTER_STATUS_PAPER_OUT',0x00000010)
    win_const_mgr.add_const('D3DCAPS3_COPY_TO_SYSTEMMEM',0x00000200)
    win_const_mgr.add_const('ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE',0x00001702)
    win_const_mgr.add_const('CERT_TRUST_PUB_CHECK_PUBLISHER_REV_FLAG',0x00000100)
    win_const_mgr.add_const('LOCKP_FAIL_WRITES',0x00000000)
    win_const_mgr.add_const('DMO_E_INVALIDSTREAMINDEX',0x80040201)
    win_const_mgr.add_const('TAPE_DRIVE_SELECT',0x00000002)
    win_const_mgr.add_const('SQL_DI_DROP_INDEX',0x00000002)
    win_const_mgr.add_const('TF_COMMANDING_ENABLED',0x00000004)
    win_const_mgr.add_const('FDTF_LONGDATE',0x00000004)
    win_const_mgr.add_const('MCI_SEEK_TO_END',0x00000200)
    win_const_mgr.add_const('DDFXCAPS_OVERLAYMIRRORUPDOWN',0x10000000)
    win_const_mgr.add_const('NTDSSITELINK_OPT_DISABLE_COMPRESSION',0x00000001)
    win_const_mgr.add_const('FLG_INI2REG_64BITKEY',0x00001000)
    win_const_mgr.add_const('DNOBJECT_PHONE',0x0000001D)
    win_const_mgr.add_const('LVGS_NORMAL',0x00000000)
    win_const_mgr.add_const('ENCAPSULATED_POSTSCRIPT',0x00001014)
    win_const_mgr.add_const('OCR_NO',0x00007F88)
    win_const_mgr.add_const('PRINTER_CHANGE_PRINT_PROCESSOR',0x07000000)
    win_const_mgr.add_const('PDH_LOG_OPT_CIRCULAR',0x02000000)
    win_const_mgr.add_const('ERROR_NOT_JOINED',0x00000088)
    win_const_mgr.add_const('EMR_STRETCHBLT',0x0000004D)
    win_const_mgr.add_const('SQL_CATALOG_NAME',0x00002713)
    win_const_mgr.add_const('IMAGE_FILE_MACHINE_R4000',0x00000166)
    win_const_mgr.add_const('FVSIF_NEWFILE',0x80000000)
    win_const_mgr.add_const('OID_FDDI_PORT_CONNECTION_CAPABILITIES',0x03030266)
    win_const_mgr.add_const('VIDEO_CONFIGURE_CURRENT',0x00000010)
    win_const_mgr.add_const('IDM_TRIED_BROWSEMODE',0x0000001D)
    win_const_mgr.add_const('GD_CURSOR',0x0000000C)
    win_const_mgr.add_const('MCI_VCR_SET_PAUSE_TIMEOUT',0x08000000)
    win_const_mgr.add_const('ERROR_HANDLE_DISK_FULL',0x00000027)
    win_const_mgr.add_const('SERVICE_NOTIFY_PAUSE_PENDING',0x00000020)
    win_const_mgr.add_const('CTL_V1',0x00000000)
    win_const_mgr.add_const('SURFACE_LOCK_WAIT',0x00000004)
    win_const_mgr.add_const('SB_LINEDOWN',0x00000001)
    win_const_mgr.add_const('CERT_SECTION_TYPE_ANY',0x000000FF)
    win_const_mgr.add_const('PHONEFEATURE_GETDISPLAY',0x00000004)
    win_const_mgr.add_const('RBS_VERTICALGRIPPER',0x00004000)
    win_const_mgr.add_const('WIA_DPS_VERTICAL_BED_REGISTRATION',0x00000C08)
    win_const_mgr.add_const('PGN_LAST',0x00000000)
    win_const_mgr.add_const('RF_INFORMATION_ONLY',0x02000000)
    win_const_mgr.add_const('FWPS_RIGHT_ACTION_WRITE',0x00000001)
    win_const_mgr.add_const('SBN_LAST',0x00000000)
    win_const_mgr.add_const('DIF_NEWDEVICEWIZARD_PREANALYZE',0x0000001C)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_ROLLBACK_SAVEPOINT',0x00800000)
    win_const_mgr.add_const('MUTANT_QUERY_STATE',0x00000001)
    win_const_mgr.add_const('RP_VOLATILE_FLAGS_MASK',0xF0000000)
    win_const_mgr.add_const('DDBD_24',0x00000000)
    win_const_mgr.add_const('SCHANNEL_SECRET_TYPE_CAPI',0x00000001)
    win_const_mgr.add_const('JOB_OBJECT_LIMIT_JOB_TIME',0x00000004)
    win_const_mgr.add_const('PHONESTATE_MONITORS',0x00000010)
    win_const_mgr.add_const('NOM_BT8',0x00008000)
    win_const_mgr.add_const('CF_HDROP',0x0000000F)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_THREAD',0x00000002)
    win_const_mgr.add_const('MUTZ_NOSAVEDFILECHECK',0x00000001)
    win_const_mgr.add_const('EM_GETRECT',0x000000B2)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_REFQUAD',0x00000002)
    win_const_mgr.add_const('CSIDL_SYSTEMX86',0x00000029)
    win_const_mgr.add_const('WINHTTP_OPTION_RECEIVE_RESPONSE_TIMEOUT',0x00000007)
    win_const_mgr.add_const('SECURITY_CREATOR_OWNER_RID',0x00000000)
    win_const_mgr.add_const('OID_ATM_HW_CURRENT_ADDRESS',0x08010104)
    win_const_mgr.add_const('DEBUG_FILTER_SECOND_CHANCE_BREAK',0x00000001)
    win_const_mgr.add_const('PDH_PLA_ERROR_NAME_TOO_LONG',0xC0000BF4)
    win_const_mgr.add_const('ERROR_NO_SUPPORTING_DRIVES',0x000010F3)
    win_const_mgr.add_const('BEGIN_SYSTEM_CHANGE',0x00000064)
    win_const_mgr.add_const('CRLF_USE_XCHG_CERT_TEMPLATE',0x00004000)
    win_const_mgr.add_const('FWPM_NET_EVENT_FLAG_LOCAL_PORT_SET',0x00000008)
    win_const_mgr.add_const('IDM_TRUSTAPPCACHE',0x00000979)
    win_const_mgr.add_const('MQMSG_SENDERID_TYPE_SID',0x00000001)
    win_const_mgr.add_const('IDD_LINKSOURCEUNAVAILABLE',0x000003FC)
    win_const_mgr.add_const('CBES_EX_NOEDITIMAGEINDENT',0x00000002)
    win_const_mgr.add_const('WPC_WEB',0x00000018)
    win_const_mgr.add_const('OID_FDDI_MAC_FRAME_CT',0x0303023B)
    win_const_mgr.add_const('KS_NABTS_GROUPID_ORIGINAL_CONTENT_BASE',0x00000800)
    win_const_mgr.add_const('PXE_CALLBACK_SERVICE_CONTROL',0x00000002)
    win_const_mgr.add_const('ICC_STANDARD_CLASSES',0x00004000)
    win_const_mgr.add_const('ERROR_PRINTER_DRIVER_DOWNLOAD_NEEDED',0x00000BCB)
    win_const_mgr.add_const('INTERNET_DIAL_SHOW_OFFLINE',0x00004000)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_TRANSITION_DIAMOND',0x0000000F)
    win_const_mgr.add_const('V86FLAGS_RESUME',0x00010000)
    win_const_mgr.add_const('OPATH_TOK_ERROR',0x00000001)
    win_const_mgr.add_const('SV_ENABLEWFW311DIRECTIPX_PARMNUM',0x0000023E)
    win_const_mgr.add_const('MINIDUMP_THREAD_INFO_ERROR_THREAD',0x00000001)
    win_const_mgr.add_const('SQL_QU_DML_STATEMENTS',0x00000001)
    win_const_mgr.add_const('WSANO_DATA',0x00002AFC)
    win_const_mgr.add_const('DISPLAY_DEVICE_DISCONNECT',0x02000000)
    win_const_mgr.add_const('ERROR_DS_INVALID_ROLE_OWNER',0x000020AE)
    win_const_mgr.add_const('URLACTION_DOWNLOAD_SIGNED_ACTIVEX',0x00001001)
    win_const_mgr.add_const('SAFE_PARTIAL',0x00000001)
    win_const_mgr.add_const('MFSESSIONCAP_START',0x00000001)
    win_const_mgr.add_const('SQL_API_SQLSPECIALCOLUMNS',0x00000034)
    win_const_mgr.add_const('SQL_OSCC_NOT_COMPLIANT',0x00000000)
    win_const_mgr.add_const('HTTP_QUERY_FLAG_SYSTEMTIME',0x40000000)
    win_const_mgr.add_const('LINEDISCONNECTMODE_DONOTDISTURB',0x00040000)
    win_const_mgr.add_const('WINHTTP_OPTION_CLIENT_CERT_ISSUER_LIST',0x0000005E)
    win_const_mgr.add_const('ODS_NOACCEL',0x00000100)
    win_const_mgr.add_const('GCP_SYMSWAPOFF',0x00800000)
    win_const_mgr.add_const('TXTLOG_TAB_1',0x00080000)
    win_const_mgr.add_const('SPECIAL_DOBJ_MAX',0x00000000)
    win_const_mgr.add_const('WM_CAPTURECHANGED',0x00000215)
    win_const_mgr.add_const('ERROR_DS_DRA_RPC_CANCELLED',0x00002107)
    win_const_mgr.add_const('SERVICE_NOT_PAUSABLE',0x00000000)
    win_const_mgr.add_const('KSMETHOD_TYPE_SETSUPPORT',0x00000100)
    win_const_mgr.add_const('TTI_ERROR',0x00000003)
    win_const_mgr.add_const('SF_RTFNOOBJS',0x00000003)
    win_const_mgr.add_const('EVENTLOG_WARNING_TYPE',0x00000002)
    win_const_mgr.add_const('EVENT_TRACE_FILE_MODE_PREALLOCATE',0x00000020)
    win_const_mgr.add_const('XP_GUARANTEED_DELIVERY',0x00000002)
    win_const_mgr.add_const('CI_PROVIDER_MSSEARCH',0x00000001)
    win_const_mgr.add_const('WLX_SAS_ACTION_PWD_CHANGED',0x00000006)
    win_const_mgr.add_const('IPX_GLOBAL_INFO_TYPE',0x00000009)
    win_const_mgr.add_const('ERROR_FULL_BACKUP',0x00000FA4)
    win_const_mgr.add_const('WIA_DPC_PAN_POSITION',0x0000080C)
    win_const_mgr.add_const('DO_NOT_VIRTUALIZE_STORAGES_AS_DEVICES',0x00000001)
    win_const_mgr.add_const('SNMP_ERRORSTATUS_NOERROR',0x00000000)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_INVALID_SIG',0x00003633)
    win_const_mgr.add_const('MNGOF_BOTTOMGAP',0x00000002)
    win_const_mgr.add_const('WIA_DIP_DEV_ID',0x00000002)
    win_const_mgr.add_const('NSTYPE_DYNAMIC',0x00000002)
    win_const_mgr.add_const('EN_CORRECTTEXT',0x00000705)
    win_const_mgr.add_const('DIF_SELECTBESTCOMPATDRV',0x00000017)
    win_const_mgr.add_const('USN_REASON_DATA_OVERWRITE',0x00000001)
    win_const_mgr.add_const('WS_MINIMIZEBOX',0x00020000)
    win_const_mgr.add_const('EXTENSION_ORIGIN_REQUEST',0x00010000)
    win_const_mgr.add_const('IDM_CENTERHORIZONTALLY',0x0000000C)
    win_const_mgr.add_const('MC_CAPS_BRIGHTNESS',0x00000002)
    win_const_mgr.add_const('BS_TEXT',0x00000000)
    win_const_mgr.add_const('CAUSE_PU_USER',0x00000008)
    win_const_mgr.add_const('SQL_PT_PROCEDURE',0x00000001)
    win_const_mgr.add_const('INDEX_GUID_TEXTWORD',0x0000000B)
    win_const_mgr.add_const('DMPAPER_PENV_1_ROTATED',0x0000006D)
    win_const_mgr.add_const('SIO_GET_NUMBER_OF_ATM_DEVICES',0x50160001)
    win_const_mgr.add_const('JOY_BUTTON1CHG',0x00000100)
    win_const_mgr.add_const('POLLRDBAND',0x00000200)
    win_const_mgr.add_const('DN_MANUAL',0x00000010)
    win_const_mgr.add_const('CB_DELETESTRING',0x00000144)
    win_const_mgr.add_const('LOCALE_IDIGITS',0x00000011)
    win_const_mgr.add_const('CR_FLG_FORCETELETEX',0x00000001)
    win_const_mgr.add_const('DDCAPS2_TEXMANINNONLOCALVIDMEM',0x01000000)
    win_const_mgr.add_const('DBT_DEVTYP_DEVNODE',0x00000001)
    win_const_mgr.add_const('CERT_RDN_ENABLE_UTF8_UNICODE_FLAG',0x20000000)
    win_const_mgr.add_const('CDO_E_PROP_READONLY',0x80040227)
    win_const_mgr.add_const('OF_SET',0x00000001)
    win_const_mgr.add_const('IMAGE_SCN_LNK_OTHER',0x00000100)
    win_const_mgr.add_const('ATM_NSAP',0x00000002)
    win_const_mgr.add_const('MC_SUPPORTED_COLOR_TEMPERATURE_4000K',0x00000001)
    win_const_mgr.add_const('MCI_VCR_STATUS_INDEX_ON',0x0000400E)
    win_const_mgr.add_const('NRC_BADDR',0x00000007)
    win_const_mgr.add_const('CCHCCDESC',0x00000020)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_SQL_LANGUAGES',0x00000000)
    win_const_mgr.add_const('JOY_POVFORWARD',0x00000000)
    win_const_mgr.add_const('SSRVOPT_CALLBACK',0x00000001)
    win_const_mgr.add_const('WM_MOUSEWHEEL',0x0000020A)
    win_const_mgr.add_const('POLICY_ERRV_SUBNET_GRP_SUM_PEAK_RATE',0x0000002E)
    win_const_mgr.add_const('WNNC_SPEC_VERSION',0x00000001)
    win_const_mgr.add_const('DS_ROLE_INFRASTRUCTURE_OWNER',0x00000004)
    win_const_mgr.add_const('NDIS_RING_SOFT_ERROR',0x00002000)
    win_const_mgr.add_const('ICDECOMPRESS_PREROLL',0x20000000)
    win_const_mgr.add_const('SAMPLE_SEQ_CONTENT_UNKNOWN',0x00000000)
    win_const_mgr.add_const('WMIGUID_NOTIFICATION',0x00000004)
    win_const_mgr.add_const('PDH_SQL_FETCH_FAILED',0xC0000BE3)
    win_const_mgr.add_const('CRED_TYPE_DOMAIN_PASSWORD',0x00000002)
    win_const_mgr.add_const('SNMP_GENERICTRAP_ENTERSPECIFIC',0x00000006)
    win_const_mgr.add_const('LANG_ESTONIAN',0x00000025)
    win_const_mgr.add_const('FOF_NOCONFIRMATION',0x00000010)
    win_const_mgr.add_const('MDPROPVAL_MJC_SINGLECUBE',0x00000001)
    win_const_mgr.add_const('SQL_CONVERT_BINARY',0x00000036)
    win_const_mgr.add_const('KSPIN_FLAG_ENFORCE_FIFO',0x00000080)
    win_const_mgr.add_const('MSIM_DISPID_ONFINDRESULT',0x00000E0A)
    win_const_mgr.add_const('DC_PRINTRATE',0x0000001A)
    win_const_mgr.add_const('SQL_SFKD_SET_DEFAULT',0x00000004)
    win_const_mgr.add_const('IASSEMBLYCACHE_INSTALL_FLAG_REFRESH',0x00000001)
    win_const_mgr.add_const('LINETRANSLATEOPTION_CARDOVERRIDE',0x00000001)
    win_const_mgr.add_const('ENABLE_DISABLE_AUTOSAVE',0x000000D2)
    win_const_mgr.add_const('SV_TYPE_DOMAIN_MEMBER',0x00000100)
    win_const_mgr.add_const('CRYPT_OID_DISABLE_SEARCH_DS_FLAG',0x80000000)
    win_const_mgr.add_const('LINEFORWARDMODE_NOANSWINTERNAL',0x00000200)
    win_const_mgr.add_const('JOY_CAL_READRONLY',0x02000000)
    win_const_mgr.add_const('DDOVERZ_SENDTOFRONT',0x00000000)
    win_const_mgr.add_const('DFCS_CHECKED',0x00000400)
    win_const_mgr.add_const('WKSTA_LANROOT_PARMNUM',0x00000007)
    win_const_mgr.add_const('PSR_MC',0x00000023)
    win_const_mgr.add_const('ICCOMPRESSFRAMES_PADDING',0x00000001)
    win_const_mgr.add_const('ELEMENT_STATUS_SVALID',0x00800000)
    win_const_mgr.add_const('BG_E_ERROR_CONTEXT_REMOTE_APPLICATION',0x8020001E)
    win_const_mgr.add_const('DDSCL_FULLSCREEN',0x00000001)
    win_const_mgr.add_const('DBPROPVAL_CB_NON_NULL',0x00000002)
    win_const_mgr.add_const('ERROR_INVALID_TARGET_HANDLE',0x00000072)
    win_const_mgr.add_const('METADATA_INSERT_PATH',0x00000040)
    win_const_mgr.add_const('MCI_DGV_METHOD_DIRECT',0x00000000)
    win_const_mgr.add_const('SV_OPENFILES_PARMNUM',0x0000019E)
    win_const_mgr.add_const('ILIF_LOWQUALITY',0x00000002)
    win_const_mgr.add_const('LINETRANSLATERESULT_INTOLLLIST',0x00000010)
    win_const_mgr.add_const('MD_MAX_CHANGE_ENTRIES',0x00000064)
    win_const_mgr.add_const('PUBLICKEYBLOB',0x00000006)
    win_const_mgr.add_const('ES_WANTRETURN',0x00001000)
    win_const_mgr.add_const('ERROR_LOG_MULTIPLEXED',0x000019E6)
    win_const_mgr.add_const('CMSG_SP3_COMPATIBLE_ENCRYPT_FLAG',0x80000000)
    win_const_mgr.add_const('DVB_SIT_PID',0x0000001F)
    win_const_mgr.add_const('XECI_REQWIZARD',0x00000003)
    win_const_mgr.add_const('SPI_SETCURSORSHADOW',0x0000101B)
    win_const_mgr.add_const('MCI_VCR_STATUS_TIME_MODE',0x0000401A)
    win_const_mgr.add_const('WS_EX_TRANSPARENT',0x00000020)
    win_const_mgr.add_const('OID_FDDI_MAC_FRAME_STATUS_FUNCTIONS',0x0303021F)
    win_const_mgr.add_const('LCRED_CRED_EXISTS',0x00000001)
    win_const_mgr.add_const('HANGUP_PENDING',0x00000004)
    win_const_mgr.add_const('LINECALLFEATURE_ADDTOCONF',0x00000002)
    win_const_mgr.add_const('PAN_WEIGHT_INDEX',0x00000002)
    win_const_mgr.add_const('PERF_ADD_COUNTER',0x00000001)
    win_const_mgr.add_const('WLAN_API_VERSION_2_0',0x00000002)
    win_const_mgr.add_const('CERT_CHAIN_CACHE_END_CERT',0x00000001)
    win_const_mgr.add_const('SPI_SETBEEP',0x00000002)
    win_const_mgr.add_const('IDM_PROPERTIES',0x0000001C)
    win_const_mgr.add_const('BCRYPT_ECDH_PUBLIC_P256_MAGIC',0x314B4345)
    win_const_mgr.add_const('FWPM_SUBSCRIPTION_FLAG_NOTIFY_ON_ADD',0x00000001)
    win_const_mgr.add_const('DNS_ERROR_CANNOT_FIND_ROOT_HINTS',0x0000255C)
    win_const_mgr.add_const('SO_DEBUG',0x00000001)
    win_const_mgr.add_const('PIDDSI_HEADINGPAIR',0x0000000C)
    win_const_mgr.add_const('RPC_C_BINDING_DEFAULT_TIMEOUT',0x00000005)
    win_const_mgr.add_const('VIF_CANNOTDELETECUR',0x00004000)
    win_const_mgr.add_const('NDW_INSTALLFLAG_CI_PICKED_OEM',0x00008000)
    win_const_mgr.add_const('HTTP_STATUS_URI_TOO_LONG',0x0000019E)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_PORT_STATE',0x0000009D)
    win_const_mgr.add_const('TRANSACTION_MANAGER_CORRUPT_FOR_RECOVERY',0x00000010)
    win_const_mgr.add_const('CCF_NOTEXT',0x00000001)
    win_const_mgr.add_const('WMDM_GET_FORMAT_SUPPORT_VIDEO',0x00000002)
    win_const_mgr.add_const('OID_TCP_SAN_SUPPORT',0xFC010204)
    win_const_mgr.add_const('INTERNET_CACHE_FLAG_ADD_FILENAME_ONLY',0x00000800)
    win_const_mgr.add_const('SET_MIRROR_MODE',0x0000100E)
    win_const_mgr.add_const('PRJOB_QS_PRINTING',0x00000003)
    win_const_mgr.add_const('WS_EX_RIGHT',0x00001000)
    win_const_mgr.add_const('PDH_LOG_TYPE_SQL',0x00000007)
    win_const_mgr.add_const('CMS_DISABLEICM',0x00000001)
    win_const_mgr.add_const('WM_ERASEBKGND',0x00000014)
    win_const_mgr.add_const('SHGFI_SELECTED',0x00010000)
    win_const_mgr.add_const('ERROR_INSTRUCTION_MISALIGNMENT',0x00000225)
    win_const_mgr.add_const('GESTURE_CIRCLE_LINE_VERT',0x00000000)
    win_const_mgr.add_const('DNSSEC_KEY_FLAG_FLAG10',0x00000400)
    win_const_mgr.add_const('UNICODE_NOCHAR',0x0000FFFF)
    win_const_mgr.add_const('PHONEFEATURE_SETDATA',0x00008000)
    win_const_mgr.add_const('ERROR_CLUSTER_NODE_NOT_FOUND',0x000013B2)
    win_const_mgr.add_const('RTUTILS_MAX_PROTOCOL_NAME_LEN',0x00000028)
    win_const_mgr.add_const('ACM_FORMATTAGDETAILSF_QUERYMASK',0x0000000F)
    win_const_mgr.add_const('WM_NCDESTROY',0x00000082)
    win_const_mgr.add_const('WIA_PLANAR',0x00000001)
    win_const_mgr.add_const('ERROR_EOM_OVERFLOW',0x00000469)
    win_const_mgr.add_const('OID_PNP_SET_POWER',0xFD010101)
    win_const_mgr.add_const('LVIF_INDENT',0x00000010)
    win_const_mgr.add_const('DOT11_FLAGS_80211G_DSSS_OFDM',0x00000010)
    win_const_mgr.add_const('RPC_S_NO_ENDPOINT_FOUND',0x000006AC)
    win_const_mgr.add_const('DMPAPER_B4_JIS_ROTATED',0x0000004F)
    win_const_mgr.add_const('DDSCL_ALLOWREBOOT',0x00000002)
    win_const_mgr.add_const('LOCKP_ALLOW_MEM_MAPPING',0x00000000)
    win_const_mgr.add_const('MSIM_DISPID_ONTEXTRECEIVED',0x00000E06)
    win_const_mgr.add_const('EMR_POLYGON16',0x00000056)
    win_const_mgr.add_const('PROFILE_MEMBUFFER',0x00000002)
    win_const_mgr.add_const('PERF_ATTRIB_NO_GROUP_SEPARATOR',0x00000004)
    win_const_mgr.add_const('SQLVARCHAR',0x00000027)
    win_const_mgr.add_const('DEBUG_EVENT_UNLOAD_MODULE',0x00000080)
    win_const_mgr.add_const('PORT_AED512',0x00000095)
    win_const_mgr.add_const('CMS_SETMONITORPROFILE',0x00000010)
    win_const_mgr.add_const('CRYPT_WRITE',0x00000010)
    win_const_mgr.add_const('OCSP_BASIC_BY_NAME_RESPONDER_ID',0x00000001)
    win_const_mgr.add_const('ERROR_LOGON_SERVER_CONFLICT',0x00000238)
    win_const_mgr.add_const('CLIPBRD_S_LAST',0x000401DF)
    win_const_mgr.add_const('RQ_SEND_RESPONSE',0x20000000)
    win_const_mgr.add_const('TA_TOP',0x00000000)
    win_const_mgr.add_const('DIALOPTION_BILLING',0x00000040)
    win_const_mgr.add_const('REG_OPTION_NON_VOLATILE',0x00000000)
    win_const_mgr.add_const('CHANGER_CLEANER_SLOT',0x00000040)
    win_const_mgr.add_const('DEFAULT_SNMPTRAP_PORT_UDP',0x000000A2)
    win_const_mgr.add_const('CHANNEL_FLAG_RESUME',0x00000040)
    win_const_mgr.add_const('DSBI_HASCREDENTIALS',0x00200000)
    win_const_mgr.add_const('OPTION_SUBNET_MASK',0x00000001)
    win_const_mgr.add_const('OID_FDDI_MAC_AVAILABLE_PATHS',0x03030223)
    win_const_mgr.add_const('DDCOLOR_HUE',0x00000004)
    win_const_mgr.add_const('MPR_INTERFACE_ADMIN_DISABLED',0x00000002)
    win_const_mgr.add_const('BATTERY_CAPACITY_RELATIVE',0x40000000)
    win_const_mgr.add_const('TMT_BORDERTYPE',0x00000FA2)
    win_const_mgr.add_const('ATSC_STT_TID',0x000000CD)
    win_const_mgr.add_const('KEY_WOW64_64KEY',0x00000100)
    win_const_mgr.add_const('SQL_DIAG_DROP_CHARACTER_SET',0x00000019)
    win_const_mgr.add_const('AVICOMPRESSF_VALID',0x00000008)
    win_const_mgr.add_const('WMDM_LOG_SEV_WARN',0x00000002)
    win_const_mgr.add_const('ITR_PAL_INDEX',0x00000004)
    win_const_mgr.add_const('IMAGE_REL_AM_TOKEN',0x00000009)
    win_const_mgr.add_const('DTRESULTPROB',0x00000002)
    win_const_mgr.add_const('IDM_JUSTIFYLEFT',0x0000003B)
    win_const_mgr.add_const('MQMSG_TRACE_NONE',0x00000000)
    win_const_mgr.add_const('ERROR_DS_COUNTING_AB_INDICES_FAILED',0x000020EC)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_REMOTE_DESKTOP_USERS',0x0000022B)
    win_const_mgr.add_const('EM_GETLINE',0x000000C4)
    win_const_mgr.add_const('WINHTTP_ACCESS_TYPE_DEFAULT_PROXY',0x00000000)
    win_const_mgr.add_const('INTERNET_ERROR_MASK_NEED_MSN_SSPI_PKG',0x00000000)
    win_const_mgr.add_const('NTM_BOLD',0x00000020)
    win_const_mgr.add_const('SSF_ICONSONLY',0x01000000)
    win_const_mgr.add_const('CRYPT_MACHINE_DEFAULT',0x00000001)
    win_const_mgr.add_const('SBSP_TRUSTFIRSTDOWNLOAD',0x01000000)
    win_const_mgr.add_const('MAX_LINE_LEN',0x00000400)
    win_const_mgr.add_const('DNOBJECT_NICE',0x00000013)
    win_const_mgr.add_const('RCRED_CRED_EXISTS',0x00000001)
    win_const_mgr.add_const('D3DVS20_MIN_NUMTEMPS',0x0000000C)
    win_const_mgr.add_const('MDTREEOP_PARENT',0x00000004)
    win_const_mgr.add_const('DDBLTFX_ROTATE90',0x00000040)
    win_const_mgr.add_const('ERROR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT',0x00001A9B)
    win_const_mgr.add_const('RPC_C_SECURITY_QOS_VERSION',0x00000001)
    win_const_mgr.add_const('VK_DBE_SBCSCHAR',0x00000000)
    win_const_mgr.add_const('LVS_EX_TRANSPARENTSHADOWTEXT',0x00800000)
    win_const_mgr.add_const('SPDRP_LOWERFILTERS',0x00000012)
    win_const_mgr.add_const('DDFXCAPS_BLTSHRINKXN',0x00000800)
    win_const_mgr.add_const('SHPWHF_USEMRU',0x00000008)
    win_const_mgr.add_const('WIA_INTENT_MAXIMIZE_QUALITY',0x00020000)
    win_const_mgr.add_const('FILE_READ_ATTRIBUTES',0x00000080)
    win_const_mgr.add_const('SPMODE_MULTISTOP',0x00004000)
    win_const_mgr.add_const('LOCALE_ICURRENCY',0x0000001B)
    win_const_mgr.add_const('RTM_ROUTE_FLAGS_ZEROS_SUBNETBC',0x00002000)
    win_const_mgr.add_const('HTTB_RESIZINGBORDER_TOP',0x00000020)
    win_const_mgr.add_const('WT_TRUSTDBDIALOG_NO_UI_FLAG',0x00000001)
    win_const_mgr.add_const('MCI_OVLY_GETDEVCAPS_CAN_FREEZE',0x00004002)
    win_const_mgr.add_const('JS_PAUSED',0x00000008)
    win_const_mgr.add_const('DNS_INFO_NO_RECORDS',0x0000251D)
    win_const_mgr.add_const('SQL_UP_OFF',0x00000000)
    win_const_mgr.add_const('GESTURE_CHEVRON_UP',0x00000000)
    win_const_mgr.add_const('PORT_DLS',0x000000C5)
    win_const_mgr.add_const('SP_FLAG_CABINETCONTINUATION',0x00000800)
    win_const_mgr.add_const('SQL_CS_DEFAULT_CHARACTER_SET',0x00000004)
    win_const_mgr.add_const('INTERNET_OPTION_SETTINGS_CHANGED',0x00000027)
    win_const_mgr.add_const('DS_REPL_NBR_FULL_SYNC_NEXT_PACKET',0x00020000)
    win_const_mgr.add_const('QUOTA_LIMITS_USE_DEFAULT_LIMITS',0x00000010)
    win_const_mgr.add_const('DS_AVOID_SELF',0x00004000)
    win_const_mgr.add_const('PHONESTATE_SPEAKERHOOKSWITCH',0x00001000)
    win_const_mgr.add_const('CAL_SABBREVMONTHNAME11',0x00000002)
    win_const_mgr.add_const('DEVPROP_TYPE_SECURITY_DESCRIPTOR',0x00000013)
    win_const_mgr.add_const('CAL_SABBREVMONTHNAME13',0x00000002)
    win_const_mgr.add_const('SPQ_FLAG_DO_SHUFFLEMOVE',0x00000008)
    win_const_mgr.add_const('DEBUG_CSS_ALL',0x00000000)
    win_const_mgr.add_const('SO_TYPE',0x00001008)
    win_const_mgr.add_const('SUBLANG_TAJIK_TAJIKISTAN',0x00000001)
    win_const_mgr.add_const('SV_ALERTSCHEDULE_PARMNUM',0x00000223)
    win_const_mgr.add_const('ERROR_CSCSHARE_OFFLINE',0x000004EE)
    win_const_mgr.add_const('WIA_PROP_SYNC_REQUIRED',0x00000004)
    win_const_mgr.add_const('CRYPTPROTECTMEMORY_SAME_PROCESS',0x00000000)
    win_const_mgr.add_const('MEM_LARGE_PAGES',0x20000000)
    win_const_mgr.add_const('TVHT_ONITEMRIGHT',0x00000020)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_REFLONGNB',0x00000010)
    win_const_mgr.add_const('DMICM_CONTRAST',0x00000002)
    win_const_mgr.add_const('HTTP_QUERY_WARNING',0x00000043)
    win_const_mgr.add_const('BFFM_INITIALIZED',0x00000001)
    win_const_mgr.add_const('DM_ICMMETHOD',0x00800000)
    win_const_mgr.add_const('WIA_IPS_INVERT',0x00001810)
    win_const_mgr.add_const('DNPROTO_RAW',0x000000FF)
    win_const_mgr.add_const('MCI_ANIM_INFO_TEXT',0x00010000)
    win_const_mgr.add_const('SCHEDULE_BANDWIDTH',0x00000001)
    win_const_mgr.add_const('WMDM_RIGHTS_PLAY_ON_PC',0x00000001)
    win_const_mgr.add_const('CVT_HOURS',0x0000003C)
    win_const_mgr.add_const('TBSTYLE_REGISTERDROP',0x00004000)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_SCHEMATA',0x00000003)
    win_const_mgr.add_const('ERROR_REC_NON_EXISTENT',0x00000FA5)
    win_const_mgr.add_const('PFS_EC_SIZE',0x00000006)
    win_const_mgr.add_const('INDEX_GUID_GUIDE',0x00000001)
    win_const_mgr.add_const('SQLAOPMAX',0x00000052)
    win_const_mgr.add_const('SUPPORTS_UNICODE',0x00000010)
    win_const_mgr.add_const('CRYPT_OID_INFO_OID_GROUP_BIT_LEN_MASK',0x0FFF0000)
    win_const_mgr.add_const('IEIFLAG_SCREEN',0x00000020)
    win_const_mgr.add_const('OID_FDDI_SHORT_PERMANENT_ADDR',0x03010105)
    win_const_mgr.add_const('DWN_FORCEDITHER',0x00000080)
    win_const_mgr.add_const('HTLEFT',0x0000000A)
    win_const_mgr.add_const('MDPROPVAL_VISUAL_MODE_VISUAL_OFF',0x00000002)
    win_const_mgr.add_const('PF_ALPHA_BYTE_INSTRUCTIONS',0x00000005)
    win_const_mgr.add_const('NETE_NORESOURCE',0x00000008)
    win_const_mgr.add_const('CERT_TRUST_HAS_EXACT_MATCH_ISSUER',0x00000001)
    win_const_mgr.add_const('SPINST_BITREG',0x00000020)
    win_const_mgr.add_const('CREDUI_MAX_MESSAGE_LENGTH',0x00007FFF)
    win_const_mgr.add_const('SHTDN_REASON_FLAG_CLEAN_UI',0x04000000)
    win_const_mgr.add_const('CM_REGISTER_DEVICE_DRIVER_STATIC',0x00000000)
    win_const_mgr.add_const('OBM_DNARROWD',0x00007FE6)
    win_const_mgr.add_const('DS_REPL_NBR_NO_CHANGE_NOTIFICATIONS',0x20000000)
    win_const_mgr.add_const('RTCEF_CLIENT',0x00000001)
    win_const_mgr.add_const('SMC_DEMOTE',0x00000011)
    win_const_mgr.add_const('CHANNEL_RC_NOT_IN_VIRTUALCHANNELENTRY',0x0000000F)
    win_const_mgr.add_const('POLLERR',0x00000001)
    win_const_mgr.add_const('WIA_PAGE_ISO_B3',0x00000014)
    win_const_mgr.add_const('LINEERR_INUSE',0x8000000F)
    win_const_mgr.add_const('SERVICE_UNINSTALL_PENDING',0x00000002)
    win_const_mgr.add_const('SQL_INTERVAL_DAY',0x00000064)
    win_const_mgr.add_const('IMAGE_REL_I386_DIR32',0x00000006)
    win_const_mgr.add_const('RPC_C_AUTHN_GSS_SCHANNEL',0x0000000E)
    win_const_mgr.add_const('FACILITY_ITF',0x00000004)
    win_const_mgr.add_const('DSGIF_ISNORMAL',0x00000000)
    win_const_mgr.add_const('ERROR_CLUSTER_IPADDR_IN_USE',0x000013C1)
    win_const_mgr.add_const('RPC_C_AUTHN_WINNT',0x0000000A)
    win_const_mgr.add_const('MIXER_GETLINECONTROLSF_ALL',0x00000000)
    win_const_mgr.add_const('CAUSE_LOC_PRIVATE_LOCAL',0x00000001)
    win_const_mgr.add_const('PDCAP_S1_SUPPORTED',0x00020000)
    win_const_mgr.add_const('PRINTER_CHANGE_SET_PRINTER',0x00000002)
    win_const_mgr.add_const('KSNODEPIN_AEC_CAPTURE_OUT',0x00000003)
    win_const_mgr.add_const('DSROLE_PRIMARY_DS_RUNNING',0x00000001)
    win_const_mgr.add_const('SAMPLE_SEQ_PICTURE_HEADER',0x00000003)
    win_const_mgr.add_const('CRYPT_MODE_CFB',0x00000004)
    win_const_mgr.add_const('ICM_LEVEL2_5',0x00000003)
    win_const_mgr.add_const('LANG_FARSI',0x00000029)
    win_const_mgr.add_const('WM_NCXBUTTONDBLCLK',0x000000AD)
    win_const_mgr.add_const('EVENT_SYSTEM_MINIMIZESTART',0x00000016)
    win_const_mgr.add_const('SQL_FN_STR_LOCATE_2',0x00010000)
    win_const_mgr.add_const('DSSI_READ_ONLY',0x00000001)
    win_const_mgr.add_const('WMIGUID_SET',0x00000002)
    win_const_mgr.add_const('MF_COMPONENT_CERT_REVOKED',0x00008000)
    win_const_mgr.add_const('IDD_DYNAWIZ_SELECT_NEXTPAGE',0x00002712)
    win_const_mgr.add_const('BCRYPT_PUBLIC_KEY_FLAG',0x00000001)
    win_const_mgr.add_const('CACHEGROUP_ATTRIBUTE_FLAG',0x00000002)
    win_const_mgr.add_const('E_PRINTCAPABILITIES_FORMAT',0x80040004)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_DECRYPT',0x0000362B)
    win_const_mgr.add_const('EVENT_E_FIRST',0x80040200)
    win_const_mgr.add_const('__SAL_H_FULL_VER',0x08590127)
    win_const_mgr.add_const('CPS_COMPLETE',0x00000001)
    win_const_mgr.add_const('SID_MAX_SUB_AUTHORITIES',0x0000000F)
    win_const_mgr.add_const('D3DDEVCAPS_CANBLTSYSTONONLOCAL',0x00020000)
    win_const_mgr.add_const('D3DTEXOPCAPS_MULTIPLYADD',0x01000000)
    win_const_mgr.add_const('CRYPT_OID_INFO_PUBKEY_SIGN_KEY_FLAG',0x80000000)
    win_const_mgr.add_const('MQ_ACTION_RECEIVE',0x00000000)
    win_const_mgr.add_const('CRYPT_NEWKEYSET',0x00000008)
    win_const_mgr.add_const('MAX_DEINTERLACE_SURFACES',0x00000020)
    win_const_mgr.add_const('HTTP_QUERY_CONTENT_LANGUAGE',0x00000006)
    win_const_mgr.add_const('SECPKG_FLAG_RESTRICTED_TOKENS',0x00080000)
    win_const_mgr.add_const('ERROR_UNDEFINED_CHARACTER',0x00000247)
    win_const_mgr.add_const('MCI_VCR_STATUS_INDEX',0x0000400F)
    win_const_mgr.add_const('USN_REASON_INDEXABLE_CHANGE',0x00004000)
    win_const_mgr.add_const('PRIVACY_TYPE_THIRD_PARTY',0x00000001)
    win_const_mgr.add_const('DSF_TWAIN_DEVICES',0x00000010)
    win_const_mgr.add_const('STD_PROPERTIES',0x0000000A)
    win_const_mgr.add_const('DFCS_CAPTIONMIN',0x00000001)
    win_const_mgr.add_const('SIMPLEBLOB',0x00000001)
    win_const_mgr.add_const('DISPID_RESETFIRSTBOOTMODE',0x00000001)
    win_const_mgr.add_const('BTH_ERROR_CONNECTION_TIMEOUT',0x00000008)
    win_const_mgr.add_const('GL_ID_INPUTCODE',0x00000026)
    win_const_mgr.add_const('FPSR_I2',0x0000002C)
    win_const_mgr.add_const('FPSR_I3',0x00000039)
    win_const_mgr.add_const('NDIS_PACKET_TYPE_802_11_DIRECTED_CTRL',0x00800000)
    win_const_mgr.add_const('IME_PROP_AT_CARET',0x00010000)
    win_const_mgr.add_const('DDSD_CKSRCBLT',0x00010000)
    win_const_mgr.add_const('KSDSOUND_3D_MODE_NORMAL',0x00000000)
    win_const_mgr.add_const('LVHT_BELOW',0x00000010)
    win_const_mgr.add_const('PHOTO_PROGRAMMODE_SHUTTER',0x00000004)
    win_const_mgr.add_const('FPSR_ID',0x00000005)
    win_const_mgr.add_const('TIME_NOSECONDS',0x00000002)
    win_const_mgr.add_const('TABLET_ENABLE_FLICKLEARNINGMODE',0x00040000)
    win_const_mgr.add_const('SQL_OV_ODBC3',0x00000003)
    win_const_mgr.add_const('SQL_OV_ODBC2',0x00000002)
    win_const_mgr.add_const('MIB_IF_TYPE_TOKENRING',0x00000009)
    win_const_mgr.add_const('RPC_X_INVALID_ES_ACTION',0x00000723)
    win_const_mgr.add_const('IDM_SAVEAS',0x00000047)
    win_const_mgr.add_const('TLS1_ALERT_INTERNAL_ERROR',0x00000050)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_SERVICES',0x80800000)
    win_const_mgr.add_const('MCI_DGV_FF_JFIF',0x00004006)
    win_const_mgr.add_const('CMSG_BARE_CONTENT_FLAG',0x00000001)
    win_const_mgr.add_const('INTERNET_OPTION_IGNORE_OFFLINE',0x0000004D)
    win_const_mgr.add_const('CLCTL_USER_MASK',0x00000001)
    win_const_mgr.add_const('LINEDEVCAPFLAGS_MEDIACONTROL',0x00000008)
    win_const_mgr.add_const('DCM_FLAGS_CTFMON',0x00000002)
    win_const_mgr.add_const('CRL_REASON_UNUSED_FLAG',0x00000080)
    win_const_mgr.add_const('GMEM_MODIFY',0x00000080)
    win_const_mgr.add_const('PID_NETRESOURCE',0x00000001)
    win_const_mgr.add_const('CRED_FLAGS_PROMPT_NOW',0x00000002)
    win_const_mgr.add_const('ERROR_DS_CANT_MOVE_DELETED_OBJECT',0x00002129)
    win_const_mgr.add_const('CM_DETECT_CRASHED',0x00000002)
    win_const_mgr.add_const('MDFF_BOLD',0x00000001)
    win_const_mgr.add_const('SPI_SETMINIMIZEDMETRICS',0x0000002C)
    win_const_mgr.add_const('CB_SETEXTENDEDUI',0x00000155)
    win_const_mgr.add_const('REPLACEFILE_WRITE_THROUGH',0x00000001)
    win_const_mgr.add_const('SPI_GETDROPSHADOW',0x00001024)
    win_const_mgr.add_const('PRINTER_NOTIFY_FIELD_ATTRIBUTES',0x0000000D)
    win_const_mgr.add_const('GL_RSCA_QUERY',0x00001000)
    win_const_mgr.add_const('IMC_SETCOMPOSITIONWINDOW',0x0000000C)
    win_const_mgr.add_const('WLX_DLG_INPUT_TIMEOUT',0x00000066)
    win_const_mgr.add_const('WINHTTP_AUTO_DETECT_TYPE_DHCP',0x00000001)
    win_const_mgr.add_const('EVENT_ENABLE_PROPERTY_TS_ID',0x00000002)
    win_const_mgr.add_const('MMIO_REMOVEPROC',0x00020000)
    win_const_mgr.add_const('IPSEC_POLICY_FLAG_NAT_ENCAP_ALLOW_PEER_BEHIND_NAT',0x00000010)
    win_const_mgr.add_const('SECTION_MAP_EXECUTE_EXPLICIT',0x00000020)
    win_const_mgr.add_const('SCESTATUS_ALREADY_RUNNING',0x0000000D)
    win_const_mgr.add_const('SQL_CT_COLUMN_DEFAULT',0x00000400)
    win_const_mgr.add_const('ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE',0x000036DD)
    win_const_mgr.add_const('MDMSPKR_OFF',0x00000000)
    win_const_mgr.add_const('CLCTL_MODIFY_MASK',0x00000001)
    win_const_mgr.add_const('MM_SNDBLST_MIDIOUT',0x00000003)
    win_const_mgr.add_const('VK_RBUTTON',0x00000002)
    win_const_mgr.add_const('OID_FDDI_FRAME_ERRORS',0x03020104)
    win_const_mgr.add_const('SQL_API_SQLTABLEPRIVILEGES',0x00000046)
    win_const_mgr.add_const('LL_INACTIVE',0x00000000)
    win_const_mgr.add_const('CBR_256000',0x0003E800)
    win_const_mgr.add_const('SQL_ATTR_OUTPUT_NTS',0x00002711)
    win_const_mgr.add_const('MK_XBUTTON1',0x00000020)
    win_const_mgr.add_const('EAP_E_EAPHOST_EAPQEC_INACCESSIBLE',0x80420013)
    win_const_mgr.add_const('AM_LOADSTATUS_LOADINGDESCR',0x00000001)
    win_const_mgr.add_const('INTERNET_OPTION_CONNECT_BACKOFF',0x00000004)
    win_const_mgr.add_const('DN_MAXOBJL',0x00000010)
    win_const_mgr.add_const('WIA_DIP_PNP_ID',0x00000010)
    win_const_mgr.add_const('HTTP_QUERY_RAW_HEADERS',0x00000015)
    win_const_mgr.add_const('USER_MARSHAL_FC_DOUBLE',0x0000000C)
    win_const_mgr.add_const('IDM_JUSTIFYCENTER',0x00000039)
    win_const_mgr.add_const('WT_EXECUTEINTIMERTHREAD',0x00000020)
    win_const_mgr.add_const('FR_NOUPDOWN',0x00000400)
    win_const_mgr.add_const('KAGPROP_CONCURRENCY',0x00000007)
    win_const_mgr.add_const('KSEVENT_TYPE_ENABLE',0x00000001)
    win_const_mgr.add_const('WLX_CREDENTIAL_TYPE_V1_0',0x00000001)
    win_const_mgr.add_const('GL_LEVEL_WARNING',0x00000003)
    win_const_mgr.add_const('SQL_INDEX_ALL',0x00000001)
    win_const_mgr.add_const('BFT_DATABASE_DIRECTORY',0x00000040)
    win_const_mgr.add_const('CRYPT_FORCE_KEY_PROTECTION_HIGH',0x00008000)
    win_const_mgr.add_const('MK_XBUTTON2',0x00000040)
    win_const_mgr.add_const('FACILITY_WIN32',0x00000007)
    win_const_mgr.add_const('SMAE_VALID',0x00000007)
    win_const_mgr.add_const('BLLI_L2_LLC',0x0000000C)
    win_const_mgr.add_const('HICF_MOUSE',0x00000001)
    win_const_mgr.add_const('D3DSHADER_COMPARISON_MASK',0x00000007)
    win_const_mgr.add_const('SQLBIGCHAR',0x00000000)
    win_const_mgr.add_const('WSA_FLAG_OVERLAPPED',0x00000001)
    win_const_mgr.add_const('SQL_NB_ON',0x00000001)
    win_const_mgr.add_const('VIDEO_CONFIGURE_GET',0x00002000)
    win_const_mgr.add_const('SERVICE_SID_TYPE_UNRESTRICTED',0x00000001)
    win_const_mgr.add_const('PGN_FIRST',0x00000000)
    win_const_mgr.add_const('DDFLIP_EVEN',0x00000002)
    win_const_mgr.add_const('ILP_DOWNLEVEL',0x00000001)
    win_const_mgr.add_const('STD_COPY',0x00000001)
    win_const_mgr.add_const('DEBUG_MANRESET_LOAD_DLL',0x00000001)
    win_const_mgr.add_const('PDH_DIALOG_CANCELLED',0x800007D9)
    win_const_mgr.add_const('IDM_ATOMICSELECTION',0x0000095F)
    win_const_mgr.add_const('DBPROPVAL_IN_IGNOREANYNULL',0x00000004)
    win_const_mgr.add_const('RBSTR_CHANGERECT',0x00000001)
    win_const_mgr.add_const('LOCKP_LOCK_FOR_FORMAT',0x00000004)
    win_const_mgr.add_const('TBS_FIXEDLENGTH',0x00000040)
    win_const_mgr.add_const('HELP_KEY',0x00000101)
    win_const_mgr.add_const('EC_SAMPLE_NEEDED',0x00000020)
    win_const_mgr.add_const('UNWIND_HISTORY_TABLE_SIZE',0x0000000C)
    win_const_mgr.add_const('MCI_DGV_WHERE_DESTINATION',0x00040000)
    win_const_mgr.add_const('FILE_DEVICE_SCREEN',0x00000001)
    win_const_mgr.add_const('COD_COMPUTER_MINOR_UNCLASSIFIED',0x00000000)
    win_const_mgr.add_const('MSV1_0_SUBAUTH_ACCOUNT_TYPE',0x00000040)
    win_const_mgr.add_const('F_EXISTCHECK',0x00000013)
    win_const_mgr.add_const('ACM_MPEG_ORIGINALHOME',0x00000004)
    win_const_mgr.add_const('ERROR_CLEANER_SLOT_NOT_SET',0x000010EC)
    win_const_mgr.add_const('LINE_MONITORMEDIA',0x0000000A)
    win_const_mgr.add_const('MCN_FIRST',0x00000000)
    win_const_mgr.add_const('BG_COPY_FILE_SACL',0x00000008)
    win_const_mgr.add_const('MDPROPVAL_MSC_LESSTHAN',0x00000001)
    win_const_mgr.add_const('DEBUG_OUTPUT_IDENTITY_DEFAULT',0x00000000)
    win_const_mgr.add_const('AUTO_PROXY_FLAG_DONT_CACHE_PROXY_RESULT',0x00000010)
    win_const_mgr.add_const('SQL_RE_ON',0x00000001)
    win_const_mgr.add_const('SM_CYFOCUSBORDER',0x00000054)
    win_const_mgr.add_const('SM_CXICONSPACING',0x00000026)
    win_const_mgr.add_const('ASC_REQ_LICENSING',0x00040000)
    win_const_mgr.add_const('CDB2GVF_ISFILESAVE',0x00000002)
    win_const_mgr.add_const('IF_TYPE_COFFEE',0x00000084)
    win_const_mgr.add_const('GD_MAX_RESOURCE',0x0000000F)
    win_const_mgr.add_const('SUBLANG_ARABIC_QATAR',0x00000010)
    win_const_mgr.add_const('SP_COPY_PNPLOCKED',0x02000000)
    win_const_mgr.add_const('ERROR_TXF_METADATA_ALREADY_PRESENT',0x00001AB3)
    win_const_mgr.add_const('SUBLANG_CUSTOM_UNSPECIFIED',0x00000004)
    win_const_mgr.add_const('CERT_VALIDITY_EXTENDED_USAGE_FAILURE',0x00000020)
    win_const_mgr.add_const('MAXLSN',0x7FFFFFFFFFFFFFFF)
    win_const_mgr.add_const('SCARD_STATE_MUTE',0x00000200)
    win_const_mgr.add_const('D3DPTADDRESSCAPS_CLAMP',0x00000004)
    win_const_mgr.add_const('PAN_MIDLINE_STANDARD_TRIMMED',0x00000002)
    win_const_mgr.add_const('SCARD_PROTOCOL_DEFAULT',0x80000000)
    win_const_mgr.add_const('ICW_FULLPRESENT',0x00000001)
    win_const_mgr.add_const('DBT_CONFIGMGAPI32',0x00000022)
    win_const_mgr.add_const('ERROR_DS_OBJECT_BEING_REMOVED',0x00002093)
    win_const_mgr.add_const('DISPID_FONT_SIZE',0x00000002)
    win_const_mgr.add_const('DM_YRESOLUTION',0x00002000)
    win_const_mgr.add_const('PSWIZB_FINISH',0x00000004)
    win_const_mgr.add_const('LINEADDRESSTYPE_EMAILNAME',0x00000004)
    win_const_mgr.add_const('DDBLTFAST_NOCOLORKEY',0x00000000)
    win_const_mgr.add_const('D3DSP_REGNUM_MASK',0x000007FF)
    win_const_mgr.add_const('NETLOGON_CONTROL_UNLOAD_NETLOGON_DLL',0x0000FFFB)
    win_const_mgr.add_const('DEBUG_TYPEOPTS_LONGSTATUS_DISPLAY',0x00000002)
    win_const_mgr.add_const('MAPI_NEW_MESSAGE',0x00000002)
    win_const_mgr.add_const('CC_ROUNDRECT',0x00000100)
    win_const_mgr.add_const('WINHTTP_OPTION_RECEIVE_TIMEOUT',0x00000006)
    win_const_mgr.add_const('OID_GEN_BROADCAST_BYTES_XMIT',0x00020205)
    win_const_mgr.add_const('APPCOMMAND_MEDIA_REWIND',0x00000032)
    win_const_mgr.add_const('ERROR_CTX_NO_OUTBUF',0x00001B60)
    win_const_mgr.add_const('DNOBJECT_DTR',0x0000003F)
    win_const_mgr.add_const('TME_CANCEL',0x80000000)
    win_const_mgr.add_const('IF_TYPE_FRAMERELAY_SERVICE',0x0000002C)
    win_const_mgr.add_const('DFC_BUTTON',0x00000004)
    win_const_mgr.add_const('SQL_QUICK',0x00000000)
    win_const_mgr.add_const('NDIS_RING_REMOVE_RECEIVED',0x00000200)
    win_const_mgr.add_const('AGP_FLAG_NO_8X_RATE',0x00000008)
    win_const_mgr.add_const('REG_NOTIFY_CHANGE_NAME',0x00000001)
    win_const_mgr.add_const('PERF_DISPLAY_NOSHOW',0x40000000)
    win_const_mgr.add_const('HCF_HOTKEYACTIVE',0x00000004)
    win_const_mgr.add_const('ACL_REVISION2',0x00000002)
    win_const_mgr.add_const('EC_SHUTTING_DOWN',0x0000000C)
    win_const_mgr.add_const('KSDSOUND_BUFFER_CTRL_VOLUME',0x00000008)
    win_const_mgr.add_const('SMART_CYL_HI',0x000000C2)
    win_const_mgr.add_const('TXTLOG_POLICY',0x00800000)
    win_const_mgr.add_const('DEBUG_EVENT_EXIT_PROCESS',0x00000020)
    win_const_mgr.add_const('SC_MINIMIZE',0x0000F020)
    win_const_mgr.add_const('KS_VBICAP_PROTECTION_MV_PRESENT',0x00000001)
    win_const_mgr.add_const('KAGPROP_MAXCOLUMNSINSELECT',0x0000000F)
    win_const_mgr.add_const('WMI_GUIDTYPE_EVENT',0x00000003)
    win_const_mgr.add_const('RPC_S_OUT_OF_RESOURCES',0x000006B9)
    win_const_mgr.add_const('WHITEONBLACK',0x00000002)
    win_const_mgr.add_const('OID_FDDI_IF_TYPE',0x0303027A)
    win_const_mgr.add_const('MD_APPPOOL_IDENTITY_TYPE_SPECIFICUSER',0x00000003)
    win_const_mgr.add_const('JOB_STATUS_DELETING',0x00000004)
    win_const_mgr.add_const('FCSM_WEBVIEWTEMPLATE',0x00000002)
    win_const_mgr.add_const('TTS_ALWAYSTIP',0x00000001)
    win_const_mgr.add_const('MCI_WHERE',0x00000843)
    win_const_mgr.add_const('RPC_C_AUTHN_DPA',0x00000011)
    win_const_mgr.add_const('SUBLANG_ENGLISH_CAN',0x00000004)
    win_const_mgr.add_const('PLAINTEXTKEYBLOB',0x00000008)
    win_const_mgr.add_const('IDD_ACMFORMATCHOOSE_BTN_SETNAME',0x00000067)
    win_const_mgr.add_const('MAPI_EXPLICIT_PROFILE',0x00000010)
    win_const_mgr.add_const('IS_TEXT_UNICODE_STATISTICS',0x00000002)
    win_const_mgr.add_const('CMSG_CMS_ENCAPSULATED_CONTENT_FLAG',0x00000040)
    win_const_mgr.add_const('PORT_DN6NLMAUD',0x000000C3)
    win_const_mgr.add_const('TAPE_SELECT_PARTITIONS',0x00000001)
    win_const_mgr.add_const('SKF_RSHIFTLATCHED',0x02000000)
    win_const_mgr.add_const('RAS_EAP_FLAG_LOGON',0x00000004)
    win_const_mgr.add_const('IF_TYPE_LAP_D',0x0000004D)
    win_const_mgr.add_const('CMSG_ATTR_CERT_PARAM',0x00000020)
    win_const_mgr.add_const('INTERNET_FLAG_NO_COOKIES',0x00080000)
    win_const_mgr.add_const('DISPID_DEPTH',0x00000011)
    win_const_mgr.add_const('SPI_GETWINDOWSEXTENSION',0x0000005C)
    win_const_mgr.add_const('WINCODEC_ERR_BASE',0x00002000)
    win_const_mgr.add_const('SAMPLE_SEQ_SEQUENCE_HEADER',0x00000001)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_PROCESS_ERR_TRANS',0x00003608)
    win_const_mgr.add_const('LSA_MODE_MANDATORY_ACCESS',0x00000004)
    win_const_mgr.add_const('PIDDSI_MMCLIPCOUNT',0x0000000A)
    win_const_mgr.add_const('SBM_SETRANGE',0x000000E2)
    win_const_mgr.add_const('ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP',0x00001706)
    win_const_mgr.add_const('SCARD_STATE_IGNORE',0x00000001)
    win_const_mgr.add_const('SQL_ISV_REFERENTIAL_CONSTRAINTS',0x00001000)
    win_const_mgr.add_const('AM_AC3_SERVICE_MAIN_AUDIO',0x00000000)
    win_const_mgr.add_const('WIA_DATA_RAW_BGR',0x00000007)
    win_const_mgr.add_const('LVNI_SELECTED',0x00000002)
    win_const_mgr.add_const('BAUD_115200',0x00020000)
    win_const_mgr.add_const('MB_SERVICE_NOTIFICATION',0x00040000)
    win_const_mgr.add_const('IS_TEXT_UNICODE_NOT_ASCII_MASK',0x0000F000)
    win_const_mgr.add_const('OID_GEN_CO_BYTES_XMIT_OUTSTANDING',0x00020221)
    win_const_mgr.add_const('WM_MBUTTONDOWN',0x00000207)
    win_const_mgr.add_const('LINEINITIALIZEEXOPTION_USEEVENT',0x00000002)
    win_const_mgr.add_const('WPSTYLE_MAX',0x00000003)
    win_const_mgr.add_const('SECURITY_MIN_NEVER_FILTERED',0x000003E8)
    win_const_mgr.add_const('ABM_WINDOWPOSCHANGED',0x00000009)
    win_const_mgr.add_const('LANG_KOREAN',0x00000012)
    win_const_mgr.add_const('LINEAGENTSTATE_WORKINGAFTERCALL',0x00000080)
    win_const_mgr.add_const('DISPID_FONT_WEIGHT',0x00000007)
    win_const_mgr.add_const('SI_EDIT_EFFECTIVE',0x00020000)
    win_const_mgr.add_const('DISK_BINNING',0x00000003)
    win_const_mgr.add_const('GCPCLASS_POSTBOUNDLTR',0x00000020)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATAEVENTARGS_CURRENTACTION',0x00000303)
    win_const_mgr.add_const('PARMNUM_ALL',0x00000000)
    win_const_mgr.add_const('ERROR_DS_NONEXISTENT_POSS_SUP',0x000020C6)
    win_const_mgr.add_const('ID_BROWSE_ADDCONTROL',0x00000003)
    win_const_mgr.add_const('OID_GEN_BROADCAST_BYTES_RCV',0x0002020B)
    win_const_mgr.add_const('FLG_BITREG_32BITKEY',0x00004000)
    win_const_mgr.add_const('WS_BORDER',0x00800000)
    win_const_mgr.add_const('SQL_SENSITIVE',0x00000002)
    win_const_mgr.add_const('IO_ALIAS_10_BIT_DECODE',0x00000004)
    win_const_mgr.add_const('DNS_TYPE_NSAPPTR',0x00000017)
    win_const_mgr.add_const('PHOTO_SHARPNESS_SOFT',0x00000001)
    win_const_mgr.add_const('IDANI_OPEN',0x00000001)
    win_const_mgr.add_const('STN_DISABLE',0x00000003)
    win_const_mgr.add_const('LINEGATHERTERM_FIRSTTIMEOUT',0x00000004)
    win_const_mgr.add_const('REO_BELOWBASELINE',0x00000002)
    win_const_mgr.add_const('CERT_CROSS_CERT_DIST_POINTS_PROP_ID',0x00000017)
    win_const_mgr.add_const('ACM_FORMATSUGGESTF_WBITSPERSAMPLE',0x00080000)
    win_const_mgr.add_const('DISKQUOTA_FILESTATE_REBUILDING',0x00000200)
    win_const_mgr.add_const('SPDRP_LOCATION_INFORMATION',0x0000000D)
    win_const_mgr.add_const('FOREGROUND_INTENSITY',0x00000008)
    win_const_mgr.add_const('WMDM_DEVICECAP_CANSTOP',0x00000040)
    win_const_mgr.add_const('MUI_THREAD_LANGUAGES',0x00000040)
    win_const_mgr.add_const('LBS_DISABLENOSCROLL',0x00001000)
    win_const_mgr.add_const('SV_IRPSTACKSIZE_PARMNUM',0x000001FC)
    win_const_mgr.add_const('MCS_NOTRAILINGDATES',0x00000040)
    win_const_mgr.add_const('VS_FF_PRIVATEBUILD',0x00000008)
    win_const_mgr.add_const('SQL_IS_OFF',0x00000000)
    win_const_mgr.add_const('SBSP_REDIRECT',0x40000000)
    win_const_mgr.add_const('WIA_PAGE_ISO_A5',0x0000000B)
    win_const_mgr.add_const('IF_CONNECTION_DEDICATED',0x00000001)
    win_const_mgr.add_const('C2_ARABICNUMBER',0x00000006)
    win_const_mgr.add_const('ISCSI_LOGIN_OPTIONS_AUTH_TYPE',0x00000080)
    win_const_mgr.add_const('PRIORITY_PROP_HIGH',0x00000002)
    win_const_mgr.add_const('WIA_PAGE_ISO_A3',0x0000000A)
    win_const_mgr.add_const('CDS_GLOBAL',0x00000008)
    win_const_mgr.add_const('MD_SERVER_COMMAND_CONTINUE',0x00000004)
    win_const_mgr.add_const('LOCALSTATE_PUBLISHED',0x00000002)
    win_const_mgr.add_const('EMR_SETICMMODE',0x00000062)
    win_const_mgr.add_const('MD_ERROR_SUB401_LOGON_ACL',0x00000003)
    win_const_mgr.add_const('TCS_FORCELABELLEFT',0x00000020)
    win_const_mgr.add_const('WIA_PAGE_ISO_A1',0x00000008)
    win_const_mgr.add_const('ERROR_CHECKOUT_REQUIRED',0x000000DD)
    win_const_mgr.add_const('SQL_CO_FIREHOSE_AF',0x00000004)
    win_const_mgr.add_const('ERROR_ADDRESS_NOT_ASSOCIATED',0x000004CC)
    win_const_mgr.add_const('PC_NOCOLLAPSE',0x00000004)
    win_const_mgr.add_const('TYMED_MULTIPAGE_CALLBACK',0x00000200)
    win_const_mgr.add_const('OID_FDDI_MAC_LOST_CT',0x03030240)
    win_const_mgr.add_const('ERROR_TIMEOUT',0x000005B4)
    win_const_mgr.add_const('CQPM_HANDLERSPECIFIC',0x10000000)
    win_const_mgr.add_const('CHANGER_TO_TRANSPORT',0x00000001)
    win_const_mgr.add_const('ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC',0x0000219C)
    win_const_mgr.add_const('X3_IMM20_INST_WORD_X',0x00000003)
    win_const_mgr.add_const('HELP_CONTEXTPOPUP',0x00000008)
    win_const_mgr.add_const('PIPE_WAIT',0x00000000)
    win_const_mgr.add_const('ES_UPPERCASE',0x00000008)
    win_const_mgr.add_const('SND_ALIAS_START',0x00000000)
    win_const_mgr.add_const('CAUSE_LOC_INTERNATIONAL_NETWORK',0x00000007)
    win_const_mgr.add_const('KERB_RETRIEVE_TICKET_DONT_USE_CACHE',0x00000001)
    win_const_mgr.add_const('PGF_SCROLLUP',0x00000001)
    win_const_mgr.add_const('TCI_SRCFONTSIG',0x00000003)
    win_const_mgr.add_const('SP_PROT_UNI_CLIENT',0x80000000)
    win_const_mgr.add_const('ERROR_SXS_XML_E_INVALID_STANDALONE',0x000036F6)
    win_const_mgr.add_const('SB_LEFT',0x00000006)
    win_const_mgr.add_const('BG_E_PEERCACHING_DISABLED',0x80200047)
    win_const_mgr.add_const('CONFIGFLAG_SUPPRESS_SURPRISE',0x00004000)
    win_const_mgr.add_const('PHONESTATE_CAPSCHANGE',0x00400000)
    win_const_mgr.add_const('MCI_SET_AUDIO_LEFT',0x00000001)
    win_const_mgr.add_const('CLUS_HYBRID_QUORUM',0x00000400)
    win_const_mgr.add_const('USER_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION',0x00040000)
    win_const_mgr.add_const('CPS_CANCEL',0x00000004)
    win_const_mgr.add_const('IMAGE_REL_BASED_HIGHLOW',0x00000003)
    win_const_mgr.add_const('LC_POLYLINE',0x00000002)
    win_const_mgr.add_const('SCRIPT_DIGITSUBSTITUTE_TRADITIONAL',0x00000003)
    win_const_mgr.add_const('WM_SETREDRAW',0x0000000B)
    win_const_mgr.add_const('PFM_NUMBERING',0x00000020)
    win_const_mgr.add_const('AE_CONNSTART',0x00000004)
    win_const_mgr.add_const('IDC_LP_CHANGESOURCE',0x000003F7)
    win_const_mgr.add_const('CPIOD_PEEK',0x40000000)
    win_const_mgr.add_const('LGRPID_TURKIC',0x00000006)
    win_const_mgr.add_const('AUTH_REQ_ALLOW_FORWARDABLE',0x00000001)
    win_const_mgr.add_const('MAX_CO_PASSWORD_LENGTH',0x00000010)
    win_const_mgr.add_const('TLS1_ALERT_DECOMPRESSION_FAIL',0x0000001E)
    win_const_mgr.add_const('DISPID_SETPHISHINGFILTERSTATUS',0x0000011A)
    win_const_mgr.add_const('IME_SETCONVERSIONWINDOW',0x00000008)
    win_const_mgr.add_const('MS_PPM_SOFTWARE_ALL',0x00000001)
    win_const_mgr.add_const('NTDSSETTINGS_OPT_IS_TOPL_DETECT_STALE_DISABLED',0x00000001)
    win_const_mgr.add_const('MCI_DGV_SETAUDIO_LEFT',0x00200000)
    win_const_mgr.add_const('WN_SERVICE_CLASS',0x00000008)
    win_const_mgr.add_const('RASLCPAD_CHAP_MS',0x00000080)
    win_const_mgr.add_const('CERT_NAME_DNS_TYPE',0x00000006)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_CONFIG_NIC',0x0000000D)
    win_const_mgr.add_const('INTERNET_OPTION_CONNECT_TIMEOUT',0x00000002)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_SYSTEMSPEED',0x00000029)
    win_const_mgr.add_const('WM_GETHOTKEY',0x00000033)
    win_const_mgr.add_const('DOT11_RECV_FLAG_RAW_PACKET_FCS_FAILURE',0x00000002)
    win_const_mgr.add_const('DFCS_SCROLLSIZEGRIPRIGHT',0x00000010)
    win_const_mgr.add_const('DTR_CONTROL_HANDSHAKE',0x00000002)
    win_const_mgr.add_const('ISC_RET_EXTENDED_ERROR',0x00004000)
    win_const_mgr.add_const('NDIS_PNP_WAKE_UP_LINK_CHANGE',0x00000004)
    win_const_mgr.add_const('TRACE_VS_EVENT_ON',0x00000002)
    win_const_mgr.add_const('CRYPT_GET_URL_FROM_PROPERTY',0x00000001)
    win_const_mgr.add_const('ERROR_WAS_UNLOCKED',0x000002CB)
    win_const_mgr.add_const('CHINESEBIG5_CHARSET',0x00000088)
    win_const_mgr.add_const('SCARD_PROVIDER_CSP',0x00000002)
    win_const_mgr.add_const('SNMP_MEM_ALLOC_ERROR',0x00000001)
    win_const_mgr.add_const('DMPAPER_DSHEET',0x00000019)
    win_const_mgr.add_const('MAPI_NEW_SESSION',0x00000002)
    win_const_mgr.add_const('CONFIGFLAG_OKREMOVEROM',0x00000100)
    win_const_mgr.add_const('NDIS_PORT_AUTHENTICATION_PARAMETERS_REVISION_1',0x00000001)
    win_const_mgr.add_const('VCAPS_SRC_CAN_CLIP',0x00000002)
    win_const_mgr.add_const('SPFILENOTIFY_STARTBACKUP',0x00000015)
    win_const_mgr.add_const('DE_E_FILTER_SCRIPTLISTING',0x80100008)
    win_const_mgr.add_const('SQL_CD_TRUE',0x00000001)
    win_const_mgr.add_const('HSR_INITIATE',0x00000008)
    win_const_mgr.add_const('FAX_ERR_END',0x00001B65)
    win_const_mgr.add_const('FACILITY_HTTP',0x00000019)
    win_const_mgr.add_const('WSAEINTR',0x00002714)
    win_const_mgr.add_const('DPNHCAPSFLAG_NOTALLSUPPORTACTIVENOTIFY',0x00000010)
    win_const_mgr.add_const('FILE_DEVICE_WAVE_OUT',0x00000026)
    win_const_mgr.add_const('RPC_PROTSEQ_NMP',0x00000002)
    win_const_mgr.add_const('SPFILENOTIFY_FILEEXTRACTED',0x00000013)
    win_const_mgr.add_const('NUMBER_OF_PERFMON_REGISTER_PAIRS',0x00000004)
    win_const_mgr.add_const('ACMFILTERCHOOSE_STYLEF_CONTEXTHELP',0x00000080)
    win_const_mgr.add_const('IRTIR_TASK_SUSPENDED',0x00000002)
    win_const_mgr.add_const('LDAP_OPT_CACHE_STRATEGY',0x00000000)
    win_const_mgr.add_const('SERVICE_CONTROL_NETBINDENABLE',0x00000009)
    win_const_mgr.add_const('DONT_RESOLVE_DLL_REFERENCES',0x00000001)
    win_const_mgr.add_const('COD_MAJOR_IMAGING',0x00000006)
    win_const_mgr.add_const('DBPROPVAL_BI_CROSSROWSET',0x00000001)
    win_const_mgr.add_const('SECBUFFER_DATA',0x00000001)
    win_const_mgr.add_const('DS_GC_FLAG',0x00000004)
    win_const_mgr.add_const('SQL_FLOAT',0x00000006)
    win_const_mgr.add_const('ERROR_SXS_XML_E_UNCLOSEDCOMMENT',0x000036EF)
    win_const_mgr.add_const('SCESTATUS_SERVICE_NOT_SUPPORT',0x0000000E)
    win_const_mgr.add_const('PRINTER_ATTRIBUTE_WORK_OFFLINE',0x00000400)
    win_const_mgr.add_const('F_CLOSE',0x00000011)
    win_const_mgr.add_const('HDSIL_STATE',0x00000001)
    win_const_mgr.add_const('ERROR_NO_EFS',0x00001774)
    win_const_mgr.add_const('SV_LOCKVIOLATIONOFFSET_PARMNUM',0x00000238)
    win_const_mgr.add_const('INTERNET_AUTODIAL_FORCE_ONLINE',0x00000001)
    win_const_mgr.add_const('AM_GETDECODERCAP_QUERY_EVR_SUPPORT',0x00000007)
    win_const_mgr.add_const('BCRYPT_CIPHER_OPERATION',0x00000001)
    win_const_mgr.add_const('DFS_STORAGE_STATE_ONLINE',0x00000002)
    win_const_mgr.add_const('L2_NOTIFICATION_SOURCE_WLAN_MSM',0x00000000)
    win_const_mgr.add_const('SPI_GETFOREGROUNDLOCKTIMEOUT',0x00002000)
    win_const_mgr.add_const('DRM_AL_NONSILENT',0x00000001)
    win_const_mgr.add_const('ES_NOOLEDRAGDROP',0x00000008)
    win_const_mgr.add_const('COOKIE_OP_3RD_PARTY',0x00000020)
    win_const_mgr.add_const('IDD_CHANGEICONBROWSE',0x000003F3)
    win_const_mgr.add_const('IDM_BRINGTOFRONT',0x0000000B)
    win_const_mgr.add_const('REFERENCE_WHITE_MAX',0x00002710)
    win_const_mgr.add_const('D3DSTENCILCAPS_KEEP',0x00000001)
    win_const_mgr.add_const('CRYPT_GET_URL_FROM_UNAUTH_ATTRIBUTE',0x00000004)
    win_const_mgr.add_const('ERROR_PATCH_NOT_AVAILABLE',0xC00E4106)
    win_const_mgr.add_const('CRYPT_ALL_PROVIDERS',0x00000002)
    win_const_mgr.add_const('NULLREGION',0x00000001)
    win_const_mgr.add_const('TCP_MAXSEG',0x00000004)
    win_const_mgr.add_const('WM_GETFONT',0x00000031)
    win_const_mgr.add_const('HOTKEYF_CONTROL',0x00000002)
    win_const_mgr.add_const('SQL_TRUE',0x00000001)
    win_const_mgr.add_const('DOT11_ASSOC_STATUS_CANDIDATE_LIST_EXHAUSTED',0x00000006)
    win_const_mgr.add_const('SP_COPY_NOOVERWRITE',0x00000008)
    win_const_mgr.add_const('CAUSE_NO_ROUTE_TO_TRANSIT_NETWORK',0x00000002)
    win_const_mgr.add_const('ERROR_CLIENT_SERVER_PARAMETERS_INVALID',0x00000255)
    win_const_mgr.add_const('HTTP_LOG_FIELD_REASON',0x02000000)
    win_const_mgr.add_const('VT_BLOB_PROPSET',0x0000004B)
    win_const_mgr.add_const('SPFILENOTIFY_STARTDELETE',0x00000005)
    win_const_mgr.add_const('ERROR_DS_BAD_ATT_SCHEMA_SYNTAX',0x000020D0)
    win_const_mgr.add_const('RIM_INPUT',0x00000000)
    win_const_mgr.add_const('MCI_DGV_STATUS_KEY_COLOR',0x00004025)
    win_const_mgr.add_const('PRINTER_ENUM_CONTAINER',0x00008000)
    win_const_mgr.add_const('TVS_EDITLABELS',0x00000008)
    win_const_mgr.add_const('WMS_CONTAINER_IS_VBR',0x0000000F)
    win_const_mgr.add_const('SM_CYICON',0x0000000C)
    win_const_mgr.add_const('MEM_64M',0x04000000)
    win_const_mgr.add_const('SUBLANG_MALTESE_MALTA',0x00000001)
    win_const_mgr.add_const('MEM_64K',0x00010000)
    win_const_mgr.add_const('BG_E_INVALID_STATE',0x80200002)
    win_const_mgr.add_const('NSPROTO_SPX',0x000004E8)
    win_const_mgr.add_const('SQL_ACTIVE_STATEMENTS',0x00000001)
    win_const_mgr.add_const('TIME_PERIODIC',0x00000001)
    win_const_mgr.add_const('TOKEN_IMPERSONATE',0x00000004)
    win_const_mgr.add_const('TOKEN_ASSIGN_PRIMARY',0x00000001)
    win_const_mgr.add_const('BG_E_PROXY_BYPASS_LIST_TOO_LARGE',0x80200019)
    win_const_mgr.add_const('WM_QUERYNEWPALETTE',0x0000030F)
    win_const_mgr.add_const('RQ_EXECUTE_REQUEST_HANDLER',0x00000080)
    win_const_mgr.add_const('NETSETUP_JOIN_DC_ACCOUNT',0x00000200)
    win_const_mgr.add_const('RTCEF_USERSEARCH',0x00000800)
    win_const_mgr.add_const('HH_SET_GLOBAL_PROPERTY',0x00000000)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2TAO_SUPPORTEDWRITESPEEDDESCRIPTORS',0x00000114)
    win_const_mgr.add_const('LINETERMMODE_MEDIABIDIRECT',0x00000080)
    win_const_mgr.add_const('CMB_MASKED',0x00000002)
    win_const_mgr.add_const('ERROR_LOG_RESERVATION_INVALID',0x000019D7)
    win_const_mgr.add_const('DBTF_RESOURCE',0x00000001)
    win_const_mgr.add_const('WIA_DPS_DEVICE_ID',0x00000C2A)
    win_const_mgr.add_const('LINEADDRESSMODE_DIALABLEADDR',0x00000002)
    win_const_mgr.add_const('SCARD_PROTOCOL_OPTIMAL',0x00000000)
    win_const_mgr.add_const('DISPID_NAVIGATECOMPLETE',0x00000065)
    win_const_mgr.add_const('PDH_LOG_OPEN_EXISTING',0x00000004)
    win_const_mgr.add_const('IF_TYPE_ATM_DXI',0x00000069)
    win_const_mgr.add_const('KSPROPERTY_CAMERACONTROL_FLAGS_MANUAL',0x00000000)
    win_const_mgr.add_const('VK_OEM_2',0x000000BF)
    win_const_mgr.add_const('RF_DONTCARE',0x00000001)
    win_const_mgr.add_const('CONTEXT_E_FIRST',0x8004E000)
    win_const_mgr.add_const('MFE_OIF_PRUNED',0x00000005)
    win_const_mgr.add_const('ERROR_CTX_WINSTATIONS_DISABLED',0x00001B94)
    win_const_mgr.add_const('VK_OEM_3',0x000000C0)
    win_const_mgr.add_const('WMDM_FILE_ATTR_FILE',0x00000020)
    win_const_mgr.add_const('ERR_DISK_WRITE_ERROR',0xE0000005)
    win_const_mgr.add_const('LINEERR_INVALPARAM',0x80000032)
    win_const_mgr.add_const('IMAGE_SYM_CLASS_END_OF_STRUCT',0x00000066)
    win_const_mgr.add_const('MIXER_GETLINECONTROLSF_QUERYMASK',0x0000000F)
    win_const_mgr.add_const('GESTURE_SEMICIRCLE_LEFT',0x00000000)
    win_const_mgr.add_const('CDERR_LOADSTRFAILURE',0x00000005)
    win_const_mgr.add_const('AA_A_CREATE',0x00002000)
    win_const_mgr.add_const('CDEF_BYPASS_CLASS_MANAGER',0x00000002)
    win_const_mgr.add_const('NETSCAPE_SIGN_CA_CERT_TYPE',0x00000001)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_COLUMN_PRIVILEGES',0x00000006)
    win_const_mgr.add_const('LINEANSWERMODE_NONE',0x00000001)
    win_const_mgr.add_const('BCPKEEPNULLS',0x00000005)
    win_const_mgr.add_const('DEBUG_FORMAT_USER_SMALL_INDIRECT_MEMORY',0x00000008)
    win_const_mgr.add_const('TMT_OPACITY',0x0000097E)
    win_const_mgr.add_const('ERROR_ARBITRATION_UNHANDLED',0x000002D3)
    win_const_mgr.add_const('SECPKG_CRED_BOTH',0x00000003)
    win_const_mgr.add_const('MCI_SETVIDEO',0x00000876)
    win_const_mgr.add_const('FWP_ACTION_FLAG_CALLOUT',0x00004000)
    win_const_mgr.add_const('ENUM_SUCCESS',0x00000000)
    win_const_mgr.add_const('FILE_EXECUTE',0x00000020)
    win_const_mgr.add_const('PEER_TO_PEER_NODETYPE',0x00000002)
    win_const_mgr.add_const('ERROR_DS_CONSTRAINT_VIOLATION',0x0000202F)
    win_const_mgr.add_const('THREAD_SET_THREAD_TOKEN',0x00000080)
    win_const_mgr.add_const('SRCLIST_NOBROWSE',0x00000002)
    win_const_mgr.add_const('LVS_EX_SUBITEMIMAGES',0x00000002)
    win_const_mgr.add_const('MAX_INSTRUCTION_LEN',0x00000100)
    win_const_mgr.add_const('PDH_SQL_ROWCOUNT_FAILED',0xC0000BE4)
    win_const_mgr.add_const('CB_LIMITTEXT',0x00000141)
    win_const_mgr.add_const('DBPROPVAL_TI_CURSORSTABILITY',0x00001000)
    win_const_mgr.add_const('DSPROVIDER_ADVANCED',0x00000010)
    win_const_mgr.add_const('ERROR_PASSWORD_EXPIRED',0x00000532)
    win_const_mgr.add_const('IPV6_UNICAST_IF',0x0000001F)
    win_const_mgr.add_const('ELEMENT_STATUS_PVOLTAG',0x10000000)
    win_const_mgr.add_const('MODALS_DOMAIN_ID_PARMNUM',0x00000009)
    win_const_mgr.add_const('AF_ECMA',0x00000008)
    win_const_mgr.add_const('ERROR_SYSTEM_TRACE',0x00000096)
    win_const_mgr.add_const('RASLCPO_3_DES',0x00000010)
    win_const_mgr.add_const('MIXER_GETLINEINFOF_TARGETTYPE',0x00000004)
    win_const_mgr.add_const('DEBUG_STATUS_MASK',0x00000000)
    win_const_mgr.add_const('INTERNET_MAX_PORT_NUMBER_LENGTH',0x00000005)
    win_const_mgr.add_const('LINEAGENTSESSIONSTATUS_STATE',0x00000002)
    win_const_mgr.add_const('TBIF_APPEND',0x00000000)
    win_const_mgr.add_const('C1_SPACE',0x00000008)
    win_const_mgr.add_const('MEDIASINK_CANNOT_MATCH_CLOCK',0x00000002)
    win_const_mgr.add_const('ICMODE_DECOMPRESS',0x00000002)
    win_const_mgr.add_const('ERROR_DS_INTERNAL_FAILURE',0x000020EE)
    win_const_mgr.add_const('DVB_ST_PID_20',0x00000014)
    win_const_mgr.add_const('DISPID_EXPAND',0x00000019)
    win_const_mgr.add_const('DBIMF_NOMARGINS',0x00002000)
    win_const_mgr.add_const('ERROR_RESOURCE_ENUM_USER_STOP',0x00003B02)
    win_const_mgr.add_const('ERROR_CLUSTER_INVALID_REQUEST',0x000013B8)
    win_const_mgr.add_const('ERROR_DS_INSTALL_SCHEMA_MISMATCH',0x00002113)
    win_const_mgr.add_const('MCI_DGV_FF_JPEG',0x00004004)
    win_const_mgr.add_const('DPAS_INSERTAFTER',0x00000004)
    win_const_mgr.add_const('ERRCLASS_INTRN',0x00000004)
    win_const_mgr.add_const('TC_HARDERR',0x00000001)
    win_const_mgr.add_const('MF_TEST_SIGNED_COMPONENT_LOADING',0x01000000)
    win_const_mgr.add_const('PDH_SQL_CONNECT_FAILED',0xC0000BE6)
    win_const_mgr.add_const('CAC_FULL',0x00000000)
    win_const_mgr.add_const('SM_XVIRTUALSCREEN',0x0000004C)
    win_const_mgr.add_const('WIA_DATA_RAW_YUVK',0x00000009)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_ENLIST_PREPREPARE',0x00001000)
    win_const_mgr.add_const('SPI_SETCLIENTAREAANIMATION',0x00001043)
    win_const_mgr.add_const('DBFLAGS_LOGBUFFERSLARGE',0x00000040)
    win_const_mgr.add_const('MD_ERROR_SECURE_CHANNEL_FAILURE',0x800CC806)
    win_const_mgr.add_const('ERROR_TRANSACTION_OBJECT_EXPIRED',0x00001A42)
    win_const_mgr.add_const('DDENUMSURFACES_DOESEXIST',0x00000010)
    win_const_mgr.add_const('VDMEVENT_PM16',0x00000002)
    win_const_mgr.add_const('XP1_MESSAGE_ORIENTED',0x00000008)
    win_const_mgr.add_const('IMAGE_REL_BASED_MIPS_JMPADDR16',0x00000009)
    win_const_mgr.add_const('URL_APPLY_FORCEAPPLY',0x00000008)
    win_const_mgr.add_const('JIFMK_DHP',0x0000FFDE)
    win_const_mgr.add_const('ERROR_CTX_ACCOUNT_RESTRICTION',0x00001B98)
    win_const_mgr.add_const('ISDB_PCAT_TID',0x000000C2)
    win_const_mgr.add_const('JIFMK_DHT',0x0000FFC4)
    win_const_mgr.add_const('HDS_NOSIZING',0x00000800)
    win_const_mgr.add_const('DBG_MODMOVE',0x00000013)
    win_const_mgr.add_const('ISOPROTO_TP1',0x0000001A)
    win_const_mgr.add_const('D3DLINECAPS_ALPHACMP',0x00000008)
    win_const_mgr.add_const('CHECKSUM_MAP_FAILURE',0x00000002)
    win_const_mgr.add_const('TTS_BALLOON',0x00000040)
    win_const_mgr.add_const('SMC_INITMENU',0x00000001)
    win_const_mgr.add_const('VARIANT_NOVALUEPROP',0x00000001)
    win_const_mgr.add_const('ICW_MANUALPRESENT',0x00000002)
    win_const_mgr.add_const('FACILITY_DISPATCH',0x00000002)
    win_const_mgr.add_const('SEC_WINNT_AUTH_IDENTITY_ANSI',0x00000001)
    win_const_mgr.add_const('SHCDF_UPDATEITEM',0x00000001)
    win_const_mgr.add_const('ENUM_E_FIRST',0x800401B0)
    win_const_mgr.add_const('IP_TOS_SHIFT',0x00000001)
    win_const_mgr.add_const('LDAP_MODIFY_CMD',0x00000066)
    win_const_mgr.add_const('MXDCOP_SET_XPSPASSTHRU_MODE',0x00000020)
    win_const_mgr.add_const('MCI_VCR_SETVIDEO_RECORD',0x00010000)
    win_const_mgr.add_const('TSF_NORMAL',0x00000000)
    win_const_mgr.add_const('HIST_BACK',0x00000000)
    win_const_mgr.add_const('WINHTTP_OPTION_CONNECTION_INFO',0x0000005D)
    win_const_mgr.add_const('IME_PROP_UNICODE',0x00080000)
    win_const_mgr.add_const('FILE_ATTRIBUTE_TEMPORARY',0x00000100)
    win_const_mgr.add_const('SCARD_W_CARD_NOT_AUTHENTICATED',0x8010006F)
    win_const_mgr.add_const('CERT_STORE_SHARE_STORE_FLAG',0x00000040)
    win_const_mgr.add_const('SQL_NUMERIC',0x00000002)
    win_const_mgr.add_const('WIA_DIP_SERVER_NAME',0x00000008)
    win_const_mgr.add_const('WINHTTP_DISABLE_COOKIES',0x00000001)
    win_const_mgr.add_const('MD_ERROR_SUB403_SSL_REQUIRED',0x00000004)
    win_const_mgr.add_const('SMINIT_DROPONCONTAINER',0x00000400)
    win_const_mgr.add_const('EM_GETHANDLE',0x000000BD)
    win_const_mgr.add_const('INTERNET_AUTODIAL_FORCE_UNATTENDED',0x00000002)
    win_const_mgr.add_const('UISF_HIDEFOCUS',0x00000001)
    win_const_mgr.add_const('TF_CLUIE_COUNT',0x00000002)
    win_const_mgr.add_const('CSIDL_CONTROLS',0x00000003)
    win_const_mgr.add_const('WIA_DPA_DEVICE_TIME',0x00000404)
    win_const_mgr.add_const('SV_MDLREADSWITCHOVER_PARMNUM',0x0000023A)
    win_const_mgr.add_const('INTERNET_STATUS_FILTER_CLOSING',0x00000100)
    win_const_mgr.add_const('PHONESTATE_DISPLAY',0x00000020)
    win_const_mgr.add_const('PCR_ENTRY',0x00000000)
    win_const_mgr.add_const('LINEFEATURE_SETTERMINAL',0x00000020)
    win_const_mgr.add_const('CTRY_SOUTH_KOREA',0x00000052)
    win_const_mgr.add_const('ERROR_EC_CRED_NOT_FOUND',0x00003AEC)
    win_const_mgr.add_const('PAN_SERIF_THIN',0x00000007)
    win_const_mgr.add_const('BI_1632',0x32333631)
    win_const_mgr.add_const('MCI_DGV_SET_STILL',0x00040000)
    win_const_mgr.add_const('MD_CPU_DISABLE_ALL_LOGGING',0x00000000)
    win_const_mgr.add_const('TF_SFT_EXTRAICONSONMINIMIZED',0x00000200)
    win_const_mgr.add_const('LOCALE_SDURATION',0x00000005)
    win_const_mgr.add_const('MDPROPVAL_VISUAL_MODE_DEFAULT',0x00000000)
    win_const_mgr.add_const('SUBSMGRUPDATE_MINIMIZE',0x00000001)
    win_const_mgr.add_const('ERROR_PORT_UNREACHABLE',0x000004D2)
    win_const_mgr.add_const('IMAGE_SYM_CLASS_BIT_FIELD',0x00000012)
    win_const_mgr.add_const('MCGIF_NAME',0x00000004)
    win_const_mgr.add_const('MSDAIPP_MAX_URL_LENGTH',0x00001000)
    win_const_mgr.add_const('DNSSEC_KEY_FLAG_SIG4',0x00004000)
    win_const_mgr.add_const('DNSSEC_KEY_FLAG_SIG7',0x00007000)
    win_const_mgr.add_const('TTFCFP_FLAGS_COMPRESS',0x00000002)
    win_const_mgr.add_const('LIFF_FORCE_TEXT_FILTER_FALLBACK',0x00000003)
    win_const_mgr.add_const('DNSSEC_KEY_FLAG_SIG0',0x00000000)
    win_const_mgr.add_const('LINEPROXYREQUEST_GETAGENTSTATUS',0x00000005)
    win_const_mgr.add_const('CSA_GRAY',0x00000005)
    win_const_mgr.add_const('IP_CURSOR_DOWN',0x00000001)
    win_const_mgr.add_const('BF_ADJUST',0x00002000)
    win_const_mgr.add_const('COMP_TYPE_CFHTML',0x00000004)
    win_const_mgr.add_const('DNSSEC_KEY_FLAG_SIG9',0x00009000)
    win_const_mgr.add_const('DNSSEC_KEY_FLAG_SIG8',0x00008000)
    win_const_mgr.add_const('SI_RESET',0x00000020)
    win_const_mgr.add_const('REO_INPLACEACTIVE',0x02000000)
    win_const_mgr.add_const('LINECALLREASON_PARKED',0x00002000)
    win_const_mgr.add_const('IS_FULLSCREEN',0x00000002)
    win_const_mgr.add_const('PP_ENUMEX_SIGNING_PROT',0x00000028)
    win_const_mgr.add_const('IDM_COPYBACKGROUND',0x000008D9)
    win_const_mgr.add_const('TMT_TOCOLOR5',0x000007DA)
    win_const_mgr.add_const('TMT_TOCOLOR2',0x000007D7)
    win_const_mgr.add_const('DIRID_SYSTEM_X86',0x00004029)
    win_const_mgr.add_const('TMT_TOCOLOR1',0x000007D6)
    win_const_mgr.add_const('BAUD_7200',0x00000400)
    win_const_mgr.add_const('LBN_DBLCLK',0x00000002)
    win_const_mgr.add_const('RF_REQUIRESSEGMENTATIONBREAKING',0x00020000)
    win_const_mgr.add_const('SO_CONNDATALEN',0x00007004)
    win_const_mgr.add_const('DDE_FAPPSTATUS',0x00000000)
    win_const_mgr.add_const('IMAGE_FILE_MACHINE_EBC',0x00000EBC)
    win_const_mgr.add_const('SET_FEATURE_ON_THREAD_TRUSTED',0x00000020)
    win_const_mgr.add_const('SQL_CA1_POSITIONED_UPDATE',0x00002000)
    win_const_mgr.add_const('MDMEASURE_AGGR_VAR',0x00000006)
    win_const_mgr.add_const('IMAGE_DEBUG_TYPE_UNKNOWN',0x00000000)
    win_const_mgr.add_const('LVCDI_GROUP',0x00000001)
    win_const_mgr.add_const('DEFAULT_CHARSET',0x00000001)
    win_const_mgr.add_const('PRINTER_ERROR_WARNING',0x40000000)
    win_const_mgr.add_const('ERROR_CANTSCROLLBACKWARDS',0x00000303)
    win_const_mgr.add_const('MCI_OVLY_WINDOW_DISABLE_STRETCH',0x00200000)
    win_const_mgr.add_const('IDM_TRIED_EDITMODE',0x00000021)
    win_const_mgr.add_const('LOCALE_SENGCOUNTRY',0x00001002)
    win_const_mgr.add_const('LINEADDRFEATURE_SETMEDIACONTROL',0x00000008)
    win_const_mgr.add_const('NETSCAPE_SMIME_CERT_TYPE',0x00000020)
    win_const_mgr.add_const('REPLACE_PRIMARY',0x0000000A)
    win_const_mgr.add_const('MCI_DGV_STATUS_UNSAVED',0x00004017)
    win_const_mgr.add_const('COLOR_ACTIVECAPTION',0x00000002)
    win_const_mgr.add_const('CRYPT_LITTLE_ENDIAN',0x00000001)
    win_const_mgr.add_const('PXE_CALLBACK_RECV_REQUEST',0x00000000)
    win_const_mgr.add_const('SSPROP_DEFERPREPARE',0x0000000D)
    win_const_mgr.add_const('USN_REASON_FILE_DELETE',0x00000200)
    win_const_mgr.add_const('MDM_MASK_HDLCPPP_ML',0x00000003)
    win_const_mgr.add_const('HDN_FIRST',0x00000000)
    win_const_mgr.add_const('KSCREATE_ITEM_FREEONSTOP',0x00000008)
    win_const_mgr.add_const('NCBRECV',0x00000015)
    win_const_mgr.add_const('IMAGE_REL_M32R_ADDR32',0x00000001)
    win_const_mgr.add_const('CLFS_SCAN_INIT',0x00000001)
    win_const_mgr.add_const('ERROR_INVALID_MEDIA_POOL',0x000010CE)
    win_const_mgr.add_const('DBPROPVAL_FU_TABLE',0x00000004)
    win_const_mgr.add_const('XECI_DISABLE',0x00000000)
    win_const_mgr.add_const('DISPID_WINDOWREVOKED',0x000000C9)
    win_const_mgr.add_const('PPP_LCP_CHAP',0x0000C223)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_INVALID_FILTER',0x00003622)
    win_const_mgr.add_const('VP_CP_CMD_DEACTIVATE',0x00000002)
    win_const_mgr.add_const('MIXERCONTROL_CT_CLASS_SLIDER',0x40000000)
    win_const_mgr.add_const('DIB_RGB_COLORS',0x00000000)
    win_const_mgr.add_const('MD_DIRBROW_SHOW_DATE',0x00000002)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2RAWCD_SETWRITESPEED',0x00000205)
    win_const_mgr.add_const('DMPAPER_P32KBIG',0x0000005F)
    win_const_mgr.add_const('RPC_C_OPT_OPTIMIZE_TIME',0x00000010)
    win_const_mgr.add_const('XA_SWITCH_F_DTC',0x00000001)
    win_const_mgr.add_const('ERROR_CONNECTION_INVALID',0x000004CD)
    win_const_mgr.add_const('HOTKEYF_SHIFT',0x00000001)
    win_const_mgr.add_const('TAPE_SPACE_RELATIVE_BLOCKS',0x00000005)
    win_const_mgr.add_const('DBT_DEVICEARRIVAL',0x00008000)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_REFHI',0x0000000A)
    win_const_mgr.add_const('R2_NOTCOPYPEN',0x00000004)
    win_const_mgr.add_const('POLICY_ERRV_GLOBAL_GRP_PEAK_RATE',0x0000001A)
    win_const_mgr.add_const('VTBIT_CY',0x00000001)
    win_const_mgr.add_const('URLACTION_HTML_SUBFRAME_NAVIGATE',0x00001607)
    win_const_mgr.add_const('DRIVER_COMPATID_RANK',0x00003FFF)
    win_const_mgr.add_const('SQL_OU_PRIVILEGE_DEFINITION',0x00000010)
    win_const_mgr.add_const('CTRY_AUSTRALIA',0x0000003D)
    win_const_mgr.add_const('CTRY_NETHERLANDS',0x0000001F)
    win_const_mgr.add_const('WMDM_SCP_RIGHTS_DATA',0x00000040)
    win_const_mgr.add_const('MF_COMPONENT_INVALID_ROOT',0x00010000)
    win_const_mgr.add_const('CI_STATE_READING_USNS',0x00004000)
    win_const_mgr.add_const('FAST_TRANSLATE',0x00040000)
    win_const_mgr.add_const('PHONEERR_INIFILECORRUPT',0x90000005)
    win_const_mgr.add_const('SQL_CODE_DAY',0x00000003)
    win_const_mgr.add_const('ERROR_EVENTLOG_CANT_START',0x000005DD)
    win_const_mgr.add_const('DBPROP_MSREMOTE_SERVER',0x00000002)
    win_const_mgr.add_const('WMDM_POWER_CAP_BATTERY',0x00000001)
    win_const_mgr.add_const('ERROR_TRANSACTION_SUPERIOR_EXISTS',0x00001A35)
    win_const_mgr.add_const('RESOURCEDISPLAYTYPE_TREE',0x0000000A)
    win_const_mgr.add_const('DISPID_DHTMLEDITSCROLLBARS',0x0000000E)
    win_const_mgr.add_const('SELCERT_CERTLIST',0x00000066)
    win_const_mgr.add_const('MPR_INTERFACE_CONNECTION_FAILURE',0x00000004)
    win_const_mgr.add_const('ERROR_MCA_MCCS_VERSION_MISMATCH',0x00003B63)
    win_const_mgr.add_const('OID_GEN_RCV_LINK_SPEED',0x00010285)
    win_const_mgr.add_const('SYSFXUI_DONOTSHOW_SPEAKERFILLING',0x00000040)
    win_const_mgr.add_const('SQL_SSF_UPPER',0x00000004)
    win_const_mgr.add_const('DISPID_SEARCHCOMMAND_RESTORE',0x00000007)
    win_const_mgr.add_const('DATE_USE_ALT_CALENDAR',0x00000004)
    win_const_mgr.add_const('ETW_UINT16_TYPE_VALUE',0x00000006)
    win_const_mgr.add_const('FCW_PROGRESS',0x00000008)
    win_const_mgr.add_const('RTM_ROUTE_FLAGS_LOCAL_MCAST',0x00000200)
    win_const_mgr.add_const('SD_RECEIVE',0x00000000)
    win_const_mgr.add_const('ERROR_SUCCESS',0x00000000)
    win_const_mgr.add_const('HTTP_STATUS_OK',0x000000C8)
    win_const_mgr.add_const('CHANNEL_RC_NOT_OPEN',0x0000000A)
    win_const_mgr.add_const('LINEROAMMODE_UNAVAIL',0x00000002)
    win_const_mgr.add_const('PRINTER_ERROR_OUTOFPAPER',0x00000001)
    win_const_mgr.add_const('ICM_QUERY',0x00000003)
    win_const_mgr.add_const('PHONESTATE_HANDSETVOLUME',0x00000400)
    win_const_mgr.add_const('ERROR_EVT_VERSION_TOO_OLD',0x00003ABA)
    win_const_mgr.add_const('DXVA_HIGHLIGHT_BUFFER',0x0000000B)
    win_const_mgr.add_const('PHONEHOOKSWITCHMODE_ONHOOK',0x00000001)
    win_const_mgr.add_const('IPX_SERVICE_FILTER_PERMIT',0x00000001)
    win_const_mgr.add_const('PSNRET_MESSAGEHANDLED',0x00000003)
    win_const_mgr.add_const('SQL_FN_TSI_MINUTE',0x00000004)
    win_const_mgr.add_const('XEPR_REQUESTID',0x00000004)
    win_const_mgr.add_const('SV_MINLINKTHROUGHPUT_PARMNUM',0x00000229)
    win_const_mgr.add_const('CERT_CHAIN_ENABLE_CACHE_AUTO_UPDATE',0x00000010)
    win_const_mgr.add_const('SQL_GB_NOT_SUPPORTED',0x00000000)
    win_const_mgr.add_const('XBUTTON2',0x00000002)
    win_const_mgr.add_const('DVB_BAT_PID',0x00000011)
    win_const_mgr.add_const('STACK_SCRATCH_AREA',0x00000010)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_DATETIME',0x0000001F)
    win_const_mgr.add_const('CRYPTUI_WIZ_DIGITAL_SIGN_COMMERCIAL',0x00000001)
    win_const_mgr.add_const('META_OFFSETVIEWPORTORG',0x00000211)
    win_const_mgr.add_const('IP_PRECEDENCE_SHIFT',0x00000005)
    win_const_mgr.add_const('PORT_MSGAUTH',0x0000001F)
    win_const_mgr.add_const('JOB_NOTIFY_FIELD_NOTIFY_NAME',0x00000004)
    win_const_mgr.add_const('COD_LAN_MINOR_UNCLASSIFIED',0x00000000)
    win_const_mgr.add_const('BCOB_C',0x00000003)
    win_const_mgr.add_const('PROGRESS_CANCEL',0x00000001)
    win_const_mgr.add_const('CM_CREATE_DEVNODE_PHANTOM',0x00000002)
    win_const_mgr.add_const('SQL_SRVC_VALUE_EXPRESSION',0x00000001)
    win_const_mgr.add_const('PKR_RD',0x00000002)
    win_const_mgr.add_const('PHONEERR_BADDEVICEID',0x90000002)
    win_const_mgr.add_const('BCOB_X',0x00000010)
    win_const_mgr.add_const('RPC_S_CALL_FAILED_DNE',0x000006BF)
    win_const_mgr.add_const('MCI_WAVE_SET_CHANNELS',0x00020000)
    win_const_mgr.add_const('DSPRINT_UPDATE',0x00000002)
    win_const_mgr.add_const('MSIM_LIST_NOREF',0x00000010)
    win_const_mgr.add_const('WNODE_FLAG_PERSIST_EVENT',0x00000400)
    win_const_mgr.add_const('DUPLICATE_SAME_ACCESS',0x00000002)
    win_const_mgr.add_const('SM_MEDIACENTER',0x00000057)
    win_const_mgr.add_const('CBR_300',0x0000012C)
    win_const_mgr.add_const('IMAGE_SYM_CLASS_MEMBER_OF_ENUM',0x00000010)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_OPTION',0x00000485)
    win_const_mgr.add_const('RED_SHIFT',0x00000010)
    win_const_mgr.add_const('SQL_API_SQLALLOCENV',0x00000002)
    win_const_mgr.add_const('DN_MAXNODEL',0x00000007)
    win_const_mgr.add_const('TMT_ANIMATIONBUTTONRECT',0x0000138D)
    win_const_mgr.add_const('CR_PROP_CABACKWARDCROSSCERTSTATE',0x00000026)
    win_const_mgr.add_const('CRYPTNET_URL_CACHE_RESPONSE_NONE',0x00000000)
    win_const_mgr.add_const('RTCEF_WATCHER',0x00000200)
    win_const_mgr.add_const('INTERNET_OPEN_TYPE_PRECONFIG_WITH_NO_AUTOPROXY',0x00000004)
    win_const_mgr.add_const('SBSP_EXPLOREMODE',0x00000020)
    win_const_mgr.add_const('SQL_API_SQLDESCRIBEPARAM',0x0000003A)
    win_const_mgr.add_const('CBS_UPPERCASE',0x00002000)
    win_const_mgr.add_const('NTMS_APPLICATIONNAME_LENGTH',0x00000040)
    win_const_mgr.add_const('SQL_QUALIFIER_USAGE',0x0000005C)
    win_const_mgr.add_const('AE_SRVSTART',0x00000000)
    win_const_mgr.add_const('KERB_ETYPE_AES128_CTS_HMAC_SHA1_96',0x00000011)
    win_const_mgr.add_const('PHONEHOOKSWITCHDEV_SPEAKER',0x00000002)
    win_const_mgr.add_const('CFU_UNDERLINEDOUBLEWAVE',0x0000000B)
    win_const_mgr.add_const('ERROR_TRANSACTIONS_NOT_FROZEN',0x00001AB7)
    win_const_mgr.add_const('SUBLANG_FRISIAN_NETHERLANDS',0x00000001)
    win_const_mgr.add_const('CERT_UNICODE_RDN_ERR_INDEX_SHIFT',0x00000016)
    win_const_mgr.add_const('GESTURE_SCRATCHOUT',0x00000000)
    win_const_mgr.add_const('SQL_OPT_TRACE',0x00000068)
    win_const_mgr.add_const('ICM_SET_CALIBRATE_MODE',0x00000002)
    win_const_mgr.add_const('BIF_SHOWSIMILARDRIVERS',0x00000001)
    win_const_mgr.add_const('DBT_QUERYCHANGECONFIG',0x00000017)
    win_const_mgr.add_const('MD_BACKUP_OVERWRITE',0x00000001)
    win_const_mgr.add_const('EXITEVENT_CERTPENDING',0x00000002)
    win_const_mgr.add_const('FMEVENT_HELPMENUITEM',0x0000006B)
    win_const_mgr.add_const('MSV1_0_USER_SESSION_KEY_LENGTH',0x00000010)
    win_const_mgr.add_const('MQSEC_DELETE_MESSAGE',0x00000001)
    win_const_mgr.add_const('MIXER_SETCONTROLDETAILSF_CUSTOM',0x00000001)
    win_const_mgr.add_const('IDB_HIST_NORMAL',0x0000000C)
    win_const_mgr.add_const('SMC_CREATE',0x00000002)
    win_const_mgr.add_const('CRLF_IGNORE_CROSS_CERT_TRUST_ERROR',0x00000100)
    win_const_mgr.add_const('DNS_ERROR_NOT_ALLOWED_ON_RODC',0x00002561)
    win_const_mgr.add_const('CRYPT_KEYID_ALLOC_FLAG',0x00008000)
    win_const_mgr.add_const('MD_CPU_ENABLE_LOGGING',0x80000000)
    win_const_mgr.add_const('PPP_LCP_AES_256',0x00000080)
    win_const_mgr.add_const('RRF_RT_REG_MULTI_SZ',0x00000020)
    win_const_mgr.add_const('ATMPROTO_AAL1',0x00000001)
    win_const_mgr.add_const('ERROR_LOG_METADATA_INCONSISTENT',0x000019D6)
    win_const_mgr.add_const('TR_AR',0x00000009)
    win_const_mgr.add_const('VP_TV_STANDARD_SECAM_K1',0x00002000)
    win_const_mgr.add_const('CMS_SETPRINTERPROFILE',0x00000020)
    win_const_mgr.add_const('SUBLANG_XHOSA_SOUTH_AFRICA',0x00000001)
    win_const_mgr.add_const('LVIF_TEXT',0x00000001)
    win_const_mgr.add_const('DBT_DEVTYP_HANDLE',0x00000006)
    win_const_mgr.add_const('DSBI_RETURNOBJECTCLASS',0x01000000)
    win_const_mgr.add_const('D3DCAPS3_COPY_TO_VIDMEM',0x00000100)
    win_const_mgr.add_const('IDM_JUSTIFYFULL',0x00000032)
    win_const_mgr.add_const('RTM_NUM_CHANGE_TYPES',0x00000003)
    win_const_mgr.add_const('INTERNET_OPTION_CACHE_TIMESTAMPS',0x00000045)
    win_const_mgr.add_const('TMT_CAPTIONBARWIDTH',0x000004B4)
    win_const_mgr.add_const('RESETDEV',0x00000007)
    win_const_mgr.add_const('MSIM_DISPID_ONLOGOFF',0x00000E01)
    win_const_mgr.add_const('MKF_LEFTBUTTONDOWN',0x01000000)
    win_const_mgr.add_const('BAUD_134_5',0x00000004)
    win_const_mgr.add_const('NTDSCONN_OPT_USE_NOTIFY',0x00000001)
    win_const_mgr.add_const('MCI_VCR_LIST_VIDEO_SOURCE',0x00010000)
    win_const_mgr.add_const('NETLOGON_CONTROL_TRANSPORT_NOTIFY',0x00000007)
    win_const_mgr.add_const('FOF_NO_CONNECTED_ELEMENTS',0x00002000)
    win_const_mgr.add_const('WLX_SAS_TYPE_SC_INSERT',0x00000005)
    win_const_mgr.add_const('SETUP_DCOM_SECURITY_UPDATED_FLAG',0x00002000)
    win_const_mgr.add_const('ERROR_IMAGE_NOT_STRIPPED',0x00008800)
    win_const_mgr.add_const('RPC_INTERFACE_HAS_PIPES',0x00000001)
    win_const_mgr.add_const('WINEVENT_LEVEL_ERROR',0x00000002)
    win_const_mgr.add_const('DBPROP_INIT_CACHEAGGRESSIVELY',0x00000003)
    win_const_mgr.add_const('SSM_REFRESH',0x00000002)
    win_const_mgr.add_const('NIF_INFO',0x00000010)
    win_const_mgr.add_const('STRSAFE_NO_TRUNCATION',0x00001000)
    win_const_mgr.add_const('DC_FILEDEPENDENCIES',0x0000000E)
    win_const_mgr.add_const('BTNS_WHOLEDROPDOWN',0x00000080)
    win_const_mgr.add_const('DDLOCK_OKTOSWAP',0x00002000)
    win_const_mgr.add_const('PORT_FTPDATA',0x00000014)
    win_const_mgr.add_const('DISPID_EVPROPS_COUNT',0x00000064)
    win_const_mgr.add_const('PAN_STROKE_GRADUAL_HORZ',0x00000005)
    win_const_mgr.add_const('SCARD_SHARE_DIRECT',0x00000003)
    win_const_mgr.add_const('VPDF_DISABLEPWRSTATUSPOLL',0x00000008)
    win_const_mgr.add_const('VIDCF_COMPRESSFRAMES',0x00000008)
    win_const_mgr.add_const('MCI_VD_STEP_FRAMES',0x00010000)
    win_const_mgr.add_const('IDM_HTMLCONTAIN',0x0000086F)
    win_const_mgr.add_const('USN_REASON_NAMED_DATA_TRUNCATION',0x00000040)
    win_const_mgr.add_const('IDI_SHIELD',0x00007F06)
    win_const_mgr.add_const('GC_WCH_FSELECTED',0x40000000)
    win_const_mgr.add_const('MIB_IF_ADMIN_STATUS_TESTING',0x00000003)
    win_const_mgr.add_const('BCRYPT_ECDSA_PRIVATE_P384_MAGIC',0x34534345)
    win_const_mgr.add_const('SCS_WOW_BINARY',0x00000002)
    win_const_mgr.add_const('ENUM_TYPE_VERSION',0x00000300)
    win_const_mgr.add_const('IRLMP_EXCLUSIVE_MODE',0x00000014)
    win_const_mgr.add_const('URLMON_OPTION_USE_BINDSTRINGCREDS',0x10000008)
    win_const_mgr.add_const('PRF_ERASEBKGND',0x00000008)
    win_const_mgr.add_const('SQL_SSF_TRIM_TRAILING',0x00000080)
    win_const_mgr.add_const('ERROR_SET_POWER_STATE_FAILED',0x00000475)
    win_const_mgr.add_const('SL_MSCH_ZONE',0x0000C000)
    win_const_mgr.add_const('VER_PRODUCTMAJORVERSION',0x00000006)
    win_const_mgr.add_const('RTCRMF_PRESENCE_ROAMING',0x00000004)
    win_const_mgr.add_const('OID_GEN_GET_NETCARD_TIME',0x00020210)
    win_const_mgr.add_const('NABTS_BYTES_PER_LINE',0x00000024)
    win_const_mgr.add_const('SSPROP_FASTLOADOPTIONS',0x00000009)
    win_const_mgr.add_const('DMPAPER_FANFOLD_STD_GERMAN',0x00000028)
    win_const_mgr.add_const('D3DUSAGE_DEPTHSTENCIL',0x00000002)
    win_const_mgr.add_const('ERROR_CANNOT_LOAD_REGISTRY_FILE',0x0000024D)
    win_const_mgr.add_const('HTTP_STATUS_BAD_GATEWAY',0x000001F6)
    win_const_mgr.add_const('CONNECT_COMMANDLINE',0x00000800)
    win_const_mgr.add_const('DXVA_INVERSE_QUANTIZATION_MATRIX_BUFFER',0x00000005)
    win_const_mgr.add_const('BSM_VXDS',0x00000001)
    win_const_mgr.add_const('IO_ALIAS_12_BIT_DECODE',0x00000010)
    win_const_mgr.add_const('MD_WARNING_PATH_NOT_INSERTED',0x000CC807)
    win_const_mgr.add_const('SQL_ATTR_CONNECTION_TIMEOUT',0x00000071)
    win_const_mgr.add_const('PHONEERR_INUSE',0x90000006)
    win_const_mgr.add_const('CAUSE_DESTINATION_OUT_OF_ORDER',0x0000001B)
    win_const_mgr.add_const('MKF_MOUSEMODE',0x80000000)
    win_const_mgr.add_const('MCI_ANIM_WINDOW_DEFAULT',0x00000000)
    win_const_mgr.add_const('FILE_NOTIFY_CHANGE_SIZE',0x00000008)
    win_const_mgr.add_const('CMC_STATUS_SUCCESS',0x00000000)
    win_const_mgr.add_const('WIA_DPC_EFFECT_MODE',0x0000081D)
    win_const_mgr.add_const('STI_TRACE_ERROR',0x00000004)
    win_const_mgr.add_const('LDAP_SCOPE_ONELEVEL',0x00000001)
    win_const_mgr.add_const('ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND',0x00003AB9)
    win_const_mgr.add_const('D3DVTXPCAPS_TEXGEN',0x00000001)
    win_const_mgr.add_const('SQL_FN_STR_REPLACE',0x00000100)
    win_const_mgr.add_const('BCRYPT_ECDSA_PUBLIC_P384_MAGIC',0x33534345)
    win_const_mgr.add_const('KS_VBICAP_PROTECTION_MV_HARDWARE',0x00000002)
    win_const_mgr.add_const('ERROR_SEEK_ON_DEVICE',0x00000084)
    win_const_mgr.add_const('MD_CERT_NO_REVOC_CHECK',0x00000001)
    win_const_mgr.add_const('LINETRANSLATEOPTION_FORCELOCAL',0x00000004)
    win_const_mgr.add_const('DTBG_DRAWSOLID',0x00000002)
    win_const_mgr.add_const('DSOP_SCOPE_FLAG_DEFAULT_FILTER_USERS',0x00000040)
    win_const_mgr.add_const('CAL_SABBREVMONTHNAME3',0x00000024)
    win_const_mgr.add_const('TVE_COLLAPSERESET',0x00008000)
    win_const_mgr.add_const('IME_RS_SYSTEMMODAL',0x00000013)
    win_const_mgr.add_const('SQL_OAC_LEVEL1',0x00000001)
    win_const_mgr.add_const('SQL_FN_TD_DAYOFWEEK',0x00000008)
    win_const_mgr.add_const('PROPID_PC_BASE',0x000016A8)
    win_const_mgr.add_const('SQL_OAC_LEVEL2',0x00000002)
    win_const_mgr.add_const('DNS_TYPE_EID',0x00000001)
    win_const_mgr.add_const('CERT_CREATE_CONTEXT_NOCOPY_FLAG',0x00000001)
    win_const_mgr.add_const('LINEERR_NOCONFERENCE',0x80000041)
    win_const_mgr.add_const('ERROR_PROCESS_MODE_NOT_BACKGROUND',0x00000193)
    win_const_mgr.add_const('SAFER_POLICY_UIFLAGS_INFORMATION_PROMPT',0x00000001)
    win_const_mgr.add_const('CAL_SABBREVMONTHNAME6',0x00000027)
    win_const_mgr.add_const('IDM_BEGINUSERACTION',0x00000980)
    win_const_mgr.add_const('TMT_MINDPI4',0x00000977)
    win_const_mgr.add_const('KP_PUB_EX_LEN',0x0000001C)
    win_const_mgr.add_const('CAL_SABBREVMONTHNAME7',0x00000028)
    win_const_mgr.add_const('SAPI_ERROR_BASE',0x00005000)
    win_const_mgr.add_const('WIA_DATA_RAW_CMY',0x0000000A)
    win_const_mgr.add_const('PSBTN_NEXT',0x00000001)
    win_const_mgr.add_const('ERROR_RECEIVE_PARTIAL_EXPEDITED',0x000002C5)
    win_const_mgr.add_const('INTERNET_STATUS_FILTER_SENT',0x00000020)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_REGCLOSE',0x0000001B)
    win_const_mgr.add_const('FLAGS_ERROR_UI_FILTER_FOR_ERRORS',0x00000001)
    win_const_mgr.add_const('TMT_MINDPI3',0x00000976)
    win_const_mgr.add_const('DDSCAPS_RESERVED1',0x00000001)
    win_const_mgr.add_const('CR_FAILURE',0x00000013)
    win_const_mgr.add_const('DDSCAPS_RESERVED3',0x00000400)
    win_const_mgr.add_const('CM_REGISTRY_USER',0x00000100)
    win_const_mgr.add_const('QITIPF_DEFAULT',0x00000000)
    win_const_mgr.add_const('MAXLONG',0x00000007)
    win_const_mgr.add_const('IDM_REMOVEPARAFORMAT',0x000008CD)
    win_const_mgr.add_const('PORT_METAGRAM',0x00000063)
    win_const_mgr.add_const('IDC_UL_METER',0x00000405)
    win_const_mgr.add_const('SMC_NEWITEM',0x00000017)
    win_const_mgr.add_const('CRL_REASON_CESSATION_OF_OPERATION',0x00000005)
    win_const_mgr.add_const('SDP_ATTRIB_PROFILE_SPECIFIC',0x00000200)
    win_const_mgr.add_const('SHFMT_OPT_FULL',0x00000001)
    win_const_mgr.add_const('TSF_USE_FULL_ACCESS',0x00000040)
    win_const_mgr.add_const('ERROR_RESMON_CREATE_FAILED',0x00001399)
    win_const_mgr.add_const('CERT_LDAP_STORE_AREC_EXCLUSIVE_FLAG',0x00020000)
    win_const_mgr.add_const('SCARD_E_CANCELLED',0x80100002)
    win_const_mgr.add_const('LINEERR_INVALREQUESTMODE',0x80000038)
    win_const_mgr.add_const('VIEW_PRIORITY_USEASDEFAULT',0x00000043)
    win_const_mgr.add_const('PROXY_TYPE_PROXY',0x00000002)
    win_const_mgr.add_const('FLG_DELREG_VALUE',0x00000000)
    win_const_mgr.add_const('DXVA_EXECUTE_RETURN_DATA_ERROR_MINOR',0x00000001)
    win_const_mgr.add_const('CSIDL_FONTS',0x00000014)
    win_const_mgr.add_const('MCI_DGV_SAVE_ABORT',0x00020000)
    win_const_mgr.add_const('TSPI_PROC_BASE',0x000001F4)
    win_const_mgr.add_const('VER_ERR_EXCEP_NUM_2',0x00000020)
    win_const_mgr.add_const('DNS_CLASS_INTERNET',0x00000001)
    win_const_mgr.add_const('PRINTER_STATUS_WAITING',0x00002000)
    win_const_mgr.add_const('PORT_OSUNMS',0x000000C0)
    win_const_mgr.add_const('WM_MOUSELEAVE',0x000002A3)
    win_const_mgr.add_const('SCRIPTSTAT_INSTRUCTION_COUNT',0x00000002)
    win_const_mgr.add_const('LVNI_SAMEGROUPONLY',0x00000080)
    win_const_mgr.add_const('PSF_SELECTPASTE',0x00000002)
    win_const_mgr.add_const('PLATFORM_ID_OSF',0x00000258)
    win_const_mgr.add_const('LVFIF_TEXT',0x00000001)
    win_const_mgr.add_const('IMAGE_REL_MIPS_GPREL',0x00000006)
    win_const_mgr.add_const('TXTLOG_DEPTH_DECR',0x00040000)
    win_const_mgr.add_const('AM_DVD_NOT_COPYRIGHTED',0x00000000)
    win_const_mgr.add_const('SW_SHOWDEFAULT',0x0000000A)
    win_const_mgr.add_const('SP_PROT_SSL2_SERVER',0x00000004)
    win_const_mgr.add_const('DDENUMSURFACES_CANBECREATED',0x00000008)
    win_const_mgr.add_const('VHDR_INQUEUE',0x00000004)
    win_const_mgr.add_const('PORT_RFILE',0x000002EE)
    win_const_mgr.add_const('ACMDRIVERDETAILS_SUPPORTF_HARDWARE',0x00000008)
    win_const_mgr.add_const('BG_E_ERROR_CONTEXT_REMOTE_FILE',0x8020000A)
    win_const_mgr.add_const('RTCSI_APPLICATION',0x00000020)
    win_const_mgr.add_const('SYMOPT_FAVOR_COMPRESSED',0x00800000)
    win_const_mgr.add_const('REG_QWORD_LITTLE_ENDIAN',0x0000000B)
    win_const_mgr.add_const('BAUD_1800',0x00000080)
    win_const_mgr.add_const('MSV1_0_TRY_SPECIFIED_DOMAIN_ONLY',0x00000400)
    win_const_mgr.add_const('ERROR_SYSTEM_SHUTDOWN',0x00000281)
    win_const_mgr.add_const('ALINF_UPDHLPDLLS',0x00000010)
    win_const_mgr.add_const('SQL_CCS_COLLATE_CLAUSE',0x00000002)
    win_const_mgr.add_const('HAL_RID',0x00000002)
    win_const_mgr.add_const('MCS_SHORTDAYSOFWEEK',0x00000080)
    win_const_mgr.add_const('WIA_IPS_ORIENTATION',0x0000180C)
    win_const_mgr.add_const('CRL_FIND_ISSUED_BY_BASE_FLAG',0x00000008)
    win_const_mgr.add_const('IDABORT',0x00000003)
    win_const_mgr.add_const('NDIS_802_11_AUTH_REQUEST_AUTH_FIELDS',0x00000000)
    win_const_mgr.add_const('CB_GETCOUNT',0x00000146)
    win_const_mgr.add_const('SQL_CB_DELETE',0x00000000)
    win_const_mgr.add_const('CRL_REASON_REMOVE_FROM_CRL',0x00000008)
    win_const_mgr.add_const('NTDSSETTINGS_OPT_IS_SCHEDULE_HASHING_ENABLED',0x00000001)
    win_const_mgr.add_const('CRYPT_MODE_OFBP',0x00000008)
    win_const_mgr.add_const('ERROR_QUORUMLOG_OPEN_FAILED',0x000013A4)
    win_const_mgr.add_const('IMGDECODE_EVENT_PALETTE',0x00000002)
    win_const_mgr.add_const('TRUST_TYPE_MIT',0x00000003)
    win_const_mgr.add_const('SQL_FN_TD_CURRENT_TIME',0x00040000)
    win_const_mgr.add_const('PPP_CCP_COMPRESSION',0x00000001)
    win_const_mgr.add_const('D3DPTFILTERCAPS_MINFLINEAR',0x00000200)
    win_const_mgr.add_const('MC_CAPS_CONTRAST',0x00000004)
    win_const_mgr.add_const('PRINTER_ENUM_REMOTE',0x00000010)
    win_const_mgr.add_const('LOCALE_IDEFAULTMACCODEPAGE',0x00001011)
    win_const_mgr.add_const('PSD_ENABLEPAGEPAINTHOOK',0x00040000)
    win_const_mgr.add_const('SQL_AF_MAX',0x00000004)
    win_const_mgr.add_const('NDIS_MAC_OPTION_TRANSFERS_NOT_PEND',0x00000004)
    win_const_mgr.add_const('DXVA_BIDIRECTIONAL_AVERAGING_MPEG2_ROUND',0x00000000)
    win_const_mgr.add_const('BLLI_L3_PACKET_512',0x00000009)
    win_const_mgr.add_const('CTRY_COLOMBIA',0x00000039)
    win_const_mgr.add_const('CAL_SABBREVDAYNAME5',0x00000012)
    win_const_mgr.add_const('PSINJECT_PAGEORDER',0x00000007)
    win_const_mgr.add_const('INTERNET_STATUS_FILTER_CONNECTING',0x00000004)
    win_const_mgr.add_const('BTH_ERROR_REMOTE_USER_ENDED_CONNECTION',0x00000013)
    win_const_mgr.add_const('AUDIO_CHANNELCOUNT_MONO',0x00000001)
    win_const_mgr.add_const('IITWBC_BREAKTYPE_DATE',0x00000002)
    win_const_mgr.add_const('URLPOLICY_QUERY',0x00000001)
    win_const_mgr.add_const('SQL_CA1_POSITIONED_DELETE',0x00004000)
    win_const_mgr.add_const('SHFMT_OPT_SYSONLY',0x00000002)
    win_const_mgr.add_const('DSOP_FILTER_DOMAIN_LOCAL_GROUPS_DL',0x00000100)
    win_const_mgr.add_const('CTRY_BELARUS',0x00000177)
    win_const_mgr.add_const('LINEREQUESTMODE_DROP',0x00000004)
    win_const_mgr.add_const('SMC_GETOBJECT',0x00000007)
    win_const_mgr.add_const('DDSCAPS2_D3DTEXTUREMANAGE',0x00020000)
    win_const_mgr.add_const('SHGFI_USEFILEATTRIBUTES',0x00000010)
    win_const_mgr.add_const('OID_802_5_CURRENT_RING_STATUS',0x02010106)
    win_const_mgr.add_const('PORT_PCSERVER',0x00000258)
    win_const_mgr.add_const('ERROR_SHARING_PAUSED',0x00000046)
    win_const_mgr.add_const('HTTP_QUERY_URI',0x0000000D)
    win_const_mgr.add_const('ERROR_BAD_UNIT',0x00000014)
    win_const_mgr.add_const('FILE_BEGIN',0x00000000)
    win_const_mgr.add_const('WCS_ALWAYS',0x00200000)
    win_const_mgr.add_const('DISPID_SYNCHRONIZE',0x00000005)
    win_const_mgr.add_const('ALG_SID_HMAC',0x00000009)
    win_const_mgr.add_const('FORMAT_MESSAGE_FROM_STRING',0x00000400)
    win_const_mgr.add_const('FLG_ADDPROPERTY_OVERWRITEONLY',0x00000002)
    win_const_mgr.add_const('PRIVATEOBJECT_CALLID',0x00000002)
    win_const_mgr.add_const('COLOR_NO_TRANSPARENT',0xFFFFFFFF)
    win_const_mgr.add_const('LB_MULTIPLEADDSTRING',0x000001B1)
    win_const_mgr.add_const('INDEX_GUID_ALIGNMENTLEVEL',0x00000003)
    win_const_mgr.add_const('BS_PATTERN8X8',0x00000007)
    win_const_mgr.add_const('IDS_CAP_NO_FRAME_CAP_ERROR',0x000001B2)
    win_const_mgr.add_const('CERT_TRUST_HAS_KEY_MATCH_ISSUER',0x00000002)
    win_const_mgr.add_const('RI_MOUSE_BUTTON_4_DOWN',0x00000040)
    win_const_mgr.add_const('CERT_NAME_URL_TYPE',0x00000007)
    win_const_mgr.add_const('SQL_DRIVER_NAME',0x00000006)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_NO_PEER_CERT',0x00003617)
    win_const_mgr.add_const('WT_TRUSTDBDIALOG_WRITE_IEAK_STORE_FLAG',0x00000200)
    win_const_mgr.add_const('PARTITION_ENTRY_UNUSED',0x00000000)
    win_const_mgr.add_const('CO_S_LAST',0x000401FF)
    win_const_mgr.add_const('PIDSI_WORDCOUNT',0x00000000)
    win_const_mgr.add_const('SFVM_REMOVEOBJECT',0x00000006)
    win_const_mgr.add_const('INTERNET_OPTION_SOCKET_SEND_BUFFER_LENGTH',0x0000005E)
    win_const_mgr.add_const('GET_TAPE_DRIVE_INFORMATION',0x00000001)
    win_const_mgr.add_const('DEBUG_MANAGED_DISABLED',0x00000000)
    win_const_mgr.add_const('EC_OLE_EVENT',0x00000018)
    win_const_mgr.add_const('RGB_GAMMA_MIN',0x000009C4)
    win_const_mgr.add_const('USE_LOTS_OF_FORCE',0x00000002)
    win_const_mgr.add_const('PROTO_VENDOR_MS2',0x00003FFF)
    win_const_mgr.add_const('WINSTA_READATTRIBUTES',0x00000002)
    win_const_mgr.add_const('PROTO_VENDOR_MS0',0x00000000)
    win_const_mgr.add_const('PROTO_VENDOR_MS1',0x00000137)
    win_const_mgr.add_const('D3DFVF_NORMAL',0x00000010)
    win_const_mgr.add_const('OID_ATM_RCV_CELLS_DROPPED',0x08020103)
    win_const_mgr.add_const('DISPID_EXPLORERWINDOWREADY',0x000000DD)
    win_const_mgr.add_const('DBTYPE_SQLVARIANT',0x00000090)
    win_const_mgr.add_const('KEY_WOW64_32KEY',0x00000200)
    win_const_mgr.add_const('DIRID_USERPROFILE',0x00000035)
    win_const_mgr.add_const('REVISION_LENGTH',0x00000004)
    win_const_mgr.add_const('OID_TAPI_SET_STATUS_MESSAGES',0x07030122)
    win_const_mgr.add_const('DDPCAPS_PRIMARYSURFACELEFT',0x00000020)
    win_const_mgr.add_const('IF_TYPE_HYPERCHANNEL',0x0000000E)
    win_const_mgr.add_const('SC_DLG_NO_UI',0x00000002)
    win_const_mgr.add_const('NETINFO_DISKRED',0x00000004)
    win_const_mgr.add_const('ERROR_DS_DUP_MAPI_ID',0x000020BC)
    win_const_mgr.add_const('CMF_VERBSONLY',0x00000002)
    win_const_mgr.add_const('ERROR_CANNOT_COPY',0x0000010A)
    win_const_mgr.add_const('DMDITHER_ERRORDIFFUSION',0x00000005)
    win_const_mgr.add_const('MRINFO_TUNNEL_FLAG',0x00000001)
    win_const_mgr.add_const('MD_ERROR_SUB404_FILE_EXTENSION_DENIED',0x00000007)
    win_const_mgr.add_const('END_SYSTEM_CHANGE',0x00000065)
    win_const_mgr.add_const('GCPCLASS_POSTBOUNDRTL',0x00000010)
    win_const_mgr.add_const('DC_SMALLCAP',0x00000002)
    win_const_mgr.add_const('GET_FEATURE_FROM_THREAD',0x00000001)
    win_const_mgr.add_const('RI_MOUSE_BUTTON_5_DOWN',0x00000100)
    win_const_mgr.add_const('RPC_S_INVALID_STRING_UUID',0x000006A9)
    win_const_mgr.add_const('ERROR_SXS_SECTION_NOT_FOUND',0x000036B0)
    win_const_mgr.add_const('NCRYPT_OVERWRITE_KEY_FLAG',0x00000080)
    win_const_mgr.add_const('BLUETOOTH_MAX_PASSKEY_SIZE',0x00000010)
    win_const_mgr.add_const('SPLITSYM_EXTRACT_ALL',0x00000002)
    win_const_mgr.add_const('SEC_IMAGE',0x01000000)
    win_const_mgr.add_const('POLICY_LOOKUP_NAMES',0x00000800)
    win_const_mgr.add_const('SPSVCINST_DELETEEVENTLOGENTRY',0x00000004)
    win_const_mgr.add_const('KERB_ETYPE_DES_CBC_MD4',0x00000002)
    win_const_mgr.add_const('ALINF_DELAYREGISTEROCX',0x00000200)
    win_const_mgr.add_const('PDCAP_WAKE_FROM_D2_SUPPORTED',0x00000040)
    win_const_mgr.add_const('URL_APPLY_DEFAULT',0x00000001)
    win_const_mgr.add_const('DSOBJECT_READONLYPAGES',0x80000000)
    win_const_mgr.add_const('CROSS_CERT_DIST_POINT_ERR_INDEX_SHIFT',0x00000018)
    win_const_mgr.add_const('OPATH_TOK_EOF',0x00000000)
    win_const_mgr.add_const('MFASYNC_CALLBACK_QUEUE_STANDARD',0x00000001)
    win_const_mgr.add_const('CB_MAX_CAB_PATH',0x00000100)
    win_const_mgr.add_const('IF_TYPE_ESCON',0x00000049)
    win_const_mgr.add_const('ENABLE_MOUSE_INPUT',0x00000010)
    win_const_mgr.add_const('DISPID_VIEWPAINTDONE',0x000000D3)
    win_const_mgr.add_const('LINEERR_INVALPASSWORD',0x80000059)
    win_const_mgr.add_const('LGRPID_SIMPLIFIED_CHINESE',0x00000000)
    win_const_mgr.add_const('FMEVENT_SELCHANGE',0x00000068)
    win_const_mgr.add_const('MCI_VCR_STATUS_COUNTER_VALUE',0x00004013)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_SRVQUERYCRED',0x00003620)
    win_const_mgr.add_const('EVENT_SYSTEM_SCROLLINGEND',0x00000013)
    win_const_mgr.add_const('JOY_BUTTON1',0x00000001)
    win_const_mgr.add_const('JOY_BUTTON2',0x00000002)
    win_const_mgr.add_const('JOY_BUTTON3',0x00000004)
    win_const_mgr.add_const('JOY_BUTTON4',0x00000008)
    win_const_mgr.add_const('JOY_BUTTON5',0x00000010)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_FOCUS',0x00000486)
    win_const_mgr.add_const('JOY_BUTTON7',0x00000040)
    win_const_mgr.add_const('JOY_BUTTON8',0x00000080)
    win_const_mgr.add_const('JOY_BUTTON9',0x00000100)
    win_const_mgr.add_const('MCI_DGV_SETAUDIO_SRC_RIGHT_S',0x00008021)
    win_const_mgr.add_const('USE_DOMAINNAME_PARMNUM',0x00000006)
    win_const_mgr.add_const('IDM_SETCUSTOMCURSOR',0x00000982)
    win_const_mgr.add_const('GD_FONTDIR',0x00000007)
    win_const_mgr.add_const('MIXERCONTROL_CT_SC_LIST_MULTIPLE',0x01000000)
    win_const_mgr.add_const('PRINTER_STATUS_BUSY',0x00000200)
    win_const_mgr.add_const('PHOTO_PHOTOMETRIC_RGB',0x00000002)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_SETTIMEOUT',0x00000494)
    win_const_mgr.add_const('SUBLANG_ARABIC_JORDAN',0x00000000)
    win_const_mgr.add_const('NUM_EISA_RANGES',0x00000004)
    win_const_mgr.add_const('PRIVATEOBJECT_LINE',0x00000003)
    win_const_mgr.add_const('CF_ENABLETEMPLATEHANDLE',0x00000020)
    win_const_mgr.add_const('DSSSF_DSAVAILABLE',0x80000000)
    win_const_mgr.add_const('SDP_ATTRIB_DOCUMENTATION_URL',0x0000000A)
    win_const_mgr.add_const('KSNODEPIN_DEMUX_OUT',0x00000001)
    win_const_mgr.add_const('EMO_EXPAND',0x00000003)
    win_const_mgr.add_const('SI_NETWORK',0x00000003)
    win_const_mgr.add_const('POLICY_ERRV_GLOBAL_DEF_PEAK_RATE',0x00000019)
    win_const_mgr.add_const('SNMP_LOG_WARNING',0x00000003)
    win_const_mgr.add_const('SCRIPT_ENCODE_NO_ASP_LANGUAGE',0x00000002)
    win_const_mgr.add_const('SERIAL_IOC_FCR_XMIT_RESET',0x00000004)
    win_const_mgr.add_const('WLX_SAS_TYPE_SC_FIRST_READER_ARRIVED',0x00000008)
    win_const_mgr.add_const('HTTP_LOG_FIELD_VERSION',0x00080000)
    win_const_mgr.add_const('SECPKG_ATTR_SUPPORTED_PROTOCOLS',0x00000058)
    win_const_mgr.add_const('REQDISP_USEREQUESTATTRIBUTE',0x00000003)
    win_const_mgr.add_const('BTH_ERROR_INVALID_HCI_PARAMETER',0x00000012)
    win_const_mgr.add_const('JOY_RETURNRAWDATA',0x00000100)
    win_const_mgr.add_const('LINEMEDIAMODE_VOICEVIEW',0x00004000)
    win_const_mgr.add_const('DXVA_PICTURE_DECODING_FUNCTION',0x00000001)
    win_const_mgr.add_const('NRC_PENDING',0x00000000)
    win_const_mgr.add_const('HS_CROSS',0x00000004)
    win_const_mgr.add_const('CSA_DEF',0x00000003)
    win_const_mgr.add_const('ERROR_VOLSNAP_HIBERNATE_READY',0x000002F9)
    win_const_mgr.add_const('WMDRM_LICENSE_TYPE_XML',0x00000001)
    win_const_mgr.add_const('CSTR_GREATER_THAN',0x00000003)
    win_const_mgr.add_const('DISPID_SELECTIONCHANGED',0x000000C8)
    win_const_mgr.add_const('KP_KEYEXCHANGE_PIN',0x00000020)
    win_const_mgr.add_const('HTTP_RECEIVE_REQUEST_ENTITY_BODY_FLAG_FILL_BUFFER',0x00000001)
    win_const_mgr.add_const('FTPWPP_ERROR_LAST',0x400423FF)
    win_const_mgr.add_const('ES_DISPLAY_REQUIRED',0x00000002)
    win_const_mgr.add_const('SBARS_TOOLTIPS',0x00000800)
    win_const_mgr.add_const('RBBIM_HEADERSIZE',0x00000800)
    win_const_mgr.add_const('NETWORK_ALIVE_AOL',0x00000004)
    win_const_mgr.add_const('IMAGE_SCN_CNT_CODE',0x00000020)
    win_const_mgr.add_const('KSPIN_FLAG_DENY_USERMODE_ACCESS',0x80000000)
    win_const_mgr.add_const('ERROR_DATA_LOST_REPAIR',0x00001ABB)
    win_const_mgr.add_const('IMAGE_FILE_MACHINE_WCEMIPSV2',0x00000169)
    win_const_mgr.add_const('SQL_LOCK_TYPES',0x0000004E)
    win_const_mgr.add_const('CDERR_STRUCTSIZE',0x00000001)
    win_const_mgr.add_const('D3DTEXOPCAPS_MODULATE4X',0x00000020)
    win_const_mgr.add_const('DDSCAPS_3DDEVICE',0x00002000)
    win_const_mgr.add_const('AD_FLAG_BREAK_BIT',0x00000001)
    win_const_mgr.add_const('CBR_110',0x0000006E)
    win_const_mgr.add_const('ASC_RET_NO_TOKEN',0x01000000)
    win_const_mgr.add_const('BTH_ADDR_IAC_FIRST',0x009E8B00)
    win_const_mgr.add_const('RTM_ENUM_OWN_DESTS',0x01000000)
    win_const_mgr.add_const('HTTP_STATUS_NONE_ACCEPTABLE',0x00000196)
    win_const_mgr.add_const('MD_NOTIFY_SEND_RAW_DATA',0x00000400)
    win_const_mgr.add_const('TF_DISABLE_COMMANDING',0x00000004)
    win_const_mgr.add_const('DISABLE_CPL_FIX',0x00000006)
    win_const_mgr.add_const('ERROR_WAIT_63',0x000002DE)
    win_const_mgr.add_const('ERROR_DS_DRA_ABANDON_SYNC',0x0000210E)
    win_const_mgr.add_const('PROV_INTEL_SEC',0x00000016)
    win_const_mgr.add_const('IF_TYPE_ATM_IMA',0x0000006B)
    win_const_mgr.add_const('MDM_BEARERMODE_ANALOG',0x00000000)
    win_const_mgr.add_const('SCH_CRED_NO_SERVERNAME_CHECK',0x00000004)
    win_const_mgr.add_const('ERROR_CTX_SERVICE_NAME_COLLISION',0x00001B5E)
    win_const_mgr.add_const('SERVICE_STOP_REASON_FLAG_UNPLANNED',0x10000000)
    win_const_mgr.add_const('IDM_TRIED_SEND_TO_BACK',0x00000006)
    win_const_mgr.add_const('MCI_QUALITY_NAME',0x00020000)
    win_const_mgr.add_const('CM_DETECT_NEW_PROFILE',0x00000001)
    win_const_mgr.add_const('TRUSTERROR_STEP_FILEIO',0x00000002)
    win_const_mgr.add_const('SECPKG_OPTIONS_TYPE_SSPI',0x00000002)
    win_const_mgr.add_const('TF_MOD_CONTROL',0x00000002)
    win_const_mgr.add_const('PSR_AC',0x00000003)
    win_const_mgr.add_const('LINECALLPARTYID_BLOCKED',0x00000001)
    win_const_mgr.add_const('CERT_CHAIN_CACHE_ONLY_URL_RETRIEVAL',0x00000004)
    win_const_mgr.add_const('MM_JOY1BUTTONUP',0x000003B7)
    win_const_mgr.add_const('HTTP_STATUS_NOT_MODIFIED',0x00000130)
    win_const_mgr.add_const('SDP_ATTRIB_DI_PRODUCT_ID',0x00000202)
    win_const_mgr.add_const('PORT_CHSHELL',0x00000232)
    win_const_mgr.add_const('REPL_ROLE_BOTH',0x00000003)
    win_const_mgr.add_const('DFS_VOLUME_FLAVOR_STANDALONE',0x00000100)
    win_const_mgr.add_const('FOCUSMETERING_MULTISPOT',0x00000002)
    win_const_mgr.add_const('DFS_STORAGE_FLAVOR_UNUSED2',0x00000300)
    win_const_mgr.add_const('GOPHER_TYPE_SOUND',0x00010000)
    win_const_mgr.add_const('ALG_SID_3DES_112',0x00000009)
    win_const_mgr.add_const('URLPOLICY_LOG_ON_DISALLOW',0x00000080)
    win_const_mgr.add_const('CAL_SSHORTESTDAYNAME4',0x00000034)
    win_const_mgr.add_const('CAL_SSHORTESTDAYNAME5',0x00000035)
    win_const_mgr.add_const('CAL_SSHORTESTDAYNAME6',0x00000036)
    win_const_mgr.add_const('CAL_SSHORTESTDAYNAME7',0x00000037)
    win_const_mgr.add_const('IDM_DELETEWORD',0x0000005C)
    win_const_mgr.add_const('CAL_SSHORTESTDAYNAME1',0x00000031)
    win_const_mgr.add_const('REPLACE_ALTERNATE',0x0000000B)
    win_const_mgr.add_const('DRM_AL_CANCEL',0x00000004)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_LOCATION',0x0000000E)
    win_const_mgr.add_const('KSPROPERTY_MEMBER_FLAG_BASICSUPPORT_MULTICHANNEL',0x00000002)
    win_const_mgr.add_const('STATEBITS_FLAT',0x00000001)
    win_const_mgr.add_const('HTTP_QUERY_EXPIRES',0x0000000A)
    win_const_mgr.add_const('MEM_COMMIT',0x00001000)
    win_const_mgr.add_const('DMBIN_LOWER',0x00000002)
    win_const_mgr.add_const('USE_PAUSED',0x00000001)
    win_const_mgr.add_const('WIA_IPA_ACCESS_RIGHTS',0x00001006)
    win_const_mgr.add_const('SBSP_FEEDNAVIGATION',0x20000000)
    win_const_mgr.add_const('D3DCOMPOSERECTS_MAXNUMRECTS',0x0000FFFF)
    win_const_mgr.add_const('MCMV_YEAR',0x00000001)
    win_const_mgr.add_const('INTERNET_STATUS_CONNECTING_TO_SERVER',0x00000014)
    win_const_mgr.add_const('USER_PRIV_MASK',0x00000003)
    win_const_mgr.add_const('MIDIPROP_GET',0x40000000)
    win_const_mgr.add_const('CRYPT_OWF_REPL_LM_HASH',0x00000001)
    win_const_mgr.add_const('SSF_NONETCRAWLING',0x00100000)
    win_const_mgr.add_const('DN_MAXALIASL',0x00000080)
    win_const_mgr.add_const('DNS_RTYPE_AAAA',0x00000001)
    win_const_mgr.add_const('X3_TMPLT_SIZE_X',0x00000004)
    win_const_mgr.add_const('INTERNET_OPTION_BYPASS_EDITED_ENTRY',0x00000040)
    win_const_mgr.add_const('CERT_BIOMETRIC_SIGNATURE_TYPE',0x00000001)
    win_const_mgr.add_const('TF_IPP_FLAG_SUBSTITUTEDBYINPUTPROCESSOR',0x00000004)
    win_const_mgr.add_const('ERRACT_PANIC',0x00000005)
    win_const_mgr.add_const('OBM_REDUCE',0x00007FED)
    win_const_mgr.add_const('NTDSSETTINGS_OPT_IS_TOPL_MIN_HOPS_DISABLED',0x00000001)
    win_const_mgr.add_const('WINHTTP_CALLBACK_STATUS_CONNECTION_CLOSED',0x00000200)
    win_const_mgr.add_const('SPSVCINST_STARTSERVICE',0x00000800)
    win_const_mgr.add_const('CM_GET_DEVICE_INTERFACE_LIST_PRESENT',0x00000000)
    win_const_mgr.add_const('ATMPROTO_AAL5',0x00000005)
    win_const_mgr.add_const('NDIS_WMI_METHOD_HEADER_REVISION_1',0x00000001)
    win_const_mgr.add_const('FILE_DEVICE_INFINIBAND',0x0000003B)
    win_const_mgr.add_const('FL_UFI_DESIGNVECTOR_PFF',0x00000002)
    win_const_mgr.add_const('HTTP_QUERY_VIA',0x00000042)
    win_const_mgr.add_const('TAPE_DRIVE_RELATIVE_BLKS',0x80020000)
    win_const_mgr.add_const('TRACELOG_CREATE_ONDISK',0x00000040)
    win_const_mgr.add_const('D3DSTENCILCAPS_DECR',0x00000080)
    win_const_mgr.add_const('ERROR_DS_BAD_NAME_SYNTAX',0x0000208F)
    win_const_mgr.add_const('FLG_INI2REG_32BITKEY',0x00004000)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_HOTFIX',0x00000011)
    win_const_mgr.add_const('PSINJECT_ENDPAGESETUP',0x00000066)
    win_const_mgr.add_const('KSDSOUND_BUFFER_PRIMARY',0x00000001)
    win_const_mgr.add_const('AT_KEYEXCHANGE',0x00000001)
    win_const_mgr.add_const('KEY_LENGTH_MASK',0xFFFF0000)
    win_const_mgr.add_const('MIIM_ID',0x00000002)
    win_const_mgr.add_const('ETO_NUMERICSLATIN',0x00000800)
    win_const_mgr.add_const('DISK_LOGGING_STOP',0x00000001)
    win_const_mgr.add_const('BS_LEFT',0x00000100)
    win_const_mgr.add_const('KS_NABTS_GROUPID_TELEVISION_STATION_ADVERTISER_BASE',0x00000890)
    win_const_mgr.add_const('FCSM_VIEWID',0x00000001)
    win_const_mgr.add_const('OPATH_TOK_SINGLETON_SYM',0x0000006C)
    win_const_mgr.add_const('FACILITY_PINT_STATUS_CODE',0x000000F0)
    win_const_mgr.add_const('IN4ADDR_LOOPBACKPREFIX_LENGTH',0x00000008)
    win_const_mgr.add_const('MFBYTESTREAM_IS_WRITABLE',0x00000002)
    win_const_mgr.add_const('SM_REMOTESESSION',0x00001000)
    win_const_mgr.add_const('FAULT_INVALID_SEQUENCE_NUMBER',0x00000193)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_NAME',0x0000000B)
    win_const_mgr.add_const('RPC_C_AUTHN_GSS_NEGOTIATE',0x00000009)
    win_const_mgr.add_const('TMT_INACTIVECAPTIONTEXT',0x00000654)
    win_const_mgr.add_const('CONTEXT_MENU_ANCHOR',0x00000005)
    win_const_mgr.add_const('MCI_DGV_SETVIDEO_COLOR',0x00004001)
    win_const_mgr.add_const('STDPROP_INDEX_BREAK',0x000000CC)
    win_const_mgr.add_const('POSTSCRIPT_INJECTION',0x00001016)
    win_const_mgr.add_const('TRACE_HEADER_FLAG_USE_TIMESTAMP',0x00000200)
    win_const_mgr.add_const('PDCAP_WAKE_FROM_S2_SUPPORTED',0x00400000)
    win_const_mgr.add_const('LANG_NORWEGIAN',0x00000014)
    win_const_mgr.add_const('PRP',0x00000080)
    win_const_mgr.add_const('ODBC_VS_FLAG_UNICODE_ARG',0x00000001)
    win_const_mgr.add_const('WM_MENUDRAG',0x00000123)
    win_const_mgr.add_const('SECPKG_ATTR_NAMES',0x00000001)
    win_const_mgr.add_const('DDF_0001',0x00000001)
    win_const_mgr.add_const('D3DCREATE_NOWINDOWCHANGES',0x00000800)
    win_const_mgr.add_const('ACMFORMATCHOOSE_STYLEF_ENABLETEMPLATEHANDLE',0x00000020)
    win_const_mgr.add_const('NETLOGON_CONTROL_TRUNCATE_LOG',0x0000FFFD)
    win_const_mgr.add_const('ISR_UI_TRAP',0x00000004)
    win_const_mgr.add_const('IME_ESC_RESERVED_LAST',0x000007FF)
    win_const_mgr.add_const('ERROR_TRANSACTION_NOT_REQUESTED',0x00001A2F)
    win_const_mgr.add_const('DESKTOPHORZRES',0x00000076)
    win_const_mgr.add_const('IMGLOAD_NOTLOADED',0x00100000)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_REGSETINFORMATION',0x00000014)
    win_const_mgr.add_const('KSPROPERTY_TYPE_SERIALIZESET',0x00000800)
    win_const_mgr.add_const('IME_RS_ILLEGAL',0x00000006)
    win_const_mgr.add_const('CS_DISABLE',0x00000002)
    win_const_mgr.add_const('SQL_DESC_ARRAY_SIZE',0x00000014)
    win_const_mgr.add_const('IDM_CELLINSERT',0x0000089A)
    win_const_mgr.add_const('SM_FOCUS_TYPE_UNKNOWN_DOMAIN',0x00000003)
    win_const_mgr.add_const('SQL_INFO_SCHEMA_VIEWS',0x00000095)
    win_const_mgr.add_const('DISPID_FILELISTENUMDONE',0x000000C9)
    win_const_mgr.add_const('DBPROPVAL_IN_DISALLOWNULL',0x00000001)
    win_const_mgr.add_const('PP_PROVTYPE',0x00000010)
    win_const_mgr.add_const('MWMO_WAITALL',0x00000001)
    win_const_mgr.add_const('PIR_STATUS_ERROR',0x00000000)
    win_const_mgr.add_const('ERROR_DS_NO_DELETED_NAME',0x000020A3)
    win_const_mgr.add_const('PRINTER_ATTRIBUTE_KEEPPRINTEDJOBS',0x00000100)
    win_const_mgr.add_const('WTPF_ALLOWONLYPERTRUST',0x00040000)
    win_const_mgr.add_const('DFC_MENU',0x00000002)
    win_const_mgr.add_const('VIEW_E_FIRST',0x80040140)
    win_const_mgr.add_const('NDIS_OFFLOAD_SET_OFF',0x00000002)
    win_const_mgr.add_const('TME_QUERY',0x40000000)
    win_const_mgr.add_const('SYMOPT_INCLUDE_32BIT_MODULES',0x00002000)
    win_const_mgr.add_const('LINEADDRCAPFLAGS_SETCALLINGID',0x20000000)
    win_const_mgr.add_const('IDF_CHECKFIRST',0x00000100)
    win_const_mgr.add_const('APPCOMMAND_SEND_MAIL',0x00000029)
    win_const_mgr.add_const('TAPE_SPACE_SEQUENTIAL_SMKS',0x00000009)
    win_const_mgr.add_const('FWPM_CONTEXT_RPC_AUDIT_ENABLED',0x00000001)
    win_const_mgr.add_const('NETSETUP_INSTALL_INVOCATION',0x00040000)
    win_const_mgr.add_const('SFC_SCAN_ALWAYS',0x00000001)
    win_const_mgr.add_const('ERROR_HOST_UNREACHABLE',0x000004D0)
    win_const_mgr.add_const('SUF_BATCHINF',0x00000004)
    win_const_mgr.add_const('ERROR_ONLY_IF_CONNECTED',0x000004E3)
    win_const_mgr.add_const('VER_PRODUCTMINORVERSION',0x00000000)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_SETINTERVAL',0x00000495)
    win_const_mgr.add_const('EVENT_MIN',0x00000001)
    win_const_mgr.add_const('LANG_SYRIAC',0x00000005)
    win_const_mgr.add_const('CPF_MANUAL',0x00000040)
    win_const_mgr.add_const('OLEOBJ_E_FIRST',0x80040180)
    win_const_mgr.add_const('OID_ATM_DIGITAL_BROADCAST_VPIVCI',0x08010206)
    win_const_mgr.add_const('IPX_STANDARD_PACKET_TYPE',0x00000001)
    win_const_mgr.add_const('RTM_CHANGE_TYPE_ALL',0x00000001)
    win_const_mgr.add_const('VIDEO_EXTERNALIN',0x00000001)
    win_const_mgr.add_const('FNERR_INVALIDFILENAME',0x00003002)
    win_const_mgr.add_const('BTH_ERROR_UNKNOWN_HCI_COMMAND',0x00000001)
    win_const_mgr.add_const('ERROR_PRINTER_DRIVER_PACKAGE_IN_USE',0x00000BC7)
    win_const_mgr.add_const('DIF_DESTROYWIZARDDATA',0x00000011)
    win_const_mgr.add_const('TVS_EX_DOUBLEBUFFER',0x00000004)
    win_const_mgr.add_const('IPX_ADAPTER_INFO_TYPE',0x00000007)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2ERASE_RECORDER',0x00000100)
    win_const_mgr.add_const('DNS_TYPE_PX',0x00000001)
    win_const_mgr.add_const('SQL_API_SQLSETDESCFIELD',0x000003F9)
    win_const_mgr.add_const('ABM_QUERYPOS',0x00000002)
    win_const_mgr.add_const('PORT_SURMEAS',0x000000F3)
    win_const_mgr.add_const('USER_LAST_LOGON_PARMNUM',0x0000000F)
    win_const_mgr.add_const('PLATFORM_ID_DOS',0x0000012C)
    win_const_mgr.add_const('EVENTLOG_SEQUENTIAL_READ',0x00000001)
    win_const_mgr.add_const('OID_GEN_MAX_LINK_SPEED',0x00010206)
    win_const_mgr.add_const('VP_CP_TYPE_MACROVISION',0x00000002)
    win_const_mgr.add_const('SECPKG_CALL_ANSI',0x00000002)
    win_const_mgr.add_const('SM_CYMAXTRACK',0x0000003C)
    win_const_mgr.add_const('OPATH_TOK_COLON',0x0000006F)
    win_const_mgr.add_const('INTERNET_MAX_HOST_NAME_LENGTH',0x00000100)
    win_const_mgr.add_const('WIA_PAGE_ISO_B7',0x00000018)
    win_const_mgr.add_const('SVAUD_USERLIST',0x00002000)
    win_const_mgr.add_const('WIA_PAGE_ISO_B5',0x00000016)
    win_const_mgr.add_const('SQL_HANDLE_ENV',0x00000001)
    win_const_mgr.add_const('XP_BANDWIDTH_ALLOCATION',0x00000800)
    win_const_mgr.add_const('WIA_PAGE_ISO_B2',0x00000013)
    win_const_mgr.add_const('WIA_PAGE_ISO_B1',0x00000012)
    win_const_mgr.add_const('WIA_PAGE_ISO_B0',0x00000011)
    win_const_mgr.add_const('D3DPS20_MAX_STATICFLOWCONTROLDEPTH',0x00000004)
    win_const_mgr.add_const('LF32_MOVEABLE',0x00000004)
    win_const_mgr.add_const('DBG_TOOLHELP',0x0000000F)
    win_const_mgr.add_const('WIA_PAGE_ISO_B9',0x0000001A)
    win_const_mgr.add_const('CQPM_INITIALIZE',0x00000001)
    win_const_mgr.add_const('MCI_VCR_FREEZE_INPUT',0x00010000)
    win_const_mgr.add_const('ECOOP_SET',0x00000001)
    win_const_mgr.add_const('MF_RIGHTJUSTIFY',0x00004000)
    win_const_mgr.add_const('MIXERCONTROL_CT_UNITS_PERCENT',0x00050000)
    win_const_mgr.add_const('RTCSI_PHONE_TO_PHONE',0x00000004)
    win_const_mgr.add_const('HTTP_INITIALIZE_SERVER',0x00000001)
    win_const_mgr.add_const('DEBUG_STATUS_STEP_BRANCH',0x00000008)
    win_const_mgr.add_const('TMRESUME',0x08000000)
    win_const_mgr.add_const('PORT_STATUS_TYPE_WARNING',0x00000002)
    win_const_mgr.add_const('STG_TOEND',0xFFFFFFFF)
    win_const_mgr.add_const('DRIVER_HARDWAREID_MASK',0x80000FFF)
    win_const_mgr.add_const('PRINTER_NOTIFY_TYPE',0x00000000)
    win_const_mgr.add_const('D3DPBLENDCAPS_INVSRCCOLOR',0x00000008)
    win_const_mgr.add_const('CRED_TI_DOMAIN_FORMAT_UNKNOWN',0x00000002)
    win_const_mgr.add_const('WPC_SETTINGS_MODIFY',0x00000015)
    win_const_mgr.add_const('DELFLG_IN_USE',0x00000001)
    win_const_mgr.add_const('COPYFILE_SIS_LINK',0x00000001)
    win_const_mgr.add_const('NCRYPT_MAX_PROPERTY_DATA',0x00100000)
    win_const_mgr.add_const('CMSG_ENVELOPED_FLAG',0x00000001)
    win_const_mgr.add_const('HTTP_LOG_FIELD_SITE_NAME',0x00000010)
    win_const_mgr.add_const('CDO_E_NO_DIRECTORIES_SPECIFIED',0x80040231)
    win_const_mgr.add_const('MCI_OVLY_WINDOW_HWND',0x00010000)
    win_const_mgr.add_const('OFN_HIDEREADONLY',0x00000004)
    win_const_mgr.add_const('SERIAL_IOC_FCR_FIFO_ENABLE',0x00000001)
    win_const_mgr.add_const('KAGPROP_NUMERICFUNCTIONS',0x00000011)
    win_const_mgr.add_const('SETDTR',0x00000005)
    win_const_mgr.add_const('BG_E_INVALID_SERVER_RESPONSE',0x8020001B)
    win_const_mgr.add_const('SQL_SCROLLABLE',0x00000001)
    win_const_mgr.add_const('MCI_DGV_STATUS_TINT',0x00004015)
    win_const_mgr.add_const('DC_PRINTERMEM',0x0000001C)
    win_const_mgr.add_const('MAX_REASON_NAME_LEN',0x00000040)
    win_const_mgr.add_const('CFM_STYLE',0x00080000)
    win_const_mgr.add_const('ERROR_SERVICE_DISABLED',0x00000422)
    win_const_mgr.add_const('LINEERR_INVALCALLCOMPLMODE',0x80000017)
    win_const_mgr.add_const('PDH_CSTATUS_NO_OBJECT',0xC0000BB8)
    win_const_mgr.add_const('STI_VERSION_FLAG_MASK',0x00000000)
    win_const_mgr.add_const('ERROR_PATCH_PACKAGE_UNSUPPORTED',0x00000665)
    win_const_mgr.add_const('CLUSCTL_ACCESS_MODE_MASK',0x00000003)
    win_const_mgr.add_const('DSPRINT_UNPUBLISH',0x00000004)
    win_const_mgr.add_const('SQL_AF_COUNT',0x00000002)
    win_const_mgr.add_const('INTERNET_IDENTITY_FLAG_CLEAR_COOKIES',0x00000008)
    win_const_mgr.add_const('AUXCAPS_VOLUME',0x00000001)
    win_const_mgr.add_const('SECURITY_DESCRIPTOR_REVISION1',0x00000001)
    win_const_mgr.add_const('GPO_FLAG_DISABLE',0x00000001)
    win_const_mgr.add_const('WMDM_RIGHTS_NAMEDSERIALIDS',0x00000010)
    win_const_mgr.add_const('LDAP_OPT_PING_KEEP_ALIVE',0x00000036)
    win_const_mgr.add_const('DS_KCC_FLAG_ASYNC_OP',0x00000001)
    win_const_mgr.add_const('IDS_FW',0x0001100B)
    win_const_mgr.add_const('SPI_GETCLIENTAREAANIMATION',0x00001042)
    win_const_mgr.add_const('ATSC_EIT_TID',0x000000CB)
    win_const_mgr.add_const('SQL_DESC_ALLOC_USER',0x00000002)
    win_const_mgr.add_const('PKCS12_EXPORT_RESERVED_MASK',0x00000000)
    win_const_mgr.add_const('MIXER_OBJECTF_WAVEIN',0x20000000)
    win_const_mgr.add_const('TF_LBI_CUSTOMUI',0x00000020)
    win_const_mgr.add_const('CRYPT_EXPORTABLE',0x00000001)
    win_const_mgr.add_const('KSPROPERTY_TYPE_RELATIONS',0x00000400)
    win_const_mgr.add_const('AVIIF_COMPUSE',0x0FFF0000)
    win_const_mgr.add_const('CM_SHOW_HELP',0x00000002)
    win_const_mgr.add_const('AEC_MODE_FULL_DUPLEX',0x00000002)
    win_const_mgr.add_const('RENDBIND_AUTHENTICATE',0x00000001)
    win_const_mgr.add_const('ICM_OFF',0x00000001)
    win_const_mgr.add_const('DISPID_NAVIGATOR',0x00000001)
    win_const_mgr.add_const('WM_GETDLGCODE',0x00000087)
    win_const_mgr.add_const('DNS_ERROR_UNSECURE_PACKET',0x00002521)
    win_const_mgr.add_const('IME_CHOTKEY_SYMBOL_TOGGLE',0x00000012)
    win_const_mgr.add_const('DI_CLASSINSTALLPARAMS',0x00100000)
    win_const_mgr.add_const('MSGF_NEXTWINDOW',0x00000006)
    win_const_mgr.add_const('MFASYNC_CALLBACK_QUEUE_PRIVATE_MASK',0xFFFF0000)
    win_const_mgr.add_const('CERT_SIMPLE_NAME_STR',0x00000001)
    win_const_mgr.add_const('MFS_GRAYED',0x00000003)
    win_const_mgr.add_const('MCI_WAVE_SET_ANYOUTPUT',0x08000000)
    win_const_mgr.add_const('SECPKG_CRED_ATTR_NAMES',0x00000001)
    win_const_mgr.add_const('RRF_NOEXPAND',0x10000000)
    win_const_mgr.add_const('ASYNC_RECO_SETFACTOID_FAILED',0x00000080)
    win_const_mgr.add_const('ACTRL_ACCESS_SUPPORTS_OBJECT_ENTRIES',0x00000001)
    win_const_mgr.add_const('AEC_STATUS_FD_HISTORY_CONTINUOUSLY_CONVERGED',0x00000001)
    win_const_mgr.add_const('IN4ADDR_LINKLOCALPREFIX_LENGTH',0x00000010)
    win_const_mgr.add_const('OID_FDDI_FRAMES_LOST',0x03020105)
    win_const_mgr.add_const('LINEERR_INVALCALLHANDLE',0x80000018)
    win_const_mgr.add_const('WMS_CONTAINER_FILESIZE_HI',0x0000000C)
    win_const_mgr.add_const('SQL_FD_FETCH_LAST',0x00000004)
    win_const_mgr.add_const('FACILITY_NS_WIN32',0x00000007)
    win_const_mgr.add_const('ERRACT_USER',0x00000003)
    win_const_mgr.add_const('SCARD_PROVIDER_KSP',0x00000003)
    win_const_mgr.add_const('JOB_OBJECT_UILIMIT_EXITWINDOWS',0x00000080)
    win_const_mgr.add_const('PDH_UNABLE_MAP_NAME_FILES',0x80000BD5)
    win_const_mgr.add_const('CACHEGROUP_TYPE_INVALID',0x00000001)
    win_const_mgr.add_const('METHOD_BGP4_NEXTHOP_ATTR',0x00000008)
    win_const_mgr.add_const('ACM_FILTERTAGDETAILSF_QUERYMASK',0x0000000F)
    win_const_mgr.add_const('WIA_INTENT_IMAGE_TYPE_TEXT',0x00000004)
    win_const_mgr.add_const('SUBLANG_SLOVAK_SLOVAKIA',0x00000001)
    win_const_mgr.add_const('GESTURE_BRACKET_OVER',0x00000000)
    win_const_mgr.add_const('NDIS_DEVICE_WAKE_UP_ENABLE',0x00000001)
    win_const_mgr.add_const('OFN_FORCESHOWHIDDEN',0x10000000)
    win_const_mgr.add_const('SECPKG_FLAG_CLIENT_ONLY',0x00000040)
    win_const_mgr.add_const('DMPAPER_PENV_5_ROTATED',0x00000071)
    win_const_mgr.add_const('CDIS_NEARHOT',0x00000400)
    win_const_mgr.add_const('CRYPT_SF',0x00000100)
    win_const_mgr.add_const('KSEVENT_TYPE_TOPOLOGY',0x10000000)
    win_const_mgr.add_const('DBPROP_CLIENT_CLSID',0x00000003)
    win_const_mgr.add_const('HCBT_ACTIVATE',0x00000005)
    win_const_mgr.add_const('SNMPAPI_TL_IN_USE',0x0000006B)
    win_const_mgr.add_const('_WIN32_IE_IE501',0x00000501)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_PROVIDER_TYPES',0x00000002)
    win_const_mgr.add_const('ERROR_SEVERITY_ERROR',0xC0000000)
    win_const_mgr.add_const('IMAGE_REL_IA64_DIR32',0x00000004)
    win_const_mgr.add_const('CM_SHOW_HELPICON',0x00000004)
    win_const_mgr.add_const('GLOBAL_WAN_ROUTE',0x00000001)
    win_const_mgr.add_const('LINETERMSHARING_SHAREDCONF',0x00000004)
    win_const_mgr.add_const('MCI_VCR_LIST_COUNT',0x00040000)
    win_const_mgr.add_const('CRYPT_KEK',0x00000400)
    win_const_mgr.add_const('SECURITY_SERVICE_ID_BASE_RID',0x00000050)
    win_const_mgr.add_const('XP1_GUARANTEED_DELIVERY',0x00000002)
    win_const_mgr.add_const('BIF_BROWSEFORCOMPUTER',0x00001000)
    win_const_mgr.add_const('MD_SERVER_STATE_STARTING',0x00000001)
    win_const_mgr.add_const('CMSG_ENCODED_MESSAGE',0x0000001D)
    win_const_mgr.add_const('OPTION_XWINDOW_DISPLAY_MANAGER',0x00000031)
    win_const_mgr.add_const('USE_NETERR',0x00000003)
    win_const_mgr.add_const('DIF_INSTALLCLASSDRIVERS',0x0000000A)
    win_const_mgr.add_const('MCI_OVLY_OPEN_PARENT',0x00020000)
    win_const_mgr.add_const('ERROR_TIME_SKEW',0x00000576)
    win_const_mgr.add_const('WAIT_FAILED',0xFFFFFFFF)
    win_const_mgr.add_const('DNF_UNUSED_30',0x40000000)
    win_const_mgr.add_const('DNF_UNUSED_31',0x80000000)
    win_const_mgr.add_const('SQL_QUERY_TIMEOUT_DEFAULT',0x00000000)
    win_const_mgr.add_const('CDRF_DOERASE',0x00000008)
    win_const_mgr.add_const('LANG_ORIYA',0x00000048)
    win_const_mgr.add_const('SSF_NOCONFIRMRECYCLE',0x00008000)
    win_const_mgr.add_const('CBS_DROPDOWN',0x00000002)
    win_const_mgr.add_const('LANG_YI',0x00000078)
    win_const_mgr.add_const('KSSTREAM_HEADER_OPTIONSF_LOOPEDDATA',0x80000000)
    win_const_mgr.add_const('MIM_MENUDATA',0x00000008)
    win_const_mgr.add_const('MM_MIM_DATA',0x000003C3)
    win_const_mgr.add_const('WSA_QOS_EFLOWSPEC',0x00002B09)
    win_const_mgr.add_const('PD_ENABLESETUPHOOK',0x00002000)
    win_const_mgr.add_const('LINEFORWARDMODE_BUSYSPECIFIC',0x00000080)
    win_const_mgr.add_const('DVD_STREAM_DATA_CURRENT',0x00000800)
    win_const_mgr.add_const('URLACTION_SHELL_EXECUTE_HIGHRISK',0x00001806)
    win_const_mgr.add_const('PAN_MIDLINE_HIGH_TRIMMED',0x00000005)
    win_const_mgr.add_const('ERROR_BADSTARTPOSITION',0x0000030A)
    win_const_mgr.add_const('CPL_DBLCLK',0x00000005)
    win_const_mgr.add_const('MM_TWIPS',0x00000006)
    win_const_mgr.add_const('VER_SUITE_SMALLBUSINESS_RESTRICTED',0x00000020)
    win_const_mgr.add_const('SQL_DCS_DROP_CHARACTER_SET',0x00000001)
    win_const_mgr.add_const('DEBUG_CURRENT_DISASM',0x00000002)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_OID_REQUEST',0x00000096)
    win_const_mgr.add_const('CERT_COMPARE_SHIFT',0x00000010)
    win_const_mgr.add_const('CBEIF_TEXT',0x00000001)
    win_const_mgr.add_const('VNSPROTO_SPP',0x00000003)
    win_const_mgr.add_const('NIM_MODIFY',0x00000001)
    win_const_mgr.add_const('CSCONFIGFLAG_BITS',0x00000007)
    win_const_mgr.add_const('DUPLICATE_CLOSE_SOURCE',0x00000001)
    win_const_mgr.add_const('PROV_RSA_AES',0x00000018)
    win_const_mgr.add_const('SQL_TL_OFF',0x00000000)
    win_const_mgr.add_const('CM_SETUP_DEVNODE_READY',0x00000000)
    win_const_mgr.add_const('WH_HARDWARE',0x00000008)
    win_const_mgr.add_const('SUBLANG_TAMIL_INDIA',0x00000001)
    win_const_mgr.add_const('PP_KEYSTORAGE',0x00000011)
    win_const_mgr.add_const('URLACTION_JAVA_MIN',0x00001C00)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_UNKNOWN_DOI',0x00003626)
    win_const_mgr.add_const('SBS_BOTTOMALIGN',0x00000004)
    win_const_mgr.add_const('ARCONTENT_AUTORUNINF',0x00000002)
    win_const_mgr.add_const('SPARSE_CACHE_ENTRY',0x00010000)
    win_const_mgr.add_const('MFE_NO_SPACE',0x0000000D)
    win_const_mgr.add_const('_SIZE_T_MAX',0x00000000)
    win_const_mgr.add_const('OID_GEN_BYTES_RCV',0x00020219)
    win_const_mgr.add_const('DI_FLAGSEX_NO_CLASSLIST_NODE_MERGE',0x08000000)
    win_const_mgr.add_const('ERROR_SXS_UNKNOWN_ENCODING_GROUP',0x000036BC)
    win_const_mgr.add_const('EXECUTE_FLAG_IGNORE_CURRENT_INTERCEPTOR',0x00000002)
    win_const_mgr.add_const('IASSEMBLYCACHEITEM_COMMIT_DISPOSITION_REFRESHED',0x00000002)
    win_const_mgr.add_const('ERR_DISK_READ_ERROR',0xE0000004)
    win_const_mgr.add_const('SV_ANNOUNCE_PARMNUM',0x00000011)
    win_const_mgr.add_const('ERROR_INVALID_WINDOW_STYLE',0x000007D2)
    win_const_mgr.add_const('INF_STYLE_NONE',0x00000000)
    win_const_mgr.add_const('TLS1_ALERT_NO_RENEGOTIATION',0x00000064)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_REGKCBCREATE',0x00000016)
    win_const_mgr.add_const('IPX_TRAFFIC_FILTER_ACTION_PERMIT',0x00000001)
    win_const_mgr.add_const('SSF_SOUNDSENTRYON',0x00000001)
    win_const_mgr.add_const('TF_SFT_MINIMIZED',0x00000004)
    win_const_mgr.add_const('IF_TYPE_PRIMARY_ISDN',0x00000015)
    win_const_mgr.add_const('PST_RS449',0x00000005)
    win_const_mgr.add_const('LINEERR_BILLINGREJECTED',0x80000054)
    win_const_mgr.add_const('LINEADDRCAPFLAGS_DIALED',0x00000020)
    win_const_mgr.add_const('DNF_OLD_INET_DRIVER',0x00000400)
    win_const_mgr.add_const('SV_CONNECTIONNOSESSIONSTIMEOUT_PARMNUM',0x00000254)
    win_const_mgr.add_const('CACHE_HEADER_DATA_ROOT_LEAK_OFFSET',0x00000016)
    win_const_mgr.add_const('WGL_SWAP_OVERLAY10',0x00000400)
    win_const_mgr.add_const('IP_ROUTER_MANAGER_VERSION',0x00000001)
    win_const_mgr.add_const('IMEVER_0400',0x00040000)
    win_const_mgr.add_const('WGL_SWAP_OVERLAY13',0x00002000)
    win_const_mgr.add_const('INPLACE_E_FIRST',0x800401A0)
    win_const_mgr.add_const('ERROR_DBG_PRINTEXCEPTION_C',0x000002B6)
    win_const_mgr.add_const('NRC_TOOMANY',0x00000022)
    win_const_mgr.add_const('CTRY_DOMINICAN_REPUBLIC',0x00000001)
    win_const_mgr.add_const('DI_FLAGSEX_IN_SYSTEM_SETUP',0x00010000)
    win_const_mgr.add_const('SE_ERR_DLLNOTFOUND',0x00000020)
    win_const_mgr.add_const('IMAGE_REL_AMD64_ABSOLUTE',0x00000000)
    win_const_mgr.add_const('POLICY_ERRV_SUBNET_USER_PEAK_RATE',0x0000001F)
    win_const_mgr.add_const('VFT2_DRV_KEYBOARD',0x00000002)
    win_const_mgr.add_const('PAN_BENT_ARMS_VERT',0x00000009)
    win_const_mgr.add_const('GCP_CLASSIN',0x00080000)
    win_const_mgr.add_const('DS_INET_ADDRESS',0x00000001)
    win_const_mgr.add_const('VK_CAPITAL',0x00000014)
    win_const_mgr.add_const('SECTION_EXTEND_SIZE',0x00000010)
    win_const_mgr.add_const('ERROR_REDIR_PAUSED',0x00000048)
    win_const_mgr.add_const('RPC_C_MQ_JOURNAL_ALWAYS',0x00000002)
    win_const_mgr.add_const('ACTION_ADMINUNLOCK',0x00000001)
    win_const_mgr.add_const('IME_HOTKEY_DSWITCH_FIRST',0x00000100)
    win_const_mgr.add_const('IDTR_KEY',0x00000008)
    win_const_mgr.add_const('DRM_ACTIVATE_MACHINE',0x00000001)
    win_const_mgr.add_const('INFO_BASE',0x00000000)
    win_const_mgr.add_const('ERROR_CTX_NO_FORCE_LOGOFF',0x00001B97)
    win_const_mgr.add_const('D3DLOCK_DISCARD',0x00002000)
    win_const_mgr.add_const('SET_SERVICE_PARTIAL_SUCCESS',0x00000001)
    win_const_mgr.add_const('PRODUCT_HOME_PREMIUM',0x00000003)
    win_const_mgr.add_const('CERT_STORE_ADD_USE_EXISTING',0x00000002)
    win_const_mgr.add_const('LINE_DEVSPECIFIC',0x00000004)
    win_const_mgr.add_const('IOC_UNIX',0x00000000)
    win_const_mgr.add_const('CERT_PROT_ROOT_INHIBIT_PURGE_LM_FLAG',0x00000004)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW3_SCREENLEFT',0x00000492)
    win_const_mgr.add_const('CM_DRP_REMOVAL_POLICY_OVERRIDE',0x00000022)
    win_const_mgr.add_const('SHFMT_ERROR',0xFFFFFFFF)
    win_const_mgr.add_const('SB_BOTH',0x00000003)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_COMMIT_REQUEST',0x04000000)
    win_const_mgr.add_const('DFM_WM_INITMENUPOPUP',0x00000008)
    win_const_mgr.add_const('VPDF_DISABLERINGRESUME',0x00000010)
    win_const_mgr.add_const('VPF_DISABLERELATIVE',0x00000002)
    win_const_mgr.add_const('SO_RCVTIMEO',0x00001006)
    win_const_mgr.add_const('LOCALE_SDAYNAME2',0x0000002B)
    win_const_mgr.add_const('SPMODE_BROWSER',0x00000008)
    win_const_mgr.add_const('EVENT_SYSTEM_CONTEXTHELPEND',0x0000000D)
    win_const_mgr.add_const('SECURITY_THIS_ORGANIZATION_RID',0x0000000F)
    win_const_mgr.add_const('URL_UNESCAPE',0x10000000)
    win_const_mgr.add_const('INVALID_TIME',0x00000000)
    win_const_mgr.add_const('DESKTOP_JOURNALPLAYBACK',0x00000020)
    win_const_mgr.add_const('ERROR_LOG_RESTART_INVALID',0x000019CF)
    win_const_mgr.add_const('LINEPROXYREQUEST_GETAGENTINFO',0x0000000B)
    win_const_mgr.add_const('PORT_CYCLESERV',0x000002FB)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_INVALID_HASH',0x0000362E)
    win_const_mgr.add_const('DISPID_WMPCORE_BASE',0x00000000)
    win_const_mgr.add_const('PIR_OPTION_REGISTRY',0x00000002)
    win_const_mgr.add_const('FILE_DEVICE_VIRTUAL_DISK',0x00000024)
    win_const_mgr.add_const('SUBLANG_MOHAWK_MOHAWK',0x00000001)
    win_const_mgr.add_const('SNMP_TRAP_AUTHFAIL',0x00000004)
    win_const_mgr.add_const('PSD_DISABLEPRINTER',0x00000020)
    win_const_mgr.add_const('MFCOMMENT',0x0000000F)
    win_const_mgr.add_const('SQL_API_SQLNUMRESULTCOLS',0x00000012)
    win_const_mgr.add_const('ERROR_DS_NO_CROSSREF_FOR_NC',0x000020AB)
    win_const_mgr.add_const('MXDCOP_SET_S0PAGE_RESOURCE',0x0000001E)
    win_const_mgr.add_const('DNSSEC_PROTOCOL_IPSEC',0x00000004)
    win_const_mgr.add_const('IP_DROP_SOURCE_MEMBERSHIP',0x00000010)
    win_const_mgr.add_const('IF_TYPE_POS',0x000000AB)
    win_const_mgr.add_const('ERROR_CORRUPT_SYSTEM_FILE',0x0000027A)
    win_const_mgr.add_const('CM_PROB_CANT_SHARE_IRQ',0x0000001E)
    win_const_mgr.add_const('STI_GENCAP_GENERATE_ARRIVALEVENT',0x00000004)
    win_const_mgr.add_const('DDCOLOR_SHARPNESS',0x00000010)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_NO_CERT',0x000035EE)
    win_const_mgr.add_const('SQL_AA_FALSE',0x00000000)
    win_const_mgr.add_const('ERROR_GUID_SUBSTITUTION_MADE',0x000002A8)
    win_const_mgr.add_const('WSA_QOS_EPSFLOWSPEC',0x00002B13)
    win_const_mgr.add_const('VK_PRIOR',0x00000021)
    win_const_mgr.add_const('MCGIF_RECT',0x00000002)
    win_const_mgr.add_const('WIA_PAGE_AUTO',0x00000064)
    win_const_mgr.add_const('CACHE_HEADER_DATA_CACHE_RESERVED_30',0x0000001E)
    win_const_mgr.add_const('LINETERMMODE_HOOKSWITCH',0x00000010)
    win_const_mgr.add_const('DXVA_EXECUTE_RETURN_OTHER_ERROR_SEVERE',0x00000004)
    win_const_mgr.add_const('CC_ELLIPSES',0x00000008)
    win_const_mgr.add_const('PRINTER_CHANGE_PORT',0x00700000)
    win_const_mgr.add_const('CACHE_FIND_CONTAINER_RETURN_NOCHANGE',0x00000001)
    win_const_mgr.add_const('DLG_ACMFILTERCHOOSE_ID',0x00000047)
    win_const_mgr.add_const('REG_FULL_RESOURCE_DESCRIPTOR',0x00000009)
    win_const_mgr.add_const('SQL_API_SQLALLOCCONNECT',0x00000001)
    win_const_mgr.add_const('DEBUG_VSEARCH_WRITABLE_ONLY',0x00000001)
    win_const_mgr.add_const('FWP_FILTER_ENUM_FLAG_INCLUDE_DISABLED',0x00000010)
    win_const_mgr.add_const('DBPROPVAL_TI_SERIALIZABLE',0x00100000)
    win_const_mgr.add_const('PHONESTATE_DISCONNECTED',0x00000004)
    win_const_mgr.add_const('LINEFORWARDMODE_BUSYEXTERNAL',0x00000040)
    win_const_mgr.add_const('LDAP_BIND_CMD',0x00000060)
    win_const_mgr.add_const('SQL_CA2_SENSITIVITY_DELETIONS',0x00000020)
    win_const_mgr.add_const('APPCOMMAND_VOLUME_MUTE',0x00000008)
    win_const_mgr.add_const('PORT_PPTP',0x0000162E)
    win_const_mgr.add_const('SHGFI_SHELLICONSIZE',0x00000004)
    win_const_mgr.add_const('MDM_AUTO_ML_2',0x00000002)
    win_const_mgr.add_const('ERROR_INVALID_LEVEL',0x0000007C)
    win_const_mgr.add_const('PSWIZB_BACK',0x00000001)
    win_const_mgr.add_const('STI_EVENTHANDLING_PENDING',0x00000004)
    win_const_mgr.add_const('MAPI_E_ACCESS_DENIED',0x00000006)
    win_const_mgr.add_const('DVD_AUDIO_CAPS_SDDS',0x00000010)
    win_const_mgr.add_const('_WIN32_WINNT_NT4',0x00000400)
    win_const_mgr.add_const('IP_FRAGOFF_MASK',0x00001FFF)
    win_const_mgr.add_const('VK_RETURN',0x0000000D)
    win_const_mgr.add_const('DFS_VOLUME_STATE_ONLINE',0x00000004)
    win_const_mgr.add_const('D3D10_SHADER_IEEE_STRICTNESS',0x00000001)
    win_const_mgr.add_const('ALG_SID_ECMQV',0x00000001)
    win_const_mgr.add_const('ERROR_DS_CONFIG_PARAM_MISSING',0x000020EB)
    win_const_mgr.add_const('WSAENOTEMPTY',0x00002752)
    win_const_mgr.add_const('ERROR_EVT_CONFIGURATION_ERROR',0x00003AA2)
    win_const_mgr.add_const('PAN_CULTURE_LATIN',0x00000000)
    win_const_mgr.add_const('TCS_FOCUSONBUTTONDOWN',0x00001000)
    win_const_mgr.add_const('CRYPT_VERIFYCONTEXT',0xF0000000)
    win_const_mgr.add_const('IF_TYPE_TERMPAD',0x0000005B)
    win_const_mgr.add_const('NLS_CP_WCTOMB',0x80000000)
    win_const_mgr.add_const('RIS_INTERFACE_DISABLED',0x00000002)
    win_const_mgr.add_const('SHIL_JUMBO',0x00000004)
    win_const_mgr.add_const('CM_REENUMERATE_NORMAL',0x00000000)
    win_const_mgr.add_const('DBG_MODLOAD',0x00000003)
    win_const_mgr.add_const('OID_GEN_ADMIN_STATUS',0x00010288)
    win_const_mgr.add_const('MCI_DGV_STATUS_WINDOW_VISIBLE',0x00004021)
    win_const_mgr.add_const('ERROR_DOMAIN_EXISTS',0x0000054C)
    win_const_mgr.add_const('DDSCAPS_OVERLAY',0x00000080)
    win_const_mgr.add_const('IMAGE_SCN_ALIGN_256BYTES',0x00900000)
    win_const_mgr.add_const('SCH_CRED_USE_DEFAULT_CREDS',0x00000040)
    win_const_mgr.add_const('KERB_REFRESH_SCCRED_RELEASE',0x00000000)
    win_const_mgr.add_const('CHANNEL_RC_UNKNOWN_CHANNEL_NAME',0x0000000D)
    win_const_mgr.add_const('SYSRGN',0x00000004)
    win_const_mgr.add_const('SCH_CRED_X509_CERTCHAIN',0x00000001)
    win_const_mgr.add_const('SS_USERITEM',0x0000000A)
    win_const_mgr.add_const('POWER_USER_NOTIFY_BUTTON',0x00000008)
    win_const_mgr.add_const('LINEADDRESSSTATE_NUMCALLS',0x00000020)
    win_const_mgr.add_const('PRODUCT_STARTER',0x0000000B)
    win_const_mgr.add_const('OFFLOAD_INBOUND_SA',0x00000001)
    win_const_mgr.add_const('MNC_CLOSE',0x00000001)
    win_const_mgr.add_const('IDC_CI_ICONDISPLAY',0x00000083)
    win_const_mgr.add_const('KERB_ETYPE_RSA_PRIV',0x00000009)
    win_const_mgr.add_const('IME_CONFIG_GENERAL',0x00000001)
    win_const_mgr.add_const('CSIDL_COMMON_ADMINTOOLS',0x00000002)
    win_const_mgr.add_const('WMDM_STATUS_STORAGECONTROL_APPENDING',0x00008000)
    win_const_mgr.add_const('R2_NOTMERGEPEN',0x00000002)
    win_const_mgr.add_const('SSF_SHOWEXTENSIONS',0x00000002)
    win_const_mgr.add_const('ERROR_SXS_DUPLICATE_ASSEMBLY_NAME',0x000036CB)
    win_const_mgr.add_const('CERT_RDN_ENCODED_BLOB',0x00000001)
    win_const_mgr.add_const('IDM_SCROLL_PAGEUP',0x0000094F)
    win_const_mgr.add_const('DEBUG_GSEL_NO_SYMBOL_LOADS',0x00000001)
    win_const_mgr.add_const('IMAGE_WEAK_EXTERN_SEARCH_ALIAS',0x00000003)
    win_const_mgr.add_const('TMT_GLYPHTEXTCOLOR',0x00000EEB)
    win_const_mgr.add_const('MAX_DEVICE_IDENTIFIER_STRING',0x00000200)
    win_const_mgr.add_const('WT_EXECUTEDELETEWAIT',0x00000008)
    win_const_mgr.add_const('INTERNET_OPTION_RECEIVE_TIMEOUT',0x00000006)
    win_const_mgr.add_const('NRC_LOCKFAIL',0x0000003C)
    win_const_mgr.add_const('PRINTACTION_SERVERPROPERTIES',0x00000007)
    win_const_mgr.add_const('JL_SENDER_ONLY',0x00000001)
    win_const_mgr.add_const('CERT_UNICODE_ATTR_ERR_INDEX_MASK',0x0000003F)
    win_const_mgr.add_const('LOGON_PROFILE_PATH_RETURNED',0x00000400)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_SECREL',0x0000000F)
    win_const_mgr.add_const('SM_CXFRAME',0x00000020)
    win_const_mgr.add_const('WIA_MAJOR_EVENT_DEVICE_DISCONNECT',0x00000002)
    win_const_mgr.add_const('USER_MARSHAL_FC_FLOAT',0x0000000A)
    win_const_mgr.add_const('DISPID_NAVIGATECOMPLETE2',0x000000FC)
    win_const_mgr.add_const('SET_REPAIR_WARN_ABOUT_DATA_LOSS',0x00000008)
    win_const_mgr.add_const('SCS_CAP_COMPSTR',0x00000001)
    win_const_mgr.add_const('WVR_HREDRAW',0x00000100)
    win_const_mgr.add_const('VS_ALLOW_LATIN',0x00000001)
    win_const_mgr.add_const('SAVE_FORMAT_TEXT',0x00000001)
    win_const_mgr.add_const('IMAGE_DLLCHARACTERISTICS_NO_SEH',0x00000400)
    win_const_mgr.add_const('RQ_CUSTOM_NOTIFICATION',0x10000000)
    win_const_mgr.add_const('LINEGROUPSTATUS_NEWGROUP',0x00000001)
    win_const_mgr.add_const('D3DPRASTERCAPS_FOGVERTEX',0x00000080)
    win_const_mgr.add_const('CSIDL_DRIVES',0x00000011)
    win_const_mgr.add_const('IDD_VIEWPROPS',0x0000044D)
    win_const_mgr.add_const('DMDO_270',0x00000003)
    win_const_mgr.add_const('TMT_ACCENTCOLORHINT',0x00000EEF)
    win_const_mgr.add_const('COD_AUDIO_MINOR_LOUDSPEAKER',0x00000005)
    win_const_mgr.add_const('ENABLE_DISABLE_AUTO_OFFLINE',0x000000DB)
    win_const_mgr.add_const('EMARCH_ENC_I17_SIGN_INST_WORD_POS_X',0x0000001B)
    win_const_mgr.add_const('CERT_STORE_ADD_REPLACE_EXISTING',0x00000003)
    win_const_mgr.add_const('CRED_PERSIST_NONE',0x00000000)
    win_const_mgr.add_const('TC_OP_STROKE',0x00000002)
    win_const_mgr.add_const('FIND_NEXT',0x00000001)
    win_const_mgr.add_const('SQL_MAX_STATEMENT_LEN',0x00000069)
    win_const_mgr.add_const('KS_NABTS_GROUPID_PRODUCTION_COMPANY_ADVERTISER_BASE',0x00000830)
    win_const_mgr.add_const('DISPID_IWBSCRIPTCONTROL_SELECTABLECONTENT',0x00000004)
    win_const_mgr.add_const('TMT_WINDOW',0x00000646)
    win_const_mgr.add_const('ERROR_DIRECT_ACCESS_HANDLE',0x00000082)
    win_const_mgr.add_const('OID_FDDI_SMT_CONFIG_CAPABILITIES',0x0303020C)
    win_const_mgr.add_const('CAUSE_LOC_PUBLIC_LOCAL',0x00000002)
    win_const_mgr.add_const('ERROR_CANT_ACCESS_FILE',0x00000780)
    win_const_mgr.add_const('DXGI_PRESENT_RESTART',0x00000004)
    win_const_mgr.add_const('ASC_REQ_CONFIDENTIALITY',0x00000010)
    win_const_mgr.add_const('TAPE_DRIVE_COMPRESSION',0x00020000)
    win_const_mgr.add_const('TVGN_CHILD',0x00000004)
    win_const_mgr.add_const('MIXED_NODETYPE',0x00000004)
    win_const_mgr.add_const('DIF_SELECTCLASSDRIVERS',0x00000008)
    win_const_mgr.add_const('INT_PTR_MAX',0x7FFFFFFF)
    win_const_mgr.add_const('SE_PRIVILEGE_REMOVED',0x00000000)
    win_const_mgr.add_const('TF_RP_LOCALTHREAD',0x00000008)
    win_const_mgr.add_const('TBNF_DI_SETITEM',0x10000000)
    win_const_mgr.add_const('AUTH_REQ_ALLOW_PROXIABLE',0x00000002)
    win_const_mgr.add_const('D3D_MAX_SIMULTANEOUS_RENDERTARGETS',0x00000004)
    win_const_mgr.add_const('SERIAL_IOC_MCR_RTS',0x00000002)
    win_const_mgr.add_const('TMT_SMCAPTIONBARHEIGHT',0x000004B7)
    win_const_mgr.add_const('R2_BLACK',0x00000001)
    win_const_mgr.add_const('SQL_MAX_SCHEMA_NAME_LEN',0x00000020)
    win_const_mgr.add_const('CERT_RDN_GENERAL_STRING',0x0000000A)
    win_const_mgr.add_const('MDM_PROTOCOLID_DEFAULT',0x00000000)
    win_const_mgr.add_const('ERROR_STREAM_MINIVERSION_NOT_VALID',0x00001A99)
    win_const_mgr.add_const('DNS_MAX_TEXT_STRING_LENGTH',0x000000FF)
    win_const_mgr.add_const('SRRF_RT_REG_EXPAND_SZ',0x00000004)
    win_const_mgr.add_const('WS_MINIMIZE',0x20000000)
    win_const_mgr.add_const('SND_SYSTEM',0x00200000)
    win_const_mgr.add_const('OID_GEN_MEDIA_SENSE_COUNTS',0x00020215)
    win_const_mgr.add_const('IC_E_INTERNAL_ERROR',0x83010006)
    win_const_mgr.add_const('SFGAO_HASSUBFOLDER',0x80000000)
    win_const_mgr.add_const('SSPROP_STREAM_BASEPATH',0x00000011)
    win_const_mgr.add_const('SV_RAWWORKITEMS_PARMNUM',0x000001FB)
    win_const_mgr.add_const('WLAN_CONNECTION_IGNORE_PRIVACY_BIT',0x00000004)
    win_const_mgr.add_const('SVSI_DESELECT',0x00000000)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MAJOR_MAX',0x00070000)
    win_const_mgr.add_const('HEAP_CREATE_ALIGN_16',0x00010000)
    win_const_mgr.add_const('SQL_IS_INSERT_LITERALS',0x00000001)
    win_const_mgr.add_const('VK_NUMPAD3',0x00000063)
    win_const_mgr.add_const('PHONEERR_INVALPOINTER',0x90000015)
    win_const_mgr.add_const('DS_REPMOD_WRITEABLE',0x00000002)
    win_const_mgr.add_const('PAN_SERIF_OBTUSE_SANS',0x0000000C)
    win_const_mgr.add_const('VK_NUMPAD7',0x00000067)
    win_const_mgr.add_const('VK_NUMPAD6',0x00000066)
    win_const_mgr.add_const('VK_NUMPAD5',0x00000065)
    win_const_mgr.add_const('VK_NUMPAD4',0x00000064)
    win_const_mgr.add_const('NDIS_PORT_CHARACTERISTICS_REVISION_1',0x00000001)
    win_const_mgr.add_const('LVS_EX_COLUMNSNAPPOINTS',0x40000000)
    win_const_mgr.add_const('DMPAPER_P32KBIG_ROTATED',0x0000006C)
    win_const_mgr.add_const('AM_VIDEO_FLAG_REPEAT_FIELD',0x00000040)
    win_const_mgr.add_const('DBPROP_MSREMOTE_INTERNET_TIMEOUT',0x00000006)
    win_const_mgr.add_const('SHDID_COMPUTER_OTHER',0x0000000C)
    win_const_mgr.add_const('META_SCALEVIEWPORTEXT',0x00000412)
    win_const_mgr.add_const('PRINTER_ERROR_SEVERE',0x20000000)
    win_const_mgr.add_const('EXCEPTION_WRITE_FAULT',0x00000001)
    win_const_mgr.add_const('AVIFILEINFO_MUSTUSEINDEX',0x00000020)
    win_const_mgr.add_const('LP_DEFAULT',0x00000000)
    win_const_mgr.add_const('MCI_DGV_RESERVE_SIZE',0x00020000)
    win_const_mgr.add_const('MD_WARNING_PATH_NOT_FOUND',0x000CC803)
    win_const_mgr.add_const('SECTION_QUERY',0x00000001)
    win_const_mgr.add_const('TCS_MULTISELECT',0x00000004)
    win_const_mgr.add_const('BACKUP_DISABLE_INCREMENTAL',0x00000000)
    win_const_mgr.add_const('DXVA_PICTURE_STRUCTURE_TOP_FIELD',0x00000001)
    win_const_mgr.add_const('IPV6_RTHDR',0x00000020)
    win_const_mgr.add_const('PROV_SPYRUS_LYNKS',0x00000014)
    win_const_mgr.add_const('SPDRP_SERVICE',0x00000004)
    win_const_mgr.add_const('LINECALLFEATURE_SWAPHOLD',0x04000000)
    win_const_mgr.add_const('ALT4KB_END',0x6FC00800000)
    win_const_mgr.add_const('SPI_GETACTIVEWINDOWTRACKING',0x00001000)
    win_const_mgr.add_const('ERROR_CANT_CROSS_RM_BOUNDARY',0x00001AA9)
    win_const_mgr.add_const('SQL_GETDATA_EXTENSIONS',0x00000051)
    win_const_mgr.add_const('ERROR_REPARSE_TAG_MISMATCH',0x0000112A)
    win_const_mgr.add_const('NDIS_MEDIA_CAP_RECEIVE',0x00000002)
    win_const_mgr.add_const('INSTALLFLAG_NONINTERACTIVE',0x00000004)
    win_const_mgr.add_const('VALIDATEUNC_VALID',0x00000007)
    win_const_mgr.add_const('DFS_SITE_PRIMARY',0x00000001)
    win_const_mgr.add_const('WIA_IPS_FILM_SCAN_MODE',0x00000C20)
    win_const_mgr.add_const('ERROR_CONTROLLING_IEPORT',0x000010E9)
    win_const_mgr.add_const('SQL_CV_CASCADED',0x00000004)
    win_const_mgr.add_const('E_SURFACE_NODC',0x8000C004)
    win_const_mgr.add_const('SHCNF_NOTIFYRECURSIVE',0x00010000)
    win_const_mgr.add_const('IMC_GETCOMPOSITIONWINDOW',0x0000000B)
    win_const_mgr.add_const('DBPROPVAL_IC_MIXED',0x00000008)
    win_const_mgr.add_const('MCI_VCR_STATUS_NUMBER_OF_AUDIO_TRACKS',0x00004020)
    win_const_mgr.add_const('MQMSG_ACKNOWLEDGMENT_POS_RECEIVE',0x00000002)
    win_const_mgr.add_const('HDS_HIDDEN',0x00000008)
    win_const_mgr.add_const('EVENT_TRACE_USE_NOCPUTIME',0x00000002)
    win_const_mgr.add_const('LINEERR_INVALBEARERMODE',0x80000016)
    win_const_mgr.add_const('MDPROPVAL_AU_UNCHANGED',0x00000001)
    win_const_mgr.add_const('TMT_GRADIENTCOLOR2',0x00000EE3)
    win_const_mgr.add_const('ERROR_DS_GC_NOT_AVAILABLE',0x00002019)
    win_const_mgr.add_const('ERROR_DS_INVALID_SCRIPT',0x00002198)
    win_const_mgr.add_const('RPC_X_NO_MORE_ENTRIES',0x000006EC)
    win_const_mgr.add_const('APPCOMMAND_BROWSER_BACKWARD',0x00000001)
    win_const_mgr.add_const('RF_USER_ACTION',0x10000000)
    win_const_mgr.add_const('PRIVATE_NAMESPACE_FLAG_DESTROY',0x00000001)
    win_const_mgr.add_const('FS_CHINESETRAD',0x00100000)
    win_const_mgr.add_const('MCI_VCR_ESCAPE_STRING',0x00000100)
    win_const_mgr.add_const('DS_CONTROL',0x00000400)
    win_const_mgr.add_const('TRACE_LEVEL_CRITICAL',0x00000001)
    win_const_mgr.add_const('INTERNET_DEFAULT_FTP_PORT',0x00000015)
    win_const_mgr.add_const('NDIS_PORT_STATE_REVISION_1',0x00000001)
    win_const_mgr.add_const('DEX_IDS_DISK_WRITE_ERROR',0x0000058B)
    win_const_mgr.add_const('DDCKEYCAPS_NOCOSTOVERLAY',0x00040000)
    win_const_mgr.add_const('HTTP_LOGGING_FLAG_USE_UTF8_CONVERSION',0x00000002)
    win_const_mgr.add_const('PFN_LCLETTER',0x00000003)
    win_const_mgr.add_const('SHGDFIL_DESCRIPTIONID',0x00000003)
    win_const_mgr.add_const('SPFILENOTIFY_STARTRENAME',0x00000008)
    win_const_mgr.add_const('ERROR_INVALID_GW_COMMAND',0x000005A3)
    win_const_mgr.add_const('VR_PENDING',0x00000000)
    win_const_mgr.add_const('ERROR_BAD_SERVICE_ENTRYPOINT',0x00000262)
    win_const_mgr.add_const('PORT_TYPE_NET_ATTACHED',0x00000008)
    win_const_mgr.add_const('DAO_NOINDICATOR',0x00000000)
    win_const_mgr.add_const('SNMP_ERROR_TOOBIG',0x00000001)
    win_const_mgr.add_const('CERT_PROT_ROOT_DISABLE_PEER_TRUST',0x00010000)
    win_const_mgr.add_const('CERT_COMPARE_SUBJECT_INFO_ACCESS',0x00000013)
    win_const_mgr.add_const('DNS_TYPE_ALL',0x00000000)
    win_const_mgr.add_const('SQL_OPT_TRACEFILE',0x00000069)
    win_const_mgr.add_const('LVHT_ABOVE',0x00000008)
    win_const_mgr.add_const('NIIF_NDIS_WDM_INTERFACE',0x00000020)
    win_const_mgr.add_const('KSWAVE_BUFFER_ATTRIBUTEF_LOOPING',0x00000001)
    win_const_mgr.add_const('BG_E_INVALID_PROXY_INFO',0x8020003F)
    win_const_mgr.add_const('STI_ONLINESTATE_PAUSED',0x00000008)
    win_const_mgr.add_const('MCI_DGV_CUT_AT',0x00010000)
    win_const_mgr.add_const('BST_INDETERMINATE',0x00000002)
    win_const_mgr.add_const('FILE_ACTION_MODIFIED',0x00000003)
    win_const_mgr.add_const('MDM_ERROR_CONTROL',0x00000002)
    win_const_mgr.add_const('ERROR_DS_EXISTS_IN_RDNATTID',0x00002196)
    win_const_mgr.add_const('DBT_CONFIGCHANGECANCELED',0x00000019)
    win_const_mgr.add_const('X3_D_WH_INST_WORD_POS_X',0x00000018)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_PROVIDER_CHIMNEY_OFFLOAD_CHARACTERISTICS',0x00000094)
    win_const_mgr.add_const('SB_THUMBTRACK',0x00000005)
    win_const_mgr.add_const('DIF_VALIDATECLASSDRIVERS',0x00000009)
    win_const_mgr.add_const('KSMPEGVIDMODE_PANSCAN',0x00000001)
    win_const_mgr.add_const('NDIS_PROTOCOL_ID_NBF',0x00000007)
    win_const_mgr.add_const('VIEW_PRIORITY_NONE',0x00000000)
    win_const_mgr.add_const('TMT_ICONTITLEFONT',0x00000326)
    win_const_mgr.add_const('REO_GETOBJ_POLESITE',0x00000004)
    win_const_mgr.add_const('EC_TIMECODE_AVAILABLE',0x00000030)
    win_const_mgr.add_const('RTCEF_SESSION_OPERATION_COMPLETE',0x00000008)
    win_const_mgr.add_const('MSV1_0_USE_CLIENT_CHALLENGE',0x00000080)
    win_const_mgr.add_const('IPX_TRAFFIC_FILTER_ON_SRCNODE',0x00000002)
    win_const_mgr.add_const('PRINTER_STATUS_SERVER_OFFLINE',0x02000000)
    win_const_mgr.add_const('DDOVER_KEYSRCOVERRIDE',0x00002000)
    win_const_mgr.add_const('PRINTER_CONTROL_RESUME',0x00000002)
    win_const_mgr.add_const('TAPIMAXAPPNAMESIZE',0x00000028)
    win_const_mgr.add_const('DBPROPVAL_SQ_COMPARISON',0x00000002)
    win_const_mgr.add_const('PID_THUMBNAIL',0x00000011)
    win_const_mgr.add_const('SFGAO_CANMONIKER',0x00400000)
    win_const_mgr.add_const('SQL_TRANSLATE_OPTION',0x0000006B)
    win_const_mgr.add_const('CAUSE_LOC_BEYOND_INTERWORKING',0x0000000A)
    win_const_mgr.add_const('LDAP_OPT_ENCRYPT',0x00000096)
    win_const_mgr.add_const('D3DPTEXTURECAPS_NOPROJECTEDBUMPENV',0x00200000)
    win_const_mgr.add_const('POLICY_QOS_SCHANNEL_REQUIRED',0x00000001)
    win_const_mgr.add_const('OPATH_TOK_CLOSE_PAREN',0x0000006B)
    win_const_mgr.add_const('SQL_AF_SUM',0x00000010)
    win_const_mgr.add_const('LR_LOADMAP3DCOLORS',0x00001000)
    win_const_mgr.add_const('OID_ATM_MAX_AAL1_PACKET_SIZE',0x08010109)
    win_const_mgr.add_const('IDM_JUSTIFYNONE',0x0000005E)
    win_const_mgr.add_const('SV_NAME_PARMNUM',0x00000066)
    win_const_mgr.add_const('DNS_TYPE_ZERO',0x00000000)
    win_const_mgr.add_const('STAT_NOISE_WORDS',0x00000010)
    win_const_mgr.add_const('MD_AUTH_PASSPORT',0x00000040)
    win_const_mgr.add_const('CF_APPLY',0x00000200)
    win_const_mgr.add_const('NDIS_WMI_EVENT_HEADER_REVISION_1',0x00000001)
    win_const_mgr.add_const('PERM_FILE_WRITE',0x00000002)
    win_const_mgr.add_const('ERROR_NO_INHERITANCE',0x0000056F)
    win_const_mgr.add_const('IF_TYPE_ISO88026_MAN',0x0000000A)
    win_const_mgr.add_const('RTCRF_REGISTER_NOTIFY',0x00000008)
    win_const_mgr.add_const('FRS_ERR_INVALID_SERVICE_PARAMETER',0x00001F51)
    win_const_mgr.add_const('DMO_E_TYPE_NOT_ACCEPTED',0x80040205)
    win_const_mgr.add_const('SYSTEM_AUDIT_ACE_TYPE',0x00000002)
    win_const_mgr.add_const('DB_MODE_SHARE_EXCLUSIVE',0x00000000)
    win_const_mgr.add_const('PDERR_GETDEVMODEFAIL',0x00001005)
    win_const_mgr.add_const('SIOM_ICONINDEX',0x00000002)
    win_const_mgr.add_const('DDFXCAPS_OVERLAYSHRINKYN',0x00400000)
    win_const_mgr.add_const('IDM_GETUSERACTIONTIME',0x0000097F)
    win_const_mgr.add_const('RTCEF_SESSION_REFERRED',0x00200000)
    win_const_mgr.add_const('ADS_JOB_PRINTING',0x00000010)
    win_const_mgr.add_const('SVAUD_LOGONLIM',0x00010000)
    win_const_mgr.add_const('UNDNAME_NO_MS_THISTYPE',0x00000020)
    win_const_mgr.add_const('FILE_VOLUME_QUOTAS',0x00000020)
    win_const_mgr.add_const('WMSZ_BOTTOMLEFT',0x00000007)
    win_const_mgr.add_const('LINEERR_USERUSERINFOTOOBIG',0x80000051)
    win_const_mgr.add_const('LINEADDRCAPFLAGS_COMPLETIONID',0x00000800)
    win_const_mgr.add_const('BIF_RETURNONLYFSDIRS',0x00000001)
    win_const_mgr.add_const('TPM_BOTTOMALIGN',0x00000020)
    win_const_mgr.add_const('DBPROPVAL_ORS_INTEGRATEDINDEX',0x00000002)
    win_const_mgr.add_const('ISC_RET_CONFIDENTIALITY',0x00000010)
    win_const_mgr.add_const('IDM_UNGROUP',0x0000002D)
    win_const_mgr.add_const('TBS_NOTHUMB',0x00000080)
    win_const_mgr.add_const('MCI_VCR_UNFREEZE_OUTPUT',0x00020000)
    win_const_mgr.add_const('RBBS_NOVERT',0x00000010)
    win_const_mgr.add_const('DS_DOMAIN_PRIMARY',0x00000008)
    win_const_mgr.add_const('FWPM_FILTER_FLAG_NONE',0x00000000)
    win_const_mgr.add_const('NDIS_LINK_PARAMETERS_REVISION_1',0x00000001)
    win_const_mgr.add_const('FAX_ERR_NOT_SUPPORTED_ON_THIS_SKU',0x00001B63)
    win_const_mgr.add_const('ERROR_CLUSTER_NETWORK_EXISTS',0x000013B4)
    win_const_mgr.add_const('ICDRAW_BUFFER',0x00000100)
    win_const_mgr.add_const('DISPID_VIEWUPDATE',0x00000119)
    win_const_mgr.add_const('WINHTTP_QUERY_AUTHORIZATION',0x0000001C)
    win_const_mgr.add_const('ENABLE_PROCESSED_OUTPUT',0x00000001)
    win_const_mgr.add_const('TIMEMEDIAELEMENT_OFFSET',0x00000400)
    win_const_mgr.add_const('DEBUG_PROCESS_ONLY_THIS_PROCESS',0x00000002)
    win_const_mgr.add_const('TF_IPPMF_FORPROCESS',0x10000000)
    win_const_mgr.add_const('WEBPOST_ERROR_AUTOBIND_FAILED',0xC0042112)
    win_const_mgr.add_const('FR_PROP_BODYPARTSTRING',0x00000003)
    win_const_mgr.add_const('VARIABLE_PITCH',0x00000002)
    win_const_mgr.add_const('REG_NOTIFY_CHANGE_ATTRIBUTES',0x00000002)
    win_const_mgr.add_const('ACMDRIVERDETAILS_SUPPORTF_LOCAL',0x40000000)
    win_const_mgr.add_const('DEV_PORT_ARTI',0x00000007)
    win_const_mgr.add_const('LANG_JAPANESE',0x00000011)
    win_const_mgr.add_const('AUDIO_MIN_FRAMERATE',0x0000000A)
    win_const_mgr.add_const('NRB_FUNCTION_NVCACHE_POWER_MODE_RETURN',0x00000001)
    win_const_mgr.add_const('INTERNET_IDENTITY_FLAG_SHARED_CACHE',0x00000002)
    win_const_mgr.add_const('LCS_GM_GRAPHICS',0x00000002)
    win_const_mgr.add_const('LINECALLINFOSTATE_CALLID',0x00000040)
    win_const_mgr.add_const('ERROR_IP_ADDRESS_CONFLICT2',0x00000264)
    win_const_mgr.add_const('ERROR_DS_SRC_NAME_MISMATCH',0x00002124)
    win_const_mgr.add_const('ERROR_IP_ADDRESS_CONFLICT1',0x00000263)
    win_const_mgr.add_const('SHDID_COMPUTER_SHAREDDOCS',0x00000014)
    win_const_mgr.add_const('TKF_TOGGLEKEYSON',0x00000001)
    win_const_mgr.add_const('TBS_COMMAND_LOCALITY_FOUR',0x00000004)
    win_const_mgr.add_const('ISC_RET_INTEGRITY',0x00010000)
    win_const_mgr.add_const('PSM_UDI_C_PLANE',0x0000001D)
    win_const_mgr.add_const('PID_LINK_TARGET',0x00000002)
    win_const_mgr.add_const('MUI_QUERY_TYPE',0x00000001)
    win_const_mgr.add_const('MDM_V110_SPEED_14DOT4K',0x00000006)
    win_const_mgr.add_const('CMSG_DATA',0x00000001)
    win_const_mgr.add_const('SQL_QU_TABLE_DEFINITION',0x00000004)
    win_const_mgr.add_const('WIA_DPS_SHEET_FEEDER_REGISTRATION',0x00000C06)
    win_const_mgr.add_const('PROTO_IP_NAT',0x00002715)
    win_const_mgr.add_const('ERROR_CAN_NOT_DEL_LOCAL_WINS',0x00000FA1)
    win_const_mgr.add_const('ERROR_DS_SENSITIVE_GROUP_VIOLATION',0x00002139)
    win_const_mgr.add_const('LINEERR_NOMEM',0x80000044)
    win_const_mgr.add_const('CREATE_BREAKAWAY_FROM_JOB',0x01000000)
    win_const_mgr.add_const('NTMS_OMID_TYPE_FILESYSTEM_INFO',0x00000002)
    win_const_mgr.add_const('FD_GROUP_QOS',0x00000001)
    win_const_mgr.add_const('INTERNET_OPTION_EXTENDED_ERROR',0x00000018)
    win_const_mgr.add_const('CF_NOSCRIPTSEL',0x00800000)
    win_const_mgr.add_const('IMAGE_NT_OPTIONAL_HDR32_MAGIC',0x00000010)
    win_const_mgr.add_const('LINEERR_INVALTIMEOUT',0x8000003B)
    win_const_mgr.add_const('HTTP_QUERY_CONTENT_ID',0x00000003)
    win_const_mgr.add_const('LCMAP_UPPERCASE',0x00000200)
    win_const_mgr.add_const('PDH_LOG_TYPE_TRACE_GENERIC',0x00000005)
    win_const_mgr.add_const('NS_X500',0x00000028)
    win_const_mgr.add_const('DATA_SOURCE_WBEM',0x00000004)
    win_const_mgr.add_const('META_MOVETO',0x00000214)
    win_const_mgr.add_const('DXVA_CONFIG_BLEND_TYPE_FRONT_BUFFER',0x00000000)
    win_const_mgr.add_const('SHCNEE_ORDERCHANGED',0x00000002)
    win_const_mgr.add_const('ERROR_POPUP_ALREADY_ACTIVE',0x000005A6)
    win_const_mgr.add_const('TMT_VALIGN',0x00000FA7)
    win_const_mgr.add_const('DVB_TDT_TID',0x00000070)
    win_const_mgr.add_const('USER_COUNTRY_CODE_PARMNUM',0x00000018)
    win_const_mgr.add_const('MCI_DGV_SETAUDIO_QUALITY',0x00080000)
    win_const_mgr.add_const('MNC_EXECUTE',0x00000002)
    win_const_mgr.add_const('ERROR_PROTECTION_VIOLATION',0x00000073)
    win_const_mgr.add_const('MEDIA_ERASEABLE',0x00000001)
    win_const_mgr.add_const('DEFAULT_PITCH',0x00000000)
    win_const_mgr.add_const('DEBUG_PHYSICAL_DEFAULT',0x00000000)
    win_const_mgr.add_const('SQL_PAS_NO_BATCH',0x00000002)
    win_const_mgr.add_const('CC_FULLOPEN',0x00000002)
    win_const_mgr.add_const('BLUETOOTH_MAX_SERVICE_NAME_SIZE',0x00000100)
    win_const_mgr.add_const('DBTF_XPORT',0x00000002)
    win_const_mgr.add_const('ERROR_CANT_OPEN_ANONYMOUS',0x00000543)
    win_const_mgr.add_const('IME_SETCONVERSIONMODE',0x00000010)
    win_const_mgr.add_const('RPC_S_FP_UNDERFLOW',0x000006EA)
    win_const_mgr.add_const('IF_TYPE_VOICEOVERATM',0x00000098)
    win_const_mgr.add_const('JT_FAIL_RECEIVE',0x00000004)
    win_const_mgr.add_const('IDM_MULTILEVELREDO',0x0000001E)
    win_const_mgr.add_const('KSDSOUND_BUFFER_CTRL_HRTF_3D',0x40000000)
    win_const_mgr.add_const('GETSCALINGFACTOR',0x0000000E)
    win_const_mgr.add_const('ISC_SHOWUIALLCANDIDATEWINDOW',0x0000000F)
    win_const_mgr.add_const('PAN_SERIF_OBTUSE_COVE',0x00000003)
    win_const_mgr.add_const('DHCP_ENDPOINT_FLAG_CANT_MODIFY',0x00000001)
    win_const_mgr.add_const('CM_PROB_REGISTRY_TOO_LARGE',0x00000031)
    win_const_mgr.add_const('D3DTSS_TCI_SPHEREMAP',0x00040000)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2RAWCD_SUPPORTEDDATASECTORTYPES',0x00000108)
    win_const_mgr.add_const('CPLPAGE_KEYBOARD_SPEED',0x00000001)
    win_const_mgr.add_const('FOF_SIMPLEPROGRESS',0x00000100)
    win_const_mgr.add_const('KSPROBE_ALLOCATEMDL',0x00000010)
    win_const_mgr.add_const('GESTURE_OPENUP',0x00000000)
    win_const_mgr.add_const('CAL_SCALNAME',0x00000002)
    win_const_mgr.add_const('MMIOM_RENAME',0x00000006)
    win_const_mgr.add_const('MCI_DGV_SETAUDIO_RIGHT',0x00400000)
    win_const_mgr.add_const('EAP_E_SERVER_ROOT_CERT_LAST',0x804204FF)
    win_const_mgr.add_const('ERROR_EA_TABLE_FULL',0x00000115)
    win_const_mgr.add_const('OID_LTALK_IN_LENGTH_ERRORS',0x05020102)
    win_const_mgr.add_const('MAX_UCSCHAR',0x0010FFFF)
    win_const_mgr.add_const('CERT_TRUST_PUB_ALLOW_TRUST_MASK',0x00000003)
    win_const_mgr.add_const('BLUETOOTH_SERVICE_DISABLE',0x00000000)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2RAWCD_REQUESTEDWRITESPEED',0x0000010B)
    win_const_mgr.add_const('DTPB_USEERASEBKGND',0x00000004)
    win_const_mgr.add_const('DNS_TYPE_TEXT',0x00000010)
    win_const_mgr.add_const('OIC_QUES',0x00007F02)
    win_const_mgr.add_const('LDAP_SERVER_COPY_CONTROL_DONT_USE_COPY',0x00000001)
    win_const_mgr.add_const('WM_COPYDATA',0x0000004A)
    win_const_mgr.add_const('SQL_ODBC_SQL_OPT_IEF',0x00000049)
    win_const_mgr.add_const('SS_ETCHEDVERT',0x00000011)
    win_const_mgr.add_const('ERROR_SEGMENT_NOTIFICATION',0x000002BE)
    win_const_mgr.add_const('WB_MOVEWORDLEFT',0x00000004)
    win_const_mgr.add_const('IO_REPARSE_TAG_SYMLINK',0xA000000C)
    win_const_mgr.add_const('MDPROPVAL_MSF_DRILLDOWNLEVELTOP',0x00004000)
    win_const_mgr.add_const('BG_COPY_FILE_ALL',0x0000000F)
    win_const_mgr.add_const('ISC_REQ_STREAM',0x00008000)
    win_const_mgr.add_const('BG_E_ERROR_CONTEXT_GENERAL_TRANSPORT',0x8020000B)
    win_const_mgr.add_const('PHOTO_EXPOSUREPROGRAM_LANDSCAPE',0x00000008)
    win_const_mgr.add_const('EMR_SELECTCLIPPATH',0x00000043)
    win_const_mgr.add_const('SI_RESET_SACL_TREE',0x00008000)
    win_const_mgr.add_const('SP_HANDSHAKING',0x00000010)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_REMOTE_LOGON',0x80100000)
    win_const_mgr.add_const('COD_IMAGING_MINOR_PRINTER_MASK',0x00000020)
    win_const_mgr.add_const('MCI_VCR_GETDEVCAPS_CAN_PREVIEW',0x00004008)
    win_const_mgr.add_const('NETSH_MAX_CMD_TOKEN_LENGTH',0x00000080)
    win_const_mgr.add_const('ADS_PRINTER_PAPER_PROBLEM',0x00000007)
    win_const_mgr.add_const('SPI_GETPOWEROFFACTIVE',0x00000054)
    win_const_mgr.add_const('DPNHINITIALIZE_DISABLELOCALFIREWALLSUPPORT',0x00000002)
    win_const_mgr.add_const('MCI_VCR_MARK_ERASE',0x00020000)
    win_const_mgr.add_const('AA_F_CREATE',0x00000200)
    win_const_mgr.add_const('AUTO_DETECT_PACKET_TYPE',0xFFFFFFFF)
    win_const_mgr.add_const('HIST_VIEWTREE',0x00000004)
    win_const_mgr.add_const('CF_UNICODETEXT',0x0000000D)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_SPEAKEROFF',0x00000016)
    win_const_mgr.add_const('MCI_DGV_FILE_MODE_IDLE_S',0x00008007)
    win_const_mgr.add_const('DRV_LOAD',0x00000001)
    win_const_mgr.add_const('OID_CO_DELETE_ADDRESS',0xFE000005)
    win_const_mgr.add_const('SQL_TXN_REPEATABLE_READ',0x00000004)
    win_const_mgr.add_const('D3DFVFCAPS_DONOTSTRIPELEMENTS',0x00080000)
    win_const_mgr.add_const('ERROR_DS_OBJECT_CLASS_REQUIRED',0x0000207B)
    win_const_mgr.add_const('PBT_APMRESUMESUSPEND',0x00000007)
    win_const_mgr.add_const('UAS_ROLE_PRIMARY',0x00000003)
    win_const_mgr.add_const('MCI_DGV_FILE_S',0x00008002)
    win_const_mgr.add_const('PAN_LETT_OBLIQUE_OFF_CENTER',0x0000000E)
    win_const_mgr.add_const('PSH_USEHICON',0x00000002)
    win_const_mgr.add_const('ERROR_PROFILING_NOT_STOPPED',0x00000227)
    win_const_mgr.add_const('LINECALLFEATURE_SETUPCONF',0x01000000)
    win_const_mgr.add_const('PROCESSOR_ARCHITECTURE_UNKNOWN',0x0000FFFF)
    win_const_mgr.add_const('HTTP_REQUEST_AUTH_FLAG_TOKEN_FOR_CACHED_CRED',0x00000001)
    win_const_mgr.add_const('SDP_ATTRIB_RECORD_STATE',0x00000002)
    win_const_mgr.add_const('CMM_LOGOICON',0x00000006)
    win_const_mgr.add_const('NT351_INTERFACE_SIZE',0x00000040)
    win_const_mgr.add_const('DISPID_COLLECTION_MIN',0x000F4240)
    win_const_mgr.add_const('ICINSTALL_UNICODE',0x00008000)
    win_const_mgr.add_const('SI_USER_FAILED',0x00000002)
    win_const_mgr.add_const('ERROR_NOLOGON_SERVER_TRUST_ACCOUNT',0x00000711)
    win_const_mgr.add_const('IF_MAX_PHYS_ADDRESS_LENGTH',0x00000020)
    win_const_mgr.add_const('DDFXCAPS_BLTMIRRORUPDOWN',0x00000080)
    win_const_mgr.add_const('IRTIR_TASK_FINISHED',0x00000004)
    win_const_mgr.add_const('STATE_SYSTEM_SELECTED',0x00000002)
    win_const_mgr.add_const('POLICY_ERRV_SUBNET_DEF_FLOW_COUNT',0x00000005)
    win_const_mgr.add_const('IMGLOAD_MASK',0x01F00000)
    win_const_mgr.add_const('COLOR_CAPTIONTEXT',0x00000009)
    win_const_mgr.add_const('ERROR_SEM_TIMEOUT',0x00000079)
    win_const_mgr.add_const('SCSI_IOCTL_DATA_UNSPECIFIED',0x00000002)
    win_const_mgr.add_const('FILEOP_DOIT',0x00000001)
    win_const_mgr.add_const('FILE_SUPPORTS_OBJECT_IDS',0x00010000)
    win_const_mgr.add_const('LINEADDRFEATURE_PICKUPGROUP',0x00000200)
    win_const_mgr.add_const('SYNC_HANDLERTYPE_COMPUTERS',0x00000005)
    win_const_mgr.add_const('PORT_XYPLEXMUX',0x000000AD)
    win_const_mgr.add_const('TIMETRANSITIONELEMENT_OFFSET',0x00001500)
    win_const_mgr.add_const('SIOM_RESERVED_SHARED',0x00000000)
    win_const_mgr.add_const('FWPM_CALLOUT_FLAG_USES_PROVIDER_CONTEXT',0x00020000)
    win_const_mgr.add_const('F_END',0x00000006)
    win_const_mgr.add_const('CERT_NAME_DISABLE_IE4_UTF8_FLAG',0x00010000)
    win_const_mgr.add_const('SV_TYPE_DOMAIN_ENUM',0x80000000)
    win_const_mgr.add_const('DEBUG_REQUEST_SET_ADDITIONAL_CREATE_OPTIONS',0x00000005)
    win_const_mgr.add_const('DISPID_SAVEDOCUMENT',0x00000004)
    win_const_mgr.add_const('MSIM_DISPID_ON_NM_CANCELLED',0x00000E15)
    win_const_mgr.add_const('SQL_EN_ON',0x00000001)
    win_const_mgr.add_const('DISPID_ADDSEARCHPROVIDER',0x0000000E)
    win_const_mgr.add_const('CTRY_RUSSIA',0x00000007)
    win_const_mgr.add_const('COD_LAN_ACCESS_BIT_OFFSET',0x00000005)
    win_const_mgr.add_const('DDPF_ALPHAPIXELS',0x00000001)
    win_const_mgr.add_const('D3DCS_BACK',0x00000020)
    win_const_mgr.add_const('ERROR_DS_NO_RIDS_ALLOCATED',0x00002010)
    win_const_mgr.add_const('RPC_C_AUTHZ_DCE',0x00000002)
    win_const_mgr.add_const('URLACTION_ACTIVEX_OVERRIDE_OBJECT_SAFETY',0x00001201)
    win_const_mgr.add_const('BAUD_9600',0x00000800)
    win_const_mgr.add_const('MCI_VCR_FREEZE_FIELD',0x00040000)
    win_const_mgr.add_const('SQL_BP_DELETE',0x00000002)
    win_const_mgr.add_const('ERROR_DS_RANGE_CONSTRAINT',0x00002082)
    win_const_mgr.add_const('PID_SECURITY',0x00000013)
    win_const_mgr.add_const('ERROR_ABIOS_ERROR',0x0000021A)
    win_const_mgr.add_const('DN_NEED_RESTART',0x00000100)
    win_const_mgr.add_const('MIXERLINE_TARGETTYPE_UNDEFINED',0x00000000)
    win_const_mgr.add_const('PERCEIVEDFLAG_WMSDK',0x00000020)
    win_const_mgr.add_const('URLMON_OPTION_URL_ENCODING',0x10000004)
    win_const_mgr.add_const('DBCOMPUTEMODE_NOTCOMPUTED',0x00000003)
    win_const_mgr.add_const('CF_ENABLEHOOK',0x00000008)
    win_const_mgr.add_const('FILE_ATTRIBUTE_SYSTEM',0x00000004)
    win_const_mgr.add_const('MCI_DGV_MONITOR_SOURCE',0x00020000)
    win_const_mgr.add_const('PE_ATTRIB_TYPE_POLICY_LOCATOR',0x00000001)
    win_const_mgr.add_const('DI_FLAGSEX_EXCLUDE_OLD_INET_DRIVERS',0x00800000)
    win_const_mgr.add_const('RPC_S_NO_CONTEXT_AVAILABLE',0x000006E5)
    win_const_mgr.add_const('PROTO_TYPE_MS1',0x00000003)
    win_const_mgr.add_const('DI_NOSELECTICONS',0x40000000)
    win_const_mgr.add_const('ASP_MD_UT_APP',0x00000065)
    win_const_mgr.add_const('SUBLANG_SAMI_LULE_NORWAY',0x00000004)
    win_const_mgr.add_const('CREDUIWIN_CHECKBOX',0x00000002)
    win_const_mgr.add_const('CERT_DISPWELL_TRUST_ADD_LEAF_CERT',0x00000005)
    win_const_mgr.add_const('ERROR_SXS_XML_E_BADCHARINSTRING',0x000036D2)
    win_const_mgr.add_const('RTM_ROUTE_FLAGS_ONES_NETBC',0x00004000)
    win_const_mgr.add_const('IDB_VIEW_LARGE_COLOR',0x00000005)
    win_const_mgr.add_const('WM_PRINTCLIENT',0x00000318)
    win_const_mgr.add_const('FACILITY_STATE_MANAGEMENT',0x00000022)
    win_const_mgr.add_const('TMT_PROGRESSCHUNKSIZE',0x0000096B)
    win_const_mgr.add_const('MAPI_E_LOGON_FAILURE',0x00000003)
    win_const_mgr.add_const('CBM_FIRST',0x00001700)
    win_const_mgr.add_const('PARMNUM_BASE_INFOLEVEL',0x000003E8)
    win_const_mgr.add_const('SQL_FN_TSI_HOUR',0x00000008)
    win_const_mgr.add_const('IDC_CV_ICONDISPLAY',0x000000A5)
    win_const_mgr.add_const('SQLAOPVARP',0x00000033)
    win_const_mgr.add_const('STATE_SYSTEM_SELECTABLE',0x00200000)
    win_const_mgr.add_const('LDAP_FILTER_OR',0x00000000)
    win_const_mgr.add_const('SQL_CONVERT_VARBINARY',0x00000045)
    win_const_mgr.add_const('IMAGE_ICON',0x00000001)
    win_const_mgr.add_const('LBS_NOTIFY',0x00000001)
    win_const_mgr.add_const('DEBUG_PROCESS',0x00000001)
    win_const_mgr.add_const('WINHTTP_QUERY_ACCEPT_ENCODING',0x0000001A)
    win_const_mgr.add_const('FILE_NOTIFY_CHANGE_LAST_WRITE',0x00000010)
    win_const_mgr.add_const('SQL_MAX_ROW_SIZE',0x00000068)
    win_const_mgr.add_const('D3D10_SHADER_SKIP_VALIDATION',0x00000001)
    win_const_mgr.add_const('ICC_INTERNET_CLASSES',0x00000800)
    win_const_mgr.add_const('SUBLANG_MALAYALAM_INDIA',0x00000001)
    win_const_mgr.add_const('ODBC_ERROR_GENERAL_ERR',0x00000001)
    win_const_mgr.add_const('REO_READWRITEMASK',0x0000003F)
    win_const_mgr.add_const('ERROR_NTLM_BLOCKED',0x00000791)
    win_const_mgr.add_const('SQL_CONCUR_ROWVER',0x00000003)
    win_const_mgr.add_const('SQL_CVT_BIT',0x00001000)
    win_const_mgr.add_const('IF_TYPE_RADSL',0x0000005F)
    win_const_mgr.add_const('ERROR_NO_SUCH_ALIAS',0x00000560)
    win_const_mgr.add_const('NETE_NETNOTSTARTED',0x00000007)
    win_const_mgr.add_const('IMPORTANCE_NORMAL_SET',0x00000003)
    win_const_mgr.add_const('APPCOMMAND_BROWSER_HOME',0x00000007)
    win_const_mgr.add_const('D3D10_DEFAULT_MIP_LOD_BIAS',0x00000000)
    win_const_mgr.add_const('NDIS_STATISTICS_FLAGS_VALID_DIRECTED_BYTES_XMIT',0x00080000)
    win_const_mgr.add_const('AA_F_DELETE',0x00000400)
    win_const_mgr.add_const('FILE_COMPRESSION_NONE',0x00000000)
    win_const_mgr.add_const('DRM_DEVICE_REGISTER_TYPE_STORAGE',0x00000002)
    win_const_mgr.add_const('SUBLANG_THAI_THAILAND',0x00000001)
    win_const_mgr.add_const('FWPM_CONTEXT_ALE_SET_CONNECTION_REQUIRE_IPSEC_SECURITY',0x00000002)
    win_const_mgr.add_const('IDM_TRIED_DOVERB',0x0000003D)
    win_const_mgr.add_const('LSA_TLN_DISABLED_CONFLICT',0x00000004)
    win_const_mgr.add_const('PROCESSOR_ARCHITECTURE_ALPHA',0x00000002)
    win_const_mgr.add_const('HH_SYNC',0x00000009)
    win_const_mgr.add_const('CALG_OID_INFO_PARAMETERS',0xFFFFFFFE)
    win_const_mgr.add_const('SECPKG_ATTR_USER_FLAGS',0x0000000B)
    win_const_mgr.add_const('MDM_PROTOCOLID_PIAFS',0x00000009)
    win_const_mgr.add_const('STI_ONLINESTATE_OPERATIONAL',0x00000001)
    win_const_mgr.add_const('SI_EDIT_PROPERTIES',0x00000080)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MAJOR_SOFTWARE',0x00040000)
    win_const_mgr.add_const('SYSPAL_NOSTATIC256',0x00000003)
    win_const_mgr.add_const('FLAG_NO_COMPUTER',0x00000002)
    win_const_mgr.add_const('STRETCHBLT',0x00000800)
    win_const_mgr.add_const('JOB_NOTIFY_FIELD_PRIORITY',0x0000000E)
    win_const_mgr.add_const('IDD_PASTESPECIAL4',0x00000454)
    win_const_mgr.add_const('SQL_ODBC_API_CONFORMANCE',0x00000009)
    win_const_mgr.add_const('UF_TEMP_DUPLICATE_ACCOUNT',0x00000100)
    win_const_mgr.add_const('DS_UNKNOWN_ADDRESS_TYPE',0x00000000)
    win_const_mgr.add_const('HTTP_SEND_RESPONSE_FLAG_BUFFER_DATA',0x00000004)
    win_const_mgr.add_const('D3DTA_TFACTOR',0x00000003)
    win_const_mgr.add_const('SQL_INTERVAL',0x0000000A)
    win_const_mgr.add_const('META_SETDIBTODEV',0x00000000)
    win_const_mgr.add_const('WIA_PAGE_JIS_4A',0x00000033)
    win_const_mgr.add_const('WINEFS_SETUSERKEY_SET_CAPABILITIES',0x00000001)
    win_const_mgr.add_const('MD_ERROR_SUB502_TIMEOUT',0x00000001)
    win_const_mgr.add_const('LVIS_STATEIMAGEMASK',0x0000F000)
    win_const_mgr.add_const('KP_CLIENT_RANDOM',0x00000015)
    win_const_mgr.add_const('TSF_NO_SECURITY',0x00000008)
    win_const_mgr.add_const('CFU_UNDERLINETHICKDOTTED',0x00000011)
    win_const_mgr.add_const('DOMAIN_GROUP_RID_POLICY_ADMINS',0x00000208)
    win_const_mgr.add_const('SPFILENOTIFY_FILEOPDELAYED',0x00000014)
    win_const_mgr.add_const('HTTP_QUERY_CONTENT_MD5',0x00000034)
    win_const_mgr.add_const('ERROR_INVALID_IMPORT_OF_NON_DLL',0x000004FC)
    win_const_mgr.add_const('SRRF_NOEXPAND',0x10000000)
    win_const_mgr.add_const('RTL_CRITICAL_SECTION_DEBUG_FLAG_STATIC_INIT',0x00000001)
    win_const_mgr.add_const('MF_FLAGS_CREATE_BUT_NO_SHOW_DISABLED',0x00000008)
    win_const_mgr.add_const('OFFLINE_STATUS_REMOTE',0x00000002)
    win_const_mgr.add_const('IPPORT_FTP_DATA',0x00000014)
    win_const_mgr.add_const('CSIDL_FLAG_DONT_VERIFY',0x00004000)
    win_const_mgr.add_const('CI_STATE_LOW_DISK',0x00010000)
    win_const_mgr.add_const('SQL_FILE_QUALIFIER',0x00000002)
    win_const_mgr.add_const('CTRY_MONGOLIA',0x000003D0)
    win_const_mgr.add_const('LANG_ZULU',0x00000035)
    win_const_mgr.add_const('DBPROPVAL_ASYNCH_SEQUENTIALPOPULATION',0x00000002)
    win_const_mgr.add_const('ERROR_BAD_LENGTH',0x00000018)
    win_const_mgr.add_const('CR_PROP_CAXCHGCERTCRLCHAIN',0x00000021)
    win_const_mgr.add_const('STREAMBUFFER_EC_BASE',0x00000326)
    win_const_mgr.add_const('OLEMISC_SIMPLEFRAME',0x00010000)
    win_const_mgr.add_const('TAPE_DRIVE_ERASE_LONG',0x00000020)
    win_const_mgr.add_const('OBM_REDUCED',0x00007FEA)
    win_const_mgr.add_const('IDD_DYNAWIZ_SELECT_PREVPAGE',0x00002711)
    win_const_mgr.add_const('SPMODE_SHELL',0x00000001)
    win_const_mgr.add_const('NETINFO_DLL16',0x00000001)
    win_const_mgr.add_const('LONG_PTR_MAX',0x7FFFFFFF)
    win_const_mgr.add_const('PHONELAMPMODE_DUMMY',0x00000001)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_REQUESTEDROTATIONTYPEISPURECAV',0x00000112)
    win_const_mgr.add_const('OLEMISC_SETCLIENTSITEFIRST',0x00020000)
    win_const_mgr.add_const('OID_802_5_CURRENT_ADDRESS',0x02010102)
    win_const_mgr.add_const('SDP_ATTRIB_INFO_TIME_TO_LIVE',0x00000007)
    win_const_mgr.add_const('D3DPTEXTURECAPS_VOLUMEMAP',0x00002000)
    win_const_mgr.add_const('HSHELL_WINDOWREPLACED',0x0000000D)
    win_const_mgr.add_const('MFE_OLD_ROUTER',0x0000000B)
    win_const_mgr.add_const('ACCESS_ACCESS_LIST_PARMNUM',0x00000004)
    win_const_mgr.add_const('WS_EX_STATICEDGE',0x00020000)
    win_const_mgr.add_const('DMDUP_HORIZONTAL',0x00000003)
    win_const_mgr.add_const('ERROR_DATA_NOT_ACCEPTED',0x00000250)
    win_const_mgr.add_const('D3DDEVCAPS2_CAN_STRETCHRECT_FROM_TEXTURES',0x00000010)
    win_const_mgr.add_const('R2_MERGENOTPEN',0x0000000C)
    win_const_mgr.add_const('ERROR_CALLBACK_POP_STACK',0x00000300)
    win_const_mgr.add_const('SPI_GETAUDIODESCRIPTION',0x00000074)
    win_const_mgr.add_const('LANG_ROMANSH',0x00000017)
    win_const_mgr.add_const('HHWIN_PROP_CHANGE_TITLE',0x00000001)
    win_const_mgr.add_const('CRYPT_NEXT',0x00000002)
    win_const_mgr.add_const('DEBUG_DUMP_TRACE_LOG',0x00000404)
    win_const_mgr.add_const('IPSEC_SA_BUNDLE_FLAG_ALLOW_NULL_TARGET_NAME_MATCH',0x00000200)
    win_const_mgr.add_const('WS_SYSMENU',0x00080000)
    win_const_mgr.add_const('STANDARD_RIGHTS_REQUIRED',0x000F0000)
    win_const_mgr.add_const('DRM_LICENSE_STATE_DATA_SAP_PRESENT',0x00000004)
    win_const_mgr.add_const('DS_REPSYNCALL_PUSH_CHANGES_OUTWARD',0x00000020)
    win_const_mgr.add_const('AE_NORMAL',0x00000000)
    win_const_mgr.add_const('EM_SETMODIFY',0x000000B9)
    win_const_mgr.add_const('LINEADDRCAPFLAGS_QUEUE',0x01000000)
    win_const_mgr.add_const('PRINTER_ACCESS_ADMINISTER',0x00000004)
    win_const_mgr.add_const('SECPKG_CALL_THREAD_TERM',0x00000080)
    win_const_mgr.add_const('MD_DIRBROW_SHOW_EXTENSION',0x00000010)
    win_const_mgr.add_const('HHWIN_BUTTON_BROWSE_BCK',0x00000001)
    win_const_mgr.add_const('COLOR_WINDOWFRAME',0x00000006)
    win_const_mgr.add_const('EN_LINK',0x00000070)
    win_const_mgr.add_const('ERROR_DS_NOT_SUPPORTED',0x00002040)
    win_const_mgr.add_const('PORT_KSHELL',0x00000220)
    win_const_mgr.add_const('SUBLANG_SPANISH_MEXICAN',0x00000002)
    win_const_mgr.add_const('SQL_API_SQLPROCEDURES',0x00000043)
    win_const_mgr.add_const('WINEVENT_OPCODE_RESUME',0x00000007)
    win_const_mgr.add_const('CERT_AUTH_ROOT_AUTO_UPDATE_DISABLE_PARTIAL_CHAIN_LOGGING_FLAG',0x00000002)
    win_const_mgr.add_const('WLX_SAS_TYPE_SC_REMOVE',0x00000006)
    win_const_mgr.add_const('ILC_COLOR',0x00000000)
    win_const_mgr.add_const('ISR_RESVD_REG',0x00000003)
    win_const_mgr.add_const('PRINTACTION_NETINSTALLLINK',0x00000003)
    win_const_mgr.add_const('IMAGE_SYM_TYPE_MOE',0x0000000B)
    win_const_mgr.add_const('OF_VERIFY',0x00000400)
    win_const_mgr.add_const('SPINST_LOGCONFIGS_ARE_OVERRIDES',0x00040000)
    win_const_mgr.add_const('SVSI_CHECK2',0x00000200)
    win_const_mgr.add_const('OPTION_TFTP_SERVER_NAME',0x00000042)
    win_const_mgr.add_const('JIFMK_COM',0x0000FFFE)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_SYSTEM_OPS',0x00000225)
    win_const_mgr.add_const('IDM_SENDBACKWARD',0x00000020)
    win_const_mgr.add_const('STGM_DIRECT_SWMR',0x00400000)
    win_const_mgr.add_const('SOL_SOCKET',0x00000000)
    win_const_mgr.add_const('WININETINFO_OPTION_LOCK_HANDLE',0x0000FFFE)
    win_const_mgr.add_const('SDP_ATTRIB_SYNCH_SUPPORTED_DATA_STORES_LIST',0x00000301)
    win_const_mgr.add_const('SQL_INTEGER',0x00000004)
    win_const_mgr.add_const('WINHTTP_AUTH_TARGET_SERVER',0x00000000)
    win_const_mgr.add_const('SM_CYCAPTION',0x00000004)
    win_const_mgr.add_const('DDOVER_REFRESHALL',0x00020000)
    win_const_mgr.add_const('NTDSSITECONN_OPT_DISABLE_COMPRESSION',0x00000001)
    win_const_mgr.add_const('ATTR_FIXEDCONVERTED',0x00000005)
    win_const_mgr.add_const('CERT_ALT_NAME_X400_ADDRESS',0x00000004)
    win_const_mgr.add_const('MSIM_DISPID_ONLOCALSTATECHANGERESULT',0x00000E08)
    win_const_mgr.add_const('ERROR_SERVICE_NOT_ACTIVE',0x00000426)
    win_const_mgr.add_const('TREE_SEC_INFO_SET',0x00000001)
    win_const_mgr.add_const('CRYPT_KEEP_TIME_VALID',0x00000080)
    win_const_mgr.add_const('TMT_SMALLCAPTIONFONT',0x00000322)
    win_const_mgr.add_const('TBCDRF_NOOFFSET',0x00040000)
    win_const_mgr.add_const('C1_PUNCT',0x00000010)
    win_const_mgr.add_const('PRINTER_CHANGE_DELETE_PORT',0x00400000)
    win_const_mgr.add_const('PXE_TRACE_WARNING',0x00040000)
    win_const_mgr.add_const('REPL_STATE_OK',0x00000000)
    win_const_mgr.add_const('SPI_SETCOMBOBOXANIMATION',0x00001005)
    win_const_mgr.add_const('SQL_CN_DIFFERENT',0x00000001)
    win_const_mgr.add_const('COR_NATIVE_LINK_CUSTOM_VALUE_CC',0x00000012)
    win_const_mgr.add_const('RBAB_ADDBAND',0x00000002)
    win_const_mgr.add_const('MIXERCONTROL_CT_CLASS_TIME',0x60000000)
    win_const_mgr.add_const('SETUP_FORCECRL_FLAG',0x00000100)
    win_const_mgr.add_const('NTDDI_WIN2KSP2',0x05000200)
    win_const_mgr.add_const('LINECALLCOMPLMODE_INTRUDE',0x00000004)
    win_const_mgr.add_const('ERROR_DS_BAD_RDN_ATT_ID_SYNTAX',0x000020C8)
    win_const_mgr.add_const('NTDSSETTINGS_DEFAULT_SERVER_REDUNDANCY',0x00000002)
    win_const_mgr.add_const('TF_TMAE_NOACTIVATEKEYBOARDLAYOUT',0x00000020)
    win_const_mgr.add_const('SELCERT_VALIDITY',0x00000068)
    win_const_mgr.add_const('TRACE_MESSAGE_FLAG_MASK',0x0000FFFF)
    win_const_mgr.add_const('X3_EMPTY_INST_WORD_POS_X',0x0000000E)
    win_const_mgr.add_const('DOT11_FLAGS_80211B_CHANNEL_AGILITY',0x00000004)
    win_const_mgr.add_const('D3DTEXOPCAPS_DISABLE',0x00000001)
    win_const_mgr.add_const('IMAGE_ARCHIVE_START_SIZE',0x00000008)
    win_const_mgr.add_const('WINEVENT_KEYWORD_EVENTLOG_CLASSIC',0x80000000000000)
    win_const_mgr.add_const('ERROR_INVALID_PASSWORDNAME',0x000004C0)
    win_const_mgr.add_const('SHGDFIL_NETRESOURCE',0x00000002)
    win_const_mgr.add_const('LDAP_AUTH_SIMPLE',0x00000080)
    win_const_mgr.add_const('MIXERCONTROL_CT_CLASS_SWITCH',0x20000000)
    win_const_mgr.add_const('EAP_E_SERVER_CERT_NOT_FOUND',0x80420200)
    win_const_mgr.add_const('IDC_EL_MANUAL',0x000000D4)
    win_const_mgr.add_const('PRIMARY_CACHE_SHARED',0x00000001)
    win_const_mgr.add_const('DLGC_STATIC',0x00000100)
    win_const_mgr.add_const('_WIN32_IE_IE30',0x00000300)
    win_const_mgr.add_const('ACM_METRIC_COUNT_HARDWARE',0x00000006)
    win_const_mgr.add_const('OID_FDDI_PORT_LER_ALARM',0x03030271)
    win_const_mgr.add_const('DISPID_IWBSCRIPTCONTROL_ONVISIBILITYCHANGE',0x0000000A)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_MUTE',0x00000012)
    win_const_mgr.add_const('DISPID_TABLEPARAMS_NUMCOLS',0x00000002)
    win_const_mgr.add_const('LVS_EX_GRIDLINES',0x00000001)
    win_const_mgr.add_const('GCS_DELTASTART',0x00000100)
    win_const_mgr.add_const('MM_STREAM_ERROR',0x000003D7)
    win_const_mgr.add_const('ERROR_RESOURCE_PROPERTIES_STORED',0x000013A0)
    win_const_mgr.add_const('DDFXCAPS_BLTARITHSTRETCHY',0x00000020)
    win_const_mgr.add_const('AMCONTROL_COLORINFO_PRESENT',0x00000080)
    win_const_mgr.add_const('ERROR_CLASS_HAS_WINDOWS',0x00000584)
    win_const_mgr.add_const('WPF_NO_RECURSIVE_POST',0x00000001)
    win_const_mgr.add_const('CAUSE_INCOMPATIBLE_DESTINATION',0x00000058)
    win_const_mgr.add_const('RPC_S_NOTHING_TO_EXPORT',0x000006DA)
    win_const_mgr.add_const('DDL_ARCHIVE',0x00000020)
    win_const_mgr.add_const('MMSYSERR_NOERROR',0x00000000)
    win_const_mgr.add_const('FPS_ABORTING',0x20200000)
    win_const_mgr.add_const('LDAP_ABANDON_CMD',0x00000050)
    win_const_mgr.add_const('LOCALE_IDIGITSUBSTITUTION',0x00001014)
    win_const_mgr.add_const('WINHTTP_QUERY_EXPECT',0x00000044)
    win_const_mgr.add_const('DEBUG_FORMAT_USER_SMALL_HANDLE_DATA',0x00000002)
    win_const_mgr.add_const('IF_TYPE_SDLC',0x00000011)
    win_const_mgr.add_const('NDIS_802_11_AUTH_REQUEST_PAIRWISE_ERROR',0x00000006)
    win_const_mgr.add_const('LANG_TURKISH',0x00000001)
    win_const_mgr.add_const('CRYPT_DECRYPT_RSA_NO_PADDING_CHECK',0x00000020)
    win_const_mgr.add_const('SQL_SRJO_FULL_OUTER_JOIN',0x00000008)
    win_const_mgr.add_const('BG_E_ERROR_INFORMATION_UNAVAILABLE',0x8020000F)
    win_const_mgr.add_const('IMAGE_REL_AMD64_ADDR32',0x00000002)
    win_const_mgr.add_const('BLLI_L2_X75',0x0000000D)
    win_const_mgr.add_const('ERROR_DS_DRA_OBJ_NC_MISMATCH',0x00002161)
    win_const_mgr.add_const('ERROR_INVALID_ADDRESS',0x000001E7)
    win_const_mgr.add_const('TIMEMEDIAPLAYERCONTROL_OFFSET',0x00001300)
    win_const_mgr.add_const('MFE_NOT_LAST_HOP',0x0000000A)
    win_const_mgr.add_const('PID_MISC_OWNER',0x00000004)
    win_const_mgr.add_const('SQL_DS_CASCADE',0x00000004)
    win_const_mgr.add_const('INTERNET_OPTION_COOKIES_3RD_PARTY',0x00000056)
    win_const_mgr.add_const('FWPM_CONTEXT_ALE_SET_CONNECTION_REQUIRE_IPSEC_ENCRYPTION',0x00000008)
    win_const_mgr.add_const('NI_OPENCANDIDATE',0x00000010)
    win_const_mgr.add_const('SQL_SPEC_MAJOR',0x00000003)
    win_const_mgr.add_const('UAS_ROLE_STANDALONE',0x00000000)
    win_const_mgr.add_const('IMAGE_REL_PPC_ABSOLUTE',0x00000000)
    win_const_mgr.add_const('IMAGE_REL_IA64_SREL22',0x00000012)
    win_const_mgr.add_const('WM_PAINTCLIPBOARD',0x00000309)
    win_const_mgr.add_const('NS_NETBT',0x0000000D)
    win_const_mgr.add_const('IDC_EL_LINKSLISTBOX',0x000000CE)
    win_const_mgr.add_const('TXFS_RM_STATE_SHUTTING_DOWN',0x00000003)
    win_const_mgr.add_const('DRM_LOCKBOXTYPE_WHITEBOX',0x00000001)
    win_const_mgr.add_const('LINEERR_INVALTERMINALMODE',0x8000003A)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2TAO_EXPECTEDTABLEOFCONTENTS',0x0000010A)
    win_const_mgr.add_const('WMDM_FILE_ATTR_READONLY',0x01000000)
    win_const_mgr.add_const('QOS_NOT_SPECIFIED',0xFFFFFFFF)
    win_const_mgr.add_const('CREATE_PROCESS_DEBUG_EVENT',0x00000003)
    win_const_mgr.add_const('MAX_VENDORNAME',0x00000020)
    win_const_mgr.add_const('REPL_STATE_NEVER_REPLICATED',0x00000003)
    win_const_mgr.add_const('FACILITY_CMI',0x00000036)
    win_const_mgr.add_const('HOTKEYF_EXT',0x00000008)
    win_const_mgr.add_const('EDITF_ALLOWSIGNINGWITHOLDCAKEY',0x04000000)
    win_const_mgr.add_const('PID_PAGECOUNT',0x0000000E)
    win_const_mgr.add_const('DEBUG_DUMP_FILE_ORIGINAL_CAB_INDEX',0x00000000)
    win_const_mgr.add_const('BEST_COMPLETE',0x00000002)
    win_const_mgr.add_const('CM_DEVCAP_RAWDEVICEOK',0x00000040)
    win_const_mgr.add_const('EMR_CLOSEFIGURE',0x0000003D)
    win_const_mgr.add_const('SRRF_RM_ANY',0x00000000)
    win_const_mgr.add_const('ED_AUDIO_9',0x00000100)
    win_const_mgr.add_const('ED_AUDIO_8',0x00000080)
    win_const_mgr.add_const('COPY_FILE_COPY_SYMLINK',0x00000800)
    win_const_mgr.add_const('GCPCLASS_LATINNUMBER',0x00000005)
    win_const_mgr.add_const('TVS_EX_MULTISELECT',0x00000002)
    win_const_mgr.add_const('ED_AUDIO_2',0x00000002)
    win_const_mgr.add_const('IPX_PROTOCOL_LOCAL',0x00000001)
    win_const_mgr.add_const('ED_AUDIO_7',0x00000040)
    win_const_mgr.add_const('ED_AUDIO_6',0x00000020)
    win_const_mgr.add_const('ED_AUDIO_5',0x00000010)
    win_const_mgr.add_const('ED_AUDIO_4',0x00000008)
    win_const_mgr.add_const('SQL_PC_PSEUDO',0x00000002)
    win_const_mgr.add_const('ERROR_INSUFFICIENT_LOGON_INFO',0x00000260)
    win_const_mgr.add_const('SV_MINKEEPCOMPLSEARCH_PARMNUM',0x0000020C)
    win_const_mgr.add_const('WMS_CONTAINER_ALLOW_PLAYLIST_SKIP_FORWARD',0x00000100)
    win_const_mgr.add_const('DSOP_SCOPE_TYPE_TARGET_COMPUTER',0x00000001)
    win_const_mgr.add_const('URLACTION_INFODELIVERY_NO_REMOVING_SUBSCRIPTIONS',0x00001D05)
    win_const_mgr.add_const('CREDUI_FLAGS_DO_NOT_PERSIST',0x00000002)
    win_const_mgr.add_const('LINEAGENTSTATEEX_NOTREADY',0x00000001)
    win_const_mgr.add_const('WS_OVERLAPPED',0x00000000)
    win_const_mgr.add_const('MOVEFILE_REPLACE_EXISTING',0x00000001)
    win_const_mgr.add_const('KSPROBE_ALLOWFORMATCHANGE',0x00000080)
    win_const_mgr.add_const('GQOS_ERRORVALUE_UNKNOWN',0xFFFFFFFF)
    win_const_mgr.add_const('DISABLE_BTB_FIX',0x00000001)
    win_const_mgr.add_const('FW_EXTRABOLD',0x00000320)
    win_const_mgr.add_const('NCRYPT_ALLOW_EXPORT_FLAG',0x00000001)
    win_const_mgr.add_const('IDS_CAP_FILE_WRITE_ERROR',0x000001AE)
    win_const_mgr.add_const('KERB_ETYPE_RSA_SHA1_CMS',0x0000000B)
    win_const_mgr.add_const('SQL_API_SQLBULKOPERATIONS',0x00000018)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW3_SETINTERVAL',0x0000048A)
    win_const_mgr.add_const('ACTION_REVOCATION_DEFAULT_ONLINE',0x00010000)
    win_const_mgr.add_const('DDCAPS_OVERLAYFOURCC',0x00002000)
    win_const_mgr.add_const('MD_EXTLOG_DATE',0x00000001)
    win_const_mgr.add_const('CTRY_KAZAKSTAN',0x00000007)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_ROLLBACK',0x00000008)
    win_const_mgr.add_const('SQL_QI_OFF',0x00000000)
    win_const_mgr.add_const('MD_NOTIFY_SECURE_PORT',0x00000001)
    win_const_mgr.add_const('ICDECOMPRESS_NOTKEYFRAME',0x08000000)
    win_const_mgr.add_const('WMDM_STORAGE_ATTR_CANEDITMETADATA',0x00000080)
    win_const_mgr.add_const('CERT_CHAIN_POLICY_IGNORE_CTL_SIGNER_REV_UNKNOWN_FLAG',0x00000200)
    win_const_mgr.add_const('SM_CYMINIMIZED',0x0000003A)
    win_const_mgr.add_const('IDD_DYNAWIZ_INSTALLDETECTED_PREVPAGE',0x00002716)
    win_const_mgr.add_const('COMP_ELEM_FRIENDLYNAME',0x00000400)
    win_const_mgr.add_const('DB_MODE_SHARE_DENY_NONE',0x00000010)
    win_const_mgr.add_const('MCI_VCR_OFFSET',0x00000500)
    win_const_mgr.add_const('CF_RIFF',0x0000000B)
    win_const_mgr.add_const('INTERNET_STATUS_RESPONSE_RECEIVED',0x00000029)
    win_const_mgr.add_const('LCS_GM_ABS_COLORIMETRIC',0x00000008)
    win_const_mgr.add_const('D3DPRASTERCAPS_COLORPERSPECTIVE',0x00400000)
    win_const_mgr.add_const('ICM_CTF',0x00000005)
    win_const_mgr.add_const('MAX_DEINTERLACE_DEVICE_GUIDS',0x00000020)
    win_const_mgr.add_const('PERF_COUNTERSET_FLAG_INSTANCE',0x00000010)
    win_const_mgr.add_const('WMDM_MODE_TRANSFER_PROTECTED',0x00000080)
    win_const_mgr.add_const('BDR_RAISEDOUTER',0x00000001)
    win_const_mgr.add_const('PP_SYM_KEYSIZE',0x00000013)
    win_const_mgr.add_const('TRANSACTION_COMMIT',0x00000008)
    win_const_mgr.add_const('ULONG_ERROR',0x00000000)
    win_const_mgr.add_const('NULL_BRUSH',0x00000005)
    win_const_mgr.add_const('PRINTER_CHANGE_DELETE_FORM',0x00040000)
    win_const_mgr.add_const('LIF_STATE',0x00000002)
    win_const_mgr.add_const('WINEVENT_KEYWORD_RESERVED_61',0x2000000000000000)
    win_const_mgr.add_const('HTTP_1_1_CACHE_ENTRY',0x00000040)
    win_const_mgr.add_const('MCI_ANIM_PLAY_FAST',0x00040000)
    win_const_mgr.add_const('PROCESSOR_STRONGARM',0x00000A11)
    win_const_mgr.add_const('WKSTA_USEWRITERAWWITHDATA_PARMNUM',0x00000038)
    win_const_mgr.add_const('PHONEPRIVILEGE_OWNER',0x00000002)
    win_const_mgr.add_const('CERT_ALT_NAME_ENTRY_ERR_INDEX_SHIFT',0x00000010)
    win_const_mgr.add_const('RATING_ONE_STAR_SET',0x00000001)
    win_const_mgr.add_const('CERT_TRUST_HAS_EXCLUDED_NAME_CONSTRAINT',0x00008000)
    win_const_mgr.add_const('MULTICLASSINFO_GETTYPEINFO',0x00000001)
    win_const_mgr.add_const('FACILITY_ACS',0x00000014)
    win_const_mgr.add_const('DRM_SERVICE_TYPE_PUBLISHING',0x00000004)
    win_const_mgr.add_const('EC_LENGTH_CHANGED',0x0000001E)
    win_const_mgr.add_const('CRED_TI_WORKGROUP_MEMBER',0x00000020)
    win_const_mgr.add_const('WKSTA_LOCKMAXIMUM_PARMNUM',0x0000002B)
    win_const_mgr.add_const('WINHTTP_OPTION_PASSPORT_COBRANDING_URL',0x00000052)
    win_const_mgr.add_const('URL_ESCAPE_UNSAFE',0x20000000)
    win_const_mgr.add_const('MM_SNDBLST_WAVEIN',0x00000007)
    win_const_mgr.add_const('ERROR_DRIVE_MEDIA_MISMATCH',0x000010CF)
    win_const_mgr.add_const('CAC_RANDOM',0x00000002)
    win_const_mgr.add_const('DS_REPMOD_UPDATE_INSTANCE',0x00000002)
    win_const_mgr.add_const('KS_DVD_SECTOR_PROTECT_MASK',0x00000020)
    win_const_mgr.add_const('TF_LBI_STYLE_TEXTCOLORICON',0x00000020)
    win_const_mgr.add_const('DSF_WPD_DEVICES',0x00000001)
    win_const_mgr.add_const('ERROR_EVT_FILTER_TOO_COMPLEX',0x00003AB2)
    win_const_mgr.add_const('CSIDL_STARTUP',0x00000007)
    win_const_mgr.add_const('DDF_BACKGROUNDPAL',0x00000200)
    win_const_mgr.add_const('DBPROPVAL_OS_ENABLEALL',0x00000000)
    win_const_mgr.add_const('ATF_ONOFFFEEDBACK',0x00000002)
    win_const_mgr.add_const('WMDM_E_REVOKED',0x8004500E)
    win_const_mgr.add_const('OID_FDDI_LCONNECTION_STATE',0x03020109)
    win_const_mgr.add_const('COLOR_MENUBAR',0x0000001E)
    win_const_mgr.add_const('LVGS_COLLAPSED',0x00000001)
    win_const_mgr.add_const('META_SETTEXTCOLOR',0x00000209)
    win_const_mgr.add_const('TMT_MENUBARWIDTH',0x000004B8)
    win_const_mgr.add_const('BTH_MFG_INTEL',0x00000002)
    win_const_mgr.add_const('ETW_COUNTED_ANSISTRING_TYPE_VALUE',0x0000006D)
    win_const_mgr.add_const('FORMATDLGORD31',0x00000607)
    win_const_mgr.add_const('CHANGER_BAR_CODE_SCANNER_INSTALLED',0x00000001)
    win_const_mgr.add_const('DISPID_IDISCRECORDER2_ACQUIREEXCLUSIVEACCESS',0x00000102)
    win_const_mgr.add_const('SCRIPT_ENCODE_DEFAULT_LANGUAGE',0x00000001)
    win_const_mgr.add_const('ERROR_CANT_DISABLE_MANDATORY',0x0000051E)
    win_const_mgr.add_const('LOCALE_SNEGINFINITY',0x00000006)
    win_const_mgr.add_const('ERROR_BAD_ENVIRONMENT',0x0000000A)
    win_const_mgr.add_const('DDBLT_ZBUFFERSRCCONSTOVERRIDE',0x00400000)
    win_const_mgr.add_const('DEBUG_NOTIFY_SESSION_ACTIVE',0x00000000)
    win_const_mgr.add_const('EMR_RESIZEPALETTE',0x00000033)
    win_const_mgr.add_const('SQL_ISV_DOMAINS',0x00000400)
    win_const_mgr.add_const('LV_VIEW_TILE',0x00000004)
    win_const_mgr.add_const('BS_AUTOCHECKBOX',0x00000003)
    win_const_mgr.add_const('MIB_IF_TYPE_PPP',0x00000017)
    win_const_mgr.add_const('CAUSE_STATUS_ENQUIRY_RESPONSE',0x0000001E)
    win_const_mgr.add_const('PHONEERR_INVALAPPHANDLE',0x90000007)
    win_const_mgr.add_const('TC_RESERVED',0x00008000)
    win_const_mgr.add_const('DS_SCHEMA_GUID_ATTR',0x00000001)
    win_const_mgr.add_const('WINHTTP_OPTION_WRITE_BUFFER_SIZE',0x0000000D)
    win_const_mgr.add_const('RC_SCALING',0x00000004)
    win_const_mgr.add_const('PSR_SI',0x00000017)
    win_const_mgr.add_const('DRIVER_W9X_SUSPECT_COMPATID_RANK',0x0000FFFF)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_ACCOUNT_OPS',0x00000224)
    win_const_mgr.add_const('DDSD_MIPMAPCOUNT',0x00020000)
    win_const_mgr.add_const('JOY_BUTTON17',0x00010000)
    win_const_mgr.add_const('DI_FLAGSEX_RESERVED4',0x00004000)
    win_const_mgr.add_const('DI_FLAGSEX_RESERVED3',0x00000002)
    win_const_mgr.add_const('DI_FLAGSEX_RESERVED2',0x00000001)
    win_const_mgr.add_const('GIL_SIMULATEDOC',0x00000001)
    win_const_mgr.add_const('V86FLAGS_CARRY',0x00000001)
    win_const_mgr.add_const('COD_MAJOR_AUDIO',0x00000004)
    win_const_mgr.add_const('RPC_C_FULL_CERT_CHAIN',0x00000001)
    win_const_mgr.add_const('MD_CPU_TRACE',0x00000002)
    win_const_mgr.add_const('SERVICE_CONTROL_SESSIONCHANGE',0x0000000E)
    win_const_mgr.add_const('SI_SERVER_IS_DC',0x00001000)
    win_const_mgr.add_const('MPEGLAYER3_ID_CONSTANTFRAMESIZE',0x00000002)
    win_const_mgr.add_const('PSR_ED',0x0000002B)
    win_const_mgr.add_const('KERB_ETYPE_DES_CBC_MD5_NT',0x00000014)
    win_const_mgr.add_const('DEBUG_FILTER_REMOVE',0x00000004)
    win_const_mgr.add_const('LB_GETTEXTLEN',0x0000018A)
    win_const_mgr.add_const('PHONEINITIALIZEEXOPTION_USEHIDDENWINDOW',0x00000001)
    win_const_mgr.add_const('DS_REPSYNC_PERIODIC',0x00000004)
    win_const_mgr.add_const('LINECALLSTATE_OFFERING',0x00000002)
    win_const_mgr.add_const('OPERATION_ASYNC',0x00000010)
    win_const_mgr.add_const('PROCESSOR_INTEL_IA64',0x00000898)
    win_const_mgr.add_const('LANG_HEBREW',0x00000000)
    win_const_mgr.add_const('SORT_HUNGARIAN_DEFAULT',0x00000000)
    win_const_mgr.add_const('NETLOGON_CONTROL_FIND_USER',0x00000008)
    win_const_mgr.add_const('SF_NCRFORNONASCII',0x00000040)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_SUPPORTEDWRITESPEEDDESCRIPTORS',0x00000116)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_ENVIRONMENT',0x00000000)
    win_const_mgr.add_const('WINEVENT_LEVEL_INFO',0x00000004)
    win_const_mgr.add_const('WINHTTP_QUERY_PRAGMA',0x00000011)
    win_const_mgr.add_const('SQL_FB_OFF',0x00000000)
    win_const_mgr.add_const('ERROR_INVALID_DOMAIN_STATE',0x00000549)
    win_const_mgr.add_const('SSF_INDICATOR',0x00000004)
    win_const_mgr.add_const('CDDS_PREPAINT',0x00000001)
    win_const_mgr.add_const('SERVICE_CONTROL_PRESHUTDOWN',0x0000000F)
    win_const_mgr.add_const('IPPORT_HTTPS',0x000001BB)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_NOTCBPRIV',0x0000361B)
    win_const_mgr.add_const('WMDRM_SECURITY_PERFORM_FORCE_INDIV',0x00000004)
    win_const_mgr.add_const('CRYPT_PSTORE',0x00000002)
    win_const_mgr.add_const('BG_E_HTTP_ERROR_100',0x80190064)
    win_const_mgr.add_const('NDIS_ENCAPSULATION_IEEE_802_3',0x00000002)
    win_const_mgr.add_const('STDPROP_DISPLAYKEY',0x00000065)
    win_const_mgr.add_const('DWM_TNP_VISIBLE',0x00000008)
    win_const_mgr.add_const('NETE_NOMAP',0x00000000)
    win_const_mgr.add_const('KS_CC_SUBSTREAM_SERVICE_T3',0x00000400)
    win_const_mgr.add_const('FACILITY_COMPLUS',0x00000011)
    win_const_mgr.add_const('SEARCH_PRIMARY',0x00000001)
    win_const_mgr.add_const('OBM_OLD_ZOOM',0x00007FF4)
    win_const_mgr.add_const('CRL_DIST_POINT_ERR_INDEX_SHIFT',0x00000018)
    win_const_mgr.add_const('IDC_PU_TEXT',0x00000385)
    win_const_mgr.add_const('IMAGE_REL_MIPS_LITERAL',0x00000007)
    win_const_mgr.add_const('IDD_ACMFILTERCHOOSE_BTN_HELP',0x00000009)
    win_const_mgr.add_const('CBR_14400',0x00003840)
    win_const_mgr.add_const('IN_CLASSA_MAX',0x00000080)
    win_const_mgr.add_const('WNPS_MULT',0x00000002)
    win_const_mgr.add_const('ENLISTMENT_RECOVER',0x00000004)
    win_const_mgr.add_const('DDFLIP_NOVSYNC',0x00000008)
    win_const_mgr.add_const('LOGON32_PROVIDER_DEFAULT',0x00000000)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_TRANSITION_FILLED_V',0x00000011)
    win_const_mgr.add_const('BSF_FEEDNAVIGATION',0x00080000)
    win_const_mgr.add_const('CERT_ALT_NAME_ENTRY_ERR_INDEX_MASK',0x000000FF)
    win_const_mgr.add_const('LOGON32_LOGON_INTERACTIVE',0x00000002)
    win_const_mgr.add_const('CERT_VERIFY_REV_CHAIN_FLAG',0x00000001)
    win_const_mgr.add_const('DDFLIP_ODD',0x00000004)
    win_const_mgr.add_const('PARTITION_XENIX_2',0x00000003)
    win_const_mgr.add_const('VARIANT_NOUSEROVERRIDE',0x00000004)
    win_const_mgr.add_const('IPPORT_CMDSERVER',0x00000202)
    win_const_mgr.add_const('TMT_TEXTITALIC',0x000008AA)
    win_const_mgr.add_const('DV_SMCHN',0x00000000)
    win_const_mgr.add_const('INTERNET_COOKIE_EVALUATE_P3P',0x00000040)
    win_const_mgr.add_const('NDIS_OFFLOAD_PARAMETERS_IPSECV1_AH_AND_ESP_ENABLED',0x00000004)
    win_const_mgr.add_const('IPX_PTYPE',0x00004000)
    win_const_mgr.add_const('PERF_TYPE_TEXT',0x00000800)
    win_const_mgr.add_const('MMIO_PARSE',0x00000100)
    win_const_mgr.add_const('ACCESS_WRITE',0x00000002)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_CORDUNPLUGGED',0x00000000)
    win_const_mgr.add_const('FILE_TYPE_UNKNOWN',0x00000000)
    win_const_mgr.add_const('DISKQUOTA_USER_ACCOUNT_RESOLVED',0x00000000)
    win_const_mgr.add_const('SQL_TIMEDATE_DIFF_INTERVALS',0x0000006E)
    win_const_mgr.add_const('IPP_E_CLIENTMUSTEMULATE',0xC0048103)
    win_const_mgr.add_const('BG_E_PASSWORD_TOO_LARGE',0x80200026)
    win_const_mgr.add_const('KS_MAX_SIZE_MPEG1_SEQUENCE_INFO',0x0000008C)
    win_const_mgr.add_const('WCS_DEFAULT',0x00000000)
    win_const_mgr.add_const('V86FLAGS_SIGN',0x00000080)
    win_const_mgr.add_const('RECOFLAG_SINGLESEG',0x00000004)
    win_const_mgr.add_const('PSR_SS',0x00000028)
    win_const_mgr.add_const('GESTURE_UP_RIGHT',0x00000000)
    win_const_mgr.add_const('PCF_SPECIALCHARS',0x00000100)
    win_const_mgr.add_const('PORT_NAMP',0x000000A7)
    win_const_mgr.add_const('PC_RECTANGLE',0x00000002)
    win_const_mgr.add_const('WINHTTP_QUERY_VARY',0x00000041)
    win_const_mgr.add_const('LINEREQUESTMODE_MAKECALL',0x00000001)
    win_const_mgr.add_const('SNMPAPI_NOT_INITIALIZED',0x00000012)
    win_const_mgr.add_const('PORT_RPASSWD',0x00000306)
    win_const_mgr.add_const('PXE_ADDR_USE_DHCP_RULES',0x00000008)
    win_const_mgr.add_const('WM_MDINEXT',0x00000224)
    win_const_mgr.add_const('PDH_SQL_EXEC_DIRECT_FAILED',0xC0000BE2)
    win_const_mgr.add_const('LINEMEDIAMODE_TDD',0x00000040)
    win_const_mgr.add_const('LSA_TLN_DISABLED_ADMIN',0x00000002)
    win_const_mgr.add_const('PORT_RIP',0x00000208)
    win_const_mgr.add_const('PORT_RIS',0x000000B4)
    win_const_mgr.add_const('MCGIP_CALENDARCELL',0x00000008)
    win_const_mgr.add_const('CTRY_LEBANON',0x000003C1)
    win_const_mgr.add_const('TA_RIGHT',0x00000002)
    win_const_mgr.add_const('BUTTON_IMAGELIST_ALIGN_LEFT',0x00000000)
    win_const_mgr.add_const('SCESTATUS_PREFIX_OVERFLOW',0x0000000B)
    win_const_mgr.add_const('WM_RENDERFORMAT',0x00000305)
    win_const_mgr.add_const('PROV_STT_ACQ',0x00000008)
    win_const_mgr.add_const('GMEM_NOTIFY',0x00004000)
    win_const_mgr.add_const('WIA_DIP_WIA_VERSION',0x0000000E)
    win_const_mgr.add_const('GCS_RESULTSTR',0x00000800)
    win_const_mgr.add_const('PSP_DEFAULT',0x00000000)
    win_const_mgr.add_const('LINECALLINFOSTATE_BEARERMODE',0x00000004)
    win_const_mgr.add_const('SCRIPTTYPELIB_ISCONTROL',0x00000010)
    win_const_mgr.add_const('SUBLANG_SLOVENIAN_SLOVENIA',0x00000001)
    win_const_mgr.add_const('TF_DISABLE_BALLOON',0x00000002)
    win_const_mgr.add_const('TTFCFP_APPLE_PLATFORMID',0x00000001)
    win_const_mgr.add_const('VOS__WINDOWS16',0x00000001)
    win_const_mgr.add_const('FD_CLOSE_BIT',0x00000005)
    win_const_mgr.add_const('WAVE_FORMAT_2M08',0x00000010)
    win_const_mgr.add_const('EAP_E_SERVER_ROOT_CERT_NOT_FOUND',0x80420400)
    win_const_mgr.add_const('DISPID_WINDOWSETTOP',0x00000109)
    win_const_mgr.add_const('SPC_INC_PE_RESOURCES_FLAG',0x00000080)
    win_const_mgr.add_const('EC_EOS_SOON',0x00000046)
    win_const_mgr.add_const('DS_KCC_FLAG_DAMPED',0x00000001)
    win_const_mgr.add_const('WS_EX_LAYERED',0x00080000)
    win_const_mgr.add_const('DDSCAPS2_DONOTPERSIST',0x00040000)
    win_const_mgr.add_const('DNS_OPCODE_UNKNOWN',0x00000003)
    win_const_mgr.add_const('WM_DESTROY',0x00000002)
    win_const_mgr.add_const('IMAGE_REL_IA64_TOKEN',0x0000001B)
    win_const_mgr.add_const('DEBUG_OUTTYPE_BLOCK_RECURSE',0x00200000)
    win_const_mgr.add_const('DISPLAYDIB_NOTACTIVE',0x00000006)
    win_const_mgr.add_const('WB_RIGHT',0x00000001)
    win_const_mgr.add_const('DS_TIMESERV_FLAG',0x00000040)
    win_const_mgr.add_const('SBM_GETSCROLLBARINFO',0x000000EB)
    win_const_mgr.add_const('ERROR_FILE_IDENTITY_NOT_PERSISTENT',0x00001AA7)
    win_const_mgr.add_const('FACILITY_VIDEO',0x0000001B)
    win_const_mgr.add_const('PAN_PROP_CONDENSED',0x00000006)
    win_const_mgr.add_const('MIXER_OBJECTF_HANDLE',0x80000000)
    win_const_mgr.add_const('MOUSEEVENTF_XUP',0x00000100)
    win_const_mgr.add_const('DM_PAPERLENGTH',0x00000004)
    win_const_mgr.add_const('WT_TRANSFER_IMPERSONATION',0x00000100)
    win_const_mgr.add_const('URLACTION_FEATURE_FORCE_ADDR_AND_STATUS',0x00002104)
    win_const_mgr.add_const('MDLEVEL_TYPE_TIME_SECONDS',0x00000804)
    win_const_mgr.add_const('INHERIT_ONLY_ACE',0x00000008)
    win_const_mgr.add_const('MPEG_PMT_TID',0x00000002)
    win_const_mgr.add_const('WLX_SAS_TYPE_SC_LAST_READER_REMOVED',0x00000009)
    win_const_mgr.add_const('DSOP_SCOPE_FLAG_DEFAULT_FILTER_COMPUTERS',0x00000100)
    win_const_mgr.add_const('INTERNET_OPEN_TYPE_PROXY',0x00000003)
    win_const_mgr.add_const('DBPROP_CI_PROVIDER',0x00000008)
    win_const_mgr.add_const('ERROR_UNKNOWN_PORT',0x00000704)
    win_const_mgr.add_const('INTERNET_DIALSTATE_DISCONNECTED',0x00000001)
    win_const_mgr.add_const('SF_NOTIFY_LOG',0x00000200)
    win_const_mgr.add_const('SHHLNF_WRITENOHISTORY',0x08000000)
    win_const_mgr.add_const('DVB_ST_TID',0x00000072)
    win_const_mgr.add_const('ERROR_INVALID_DRIVE_OBJECT',0x000010E1)
    win_const_mgr.add_const('CERT_HCRYPTPROV_OR_NCRYPT_KEY_HANDLE_PROP_ID',0x0000004F)
    win_const_mgr.add_const('ERROR_LOG_CLIENT_ALREADY_REGISTERED',0x000019EC)
    win_const_mgr.add_const('PROCESS_TERMINATE',0x00000001)
    win_const_mgr.add_const('CERT_STORE_CTRL_AUTO_RESYNC',0x00000004)
    win_const_mgr.add_const('WINHTTP_QUERY_REFRESH',0x0000002E)
    win_const_mgr.add_const('HTTP_QUERY_COST',0x0000000F)
    win_const_mgr.add_const('PXE_ADDR_USE_PORT',0x00000002)
    win_const_mgr.add_const('META_STRETCHDIB',0x00000000)
    win_const_mgr.add_const('VK_SNAPSHOT',0x0000002C)
    win_const_mgr.add_const('MAX_TITLE_LEN',0x0000003C)
    win_const_mgr.add_const('REFERENCE_BLACK_MIN',0x00000000)
    win_const_mgr.add_const('FWPS_METADATA_FIELD_FLOW_HANDLE',0x00000002)
    win_const_mgr.add_const('PT_TEMPORARY',0x00000001)
    win_const_mgr.add_const('DISPLAYDIB_NOPALETTE',0x00000010)
    win_const_mgr.add_const('DCB_ENABLE',0x00000004)
    win_const_mgr.add_const('ERROR_DBG_EXCEPTION_NOT_HANDLED',0x000002B0)
    win_const_mgr.add_const('TXFS_RM_FLAG_RENAME_RM',0x00000002)
    win_const_mgr.add_const('IF_TYPE_GR303_IDT',0x000000B2)
    win_const_mgr.add_const('EMR_PAINTRGN',0x0000004A)
    win_const_mgr.add_const('FILE_DEVICE_PRINTER',0x00000018)
    win_const_mgr.add_const('ISC_RET_FRAGMENT_ONLY',0x00200000)
    win_const_mgr.add_const('PROP_DISPLAY_HINT',0x00000004)
    win_const_mgr.add_const('RASLCPAP_CHAP',0x0000C223)
    win_const_mgr.add_const('IDM_TRIED_UNDO',0x0000003A)
    win_const_mgr.add_const('METHOD_BGP4_PEER_ID',0x00000002)
    win_const_mgr.add_const('INTERNET_OPTION_WRITE_BUFFER_SIZE',0x0000000D)
    win_const_mgr.add_const('CMSG_CONTENT_ENCRYPT_PAD_ENCODED_LEN_FLAG',0x00000001)
    win_const_mgr.add_const('LINEEQOSINFO_POLICYFAILURE',0x00000003)
    win_const_mgr.add_const('ERROR_LABEL_QUESTIONABLE',0x00000002)
    win_const_mgr.add_const('MDM_SHIFT_PROTOCOLID',0x00000010)
    win_const_mgr.add_const('WIA_PROP_CACHEABLE',0x00010000)
    win_const_mgr.add_const('EMARCH_ENC_I17_IMM7B_VAL_POS_X',0x00000000)
    win_const_mgr.add_const('SHARE_PATH_PARMNUM',0x00000008)
    win_const_mgr.add_const('MF_FLAGS_NO_CREATE_IF_NO_RESOURCE',0x00000002)
    win_const_mgr.add_const('PRIVACY_TEMPLATE_ADVANCED',0x00000065)
    win_const_mgr.add_const('TBCDRF_BLENDICON',0x00200000)
    win_const_mgr.add_const('WLX_SAS_ACTION_SHUTDOWN_POWER_OFF',0x0000000A)
    win_const_mgr.add_const('HTTP_MAX_SERVER_QUEUE_LENGTH',0x7FFFFFFF)
    win_const_mgr.add_const('PFM_NUMBERINGSTART',0x00008000)
    win_const_mgr.add_const('DISPID_PRINTTEMPLATETEARDOWN',0x000000E2)
    win_const_mgr.add_const('PROTO_IP_NT_STATIC_NON_DOD',0x00002717)
    win_const_mgr.add_const('MCI_ANIM_OPEN_NOSTATIC',0x00040000)
    win_const_mgr.add_const('DC_MINEXTENT',0x00000004)
    win_const_mgr.add_const('DEVPROP_TYPE_BOOLEAN',0x00000011)
    win_const_mgr.add_const('SYMSEARCH_RECURSE',0x00000000)
    win_const_mgr.add_const('WMDM_MODE_TRANSFER_UNPROTECTED',0x00000100)
    win_const_mgr.add_const('DLGC_UNDEFPUSHBUTTON',0x00000020)
    win_const_mgr.add_const('IPX_ROUTE_FILTER_PERMIT',0x00000001)
    win_const_mgr.add_const('CACHE_FULLY_ASSOCIATIVE',0x000000FF)
    win_const_mgr.add_const('MAPMIME_CLSID',0x00000001)
    win_const_mgr.add_const('MCI_VCR_STATUS_CLOCK_ID',0x00004021)
    win_const_mgr.add_const('OPTION_CLIENT_CLASS_INFO',0x0000003C)
    win_const_mgr.add_const('TAPE_DRIVE_SETMARKS',0x80100000)
    win_const_mgr.add_const('MD_NOTIFY_END_OF_NET_SESSION',0x00000100)
    win_const_mgr.add_const('DIRID_SPOOLDRIVERS',0x00000034)
    win_const_mgr.add_const('INDEX_GUID_PARAGRAPH',0x00000007)
    win_const_mgr.add_const('PROCESS_CREATE_THREAD',0x00000002)
    win_const_mgr.add_const('ERROR_IPSEC_QM_POLICY_PENDING_DELETION',0x000032DF)
    win_const_mgr.add_const('ERROR_DS_CANT_FIND_EXPECTED_NC',0x000020E4)
    win_const_mgr.add_const('WAB_VCARD_FILE',0x00000000)
    win_const_mgr.add_const('RIDEV_APPKEYS',0x00000400)
    win_const_mgr.add_const('SHCNE_RENAMEITEM',0x00000001)
    win_const_mgr.add_const('SFGAO_VALIDATE',0x01000000)
    win_const_mgr.add_const('CB_GETITEMHEIGHT',0x00000154)
    win_const_mgr.add_const('WM_MOUSELAST',0x00000209)
    win_const_mgr.add_const('IF_TYPE_X213',0x0000005D)
    win_const_mgr.add_const('DDSETSURFACEDESC_RECREATEDC',0x00000000)
    win_const_mgr.add_const('MSIM_DISPID_ONFRIENDLYNAMECHANGERESULT',0x00000E04)
    win_const_mgr.add_const('VK_SHIFT',0x00000010)
    win_const_mgr.add_const('ERROR_BAD_FORMAT',0x0000000B)
    win_const_mgr.add_const('CMSG_MAIL_LIST_ENCRYPT_FREE_PARA_FLAG',0x00000001)
    win_const_mgr.add_const('PIDSI_TITLE',0x00000002)
    win_const_mgr.add_const('ERROR_NOT_REGISTRY_FILE',0x000003F9)
    win_const_mgr.add_const('DNSSEC_KEY_FLAG_NOCONF',0x00000002)
    win_const_mgr.add_const('DBPROPVAL_SQ_IN',0x00000008)
    win_const_mgr.add_const('ALG_SID_SCHANNEL_MAC_KEY',0x00000003)
    win_const_mgr.add_const('D3DMAXUSERCLIPPLANES',0x00000020)
    win_const_mgr.add_const('PP_SESSION_KEYSIZE',0x00000014)
    win_const_mgr.add_const('WINEVENT_OPCODE_RESERVED_245',0x00000000)
    win_const_mgr.add_const('LINECALLCOMPLMODE_CAMPON',0x00000001)
    win_const_mgr.add_const('SSPROP_INIT_WSID',0x0000000B)
    win_const_mgr.add_const('SNMP_OUTPUT_TO_DEBUGGER',0x00000008)
    win_const_mgr.add_const('ENM_LANGCHANGE',0x01000000)
    win_const_mgr.add_const('PSINJECT_ENDSETUP',0x00000011)
    win_const_mgr.add_const('WVR_ALIGNRIGHT',0x00000080)
    win_const_mgr.add_const('WINEVENT_OPCODE_RESERVED_247',0x00000000)
    win_const_mgr.add_const('DSOP_SCOPE_TYPE_EXTERNAL_DOWNLEVEL_DOMAIN',0x00000040)
    win_const_mgr.add_const('BDR_RAISEDINNER',0x00000004)
    win_const_mgr.add_const('DEVICEPOWER_FILTER_HARDWARE',0x10000000)
    win_const_mgr.add_const('MCI_VCR_SET_TIME_MODE',0x00010000)
    win_const_mgr.add_const('TAPE_ABSOLUTE_POSITION',0x00000000)
    win_const_mgr.add_const('PORT_STATSRV',0x00000085)
    win_const_mgr.add_const('NUMMARKERS',0x00000014)
    win_const_mgr.add_const('DDPF_PALETTEINDEXED8',0x00000020)
    win_const_mgr.add_const('WINEVENT_OPCODE_RESERVED_241',0x00000000)
    win_const_mgr.add_const('MCI_SEQ_SET_MASTER',0x00080000)
    win_const_mgr.add_const('MCI_WAVE_STATUS_AVGBYTESPERSEC',0x00004004)
    win_const_mgr.add_const('DDPF_PALETTEINDEXED2',0x00001000)
    win_const_mgr.add_const('GESTURE_DOUBLE_LEFT',0x00000000)
    win_const_mgr.add_const('FEI_INITIALIZING',0x00000018)
    win_const_mgr.add_const('CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_PARA_FLAG',0x00000008)
    win_const_mgr.add_const('PIDMSI_COPYRIGHT',0x0000000B)
    win_const_mgr.add_const('AF_ISO',0x00000007)
    win_const_mgr.add_const('SPREG_SUCCESS',0x00000000)
    win_const_mgr.add_const('MMIO_FINDLIST',0x00000040)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW4_FRAMEELEMENT',0x0000049D)
    win_const_mgr.add_const('_MULTIMON_USE_SECURE_CRT',0x00000000)
    win_const_mgr.add_const('CERT_RDN_VIDEOTEX_STRING',0x00000006)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_ACCEPT',0x0000000F)
    win_const_mgr.add_const('DNS_RCLASS_CSNET',0x00000200)
    win_const_mgr.add_const('STM_ONLY_THIS_NAME',0x00000008)
    win_const_mgr.add_const('ERROR_NO_NET_OR_BAD_PATH',0x000004B3)
    win_const_mgr.add_const('IMAGE_REL_MIPS_REFWORDNB',0x00000022)
    win_const_mgr.add_const('SQL_DP_OFF',0x00000000)
    win_const_mgr.add_const('SECURITY_FLAG_FORTEZZA',0x08000000)
    win_const_mgr.add_const('ERROR_PRODUCT_VERSION',0x00000666)
    win_const_mgr.add_const('SFVM_BACKGROUNDENUM',0x00000020)
    win_const_mgr.add_const('CERT_PROT_ROOT_ONLY_LM_GPT_FLAG',0x00000008)
    win_const_mgr.add_const('OPEN_EXISTING',0x00000003)
    win_const_mgr.add_const('MDPROPVAL_MSF_DRILLDOWNLEVEL',0x00000800)
    win_const_mgr.add_const('CRYPTNET_URL_CACHE_RESPONSE_VALIDATED',0x00008000)
    win_const_mgr.add_const('EMR_CHORD',0x0000002E)
    win_const_mgr.add_const('EVENT_TRACE_USE_GLOBAL_SEQUENCE',0x00004000)
    win_const_mgr.add_const('ERROR_CTX_LICENSE_NOT_AVAILABLE',0x00001B8E)
    win_const_mgr.add_const('OID_TAPI_DIAL',0x07030108)
    win_const_mgr.add_const('DBPROPVAL_IN_IGNORENULL',0x00000002)
    win_const_mgr.add_const('CRYPT_UI_PROMPT',0x00000004)
    win_const_mgr.add_const('WSB_PROP_CXHTHUMB',0x00000010)
    win_const_mgr.add_const('FILEOP_SKIP',0x00000002)
    win_const_mgr.add_const('KP_PRECOMP_MD5',0x00000018)
    win_const_mgr.add_const('ERROR_DESTINATION_ELEMENT_FULL',0x00000489)
    win_const_mgr.add_const('ERROR_INSTALL_ALREADY_RUNNING',0x00000652)
    win_const_mgr.add_const('PS_256M',0x00000001)
    win_const_mgr.add_const('WMPGC_FLAGS_ALLOW_PREROLL',0x00000001)
    win_const_mgr.add_const('CERT_VERIFY_NO_TIME_CHECK_FLAG',0x00000004)
    win_const_mgr.add_const('RECOFLAG_AUTOSPACE',0x00000040)
    win_const_mgr.add_const('HDS_FULLDRAG',0x00000080)
    win_const_mgr.add_const('DFCS_SCROLLDOWN',0x00000001)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MAJOR_MIN_CUSTOM',0x00400000)
    win_const_mgr.add_const('TRACE_HEADER_FLAG_LOG_WNODE',0x00040000)
    win_const_mgr.add_const('RPC_C_DONT_FAIL',0x00000004)
    win_const_mgr.add_const('HLNF_TRUSTEDFORACTIVEX',0x00400000)
    win_const_mgr.add_const('IMAGE_REL_IA64_SECREL22',0x0000000C)
    win_const_mgr.add_const('WSAEPROVIDERFAILEDINIT',0x0000277A)
    win_const_mgr.add_const('OCSP_BASIC_REVOKED_CERT_STATUS',0x00000001)
    win_const_mgr.add_const('RIGHT_CTRL_PRESSED',0x00000004)
    win_const_mgr.add_const('DNOBJECT_MIRROR',0x00000019)
    win_const_mgr.add_const('IDM_TEMPLATE_PAGESETUP',0x000008FA)
    win_const_mgr.add_const('DEBUG_SYMTYPE_DIA',0x00000007)
    win_const_mgr.add_const('IPX_INTERFACE_INFO_TYPE',0x00000001)
    win_const_mgr.add_const('POLICY_AUDIT_SUBCATEGORY_COUNT',0x00000032)
    win_const_mgr.add_const('DOF_SHELLDATA',0x00000002)
    win_const_mgr.add_const('MAX_SYM_NAME',0x000007D0)
    win_const_mgr.add_const('D3DSI_OPCODE_MASK',0x0000FFFF)
    win_const_mgr.add_const('CM_SET_HW_PROF_FLAGS_BITS',0x00000001)
    win_const_mgr.add_const('INTERNET_CACHE_GROUP_REMOVE',0x00000001)
    win_const_mgr.add_const('HTTP_QUERY_EXPECT',0x00000044)
    win_const_mgr.add_const('NUMBRUSHES',0x00000010)
    win_const_mgr.add_const('D3DCURSORCAPS_LOWRES',0x00000002)
    win_const_mgr.add_const('RAS_FLAGS_QUARANTINE_PRESENT',0x00000008)
    win_const_mgr.add_const('BCP_FMT_SERVER_COL',0x00000005)
    win_const_mgr.add_const('WIA_PAGE_ISO_B10',0x0000001B)
    win_const_mgr.add_const('DISPID_FONT_NAME',0x00000000)
    win_const_mgr.add_const('SOCKET_SETTINGS_ALLOW_INSECURE',0x00000002)
    win_const_mgr.add_const('TLS1_ALERT_RECORD_OVERFLOW',0x00000016)
    win_const_mgr.add_const('SQL_FD_FETCH_PRIOR',0x00000008)
    win_const_mgr.add_const('URLACTION_WINDOWS_BROWSER_APPLICATIONS',0x00002400)
    win_const_mgr.add_const('HTTP_QUERY_DERIVED_FROM',0x0000000E)
    win_const_mgr.add_const('URLACTION_INFODELIVERY_NO_REMOVING_CHANNELS',0x00001D02)
    win_const_mgr.add_const('GGL_INDEX',0x00000002)
    win_const_mgr.add_const('UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION',0x01000000)
    win_const_mgr.add_const('TXFS_RM_FLAG_LOG_CONTAINER_COUNT_MAX',0x00000004)
    win_const_mgr.add_const('PL_USER',0x00000003)
    win_const_mgr.add_const('SQL_CONVERT_TIME',0x00000042)
    win_const_mgr.add_const('ISC_RET_INTERMEDIATE_RETURN',0x00001000)
    win_const_mgr.add_const('CM_GLOBAL_STATE_CAN_DO_UI',0x00000001)
    win_const_mgr.add_const('PERF_COUNTER_FRACTION',0x00020000)
    win_const_mgr.add_const('MF_CHECKED',0x00000008)
    win_const_mgr.add_const('SQL_NNC_NON_NULL',0x00000001)
    win_const_mgr.add_const('NUMPRS_TRAILING_PLUS',0x00000008)
    win_const_mgr.add_const('ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME',0x0000170C)
    win_const_mgr.add_const('NIF_ICON',0x00000002)
    win_const_mgr.add_const('SHPWHF_VALIDATEVIAWEBFOLDERS',0x00010000)
    win_const_mgr.add_const('SUBLANG_ITALIAN',0x00000001)
    win_const_mgr.add_const('SDP_ATTRIB_HID_SDP_DISABLE',0x00000208)
    win_const_mgr.add_const('LOWER_GET_HINT_MASK',0x0000FF00)
    win_const_mgr.add_const('DDSCAPS_PRIMARYSURFACELEFT',0x00000000)
    win_const_mgr.add_const('KSDSOUND_BUFFER_CTRL_POSITIONNOTIFY',0x00000010)
    win_const_mgr.add_const('DDFXCAPS_OVERLAYSTRETCHYN',0x04000000)
    win_const_mgr.add_const('LCMAP_LOWERCASE',0x00000100)
    win_const_mgr.add_const('PHOTOACQ_DISABLE_DB_INTEGRATION',0x00000010)
    win_const_mgr.add_const('CERT_SMART_CARD_DATA_PROP_ID',0x00000010)
    win_const_mgr.add_const('SHPWHF_NOFILESELECTOR',0x00000004)
    win_const_mgr.add_const('MAX_THEMECOLOR',0x00000040)
    win_const_mgr.add_const('USER_TRUSTED_FOR_DELEGATION',0x00002000)
    win_const_mgr.add_const('IME_ITHOTKEY_RESEND_RESULTSTR',0x00000200)
    win_const_mgr.add_const('WM_CLEAR',0x00000303)
    win_const_mgr.add_const('IDM_OVERRIDE_CURSOR',0x00000974)
    win_const_mgr.add_const('NNTP_MD_ID_BEGIN_RESERVED',0x00000000)
    win_const_mgr.add_const('SYMFLAG_RESET',0x80000000)
    win_const_mgr.add_const('ERROR_DS_REPL_LIFETIME_EXCEEDED',0x000021A6)
    win_const_mgr.add_const('PST_NETWORK_BRIDGE',0x00000100)
    win_const_mgr.add_const('FWPM_CONTEXT_IPSEC_INBOUND_PERSIST_CONNECTION_SECURITY',0x00000002)
    win_const_mgr.add_const('INTERNET_OPTION_DATA_SEND_TIMEOUT',0x00000007)
    win_const_mgr.add_const('CTF_PROCESS_REF',0x00000004)
    win_const_mgr.add_const('ERROR_NO_PROC_SLOTS',0x00000059)
    win_const_mgr.add_const('DEBUG_SESSION_END_SESSION_PASSIVE',0x00000003)
    win_const_mgr.add_const('JOB_CONTROL_PAUSE',0x00000001)
    win_const_mgr.add_const('CERT_BIOMETRIC_OID_DATA_CHOICE',0x00000002)
    win_const_mgr.add_const('NTDDI_WIN2KSP1',0x05000100)
    win_const_mgr.add_const('DDOVER_ALPHADESTNEG',0x00000004)
    win_const_mgr.add_const('DNS_REGISTER',0x00000001)
    win_const_mgr.add_const('ISO_NON_HIERARCHICAL',0x00000001)
    win_const_mgr.add_const('CRL_FIND_EXISTING',0x00000002)
    win_const_mgr.add_const('SPREG_TIMEOUT',0x00000005)
    win_const_mgr.add_const('ACM_STREAMCONVERTF_END',0x00000020)
    win_const_mgr.add_const('DISPLAY_DEVICE_REMOVABLE',0x00000020)
    win_const_mgr.add_const('PIR_STATUS_MINIPORT_INVALID',0x00000007)
    win_const_mgr.add_const('TVIS_EXPANDED',0x00000020)
    win_const_mgr.add_const('IPV6_MULTICAST_HOPS',0x0000000A)
    win_const_mgr.add_const('SQL_LOCK_UNLOCK',0x00000002)
    win_const_mgr.add_const('NRB_FUNCTION_QUERY_CACHE_MISS',0x00000013)
    win_const_mgr.add_const('PROPTYPE_LONG',0x00000001)
    win_const_mgr.add_const('COMMON_LVB_UNDERSCORE',0x00008000)
    win_const_mgr.add_const('PROPID_MGMT_MSMQ_BASE',0x00000000)
    win_const_mgr.add_const('HTTP_QUERY_FROM',0x0000001F)
    win_const_mgr.add_const('FS_BALTIC',0x00000080)
    win_const_mgr.add_const('CERT_TRUST_IS_SELF_SIGNED',0x00000008)
    win_const_mgr.add_const('MCI_DGV_WHERE_FRAME',0x00080000)
    win_const_mgr.add_const('HCF_HOTKEYAVAILABLE',0x00000040)
    win_const_mgr.add_const('CRR_CALL_LIMIT',0xFFFFFFFD)
    win_const_mgr.add_const('DISPID_WINDOWMOVE',0x0000006D)
    win_const_mgr.add_const('ISDB_SDTT_PID',0x00000023)
    win_const_mgr.add_const('CTRY_EGYPT',0x00000014)
    win_const_mgr.add_const('ERROR_DS_FOREST_VERSION_TOO_HIGH',0x00002173)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_WINEVT_RECEIVE',0x00000000)
    win_const_mgr.add_const('DEBUG_DUMP_IMAGE_FILE',0x00000403)
    win_const_mgr.add_const('CERT_STORE_OPEN_EXISTING_FLAG',0x00004000)
    win_const_mgr.add_const('PD_ENABLEPRINTHOOK',0x00001000)
    win_const_mgr.add_const('OID_IRDA_SUPPORTED_SPEEDS',0x0A010102)
    win_const_mgr.add_const('AA_S_WRITE',0x00000020)
    win_const_mgr.add_const('PHRASE_FEEDBACK',0x00000004)
    win_const_mgr.add_const('WIA_INTENT_NONE',0x00000000)
    win_const_mgr.add_const('STAT_REFRESH',0x00000003)
    win_const_mgr.add_const('SPI_SETANIMATION',0x00000049)
    win_const_mgr.add_const('IME_CAND_MEANING',0x00000003)
    win_const_mgr.add_const('DRM_EL_GROUPIDENTITY_NAME',0x00000004)
    win_const_mgr.add_const('TIME_NOTIMEMARKER',0x00000004)
    win_const_mgr.add_const('SHUTDOWN_INSTALL_UPDATES',0x00000040)
    win_const_mgr.add_const('DEVPROP_TYPE_INT64',0x00000008)
    win_const_mgr.add_const('ERROR_EVT_FILTER_INVARG',0x00003AA8)
    win_const_mgr.add_const('TBS_NOTIFYBEFOREMOVE',0x00000800)
    win_const_mgr.add_const('ERROR_LABEL_TOO_LONG',0x0000009A)
    win_const_mgr.add_const('WIA_SHOW_PREVIEW_CONTROL',0x00000000)
    win_const_mgr.add_const('ENABLE_WRAP_AT_EOL_OUTPUT',0x00000002)
    win_const_mgr.add_const('FLAGSTATUS_COMPLETED',0x00000001)
    win_const_mgr.add_const('PID_FINDDATA',0x00000000)
    win_const_mgr.add_const('WMDM_E_MOREDATA',0x80045009)
    win_const_mgr.add_const('PROTO_IP_DHCP_ALLOCATOR',0x00002714)
    win_const_mgr.add_const('KLF_ACTIVATE',0x00000001)
    win_const_mgr.add_const('IDM_SHOWPRINT',0x000007DA)
    win_const_mgr.add_const('HLNF_UNTRUSTEDFORDOWNLOAD',0x02000000)
    win_const_mgr.add_const('MOUSEEVENTF_VIRTUALDESK',0x00004000)
    win_const_mgr.add_const('ISSH_BREAK_BIT',0x00000080)
    win_const_mgr.add_const('WSAEINVALIDPROCTABLE',0x00002778)
    win_const_mgr.add_const('DEFAULT_SNMPTRAP_PORT_IPX',0x00009010)
    win_const_mgr.add_const('DEBUG_REQUEST_TARGET_EXCEPTION_THREAD',0x00000002)
    win_const_mgr.add_const('CAUSE_BEARER_CAPABILITY_UNAVAILABLE',0x0000003A)
    win_const_mgr.add_const('IPX_NO_UPDATE',0x00000002)
    win_const_mgr.add_const('RF_POWER',0x00000040)
    win_const_mgr.add_const('BOM_DEFPARADIR',0x00000001)
    win_const_mgr.add_const('MAX_LCPRI',0x0000FFFF)
    win_const_mgr.add_const('SHCNE_DELETE',0x00000004)
    win_const_mgr.add_const('HEAP_GENERATE_EXCEPTIONS',0x00000004)
    win_const_mgr.add_const('SI_EDIT_PERMS',0x00000000)
    win_const_mgr.add_const('SQL_FETCH_FIRST_USER',0x0000001F)
    win_const_mgr.add_const('DMDFO_CENTER',0x00000002)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_DEVICE_OBJECT_ATTRIBUTES',0x00000085)
    win_const_mgr.add_const('DBTF_SLOWNET',0x00000004)
    win_const_mgr.add_const('GAA_FLAG_INCLUDE_GATEWAYS',0x00000080)
    win_const_mgr.add_const('HSHELL_HIGHBIT',0x00008000)
    win_const_mgr.add_const('ACM_DRIVERADDF_FUNCTION',0x00000003)
    win_const_mgr.add_const('ERROR_SXS_XML_E_BADXMLCASE',0x000036F5)
    win_const_mgr.add_const('DBPROPVAL_CO_STRING',0x00000002)
    win_const_mgr.add_const('FDTF_NOAUTOREADINGORDER',0x00000400)
    win_const_mgr.add_const('IMAGE_REL_EBC_REL32',0x00000002)
    win_const_mgr.add_const('DFCS_CAPTIONHELP',0x00000004)
    win_const_mgr.add_const('COLOR_GRADIENTINACTIVECAPTION',0x0000001C)
    win_const_mgr.add_const('DI_FLAGSEX_CI_FAILED',0x00000004)
    win_const_mgr.add_const('LINEFORWARDMODE_NOANSWEXTERNAL',0x00000400)
    win_const_mgr.add_const('IF_TYPE_DVBRCC_DOWNSTREAM',0x00000093)
    win_const_mgr.add_const('RES_CURSOR',0x00000002)
    win_const_mgr.add_const('PP_UNIQUE_CONTAINER',0x00000024)
    win_const_mgr.add_const('RQ_END_REQUEST',0x00000800)
    win_const_mgr.add_const('IPPORT_TCPMUX',0x00000001)
    win_const_mgr.add_const('DS_REPSYNC_TWO_WAY',0x00000800)
    win_const_mgr.add_const('CERT_EXCLUDED_SUBTREE_BIT',0x80000000)
    win_const_mgr.add_const('WMDM_STORAGECONTROL_INSERTBEFORE',0x00000200)
    win_const_mgr.add_const('SCARD_POWER_DOWN',0x00000000)
    win_const_mgr.add_const('OID_WAN_CO_GET_INFO',0x04010180)
    win_const_mgr.add_const('GESTURE_DOUBLE_ARROW_RIGHT',0x00000000)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_PCI_DEVICE_CUSTOM_PROPERTIES_REVISION_1',0x00000001)
    win_const_mgr.add_const('PROPID_QUERY_ALL',0x00000006)
    win_const_mgr.add_const('CDRF_SKIPDEFAULT',0x00000004)
    win_const_mgr.add_const('RPC_S_NO_PRINC_NAME',0x0000071E)
    win_const_mgr.add_const('MH_CREATE',0x00000001)
    win_const_mgr.add_const('FWPM_NET_EVENT_FLAG_IP_VERSION_SET',0x00000100)
    win_const_mgr.add_const('SQL_ATTR_PARAM_BIND_TYPE',0x00000012)
    win_const_mgr.add_const('DMPAPER_ENV_C5',0x0000001C)
    win_const_mgr.add_const('ERROR_IPSEC_TRANSPORT_FILTER_EXISTS',0x000032D0)
    win_const_mgr.add_const('NUM_LOG_CONF',0x00000006)
    win_const_mgr.add_const('WN_PRIMARY_AUTHENT_CLASS',0x00000004)
    win_const_mgr.add_const('MCI_DGV_WINDOW_DEFAULT',0x00000000)
    win_const_mgr.add_const('SQL_CVT_VARBINARY',0x00000800)
    win_const_mgr.add_const('SQL_ATTR_ODBC_VERSION',0x000000C8)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_MIN_CUSTOM',0x00000100)
    win_const_mgr.add_const('SQL_CURSOR_TYPE',0x00000006)
    win_const_mgr.add_const('PDH_FLAGS_CLOSE_QUERY',0x00000001)
    win_const_mgr.add_const('BCRYPT_RNG_OPERATION',0x00000020)
    win_const_mgr.add_const('MCI_UNFREEZE',0x00000845)
    win_const_mgr.add_const('DMDFO_DEFAULT',0x00000000)
    win_const_mgr.add_const('PRINTDLGEXORD',0x0000060D)
    win_const_mgr.add_const('CERT_FILE_STORE_COMMIT_ENABLE_FLAG',0x00010000)
    win_const_mgr.add_const('SAM_DAYS_PER_WEEK',0x00000007)
    win_const_mgr.add_const('DISPID_IMULTISESSION_INUSE',0x00000101)
    win_const_mgr.add_const('PSINJECT_PLATECOLOR',0x00000068)
    win_const_mgr.add_const('EPT_S_CANT_CREATE',0x0000076B)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_DISCONNECT',0x00000006)
    win_const_mgr.add_const('QS_KEY',0x00000001)
    win_const_mgr.add_const('CM_PROB_DUPLICATE_DEVICE',0x0000002A)
    win_const_mgr.add_const('SUBLANG_JAPANESE_JAPAN',0x00000001)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_QM_ACQUIRE_DROP',0x000035F2)
    win_const_mgr.add_const('NS_PNRPNAME',0x00000026)
    win_const_mgr.add_const('PSH_WIZARD_LITE',0x00400000)
    win_const_mgr.add_const('IF_TYPE_MPC',0x00000071)
    win_const_mgr.add_const('TRACE_HEADER_FLAG_USE_MOF_PTR',0x00100000)
    win_const_mgr.add_const('DDE_FREQUESTED',0x00001000)
    win_const_mgr.add_const('CRYPT_ACQUIRE_USE_PROV_INFO_FLAG',0x00000002)
    win_const_mgr.add_const('EAP_E_EAPHOST_METHOD_OPERATION_NOT_SUPPORTED',0x80420020)
    win_const_mgr.add_const('MM_STREAM_CLOSE',0x000003D5)
    win_const_mgr.add_const('D3DPSHADECAPS_COLORGOURAUDRGB',0x00000008)
    win_const_mgr.add_const('MAC_BINARY',0x00000001)
    win_const_mgr.add_const('SFVM_DEFVIEWMODE',0x0000001B)
    win_const_mgr.add_const('LANG_HINDI',0x00000039)
    win_const_mgr.add_const('DAO_NULL',0x00000000)
    win_const_mgr.add_const('DDCAPS_COLORKEYHWASSIST',0x01000000)
    win_const_mgr.add_const('MDITILE_VERTICAL',0x00000000)
    win_const_mgr.add_const('LDAP_MOD_BVALUES',0x00000080)
    win_const_mgr.add_const('CDO_E_PROP_UNSUPPORTED',0x80040205)
    win_const_mgr.add_const('RPC_PROTSEQ_TCP',0x00000001)
    win_const_mgr.add_const('SQLUNIQUEID',0x00000024)
    win_const_mgr.add_const('CTRY_ESTONIA',0x00000174)
    win_const_mgr.add_const('EAP_E_USER_ROOT_CERT_LAST',0x804203FF)
    win_const_mgr.add_const('LANG_DEFAULT_ID',0x00000100)
    win_const_mgr.add_const('ERROR_DS_DRA_NO_REPLICA',0x00002104)
    win_const_mgr.add_const('PARTITION_PREP',0x00000041)
    win_const_mgr.add_const('SV_MAXGLOBALOPENSEARCH_PARMNUM',0x00000235)
    win_const_mgr.add_const('PORT_LPD730',0x000002DA)
    win_const_mgr.add_const('TF_LBI_STYLE_HIDEONNOOTHERITEMS',0x00000004)
    win_const_mgr.add_const('TBSTYLE_DROPDOWN',0x00000008)
    win_const_mgr.add_const('MN_GETHMENU',0x000001E1)
    win_const_mgr.add_const('DDL_DIRECTORY',0x00000010)
    win_const_mgr.add_const('SV_TYPE_ALTERNATE_XPORT',0x20000000)
    win_const_mgr.add_const('DNS_CLASS_ALL',0x00000000)
    win_const_mgr.add_const('CERT_STORE_PROV_READ_CRL_FUNC',0x00000005)
    win_const_mgr.add_const('ERROR_DS_DRA_CONNECTION_FAILED',0x000020FC)
    win_const_mgr.add_const('DLLVER_PLATFORM_WINDOWS',0x00000001)
    win_const_mgr.add_const('EMR_RECTANGLE',0x0000002B)
    win_const_mgr.add_const('WINHTTP_AUTOPROXY_RUN_INPROCESS',0x00010000)
    win_const_mgr.add_const('ACCESS_ATTR_PARMNUM',0x00000002)
    win_const_mgr.add_const('NRB_OUTPUT_DATA_UNDERRUN',0x00000006)
    win_const_mgr.add_const('SPFILENOTIFY_ENDRENAME',0x00000009)
    win_const_mgr.add_const('KP_INFO',0x00000012)
    win_const_mgr.add_const('CM_LOCATE_DEVNODE_NORMAL',0x00000000)
    win_const_mgr.add_const('MDPROPVAL_MMF_OPENINGPERIOD',0x00000004)
    win_const_mgr.add_const('D3D10_MIN_BORDER_COLOR_COMPONENT',0x00000000)
    win_const_mgr.add_const('PTE_PS',0x00000037)
    win_const_mgr.add_const('ERROR_MUTUAL_AUTH_FAILED',0x00000575)
    win_const_mgr.add_const('LOCALE_STIME',0x0000001E)
    win_const_mgr.add_const('DEBUG_SOURCE_IS_STATEMENT',0x00000001)
    win_const_mgr.add_const('PID_DISPLACED_FROM',0x00000002)
    win_const_mgr.add_const('MCI_VCR_STATUS_CLOCK',0x0000401C)
    win_const_mgr.add_const('MAPIFORM_SELECT_FOLDER_REGISTRY_ONLY',0x00000001)
    win_const_mgr.add_const('WM_PALETTECHANGED',0x00000311)
    win_const_mgr.add_const('MV_INSTANCE',0x00002000)
    win_const_mgr.add_const('CRR_RECYCLED_FROM_UI',0xFFFFFFFB)
    win_const_mgr.add_const('DFS_VOLUME_STATE_RESYNCHRONIZE',0x00000010)
    win_const_mgr.add_const('IIS_MD_APP_BASE',0x0000238C)
    win_const_mgr.add_const('PSR_CPL_LEN',0x00000002)
    win_const_mgr.add_const('MCIWNDF_NOTIFYMEDIAW',0x00000800)
    win_const_mgr.add_const('CRYPT_DECODE_TO_BE_SIGNED_FLAG',0x00000002)
    win_const_mgr.add_const('CMSG_TRUSTED_SIGNER_FLAG',0x00000001)
    win_const_mgr.add_const('XP_ENCRYPTS',0x00002000)
    win_const_mgr.add_const('GC_WCH_ALL',0x00000004)
    win_const_mgr.add_const('WM_PRINT',0x00000317)
    win_const_mgr.add_const('RPC_FLAGS_VALID_BIT',0x00008000)
    win_const_mgr.add_const('CERT_SYSTEM_STORE_LOCATION_SHIFT',0x00000010)
    win_const_mgr.add_const('ERROR_TRANSACTION_NOT_FOUND',0x00001A3B)
    win_const_mgr.add_const('ERROR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE',0x00001783)
    win_const_mgr.add_const('D3DPMISCCAPS_INDEPENDENTWRITEMASKS',0x00004000)
    win_const_mgr.add_const('DISPID_FONT_ITALIC',0x00000004)
    win_const_mgr.add_const('ERROR_CTX_CONSOLE_DISCONNECT',0x00001B81)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_DH_FAIL',0x000035FE)
    win_const_mgr.add_const('STGM_READ',0x00000000)
    win_const_mgr.add_const('POLICY_AUDIT_EVENT_NONE',0x00000004)
    win_const_mgr.add_const('ERROR_KEY_DELETED',0x000003FA)
    win_const_mgr.add_const('NDIS_PACKET_TYPE_ALL_LOCAL',0x00000080)
    win_const_mgr.add_const('D3DPMISCCAPS_CULLCCW',0x00000040)
    win_const_mgr.add_const('PHONEERR_RESOURCEUNAVAIL',0x9000001F)
    win_const_mgr.add_const('HH_ENUM_CATEGORY',0x00000015)
    win_const_mgr.add_const('SORT_CHINESE_BOPOMOFO',0x00000003)
    win_const_mgr.add_const('WNODE_FLAG_ANSI_INSTANCENAMES',0x00004000)
    win_const_mgr.add_const('SQL_COLUMN_UNSIGNED',0x00000008)
    win_const_mgr.add_const('LGRPID_ARMENIAN',0x00000011)
    win_const_mgr.add_const('DIGCF_DEVICEINTERFACE',0x00000010)
    win_const_mgr.add_const('ERROR_FAIL_NOACTION_REBOOT',0x0000015E)
    win_const_mgr.add_const('SEL_MULTIOBJECT',0x00000008)
    win_const_mgr.add_const('SHDID_MOBILE_DEVICE',0x00000015)
    win_const_mgr.add_const('ILS_GLOW',0x00000001)
    win_const_mgr.add_const('IF_NORPCICERTREQUEST',0x00000008)
    win_const_mgr.add_const('ACCESS_MAX_MS_V5_ACE_TYPE',0x00000011)
    win_const_mgr.add_const('KS_VIDEO_ALLOC_VPE_AGP',0x00000004)
    win_const_mgr.add_const('TAPE_DRIVE_WRITE_SHORT_FMKS',0x84000000)
    win_const_mgr.add_const('ERROR_INCOMPATIBLE_SERVICE_PRIVILEGE',0x00000511)
    win_const_mgr.add_const('TF_RP_SUBITEMINSETTINGUI',0x00000010)
    win_const_mgr.add_const('LVCF_FMT',0x00000001)
    win_const_mgr.add_const('PDCAP_D2_SUPPORTED',0x00000004)
    win_const_mgr.add_const('SO_LINGER',0x00000080)
    win_const_mgr.add_const('SQL_CREATE_TABLE',0x00000084)
    win_const_mgr.add_const('SV_MAXAUDITSZ_PARMNUM',0x0000002B)
    win_const_mgr.add_const('NET_STRING_NAMED_SERVICE',0x00000200)
    win_const_mgr.add_const('SV_TYPE_SERVER',0x00000002)
    win_const_mgr.add_const('ERROR_SERVICE_NOT_IN_EXE',0x0000043B)
    win_const_mgr.add_const('TVS_DISABLEDRAGDROP',0x00000010)
    win_const_mgr.add_const('RTM_ROUTE_FLAGS_LOOPBACK',0x00000080)
    win_const_mgr.add_const('MCI_DEVTYPE_DAT',0x00000205)
    win_const_mgr.add_const('GOPHER_TYPE_IMAGE',0x00002000)
    win_const_mgr.add_const('TIMECODE_SMPTE_BINARY_GROUP',0x00000007)
    win_const_mgr.add_const('DSPRINT_REPUBLISH',0x00000008)
    win_const_mgr.add_const('CREDENTIAL_SUB_TYPE_KERBEROS_TKT',0x00000003)
    win_const_mgr.add_const('WM_MBUTTONDBLCLK',0x00000209)
    win_const_mgr.add_const('ERROR_END_OF_MEDIA',0x0000044C)
    win_const_mgr.add_const('PORT_UAAC',0x00000091)
    win_const_mgr.add_const('D3DPBLENDCAPS_SRCALPHA',0x00000010)
    win_const_mgr.add_const('CALLBACK_STREAM_SWITCH',0x00000001)
    win_const_mgr.add_const('NUMPRS_PARENS',0x00000080)
    win_const_mgr.add_const('SHI1005_FLAGS_FORCE_SHARED_DELETE',0x00000200)
    win_const_mgr.add_const('SQL_HC_OFF',0x00000000)
    win_const_mgr.add_const('WIA_DONT_SHOW_PREVIEW_CONTROL',0x00000001)
    win_const_mgr.add_const('DRVCNF_OK',0x00000001)
    win_const_mgr.add_const('WINWATCHNOTIFY_CHANGED',0x00000004)
    win_const_mgr.add_const('ERROR_IS_SUBST_PATH',0x00000092)
    win_const_mgr.add_const('APPLICATION_INSTALL',0x00000000)
    win_const_mgr.add_const('MIN_EVENT',0x00000064)
    win_const_mgr.add_const('HICF_OTHER',0x00000000)
    win_const_mgr.add_const('WMS_CONTAINER_FLAGS',0x00000003)
    win_const_mgr.add_const('PUBLICKEYBLOBEX',0x0000000A)
    win_const_mgr.add_const('JOB_OBJECT_LIMIT_KILL_ON_JOB_CLOSE',0x00002000)
    win_const_mgr.add_const('DTT_GLOWSIZE',0x00000001)
    win_const_mgr.add_const('WINHTTP_QUERY_ORIG_URI',0x00000022)
    win_const_mgr.add_const('DS_NDNC_FLAG',0x00000400)
    win_const_mgr.add_const('BCSS_NOSPLIT',0x00000001)
    win_const_mgr.add_const('LDAP_OPT_THREAD_FN_PTRS',0x00000005)
    win_const_mgr.add_const('RPC_C_AUTHN_DCE_PUBLIC',0x00000002)
    win_const_mgr.add_const('SQL_MAX_DSN_LENGTH',0x00000020)
    win_const_mgr.add_const('R2_NOP',0x0000000B)
    win_const_mgr.add_const('HHWIN_PROP_TAB_SEARCH',0x00000001)
    win_const_mgr.add_const('WINHTTP_OPTION_EXTENDED_ERROR',0x00000018)
    win_const_mgr.add_const('TTF_DI_SETITEM',0x00008000)
    win_const_mgr.add_const('BG_E_NEW_OWNER_NO_FILE_ACCESS',0x80200016)
    win_const_mgr.add_const('SQL_CODE_MINUTE',0x00000005)
    win_const_mgr.add_const('DBPROPVAL_STGM_CONVERT',0x00040000)
    win_const_mgr.add_const('WINHTTP_QUERY_MAX_FORWARDS',0x0000003C)
    win_const_mgr.add_const('OID_GEN_DIRECTED_BYTES_XMIT',0x00020201)
    win_const_mgr.add_const('SMART_ABORT_OFFLINE_SELFTEST',0x0000007F)
    win_const_mgr.add_const('EVENT_TRACE_CONTROL_UPDATE',0x00000002)
    win_const_mgr.add_const('MAXIMUM_ATTR_STRING_LENGTH',0x00000020)
    win_const_mgr.add_const('MAX_CRED_SIZE',0x00000400)
    win_const_mgr.add_const('IP_DEFAULT_MULTICAST_TTL',0x00000001)
    win_const_mgr.add_const('RUNCMDS_QUIET',0x00000001)
    win_const_mgr.add_const('TMT_MENUBAR',0x0000065F)
    win_const_mgr.add_const('ATAPI_ID_CMD',0x000000A1)
    win_const_mgr.add_const('NDIS_ENCAPSULATION_NOT_SUPPORTED',0x00000000)
    win_const_mgr.add_const('MD_DIMTYPE_TIME',0x00000001)
    win_const_mgr.add_const('IDSI_FLAG_PROXY',0x00000004)
    win_const_mgr.add_const('BSF_ALLOWSFW',0x00000080)
    win_const_mgr.add_const('ERROR_DS_NAME_TOO_MANY_PARTS',0x0000209B)
    win_const_mgr.add_const('BDIF_NAME',0x00000004)
    win_const_mgr.add_const('NRB_FUNCTION_QUERY_ASCENDER_STATUS',0x000000D0)
    win_const_mgr.add_const('COM_RIGHTS_EXECUTE',0x00000001)
    win_const_mgr.add_const('SPI_GETKEYBOARDSPEED',0x0000000A)
    win_const_mgr.add_const('IF_TYPE_HDLC',0x00000076)
    win_const_mgr.add_const('KP_PREHASH',0x00000022)
    win_const_mgr.add_const('XINPUT_GAMEPAD_LEFT_THUMB_DEADZONE',0x00001EA9)
    win_const_mgr.add_const('AVI_HEADERSIZE',0x00000800)
    win_const_mgr.add_const('OPTION_MESSAGE',0x00000038)
    win_const_mgr.add_const('LVGF_NONE',0x00000000)
    win_const_mgr.add_const('ERROR_SHUTDOWN_IN_PROGRESS',0x0000045B)
    win_const_mgr.add_const('SBSP_DEFMODE',0x00000000)
    win_const_mgr.add_const('ERROR_TS_INCOMPATIBLE_SESSIONS',0x00001B9D)
    win_const_mgr.add_const('MUI_USE_SEARCH_ALL_LANGUAGES',0x00000040)
    win_const_mgr.add_const('CRYPTPROTECTMEMORY_CROSS_PROCESS',0x00000001)
    win_const_mgr.add_const('IPSEC_CIPHER_CONFIG_CBC_DES',0x00000001)
    win_const_mgr.add_const('LINEDEVSTATUSFLAGS_MSGWAIT',0x00000002)
    win_const_mgr.add_const('STATIC_CACHE_ENTRY',0x00000080)
    win_const_mgr.add_const('DISPID_WINDOW',0x00000001)
    win_const_mgr.add_const('IP_OPT_TS',0x00000044)
    win_const_mgr.add_const('USE_ASGTYPE_PARMNUM',0x00000004)
    win_const_mgr.add_const('CRL_REASON_SUPERSEDED',0x00000004)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_SAMPLE_USES_CURRENT_INPUT_FRAME',0x00000004)
    win_const_mgr.add_const('TASK_TRIGGER_FLAG_DISABLED',0x00000004)
    win_const_mgr.add_const('MAX_INSTALLWIZARD_DYNAPAGES',0x00000014)
    win_const_mgr.add_const('D3DFVFCAPS_PSIZE',0x00100000)
    win_const_mgr.add_const('SCARD_E_PCI_TOO_SMALL',0x80100019)
    win_const_mgr.add_const('RSC_FLAG_UPDHLPDLLS',0x00000010)
    win_const_mgr.add_const('CHANGER_PREDISMOUNT_ALIGN_TO_DRIVE',0x80000002)
    win_const_mgr.add_const('WAVE_FORMAT_48M08',0x00001000)
    win_const_mgr.add_const('APMTIMEOUT_DISABLED',0x00000000)
    win_const_mgr.add_const('ACMFORMATCHOOSE_STYLEF_ENABLEHOOK',0x00000008)
    win_const_mgr.add_const('WLX_OPTION_USE_CTRL_ALT_DEL',0x00000001)
    win_const_mgr.add_const('BSF_NOTIMEOUTIFNOTHUNG',0x00000040)
    win_const_mgr.add_const('BG_E_HTTP_ERROR_449',0x801901C1)
    win_const_mgr.add_const('MCI_ANIM_GETDEVCAPS_NORMAL_RATE',0x00004004)
    win_const_mgr.add_const('CRYPT_VOLATILE',0x00001000)
    win_const_mgr.add_const('SCRIPTITEM_GLOBALMEMBERS',0x00000008)
    win_const_mgr.add_const('SNMPAPI_SIZE_INVALID',0x00000011)
    win_const_mgr.add_const('PROV_EC_ECDSA_FULL',0x00000010)
    win_const_mgr.add_const('CERT_VERIFY_REV_SERVER_OCSP_FLAG',0x00000008)
    win_const_mgr.add_const('MAXIMUM_PROCESSORS',0x00000020)
    win_const_mgr.add_const('TTF_TRANSPARENT',0x00000100)
    win_const_mgr.add_const('D3DPRASTERCAPS_FOGRANGE',0x00010000)
    win_const_mgr.add_const('DTR_KERNEL_INDEX',0x00000001)
    win_const_mgr.add_const('GLOBAL_FREE',0x00000002)
    win_const_mgr.add_const('MDM_V110_SPEED_57DOT6K',0x0000000A)
    win_const_mgr.add_const('PRIVACY_IMPACTED_CACHE_ENTRY',0x02000000)
    win_const_mgr.add_const('SV_SENDSFROMPREFERREDPROCESSOR_PARMNUM',0x00000249)
    win_const_mgr.add_const('ERROR_INVALID_WINDOW_HANDLE',0x00000578)
    win_const_mgr.add_const('PARTITION_XINT13',0x0000000E)
    win_const_mgr.add_const('SHDID_NET_DOMAIN',0x0000000D)
    win_const_mgr.add_const('CONNDLG_USE_MRU',0x00000004)
    win_const_mgr.add_const('ERROR_BADDB',0x000003F1)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_SUSPEND',0x00000008)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_INTERRUPT',0x00000040)
    win_const_mgr.add_const('LINECALLINFOSTATE_CALLEDID',0x00010000)
    win_const_mgr.add_const('CM_GETIDLIST_FILTER_BUSRELATIONS',0x00000020)
    win_const_mgr.add_const('PI_NUMBER_NOT_AVAILABLE',0x00000080)
    win_const_mgr.add_const('MDM_SHIFT_PROTOCOLDATA',0x00000014)
    win_const_mgr.add_const('LOCALE_SISO639LANGNAME2',0x00000067)
    win_const_mgr.add_const('PIDMSI_STATUS',0x00000007)
    win_const_mgr.add_const('SYNC_HANDLERTYPE_PROGRAMS',0x00000001)
    win_const_mgr.add_const('ILFIP_FROMSTANDBY',0x00000001)
    win_const_mgr.add_const('IMAGE_SYM_TYPE_UINT',0x0000000E)
    win_const_mgr.add_const('IDM_GETZOOMNUMERATOR',0x00000929)
    win_const_mgr.add_const('LVCF_IMAGE',0x00000010)
    win_const_mgr.add_const('DEBUG_MANAGED_DLL_LOADED',0x00000002)
    win_const_mgr.add_const('AE_GUEST',0x00000000)
    win_const_mgr.add_const('CERT_END_ENTITY_SUBJECT_FLAG',0x00000040)
    win_const_mgr.add_const('RETURN_SMART_STATUS',0x000000DA)
    win_const_mgr.add_const('RBBIM_IMAGE',0x00000008)
    win_const_mgr.add_const('SVTI2_REMAP_PIPE_NAMES',0x00000002)
    win_const_mgr.add_const('URLPOLICY_BEHAVIOR_CHECK_LIST',0x00010000)
    win_const_mgr.add_const('FEATURESETTING_PRIVATE_END',0x00001FFF)
    win_const_mgr.add_const('SQL_LIKE_ESCAPE_CLAUSE',0x00000071)
    win_const_mgr.add_const('SECPKG_ATTR_SUPPORTED_ALGS',0x00000056)
    win_const_mgr.add_const('RIDI_DEVICEINFO',0x02000000)
    win_const_mgr.add_const('QS_TIMER',0x00000010)
    win_const_mgr.add_const('ERROR_DS_TIMELIMIT_EXCEEDED',0x00002022)
    win_const_mgr.add_const('KSNODEPIN_DEMUX_IN',0x00000000)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_REFQ3',0x00000013)
    win_const_mgr.add_const('USER_MARSHAL_POINTER',0x00000000)
    win_const_mgr.add_const('FLAG_EMBEDDEDPROFILE',0x00000001)
    win_const_mgr.add_const('DRV_INSTALL',0x00000009)
    win_const_mgr.add_const('DISPID_TABLEPARAMS_CELLATTRS',0x00000004)
    win_const_mgr.add_const('OID_TAPI_SET_MEDIA_MODE',0x07030121)
    win_const_mgr.add_const('ACTRL_ACCESS_ALLOWED',0x00000001)
    win_const_mgr.add_const('GTL_USECRLF',0x00000001)
    win_const_mgr.add_const('MKSYS_URLMONIKER',0x00000006)
    win_const_mgr.add_const('STI_DEVSTATUS_ONLINE_STATE',0x00000001)
    win_const_mgr.add_const('FD_QOS_BIT',0x00000006)
    win_const_mgr.add_const('COD_PHONE_MINOR_CORDLESS',0x00000002)
    win_const_mgr.add_const('LCID_ALTERNATE_SORTS',0x00000004)
    win_const_mgr.add_const('IF_TYPE_IF_GSN',0x00000091)
    win_const_mgr.add_const('SQL_CA2_READ_ONLY_CONCURRENCY',0x00000001)
    win_const_mgr.add_const('MQMSG_DELIVERY_RECOVERABLE',0x00000001)
    win_const_mgr.add_const('D3DPTEXTURECAPS_MIPMAP',0x00004000)
    win_const_mgr.add_const('REFERENCE_BLACK_MAX',0x00000FA0)
    win_const_mgr.add_const('MIXER_GETLINECONTROLSF_ONEBYID',0x00000001)
    win_const_mgr.add_const('MDITILE_SKIPDISABLED',0x00000002)
    win_const_mgr.add_const('TRANSACTIONMANAGER_QUERY_INFORMATION',0x00000001)
    win_const_mgr.add_const('INTERNET_DEFAULT_PORT',0x00000000)
    win_const_mgr.add_const('DNS_RTYPE_UINFO',0x00006400)
    win_const_mgr.add_const('NET_VALIDATE_PASSWORD_HISTORY_LENGTH',0x00000010)
    win_const_mgr.add_const('AE_USER',0x00000001)
    win_const_mgr.add_const('TVE_TOGGLE',0x00000003)
    win_const_mgr.add_const('VER_ERR_ARG_RET',0xFFFFFFFE)
    win_const_mgr.add_const('IKEEXT_CERT_AUTH_ENABLE_CRL_CHECK_STRONG',0x00000004)
    win_const_mgr.add_const('HICF_LMOUSE',0x00000080)
    win_const_mgr.add_const('S_THRESHOLD',0x00000001)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_HOTFIX_UNINSTALL',0x00000017)
    win_const_mgr.add_const('SSPROP_CHARACTERSET',0x00000005)
    win_const_mgr.add_const('ETO_IGNORELANGUAGE',0x00001000)
    win_const_mgr.add_const('ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC',0x00002184)
    win_const_mgr.add_const('IDC_LP_BREAKLINK',0x000003F0)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_REFQ1',0x00000015)
    win_const_mgr.add_const('DNF_ALWAYSEXCLUDEFROMLIST',0x00080000)
    win_const_mgr.add_const('ILCF_SWAP',0x00000001)
    win_const_mgr.add_const('WIA_IPA_REGION_TYPE',0x00001017)
    win_const_mgr.add_const('PSR_CPL',0x00000020)
    win_const_mgr.add_const('MQMSG_AUTH_LEVEL_MSMQ10',0x00000002)
    win_const_mgr.add_const('WMDM_SCP_REVOKED',0x00000008)
    win_const_mgr.add_const('LARGE_ENTRY',0x00000003)
    win_const_mgr.add_const('INFINFO_INF_PATH_LIST_SEARCH',0x00000005)
    win_const_mgr.add_const('SDP_ERROR_INVALID_CONTINUATION_STATE',0x00000005)
    win_const_mgr.add_const('NUM_FLICK_DIRECTIONS',0x00000008)
    win_const_mgr.add_const('WINHTTP_QUERY_RAW_HEADERS',0x00000015)
    win_const_mgr.add_const('CPF_FILE_ERROR',0x00000200)
    win_const_mgr.add_const('SBSP_SAMEBROWSER',0x00000001)
    win_const_mgr.add_const('WM_CONVERTRESULT',0x0000010B)
    win_const_mgr.add_const('VOS__BASE',0x00000000)
    win_const_mgr.add_const('WMDRM_CLEAN_LICENSE_STORE_SYNC',0x00000001)
    win_const_mgr.add_const('MOUSEEVENTF_RIGHTDOWN',0x00000008)
    win_const_mgr.add_const('RPC_NCA_FLAGS_BROADCAST',0x00000002)
    win_const_mgr.add_const('SSA_LINK',0x00001000)
    win_const_mgr.add_const('LINEFEATURE_DEVSPECIFICFEAT',0x00000002)
    win_const_mgr.add_const('DEVICEPOWER_FILTER_DEVICES_PRESENT',0x20000000)
    win_const_mgr.add_const('PSH_PROPSHEETPAGE',0x00000008)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_INTERNET_USER',0x80200000)
    win_const_mgr.add_const('WAVE_FORMAT_44M08',0x00000100)
    win_const_mgr.add_const('ERROR_CHILD_NOT_COMPLETE',0x00000081)
    win_const_mgr.add_const('NTDSDSA_OPT_DISABLE_OUTBOUND_SELECT_SECRET_NULL',0x00000001)
    win_const_mgr.add_const('GMDI_GOINTOPOPUPS',0x00000002)
    win_const_mgr.add_const('EMR_ROUNDRECT',0x0000002C)
    win_const_mgr.add_const('INTERNET_FLAG_IGNORE_CERT_DATE_INVALID',0x00002000)
    win_const_mgr.add_const('MCI_DGV_STATUS_FILEFORMAT',0x00004008)
    win_const_mgr.add_const('IF_TYPE_COMPOSITELINK',0x0000009B)
    win_const_mgr.add_const('RR_RID_LEN',0x00000018)
    win_const_mgr.add_const('DDBLTFX_NOTEARING',0x00000008)
    win_const_mgr.add_const('MCI_CLOSE',0x00000804)
    win_const_mgr.add_const('CHANGER_CLOSE_IEPORT',0x00000004)
    win_const_mgr.add_const('SQL_SR_USAGE_ON_CHARACTER_SET',0x00000002)
    win_const_mgr.add_const('WLAN_UI_API_INITIAL_VERSION',0x00000001)
    win_const_mgr.add_const('SECURITY_DIALUP_RID',0x00000001)
    win_const_mgr.add_const('RPC_X_WRONG_PIPE_VERSION',0x00000728)
    win_const_mgr.add_const('WIA_COMPRESSION_JPEG2K',0x00000007)
    win_const_mgr.add_const('TIMECODE_RATE_30DROP',0x00000000)
    win_const_mgr.add_const('SFGAO_FILESYSANCESTOR',0x10000000)
    win_const_mgr.add_const('WIA_IPS_PAGES',0x00000C18)
    win_const_mgr.add_const('DNS_QUERY_RESERVED',0x00000000)
    win_const_mgr.add_const('VFT2_DRV_SOUND',0x00000009)
    win_const_mgr.add_const('INVALID_TASK_ID',0x00000000)
    win_const_mgr.add_const('CRESTRICTIONS_MDSCHEMA_COMMANDS',0x00000005)
    win_const_mgr.add_const('CERT_DISPWELL_DISTRUST_ADD_CA_CERT',0x00000008)
    win_const_mgr.add_const('SM_CYVIRTUALSCREEN',0x0000004F)
    win_const_mgr.add_const('CFM_KERNING',0x00100000)
    win_const_mgr.add_const('ERROR_SETCOUNT_ON_BAD_LB',0x00000599)
    win_const_mgr.add_const('DXVA_FILM_GRAIN_BUFFER',0x00000011)
    win_const_mgr.add_const('CREDUI_FLAGS_ALWAYS_SHOW_UI',0x00000080)
    win_const_mgr.add_const('VER_SUITE_BLADE',0x00000400)
    win_const_mgr.add_const('USER_USE_AES_KEYS',0x00200000)
    win_const_mgr.add_const('FWP_ACTRL_MATCH_FILTER',0x00000001)
    win_const_mgr.add_const('SCOPE_TYPE_VPATH',0x00000200)
    win_const_mgr.add_const('TSF_FAIL_EXIST',0x00000000)
    win_const_mgr.add_const('NETBIOS_NAME_LEN',0x00000010)
    win_const_mgr.add_const('SND_FILENAME',0x00020000)
    win_const_mgr.add_const('LOCALE_IPOSSIGNPOSN',0x00000052)
    win_const_mgr.add_const('LVGS_NOHEADER',0x00000004)
    win_const_mgr.add_const('KAGPROP_MAXCOLUMNSINGROUPBY',0x0000000C)
    win_const_mgr.add_const('LVGF_GROUPID',0x00000010)
    win_const_mgr.add_const('FWP_OPTION_VALUE_DISABLE_LOOSE_SOURCE',0x00000000)
    win_const_mgr.add_const('DEFAULT_PALETTE',0x0000000F)
    win_const_mgr.add_const('TBSTYLE_AUTOSIZE',0x00000010)
    win_const_mgr.add_const('SM_CYMINTRACK',0x00000023)
    win_const_mgr.add_const('CLUSCTL_CONTROL_CODE_MASK',0x003FFFFF)
    win_const_mgr.add_const('CRED_MAX_ATTRIBUTES',0x00000040)
    win_const_mgr.add_const('DBPROPVAL_SQL_ANSI89_IEF',0x00000008)
    win_const_mgr.add_const('LB_DST_ADDR_USE_DSTADDR_FLAG',0x00000008)
    win_const_mgr.add_const('CM_PROB_LEGACY_SERVICE_NO_DEVICES',0x00000029)
    win_const_mgr.add_const('SM_IMMENABLED',0x00000052)
    win_const_mgr.add_const('IDD_DYNAWIZ_ANALYZE_NEXTPAGE',0x00002714)
    win_const_mgr.add_const('SNMP_MGMTAPI_TRAP_DUPINIT',0x0000002B)
    win_const_mgr.add_const('DS_NOFAILCREATE',0x00000010)
    win_const_mgr.add_const('KSNODEPIN_STANDARD_IN',0x00000001)
    win_const_mgr.add_const('WC_SEPCHARS',0x00000020)
    win_const_mgr.add_const('SP_COPY_NOSKIP',0x00000400)
    win_const_mgr.add_const('DI_SHOWOEM',0x00000001)
    win_const_mgr.add_const('DISPID_ACTIVEELMENTS_LENGTH',0x00000005)
    win_const_mgr.add_const('INTERNET_OPTION_REMOVE_IDENTITY',0x0000004F)
    win_const_mgr.add_const('PORT_DN6SMMRED',0x000000C4)
    win_const_mgr.add_const('SUBLANG_FRENCH_SWISS',0x00000004)
    win_const_mgr.add_const('DM_POSITION',0x00000020)
    win_const_mgr.add_const('WM_CLOSE',0x00000010)
    win_const_mgr.add_const('CTRY_PORTUGAL',0x0000015F)
    win_const_mgr.add_const('SQL_ISV_DOMAIN_CONSTRAINTS',0x00000200)
    win_const_mgr.add_const('CTRY_BELGIUM',0x00000020)
    win_const_mgr.add_const('MCI_DGV_INFO_STILL_QUALITY',0x00004002)
    win_const_mgr.add_const('COMPONENT_DEFAULT_TOP',0x0000FFFF)
    win_const_mgr.add_const('DNS_ERROR_MASK',0x00002328)
    win_const_mgr.add_const('CERT_CHAIN_REVOCATION_CHECK_CHAIN_EXCLUDE_ROOT',0x40000000)
    win_const_mgr.add_const('GPO_INFO_FLAG_FORCED_REFRESH',0x00000400)
    win_const_mgr.add_const('HDS_HOTTRACK',0x00000004)
    win_const_mgr.add_const('IMAGE_REL_PPC_TOCREL16',0x00000008)
    win_const_mgr.add_const('LINECALLHUBTRACKING_NONE',0x00000000)
    win_const_mgr.add_const('IMAGE_REL_PPC_TOCREL14',0x00000009)
    win_const_mgr.add_const('SERVICE_RESOURCE',0x00000001)
    win_const_mgr.add_const('ISCSI_LOGIN_FLAG_MULTIPATH_ENABLED',0x00000002)
    win_const_mgr.add_const('INTERNET_IDENTITY_FLAG_PRIVATE_CACHE',0x00000001)
    win_const_mgr.add_const('MCI_VD_OFFSET',0x00000400)
    win_const_mgr.add_const('SNMPAPI_MESSAGE_INVALID',0x00000013)
    win_const_mgr.add_const('DBDTF_RETURNFQDN',0x00000001)
    win_const_mgr.add_const('BATTERY_POWER_ON_LINE',0x00000001)
    win_const_mgr.add_const('AUTO_PROXY_FLAG_DETECTION_SUSPECT',0x00000040)
    win_const_mgr.add_const('BSF_SENDNOTIFYMESSAGE',0x00000100)
    win_const_mgr.add_const('TAPE_DRIVE_PADDING',0x00040000)
    win_const_mgr.add_const('URLACTION_HTML_INCLUDE_FILE_PATH',0x0000160A)
    win_const_mgr.add_const('PHONEINITIALIZEEXOPTION_USECOMPLETIONPORT',0x00000003)
    win_const_mgr.add_const('SQL_SRJO_EXCEPT_JOIN',0x00000004)
    win_const_mgr.add_const('CM_REENUMERATE_BITS',0x00000007)
    win_const_mgr.add_const('BSM_APPLICATIONS',0x00000008)
    win_const_mgr.add_const('SM_CXSCREEN',0x00000000)
    win_const_mgr.add_const('DEVICEPOWER_CLEAR_WAKEENABLED',0x00000002)
    win_const_mgr.add_const('CP_WINUNICODE',0x000004B0)
    win_const_mgr.add_const('DMMEDIA_STANDARD',0x00000001)
    win_const_mgr.add_const('PATCH_SYMBOL_UNDECORATED_TOO',0x00000004)
    win_const_mgr.add_const('OID_LTALK_FCS_ERRORS',0x05020206)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_SECRELLO',0x00000011)
    win_const_mgr.add_const('CDS_UPDATEREGISTRY',0x00000001)
    win_const_mgr.add_const('DI_PROPERTIES_CHANGE',0x00004000)
    win_const_mgr.add_const('ENABLE_LINE_INPUT',0x00000002)
    win_const_mgr.add_const('SUBLANG_GERMAN_SWISS',0x00000002)
    win_const_mgr.add_const('MDLEVEL_TYPE_TIME_YEARS',0x00000014)
    win_const_mgr.add_const('VALIDATEUNC_PRINT',0x00000004)
    win_const_mgr.add_const('MCI_WAIT',0x00000002)
    win_const_mgr.add_const('SPI_SETDROPSHADOW',0x00001025)
    win_const_mgr.add_const('VK_OEM_PERIOD',0x000000BE)
    win_const_mgr.add_const('CERT_STORE_PROV_WRITE_CTL_FUNC',0x0000000A)
    win_const_mgr.add_const('SUBLANG_TAMAZIGHT_ALGERIA_LATIN',0x00000002)
    win_const_mgr.add_const('XECR_PKCS7',0x00000002)
    win_const_mgr.add_const('GL_ID_INPUTSYMBOL',0x00000027)
    win_const_mgr.add_const('TRACE_USE_MASK',0x00000002)
    win_const_mgr.add_const('IP_INTFC_INFO_ID',0x00000103)
    win_const_mgr.add_const('ERROR_ACCOUNT_LOCKED_OUT',0x00000775)
    win_const_mgr.add_const('ERROR_SXS_DUPLICATE_IID',0x000036C8)
    win_const_mgr.add_const('DMPAPER_LEGAL_EXTRA',0x00000033)
    win_const_mgr.add_const('SCH_CRED_REVOCATION_CHECK_CHAIN',0x00000200)
    win_const_mgr.add_const('ACMFILTERDETAILS_FILTER_CHARS',0x00000080)
    win_const_mgr.add_const('LOCALE_SABBREVDAYNAME7',0x00000037)
    win_const_mgr.add_const('MCI_DGV_LIST_COUNT',0x00020000)
    win_const_mgr.add_const('LOCALE_SABBREVDAYNAME5',0x00000035)
    win_const_mgr.add_const('SQL_CVT_DATE',0x00008000)
    win_const_mgr.add_const('MD_ACR_WRITE',0x00000002)
    win_const_mgr.add_const('LOCALE_SABBREVDAYNAME2',0x00000032)
    win_const_mgr.add_const('LOCALE_SABBREVDAYNAME1',0x00000031)
    win_const_mgr.add_const('D3DVS20CAPS_PREDICATION',0x00000001)
    win_const_mgr.add_const('MFE_IIF',0x00000008)
    win_const_mgr.add_const('ERROR_LOG_CONTAINER_READ_FAILED',0x000019EF)
    win_const_mgr.add_const('IPPROTO_RAW',0x000000FF)
    win_const_mgr.add_const('XA_NOMIGRATE',0x00000009)
    win_const_mgr.add_const('SUBLANG_WELSH_UNITED_KINGDOM',0x00000001)
    win_const_mgr.add_const('MDM_HDLCPPP_ML_DEFAULT',0x00000000)
    win_const_mgr.add_const('IME_CMODE_SYMBOL',0x00000400)
    win_const_mgr.add_const('META_OFFSETCLIPRGN',0x00000220)
    win_const_mgr.add_const('IF_TYPE_REACH_DSL',0x000000C0)
    win_const_mgr.add_const('KSAUDIO_QUALITY_ADVANCED',0x00000003)
    win_const_mgr.add_const('JOB_STATUS_PAPEROUT',0x00000040)
    win_const_mgr.add_const('EM_GETFIRSTVISIBLELINE',0x000000CE)
    win_const_mgr.add_const('OPTION_IMPRESS_SERVERS',0x0000000A)
    win_const_mgr.add_const('IMAGE_REL_SH3_DIRECT8',0x00000003)
    win_const_mgr.add_const('PAN_WEIGHT_BLACK',0x0000000A)
    win_const_mgr.add_const('CERT_TRUST_HAS_ISSUANCE_CHAIN_POLICY',0x00000200)
    win_const_mgr.add_const('EMR_EXTCREATEPEN',0x0000005F)
    win_const_mgr.add_const('DISPID_WMPCORE_MIN',0x00000001)
    win_const_mgr.add_const('DEBUG_CLASS_KERNEL',0x00000001)
    win_const_mgr.add_const('PIR_OPTION_DEFAULT',0x00000000)
    win_const_mgr.add_const('NOTIFIER_TYPE_INTERVAL',0x00000001)
    win_const_mgr.add_const('PIR_STATUS_MINIPORT_NONE',0x00000003)
    win_const_mgr.add_const('BS_CENTER',0x00000300)
    win_const_mgr.add_const('SAFER_POLICY_ONLY_AUDIT',0x00001000)
    win_const_mgr.add_const('DT_END_ELLIPSIS',0x00008000)
    win_const_mgr.add_const('RPC_S_INVALID_RPC_PROTSEQ',0x000006A8)
    win_const_mgr.add_const('PROPCALLER_POLICY',0x00000200)
    win_const_mgr.add_const('D3DFVF_TEXCOUNT_SHIFT',0x00000008)
    win_const_mgr.add_const('EC_VMR_SURFACE_FLIPPED',0x00000054)
    win_const_mgr.add_const('MCI_DGV_STATUS_PAUSE_MODE',0x00004026)
    win_const_mgr.add_const('NOTIFIER_TYPE_STATE_CHANGE',0x00000003)
    win_const_mgr.add_const('ERROR_TRUSTED_RELATIONSHIP_FAILURE',0x000006FD)
    win_const_mgr.add_const('CTRY_VIET_NAM',0x00000054)
    win_const_mgr.add_const('INHERIT_NO_PROPAGATE',0x00000004)
    win_const_mgr.add_const('SYMSEARCH_GLOBALSONLY',0x00000000)
    win_const_mgr.add_const('JOB_NOTIFY_FIELD_PARAMETERS',0x00000007)
    win_const_mgr.add_const('DISPID_XOBJ_MIN',0x00010000)
    win_const_mgr.add_const('USE_DISCONN',0x00000002)
    win_const_mgr.add_const('MARSHALINTERFACE_MIN',0x000001F4)
    win_const_mgr.add_const('STI_DEVICE_CREATE_STATUS',0x00000001)
    win_const_mgr.add_const('PLA_CAPABILITY_AUTOLOGGER',0x00000020)
    win_const_mgr.add_const('GDICOMMENT_IDENTIFIER',0x43494447)
    win_const_mgr.add_const('ATA_FLAGS_DATA_IN',0x00000001)
    win_const_mgr.add_const('CRYPT_DECODE_ALLOC_FLAG',0x00008000)
    win_const_mgr.add_const('CLIP_LH_ANGLES',0x00000001)
    win_const_mgr.add_const('LINEBUSYMODE_UNAVAIL',0x00000008)
    win_const_mgr.add_const('META_SETPIXEL',0x0000041F)
    win_const_mgr.add_const('LGRPID_TURKISH',0x00000006)
    win_const_mgr.add_const('WIA_RESERVED_FOR_NEW_PROPS',0x00000400)
    win_const_mgr.add_const('ERROR_THREAD_MODE_ALREADY_BACKGROUND',0x00000190)
    win_const_mgr.add_const('DEBUG_FILTER_CREATE_THREAD',0x00000000)
    win_const_mgr.add_const('REGDF_NOTVERIFIED',0x80000000)
    win_const_mgr.add_const('IPX_TRAFFIC_FILTER_ON_PKTTYPE',0x00000100)
    win_const_mgr.add_const('LOCALE_IOPTIONALCALENDAR',0x0000100B)
    win_const_mgr.add_const('C3_HALFWIDTH',0x00000040)
    win_const_mgr.add_const('CRL_DIST_POINT_ERR_CRL_ISSUER_BIT',0x80000000)
    win_const_mgr.add_const('ACTRL_DS_READ_PROP',0x00000010)
    win_const_mgr.add_const('IDD_DYNAWIZ_FIRSTPAGE',0x00002710)
    win_const_mgr.add_const('PSINJECT_COMMENTS',0x0000000B)
    win_const_mgr.add_const('SN_TEST_SIGN',0x00000002)
    win_const_mgr.add_const('TCS_OWNERDRAWFIXED',0x00002000)
    win_const_mgr.add_const('SETUP_SERVER_UPGRADED_FLAG',0x00000400)
    win_const_mgr.add_const('SPINST_UNREGSVR',0x00000080)
    win_const_mgr.add_const('BG_E_NETWORK_DISCONNECTED',0x80200010)
    win_const_mgr.add_const('GETPENWIDTH',0x00000010)
    win_const_mgr.add_const('ERROR_SXS_XML_E_RESERVEDNAMESPACE',0x000036F2)
    win_const_mgr.add_const('IP4_ADDRESS_STRING_LENGTH',0x00000010)
    win_const_mgr.add_const('JOY_RETURNBUTTONS',0x00000080)
    win_const_mgr.add_const('JOY_CAL_READUONLY',0x04000000)
    win_const_mgr.add_const('JOB_OBJECT_SET_ATTRIBUTES',0x00000002)
    win_const_mgr.add_const('PSR_MBZ2_V',0x00000000)
    win_const_mgr.add_const('FROM_LEFT_2ND_BUTTON_PRESSED',0x00000004)
    win_const_mgr.add_const('MCI_ANIM_WHERE_DESTINATION',0x00040000)
    win_const_mgr.add_const('ERROR_SYMLINK_CLASS_DISABLED',0x000005B7)
    win_const_mgr.add_const('TMJOIN',0x00200000)
    win_const_mgr.add_const('WM_KEYDOWN',0x00000100)
    win_const_mgr.add_const('WINEVENT_KEYWORD_SQM',0x8000000000000)
    win_const_mgr.add_const('SYMFLAG_CONSTANT',0x00000100)
    win_const_mgr.add_const('WINEVENT_OPCODE_RESERVED_253',0x00000000)
    win_const_mgr.add_const('STG_LAYOUT_INTERLEAVED',0x00000001)
    win_const_mgr.add_const('URLPOLICY_JAVA_HIGH',0x00010000)
    win_const_mgr.add_const('TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MAX',0x00000080)
    win_const_mgr.add_const('COPYFLG_IN_USE_TRY_RENAME',0x00004000)
    win_const_mgr.add_const('KSMETHOD_TYPE_SEND',0x00000001)
    win_const_mgr.add_const('OBJECT_INHERIT_ACE',0x00000001)
    win_const_mgr.add_const('SND_LOOP',0x00000008)
    win_const_mgr.add_const('WSANO_RECOVERY',0x00002AFB)
    win_const_mgr.add_const('SSF_FILTER',0x00010000)
    win_const_mgr.add_const('OPTION_NETBIOS_NODE_TYPE',0x0000002E)
    win_const_mgr.add_const('ERROR_DS_CANT_MOVE_APP_QUERY_GROUP',0x000021A1)
    win_const_mgr.add_const('SUBSCRIPTION_CAP_BACKGROUNDPROCESSING',0x00000008)
    win_const_mgr.add_const('DMCOLLATE_FALSE',0x00000000)
    win_const_mgr.add_const('LINETONEMODE_BEEP',0x00000008)
    win_const_mgr.add_const('DWL_DLGPROC',0x00000004)
    win_const_mgr.add_const('IDM_SHOWWBRTAGS',0x00000924)
    win_const_mgr.add_const('CERT_STORE_PROV_FIND_CTL_FUNC',0x00000014)
    win_const_mgr.add_const('MDPROPVAL_MSF_WTD',0x00000200)
    win_const_mgr.add_const('DEVPROP_TYPE_ERROR',0x00000017)
    win_const_mgr.add_const('IPX_TRAFFIC_FILTER_ON_DSTNET',0x00000010)
    win_const_mgr.add_const('MM_ADDSEPARATOR',0x00000001)
    win_const_mgr.add_const('WMDM_STORAGE_ATTR_REMOVABLE',0x00000002)
    win_const_mgr.add_const('DTS_APPCANPARSE',0x00000010)
    win_const_mgr.add_const('CERT_RDN_OCTET_STRING',0x00000002)
    win_const_mgr.add_const('HHWIN_BUTTON_SEARCH',0x00000001)
    win_const_mgr.add_const('MAX_CLASSNAME_LENGTH',0x00000400)
    win_const_mgr.add_const('PPCF_NODIRECTORIES',0x00000010)
    win_const_mgr.add_const('SV_TYPE_WFW',0x00002000)
    win_const_mgr.add_const('BTH_ERROR_REMOTE_POWERING_OFF',0x00000015)
    win_const_mgr.add_const('MCI_DGV_SETVIDEO_KEY_INDEX',0x00000400)
    win_const_mgr.add_const('IDM_RCINSERT',0x00000899)
    win_const_mgr.add_const('DISPID_ONDBLCLICK',0x0000000B)
    win_const_mgr.add_const('NAME_FLAGS_MASK',0x00000087)
    win_const_mgr.add_const('ILD_IMAGE',0x00000020)
    win_const_mgr.add_const('EC_CLOCK_UNSET',0x00000051)
    win_const_mgr.add_const('WLX_SAS_ACTION_TASKLIST',0x00000007)
    win_const_mgr.add_const('WM_NCLBUTTONUP',0x000000A2)
    win_const_mgr.add_const('SLE_MINORERROR',0x00000002)
    win_const_mgr.add_const('ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT',0x00002160)
    win_const_mgr.add_const('OID_WAN_PROTOCOL_CAPS',0x0401010B)
    win_const_mgr.add_const('NTMS_SERIALNUMBER_LENGTH',0x00000020)
    win_const_mgr.add_const('SQL_AT_ADD_COLUMN_DEFAULT',0x00000040)
    win_const_mgr.add_const('SETALLJUSTVALUES',0x00000303)
    win_const_mgr.add_const('DS_REPL_NBR_FULL_REPLICA',0x00000400)
    win_const_mgr.add_const('PS_COMPONENT_SHAPER',0x00000004)
    win_const_mgr.add_const('ERROR_PATCH_RETAIN_RANGES_DIFFER',0xC00E3104)
    win_const_mgr.add_const('CERT_STORE_PROV_SET_CRL_PROPERTY_FUNC',0x00000008)
    win_const_mgr.add_const('MSG_MAXIOVLEN',0x00000010)
    win_const_mgr.add_const('WINWATCHNOTIFY_CHANGING',0x00000003)
    win_const_mgr.add_const('EN_MAXTEXT',0x00000501)
    win_const_mgr.add_const('ERROR_PIPE_NOT_CONNECTED',0x000000E9)
    win_const_mgr.add_const('D3D10_SRGB_TO_FLOAT_EXPONENT',0x00000002)
    win_const_mgr.add_const('SRCLIST_SUBDIRS',0x00000100)
    win_const_mgr.add_const('STATURLFLAG_ISTOPLEVEL',0x00000002)
    win_const_mgr.add_const('CACHEGROUP_ATTRIBUTE_STORAGE',0x00000020)
    win_const_mgr.add_const('OLEOBJ_E_LAST',0x8004018F)
    win_const_mgr.add_const('KSFILTER_FLAG_CRITICAL_PROCESSING',0x00000002)
    win_const_mgr.add_const('DEVPROPID_FIRST_USABLE',0x00000002)
    win_const_mgr.add_const('IDM_CHECKBOX',0x00000873)
    win_const_mgr.add_const('WINEVENT_CHANNEL_CLASSIC_TRACE',0x00000000)
    win_const_mgr.add_const('SHPWHF_ANYLOCATION',0x00000100)
    win_const_mgr.add_const('LC_WIDESTYLED',0x00000040)
    win_const_mgr.add_const('MK_RBUTTON',0x00000002)
    win_const_mgr.add_const('PD_PRINTSETUP',0x00000040)
    win_const_mgr.add_const('SECPKG_CALL_WOWCLIENT',0x00000040)
    win_const_mgr.add_const('MUI_PUBLIC_LANGUAGE_TYPE_FLAGS_MASK',0x00000067)
    win_const_mgr.add_const('PRODUCT_SMALLBUSINESS_SERVER',0x00000009)
    win_const_mgr.add_const('PATCH_TRANSFORM_PE_IRELOC_2',0x00000200)
    win_const_mgr.add_const('MTP_NEXTPHASE_READ_DATA',0x00000001)
    win_const_mgr.add_const('IMAGE_SYM_CLASS_UNION_TAG',0x0000000C)
    win_const_mgr.add_const('ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE',0x00002183)
    win_const_mgr.add_const('MDPROPVAL_MSF_DRILLDOWNMEMBBER',0x00000400)
    win_const_mgr.add_const('WINEVENT_KEYWORD_WDI_DIAG',0x4000000000000)
    win_const_mgr.add_const('BUTTON_IMAGELIST_ALIGN_RIGHT',0x00000001)
    win_const_mgr.add_const('CF_DIBV5',0x00000011)
    win_const_mgr.add_const('MMIO_DENYREAD',0x00000030)
    win_const_mgr.add_const('LUP_ADDRCONFIG',0x00100000)
    win_const_mgr.add_const('DN_MAXADDL',0x00000014)
    win_const_mgr.add_const('DNS_ERROR_PACKET_FMT_BASE',0x0000251C)
    win_const_mgr.add_const('SF_NOTIFY_ORDER_LOW',0x00020000)
    win_const_mgr.add_const('OPER_STATE_DOWN',0x00000001)
    win_const_mgr.add_const('OID_GEN_LINK_SPEED_EX',0x0001028B)
    win_const_mgr.add_const('SORTED_CTL_EXT_COUNT_OFFSET',0x00000001)
    win_const_mgr.add_const('ERROR_DEVICE_DOOR_OPEN',0x0000048E)
    win_const_mgr.add_const('SFGAO_HASSTORAGE',0x00400000)
    win_const_mgr.add_const('SP_PROT_PCT1_CLIENT',0x00000002)
    win_const_mgr.add_const('DNS_QUERY_NO_LOCAL_NAME',0x00000020)
    win_const_mgr.add_const('OID_GEN_DEVICE_PROFILE',0x00020212)
    win_const_mgr.add_const('SCH_CRED_CACHE_ONLY_URL_RETRIEVAL',0x00008000)
    win_const_mgr.add_const('BG_E_LOCAL_FILE_CHANGED',0x8020001D)
    win_const_mgr.add_const('OID_GEN_MULTICAST_FRAMES_RCV',0x0002020A)
    win_const_mgr.add_const('BTH_ERROR_MAX_NUMBER_OF_CONNECTIONS',0x00000009)
    win_const_mgr.add_const('SECBUFFER_MECHLIST_SIGNATURE',0x0000000C)
    win_const_mgr.add_const('PROTECTED_SACL_SECURITY_INFORMATION',0x40000000)
    win_const_mgr.add_const('ERROR_INTERRUPT_STILL_CONNECTED',0x000002FC)
    win_const_mgr.add_const('MSAA_MENU_SIG',0xAA0DF00D)
    win_const_mgr.add_const('WS_DLGFRAME',0x00400000)
    win_const_mgr.add_const('ERROR_EVENTLOG_FILE_CORRUPT',0x000005DC)
    win_const_mgr.add_const('WM_TIMER',0x00000113)
    win_const_mgr.add_const('URLACTION_SCRIPT_PASTE',0x00001407)
    win_const_mgr.add_const('POLICY_CREATE_SECRET',0x00000020)
    win_const_mgr.add_const('IMEVER_0310',0x0003000A)
    win_const_mgr.add_const('RPC_C_AUTHN_INFO_TYPE_HTTP',0x00000001)
    win_const_mgr.add_const('AVISF_DISABLED',0x00000001)
    win_const_mgr.add_const('TMT_HOTTRACKING',0x0000065B)
    win_const_mgr.add_const('DDCAPS_OVERLAY',0x00000800)
    win_const_mgr.add_const('MCI_VCR_FREEZE_OUTPUT',0x00020000)
    win_const_mgr.add_const('DEX_IDS_NO_SOURCE_NAMES',0x0000057D)
    win_const_mgr.add_const('SQL_OUTER_JOINS',0x00000026)
    win_const_mgr.add_const('CR_NO_SUCH_LOGICAL_DEV',0x00000014)
    win_const_mgr.add_const('IDC_PS_DISPLAYASICON',0x000001FA)
    win_const_mgr.add_const('GESTURE_UP_LEFT_LONG',0x00000000)
    win_const_mgr.add_const('FO_RENAME',0x00000004)
    win_const_mgr.add_const('WM_DROPFILES',0x00000233)
    win_const_mgr.add_const('ERROR_PNP_TRANSLATION_FAILED',0x000002A0)
    win_const_mgr.add_const('ICINSTALL_FUNCTION',0x00000001)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_CO_CALL_MANAGER_OPTIONAL_HANDLERS',0x000000A5)
    win_const_mgr.add_const('TAPE_CHECK_FOR_DRIVE_PROBLEM',0x00000002)
    win_const_mgr.add_const('POP3_MD_ID_END_RESERVED',0x00000000)
    win_const_mgr.add_const('IPPROTO_ND',0x0000004D)
    win_const_mgr.add_const('HTTP_QUERY_FLAG_COALESCE',0x10000000)
    win_const_mgr.add_const('AUTH_REQ_ALLOW_ENC_TKT_IN_SKEY',0x00000020)
    win_const_mgr.add_const('TXTLOG_RESERVED_FLAGS',0x0000FFF0)
    win_const_mgr.add_const('MQMSG_LAST_IN_XACT',0x00000001)
    win_const_mgr.add_const('SIGNERSCORE_INBOX',0x0D000003)
    win_const_mgr.add_const('SQL_DIAG_DROP_TABLE',0x00000020)
    win_const_mgr.add_const('USER_MARSHAL_FC_HYPER',0x0000000B)
    win_const_mgr.add_const('ERROR_NON_ACCOUNT_SID',0x000004E9)
    win_const_mgr.add_const('D3DPTADDRESSCAPS_MIRROR',0x00000002)
    win_const_mgr.add_const('DNS_MAX_LABEL_BUFFER_LENGTH',0x00000040)
    win_const_mgr.add_const('UM_SELTYPE_GLOBALGROUP',0x00000008)
    win_const_mgr.add_const('WM_PALETTEISCHANGING',0x00000310)
    win_const_mgr.add_const('EVENT_TRACE_USE_LOCAL_SEQUENCE',0x00008000)
    win_const_mgr.add_const('DLG_FLAGS_SEC_CERT_REV_FAILED',0x00800000)
    win_const_mgr.add_const('OID_802_11_TX_ANTENNA_SELECTED',0x0D01020D)
    win_const_mgr.add_const('MCI_FROM',0x00000004)
    win_const_mgr.add_const('DI_FLAGSEX_DIDINFOLIST',0x00000010)
    win_const_mgr.add_const('OID_IRDA_MAX_RECEIVE_WINDOW_SIZE',0x0A010204)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_UNKNOWN',0x00000000)
    win_const_mgr.add_const('META_EXTTEXTOUT',0x00000000)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_TABLE_PRIVILEGES',0x00000005)
    win_const_mgr.add_const('SPI_SETNONCLIENTMETRICS',0x0000002A)
    win_const_mgr.add_const('FILE_FLAG_OPEN_REPARSE_POINT',0x00200000)
    win_const_mgr.add_const('CRYPT_OID_INFO_CNG_SIGN_KEY',0x00000006)
    win_const_mgr.add_const('FRS_ERR_SYSVOL_IS_BUSY',0x00001F4F)
    win_const_mgr.add_const('WIA_DPC_FNUMBER',0x00000807)
    win_const_mgr.add_const('SDP_ATTRIB_HID_RECONNECT_INITIATE',0x00000205)
    win_const_mgr.add_const('AUTH_REQ_VALIDATE_CLIENT',0x00000080)
    win_const_mgr.add_const('PDERR_NODEVICES',0x00001007)
    win_const_mgr.add_const('ERROR_IO_INCOMPLETE',0x000003E4)
    win_const_mgr.add_const('LANG_ASSAMESE',0x00000004)
    win_const_mgr.add_const('CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_CERT_COUNT_DEFAULT',0x0000000A)
    win_const_mgr.add_const('LINECALLORIGIN_CONFERENCE',0x00000040)
    win_const_mgr.add_const('_WIN32_IE_IE70',0x00000700)
    win_const_mgr.add_const('SNMP_ERRORSTATUS_WRONGENCODING',0x00000009)
    win_const_mgr.add_const('WKSTA_USEENCRYPTION_PARMNUM',0x00000039)
    win_const_mgr.add_const('PSH_AEROWIZARD',0x00004000)
    win_const_mgr.add_const('RPC_C_AUTHN_LEVEL_PKT_INTEGRITY',0x00000005)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_ASSERTIONS',0x00000003)
    win_const_mgr.add_const('ERROR_BAD_DESCRIPTOR_FORMAT',0x00000551)
    win_const_mgr.add_const('PP_APPLI_CERT',0x00000012)
    win_const_mgr.add_const('QUERYFORM_CHANGESOPTFORMLIST',0x00000002)
    win_const_mgr.add_const('PCF_INTTIMEOUTS',0x00000080)
    win_const_mgr.add_const('WM_MAX_STREAMS',0x00000003)
    win_const_mgr.add_const('WM_NEXTMENU',0x00000213)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_CRL_FAILED',0x000035F9)
    win_const_mgr.add_const('ENM_MOUSEEVENTS',0x00020000)
    win_const_mgr.add_const('IMAGE_REL_IA64_IMM22',0x00000002)
    win_const_mgr.add_const('CHANGER_EXCHANGE_MEDIA',0x00000020)
    win_const_mgr.add_const('SQL_LCK_NO_CHANGE',0x00000001)
    win_const_mgr.add_const('STDPROP_UID',0x00000001)
    win_const_mgr.add_const('ERROR_DIRECTORY',0x0000010B)
    win_const_mgr.add_const('PROCESSOR_ARCHITECTURE_IA32_ON_WIN64',0x0000000A)
    win_const_mgr.add_const('SZ_ALG_MAX_SIZE',0x00000040)
    win_const_mgr.add_const('DOT11_FLAGS_80211B_SHORT_PREAMBLE',0x00000001)
    win_const_mgr.add_const('ERROR_VOLSNAP_PREPARE_HIBERNATE',0x0000028F)
    win_const_mgr.add_const('TMT_CAPTIONBARHEIGHT',0x000004B5)
    win_const_mgr.add_const('IDM_ENABLE_INTERACTION',0x000008FE)
    win_const_mgr.add_const('CRYPTUI_WIZ_DIGITAL_SIGN_PVK',0x00000003)
    win_const_mgr.add_const('ERROR_CTX_MODEM_RESPONSE_NO_CARRIER',0x00001B65)
    win_const_mgr.add_const('OE_SETTING',0x00000004)
    win_const_mgr.add_const('DDSCAPS2_CUBEMAP_POSITIVEX',0x00000400)
    win_const_mgr.add_const('DDSCAPS2_CUBEMAP_POSITIVEY',0x00001000)
    win_const_mgr.add_const('DDSCAPS2_CUBEMAP_POSITIVEZ',0x00004000)
    win_const_mgr.add_const('STYPE_DEVICE',0x00000002)
    win_const_mgr.add_const('SV_TYPE_NOVELL',0x00000080)
    win_const_mgr.add_const('SRCLIST_APPEND',0x00000200)
    win_const_mgr.add_const('SERKF_AVAILABLE',0x00000002)
    win_const_mgr.add_const('SCARD_CLASS_VENDOR_DEFINED',0x00000007)
    win_const_mgr.add_const('PHYSICALHEIGHT',0x0000006F)
    win_const_mgr.add_const('CM_HWPI_NOT_DOCKABLE',0x00000000)
    win_const_mgr.add_const('CM_PROB_FAILED_INSTALL',0x0000001C)
    win_const_mgr.add_const('CR_INVALID_RANGE_LIST',0x00000011)
    win_const_mgr.add_const('SYMSRV_VERSION',0x00000002)
    win_const_mgr.add_const('SM_CXVSCROLL',0x00000002)
    win_const_mgr.add_const('SE_SACL_AUTO_INHERIT_REQ',0x00000200)
    win_const_mgr.add_const('WIA_IPC_SEQUENCE',0x00001409)
    win_const_mgr.add_const('DSOP_SCOPE_TYPE_ENTERPRISE_DOMAIN',0x00000008)
    win_const_mgr.add_const('X3_P_SIGN_VAL_POS_X',0x00000000)
    win_const_mgr.add_const('HTVSCROLL',0x00000007)
    win_const_mgr.add_const('BLLI_L2_MODE_NORMAL',0x00000040)
    win_const_mgr.add_const('SCARD_E_CARD_UNSUPPORTED',0x8010001C)
    win_const_mgr.add_const('ERROR_DRIVERS_LEAKING_LOCKED_PAGES',0x000002D9)
    win_const_mgr.add_const('WINHTTP_QUERY_VIA',0x00000042)
    win_const_mgr.add_const('COOKIEACTION_LEASH',0x00000008)
    win_const_mgr.add_const('CR_NO_SUCH_VALUE',0x00000025)
    win_const_mgr.add_const('FWPM_NET_EVENT_IKEEXT_MM_FAILURE_FLAG_BENIGN',0x00000001)
    win_const_mgr.add_const('IF_LOCKICERTREQUEST',0x00000001)
    win_const_mgr.add_const('ERROR_MCA_OCCURED',0x0000028B)
    win_const_mgr.add_const('DNS_RCODE_NOERROR',0x00000000)
    win_const_mgr.add_const('SV_SESSOPENS_PARMNUM',0x000001F5)
    win_const_mgr.add_const('PRINTER_NOTIFY_FIELD_CJOBS',0x00000014)
    win_const_mgr.add_const('PID_LASTSAVE_DTM',0x0000000D)
    win_const_mgr.add_const('DEVICE_STATE_ACTIVE',0x00000001)
    win_const_mgr.add_const('DCR_MBZ1',0x00000002)
    win_const_mgr.add_const('STYPE_PRINTQ',0x00000001)
    win_const_mgr.add_const('MIB_IF_ADMIN_STATUS_UP',0x00000001)
    win_const_mgr.add_const('MM_MIDI_MAPPER',0x00000001)
    win_const_mgr.add_const('LOCALE_SYEARMONTH',0x00001006)
    win_const_mgr.add_const('SC_TASKLIST',0x0000F130)
    win_const_mgr.add_const('BIF_NOTRANSLATETARGETS',0x00000400)
    win_const_mgr.add_const('SQL_PARAM_IGNORE',0x00000001)
    win_const_mgr.add_const('RGB_GAMMA_MAX',0x0000FDE8)
    win_const_mgr.add_const('SCTE_EAS_TID',0x000000D8)
    win_const_mgr.add_const('SQL_DV_DROP_VIEW',0x00000001)
    win_const_mgr.add_const('ERROR_FILE_READ_ONLY',0x00001779)
    win_const_mgr.add_const('DEBUG_REQUEST_SOURCE_PATH_HAS_SOURCE_SERVER',0x00000000)
    win_const_mgr.add_const('WMS_EVENT_VERSION',0x00000001)
    win_const_mgr.add_const('AM_QUERY_DECODER_DVD_SUPPORT',0x00000003)
    win_const_mgr.add_const('SQL_CCOL_CREATE_COLLATION',0x00000001)
    win_const_mgr.add_const('SQL_AT_CONSTRAINT_DEFERRABLE',0x00040000)
    win_const_mgr.add_const('VOS_UNKNOWN',0x00000000)
    win_const_mgr.add_const('WIN_CERT_REVISION_2_0',0x00000200)
    win_const_mgr.add_const('D3DCOLORWRITEENABLE_ALPHA',0x00000001)
    win_const_mgr.add_const('ERROR_DATABASE_DOES_NOT_EXIST',0x00000429)
    win_const_mgr.add_const('MD_ERROR_SUB403_CERT_REQUIRED',0x00000007)
    win_const_mgr.add_const('SQL_CDO_CONSTRAINT_DEFERRABLE',0x00000080)
    win_const_mgr.add_const('TCSAT_PROTOCOL_UUID16',0x00000006)
    win_const_mgr.add_const('SSF_DOUBLECLICKINWEBVIEW',0x00000080)
    win_const_mgr.add_const('FILE_ATTRIBUTE_NOT_CONTENT_INDEXED',0x00002000)
    win_const_mgr.add_const('WIA_DPS_TRANSPARENCY_SELECT',0x00000C1E)
    win_const_mgr.add_const('SQLAOPAVG',0x00000004)
    win_const_mgr.add_const('DBIM_MINSIZE',0x00000001)
    win_const_mgr.add_const('WM_MOUSEHWHEEL',0x0000020E)
    win_const_mgr.add_const('ERROR_INVALID_SECURITY_DESCR',0x0000053A)
    win_const_mgr.add_const('NUM_DISCHARGE_POLICIES',0x00000004)
    win_const_mgr.add_const('DISPATCH_PROPERTYGET',0x00000002)
    win_const_mgr.add_const('PSH_RTLREADING',0x00000800)
    win_const_mgr.add_const('KS_CC_SUBSTREAM_SERVICE_CC3',0x00000100)
    win_const_mgr.add_const('AE_LIM_LOGONHOURS',0x00000001)
    win_const_mgr.add_const('ERROR_JOIN_TO_SUBST',0x0000008C)
    win_const_mgr.add_const('SQL_API_ODBC3_ALL_FUNCTIONS_SIZE',0x000000FA)
    win_const_mgr.add_const('CERT_LOGOTYPE_INDIRECT_INFO_CHOICE',0x00000002)
    win_const_mgr.add_const('SV_OPLOCKBREAKWAIT_PARMNUM',0x00000216)
    win_const_mgr.add_const('IME_MODE_HIRAGANA',0x00000004)
    win_const_mgr.add_const('STDOLE2_MAJORVERNUM',0x00000002)
    win_const_mgr.add_const('FACILITY_NTSSPI',0x00000009)
    win_const_mgr.add_const('TAPE_LOAD',0x00000000)
    win_const_mgr.add_const('DS_REPSYNC_INITIAL_IN_PROGRESS',0x00010000)
    win_const_mgr.add_const('INTERNET_OPTION_REQUEST_PRIORITY',0x0000003A)
    win_const_mgr.add_const('DS_DOMAIN_DIRECT_INBOUND',0x00000020)
    win_const_mgr.add_const('MCI_STATUS_LENGTH',0x00000001)
    win_const_mgr.add_const('WMDM_FILE_ATTR_FOLDER',0x00000008)
    win_const_mgr.add_const('WSA_QOS_EFILTERSTYLE',0x00002B0B)
    win_const_mgr.add_const('TPM_LEFTBUTTON',0x00000000)
    win_const_mgr.add_const('IMAGE_REL_I386_SEG12',0x00000009)
    win_const_mgr.add_const('CLCTL_USER_BASE',0x00000001)
    win_const_mgr.add_const('ERROR_CANNOT_IMPERSONATE',0x00000558)
    win_const_mgr.add_const('CONNDLG_NOT_PERSIST',0x00000020)
    win_const_mgr.add_const('SQL_TC_DML',0x00000001)
    win_const_mgr.add_const('IMAGE_REL_PPC_ADDR32',0x00000002)
    win_const_mgr.add_const('ERROR_CLUSTER_INVALID_STRING_FORMAT',0x0000171D)
    win_const_mgr.add_const('LINEPROXYREQUEST_GETAGENTSESSIONLIST',0x0000000D)
    win_const_mgr.add_const('MQMSG_AUTH_LEVEL_SIG10',0x00000002)
    win_const_mgr.add_const('GL_TRACE_EVENT',0x00002000)
    win_const_mgr.add_const('PORT_SRMP',0x000000C1)
    win_const_mgr.add_const('WIA_DPS_FILTER_SELECT',0x00000C0B)
    win_const_mgr.add_const('LINECALLINFOSTATE_CHARGINGINFO',0x01000000)
    win_const_mgr.add_const('ERROR_NOT_AUTHENTICATED',0x000004DC)
    win_const_mgr.add_const('DBPROP_MSDAORA8_DETERMINEKEYCOLUMNS',0x00000002)
    win_const_mgr.add_const('BS_MULTILINE',0x00002000)
    win_const_mgr.add_const('CAL_SABBREVDAYNAME7',0x00000014)
    win_const_mgr.add_const('SQL_CCS_CREATE_CHARACTER_SET',0x00000001)
    win_const_mgr.add_const('MKF_MOUSEKEYSON',0x00000001)
    win_const_mgr.add_const('FILE_SKIP_COMPLETION_PORT_ON_SUCCESS',0x00000001)
    win_const_mgr.add_const('DEBUG_CURRENT_DEFAULT',0x00000000)
    win_const_mgr.add_const('DBPROPVAL_TI_CHAOS',0x00000010)
    win_const_mgr.add_const('DI_FLAGSEX_USECLASSFORCOMPAT',0x00002000)
    win_const_mgr.add_const('MCI_DGV_LIST_VIDEO_ALG',0x00004005)
    win_const_mgr.add_const('FPS_AVAILABLE',0x20100000)
    win_const_mgr.add_const('SECPKG_CALL_ASYNC_UPDATE',0x00001000)
    win_const_mgr.add_const('WSB_PROP_HBKGCOLOR',0x00000080)
    win_const_mgr.add_const('ERROR_CLUSTER_NODE_PAUSED',0x000013CE)
    win_const_mgr.add_const('RTM_MATCH_NEXTHOP',0x00000008)
    win_const_mgr.add_const('DIFFERENCE',0x0000000B)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_REGENUMERATEVALUEKEY',0x00000012)
    win_const_mgr.add_const('INPUT_MOUSE',0x00000000)
    win_const_mgr.add_const('SCARD_CLASS_COMMUNICATIONS',0x00000002)
    win_const_mgr.add_const('CERT_TRUST_IS_NOT_TIME_NESTED',0x00000002)
    win_const_mgr.add_const('DISC_UPDATE_PROFILE',0x00000001)
    win_const_mgr.add_const('LOW_SURROGATE_END',0x00000000)
    win_const_mgr.add_const('PORT_KIS',0x000000BA)
    win_const_mgr.add_const('CM_GETIDLIST_FILTER_SERVICE',0x00000002)
    win_const_mgr.add_const('SMINIT_AUTOTOOLTIP',0x00000200)
    win_const_mgr.add_const('OF_GET',0x00000002)
    win_const_mgr.add_const('DSOP_SCOPE_TYPE_GLOBAL_CATALOG',0x00000010)
    win_const_mgr.add_const('MAX_GOPHER_LOCATOR_LENGTH',0x00000001)
    win_const_mgr.add_const('KSMETHOD_TYPE_READ',0x00000001)
    win_const_mgr.add_const('MCGIP_FOOTER',0x00000003)
    win_const_mgr.add_const('IME_SMODE_AUTOMATIC',0x00000004)
    win_const_mgr.add_const('SET_TAPE_DRIVE_INFORMATION',0x00000001)
    win_const_mgr.add_const('ANSI_FIXED_FONT',0x0000000B)
    win_const_mgr.add_const('D3DTA_COMPLEMENT',0x00000010)
    win_const_mgr.add_const('HEAP_GROWABLE',0x00000002)
    win_const_mgr.add_const('TF_SFT_HIGHTRANSPARENCY',0x00000040)
    win_const_mgr.add_const('SQL_OSC_EXTENDED',0x00000002)
    win_const_mgr.add_const('ICC_DATE_CLASSES',0x00000100)
    win_const_mgr.add_const('CRED_PERSIST_SESSION',0x00000001)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_PROCESS_ERR_HASH',0x0000360D)
    win_const_mgr.add_const('WINHTTP_AUTO_DETECT_TYPE_DNS_A',0x00000002)
    win_const_mgr.add_const('IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR',0x0000000E)
    win_const_mgr.add_const('IDS_CAP_AUDIO_DROP_COMPERROR',0x000001BA)
    win_const_mgr.add_const('DCM_FLAGS_LOCALTHREADTSF',0x00000004)
    win_const_mgr.add_const('SHTDN_REASON_FLAG_USER_DEFINED',0x40000000)
    win_const_mgr.add_const('RC_DEVBITS',0x00008000)
    win_const_mgr.add_const('CERT_VALIDITY_CERTIFICATE_REVOKED',0x00000008)
    win_const_mgr.add_const('CRYPT_GET_INSTALLED_OID_FUNC_FLAG',0x00000001)
    win_const_mgr.add_const('DNS_ERROR_WINS_INIT_FAILED',0x0000258F)
    win_const_mgr.add_const('JOB_NOTIFY_FIELD_PRINTER_NAME',0x00000000)
    win_const_mgr.add_const('WIA_DIP_STI_GEN_CAPABILITIES',0x0000000D)
    win_const_mgr.add_const('LVS_EX_SNAPTOGRID',0x00080000)
    win_const_mgr.add_const('WMDM_STATUS_BUSY',0x00000002)
    win_const_mgr.add_const('ACTIVATION_CONTEXT_PATH_TYPE_URL',0x00000003)
    win_const_mgr.add_const('IPX_STATIC_ROUTE_TABLE',0x00000003)
    win_const_mgr.add_const('OID_FDDI_SMT_CF_STATE',0x03030216)
    win_const_mgr.add_const('ETDT_DISABLE',0x00000001)
    win_const_mgr.add_const('IDC_EL_LINKSOURCE',0x000000D8)
    win_const_mgr.add_const('PAN_MIDLINE_LOW_POINTED',0x0000000C)
    win_const_mgr.add_const('OID_PNP_WAKE_UP_ERROR',0xFD020201)
    win_const_mgr.add_const('CMSG_SIGNER_CERT_INFO_PARAM',0x00000007)
    win_const_mgr.add_const('ADS_PRINTER_WARMING_UP',0x00010000)
    win_const_mgr.add_const('FWP_CONDITION_FLAG_IS_IMPLICIT_BIND',0x00000200)
    win_const_mgr.add_const('SSA_RTL',0x00000100)
    win_const_mgr.add_const('SNMP_PDUAPI_UNRECOGNIZED_PDU',0x00000014)
    win_const_mgr.add_const('PW_CLIENTONLY',0x00000001)
    win_const_mgr.add_const('SM_REMOTECONTROL',0x00002001)
    win_const_mgr.add_const('MCI_DGV_SETVIDEO_KEY_COLOR',0x00000400)
    win_const_mgr.add_const('HSE_URL_FLAGS_DONT_CACHE',0x00000010)
    win_const_mgr.add_const('SERVICE_NOTIFY_RUNNING',0x00000008)
    win_const_mgr.add_const('VARCMP_LT',0x00000000)
    win_const_mgr.add_const('MAPI_THISSESSION',0x00000020)
    win_const_mgr.add_const('SSPROP_STREAM_COMMANDTYPE',0x00000012)
    win_const_mgr.add_const('MD_LOGFILE_PERIOD_DAILY',0x00000001)
    win_const_mgr.add_const('PHOTO_PROGRAMMODE_PORTRAIT',0x00000007)
    win_const_mgr.add_const('DEBUG_BREAK_EXECUTE',0x00000004)
    win_const_mgr.add_const('WINHTTP_OPTION_PROXY',0x00000026)
    win_const_mgr.add_const('IDB_HIST_HOT',0x0000000D)
    win_const_mgr.add_const('IF_TYPE_GIGABITETHERNET',0x00000075)
    win_const_mgr.add_const('OPTION_DEFAULT_TTL',0x00000017)
    win_const_mgr.add_const('EVENT_OBJECT_HIDE',0x00008003)
    win_const_mgr.add_const('RCRED_STATUS_NOCRED',0x00000000)
    win_const_mgr.add_const('HCF_DEFAULTDESKTOP',0x00000200)
    win_const_mgr.add_const('ET_DITHERMODE',0x00000004)
    win_const_mgr.add_const('AA_A_ACL',0x00008000)
    win_const_mgr.add_const('MCI_UPDATE',0x00000854)

    win_const_mgr.add_const('ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST',0x00002157)
    win_const_mgr.add_const('IDM_IE50_PASTE',0x00000961)
    win_const_mgr.add_const('DB_NULL_HCHAPTER',0x00000000)
    win_const_mgr.add_const('DEBUG_SYMENT_IS_LOCAL',0x00000008)
    win_const_mgr.add_const('MDPROPVAL_MSF_QTD',0x00000080)
    win_const_mgr.add_const('TRACE_PROVIDER_FLAG_LEGACY',0x00000001)
    win_const_mgr.add_const('PHOTO_EXPOSUREPROGRAM_APERTURE',0x00000003)
    win_const_mgr.add_const('SQL_API_SQLCANCEL',0x00000005)
    win_const_mgr.add_const('PORT_RTIP',0x00000303)
    win_const_mgr.add_const('DISPID_FAVSELECTIONCHANGE',0x00000001)
    win_const_mgr.add_const('ASC_REQ_SEQUENCE_DETECT',0x00000008)
    win_const_mgr.add_const('NETERR_RING_STATUS_RECOVERY',0x00000040)
    win_const_mgr.add_const('VIF_MISMATCH',0x00000002)
    win_const_mgr.add_const('D3DSP_DCL_USAGEINDEX_SHIFT',0x00000010)
    win_const_mgr.add_const('EM_REPLACESEL',0x000000C2)
    win_const_mgr.add_const('NAT_BITS_PER_RNAT_REG',0x0000003F)
    win_const_mgr.add_const('SHDID_FS_OTHER',0x00000004)
    win_const_mgr.add_const('MD_NOTIFY_ORDER_MEDIUM',0x00040000)
    win_const_mgr.add_const('IMN_SETCANDIDATEPOS',0x00000009)
    win_const_mgr.add_const('PRJOB_DEVSTATUS',0x00000001)
    win_const_mgr.add_const('NDIS_ETH_TYPE_802_1Q',0x00008100)
    win_const_mgr.add_const('SPI_SETMOUSESPEED',0x00000071)
    win_const_mgr.add_const('OFFSET_VECTOR_EXT_INTERRUPT',0x00000002)
    win_const_mgr.add_const('MB_TYPEMASK',0x0000000F)
    win_const_mgr.add_const('NDIS_ETH_TYPE_802_1X',0x00000888)
    win_const_mgr.add_const('STGFMT_FILE',0x00000003)
    win_const_mgr.add_const('RAS_EAP_FLAG_MACHINE_AUTH',0x00000020)
    win_const_mgr.add_const('WIA_TRANSFER_CHILDREN_SINGLE_SCAN',0x00000001)
    win_const_mgr.add_const('POLICY_SERVER_ADMIN',0x00000400)
    win_const_mgr.add_const('D3DFVF_RESERVED0',0x00000001)
    win_const_mgr.add_const('ERROR_DS_NAME_ERROR_NOT_FOUND',0x00002116)
    win_const_mgr.add_const('D3DFVF_RESERVED2',0x00006000)
    win_const_mgr.add_const('WIA_IPA_ITEM_NAME',0x00001002)
    win_const_mgr.add_const('IF_NOLOCALICERTADMIN',0x00000020)
    win_const_mgr.add_const('DDCAPS2_NONLOCALVIDMEMCAPS',0x00000400)
    win_const_mgr.add_const('WMDM_FILE_ATTR_SYSTEM',0x00800000)
    win_const_mgr.add_const('DBPROPVAL_PT_PGUID_PROPID',0x00000040)
    win_const_mgr.add_const('QS_POSTMESSAGE',0x00000008)
    win_const_mgr.add_const('MB_SYSTEMMODAL',0x00001000)
    win_const_mgr.add_const('MM_MCISIGNAL',0x000003CB)
    win_const_mgr.add_const('WM_INITMENU',0x00000116)
    win_const_mgr.add_const('EDITF_DISABLEOLDOSCNUPN',0x00400000)
    win_const_mgr.add_const('OID_FDDI_MAC_TVX_VALUE',0x03030233)
    win_const_mgr.add_const('WINHTTP_QUERY_STATUS_CODE',0x00000013)
    win_const_mgr.add_const('DC_BUTTONS',0x00001000)
    win_const_mgr.add_const('SE_SACL_AUTO_INHERITED',0x00000800)
    win_const_mgr.add_const('SQL_SCCO_LOCK',0x00000002)
    win_const_mgr.add_const('SEE_MASK_NO_CONSOLE',0x00008000)
    win_const_mgr.add_const('SUBLANG_URDU_PAKISTAN',0x00000001)
    win_const_mgr.add_const('WINEVENT_OPCODE_RESERVED_254',0x00000000)
    win_const_mgr.add_const('PERF_DISPLAY_NO_SUFFIX',0x00000000)
    win_const_mgr.add_const('WIA_IPC_AUDIO_DATA_FORMAT',0x00001406)
    win_const_mgr.add_const('TMT_TEXTBORDERCOLOR',0x00000EE9)
    win_const_mgr.add_const('LOCK_ELEMENT',0x00000000)
    win_const_mgr.add_const('DDSD_FVF',0x00200000)
    win_const_mgr.add_const('WM_GETTITLEBARINFOEX',0x0000033F)
    win_const_mgr.add_const('PDH_MAX_SCALE',0x00000007)
    win_const_mgr.add_const('IOF_SELECTCREATENEW',0x00000002)
    win_const_mgr.add_const('SHGFI_ICON',0x00000100)
    win_const_mgr.add_const('SKF_LSHIFTLOCKED',0x00010000)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_SENDCALLS',0x00000025)
    win_const_mgr.add_const('LINEDEVCAPFLAGS_DIALQUIET',0x00000080)
    win_const_mgr.add_const('D3DFMT_A1_SURFACE_MAXHEIGHT',0x00000800)
    win_const_mgr.add_const('CRED_MAX_TARGETNAME_NAMESPACE_LENGTH',0x00000100)
    win_const_mgr.add_const('ERROR_NOT_SUPPORTED',0x00000032)
    win_const_mgr.add_const('MCI_SYSINFO_QUANTITY',0x00000100)
    win_const_mgr.add_const('IT_PORTABLE',0x00000002)
    win_const_mgr.add_const('ERROR_TOO_MANY_SEM_REQUESTS',0x00000067)
    win_const_mgr.add_const('BTH_ERROR_UNSUPPORTED_LMP_PARM_VALUE',0x00000020)
    win_const_mgr.add_const('CMS_USEAPPLYCALLBACK',0x00000100)
    win_const_mgr.add_const('ERROR_NO_EVENT_PAIR',0x00000244)
    win_const_mgr.add_const('ERROR_INVALID_SIGNAL_NUMBER',0x000000D1)
    win_const_mgr.add_const('ERROR_IPSEC_MM_FILTER_EXISTS',0x000032CE)
    win_const_mgr.add_const('STRING_PROVIDER_NAME_OFFSET',0x00000002)
    win_const_mgr.add_const('SQL_AA_TRUE',0x00000001)
    win_const_mgr.add_const('LINEDEVCAPFLAGS_MSP',0x00000200)
    win_const_mgr.add_const('FAXDEVRECEIVE_SIZE',0x00001000)
    win_const_mgr.add_const('FKF_HOTKEYACTIVE',0x00000004)
    win_const_mgr.add_const('IIS_MD_FTP_BASE',0x00001388)
    win_const_mgr.add_const('CERT_RDN_PRINTABLE_STRING',0x00000004)
    win_const_mgr.add_const('STANDARD_RIGHTS_ALL',0x001F0000)
    win_const_mgr.add_const('SPDRP_EXCLUSIVE',0x0000001A)
    win_const_mgr.add_const('EC_GRAPH_CHANGED',0x00000050)
    win_const_mgr.add_const('ERROR_EXCL_SEM_ALREADY_OWNED',0x00000065)
    win_const_mgr.add_const('MXDCOP_GET_FILENAME',0x0000000E)
    win_const_mgr.add_const('PORT_CL1',0x000000AC)
    win_const_mgr.add_const('IMAGE_COLORSPACE_SRGB',0x00000001)
    win_const_mgr.add_const('PHONEBUTTONSTATE_UNKNOWN',0x00000004)
    win_const_mgr.add_const('AM_CONTENTPROPERTY_COPYRIGHT',0x00000004)
    win_const_mgr.add_const('SQL_IS_ON',0x00000001)
    win_const_mgr.add_const('SSPROP_COLUMNLEVELCOLLATION',0x00000004)
    win_const_mgr.add_const('CWP_ALL',0x00000000)
    win_const_mgr.add_const('MD_ACCESS_READ',0x00000001)
    win_const_mgr.add_const('PIR_STATUS_TABLE_ERROR',0x00000004)
    win_const_mgr.add_const('DISPID_AUTOSCAN',0x0000000B)
    win_const_mgr.add_const('IP_ADD_SOURCE_MEMBERSHIP',0x0000000F)
    win_const_mgr.add_const('FR_MATCHCASE',0x00000004)
    win_const_mgr.add_const('SSPROP_INIT_NETWORKADDRESS',0x00000005)
    win_const_mgr.add_const('MCI_WAVE_OFFSET',0x00000480)
    win_const_mgr.add_const('WIA_DPS_HORIZONTAL_SHEET_FEED_SIZE',0x00000C04)
    win_const_mgr.add_const('CRYPT_FLAG_TLS1',0x00000008)
    win_const_mgr.add_const('DMPAPER_LEDGER',0x00000004)
    win_const_mgr.add_const('D3DLINECAPS_BLEND',0x00000004)
    win_const_mgr.add_const('SQL_TXN_READ_UNCOMMITTED',0x00000001)
    win_const_mgr.add_const('IDS_CAP_VIDEO_ADD_ERROR',0x000001AB)
    win_const_mgr.add_const('AUTHZ_NO_SUCCESS_AUDIT',0x00000001)
    win_const_mgr.add_const('OID_WAN_QUALITY_OF_SERVICE',0x04010103)
    win_const_mgr.add_const('OID_GEN_BYTES_XMIT',0x0002021A)
    win_const_mgr.add_const('WIN_CERT_TYPE_PKCS_SIGNED_DATA',0x00000002)
    win_const_mgr.add_const('LB_GETTEXT',0x00000189)
    win_const_mgr.add_const('SCARD_LEAVE_CARD',0x00000000)
    win_const_mgr.add_const('RESOURCEDISPLAYTYPE_DIRECTORY',0x00000009)
    win_const_mgr.add_const('SV_MAXPAGEDPOOLCHUNKSIZE_PARMNUM',0x00000248)
    win_const_mgr.add_const('SM_MIDEASTENABLED',0x0000004A)
    win_const_mgr.add_const('DOT11_MAX_NUM_OF_FRAGMENTS',0x00000010)
    win_const_mgr.add_const('SCF_USEUIRULES',0x00000008)
    win_const_mgr.add_const('CC_SOLIDCOLOR',0x00000080)
    win_const_mgr.add_const('CAL_GREGORIAN_US',0x00000002)
    win_const_mgr.add_const('VOS_DOS_WINDOWS32',0x00010004)
    win_const_mgr.add_const('SPI_SETACTIVEWNDTRKTIMEOUT',0x00002003)
    win_const_mgr.add_const('LUP_RETURN_PREFERRED_NAMES',0x00010000)
    win_const_mgr.add_const('COLOR_SCROLLBAR',0x00000000)
    win_const_mgr.add_const('INTERNET_FLAG_FWD_BACK',0x00000020)
    win_const_mgr.add_const('SQL_MAX_ROW_SIZE_INCLUDES_LONG',0x00000067)
    win_const_mgr.add_const('TF_CONVERSIONMODE_NATIVE',0x00000001)
    win_const_mgr.add_const('WKSTA_USECLOSEBEHIND_PARMNUM',0x00000032)
    win_const_mgr.add_const('TLS1_ALERT_HANDSHAKE_FAILURE',0x00000028)
    win_const_mgr.add_const('STATUS_SEVERITY_SUCCESS',0x00000000)
    win_const_mgr.add_const('ERROR_OBJECT_NO_LONGER_EXISTS',0x00001A97)
    win_const_mgr.add_const('GMDI_USEDISABLED',0x00000001)
    win_const_mgr.add_const('URLACTION_ACTIVEX_OVERRIDE_DATA_SAFETY',0x00001202)
    win_const_mgr.add_const('JOY_BUTTON4CHG',0x00000800)
    win_const_mgr.add_const('DB_NULL_HROW',0x00000000)
    win_const_mgr.add_const('TF_SFT_HIDDEN',0x00000008)
    win_const_mgr.add_const('LOCALE_SABBREVMONTHNAME4',0x00000047)
    win_const_mgr.add_const('ERROR_HOST_NODE_NOT_AVAILABLE',0x0000138D)
    win_const_mgr.add_const('LOCALE_SABBREVMONTHNAME6',0x00000049)
    win_const_mgr.add_const('LOCALE_SABBREVMONTHNAME1',0x00000044)
    win_const_mgr.add_const('ODBC_ERROR_INVALID_BUFF_LEN',0x00000002)
    win_const_mgr.add_const('LOCALE_SABBREVMONTHNAME2',0x00000045)
    win_const_mgr.add_const('TASK_WEDNESDAY',0x00000008)
    win_const_mgr.add_const('DEBUG_OUTCTL_NOT_LOGGED',0x00000008)
    win_const_mgr.add_const('EVENT_MAX',0x7FFFFFFF)
    win_const_mgr.add_const('LOCALE_SABBREVMONTHNAME9',0x0000004C)
    win_const_mgr.add_const('ERROR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY',0x00000312)
    win_const_mgr.add_const('MSIDBOPEN_PATCHFILE',0x00000020)
    win_const_mgr.add_const('DISPID_IDISCRECORDER2_VOLUMENAME',0x00000204)
    win_const_mgr.add_const('ARW_RIGHT',0x00000000)
    win_const_mgr.add_const('MUI_USE_INSTALLED_LANGUAGES',0x00000020)
    win_const_mgr.add_const('MCI_SEQ_SET_OFFSET',0x01000000)
    win_const_mgr.add_const('PSH_HEADER',0x00080000)
    win_const_mgr.add_const('IC_E_CAPS_INITIALIZATION_FAILURE',0x83010002)
    win_const_mgr.add_const('ISC_RET_FORWARD_CREDENTIALS',0x00400000)
    win_const_mgr.add_const('IP_RECVIF',0x00000018)
    win_const_mgr.add_const('LANG_TELUGU',0x00000004)
    win_const_mgr.add_const('DSSI_NO_ACCESS_CHECK',0x00000002)
    win_const_mgr.add_const('NETSETUP_MACHINE_PWD_PASSED',0x00000080)
    win_const_mgr.add_const('WM_XBUTTONDOWN',0x0000020B)
    win_const_mgr.add_const('CAL_GREGORIAN_XLIT_ENGLISH',0x0000000B)
    win_const_mgr.add_const('IDM_INSERTSPAN',0x00000935)
    win_const_mgr.add_const('KSAUDIO_QUALITY_WORST',0x00000000)
    win_const_mgr.add_const('MWT_LEFTMULTIPLY',0x00000002)
    win_const_mgr.add_const('MIDI_CACHE_ALL',0x00000001)
    win_const_mgr.add_const('CSC_CACHE_AUTO_REINT',0x00000010)
    win_const_mgr.add_const('ETW_OBJECT_TYPE_VALUE',0x00000001)
    win_const_mgr.add_const('DI_FLAGSEX_FILTERCLASSES',0x00000040)
    win_const_mgr.add_const('DDENUM_ATTACHEDSECONDARYDEVICES',0x00000001)
    win_const_mgr.add_const('ACM_FORMATENUMF_INPUT',0x00800000)
    win_const_mgr.add_const('MCI_FORMAT_FRAMES',0x00000003)
    win_const_mgr.add_const('SECURITY_PACKAGE_DIGEST_RID',0x00000015)
    win_const_mgr.add_const('WTS_EVENT_DELETE',0x00000002)
    win_const_mgr.add_const('INTERNET_OPTION_DISABLE_AUTODIAL',0x00000046)
    win_const_mgr.add_const('KSSTREAM_HEADER_OPTIONSF_DATADISCONTINUITY',0x00000004)
    win_const_mgr.add_const('LR_COPYFROMRESOURCE',0x00004000)
    win_const_mgr.add_const('SHORT_MAX',0x00007FFF)
    win_const_mgr.add_const('FILE_ANY_ACCESS',0x00000000)
    win_const_mgr.add_const('LANG_ARMENIAN',0x00000002)
    win_const_mgr.add_const('TLS1_ALERT_WARNING',0x00000001)
    win_const_mgr.add_const('DISPID_BLUR',0x00000006)
    win_const_mgr.add_const('CMM_IDENT',0x00000001)
    win_const_mgr.add_const('CDEF_DEVMON_CMGR_DEVICE',0x00000010)
    win_const_mgr.add_const('LOGTOKEN_TYPE_MASK',0x00000003)
    win_const_mgr.add_const('SQL_CV_CHECK_OPTION',0x00000002)
    win_const_mgr.add_const('SUBLANG_MACEDONIAN_MACEDONIA',0x00000001)
    win_const_mgr.add_const('HH_SET_QUERYSERVICE',0x0000001E)
    win_const_mgr.add_const('WM_DWMCOMPOSITIONCHANGED',0x0000031E)
    win_const_mgr.add_const('BN_SETFOCUS',0x00000006)
    win_const_mgr.add_const('TAPE_DRIVE_LOAD_UNLD_IMMED',0x80000020)
    win_const_mgr.add_const('CF_ANSIONLY',0x00000400)
    win_const_mgr.add_const('JOB_OBJECT_BASIC_LIMIT_VALID_FLAGS',0x00000000)
    win_const_mgr.add_const('MB_ICONASTERISK',0x00000040)
    win_const_mgr.add_const('PFNS_PLAIN',0x00000300)
    win_const_mgr.add_const('DDBLT_ALPHASRCSURFACEOVERRIDE',0x00000100)
    win_const_mgr.add_const('MAX_GOPHER_DISPLAY_TEXT',0x00000080)
    win_const_mgr.add_const('VIF_DIFFTYPE',0x00000020)
    win_const_mgr.add_const('BCM_FIRST',0x00001600)
    win_const_mgr.add_const('LCPRI_FORCECONFIG',0x00000000)
    win_const_mgr.add_const('PORT_SGMPTRAPS',0x000000A0)
    win_const_mgr.add_const('SV_ALERTSCHED_PARMNUM',0x00000025)
    win_const_mgr.add_const('EC_SKIP_FRAMES',0x00000025)
    win_const_mgr.add_const('STIF_DEFAULT',0x00000000)
    win_const_mgr.add_const('D3DFVF_TEX2',0x00000200)
    win_const_mgr.add_const('SSRVOPT_DWORD',0x00000002)
    win_const_mgr.add_const('D3DFVF_TEX0',0x00000000)
    win_const_mgr.add_const('SASL_OPTION_RECV_SIZE',0x00000002)
    win_const_mgr.add_const('D3DFVF_TEX6',0x00000600)
    win_const_mgr.add_const('D3DFVF_TEX7',0x00000700)
    win_const_mgr.add_const('D3DFVF_TEX4',0x00000400)
    win_const_mgr.add_const('CM_DETECT_RUN',0x80000000)
    win_const_mgr.add_const('VCSTATUS_NEW_MESSAGE',0x00400000)
    win_const_mgr.add_const('TMT_COMPANY',0x0000025B)
    win_const_mgr.add_const('D3DFVF_TEX8',0x00000800)
    win_const_mgr.add_const('ERROR_INVALID_IMAGE_HASH',0x00000241)
    win_const_mgr.add_const('DRM_DEVICE_REGISTER_TYPE_STREAMING',0x00000001)
    win_const_mgr.add_const('DS_REPADD_TWO_WAY',0x00000400)
    win_const_mgr.add_const('FSB_ENCARTA_MODE',0x00000001)
    win_const_mgr.add_const('DDCAPS2_CANCALIBRATEGAMMA',0x00100000)
    win_const_mgr.add_const('DISPID_DOM_COLLECTION_BASE',0x000F4240)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_CLEARTIMEOUT',0x00000450)
    win_const_mgr.add_const('POLICY_ERRV_GLOBAL_GRP_SUM_FLOW_RATE',0x00000022)
    win_const_mgr.add_const('DCTT_DOWNLOAD_OUTLINE',0x00000008)
    win_const_mgr.add_const('MDM_MASK_AUTO_ML',0x00000003)
    win_const_mgr.add_const('SETXON',0x00000002)
    win_const_mgr.add_const('NTDSCONN_OPT_IS_GENERATED',0x00000001)
    win_const_mgr.add_const('D3DFVF_TEX5',0x00000500)
    win_const_mgr.add_const('IMAGE_REL_IA64_PCREL60F',0x00000017)
    win_const_mgr.add_const('DB_DISP_ERROR',0x0000001E)
    win_const_mgr.add_const('SQL_DESC_ROWS_PROCESSED_PTR',0x00000022)
    win_const_mgr.add_const('OPTION_HOST_NAME',0x0000000C)
    win_const_mgr.add_const('NRC_NAMERR',0x00000017)
    win_const_mgr.add_const('MDPROPVAL_RR_READONLY',0x00000002)
    win_const_mgr.add_const('PS_DASHDOT',0x00000003)
    win_const_mgr.add_const('LINEERR_INVALPRIVSELECT',0x80000036)
    win_const_mgr.add_const('IMAGE_REL_IA64_PCREL60I',0x00000018)
    win_const_mgr.add_const('DDBLTFX_MIRRORLEFTRIGHT',0x00000002)
    win_const_mgr.add_const('CSCONFIGFLAG_DISABLED',0x00000001)
    win_const_mgr.add_const('META_SETWINDOWORG',0x0000020B)
    win_const_mgr.add_const('SUBLANG_SPANISH_HONDURAS',0x00000012)
    win_const_mgr.add_const('D3DPS20CAPS_NODEPENDENTREADLIMIT',0x00000001)
    win_const_mgr.add_const('MCI_VD_GETDEVCAPS_FAST_RATE',0x00004003)
    win_const_mgr.add_const('SMART_NOT_SUPPORTED',0x00000009)
    win_const_mgr.add_const('IMAGE_FILE_MACHINE_ARM',0x00000001)
    win_const_mgr.add_const('HTTP_STATUS_REQUEST_TIMEOUT',0x00000198)
    win_const_mgr.add_const('UNISCRIBE_OPENTYPE',0x00000100)
    win_const_mgr.add_const('NTMSMLI_MAXTYPE',0x00000040)
    win_const_mgr.add_const('DEBUG_VSEARCH_DEFAULT',0x00000000)
    win_const_mgr.add_const('PDH_CSTATUS_VALID_DATA',0x00000000)
    win_const_mgr.add_const('DEVPROP_TYPE_SECURITY_DESCRIPTOR_STRING',0x00000014)
    win_const_mgr.add_const('CM_GLOBAL_STATE_ON_BIG_STACK',0x00000002)
    win_const_mgr.add_const('DDPF_ZBUFFER',0x00000400)
    win_const_mgr.add_const('ACM_DRIVERADDF_LOCAL',0x00000000)
    win_const_mgr.add_const('MAX_ISCSI_DISCOVERY_DOMAIN_LEN',0x00000100)
    win_const_mgr.add_const('ERROR_I24_NOT_READY',0x00000002)
    win_const_mgr.add_const('DEBUG_PROC_DESC_NO_SERVICES',0x00000002)
    win_const_mgr.add_const('ENABLE_ECHO_INPUT',0x00000004)
    win_const_mgr.add_const('MM_MCINOTIFY',0x000003B9)
    win_const_mgr.add_const('MFT_RADIOCHECK',0x00000200)
    win_const_mgr.add_const('MQMSG_FIRST_IN_XACT',0x00000001)
    win_const_mgr.add_const('GOPHER_TYPE_DIRECTORY',0x00000002)
    win_const_mgr.add_const('DISCHARGE_POLICY_LOW',0x00000001)
    win_const_mgr.add_const('OID_802_11_TEST',0x0D010120)
    win_const_mgr.add_const('LINECALLPARTYID_OUTOFAREA',0x00000002)
    win_const_mgr.add_const('LANG_DANISH',0x00000006)
    win_const_mgr.add_const('MQMSG_SENDERID_TYPE_NONE',0x00000000)
    win_const_mgr.add_const('MS_ROUTER_VERSION',0x00000500)
    win_const_mgr.add_const('ACN_STOP',0x00000002)
    win_const_mgr.add_const('DDCAPS2_RESERVED1',0x08000000)
    win_const_mgr.add_const('NDIS_DEVICE_TYPE_ENDPOINT',0x00000001)
    win_const_mgr.add_const('ERROR_NO_SYSTEM_RESOURCES',0x000005AA)
    win_const_mgr.add_const('PERF_TEXT_ASCII',0x00010000)
    win_const_mgr.add_const('DTT_GRAYED',0x00000001)
    win_const_mgr.add_const('SQL_RE_OFF',0x00000000)
    win_const_mgr.add_const('CM_GETIDLIST_DONOTGENERATE',0x10000040)
    win_const_mgr.add_const('SO_DISCDATALEN',0x00007006)
    win_const_mgr.add_const('DC_MEDIAREADY',0x0000001D)
    win_const_mgr.add_const('SPINST_ALL',0x00000001)
    win_const_mgr.add_const('MQ_MAX_Q_NAME_LEN',0x0000007C)
    win_const_mgr.add_const('TBSTYLE_EX_DRAWDDARROWS',0x00000001)
    win_const_mgr.add_const('LOCALE_IPOSSEPBYSPACE',0x00000055)
    win_const_mgr.add_const('SQL_NULL_HDBC',0x00000000)
    win_const_mgr.add_const('CM_CREATE_DEVNODE_BITS',0x0000000F)
    win_const_mgr.add_const('DIRID_APPS',0x00000018)
    win_const_mgr.add_const('SSRVOPT_DOWNSTREAM_STORE',0x00002000)
    win_const_mgr.add_const('DXVA_BITSTREAM_CONCEALMENT_METHOD_BACKWARD',0x00000003)
    win_const_mgr.add_const('PRODUCT_SMALLBUSINESS_SERVER_PREMIUM',0x00000019)
    win_const_mgr.add_const('VER_ERR_CALL_SIG',0x04000000)
    win_const_mgr.add_const('CMPT_PROTOCOL_UUID16',0x0000001B)
    win_const_mgr.add_const('CERT_RDN_TYPE_MASK',0x000000FF)
    win_const_mgr.add_const('LINESPECIALINFO_REORDER',0x00000004)
    win_const_mgr.add_const('INTERNET_SCHEME_HTTP',0x00000001)
    win_const_mgr.add_const('SDP_ATTRIB_IMAGING_SUPPORTED_FEATURES',0x00000311)
    win_const_mgr.add_const('FILE_SUPPORTS_TRANSACTIONS',0x00200000)
    win_const_mgr.add_const('ERROR_ILLEGAL_ELEMENT_ADDRESS',0x0000048A)
    win_const_mgr.add_const('PORT_NTP',0x0000007B)
    win_const_mgr.add_const('ERROR_BAD_MCFG_TABLE',0x00000317)
    win_const_mgr.add_const('HF32_SHARED',0x00000002)
    win_const_mgr.add_const('RPC_S_NO_CALL_ACTIVE',0x000006BD)
    win_const_mgr.add_const('DDCAPS_BLTSTRETCH',0x00000200)
    win_const_mgr.add_const('DS_REPADD_ASYNCHRONOUS_REPLICA',0x00000020)
    win_const_mgr.add_const('MAPI_LONG_MSGID',0x00004000)
    win_const_mgr.add_const('WM_IME_STARTCOMPOSITION',0x0000010D)
    win_const_mgr.add_const('SM_CYMIN',0x0000001D)
    win_const_mgr.add_const('BAUD_14400',0x00001000)
    win_const_mgr.add_const('MCI_DGV_STATUS_BITSPERSAMPLE',0x00000402)
    win_const_mgr.add_const('OPF_DISABLECONVERT',0x00000008)
    win_const_mgr.add_const('D3DPCMPCAPS_LESS',0x00000002)
    win_const_mgr.add_const('D3DPRESENT_INTERVAL_TWO',0x00000002)
    win_const_mgr.add_const('WLX_OPTION_SMART_CARD_INFO',0x00010002)
    win_const_mgr.add_const('MAX_LANA',0x000000FE)
    win_const_mgr.add_const('PLATFORM_ID_VMS',0x000002BC)
    win_const_mgr.add_const('OID_GEN_RECEIVE_BLOCK_SIZE',0x0001010B)
    win_const_mgr.add_const('TCS_TABS',0x00000000)
    win_const_mgr.add_const('VK_PRINT',0x0000002A)
    win_const_mgr.add_const('IP_EXPORT_INCLUDED',0x00000001)
    win_const_mgr.add_const('RESOURCEDISPLAYTYPE_FILE',0x00000004)
    win_const_mgr.add_const('ASC_REQ_INTEGRITY',0x00020000)
    win_const_mgr.add_const('NFR_ANSI',0x00000001)
    win_const_mgr.add_const('NCRYPT_PERSIST_ONLY_FLAG',0x40000000)
    win_const_mgr.add_const('LB_SETITEMHEIGHT',0x000001A0)
    win_const_mgr.add_const('ERROR_SHUTDOWN_CLUSTER',0x00001390)
    win_const_mgr.add_const('IME_ESC_QUERY_SUPPORT',0x00000003)
    win_const_mgr.add_const('METHOD_IN_DIRECT',0x00000001)
    win_const_mgr.add_const('IDM_TRIED_ORDERLIST',0x0000002F)
    win_const_mgr.add_const('ES_PASSWORD',0x00000020)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_NEGOTIATION_PENDING',0x000035EB)
    win_const_mgr.add_const('DI_DEFAULTSIZE',0x00000008)
    win_const_mgr.add_const('CGD_DEFAULT',0x00000000)
    win_const_mgr.add_const('TF_LBI_TEXT',0x00000002)
    win_const_mgr.add_const('MAX_SIZE_SECURITY_ID',0x00000200)
    win_const_mgr.add_const('TH_TAPI',0x00000002)
    win_const_mgr.add_const('WSA_WAIT_TIMEOUT',0x00000102)
    win_const_mgr.add_const('AC_SRC_OVER',0x00000000)
    win_const_mgr.add_const('CTRY_TRINIDAD_Y_TOBAGO',0x00000001)
    win_const_mgr.add_const('MMIO_INSTALLPROC',0x00010000)
    win_const_mgr.add_const('ERROR_DEPENDENCY_TREE_TOO_COMPLEX',0x00001729)
    win_const_mgr.add_const('RPC_C_HTTP_AUTHN_SCHEME_NTLM',0x00000002)
    win_const_mgr.add_const('IDC_EL_AUTOMATIC',0x000000CA)
    win_const_mgr.add_const('IDM_HTMLEDITMODE',0x0000090C)
    win_const_mgr.add_const('ERROR_PRINT_JOB_RESTART_REQUIRED',0x00000BCC)
    win_const_mgr.add_const('APPCOMMAND_CORRECTION_LIST',0x0000002D)
    win_const_mgr.add_const('IF_TYPE_IS088023_CSMACD',0x00000007)
    win_const_mgr.add_const('LVCFMT_COL_HAS_IMAGES',0x00008000)
    win_const_mgr.add_const('PHONEFEATURE_GENERICPHONE',0x10000000)
    win_const_mgr.add_const('CERT_NAME_STR_COMMA_FLAG',0x04000000)
    win_const_mgr.add_const('SEC_FILE',0x00800000)
    win_const_mgr.add_const('ALG_SID_AGREED_KEY_ANY',0x00000003)
    win_const_mgr.add_const('MDTREEOP_SELF',0x00000008)
    win_const_mgr.add_const('LINE_CALLINFO',0x00000001)
    win_const_mgr.add_const('SDP_ATTRIB_AVAILABILITY',0x00000008)
    win_const_mgr.add_const('SBSP_NOAUTOSELECT',0x04000000)
    win_const_mgr.add_const('CMC_STATUS_FAILED',0x00000002)
    win_const_mgr.add_const('CRL_V2',0x00000001)
    win_const_mgr.add_const('RATING_ONE_STAR_MIN',0x00000001)
    win_const_mgr.add_const('SEARCH_ALL',0x00000000)
    win_const_mgr.add_const('SQL_FD_FETCH_RESUME',0x00000040)
    win_const_mgr.add_const('IDSI_FLAG_SECURE',0x00000002)
    win_const_mgr.add_const('PIDASI_SAMPLE_SIZE',0x00000006)
    win_const_mgr.add_const('SQL_ACCESS_MODE',0x00000065)
    win_const_mgr.add_const('DEBUG_STATUS_REVERSE_GO',0x0000000B)
    win_const_mgr.add_const('OID_WAN_SET_BRIDGE_INFO',0x0401020B)
    win_const_mgr.add_const('PSPROTOCOL_ASCII',0x00000000)
    win_const_mgr.add_const('DBPROPVAL_SQL_ODBC_MINIMUM',0x00000001)
    win_const_mgr.add_const('RPC_C_MQ_AUTHN_LEVEL_NONE',0x00000000)
    win_const_mgr.add_const('MDPROPVAL_MSF_DRILLDOWNMEMBERBOTTOM',0x00002000)
    win_const_mgr.add_const('OID_TAPI_SET_APP_SPECIFIC',0x0703011D)
    win_const_mgr.add_const('ERROR_RESOURCEMANAGER_NOT_FOUND',0x00001A3C)
    win_const_mgr.add_const('D3DSP_OPCODESPECIFICCONTROL_MASK',0x00000000)
    win_const_mgr.add_const('D3DFMT_A8R8G8B8',0x00000015)
    win_const_mgr.add_const('DSQPF_SHOWHIDDENOBJECTS',0x00000004)
    win_const_mgr.add_const('DMPAPER_B_PLUS',0x0000003A)
    win_const_mgr.add_const('SPEAKER_SIDE_LEFT',0x00000200)
    win_const_mgr.add_const('PIDISF_CACHEDSTICKY',0x00000002)
    win_const_mgr.add_const('STI_ONLINESTATE_BUSY',0x00000100)
    win_const_mgr.add_const('WMP_MDRT_FLAGS_UNREPORTED_DELETED_ITEMS',0x00000001)
    win_const_mgr.add_const('ED_VIDEO',0x02000000)
    win_const_mgr.add_const('ASC_RET_ALLOW_NON_USER_LOGONS',0x00200000)
    win_const_mgr.add_const('ERROR_IMPLEMENTATION_LIMIT',0x0000050C)
    win_const_mgr.add_const('ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET',0x00002110)
    win_const_mgr.add_const('CDIS_CHECKED',0x00000008)
    win_const_mgr.add_const('EMR_DELETECOLORSPACE',0x00000065)
    win_const_mgr.add_const('DCBA_FACEDOWNRIGHT',0x00000103)
    win_const_mgr.add_const('SV_TYPE_AFP',0x00000040)
    win_const_mgr.add_const('DDSCAPS2_HINTDYNAMIC',0x00000004)
    win_const_mgr.add_const('CTRY_CHILE',0x00000038)
    win_const_mgr.add_const('MF_HILITE',0x00000080)
    win_const_mgr.add_const('SSF_SHOWSYSFILES',0x00000020)
    win_const_mgr.add_const('WIA_PRIVATE_DEVPROP',0x00009802)
    win_const_mgr.add_const('DDBLT_KEYDESTOVERRIDE',0x00004000)
    win_const_mgr.add_const('ERROR_CLUSTER_INVALID_IPV6_NETWORK',0x00001726)
    win_const_mgr.add_const('ILLUMINANT_F2',0x00000008)
    win_const_mgr.add_const('SERVICE_CONFIG_FAILURE_ACTIONS_FLAG',0x00000004)
    win_const_mgr.add_const('SQL_DROP_SCHEMA',0x0000008C)
    win_const_mgr.add_const('FACILITY_DEBUGGER',0x00000001)
    win_const_mgr.add_const('CBA_DEBUG_INFO',0x10000000)
    win_const_mgr.add_const('INTERNET_STATUS_STATE_CHANGE',0x000000C8)
    win_const_mgr.add_const('IPPORT_IMAP',0x0000008F)
    win_const_mgr.add_const('SWP_NOMOVE',0x00000002)
    win_const_mgr.add_const('NTMSMLI_MAXAPPDESCR',0x00000100)
    win_const_mgr.add_const('ERROR_MUI_INVALID_FILE',0x00003AFD)
    win_const_mgr.add_const('JOYSTICKID1',0x00000000)
    win_const_mgr.add_const('JOYSTICKID2',0x00000001)
    win_const_mgr.add_const('HH_DISPLAY_SEARCH',0x00000003)
    win_const_mgr.add_const('ERROR_DS_IS_LEAF',0x00002033)
    win_const_mgr.add_const('FWPM_NET_EVENT_KEYWORD_INBOUND_MCAST',0x00000001)
    win_const_mgr.add_const('INTERNET_AUTOPROXY_INIT_ONLYQUERY',0x00000008)
    win_const_mgr.add_const('GUI_CARETBLINKING',0x00000001)
    win_const_mgr.add_const('RPC_IF_SEC_NO_CACHE',0x00000040)
    win_const_mgr.add_const('ETW_CHAR_TYPE_VALUE',0x0000000B)
    win_const_mgr.add_const('DISPID_DOM_COLLECTION_MAX',0x002DC6BF)
    win_const_mgr.add_const('TF_IPPMF_FORSYSTEMALL',0x40000000)
    win_const_mgr.add_const('WINHTTP_QUERY_COST',0x0000000F)
    win_const_mgr.add_const('CRYPT_MIN_DEPENDENCIES',0x00000001)
    win_const_mgr.add_const('BN_KILLFOCUS',0x00000007)
    win_const_mgr.add_const('TXTLOG_NEWDEV',0x01000000)
    win_const_mgr.add_const('MAXLONGLONG',0x00000007)
    win_const_mgr.add_const('NMP_PROCESS_MODERATOR',0x00000004)
    win_const_mgr.add_const('WS_CAPTION',0x00C00000)
    win_const_mgr.add_const('CM_PROB_DRIVER_SERVICE_KEY_INVALID',0x00000028)
    win_const_mgr.add_const('MDITILE_HORIZONTAL',0x00000001)
    win_const_mgr.add_const('PORT_NEWS',0x00000090)
    win_const_mgr.add_const('TRUST_AUTH_TYPE_NT4OWF',0x00000001)
    win_const_mgr.add_const('ACMDRIVERDETAILS_FEATURES_CHARS',0x00000200)
    win_const_mgr.add_const('ASPECT_FILTERING',0x00000001)
    win_const_mgr.add_const('SQL_QUOTED_IDENTIFIER_CASE',0x0000005D)
    win_const_mgr.add_const('INDEX_GUID_BASELINE',0x00000009)
    win_const_mgr.add_const('DNS_ERROR_DWORD_VALUE_TOO_LARGE',0x0000255F)
    win_const_mgr.add_const('ICC_USEREX_CLASSES',0x00000200)
    win_const_mgr.add_const('AF_FIREFOX',0x00000013)
    win_const_mgr.add_const('SQL_CVT_NUMERIC',0x00000002)
    win_const_mgr.add_const('VALID_LOGOFF',0x00000001)
    win_const_mgr.add_const('DICS_FLAG_CONFIGGENERAL',0x00000004)
    win_const_mgr.add_const('ERROR_INVALID_BLOCK',0x00000009)
    win_const_mgr.add_const('VK_ICO_HELP',0x000000E3)
    win_const_mgr.add_const('D3D10_FLOAT_TO_SRGB_SCALE_1',0x0000000C)
    win_const_mgr.add_const('FPS_DIALING',0x20000001)
    win_const_mgr.add_const('IPX_TRAFFIC_FILTER_LOG_MATCHES',0x80000000)
    win_const_mgr.add_const('TMT_SCROLLBARHEIGHT',0x000004B3)
    win_const_mgr.add_const('SVAUD_GOODSESSLOGON',0x00000006)
    win_const_mgr.add_const('ERROR_PATCH_CORRUPT',0xC00E4102)
    win_const_mgr.add_const('VIEW_NEWFOLDER',0x0000000B)
    win_const_mgr.add_const('IPX_STATIC_NETBIOS_NAME_INFO_TYPE',0x0000000A)
    win_const_mgr.add_const('KERB_REQUEST_REMOVE_CREDENTIAL',0x00000004)
    win_const_mgr.add_const('LINE_LINEDEVSTATE',0x00000008)
    win_const_mgr.add_const('SECPKG_ATTR_THUNK_ALL',0x00010000)
    win_const_mgr.add_const('BTH_MFG_PHILIPS_SEMICONDUCTOR',0x00000025)
    win_const_mgr.add_const('SOUND_SYSTEM_FAULT',0x0000000D)
    win_const_mgr.add_const('VCSTATUS_DELETE_IS_MOVE',0x00100000)
    win_const_mgr.add_const('AF_INET',0x00000002)
    win_const_mgr.add_const('AA_F_OPEN',0x00000100)
    win_const_mgr.add_const('TBS_COMMAND_LOCALITY_TWO',0x00000002)
    win_const_mgr.add_const('KAGPROP_ACCESSIBLEPROCEDURES',0x00000002)
    win_const_mgr.add_const('PD_STRETCHDIB_1_1_OK',0x00000004)
    win_const_mgr.add_const('SPI_SETDRAGHEIGHT',0x0000004D)
    win_const_mgr.add_const('SCARD_SHARE_EXCLUSIVE',0x00000001)
    win_const_mgr.add_const('RSVP_PATH_TEAR',0x00000005)
    win_const_mgr.add_const('HHWIN_PARAM_HISTORY_COUNT',0x00000001)
    win_const_mgr.add_const('IME_MODE_KATAKANA',0x00000002)
    win_const_mgr.add_const('IMAGE_FILE_DLL',0x00002000)
    win_const_mgr.add_const('SF_MAX_PASSWORD',0x00000100)
    win_const_mgr.add_const('COPY_FILE_OPEN_SOURCE_FOR_WRITE',0x00000004)
    win_const_mgr.add_const('BF_DIAGONAL',0x00000010)
    win_const_mgr.add_const('WB_MOVEWORDRIGHT',0x00000005)
    win_const_mgr.add_const('CONTEXT_MENU_IMGDYNSRC',0x00000007)
    win_const_mgr.add_const('JT_ROUTING',0x00000003)
    win_const_mgr.add_const('MD_LOGCUSTOM_DATATYPE_ULONG',0x00000003)
    win_const_mgr.add_const('SBSP_PARENT',0x00002000)
    win_const_mgr.add_const('ERROR',0x00000000)
    win_const_mgr.add_const('CM_SETUP_DOWNLOAD',0x00000001)
    win_const_mgr.add_const('NETLOGON_HAS_TIMESERV',0x00000020)
    win_const_mgr.add_const('LSP_REDIRECTOR',0x00000002)
    win_const_mgr.add_const('MCI_DGV_STOP_HOLD',0x00010000)
    win_const_mgr.add_const('FILE_ATTRIBUTE_OFFLINE',0x00001000)
    win_const_mgr.add_const('CRYPT_ENCODE_NO_SIGNATURE_BYTE_REVERSAL_FLAG',0x00000008)
    win_const_mgr.add_const('NM_LAST',0x00000000)
    win_const_mgr.add_const('ACTRL_SYSTEM_ACCESS',0x04000000)
    win_const_mgr.add_const('PDH_LOG_TYPE_BINARY',0x00000003)
    win_const_mgr.add_const('AUTHZ_MIGRATED_LEGACY_PUBLISHER',0x00000002)
    win_const_mgr.add_const('SQL_INTERVAL_MINUTE',0x00000064)
    win_const_mgr.add_const('LINEADDRCAPFLAGS_BLOCKIDOVERRIDE',0x00000010)
    win_const_mgr.add_const('CAL_ICALINTVALUE',0x00000001)
    win_const_mgr.add_const('MAX_COLUMNS',0x00000100)
    win_const_mgr.add_const('ERROR_PATH_NOT_FOUND',0x00000003)
    win_const_mgr.add_const('RPC_CONTEXT_HANDLE_FLAGS',0x30000000)
    win_const_mgr.add_const('SERVICE_GUARANTEED',0x80040000)
    win_const_mgr.add_const('ERROR_DS_CANT_REM_MISSING_ATT',0x00002084)
    win_const_mgr.add_const('PCMCIA_DEF_MEMBEGIN',0x000C0000)
    win_const_mgr.add_const('ERROR_NO_CALLBACK_ACTIVE',0x00000266)
    win_const_mgr.add_const('DXVA_MACROBLOCK_CONTROL_BUFFER',0x00000002)
    win_const_mgr.add_const('ID_BROWSE_CHANGEICON',0x00000001)
    win_const_mgr.add_const('ATA_FLAGS_DATA_OUT',0x00000001)
    win_const_mgr.add_const('WIA_SELECT_DEVICE_NODEFAULT',0x00000001)
    win_const_mgr.add_const('IF_TYPE_RFC1483',0x0000009F)
    win_const_mgr.add_const('CDS_RESET',0x40000000)
    win_const_mgr.add_const('FWP_FILTER_ENUM_FLAG_INCLUDE_BOOTTIME',0x00000008)
    win_const_mgr.add_const('SQL_MAX_INDEX_SIZE',0x00000066)
    win_const_mgr.add_const('ACM_DRIVERPRIORITYF_ABLEMASK',0x00000003)
    win_const_mgr.add_const('RC_PALETTE',0x00000100)
    win_const_mgr.add_const('CFU_UNDERLINE',0x00000001)
    win_const_mgr.add_const('MQMSG_AUTHENTICATION_NOT_REQUESTED',0x00000000)
    win_const_mgr.add_const('CM_QUERY_ARBITRATOR_BITS',0x00000001)
    win_const_mgr.add_const('NETSETUP_ACCT_CREATE',0x00000002)
    win_const_mgr.add_const('SECPKG_FLAG_ACCEPT_WIN32_NAME',0x00000200)
    win_const_mgr.add_const('ICEE_CREATE_MACHINE_AMD64',0x00000400)
    win_const_mgr.add_const('WMSZ_BOTTOMRIGHT',0x00000008)
    win_const_mgr.add_const('NET_DFS_SETDC_INITPKT',0x00000002)
    win_const_mgr.add_const('MQSEC_SET_QUEUE_PROPERTIES',0x00000010)
    win_const_mgr.add_const('DDFXCAPS_OVERLAYSTRETCHY',0x02000000)
    win_const_mgr.add_const('DDFXCAPS_OVERLAYSTRETCHX',0x00800000)
    win_const_mgr.add_const('UNRECOVERED_READS_VALID',0x00000008)
    win_const_mgr.add_const('SPWPT_SELECTDEVICE',0x00000001)
    win_const_mgr.add_const('HTTP_STATUS_PAYMENT_REQ',0x00000192)
    win_const_mgr.add_const('INTERNET_IDENTITY_FLAG_CLEAR_DATA',0x00000004)
    win_const_mgr.add_const('INTERNET_STATE_DISCONNECTED_BY_USER',0x00000010)
    win_const_mgr.add_const('HTTP_LOG_FIELD_CLIENT_PORT',0x00400000)
    win_const_mgr.add_const('AE_LIM_DISABLED',0x00000004)
    win_const_mgr.add_const('D3DPMISCCAPS_CULLCW',0x00000020)
    win_const_mgr.add_const('VK_OEM_102',0x000000E2)
    win_const_mgr.add_const('FAX_JOB_SUBMIT',0x00000001)
    win_const_mgr.add_const('WTS_EVENT_DISCONNECT',0x00000010)
    win_const_mgr.add_const('MCI_DEVTYPE_SCANNER',0x00000206)
    win_const_mgr.add_const('SUBLANG_KICHE_GUATEMALA',0x00000001)
    win_const_mgr.add_const('NCRYPTBUFFER_SSL_SERVER_RANDOM',0x00000015)
    win_const_mgr.add_const('PID_INTSITE_CONTENTCODE',0x0000000B)
    win_const_mgr.add_const('SM_CYFULLSCREEN',0x00000011)
    win_const_mgr.add_const('VK_DBE_HIRAGANA',0x00000000)
    win_const_mgr.add_const('WIA_DPS_MIN_VERTICAL_SHEET_FEED_SIZE',0x00000C21)
    win_const_mgr.add_const('ERROR_CLUSTER_DATABASE_SEQMISMATCH',0x000013DB)
    win_const_mgr.add_const('SNMPAPI_TL_UNDELIVERABLE',0x00000068)
    win_const_mgr.add_const('ASC_RET_REPLAY_DETECT',0x00000004)
    win_const_mgr.add_const('SQL_RESTRICT',0x00000001)
    win_const_mgr.add_const('PORT_DLSMON',0x000000C6)
    win_const_mgr.add_const('ERRACT_DLYRET',0x00000002)
    win_const_mgr.add_const('NMP_PROCESS_CONTROL',0x00000002)
    win_const_mgr.add_const('PHONELAMPMODE_BROKENFLUTTER',0x00000040)
    win_const_mgr.add_const('GLEX_ACCEPT',0x00000001)
    win_const_mgr.add_const('STI_GENCAP_AUTO_PORTSELECT',0x00000008)
    win_const_mgr.add_const('FWPM_FILTER_FLAG_CLEAR_ACTION_RIGHT',0x00000008)
    win_const_mgr.add_const('IP_MISS_STNS_SHIFT',0x00000004)
    win_const_mgr.add_const('TMT_TEXTSHADOWCOLOR',0x00000EEA)
    win_const_mgr.add_const('MFE_PROHIBITED',0x0000000C)
    win_const_mgr.add_const('DEBUG_GET_PROC_FULL_MATCH',0x00000001)
    win_const_mgr.add_const('SPI_GETDRAGFULLWINDOWS',0x00000026)
    win_const_mgr.add_const('SEF_SACL_AUTO_INHERIT',0x00000002)
    win_const_mgr.add_const('EVENT_SYSTEM_DRAGDROPSTART',0x0000000E)
    win_const_mgr.add_const('SQL_TIMEDATE_ADD_INTERVALS',0x0000006D)
    win_const_mgr.add_const('ERROR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE',0x00001784)
    win_const_mgr.add_const('DDBLT_KEYSRCOVERRIDE',0x00010000)
    win_const_mgr.add_const('DPROMPT_BUFFERTOOSMALL',0x00000003)
    win_const_mgr.add_const('ALG_SID_SKIPJACK',0x0000000A)
    win_const_mgr.add_const('WINHELP_INDEX',0x00000010)
    win_const_mgr.add_const('GDICOMMENT_WINDOWS_METAFILE',0x80000001)
    win_const_mgr.add_const('EVLEN',0x00000010)
    win_const_mgr.add_const('DEBUG_GETMOD_NO_LOADED_MODULES',0x00000001)
    win_const_mgr.add_const('COOKIE_DONT_ALLOW_ALL',0x00000008)
    win_const_mgr.add_const('DRVCNF_CANCEL',0x00000000)
    win_const_mgr.add_const('MD_ERROR_SUB404_URL_SEQUENCE_DENIED',0x00000005)
    win_const_mgr.add_const('AUDCLNT_STREAMFLAGS_CROSSPROCESS',0x00010000)
    win_const_mgr.add_const('DBPROPVAL_ORS_STOREDPROC',0x00000004)
    win_const_mgr.add_const('NUMPRS_CURRENCY',0x00000400)
    win_const_mgr.add_const('IMAGE_SCN_CNT_UNINITIALIZED_DATA',0x00000080)
    win_const_mgr.add_const('ILC_MASK',0x00000001)
    win_const_mgr.add_const('IDTR_PPN',0x00000038)
    win_const_mgr.add_const('SQL_ISV_ASSERTIONS',0x00000001)
    win_const_mgr.add_const('DISPID_SEARCHCOMMAND_UPDATE',0x00000004)
    win_const_mgr.add_const('SORT_INVARIANT_MATH',0x00000001)
    win_const_mgr.add_const('PDH_RETRY',0x800007D4)
    win_const_mgr.add_const('DEBUG_GETFNENT_RAW_ENTRY_ONLY',0x00000001)
    win_const_mgr.add_const('ERROR_DBG_COMMAND_EXCEPTION',0x000002B9)
    win_const_mgr.add_const('DXGI_FORMAT_DEFINED',0x00000001)
    win_const_mgr.add_const('IDM_BORDERCOLOR',0x00000035)
    win_const_mgr.add_const('SWP_NOSIZE',0x00000001)
    win_const_mgr.add_const('LINEAGENTSTATUS_CAPSCHANGE',0x00000040)
    win_const_mgr.add_const('SNMP_OUTPUT_TO_EVENTLOG',0x00000004)
    win_const_mgr.add_const('TAPE_DRIVE_GET_LOGICAL_BLK',0x00200000)
    win_const_mgr.add_const('SNMPAPI_NO_SUPPORT',0x00000000)
    win_const_mgr.add_const('LINEMEDIAMODE_UNKNOWN',0x00000002)
    win_const_mgr.add_const('MCI_VD_FORMAT_TRACK',0x00004001)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_LOGGING_USERS',0x0000022F)
    win_const_mgr.add_const('PERF_DELTA_COUNTER',0x00400000)
    win_const_mgr.add_const('LOW_SURROGATE_START',0x00000000)
    win_const_mgr.add_const('OPTION_STATIC_ROUTES',0x00000021)
    win_const_mgr.add_const('OLECMDARGINDEX_SHOWPAGEACTIONMENU_HWND',0x00000000)
    win_const_mgr.add_const('EVENT_HEADER_FLAG_PRIVATE_SESSION',0x00000002)
    win_const_mgr.add_const('FLASHMODE_EXTERNALSYNC',0x00000006)
    win_const_mgr.add_const('DM_DUPLEX',0x00001000)
    win_const_mgr.add_const('WSAENOMORE',0x00002776)
    win_const_mgr.add_const('IMGLOAD_COMPLETE',0x01000000)
    win_const_mgr.add_const('PERF_SIZE_DWORD',0x00000000)
    win_const_mgr.add_const('MQSEC_DELETE_JOURNAL_MESSAGE',0x00000008)
    win_const_mgr.add_const('DOT11_STATUS_AUTH_VERIFIED',0x00010000)
    win_const_mgr.add_const('ASC_REQ_CALL_LEVEL',0x00001000)
    win_const_mgr.add_const('ERROR_PROFILING_NOT_STARTED',0x00000226)
    win_const_mgr.add_const('IPPORT_REGISTERED_MAX',0x00000000)
    win_const_mgr.add_const('SND_NOWAIT',0x00002000)
    win_const_mgr.add_const('IME_THOTKEY_SYMBOL_TOGGLE',0x00000072)
    win_const_mgr.add_const('IDM_CLEARAUTHENTICATIONCACHE',0x00003A9B)
    win_const_mgr.add_const('WIA_FILM_COLOR_SLIDE',0x00000000)
    win_const_mgr.add_const('ERROR_DS_DRA_SINK_DISABLED',0x00002109)
    win_const_mgr.add_const('TIME_ZONE_ID_DAYLIGHT',0x00000002)
    win_const_mgr.add_const('FILTER_WORKSTATION_TRUST_ACCOUNT',0x00000010)
    win_const_mgr.add_const('INTERNET_OPTION_ASYNC',0x0000001E)
    win_const_mgr.add_const('SUBLANG_SPANISH_URUGUAY',0x00000000)
    win_const_mgr.add_const('PAN_STROKE_RAPID_HORZ',0x00000007)
    win_const_mgr.add_const('CB_GETTOPINDEX',0x00000015)
    win_const_mgr.add_const('LINEPROXYREQUEST_SETQUEUEMEASUREMENTPERIOD',0x00000011)
    win_const_mgr.add_const('TMT_GRADIENTRATIO5',0x0000096A)
    win_const_mgr.add_const('DEBUG_SESSION_END',0x00000004)
    win_const_mgr.add_const('WSAECANCELLED',0x00002777)
    win_const_mgr.add_const('TASK_MAY',0x00000010)
    win_const_mgr.add_const('TMT_GRADIENTRATIO4',0x00000969)
    win_const_mgr.add_const('CE_MODE',0x00008000)
    win_const_mgr.add_const('ERROR_NONPAGED_SYSTEM_RESOURCES',0x000005AB)
    win_const_mgr.add_const('DRM_SERVICE_TYPE_CLIENTLICENSOR',0x00000008)
    win_const_mgr.add_const('KF_FLAG_DONT_UNEXPAND',0x00002000)
    win_const_mgr.add_const('IMAGE_REL_I386_ABSOLUTE',0x00000000)
    win_const_mgr.add_const('SQL_DESC_ALLOC_TYPE',0x0000044B)
    win_const_mgr.add_const('COLOR_BLUE',0x000002C4)
    win_const_mgr.add_const('ERROR_EVT_FILTER_OUT_OF_RANGE',0x00003ABE)
    win_const_mgr.add_const('ERROR_SPECIAL_GROUP',0x0000055C)
    win_const_mgr.add_const('VALIDATEUNC_CONNECT',0x00000001)
    win_const_mgr.add_const('DEVICEPOWER_FILTER_WAKEENABLED',0x08000000)
    win_const_mgr.add_const('TIMECOLLECTION_OFFSET',0x00000600)
    win_const_mgr.add_const('LVS_EDITLABELS',0x00000200)
    win_const_mgr.add_const('ERROR_INVALID_PORT_ATTRIBUTES',0x00000221)
    win_const_mgr.add_const('ERROR_DS_INCOMPATIBLE_CONTROLS_USED',0x0000217E)
    win_const_mgr.add_const('CDRF_SKIPPOSTPAINT',0x00000100)
    win_const_mgr.add_const('EAP_I_EAPHOST_LAST',0x804200FF)
    win_const_mgr.add_const('SE_GROUP_USE_FOR_DENY_ONLY',0x00000010)
    win_const_mgr.add_const('CMSG_ATTR_CERT_COUNT_PARAM',0x0000001F)
    win_const_mgr.add_const('SE_GROUP_DEFAULTED',0x00000002)
    win_const_mgr.add_const('XP1_UNI_RECV',0x00010000)
    win_const_mgr.add_const('OBJ_METADC',0x00000004)
    win_const_mgr.add_const('RPC_C_IMP_LEVEL_IDENTIFY',0x00000002)
    win_const_mgr.add_const('IF_TYPE_HDH_1822',0x00000003)
    win_const_mgr.add_const('NRC_NAMTFUL',0x00000000)
    win_const_mgr.add_const('ICDECOMPRESS_HURRYUP',0x80000000)
    win_const_mgr.add_const('ST_NEWCHARS',0x00000004)
    win_const_mgr.add_const('MUTZ_DONT_UNESCAPE',0x00000800)
    win_const_mgr.add_const('VCSTATUS_MOVE',0x00040000)
    win_const_mgr.add_const('OID_GEN_VENDOR_DESCRIPTION',0x0001010D)
    win_const_mgr.add_const('WM_DEVMODECHANGE',0x0000001B)
    win_const_mgr.add_const('MAX_RECORDS_IN_FOREST_TRUST_INFO',0x00000FA0)
    win_const_mgr.add_const('SM_CXVIRTUALSCREEN',0x0000004E)
    win_const_mgr.add_const('CS_NOCLOSE',0x00000200)
    win_const_mgr.add_const('CF_PRIVATELAST',0x000002FF)
    win_const_mgr.add_const('CERT_COMPARE_ENHKEY_USAGE',0x0000000A)
    win_const_mgr.add_const('META_CREATEREGION',0x000006FF)
    win_const_mgr.add_const('CTLCOLOR_BTN',0x00000003)
    win_const_mgr.add_const('ACM_METRIC_COUNT_LOCAL_DRIVERS',0x00000014)
    win_const_mgr.add_const('DISPID_DOCUMENTCOMPLETE',0x00000103)
    win_const_mgr.add_const('IDM_ROWSELECT',0x0000089F)
    win_const_mgr.add_const('TTFCFP_LANG_KEEP_ALL',0x00000000)
    win_const_mgr.add_const('USE_SESSLOST',0x00000002)
    win_const_mgr.add_const('ILR_SCALE_CLIP',0x00000000)
    win_const_mgr.add_const('TASK_JANUARY',0x00000001)
    win_const_mgr.add_const('PDH_INVALID_ARGUMENT',0xC0000BBD)
    win_const_mgr.add_const('FCSM_LOGO',0x00000020)
    win_const_mgr.add_const('OID_CO_TAPI_LINE_CAPS',0xFE001002)
    win_const_mgr.add_const('CM_REENUMERATE_RETRY_INSTALLATION',0x00000002)
    win_const_mgr.add_const('DNS_STATUS_DOTTED_NAME',0x00002556)
    win_const_mgr.add_const('DEBUG_EXECUTE_NOT_LOGGED',0x00000002)
    win_const_mgr.add_const('ERROR_DS_CANT_RETRIEVE_CHILD',0x000020E6)
    win_const_mgr.add_const('DNS_TYPE_DNAME',0x00000027)
    win_const_mgr.add_const('RPC_S_INVALID_BOUND',0x000006C6)
    win_const_mgr.add_const('PORT_TACNEWS',0x00000062)
    win_const_mgr.add_const('ERROR_DS_OUT_OF_SCOPE',0x00002092)
    win_const_mgr.add_const('KSFILTER_FLAG_DISPATCH_LEVEL_PROCESSING',0x00000001)
    win_const_mgr.add_const('SV_TYPE_XENIX_SERVER',0x00000800)
    win_const_mgr.add_const('RRF_RT_REG_EXPAND_SZ',0x00000004)
    win_const_mgr.add_const('MAX_SEARCH_FORMAT_STRING',0x000000FF)
    win_const_mgr.add_const('CERT_DSS_S_LEN',0x00000014)
    win_const_mgr.add_const('HS_HORIZONTAL',0x00000000)
    win_const_mgr.add_const('OID_FDDI_IF_OUT_OCTETS',0x03030287)
    win_const_mgr.add_const('EAP_FLAG_LOGON',0x00000004)
    win_const_mgr.add_const('ODS_NOFOCUSRECT',0x00000200)
    win_const_mgr.add_const('ASYNC_RECO_SETGUIDE_FAILED',0x00000020)
    win_const_mgr.add_const('FIND_SIZE',0x00003000)
    win_const_mgr.add_const('SPI_GETICONMETRICS',0x0000002D)
    win_const_mgr.add_const('CERT_CHAIN_FIND_BY_ISSUER_COMPLEX_CHAIN_FLAG',0x00000002)
    win_const_mgr.add_const('CAL_HEBREW',0x00000008)
    win_const_mgr.add_const('RESOURCEDISPLAYTYPE_SERVER',0x00000002)
    win_const_mgr.add_const('ERROR_CLASS_DOES_NOT_EXIST',0x00000583)
    win_const_mgr.add_const('ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT',0x0000219E)
    win_const_mgr.add_const('IF_TYPE_LOCALTALK',0x0000002A)
    win_const_mgr.add_const('OID_GEN_CO_MINIMUM_LINK_SPEED',0x00020120)
    win_const_mgr.add_const('DATABITS_5',0x00000001)
    win_const_mgr.add_const('FLG_ADDREG_32BITKEY',0x00004000)
    win_const_mgr.add_const('DDOVER_ALPHASRC',0x00000020)
    win_const_mgr.add_const('FPS_NOT_FAX_CALL',0x20001000)
    win_const_mgr.add_const('KP_PUB_EX_VAL',0x0000001D)
    win_const_mgr.add_const('MDPROPVAL_MSF_BOTTOMPERCENT',0x00000002)
    win_const_mgr.add_const('RUNTIME_FUNCTION_INDIRECT',0x00000001)
    win_const_mgr.add_const('TECHNOLOGY',0x00000002)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2ERASE_CLIENTNAME',0x00000103)
    win_const_mgr.add_const('NUMPRS_EXPONENT',0x00000800)
    win_const_mgr.add_const('HTTOP',0x0000000C)
    win_const_mgr.add_const('MCI_DGV_GETDEVCAPS_CAN_STRETCH',0x00004001)
    win_const_mgr.add_const('HH_SET_WIN_TYPE',0x00000004)
    win_const_mgr.add_const('IDM_LIVERESIZE',0x0000095E)
    win_const_mgr.add_const('DBPROPVAL_IT_CONTENT',0x00000003)
    win_const_mgr.add_const('SSRVOPT_CALLBACKW',0x00010000)
    win_const_mgr.add_const('CRYPTUI_ENABLE_ADDTOSTORE',0x00000020)
    win_const_mgr.add_const('PORT_LOCUSMAP',0x0000007D)
    win_const_mgr.add_const('CMS_USEDESCRIPTION',0x00000200)
    win_const_mgr.add_const('D3DSHADER_INSTRUCTION_PREDICATED',0x00000001)
    win_const_mgr.add_const('PORT_ANYFILESYS',0x0000003B)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_TRANSITION_IRIS',0x00000014)
    win_const_mgr.add_const('DIRID_SHARED',0x00000019)
    win_const_mgr.add_const('SQL_API_SQLALLOCSTMT',0x00000003)
    win_const_mgr.add_const('LINEDEVCAPFLAGS_CROSSADDRCONF',0x00000001)
    win_const_mgr.add_const('CAUSE_LOC_TRANSIT_NETWORK',0x00000003)
    win_const_mgr.add_const('SNMP_MGMTAPI_AGAIN',0x0000002D)
    win_const_mgr.add_const('PORT_X400SND',0x00000068)
    win_const_mgr.add_const('CAPTUREMODE_NORMAL',0x00000001)
    win_const_mgr.add_const('ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE',0x00003AE8)
    win_const_mgr.add_const('APPCOMMAND_BASS_UP',0x00000015)
    win_const_mgr.add_const('SHCNE_DRIVEADDGUI',0x00010000)
    win_const_mgr.add_const('PSWIZB_SHOW',0x00000000)
    win_const_mgr.add_const('MCI_SPIN',0x0000080C)
    win_const_mgr.add_const('DC_EMF_COMPLIANT',0x00000014)
    win_const_mgr.add_const('CT_CTYPE2',0x00000002)
    win_const_mgr.add_const('ERROR_BAD_INHERITANCE_ACL',0x0000053C)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_REPLICATOR',0x00000228)
    win_const_mgr.add_const('HHWIN_PARAM_SHOWSTATE',0x00000001)
    win_const_mgr.add_const('D3DDTCAPS_USHORT2N',0x00000010)
    win_const_mgr.add_const('IMAGE_FILE_NET_RUN_FROM_SWAP',0x00000800)
    win_const_mgr.add_const('CRYPT_MACHINE_KEYSET',0x00000020)
    win_const_mgr.add_const('D3DPBLENDCAPS_INVDESTALPHA',0x00000080)
    win_const_mgr.add_const('RASCS_DONE',0x00002000)
    win_const_mgr.add_const('IR_UNDETERMINE',0x00000170)
    win_const_mgr.add_const('JOB_OBJECT_MSG_EXIT_PROCESS',0x00000007)
    win_const_mgr.add_const('ERROR_NO_USER_SESSION_KEY',0x00000572)
    win_const_mgr.add_const('DDSCL_FPUSETUP',0x00000800)
    win_const_mgr.add_const('MODALS_LOCKOUT_OBSERVATION_WINDOW_PARMNUM',0x0000000B)
    win_const_mgr.add_const('DCX_INTERSECTUPDATE',0x00000200)
    win_const_mgr.add_const('URLACTION_FEATURE_MIN',0x00002100)
    win_const_mgr.add_const('BTNS_SHOWTEXT',0x00000040)
    win_const_mgr.add_const('ET_DEVICENAME',0x00000001)
    win_const_mgr.add_const('PI_RESTRICTED',0x00000040)
    win_const_mgr.add_const('HDI_WIDTH',0x00000001)
    win_const_mgr.add_const('SUBLANG_CHINESE_MACAU',0x00000005)
    win_const_mgr.add_const('MFBYTESTREAM_IS_READABLE',0x00000001)
    win_const_mgr.add_const('SV_MAXKEEPSEARCH_PARMNUM',0x0000020B)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_TRANSITION_WHEEL',0x0000001F)
    win_const_mgr.add_const('WB_ISDELIMITER',0x00000002)
    win_const_mgr.add_const('PGS_AUTOSCROLL',0x00000002)
    win_const_mgr.add_const('INTERNET_STATUS_NAME_RESOLVED',0x0000000B)
    win_const_mgr.add_const('WIA_PAGE_DIN_2B',0x00000034)
    win_const_mgr.add_const('INTERNET_FLAG_IDN_PROXY',0x00000002)
    win_const_mgr.add_const('IEIFLAG_ASYNC',0x00000001)
    win_const_mgr.add_const('DEREGISTERED',0x00000005)
    win_const_mgr.add_const('ERROR_ILL_FORMED_PASSWORD',0x0000052C)
    win_const_mgr.add_const('CERT_AIA_URL_RETRIEVED_PROP_ID',0x00000043)
    win_const_mgr.add_const('WIA_DPC_THUMB_HEIGHT',0x00000813)
    win_const_mgr.add_const('URLACTION_SCRIPT_MIN',0x00001400)
    win_const_mgr.add_const('IMFT_SUBMENU',0x00000004)
    win_const_mgr.add_const('ERROR_RESOURCE_NOT_AVAILABLE',0x0000138E)
    win_const_mgr.add_const('DISPID_RESETSAFEMODE',0x00000002)
    win_const_mgr.add_const('WAVE_FORMAT_DEVELOPMENT',0x0000FFFF)
    win_const_mgr.add_const('SUBLANG_SAMI_LULE_SWEDEN',0x00000005)
    win_const_mgr.add_const('CM_DEVCAP_REMOVABLE',0x00000004)
    win_const_mgr.add_const('DMPAPER_A3_TRANSVERSE',0x00000043)
    win_const_mgr.add_const('DBPROPVAL_PERSIST_ADTG',0x00000000)
    win_const_mgr.add_const('MAPI_E_MESSAGE_IN_USE',0x00000016)
    win_const_mgr.add_const('TVS_FULLROWSELECT',0x00001000)
    win_const_mgr.add_const('IP_OPT_ROUTER_ALERT',0x00000094)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_SYSTEMRESTORE',0x00000001)
    win_const_mgr.add_const('IDTB_CONTRACT',0x000000C9)
    win_const_mgr.add_const('FWPM_CONTEXT_IPSEC_OUTBOUND_NEGOTIATE_DISCOVER',0x00000001)
    win_const_mgr.add_const('SQL_CA_CONSTRAINT_INITIALLY_DEFERRED',0x00000010)
    win_const_mgr.add_const('IMGDECODE_EVENT_BITSCOMPLETE',0x00000008)
    win_const_mgr.add_const('SQL_API_SQLFREECONNECT',0x0000000E)
    win_const_mgr.add_const('DRM_EL_REVOCATIONLIST_LID',0x00000800)
    win_const_mgr.add_const('LINEDEVSTATUSFLAGS_CONNECTED',0x00000001)
    win_const_mgr.add_const('OID_FDDI_MAC_COPIED_CT',0x0303023C)
    win_const_mgr.add_const('D3DDEVCAPS_TLVERTEXVIDEOMEMORY',0x00000080)
    win_const_mgr.add_const('WLX_SAS_ACTION_SHUTDOWN_SLEEP',0x0000000C)
    win_const_mgr.add_const('PORT_TFTP',0x00000045)
    win_const_mgr.add_const('ERROR_DESTROY_OBJECT_OF_OTHER_THREAD',0x0000059B)
    win_const_mgr.add_const('SQL_SEARCHABLE',0x00000003)
    win_const_mgr.add_const('MUTZ_ACCEPT_WILDCARD_SCHEME',0x00000080)
    win_const_mgr.add_const('CMSG_CMS_ENCAPSULATED_CTL_FLAG',0x00008000)
    win_const_mgr.add_const('OID_FDDI_PATH_SBA_AVAILABLE',0x03030258)
    win_const_mgr.add_const('NORMAL_CACHE_ENTRY',0x00000001)
    win_const_mgr.add_const('IDM_HWND',0x00000002)
    win_const_mgr.add_const('DUMP_DRIVER_NAME_LENGTH',0x0000000F)
    win_const_mgr.add_const('GAA_FLAG_INCLUDE_ALL_COMPARTMENTS',0x00000200)
    win_const_mgr.add_const('BG_E_INVALID_AUTH_TARGET',0x80200027)
    win_const_mgr.add_const('PERCEIVEDFLAG_HARDCODED',0x00000002)
    win_const_mgr.add_const('CAL_SABBREVMONTHNAME12',0x00000002)
    win_const_mgr.add_const('URLPOLICY_ACTIVEX_CHECK_LIST',0x00010000)
    win_const_mgr.add_const('SQL_CDO_CREATE_DOMAIN',0x00000001)
    win_const_mgr.add_const('SUBLANG_NEUTRAL',0x00000000)
    win_const_mgr.add_const('MEM_8K',0x00002000)
    win_const_mgr.add_const('COLOR_RED',0x000002C2)
    win_const_mgr.add_const('MCI_ANIM_STEP_FRAMES',0x00020000)
    win_const_mgr.add_const('SHIL_SMALL',0x00000001)
    win_const_mgr.add_const('ERROR_CTX_SECURITY_LAYER_ERROR',0x00001B9C)
    win_const_mgr.add_const('DMMEDIA_USER',0x00000100)
    win_const_mgr.add_const('CERT_RDN_TELETEX_STRING',0x00000005)
    win_const_mgr.add_const('FS_DISCONNECTED',0x20000400)
    win_const_mgr.add_const('OID_CO_ADD_PVC',0xFE000001)
    win_const_mgr.add_const('SPI_GETDEFAULTINPUTLANG',0x00000059)
    win_const_mgr.add_const('LINEDEVSTATE_CAPSCHANGE',0x00100000)
    win_const_mgr.add_const('TRANSPORT_TYPE_WMSG',0x00000008)
    win_const_mgr.add_const('PROTO_IP_BOOTP',0x0000270F)
    win_const_mgr.add_const('MSV1_0_OWF_PASSWORD_LENGTH',0x00000010)
    win_const_mgr.add_const('LOCALE_SPOSINFINITY',0x00000006)
    win_const_mgr.add_const('JIFMK_JPG',0x0000FFC8)
    win_const_mgr.add_const('DS_REPSYNCALL_ID_SERVERS_BY_DN',0x00000004)
    win_const_mgr.add_const('PIDSI_SUBJECT',0x00000003)
    win_const_mgr.add_const('CSF_EXPLORER',0x00000008)
    win_const_mgr.add_const('SQL_CHAR',0x00000001)
    win_const_mgr.add_const('SQL_MODE_READ_ONLY',0x00000001)
    win_const_mgr.add_const('WSA_QOS_ESDMODEOBJ',0x00002B15)
    win_const_mgr.add_const('F_NOPARENT',0x0000000A)
    win_const_mgr.add_const('IDM_COMMENT',0x0000087D)
    win_const_mgr.add_const('LINECALLPARTYID_ADDRESS',0x00000008)
    win_const_mgr.add_const('SECURITY_FLAG_IETFSSL4',0x00000020)
    win_const_mgr.add_const('CC_NONE',0x00000000)
    win_const_mgr.add_const('KTM_MARSHAL_BLOB_VERSION_MAJOR',0x00000001)
    win_const_mgr.add_const('PERF_NUMBER_HEX',0x00000000)
    win_const_mgr.add_const('TIMEDMPLAYEROBJECT_OFFSET',0x00001100)
    win_const_mgr.add_const('DM_ORIENTATION',0x00000001)
    win_const_mgr.add_const('DMDITHER_FINE',0x00000003)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_MM_COW',0x0000000C)
    win_const_mgr.add_const('ERROR_PAGEFILE_CREATE_FAILED',0x00000240)
    win_const_mgr.add_const('SIF_PAGE',0x00000002)
    win_const_mgr.add_const('SIZE_MAXIMIZED',0x00000002)
    win_const_mgr.add_const('CBN_SELCHANGE',0x00000001)
    win_const_mgr.add_const('AM_AC3_SERVICE_DIALOG_ONLY',0x00000004)
    win_const_mgr.add_const('MFCLOCK_JITTER_DPC',0x00000FA0)
    win_const_mgr.add_const('TXTLOG_SETUPAPI_BITS',0x00000003)
    win_const_mgr.add_const('DISPID_COLUMNSCHANGED',0x000000D4)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_REFQ2',0x00000014)
    win_const_mgr.add_const('CLASSFACTORY_E_LAST',0x8004011F)
    win_const_mgr.add_const('CERT_DISPWELL_TRUST_LEAF_CERT',0x00000003)
    win_const_mgr.add_const('DSBS_ROOT',0x00000004)
    win_const_mgr.add_const('SPI_SETSCREENSAVEACTIVE',0x00000011)
    win_const_mgr.add_const('DISPID_CLIENTTOHOSTWINDOW',0x0000010C)
    win_const_mgr.add_const('NLS_DBCSCHAR',0x00010000)
    win_const_mgr.add_const('MCI_VCR_STATUS_ASSEMBLE_RECORD',0x0000401D)
    win_const_mgr.add_const('ERROR_NO_RECOVERY_PROGRAM',0x0000043A)
    win_const_mgr.add_const('MIXER_GETLINEINFOF_SOURCE',0x00000001)
    win_const_mgr.add_const('ILDI_PURGE',0x00000001)
    win_const_mgr.add_const('WTS_WSD_POWEROFF',0x00000008)
    win_const_mgr.add_const('DISPID_TVFLAGS',0x00000014)
    win_const_mgr.add_const('MC_CAPS_RED_GREEN_BLUE_DRIVE',0x00000020)
    win_const_mgr.add_const('PFM_BORDER',0x00000800)
    win_const_mgr.add_const('IDC_VP_RESULTIMAGE',0x00000409)
    win_const_mgr.add_const('LDAP_VERSION_MIN',0x00000002)
    win_const_mgr.add_const('SQL_AD_ON',0x00000001)
    win_const_mgr.add_const('ERROR_DS_ADMIN_LIMIT_EXCEEDED',0x00002024)
    win_const_mgr.add_const('ERROR_FATAL_APP_EXIT',0x000002C9)
    win_const_mgr.add_const('ASYNC_RECO_ADDSTROKE_FAILED',0x00000004)
    win_const_mgr.add_const('DBIMF_DEBOSSED',0x00000020)
    win_const_mgr.add_const('SECURITY_MANDATORY_LOW_RID',0x00001000)
    win_const_mgr.add_const('LUP_RES_SERVICE',0x00008000)
    win_const_mgr.add_const('SSGF_DISPLAY',0x00000003)
    win_const_mgr.add_const('GD_CURSORCOMPONENT',0x00000001)
    win_const_mgr.add_const('MEM_WRITE_WATCH',0x00200000)
    win_const_mgr.add_const('VK_MBUTTON',0x00000004)
    win_const_mgr.add_const('BTH_ERROR_MEMORY_FULL',0x00000007)
    win_const_mgr.add_const('PROFILE_SERVER',0x40000000)
    win_const_mgr.add_const('ETW_NON_NULL_TERMINATED_STRING_TYPE_VALUE',0x00000070)
    win_const_mgr.add_const('RECOFLAG_DISABLEPERSONALIZATION',0x00000020)
    win_const_mgr.add_const('EV_TXEMPTY',0x00000004)
    win_const_mgr.add_const('CERT_INFO_ISSUER_FLAG',0x00000004)
    win_const_mgr.add_const('ERROR_EFS_NOT_ALLOWED_IN_TRANSACTION',0x00001AAF)
    win_const_mgr.add_const('RPC_C_AUTHN_LEVEL_DEFAULT',0x00000000)
    win_const_mgr.add_const('UDS_SETBUDDYINT',0x00000002)
    win_const_mgr.add_const('LVS_EX_CHECKBOXES',0x00000004)
    win_const_mgr.add_const('WIA_DATA_THRESHOLD',0x00000000)
    win_const_mgr.add_const('IP_HOPLIMIT',0x00000015)
    win_const_mgr.add_const('PHOTO_ORIENTATION_ROTATE270',0x00000006)
    win_const_mgr.add_const('NETE_SSLSEC',0x00000012)
    win_const_mgr.add_const('IN6ADDR_LINKLOCALPREFIX_LENGTH',0x00000040)
    win_const_mgr.add_const('MCI_INFO_VERSION',0x00000400)
    win_const_mgr.add_const('MCI_DGV_SET_SPEED',0x00020000)
    win_const_mgr.add_const('D3DPTFILTERCAPS_MINFPOINT',0x00000100)
    win_const_mgr.add_const('SUBLANG_AFRIKAANS_SOUTH_AFRICA',0x00000001)
    win_const_mgr.add_const('WIA_IPS_MIRROR',0x0000180E)
    win_const_mgr.add_const('FROM_LEFT_3RD_BUTTON_PRESSED',0x00000008)
    win_const_mgr.add_const('ETW_ASCIISTRING_TYPE_VALUE',0x00000067)
    win_const_mgr.add_const('SELCERT_FINEPRINT',0x00000065)
    win_const_mgr.add_const('SUBLANG_FILIPINO_PHILIPPINES',0x00000001)
    win_const_mgr.add_const('ERROR_SWAPERROR',0x000003E7)
    win_const_mgr.add_const('CF_DIB',0x00000008)
    win_const_mgr.add_const('SECPKG_ATTR_APP_DATA',0x00000005)
    win_const_mgr.add_const('RBNM_STYLE',0x00000002)
    win_const_mgr.add_const('WM_GETTEXT',0x0000000D)
    win_const_mgr.add_const('SQL_DROP_ASSERTION',0x00000088)
    win_const_mgr.add_const('DNS_ERROR_RECORD_ALREADY_EXISTS',0x000025EF)
    win_const_mgr.add_const('ERROR_DS_NAME_UNPARSEABLE',0x0000209E)
    win_const_mgr.add_const('TF_CONVERSIONMODE_NOCONVERSION',0x00000100)
    win_const_mgr.add_const('SO_DEREGISTER_NAME',0x0000A001)
    win_const_mgr.add_const('QOS_NON_ADAPTIVE_FLOW',0x00000002)
    win_const_mgr.add_const('TCS_BUTTONS',0x00000100)
    win_const_mgr.add_const('WMDM_E_BUSY',0x80045000)
    win_const_mgr.add_const('ACCESS_FAIL_OPEN',0x00000100)
    win_const_mgr.add_const('ENM_SELCHANGE',0x00080000)
    win_const_mgr.add_const('AE_UNSHARE',0x00000002)
    win_const_mgr.add_const('DDD_REMOVE_DEFINITION',0x00000002)
    win_const_mgr.add_const('UI_CAP_ROT90',0x00000002)
    win_const_mgr.add_const('JOB_OBJECT_UILIMIT_DESKTOP',0x00000040)
    win_const_mgr.add_const('CAUSE_USER_REJECTS_CLIR',0x00000017)
    win_const_mgr.add_const('SM_CARETBLINKINGENABLED',0x00002002)
    win_const_mgr.add_const('SUBLANG_UZBEK_LATIN',0x00000001)
    win_const_mgr.add_const('BLLI_L3_IPI_SNAP',0x00000080)
    win_const_mgr.add_const('OFFLINESTATUS_OFFLINE_SUSPENDED',0x00000006)
    win_const_mgr.add_const('FS_JISJAPAN',0x00020000)
    win_const_mgr.add_const('CM_ADD_RANGE_DONOTADDIFCONFLICT',0x00000001)
    win_const_mgr.add_const('END_PATH',0x00001002)
    win_const_mgr.add_const('PRIVACY_TEMPLATE_NO_COOKIES',0x00000000)
    win_const_mgr.add_const('SCESTATUS_PROFILE_NOT_FOUND',0x00000006)
    win_const_mgr.add_const('SQL_MAX_COLUMNS_IN_GROUP_BY',0x00000061)
    win_const_mgr.add_const('DWN_RAWIMAGE',0x00000100)
    win_const_mgr.add_const('SM_SAMEDISPLAYFORMAT',0x00000051)
    win_const_mgr.add_const('ERROR_HOST_NODE_NOT_GROUP_OWNER',0x00001398)
    win_const_mgr.add_const('DEBUG_SESSION_HIBERNATE',0x00000006)
    win_const_mgr.add_const('MSGFLT_ADD',0x00000001)
    win_const_mgr.add_const('NIIF_HARDWARE_INTERFACE',0x00000001)
    win_const_mgr.add_const('VK_OEM_WSCTRL',0x000000EE)
    win_const_mgr.add_const('KRB_NT_X500_PRINCIPAL',0x00000006)
    win_const_mgr.add_const('ERROR_NODE_CANNOT_BE_CLUSTERED',0x0000170A)
    win_const_mgr.add_const('SPFILENOTIFY_COPYERROR',0x00000000)
    win_const_mgr.add_const('D3DPCMPCAPS_GREATEREQUAL',0x00000040)
    win_const_mgr.add_const('BS_DEFSPLITBUTTON',0x0000000D)
    win_const_mgr.add_const('D3DPBLENDCAPS_ONE',0x00000002)
    win_const_mgr.add_const('USER_FLAGS_PARMNUM',0x00000008)
    win_const_mgr.add_const('TCSBIN_PROTOCOL_UUID16',0x00000005)
    win_const_mgr.add_const('MCI_SEQ_STATUS_SLAVE',0x00004007)
    win_const_mgr.add_const('URLACTION_HTML_SUBMIT_FORMS',0x00001601)
    win_const_mgr.add_const('GDI_ERROR',0xFFFFFFFF)
    win_const_mgr.add_const('OLEUI_ERR_LOADTEMPLATEFAILURE',0x0000006F)
    win_const_mgr.add_const('PORT_REMOTEKIS',0x000000B9)
    win_const_mgr.add_const('PRIVACY_TEMPLATE_LOW',0x00000005)
    win_const_mgr.add_const('CERT_CHAIN_DISABLE_MY_PEER_TRUST',0x00000800)
    win_const_mgr.add_const('PDH_UNKNOWN_LOGSVC_COMMAND',0xC0000BD7)
    win_const_mgr.add_const('SDP_MAX_INQUIRY_SECONDS',0x0000003C)
    win_const_mgr.add_const('DISPID_SUBSCRIPTIONSENABLED',0x0000000A)
    win_const_mgr.add_const('LDAP_API_VERSION',0x000007D4)
    win_const_mgr.add_const('INTERNET_PRIORITY_FOREGROUND',0x000003E8)
    win_const_mgr.add_const('BLTALIGNMENT',0x00000077)
    win_const_mgr.add_const('LINEOPENOPTION_SINGLEADDRESS',0x80000000)
    win_const_mgr.add_const('DBPROP_INIT_IGNORECACHEDDATA',0x00000002)
    win_const_mgr.add_const('MAX_ISCSI_PORTAL_ALIAS_LEN',0x00000100)
    win_const_mgr.add_const('EN_SETFOCUS',0x00000100)
    win_const_mgr.add_const('OCSP_BASIC_GOOD_CERT_STATUS',0x00000000)
    win_const_mgr.add_const('CERT_ROOT_PROGRAM_NAME_CONSTRAINTS_PROP_ID',0x00000054)
    win_const_mgr.add_const('CD_LBSELCHANGE',0x00000000)
    win_const_mgr.add_const('PROCESS_VM_WRITE',0x00000020)
    win_const_mgr.add_const('OID_WAN_SET_COMP_INFO',0x0401020D)
    win_const_mgr.add_const('KERB_REQUEST_ADD_CREDENTIAL',0x00000001)
    win_const_mgr.add_const('DDCAPS2_COLORCONTROLPRIMARY',0x00000080)
    win_const_mgr.add_const('D3DFMT_A1_SURFACE_MAXWIDTH',0x00002000)
    win_const_mgr.add_const('SPINST_REGSVR',0x00000040)
    win_const_mgr.add_const('INT16_MAX',0x00007FFF)
    win_const_mgr.add_const('UNDNAME_NO_RETURN_UDT_MODEL',0x00000400)
    win_const_mgr.add_const('RTCEF_INFO',0x00001000)
    win_const_mgr.add_const('MM_DRVM_CLOSE',0x000003D1)
    win_const_mgr.add_const('PF_PAE_ENABLED',0x00000009)
    win_const_mgr.add_const('CR_PROP_CACERTVERSION',0x00000027)
    win_const_mgr.add_const('ERROR_DS_CANT_ON_RDN',0x00002016)
    win_const_mgr.add_const('ERRACT_IGNORE',0x00000006)
    win_const_mgr.add_const('D3DPRASTERCAPS_ANISOTROPY',0x00020000)
    win_const_mgr.add_const('SBSP_KEEPWORDWHEELTEXT',0x00040000)
    win_const_mgr.add_const('IDM_LINEBREAKLEFT',0x00000868)
    win_const_mgr.add_const('TB_PAGEUP',0x00000002)
    win_const_mgr.add_const('RES_SOFT_SEARCH',0x00000001)
    win_const_mgr.add_const('XP1_CONNECT_DATA',0x00000080)
    win_const_mgr.add_const('NCRYPT_IMPL_HARDWARE_FLAG',0x00000001)
    win_const_mgr.add_const('DISPID_FILEDOWNLOAD',0x0000010E)
    win_const_mgr.add_const('SPDRP_MAXIMUM_PROPERTY',0x00000024)
    win_const_mgr.add_const('GESTURE_UP_LEFT',0x00000000)
    win_const_mgr.add_const('L2_REASON_CODE_GROUP_SIZE',0x00010000)
    win_const_mgr.add_const('DLCTL_NO_BEHAVIORS',0x00008000)
    win_const_mgr.add_const('MFASYNC_CALLBACK_QUEUE_UNDEFINED',0x00000000)
    win_const_mgr.add_const('ALERT_SYSTEM_WARNING',0x00000002)
    win_const_mgr.add_const('SO_PROTOCOL_INFOA',0x00002004)
    win_const_mgr.add_const('ERROR_STACK_BUFFER_OVERRUN',0x00000502)
    win_const_mgr.add_const('DEBUG_CSS_PATHS',0x00000008)
    win_const_mgr.add_const('SECPKG_ATTR_REMOTE_CERTIFICATES',0x0000005F)
    win_const_mgr.add_const('IDM_SUNKEN',0x0000003E)
    win_const_mgr.add_const('DNS_RTYPE_PTR',0x00000000)
    win_const_mgr.add_const('NETE_NETBUSY',0x00000009)
    win_const_mgr.add_const('CAL_GREGORIAN_XLIT_FRENCH',0x0000000C)
    win_const_mgr.add_const('TAPE_LOCK',0x00000003)
    win_const_mgr.add_const('DBIMF_FIXED',0x00000001)
    win_const_mgr.add_const('DESKTOP_HOOKCONTROL',0x00000008)
    win_const_mgr.add_const('SPFEI_ALL_TTS_EVENTS',0x0000FFFE)
    win_const_mgr.add_const('MCW_SCREEN',0x00000004)
    win_const_mgr.add_const('IMAGE_REL_MIPS_REFLO',0x00000005)
    win_const_mgr.add_const('SO_PROTOCOL_INFOW',0x00002005)
    win_const_mgr.add_const('IF_TYPE_IPSWITCH',0x0000004E)
    win_const_mgr.add_const('SQL_API_SQLALLOCHANDLESTD',0x00000049)
    win_const_mgr.add_const('WTS_EVENT_STATECHANGE',0x00000080)
    win_const_mgr.add_const('DE_E_OBJECT_NOT_FOUND',0x800C0006)
    win_const_mgr.add_const('NIF_SHOWTIP',0x00000080)
    win_const_mgr.add_const('IDM_HELP_README',0x000008AE)
    win_const_mgr.add_const('CERT_DESCRIPTION_PROP_ID',0x0000000D)
    win_const_mgr.add_const('SQL_DT_CASCADE',0x00000004)
    win_const_mgr.add_const('NS_PNRPCLOUD',0x00000027)
    win_const_mgr.add_const('MM_WOM_OPEN',0x000003BB)
    win_const_mgr.add_const('WPWIZ_ERROR_FILE_NOT_FOUND',0xC0042008)
    win_const_mgr.add_const('DEBUG_FORMAT_USER_SMALL_FILTER_PATHS',0x00000040)
    win_const_mgr.add_const('VP_COMMAND_GET',0x00000001)
    win_const_mgr.add_const('EMR_COLORCORRECTPALETTE',0x0000006F)
    win_const_mgr.add_const('IF_TYPE_CNR',0x00000055)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_SYSTEM',0x80004000)
    win_const_mgr.add_const('CERT_CREATE_SELFSIGN_NO_SIGN',0x00000001)
    win_const_mgr.add_const('OID_FDDI_PATH_T_R_MODE',0x03030257)
    win_const_mgr.add_const('AM_CONTENTPROPERTY_DESCRIPTION',0x00000008)
    win_const_mgr.add_const('TF_CONVERSIONMODE_KATAKANA',0x00000002)
    win_const_mgr.add_const('ES_CONTINUOUS',0x80000000)
    win_const_mgr.add_const('ES_EX_NOCALLOLEINIT',0x01000000)
    win_const_mgr.add_const('GTL_NUMBYTES',0x00000010)
    win_const_mgr.add_const('MCI_VD_STATUS_MEDIA_TYPE',0x00004004)
    win_const_mgr.add_const('HTTP_LOG_FIELD_REFERER',0x00040000)
    win_const_mgr.add_const('USER_PASSWORD_PARMNUM',0x00000003)
    win_const_mgr.add_const('CERT_CHAIN_FIND_BY_ISSUER_CACHE_ONLY_FLAG',0x00008000)
    win_const_mgr.add_const('IMGTRANS_OPAQUE',0x20000000)
    win_const_mgr.add_const('DDCKEYCAPS_SRCOVERLAYCLRSPACE',0x00004000)
    win_const_mgr.add_const('VOLUME_NAME_NONE',0x00000004)
    win_const_mgr.add_const('TXTBIT_MULTILINE',0x00000002)
    win_const_mgr.add_const('GPO_SECTION_MACHINE',0x00000002)
    win_const_mgr.add_const('ODT_TAB',0x00000065)
    win_const_mgr.add_const('IPPROTO_MAX',0x00000100)
    win_const_mgr.add_const('PSINJECT_PAGESATEND',0x00000003)
    win_const_mgr.add_const('ERROR_DS_AUTHORIZATION_FAILED',0x00002197)
    win_const_mgr.add_const('AM_GBF_NOWAIT',0x00000004)
    win_const_mgr.add_const('QUERYASMINFO_FLAG_VALIDATE',0x00000001)
    win_const_mgr.add_const('ERROR_DS_NCNAME_MUST_BE_NC',0x000020A5)
    win_const_mgr.add_const('SBS_LEFTALIGN',0x00000002)
    win_const_mgr.add_const('IOCTL_IP_INTERFACE_INFO',0x00000068)
    win_const_mgr.add_const('PCMCIA_OPT_NO_SOUND',0x00000008)
    win_const_mgr.add_const('BELOW_NORMAL_PRIORITY_CLASS',0x00004000)
    win_const_mgr.add_const('OS_SMALLBUSINESSSERVER',0x00000020)
    win_const_mgr.add_const('IMGCHG_MASK',0x0000000F)
    win_const_mgr.add_const('NDIS_PACKET_TYPE_ALL_MULTICAST',0x00000004)
    win_const_mgr.add_const('IMAGE_WEAK_EXTERN_SEARCH_LIBRARY',0x00000002)
    win_const_mgr.add_const('CERT_FIND_EXT_ONLY_ENHKEY_USAGE_FLAG',0x00000002)
    win_const_mgr.add_const('DBPROPVAL_SU_PRIVILEGE_DEFINITION',0x00000008)
    win_const_mgr.add_const('PKEY_PIDSTR_MAX',0x0000000A)
    win_const_mgr.add_const('MDMEMBER_TYPE_RESERVE4',0x00000008)
    win_const_mgr.add_const('DEBUG_STACK_NONVOLATILE_REGISTERS',0x00000020)
    win_const_mgr.add_const('MDMEMBER_TYPE_RESERVE1',0x00000005)
    win_const_mgr.add_const('DEBUG_ENGOPT_SYNCHRONIZE_BREAKPOINTS',0x00000800)
    win_const_mgr.add_const('MDMEMBER_TYPE_RESERVE3',0x00000007)
    win_const_mgr.add_const('MDMEMBER_TYPE_RESERVE2',0x00000006)
    win_const_mgr.add_const('MAX_TRANSPORT_NAME_LEN',0x00000028)
    win_const_mgr.add_const('PAN_MIDLINE_LOW_TRIMMED',0x0000000B)
    win_const_mgr.add_const('ECOOP_AND',0x00000003)
    win_const_mgr.add_const('NERR_BASE',0x00000834)
    win_const_mgr.add_const('LR_DEFAULTCOLOR',0x00000000)
    win_const_mgr.add_const('ASN_PRIVATE',0x000000C0)
    win_const_mgr.add_const('CAP_ATAPI_ID_CMD',0x00000002)
    win_const_mgr.add_const('FEI_RECEIVING',0x00000003)
    win_const_mgr.add_const('WIA_NUM_IPC',0x00000009)
    win_const_mgr.add_const('NTDSTRANSPORT_OPT_IGNORE_SCHEDULES',0x00000001)
    win_const_mgr.add_const('IMAGE_SCN_MEM_WRITE',0x80000000)
    win_const_mgr.add_const('DM_COLOR',0x00000800)
    win_const_mgr.add_const('FEI_NO_ANSWER',0x00000006)
    win_const_mgr.add_const('ACM_METRIC_MAX_SIZE_FORMAT',0x00000032)
    win_const_mgr.add_const('ADS_PRINTER_PENDING_DELETION',0x00000002)
    win_const_mgr.add_const('CERT_LOGOTYPE_NO_IMAGE_RESOLUTION_CHOICE',0x00000000)
    win_const_mgr.add_const('SCF_WORD',0x00000002)
    win_const_mgr.add_const('SV_DISKALERT_PARMNUM',0x00000029)
    win_const_mgr.add_const('IDM_TOOLBARS',0x00000852)
    win_const_mgr.add_const('SYSAUDIO_FLAGS_CLEAR_PREFERRED',0x00000002)
    win_const_mgr.add_const('RIDEV_EXINPUTSINK',0x00001000)
    win_const_mgr.add_const('CTRY_KENYA',0x000000FE)
    win_const_mgr.add_const('IDM_INSFIELDSET',0x00000847)
    win_const_mgr.add_const('DRM_SIGN_OFFLINE',0x00000002)
    win_const_mgr.add_const('SQL_TYPE_TIMESTAMP',0x0000005D)
    win_const_mgr.add_const('TIME_KILL_SYNCHRONOUS',0x00000100)
    win_const_mgr.add_const('CMSG_ENCRYPTED',0x00000006)
    win_const_mgr.add_const('CONTROLLED_LOAD_SERV',0x00000005)
    win_const_mgr.add_const('JOY_POVLEFT',0x00006978)
    win_const_mgr.add_const('LINEAGENTSESSIONSTATUS_NEWSESSION',0x00000001)
    win_const_mgr.add_const('ERROR_XML_PARSE_ERROR',0x000005B9)
    win_const_mgr.add_const('SPFILENOTIFY_ENDBACKUP',0x00000017)
    win_const_mgr.add_const('BF_BOTTOM',0x00000008)
    win_const_mgr.add_const('DISPID_DELTA',0x00000032)
    win_const_mgr.add_const('RPC_NCA_FLAGS_MAYBE',0x00000004)
    win_const_mgr.add_const('OID_CO_GET_ADDRESSES',0xFE000006)
    win_const_mgr.add_const('PFM_LINESPACING',0x00000100)
    win_const_mgr.add_const('NRC_LOCTFUL',0x00000011)
    win_const_mgr.add_const('DNS_ERROR_NEED_WINS_SERVERS',0x00002590)
    win_const_mgr.add_const('NRC_ENVNOTDEF',0x00000034)
    win_const_mgr.add_const('WKSTA_CHARCOUNT_PARMNUM',0x0000000C)
    win_const_mgr.add_const('DMDUP_SIMPLEX',0x00000001)
    win_const_mgr.add_const('DEBUG_BREAKPOINT_ENABLED',0x00000004)
    win_const_mgr.add_const('RPC_C_MQ_EXPRESS',0x00000000)
    win_const_mgr.add_const('R2_WHITE',0x00000010)
    win_const_mgr.add_const('ERROR_DDE_FAIL',0x00000484)
    win_const_mgr.add_const('DDD_LUID_BROADCAST_DRIVE',0x00000010)
    win_const_mgr.add_const('OVERRIDE_LOG_CONF',0x00000005)
    win_const_mgr.add_const('OID_FDDI_PORT_MAC_PLACEMENT',0x03030262)
    win_const_mgr.add_const('PIDMSI_EDITOR',0x00000002)
    win_const_mgr.add_const('SQL_DROP_COLLATION',0x0000008A)
    win_const_mgr.add_const('D3DSP_DSTSHIFT_MASK',0x0F000000)
    win_const_mgr.add_const('DMDITHER_RESERVED7',0x00000007)
    win_const_mgr.add_const('DEX_IDS_INVALID_DXT',0x00000583)
    win_const_mgr.add_const('LINEMEDIACONTROL_NONE',0x00000001)
    win_const_mgr.add_const('SPI_SETMENUFADE',0x00001013)
    win_const_mgr.add_const('DSOP_FILTER_UNIVERSAL_GROUPS_DL',0x00000010)
    win_const_mgr.add_const('STGFMT_STORAGE',0x00000000)
    win_const_mgr.add_const('ERROR_CLUSTER_GROUP_MOVING',0x00001714)
    win_const_mgr.add_const('DEBUG_ENGOPT_INITIAL_BREAK',0x00000020)
    win_const_mgr.add_const('CACHEGROUP_SEARCH_BYURL',0x00000001)
    win_const_mgr.add_const('DMDITHER_RESERVED8',0x00000008)
    win_const_mgr.add_const('PHONEERR_REQUESTOVERRUN',0x90000020)
    win_const_mgr.add_const('EM_SCROLLCARET',0x000000B7)
    win_const_mgr.add_const('IMAGE_DLLCHARACTERISTICS_FORCE_INTEGRITY',0x00000080)
    win_const_mgr.add_const('ERROR_OVERRIDE_NOCHANGES',0x000004E4)
    win_const_mgr.add_const('LR_LOADTRANSPARENT',0x00000020)
    win_const_mgr.add_const('SUBLANG_GREEK_GREECE',0x00000001)
    win_const_mgr.add_const('DISPID_NSCOLUMNS',0x00000015)
    win_const_mgr.add_const('MAPI_DEFAULT_STORE',0x00000001)
    win_const_mgr.add_const('PHOTO_EXPOSUREPROGRAM_UNKNOWN',0x00000000)
    win_const_mgr.add_const('CRYPT_RDN_ATTR_OID_GROUP_ID',0x00000005)
    win_const_mgr.add_const('PHYSICAL_SALEVENTRESOURCE_OFFSET',0x0000001F)
    win_const_mgr.add_const('INTERNET_AUTOPROXY_INIT_DOWNLOADSYNC',0x00000002)
    win_const_mgr.add_const('ALG_CLASS_KEY_EXCHANGE',0x00000005)
    win_const_mgr.add_const('DFCS_MENUCHECK',0x00000001)
    win_const_mgr.add_const('NWF_MANDATORY_OID',0x00000001)
    win_const_mgr.add_const('MCI_DGV_STATUS_WINDOW_MAXIMIZED',0x00004023)
    win_const_mgr.add_const('MINSHORT',0x00008000)
    win_const_mgr.add_const('SO_SNDTIMEO',0x00001005)
    win_const_mgr.add_const('IMAGE_REL_EBC_SECREL',0x00000004)
    win_const_mgr.add_const('DWM_BB_ENABLE',0x00000001)
    win_const_mgr.add_const('CTRY_NEW_ZEALAND',0x00000040)
    win_const_mgr.add_const('CHANGER_VOLUME_ASSERT',0x00400000)
    win_const_mgr.add_const('MAXERRORLENGTH',0x00000100)
    win_const_mgr.add_const('EVENT_OBJECT_HELPCHANGE',0x00008010)
    win_const_mgr.add_const('TTFCFP_SUBSET',0x00000000)
    win_const_mgr.add_const('SUB_OBJECTS_ONLY_INHERIT',0x00000001)
    win_const_mgr.add_const('LINEERR_REINIT',0x80000052)
    win_const_mgr.add_const('DDBLT_ZBUFFERSRCOVERRIDE',0x00800000)
    win_const_mgr.add_const('SUBLANG_ENGLISH_AUS',0x00000003)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_OTHERDRIVER',0x00000000)
    win_const_mgr.add_const('WARNING_IPSEC_MM_POLICY_PRUNED',0x000032E0)
    win_const_mgr.add_const('TMT_HALIGN',0x00000FA5)
    win_const_mgr.add_const('LINEERR_INVALAGENTACTIVITY',0x8000005B)
    win_const_mgr.add_const('CM_REGISTER_DEVICE_DRIVER_BITS',0x00000003)
    win_const_mgr.add_const('TPM_VERNEGANIMATION',0x00002000)
    win_const_mgr.add_const('STRING_NAME_OFFSET',0x00000000)
    win_const_mgr.add_const('SIZEOF_RFPO_DATA',0x00000010)
    win_const_mgr.add_const('DTT_COMPOSITED',0x00000001)
    win_const_mgr.add_const('RESOURCETYPE_ANY',0x00000000)
    win_const_mgr.add_const('NETLOGON_CONTROL_TC_QUERY',0x00000006)
    win_const_mgr.add_const('EMR_FILLRGN',0x00000047)
    win_const_mgr.add_const('LANG_WOLOF',0x00000088)
    win_const_mgr.add_const('OID_FDDI_PATH_TRACE_STATUS',0x03030253)
    win_const_mgr.add_const('SV_TYPE_DIALIN_SERVER',0x00000400)
    win_const_mgr.add_const('TAPE_DRIVE_WRITE_PROTECT',0x00001000)
    win_const_mgr.add_const('KAGPROPVAL_CONCUR_VALUES',0x00000002)
    win_const_mgr.add_const('BLKHOLE_BASETYPE',0x00000001)
    win_const_mgr.add_const('GCS_CURSORPOS',0x00000080)
    win_const_mgr.add_const('META_RESIZEPALETTE',0x00000139)
    win_const_mgr.add_const('SQL_API_SQLDISCONNECT',0x00000009)
    win_const_mgr.add_const('SE_DACL_AUTO_INHERIT_REQ',0x00000100)
    win_const_mgr.add_const('WS_EX_NOACTIVATE',0x08000000)
    win_const_mgr.add_const('DI_NOVCP',0x00000008)
    win_const_mgr.add_const('HSHELL_WINDOWREPLACING',0x0000000E)
    win_const_mgr.add_const('LPM_PE_USER_IDENTITY',0x00000002)
    win_const_mgr.add_const('OCR_ICOCUR',0x00007F87)
    win_const_mgr.add_const('DI_ROPS_READ_DESTINATION',0x00000002)
    win_const_mgr.add_const('UNDERSTANDS_LONG_NAMES',0x00000001)
    win_const_mgr.add_const('STAT_CONTENT_OUT_OF_DATE',0x00000020)
    win_const_mgr.add_const('CTRY_EL_SALVADOR',0x000001F7)
    win_const_mgr.add_const('OID_GEN_RCV_ERROR',0x00020104)
    win_const_mgr.add_const('ULONGLONG_MAX',0x00000000)
    win_const_mgr.add_const('ES_READONLY',0x00000800)
    win_const_mgr.add_const('DISPID_IWRITEENGINE2EVENTARGS_LASTREADLBA',0x00000102)
    win_const_mgr.add_const('DEBUG_REGISTERS_ALL',0x00000007)
    win_const_mgr.add_const('ERROR_DBG_TERMINATE_PROCESS',0x000002B4)
    win_const_mgr.add_const('MCI_FORMAT_BYTES',0x00000008)
    win_const_mgr.add_const('MSV1_0_SUBAUTH_ACCOUNT_EXPIRY',0x00000010)
    win_const_mgr.add_const('PRIVACY_TEMPLATE_HIGH',0x00000001)
    win_const_mgr.add_const('PSPCB_ADDREF',0x00000000)
    win_const_mgr.add_const('ERROR_ALREADY_WAITING',0x00000770)
    win_const_mgr.add_const('SHARE_PERMISSIONS_PARMNUM',0x00000005)
    win_const_mgr.add_const('KLF_SUBSTITUTE_OK',0x00000002)
    win_const_mgr.add_const('IDM_SCROLL_PAGERIGHT',0x00000956)
    win_const_mgr.add_const('EMR_ARC',0x0000002D)
    win_const_mgr.add_const('XP1_SAN_SUPPORT_SDP',0x00080000)
    win_const_mgr.add_const('CR_PROP_CAXCHGCERTCOUNT',0x0000000E)
    win_const_mgr.add_const('RPC_BHO_DONTLINGER',0x00000002)
    win_const_mgr.add_const('DNS_TYPE_ISDN',0x00000014)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2TAO_DONOTFINALIZEMEDIA',0x00000107)
    win_const_mgr.add_const('DNS_TYPE_IXFR',0x00000000)
    win_const_mgr.add_const('IASSEMBLYCACHE_UNINSTALL_DISPOSITION_DELETE_PENDING',0x00000004)
    win_const_mgr.add_const('AA_A_OPEN',0x00001000)
    win_const_mgr.add_const('SE_ERR_ASSOCINCOMPLETE',0x0000001B)
    win_const_mgr.add_const('IF_TYPE_RFC877_X25',0x00000005)
    win_const_mgr.add_const('EN_DROPFILES',0x00000703)
    win_const_mgr.add_const('DXVA_EXECUTE_RETURN_DATA_ERROR_SEVERE',0x00000003)
    win_const_mgr.add_const('SECPKG_NEGOTIATION_IN_PROGRESS',0x00000002)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_CLIENT_CHIMNEY_OFFLOAD_CHARACTERISTICS',0x00000093)
    win_const_mgr.add_const('DTS_SHOWNONE',0x00000002)
    win_const_mgr.add_const('CLIP_SUS',0x00000020)
    win_const_mgr.add_const('CONNECT_UPDATE_RECENT',0x00000002)
    win_const_mgr.add_const('IDC_CI_CURRENTICON',0x0000007A)
    win_const_mgr.add_const('RI_KEY_MAKE',0x00000000)
    win_const_mgr.add_const('CREATE_FOR_DIR',0x00000002)
    win_const_mgr.add_const('MCI_VCR_SIGNAL_EVERY',0x00020000)
    win_const_mgr.add_const('SQL_ROW_UPDATED',0x00000002)
    win_const_mgr.add_const('WIA_PROPPAGE_CAMERA_ITEM_GENERAL',0x00000002)
    win_const_mgr.add_const('RTL_RESOURCE_TYPE',0x00000001)
    win_const_mgr.add_const('VFT_DLL',0x00000002)
    win_const_mgr.add_const('PERF_DETAIL_WIZARD',0x00000190)
    win_const_mgr.add_const('OBM_LFARROWI',0x00007FDE)
    win_const_mgr.add_const('FF_ROMAN',0x00000001)
    win_const_mgr.add_const('REGDB_S_FIRST',0x00040150)
    win_const_mgr.add_const('MIXERLINE_LINEF_DISCONNECTED',0x00008000)
    win_const_mgr.add_const('CRLF_DELETE_EXPIRED_CRLS',0x00000002)
    win_const_mgr.add_const('PRIMARY_CRED_LOGON_LUA',0x00000020)
    win_const_mgr.add_const('PD_CURRENTPAGE',0x00400000)
    win_const_mgr.add_const('SQL_FETCH_LAST',0x00000003)
    win_const_mgr.add_const('LVIF_GROUPID',0x00000100)
    win_const_mgr.add_const('SQL_ROW_UPDATES',0x0000000B)
    win_const_mgr.add_const('SFVS_SELECT_ALLITEMS',0x00000001)
    win_const_mgr.add_const('XP1_QOS_SUPPORTED',0x00002000)
    win_const_mgr.add_const('SERVICETYPE_NONCONFORMING',0x00000009)
    win_const_mgr.add_const('LANG_PORTUGUESE',0x00000016)
    win_const_mgr.add_const('DPNHCAPSFLAG_GATEWAYPRESENT',0x00000002)
    win_const_mgr.add_const('CDBOSC_RENAME',0x00000003)
    win_const_mgr.add_const('FINDDLGORD',0x00000604)
    win_const_mgr.add_const('AF_IMPLINK',0x00000003)
    win_const_mgr.add_const('TF_COMMANDING_ON',0x00000008)
    win_const_mgr.add_const('WM_SYNCPAINT',0x00000088)
    win_const_mgr.add_const('SCARD_E_SERVICE_STOPPED',0x8010001E)
    win_const_mgr.add_const('PROOF_QUALITY',0x00000002)
    win_const_mgr.add_const('PROC_THREAD_ATTRIBUTE_REPLACE_VALUE',0x00000001)
    win_const_mgr.add_const('SQL_ATTR_CONNECTION_POOLING',0x000000C9)
    win_const_mgr.add_const('HANDLE_PARAM_IS_VIA_PTR',0x00000080)
    win_const_mgr.add_const('URLACTION_LOWRIGHTS',0x00002500)
    win_const_mgr.add_const('COD_PERIPHERAL_MINOR_GAMEPAD',0x00000002)
    win_const_mgr.add_const('USER_HOME_DIRECTORY_REQUIRED',0x00000002)
    win_const_mgr.add_const('SV_OPENSEARCH_PARMNUM',0x000001F7)
    win_const_mgr.add_const('WCT_OUT_OF_PROC_CS_FLAG',0x00000004)
    win_const_mgr.add_const('OBJ_EXTPEN',0x0000000B)
    win_const_mgr.add_const('ERROR_GROUP_NOT_AVAILABLE',0x00001394)
    win_const_mgr.add_const('L2_REASON_CODE_PROFILE_MISSING',0x00000001)
    win_const_mgr.add_const('ERROR_JOURNAL_HOOK_SET',0x00000596)
    win_const_mgr.add_const('USER_PRIV_ADMIN',0x00000002)
    win_const_mgr.add_const('MS_INVERTCOLORS',0x00000004)
    win_const_mgr.add_const('SQL_CP_STRICT_MATCH',0x00000000)
    win_const_mgr.add_const('VAR_TIMEVALUEONLY',0x00000001)
    win_const_mgr.add_const('VPDF_DISABLEPWRMGMT',0x00000001)
    win_const_mgr.add_const('QOSSPBASE',0x0000C350)
    win_const_mgr.add_const('IDC_CI_DEFAULTICON',0x0000007C)
    win_const_mgr.add_const('CERT_REGISTRY_STORE_REMOTE_FLAG',0x00010000)
    win_const_mgr.add_const('SIC_COMPLEX',0x00000001)
    win_const_mgr.add_const('ERROR_INTERNAL_DB_ERROR',0x00000567)
    win_const_mgr.add_const('DRMHANDLE_INVALID',0x00000000)
    win_const_mgr.add_const('LBER_ERROR',0x00000000)
    win_const_mgr.add_const('MCI_VCR_STATUS_VIDEO',0x00004025)
    win_const_mgr.add_const('URLPOLICY_CHANNEL_SOFTDIST_PRECACHE',0x00020000)
    win_const_mgr.add_const('DV_HD',0x00000001)
    win_const_mgr.add_const('ERROR_NETNAME_DELETED',0x00000040)
    win_const_mgr.add_const('PIFDEFPATHSIZE',0x00000040)
    win_const_mgr.add_const('IDM_ISTRUSTEDDLG',0x00000934)
    win_const_mgr.add_const('APPSTATUS_NOTDEFINED',0x00000002)
    win_const_mgr.add_const('MNS_AUTODISMISS',0x10000000)
    win_const_mgr.add_const('STDOLE_MINORVERNUM',0x00000000)
    win_const_mgr.add_const('COLORONCOLOR',0x00000003)
    win_const_mgr.add_const('IPPORT_RESERVED',0x00000400)
    win_const_mgr.add_const('WINDING',0x00000002)
    win_const_mgr.add_const('MAX_KNOWN_INK_ANALYSIS_GUID_INDEX',0x00000080)
    win_const_mgr.add_const('EMARCH_ENC_I17_SIGN_INST_WORD_X',0x00000003)
    win_const_mgr.add_const('CBEIF_INDENT',0x00000010)
    win_const_mgr.add_const('DEVICE_DEFAULT_FONT',0x0000000E)
    win_const_mgr.add_const('IDC_LP_UPDATENOW',0x000003EF)
    win_const_mgr.add_const('IDC_GP_OBJECTLOCATION',0x000003FE)
    win_const_mgr.add_const('GESTURE_DOWN_LEFT',0x00000000)
    win_const_mgr.add_const('ERROR_LB_WITHOUT_TABSTOPS',0x0000059A)
    win_const_mgr.add_const('WMDM_DEVICE_TYPE_RECORD',0x00000002)
    win_const_mgr.add_const('ERROR_FAILED_DRIVER_ENTRY',0x00000287)
    win_const_mgr.add_const('DBPROPVAL_NP_FAILEDTODO',0x00000008)
    win_const_mgr.add_const('SUBLANG_BENGALI_INDIA',0x00000001)
    win_const_mgr.add_const('IMAGE_COMPRESSION_CCITT_T6',0x00000004)
    win_const_mgr.add_const('SOCKET_SETTINGS_GUARANTEE_ENCRYPTION',0x00000001)
    win_const_mgr.add_const('IMAGE_COMPRESSION_CCITT_T4',0x00000003)
    win_const_mgr.add_const('IMAGE_COMPRESSION_CCITT_T3',0x00000002)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_PROCESS_ERR_PROP',0x00003607)
    win_const_mgr.add_const('NTMS_COMPUTERNAME_LENGTH',0x00000040)
    win_const_mgr.add_const('IT_STATUS_TRANSFER_TO_CLIENT',0x00000004)
    win_const_mgr.add_const('DEVPROP_MASK_TYPE',0x00000FFF)
    win_const_mgr.add_const('LDAP_OPT_AREC_EXCLUSIVE',0x00000098)
    win_const_mgr.add_const('PHONEERR_INVALBUTTONSTATE',0x9000000B)
    win_const_mgr.add_const('PRINTER_STATUS_INITIALIZING',0x00008000)
    win_const_mgr.add_const('MB_DEFBUTTON4',0x00000300)
    win_const_mgr.add_const('ICC_BAR_CLASSES',0x00000004)
    win_const_mgr.add_const('RESTORE',0x00000006)
    win_const_mgr.add_const('KP_PRECOMP_SHA',0x00000019)
    win_const_mgr.add_const('IEIFLAG_ORIGSIZE',0x00000040)
    win_const_mgr.add_const('OFN_EXTENSIONDIFFERENT',0x00000400)
    win_const_mgr.add_const('D3DFVF_XYZW',0x00004002)
    win_const_mgr.add_const('ERROR_CLUSTER_INSTANCE_ID_MISMATCH',0x00001705)
    win_const_mgr.add_const('DEBUG_SYMINFO_BREAKPOINT_SOURCE_LINE',0x00000000)
    win_const_mgr.add_const('NIS_HIDDEN',0x00000001)
    win_const_mgr.add_const('SQL_FB_ON',0x00000001)
    win_const_mgr.add_const('SYMF_OMAP_GENERATED',0x00000001)
    win_const_mgr.add_const('DEBUG_OUTPUT_WARNING',0x00000004)
    win_const_mgr.add_const('SQL_DV_RESTRICT',0x00000002)
    win_const_mgr.add_const('ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY',0x00003ABC)
    win_const_mgr.add_const('FD_MAX_EVENTS',0x0000000A)
    win_const_mgr.add_const('RBS_VARHEIGHT',0x00000200)
    win_const_mgr.add_const('BF_MONO',0x00008000)
    win_const_mgr.add_const('SO_MAXDG',0x00007009)
    win_const_mgr.add_const('TARGET_IS_NT60_OR_LATER',0x00000000)
    win_const_mgr.add_const('SV_COMMENT_PARMNUM',0x00000005)
    win_const_mgr.add_const('PRINTER_ENUM_EXPAND',0x00004000)
    win_const_mgr.add_const('SO_BTH_MTU',0x80000007)
    win_const_mgr.add_const('WLAN_CONNECTION_NOTIFICATION_ADHOC_NETWORK_FORMED',0x00000001)
    win_const_mgr.add_const('SERVICE_LOCAL',0x00000004)
    win_const_mgr.add_const('KF_EXTENDED',0x00000100)
    win_const_mgr.add_const('USER_MAX_STORAGE_PARMNUM',0x00000012)
    win_const_mgr.add_const('REG_BINARY',0x00000003)
    win_const_mgr.add_const('LINEDEVSTATE_CLOSE',0x00000400)
    win_const_mgr.add_const('GL_LEVEL_INFORMATION',0x00000004)
    win_const_mgr.add_const('NDIS_RING_TRANSMIT_BEACON',0x00001000)
    win_const_mgr.add_const('EC_STREAM_ERROR_STOPPED',0x00000006)
    win_const_mgr.add_const('MCI_OVLY_WINDOW_STATE',0x00040000)
    win_const_mgr.add_const('BTH_MFG_MANSELLA',0x00000021)
    win_const_mgr.add_const('DAO_MAXSEEKFIELDS',0x0000000D)
    win_const_mgr.add_const('SHGVSPB_ALLUSERS',0x00000002)
    win_const_mgr.add_const('ACM_METRIC_COUNT_DRIVERS',0x00000001)
    win_const_mgr.add_const('DISPLAYDIB_TEST',0x00000400)
    win_const_mgr.add_const('EMARCH_ENC_I17_IMM9D_INST_WORD_POS_X',0x00000012)
    win_const_mgr.add_const('SWP_SHOWWINDOW',0x00000040)
    win_const_mgr.add_const('LVS_ICON',0x00000000)
    win_const_mgr.add_const('PHOTO_ORIENTATION_ROTATE180',0x00000003)
    win_const_mgr.add_const('RPC_C_OPT_MQ_TIME_TO_BE_RECEIVED',0x00000008)
    win_const_mgr.add_const('SQL_FN_TD_TIMESTAMPDIFF',0x00004000)
    win_const_mgr.add_const('SHDID_COMPUTER_REMOVABLE',0x00000007)
    win_const_mgr.add_const('HTTP_QUERY_ACCEPT_ENCODING',0x0000001A)
    win_const_mgr.add_const('CM_DISABLE_POLITE',0x00000000)
    win_const_mgr.add_const('IPV6_UNICAST_HOPS',0x00000004)
    win_const_mgr.add_const('GIL_DEFAULTICON',0x00000040)
    win_const_mgr.add_const('LANG_MACEDONIAN',0x00000002)
    win_const_mgr.add_const('PHONEHOOKSWITCHMODE_UNKNOWN',0x00000010)
    win_const_mgr.add_const('RECO_DRAG',0x00000004)
    win_const_mgr.add_const('SQL_INDEX_OTHER',0x00000003)
    win_const_mgr.add_const('ACTRL_DS_LIST_OBJECT',0x00000080)
    win_const_mgr.add_const('MCI_QUALITY_HANDLE',0x00100000)
    win_const_mgr.add_const('KAGPROP_ACTIVESTATEMENTS',0x00000018)
    win_const_mgr.add_const('DL_STOPCURSOR',0x00000001)
    win_const_mgr.add_const('KRAF_ENABLEFOREIGN',0x00000001)
    win_const_mgr.add_const('EC_USERABORT',0x00000002)
    win_const_mgr.add_const('MCI_DGV_STATUS_KEY_INDEX',0x00004024)
    win_const_mgr.add_const('SECURITY_FLAG_SSL3',0x00000004)
    win_const_mgr.add_const('WSAENOPROTOOPT',0x0000273A)
    win_const_mgr.add_const('WEBPOST_ERROR_SITE_EXISTS',0xC0042109)
    win_const_mgr.add_const('DI_FLAGSEX_FILTERSIMILARDRIVERS',0x02000000)
    win_const_mgr.add_const('RESOURCEUSAGE_ATTACHED',0x00000010)
    win_const_mgr.add_const('ACTIVATION_CONTEXT_PATH_TYPE_WIN32_FILE',0x00000002)
    win_const_mgr.add_const('KP_GET_USE_COUNT',0x0000002A)
    win_const_mgr.add_const('SPI_SETFONTSMOOTHINGTYPE',0x0000200B)
    win_const_mgr.add_const('OID_802_3_CURRENT_ADDRESS',0x01010102)
    win_const_mgr.add_const('SQL_PC_OFF',0x00000000)
    win_const_mgr.add_const('OID_FDDI_SMT_USER_DATA',0x03030206)
    win_const_mgr.add_const('TABLET_DISABLE_TOUCHUIFORCEOFF',0x00000200)
    win_const_mgr.add_const('CM_DRP_UI_NUMBER',0x00000011)
    win_const_mgr.add_const('TVS_NOTOOLTIPS',0x00000080)
    win_const_mgr.add_const('WKSTA_CHARWAIT_PARMNUM',0x0000000A)
    win_const_mgr.add_const('CM_DRP_CLASS',0x00000008)
    win_const_mgr.add_const('FCIDM_BROWSERLAST',0x00000000)
    win_const_mgr.add_const('ERROR_DS_SCHEMA_NOT_LOADED',0x000020DE)
    win_const_mgr.add_const('DS_REPDEL_ASYNCHRONOUS_OPERATION',0x00000001)
    win_const_mgr.add_const('WINEVENT_KEYWORD_RESERVED_48',0x1000000000000)
    win_const_mgr.add_const('PHOTO_FLASH_WITHSTROBE',0x00000007)
    win_const_mgr.add_const('DISKQUOTA_FILESTATE_MASK',0x00000300)
    win_const_mgr.add_const('FILE_UNICODE_ON_DISK',0x00000004)
    win_const_mgr.add_const('RPC_C_AUTHN_LEVEL_PKT_PRIVACY',0x00000006)
    win_const_mgr.add_const('MSIDXSPROP_COMMAND_LOCALE_STRING',0x00000003)
    win_const_mgr.add_const('DBG_ATTACH',0x0000000E)
    win_const_mgr.add_const('STGM_READWRITE',0x00000002)
    win_const_mgr.add_const('DEBUG_SESSION_REBOOT',0x00000005)
    win_const_mgr.add_const('PHOTO_EXPOSUREPROGRAM_NORMAL',0x00000002)
    win_const_mgr.add_const('EMR_RESERVED_105',0x00000069)
    win_const_mgr.add_const('HH_DISPLAY_INDEX',0x00000002)
    win_const_mgr.add_const('CM_DRP_FRIENDLYNAME',0x0000000D)
    win_const_mgr.add_const('NTDSCONN_KCC_INTERSITE_TOPOLOGY',0x00000001)
    win_const_mgr.add_const('JOB_NOTIFY_FIELD_POSITION',0x0000000F)
    win_const_mgr.add_const('GESTURE_ASTERISK',0x00000000)
    win_const_mgr.add_const('SMART_NO_IDE_DEVICE',0x0000000A)
    win_const_mgr.add_const('CERT_PVK_FILE_PROP_ID',0x0000000C)
    win_const_mgr.add_const('FWP_CALLOUT_FLAG_CONDITIONAL_ON_FLOW',0x00000001)
    win_const_mgr.add_const('SHGNLI_NOLOCNAME',0x00000010)
    win_const_mgr.add_const('AM_DVD_COPYRIGHT_MASK',0x00000040)
    win_const_mgr.add_const('BLLI_L3_PACKET_64',0x00000006)
    win_const_mgr.add_const('TRANSACTIONMANAGER_RECOVER',0x00000004)
    win_const_mgr.add_const('ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY',0x000000D9)
    win_const_mgr.add_const('IF_TYPE_CCTEMUL',0x0000003D)
    win_const_mgr.add_const('POLICY_QOS_OUTBOUND_INTEGRITY',0x00000002)
    win_const_mgr.add_const('IPP_E_UNSYNCHRONIZED',0xC0048008)
    win_const_mgr.add_const('SRRF_RM_NORMAL',0x00010000)
    win_const_mgr.add_const('CORDLESS_EXTERNAL_NETWORK_OTHER',0x00000007)
    win_const_mgr.add_const('IF_TYPE_HIPPI',0x0000002F)
    win_const_mgr.add_const('HTTP_NULL_ID',0x00000000)
    win_const_mgr.add_const('EMR_INTERSECTCLIPRECT',0x0000001E)
    win_const_mgr.add_const('LINECALLPARAMFLAGS_IDLE',0x00000002)
    win_const_mgr.add_const('MIIM_STRING',0x00000040)
    win_const_mgr.add_const('DBPROPVAL_GB_CONTAINS_SELECT',0x00000004)
    win_const_mgr.add_const('ACS_TRANSPARENT',0x00000002)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_REGCREATE',0x0000000A)
    win_const_mgr.add_const('AD_GETWP_LAST_APPLIED',0x00000002)
    win_const_mgr.add_const('WTNCA_NOSYSMENU',0x00000004)
    win_const_mgr.add_const('CERT_COMPARE_CERT_ID',0x00000010)
    win_const_mgr.add_const('FPSR_I0',0x00000012)
    win_const_mgr.add_const('SQL_SS_ADDITIONS',0x00000001)
    win_const_mgr.add_const('ODBC_ERROR_INVALID_NAME',0x00000007)
    win_const_mgr.add_const('LINECALLSTATE_CONNECTED',0x00000100)
    win_const_mgr.add_const('FPSR_I1',0x0000001F)
    win_const_mgr.add_const('FACILITY_TERMINAL_SERVER',0x0000000A)
    win_const_mgr.add_const('MCI_VCR_STEP_REVERSE',0x00020000)
    win_const_mgr.add_const('SQL_CDO_CONSTRAINT_NON_DEFERRABLE',0x00000100)
    win_const_mgr.add_const('JOY_BUTTON30',0x20000000)
    win_const_mgr.add_const('JOY_BUTTON31',0x40000000)
    win_const_mgr.add_const('JOY_BUTTON32',0x80000000)
    win_const_mgr.add_const('TTFMFP_SUBSET1',0x00000001)
    win_const_mgr.add_const('FR_NOMATCHCASE',0x00000800)
    win_const_mgr.add_const('PSINJECT_BEGINSETUP',0x00000010)
    win_const_mgr.add_const('SELECT_CAP_SENTENCE',0x00000002)
    win_const_mgr.add_const('DBPROPVAL_SQL_FIPS_TRANSITIONAL',0x00000020)
    win_const_mgr.add_const('WPP_POST_POSTING_NO_RESPONSE_ERROR',0xC0042383)
    win_const_mgr.add_const('NETLOGON_CONTROL_REPLICATE',0x00000002)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_GPRELHI',0x00000017)
    win_const_mgr.add_const('LDAP_SUBSTRING_INITIAL',0x00000080)
    win_const_mgr.add_const('OID_FDDI_SMT_TRACE_MAX_EXPIRATION',0x03030211)
    win_const_mgr.add_const('LINE_AGENTSESSIONSTATUS',0x0000001B)
    win_const_mgr.add_const('DEBUG_CES_CODE_LEVEL',0x00000008)
    win_const_mgr.add_const('MTP_NEXTPHASE_WRITE_DATA',0x00000002)
    win_const_mgr.add_const('LIS_NOGRPCONV',0x00000002)
    win_const_mgr.add_const('SECURITY_INTERACTIVE_RID',0x00000004)
    win_const_mgr.add_const('IDO_SHGIOI_SHARE',0x0FFFFFFF)
    win_const_mgr.add_const('RQ_LOG_REQUEST',0x00000400)
    win_const_mgr.add_const('SQL_CONCAT_NULL_BEHAVIOR',0x00000016)
    win_const_mgr.add_const('DMPAPER_ENV_C4',0x0000001E)
    win_const_mgr.add_const('KS_TVTUNER_CHANGE_BEGIN_TUNE',0x00000001)
    win_const_mgr.add_const('DEBUG_OUTSYM_FORCE_OFFSET',0x00000001)
    win_const_mgr.add_const('IDM_BACKCOLOR',0x00000033)
    win_const_mgr.add_const('CDO_E_UNSUPPORTED_DATASOURCE',0x80040203)
    win_const_mgr.add_const('AM_AC3_SERVICE_COMMENTARY',0x00000005)
    win_const_mgr.add_const('ACM_METRIC_DRIVER_PRIORITY',0x00000065)
    win_const_mgr.add_const('DCX_CLIPSIBLINGS',0x00000010)
    win_const_mgr.add_const('CWP_SKIPINVISIBLE',0x00000001)
    win_const_mgr.add_const('TRUST_ATTRIBUTES_USER',0xFF000000)
    win_const_mgr.add_const('ERROR_BAD_PROFILE',0x000004B6)
    win_const_mgr.add_const('LGRPID_THAI',0x00000000)
    win_const_mgr.add_const('DI_UNREMOVEDEVICE_CONFIGSPECIFIC',0x00000002)
    win_const_mgr.add_const('SM_CMETRICS',0x0000005D)
    win_const_mgr.add_const('CMSG_SIGNED_DATA_V1',0x00000001)
    win_const_mgr.add_const('IDM_FOLLOWLINKC',0x00000858)
    win_const_mgr.add_const('NDIS_OFFLOAD_PARAMETERS_IPSECV1_AH_ENABLED',0x00000002)
    win_const_mgr.add_const('CM_PROB_DEVLOADER_NOT_FOUND',0x00000008)
    win_const_mgr.add_const('SQL_DIAG_DELETE_WHERE',0x00000013)
    win_const_mgr.add_const('WM_HSCROLLCLIPBOARD',0x0000030E)
    win_const_mgr.add_const('ASC_REQ_STREAM',0x00010000)
    win_const_mgr.add_const('MAPI_POST_MESSAGE',0x00000001)
    win_const_mgr.add_const('OLECMDARGINDEX_SHOWPAGEACTIONMENU_Y',0x00000002)
    win_const_mgr.add_const('ITALIC_FONTTYPE',0x00000200)
    win_const_mgr.add_const('DEF_MAX_BADPW',0x00000000)
    win_const_mgr.add_const('IDM_FOLLOWLINKT',0x00000983)
    win_const_mgr.add_const('PWR_SUSPENDRESUME',0x00000002)
    win_const_mgr.add_const('ASYNC_RECO_SETFLAGS_FAILED',0x00000040)
    win_const_mgr.add_const('EVENT_SYSTEM_MENUSTART',0x00000004)
    win_const_mgr.add_const('URL_INTERNAL_PATH',0x00800000)
    win_const_mgr.add_const('HICF_LEAVING',0x00000020)
    win_const_mgr.add_const('WM_MDIGETACTIVE',0x00000229)
    win_const_mgr.add_const('NRC_REMTFUL',0x00000012)
    win_const_mgr.add_const('INTERNET_OPTION_PROXY',0x00000026)
    win_const_mgr.add_const('SQL_ODBC_CURSORS',0x0000006E)
    win_const_mgr.add_const('CLEARTYPE_NATURAL_QUALITY',0x00000006)
    win_const_mgr.add_const('NEWFILEOPENORD',0x0000060B)
    win_const_mgr.add_const('ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED',0x00001B95)
    win_const_mgr.add_const('PROCESSOR_ARM720',0x00000720)
    win_const_mgr.add_const('ERROR_CONNECTED_OTHER_PASSWORD',0x0000083C)
    win_const_mgr.add_const('WNTYPE_DRIVE',0x00000001)
    win_const_mgr.add_const('INF_STYLE_OLDNT',0x00000001)
    win_const_mgr.add_const('DOT11_ASSOC_STATUS_PEER_DEAUTHENTICATED_END',0x00000001)
    win_const_mgr.add_const('ISR_CODE_MASK',0x0000FFFF)
    win_const_mgr.add_const('SQL_SR_INSERT_COLUMN',0x00000200)
    win_const_mgr.add_const('FACILITY_SHELL',0x00000027)
    win_const_mgr.add_const('DS_REPSYNC_INITIAL',0x00002000)
    win_const_mgr.add_const('FPS_FATAL_ERROR',0x20000800)
    win_const_mgr.add_const('CRYPT_DECODE_SHARE_OID_STRING_FLAG',0x00000004)
    win_const_mgr.add_const('DCOMSCM_ACTIVATION_USE_ALL_AUTHNSERVICES',0x00000001)
    win_const_mgr.add_const('MCI_WAVE_GETDEVCAPS_INPUTS',0x00004001)
    win_const_mgr.add_const('CS_GLOBALCLASS',0x00004000)
    win_const_mgr.add_const('AUTHZ_COMPUTE_PRIVILEGES',0x00000008)
    win_const_mgr.add_const('DSBI_NOLINESATROOT',0x00000004)
    win_const_mgr.add_const('POLICY_ERRV_UNSUPPORTED_CREDENTIAL_TYPE',0x00000002)
    win_const_mgr.add_const('DSOP_FILTER_CONTACTS',0x00000400)
    win_const_mgr.add_const('SUBLANG_SPANISH_PARAGUAY',0x00000000)
    win_const_mgr.add_const('GMEM_MOVEABLE',0x00000002)
    win_const_mgr.add_const('CMSG_KEY_AGREE_EPHEMERAL_KEY_CHOICE',0x00000001)
    win_const_mgr.add_const('SQL_CACHE_DATA_YES',0x00000001)
    win_const_mgr.add_const('CAL_SLONGDATE',0x00000006)
    win_const_mgr.add_const('LWS_USECUSTOMTEXT',0x00000010)
    win_const_mgr.add_const('WIA_IPS_PREVIEW',0x00000C1C)
    win_const_mgr.add_const('SN_INFLAG_RUNTIME',0x80000000)
    win_const_mgr.add_const('APMMENUSUSPEND_UNDOCKED',0x00000002)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2RAWCD_RELEASEMEDIA',0x00000204)
    win_const_mgr.add_const('IDM_INSINPUTPASSWORD',0x00000909)
    win_const_mgr.add_const('FEI_DIALING',0x00000001)
    win_const_mgr.add_const('MAXIMUM_REPARSE_DATA_BUFFER_SIZE',0x00000010)
    win_const_mgr.add_const('OID_GEN_INTERRUPT_MODERATION',0x00010209)
    win_const_mgr.add_const('SQL_NC_ON',0x00000001)
    win_const_mgr.add_const('SP_COPY_NEWER',0x00000004)
    win_const_mgr.add_const('IDM_ZOOMRATIO',0x00000928)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_CONSTRAINT_COLUMN_USAGE',0x00000004)
    win_const_mgr.add_const('SAFER_TOKEN_COMPARE_ONLY',0x00000002)
    win_const_mgr.add_const('MAX_IRQS',0x00000007)
    win_const_mgr.add_const('SDP_ATTRIB_FAX_CLASS_2_0_SUPPORT',0x00000303)
    win_const_mgr.add_const('LVS_ALIGNMASK',0x00000000)
    win_const_mgr.add_const('CTRY_HONDURAS',0x000001F8)
    win_const_mgr.add_const('ERROR_DS_CONTROL_NOT_FOUND',0x00002042)
    win_const_mgr.add_const('VK_OEM_ATTN',0x000000F0)
    win_const_mgr.add_const('MDM_PROTOCOLID_V110',0x00000004)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_REFERENTIAL_CONSTRAINTS',0x00000003)
    win_const_mgr.add_const('PSINJECT_BEGINDEFAULTS',0x0000000C)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_CONFIG_POWER',0x00000010)
    win_const_mgr.add_const('MCI_DGV_LIST_STILL_ALG',0x00004003)
    win_const_mgr.add_const('BIF_NONEWFOLDERBUTTON',0x00000200)
    win_const_mgr.add_const('DS_REPL_NBR_SELECT_SECRETS',0x00001000)
    win_const_mgr.add_const('CR_PROP_CASIGCERTCHAIN',0x0000000D)
    win_const_mgr.add_const('CMC_FAIL_POP_REQUIRED',0x00000008)
    win_const_mgr.add_const('AM_CONTENTPROPERTY_TITLE',0x00000001)
    win_const_mgr.add_const('IKEEXT_CERT_HASH_LEN',0x00000014)
    win_const_mgr.add_const('LOCALE_RETURN_NUMBER',0x20000000)
    win_const_mgr.add_const('SW_OTHERZOOM',0x00000002)
    win_const_mgr.add_const('BACKUP_DATA',0x00000001)
    win_const_mgr.add_const('MAPI_NOTRECIP',0x00000040)
    win_const_mgr.add_const('WTS_SESSION_UNLOCK',0x00000008)
    win_const_mgr.add_const('PERF_COUNTER_BASE',0x00030000)
    win_const_mgr.add_const('IMAGE_DLLCHARACTERISTICS_WDM_DRIVER',0x00002000)
    win_const_mgr.add_const('OF_CAP_CANSWITCHTO',0x00000001)
    win_const_mgr.add_const('HANDLE_FLAG_PROTECT_FROM_CLOSE',0x00000002)
    win_const_mgr.add_const('ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA',0x00002111)
    win_const_mgr.add_const('UPNP_PROTOCOL_UUID16',0x00000010)
    win_const_mgr.add_const('SIF_RANGE',0x00000001)
    win_const_mgr.add_const('GRADIENT_FILL_RECT_V',0x00000001)
    win_const_mgr.add_const('MUI_QUERY_RESOURCE_TYPES',0x00000008)
    win_const_mgr.add_const('DDSCAPS2_TEXTUREMANAGE',0x00000010)
    win_const_mgr.add_const('IDD_PASTESPECIAL',0x000003EB)
    win_const_mgr.add_const('LDAP_OPT_REBIND_FN',0x00000006)
    win_const_mgr.add_const('DBPROPVAL_GB_NOT_SUPPORTED',0x00000001)
    win_const_mgr.add_const('ERROR_CTX_LICENSE_CLIENT_INVALID',0x00001B8F)
    win_const_mgr.add_const('LANG_BRETON',0x00000007)
    win_const_mgr.add_const('ADS_JOB_ERROR',0x00000002)
    win_const_mgr.add_const('WPF_NO_PROGRESS_DLGS',0x00000200)
    win_const_mgr.add_const('LINE_DEVSPECIFICFEATURE',0x00000005)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_PAIR',0x0000000C)
    win_const_mgr.add_const('MQ_LOOKUP_RECEIVE_ALLOW_PEEK',0x40000120)
    win_const_mgr.add_const('RPC_IF_ALLOW_SECURE_ONLY',0x00000008)
    win_const_mgr.add_const('RSA_KEY_LEN',0x00000040)
    win_const_mgr.add_const('SQL_NC_OFF',0x00000000)
    win_const_mgr.add_const('EVENT_TRACE_PRIVATE_IN_PROC',0x00020000)
    win_const_mgr.add_const('DSOP_SCOPE_TYPE_EXTERNAL_UPLEVEL_DOMAIN',0x00000020)
    win_const_mgr.add_const('BF_RIGHT',0x00000004)
    win_const_mgr.add_const('WKSTA_NUMWORKBUF_PARMNUM',0x00000010)
    win_const_mgr.add_const('ATSC_ETT_TID',0x000000CC)
    win_const_mgr.add_const('DBPROPVAL_NT_MULTIPLEROWS',0x00000002)
    win_const_mgr.add_const('DEBUG_EVENT_LOAD_MODULE',0x00000040)
    win_const_mgr.add_const('HH_GET_WIN_HANDLE',0x00000006)
    win_const_mgr.add_const('OFN_ENABLETEMPLATEHANDLE',0x00000080)
    win_const_mgr.add_const('ERROR_NONE_MAPPED',0x00000534)
    win_const_mgr.add_const('SPI_GETSCREENSAVEACTIVE',0x00000010)
    win_const_mgr.add_const('OFFLOAD_OUTBOUND_SA',0x00000002)
    win_const_mgr.add_const('PROPID_QUERY_RANK',0x00000003)
    win_const_mgr.add_const('DFM_GETHELPTEXTW',0x0000000B)
    win_const_mgr.add_const('BG_E_HTTP_ERROR_206',0x801900CE)
    win_const_mgr.add_const('EAP_CONFIG_INPUT_FIELD_PROPS_DEFAULT',0x00000000)
    win_const_mgr.add_const('BG_E_HTTP_ERROR_204',0x801900CC)
    win_const_mgr.add_const('HSE_URL_FLAGS_SSL',0x00000008)
    win_const_mgr.add_const('BG_E_HTTP_ERROR_202',0x801900CA)
    win_const_mgr.add_const('BG_E_HTTP_ERROR_201',0x801900C9)
    win_const_mgr.add_const('ARCONTENT_DVDMOVIE',0x00000008)
    win_const_mgr.add_const('LCMAP_KATAKANA',0x00200000)
    win_const_mgr.add_const('MCI_DGV_STATUS_COLOR',0x00004006)
    win_const_mgr.add_const('HKCOMB_S',0x00000002)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_GUIDMAP',0x0000000A)
    win_const_mgr.add_const('PRIVACY_URLHASPOLICYREFLINK',0x00100000)
    win_const_mgr.add_const('PRJOB_NOTIFY',0x00000080)
    win_const_mgr.add_const('DISPID_FONT_CHARSET',0x00000008)
    win_const_mgr.add_const('ISFB_MASK_IDLIST',0x00000010)
    win_const_mgr.add_const('OBM_CHECKBOXES',0x00007FF7)
    win_const_mgr.add_const('RR_SIZE',0x00000008)
    win_const_mgr.add_const('DMDO_DEFAULT',0x00000000)
    win_const_mgr.add_const('VK_CONTROL',0x00000011)
    win_const_mgr.add_const('IRLMP_IAS_QUERY',0x00000012)
    win_const_mgr.add_const('EMR_SETICMPROFILEA',0x00000070)
    win_const_mgr.add_const('CHANGER_VOLUME_IDENTIFICATION',0x00100000)
    win_const_mgr.add_const('MDMEMBER_TYPE_MEASURE',0x00000003)
    win_const_mgr.add_const('LINECALLFEATURE_ANSWER',0x00000004)
    win_const_mgr.add_const('ULONG_PTR_MAX',0x00000000)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_MM_HPF',0x0000000E)
    win_const_mgr.add_const('EMR_SETICMPROFILEW',0x00000071)
    win_const_mgr.add_const('DS_REPADD_ASYNCHRONOUS_OPERATION',0x00000001)
    win_const_mgr.add_const('DV_AUDIOMODE',0x00000000)
    win_const_mgr.add_const('SCARD_STATE_EXCLUSIVE',0x00000080)
    win_const_mgr.add_const('WMS_ASF_THRESHOLD_DURATION',0x000001F4)
    win_const_mgr.add_const('RPC_DE_USE_CURRENT_EEINFO',0x00000001)
    win_const_mgr.add_const('ICM_DONE_OUTSIDEDC',0x00000004)
    win_const_mgr.add_const('MCS_NOTODAY',0x00000008)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_RECOVER_QUERY',0x00000800)
    win_const_mgr.add_const('OPPROGDLG_DONTDISPLAYSOURCEPATH',0x00000200)
    win_const_mgr.add_const('LAYOUT_BITMAPORIENTATIONPRESERVED',0x00000008)
    win_const_mgr.add_const('SERVICE_MULTIPLE',0x00000001)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_SAMPLE_INPUT_FRAME',0x00000001)
    win_const_mgr.add_const('SYMOPT_AUTO_PUBLICS',0x00010000)
    win_const_mgr.add_const('D3DPCMPCAPS_LESSEQUAL',0x00000008)
    win_const_mgr.add_const('ERROR_DISK_RECALIBRATE_FAILED',0x00000466)
    win_const_mgr.add_const('SV_TYPE_WINDOWS',0x00400000)
    win_const_mgr.add_const('MAPI_E_AMBIGUOUS_RECIPIENT',0x00000015)
    win_const_mgr.add_const('FILE_DEVICE_BUS_EXTENDER',0x00000002)
    win_const_mgr.add_const('SQL_PARAM_SUCCESS',0x00000000)
    win_const_mgr.add_const('CONFIGFLAG_FAILEDINSTALL',0x00000040)
    win_const_mgr.add_const('WM_GETMINMAXINFO',0x00000024)
    win_const_mgr.add_const('PROFILE_FILENAME',0x00000001)
    win_const_mgr.add_const('MD_CHANGE_TYPE_RESTORE',0x00000020)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2RAWCDEVENTARGS_ESTIMATEDTOTALTIME',0x00000302)
    win_const_mgr.add_const('TXFS_TRANSACTION_STATE_PREPARED',0x00000002)
    win_const_mgr.add_const('AUTH_REQ_ALLOW_S4U_DELEGATE',0x00000800)
    win_const_mgr.add_const('TMT_CSSNAME',0x00000579)
    win_const_mgr.add_const('DNS_ERROR_UNKNOWN_RECORD_TYPE',0x000025E8)
    win_const_mgr.add_const('TMT_MENUBARHEIGHT',0x000004B9)
    win_const_mgr.add_const('SAFER_POLICY_JOBID_MASK',0xFF000000)
    win_const_mgr.add_const('DNS_FILTEROFF',0x00000008)
    win_const_mgr.add_const('HKCOMB_A',0x00000008)
    win_const_mgr.add_const('DDSVCAPS_STEREOSEQUENTIAL',0x00000010)
    win_const_mgr.add_const('SECBUFFER_MECHLIST',0x0000000B)
    win_const_mgr.add_const('SSPROP_QUOTEDCATALOGNAMES',0x00000002)
    win_const_mgr.add_const('CERT_STORE_DELTA_CRL_FLAG',0x00000200)
    win_const_mgr.add_const('PRODUCT_CLUSTER_SERVER',0x00000012)
    win_const_mgr.add_const('SMTO_NORMAL',0x00000000)
    win_const_mgr.add_const('HKCOMB_C',0x00000004)
    win_const_mgr.add_const('RTCAU_BASIC',0x00000001)
    win_const_mgr.add_const('RPC_C_OPT_TRUST_PEER',0x0000000E)
    win_const_mgr.add_const('PARTITION_XINT13_EXTENDED',0x0000000F)
    win_const_mgr.add_const('PSP_HIDEHEADER',0x00000800)
    win_const_mgr.add_const('GTL_CLOSE',0x00000004)
    win_const_mgr.add_const('SN_CMP_DIFFERENT',0x00000000)
    win_const_mgr.add_const('FACILITY_RPC_STUBS',0x00000003)
    win_const_mgr.add_const('WMPGC_FLAGS_IGNORE_AV_SYNC',0x00000004)
    win_const_mgr.add_const('URLACTION_AUTOMATIC_ACTIVEX_UI',0x00002201)
    win_const_mgr.add_const('SSPROP_AUTH_REPL_SERVER_NAME',0x0000000E)
    win_const_mgr.add_const('CLCTL_INTERNAL_MASK',0x00000001)
    win_const_mgr.add_const('NET_IFLUID_UNSPECIFIED',0x00000000)
    win_const_mgr.add_const('SECTION_MAP_READ',0x00000004)
    win_const_mgr.add_const('DCTT_BITMAP',0x00000001)
    win_const_mgr.add_const('ACM_FORMATSUGGESTF_NCHANNELS',0x00020000)
    win_const_mgr.add_const('PORT_AUTH',0x00000071)
    win_const_mgr.add_const('MSIM_DISPID_ONNEWSESSIONMEMBER',0x00000E0C)
    win_const_mgr.add_const('CHANNEL_RC_BAD_INIT_HANDLE',0x00000009)
    win_const_mgr.add_const('PSN_FIRST',0x00000000)
    win_const_mgr.add_const('IDM_DYNSRCPLAY',0x000008DF)
    win_const_mgr.add_const('KSPROPERTY_TYPE_TOPOLOGY',0x10000000)
    win_const_mgr.add_const('OF_REOPEN',0x00008000)
    win_const_mgr.add_const('OPATH_TOK_HEXINT',0x00000067)
    win_const_mgr.add_const('ERROR_EVT_CHANNEL_CANNOT_ACTIVATE',0x00003AB1)
    win_const_mgr.add_const('SV_SECURITY_NETWARE',0x00000003)
    win_const_mgr.add_const('WIA_DIP_REMOTE_DEV_ID',0x00000009)
    win_const_mgr.add_const('SQL_BS_ROW_COUNT_PROC',0x00000008)
    win_const_mgr.add_const('URLACTION_HTML_MIXED_CONTENT',0x00001609)
    win_const_mgr.add_const('META_PAINTREGION',0x0000012B)
    win_const_mgr.add_const('PPP_CCP_ENCRYPTION40BITOLD',0x00000010)
    win_const_mgr.add_const('EMR_RESERVED_107',0x0000006B)
    win_const_mgr.add_const('EMR_RESERVED_106',0x0000006A)
    win_const_mgr.add_const('DEBUG_ATTACH_NONINVASIVE_NO_SUSPEND',0x00000004)
    win_const_mgr.add_const('PAN_XHEIGHT_DUCKING_STD',0x00000006)
    win_const_mgr.add_const('IPX_ADDRESS_NOTIFY',0x0000400C)
    win_const_mgr.add_const('ACL_REVISION_DS',0x00000004)
    win_const_mgr.add_const('ERROR_OBJECT_NOT_FOUND',0x000010D8)
    win_const_mgr.add_const('REGDF_NOTDETIRQ',0x00000004)
    win_const_mgr.add_const('DBPROPVAL_ORS_HISTOGRAM',0x00000008)
    win_const_mgr.add_const('RESOURCEMANAGER_REGISTER_PROTOCOL',0x00000020)
    win_const_mgr.add_const('LOCALE_ICALENDARTYPE',0x00001009)
    win_const_mgr.add_const('EAP_E_USER_CERT_NOT_FOUND',0x80420100)
    win_const_mgr.add_const('SERVICETYPE_NOTRAFFIC',0x00000000)
    win_const_mgr.add_const('SUBLANG_YI_PRC',0x00000001)
    win_const_mgr.add_const('RF_UI_ONLY',0x01000000)
    win_const_mgr.add_const('DISPID_IDISCRECORDER2_PRODUCTID',0x00000202)
    win_const_mgr.add_const('IF_TYPE_GR303_RDT',0x000000B1)
    win_const_mgr.add_const('X509_ASN_ENCODING',0x00000001)
    win_const_mgr.add_const('ERROR_SEM_OWNER_DIED',0x00000069)
    win_const_mgr.add_const('DCI_STATUS_SURFACEINFOCHANGED',0x00000008)
    win_const_mgr.add_const('URLACTION_CHANNEL_SOFTDIST_PERMISSIONS',0x00001E05)
    win_const_mgr.add_const('ACM_DRIVERADDF_TYPEMASK',0x00000007)
    win_const_mgr.add_const('RPC_S_ADDRESS_ERROR',0x000006E8)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_FILTER_ATTRIBUTES',0x0000008D)
    win_const_mgr.add_const('KP_CERTIFICATE',0x0000001A)
    win_const_mgr.add_const('PIDASI_CHANNEL_COUNT',0x00000007)
    win_const_mgr.add_const('RTM_VIEW_ID_UCAST',0x00000000)
    win_const_mgr.add_const('FORCE_IMMEDIATE_REFRESH',0x00000001)
    win_const_mgr.add_const('TXFS_RM_FLAG_PRESERVE_CHANGES',0x00002000)
    win_const_mgr.add_const('SFGAO_STORAGEANCESTOR',0x00800000)
    win_const_mgr.add_const('JOB_OBJECT_UILIMIT_GLOBALATOMS',0x00000020)
    win_const_mgr.add_const('WSA_E_NO_MORE',0x0000277E)
    win_const_mgr.add_const('DV_SD',0x00000000)
    win_const_mgr.add_const('DCB_ACCUMULATE',0x00000002)
    win_const_mgr.add_const('FS_USER_ABORT',0x20200000)
    win_const_mgr.add_const('PDH_CANNOT_CONNECT_MACHINE',0xC0000BC3)
    win_const_mgr.add_const('DMTT_DOWNLOAD_OUTLINE',0x00000004)
    win_const_mgr.add_const('NOTIFY_POST',0x00000002)
    win_const_mgr.add_const('DV_SL',0x00000002)
    win_const_mgr.add_const('SND_MEMORY',0x00000004)
    win_const_mgr.add_const('DISPID_IMIMEEDIT_BASE',0x00000064)
    win_const_mgr.add_const('POLICY_ERRV_UNKNOWN_USER',0x00000031)
    win_const_mgr.add_const('STATE_SYSTEM_SIZEABLE',0x00020000)
    win_const_mgr.add_const('VER_SERVICEPACKMINOR',0x00000010)
    win_const_mgr.add_const('SCRIPTPROC_HOSTMANAGESSOURCE',0x00000080)
    win_const_mgr.add_const('SQL_DL_SQL92_INTERVAL_DAY',0x00000020)
    win_const_mgr.add_const('ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION',0x000005B3)
    win_const_mgr.add_const('D3DSP_TEXTURETYPE_SHIFT',0x0000001B)
    win_const_mgr.add_const('STRSAFE_IGNORE_NULLS',0x00000100)
    win_const_mgr.add_const('ACTRL_PERM_9',0x00000100)
    win_const_mgr.add_const('SERVICE_CONTROL_NETBINDDISABLE',0x0000000A)
    win_const_mgr.add_const('IDM_TEXTAREA',0x00000872)
    win_const_mgr.add_const('PID_REVNUMBER',0x00000009)
    win_const_mgr.add_const('LINEDISCONNECTMODE_FORWARDED',0x00000010)
    win_const_mgr.add_const('IDM_MENUEXT_COUNT',0x00000E95)
    win_const_mgr.add_const('WINHTTP_CALLBACK_STATUS_REDIRECT',0x00004000)
    win_const_mgr.add_const('PRINTER_NOTIFY_FIELD_AVERAGE_PPM',0x00000015)
    win_const_mgr.add_const('INTERNET_OPTION_CALLBACK_FILTER',0x00000036)
    win_const_mgr.add_const('ICDRAW_ANIMATE',0x00000008)
    win_const_mgr.add_const('QITIPF_LINKUSETARGET',0x00000004)
    win_const_mgr.add_const('SCESTATUS_MOD_NOT_FOUND',0x0000000F)
    win_const_mgr.add_const('BZ_DISABLESWITCHTOBUTTON',0x00000002)
    win_const_mgr.add_const('EC_BUFFERING_DATA',0x00000011)
    win_const_mgr.add_const('MSGF_COMMCTRL_TOOLBARCUST',0x00004203)
    win_const_mgr.add_const('SBS_RIGHTALIGN',0x00000004)
    win_const_mgr.add_const('SQL_GD_BOUND',0x00000008)
    win_const_mgr.add_const('ERROR_DS_DUPLICATE_ID_FOUND',0x0000219D)
    win_const_mgr.add_const('ERROR_INCORRECT_ADDRESS',0x000004D9)
    win_const_mgr.add_const('SAFER_CRITERIA_IMAGEHASH',0x00000004)
    win_const_mgr.add_const('MIXERCONTROL_CT_UNITS_DECIBELS',0x00040000)
    win_const_mgr.add_const('RESTART_NO_CRASH',0x00000001)
    win_const_mgr.add_const('CM_SET_DEVNODE_PROBLEM_OVERRIDE',0x00000001)
    win_const_mgr.add_const('D3DPMISCCAPS_CLIPPLANESCALEDPOINTS',0x00000100)
    win_const_mgr.add_const('IDM_OUTDENT',0x0000088B)
    win_const_mgr.add_const('MDM_PROTOCOLID_X75',0x00000003)
    win_const_mgr.add_const('SNMP_ERROR_AUTHORIZATIONERROR',0x00000010)
    win_const_mgr.add_const('PP_CLIENT_HWND',0x00000001)
    win_const_mgr.add_const('SBM_SETPOS',0x000000E0)
    win_const_mgr.add_const('DEBUG_ATTACH_EXISTING',0x00000002)
    win_const_mgr.add_const('SHUTDOWN_POWEROFF',0x00000008)
    win_const_mgr.add_const('IMAGE_SCN_ALIGN_4BYTES',0x00300000)
    win_const_mgr.add_const('OPTION_IEN116_NAME_SERVERS',0x00000005)
    win_const_mgr.add_const('NFS_EDIT',0x00000001)
    win_const_mgr.add_const('SCHEME_EDIT',0x00000002)
    win_const_mgr.add_const('EDITF_DISABLEEXTENSIONLIST',0x00000004)
    win_const_mgr.add_const('GD_USERDEFINED',0x00000000)
    win_const_mgr.add_const('ALG_SID_3DES',0x00000003)
    win_const_mgr.add_const('MP_STATUS_RETRY',0x00000001)
    win_const_mgr.add_const('MB_ABORTRETRYIGNORE',0x00000002)
    win_const_mgr.add_const('CRED_TI_ONLY_PASSWORD_REQUIRED',0x00000004)
    win_const_mgr.add_const('IDTR_IGN0',0x00000030)
    win_const_mgr.add_const('IDS_CAP_AVI_DRAWDIB_ERROR',0x000001B7)
    win_const_mgr.add_const('BIF_EDITBOX',0x00000010)
    win_const_mgr.add_const('WINHTTP_HANDLE_TYPE_CONNECT',0x00000002)
    win_const_mgr.add_const('CBES_EX_CASESENSITIVE',0x00000010)
    win_const_mgr.add_const('WMDM_FILE_ATTR_VIDEO',0x00000040)
    win_const_mgr.add_const('SQL_NOT_DEFERRABLE',0x00000007)
    win_const_mgr.add_const('UDP_NOCHECKSUM',0x00000001)
    win_const_mgr.add_const('UNDNAME_NO_THROW_SIGNATURES',0x00000100)
    win_const_mgr.add_const('JOY_CAL_READYONLY',0x00200000)
    win_const_mgr.add_const('KSFRAMETIME_VARIABLESIZE',0x00000001)
    win_const_mgr.add_const('ERROR_UNKNOWN_COMPONENT',0x00000647)
    win_const_mgr.add_const('SQL_PC_NOT_PSEUDO',0x00000001)
    win_const_mgr.add_const('KERB_CHECKSUM_NONE',0x00000000)
    win_const_mgr.add_const('BL_SAL_INDEX',0x00000000)
    win_const_mgr.add_const('CSIDL_MYMUSIC',0x00000000)
    win_const_mgr.add_const('AM_DVD_CGMS_RESERVED_MASK',0x00000078)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_WMI',0x00000015)
    win_const_mgr.add_const('WINHTTP_ACCESS_TYPE_NO_PROXY',0x00000001)
    win_const_mgr.add_const('ERROR_DS_ATT_SCHEMA_REQ_ID',0x000020CF)
    win_const_mgr.add_const('NOTIFIER_FLAG_NEW_THREAD',0x00000001)
    win_const_mgr.add_const('LINECALLSELECT_LINE',0x00000001)
    win_const_mgr.add_const('FLAG_FORCE_CREATENAMESPACE',0x00000004)
    win_const_mgr.add_const('SECPKG_CRED_ATTR_SSI_PROVIDER',0x00000002)
    win_const_mgr.add_const('CRYPT_MESSAGE_SILENT_KEYSET_FLAG',0x00000040)
    win_const_mgr.add_const('IDM_EDITMODE',0x0000084F)
    win_const_mgr.add_const('CHANNEL_EVENT_DATA_RECEIVED',0x0000000A)
    win_const_mgr.add_const('DDENUMSURFACES_MATCH',0x00000002)
    win_const_mgr.add_const('CERT_ENCIPHER_ONLY_KEY_USAGE',0x00000001)
    win_const_mgr.add_const('WAIT_TIMEOUT',0x00000102)
    win_const_mgr.add_const('ERRCLASS_TEMPSIT',0x00000002)
    win_const_mgr.add_const('HTTP_QUERY_ALLOW',0x00000007)
    win_const_mgr.add_const('SPI_SETDRAGFULLWINDOWS',0x00000025)
    win_const_mgr.add_const('DTR_DRIVER1_INDEX',0x00000003)
    win_const_mgr.add_const('SHARD_PIDL',0x00000001)
    win_const_mgr.add_const('SFVM_BACKGROUNDENUMDONE',0x00000030)
    win_const_mgr.add_const('COLOR_LUMACCEL',0x000002D5)
    win_const_mgr.add_const('HELP_SETPOPUP_POS',0x00000000)
    win_const_mgr.add_const('MCI_DGV_OPEN_PARENT',0x00020000)
    win_const_mgr.add_const('SBS_HORZ',0x00000000)
    win_const_mgr.add_const('PFA_FULL_SCALED',0x00000006)
    win_const_mgr.add_const('NFS_STATIC',0x00000002)
    win_const_mgr.add_const('CDS_DISABLE_UNSAFE_MODES',0x00000200)
    win_const_mgr.add_const('PORT_CMIPAGENT',0x000000A4)
    win_const_mgr.add_const('MAX_MIB_OFFSET',0x00000008)
    win_const_mgr.add_const('DISPID_IWBSCRIPTCONTROL_FROZEN',0x00000005)
    win_const_mgr.add_const('PIDISF_CACHEIMAGES',0x00000010)
    win_const_mgr.add_const('TMT_SIZINGMARGINS',0x00000E11)
    win_const_mgr.add_const('CRR_MEMORY_LIMIT',0xFFFFFFFC)
    win_const_mgr.add_const('CDDS_PREERASE',0x00000003)
    win_const_mgr.add_const('HFRMREG_DEFAULT',0x00000000)
    win_const_mgr.add_const('DDFXCAPS_BLTSTRETCHXN',0x00008000)
    win_const_mgr.add_const('AUTODIAL_MODE_ALWAYS',0x00000002)
    win_const_mgr.add_const('LOGON_NOENCRYPTION',0x00000002)
    win_const_mgr.add_const('FACILITY_FVE',0x00000031)
    win_const_mgr.add_const('MD_FILTER_STATE_LOADED',0x00000001)
    win_const_mgr.add_const('CERT_STORE_ADD_NEW',0x00000001)
    win_const_mgr.add_const('WIA_DPC_EXPOSURE_METERING_MODE',0x00000824)
    win_const_mgr.add_const('NDIS_STATISTICS_FLAGS_VALID_RCV_ERROR',0x00000020)
    win_const_mgr.add_const('RPC_C_QOS_CAPABILITIES_IGNORE_DELEGATE_FAILURE',0x00000008)
    win_const_mgr.add_const('SEL_TEXT',0x00000001)
    win_const_mgr.add_const('KSAUDIO_STEREO_SPEAKER_GEOMETRY_NARROW',0x0000000A)
    win_const_mgr.add_const('SQL_CT_COLUMN_CONSTRAINT',0x00000200)
    win_const_mgr.add_const('IME_ENABLE_CONVERT',0x00000002)
    win_const_mgr.add_const('ACCESS_DENIED_CALLBACK_OBJECT_ACE_TYPE',0x0000000C)
    win_const_mgr.add_const('ERROR_CLUSTER_REGISTRY_INVALID_FUNCTION',0x0000171B)
    win_const_mgr.add_const('CERT_VERIFY_ALLOW_MORE_USAGE_FLAG',0x00000008)
    win_const_mgr.add_const('DFS_VOLUME_STATE_STANDBY',0x00000020)
    win_const_mgr.add_const('SPMODE_DEBUGOUT',0x00000002)
    win_const_mgr.add_const('WIA_NUM_DIP',0x00000010)
    win_const_mgr.add_const('CERT_CHAIN_POLICY_IGNORE_INVALID_BASIC_CONSTRAINTS_FLAG',0x00000008)
    win_const_mgr.add_const('SPI_SETLOWPOWERACTIVE',0x00000055)
    win_const_mgr.add_const('MAX_ISCSI_NAME_LEN',0x000000DF)
    win_const_mgr.add_const('SHTDN_REASON_MINOR_INSTALLATION',0x00000002)
    win_const_mgr.add_const('FILE_DEVICE_DFS_VOLUME',0x00000036)
    win_const_mgr.add_const('MDM_V110_SPEED_12DOT0K',0x00000005)
    win_const_mgr.add_const('PIDVSI_STREAM_NUMBER',0x0000000B)
    win_const_mgr.add_const('SPI_GETBLOCKSENDINPUTRESETS',0x00001026)
    win_const_mgr.add_const('SEM_NOALIGNMENTFAULTEXCEPT',0x00000004)
    win_const_mgr.add_const('IDM_VERTSPACECONCATENATE',0x0000002E)
    win_const_mgr.add_const('SVSI_NOSTATECHANGE',0x80000000)
    win_const_mgr.add_const('RUSSIAN_CHARSET',0x000000CC)
    win_const_mgr.add_const('AF_HYLINK',0x0000000F)
    win_const_mgr.add_const('ERROR_DS_GC_REQUIRED',0x00002163)
    win_const_mgr.add_const('CMSG_CTRL_ADD_CRL',0x0000000C)
    win_const_mgr.add_const('BG_E_TOO_MANY_FILES_IN_JOB',0x80200051)
    win_const_mgr.add_const('MD_LOGCUSTOM_DATATYPE_LPSTR',0x00000006)
    win_const_mgr.add_const('STGM_TRANSACTED',0x00010000)
    win_const_mgr.add_const('RAS_EAP_ROLE_EXCLUDE_IN_EAP',0x00000004)
    win_const_mgr.add_const('COOKIEACTION_ACCEPT',0x00000001)
    win_const_mgr.add_const('SECBUFFER_NEGOTIATION_INFO',0x00000008)
    win_const_mgr.add_const('PP_ENUMELECTROOTS',0x0000001A)
    win_const_mgr.add_const('IDD_INSERTFILEBROWSE',0x000003F2)
    win_const_mgr.add_const('CM_DRP_DEVTYPE',0x0000001A)
    win_const_mgr.add_const('BTH_ERROR_INVALID_LMP_PARAMETERS',0x00000001)
    win_const_mgr.add_const('MD_ERROR_SUB404_REQUEST_HEADER_TOO_LONG',0x0000000A)
    win_const_mgr.add_const('HDI_IMAGE',0x00000020)
    win_const_mgr.add_const('BI_RLE8',0x00000001)
    win_const_mgr.add_const('IPX_SERVICE_FILTER_INFO_TYPE',0x00000004)
    win_const_mgr.add_const('MCI_VD_STEP_REVERSE',0x00020000)
    win_const_mgr.add_const('KEY_QUERY_VALUE',0x00000001)
    win_const_mgr.add_const('CRYPT_DECRYPT',0x00000002)
    win_const_mgr.add_const('BI_RLE4',0x00000002)
    win_const_mgr.add_const('D3DPRASTERCAPS_WBUFFER',0x00040000)
    win_const_mgr.add_const('CDRF_NEWFONT',0x00000002)
    win_const_mgr.add_const('CSIDL_COMMON_FAVORITES',0x00000001)
    win_const_mgr.add_const('SPI_GETWORKAREA',0x00000030)
    win_const_mgr.add_const('LWS_RIGHT',0x00000020)
    win_const_mgr.add_const('SERVICE_ACCEPT_STOP',0x00000001)
    win_const_mgr.add_const('IF_TYPE_TUNNEL',0x00000083)
    win_const_mgr.add_const('HDFT_ISNUMBER',0x00000001)
    win_const_mgr.add_const('SYSTEM_MANDATORY_LABEL_NO_WRITE_UP',0x00000001)
    win_const_mgr.add_const('VER_ERR_ITEM_F',0x00000200)
    win_const_mgr.add_const('OQWF_LOADQUERY',0x00000008)
    win_const_mgr.add_const('IF_TYPE_DVBRCC_MACLAYER',0x00000092)
    win_const_mgr.add_const('RTM_ROUTE_FLAGS_MYSELF',0x00000040)
    win_const_mgr.add_const('SCARD_E_UNKNOWN_CARD',0x8010000D)
    win_const_mgr.add_const('DEBUG_SERVERS_DEBUGGER',0x00000001)
    win_const_mgr.add_const('NTDSCONN_KCC_SERVER_FAILOVER_TOPOLOGY',0x00000001)
    win_const_mgr.add_const('MDM_MASK_X75_DATA',0x00000007)
    win_const_mgr.add_const('L2CAP_PROTOCOL_UUID16',0x00000100)
    win_const_mgr.add_const('EVENT_HEADER_EXT_TYPE_RELATED_ACTIVITYID',0x00000001)
    win_const_mgr.add_const('PSP_USECALLBACK',0x00000080)
    win_const_mgr.add_const('DDPF_RGB',0x00000040)
    win_const_mgr.add_const('DISPID_IWBSCRIPTCONTROL_RAISEEVENT',0x00000001)
    win_const_mgr.add_const('AC_LINE_OFFLINE',0x00000000)
    win_const_mgr.add_const('OID_TCP_TASK_IPSEC_ADD_UDPESP_SA',0xFC010205)
    win_const_mgr.add_const('IPPORT_TTYLINK',0x00000057)
    win_const_mgr.add_const('CLR_DEFAULT',0xFF000000)
    win_const_mgr.add_const('FILE_DEVICE_DISK_FILE_SYSTEM',0x00000008)
    win_const_mgr.add_const('CLFS_SCAN_INITIALIZED',0x00000010)
    win_const_mgr.add_const('INDEX_GUID_WORDLIST',0x00000008)
    win_const_mgr.add_const('MCI_DGV_WINDOW_TEXT',0x00080000)
    win_const_mgr.add_const('RPC_IF_AUTOLISTEN',0x00000001)
    win_const_mgr.add_const('WM_WNT_CONVERTREQUESTEX',0x00000109)
    win_const_mgr.add_const('PIDSI_COMMENT',0x00000006)
    win_const_mgr.add_const('C3_KATAKANA',0x00000010)
    win_const_mgr.add_const('RECO_COPY',0x00000002)
    win_const_mgr.add_const('NORM_IGNOREKANATYPE',0x00010000)
    win_const_mgr.add_const('ERROR_SXS_XML_E_BADCHARDATA',0x000036D4)
    win_const_mgr.add_const('SMART_INVALID_FLAG',0x00000002)
    win_const_mgr.add_const('SEL_MULTICHAR',0x00000004)
    win_const_mgr.add_const('DVB_NIT_OTHER_TID',0x00000041)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_FORWARD_WMI',0x40000000)
    win_const_mgr.add_const('ERROR_WMI_INVALID_REGINFO',0x00001073)
    win_const_mgr.add_const('SQL_DB_RETURN_TO_POOL',0x00000000)
    win_const_mgr.add_const('WIA_IPS_DOCUMENT_HANDLING_SELECT',0x00000C10)
    win_const_mgr.add_const('DWN_DOWNLOADONLY',0x00000040)
    win_const_mgr.add_const('SNMP_LOG_ERROR',0x00000002)
    win_const_mgr.add_const('ISCSI_SECURITY_FLAG_TUNNEL_MODE_PREFERRED',0x00000040)
    win_const_mgr.add_const('BG_E_TOO_MANY_JOBS_PER_USER',0x80200049)
    win_const_mgr.add_const('PORT_METER',0x0000023A)
    win_const_mgr.add_const('INTERNET_OPTION_CACHE_STREAM_HANDLE',0x0000001B)
    win_const_mgr.add_const('TXTBIT_WORDWRAP',0x00000400)
    win_const_mgr.add_const('CTFMODEBIAS_READING',0x00000003)
    win_const_mgr.add_const('DISPID_PICT_HEIGHT',0x00000005)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_TRUSTEE',0x00000004)
    win_const_mgr.add_const('DMPAPER_B5_EXTRA',0x00000041)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_TM_ONLINE',0x02000000)
    win_const_mgr.add_const('USE_DEFAULT_CREDENTIALS',0x00000004)
    win_const_mgr.add_const('WSAEHOSTDOWN',0x00002750)
    win_const_mgr.add_const('RBBS_NOGRIPPER',0x00000100)
    win_const_mgr.add_const('DCI_OFFSCREEN',0x00000001)
    win_const_mgr.add_const('IDC_VP_SPIN',0x000003EE)
    win_const_mgr.add_const('IPV6_DEL_IFLIST',0x0000001E)
    win_const_mgr.add_const('MD_CPU_ENABLE_PROC_TYPE',0x00000002)
    win_const_mgr.add_const('SQL_POS_REFRESH',0x00000002)
    win_const_mgr.add_const('PORT_RRH',0x000002F1)
    win_const_mgr.add_const('D3DDTCAPS_SHORT4N',0x00000008)
    win_const_mgr.add_const('CERT_CHAIN_OPTION_DISABLE_AIA_URL_RETRIEVAL',0x00000002)
    win_const_mgr.add_const('DN_NO_SHOW_IN_DM',0x40000000)
    win_const_mgr.add_const('LB_INSERTSTRING',0x00000181)
    win_const_mgr.add_const('CB_FINDSTRING',0x0000014C)
    win_const_mgr.add_const('DBFLAGS_LOGBUFFERSHUGE',0x00000080)
    win_const_mgr.add_const('CMSG_SIGNED_AND_ENVELOPED',0x00000004)
    win_const_mgr.add_const('RPC_S_NO_PROTSEQS_REGISTERED',0x000006B2)
    win_const_mgr.add_const('PRINTER_ATTRIBUTE_ENABLE_BIDI',0x00000800)
    win_const_mgr.add_const('SPLITSYM_REMOVE_PRIVATE',0x00000001)
    win_const_mgr.add_const('SNAPSHOT_POLICY_UNPLANNED',0x00000002)
    win_const_mgr.add_const('DL_MOVECURSOR',0x00000003)
    win_const_mgr.add_const('CBS_OWNERDRAWVARIABLE',0x00000020)
    win_const_mgr.add_const('BCRYPT_DH_PRIVATE_MAGIC',0x56504844)
    win_const_mgr.add_const('MIXERLINE_COMPONENTTYPE_DST_FIRST',0x00000000)
    win_const_mgr.add_const('ERROR_FILEMARK_DETECTED',0x0000044D)
    win_const_mgr.add_const('CERT_SUBJECT_NAME_MD5_HASH_PROP_ID',0x0000001D)
    win_const_mgr.add_const('VK_MULTIPLY',0x0000006A)
    win_const_mgr.add_const('MCHT_CALENDAR',0x00020000)
    win_const_mgr.add_const('DATE_LTRREADING',0x00000010)
    win_const_mgr.add_const('IDM_SHOWMISCTAGS',0x00000910)
    win_const_mgr.add_const('COMP_ELEM_ORIGINAL_CSI',0x00001000)
    win_const_mgr.add_const('CSS_ENABLEHOOK',0x00000002)
    win_const_mgr.add_const('OID_FDDI_IF_IN_ERRORS',0x03030285)
    win_const_mgr.add_const('PORT_GACP',0x000000BE)
    win_const_mgr.add_const('DDFXCAPS_OVERLAYARITHSTRETCHY',0x00040000)
    win_const_mgr.add_const('LOGON_WITH_PROFILE',0x00000001)
    win_const_mgr.add_const('DXVA_BITSTREAM_CONCEALMENT_METHOD_INTRA',0x00000001)
    win_const_mgr.add_const('GLEX_LINEFEED',0x00000010)
    win_const_mgr.add_const('ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE',0x0000370A)
    win_const_mgr.add_const('IDF_NOSKIP',0x00000002)
    win_const_mgr.add_const('DRM_EL_CLIENTLICENSOR_LID',0x00000100)
    win_const_mgr.add_const('IMAGE_REL_IA64_IMM14',0x00000001)
    win_const_mgr.add_const('BLLI_L3_SIO_8473',0x00000009)
    win_const_mgr.add_const('MIIM_FTYPE',0x00000100)
    win_const_mgr.add_const('SQL_INFO_FIRST',0x00000000)
    win_const_mgr.add_const('MIXERCONTROL_CT_CLASS_NUMBER',0x30000000)
    win_const_mgr.add_const('HELP_CONTEXT',0x00000001)
    win_const_mgr.add_const('LCS_CALIBRATED_RGB',0x00000000)
    win_const_mgr.add_const('D3D10_SRGB_TO_FLOAT_OFFSET',0x00000000)
    win_const_mgr.add_const('SUBLANG_KASHMIRI_SASIA',0x00000002)
    win_const_mgr.add_const('DS_REPDEL_IGNORE_ERRORS',0x00000008)
    win_const_mgr.add_const('LINECALLTREATMENT_MUSIC',0x00000004)
    win_const_mgr.add_const('OID_TAPI_GET_LINE_DEV_STATUS',0x07030114)
    win_const_mgr.add_const('TOKEN_MANDATORY_POLICY_NEW_PROCESS_MIN',0x00000002)
    win_const_mgr.add_const('SMTO_ERRORONEXIT',0x00000020)
    win_const_mgr.add_const('MAXVENDORINFO',0x00000020)
    win_const_mgr.add_const('TC_NONCONF_BORROW',0x00000000)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_MONITORING_USERS',0x0000022E)
    win_const_mgr.add_const('ASN_CONTEXT',0x00000080)
    win_const_mgr.add_const('RPC_C_QOS_CAPABILITIES_ANY_AUTHORITY',0x00000004)
    win_const_mgr.add_const('PDK3_SPI_VERSION',0x00010010)
    win_const_mgr.add_const('SV_TYPE_SERVER_VMS',0x00200000)
    win_const_mgr.add_const('TASKSTATUS_DEFERRED',0x00000004)
    win_const_mgr.add_const('IDM_EDITSOURCE',0x0000084A)
    win_const_mgr.add_const('META_CREATEPENINDIRECT',0x000002FA)
    win_const_mgr.add_const('CRYPT_SGCKEY',0x00002000)
    win_const_mgr.add_const('DNS_RCLASS_ALL',0x00000000)
    win_const_mgr.add_const('INTERNET_STATUS_RESOLVING_NAME',0x0000000A)
    win_const_mgr.add_const('MB_ERR_INVALID_CHARS',0x00000008)
    win_const_mgr.add_const('IP_TOS',0x00000003)
    win_const_mgr.add_const('NDIS_OFFLOAD_REVISION_1',0x00000001)
    win_const_mgr.add_const('IDM_BACKGROUNDIMAGECACHE',0x0000097E)
    win_const_mgr.add_const('OID_FDDI_PORT_BS_FLAG',0x03030269)
    win_const_mgr.add_const('LINEERR_INCOMPATIBLEAPIVERSION',0x8000000C)
    win_const_mgr.add_const('ERROR_DS_CANT_MOVE_APP_BASIC_GROUP',0x000021A0)
    win_const_mgr.add_const('DOT11_ASSOC_STATUS_IHV_END',0x00000000)
    win_const_mgr.add_const('CTFMODEBIAS_HIRAGANA',0x00000007)
    win_const_mgr.add_const('DEBUG_MANSTR_LOAD_STATUS',0x00000002)
    win_const_mgr.add_const('SQL_CONVERT_LONGVARBINARY',0x00000047)
    win_const_mgr.add_const('SECPKG_OPTIONS_TYPE_UNKNOWN',0x00000000)
    win_const_mgr.add_const('ERROR_SUCCESS_REBOOT_INITIATED',0x00000669)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_DIRECTORY',0x00000020)
    win_const_mgr.add_const('SUBLANG_SPANISH_ECUADOR',0x00000000)
    win_const_mgr.add_const('SEE_MASK_FLAG_LOG_USAGE',0x04000000)
    win_const_mgr.add_const('ERROR_TOKEN_ALREADY_IN_USE',0x0000055F)
    win_const_mgr.add_const('DBPROPVAL_OO_IPERSIST',0x00000002)
    win_const_mgr.add_const('D3DSTENCILCAPS_TWOSIDED',0x00000100)
    win_const_mgr.add_const('IDC_CV_ACTIVATEAS',0x0000009C)
    win_const_mgr.add_const('IDM_TABORDER',0x00000029)
    win_const_mgr.add_const('MDPROPVAL_MF_CREATE_NAMEDSETS',0x00000008)
    win_const_mgr.add_const('ICU_ESCAPE',0x80000000)
    win_const_mgr.add_const('ERRLOG_BASE',0x00000C1C)
    win_const_mgr.add_const('SUBLANG_DUTCH_BELGIAN',0x00000002)
    win_const_mgr.add_const('OID_TAPI_MAKE_CALL',0x07030115)
    win_const_mgr.add_const('DNSSEC_KEY_FLAG_FLAG11',0x00000800)
    win_const_mgr.add_const('SQL_FN_NUM_POWER',0x00100000)
    win_const_mgr.add_const('PORT_LPD724',0x000002D4)
    win_const_mgr.add_const('MIB_IF_TYPE_SLIP',0x0000001C)
    win_const_mgr.add_const('DEBUG_FORMAT_USER_SMALL_FULL_MEMORY',0x00000001)
    win_const_mgr.add_const('DISPID_GETALWAYSSHOWLOCKSTATE',0x00000017)
    win_const_mgr.add_const('IPV6_PROTECTION_LEVEL',0x00000017)
    win_const_mgr.add_const('IRLMP_IAS_SET',0x00000011)
    win_const_mgr.add_const('TCP_MAXRT',0x00000005)
    win_const_mgr.add_const('PORT_ATECHO',0x000000CC)
    win_const_mgr.add_const('LINEERR_INVALTONELIST',0x8000003D)
    win_const_mgr.add_const('SERVICE_ADDRESS_FLAG_RPC_CN',0x00000001)
    win_const_mgr.add_const('ADS_JOB_PAPEROUT',0x00000040)
    win_const_mgr.add_const('VER_PRODUCTBUILD_QFE',0x00000000)
    win_const_mgr.add_const('DIIRFLAG_HW_USING_THE_INF',0x00000004)
    win_const_mgr.add_const('PSD_INHUNDREDTHSOFMILLIMETERS',0x00000008)
    win_const_mgr.add_const('IPPORT_FTP',0x00000015)
    win_const_mgr.add_const('DEBUG_EVENT_CHANGE_DEBUGGEE_STATE',0x00000400)
    win_const_mgr.add_const('IDM_TRISTATEBOLD',0x0000005F)
    win_const_mgr.add_const('DMPAPER_9X11',0x0000002C)
    win_const_mgr.add_const('HCN_PROTOCOL_UUID16',0x00000016)
    win_const_mgr.add_const('CBEIF_LPARAM',0x00000020)
    win_const_mgr.add_const('DBPROMPT_NOPROMPT',0x00000004)
    win_const_mgr.add_const('ST_KEEPUNDO',0x00000001)
    win_const_mgr.add_const('DEBUG_FIND_SOURCE_NO_SRCSRV',0x00000004)
    win_const_mgr.add_const('PHONEHOOKSWITCHDEV_HANDSET',0x00000001)
    win_const_mgr.add_const('GMEM_INVALID_HANDLE',0x00008000)
    win_const_mgr.add_const('BAUD_300',0x00000010)
    win_const_mgr.add_const('STARTDOC',0x0000000A)
    win_const_mgr.add_const('MAPI_LOGOFF_SHARED',0x00000001)
    win_const_mgr.add_const('MAX_FILTER_NAME',0x00000080)
    win_const_mgr.add_const('PERM_FILE_READ',0x00000001)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_MAX_CUSTOM',0x0000FFFF)
    win_const_mgr.add_const('MF_API_VERSION',0x00000070)
    win_const_mgr.add_const('OID_FDDI_MAC_T_NEG',0x03030231)
    win_const_mgr.add_const('RAS_EAP_FLAG_PREVIEW',0x00000008)
    win_const_mgr.add_const('FO_COPY',0x00000002)
    win_const_mgr.add_const('BTH_ERROR_UNSUPPORTED_REMOTE_FEATURE',0x00000001)
    win_const_mgr.add_const('CLUSCTL_FUNCTION_SHIFT',0x00000002)
    win_const_mgr.add_const('WNODE_FLAG_NO_HEADER',0x00200000)
    win_const_mgr.add_const('MCI_SET_TIME_FORMAT',0x00000400)
    win_const_mgr.add_const('LB_GETCARETINDEX',0x0000019F)
    win_const_mgr.add_const('DEBUG_MODNAME_MAPPED_IMAGE',0x00000004)
    win_const_mgr.add_const('NDIS_OFFLOAD_PARAMETERS_RX_ENABLED_TX_DISABLED',0x00000003)
    win_const_mgr.add_const('WINHTTP_OPTION_PROXY_PASSWORD',0x00001003)
    win_const_mgr.add_const('IDM_MULTIPLESELECTION',0x00000959)
    win_const_mgr.add_const('MDPROPVAL_MS_SINGLETUPLE',0x00000002)
    win_const_mgr.add_const('NCBSEND',0x00000014)
    win_const_mgr.add_const('COPYFLG_WARN_IF_SKIP',0x00000001)
    win_const_mgr.add_const('WM_CHILDACTIVATE',0x00000022)
    win_const_mgr.add_const('GPO_INFO_FLAG_MACHINE',0x00000001)
    win_const_mgr.add_const('ADS_PRINTER_OFFLINE',0x00000008)
    win_const_mgr.add_const('SPOST_URL',0x00000002)
    win_const_mgr.add_const('OID_ATM_PARTY_ALERTING',0x0801020D)
    win_const_mgr.add_const('HH_RESERVED2',0x0000000B)
    win_const_mgr.add_const('DRV_ENABLE',0x00000002)
    win_const_mgr.add_const('LINEDISCONNECTMODE_NUMBERCHANGED',0x00002000)
    win_const_mgr.add_const('ERROR_DS_INSTALL_NO_SRC_SCH_VERSION',0x0000213F)
    win_const_mgr.add_const('RDW_INTERNALPAINT',0x00000002)
    win_const_mgr.add_const('PROTO_IP_DNS_PROXY',0x00002713)
    win_const_mgr.add_const('LPM_OK',0x00000000)
    win_const_mgr.add_const('MM_SNDBLST_SYNTH',0x00000005)
    win_const_mgr.add_const('FACILITY_GRAPHICS',0x00000026)
    win_const_mgr.add_const('POLICY_LOCATOR_SUB_TYPE_ASCII_DN',0x00000001)
    win_const_mgr.add_const('IDM_CREATESHORTCUT',0x000008DA)
    win_const_mgr.add_const('CRYPT_USER_DEFAULT',0x00000002)
    win_const_mgr.add_const('GESTURE_CIRCLE_LINE_HORZ',0x00000000)
    win_const_mgr.add_const('UINT_PTR_ERROR',0x00000000)
    win_const_mgr.add_const('VOS_WINCE',0x00050000)
    win_const_mgr.add_const('DISPID_IWRITEENGINE2_WRITESECTION',0x00000200)
    win_const_mgr.add_const('TRACE_ON',0x00000001)
    win_const_mgr.add_const('MCI_DEVTYPE_OVERLAY',0x00000203)
    win_const_mgr.add_const('CM_PROB_TOO_EARLY',0x0000001A)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_NEGOTIATION_DISABLED',0x0000363B)
    win_const_mgr.add_const('OPATH_TOK_IDENT',0x00000064)
    win_const_mgr.add_const('DFM_MERGECONTEXTMENU_BOTTOM',0x00000011)
    win_const_mgr.add_const('FILE_DEVICE_BATTERY',0x00000029)
    win_const_mgr.add_const('DBPROPVAL_NC_HIGH',0x00000002)
    win_const_mgr.add_const('LMEM_INVALID_HANDLE',0x00008000)
    win_const_mgr.add_const('SQL_SR_UPDATE_TABLE',0x00002000)
    win_const_mgr.add_const('SQL_UNBIND',0x00000002)
    win_const_mgr.add_const('IDM_ALIGNTOP',0x00000006)
    win_const_mgr.add_const('DB_BINDFLAGS_COLLECTION',0x00000010)
    win_const_mgr.add_const('REO_DYNAMICSIZE',0x00000008)
    win_const_mgr.add_const('LINECONNECTEDMODE_ACTIVE',0x00000001)
    win_const_mgr.add_const('TTFCFP_UNICODE_PLATFORMID',0x00000000)
    win_const_mgr.add_const('EFFECTMODE_STANDARD',0x00000001)
    win_const_mgr.add_const('IMAGE_SCN_ALIGN_4096BYTES',0x00D00000)
    win_const_mgr.add_const('INTERNET_REQFLAG_ASYNC',0x00000002)
    win_const_mgr.add_const('CRYPT_NOT_MODIFIED_RETRIEVAL',0x00400000)
    win_const_mgr.add_const('CRYPTDLG_REVOCATION_NONE',0x20000000)
    win_const_mgr.add_const('DEVPROP_TYPEMOD_ARRAY',0x00001000)
    win_const_mgr.add_const('MIN_IDD_DYNAWIZ_RESOURCE_ID',0x00002710)
    win_const_mgr.add_const('SMART_EXTENDED_SELFTEST_CAPTIVE',0x00000082)
    win_const_mgr.add_const('FWP_OPTION_VALUE_ALLOW_GLOBAL_MULTICAST_STATE',0x00000002)
    win_const_mgr.add_const('DOSOPTGF_DEFCLEAN',0x00000001)
    win_const_mgr.add_const('IDM_TRIED_DELETE',0x00000020)
    win_const_mgr.add_const('TF_RP_HIDDENINSETTINGUI',0x00000002)
    win_const_mgr.add_const('DXVA_BITSTREAM_DATA_BUFFER',0x00000007)
    win_const_mgr.add_const('ROT_COMPARE_MAX',0x00000800)
    win_const_mgr.add_const('LBN_SELCHANGE',0x00000001)
    win_const_mgr.add_const('CMSG_ENCODED_SIGNER',0x0000001C)
    win_const_mgr.add_const('SUBLANG_INUKTITUT_CANADA',0x00000001)
    win_const_mgr.add_const('ERROR_SERVICE_START_HANG',0x0000042E)
    win_const_mgr.add_const('CREDENTIAL_SUB_TYPE_UNICODE_ID',0x00000002)
    win_const_mgr.add_const('OPTION_TTL',0x00000025)
    win_const_mgr.add_const('BN_PAINT',0x00000001)
    win_const_mgr.add_const('ERROR_NO_SITENAME',0x0000077F)
    win_const_mgr.add_const('USN_REASON_SECURITY_CHANGE',0x00000800)
    win_const_mgr.add_const('WST_TVTUNER_CHANGE_BEGIN_TUNE',0x00001000)
    win_const_mgr.add_const('DS_REPSYNC_ALL_SOURCES',0x00000010)
    win_const_mgr.add_const('SMC_SFDDRESTRICTED',0x00000030)
    win_const_mgr.add_const('PROFILE_READ',0x00000001)
    win_const_mgr.add_const('DBMAXCHAR',0x00001F40)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATAEVENTARGS_ELAPSEDTIME',0x00000300)
    win_const_mgr.add_const('DOT11_ASSOC_STATUS_ASSOCIATION_RESPONSE_END',0x00000003)
    win_const_mgr.add_const('CSF_VALIDSOURCE',0x00000002)
    win_const_mgr.add_const('DF_TRACELESS',0x40000000)
    win_const_mgr.add_const('RBN_FIRST',0x00000000)
    win_const_mgr.add_const('DEBUG_DUMP_DEFAULT',0x00000401)
    win_const_mgr.add_const('LINEGROUPSTATUS_GROUPREMOVED',0x00000002)
    win_const_mgr.add_const('MAXUIDLEN',0x00000040)
    win_const_mgr.add_const('ETW_REDUCED_STRING_TYPE_VALUE',0x00000072)
    win_const_mgr.add_const('WIA_PAGE_JIS_B8',0x0000002F)
    win_const_mgr.add_const('IMGDECODE_EVENT_BEGINBITS',0x00000004)
    win_const_mgr.add_const('CHANGER_VOLUME_SEARCH',0x00200000)
    win_const_mgr.add_const('IT_STATUS_TRANSFER_FROM_DEVICE',0x00000001)
    win_const_mgr.add_const('KS_VBIDATARATE_NABTS',0x00576428)
    win_const_mgr.add_const('APPCOMMAND_SAVE',0x00000020)
    win_const_mgr.add_const('WSAETOOMANYREFS',0x0000274B)
    win_const_mgr.add_const('KSWAVE_COMPATCAPS_INPUT',0x00000000)
    win_const_mgr.add_const('D3D10_SHADER_NO_PRESHADER',0x00000001)
    win_const_mgr.add_const('ACCESS_MIN_MS_ACE_TYPE',0x00000000)
    win_const_mgr.add_const('CFM_FACE',0x20000000)
    win_const_mgr.add_const('RPC_S_NAME_SERVICE_UNAVAILABLE',0x000006E2)
    win_const_mgr.add_const('DDSD_LINEARSIZE',0x00080000)
    win_const_mgr.add_const('DSBS_CHECKED',0x00000001)
    win_const_mgr.add_const('INTERNET_OPTION_IDLE_STATE',0x00000033)
    win_const_mgr.add_const('AI_ADDRCONFIG',0x00000400)
    win_const_mgr.add_const('APPCOMMAND_MIC_ON_OFF_TOGGLE',0x0000002C)
    win_const_mgr.add_const('AUDIO_MAX_CHANNELS',0x00001000)
    win_const_mgr.add_const('SQL_BIND_BY_COLUMN',0x00000000)
    win_const_mgr.add_const('DBPROPVAL_OP_EQUAL',0x00000001)
    win_const_mgr.add_const('TTFCFP_DONT_CARE',0x0000FFFF)
    win_const_mgr.add_const('WLX_SAS_TYPE_USER_LOGOFF',0x00000004)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_STATIONSPEED',0x0000002A)
    win_const_mgr.add_const('JOB_EXEC_ERROR',0x00000002)
    win_const_mgr.add_const('SP_PROT_TLS1_CLIENT',0x00000080)
    win_const_mgr.add_const('FAX_ERR_DEVICE_NUM_LIMIT_EXCEEDED',0x00001B62)
    win_const_mgr.add_const('GOPHER_TYPE_TEXT_FILE',0x00000001)
    win_const_mgr.add_const('FACILITY_WINDOWS_DEFENDER',0x00000050)
    win_const_mgr.add_const('DNS_ERROR_CNAME_COLLISION',0x000025ED)
    win_const_mgr.add_const('MB_HELP',0x00004000)
    win_const_mgr.add_const('INTERNET_STATUS_RECEIVING_RESPONSE',0x00000028)
    win_const_mgr.add_const('WM_KEYLAST',0x00000108)
    win_const_mgr.add_const('ERROR_BAD_THREADID_ADDR',0x0000009F)
    win_const_mgr.add_const('CMSG_HASHED',0x00000005)
    win_const_mgr.add_const('DDFXCAPS_BLTSTRETCHY',0x00010000)
    win_const_mgr.add_const('DDFXCAPS_BLTSTRETCHX',0x00004000)
    win_const_mgr.add_const('TKF_INDICATOR',0x00000020)
    win_const_mgr.add_const('FWPM_NET_EVENT_IKEEXT_EM_FAILURE_FLAG_MULTIPLE',0x00000001)
    win_const_mgr.add_const('SUBLANG_SYRIAC_SYRIA',0x00000001)
    win_const_mgr.add_const('FILE_READ_ACCESS',0x00000001)
    win_const_mgr.add_const('SCESTATUS_TRUST_FAIL',0x00000013)
    win_const_mgr.add_const('IKEEXT_NTLM_V2_AUTH_DONT_ACCEPT_EXPLICIT_CREDENTIALS',0x00000001)
    win_const_mgr.add_const('PKCS12_INCLUDE_EXTENDED_PROPERTIES',0x00000010)
    win_const_mgr.add_const('MCI_STEP',0x0000080E)
    win_const_mgr.add_const('DSBF_STATE',0x00000001)
    win_const_mgr.add_const('TMT_FLATMENUS',0x000003E9)
    win_const_mgr.add_const('TCIF_IMAGE',0x00000002)
    win_const_mgr.add_const('WIA_PAGE_ISO_C10',0x00000026)
    win_const_mgr.add_const('CERT_STORE_ENUM_ARCHIVED_FLAG',0x00000200)
    win_const_mgr.add_const('TCIS_HIGHLIGHTED',0x00000002)
    win_const_mgr.add_const('VMRBITMAP_ENTIREDDS',0x00000004)
    win_const_mgr.add_const('MNGO_NOINTERFACE',0x00000000)
    win_const_mgr.add_const('VCAPS_CAN_SCALE',0x00000008)
    win_const_mgr.add_const('RTM_CHANGE_TYPE_FORWARDING',0x00000004)
    win_const_mgr.add_const('CSIDL_STARTMENU',0x00000000)
    win_const_mgr.add_const('PDH_FMT_LONG',0x00000100)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_REGKCBDELETE',0x00000017)
    win_const_mgr.add_const('FLG_ADDPROPERTY_NOCLOBBER',0x00000001)
    win_const_mgr.add_const('SQL_SRJO_CORRESPONDING_CLAUSE',0x00000001)
    win_const_mgr.add_const('DEBUG_CES_EXPRESSION_SYNTAX',0x00002000)
    win_const_mgr.add_const('SQL_CB_CLOSE',0x00000001)
    win_const_mgr.add_const('RTM_MAX_VIEWS',0x00000020)
    win_const_mgr.add_const('OPTION_CLIENT_ID',0x0000003D)
    win_const_mgr.add_const('CSBACKUP_TYPE_MASK',0x00000003)
    win_const_mgr.add_const('PXE_PROV_ATTR_FILTER',0x00000000)
    win_const_mgr.add_const('IDM_TRIED_REMOVEFORMAT',0x00000035)
    win_const_mgr.add_const('PROGDLG_MARQUEEPROGRESS',0x00000020)
    win_const_mgr.add_const('ERROR_VIOKBD_REQUEST',0x00000074)
    win_const_mgr.add_const('CHANNEL_OPTION_INITIALIZED',0x80000000)
    win_const_mgr.add_const('CERT_STORE_SAVE_AS_STORE',0x00000001)
    win_const_mgr.add_const('SECPKG_CONTEXT_EXPORT_TO_KERNEL',0x00000004)
    win_const_mgr.add_const('SQL_MAX_IDENTIFIER_LEN',0x00002715)
    win_const_mgr.add_const('VK_OEM_BACKTAB',0x000000F5)
    win_const_mgr.add_const('MCI_DEVTYPE_DIGITAL_VIDEO',0x00000208)
    win_const_mgr.add_const('MCM_FIRST',0x00001000)
    win_const_mgr.add_const('ACTCTX_FLAG_ASSEMBLY_DIRECTORY_VALID',0x00000004)
    win_const_mgr.add_const('CM_DRP_MIN',0x00000001)
    win_const_mgr.add_const('SHACF_AUTOAPPEND_FORCE_ON',0x40000000)
    win_const_mgr.add_const('MCAST_BLOCK_SOURCE',0x0000002B)
    win_const_mgr.add_const('CACHE_CONFIG_QUOTA_FC',0x00000800)
    win_const_mgr.add_const('GESTURE_PARAGRAPH',0x00000000)
    win_const_mgr.add_const('ET_ATTRIBUTES',0x00002000)
    win_const_mgr.add_const('IF_TYPE_ATM_VIRTUAL',0x00000095)
    win_const_mgr.add_const('NDIS_PACKET_TYPE_802_11_PROMISCUOUS_MGMT',0x00200000)
    win_const_mgr.add_const('STDINDEXSIZE',0x00004000)
    win_const_mgr.add_const('OID_CO_TAPI_REPORT_DIGITS',0xFE001008)
    win_const_mgr.add_const('SNMP_PDUAPI_INVALID_ES',0x00000015)
    win_const_mgr.add_const('SUBLANG_MAPUDUNGUN_CHILE',0x00000001)
    win_const_mgr.add_const('LANG_HUNGARIAN',0x00000000)
    win_const_mgr.add_const('CONVERT10_E_LAST',0x800401CF)
    win_const_mgr.add_const('CDIS_DROPHILITED',0x00001000)
    win_const_mgr.add_const('FLG_ADDPROPERTY_AND',0x00000010)
    win_const_mgr.add_const('PST_PC_PCMCIA',0x00000008)
    win_const_mgr.add_const('INHERITED_GRANDPARENT',0x20000000)
    win_const_mgr.add_const('ERROR_LOG_EPHEMERAL',0x000019EA)
    win_const_mgr.add_const('V86FLAGS_INTERRUPT',0x00000200)
    win_const_mgr.add_const('MCI_DGV_METHOD_PRE',0x00000000)
    win_const_mgr.add_const('WSA_QOS_BAD_STYLE',0x00002B04)
    win_const_mgr.add_const('EMR_EOF',0x0000000E)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_NSI_COMPARTMENT_RW_STRUCT',0x000000AD)
    win_const_mgr.add_const('SQL_CVT_WLONGVARCHAR',0x00400000)
    win_const_mgr.add_const('WIA_USE_SEGMENTATION_FILTER',0x00000000)
    win_const_mgr.add_const('TRACE_HEADER_FLAG_TRACED_GUID',0x00020000)
    win_const_mgr.add_const('IDM_ENDUSERACTION',0x00000981)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_HISTORY',0x00000002)
    win_const_mgr.add_const('DEBUG_STACK_FRAME_ADDRESSES_RA_ONLY',0x00000100)
    win_const_mgr.add_const('WM_IME_REQUEST',0x00000288)
    win_const_mgr.add_const('OID_GEN_MEDIA_DUPLEX_STATE',0x0001028C)
    win_const_mgr.add_const('IME_CMODE_NOCONVERSION',0x00000100)
    win_const_mgr.add_const('OFN_SHAREAWARE',0x00004000)
    win_const_mgr.add_const('SQL_FN_STR_BIT_LENGTH',0x00080000)
    win_const_mgr.add_const('LBS_SORT',0x00000002)
    win_const_mgr.add_const('DISPID_XOBJ_MAX',0x0001FFFF)
    win_const_mgr.add_const('OID_GEN_DIRECTED_BYTES_RCV',0x00020207)
    win_const_mgr.add_const('TASK_FOURTH_WEEK',0x00000004)
    win_const_mgr.add_const('FOF_NOERRORUI',0x00000400)
    win_const_mgr.add_const('RPC_S_ZERO_DIVIDE',0x000006E7)
    win_const_mgr.add_const('SI_TEMPORARY',0x80000000)
    win_const_mgr.add_const('KS_DVD_CGMS_NO_COPY',0x00000018)
    win_const_mgr.add_const('ISMEX_REPLIED',0x00000008)
    win_const_mgr.add_const('DBPROPVAL_LM_INTENT',0x00000004)
    win_const_mgr.add_const('D3DUSAGE_TEXTAPI',0x10000000)
    win_const_mgr.add_const('MDM_PROTOCOLID_ANALOG',0x00000007)
    win_const_mgr.add_const('IF_TYPE_PROP_DOCS_WIRELESS_DOWNSTREAM',0x000000B5)
    win_const_mgr.add_const('DNS_TYPE_MF',0x00000004)
    win_const_mgr.add_const('D3DPCMPCAPS_NOTEQUAL',0x00000020)
    win_const_mgr.add_const('HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA',0x40000000)
    win_const_mgr.add_const('KSDATAFORMAT_BIT_ATTRIBUTES',0x00000001)
    win_const_mgr.add_const('D3DPS20_MIN_DYNAMICFLOWCONTROLDEPTH',0x00000000)
    win_const_mgr.add_const('URLPOLICY_CREDENTIALS_CONDITIONAL_PROMPT',0x00020000)
    win_const_mgr.add_const('FR_MATCHKASHIDA',0x40000000)
    win_const_mgr.add_const('HTTP_QUERY_AGE',0x00000030)
    win_const_mgr.add_const('KSPIN_FLAG_FIXED_FORMAT',0x00100000)
    win_const_mgr.add_const('EAP_CREDENTIAL_VERSION',0x00000001)
    win_const_mgr.add_const('IPX_RERIPNETNUMBER',0x0000400E)
    win_const_mgr.add_const('MDFF_STRIKEOUT',0x00000008)
    win_const_mgr.add_const('DBPROPVAL_CU_DML_STATEMENTS',0x00000001)
    win_const_mgr.add_const('CDRF_NOTIFYSUBITEMDRAW',0x00000020)
    win_const_mgr.add_const('SQL_DIAG_SQLSTATE',0x00000004)
    win_const_mgr.add_const('RATING_UNRATED_MIN',0x00000000)
    win_const_mgr.add_const('PAGEMASK_4MB',0x00000003)
    win_const_mgr.add_const('EDITED_CACHE_ENTRY',0x00000008)
    win_const_mgr.add_const('STD_REPLACE',0x0000000D)
    win_const_mgr.add_const('CERT_REGISTRY_STORE_MY_IE_DIRTY_FLAG',0x00080000)
    win_const_mgr.add_const('ERROR_INVALID_BLOCK_LENGTH',0x00000452)
    win_const_mgr.add_const('PFD_DRAW_TO_BITMAP',0x00000008)
    win_const_mgr.add_const('CAUSE_UNALLOCATED_NUMBER',0x00000001)
    win_const_mgr.add_const('MD_WARNING_DUP_NAME',0x000CC804)
    win_const_mgr.add_const('SQL_OU_DML_STATEMENTS',0x00000001)
    win_const_mgr.add_const('DFS_PROPERTY_FLAG_CLUSTER_ENABLED',0x00000010)
    win_const_mgr.add_const('SQL_DESC_ARRAY_STATUS_PTR',0x00000015)
    win_const_mgr.add_const('DXVA_SLICE_CONTROL_BUFFER',0x00000006)
    win_const_mgr.add_const('LUP_CONTAINERS',0x00000002)
    win_const_mgr.add_const('TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MIN',0x00000100)
    win_const_mgr.add_const('SQL_OJ_NESTED',0x00000008)
    win_const_mgr.add_const('BL_128M',0x08000000)
    win_const_mgr.add_const('DS_REPSYNC_USE_COMPRESSION',0x00004000)
    win_const_mgr.add_const('OID_TAPI_GET_CALL_ADDRESS_ID',0x0703010D)
    win_const_mgr.add_const('CDIS_GRAYED',0x00000002)
    win_const_mgr.add_const('DISPID_QUIT',0x00000067)
    win_const_mgr.add_const('LINETOLLLISTOPTION_REMOVE',0x00000002)
    win_const_mgr.add_const('SM_FOCUS_TYPE_NT_DOMAIN',0x00000001)
    win_const_mgr.add_const('WINHTTP_CALLBACK_STATUS_REQUEST_ERROR',0x00200000)
    win_const_mgr.add_const('PORT_WPGS',0x0000030C)
    win_const_mgr.add_const('TVS_NONEVENHEIGHT',0x00004000)
    win_const_mgr.add_const('SQL_MAX_COLUMNS_IN_TABLE',0x00000065)
    win_const_mgr.add_const('DLCTL_NOFRAMES',0x00080000)
    win_const_mgr.add_const('CMSG_LENGTH_ONLY_FLAG',0x00000002)
    win_const_mgr.add_const('SQL_ATTR_CONNECTION_DEAD',0x000004B9)
    win_const_mgr.add_const('DI_DIDCOMPAT',0x00000010)
    win_const_mgr.add_const('RTCTR_TLS',0x00000004)
    win_const_mgr.add_const('DBPROPVAL_TR_ABORT_DC',0x00000008)
    win_const_mgr.add_const('VK_XBUTTON1',0x00000005)
    win_const_mgr.add_const('SUBLANG_SINDHI_PAKISTAN',0x00000002)
    win_const_mgr.add_const('PBT_APMSTANDBY',0x00000005)
    win_const_mgr.add_const('SMC_GETINFO',0x00000005)
    win_const_mgr.add_const('SCARD_UNKNOWN',0x00000000)
    win_const_mgr.add_const('ATE_MASK0',0x00000621)
    win_const_mgr.add_const('ERROR_INVALID_HW_PROFILE',0x0000026B)
    win_const_mgr.add_const('FWPM_NET_EVENT_FLAG_USER_ID_SET',0x00000040)
    win_const_mgr.add_const('WIA_DPS_GLOBAL_IDENTITY',0x00000C2B)
    win_const_mgr.add_const('SRRF_RT_REG_NONE',0x00000001)
    win_const_mgr.add_const('DNS_ERROR_DWORD_VALUE_TOO_SMALL',0x0000255E)
    win_const_mgr.add_const('IDTB_TOC_NEXT',0x000000DF)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_MSGWAITON',0x00000008)
    win_const_mgr.add_const('PORT_HMMP_OPERATION',0x00000265)
    win_const_mgr.add_const('TF_LBI_STATUS_HIDDEN',0x00000001)
    win_const_mgr.add_const('SECURITY_REMOTE_LOGON_RID',0x0000000E)
    win_const_mgr.add_const('SETABORTPROC',0x00000009)
    win_const_mgr.add_const('INTERNET_HANDLE_TYPE_FILE_REQUEST',0x0000000E)
    win_const_mgr.add_const('SCARD_ATR_LENGTH',0x00000021)
    win_const_mgr.add_const('CR_BUFFER_SMALL',0x0000001A)
    win_const_mgr.add_const('DOT11_ASSOC_STATUS_CANCELLED',0x00000005)
    win_const_mgr.add_const('DDCKEYCAPS_DESTOVERLAY',0x00000010)
    win_const_mgr.add_const('JOB_OBJECT_MSG_ACTIVE_PROCESS_ZERO',0x00000004)
    win_const_mgr.add_const('DS_REPL_NBR_WRITEABLE',0x00000010)
    win_const_mgr.add_const('IDM_SAVEPRETRANSFORMSOURCE',0x00000942)
    win_const_mgr.add_const('MCS_NOSELCHANGEONNAV',0x00000100)
    win_const_mgr.add_const('DEBUG_FILTER_LOAD_MODULE',0x00000004)
    win_const_mgr.add_const('SDP_ATTRIB_SERVICE_VERSION',0x00000300)
    win_const_mgr.add_const('WMDRM_QUERY_CLIENT_INDIVSTATUS',0x00000008)
    win_const_mgr.add_const('SFGAO_SHARE',0x00020000)
    win_const_mgr.add_const('CMIC_MASK_CONTROL_DOWN',0x40000000)
    win_const_mgr.add_const('PDTIMER_RESUME',0x00000003)
    win_const_mgr.add_const('ERROR_DS_USER_BUFFER_TO_SMALL',0x00002075)
    win_const_mgr.add_const('NT_CONSOLE_PROPS_SIG',0xA0000002)
    win_const_mgr.add_const('ERROR_DOMAIN_CTRLR_CONFIG_ERROR',0x00000245)
    win_const_mgr.add_const('OFFLINEAVAILABILITY_NOT_AVAILABLE',0x00000000)
    win_const_mgr.add_const('SDP_DEFAULT_INQUIRY_MAX_RESPONSES',0x000000FF)
    win_const_mgr.add_const('BCRYPT_ECDSA_PUBLIC_P256_MAGIC',0x31534345)
    win_const_mgr.add_const('SCH_CRED_AUTO_CRED_VALIDATION',0x00000020)
    win_const_mgr.add_const('WINEVENT_INCONTEXT',0x00000004)
    win_const_mgr.add_const('SNMPAPI_SESSION_INVALID',0x0000000D)
    win_const_mgr.add_const('ERROR_SETMARK_DETECTED',0x0000044F)
    win_const_mgr.add_const('CF_PRIVATEFIRST',0x00000200)
    win_const_mgr.add_const('ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION',0x000032DB)
    win_const_mgr.add_const('MAX_REASON_BUGID_LEN',0x00000020)
    win_const_mgr.add_const('TMMIGRATE',0x00100000)
    win_const_mgr.add_const('IMAGE_SCN_MEM_NOT_PAGED',0x08000000)
    win_const_mgr.add_const('RPC_QUERY_CLIENT_PRINCIPAL_NAME',0x00000004)
    win_const_mgr.add_const('TXTLOG_INFDB',0x00000400)
    win_const_mgr.add_const('ISR_NAT_REG',0x00000001)
    win_const_mgr.add_const('SQL_DRIVER_HLIB',0x0000004C)
    win_const_mgr.add_const('SQL_AF_MIN',0x00000008)
    win_const_mgr.add_const('GESTURE_LETTER_V',0x00000000)
    win_const_mgr.add_const('CHANGER_PREMOUNT_EJECT_REQUIRED',0x00080000)
    win_const_mgr.add_const('OID_FDDI_LONG_MULTICAST_LIST',0x03010103)
    win_const_mgr.add_const('DPNHQUERYADDRESS_CACHENOTFOUND',0x00000004)
    win_const_mgr.add_const('SP_COPY_REPLACEONLY',0x00000002)
    win_const_mgr.add_const('ARW_HIDE',0x00000008)
    win_const_mgr.add_const('VIF_CANNOTREADSRC',0x00010000)
    win_const_mgr.add_const('PSP_USEREFPARENT',0x00000040)
    win_const_mgr.add_const('CERT_INFO_SERIAL_NUMBER_FLAG',0x00000002)
    win_const_mgr.add_const('RBBS_HIDDEN',0x00000008)
    win_const_mgr.add_const('WIA_DEVICE_COMMANDS',0x00000001)
    win_const_mgr.add_const('INTERNET_DEFAULT_HTTPS_PORT',0x000001BB)
    win_const_mgr.add_const('ILD_BLEND25',0x00000002)
    win_const_mgr.add_const('COMPRESSION_FORMAT_LZNT1',0x00000002)
    win_const_mgr.add_const('TASKSTATUS_NOTSTARTED',0x00000000)
    win_const_mgr.add_const('MCI_TEST',0x00000020)
    win_const_mgr.add_const('D3D10_FLOAT_TO_SRGB_SCALE_2',0x00000001)
    win_const_mgr.add_const('NCBCHAINSEND',0x00000017)
    win_const_mgr.add_const('MQMSG_ACKNOWLEDGMENT_NONE',0x00000000)
    win_const_mgr.add_const('NOM_BS5',0x00000020)
    win_const_mgr.add_const('NOM_BS4',0x00000010)
    win_const_mgr.add_const('NOM_BS3',0x00000008)
    win_const_mgr.add_const('NOM_BS2',0x00000004)
    win_const_mgr.add_const('SERVICE_CTRL_REDIR_COMM',0x00000004)
    win_const_mgr.add_const('NOM_BS0',0x00000001)
    win_const_mgr.add_const('DNS_TYPE_MR',0x00000009)
    win_const_mgr.add_const('LINEERR_INIFILECORRUPT',0x8000000E)
    win_const_mgr.add_const('MD_ERROR_SUB500_UNC_ACCESS',0x00000010)
    win_const_mgr.add_const('SQL_SERVER_NAME',0x0000000D)
    win_const_mgr.add_const('MCI_VCR_SETTUNER_CHANNEL_SEEK_DOWN',0x00100000)
    win_const_mgr.add_const('IITWBC_EXTDATA_CHARTABLE',0x00000000)
    win_const_mgr.add_const('ALG_SID_DSS_DMS',0x00000002)
    win_const_mgr.add_const('DM_DEFAULTSOURCE',0x00000200)
    win_const_mgr.add_const('CTRY_POLAND',0x00000030)
    win_const_mgr.add_const('CDIS_MARKED',0x00000080)
    win_const_mgr.add_const('VECTOR_RANK_DICE',0x00000003)
    win_const_mgr.add_const('CERT_STORE_PROV_DELETE_CRL_FUNC',0x00000007)
    win_const_mgr.add_const('DI_FLAGSEX_PREINSTALLBACKUP',0x00080000)
    win_const_mgr.add_const('INTERNET_SCHEME_HTTPS',0x00000002)
    win_const_mgr.add_const('NETERR_RING_STOP_CAPTURE',0x00008E00)
    win_const_mgr.add_const('INTERNET_CACHE_CONTAINER_NODESKTOPINIT',0x00000008)
    win_const_mgr.add_const('ERROR_DRIVER_CANCEL_TIMEOUT',0x00000252)
    win_const_mgr.add_const('IME_CMODE_ALPHANUMERIC',0x00000000)
    win_const_mgr.add_const('DDCAPS2_COPYFOURCC',0x00008000)
    win_const_mgr.add_const('GESTURE_LETTER_B',0x00000000)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_IMAGE_LOAD',0x00000004)
    win_const_mgr.add_const('CR_DEVLOADER_NOT_READY',0x00000021)
    win_const_mgr.add_const('ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED',0x000013D9)
    win_const_mgr.add_const('HTTP_QUERY_DATE',0x00000009)
    win_const_mgr.add_const('ISC_REQ_DELEGATE',0x00000001)
    win_const_mgr.add_const('RPC_NCA_FLAGS_IDEMPOTENT',0x00000001)
    win_const_mgr.add_const('SQL_COLUMN_NAME',0x00000001)
    win_const_mgr.add_const('LOCALE_SSHORTDATE',0x0000001F)
    win_const_mgr.add_const('TRUSTERROR_STEP_MSG_SIGNERCOUNT',0x00000009)
    win_const_mgr.add_const('SQL_PRED_CHAR',0x00000001)
    win_const_mgr.add_const('SQL_SOPT_SS_BASE',0x000004C9)
    win_const_mgr.add_const('IDM_SETDESKTOPITEM',0x000008E6)
    win_const_mgr.add_const('FRS_ERR_STARTING_SERVICE',0x00001F42)
    win_const_mgr.add_const('ALG_SID_DES',0x00000001)
    win_const_mgr.add_const('D3DPMISCCAPS_MASKZ',0x00000002)
    win_const_mgr.add_const('RESTORE_TYPE_AUTHORATATIVE',0x00000001)
    win_const_mgr.add_const('NTDSCONN_KCC_GC_TOPOLOGY',0x00000001)
    win_const_mgr.add_const('SCESTATUS_CANT_DELETE',0x0000000A)
    win_const_mgr.add_const('SW_SMOOTHSCROLL',0x00000010)
    win_const_mgr.add_const('DDSCAPS3_READONLYRESOURCE',0x00004000)
    win_const_mgr.add_const('PP_KEYSET_SEC_DESCR',0x00000008)
    win_const_mgr.add_const('URLHISTORY_CACHE_ENTRY',0x00200000)
    win_const_mgr.add_const('ICDRAW_UPDATING',0x00000040)
    win_const_mgr.add_const('SNMP_BERAPI_INVALID_OBJELEM',0x0000000E)
    win_const_mgr.add_const('DSOP_SCOPE_TYPE_DOWNLEVEL_JOINED_DOMAIN',0x00000004)
    win_const_mgr.add_const('MK_E_FIRST',0x800401E0)
    win_const_mgr.add_const('FOF_NORECURSEREPARSE',0x00008000)
    win_const_mgr.add_const('ACM_METRIC_COUNT_LOCAL_FILTERS',0x00000017)
    win_const_mgr.add_const('TAPE_DRIVE_GET_ABSOLUTE_BLK',0x00100000)
    win_const_mgr.add_const('LDAP_OPT_REBIND_ARG',0x00000007)
    win_const_mgr.add_const('IMAGE_SYM_TYPE_UNION',0x00000009)
    win_const_mgr.add_const('SQL_DESC_OCTET_LENGTH_PTR',0x000003EC)
    win_const_mgr.add_const('GESTURE_LETTER_L',0x00000000)
    win_const_mgr.add_const('SQL_FN_STR_RTRIM',0x00000400)
    win_const_mgr.add_const('BST_UNCHECKED',0x00000000)
    win_const_mgr.add_const('GESTURE_DOUBLE_DOWN',0x00000000)
    win_const_mgr.add_const('SQL_API_SQLGETDESCREC',0x000003F1)
    win_const_mgr.add_const('LVS_SHAREIMAGELISTS',0x00000040)
    win_const_mgr.add_const('GS_LOOKASIDE_INFO',0x00000004)
    win_const_mgr.add_const('WM_CHANGECBCHAIN',0x0000030D)
    win_const_mgr.add_const('ISCSI_LOGIN_OPTIONS_VERSION',0x00000000)
    win_const_mgr.add_const('WSAEWOULDBLOCK',0x00002733)
    win_const_mgr.add_const('PRINTACTION_DOCUMENTDEFAULTS',0x00000006)
    win_const_mgr.add_const('SQL_CV_LOCAL',0x00000008)
    win_const_mgr.add_const('OID_WAN_CO_GET_LINK_INFO',0x04010182)
    win_const_mgr.add_const('IT_TYPICAL',0x00000001)
    win_const_mgr.add_const('EM_CANUNDO',0x000000C6)
    win_const_mgr.add_const('DBPROPVAL_OS_AGR_AFTERSESSION',0x00000008)
    win_const_mgr.add_const('SERVICE_NOTIFY_DELETED',0x00000100)
    win_const_mgr.add_const('SYMFLAG_LOCAL',0x00000080)
    win_const_mgr.add_const('DNS_OPCODE_UPDATE',0x00000005)
    win_const_mgr.add_const('DDF_JUSTDRAWIT',0x00000080)
    win_const_mgr.add_const('PTE_DIRTY_MASK',0x00000040)
    win_const_mgr.add_const('MCI_ANIM_GETDEVCAPS_PALETTES',0x00004006)
    win_const_mgr.add_const('MCI_DGV_STATUS_REFERENCE',0x00040000)
    win_const_mgr.add_const('XP1_UNI_SEND',0x00008000)
    win_const_mgr.add_const('GESTURE_UP_ARROW_RIGHT',0x00000000)
    win_const_mgr.add_const('FILE_READ_ONLY_VOLUME',0x00080000)
    win_const_mgr.add_const('NCRYPTBUFFER_SSL_CLEAR_KEY',0x00000017)
    win_const_mgr.add_const('CMSG_ENCODING_TYPE_MASK',0xFFFF0000)
    win_const_mgr.add_const('LVNI_FOCUSED',0x00000001)
    win_const_mgr.add_const('EN_PAGECHANGE',0x00000070)
    win_const_mgr.add_const('TBS_VERT',0x00000002)
    win_const_mgr.add_const('BF_FLAT',0x00004000)
    win_const_mgr.add_const('MB_ICONEXCLAMATION',0x00000030)
    win_const_mgr.add_const('APPCOMMAND_LAUNCH_MAIL',0x0000000F)
    win_const_mgr.add_const('CERT_NAME_STR_SEMICOLON_FLAG',0x40000000)
    win_const_mgr.add_const('CICAT_NO_QUERY',0x00000008)
    win_const_mgr.add_const('COPYFLG_PROTECTED_WINDOWS_DRIVER_FILE',0x00000100)
    win_const_mgr.add_const('FEI_ABORTING',0x00000000)
    win_const_mgr.add_const('SND_APPLICATION',0x00000080)
    win_const_mgr.add_const('SQL_USE_BOOKMARKS',0x0000000C)
    win_const_mgr.add_const('D3D10_DEFAULT_SLOPE_SCALED_DEPTH_BIAS',0x00000000)
    win_const_mgr.add_const('WLX_OPTION_NO_SWITCH_ON_SAS',0x00000009)
    win_const_mgr.add_const('DISPLAY_DEVICE_ACTIVE',0x00000001)
    win_const_mgr.add_const('SYSAUDIO_FLAGS_DONT_COMBINE_PINS',0x00000001)
    win_const_mgr.add_const('KS_NABTS_GROUPID_LOCAL_CABLE_SYSTEM_CONTENT_BASE',0x000008A0)
    win_const_mgr.add_const('DI_IMAGE',0x00000002)
    win_const_mgr.add_const('PS_COMPONENT_CONFORMER',0x00000003)
    win_const_mgr.add_const('SVSI_KEYBOARDSELECT',0x00000401)
    win_const_mgr.add_const('FILE_PREFETCH_TYPE_FOR_DIRENUM_EX',0x00000004)
    win_const_mgr.add_const('DS_ROLE_PDC_OWNER',0x00000002)
    win_const_mgr.add_const('SQL_SQL92_DATETIME_FUNCTIONS',0x0000009B)
    win_const_mgr.add_const('LINETRANSFERMODE_TRANSFER',0x00000001)
    win_const_mgr.add_const('ERROR_DRIVER_PROCESS_TERMINATED',0x0000050B)
    win_const_mgr.add_const('SWP_DEFERERASE',0x00002000)
    win_const_mgr.add_const('ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE',0x00003AAF)
    win_const_mgr.add_const('PIDISM_DONTWATCH',0x00000002)
    win_const_mgr.add_const('SET_FEATURE_ON_THREAD_LOCALMACHINE',0x00000008)
    win_const_mgr.add_const('SQLBITN',0x00000068)
    win_const_mgr.add_const('CRESTRICTIONS_MDSCHEMA_PROPERTIES',0x00000009)
    win_const_mgr.add_const('URL_ESCAPE_SEGMENT_ONLY',0x00002000)
    win_const_mgr.add_const('TMT_ALPHALEVEL',0x00000962)
    win_const_mgr.add_const('LDAP_SCOPE_SUBTREE',0x00000002)
    win_const_mgr.add_const('WM_CANCELJOURNAL',0x0000004B)
    win_const_mgr.add_const('TRUSTERROR_STEP_FINAL_SIGPROV',0x00000021)
    win_const_mgr.add_const('SDP_ATTRIB_DI_VERSION',0x00000203)
    win_const_mgr.add_const('COOKIEACTION_SUPPRESS',0x00000010)
    win_const_mgr.add_const('DISPID_ABSOLUTEDROPMODE',0x00000012)
    win_const_mgr.add_const('TVGN_DROPHILITE',0x00000008)
    win_const_mgr.add_const('EC_MARKER_HIT',0x00000042)
    win_const_mgr.add_const('VK_DECIMAL',0x0000006E)
    win_const_mgr.add_const('BTH_ERROR_SCO_AIRMODE_REJECTED',0x00000001)
    win_const_mgr.add_const('ERROR_IPSEC_BAD_SPI',0x00003656)
    win_const_mgr.add_const('POLICY_SHOWREASONUI_SERVERONLY',0x00000003)
    win_const_mgr.add_const('SQL_POS_UPDATE',0x00000004)
    win_const_mgr.add_const('DBPROPVAL_SQ_EXISTS',0x00000004)
    win_const_mgr.add_const('ES_NOHIDESEL',0x00000100)
    win_const_mgr.add_const('MCI_ANIM_OPEN_WS',0x00010000)
    win_const_mgr.add_const('TC_NONCONF_BORROW_PLUS',0x00000003)
    win_const_mgr.add_const('HSE_URL_FLAGS_SCRIPT',0x00000200)
    win_const_mgr.add_const('FILE_COMPRESSION_MSZIP',0x00000002)
    win_const_mgr.add_const('MHDR_ISSTRM',0x00000008)
    win_const_mgr.add_const('CM_PROB_FAILED_FILTER',0x00000007)
    win_const_mgr.add_const('AEC_MAX_SYSTEM_MODES',0x00000006)
    win_const_mgr.add_const('LOAD_TLB_AS_32BIT',0x00000020)
    win_const_mgr.add_const('NETE_NAMENOTFOUND',0x0000000D)
    win_const_mgr.add_const('ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED',0x0000078E)
    win_const_mgr.add_const('UINT8_ERROR',0x00000000)
    win_const_mgr.add_const('SUBLANG_DANISH_DENMARK',0x00000001)
    win_const_mgr.add_const('NET_VALIDATE_BAD_PASSWORD_COUNT',0x00000008)
    win_const_mgr.add_const('SERVICE_IP_CHKPT_NUM',0x000000FF)
    win_const_mgr.add_const('CQPM_SETDEFAULTPARAMETERS',0x00000009)
    win_const_mgr.add_const('RPC_C_STATS_CALLS_IN',0x00000000)
    win_const_mgr.add_const('DR_IG',0x0000003C)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_NETWORK_TCPIP',0x00010000)
    win_const_mgr.add_const('PSH_NOAPPLYNOW',0x00000080)
    win_const_mgr.add_const('WMDM_RIGHTS_FREESERIALIDS',0x00000008)
    win_const_mgr.add_const('LB_SETHORIZONTALEXTENT',0x00000194)
    win_const_mgr.add_const('NETERR_RING_STATUS_TRANSMIT_BEACON',0x00001000)
    win_const_mgr.add_const('SSF_SERVERADMINUI',0x00000004)
    win_const_mgr.add_const('CHANGER_MOVE_EXTENDS_IEPORT',0x80000200)
    win_const_mgr.add_const('ISC_REQ_RESERVED1',0x00100000)
    win_const_mgr.add_const('GCPCLASS_ARABIC',0x00000002)
    win_const_mgr.add_const('ERROR_UNABLE_TO_LOCK_MEDIA',0x00000454)
    win_const_mgr.add_const('DNS_ERROR_NON_RFC_NAME',0x00002554)
    win_const_mgr.add_const('MCI_VCR_SET_COUNTER_FORMAT',0x00080000)
    win_const_mgr.add_const('IMAGE_SUBSYSTEM_EFI_APPLICATION',0x0000000A)
    win_const_mgr.add_const('DB_MODE_READWRITE',0x00000003)
    win_const_mgr.add_const('SECBUFFER_PKG_PARAMS',0x00000003)
    win_const_mgr.add_const('MONITOR_DEFAULTTONULL',0x00000000)
    win_const_mgr.add_const('SV_TYPE_PARMNUM',0x00000069)
    win_const_mgr.add_const('PHOTO_FLASH_WITHOUTSTROBE',0x00000005)
    win_const_mgr.add_const('FILE_PREFETCH_TYPE_MAX',0x00000004)
    win_const_mgr.add_const('TURKISH_CHARSET',0x000000A2)
    win_const_mgr.add_const('SQLAOPANY',0x00000053)
    win_const_mgr.add_const('TC_NOTIFY_IFC_UP',0x00000001)
    win_const_mgr.add_const('PSR_PP',0x00000015)
    win_const_mgr.add_const('IME_ESC_PRIVATE_FIRST',0x00000800)
    win_const_mgr.add_const('JOB_OBJECT_LIMIT_SCHEDULING_CLASS',0x00000080)
    win_const_mgr.add_const('WM_NCMOUSELEAVE',0x000002A2)
    win_const_mgr.add_const('DPAMM_INSERT',0x00000003)
    win_const_mgr.add_const('DNS_TYPE_MX',0x00000000)
    win_const_mgr.add_const('EVENT_TRACE_TYPE_INFO',0x00000000)
    win_const_mgr.add_const('ED_RIGHT',0x00000400)
    win_const_mgr.add_const('LINEDEVSTATE_MAINTENANCE',0x00000100)
    win_const_mgr.add_const('SCRIPTTEXT_ISVISIBLE',0x00000002)
    win_const_mgr.add_const('SECPKG_CONTEXT_EXPORT_DELETE_OLD',0x00000002)
    win_const_mgr.add_const('FTP_TRANSFER_TYPE_BINARY',0x00000002)
    win_const_mgr.add_const('DBPROPVAL_OS_TXNENLISTMENT',0x00000002)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_MATCH',0x0000000D)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_SPLIT_IO',0x00200000)
    win_const_mgr.add_const('IF_TYPE_STANDALONE_WORKSTATION_DIALOUT',0x00000008)
    win_const_mgr.add_const('GGI_MARK_NONEXISTING_GLYPHS',0x00000000)
    win_const_mgr.add_const('DDCKEYCAPS_DESTBLT',0x00000001)
    win_const_mgr.add_const('OID_1394_VC_INFO',0x0C010102)
    win_const_mgr.add_const('PORT_ISOTSAP',0x00000066)
    win_const_mgr.add_const('VK_JUNJA',0x00000017)
    win_const_mgr.add_const('APMMENUSUSPEND_NOCHANGE',0x00000080)
    win_const_mgr.add_const('LANG_GALICIAN',0x00000056)
    win_const_mgr.add_const('DSOP_SCOPE_FLAG_WANT_DOWNLEVEL_BUILTIN_PATH',0x00000020)
    win_const_mgr.add_const('DEBUG_VALUE_FLOAT32',0x00000005)
    win_const_mgr.add_const('TTI_NONE',0x00000000)
    win_const_mgr.add_const('EDD_GET_DEVICE_INTERFACE_NAME',0x00000001)
    win_const_mgr.add_const('URLACTION_ACTIVEX_OVERRIDE_OPTIN',0x00001208)
    win_const_mgr.add_const('SQL_DIAG_CREATE_VIEW',0x00000054)
    win_const_mgr.add_const('DNS_ERROR_NODE_IS_DNAME',0x000025F8)
    win_const_mgr.add_const('CE_DNS',0x00000800)
    win_const_mgr.add_const('SCARD_W_CANCELLED_BY_USER',0x8010006E)
    win_const_mgr.add_const('XP1_SUPPORT_MULTIPOINT',0x00000400)
    win_const_mgr.add_const('SDP_ERROR_INVALID_PDU_SIZE',0x00000004)
    win_const_mgr.add_const('ICC_NATIVEFNTCTL_CLASS',0x00002000)
    win_const_mgr.add_const('MCI_DGV_MONITOR_FILE',0x00004001)
    win_const_mgr.add_const('CERT_RDN_NUMERIC_STRING',0x00000003)
    win_const_mgr.add_const('PROTO_TYPE_MS0',0x00000002)
    win_const_mgr.add_const('MCI_CONFIGURE',0x00000087)
    win_const_mgr.add_const('WM_POWERBROADCAST',0x00000218)
    win_const_mgr.add_const('LCMAP_SORTKEY',0x00000400)
    win_const_mgr.add_const('SUBLANG_URDU_INDIA',0x00000002)
    win_const_mgr.add_const('USER_DEFAULT_SCREEN_DPI',0x00000060)
    win_const_mgr.add_const('ACCESS_COUNT_PARMNUM',0x00000003)
    win_const_mgr.add_const('SPDRP_COMPATIBLEIDS',0x00000002)
    win_const_mgr.add_const('IF_CHECK_NONE',0x00000000)
    win_const_mgr.add_const('DXVA_MV_PRECISION_AND_CHROMA_RELATION_H263',0x00000001)
    win_const_mgr.add_const('RASLCPAP_PAP',0x0000C023)
    win_const_mgr.add_const('DNS_ERROR_INVALID_PROPERTY',0x00002551)
    win_const_mgr.add_const('OID_802_11_RADIO_STATUS',0x0D010125)
    win_const_mgr.add_const('DISPATCH_PROPERTYPUTREF',0x00000008)
    win_const_mgr.add_const('CE_OOP',0x00001000)
    win_const_mgr.add_const('KSEVENT_TYPE_SETSUPPORT',0x00000100)
    win_const_mgr.add_const('ACTIVATION_CONTEXT_SECTION_ASSEMBLY_INFORMATION',0x00000001)
    win_const_mgr.add_const('WINEVENT_SKIPOWNTHREAD',0x00000001)
    win_const_mgr.add_const('KERB_ETYPE_RSA_PUB_SHA1',0x0000000C)
    win_const_mgr.add_const('DI_REMOVEDEVICE_CONFIGSPECIFIC',0x00000002)
    win_const_mgr.add_const('DXVA_RESTRICTED_MODE_H264_F',0x00000069)
    win_const_mgr.add_const('DXVA_RESTRICTED_MODE_H264_D',0x00000067)
    win_const_mgr.add_const('DXVA_RESTRICTED_MODE_H264_E',0x00000068)
    win_const_mgr.add_const('DXVA_RESTRICTED_MODE_H264_B',0x00000065)
    win_const_mgr.add_const('DXVA_RESTRICTED_MODE_H264_C',0x00000066)
    win_const_mgr.add_const('DXVA_RESTRICTED_MODE_H264_A',0x00000064)
    win_const_mgr.add_const('BSF_LUID',0x00000400)
    win_const_mgr.add_const('INTERNET_DIAL_FORCE_PROMPT',0x00002000)
    win_const_mgr.add_const('TBDDRET_DEFAULT',0x00000000)
    win_const_mgr.add_const('WMDM_DEVICE_TYPE_ENCODE',0x00000008)
    win_const_mgr.add_const('ICW_LAUNCHEDFULL',0x00000100)
    win_const_mgr.add_const('ERROR_CARDBUS_NOT_SUPPORTED',0x000002D4)
    win_const_mgr.add_const('NDIS_PROTOCOL_ID_TCP_IP',0x00000002)
    win_const_mgr.add_const('SQL_CODE_DAY_TO_SECOND',0x0000000A)
    win_const_mgr.add_const('PROCESS_QUERY_INFORMATION',0x00000400)
    win_const_mgr.add_const('MB_PRECOMPOSED',0x00000001)
    win_const_mgr.add_const('DISPLAYDIB_NOCENTER',0x00000020)
    win_const_mgr.add_const('SQL_CA1_RELATIVE',0x00000004)
    win_const_mgr.add_const('TMT_INTEGRALSIZING',0x000008A3)
    win_const_mgr.add_const('SI_USER_PASSED',0x00000001)
    win_const_mgr.add_const('RTCMT_VIDEO_SEND',0x00000004)
    win_const_mgr.add_const('SV_TYPE_DOMAIN_CTRL',0x00000008)
    win_const_mgr.add_const('SQL_ATTR_PARAM_OPERATION_PTR',0x00000013)
    win_const_mgr.add_const('SERVICETYPE_NETWORK_CONTROL',0x0000000A)
    win_const_mgr.add_const('DN_NOT_FIRST_TIMEE',0x00080000)
    win_const_mgr.add_const('UNION_SMALL_ARMS',0x00000002)
    win_const_mgr.add_const('LAYOUT_RTL',0x00000001)
    win_const_mgr.add_const('RP_DSN_NOTIFY_NEVER',0x08000000)
    win_const_mgr.add_const('WSADESCRIPTION_LEN',0x00000100)
    win_const_mgr.add_const('WINHTTP_OPTION_USERNAME',0x00001000)
    win_const_mgr.add_const('DBTF_MEDIA',0x00000001)
    win_const_mgr.add_const('D3DFMT_X8R8G8B8',0x00000016)
    win_const_mgr.add_const('CMSG_SIGNER_UNAUTH_ATTR_PARAM',0x0000000A)
    win_const_mgr.add_const('SCARD_READER_TYPE_VENDOR',0x000000F0)
    win_const_mgr.add_const('HELP_HELPONHELP',0x00000004)
    win_const_mgr.add_const('WMSZ_TOPLEFT',0x00000004)
    win_const_mgr.add_const('WINHTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON',0x01000000)
    win_const_mgr.add_const('MDM_CELLULAR',0x00000008)
    win_const_mgr.add_const('GGL_STRING',0x00000003)
    win_const_mgr.add_const('D3DFVF_XYZB5',0x00000000)
    win_const_mgr.add_const('D3DFVF_XYZB4',0x00000000)
    win_const_mgr.add_const('D3DFVF_XYZB3',0x00000000)
    win_const_mgr.add_const('GUIDSTRING_MAX',0x00000001)
    win_const_mgr.add_const('D3DFVF_XYZB1',0x00000006)
    win_const_mgr.add_const('ILC_ORIGINALSIZE',0x00010000)
    win_const_mgr.add_const('HH_RESERVED1',0x0000000A)
    win_const_mgr.add_const('HH_RESERVED3',0x0000000C)
    win_const_mgr.add_const('SCARD_E_DIR_NOT_FOUND',0x80100023)
    win_const_mgr.add_const('MAX_VOLUME_TEMPLATE_SIZE',0x00000028)
    win_const_mgr.add_const('EDITF_ENABLEAKICRITICAL',0x00002000)
    win_const_mgr.add_const('DEBUG_INTERRUPT_EXIT',0x00000002)
    win_const_mgr.add_const('COLOR_WINDOWTEXT',0x00000008)
    win_const_mgr.add_const('DRM_SIGN_ONLINE',0x00000001)
    win_const_mgr.add_const('PDH_CALC_NEGATIVE_TIMEBASE',0x800007D7)
    win_const_mgr.add_const('CERT_RDN_DISABLE_IE4_UTF8_FLAG',0x01000000)
    win_const_mgr.add_const('COLOR_INACTIVEBORDER',0x0000000B)
    win_const_mgr.add_const('MDPROPVAL_MSF_BOTTOMSUM',0x00000008)
    win_const_mgr.add_const('SQL_HC_ON',0x00000001)
    win_const_mgr.add_const('MAPI_AB_NOMODIFY',0x00000400)
    win_const_mgr.add_const('HTTP_PROTOCOL_UUID16',0x0000000C)
    win_const_mgr.add_const('WLX_SAS_ACTION_SHUTDOWN_SLEEP2',0x0000000D)
    win_const_mgr.add_const('DMDUP_VERTICAL',0x00000002)
    win_const_mgr.add_const('ERROR_DS_NO_MSDS_INTID',0x00002194)
    win_const_mgr.add_const('PIFSHDATASIZE',0x00000040)
    win_const_mgr.add_const('DBPROPVAL_BD_REORGANIZATION',0x00000003)
    win_const_mgr.add_const('WMT_VIDEOIMAGE_TRANSITION_FADE_TO_COLOR',0x00000010)
    win_const_mgr.add_const('LR_MONOCHROME',0x00000001)
    win_const_mgr.add_const('SQL_DS_DROP_SCHEMA',0x00000001)
    win_const_mgr.add_const('EMR_SETWORLDTRANSFORM',0x00000023)
    win_const_mgr.add_const('FCT_CONFIGABLE',0x00000002)
    win_const_mgr.add_const('ERROR_SXS_XML_E_INVALID_VERSION',0x000036F8)
    win_const_mgr.add_const('DNS_ERROR_RCODE_YXDOMAIN',0x0000232E)
    win_const_mgr.add_const('SHUTDOWN_NOREBOOT',0x00000010)
    win_const_mgr.add_const('CRESTRICTIONS_DBSCHEMA_COLUMN_DOMAIN_USAGE',0x00000004)
    win_const_mgr.add_const('SECPKG_ATTR_SASL_CONTEXT',0x00010000)
    win_const_mgr.add_const('ERROR_PATCH_NO_SEQUENCE',0x00000670)
    win_const_mgr.add_const('MOVEFILE_WRITE_THROUGH',0x00000008)
    win_const_mgr.add_const('DMPAPER_ENV_C3',0x0000001D)
    win_const_mgr.add_const('STM_ORDER_BY_INTERFACE_TYPE_NAME',0x00000001)
    win_const_mgr.add_const('DXVA_RESTRICTED_MODE_H263_E',0x00000007)
    win_const_mgr.add_const('DXVA_RESTRICTED_MODE_H263_D',0x00000006)
    win_const_mgr.add_const('DXVA_RESTRICTED_MODE_H263_F',0x00000008)
    win_const_mgr.add_const('DXVA_RESTRICTED_MODE_H263_A',0x00000003)
    win_const_mgr.add_const('DXVA_RESTRICTED_MODE_H263_C',0x00000005)
    win_const_mgr.add_const('DXVA_RESTRICTED_MODE_H263_B',0x00000004)
    win_const_mgr.add_const('SYMF_FORWARDER',0x00000400)
    win_const_mgr.add_const('URLACTION_SHELL_RTF_OBJECTS_LOAD',0x0000180A)
    win_const_mgr.add_const('VIDCF_QUALITY',0x00000001)
    win_const_mgr.add_const('WIA_DPS_PAGE_WIDTH',0x00000C1A)
    win_const_mgr.add_const('IMAGE_REL_CEF_SECREL',0x00000005)
    win_const_mgr.add_const('SQL_TIME_LEN',0x00000008)
    win_const_mgr.add_const('IDS_CAP_CANTOPEN',0x00000199)
    win_const_mgr.add_const('RATING_FIVE_STARS_MAX',0x00000063)
    win_const_mgr.add_const('ACCESS_MAX_MS_V2_ACE_TYPE',0x00000003)
    win_const_mgr.add_const('EVENT_SYSTEM_DIALOGSTART',0x00000010)
    win_const_mgr.add_const('PFNS_PERIOD',0x00000200)
    win_const_mgr.add_const('SSF_SHOWTYPEOVERLAY',0x02000000)
    win_const_mgr.add_const('PAN_BENT_ARMS_SINGLE_SERIF',0x0000000A)
    win_const_mgr.add_const('DXVA_DPXD_SURFACE_BUFFER',0x0000000A)
    win_const_mgr.add_const('FS_NOT_FAX_CALL',0x20001000)
    win_const_mgr.add_const('DSF_SHOW_OFFLINE',0x00020000)
    win_const_mgr.add_const('MCI_LOAD_FILE',0x00000100)
    win_const_mgr.add_const('MD_ERROR_SUB403_DIR_LIST_DENIED',0x0000000E)
    win_const_mgr.add_const('DNS_OPCODE_NOTIFY',0x00000004)
    win_const_mgr.add_const('JOB_OBJECT_LIMIT_VALID_FLAGS',0x00000007)
    win_const_mgr.add_const('WM_MEASUREITEM',0x0000002C)
    win_const_mgr.add_const('APPCOMMAND_LAUNCH_APP1',0x00000011)
    win_const_mgr.add_const('POLICY_ERRV_EXPIRED_USER_TOKEN',0x00000033)
    win_const_mgr.add_const('IITWBC_BREAKTYPE_EPOCH',0x00000004)
    win_const_mgr.add_const('ERROR_DS_WRONG_OM_OBJ_CLASS',0x0000211C)
    win_const_mgr.add_const('APPCOMMAND_LAUNCH_APP2',0x00000012)
    win_const_mgr.add_const('CONTEXT_MENU_TEXTSELECT',0x00000004)
    win_const_mgr.add_const('FLAG_NO_GPO_FILTER',0x80000000)
    win_const_mgr.add_const('WIA_COMPRESSION_BI_RLE8',0x00000002)
    win_const_mgr.add_const('SECPKG_ALT_ATTR',0x80000000)
    win_const_mgr.add_const('PROP_ID_SECURE_MAX',0x000067FF)
    win_const_mgr.add_const('AGP_FLAG_NO_FW_ENABLE',0x00000200)
    win_const_mgr.add_const('NDR64_FC_EXPLICIT_HANDLE',0x00000000)
    win_const_mgr.add_const('VIEW_PRIORITY_CACHEHIT',0x00000050)
    win_const_mgr.add_const('SQL_SP_ISNULL',0x00000004)
    win_const_mgr.add_const('CONSOLE_FULLSCREEN_HARDWARE',0x00000002)
    win_const_mgr.add_const('CERT_TRUST_INVALID_POLICY_CONSTRAINTS',0x00000200)
    win_const_mgr.add_const('MARSHAL_E_LAST',0x8004012F)
    win_const_mgr.add_const('MCI_WAVE_GETDEVCAPS_OUTPUTS',0x00004002)
    win_const_mgr.add_const('COPYFLG_FORCE_FILE_IN_USE',0x00000008)
    win_const_mgr.add_const('ERROR_NETWORK_BUSY',0x00000036)
    win_const_mgr.add_const('ERROR_LOG_METADATA_FLUSH_FAILED',0x000019F5)
    win_const_mgr.add_const('RTS_CONTROL_ENABLE',0x00000001)
    win_const_mgr.add_const('PHOTOACQ_DISABLE_DUPLICATE_DETECTION',0x00000040)
    win_const_mgr.add_const('IOF_DISABLEDISPLAYASICON',0x00000400)
    win_const_mgr.add_const('MAXCHAR',0x00000007)
    win_const_mgr.add_const('DISPID_IHTMLDLGSAFEHELPER_CHOOSECOLORDLG',0x00000001)
    win_const_mgr.add_const('MDPROPVAL_MC_SEARCHEDCASE',0x00000002)
    win_const_mgr.add_const('ERROR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION',0x0000030F)
    win_const_mgr.add_const('EVENT_TRACE_FLAG_FILE_IO',0x02000000)
    win_const_mgr.add_const('HEAP_REALLOC_IN_PLACE_ONLY',0x00000010)
    win_const_mgr.add_const('SQL_PS_SELECT_FOR_UPDATE',0x00000004)
    win_const_mgr.add_const('WLX_OPTION_USE_SMART_CARD',0x00000003)
    win_const_mgr.add_const('NCRYPTBUFFER_SSL_KEY_ARG_DATA',0x00000018)
    win_const_mgr.add_const('ERROR_PIPE_LOCAL',0x000000E5)
    win_const_mgr.add_const('SQL_FN_NUM_DEGREES',0x00040000)
    win_const_mgr.add_const('ERROR_LOG_CONTAINER_WRITE_FAILED',0x000019F0)
    win_const_mgr.add_const('IDI_RESOURCEFIRST',0x0000009F)
    win_const_mgr.add_const('IDTB_CONTENTS',0x000000D5)
    win_const_mgr.add_const('OID_TAPI_CLOSE_CALL',0x07030104)
    win_const_mgr.add_const('WM_NCMOUSEMOVE',0x000000A0)
    win_const_mgr.add_const('NDIS_802_11_AUTH_REQUEST_REAUTH',0x00000001)
    win_const_mgr.add_const('MCI_DGV_OPEN_NOSTATIC',0x00040000)
    win_const_mgr.add_const('VER_ERR_ADDL_MSG',0x00008000)
    win_const_mgr.add_const('HTTP_LOG_FIELD_HOST',0x00100000)
    win_const_mgr.add_const('EVENTLOG_SEEK_READ',0x00000002)
    win_const_mgr.add_const('SECQOP_WRAP_NO_ENCRYPT',0x80000001)
    win_const_mgr.add_const('GL_PRE_BEGIN_REQUEST',0x00000100)
    win_const_mgr.add_const('IDD_GNRLPROPS4',0x00000452)
    win_const_mgr.add_const('WMS_DATA_CONTAINER_NONSEEKABLE',0xFFFFFFFFFFFFFFFF)
    win_const_mgr.add_const('IDH_HELP',0x00006F1D)
    win_const_mgr.add_const('TASK_DECEMBER',0x00000800)
    win_const_mgr.add_const('MCI_VCR_SIGNAL_USERVAL',0x00040000)
    win_const_mgr.add_const('SN_CODE',0x00000000)
    win_const_mgr.add_const('MDPROPVAL_MD_SELF',0x00000001)
    win_const_mgr.add_const('LABEL_SECURITY_INFORMATION',0x00000010)
    win_const_mgr.add_const('AD_APPLY_SAVE',0x00000001)
    win_const_mgr.add_const('PMSF_DONT_STRIP_SPACES',0x00010000)
    win_const_mgr.add_const('LBS_MULTIPLESEL',0x00000008)
    win_const_mgr.add_const('SYNCMGRREGISTERFLAGS_MASK',0x00000007)
    win_const_mgr.add_const('WMDRM_DEVICE_ISWMDRM',0x00000001)
    win_const_mgr.add_const('VIDEO_DLG_QUERY',0x00000010)
    win_const_mgr.add_const('EDITF_AUDITCERTTEMPLATELOAD',0x00200000)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_SAVEPOINT',0x00080000)
    win_const_mgr.add_const('CERT_NO_AUTO_EXPIRE_CHECK_PROP_ID',0x0000004D)
    win_const_mgr.add_const('CRYPT_RC2_56BIT_VERSION',0x00000034)
    win_const_mgr.add_const('IPSEC_SA_BUNDLE_FLAG_NO_MACHINE_LUID_VERIFY',0x00000020)
    win_const_mgr.add_const('IDS_CAP_AUDIO_DROP_ERROR',0x000001B9)
    win_const_mgr.add_const('IDC_CV_RESULTTEXT',0x0000009D)
    win_const_mgr.add_const('DOT11_STATUS_UNSUPPORTED_PRIORITY',0x00000004)
    win_const_mgr.add_const('TMT_AUTHOR',0x0000025C)
    win_const_mgr.add_const('ICW_LAUNCHMANUAL',0x00000200)
    win_const_mgr.add_const('SSIZE_T_MAX',0x7FFFFFFF)
    win_const_mgr.add_const('BITS_MC_JOB_CANCELLED',0x80194000)
    win_const_mgr.add_const('CRYPTDLG_REVOCATION_DEFAULT',0x00000000)
    win_const_mgr.add_const('LINEADDRCAPFLAGS_FWDNUMRINGS',0x00000001)
    win_const_mgr.add_const('IME_MODE_DBCSCHAR',0x00000010)
    win_const_mgr.add_const('DDSCL_CREATEDEVICEWINDOW',0x00000200)
    win_const_mgr.add_const('CR_FLG_SUBJECTUNMODIFIED',0x00000020)
    win_const_mgr.add_const('OFFLINESTATUS_OFFLINE_SLOW',0x00000003)
    win_const_mgr.add_const('DVB_SDT_OTHER_TID',0x00000046)
    win_const_mgr.add_const('DNS_TYPE_A',0x00000001)
    win_const_mgr.add_const('SSF_SHOWATTRIBCOL',0x00000100)
    win_const_mgr.add_const('SSPROPVAL_USEPROCFORPREP_ON_DROP',0x00000002)
    win_const_mgr.add_const('HTTP_QUERY_ACCEPT_RANGES',0x0000002A)
    win_const_mgr.add_const('LDAP_MOD_ADD',0x00000000)
    win_const_mgr.add_const('TXTBIT_CLIENTRECTCHANGE',0x00100000)
    win_const_mgr.add_const('WMI_GLOBAL_LOGGER_ID',0x00000001)
    win_const_mgr.add_const('USE_DISKDEV',0x00000000)
    win_const_mgr.add_const('ERROR_DS_GCVERIFY_ERROR',0x000020E1)
    win_const_mgr.add_const('SECURITY_MANDATORY_HIGH_RID',0x00003000)
    win_const_mgr.add_const('PORT_VMNET',0x000000AF)
    win_const_mgr.add_const('IDENTIFIER_SDK_ERROR',0x10000000)
    win_const_mgr.add_const('COOKIE_ALLOW_ALL',0x00000004)
    win_const_mgr.add_const('RESOURCEMANAGER_COMPLETE_PROPAGATION',0x00000040)
    win_const_mgr.add_const('MD_ACR_ENUM_KEYS',0x00000008)
    win_const_mgr.add_const('SEC_NOCACHE',0x10000000)
    win_const_mgr.add_const('SCARD_UNPOWER_CARD',0x00000002)
    win_const_mgr.add_const('PROPCALLER_EXIT',0x00000300)
    win_const_mgr.add_const('INTERNET_OPTION_MAX_CONNS_PER_1_0_SERVER',0x0000004A)
    win_const_mgr.add_const('RES_SERVICE',0x00000004)
    win_const_mgr.add_const('PER_USER_AUDIT_SUCCESS_INCLUDE',0x00000001)
    win_const_mgr.add_const('SUBLANG_SPANISH_US',0x00000015)
    win_const_mgr.add_const('TMT_TEXTCOLORHINT',0x00000EF0)
    win_const_mgr.add_const('DSBI_CHECKBOXES',0x00000100)
    win_const_mgr.add_const('WSA_QOS_EFILTERTYPE',0x00002B0C)
    win_const_mgr.add_const('RTCMT_AUDIO_RECEIVE',0x00000002)
    win_const_mgr.add_const('DNS_RTYPE_SRV',0x00002100)
    win_const_mgr.add_const('AVIFILECAPS_NOCOMPRESSION',0x00000020)
    win_const_mgr.add_const('SQL_DYNAMIC_CURSOR_ATTRIBUTES1',0x00000090)
    win_const_mgr.add_const('IDC_OLEUIHELP',0x00000063)
    win_const_mgr.add_const('ERROR_TOO_MANY_OPEN_FILES',0x00000004)
    win_const_mgr.add_const('WNTYPE_COMM',0x00000004)
    win_const_mgr.add_const('POLICY_ERRV_NO_MEMORY',0x00000038)
    win_const_mgr.add_const('SHUTDOWN_RESTART',0x00000004)
    win_const_mgr.add_const('SQL_QU_INDEX_DEFINITION',0x00000008)
    win_const_mgr.add_const('ROTFLAGS_REGISTRATIONKEEPSALIVE',0x00000001)
    win_const_mgr.add_const('INET_ADDRSTRLEN',0x00000016)
    win_const_mgr.add_const('NTMS_OMID_TYPE_RAW_LABEL',0x00000001)
    win_const_mgr.add_const('EVENT_ACTIVITY_CTRL_CREATE_SET_ID',0x00000005)
    win_const_mgr.add_const('IDM_CODE',0x0000000E)
    win_const_mgr.add_const('PROXY_TYPE_AUTO_PROXY_URL',0x00000004)
    win_const_mgr.add_const('DDSD_SRCVBHANDLE',0x00400000)
    win_const_mgr.add_const('FILE_PREFETCH_TYPE_FOR_CREATE',0x00000001)
    win_const_mgr.add_const('ERROR_DS_TREE_DELETE_NOT_FINISHED',0x000020CD)
    win_const_mgr.add_const('PHONEERR_INVALBUTTONLAMPID',0x90000009)
    win_const_mgr.add_const('LR_COPYRETURNORG',0x00000004)
    win_const_mgr.add_const('SC_PREVWINDOW',0x0000F050)
    win_const_mgr.add_const('LDAP_SUBSTRING_FINAL',0x00000082)
    win_const_mgr.add_const('DBPROPVAL_SS_ISTORAGE',0x00000004)
    win_const_mgr.add_const('WIA_IPA_GAMMA_CURVES',0x00001013)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_CLEARINTERVAL',0x0000048B)
    win_const_mgr.add_const('IN_CLASSD_NSHIFT',0x0000001C)
    win_const_mgr.add_const('DDSCAPS_PALETTE',0x00000100)
    win_const_mgr.add_const('DBIMF_ALWAYSGRIPPER',0x00001000)
    win_const_mgr.add_const('PCI_OPTIONS_USE_BIOS',0x00000001)
    win_const_mgr.add_const('INTERNET_MAX_USER_NAME_LENGTH',0x00000080)
    win_const_mgr.add_const('COPY_FILE_ALLOW_DECRYPTED_DESTINATION',0x00000008)
    win_const_mgr.add_const('GL_ID_CHOOSECANDIDATE',0x00000028)
    win_const_mgr.add_const('ERROR_RXACT_COMMIT_FAILURE',0x0000055A)
    win_const_mgr.add_const('DC_ENUMRESOLUTIONS',0x0000000D)
    win_const_mgr.add_const('SECURITY_DESCRIPTOR_REVISION',0x00000001)
    win_const_mgr.add_const('AM_QUERY_DECODER_ATSC_HD_SUPPORT',0x00000005)
    win_const_mgr.add_const('SSPROPVAL_COMMANDTYPE_BULKLOAD',0x00000016)
    win_const_mgr.add_const('SIZE_MINIMIZED',0x00000001)
    win_const_mgr.add_const('D3DCREATE_SCREENSAVER',0x10000000)
    win_const_mgr.add_const('DI_CHANNEL',0x00000001)
    win_const_mgr.add_const('TVS_EX_FADEINOUTEXPANDOS',0x00000040)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_INVALID_HASH_ALG',0x0000362F)
    win_const_mgr.add_const('DISPID_ADDDESKTOPCOMPONENT',0x00000006)
    win_const_mgr.add_const('SENSITIVITY_PROP_CONFIDENTIAL',0x00000003)
    win_const_mgr.add_const('URL_FILE_USE_PATHURL',0x00010000)
    win_const_mgr.add_const('SQL_DESC_DATA_PTR',0x000003F2)
    win_const_mgr.add_const('DDFLIP_INTERVAL4',0x04000000)
    win_const_mgr.add_const('DDFLIP_INTERVAL3',0x03000000)
    win_const_mgr.add_const('DDFLIP_INTERVAL2',0x02000000)
    win_const_mgr.add_const('CD_LBSELADD',0x00000002)
    win_const_mgr.add_const('REG_REFRESH_HIVE',0x00000002)
    win_const_mgr.add_const('CERT_NAME_STR_CRLF_FLAG',0x08000000)
    win_const_mgr.add_const('DDSCAPS2_HINTSTATIC',0x00000008)
    win_const_mgr.add_const('DISPID_ROOT',0x00000010)
    win_const_mgr.add_const('COMMON_LVB_GRID_LVERTICAL',0x00000800)
    win_const_mgr.add_const('IMAGE_SCN_MEM_PURGEABLE',0x00020000)
    win_const_mgr.add_const('OFN_READONLY',0x00000001)
    win_const_mgr.add_const('VP_MODE_WIN_GRAPHICS',0x00000001)
    win_const_mgr.add_const('MDMEASURE_AGGR_MIN',0x00000003)
    win_const_mgr.add_const('METHOD_OUT_DIRECT',0x00000002)
    win_const_mgr.add_const('MAX_EAP_CONFIG_INPUT_FIELD_LENGTH',0x00000100)
    win_const_mgr.add_const('SYMF_REGISTER',0x00000008)
    win_const_mgr.add_const('MAPI_TO',0x00000001)
    win_const_mgr.add_const('ISCSI_LOGIN_FLAG_USE_RADIUS_RESPONSE',0x00000010)
    win_const_mgr.add_const('SHCNF_FLUSHNOWAIT',0x00002000)
    win_const_mgr.add_const('RSC_MODE',0x00000000)
    win_const_mgr.add_const('ISR_ILLEGAL_OP',0x00000000)
    win_const_mgr.add_const('RP_DSN_NOTIFY_DELAY',0x04000000)
    win_const_mgr.add_const('EMR_DELETEOBJECT',0x00000028)
    win_const_mgr.add_const('JS_NOLINE',0x00000010)
    win_const_mgr.add_const('C1_DIGIT',0x00000004)
    win_const_mgr.add_const('PC_NONE',0x00000000)
    win_const_mgr.add_const('SEC_WINNT_AUTH_IDENTITY_MARSHALLED',0x00000004)
    win_const_mgr.add_const('TIME_CALLBACK_EVENT_SET',0x00000010)
    win_const_mgr.add_const('DISPID_IHTMLWINDOW2_CLOSE',0x00000003)
    win_const_mgr.add_const('NDIS_STATISTICS_FLAGS_VALID_MULTICAST_BYTES_XMIT',0x00100000)
    win_const_mgr.add_const('CF_PRINTERFONTS',0x00000002)
    win_const_mgr.add_const('PDH_LOG_CREATE_NEW',0x00000001)
    win_const_mgr.add_const('SQL_CONVERT_INTERVAL_DAY_TIME',0x0000007B)
    win_const_mgr.add_const('NI_IMEMENUSELECTED',0x00000018)
    win_const_mgr.add_const('FCIDM_BROWSERFIRST',0x00000000)
    win_const_mgr.add_const('LINEDEVSTATE_NUMCOMPLETIONS',0x00001000)
    win_const_mgr.add_const('PIR_STATUS_TABLE_NONE',0x00000003)
    win_const_mgr.add_const('PSH_USEHBMHEADER',0x00100000)
    win_const_mgr.add_const('SV_CRITICALTHREADS_PARMNUM',0x0000023C)
    win_const_mgr.add_const('SPINST_PROFILEITEMS',0x00000100)
    win_const_mgr.add_const('WAVE_INVALIDFORMAT',0x00000000)
    win_const_mgr.add_const('CFM_SPACING',0x00200000)
    win_const_mgr.add_const('DLLVER_PLATFORM_NT',0x00000002)
    win_const_mgr.add_const('TRACELOG_REGISTER_GUIDS',0x00000800)
    win_const_mgr.add_const('SP_COPY_INBOX_INF',0x08000000)
    win_const_mgr.add_const('MCI_OPEN_ELEMENT_ID',0x00000800)
    win_const_mgr.add_const('PHONEFEATURE_SETVOLUMESPEAKER',0x04000000)
    win_const_mgr.add_const('DEBUG_VSOURCE_MAPPED_IMAGE',0x00000002)
    win_const_mgr.add_const('ERROR_DS_OBJ_STRING_NAME_EXISTS',0x00002071)
    win_const_mgr.add_const('DPD_DELETE_ALL_FILES',0x00000004)
    win_const_mgr.add_const('DMPAPER_ENV_PERSONAL',0x00000026)
    win_const_mgr.add_const('WM_RBUTTONDBLCLK',0x00000206)
    win_const_mgr.add_const('SQL_CURRENT_QUALIFIER',0x0000006D)
    win_const_mgr.add_const('BCRYPT_PAD_PKCS1',0x00000002)
    win_const_mgr.add_const('PDH_SQL_BIND_FAILED',0xC0000BE7)
    win_const_mgr.add_const('GAA_FLAG_SKIP_ANYCAST',0x00000002)
    win_const_mgr.add_const('DEBUG_DUMP_FILE_BASE',0x00000000)
    win_const_mgr.add_const('SOFTDIST_ADSTATE_AVAILABLE',0x00000001)
    win_const_mgr.add_const('TMT_CLASSICVALUE',0x00000C82)
    win_const_mgr.add_const('PSINJECT_ENDPAGECOMMENTS',0x0000006B)
    win_const_mgr.add_const('MDM_FLOWCONTROL_HARD',0x00000010)
    win_const_mgr.add_const('KSRELATIVEEVENT_FLAG_POINTER',0x00000002)
    win_const_mgr.add_const('ERROR_CLUSTER_PARTIAL_SEND',0x0000171A)
    win_const_mgr.add_const('AUTODIAL_MODE_NO_NETWORK_PRESENT',0x00000004)
    win_const_mgr.add_const('AUTO_PROXY_FLAG_MIGRATED',0x00000008)
    win_const_mgr.add_const('LCMAP_SIMPLIFIED_CHINESE',0x02000000)
    win_const_mgr.add_const('ERROR_TRANSACTIONMANAGER_NOT_FOUND',0x00001A3E)
    win_const_mgr.add_const('PERF_DISPLAY_SECONDS',0x30000000)
    win_const_mgr.add_const('DEBUG_REQUEST_GET_ADDITIONAL_CREATE_OPTIONS',0x00000004)
    win_const_mgr.add_const('TMT_GLYPHTRANSPARENTCOLOR',0x00000EEC)
    win_const_mgr.add_const('SNMPAPI_VBL_INVALID',0x0000000F)
    win_const_mgr.add_const('SCRIPTPROC_ISEXPRESSION',0x00000020)
    win_const_mgr.add_const('MCI_GETDEVCAPS_HAS_AUDIO',0x00000002)
    win_const_mgr.add_const('ED_AUDIO_ALL',0x10000000)
    win_const_mgr.add_const('IMAGE_REL_PPC_IMGLUE',0x0000000E)
    win_const_mgr.add_const('CRYPT_CHECK_FRESHNESS_TIME_VALIDITY',0x00000400)
    win_const_mgr.add_const('PHOTO_METERINGMODE_CENTER',0x00000002)
    win_const_mgr.add_const('ERROR_MAX_SESSIONS_REACHED',0x00000161)
    win_const_mgr.add_const('HCBT_QS',0x00000002)
    win_const_mgr.add_const('MDM_V110_SPEED_9DOT6K',0x00000004)
    win_const_mgr.add_const('MD_ERROR_SUB403_SITE_ACCESS_DENIED',0x00000008)
    win_const_mgr.add_const('LVS_REPORT',0x00000001)
    win_const_mgr.add_const('SQL_STATIC_SENSITIVITY',0x00000053)
    win_const_mgr.add_const('ERROR_STACK_OVERFLOW',0x000003E9)
    win_const_mgr.add_const('PERCEIVEDFLAG_ZIPFOLDER',0x00000040)
    win_const_mgr.add_const('EMR_SETPIXELV',0x0000000F)
    win_const_mgr.add_const('ILS_SHADOW',0x00000002)
    win_const_mgr.add_const('ERROR_REQUEST_REFUSED',0x000010E0)
    win_const_mgr.add_const('RANDOM_PADDING',0x00000002)
    win_const_mgr.add_const('RTCIF_DISABLE_STRICT_DNS',0x00000008)
    win_const_mgr.add_const('TA_LEFT',0x00000000)
    win_const_mgr.add_const('THREAD_GET_CONTEXT',0x00000008)
    win_const_mgr.add_const('DDOVERFX_MIRRORUPDOWN',0x00000004)
    win_const_mgr.add_const('OID_CO_TAPI_ADDRESS_CAPS',0xFE001003)
    win_const_mgr.add_const('ETW_WMITIME_TYPE_VALUE',0x00000076)
    win_const_mgr.add_const('PROV_DSS',0x00000003)
    win_const_mgr.add_const('DS_LOCALEDIT',0x00000020)
    win_const_mgr.add_const('IDM_UPDATEPAGESTATUS',0x00000968)
    win_const_mgr.add_const('MCI_ANIM_STATUS_STRETCH',0x00004005)
    win_const_mgr.add_const('WB_CLASSIFY',0x00000003)
    win_const_mgr.add_const('ICINSTALL_DRIVERW',0x00008002)
    win_const_mgr.add_const('LANG_TIGRIGNA',0x00000073)
    win_const_mgr.add_const('PRINTER_STATUS_PAUSED',0x00000001)
    win_const_mgr.add_const('ERROR_FILE_INVALID',0x000003EE)
    win_const_mgr.add_const('SHDID_COMPUTER_DRIVE35',0x00000005)
    win_const_mgr.add_const('ERROR_OPLOCK_NOT_GRANTED',0x0000012C)
    win_const_mgr.add_const('NOTIFIER_TYPE_NOTIFY_EVENT',0x00000004)
    win_const_mgr.add_const('MF_REMOVE',0x00001000)
    win_const_mgr.add_const('MB_DEFMASK',0x00000F00)
    win_const_mgr.add_const('OPERATION_BROADCAST',0x00000002)
    win_const_mgr.add_const('SQL_DESC_COUNT',0x000003E9)
    win_const_mgr.add_const('TBCD_CHANNEL',0x00000003)
    win_const_mgr.add_const('BAUD_USER',0x10000000)
    win_const_mgr.add_const('ICON_BIG',0x00000001)
    win_const_mgr.add_const('SKF_LWINLOCKED',0x00400000)
    win_const_mgr.add_const('OS_ANYSERVER',0x0000001D)
    win_const_mgr.add_const('LUA_TOKEN',0x00000004)
    win_const_mgr.add_const('EMR_PIXELFORMAT',0x00000068)
    win_const_mgr.add_const('NONANTIALIASED_QUALITY',0x00000003)
    win_const_mgr.add_const('TCHT_ONITEMLABEL',0x00000004)
    win_const_mgr.add_const('WM_CHANGEUISTATE',0x00000127)
    win_const_mgr.add_const('SPEAKER_BACK_LEFT',0x00000010)
    win_const_mgr.add_const('ERROR_IPSEC_IKE_SA_REAPED',0x000035F0)
    win_const_mgr.add_const('_INC_MMREG',0x0000009E)
    win_const_mgr.add_const('ERROR_INVALID_ORDINAL',0x000000B6)
    win_const_mgr.add_const('CREATE_EVENT_MANUAL_RESET',0x00000001)
    win_const_mgr.add_const('SV_LINKINFOVALIDTIME_PARMNUM',0x0000022A)
    win_const_mgr.add_const('LINEPARKMODE_DIRECTED',0x00000001)
    win_const_mgr.add_const('KSPIN_FLAG_FRAMES_NOT_REQUIRED_FOR_PROCESSING',0x00000040)
    win_const_mgr.add_const('ED_BOTTOM',0x00000004)
    win_const_mgr.add_const('SECURITY_ENTERPRISE_READONLY_CONTROLLERS_RID',0x00000016)
    win_const_mgr.add_const('SN_DATA',0x00000001)
    win_const_mgr.add_const('SQL_FN_TSI_WEEK',0x00000020)
    win_const_mgr.add_const('PROCESSOR_ARCHITECTURE_AMD64',0x00000009)
    win_const_mgr.add_const('TBIF_STYLE',0x00000008)
    win_const_mgr.add_const('VER_LESS',0x00000004)
    win_const_mgr.add_const('ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD',0x00002151)
    win_const_mgr.add_const('IDM_ZOOMPOPUP',0x0000085C)
    win_const_mgr.add_const('TTF_ABSOLUTE',0x00000080)
    win_const_mgr.add_const('SQL_LOGIN_TIMEOUT',0x00000067)
    win_const_mgr.add_const('DTT_CALCRECT',0x00000001)
    win_const_mgr.add_const('SPI_GETUIEFFECTS',0x0000103E)
    win_const_mgr.add_const('FL_UFI_PRIVATEFONT',0x00000001)
    win_const_mgr.add_const('SQL_FN_NUM_FLOOR',0x00000200)
    win_const_mgr.add_const('DISPID_SELECTIONCHANGE',0x00000002)
    win_const_mgr.add_const('PROTO_IP_IGMP',0x0000000A)
    win_const_mgr.add_const('ODBC_ERROR_INVALID_HWND',0x00000003)
    win_const_mgr.add_const('RTCEF_PARTICIPANT_STATE_CHANGE',0x00000010)
    win_const_mgr.add_const('SERVICE_STOP_REASON_MINOR_INSTALLATION',0x00000003)
    win_const_mgr.add_const('PKCS12_ALWAYS_CNG_KSP',0x00000200)
    win_const_mgr.add_const('CYPHER_BLOCK_LENGTH',0x00000008)
    win_const_mgr.add_const('FWPS_METADATA_FIELD_DISCARD_REASON',0x00000001)
    win_const_mgr.add_const('LINECALLREASON_FWDUNCOND',0x00000008)
    win_const_mgr.add_const('DEBUG_ASMOPT_SOURCE_LINE_NUMBER',0x00000008)
    win_const_mgr.add_const('JOB_OBJECT_SECURITY_VALID_FLAGS',0x00000000)
    win_const_mgr.add_const('WMDRM_ACQUIRE_LICENSE_NONSILENT',0x00000002)
    win_const_mgr.add_const('WM_FONTCHANGE',0x0000001D)
    win_const_mgr.add_const('ERROR_TOO_MANY_NAMES',0x00000044)
    win_const_mgr.add_const('AUTH_REQ_ALLOW_RENEWABLE',0x00000008)
    win_const_mgr.add_const('ERROR_DS_NOT_CLOSEST',0x0000218C)
    win_const_mgr.add_const('ISR_IA_VECTOR',0x00000010)
    win_const_mgr.add_const('SCESTATUS_BUFFER_TOO_SMALL',0x00000005)
    win_const_mgr.add_const('CERT_STORE_LOCALIZED_NAME_PROP_ID',0x00001000)
    win_const_mgr.add_const('CMIC_MASK_SHIFT_DOWN',0x10000000)
    win_const_mgr.add_const('WTS_CONSOLE_DISCONNECT',0x00000002)
    win_const_mgr.add_const('WNFMT_ABBREVIATED',0x00000002)
    win_const_mgr.add_const('PORT_NSWFE',0x0000001B)
    win_const_mgr.add_const('SAP_FIELD_ABSENT',0xFFFFFFFE)
    win_const_mgr.add_const('IDM_UNKNOWN',0x00000000)
    win_const_mgr.add_const('MQMSG_AUTHENTICATED_SIG10',0x00000001)
    win_const_mgr.add_const('RTCMT_AUDIO_SEND',0x00000001)
    win_const_mgr.add_const('BAUD_110',0x00000002)
    win_const_mgr.add_const('LV_VIEW_SMALLICON',0x00000002)
    win_const_mgr.add_const('CERT_CHAIN_POLICY_IGNORE_CTL_NOT_TIME_VALID_FLAG',0x00000002)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_ROLLBACK_COMPLETE',0x00000080)
    win_const_mgr.add_const('BITS_MC_PEERCACHING_PORT',0x8019400A)
    win_const_mgr.add_const('DISPID_IDISCFORMAT2DATA_RECORDER',0x00000100)
    win_const_mgr.add_const('CS_INSERTCHAR',0x00002000)
    win_const_mgr.add_const('MPR_INTERFACE_SERVICE_PAUSED',0x00000008)
    win_const_mgr.add_const('WINHTTP_OPTION_SECURITY_KEY_BITNESS',0x00000024)
    win_const_mgr.add_const('SCARD_E_TIMEOUT',0x8010000A)
    win_const_mgr.add_const('SPI_GETICONTITLELOGFONT',0x0000001F)
    win_const_mgr.add_const('PDH_LOG_TYPE_UNDEFINED',0x00000000)
    win_const_mgr.add_const('URLACTION_INFODELIVERY_NO_EDITING_CHANNELS',0x00001D01)
    win_const_mgr.add_const('GESTURE_TRIANGLE',0x00000000)
    win_const_mgr.add_const('TLS1_ALERT_DECRYPT_ERROR',0x00000033)
    win_const_mgr.add_const('SQL_INDEX_HASHED',0x00000002)
    win_const_mgr.add_const('PRODUCT_ENTERPRISE_SERVER_CORE',0x0000000E)
    win_const_mgr.add_const('CTL_FIND_SHA1_HASH',0x00000001)
    win_const_mgr.add_const('CRLF_ENFORCE_ENROLLMENT_AGENT',0x00000400)
    win_const_mgr.add_const('KP_RB',0x00000011)
    win_const_mgr.add_const('SQL_API_SQLSETDESCREC',0x000003FA)
    win_const_mgr.add_const('CERT_STORE_CTRL_RESYNC',0x00000001)
    win_const_mgr.add_const('ERROR_CLUSTER_WRONG_OS_VERSION',0x0000170B)
    win_const_mgr.add_const('ERROR_PRIVATE_DIALOG_INDEX',0x00000587)
    win_const_mgr.add_const('WM_MENUCHAR',0x00000120)
    win_const_mgr.add_const('WMDM_DEVICE_TYPE_NONREENTRANT',0x00000100)
    win_const_mgr.add_const('ERROR_DBG_CONTROL_BREAK',0x000002B8)
    win_const_mgr.add_const('ERROR_SERVICE_NEVER_STARTED',0x00000435)
    win_const_mgr.add_const('CERT_TRUST_PUB_ALLOW_END_USER_TRUST',0x00000000)
    win_const_mgr.add_const('SQL_CONVERT_BIGINT',0x00000035)
    win_const_mgr.add_const('LINEFEATURE_FORWARD',0x00000004)
    win_const_mgr.add_const('WMDM_MODE_QUERY',0x00000020)
    win_const_mgr.add_const('D3DFVF_DIFFUSE',0x00000040)
    win_const_mgr.add_const('TVIS_EX_DISABLED',0x00000002)
    win_const_mgr.add_const('ERROR_INSTALL_UI_FAILURE',0x00000655)
    win_const_mgr.add_const('OID_FDDI_SHORT_CURRENT_ADDR',0x03010106)
    win_const_mgr.add_const('WKSTA_USE512BYTESMAXTRANSFER_PARMNUM',0x0000003D)
    win_const_mgr.add_const('POLICY_ERRV_GLOBAL_UNAUTH_USER_FLOW_RATE',0x00000014)
    win_const_mgr.add_const('URLACTION_SHELL_POPUPMGR',0x00001809)
    win_const_mgr.add_const('SUBLANG_SAMI_SOUTHERN_SWEDEN',0x00000007)
    win_const_mgr.add_const('HTTP_QUERY_PROXY_AUTHENTICATE',0x00000029)
    win_const_mgr.add_const('D3DPS20_MAX_DYNAMICFLOWCONTROLDEPTH',0x00000018)
    win_const_mgr.add_const('MS_RLSD_ON',0x00000080)
    win_const_mgr.add_const('RCVD_RESV_TEAR',0x00000002)
    win_const_mgr.add_const('MODALS_FORCE_LOGOFF_PARMNUM',0x00000004)
    win_const_mgr.add_const('MCI_DGV_FF_MPEG',0x00004007)
    win_const_mgr.add_const('PROV_STT_MER',0x00000007)
    win_const_mgr.add_const('WTNCA_NOMIRRORHELP',0x00000008)
    win_const_mgr.add_const('EC_LOADSTATUS',0x00000043)
    win_const_mgr.add_const('GESTURE_DIAGONAL_RIGHTDOWN',0x00000000)
    win_const_mgr.add_const('BLLI_L3_PACKET_2048',0x0000000B)
    win_const_mgr.add_const('DNS_RTYPE_NAPTR',0x00002300)
    win_const_mgr.add_const('PURGE_RXABORT',0x00000002)
    win_const_mgr.add_const('CTRY_JORDAN',0x000003C2)
    win_const_mgr.add_const('FPS_DISCONNECTED',0x20000400)
    win_const_mgr.add_const('DSOP_DOWNLEVEL_FILTER_ALL_WELLKNOWN_SIDS',0x80020000)
    win_const_mgr.add_const('DISPID_BEGINDRAG',0x000000CC)
    win_const_mgr.add_const('ERROR_REG_NAT_CONSUMPTION',0x000004ED)
    win_const_mgr.add_const('DT_EDITCONTROL',0x00002000)
    win_const_mgr.add_const('NTDSSETTINGS_OPT_IS_TOPL_CLEANUP_DISABLED',0x00000001)
    win_const_mgr.add_const('PROTO_IP_NT_AUTOSTATIC',0x00002712)
    win_const_mgr.add_const('ACM_METRIC_COUNT_FILTERS',0x00000004)
    win_const_mgr.add_const('HELP_CONTENTS',0x00000003)
    win_const_mgr.add_const('HDS_CHECKBOXES',0x00000400)
    win_const_mgr.add_const('MOUSEEVENTF_HWHEEL',0x00001000)
    win_const_mgr.add_const('TAPE_SPACE_SETMARKS',0x00000008)
    win_const_mgr.add_const('NETE_GENERAL',0x0000000B)
    win_const_mgr.add_const('SQL_DBMS_NAME',0x00000011)
    win_const_mgr.add_const('CRED_FLAGS_USERNAME_TARGET',0x00000004)
    win_const_mgr.add_const('ISC_SHOWUIALL',0xC000000F)
    win_const_mgr.add_const('LOCALE_USE_NLS',0x10000000)
    win_const_mgr.add_const('EXPOSUREMODE_PORTRAIT',0x00000007)
    win_const_mgr.add_const('SIGNATURE_RESOURCE_NUMBER',0x0000029A)
    win_const_mgr.add_const('SQL_CP_RELAXED_MATCH',0x00000001)
    win_const_mgr.add_const('IMAGE_REL_SH3_DIRECT8_LONG',0x00000005)
    win_const_mgr.add_const('JOB_NOTIFY_FIELD_STATUS_STRING',0x0000000B)
    win_const_mgr.add_const('AF_CCITT',0x0000000A)
    win_const_mgr.add_const('PID_INTSITE_COMMENT',0x00000008)
    win_const_mgr.add_const('DISPID_NOITEMSTATE_CHANGED',0x000000CE)
    win_const_mgr.add_const('LINEQOSREQUESTTYPE_SERVICELEVEL',0x00000001)
    win_const_mgr.add_const('PC_POLYPOLYGON',0x00000100)
    win_const_mgr.add_const('PIDSI_COMMENTS',0x00000006)
    win_const_mgr.add_const('QITIPF_USESLOWTIP',0x00000008)
    win_const_mgr.add_const('RPC_C_MQ_USE_EXISTING_SECURITY',0x00000004)
    win_const_mgr.add_const('USER_WORKSTATION_TRUST_ACCOUNT',0x00000080)
    win_const_mgr.add_const('FEI_ANSWERED',0x00000015)
    win_const_mgr.add_const('LINEAGENTSTATEEX_BUSYACD',0x00000004)
    win_const_mgr.add_const('OID_CO_TAPI_TRANSLATE_TAPI_CALLPARAMS',0xFE001004)
    win_const_mgr.add_const('COLOR_INFOTEXT',0x00000017)
    win_const_mgr.add_const('PHONEBUTTONFUNCTION_MSGWAITOFF',0x00000009)
    win_const_mgr.add_const('TMTVS_RESERVEDHIGH',0x00004E1F)
    win_const_mgr.add_const('COLOR_INFOBK',0x00000018)
    win_const_mgr.add_const('META_SETMAPPERFLAGS',0x00000231)
    win_const_mgr.add_const('BLLI_L3_X25',0x00000006)
    win_const_mgr.add_const('IF_ENFORCEENCRYPTICERTADMIN',0x00000400)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_REQUEST_OUTCOME',0x20000000)
    win_const_mgr.add_const('IMAGE_REL_ALPHA_SECRELHI',0x00000012)
    win_const_mgr.add_const('SSF_SEPPROCESS',0x00080000)
    win_const_mgr.add_const('R2_LAST',0x00000010)
    win_const_mgr.add_const('TSF_COPY_CREATION_TIME',0x00000010)
    win_const_mgr.add_const('OLEUI_ERR_CBSTRUCTINCORRECT',0x00000067)
    win_const_mgr.add_const('TRUST_ATTRIBUTE_UPLEVEL_ONLY',0x00000002)
    win_const_mgr.add_const('DOMAIN_ALIAS_RID_PRINT_OPS',0x00000226)
    win_const_mgr.add_const('CLIP_MASK',0x00000000)
    win_const_mgr.add_const('ISC_RET_MANUAL_CRED_VALIDATION',0x00080000)
    win_const_mgr.add_const('PORT_LAMAINT',0x00000033)
    win_const_mgr.add_const('DNS_RCODE_BADTIME',0x00000012)
    win_const_mgr.add_const('ERROR_BAD_CONFIGURATION',0x0000064A)
    win_const_mgr.add_const('MD_NETLOGON_WKS_DNS',0x00000002)
    win_const_mgr.add_const('IDC_IO_FILETEXT',0x00000840)
    win_const_mgr.add_const('CM_ADD_ID_HARDWARE',0x00000000)
    win_const_mgr.add_const('ERROR_UNABLE_TO_INVENTORY_SLOT',0x000010E6)
    win_const_mgr.add_const('PROGDLG_NOCANCEL',0x00000040)
    win_const_mgr.add_const('MAPI_DEFAULT_SERVICES',0x00000001)
    win_const_mgr.add_const('IDM_COPYSHORTCUT',0x000008D6)
    win_const_mgr.add_const('DBPROPVAL_SQL_ESCAPECLAUSES',0x00000100)
    win_const_mgr.add_const('SHDID_FS_DIRECTORY',0x00000003)
    win_const_mgr.add_const('CR_INVALID_RANGE',0x00000012)
    win_const_mgr.add_const('RMNAMESZ',0x00000020)
    win_const_mgr.add_const('NDIS_OBJECT_TYPE_MINIPORT_PNP_CHARACTERISTICS',0x00000092)
    win_const_mgr.add_const('NDIS_STATISTICS_FLAGS_VALID_BROADCAST_BYTES_RCV',0x00040000)
    win_const_mgr.add_const('DEVICE_DRIVER_INSTALL',0x0000000A)
    win_const_mgr.add_const('TF_LBI_STATUS',0x00010000)
    win_const_mgr.add_const('DBPROPVAL_TS_HISTOGRAM',0x00000002)
    win_const_mgr.add_const('PSINJECT_BEGINPROLOG',0x0000000E)
    win_const_mgr.add_const('WTS_SESSION_LOCK',0x00000007)
    win_const_mgr.add_const('CF_DEFER',0x00000002)
    win_const_mgr.add_const('PD_EXCLUSIONFLAGS',0x01000000)
    win_const_mgr.add_const('UDN_LAST',0x00000000)
    win_const_mgr.add_const('DNS_RTYPE_GPOS',0x00000001)
    win_const_mgr.add_const('LINEDEVSTATE_RINGING',0x00000002)
    win_const_mgr.add_const('DTRESULTOK',0x00000000)
    win_const_mgr.add_const('NM_FIRST',0x00000000)
    win_const_mgr.add_const('LVGF_STATE',0x00000004)
    win_const_mgr.add_const('TMT_SIZINGTYPE',0x00000FA4)
    win_const_mgr.add_const('XP_CONNECTIONLESS',0x00000001)
    win_const_mgr.add_const('EAP_E_AUTHENTICATION_FAILED',0x80420015)
    win_const_mgr.add_const('GPO_LIST_FLAG_MACHINE',0x00000001)
    win_const_mgr.add_const('DNS_UPDATE_CACHE_SECURITY_CONTEXT',0x00000200)
    win_const_mgr.add_const('IDS_CAP_WRITEERROR',0x0000019E)
    win_const_mgr.add_const('SPI_GETFONTSMOOTHING',0x0000004A)
    win_const_mgr.add_const('PS_JOIN_MASK',0x0000F000)
    win_const_mgr.add_const('MDPROPVAL_MNF_LINREGPOINT',0x00000400)
    win_const_mgr.add_const('IDM_SHOWALLTAGS',0x00000917)
    win_const_mgr.add_const('LINEAGENTSTATEEX_BUSYOUTGOING',0x00000010)
    win_const_mgr.add_const('MEDIASINK_FIXED_STREAMS',0x00000001)
    win_const_mgr.add_const('PS_DASH',0x00000001)
    win_const_mgr.add_const('SNMP_ERRORSTATUS_WRONGLENGTH',0x00000008)
    win_const_mgr.add_const('OFN_PATHMUSTEXIST',0x00000800)
    win_const_mgr.add_const('HTTP_ADDREQ_FLAGS_MASK',0xFFFF0000)
    win_const_mgr.add_const('D3DPS20_MIN_STATICFLOWCONTROLDEPTH',0x00000000)
    win_const_mgr.add_const('EVENT_OBJECT_TEXTSELECTIONCHANGED',0x00008014)
    win_const_mgr.add_const('SSRVOPT_DWORDPTR',0x00000004)
    win_const_mgr.add_const('RPC_BHO_EXCLUSIVE_AND_GUARANTEED',0x00000004)
    win_const_mgr.add_const('EN_MSGFILTER',0x00000700)
    win_const_mgr.add_const('E_FILTER_SERVERSCRIPT',0x80100002)
    win_const_mgr.add_const('LINEERR_INVALRATE',0x80000037)
    win_const_mgr.add_const('F_DUPLICATE',0x0000000F)
    win_const_mgr.add_const('CB_GETHORIZONTALEXTENT',0x00000015)
    win_const_mgr.add_const('DDSCAPS3_DMAP',0x00001000)
    win_const_mgr.add_const('CS_SAVEBITS',0x00000800)
    win_const_mgr.add_const('LINEADDRCAPFLAGS_NOPSTNADDRESSTRANSLATION',0x80000000)
    win_const_mgr.add_const('MAPI_E_TOO_MANY_SESSIONS',0x00000008)
    win_const_mgr.add_const('HP_HASHSIZE',0x00000004)
    win_const_mgr.add_const('MWT_IDENTITY',0x00000001)
    win_const_mgr.add_const('PRIORITY_EQUAL_FIRST',0x00000008)
    win_const_mgr.add_const('TMT_TEXTGLOW',0x000008A9)
    win_const_mgr.add_const('MDPROPVAL_AU_UNSUPPORTED',0x00000000)
    win_const_mgr.add_const('RPC_C_BINDING_MAX_TIMEOUT',0x00000009)
    win_const_mgr.add_const('CFERR_NOFONTS',0x00002001)
    win_const_mgr.add_const('SYMFLAG_VALUEPRESENT',0x00000001)
    win_const_mgr.add_const('WM_MOUSEHOVER',0x000002A1)
    win_const_mgr.add_const('C2_WHITESPACE',0x0000000A)
    win_const_mgr.add_const('ERROR_INVALID_DOMAIN_ROLE',0x0000054A)
    win_const_mgr.add_const('LVS_EX_SINGLEROW',0x00040000)
    win_const_mgr.add_const('KS_VIDEO_ALLOC_VPE_DISPLAY',0x00000002)
    win_const_mgr.add_const('GESTURE_UP',0x00000000)
    win_const_mgr.add_const('CERT_SYSTEM_STORE_UNPROTECTED_FLAG',0x40000000)
    win_const_mgr.add_const('SERVICE_CONTROL_SHUTDOWN',0x00000005)
    win_const_mgr.add_const('SV_ALERTS_PARMNUM',0x0000000B)
    win_const_mgr.add_const('CRYPT_WIRE_ONLY_RETRIEVAL',0x00000004)
    win_const_mgr.add_const('USER_SMARTCARD_REQUIRED',0x00001000)
    win_const_mgr.add_const('IDD_DYNAWIZ_ANALYZE_PREVPAGE',0x00002713)
    win_const_mgr.add_const('BLUE_SHIFT',0x00000000)
    win_const_mgr.add_const('FWPS_FILTER_FLAG_PERMIT_IF_CALLOUT_UNREGISTERED',0x00000002)
    win_const_mgr.add_const('OUTPUT_DEBUG_STRING_EVENT',0x00000008)
    win_const_mgr.add_const('MD_SERVER_STATE_STOPPED',0x00000004)
    win_const_mgr.add_const('LVFIF_STATE',0x00000002)
    win_const_mgr.add_const('CR_PROP_ADVANCEDSERVER',0x0000001C)
    win_const_mgr.add_const('ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER',0x00002144)
    win_const_mgr.add_const('INTERNET_FLAG_NO_UI',0x00000200)
    win_const_mgr.add_const('MDPROPVAL_MMF_COUSIN',0x00000001)
    win_const_mgr.add_const('MAPI_E_INVALID_MESSAGE',0x00000011)
    win_const_mgr.add_const('DEBUG_OUTSYM_SOURCE_LINE',0x00000002)
    win_const_mgr.add_const('ERROR_ENLISTMENT_NOT_FOUND',0x00001A3D)
    win_const_mgr.add_const('PID_VOLUME_CAPACITY',0x00000003)
    win_const_mgr.add_const('SUBLANG_SOTHO_NORTHERN_SOUTH_AFRICA',0x00000001)
    win_const_mgr.add_const('NT_RR_SIZE',0x00000004)
    win_const_mgr.add_const('RESOURCE_CONTEXT',0x00000005)
    win_const_mgr.add_const('TF_IPSINK_FLAG_ACTIVE',0x00000001)
    win_const_mgr.add_const('LINEADDRESSSHARING_BRIDGEDEXCL',0x00000002)
    win_const_mgr.add_const('RI_MOUSE_MIDDLE_BUTTON_UP',0x00000020)
    win_const_mgr.add_const('OBJ_ENHMETADC',0x0000000C)
    win_const_mgr.add_const('OID_GEN_VENDOR_DRIVER_VERSION',0x00010116)
    win_const_mgr.add_const('WIA_PACKED_PIXEL',0x00000000)
    win_const_mgr.add_const('DLG_COLOR',0x0000000A)
    win_const_mgr.add_const('CERT_TRUST_NO_ISSUANCE_CHAIN_POLICY',0x02000000)
    win_const_mgr.add_const('HANDLE_FLAG_INHERIT',0x00000001)
    win_const_mgr.add_const('SUPPORTS_ANY',0xFFFFFFFF)
    win_const_mgr.add_const('TCP_BSDURGENT',0x00007000)
    win_const_mgr.add_const('WIA_IPS_SEGMENTATION',0x00001814)
    win_const_mgr.add_const('NI_MAXSERV',0x00000020)
    win_const_mgr.add_const('D3DSI_COISSUE',0x40000000)
    win_const_mgr.add_const('AE_SRVSTOP',0x00000003)
    win_const_mgr.add_const('SQL_BP_OTHER_HSTMT',0x00000020)
    win_const_mgr.add_const('SCROLLLOCK_ON',0x00000040)
    win_const_mgr.add_const('ERROR_SERVER_DISABLED',0x0000053D)
    win_const_mgr.add_const('GLOBAL_ALL',0x00000000)
    win_const_mgr.add_const('VSS_SW_BOOTABLE_STATE',0x00000001)
    win_const_mgr.add_const('WIA_DPC_UPLOAD_URL',0x0000082A)
    win_const_mgr.add_const('TRANSACTION_NOTIFY_PREPREPARE',0x00000001)
    win_const_mgr.add_const('FD_ROUTING_INTERFACE_CHANGE',0x00000001)
    win_const_mgr.add_const('IMAGE_DIRECTORY_ENTRY_IAT',0x0000000C)
    win_const_mgr.add_const('TCIF_RTLREADING',0x00000004)
    win_const_mgr.add_const('IDM_REMOVEFROMGLYPHTABLE',0x00000922)
    win_const_mgr.add_const('DNS_ATMA_MAX_ADDR_LENGTH',0x00000014)
    win_const_mgr.add_const('SBSP_HELPMODE',0x00000040)
    win_const_mgr.add_const('SNMPAPI_UNTRANSLATED_V1',0x00000001)
    win_const_mgr.add_const('SRCLIST_NOSTRIPPLATFORM',0x00000400)
    win_const_mgr.add_const('SQL_OU_TABLE_DEFINITION',0x00000004)
    win_const_mgr.add_const('RC_BITMAP64',0x00000008)
    win_const_mgr.add_const('CM_PROB_FAILED_DRIVER_ENTRY',0x00000025)
    win_const_mgr.add_const('AE_SESSDIS',0x00000001)
    win_const_mgr.add_const('ERROR_UNRECOGNIZED_VOLUME',0x000003ED)
    win_const_mgr.add_const('PROPCALLER_ADMIN',0x00000400)
    win_const_mgr.add_const('PIDSI_ALBUM',0x00000004)
    win_const_mgr.add_const('DNS_ERROR_NODE_CREATION_FAILED',0x000025E7)
    win_const_mgr.add_const('WHITEBALANCE_MANUAL',0x00000001)
    win_const_mgr.add_const('OID_FDDI_PORT_PC_WITHHOLD',0x03030274)
    win_const_mgr.add_const('PCIC_DEFAULT_NUMSOCKETS',0x00000000)
    win_const_mgr.add_const('LINEAGENTSTATUS_GROUPLIST',0x00000020)
    win_const_mgr.add_const('FILE_NOTIFY_CHANGE_LAST_ACCESS',0x00000020)
    win_const_mgr.add_const('ERROR_PORT_NOT_SET',0x00000282)
    win_const_mgr.add_const('ACTRL_DS_LIST',0x00000004)
    win_const_mgr.add_const('SOL_SDP',0x00000101)
    win_const_mgr.add_const('DISPID_EXPANDO_MAX',0x003D08FF)
    win_const_mgr.add_const('PID_KEYWORDS',0x00000005)
    win_const_mgr.add_const('URLOSTRM_USECACHEDCOPY',0x00000002)
    win_const_mgr.add_const('LINEDEVSTATE_OUTOFSERVICE',0x00000080)
    win_const_mgr.add_const('DMPAPER_A4_ROTATED',0x0000004D)
    win_const_mgr.add_const('ERROR_CRASH_DUMP',0x000002F1)
    win_const_mgr.add_const('BSF_FLUSHDISK',0x00000004)
    win_const_mgr.add_const('DAOROWFETCH_FORCEREFRESH',0x00000004)
    win_const_mgr.add_const('OID_FDDI_MAC_ERROR_CT',0x0303023F)
    win_const_mgr.add_const('IF_TYPE_VDSL',0x00000061)
    win_const_mgr.add_const('SUBLANG_SPANISH_PUE