from __future__ import division
import glob, json, os.path

numCases = len(glob.glob('cases/*.out'))

# initialize point counters
totalPointsPerQues = {}
earnedPointsPerQues = {}

for i in range(1, numCases + 1):
    with open('cases/' + str(i) + '.out', 'r') as golden:
        case_out = json.loads(golden.read())
    ques = case_out["ques"]
    test = case_out["test"]
    if ques not in totalPointsPerQues:
        totalPointsPerQues[ques] = 0
    if ques not in earnedPointsPerQues:
        earnedPointsPerQues[ques] = 0

    output_file = '/usr/testguest/' + str(i) + '.out'
    if not os.path.isfile(output_file):
        print('Question ' + str(ques) + ' Test ' + str(test) + ': FAILURE -- no output')
        continue

    with open(output_file, 'r') as output:
        stud_out = json.loads(output.read())

    totalPointsPerQues[ques] = totalPointsPerQues[ques] + case_out["points"]
    if case_out["result"] == stud_out:
        earnedPointsPerQues[ques] = earnedPointsPerQues[ques] + case_out["points"]
        print('Question ' + str(ques) + ' Test ' + str(test) + ': SUCCESS! ' +
              str(case_out["points"])  + ' Points')
    else:
        print('Question ' + str(ques) + ' Test ' + str(test) + ': FAILURE. Yields ' + str(stud_out) +
                ', expecting ' + str(case_out["result"]) + '.')

numQues = max(totalPointsPerQues.keys())
earnedPoints = 0
totalPoints = 0
for ques in range(1, numQues + 1):
    earnedPoints = earnedPoints + earnedPointsPerQues[ques]
    totalPoints = totalPoints + totalPointsPerQues[ques]
    print('Question ' + str(ques) + ' Grade: ' + str(earnedPointsPerQues[ques]) + '/' +
          str(totalPointsPerQues[ques]))
print('Total Grade: ' + str(earnedPoints) + '/' + str(totalPoints))

score = earnedPoints * 1.0 / totalPoints

grades = {  'Question 1': earnedPointsPerQues[1],
            'Question 2': earnedPointsPerQues[2],
            'Question 3': earnedPointsPerQues[3],
            'Question 4': earnedPointsPerQues[4],
            'Question 5': earnedPointsPerQues[5]
            }

with open('output', 'w') as scores:
    scores.write(json.dumps(grades))
