/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.fabric.proto.xmlrpc;

import com.mysql.fabric.DumpResponse;
import com.mysql.fabric.FabricCommunicationException;
import com.mysql.fabric.FabricStateResponse;
import com.mysql.fabric.Response;
import com.mysql.fabric.Server;
import com.mysql.fabric.ServerGroup;
import com.mysql.fabric.ServerMode;
import com.mysql.fabric.ServerRole;
import com.mysql.fabric.ShardIndex;
import com.mysql.fabric.ShardMapping;
import com.mysql.fabric.ShardMappingFactory;
import com.mysql.fabric.ShardTable;
import com.mysql.fabric.ShardingType;
import com.mysql.fabric.proto.xmlrpc.AuthenticatedXmlRpcMethodCaller;
import com.mysql.fabric.proto.xmlrpc.InternalXmlRpcMethodCaller;
import com.mysql.fabric.proto.xmlrpc.XmlRpcMethodCaller;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcClient {
    private XmlRpcMethodCaller methodCaller;

    public XmlRpcClient(String url, String username, String password) throws FabricCommunicationException {
        this.methodCaller = new InternalXmlRpcMethodCaller(url);
        if (username != null && !"".equals(username) && password != null) {
            this.methodCaller = new AuthenticatedXmlRpcMethodCaller(this.methodCaller, url, username, password);
        }
    }

    private static Server unmarshallServer(List serverData) {
        Server s = null;
        if (serverData.size() <= 4) {
            String[] hostnameAndPort = ((String)serverData.get(1)).split(":");
            String hostname = hostnameAndPort[0];
            int port = Integer.valueOf(hostnameAndPort[1]);
            ServerRole role = (Boolean)serverData.get(2) != false ? ServerRole.PRIMARY : ServerRole.SECONDARY;
            s = new Server(null, (String)serverData.get(0), hostname, port, ServerMode.READ_WRITE, role, 1.0);
        } else if (serverData.size() == 7) {
            String uuid = (String)serverData.get(0);
            String groupName = (String)serverData.get(1);
            String hostname = (String)serverData.get(2);
            int port = Integer.valueOf((String)serverData.get(3));
            ServerMode mode = ServerMode.getFromConstant((Integer)serverData.get(4));
            ServerRole role = ServerRole.getFromConstant((Integer)serverData.get(5));
            double weight = (Double)serverData.get(6);
            s = new Server(groupName, uuid, hostname, port, mode, role, weight);
        }
        return s;
    }

    private static Set<Server> toServerSet(List<List> l) throws FabricCommunicationException {
        HashSet<Server> servers = new HashSet<Server>();
        for (List serverData : l) {
            Server s = XmlRpcClient.unmarshallServer(serverData);
            if (s == null) {
                throw new FabricCommunicationException("Unknown format of server object");
            }
            servers.add(s);
        }
        return servers;
    }

    private Object errorSafeCallMethod(String methodName, Object[] args) throws FabricCommunicationException {
        List<?> responseData = this.methodCaller.call(methodName, args);
        Response response = new Response(responseData);
        if (!response.isSuccessful()) {
            throw new FabricCommunicationException("Call failed to method `" + methodName + "':\n" + response.getTraceString());
        }
        return response.getReturnValue();
    }

    private DumpResponse callDumpMethod(String methodName, Object[] args) throws FabricCommunicationException {
        List<?> responseData = this.methodCaller.call(methodName, args);
        return new DumpResponse(responseData);
    }

    public List<String> getFabricNames() throws FabricCommunicationException {
        return this.callDumpMethod("dump.fabric_nodes", new Object[0]).getReturnValue();
    }

    public Set<String> getGroupNames() throws FabricCommunicationException {
        HashSet<String> groupNames = new HashSet<String>();
        for (HashMap wrapped : (List)this.errorSafeCallMethod("group.lookup_groups", null)) {
            groupNames.add((String)wrapped.get("group_id"));
        }
        return groupNames;
    }

    public ServerGroup getServerGroup(String groupName) throws FabricCommunicationException {
        Set<ServerGroup> groups = this.getServerGroups(groupName).getData();
        if (groups.size() == 1) {
            return groups.iterator().next();
        }
        return null;
    }

    public Set<Server> getServersForKey(String tableName, int key) throws FabricCommunicationException {
        return XmlRpcClient.toServerSet((List)this.errorSafeCallMethod("sharding.lookup_servers", new Object[]{tableName, key}));
    }

    public FabricStateResponse<Set<ServerGroup>> getServerGroups(String groupPattern) throws FabricCommunicationException {
        int version = 0;
        DumpResponse response = this.callDumpMethod("dump.servers", new Object[]{version, groupPattern});
        HashMap serversByGroupName = new HashMap();
        for (List server : response.getReturnValue()) {
            Server s = XmlRpcClient.unmarshallServer(server);
            if (serversByGroupName.get(s.getGroupName()) == null) {
                serversByGroupName.put(s.getGroupName(), new HashSet());
            }
            ((Set)serversByGroupName.get(s.getGroupName())).add(s);
        }
        HashSet<ServerGroup> serverGroups = new HashSet<ServerGroup>();
        for (Map.Entry entry : serversByGroupName.entrySet()) {
            ServerGroup g = new ServerGroup((String)entry.getKey(), (Set)entry.getValue());
            serverGroups.add(g);
        }
        return new FabricStateResponse<Set<ServerGroup>>((Set<ServerGroup>)serverGroups, response.getTtl());
    }

    public FabricStateResponse<Set<ServerGroup>> getServerGroups() throws FabricCommunicationException {
        return this.getServerGroups("");
    }

    private FabricStateResponse<Set<ShardTable>> getShardTables(String shardMappingId) throws FabricCommunicationException {
        int version = 0;
        Object[] args = new Object[]{version, shardMappingId};
        DumpResponse tablesResponse = this.callDumpMethod("dump.shard_tables", args);
        HashSet<ShardTable> tables = new HashSet<ShardTable>();
        for (List rawTable : tablesResponse.getReturnValue()) {
            String database = (String)rawTable.get(0);
            String table = (String)rawTable.get(1);
            String column = (String)rawTable.get(2);
            String mappingId = (String)rawTable.get(3);
            ShardTable st = new ShardTable(database, table, column);
            tables.add(st);
        }
        return new FabricStateResponse<Set<ShardTable>>((Set<ShardTable>)tables, tablesResponse.getTtl());
    }

    private FabricStateResponse<Set<ShardIndex>> getShardIndices(String shardMappingId) throws FabricCommunicationException {
        int version = 0;
        Object[] args = new Object[]{version, shardMappingId};
        DumpResponse indexResponse = this.callDumpMethod("dump.shard_index", args);
        HashSet<ShardIndex> indices = new HashSet<ShardIndex>();
        for (List rawIndexEntry : indexResponse.getReturnValue()) {
            String bound = (String)rawIndexEntry.get(0);
            String mappingId = (String)rawIndexEntry.get(1);
            String shardId = (String)rawIndexEntry.get(2);
            String groupName = (String)rawIndexEntry.get(3);
            ShardIndex si = new ShardIndex(bound, Integer.valueOf(shardId), groupName);
            indices.add(si);
        }
        return new FabricStateResponse<Set<ShardIndex>>((Set<ShardIndex>)indices, indexResponse.getTtl());
    }

    public FabricStateResponse<Set<ShardMapping>> getShardMappings(String shardMappingIdPattern) throws FabricCommunicationException {
        int version = 0;
        Object[] args = new Object[]{version, shardMappingIdPattern};
        DumpResponse mapsResponse = this.callDumpMethod("dump.shard_maps", args);
        long minExpireTimeMillis = System.currentTimeMillis() + (long)(1000 * mapsResponse.getTtl());
        HashSet<ShardMapping> mappings = new HashSet<ShardMapping>();
        for (List rawMapping : mapsResponse.getReturnValue()) {
            String mappingId = (String)rawMapping.get(0);
            ShardingType shardingType = ShardingType.valueOf((String)rawMapping.get(1));
            String globalGroupName = (String)rawMapping.get(2);
            FabricStateResponse<Set<ShardTable>> tables = this.getShardTables(mappingId);
            FabricStateResponse<Set<ShardIndex>> indices = this.getShardIndices(mappingId);
            if (tables.getExpireTimeMillis() < minExpireTimeMillis) {
                minExpireTimeMillis = tables.getExpireTimeMillis();
            }
            if (indices.getExpireTimeMillis() < minExpireTimeMillis) {
                minExpireTimeMillis = indices.getExpireTimeMillis();
            }
            ShardMapping m = new ShardMappingFactory().createShardMapping(mappingId, shardingType, globalGroupName, tables.getData(), indices.getData());
            mappings.add(m);
        }
        return new FabricStateResponse<Set<ShardMapping>>(mappings, minExpireTimeMillis);
    }

    public FabricStateResponse<Set<ShardMapping>> getShardMappings() throws FabricCommunicationException {
        return this.getShardMappings("");
    }

    public void createGroup(String groupName) throws FabricCommunicationException {
        this.errorSafeCallMethod("group.create", new Object[]{groupName});
    }

    public void createServerInGroup(String groupName, String hostname, int port) throws FabricCommunicationException {
        this.errorSafeCallMethod("group.add", new Object[]{groupName, hostname + ":" + port});
    }

    public int createShardMapping(ShardingType type, String globalGroupName) throws FabricCommunicationException {
        return (Integer)this.errorSafeCallMethod("sharding.create_definition", new Object[]{type.toString(), globalGroupName});
    }

    public void createShardTable(int shardMappingId, String database, String table, String column) throws FabricCommunicationException {
        this.errorSafeCallMethod("sharding.add_table", new Object[]{shardMappingId, database + "." + table, column});
    }

    public void createShardIndex(int shardMappingId, String groupNameLowerBoundList) throws FabricCommunicationException {
        String status = "ENABLED";
        this.errorSafeCallMethod("sharding.add_shard", new Object[]{shardMappingId, groupNameLowerBoundList, status});
    }

    public void promoteServerInGroup(String groupName, String hostname, int port) throws FabricCommunicationException {
        ServerGroup serverGroup = this.getServerGroup(groupName);
        for (Server s : serverGroup.getServers()) {
            if (!s.getHostname().equals(hostname) || s.getPort() != port) continue;
            this.errorSafeCallMethod("group.promote", new Object[]{groupName, s.getUuid()});
            break;
        }
    }

    public void reportServerError(Server server, String errorDescription, boolean forceFaulty) throws FabricCommunicationException {
        String reporter = "MySQL Connector/J";
        String command = "threat.report_error";
        if (forceFaulty) {
            command = "threat.report_failure";
        }
        this.errorSafeCallMethod(command, new Object[]{server.getUuid(), reporter, errorDescription});
    }
}

