var gitlab = require("../../lib/services/gitlab");

describe("Gitlab CI Provider", function(){

  it ("can detect gitlab", function(){
    process.env.CI_SERVER_NAME = "GitLab CI";
    expect(gitlab.detect()).to.be(true);
  });

  it ("can get service env info", function(){
    process.env.CI_BUILD_ID = '1234';
    process.env.CI_BUILD_REPO = 'https://gitlab.com/owner/repo.git';
    process.env.CI_BUILD_REF = '5678';
    process.env.CI_BUILD_REF_NAME = 'master';
    process.env.CI_PROJECT_DIR = '/';
    expect(gitlab.configuration()).to.eql({
      service : 'gitlab',
      build : '1234',
      root : '/',
      commit : '5678',
      slug : 'owner/repo',
      branch : 'master'
    });
  });
});
