# Makefile used to compile ADMS C++ output into a dynamic loadable library

# PREFIX can be passed as parameter to make:
# $make -f cpp2lib.make PREFIX='/qucs/prefix/'

# TODO
# * use -O3 by default?
# * set correct flags in each supported platform
# * check library linker flags

######################
## Makefile Parameters
######################

# Module name
MODEL=

# Project dir
PROJDIR=

# Please define
PREFIX=

# Installed headers path
INC=$(PREFIX)/include/qucs-core

# Link to Qucs library
LIBS=-lqucs

ifeq ($(OS),Windows_NT)
  DLLEXT=.dll
  CXX=g++
  CXXFLAGS=-shared -DHAVE_CONFIG_H -I./  -I$(INC)
  
  # handle deletion if Windows cmd.exe or MinGW MSYS terminal
  RM=del
  ifeq ($(MSYSTEM),MINGW32)
	RM=rm -f
  endif

else
  UNAME_S := $(shell uname -s)
  ifeq ($(UNAME_S),Linux)
    DLLEXT=.so
    CXX=g++
    CXXFLAGS=-fPIC -shared -rdynamic -DHAVE_CONFIG_H -I./  -I$(INC)
	  CXXFLAGS:=$(CXXFLAGS) -Wl,-soname,$(MODEL)$(DLLEXT)
  endif
  
  ifeq ($(UNAME_S),Darwin)
    DLLEXT=.dylib
    CXX=clang++
    CXXFLAGS=-stdlib=libc++ -dynamiclib -flat_namespace -DHAVE_CONFIG_H -I./  -I$(INC)
	  CXXFLAGS:=$(CXXFLAGS) -undefined dynamic_lookup -Wl,-headerpad_max_install_names
  endif

  # common to Linux, Darwin
  LIBS:=$(LIBS) -ldl
endif

# Linker flags
LDFLAGS=-L$(PREFIX)/lib -Wl,-rpath -Wl,$(PROJDIR)

# Required (admsXml generated) sources
SRC=$(MODEL).core.cpp $(MODEL).analogfunction.cpp

# Generated headers
HDR=$(MODEL).core.h $(MODEL).analogfunction.h

# Default
.PHONY: cpp2lib

# Main target
# clean before building
cpp2lib: clean $(MODEL)$(DLLEXT)

# Build library
$(MODEL)$(DLLEXT): $(SRC)
	$(CXX)  $(CXXFLAGS) -o $(MODEL)$(DLLEXT) $(SRC) $(LDFLAGS) $(LIBS)

clean:
	@echo '# cpp2lib - Removing autogenerated files.'
	- $(RM) $(MODEL)$(DLLEXT)
	@echo ''
