/* $Id: shhmsg.h,v 1.5 1997/05/27 21:11:06 sverrehu Exp $ */
#ifndef SHHMSG_H
#define SHHMSG_H

#include <stdio.h> /* FILE */

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __GNUC__
#define MSG_NORET __attribute__ ((noreturn))
#define MSG_FORMAT_1 __attribute__ ((format (printf, 1, 2)))
#define MSG_FORMAT_2 __attribute__ ((format (printf, 2, 3)))
#else
#define MSG_NORET
#define MSG_FORMAT_1
#define MSG_FORMAT_2
#endif

/* program name functions */
void msgSetName(const char *s);
char *msgGetName(void);

/* error functions */
void msgError(const char *format, ...) MSG_FORMAT_1 ;
void msgFatal(const char *format, ...) MSG_FORMAT_1 MSG_NORET ;
void msgPerror(const char *format, ...) MSG_FORMAT_1 ;
void msgFatalPerror(const char *format, ...) MSG_FORMAT_1 ;

/* message output functions */
void msgMessage(const char *format, ...) MSG_FORMAT_1 ;
void msgVerbose(int level, const char *format, ...) MSG_FORMAT_2 ;

/* output control functions */
void msgSetQuiet(int onoff);
void msgSetVerbose(int level);
void msgSetShowNameAlways(int onoff);
FILE *msgSetErrorStream(FILE *f);
FILE *msgSetVerboseStream(FILE *f);
FILE *msgSetMessageStream(FILE *f);

/* constants */
#define MSG_VERBOSE_DEFAULT -1
#define MSG_VERBOSE_NONE     0
#define MSG_ON               1
#define MSG_OFF              0
#define MSG_QUIET            1
#define MSG_OUTPUT           0

/* variables that may be changed */
extern int msgVerboseLevel;
extern int msgBeQuiet;

#undef MSG_NORET
#undef MSG_FORMAT_1
#undef MSG_FORMAT_2

#ifdef __cplusplus
}
#endif

#endif
