/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.ZapBootstrap;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnLoader;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.model.SessionUtils;

abstract class HeadlessBootstrap
extends ZapBootstrap {
    public HeadlessBootstrap(CommandLine commandLine) {
        super(commandLine);
        System.setProperty("java.awt.headless", "true");
    }

    protected Control initControl(boolean bl) {
        if (!Control.initSingletonWithoutView(this.getControlOverrides()) && !bl) {
            return null;
        }
        return Control.getSingleton();
    }

    protected abstract Logger getLogger();

    protected boolean handleCmdLineSessionArgsSynchronously(Control control) {
        if (this.getArgs().isEnabled("-session") && this.getArgs().isEnabled("-newsession")) {
            System.err.println("Error: Invalid command line options: option '-session' not allowed with option '-newsession'");
            return false;
        }
        if (this.getArgs().isEnabled("-session")) {
            Path path = SessionUtils.getSessionPath(this.getArgs().getArgument("-session"));
            String string = path.toAbsolutePath().toString();
            try {
                control.runCommandLineOpenSession(string);
            }
            catch (Exception exception) {
                this.getLogger().error((Object)exception.getMessage(), (Throwable)exception);
                System.err.println("Failed to open session: " + string);
                exception.printStackTrace(System.err);
                return false;
            }
        }
        if (this.getArgs().isEnabled("-newsession")) {
            Path path = SessionUtils.getSessionPath(this.getArgs().getArgument("-newsession"));
            String string = path.toAbsolutePath().toString();
            if (Files.exists(path, new LinkOption[0])) {
                System.err.println("Failed to create a new session, file already exists: " + string);
                return false;
            }
            try {
                control.runCommandLineNewSession(string);
            }
            catch (Exception exception) {
                this.getLogger().error((Object)exception.getMessage(), (Throwable)exception);
                System.err.println("Failed to create a new session: " + string);
                exception.printStackTrace(System.err);
                return false;
            }
        }
        return true;
    }

    protected void warnAddOnsAndExtensionsNoLongerRunnable() {
        AddOnLoader addOnLoader = ExtensionFactory.getAddOnLoader();
        List<String> list = addOnLoader.getIdsAddOnsWithRunningIssuesSinceLastRun();
        if (list.isEmpty()) {
            return;
        }
        ArrayList<AddOn> arrayList = new ArrayList<AddOn>(list.size());
        for (String object : list) {
            arrayList.add(addOnLoader.getAddOnCollection().getAddOn(object));
        }
        for (AddOn addOn : arrayList) {
            AddOn.AddOnRunRequirements addOnRunRequirements = addOn.calculateRunRequirements(addOnLoader.getAddOnCollection().getAddOns());
            List<String> list2 = AddOnRunIssuesUtils.getRunningIssues(addOnRunRequirements);
            if (list2.isEmpty()) {
                list2 = AddOnRunIssuesUtils.getExtensionsRunningIssues(addOnRunRequirements);
            }
            this.getLogger().warn((Object)("Add-on \"" + addOn.getId() + "\" or its extensions will no longer be run until its requirements are restored: " + list2));
        }
    }
}

