/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import sun.reflect.ByteVector;
import sun.reflect.ByteVectorFactory;
import sun.reflect.ClassFileConstants;
import sun.reflect.Label;
import sun.reflect.UTF8;

class ClassFileAssembler
implements ClassFileConstants {
    private ByteVector vec;
    private short cpIdx = 0;
    private int stack = 0;
    private int maxStack = 0;
    private int maxLocals = 0;

    public ClassFileAssembler() {
        this(ByteVectorFactory.create());
    }

    public ClassFileAssembler(ByteVector vec) {
        this.vec = vec;
    }

    public ByteVector getData() {
        return this.vec;
    }

    public short getLength() {
        return (short)this.vec.getLength();
    }

    public void emitMagicAndVersion() {
        this.emitInt(-889275714);
        this.emitShort((short)0);
        this.emitShort((short)49);
    }

    public void emitInt(int val) {
        this.emitByte((byte)(val >> 24));
        this.emitByte((byte)(val >> 16 & 0xFF));
        this.emitByte((byte)(val >> 8 & 0xFF));
        this.emitByte((byte)(val & 0xFF));
    }

    public void emitShort(short val) {
        this.emitByte((byte)(val >> 8 & 0xFF));
        this.emitByte((byte)(val & 0xFF));
    }

    void emitShort(short bci, short val) {
        this.vec.put(bci, (byte)(val >> 8 & 0xFF));
        this.vec.put(bci + 1, (byte)(val & 0xFF));
    }

    public void emitByte(byte val) {
        this.vec.add(val);
    }

    public void append(ClassFileAssembler asm) {
        this.append(asm.vec);
    }

    public void append(ByteVector vec) {
        for (int i = 0; i < vec.getLength(); ++i) {
            this.emitByte(vec.get(i));
        }
    }

    public short cpi() {
        if (this.cpIdx == 0) {
            throw new RuntimeException("Illegal use of ClassFileAssembler");
        }
        return this.cpIdx;
    }

    public void emitConstantPoolUTF8(String str) {
        byte[] bytes = UTF8.encode(str);
        this.emitByte((byte)1);
        this.emitShort((short)bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            this.emitByte(bytes[i]);
        }
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    public void emitConstantPoolClass(short index) {
        this.emitByte((byte)7);
        this.emitShort(index);
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    public void emitConstantPoolNameAndType(short nameIndex, short typeIndex) {
        this.emitByte((byte)12);
        this.emitShort(nameIndex);
        this.emitShort(typeIndex);
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    public void emitConstantPoolFieldref(short classIndex, short nameAndTypeIndex) {
        this.emitByte((byte)9);
        this.emitShort(classIndex);
        this.emitShort(nameAndTypeIndex);
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    public void emitConstantPoolMethodref(short classIndex, short nameAndTypeIndex) {
        this.emitByte((byte)10);
        this.emitShort(classIndex);
        this.emitShort(nameAndTypeIndex);
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    public void emitConstantPoolInterfaceMethodref(short classIndex, short nameAndTypeIndex) {
        this.emitByte((byte)11);
        this.emitShort(classIndex);
        this.emitShort(nameAndTypeIndex);
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    public void emitConstantPoolString(short utf8Index) {
        this.emitByte((byte)8);
        this.emitShort(utf8Index);
        this.cpIdx = (short)(this.cpIdx + 1);
    }

    private void incStack() {
        this.setStack(this.stack + 1);
    }

    private void decStack() {
        --this.stack;
    }

    public short getMaxStack() {
        return (short)this.maxStack;
    }

    public short getMaxLocals() {
        return (short)this.maxLocals;
    }

    public void setMaxLocals(int maxLocals) {
        this.maxLocals = maxLocals;
    }

    public int getStack() {
        return this.stack;
    }

    public void setStack(int value) {
        this.stack = value;
        if (this.stack > this.maxStack) {
            this.maxStack = this.stack;
        }
    }

    public void opc_aconst_null() {
        this.emitByte((byte)1);
        this.incStack();
    }

    public void opc_sipush(short constant) {
        this.emitByte((byte)17);
        this.emitShort(constant);
        this.incStack();
    }

    public void opc_ldc(byte cpIdx) {
        this.emitByte((byte)18);
        this.emitByte(cpIdx);
        this.incStack();
    }

    public void opc_iload_0() {
        this.emitByte((byte)26);
        if (this.maxLocals < 1) {
            this.maxLocals = 1;
        }
        this.incStack();
    }

    public void opc_iload_1() {
        this.emitByte((byte)27);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
        this.incStack();
    }

    public void opc_iload_2() {
        this.emitByte((byte)28);
        if (this.maxLocals < 3) {
            this.maxLocals = 3;
        }
        this.incStack();
    }

    public void opc_iload_3() {
        this.emitByte((byte)29);
        if (this.maxLocals < 4) {
            this.maxLocals = 4;
        }
        this.incStack();
    }

    public void opc_lload_0() {
        this.emitByte((byte)30);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_lload_1() {
        this.emitByte((byte)31);
        if (this.maxLocals < 3) {
            this.maxLocals = 3;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_lload_2() {
        this.emitByte((byte)32);
        if (this.maxLocals < 4) {
            this.maxLocals = 4;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_lload_3() {
        this.emitByte((byte)33);
        if (this.maxLocals < 5) {
            this.maxLocals = 5;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_fload_0() {
        this.emitByte((byte)34);
        if (this.maxLocals < 1) {
            this.maxLocals = 1;
        }
        this.incStack();
    }

    public void opc_fload_1() {
        this.emitByte((byte)35);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
        this.incStack();
    }

    public void opc_fload_2() {
        this.emitByte((byte)36);
        if (this.maxLocals < 3) {
            this.maxLocals = 3;
        }
        this.incStack();
    }

    public void opc_fload_3() {
        this.emitByte((byte)37);
        if (this.maxLocals < 4) {
            this.maxLocals = 4;
        }
        this.incStack();
    }

    public void opc_dload_0() {
        this.emitByte((byte)38);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_dload_1() {
        this.emitByte((byte)39);
        if (this.maxLocals < 3) {
            this.maxLocals = 3;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_dload_2() {
        this.emitByte((byte)40);
        if (this.maxLocals < 4) {
            this.maxLocals = 4;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_dload_3() {
        this.emitByte((byte)41);
        if (this.maxLocals < 5) {
            this.maxLocals = 5;
        }
        this.incStack();
        this.incStack();
    }

    public void opc_aload_0() {
        this.emitByte((byte)42);
        if (this.maxLocals < 1) {
            this.maxLocals = 1;
        }
        this.incStack();
    }

    public void opc_aload_1() {
        this.emitByte((byte)43);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
        this.incStack();
    }

    public void opc_aload_2() {
        this.emitByte((byte)44);
        if (this.maxLocals < 3) {
            this.maxLocals = 3;
        }
        this.incStack();
    }

    public void opc_aload_3() {
        this.emitByte((byte)45);
        if (this.maxLocals < 4) {
            this.maxLocals = 4;
        }
        this.incStack();
    }

    public void opc_aaload() {
        this.emitByte((byte)50);
        this.decStack();
    }

    public void opc_astore_0() {
        this.emitByte((byte)75);
        if (this.maxLocals < 1) {
            this.maxLocals = 1;
        }
        this.decStack();
    }

    public void opc_astore_1() {
        this.emitByte((byte)76);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
        this.decStack();
    }

    public void opc_astore_2() {
        this.emitByte((byte)77);
        if (this.maxLocals < 3) {
            this.maxLocals = 3;
        }
        this.decStack();
    }

    public void opc_astore_3() {
        this.emitByte((byte)78);
        if (this.maxLocals < 4) {
            this.maxLocals = 4;
        }
        this.decStack();
    }

    public void opc_pop() {
        this.emitByte((byte)87);
        this.decStack();
    }

    public void opc_dup() {
        this.emitByte((byte)89);
        this.incStack();
    }

    public void opc_dup_x1() {
        this.emitByte((byte)90);
        this.incStack();
    }

    public void opc_swap() {
        this.emitByte((byte)95);
    }

    public void opc_i2l() {
        this.emitByte((byte)-123);
    }

    public void opc_i2f() {
        this.emitByte((byte)-122);
    }

    public void opc_i2d() {
        this.emitByte((byte)-121);
    }

    public void opc_l2f() {
        this.emitByte((byte)-119);
    }

    public void opc_l2d() {
        this.emitByte((byte)-118);
    }

    public void opc_f2d() {
        this.emitByte((byte)-115);
    }

    public void opc_ifeq(short bciOffset) {
        this.emitByte((byte)-103);
        this.emitShort(bciOffset);
        this.decStack();
    }

    public void opc_ifeq(Label l) {
        short instrBCI = this.getLength();
        this.emitByte((byte)-103);
        l.add(this, instrBCI, this.getLength(), this.getStack() - 1);
        this.emitShort((short)-1);
    }

    public void opc_if_icmpeq(short bciOffset) {
        this.emitByte((byte)-97);
        this.emitShort(bciOffset);
        this.setStack(this.getStack() - 2);
    }

    public void opc_if_icmpeq(Label l) {
        short instrBCI = this.getLength();
        this.emitByte((byte)-97);
        l.add(this, instrBCI, this.getLength(), this.getStack() - 2);
        this.emitShort((short)-1);
    }

    public void opc_goto(short bciOffset) {
        this.emitByte((byte)-89);
        this.emitShort(bciOffset);
    }

    public void opc_goto(Label l) {
        short instrBCI = this.getLength();
        this.emitByte((byte)-89);
        l.add(this, instrBCI, this.getLength(), this.getStack());
        this.emitShort((short)-1);
    }

    public void opc_ifnull(short bciOffset) {
        this.emitByte((byte)-58);
        this.emitShort(bciOffset);
        this.decStack();
    }

    public void opc_ifnull(Label l) {
        short instrBCI = this.getLength();
        this.emitByte((byte)-58);
        l.add(this, instrBCI, this.getLength(), this.getStack() - 1);
        this.emitShort((short)-1);
        this.decStack();
    }

    public void opc_ifnonnull(short bciOffset) {
        this.emitByte((byte)-57);
        this.emitShort(bciOffset);
        this.decStack();
    }

    public void opc_ifnonnull(Label l) {
        short instrBCI = this.getLength();
        this.emitByte((byte)-57);
        l.add(this, instrBCI, this.getLength(), this.getStack() - 1);
        this.emitShort((short)-1);
        this.decStack();
    }

    public void opc_ireturn() {
        this.emitByte((byte)-84);
        this.setStack(0);
    }

    public void opc_lreturn() {
        this.emitByte((byte)-83);
        this.setStack(0);
    }

    public void opc_freturn() {
        this.emitByte((byte)-82);
        this.setStack(0);
    }

    public void opc_dreturn() {
        this.emitByte((byte)-81);
        this.setStack(0);
    }

    public void opc_areturn() {
        this.emitByte((byte)-80);
        this.setStack(0);
    }

    public void opc_return() {
        this.emitByte((byte)-79);
        this.setStack(0);
    }

    public void opc_getstatic(short fieldIndex, int fieldSizeInStackSlots) {
        this.emitByte((byte)-78);
        this.emitShort(fieldIndex);
        this.setStack(this.getStack() + fieldSizeInStackSlots);
    }

    public void opc_putstatic(short fieldIndex, int fieldSizeInStackSlots) {
        this.emitByte((byte)-77);
        this.emitShort(fieldIndex);
        this.setStack(this.getStack() - fieldSizeInStackSlots);
    }

    public void opc_getfield(short fieldIndex, int fieldSizeInStackSlots) {
        this.emitByte((byte)-76);
        this.emitShort(fieldIndex);
        this.setStack(this.getStack() + fieldSizeInStackSlots - 1);
    }

    public void opc_putfield(short fieldIndex, int fieldSizeInStackSlots) {
        this.emitByte((byte)-75);
        this.emitShort(fieldIndex);
        this.setStack(this.getStack() - fieldSizeInStackSlots - 1);
    }

    public void opc_invokevirtual(short methodIndex, int numArgs, int numReturnValues) {
        this.emitByte((byte)-74);
        this.emitShort(methodIndex);
        this.setStack(this.getStack() - numArgs - 1 + numReturnValues);
    }

    public void opc_invokespecial(short methodIndex, int numArgs, int numReturnValues) {
        this.emitByte((byte)-73);
        this.emitShort(methodIndex);
        this.setStack(this.getStack() - numArgs - 1 + numReturnValues);
    }

    public void opc_invokestatic(short methodIndex, int numArgs, int numReturnValues) {
        this.emitByte((byte)-72);
        this.emitShort(methodIndex);
        this.setStack(this.getStack() - numArgs + numReturnValues);
    }

    public void opc_invokeinterface(short methodIndex, int numArgs, byte count, int numReturnValues) {
        this.emitByte((byte)-71);
        this.emitShort(methodIndex);
        this.emitByte(count);
        this.emitByte((byte)0);
        this.setStack(this.getStack() - numArgs - 1 + numReturnValues);
    }

    public void opc_arraylength() {
        this.emitByte((byte)-66);
    }

    public void opc_new(short classIndex) {
        this.emitByte((byte)-69);
        this.emitShort(classIndex);
        this.incStack();
    }

    public void opc_athrow() {
        this.emitByte((byte)-65);
        this.setStack(1);
    }

    public void opc_checkcast(short classIndex) {
        this.emitByte((byte)-64);
        this.emitShort(classIndex);
    }

    public void opc_instanceof(short classIndex) {
        this.emitByte((byte)-63);
        this.emitShort(classIndex);
    }
}

