/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.global;

public class RandomGenerator {
    public static int intRangeRandom(int lowLimit, int upLimit) {
        int num = (int)Math.floor(RandomGenerator.doubleRangeRandom(lowLimit, upLimit + 1) - 1.0E-10);
        return num;
    }

    public static double doubleRangeRandom(double lowLimit, double upLimit) {
        double num = lowLimit + Math.random() * (upLimit - lowLimit);
        return num;
    }

    public static int[] randomSelection(int maxNum, int times) {
        if (times <= 0) {
            return new int[0];
        }
        int realTimes = Math.min(maxNum, times);
        boolean[] flags = new boolean[maxNum];
        boolean isBelowHalf = (double)times < (double)maxNum * 0.5;
        int virtualTimes = realTimes;
        if (!isBelowHalf) {
            virtualTimes = maxNum - realTimes;
        }
        int i = 0;
        int upper = maxNum - 1;
        int[] indices = new int[realTimes];
        while (i < virtualTimes) {
            indices[i] = RandomGenerator.intRangeRandom(0, upper);
            if (flags[indices[i]]) continue;
            flags[indices[i]] = true;
            ++i;
        }
        if (!isBelowHalf) {
            int j = 0;
            for (i = 0; i < maxNum; ++i) {
                if (flags[i] != isBelowHalf) continue;
                indices[j] = i;
                if (++j == realTimes) break;
            }
        }
        return indices;
    }
}

