<?php

namespace Drupal\migrate\Plugin\migrate\process;

use Drupal\migrate\MigrateException;
use Drupal\migrate\MigrateExecutableInterface;
use Drupal\migrate\ProcessPluginBase;
use Drupal\migrate\Row;

/**
 * Concatenates the strings in the current value.
 *
 * @link https://www.drupal.org/node/2345927 Online handbook documentation for concat process plugin @endlink
 *
 * @MigrateProcessPlugin(
 *   id = "concat",
 *   handle_multiples = TRUE
 * )
 */
class Concat extends ProcessPluginBase {

  /**
   * {@inheritdoc}
   *
   * Concatenates the strings in the current value.
   */
  public function transform($value, MigrateExecutableInterface $migrate_executable, Row $row, $destination_property) {
    if (is_array($value)) {
      $delimiter = isset($this->configuration['delimiter']) ? $this->configuration['delimiter'] : '';
      return implode($delimiter, $value);
    }
    else {
      throw new MigrateException(sprintf('%s is not an array', var_export($value, TRUE)));
    }
  }

}
