/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundleFileStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.structureView.PropertiesPrefixGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NewPropertyAction
extends AnAction {
    private final boolean myEnabledForce;

    public NewPropertyAction() {
        this(false);
    }

    public NewPropertyAction(boolean enabledForce) {
        super("New Property", null, AllIcons.General.Add);
        this.myEnabledForce = enabledForce;
    }

    public void actionPerformed(AnActionEvent e) {
        String separator;
        String prefix;
        ResourceBundleEditor resourceBundleEditor;
        Project project = NewPropertyAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        DataContext context = e.getDataContext();
        FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
        if (fileEditor instanceof ResourceBundleEditor) {
            resourceBundleEditor = (ResourceBundleEditor)fileEditor;
        } else {
            FileEditor[] editor = (FileEditor[])CommonDataKeys.EDITOR.getData(context);
            ResourceBundleEditor resourceBundleEditor2 = resourceBundleEditor = editor != null ? (ResourceBundleEditor)((Object)editor.getUserData(ResourceBundleEditor.RESOURCE_BUNDLE_EDITOR_KEY)) : null;
        }
        if (resourceBundleEditor == null) {
            for (FileEditor editor : FileEditorManager.getInstance((Project)project).getSelectedEditors()) {
                if (!(editor instanceof ResourceBundleEditor)) continue;
                resourceBundleEditor = (ResourceBundleEditor)editor;
            }
            if (resourceBundleEditor == null) {
                return;
            }
        }
        ResourceBundle bundle = resourceBundleEditor.getResourceBundle();
        VirtualFile file = bundle.getDefaultPropertiesFile().getVirtualFile();
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{file});
        if (status.hasReadonlyFiles()) {
            Messages.showErrorDialog((Project)bundle.getProject(), (String)String.format("Resource bundle '%s' has read-only default properties file", bundle.getBaseName()), (String)"Can't Create New Property");
            return;
        }
        String place = e.getPlace();
        if ("StructureViewToolbar".equals(place)) {
            prefix = null;
            separator = null;
        } else {
            ResourceBundleEditorViewElement selectedElement = resourceBundleEditor.getSelectedElementIfOnlyOne();
            if (selectedElement == null) {
                return;
            }
            if (selectedElement instanceof PropertiesPrefixGroup) {
                PropertiesPrefixGroup group = (PropertiesPrefixGroup)selectedElement;
                prefix = group.getPrefix();
                separator = group.getSeparator();
            } else if (selectedElement instanceof ResourceBundlePropertyStructureViewElement || selectedElement instanceof ResourceBundleFileStructureViewElement) {
                prefix = null;
                separator = null;
            } else {
                throw new IllegalStateException("unsupported type: " + selectedElement.getClass());
            }
        }
        Messages.showInputDialog((Project)project, (String)PropertiesBundle.message("new.property.dialog.name.prompt.text", new Object[0]), (String)PropertiesBundle.message("new.property.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), null, (InputValidator)new NewPropertyNameValidator(resourceBundleEditor, prefix, separator));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/editor/NewPropertyAction", "update"));
        }
        if (!this.myEnabledForce) {
            FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(e.getDataContext());
            e.getPresentation().setEnabledAndVisible(editor instanceof ResourceBundleEditor);
        }
    }

    private static class NewPropertyNameValidator
    implements InputValidator {
        @NotNull
        private final ResourceBundleEditor myResourceBundleEditor;
        @Nullable
        private final String myPrefix;
        @Nullable
        private final String mySeparator;

        public NewPropertyNameValidator(@NotNull ResourceBundleEditor resourceBundleEditor, @Nullable String prefix, @Nullable String separator) {
            if (resourceBundleEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundleEditor", "com/intellij/lang/properties/editor/NewPropertyAction$NewPropertyNameValidator", "<init>"));
            }
            this.myResourceBundleEditor = resourceBundleEditor;
            this.myPrefix = prefix;
            this.mySeparator = separator;
        }

        public boolean checkInput(String inputString) {
            return !inputString.isEmpty();
        }

        public boolean canClose(String inputString) {
            String newPropertyName = this.myPrefix == null ? inputString : this.myPrefix + this.mySeparator + inputString;
            ResourceBundle resourceBundle = this.myResourceBundleEditor.getResourceBundle();
            for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
                for (String propertyName : propertiesFile.getNamesMap().keySet()) {
                    if (!newPropertyName.equals(propertyName)) continue;
                    Messages.showErrorDialog((String)("Can't add new property. Property with key '" + newPropertyName + "' already exists."), (String)"New Property");
                    return false;
                }
            }
            ApplicationManager.getApplication().runWriteAction(() -> WriteCommandAction.runWriteCommandAction((Project)resourceBundle.getProject(), () -> this.myResourceBundleEditor.getPropertiesInsertDeleteManager().insertNewProperty(newPropertyName, "")));
            this.myResourceBundleEditor.updateTreeRoot();
            this.myResourceBundleEditor.selectProperty(newPropertyName);
            return true;
        }
    }
}

