/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor.inspections.incomplete;

import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import java.util.Locale;
import java.util.SortedSet;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncompletePropertyInspectionOptionsPanel {
    private final SortedSet<String> mySuffixes;
    private final JBList myList;

    public IncompletePropertyInspectionOptionsPanel(SortedSet<String> suffixes) {
        this.mySuffixes = suffixes;
        this.myList = new JBList((ListModel)new MyListModel());
    }

    public JPanel buildPanel() {
        JPanel panel = ToolbarDecorator.createDecorator((JList)this.myList).setPanelBorder((Border)IdeBorderFactory.createTitledBorder((String)"Ignored suffixes")).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String result = Messages.showInputDialog((Project)((Project)CommonDataKeys.PROJECT.getData(button.getDataContext())), (String)"Suffixes to ignore (use comma to separate suffixes):", (String)"Add Ignored Suffixes", null);
                if (result != null) {
                    IncompletePropertyInspectionOptionsPanel.this.mySuffixes.addAll(StringUtil.split((String)result, (String)","));
                    IncompletePropertyInspectionOptionsPanel.this.changed();
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                for (Object v : IncompletePropertyInspectionOptionsPanel.this.myList.getSelectedValues()) {
                    IncompletePropertyInspectionOptionsPanel.this.mySuffixes.remove(v);
                }
                IncompletePropertyInspectionOptionsPanel.this.changed();
            }
        }).createPanel();
        this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList list, String suffix, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspectionOptionsPanel$3", "customizeCellRenderer"));
                }
                this.append(suffix);
                Locale locale = PropertiesUtil.getLocale("_" + suffix + ".properties");
                if (locale != PropertiesUtil.DEFAULT_LOCALE) {
                    if (PropertiesUtil.hasDefaultLanguage(locale)) {
                        this.append(" ");
                        this.append(PropertiesUtil.getPresentableLocale(locale), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                } else {
                    this.append("Default locale");
                }
            }
        });
        return panel;
    }

    public boolean showDialogAndGet(Project project) {
        return new DialogWrapper(project){
            {
                this.init();
                this.setTitle("Locales to Ignore");
            }

            @Nullable
            protected JComponent createCenterPanel() {
                return IncompletePropertyInspectionOptionsPanel.this.buildPanel();
            }
        }.showAndGet();
    }

    private void changed() {
        ((MyListModel)this.myList.getModel()).modified();
    }

    private class MyListModel
    extends AbstractListModel {
        private MyListModel() {
        }

        @Override
        public int getSize() {
            return IncompletePropertyInspectionOptionsPanel.this.mySuffixes.size();
        }

        @Override
        public Object getElementAt(int index) {
            return IncompletePropertyInspectionOptionsPanel.this.mySuffixes.toArray(new String[IncompletePropertyInspectionOptionsPanel.this.mySuffixes.size()])[index];
        }

        public void modified() {
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

