/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.properties.parsing.Parsing;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.annotations.NotNull;

public class PropertiesParser
implements PsiParser {
    private static final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> MATCH_BY_KEY = (oldNode, newNode, structure) -> {
        ASTNode oldName;
        if (oldNode.getElementType() == PropertiesElementTypes.PROPERTY && (oldName = oldNode.findChildByType(PropertiesTokenTypes.KEY_CHARACTERS)) != null) {
            CharSequence oldNameStr = oldName.getChars();
            CharSequence newNameStr = PropertiesParser.findKeyCharacters(newNode, (FlyweightCapableTreeStructure<LighterASTNode>)structure);
            if (oldNameStr != null && !Comparing.equal((CharSequence)oldNameStr, (CharSequence)newNameStr)) {
                return ThreeState.NO;
            }
        }
        return ThreeState.UNSURE;
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharSequence findKeyCharacters(LighterASTNode newNode, FlyweightCapableTreeStructure<LighterASTNode> structure) {
        Ref childrenRef = Ref.create(null);
        int childrenCount = structure.getChildren((Object)newNode, childrenRef);
        Object[] children = (LighterASTNode[])childrenRef.get();
        try {
            for (int i = 0; i < children.length; ++i) {
                if (children[i].getTokenType() != PropertiesTokenTypes.KEY_CHARACTERS) continue;
                CharSequence charSequence = ((LighterASTTokenNode)children[i]).getText();
                return charSequence;
            }
            CharSequence charSequence = null;
            return charSequence;
        }
        finally {
            structure.disposeChildren(children, childrenCount);
        }
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        this.doParse(root, builder);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/parsing/PropertiesParser", "parse"));
        }
        return aSTNode;
    }

    @NotNull
    public FlyweightCapableTreeStructure<LighterASTNode> parseLight(IElementType root, PsiBuilder builder) {
        this.doParse(root, builder);
        FlyweightCapableTreeStructure flyweightCapableTreeStructure = builder.getLightTree();
        if (flyweightCapableTreeStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/parsing/PropertiesParser", "parseLight"));
        }
        return flyweightCapableTreeStructure;
    }

    public void doParse(IElementType root, PsiBuilder builder) {
        builder.putUserDataUnprotected(PsiBuilderImpl.CUSTOM_COMPARATOR, MATCH_BY_KEY);
        PsiBuilder.Marker rootMarker = builder.mark();
        PsiBuilder.Marker propertiesList = builder.mark();
        while (!builder.eof()) {
            Parsing.parseProperty(builder);
        }
        propertiesList.done((IElementType)PropertiesElementTypes.PROPERTIES_LIST);
        rootMarker.done(root);
    }
}

