/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Platform;
import com.google.common.truth.Subject;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractArraySubject<S extends AbstractArraySubject<S, T>, T>
extends Subject<S, T> {
    AbstractArraySubject(FailureStrategy failureStrategy, @Nullable T subject) {
        super(failureStrategy, subject);
    }

    public void isEmpty() {
        if (!this.listRepresentation().isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (this.listRepresentation().isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void hasLength(int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length (%s) must be >= 0");
        if (this.listRepresentation().size() != length) {
            this.fail("has length", (Object)length);
        }
    }

    @Override
    public S named(String name) {
        return (S)((AbstractArraySubject)super.named(name));
    }

    abstract String underlyingType();

    abstract List<?> listRepresentation();

    @Override
    protected String getDisplaySubject() {
        String string;
        if (this.internalCustomName() == null) {
            String string2 = this.underlyingType();
            String string3 = String.valueOf(this.listRepresentation());
            string = new StringBuilder(7 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("<(").append(string2).append("[]) ").append(string3).append(">").toString();
        } else {
            string = this.internalCustomName();
        }
        return string;
    }

    void failWithBadType(Object expected) {
        String expectedType = expected.getClass().isArray() ? String.valueOf(expected.getClass().getComponentType().getName()).concat("[]") : expected.getClass().getName();
        this.failWithRawMessage("Incompatible types compared. expected: %s, actual: %s[]", Platform.compressType(expectedType), this.underlyingType());
    }
}

