/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.support.descriptor.JavaSource;

@API(value=API.Usage.Experimental)
public class JavaMethodSource
implements JavaSource {
    private static final long serialVersionUID = 1L;
    private final Class<?> javaClass;
    private final String javaMethodName;
    private final Class<?>[] javaMethodParameterTypes;

    public JavaMethodSource(Method method) {
        Preconditions.notNull((Object)method, (String)"method must not be null");
        this.javaClass = method.getDeclaringClass();
        this.javaMethodName = method.getName();
        this.javaMethodParameterTypes = method.getParameterTypes();
    }

    public final Class<?> getJavaClass() {
        return this.javaClass;
    }

    public final String getJavaMethodName() {
        return this.javaMethodName;
    }

    public final List<Class<?>> getJavaMethodParameterTypes() {
        return Collections.unmodifiableList(Arrays.asList(this.javaMethodParameterTypes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaMethodSource that = (JavaMethodSource)o;
        return Objects.equals(this.javaClass, that.javaClass) && Objects.equals(this.javaMethodName, that.javaMethodName) && Arrays.equals(this.javaMethodParameterTypes, that.javaMethodParameterTypes);
    }

    public int hashCode() {
        return Objects.hash(this.javaClass, this.javaMethodName) + Arrays.hashCode(this.javaMethodParameterTypes);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("javaClass", (Object)this.javaClass.getName()).append("javaMethodName", (Object)this.javaMethodName).append("javaMethodParameterTypes", (Object)StringUtils.nullSafeToString((Class[])this.javaMethodParameterTypes)).toString();
    }
}

