/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.junit.jupiter.engine.discovery.predicates.IsNestedTestClass;
import org.junit.jupiter.engine.discovery.predicates.IsPotentialTestContainer;
import org.junit.jupiter.engine.discovery.predicates.IsTestFactoryMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestMethod;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ReflectionUtils;

@API(value=API.Usage.Internal)
public class IsTestClassWithTests
implements Predicate<Class<?>> {
    private static final IsTestMethod isTestMethod = new IsTestMethod();
    private static final IsTestFactoryMethod isTestFactoryMethod = new IsTestFactoryMethod();
    private static final Predicate<Method> isTestOrTestFactoryMethod = isTestMethod.or(isTestFactoryMethod);
    private static final IsPotentialTestContainer isPotentialTestContainer = new IsPotentialTestContainer();
    private static final IsNestedTestClass isNestedTestClass = new IsNestedTestClass();

    @Override
    public boolean test(Class<?> candidate) {
        if (!isPotentialTestContainer.test(candidate)) {
            return false;
        }
        return this.hasTestOrTestFactoryMethods(candidate) || this.hasNestedTests(candidate);
    }

    private boolean hasTestOrTestFactoryMethods(Class<?> candidate) {
        return !ReflectionUtils.findMethods(candidate, isTestOrTestFactoryMethod).isEmpty();
    }

    private boolean hasNestedTests(Class<?> candidate) {
        return !ReflectionUtils.findNestedClasses(candidate, (Predicate)isNestedTestClass).isEmpty();
    }
}

