/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class ChangeExtendsImplementsQuickFix
implements IntentionAction {
    @Nullable
    private final GrExtendsClause myExtendsClause;
    @Nullable
    private final GrImplementsClause myImplementsClause;
    @NotNull
    private final GrTypeDefinition myClass;

    public ChangeExtendsImplementsQuickFix(@NotNull GrTypeDefinition aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix", "<init>"));
        }
        this.myClass = aClass;
        this.myExtendsClause = aClass.getExtendsClause();
        this.myImplementsClause = aClass.getImplementsClause();
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("change.implements.and.extends.classes", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix", "isAvailable"));
        }
        return this.myClass.isValid() && this.myClass.getManager().isInProject((PsiElement)file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix", "invoke"));
        }
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        LinkedHashSet<String> interfaces = new LinkedHashSet<String>();
        LinkedHashSet<String> unknownClasses = new LinkedHashSet<String>();
        LinkedHashSet<String> unknownInterfaces = new LinkedHashSet<String>();
        if (this.myExtendsClause != null) {
            ChangeExtendsImplementsQuickFix.collectRefs(this.myExtendsClause.getReferenceElementsGroovy(), classes, interfaces, this.myClass.isInterface() ? unknownInterfaces : unknownClasses);
            this.myExtendsClause.delete();
        }
        if (this.myImplementsClause != null) {
            ChangeExtendsImplementsQuickFix.collectRefs(this.myImplementsClause.getReferenceElementsGroovy(), classes, interfaces, unknownInterfaces);
            this.myImplementsClause.delete();
        }
        if (this.myClass.isInterface()) {
            interfaces.addAll(classes);
            unknownInterfaces.addAll(unknownClasses);
            this.addNewClause(interfaces, unknownInterfaces, project, true);
        } else {
            this.addNewClause(classes, unknownClasses, project, true);
            this.addNewClause(interfaces, unknownInterfaces, project, false);
        }
    }

    private static void collectRefs(GrCodeReferenceElement[] refs, Collection<String> classes, Collection<String> interfaces, Collection<String> unknown) {
        for (GrCodeReferenceElement ref : refs) {
            PsiElement extendsElement = ref.resolve();
            String canonicalText = ref.getCanonicalText();
            if (extendsElement instanceof PsiClass) {
                if (((PsiClass)extendsElement).isInterface()) {
                    interfaces.add(canonicalText);
                    continue;
                }
                classes.add(canonicalText);
                continue;
            }
            unknown.add(canonicalText);
        }
    }

    private void addNewClause(Collection<String> elements, Collection<String> additional, Project project, boolean isExtends) throws IncorrectOperationException {
        GrReferenceList clause;
        if (elements.isEmpty() && additional.isEmpty()) {
            return;
        }
        StringBuilder classText = new StringBuilder();
        classText.append("class A ");
        classText.append(isExtends ? "extends " : "implements ");
        for (String str : elements) {
            classText.append(str);
            classText.append(", ");
        }
        for (String str : additional) {
            classText.append(str);
            classText.append(", ");
        }
        classText.delete(classText.length() - 2, classText.length());
        classText.append(" {}");
        GrTypeDefinition definition = GroovyPsiElementFactory.getInstance(project).createTypeDefinition(classText.toString());
        GrReferenceList grReferenceList = clause = isExtends ? definition.getExtendsClause() : definition.getImplementsClause();
        assert (clause != null);
        PsiElement addedClause = this.myClass.addBefore(clause, this.myClass.getBody());
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(addedClause);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

