/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.GutterIconTooltipHelper;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.ListBackgroundUpdaterTask;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class GroovyMarkerTypes {
    static final MarkerType OVERRIDING_PROPERTY_TYPE = new MarkerType("OVERRIDING_PROPERTY_TYPE", psiElement -> {
        PsiElement parent = psiElement.getParent();
        if (!(parent instanceof GrField)) {
            return null;
        }
        GrField field = (GrField)parent;
        List<GrAccessorMethod> accessors = GroovyPropertyUtils.getFieldAccessors(field);
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body>");
        int count = 0;
        String sep = "";
        for (GrAccessorMethod method : accessors) {
            PsiMethod[] superMethods = method.findSuperMethods(false);
            count += superMethods.length;
            if (superMethods.length == 0) continue;
            PsiMethod superMethod = superMethods[0];
            boolean isAbstract = method.hasModifierProperty("abstract");
            boolean isSuperAbstract = superMethod.hasModifierProperty("abstract");
            String key = isSuperAbstract && !isAbstract ? "method.implements.in" : "method.overrides.in";
            builder.append(sep);
            sep = "<br>";
            GroovyMarkerTypes.composeText((PsiElement[])superMethods, DaemonBundle.message((String)key, (Object[])new Object[0]), builder);
        }
        if (count == 0) {
            return null;
        }
        builder.append("</html></body>");
        return builder.toString();
    }, new LineMarkerNavigator(){

        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof GrField)) {
                return;
            }
            GrField field = (GrField)parent;
            List<GrAccessorMethod> accessors = GroovyPropertyUtils.getFieldAccessors(field);
            ArrayList superMethods = new ArrayList();
            for (GrAccessorMethod method : accessors) {
                Collections.addAll(superMethods, method.findSuperMethods(false));
            }
            if (superMethods.isEmpty()) {
                return;
            }
            PsiMethod[] supers = (PsiMethod[])ContainerUtil.toArray(superMethods, (Object[])new PsiMethod[superMethods.size()]);
            boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])supers);
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])supers, (String)DaemonBundle.message((String)"navigation.title.super.method", (Object[])new Object[]{field.getName()}), (String)DaemonBundle.message((String)"navigation.findUsages.title.super.method", (Object[])new Object[]{field.getName()}), (ListCellRenderer)new MethodCellRenderer(showMethodNames));
        }
    });
    static final MarkerType OVERRIDEN_PROPERTY_TYPE = new MarkerType("OVERRIDEN_PROPERTY_TYPE", element -> {
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrField)) {
            return null;
        }
        List<GrAccessorMethod> accessors = GroovyPropertyUtils.getFieldAccessors((GrField)parent);
        PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(5);
        for (GrAccessorMethod method : accessors) {
            OverridingMethodsSearch.search((PsiMethod)method).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor));
        }
        if (processor.isOverflow()) {
            return DaemonBundle.message((String)"method.is.overridden.too.many", (Object[])new Object[0]);
        }
        PsiMethod[] overridings = (PsiMethod[])processor.toArray((PsiElement[])new PsiMethod[processor.getCollection().size()]);
        if (overridings.length == 0) {
            return null;
        }
        Comparator comparator = new MethodCellRenderer(false).getComparator();
        Arrays.sort(overridings, comparator);
        String start = DaemonBundle.message((String)"method.is.overriden.header", (Object[])new Object[0]);
        String pattern = "&nbsp;&nbsp;&nbsp;&nbsp;{1}";
        return GutterIconTooltipHelper.composeText((PsiElement[])overridings, (String)start, (String)pattern);
    }, new LineMarkerNavigator(){

        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof GrField)) {
                return;
            }
            if (DumbService.isDumb((Project)element.getProject())) {
                DumbService.getInstance((Project)element.getProject()).showDumbModeNotification("Navigation to overriding classes is not possible during index update");
                return;
            }
            GrField field = (GrField)parent;
            THashSet result = new THashSet();
            Processor collectProcessor = Processors.cancelableCollectProcessor((Collection)result);
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
                for (GrAccessorMethod method : GroovyPropertyUtils.getFieldAccessors(field)) {
                    OverridingMethodsSearch.search((PsiMethod)method).forEach(collectProcessor);
                }
            }), "Searching for overriding methods", true, field.getProject(), (JComponent)e.getComponent())) {
                return;
            }
            PsiMethod[] overridings = result.toArray(PsiMethod.EMPTY_ARRAY);
            if (overridings.length == 0) {
                return;
            }
            String title = DaemonBundle.message((String)"navigation.title.overrider.method", (Object[])new Object[]{field.getName(), overridings.length});
            boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])overridings);
            MethodCellRenderer renderer = new MethodCellRenderer(showMethodNames);
            Arrays.sort(overridings, renderer.getComparator());
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])overridings, (String)title, (String)("Overriding Methods of " + field.getName()), (ListCellRenderer)renderer);
        }
    });
    public static final MarkerType GR_OVERRIDING_METHOD = new MarkerType("GR_OVERRIDING_METHOD", (Function)((NullableFunction)element -> {
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrMethod)) {
            return null;
        }
        GrMethod method = (GrMethod)parent;
        Set<PsiMethod> superMethods = GroovyMarkerTypes.collectSuperMethods(method);
        if (superMethods.isEmpty()) {
            return null;
        }
        PsiMethod superMethod = superMethods.iterator().next();
        boolean isAbstract = method.hasModifierProperty("abstract");
        boolean isSuperAbstract = superMethod.hasModifierProperty("abstract");
        boolean sameSignature = superMethod.getSignature(PsiSubstitutor.EMPTY).equals(method.getSignature(PsiSubstitutor.EMPTY));
        String key = isSuperAbstract && !isAbstract ? (sameSignature ? "method.implements" : "method.implements.in") : (sameSignature ? "method.overrides" : "method.overrides.in");
        return GutterIconTooltipHelper.composeText(superMethods, (String)"", (String)DaemonBundle.message((String)key, (Object[])new Object[0]));
    }), new LineMarkerNavigator(){

        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof GrMethod)) {
                return;
            }
            GrMethod method = (GrMethod)parent;
            Set superMethods = GroovyMarkerTypes.collectSuperMethods(method);
            if (superMethods.isEmpty()) {
                return;
            }
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])superMethods.toArray(new NavigatablePsiElement[superMethods.size()]), (String)DaemonBundle.message((String)"navigation.title.super.method", (Object[])new Object[]{method.getName()}), (String)DaemonBundle.message((String)"navigation.findUsages.title.super.method", (Object[])new Object[]{method.getName()}), (ListCellRenderer)new MethodCellRenderer(true));
        }
    });
    public static final MarkerType GR_OVERRIDEN_METHOD = new MarkerType("GR_OVERRIDEN_METHOD", (Function)((NullableFunction)element -> {
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrMethod)) {
            return null;
        }
        GrMethod method = (GrMethod)parent;
        final PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(5);
        for (GrMethod m : org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil.getMethodOrReflectedMethods(method)) {
            OverridingMethodsSearch.search((PsiMethod)m).forEach((Processor)new ReadActionProcessor<PsiMethod>(){

                public boolean processInReadAction(PsiMethod method) {
                    if (method instanceof GrTraitMethod) {
                        return true;
                    }
                    return processor.execute((PsiElement)method);
                }
            });
        }
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (processor.isOverflow()) {
            return isAbstract ? DaemonBundle.message((String)"method.is.implemented.too.many", (Object[])new Object[0]) : DaemonBundle.message((String)"method.is.overridden.too.many", (Object[])new Object[0]);
        }
        PsiMethod[] overridings = (PsiMethod[])processor.toArray((PsiElement[])new PsiMethod[processor.getCollection().size()]);
        if (overridings.length == 0) {
            return null;
        }
        Comparator comparator = new MethodCellRenderer(false).getComparator();
        Arrays.sort(overridings, comparator);
        String start = isAbstract ? DaemonBundle.message((String)"method.is.implemented.header", (Object[])new Object[0]) : DaemonBundle.message((String)"method.is.overriden.header", (Object[])new Object[0]);
        String pattern = "&nbsp;&nbsp;&nbsp;&nbsp;{1}";
        return GutterIconTooltipHelper.composeText((PsiElement[])overridings, (String)start, (String)pattern);
    }), new LineMarkerNavigator(){

        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof GrMethod)) {
                return;
            }
            if (DumbService.isDumb((Project)element.getProject())) {
                DumbService.getInstance((Project)element.getProject()).showDumbModeNotification("Navigation to overriding classes is not possible during index update");
                return;
            }
            GrMethod method = (GrMethod)parent;
            final PsiElementProcessor.CollectElementsWithLimit collectProcessor = new PsiElementProcessor.CollectElementsWithLimit(2, (Collection)new THashSet());
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
                for (GrMethod m : org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil.getMethodOrReflectedMethods(method)) {
                    OverridingMethodsSearch.search((PsiMethod)m).forEach((Processor)new ReadActionProcessor<PsiMethod>(){

                        public boolean processInReadAction(PsiMethod psiMethod) {
                            if (psiMethod instanceof GrReflectedMethod) {
                                psiMethod = ((GrReflectedMethod)psiMethod).getBaseMethod();
                            }
                            return collectProcessor.execute((PsiElement)psiMethod);
                        }
                    });
                }
            }), "Searching for Overriding Methods", true, method.getProject(), (JComponent)e.getComponent())) {
                return;
            }
            PsiMethod[] overridings = (PsiMethod[])collectProcessor.toArray((PsiElement[])PsiMethod.EMPTY_ARRAY);
            if (overridings.length == 0) {
                return;
            }
            MethodCellRenderer renderer = new MethodCellRenderer(!PsiUtil.allMethodsHaveSameSignature((PsiMethod[])overridings));
            Arrays.sort(overridings, renderer.getComparator());
            OverridingMethodsUpdater methodsUpdater = new OverridingMethodsUpdater(method, (PsiElementListCellRenderer)renderer);
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])overridings, (String)methodsUpdater.getCaption(overridings.length), (String)("Overriding Methods of " + method.getName()), (ListCellRenderer)renderer, (ListBackgroundUpdaterTask)methodsUpdater);
        }
    });

    private GroovyMarkerTypes() {
    }

    private static Set<PsiMethod> collectSuperMethods(GrMethod method) {
        HashSet superMethods = new HashSet();
        for (GrMethod m : org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil.getMethodOrReflectedMethods(method)) {
            for (PsiMethod superMethod : m.findSuperMethods(false)) {
                if (superMethod instanceof GrReflectedMethod) {
                    superMethod = ((GrReflectedMethod)superMethod).getBaseMethod();
                }
                superMethods.add(superMethod);
            }
        }
        return superMethods;
    }

    private static StringBuilder composeText(@NotNull PsiElement[] elements, String pattern, StringBuilder result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/plugins/groovy/codeInsight/GroovyMarkerTypes", "composeText"));
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (PsiElement element : elements) {
            String methodName = ((PsiMethod)element).getName();
            PsiClass aClass = ((PsiMethod)element).getContainingClass();
            String className = aClass == null ? "" : ClassPresentationUtil.getNameForClass((PsiClass)aClass, (boolean)true);
            names.add(MessageFormat.format(pattern, methodName, className));
        }
        String sep = "";
        for (String name : names) {
            result.append(sep);
            sep = "<br>";
            result.append(name);
        }
        return result;
    }

    private static class OverridingMethodsUpdater
    extends ListBackgroundUpdaterTask {
        private final GrMethod myMethod;
        private final PsiElementListCellRenderer myRenderer;

        public OverridingMethodsUpdater(GrMethod method, PsiElementListCellRenderer renderer) {
            super(method.getProject(), "Searching for Overriding Methods");
            this.myMethod = method;
            this.myRenderer = renderer;
        }

        public String getCaption(int size) {
            return this.myMethod.hasModifierProperty("abstract") ? DaemonBundle.message((String)"navigation.title.implementation.method", (Object[])new Object[]{this.myMethod.getName(), size}) : DaemonBundle.message((String)"navigation.title.overrider.method", (Object[])new Object[]{this.myMethod.getName(), size});
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/groovy/codeInsight/GroovyMarkerTypes$OverridingMethodsUpdater", "run"));
            }
            super.run(indicator);
            for (GrMethod method : org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil.getMethodOrReflectedMethods(this.myMethod)) {
                OverridingMethodsSearch.search((PsiMethod)method).forEach((Processor)new CommonProcessors.CollectProcessor<PsiMethod>(){

                    public boolean process(PsiMethod psiMethod) {
                        if (!this.updateComponent(PsiImplUtil.handleMirror((PsiElement)psiMethod), myRenderer.getComparator())) {
                            indicator.cancel();
                        }
                        indicator.checkCanceled();
                        return true;
                    }
                });
            }
        }
    }
}

