/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.MethodCallData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.OptionsData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.ReplacementData;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public abstract class Transformation {
    @Nullable
    protected final IElementType operator;

    public Transformation(@Nullable IElementType operator) {
        this.operator = operator;
    }

    @Nullable
    public ReplacementData transform(GrMethodCallExpression callExpression, OptionsData optionsData) {
        GrExpression element = this.getExpandedElement(callExpression);
        MethodCallData methodInfo = MethodCallData.create(element);
        if (methodInfo == null) {
            return null;
        }
        String replacement = this.getReplacement(methodInfo, optionsData);
        if (replacement == null) {
            return null;
        }
        return new ReplacementData(element, replacement);
    }

    protected GrExpression getExpandedElement(GrMethodCallExpression callExpression) {
        return callExpression;
    }

    @Nullable
    public abstract String getReplacement(MethodCallData var1, OptionsData var2);
}

