/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyAwareModuleBuilder;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.config.GroovyFrameworkType;
import org.jetbrains.plugins.groovy.config.GroovySupportConfigurable;

public class GroovyFrameworkSupportProvider
extends FrameworkSupportInModuleProvider {
    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        FrameworkTypeEx frameworkTypeEx = (FrameworkTypeEx)FrameworkTypeEx.EP_NAME.findExtension(GroovyFrameworkType.class);
        if (frameworkTypeEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/config/GroovyFrameworkSupportProvider", "getFrameworkType"));
        }
        return frameworkTypeEx;
    }

    public boolean isEnabledForModuleBuilder(@NotNull ModuleBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/config/GroovyFrameworkSupportProvider", "isEnabledForModuleBuilder"));
        }
        return super.isEnabledForModuleBuilder(builder) && !(builder instanceof GroovyAwareModuleBuilder);
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/config/GroovyFrameworkSupportProvider", "isSupportAlreadyAdded"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetsProvider", "org/jetbrains/plugins/groovy/config/GroovyFrameworkSupportProvider", "isSupportAlreadyAdded"));
        }
        String version = GroovyConfigUtils.getInstance().getSDKVersion(module);
        return version != null;
    }

    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/plugins/groovy/config/GroovyFrameworkSupportProvider", "createConfigurable"));
        }
        GroovySupportConfigurable groovySupportConfigurable = new GroovySupportConfigurable();
        if (groovySupportConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/config/GroovyFrameworkSupportProvider", "createConfigurable"));
        }
        return groovySupportConfigurable;
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "org/jetbrains/plugins/groovy/config/GroovyFrameworkSupportProvider", "isEnabledForModuleType"));
        }
        return GroovyFacetUtil.isAcceptableModuleType(moduleType);
    }
}

