/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class ClassContextFilter {
    private static final Key<Map<String, PsiType>> CACHED_TYPES = Key.create((String)"Cached types");

    public static ContextFilter fromClassPattern(ElementPattern pattern) {
        return (descriptor, ctx) -> {
            PsiType type = descriptor.getPsiType();
            return type instanceof PsiClassType && pattern.accepts((Object)((PsiClassType)type).resolve());
        };
    }

    public static ContextFilter subtypeOf(String typeText) {
        return (descriptor, ctx) -> ClassContextFilter.isSubtype(descriptor.getPsiType(), descriptor.justGetPlaceFile(), typeText);
    }

    public static boolean isSubtype(PsiType checked, PsiFile placeFile, String typeText) {
        PsiClass psiClass;
        boolean isClassType = checked instanceof PsiClassType;
        if (isClassType && (psiClass = ((PsiClassType)checked).resolve()) != null) {
            String rawName;
            int i = typeText.indexOf("<");
            String string = rawName = i > 0 ? typeText.substring(0, i) : typeText;
            if (!ClassUtil.getSuperClassesWithCache(psiClass).containsKey(rawName)) {
                return false;
            }
        }
        PsiType myType = ClassContextFilter.getCachedType(typeText, placeFile);
        if (checked == PsiType.NULL) {
            return myType == PsiType.NULL;
        }
        return TypesUtil.isAssignableByMethodCallConversion(myType, checked, (PsiElement)placeFile);
    }

    public static PsiType getCachedType(String typeText, PsiFile context) {
        PsiType type;
        Map map = (Map)context.getUserData(CACHED_TYPES);
        if (map == null) {
            map = ContainerUtil.newConcurrentMap();
            context.putUserData(CACHED_TYPES, (Object)map);
        }
        if ((type = (PsiType)map.get(typeText)) == null || !type.isValid()) {
            type = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(typeText, (PsiElement)context);
            map.put(typeText, type);
        }
        return type;
    }
}

