/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class ConvertStringToMultilineIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(ConvertStringToMultilineIntention.class);
    public static final String hint = GroovyIntentionsBundle.message("convert.string.to.multiline.intention.name", new Object[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processIntention(@NotNull PsiElement element, final Project project, final Editor editor) throws IncorrectOperationException {
        List<GrExpression> expressions;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "processIntention"));
        }
        if (editor.getSelectionModel().hasSelection()) {
            expressions = Collections.singletonList((GrExpression)element);
        } else {
            AccessToken accessToken = ReadAction.start();
            try {
                expressions = ConvertStringToMultilineIntention.collectExpressions(element);
            }
            finally {
                accessToken.finish();
            }
        }
        if (expressions.size() == 1) {
            this.invokeImpl(expressions.get(0), project, editor);
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.invokeImpl(expressions.get(expressions.size() - 1), project, editor);
        } else {
            Pass<GrExpression> callback = new Pass<GrExpression>(){

                public void pass(@NotNull GrExpression selectedValue) {
                    if (selectedValue == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedValue", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention$1", "pass"));
                    }
                    ConvertStringToMultilineIntention.this.invokeImpl(selectedValue, project, editor);
                }
            };
            Function renderer = grExpression -> grExpression.getText();
            IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)callback, (Function)renderer);
        }
    }

    @NotNull
    private static List<GrExpression> collectExpressions(@NotNull PsiElement element) {
        GrBinaryExpression binary;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "collectExpressions"));
        }
        assert (element instanceof GrExpression);
        ArrayList result = ContainerUtil.newArrayList();
        result.add((GrExpression)element);
        while (element.getParent() instanceof GrBinaryExpression && ConvertStringToMultilineIntention.isAppropriateBinary(binary = (GrBinaryExpression)element.getParent(), element)) {
            result.add(binary);
            element = binary;
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "collectExpressions"));
        }
        return arrayList;
    }

    private static boolean isAppropriateBinary(@NotNull GrBinaryExpression binary, @Nullable PsiElement prevChecked) {
        if (binary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binary", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "isAppropriateBinary"));
        }
        if (binary.getOperationTokenType() == GroovyTokenTypes.mPLUS) {
            GrExpression left = binary.getLeftOperand();
            GrExpression right = binary.getRightOperand();
            if ((left != prevChecked || ConvertStringToMultilineIntention.containsOnlyLiterals(right)) && (right != prevChecked || ConvertStringToMultilineIntention.containsOnlyLiterals(left))) {
                return true;
            }
        }
        return false;
    }

    private static boolean containsOnlyLiterals(@Nullable GrExpression expression) {
        if (expression instanceof GrLiteral) {
            String text = expression.getText();
            if ("'".equals(GrStringUtil.getStartQuote(text))) {
                return true;
            }
            if ("\"".equals(GrStringUtil.getStartQuote(text))) {
                return true;
            }
        } else if (expression instanceof GrBinaryExpression) {
            IElementType type = ((GrBinaryExpression)expression).getOperationTokenType();
            if (type != GroovyTokenTypes.mPLUS) {
                return false;
            }
            GrExpression left = ((GrBinaryExpression)expression).getLeftOperand();
            GrExpression right = ((GrBinaryExpression)expression).getRightOperand();
            return ConvertStringToMultilineIntention.containsOnlyLiterals(left) && ConvertStringToMultilineIntention.containsOnlyLiterals(right);
        }
        return false;
    }

    @NotNull
    private static List<GrLiteral> collectOperands(@Nullable PsiElement element, @NotNull List<GrLiteral> initial) {
        if (initial == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initial", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "collectOperands"));
        }
        if (element instanceof GrLiteral) {
            initial.add((GrLiteral)element);
        } else if (element instanceof GrBinaryExpression) {
            ConvertStringToMultilineIntention.collectOperands(((GrBinaryExpression)element).getLeftOperand(), initial);
            ConvertStringToMultilineIntention.collectOperands(((GrBinaryExpression)element).getRightOperand(), initial);
        }
        List<GrLiteral> list = initial;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "collectOperands"));
        }
        return list;
    }

    private void invokeImpl(@NotNull GrExpression element, @NotNull Project project, @NotNull Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "invokeImpl"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "invokeImpl"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "invokeImpl"));
        }
        List<GrLiteral> literals = ConvertStringToMultilineIntention.collectOperands(element, ContainerUtil.newArrayList());
        if (literals.isEmpty()) {
            return;
        }
        StringBuilder buffer = ConvertStringToMultilineIntention.prepareNewLiteralText(literals);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "lambda$invokeImpl$2"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "lambda$invokeImpl$2"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "lambda$invokeImpl$2"));
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "lambda$null$1"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "lambda$null$1"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "lambda$null$1"));
                }
                try {
                    int offset = editor.getCaretModel().getOffset();
                    TextRange range = element.getTextRange();
                    int shift = editor.getSelectionModel().hasSelection() ? 0 : (range.getStartOffset() == offset ? 0 : (range.getEndOffset() == offset + 1 ? -2 : 2));
                    GrExpression newLiteral = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(buffer.toString());
                    element.replaceWithExpression(newLiteral, true);
                    if (shift != 0) {
                        editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + shift);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
        }, this.getText(), null);
    }

    private static StringBuilder prepareNewLiteralText(List<GrLiteral> literals) {
        String quote = !ConvertStringToMultilineIntention.containsInjections(literals) && literals.get(0).getText().startsWith("'") ? "'''" : "\"\"\"";
        StringBuilder buffer = new StringBuilder();
        buffer.append(quote);
        for (GrLiteral literal : literals) {
            if (literal instanceof GrLiteralImpl) {
                ConvertStringToMultilineIntention.appendSimpleStringValue(literal, buffer, quote);
                continue;
            }
            GrStringImpl gstring = (GrStringImpl)literal;
            for (GroovyPsiElement child : gstring.getAllContentParts()) {
                if (child instanceof GrStringContent) {
                    ConvertStringToMultilineIntention.appendSimpleStringValue(child, buffer, "\"\"\"");
                    continue;
                }
                if (!(child instanceof GrStringInjection)) continue;
                buffer.append(child.getText());
            }
        }
        buffer.append(quote);
        return buffer;
    }

    private static boolean containsInjections(@NotNull List<GrLiteral> literals) {
        if (literals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literals", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "containsInjections"));
        }
        for (GrLiteral literal : literals) {
            if (!(literal instanceof GrString) || ((GrString)literal).getInjections().length <= 0) continue;
            return true;
        }
        return false;
    }

    private static void appendSimpleStringValue(PsiElement element, StringBuilder buffer, String quote) {
        String text = GrStringUtil.removeQuotes(element.getText());
        int position = buffer.length();
        if ("'''".equals(quote)) {
            GrStringUtil.escapeAndUnescapeSymbols(text, "", "'n", buffer);
            GrStringUtil.fixAllTripleQuotes(buffer, position);
        } else {
            GrStringUtil.escapeAndUnescapeSymbols(text, "", "\"n", buffer);
            GrStringUtil.fixAllTripleDoubleQuotes(buffer, position);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                return element instanceof GrLiteral && ("\"".equals(GrStringUtil.getStartQuote(element.getText())) || "'".equals(GrStringUtil.getStartQuote(element.getText()))) || element instanceof GrBinaryExpression && ConvertStringToMultilineIntention.isAppropriateBinary((GrBinaryExpression)element, null);
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertStringToMultilineIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

