/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.FromStringHintProcessor;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrDelegatesToUtil {
    public static final Key<String> DELEGATES_TO_KEY = Key.create((String)"groovy.closure.delegatesTo");
    public static final Key<Integer> DELEGATES_TO_STRATEGY_KEY = Key.create((String)"groovy.closure.delegatesTo.strategy");

    @Nullable
    public static DelegatesToInfo getDelegatesToInfo(@NotNull PsiElement place, @NotNull GrClosableBlock closableBlock) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "getDelegatesToInfo"));
        }
        if (closableBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closableBlock", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "getDelegatesToInfo"));
        }
        GrCall call = GrDelegatesToUtil.getContainingCall(closableBlock);
        if (call == null) {
            return null;
        }
        GroovyResolveResult result = GrDelegatesToUtil.resolveActualCall(call);
        PsiElement element = result.getElement();
        if (GdkMethodUtil.isWithOrIdentity(element)) {
            GrExpression qualifier = GrDelegatesToUtil.inferCallQualifier((GrMethodCall)call);
            if (qualifier == null) {
                return null;
            }
            return new DelegatesToInfo(qualifier.getType(), 1);
        }
        GrClosureSignature signature = GrDelegatesToUtil.inferSignature(element);
        if (signature == null) {
            return null;
        }
        GrClosureSignatureUtil.ArgInfo<PsiElement>[] map = GrDelegatesToUtil.mapArgs(place, call, signature);
        if (map == null) {
            return null;
        }
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)element;
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter parameter = GrDelegatesToUtil.findParameter(parameterList, closableBlock, map);
        if (parameter == null) {
            return null;
        }
        String delegateFqnData = (String)parameter.getUserData(DELEGATES_TO_KEY);
        Integer strategyData = (Integer)parameter.getUserData(DELEGATES_TO_STRATEGY_KEY);
        if (delegateFqnData != null) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType(delegateFqnData, place), strategyData == null ? 0 : strategyData);
        }
        PsiModifierList modifierList = parameter.getModifierList();
        if (modifierList == null) {
            return null;
        }
        PsiAnnotation delegatesTo = modifierList.findAnnotation("groovy.lang.DelegatesTo");
        if (delegatesTo == null) {
            return null;
        }
        PsiType delegateType = GrDelegatesToUtil.getFromValue(delegatesTo);
        if (delegateType == null) {
            delegateType = GrDelegatesToUtil.getFromTarget(parameterList, delegatesTo, signature, map);
        }
        if (delegateType == null) {
            delegateType = GrDelegatesToUtil.getFromType(result, delegatesTo);
        }
        int strategyValue = GrDelegatesToUtil.getStrategyValue(delegatesTo.findAttributeValue("strategy"));
        return new DelegatesToInfo(delegateType, strategyValue);
    }

    private static GrClosureSignatureUtil.ArgInfo<PsiElement>[] mapArgs(PsiElement place, GrCall call, GrClosureSignature signature) {
        GrClosureSignature rawSignature = GrClosureSignatureUtil.rawSignature(signature);
        return GrClosureSignatureUtil.mapParametersToArguments(rawSignature, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments(), place, false, false);
    }

    @Nullable
    private static GrClosureSignature inferSignature(@Nullable PsiElement element) {
        GrSignature signature;
        PsiType type;
        if (element instanceof PsiMethod) {
            return GrClosureSignatureUtil.createSignature((PsiMethod)element, PsiSubstitutor.EMPTY);
        }
        if (element instanceof GrVariable && (type = ((GrVariable)element).getTypeGroovy()) instanceof GrClosureType && (signature = ((GrClosureType)type).getSignature()) instanceof GrClosureSignature) {
            return (GrClosureSignature)signature;
        }
        return null;
    }

    @Nullable
    private static PsiParameter findParameter(@NotNull PsiParameterList parameterList, @NotNull GrClosableBlock closableBlock, @NotNull GrClosureSignatureUtil.ArgInfo<PsiElement>[] map) {
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "findParameter"));
        }
        if (closableBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closableBlock", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "findParameter"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "findParameter"));
        }
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < map.length; ++i) {
            if (!map[i].args.contains(closableBlock)) continue;
            return parameters[i];
        }
        return null;
    }

    private static PsiType getFromValue(@NotNull PsiAnnotation delegatesTo) {
        if (delegatesTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatesTo", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "getFromValue"));
        }
        PsiAnnotationMemberValue value = delegatesTo.findDeclaredAttributeValue("value");
        if (value instanceof GrReferenceExpression) {
            return GrDelegatesToUtil.extractTypeFromClassType(((GrReferenceExpression)value).getType());
        }
        if (value instanceof PsiClassObjectAccessExpression) {
            return GrDelegatesToUtil.extractTypeFromClassType(((PsiClassObjectAccessExpression)value).getType());
        }
        if (value == null || value instanceof PsiLiteralExpression && ((PsiLiteralExpression)value).getType() == PsiType.NULL || value instanceof GrLiteral && ((GrLiteral)value).getType() == PsiType.NULL) {
            return null;
        }
        if (value instanceof PsiExpression) {
            return ((PsiExpression)value).getType();
        }
        return null;
    }

    private static PsiType getFromTarget(PsiParameterList parameterList, PsiAnnotation delegatesTo, GrClosureSignature signature, GrClosureSignatureUtil.ArgInfo<PsiElement>[] map) {
        String target = GrAnnotationUtil.inferStringAttribute(delegatesTo, "target");
        if (target == null) {
            return null;
        }
        int parameter = GrDelegatesToUtil.findTargetParameter(parameterList, target);
        if (parameter < 0) {
            return null;
        }
        PsiType type = map[parameter].type;
        Integer index = GrAnnotationUtil.inferIntegerAttribute(delegatesTo, "genericTypeIndex");
        if (index != null) {
            return GrDelegatesToUtil.inferGenericArgType(signature, type, index, parameter);
        }
        return type;
    }

    @Nullable
    private static PsiType inferGenericArgType(@NotNull GrClosureSignature signature, @NotNull PsiType targetType, int genericIndex, int param) {
        PsiClassType.ClassResolveResult result;
        PsiClass psiClass;
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "inferGenericArgType"));
        }
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "inferGenericArgType"));
        }
        if (targetType instanceof PsiClassType && (psiClass = (result = ((PsiClassType)targetType).resolveGenerics()).getElement()) != null) {
            PsiTypeParameter[] typeParameters;
            PsiSubstitutor substitutor = result.getSubstitutor();
            PsiType baseType = signature.getParameters()[param].getType();
            PsiClass baseClass = com.intellij.psi.util.PsiUtil.resolveClassInClassTypeOnly((PsiType)baseType);
            if (baseClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)baseClass, (boolean)true) && genericIndex < (typeParameters = baseClass.getTypeParameters()).length) {
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)psiClass, (PsiSubstitutor)substitutor);
                return superClassSubstitutor.substitute(typeParameters[genericIndex]);
            }
        }
        return null;
    }

    private static PsiType getFromType(GroovyResolveResult result, PsiAnnotation delegatesTo) {
        PsiElement element = result.getElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        String typeValue = GrAnnotationUtil.inferStringAttribute(delegatesTo, "type");
        if (StringUtil.isEmptyOrSpaces((String)typeValue)) {
            return null;
        }
        PsiElement context = FromStringHintProcessor.createContext((PsiMethod)element);
        PsiType type = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(typeValue, context);
        return result.getSubstitutor().substitute(type);
    }

    private static int findTargetParameter(@NotNull PsiParameterList list, @NotNull String target) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "findTargetParameter"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "findTargetParameter"));
        }
        PsiParameter[] parameters = list.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            String value;
            PsiAnnotation targetAnnotation;
            PsiModifierList modifierList = parameters[i].getModifierList();
            if (modifierList == null || (targetAnnotation = modifierList.findAnnotation("groovy.lang.DelegatesTo.Target")) == null || (value = GrAnnotationUtil.inferStringAttribute(targetAnnotation, "value")) == null || !value.equals(target)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private static GrExpression inferCallQualifier(@NotNull GrMethodCall call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "inferCallQualifier"));
        }
        GrExpression expression = call.getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression)) {
            return null;
        }
        return (GrExpression)((GrReferenceExpression)expression).getQualifier();
    }

    @Nullable
    private static PsiType extractTypeFromClassType(@Nullable PsiType type) {
        PsiType[] parameters;
        PsiClass resolved;
        if (type instanceof PsiClassType && (resolved = ((PsiClassType)type).resolve()) != null && "java.lang.Class".equals(resolved.getQualifiedName()) && (parameters = ((PsiClassType)type).getParameters()).length == 1) {
            return parameters[0];
        }
        return null;
    }

    private static int getStrategyValue(@Nullable PsiAnnotationMemberValue strategy) {
        if (strategy == null) {
            return -1;
        }
        String text = strategy.getText();
        if ("0".equals(text)) {
            return 0;
        }
        if ("1".equals(text)) {
            return 1;
        }
        if ("2".equals(text)) {
            return 2;
        }
        if ("3".equals(text)) {
            return 3;
        }
        if ("4".equals(text)) {
            return 4;
        }
        if (text.endsWith("OWNER_FIRST")) {
            return 0;
        }
        if (text.endsWith("DELEGATE_FIRST")) {
            return 1;
        }
        if (text.endsWith("OWNER_ONLY")) {
            return 2;
        }
        if (text.endsWith("DELEGATE_ONLY")) {
            return 3;
        }
        if (text.endsWith("TO_SELF")) {
            return 4;
        }
        return -1;
    }

    @Nullable
    static GrCall getContainingCall(@NotNull GrClosableBlock closableBlock) {
        PsiElement parent1;
        if (closableBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closableBlock", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "getContainingCall"));
        }
        PsiElement parent = closableBlock.getParent();
        if (parent instanceof GrCall && ArrayUtil.contains((Object)closableBlock, (Object[])((GrCall)parent).getClosureArguments())) {
            return (GrCall)parent;
        }
        if (parent instanceof GrArgumentList && (parent1 = parent.getParent()) instanceof GrCall) {
            return (GrCall)parent1;
        }
        return null;
    }

    @NotNull
    static GroovyResolveResult resolveActualCall(@NotNull GrCall call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "resolveActualCall"));
        }
        if (call instanceof GrMethodCall) {
            GroovyResolveResult groovyResolveResult = (GroovyResolveResult)CachedValuesManager.getCachedValue((PsiElement)call, () -> {
                if (call == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "lambda$resolveActualCall$0"));
                }
                return CachedValueProvider.Result.create((Object)GrDelegatesToUtil.doResolveActualCall((GrMethodCall)call), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            });
            if (groovyResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "resolveActualCall"));
            }
            return groovyResolveResult;
        }
        GroovyResolveResult groovyResolveResult = call.advancedResolve();
        if (groovyResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "resolveActualCall"));
        }
        return groovyResolveResult;
    }

    @NotNull
    private static GroovyResolveResult doResolveActualCall(@NotNull GrMethodCall call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "doResolveActualCall"));
        }
        GroovyResolveResult result = call.advancedResolve();
        if (result.getElement() instanceof PsiMethod && !result.isInvokedOnProperty()) {
            GroovyResolveResult groovyResolveResult = result;
            if (groovyResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "doResolveActualCall"));
            }
            return groovyResolveResult;
        }
        GrExpression expression = call.getInvokedExpression();
        PsiType type = expression.getType();
        if (type == null) {
            GroovyResolveResult groovyResolveResult = result;
            if (groovyResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "doResolveActualCall"));
            }
            return groovyResolveResult;
        }
        GroovyResolveResult[] calls = ResolveUtil.getMethodCandidates(type, "call", (PsiElement)expression, PsiUtil.getArgumentTypes(expression, false));
        GroovyResolveResult groovyResolveResult = PsiImplUtil.extractUniqueResult(calls);
        if (groovyResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrDelegatesToUtil", "doResolveActualCall"));
        }
        return groovyResolveResult;
    }

    public static class DelegatesToInfo {
        final PsiType myClassToDelegate;
        final int myStrategy;

        private DelegatesToInfo(@Nullable PsiType classToDelegate, int strategy) {
            this.myClassToDelegate = classToDelegate;
            this.myStrategy = strategy;
        }

        public PsiType getTypeToDelegate() {
            return this.myClassToDelegate;
        }

        public int getStrategy() {
            return this.myStrategy;
        }
    }
}

