/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.toplevel.imports;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrImportStatementStub;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrDelegatingScopeProcessorWithHints;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;

public class GrImportStatementImpl
extends GrStubElementBase<GrImportStatementStub>
implements GrImportStatement,
StubBasedPsiElement<GrImportStatementStub> {
    public GrImportStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "<init>"));
        }
        super(node);
    }

    public GrImportStatementImpl(GrImportStatementStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public PsiElement getParent() {
        return this.getParentByStub();
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitImportStatement(this);
    }

    public String toString() {
        return "Import statement";
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processDeclarations"));
        }
        if (this.isAncestor(place)) {
            return true;
        }
        if (this.isStatic() && lastParent instanceof GrImportStatement) {
            return true;
        }
        return !(this.isOnDemand() ? !this.processDeclarationsForMultipleElements(processor, lastParent, place, state) : !this.processDeclarationsForSingleElement(processor, lastParent, place, state));
    }

    private boolean isAncestor(@Nullable PsiElement place) {
        while (place instanceof GrCodeReferenceElement) {
            PsiElement parent = place.getParent();
            if (parent == this) {
                return true;
            }
            place = parent;
        }
        return false;
    }

    private boolean processDeclarationsForSingleElement(@NotNull PsiScopeProcessor processor, @Nullable PsiElement lastParent, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processDeclarationsForSingleElement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processDeclarationsForSingleElement"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processDeclarationsForSingleElement"));
        }
        String name = this.getImportedName();
        if (name == null) {
            return true;
        }
        if (this.isStatic()) {
            return this.processSingleStaticImport(processor, state, name, lastParent, place);
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        if (nameHint == null || name.equals(nameHint.getName(state))) {
            return this.processSingleClassImport(processor, state);
        }
        return true;
    }

    @Nullable
    private PsiClass resolveQualifier() {
        return (PsiClass)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            GrCodeReferenceElement reference = this.getImportReference();
            GrCodeReferenceElement qualifier = reference == null ? null : (GrCodeReferenceElement)reference.getQualifier();
            PsiElement target = qualifier == null ? null : qualifier.resolve();
            PsiClass clazz = target instanceof PsiClass ? (PsiClass)target : null;
            return CachedValueProvider.Result.create((Object)clazz, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, this});
        });
    }

    private boolean processSingleStaticImport(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull String importedName, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processSingleStaticImport"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processSingleStaticImport"));
        }
        if (importedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedName", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processSingleStaticImport"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processSingleStaticImport"));
        }
        GrCodeReferenceElement ref = this.getImportReference();
        if (ref == null) {
            return true;
        }
        PsiClass clazz = this.resolveQualifier();
        if (clazz == null) {
            return true;
        }
        state = state.put(ClassHint.RESOLVE_CONTEXT, (Object)this);
        String refName = ref.getReferenceName();
        for (PsiScopeProcessor each : GroovyResolverProcessor.allProcessors(processor)) {
            if (GrImportStatementImpl.doProcessSingleStaticImport(each, state, importedName, lastParent, place, clazz, refName)) continue;
            return false;
        }
        return true;
    }

    private static boolean doProcessSingleStaticImport(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull String importedName, @Nullable PsiElement lastParent, @NotNull PsiElement place, PsiClass clazz, String refName) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "doProcessSingleStaticImport"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "doProcessSingleStaticImport"));
        }
        if (importedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedName", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "doProcessSingleStaticImport"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "doProcessSingleStaticImport"));
        }
        String hintName = ResolveUtil.getNameHint(processor);
        if ((hintName == null || importedName.equals(hintName)) && !clazz.processDeclarations((PsiScopeProcessor)new GrDelegatingScopeProcessorWithHints(processor, refName, null), state, lastParent, place)) {
            return false;
        }
        if (ResolveUtil.shouldProcessMethods((ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            if ((hintName == null || importedName.equals(GroovyPropertyUtils.getPropertyNameByGetterName(hintName, true))) && !clazz.processDeclarations((PsiScopeProcessor)new StaticGetterProcessor(refName, processor), state, lastParent, place)) {
                return false;
            }
            if ((hintName == null || importedName.equals(GroovyPropertyUtils.getPropertyNameBySetterName(hintName))) && !clazz.processDeclarations((PsiScopeProcessor)new StaticSetterProcessor(refName, processor), state, lastParent, place)) {
                return false;
            }
        }
        return true;
    }

    private boolean processSingleClassImport(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processSingleClassImport"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processSingleClassImport"));
        }
        if (!ResolveUtil.shouldProcessClasses((ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            return true;
        }
        GrCodeReferenceElement ref = this.getImportReference();
        if (ref == null) {
            return true;
        }
        PsiElement resolved = ref.resolve();
        if (!(resolved instanceof PsiClass)) {
            return true;
        }
        if (!this.isAliasedImport() && this.isFromSamePackage((PsiClass)resolved)) {
            return true;
        }
        return processor.execute(resolved, state.put(ClassHint.RESOLVE_CONTEXT, (Object)this));
    }

    private boolean isFromSamePackage(@NotNull PsiClass resolved) {
        if (resolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolved", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "isFromSamePackage"));
        }
        String qualifiedName = resolved.getQualifiedName();
        String packageName = ((GroovyFile)this.getContainingFile()).getPackageName();
        String assumed = packageName + '.' + resolved.getName();
        return !packageName.isEmpty() && assumed.equals(qualifiedName);
    }

    private boolean processDeclarationsForMultipleElements(@NotNull PsiScopeProcessor processor, @Nullable PsiElement lastParent, @NotNull PsiElement place, @NotNull ResolveState state) {
        PsiPackage aPackage;
        String qName;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processDeclarationsForMultipleElements"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processDeclarationsForMultipleElements"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "processDeclarationsForMultipleElements"));
        }
        GrCodeReferenceElement ref = this.getImportReference();
        if (ref == null) {
            return true;
        }
        if (this.isStatic()) {
            PsiElement resolved = ref.resolve();
            if (resolved instanceof PsiClass) {
                state = state.put(ClassHint.RESOLVE_CONTEXT, (Object)this);
                PsiClass clazz = (PsiClass)resolved;
                for (PsiScopeProcessor each : GroovyResolverProcessor.allProcessors(processor)) {
                    if (clazz.processDeclarations((PsiScopeProcessor)new DelegatingScopeProcessor(each){

                        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                            if (element == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl$1", "execute"));
                            }
                            if (state == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl$1", "execute"));
                            }
                            if (element instanceof PsiMember && ((PsiMember)element).hasModifierProperty("static")) {
                                return super.execute(element, state);
                            }
                            return true;
                        }
                    }, state, lastParent, place)) continue;
                    return false;
                }
            }
        } else if (ResolveUtil.shouldProcessClasses((ElementClassHint)processor.getHint(ElementClassHint.KEY)) && (qName = PsiUtil.getQualifiedReferenceText(ref)) != null && (aPackage = JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(qName)) != null && !((GroovyFile)this.getContainingFile()).getPackageName().equals(aPackage.getQualifiedName()) && !aPackage.processDeclarations(processor, state = state.put(ClassHint.RESOLVE_CONTEXT, (Object)this), lastParent, place)) {
            return false;
        }
        return true;
    }

    @Override
    public GrCodeReferenceElement getImportReference() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            String referenceText = stub.getReferenceText();
            if (referenceText == null) {
                return null;
            }
            return GroovyPsiElementFactory.getInstance(this.getProject()).createCodeReferenceElementFromText(referenceText);
        }
        return (GrCodeReferenceElement)this.findChildByType(GroovyElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    @Nullable
    public String getImportedName() {
        if (this.isOnDemand()) {
            return null;
        }
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            String name = stub.getAliasName();
            if (name != null) {
                return name;
            }
            String referenceText = stub.getReferenceText();
            if (referenceText == null) {
                return null;
            }
            return StringUtil.getShortName((String)referenceText);
        }
        PsiElement aliasNameElement = this.getAliasNameElement();
        if (aliasNameElement != null) {
            return aliasNameElement.getText();
        }
        GrCodeReferenceElement ref = this.getImportReference();
        return ref == null ? null : ref.getReferenceName();
    }

    @Override
    public boolean isStatic() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.isStatic();
        }
        return this.findChildByType(GroovyTokenTypes.kSTATIC) != null;
    }

    @Override
    public boolean isAliasedImport() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.getAliasName() != null;
        }
        return this.getAliasNameElement() != null;
    }

    @Override
    public boolean isOnDemand() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.isOnDemand();
        }
        return this.findChildByType(GroovyTokenTypes.mSTAR) != null;
    }

    @Override
    @NotNull
    public GrModifierList getAnnotationList() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            GrModifierList grModifierList = (GrModifierList)ObjectUtils.assertNotNull((Object)this.getStubOrPsiChild(GroovyElementTypes.MODIFIERS));
            if (grModifierList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "getAnnotationList"));
            }
            return grModifierList;
        }
        GrModifierList grModifierList = (GrModifierList)this.findNotNullChildByClass(GrModifierList.class);
        if (grModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl", "getAnnotationList"));
        }
        return grModifierList;
    }

    @Override
    @Nullable
    public PsiClass resolveTargetClass() {
        GrCodeReferenceElement ref = this.getImportReference();
        if (ref == null) {
            return null;
        }
        Object resolved = !this.isStatic() || this.isOnDemand() ? ref.resolve() : this.resolveQualifier();
        return resolved instanceof PsiClass ? (PsiClass)resolved : null;
    }

    @Override
    @Nullable
    public PsiElement getAliasNameElement() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            String alias = stub.getAliasName();
            if (alias == null) {
                return null;
            }
            GrImportStatement imp = GroovyPsiElementFactory.getInstance(this.getProject()).createImportStatementFromText("import A as " + alias);
            return imp.getAliasNameElement();
        }
        return this.findChildByType(GroovyTokenTypes.mIDENT);
    }

    private static abstract class StaticAccessorProcessor
    extends GrDelegatingScopeProcessorWithHints {
        private final String myPropertyName;

        public StaticAccessorProcessor(@NotNull String propertyName, @NotNull PsiScopeProcessor processor) {
            if (propertyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl$StaticAccessorProcessor", "<init>"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl$StaticAccessorProcessor", "<init>"));
            }
            super(processor, null, ClassHint.RESOLVE_KINDS_METHOD);
            this.myPropertyName = propertyName;
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            PsiMethod method;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl$StaticAccessorProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl$StaticAccessorProcessor", "execute"));
            }
            if (element instanceof PsiMethod && (method = (PsiMethod)element).hasModifierProperty("static") && this.isAccessor(method)) {
                return super.execute((PsiElement)method, state);
            }
            return true;
        }

        protected abstract boolean isAccessor(@NotNull PsiMethod var1);

        public String getPropertyName() {
            return this.myPropertyName;
        }

        @Override
        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl$StaticAccessorProcessor", "getHint"));
            }
            if (hintKey == NameHint.KEY) {
                return null;
            }
            return super.getHint(hintKey);
        }
    }

    private static class StaticGetterProcessor
    extends StaticAccessorProcessor {
        public StaticGetterProcessor(String refName, PsiScopeProcessor processor) {
            super(refName, processor);
        }

        @Override
        protected boolean isAccessor(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl$StaticGetterProcessor", "isAccessor"));
            }
            return GroovyPropertyUtils.isSimplePropertyGetter(method, this.getPropertyName());
        }
    }

    private static class StaticSetterProcessor
    extends StaticAccessorProcessor {
        public StaticSetterProcessor(String refName, PsiScopeProcessor processor) {
            super(refName, processor);
        }

        @Override
        protected boolean isAccessor(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl$StaticSetterProcessor", "isAccessor"));
            }
            return GroovyPropertyUtils.isSimplePropertySetter(method, this.getPropertyName());
        }
    }
}

