/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast;

import com.google.common.collect.ImmutableMap;
import com.intellij.psi.PsiAnnotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class LoggingContributor
implements AstTransformationSupport {
    private static final ImmutableMap<String, String> ourLoggers = ImmutableMap.builder().put((Object)"groovy.util.logging.Log", (Object)"java.util.logging.Logger").put((Object)"groovy.util.logging.Commons", (Object)"org.apache.commons.logging.Log").put((Object)"groovy.util.logging.Log4j", (Object)"org.apache.log4j.Logger").put((Object)"groovy.util.logging.Log4j2", (Object)"org.apache.logging.log4j.core.Logger").put((Object)"groovy.util.logging.Slf4j", (Object)"org.slf4j.Logger").build();

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/resolve/ast/LoggingContributor", "applyTransformation"));
        }
        GrModifierList modifierList = context.getCodeClass().getModifierList();
        if (modifierList == null) {
            return;
        }
        for (GrAnnotation annotation : modifierList.getAnnotations()) {
            String qname = annotation.getQualifiedName();
            String logger = (String)ourLoggers.get((Object)qname);
            if (logger == null) continue;
            String fieldName = PsiUtil.getAnnoAttributeValue((PsiAnnotation)annotation, "value", "log");
            GrLightField field = new GrLightField(fieldName, logger, context.getCodeClass());
            field.setNavigationElement(annotation);
            ((GrLightModifierList)field.getModifierList()).setModifiers("private", "final", "static");
            field.setOriginInfo("created by @" + annotation.getShortName());
            context.addField(field);
        }
    }
}

