/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.ui.RowEditableTableModel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class TableWithButtons {
    private final RowEditableTableModel myModel;
    private JPanel myPanel;
    private JButton myAddButton;
    private JButton myRemoveButton;
    private JButton myMoveUpButton;
    private JButton myMoveDownButton;
    private JBTable myTable;

    public TableWithButtons(RowEditableTableModel model) {
        this.myModel = model;
        this.$$$setupUI$$$();
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedColumn = TableWithButtons.this.myTable.getSelectedColumn();
                if (selectedColumn < 0) {
                    selectedColumn = 0;
                }
                TableWithButtons.this.myModel.addRow();
                TableWithButtons.this.myTable.setRowSelectionInterval(TableWithButtons.this.myModel.getRowCount() - 1, TableWithButtons.this.myModel.getRowCount() - 1);
                TableWithButtons.this.myTable.setColumnSelectionInterval(selectedColumn, selectedColumn);
                TableWithButtons.this.innerUpdate();
                TableWithButtons.this.myTable.requestFocus();
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = TableWithButtons.this.myTable.getSelectedRow();
                int selectedColumn = TableWithButtons.this.myTable.getSelectedColumn();
                TableWithButtons.this.myModel.removeRow(TableWithButtons.this.myTable.getSelectedRow());
                if (selectedRow == TableWithButtons.this.myModel.getRowCount()) {
                    --selectedRow;
                }
                if (TableWithButtons.this.myModel.getRowCount() == 0) {
                    return;
                }
                TableWithButtons.this.myTable.setRowSelectionInterval(selectedRow, selectedRow);
                TableWithButtons.this.myTable.setColumnSelectionInterval(selectedColumn, selectedColumn);
                TableWithButtons.this.innerUpdate();
                TableWithButtons.this.myTable.requestFocus();
            }
        });
        this.myMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = TableWithButtons.this.myTable.getSelectedRow();
                int selectedColumn = TableWithButtons.this.myTable.getSelectedColumn();
                TableWithButtons.this.myModel.exchangeRows(selectedRow, selectedRow - 1);
                TableWithButtons.this.myTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
                TableWithButtons.this.myTable.setColumnSelectionInterval(selectedColumn, selectedColumn);
                TableWithButtons.this.innerUpdate();
                TableWithButtons.this.myTable.requestFocus();
            }
        });
        this.myMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = TableWithButtons.this.myTable.getSelectedRow();
                int selectedColumn = TableWithButtons.this.myTable.getSelectedColumn();
                TableWithButtons.this.myModel.exchangeRows(selectedRow, selectedRow + 1);
                TableWithButtons.this.myTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
                TableWithButtons.this.myTable.setColumnSelectionInterval(selectedColumn, selectedColumn);
                TableWithButtons.this.innerUpdate();
                TableWithButtons.this.myTable.requestFocus();
            }
        });
        this.myModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TableWithButtons.this.innerUpdate();
            }
        });
    }

    private void createUIComponents() {
        this.myTable = new JBTable((TableModel)this.myModel);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(450, this.myTable.getRowHeight() * 8));
    }

    private void innerUpdate() {
        int selectedRow = this.myTable.getSelectedRow();
        int rowCount = this.myModel.getRowCount();
        this.myMoveUpButton.setEnabled(selectedRow > 0);
        this.myMoveDownButton.setEnabled(selectedRow + 1 < rowCount && rowCount > 1);
        this.myRemoveButton.setEnabled(rowCount > 0);
        this.update();
    }

    protected abstract void update();

    public JBTable getTable() {
        return this.myTable;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 0, 3, null, null, null));
        this.myAddButton = jButton4 = new JButton();
        jButton4.setText("Add");
        jButton4.setMnemonic('A');
        jButton4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton3 = new JButton();
        jButton3.setText("Remove");
        jButton3.setMnemonic('E');
        jButton3.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jButton3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMoveUpButton = jButton2 = new JButton();
        jButton2.setText("Move Up");
        jButton2.setMnemonic('U');
        jButton2.setDisplayedMnemonicIndex(5);
        jPanel2.add((Component)jButton2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMoveDownButton = jButton = new JButton();
        jButton.setText("Move Down");
        jButton.setMnemonic('D');
        jButton.setDisplayedMnemonicIndex(5);
        jPanel2.add((Component)jButton, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = this.myTable;
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

